/*
Zh-Pinyin-Translation (v.1.1) by Norbert Landsteiner, masswerk.at, related to http://www.masswerk.at/mespeak
data based on zh_listx http://espeak.sourceforge.net/data/zh_listx.zip (04.Feb.2013):
//From Unihan database ftp://ftp.unicode.org/Public/UNIDATA/Unihan.zip kMandarin entries (except the ones that have kHanyuPinlu, which are in zh_list)
//with compounds from CC-CEDICT http://www.mdbg.net/chindict/chindict.php?page=cedict and some corrections
//21567 single characters plus 36098 compound exceptions (includes 332 added 'yi' and 10720 added 'bu' exceptions, and 9713 extra 2-syllable words for 3rd-tone sandhi blocking)
*/
var pinyinTranslator = new function() {

/*
	Usage:
	pinyinTranslator.translate(
		'马哈拉施特拉邦',  // input string
		function(ch) {    // replacement callback for ideograms not found (or null/undefined)
		   var t;         // use this to add further logic (e.g. to handle any syntactical marks/characters)
		   // ch -> t
	       return t;
	    },
		'???',            // default replacement-string for ideograms not found (or null/undefined for original char)
		                  // used only, if no callback-function was supplied
	);

*/

function translate(str, replaceCallback, defaultReplacement) {
	if (defaultReplacement || typeof defaultReplacement != 'string') defaultReplacement=false;
	if (typeof replaceCallback != 'function') replaceCallback=false;
	var cmps=data.compounds, sgls=data.singles, out='';
	charloop: for (var i=0, l=str.length; i<l; i++) {
		var ch=str.charAt(i);
		if (ch.match(/\s/) || ch.charCodeAt(0<=0x2fff)) {
			out+=ch;
			continue charloop;
		}
		else if (cmps[ch]) {
			// loop over compounds starting with this char
			var c=cmps[ch], s=str.substring(i), sl=s.length;
			for (var k=c.length-1; k>=0; k--) {
				var p=c[k][0];
				if (sl>=p.length && s.indexOf(p)==0) {
					out+=c[k][1];
					i+=p.length-1;
					continue charloop;
				}
			}
		}
		if (sgls[ch]) {
			out+=sgls[ch];
		}
		else if (syntacticalEntities[ch]) {
			out+=syntacticalEntities[ch];
		}
		else if (replaceCallback) {
			out+=replaceCallback(ch);
		}
		else if (defaultReplacement) {
			out+=defaultReplacement;
		}
		else {
			// last option, just return the original ideogram
			out+=ch;
		}
	}
	return out.replace(/^\s+/,'').replace(/\s+$/,'');
}

var syntacticalEntities = {
"。":". ",
"〪":". ",
"〭":" .",
"，":", ",
"：":": ",
"（":" (",
"）":") ",
"「":" \"",
"」":"\" ",
"『":" \"",
"』":"\" ",
"〈":" \"",
"〉":"\" ",
"》":"\" ",
"《":" \"",
"、":", ",
"〔":" [",
"〕":"] ",
"〘":" [",
"〙":"] ",
"〚":" [",
"〛":"] ",
"〜":"~",
"〝":" \"",
"〞":"\" ",
"〟":"\" ",
"　":" "
};

var data={
"singles":{
"〇":"ling2",
"㐀":"qiu1",
"㐁":"tian3",
"㐄":"kua4",
"㐅":"wu3",
"㐆":"yin3",
"㐌":"si4",
"㐖":"ye4",
"㐜":"chou2",
"㐡":"nuo4",
"㐤":"qiu2",
"㐨":"xu4",
"㐩":"xing2",
"㐫":"xiong1",
"㐬":"liu2",
"㐭":"lin3",
"㐮":"xiang1",
"㐯":"yong1",
"㐰":"xin4",
"㐱":"zhen3",
"㐲":"dai4",
"㐳":"wu4",
"㐴":"pan1",
"㐷":"ma3",
"㐸":"qian4",
"㐹":"yi4",
"㐺":"zhong4",
"㐻":"ng3",
"㐼":"cheng4",
"㑁":"zhuo1",
"㑂":"fang3",
"㑃":"ao3",
"㑄":"wu3",
"㑅":"zuo4",
"㑇":"zhou4",
"㑈":"dong4",
"㑉":"su4",
"㑊":"yi4",
"㑋":"jiong4",
"㑌":"wang1",
"㑍":"lei3",
"㑎":"nao3",
"㑏":"zhu4",
"㑔":"xu3",
"㑘":"jie4",
"㑙":"die2",
"㑚":"nuo2",
"㑛":"su4",
"㑜":"yi4",
"㑝":"long4",
"㑞":"ying4",
"㑟":"beng3",
"㑣":"lan2",
"㑤":"miao2",
"㑥":"yi4",
"㑦":"li4",
"㑧":"ji4",
"㑨":"yu3",
"㑩":"luo2",
"㑪":"chai2",
"㑮":"hun2",
"㑯":"xu3",
"㑰":"hui4",
"㑱":"rao3",
"㑳":"zhou4",
"㑵":"han4",
"㑶":"xi4",
"㑷":"tai4",
"㑸":"ai3",
"㑹":"hui4",
"㑺":"jun4",
"㑻":"ma4",
"㑼":"lve4",
"㑽":"tang2",
"㑾":"xiao2",
"㑿":"tiao2",
"㒀":"zha3",
"㒁":"yu3",
"㒂":"ku4",
"㒃":"er4",
"㒄":"nang4",
"㒅":"qi3",
"㒆":"chi4",
"㒇":"mu4",
"㒈":"han4",
"㒉":"tang3",
"㒊":"se4",
"㒌":"qiong2",
"㒍":"lei2",
"㒎":"sa3",
"㒑":"hui4",
"㒒":"pu2",
"㒓":"ta4",
"㒔":"shu3",
"㒖":"ou3",
"㒗":"tai2",
"㒙":"mian2",
"㒚":"wen3",
"㒛":"diao4",
"㒜":"yu2",
"㒝":"mie4",
"㒞":"jun4",
"㒟":"niao3",
"㒠":"xie4",
"㒡":"you2",
"㒤":"she4",
"㒦":"lei3",
"㒧":"li4",
"㒩":"luo3",
"㒫":"ji4",
"㒰":"quan2",
"㒲":"cai2",
"㒳":"liang3",
"㒴":"gu3",
"㒵":"mao4",
"㒷":"gua3",
"㒸":"sui4",
"㒻":"mao4",
"㒼":"man2",
"㒾":"shi4",
"㒿":"li2",
"㓁":"wang3",
"㓂":"kou4",
"㓃":"chui2",
"㓄":"zhen4",
"㓈":"bing4",
"㓉":"huan4",
"㓊":"dong4",
"㓋":"gong4",
"㓎":"lian2",
"㓏":"jiong3",
"㓐":"lu4",
"㓑":"xing4",
"㓓":"nan2",
"㓔":"xie4",
"㓖":"bi4",
"㓗":"jie2",
"㓘":"su4",
"㓜":"you4",
"㓝":"xing2",
"㓞":"qi4",
"㓠":"dian4",
"㓡":"fu3",
"㓢":"luo4",
"㓣":"qia4",
"㓤":"jie2",
"㓧":"yan3",
"㓨":"ci2",
"㓪":"lang3",
"㓭":"he2",
"㓯":"li2",
"㓰":"hua4",
"㓱":"tou2",
"㓲":"pian4",
"㓴":"jun4",
"㓵":"e4",
"㓶":"qie4",
"㓷":"yi4",
"㓸":"jue2",
"㓹":"rui4",
"㓺":"jian4",
"㓼":"chi4",
"㓽":"chong2",
"㓾":"chi2",
"㔀":"lve4",
"㔂":"lin2",
"㔃":"jue2",
"㔄":"su4",
"㔅":"xiao4",
"㔆":"chan2",
"㔉":"zhu2",
"㔊":"dan3",
"㔋":"jian4",
"㔌":"zhou4",
"㔍":"duo3",
"㔎":"xie4",
"㔏":"li4",
"㔑":"chi4",
"㔒":"xi2",
"㔓":"jian3",
"㔕":"ji2",
"㔗":"fei4",
"㔘":"chu4",
"㔙":"bang3",
"㔚":"kou3",
"㔜":"ba2",
"㔝":"liang3",
"㔞":"kuai4",
"㔠":"he2",
"㔢":"jue2",
"㔣":"lei2",
"㔤":"shen3",
"㔥":"pi2",
"㔦":"yang3",
"㔧":"lv4",
"㔨":"bei4",
"㔩":"e4",
"㔪":"lu3",
"㔭":"che4",
"㔮":"nuo2",
"㔯":"suan3",
"㔰":"heng2",
"㔱":"yu3",
"㔳":"gui3",
"㔴":"yi4",
"㔵":"xian4",
"㔶":"gong4",
"㔷":"lou4",
"㔹":"le4",
"㔺":"shi4",
"㔼":"sun3",
"㔽":"yao4",
"㔾":"jie2",
"㔿":"zou4",
"㕁":"que4",
"㕂":"yin2",
"㕄":"zhi4",
"㕅":"jia3",
"㕆":"hu4",
"㕇":"la2",
"㕈":"hou4",
"㕉":"ke4",
"㕋":"jing4",
"㕌":"ai4",
"㕎":"e4",
"㕏":"chu2",
"㕐":"xie3",
"㕑":"chu2",
"㕒":"wei2",
"㕕":"huan4",
"㕖":"su4",
"㕗":"you4",
"㕙":"jun4",
"㕚":"zhao3",
"㕛":"xu4",
"㕜":"shi3",
"㕟":"kui4",
"㕡":"he2",
"㕢":"gai4",
"㕣":"yan3",
"㕤":"qiu2",
"㕥":"yi3",
"㕦":"hua4",
"㕨":"fan4",
"㕩":"zhang4",
"㕪":"dan3",
"㕫":"fang3",
"㕬":"song4",
"㕭":"ao4",
"㕮":"fu3",
"㕯":"nei4",
"㕰":"he4",
"㕱":"you2",
"㕲":"hua2",
"㕴":"chen2",
"㕵":"guo2",
"㕶":"ng4",
"㕷":"hua4",
"㕸":"li4",
"㕹":"fa2",
"㕺":"hao2",
"㕻":"pou3",
"㕽":"si4",
"㖀":"le4",
"㖁":"lin4",
"㖂":"yi4",
"㖃":"hou3",
"㖅":"xu4",
"㖆":"qu2",
"㖇":"er2",
"㖏":"nei4",
"㖐":"wei3",
"㖑":"xie4",
"㖒":"ti2",
"㖓":"hong2",
"㖔":"tun3",
"㖕":"bo4",
"㖖":"nie4",
"㖗":"yin2",
"㖞":"wai1",
"㖟":"shou4",
"㖠":"ba4",
"㖡":"ye4",
"㖢":"ji2",
"㖣":"tou4",
"㖤":"han2",
"㖥":"jiong3",
"㖦":"dong3",
"㖧":"wen3",
"㖨":"lu4",
"㖩":"sou3",
"㖪":"guo2",
"㖫":"ling2",
"㖭":"tian3",
"㖮":"lun2",
"㖶":"ye4",
"㖷":"shi2",
"㖸":"xue2",
"㖹":"fen4",
"㖺":"chun3",
"㖻":"rou2",
"㖼":"duo3",
"㖽":"ze2",
"㖾":"e4",
"㖿":"xie2",
"㗁":"e4",
"㗂":"sheng3",
"㗃":"wen3",
"㗄":"man2",
"㗅":"hu2",
"㗆":"ge2",
"㗇":"xia2",
"㗈":"man4",
"㗉":"bi4",
"㗊":"ji2",
"㗋":"hou2",
"㗌":"zhi4",
"㗑":"bai4",
"㗒":"ai4",
"㗕":"gou4",
"㗖":"dan4",
"㗗":"bai3",
"㗘":"bo2",
"㗙":"na4",
"㗚":"li4",
"㗛":"xiao4",
"㗜":"xiu4",
"㗢":"dong4",
"㗣":"ti4",
"㗤":"cu4",
"㗥":"kuo4",
"㗦":"lao2",
"㗧":"zhi4",
"㗨":"ai3",
"㗩":"xi1",
"㗫":"qie4",
"㗰":"chu4",
"㗱":"ji2",
"㗲":"huo4",
"㗳":"ta3",
"㗴":"yan2",
"㗵":"xu4",
"㗷":"sai3",
"㗼":"ye4",
"㗽":"xiang3",
"㗿":"xia4",
"㘀":"zuo4",
"㘁":"yi4",
"㘂":"ci2",
"㘅":"xian2",
"㘆":"tai2",
"㘇":"rong2",
"㘈":"yi1",
"㘉":"zhi4",
"㘊":"yi4",
"㘋":"xian2",
"㘌":"ju4",
"㘍":"ji2",
"㘎":"han3",
"㘐":"pao4",
"㘑":"li4",
"㘓":"lan2",
"㘔":"can3",
"㘕":"han3",
"㘖":"yan2",
"㘙":"yan2",
"㘚":"han3",
"㘜":"chi3",
"㘝":"nian3",
"㘞":"huo4",
"㘠":"bi4",
"㘡":"xia2",
"㘢":"weng3",
"㘣":"xuan2",
"㘥":"you2",
"㘦":"qin2",
"㘧":"xu4",
"㘨":"nei4",
"㘩":"bi4",
"㘪":"hao4",
"㘫":"jing3",
"㘬":"ao4",
"㘭":"ao4",
"㘲":"ju2",
"㘴":"zuo4",
"㘵":"bu4",
"㘶":"jie2",
"㘷":"ai4",
"㘸":"zang4",
"㘹":"ci2",
"㘺":"fa2",
"㘿":"nie4",
"㙀":"liu4",
"㙁":"mang3",
"㙂":"dui4",
"㙄":"bi4",
"㙅":"bao3",
"㙇":"chu4",
"㙈":"han2",
"㙉":"tian3",
"㙊":"chang2",
"㙏":"fu4",
"㙐":"duo3",
"㙑":"yu3",
"㙒":"ye3",
"㙓":"kui2",
"㙔":"han2",
"㙕":"kuai4",
"㙗":"kuai4",
"㙙":"long3",
"㙛":"bu3",
"㙜":"chi2",
"㙝":"xie2",
"㙞":"nie4",
"㙟":"lang3",
"㙠":"yi4",
"㙢":"man2",
"㙣":"zhang4",
"㙤":"xia4",
"㙥":"gun3",
"㙨":"ji4",
"㙩":"liao2",
"㙪":"ye4",
"㙫":"ji2",
"㙬":"yin2",
"㙮":"da1",
"㙯":"yi4",
"㙰":"xie4",
"㙱":"hao4",
"㙲":"yong3",
"㙳":"han3",
"㙴":"chan4",
"㙵":"tai2",
"㙶":"tang2",
"㙷":"zhi2",
"㙸":"bao4",
"㙹":"meng2",
"㙺":"gui4",
"㙻":"chan2",
"㙼":"lei3",
"㙾":"xi4",
"㚁":"qiao2",
"㚂":"rang2",
"㚃":"yun2",
"㚅":"long2",
"㚆":"fu4",
"㚉":"gu3",
"㚌":"hua4",
"㚍":"guo2",
"㚏":"gao3",
"㚐":"tao4",
"㚒":"shan3",
"㚓":"lai2",
"㚔":"nie4",
"㚕":"fu2",
"㚖":"gao3",
"㚗":"qie2",
"㚘":"ban4",
"㚛":"xi4",
"㚜":"xu4",
"㚝":"kui2",
"㚞":"meng3",
"㚟":"chuo4",
"㚡":"ji3",
"㚢":"nu2",
"㚣":"xiao2",
"㚤":"yi4",
"㚥":"yu2",
"㚦":"yi2",
"㚧":"yan3",
"㚩":"ran3",
"㚪":"hao4",
"㚫":"sha4",
"㚭":"you2",
"㚯":"xin2",
"㚰":"bi3",
"㚲":"dian3",
"㚴":"bu4",
"㚶":"si4",
"㚷":"er3",
"㚹":"mao3",
"㚺":"yun4",
"㚽":"qiao3",
"㚿":"pao2",
"㛂":"nuo3",
"㛃":"jie2",
"㛅":"er4",
"㛆":"duo3",
"㛊":"duo3",
"㛍":"qie4",
"㛏":"ou4",
"㛐":"sou3",
"㛑":"can4",
"㛒":"dou4",
"㛔":"peng2",
"㛕":"yi4",
"㛗":"zuo4",
"㛘":"po4",
"㛙":"qie4",
"㛚":"tong3",
"㛛":"xin4",
"㛜":"you2",
"㛝":"bei4",
"㛞":"long4",
"㛥":"ta4",
"㛦":"lan3",
"㛧":"man3",
"㛨":"qiang3",
"㛩":"zhou2",
"㛪":"yan4",
"㛬":"lu4",
"㛮":"sao3",
"㛯":"mian3",
"㛱":"rui4",
"㛲":"fa4",
"㛳":"cha4",
"㛴":"nao3",
"㛶":"chou2",
"㛸":"shu4",
"㛹":"pian2",
"㛻":"kui3",
"㛼":"sha4",
"㛾":"xian2",
"㛿":"zhi4",
"㜃":"lian4",
"㜄":"xun2",
"㜅":"xu4",
"㜆":"mi4",
"㜇":"hui4",
"㜈":"mu4",
"㜊":"pang4",
"㜋":"yi4",
"㜌":"gou4",
"㜍":"tang2",
"㜎":"qi2",
"㜏":"yun2",
"㜐":"shu4",
"㜑":"fu2",
"㜒":"yi4",
"㜓":"da2",
"㜕":"lian2",
"㜖":"cao2",
"㜗":"can3",
"㜘":"ju4",
"㜙":"lu4",
"㜚":"su4",
"㜛":"nen4",
"㜜":"ao4",
"㜝":"an3",
"㜞":"qian4",
"㜣":"ran2",
"㜤":"shen3",
"㜥":"mai2",
"㜦":"han4",
"㜧":"yue4",
"㜨":"er2",
"㜩":"ao4",
"㜪":"xian3",
"㜫":"ma4",
"㜮":"lan4",
"㜰":"yue4",
"㜱":"dong4",
"㜲":"weng3",
"㜳":"huai2",
"㜴":"meng4",
"㜵":"niao3",
"㜶":"wan3",
"㜷":"mi2",
"㜸":"nie4",
"㜹":"qu2",
"㜺":"zan4",
"㜻":"lian4",
"㜼":"zhi2",
"㜽":"zi3",
"㜾":"hai2",
"㜿":"xu4",
"㝀":"hao4",
"㝁":"xun2",
"㝂":"zhi4",
"㝃":"fan4",
"㝄":"chun2",
"㝅":"gou4",
"㝇":"chun2",
"㝈":"luan2",
"㝉":"zhu4",
"㝊":"shou3",
"㝋":"liao2",
"㝌":"jie2",
"㝍":"xie3",
"㝎":"ding4",
"㝏":"jie4",
"㝐":"rong2",
"㝑":"mang2",
"㝓":"ge2",
"㝔":"yao4",
"㝕":"ning2",
"㝖":"yi2",
"㝗":"lang2",
"㝘":"yong2",
"㝙":"yin2",
"㝛":"su4",
"㝝":"lin2",
"㝞":"ya4",
"㝟":"mao2",
"㝠":"ming2",
"㝡":"zui4",
"㝢":"yu3",
"㝣":"ye4",
"㝤":"gou4",
"㝥":"mi3",
"㝦":"jun4",
"㝧":"wen3",
"㝪":"dian4",
"㝫":"long2",
"㝭":"xing3",
"㝮":"cui4",
"㝯":"qiao2",
"㝰":"mian2",
"㝱":"meng4",
"㝲":"qin3",
"㝴":"wan2",
"㝵":"de2",
"㝶":"ai4",
"㝸":"bian4",
"㝹":"nou2",
"㝺":"lian2",
"㝻":"jin3",
"㝽":"chui2",
"㝾":"zuo3",
"㝿":"bo2",
"㞁":"yao4",
"㞂":"tui3",
"㞃":"ji2",
"㞅":"guo3",
"㞆":"ji3",
"㞇":"wei3",
"㞊":"xu4",
"㞋":"nian3",
"㞌":"yun4",
"㞎":"ba3",
"㞏":"zhe2",
"㞐":"ju1",
"㞑":"wei3",
"㞒":"xi4",
"㞓":"qi3",
"㞔":"yi2",
"㞕":"xie4",
"㞖":"ci4",
"㞗":"qiu2",
"㞘":"tun2",
"㞙":"niao4",
"㞚":"qi4",
"㞛":"ji3",
"㞟":"dian4",
"㞠":"lao2",
"㞡":"zhan3",
"㞤":"yin2",
"㞥":"cen2",
"㞦":"ji3",
"㞧":"hui4",
"㞨":"zai3",
"㞩":"lan2",
"㞪":"nao2",
"㞫":"ju4",
"㞬":"qin4",
"㞭":"dai4",
"㞯":"jie2",
"㞰":"xu3",
"㞲":"yong4",
"㞳":"dou3",
"㞴":"chi2",
"㞶":"min3",
"㞷":"huang2",
"㞸":"sui4",
"㞹":"ke3",
"㞺":"zu2",
"㞻":"hao4",
"㞼":"cheng2",
"㞽":"xue4",
"㞾":"ni2",
"㞿":"chi4",
"㟀":"lian2",
"㟁":"an4",
"㟂":"chi3",
"㟄":"xiang2",
"㟅":"yang2",
"㟆":"hua2",
"㟇":"cuo2",
"㟈":"qiu2",
"㟉":"lao2",
"㟊":"fu2",
"㟋":"dui4",
"㟌":"mang2",
"㟍":"lang2",
"㟎":"tuo3",
"㟏":"han2",
"㟐":"mang3",
"㟑":"bo2",
"㟓":"qi2",
"㟔":"han2",
"㟖":"long4",
"㟘":"tiao2",
"㟙":"lao3",
"㟚":"qi2",
"㟛":"zan4",
"㟜":"mi2",
"㟝":"pei2",
"㟞":"zhan4",
"㟟":"xiang4",
"㟠":"gang3",
"㟢":"qi2",
"㟤":"lu4",
"㟦":"yun4",
"㟧":"e4",
"㟨":"quan2",
"㟩":"min2",
"㟪":"wei3",
"㟫":"quan2",
"㟬":"shu3",
"㟭":"min2",
"㟰":"ming3",
"㟱":"yao3",
"㟲":"jue2",
"㟳":"li4",
"㟴":"kuai4",
"㟵":"gang3",
"㟶":"yuan2",
"㟷":"da5",
"㟹":"lao2",
"㟺":"lou2",
"㟻":"qian4",
"㟼":"ao2",
"㟽":"biao3",
"㟿":"mang2",
"㠀":"dao3",
"㠂":"ao2",
"㠄":"xi2",
"㠅":"fu2",
"㠇":"jiu4",
"㠈":"run4",
"㠉":"tong2",
"㠊":"qu1",
"㠋":"e4",
"㠍":"ji2",
"㠎":"ji2",
"㠏":"hua2",
"㠐":"jiao4",
"㠑":"zui4",
"㠒":"biao3",
"㠓":"meng2",
"㠔":"bai4",
"㠕":"wei3",
"㠖":"ji4",
"㠗":"ao4",
"㠘":"yu3",
"㠙":"hao2",
"㠚":"dui4",
"㠛":"wo4",
"㠜":"ni4",
"㠝":"cuan2",
"㠟":"li2",
"㠠":"lu2",
"㠡":"niao3",
"㠢":"hua4",
"㠣":"lai4",
"㠥":"lv4",
"㠧":"mi2",
"㠨":"yu4",
"㠪":"ju4",
"㠭":"zhan3",
"㠯":"yi3",
"㠱":"ji4",
"㠲":"bi3",
"㠴":"ren4",
"㠶":"fan2",
"㠷":"ge2",
"㠸":"ku4",
"㠹":"jie4",
"㠺":"miao2",
"㠽":"tong2",
"㠿":"ci3",
"㡀":"bi4",
"㡁":"kai3",
"㡂":"li4",
"㡄":"sun3",
"㡅":"nuo3",
"㡇":"ji2",
"㡈":"men2",
"㡉":"xian2",
"㡊":"qia4",
"㡋":"e4",
"㡌":"mao4",
"㡏":"tou2",
"㡑":"qiao3",
"㡔":"wu4",
"㡖":"chuang2",
"㡗":"ti2",
"㡘":"lian2",
"㡙":"bi4",
"㡛":"mang2",
"㡜":"xue3",
"㡝":"feng4",
"㡞":"lei3",
"㡠":"zheng4",
"㡡":"chu2",
"㡢":"man4",
"㡣":"long2",
"㡥":"yin3",
"㡧":"zheng4",
"㡨":"qian1",
"㡩":"luan2",
"㡪":"nie2",
"㡫":"yi4",
"㡭":"ji4",
"㡮":"ji2",
"㡯":"zhai2",
"㡰":"yu3",
"㡱":"jiu3",
"㡲":"huan2",
"㡳":"di3",
"㡵":"ling2",
"㡶":"ji4",
"㡷":"ben3",
"㡸":"zha3",
"㡹":"ci4",
"㡺":"dan4",
"㡻":"liao4",
"㡼":"yi4",
"㡽":"zhao4",
"㡾":"xian4",
"㡿":"chi4",
"㢀":"ci4",
"㢁":"chi3",
"㢂":"yan3",
"㢃":"lang2",
"㢄":"dou4",
"㢅":"long4",
"㢆":"chan2",
"㢈":"tui2",
"㢉":"cha2",
"㢊":"ai3",
"㢋":"chi3",
"㢍":"ying2",
"㢎":"cha4",
"㢏":"tou2",
"㢑":"tui2",
"㢒":"cha2",
"㢓":"yao3",
"㢔":"zong3",
"㢗":"qiao4",
"㢘":"lian2",
"㢙":"qin2",
"㢚":"lu3",
"㢛":"yan4",
"㢞":"yi4",
"㢟":"chan3",
"㢠":"jiong3",
"㢡":"jiang3",
"㢣":"jing4",
"㢥":"dong4",
"㢧":"juan4",
"㢨":"han4",
"㢩":"di4",
"㢬":"hong2",
"㢮":"chi2",
"㢯":"min2",
"㢰":"bi4",
"㢲":"xun4",
"㢳":"lu2",
"㢵":"she4",
"㢶":"bi4",
"㢸":"bi4",
"㢺":"xian2",
"㢻":"wei3",
"㢼":"bie4",
"㢽":"er3",
"㢾":"juan4",
"㣀":"zhen4",
"㣁":"bei4",
"㣂":"yi4",
"㣃":"yu3",
"㣄":"qu2",
"㣅":"zan4",
"㣆":"mi2",
"㣇":"ni3",
"㣈":"si4",
"㣌":"shan4",
"㣍":"tai2",
"㣎":"mu4",
"㣏":"jing4",
"㣐":"bian4",
"㣑":"rong2",
"㣒":"ceng4",
"㣓":"can4",
"㣙":"di2",
"㣚":"tong2",
"㣛":"ta4",
"㣜":"xing2",
"㣞":"duo2",
"㣟":"xi4",
"㣠":"tong2",
"㣢":"ti2",
"㣣":"shan3",
"㣤":"jian4",
"㣥":"zhi4",
"㣧":"yin4",
"㣪":"huan3",
"㣫":"zhong3",
"㣬":"qi4",
"㣯":"xie4",
"㣰":"xie4",
"㣱":"ze2",
"㣲":"wei2",
"㣵":"ta4",
"㣶":"zhan1",
"㣷":"ning4",
"㣻":"yi4",
"㣼":"ren3",
"㣽":"shu4",
"㣾":"cha4",
"㣿":"zhuo2",
"㤁":"mian3",
"㤂":"ji2",
"㤃":"fang2",
"㤄":"pei4",
"㤅":"ai4",
"㤆":"fan4",
"㤇":"ao3",
"㤈":"qin4",
"㤉":"qia4",
"㤊":"xiao4",
"㤍":"qiao3",
"㤏":"tong2",
"㤑":"you4",
"㤓":"ben4",
"㤔":"fu2",
"㤕":"chu4",
"㤖":"zhu4",
"㤘":"chu4",
"㤚":"hang2",
"㤛":"nin2",
"㤜":"jue2",
"㤞":"cha4",
"㤟":"kong3",
"㤠":"lie4",
"㤡":"li4",
"㤢":"xu4",
"㤤":"yu2",
"㤥":"hai4",
"㤦":"li4",
"㤧":"hou2",
"㤨":"gong3",
"㤩":"ke4",
"㤪":"yuan4",
"㤫":"de2",
"㤬":"hui4",
"㤮":"kuang2",
"㤯":"jiong3",
"㤰":"zan3",
"㤱":"fu4",
"㤲":"qie4",
"㤳":"bei3",
"㤴":"xi2",
"㤵":"ci2",
"㤶":"pang2",
"㤸":"xi4",
"㤹":"qiu2",
"㤺":"huang3",
"㤽":"chou2",
"㤾":"san4",
"㥀":"de2",
"㥁":"de2",
"㥂":"te4",
"㥃":"men4",
"㥄":"ling2",
"㥅":"shou4",
"㥆":"dian4",
"㥇":"can2",
"㥈":"die2",
"㥉":"che4",
"㥊":"peng2",
"㥌":"ju2",
"㥍":"ji4",
"㥎":"lai2",
"㥏":"tian3",
"㥐":"yuan4",
"㥒":"cai3",
"㥓":"qi3",
"㥔":"yu2",
"㥕":"lian2",
"㥚":"yu2",
"㥛":"ji2",
"㥜":"wei4",
"㥝":"mi3",
"㥞":"cui4",
"㥟":"xie2",
"㥠":"xu3",
"㥡":"xi4",
"㥢":"qiu2",
"㥣":"hui4",
"㥥":"yu2",
"㥦":"qie4",
"㥧":"shun4",
"㥨":"chui2",
"㥩":"duo3",
"㥪":"lou2",
"㥬":"pang2",
"㥭":"tai4",
"㥮":"zhou4",
"㥯":"yin3",
"㥱":"fei3",
"㥲":"shen4",
"㥳":"yuan2",
"㥴":"yi2",
"㥵":"hun4",
"㥶":"se4",
"㥷":"ye4",
"㥸":"min3",
"㥹":"fen3",
"㥺":"he2",
"㥼":"yin3",
"㥽":"ce4",
"㥾":"ni4",
"㥿":"ao4",
"㦀":"feng2",
"㦁":"lian2",
"㦂":"chang2",
"㦃":"chan3",
"㦄":"ma2",
"㦅":"di4",
"㦇":"lu4",
"㦉":"yi4",
"㦊":"hua2",
"㦌":"tui4",
"㦍":"e4",
"㦎":"hua4",
"㦏":"sun3",
"㦐":"ni4",
"㦑":"lian3",
"㦒":"li2",
"㦓":"xian4",
"㦔":"yan4",
"㦕":"long2",
"㦖":"men4",
"㦗":"jian4",
"㦚":"bian3",
"㦛":"yu2",
"㦜":"huo4",
"㦝":"miao3",
"㦞":"chou2",
"㦟":"hai4",
"㦡":"le4",
"㦢":"jie2",
"㦣":"wei4",
"㦤":"yi4",
"㦥":"huan2",
"㦦":"he4",
"㦧":"can3",
"㦨":"lan2",
"㦩":"yin3",
"㦪":"xie4",
"㦬":"luo3",
"㦭":"ling2",
"㦮":"qian2",
"㦯":"huo4",
"㦱":"wo3",
"㦴":"ge2",
"㦶":"die2",
"㦷":"yong3",
"㦸":"ji3",
"㦹":"ang4",
"㦺":"ru3",
"㦻":"xi2",
"㦼":"shuang4",
"㦽":"xu4",
"㦾":"yi2",
"㦿":"hu4",
"㧀":"ji2",
"㧁":"qu4",
"㧂":"tian2",
"㧄":"qian3",
"㧅":"mu4",
"㧇":"mao3",
"㧈":"yin3",
"㧉":"gai4",
"㧊":"ba2",
"㧋":"xian3",
"㧌":"mao4",
"㧍":"fang3",
"㧎":"ya2",
"㧐":"song3",
"㧑":"hui1",
"㧒":"xue2",
"㧔":"guai4",
"㧕":"jiu4",
"㧖":"e4",
"㧗":"zi3",
"㧘":"cui4",
"㧙":"bi4",
"㧚":"wa3",
"㧜":"lie4",
"㧟":"kuai3",
"㧡":"hai4",
"㧣":"zhu4",
"㧤":"chong4",
"㧥":"xian3",
"㧦":"xuan4",
"㧨":"qiu2",
"㧩":"pei4",
"㧪":"gui3",
"㧫":"er2",
"㧬":"gong3",
"㧭":"qiong2",
"㧯":"lao3",
"㧰":"li4",
"㧱":"chen4",
"㧲":"san3",
"㧳":"bo2",
"㧴":"wo3",
"㧵":"pou2",
"㧷":"duo4",
"㧹":"te4",
"㧺":"ta4",
"㧻":"zhi3",
"㧼":"biao4",
"㧽":"gu4",
"㨀":"bing3",
"㨁":"zhi2",
"㨂":"dong3",
"㨃":"cheng2",
"㨄":"zhao4",
"㨅":"nei4",
"㨆":"lin3",
"㨇":"po2",
"㨈":"ji3",
"㨉":"min3",
"㨊":"wei3",
"㨋":"che3",
"㨌":"gou4",
"㨎":"ru2",
"㨐":"bu3",
"㨒":"kui2",
"㨓":"lao2",
"㨔":"han4",
"㨕":"ying2",
"㨖":"zhi4",
"㨗":"jie2",
"㨘":"xing3",
"㨙":"xie2",
"㨚":"xun2",
"㨛":"shan3",
"㨜":"qian2",
"㨝":"xie4",
"㨞":"su4",
"㨟":"hai2",
"㨠":"mi4",
"㨡":"hun2",
"㨤":"hui4",
"㨥":"na4",
"㨦":"song3",
"㨧":"ben4",
"㨨":"liu4",
"㨩":"jie2",
"㨪":"huang4",
"㨫":"lan3",
"㨭":"hu4",
"㨮":"dou1",
"㨯":"huo4",
"㨰":"ge2",
"㨱":"yao2",
"㨲":"ce4",
"㨳":"gui3",
"㨴":"jian4",
"㨵":"jian3",
"㨶":"chou2",
"㨷":"jin4",
"㨸":"ma4",
"㨹":"hui4",
"㨺":"men2",
"㨻":"can2",
"㨼":"lve4",
"㨽":"pi3",
"㨾":"yang4",
"㨿":"ju4",
"㩀":"ju4",
"㩁":"que4",
"㩄":"shai1",
"㩆":"jiu4",
"㩇":"hua4",
"㩈":"xian4",
"㩉":"xie2",
"㩋":"su4",
"㩌":"fei4",
"㩍":"ce4",
"㩎":"ye4",
"㩒":"qin2",
"㩓":"hui3",
"㩔":"tun2",
"㩖":"qiang2",
"㩗":"xi2",
"㩘":"yi3",
"㩚":"meng2",
"㩛":"tuan2",
"㩜":"lan3",
"㩝":"hao2",
"㩞":"ci4",
"㩟":"zhai4",
"㩠":"piao3",
"㩡":"luo3",
"㩢":"mi2",
"㩦":"xie2",
"㩧":"bo2",
"㩨":"hui4",
"㩩":"qi3",
"㩪":"xie2",
"㩭":"bo2",
"㩮":"qian2",
"㩯":"ban3",
"㩰":"jiao3",
"㩱":"jue2",
"㩲":"kun3",
"㩳":"song3",
"㩴":"ju2",
"㩵":"e4",
"㩶":"nie4",
"㩸":"die2",
"㩹":"die2",
"㩻":"gui3",
"㩽":"qi2",
"㩾":"chui2",
"㪀":"yu2",
"㪁":"qin2",
"㪃":"ke3",
"㪄":"fu2",
"㪆":"di3",
"㪇":"xian4",
"㪈":"gui4",
"㪉":"he2",
"㪊":"qun2",
"㪋":"han4",
"㪌":"tong3",
"㪍":"bo2",
"㪎":"shan3",
"㪏":"bi3",
"㪐":"lu4",
"㪑":"ye4",
"㪒":"ni2",
"㪓":"chuai2",
"㪔":"san4",
"㪕":"diao4",
"㪖":"lu4",
"㪗":"tou3",
"㪘":"lian3",
"㪙":"ke3",
"㪚":"san4",
"㪛":"zhen3",
"㪜":"chuai3",
"㪝":"lian4",
"㪞":"mao4",
"㪠":"qian4",
"㪡":"ke3",
"㪢":"shao3",
"㪣":"qiao4",
"㪤":"bi4",
"㪦":"yin4",
"㪨":"shan4",
"㪩":"su4",
"㪪":"sa4",
"㪫":"rui4",
"㪬":"zhuo2",
"㪭":"lu2",
"㪮":"ling2",
"㪯":"cha2",
"㪱":"huan4",
"㪴":"jia2",
"㪵":"ban4",
"㪶":"hu2",
"㪷":"dou3",
"㪹":"lou3",
"㪻":"juan4",
"㪼":"ke3",
"㪽":"suo3",
"㪾":"ge2",
"㪿":"zhe2",
"㫀":"ding3",
"㫁":"duan4",
"㫂":"zhu4",
"㫃":"yan3",
"㫄":"pang2",
"㫅":"cha2",
"㫊":"yi3",
"㫍":"you2",
"㫎":"gun3",
"㫏":"yao3",
"㫐":"yao3",
"㫑":"shi2",
"㫒":"gong3",
"㫓":"qi3",
"㫔":"gen4",
"㫗":"hou4",
"㫘":"mi4",
"㫙":"fu2",
"㫚":"hu1",
"㫛":"guang4",
"㫜":"dan4",
"㫟":"yan2",
"㫢":"qu4",
"㫤":"chang3",
"㫥":"ming3",
"㫧":"bao4",
"㫫":"xian3",
"㫯":"mao4",
"㫰":"lang3",
"㫱":"nan3",
"㫲":"pei4",
"㫳":"chen2",
"㫶":"cou3",
"㫸":"qie4",
"㫹":"dai4",
"㫻":"kun4",
"㫼":"die2",
"㫽":"lu4",
"㬂":"yu2",
"㬃":"tai2",
"㬄":"chan4",
"㬅":"man4",
"㬆":"mian2",
"㬇":"huan4",
"㬉":"nuan3",
"㬊":"huan3",
"㬋":"hou2",
"㬌":"jing4",
"㬍":"bo2",
"㬎":"xian3",
"㬏":"li4",
"㬐":"jin3",
"㬒":"mang3",
"㬓":"piao4",
"㬔":"hao2",
"㬕":"yang2",
"㬗":"xian4",
"㬘":"su4",
"㬙":"wei3",
"㬚":"che4",
"㬜":"jin4",
"㬝":"ceng2",
"㬞":"he4",
"㬠":"shai4",
"㬡":"ling2",
"㬣":"dui4",
"㬥":"pu4",
"㬦":"yue4",
"㬧":"bo2",
"㬩":"hui4",
"㬪":"die2",
"㬫":"yan4",
"㬬":"ju4",
"㬭":"jiao4",
"㬮":"kuai4",
"㬯":"lie4",
"㬰":"yu2",
"㬱":"ti4",
"㬳":"wu3",
"㬴":"hong3",
"㬵":"xiao2",
"㬶":"hao4",
"㬻":"huang3",
"㬼":"fu4",
"㬿":"dun4",
"㭁":"reng2",
"㭂":"jiao3",
"㭄":"xin4",
"㭇":"yuan4",
"㭈":"jue2",
"㭉":"hua2",
"㭋":"bang4",
"㭌":"mou2",
"㭏":"wei3",
"㭑":"mei4",
"㭒":"si4",
"㭓":"bian4",
"㭔":"lu2",
"㭘":"he2",
"㭙":"she2",
"㭚":"lv3",
"㭛":"pai4",
"㭜":"rong2",
"㭝":"qiu2",
"㭞":"lie4",
"㭟":"gong3",
"㭠":"xian3",
"㭡":"xi4",
"㭤":"niao3",
"㭨":"xie2",
"㭩":"lei4",
"㭫":"cuan2",
"㭬":"zhuo2",
"㭭":"fei4",
"㭮":"zuo4",
"㭯":"die2",
"㭰":"ji4",
"㭱":"he2",
"㭲":"ji2",
"㭸":"tu2",
"㭹":"xian2",
"㭺":"yan3",
"㭻":"tang2",
"㭼":"ta4",
"㭽":"di3",
"㭾":"jue2",
"㭿":"ang2",
"㮀":"han2",
"㮁":"yao2",
"㮂":"ju2",
"㮃":"rui2",
"㮄":"bang3",
"㮆":"nie4",
"㮇":"tian4",
"㮈":"nai4",
"㮋":"you3",
"㮌":"mian2",
"㮏":"nai4",
"㮐":"xing3",
"㮑":"qi4",
"㮓":"gen4",
"㮔":"tong2",
"㮕":"er2",
"㮖":"jia2",
"㮗":"qin2",
"㮘":"mao4",
"㮙":"e4",
"㮚":"li4",
"㮛":"chi2",
"㮝":"he2",
"㮞":"jie2",
"㮟":"ji2",
"㮡":"guan4",
"㮢":"hou2",
"㮣":"gai4",
"㮥":"fen4",
"㮦":"se4",
"㮨":"ji2",
"㮪":"qiong2",
"㮫":"he2",
"㮭":"xian2",
"㮮":"jie2",
"㮯":"hua2",
"㮰":"bi2",
"㮳":"zhen4",
"㮶":"shi4",
"㮸":"song4",
"㮹":"zhi3",
"㮺":"ben3",
"㮾":"lang3",
"㮿":"bi4",
"㯀":"xian3",
"㯁":"bang4",
"㯂":"dai4",
"㯅":"pi2",
"㯆":"chan3",
"㯇":"bi4",
"㯈":"su4",
"㯉":"huo4",
"㯊":"hen2",
"㯋":"ying3",
"㯌":"chuan2",
"㯍":"jiang3",
"㯎":"nen4",
"㯏":"gu3",
"㯐":"fang3",
"㯓":"ta4",
"㯔":"cui4",
"㯖":"de2",
"㯗":"ran3",
"㯘":"kuan3",
"㯙":"che4",
"㯚":"da2",
"㯛":"hu2",
"㯜":"cui4",
"㯝":"lu4",
"㯞":"juan4",
"㯟":"lu4",
"㯠":"qian4",
"㯡":"pao4",
"㯢":"zhen4",
"㯤":"li4",
"㯥":"cao2",
"㯦":"qi2",
"㯩":"ti4",
"㯪":"ling2",
"㯫":"qu2",
"㯬":"lian3",
"㯭":"lu3",
"㯮":"shu3",
"㯯":"gong4",
"㯰":"zhe2",
"㯱":"biao3",
"㯲":"jin4",
"㯳":"qing2",
"㯶":"zong1",
"㯷":"pu2",
"㯸":"jin3",
"㯹":"biao3",
"㯺":"jian4",
"㯻":"gun3",
"㯿":"lie4",
"㰀":"li2",
"㰁":"luo3",
"㰂":"shen3",
"㰃":"mian2",
"㰄":"jian4",
"㰅":"di2",
"㰆":"bei4",
"㰈":"lian3",
"㰊":"xun2",
"㰋":"pin2",
"㰌":"que4",
"㰍":"long2",
"㰎":"zui4",
"㰐":"jue2",
"㰒":"she2",
"㰔":"xie4",
"㰖":"lan3",
"㰗":"cu4",
"㰘":"yi2",
"㰙":"nuo2",
"㰚":"li2",
"㰛":"yue4",
"㰝":"yi3",
"㰟":"ji4",
"㰠":"kang4",
"㰡":"xie4",
"㰣":"zi4",
"㰤":"ke3",
"㰥":"hui4",
"㰦":"qu4",
"㰪":"wa2",
"㰬":"xun2",
"㰮":"shen4",
"㰯":"kou4",
"㰰":"qie4",
"㰱":"sha4",
"㰲":"xu4",
"㰳":"ya4",
"㰴":"po2",
"㰵":"zu2",
"㰶":"you3",
"㰷":"zi4",
"㰸":"lian3",
"㰹":"jin4",
"㰺":"xia2",
"㰻":"yi3",
"㰼":"qie4",
"㰽":"mi3",
"㰾":"jiao4",
"㱀":"chi3",
"㱁":"shi4",
"㱃":"yin3",
"㱄":"mo4",
"㱅":"yi4",
"㱇":"se4",
"㱈":"jin4",
"㱉":"ye4",
"㱋":"que4",
"㱌":"che4",
"㱍":"luan2",
"㱏":"zheng4",
"㱖":"cui4",
"㱘":"an4",
"㱙":"xiu3",
"㱚":"can2",
"㱛":"chuan3",
"㱜":"zha2",
"㱞":"ji2",
"㱟":"bo2",
"㱢":"lang2",
"㱣":"tui3",
"㱥":"ling2",
"㱦":"e4",
"㱧":"wo4",
"㱨":"lian4",
"㱩":"du2",
"㱪":"men4",
"㱫":"lan4",
"㱬":"wei3",
"㱭":"duan4",
"㱮":"kuai4",
"㱯":"ai2",
"㱰":"zai3",
"㱱":"hui4",
"㱲":"yi4",
"㱳":"mo4",
"㱴":"zi4",
"㱵":"ben4",
"㱶":"beng4",
"㱸":"bi4",
"㱹":"li4",
"㱺":"lu2",
"㱻":"luo3",
"㱽":"dan4",
"㱿":"que4",
"㲀":"chen2",
"㲂":"cheng2",
"㲃":"jiu4",
"㲄":"kou4",
"㲅":"ji4",
"㲆":"ling2",
"㲈":"shao2",
"㲉":"kai4",
"㲊":"rui4",
"㲋":"chuo4",
"㲌":"neng4",
"㲎":"lou2",
"㲏":"bao3",
"㲒":"bao4",
"㲓":"rong2",
"㲕":"lei4",
"㲘":"qu2",
"㲛":"zhi3",
"㲜":"tan2",
"㲝":"rong3",
"㲞":"zu2",
"㲟":"ying3",
"㲠":"mao2",
"㲡":"nai4",
"㲢":"bian4",
"㲥":"tang2",
"㲦":"han4",
"㲧":"zao4",
"㲨":"rong2",
"㲫":"pu2",
"㲭":"tan3",
"㲯":"ran2",
"㲰":"ning2",
"㲱":"lie4",
"㲲":"die2",
"㲳":"die2",
"㲴":"zhong4",
"㲶":"lv4",
"㲷":"dan4",
"㲹":"gui3",
"㲺":"ji2",
"㲻":"ni4",
"㲼":"yi4",
"㲽":"nian4",
"㲾":"yu3",
"㲿":"wang3",
"㳀":"guo4",
"㳁":"ze4",
"㳂":"yan2",
"㳃":"cui4",
"㳄":"xian2",
"㳅":"jiao3",
"㳆":"shu3",
"㳇":"fu4",
"㳈":"pei4",
"㳍":"bu4",
"㳎":"bian4",
"㳏":"chi3",
"㳐":"sa4",
"㳑":"yi4",
"㳒":"bian4",
"㳔":"dui4",
"㳕":"lan2",
"㳗":"chai4",
"㳙":"xuan4",
"㳚":"yu4",
"㳛":"yu2",
"㳠":"ta4",
"㳥":"ju4",
"㳦":"xie4",
"㳧":"xi2",
"㳨":"jian3",
"㳪":"pan4",
"㳫":"ta4",
"㳬":"xuan2",
"㳭":"xian2",
"㳮":"niao4",
"㳴":"mi4",
"㳵":"ji4",
"㳶":"gou4",
"㳷":"wen3",
"㳹":"wang3",
"㳺":"you2",
"㳻":"ze2",
"㳼":"bi4",
"㳽":"mi3",
"㳿":"xie4",
"㴀":"fan4",
"㴁":"yi4",
"㴃":"lei4",
"㴄":"ying2",
"㴆":"jin4",
"㴇":"she4",
"㴈":"yin4",
"㴉":"ji3",
"㴋":"su4",
"㴏":"wang3",
"㴐":"mian4",
"㴑":"su4",
"㴒":"yi4",
"㴓":"zai3",
"㴔":"se4",
"㴕":"ji2",
"㴖":"luo4",
"㴘":"mao4",
"㴙":"zha2",
"㴚":"sui4",
"㴛":"zhi4",
"㴜":"bian4",
"㴝":"li2",
"㴥":"qiao4",
"㴦":"guan4",
"㴨":"zhen4",
"㴪":"nie4",
"㴫":"jun4",
"㴬":"xie4",
"㴭":"yao3",
"㴮":"xie4",
"㴰":"neng2",
"㴳":"long3",
"㴴":"chen2",
"㴵":"mi4",
"㴶":"que4",
"㴸":"na4",
"㴼":"su4",
"㴽":"xie4",
"㴾":"bo2",
"㴿":"ding3",
"㵀":"cuan4",
"㵂":"chuang3",
"㵃":"che4",
"㵄":"han4",
"㵅":"dan4",
"㵆":"hao4",
"㵊":"shen3",
"㵋":"mi4",
"㵌":"chan4",
"㵍":"men4",
"㵎":"han3",
"㵏":"cui3",
"㵐":"jue2",
"㵑":"he4",
"㵒":"fei4",
"㵓":"shi2",
"㵔":"che3",
"㵕":"shen4",
"㵖":"nv4",
"㵗":"fu4",
"㵘":"man4",
"㵝":"yi4",
"㵞":"chou2",
"㵡":"bao2",
"㵢":"lei2",
"㵣":"ke3",
"㵤":"dian4",
"㵥":"bi4",
"㵦":"sui2",
"㵧":"ge2",
"㵨":"bi4",
"㵩":"yi4",
"㵪":"xian2",
"㵫":"ni3",
"㵬":"ying2",
"㵭":"zhu3",
"㵮":"chun2",
"㵯":"feng2",
"㵰":"xu4",
"㵱":"piao3",
"㵲":"wu3",
"㵳":"liao2",
"㵴":"cang2",
"㵵":"zou4",
"㵷":"bian4",
"㵸":"yao4",
"㵹":"huan2",
"㵺":"pai2",
"㵻":"sou4",
"㵽":"dui4",
"㵾":"jing4",
"㵿":"xi2",
"㶁":"guo2",
"㶄":"yan2",
"㶅":"xue2",
"㶆":"chu2",
"㶇":"heng2",
"㶈":"ying2",
"㶉":"xi1",
"㶌":"lian2",
"㶍":"xian3",
"㶎":"huan2",
"㶑":"lian4",
"㶒":"shan3",
"㶓":"cang2",
"㶔":"bei4",
"㶕":"jian3",
"㶖":"shu4",
"㶗":"fan4",
"㶘":"dian4",
"㶚":"ba4",
"㶛":"yu2",
"㶞":"nang3",
"㶟":"lei3",
"㶠":"yi4",
"㶡":"dai4",
"㶣":"chan2",
"㶤":"chao3",
"㶦":"jin4",
"㶧":"nen4",
"㶫":"liao3",
"㶬":"mei2",
"㶭":"jiu4",
"㶯":"liu4",
"㶰":"han2",
"㶲":"yong4",
"㶳":"jin4",
"㶴":"chi3",
"㶵":"ren4",
"㶶":"nong2",
"㶸":"xie2",
"㶹":"hong4",
"㶺":"tian4",
"㶿":"bo2",
"㷀":"qiong2",
"㷂":"shu4",
"㷃":"cui3",
"㷄":"hui4",
"㷅":"chao3",
"㷆":"dou4",
"㷇":"guai4",
"㷈":"e4",
"㷉":"wei4",
"㷊":"fen2",
"㷋":"tan2",
"㷍":"lun2",
"㷎":"he4",
"㷏":"yong3",
"㷐":"hui3",
"㷒":"yu2",
"㷓":"zong3",
"㷔":"yan4",
"㷕":"qiu2",
"㷖":"zhao4",
"㷗":"jiong3",
"㷘":"tai2",
"㷟":"tui4",
"㷠":"lin2",
"㷡":"jiong3",
"㷢":"zha3",
"㷤":"he4",
"㷦":"xu4",
"㷪":"cui4",
"㷫":"qing3",
"㷬":"mo4",
"㷯":"beng4",
"㷰":"li2",
"㷳":"yan4",
"㷴":"ge2",
"㷵":"mo4",
"㷶":"bei4",
"㷷":"juan3",
"㷸":"die2",
"㷹":"shao4",
"㷻":"wu2",
"㷼":"yan4",
"㷾":"jue2",
"㸀":"tai2",
"㸁":"han3",
"㸃":"dian3",
"㸄":"ji4",
"㸅":"jie2",
"㸉":"xie4",
"㸊":"la4",
"㸋":"fan2",
"㸌":"huo4",
"㸍":"xi4",
"㸎":"nie4",
"㸏":"mi2",
"㸐":"ran2",
"㸑":"cuan4",
"㸒":"yin2",
"㸓":"mi4",
"㸕":"jue2",
"㸗":"tong2",
"㸘":"wan4",
"㸚":"li3",
"㸛":"shao2",
"㸜":"kong4",
"㸝":"kan3",
"㸞":"ban3",
"㸠":"tiao3",
"㸢":"bei4",
"㸣":"ye4",
"㸤":"pian4",
"㸥":"chan2",
"㸦":"hu4",
"㸧":"ken4",
"㸩":"an4",
"㸪":"chun2",
"㸫":"qian2",
"㸬":"bei4",
"㸮":"fen2",
"㸰":"tuo2",
"㸱":"tuo2",
"㸲":"zuo2",
"㸳":"ling2",
"㸵":"gui3",
"㸷":"shi4",
"㸸":"hou3",
"㸹":"lie4",
"㸻":"si4",
"㸽":"bei4",
"㸾":"ren4",
"㸿":"du2",
"㹀":"bo2",
"㹁":"liang2",
"㹂":"ci4",
"㹃":"bi4",
"㹄":"ji4",
"㹅":"zong3",
"㹇":"he2",
"㹈":"li2",
"㹉":"yuan2",
"㹊":"yue4",
"㹌":"chan3",
"㹍":"di2",
"㹎":"lei2",
"㹏":"jin3",
"㹐":"chong2",
"㹑":"si4",
"㹒":"pu3",
"㹓":"yi4",
"㹖":"huan4",
"㹗":"tao2",
"㹘":"ru2",
"㹙":"ying2",
"㹚":"ying2",
"㹛":"rao2",
"㹜":"yin2",
"㹝":"shi4",
"㹞":"yin2",
"㹟":"jue2",
"㹠":"tun2",
"㹡":"xuan2",
"㹤":"qie4",
"㹥":"zhu4",
"㹨":"you4",
"㹫":"xi4",
"㹬":"shi3",
"㹭":"yi4",
"㹮":"mo4",
"㹱":"hu2",
"㹲":"xiao4",
"㹳":"wu2",
"㹵":"jing4",
"㹶":"ting2",
"㹷":"shi3",
"㹸":"ni2",
"㹺":"ta4",
"㹼":"chu3",
"㹽":"chan3",
"㹾":"piao3",
"㹿":"diao3",
"㺀":"nao2",
"㺁":"nao3",
"㺂":"gan3",
"㺃":"gou3",
"㺄":"yu3",
"㺅":"hou2",
"㺉":"hu4",
"㺊":"yang4",
"㺌":"xian4",
"㺎":"rong2",
"㺏":"lou2",
"㺐":"zhao3",
"㺑":"can2",
"㺒":"liao4",
"㺓":"piao4",
"㺔":"hai4",
"㺕":"fan2",
"㺖":"han3",
"㺗":"dan4",
"㺘":"zhan4",
"㺚":"ta3",
"㺛":"zhu4",
"㺜":"ban3",
"㺝":"jian4",
"㺞":"yu2",
"㺟":"zhuo2",
"㺠":"you4",
"㺡":"li4",
"㺥":"chan2",
"㺦":"lian2",
"㺩":"jiu4",
"㺪":"pu2",
"㺫":"qiu2",
"㺬":"gong3",
"㺭":"zi3",
"㺮":"yu2",
"㺱":"reng2",
"㺲":"niu3",
"㺳":"mei2",
"㺵":"jiu2",
"㺷":"xu4",
"㺸":"ping2",
"㺹":"bian4",
"㺺":"mao4",
"㺿":"yi2",
"㻀":"you2",
"㻂":"ping2",
"㻄":"bao3",
"㻅":"hui4",
"㻉":"bu4",
"㻊":"mang2",
"㻋":"la4",
"㻌":"tu2",
"㻍":"wu2",
"㻎":"li4",
"㻏":"ling2",
"㻑":"ji4",
"㻒":"jun4",
"㻔":"duo3",
"㻕":"jue2",
"㻖":"dai4",
"㻗":"bei4",
"㻝":"la4",
"㻞":"bian4",
"㻟":"sui2",
"㻠":"tu2",
"㻡":"die2",
"㻧":"duo4",
"㻪":"sui4",
"㻫":"bi4",
"㻬":"tu2",
"㻭":"se4",
"㻮":"can4",
"㻯":"tu2",
"㻰":"mian3",
"㻲":"lv3",
"㻵":"zhan4",
"㻶":"bi3",
"㻷":"ji2",
"㻸":"cen2",
"㻺":"li4",
"㻽":"sui4",
"㻿":"shu3",
"㼂":"e2",
"㼇":"qiong2",
"㼈":"luo2",
"㼉":"yin4",
"㼊":"tun2",
"㼋":"gu3",
"㼌":"yu3",
"㼍":"lei3",
"㼎":"bei4",
"㼏":"nei3",
"㼐":"pian2",
"㼑":"lian4",
"㼒":"qiu3",
"㼓":"lian2",
"㼖":"li4",
"㼗":"ding3",
"㼘":"wa3",
"㼙":"zhou4",
"㼛":"xing2",
"㼜":"ang4",
"㼝":"fan4",
"㼞":"peng4",
"㼟":"bai2",
"㼠":"tuo2",
"㼢":"e3",
"㼣":"bai3",
"㼤":"qi4",
"㼥":"chu2",
"㼦":"gong3",
"㼧":"tong2",
"㼨":"han2",
"㼩":"cheng2",
"㼪":"jia2",
"㼫":"huan4",
"㼬":"xing4",
"㼭":"dian4",
"㼮":"mai2",
"㼯":"dong4",
"㼰":"e2",
"㼱":"ruan3",
"㼲":"lie4",
"㼳":"sheng3",
"㼴":"ou3",
"㼵":"di4",
"㼶":"yu2",
"㼷":"chuan2",
"㼸":"rong2",
"㼺":"tang2",
"㼻":"cong2",
"㼼":"piao2",
"㼽":"shuang3",
"㼾":"lu4",
"㼿":"tong2",
"㽀":"zheng4",
"㽁":"li4",
"㽂":"sa4",
"㽇":"guai4",
"㽈":"yi4",
"㽉":"han3",
"㽊":"xie4",
"㽋":"luo2",
"㽌":"liu4",
"㽎":"dan3",
"㽑":"tan2",
"㽕":"you2",
"㽖":"nan2",
"㽘":"gang3",
"㽙":"jun4",
"㽚":"chi4",
"㽛":"kou4",
"㽜":"wan3",
"㽝":"li4",
"㽞":"liu2",
"㽟":"lie4",
"㽠":"xia2",
"㽢":"an3",
"㽣":"yu4",
"㽤":"ju2",
"㽥":"rou2",
"㽦":"xun2",
"㽨":"cuo2",
"㽩":"can4",
"㽪":"zeng3",
"㽫":"yong3",
"㽬":"fu4",
"㽭":"ruan3",
"㽯":"xi2",
"㽰":"shu4",
"㽱":"jiao3",
"㽲":"jiao3",
"㽳":"han4",
"㽴":"zhang4",
"㽷":"shui4",
"㽸":"chen2",
"㽹":"fan4",
"㽺":"ji2",
"㽽":"gu4",
"㽾":"wu4",
"㾀":"qie4",
"㾁":"shu4",
"㾃":"tuo2",
"㾄":"du2",
"㾅":"si4",
"㾆":"ran2",
"㾇":"mu4",
"㾈":"fu4",
"㾉":"ling2",
"㾊":"ji2",
"㾋":"xiu4",
"㾌":"xuan3",
"㾍":"nai2",
"㾏":"jie4",
"㾐":"li4",
"㾑":"da2",
"㾒":"ji4",
"㾔":"lv3",
"㾕":"shen3",
"㾖":"li3",
"㾗":"lang3",
"㾘":"geng3",
"㾙":"yin3",
"㾛":"qin3",
"㾜":"qie4",
"㾝":"che4",
"㾞":"you3",
"㾟":"bu4",
"㾠":"huang2",
"㾡":"que4",
"㾢":"lai4",
"㾥":"xu4",
"㾦":"bang4",
"㾧":"ke4",
"㾨":"qi3",
"㾪":"sheng3",
"㾭":"zhou4",
"㾮":"huang2",
"㾯":"tui2",
"㾰":"hu2",
"㾱":"bei4",
"㾵":"ji4",
"㾶":"gu3",
"㾸":"gao3",
"㾹":"chai2",
"㾺":"ma4",
"㾻":"zhu4",
"㾼":"tui3",
"㾽":"tui2",
"㾾":"lian2",
"㾿":"lang2",
"㿃":"dai4",
"㿄":"ai4",
"㿅":"xian3",
"㿇":"xi2",
"㿉":"tui2",
"㿊":"can3",
"㿋":"sao4",
"㿍":"jie4",
"㿎":"fen4",
"㿏":"qun2",
"㿑":"yao4",
"㿒":"dao3",
"㿓":"jia2",
"㿔":"lei3",
"㿕":"yan2",
"㿖":"lu2",
"㿗":"tui2",
"㿘":"ying2",
"㿙":"pi4",
"㿚":"luo4",
"㿛":"li2",
"㿜":"bie3",
"㿞":"mao4",
"㿟":"bai2",
"㿢":"yao4",
"㿣":"he2",
"㿤":"chun3",
"㿥":"hu2",
"㿦":"ning4",
"㿧":"chou2",
"㿨":"li4",
"㿩":"tang3",
"㿪":"huan2",
"㿫":"bi4",
"㿭":"che4",
"㿮":"yang4",
"㿯":"da2",
"㿰":"ao2",
"㿱":"xue2",
"㿵":"ran3",
"㿷":"zao4",
"㿸":"wan3",
"㿹":"ta4",
"㿺":"bao2",
"㿼":"yan2",
"㿾":"zhu4",
"㿿":"ya3",
"䀀":"fan2",
"䀁":"you4",
"䀃":"tui2",
"䀄":"meng2",
"䀅":"she4",
"䀆":"jin4",
"䀇":"gu3",
"䀈":"qi4",
"䀉":"qiao2",
"䀊":"jiao3",
"䀋":"yan2",
"䀍":"kan4",
"䀎":"mian3",
"䀏":"xian4",
"䀐":"san3",
"䀑":"na4",
"䀓":"huan4",
"䀔":"niu2",
"䀕":"cheng4",
"䀗":"jue2",
"䀘":"xi2",
"䀙":"qi4",
"䀚":"ang2",
"䀛":"mei4",
"䀜":"gu3",
"䀟":"fan2",
"䀠":"qu2",
"䀡":"chan4",
"䀢":"shun4",
"䀣":"bi4",
"䀤":"mao4",
"䀥":"shuo4",
"䀦":"gu3",
"䀧":"hong3",
"䀨":"huan4",
"䀩":"luo4",
"䀪":"hang2",
"䀫":"jia2",
"䀬":"quan2",
"䀮":"mang2",
"䀯":"bu3",
"䀰":"gu3",
"䀲":"mu4",
"䀳":"ai4",
"䀴":"ying3",
"䀵":"shun4",
"䀶":"lang3",
"䀷":"jie2",
"䀸":"di4",
"䀹":"jia2",
"䀻":"pin4",
"䀼":"ren4",
"䀽":"yan2",
"䀾":"du3",
"䀿":"di4",
"䁁":"lang3",
"䁂":"xian4",
"䁄":"xing4",
"䁅":"bei4",
"䁆":"an3",
"䁇":"mi4",
"䁈":"qi4",
"䁉":"qi4",
"䁊":"wo4",
"䁋":"she2",
"䁌":"yu4",
"䁍":"jia4",
"䁎":"cheng2",
"䁏":"yao3",
"䁐":"ying4",
"䁑":"yang2",
"䁒":"ji2",
"䁓":"jie4",
"䁔":"han4",
"䁕":"min2",
"䁖":"lou1",
"䁗":"kai3",
"䁘":"yao3",
"䁙":"yan3",
"䁚":"sun3",
"䁛":"gui3",
"䁜":"huang3",
"䁝":"ying2",
"䁞":"sheng3",
"䁟":"cha2",
"䁠":"lian2",
"䁢":"xuan2",
"䁣":"chuan2",
"䁤":"che4",
"䁥":"ni4",
"䁦":"qu4",
"䁧":"miao2",
"䁨":"huo4",
"䁩":"yu2",
"䁪":"nan3",
"䁫":"hu2",
"䁬":"ceng2",
"䁮":"qian2",
"䁯":"she4",
"䁰":"jiang3",
"䁱":"ao4",
"䁲":"mai2",
"䁳":"mang3",
"䁴":"zhan3",
"䁵":"bian3",
"䁶":"jiao3",
"䁷":"jue2",
"䁸":"nong2",
"䁹":"bi4",
"䁺":"shi4",
"䁻":"li4",
"䁼":"mo4",
"䁽":"lie4",
"䁾":"mie4",
"䁿":"mo4",
"䂀":"xi1",
"䂁":"chan2",
"䂂":"qu2",
"䂃":"jiao4",
"䂄":"huo4",
"䂆":"xu4",
"䂇":"nang2",
"䂈":"tong2",
"䂉":"hou2",
"䂊":"yu4",
"䂍":"bo2",
"䂎":"zuan3",
"䂐":"chuo4",
"䂒":"jie2",
"䂔":"xing4",
"䂕":"hui4",
"䂖":"shi2",
"䂚":"yao2",
"䂛":"yu2",
"䂜":"bang4",
"䂝":"jie2",
"䂞":"zhe4",
"䂠":"she2",
"䂡":"di3",
"䂢":"dong3",
"䂣":"ci2",
"䂤":"fu4",
"䂥":"min2",
"䂦":"zhen3",
"䂧":"zhen3",
"䂩":"yan4",
"䂪":"diao4",
"䂫":"hong2",
"䂬":"gong3",
"䂮":"lve4",
"䂯":"guai4",
"䂰":"la4",
"䂱":"cui4",
"䂲":"fa3",
"䂳":"cuo3",
"䂴":"yan2",
"䂶":"jie2",
"䂸":"guo2",
"䂹":"suo3",
"䂺":"wan3",
"䂻":"zheng4",
"䂼":"nie4",
"䂽":"diao4",
"䂾":"lai3",
"䂿":"ta4",
"䃀":"cui4",
"䃂":"gun3",
"䃇":"mian2",
"䃉":"min2",
"䃊":"ju3",
"䃋":"yu2",
"䃍":"zhao4",
"䃎":"ze2",
"䃑":"pan2",
"䃒":"he2",
"䃓":"gou4",
"䃔":"hong2",
"䃕":"lao2",
"䃖":"wu4",
"䃗":"chuo4",
"䃙":"lu4",
"䃚":"cu4",
"䃛":"lian2",
"䃝":"qiao4",
"䃞":"shu2",
"䃡":"cen2",
"䃣":"hui3",
"䃤":"su4",
"䃥":"chuang2",
"䃧":"long2",
"䃩":"nao2",
"䃪":"tan2",
"䃫":"dan3",
"䃬":"wei3",
"䃭":"gan3",
"䃮":"da2",
"䃯":"li4",
"䃱":"xian4",
"䃲":"pan2",
"䃳":"la4",
"䃵":"niao3",
"䃶":"huai2",
"䃷":"ying2",
"䃸":"xian4",
"䃹":"lan4",
"䃺":"mo2",
"䃻":"ba4",
"䃽":"fu2",
"䃾":"bi3",
"䄀":"huo4",
"䄁":"yi4",
"䄂":"liu4",
"䄅":"juan4",
"䄆":"huo2",
"䄇":"cheng2",
"䄈":"dou4",
"䄉":"e2",
"䄋":"yan3",
"䄌":"zhui4",
"䄍":"du4",
"䄎":"qi3",
"䄏":"yu2",
"䄐":"quan4",
"䄑":"huo2",
"䄒":"nie4",
"䄓":"heng2",
"䄔":"ju3",
"䄕":"she4",
"䄘":"peng2",
"䄙":"ming2",
"䄚":"cao2",
"䄛":"lou2",
"䄜":"li2",
"䄝":"chun3",
"䄟":"cui4",
"䄠":"shan4",
"䄢":"qi2",
"䄤":"lai4",
"䄥":"ling2",
"䄦":"liao3",
"䄧":"reng2",
"䄨":"yu2",
"䄩":"nao2",
"䄪":"chuo4",
"䄫":"qi3",
"䄬":"yi2",
"䄭":"nian2",
"䄯":"jian3",
"䄰":"ya2",
"䄲":"chui2",
"䄶":"bi4",
"䄷":"dan4",
"䄸":"po4",
"䄹":"nian2",
"䄺":"zhi4",
"䄻":"chao2",
"䄼":"tian3",
"䄽":"tian3",
"䄾":"rou4",
"䄿":"yi4",
"䅀":"lie4",
"䅁":"an4",
"䅂":"he2",
"䅃":"qiong2",
"䅄":"li4",
"䅆":"zi4",
"䅇":"su4",
"䅈":"yuan4",
"䅉":"ya4",
"䅊":"du4",
"䅋":"wan3",
"䅍":"dong4",
"䅎":"you3",
"䅏":"hui4",
"䅐":"jian3",
"䅑":"rui2",
"䅒":"mang2",
"䅓":"ju3",
"䅖":"an3",
"䅗":"sui4",
"䅘":"lai2",
"䅙":"hun4",
"䅚":"qiang3",
"䅜":"duo4",
"䅞":"na4",
"䅟":"can3",
"䅠":"ti2",
"䅡":"xu3",
"䅢":"jiu4",
"䅣":"huang2",
"䅤":"qi4",
"䅥":"jie2",
"䅦":"mao2",
"䅧":"yan4",
"䅩":"zhi3",
"䅪":"tui2",
"䅬":"ai4",
"䅭":"pang2",
"䅮":"cang4",
"䅯":"tang2",
"䅰":"en3",
"䅱":"hun4",
"䅲":"qi2",
"䅳":"chu2",
"䅴":"suo3",
"䅵":"zhuo2",
"䅶":"nou4",
"䅷":"tu2",
"䅸":"zu2",
"䅹":"lou2",
"䅺":"miao3",
"䅻":"li2",
"䅼":"man2",
"䅽":"gu3",
"䅾":"cen2",
"䅿":"hua2",
"䆀":"mei3",
"䆂":"lian2",
"䆃":"dao3",
"䆄":"shan4",
"䆅":"ci2",
"䆈":"zhi4",
"䆉":"ba4",
"䆊":"cui4",
"䆋":"qiu1",
"䆍":"long2",
"䆏":"fei4",
"䆐":"guo2",
"䆑":"cheng2",
"䆒":"jiu4",
"䆓":"e4",
"䆕":"jue2",
"䆖":"hong2",
"䆗":"jiao4",
"䆘":"cuan2",
"䆙":"yao2",
"䆚":"tong2",
"䆛":"cha2",
"䆜":"you4",
"䆝":"shu4",
"䆞":"yao3",
"䆟":"ge2",
"䆠":"huan4",
"䆡":"lang2",
"䆢":"jue2",
"䆣":"chen2",
"䆦":"shen4",
"䆨":"ming2",
"䆩":"ming2",
"䆫":"chuang1",
"䆬":"yun3",
"䆮":"jin4",
"䆯":"chuo4",
"䆱":"tan3",
"䆳":"qiong2",
"䆵":"cheng2",
"䆷":"yu4",
"䆸":"cheng2",
"䆹":"tong3",
"䆻":"qiao4",
"䆽":"ju4",
"䆾":"lan2",
"䆿":"yi4",
"䇀":"rong2",
"䇃":"si4",
"䇅":"fa2",
"䇇":"meng2",
"䇈":"gui4",
"䇋":"hai4",
"䇌":"qiao4",
"䇍":"chuo4",
"䇎":"que4",
"䇏":"dui4",
"䇐":"li4",
"䇑":"ba4",
"䇒":"jie4",
"䇔":"luo4",
"䇖":"yun3",
"䇘":"hu4",
"䇙":"yin3",
"䇛":"zhi3",
"䇜":"lian3",
"䇞":"gan3",
"䇟":"jian4",
"䇠":"zhou4",
"䇡":"zhu4",
"䇢":"ku3",
"䇣":"na4",
"䇤":"dui4",
"䇥":"ze2",
"䇦":"yang3",
"䇧":"zhu4",
"䇨":"gong4",
"䇩":"yi4",
"䇬":"chuang3",
"䇭":"lao3",
"䇮":"ren4",
"䇯":"rong2",
"䇱":"na4",
"䇲":"jia1",
"䇵":"yi2",
"䇶":"jue2",
"䇷":"bi3",
"䇸":"cheng2",
"䇹":"jun4",
"䇺":"chou2",
"䇻":"hui4",
"䇼":"chi4",
"䇽":"zhi4",
"䇾":"yan2",
"䈁":"lun2",
"䈂":"bing4",
"䈃":"zhao3",
"䈄":"han2",
"䈅":"yu4",
"䈆":"dai4",
"䈇":"zhao4",
"䈈":"fei2",
"䈉":"sha4",
"䈊":"ling2",
"䈋":"ta4",
"䈍":"mang2",
"䈎":"ye4",
"䈏":"bao2",
"䈐":"kui4",
"䈑":"gua3",
"䈒":"nan3",
"䈓":"ge2",
"䈕":"chi2",
"䈗":"suo3",
"䈘":"ci2",
"䈙":"zhou4",
"䈚":"tai2",
"䈛":"kuai4",
"䈜":"qin4",
"䈞":"du3",
"䈟":"ce4",
"䈠":"huan3",
"䈢":"sai3",
"䈣":"zheng4",
"䈤":"qian2",
"䈧":"wei3",
"䈪":"xi4",
"䈫":"na4",
"䈬":"pu2",
"䈭":"huai2",
"䈮":"ju3",
"䈲":"pan2",
"䈳":"ta4",
"䈴":"qian4",
"䈶":"rong2",
"䈷":"luo4",
"䈸":"hu2",
"䈹":"sou3",
"䈻":"pu2",
"䈼":"mie4",
"䈾":"shuo4",
"䈿":"mai4",
"䉀":"shu4",
"䉁":"ling2",
"䉂":"lei3",
"䉃":"jiang3",
"䉄":"leng2",
"䉅":"zhi4",
"䉆":"diao3",
"䉈":"san3",
"䉉":"hu2",
"䉊":"fan4",
"䉋":"mei4",
"䉌":"sui4",
"䉍":"jian3",
"䉎":"tang2",
"䉏":"xie4",
"䉑":"mo2",
"䉒":"fan2",
"䉓":"lei2",
"䉕":"ceng2",
"䉖":"ling2",
"䉘":"cong2",
"䉙":"yun2",
"䉚":"meng2",
"䉛":"yu4",
"䉜":"zhi4",
"䉝":"qi3",
"䉞":"dan3",
"䉟":"huo4",
"䉠":"wei2",
"䉡":"tan2",
"䉢":"se4",
"䉣":"xie4",
"䉤":"sou3",
"䉥":"song3",
"䉧":"liu2",
"䉨":"yi4",
"䉪":"lei4",
"䉫":"li2",
"䉬":"fei4",
"䉭":"lie4",
"䉮":"lin4",
"䉯":"xian4",
"䉰":"yao2",
"䉲":"bie4",
"䉳":"xian3",
"䉴":"rang2",
"䉵":"zhuan4",
"䉷":"dan4",
"䉸":"bian4",
"䉹":"ling2",
"䉺":"hong2",
"䉻":"qi2",
"䉼":"liao4",
"䉽":"ban3",
"䉾":"mi4",
"䉿":"hu2",
"䊀":"hu2",
"䊂":"ce4",
"䊃":"pei4",
"䊄":"qiong2",
"䊅":"ming2",
"䊆":"jiu4",
"䊇":"bu4",
"䊈":"mei2",
"䊉":"san3",
"䊊":"mei4",
"䊍":"li2",
"䊎":"quan3",
"䊐":"en4",
"䊑":"xiang3",
"䊓":"shi4",
"䊖":"lan3",
"䊗":"huang2",
"䊘":"jiu4",
"䊙":"yan2",
"䊛":"sa3",
"䊜":"tuan2",
"䊝":"xie4",
"䊞":"zhe2",
"䊟":"men2",
"䊠":"xi4",
"䊡":"man2",
"䊣":"huang2",
"䊤":"tan2",
"䊥":"xiao4",
"䊦":"ya2",
"䊧":"bi4",
"䊨":"luo2",
"䊩":"fan2",
"䊪":"li4",
"䊫":"cui3",
"䊬":"cha4",
"䊭":"chou2",
"䊮":"di2",
"䊯":"kuang4",
"䊰":"chu3",
"䊲":"chan3",
"䊳":"mi2",
"䊴":"qian4",
"䊵":"qiu2",
"䊶":"zhen4",
"䊺":"gu3",
"䊻":"yan3",
"䊼":"chi3",
"䊽":"guai4",
"䊾":"mu4",
"䊿":"bo2",
"䋀":"kua4",
"䋁":"geng3",
"䋂":"yao2",
"䋃":"mao4",
"䋄":"wang3",
"䋈":"ru2",
"䋉":"jue2",
"䋋":"min2",
"䋌":"jiang3",
"䋎":"zhan4",
"䋏":"zuo4",
"䋐":"yue4",
"䋑":"bing3",
"䋓":"zhou4",
"䋔":"bi4",
"䋕":"ren4",
"䋖":"yu4",
"䋘":"chuo4",
"䋙":"er3",
"䋚":"yi4",
"䋛":"mi2",
"䋜":"qing4",
"䋞":"wang3",
"䋟":"ji4",
"䋠":"bu3",
"䋢":"bie4",
"䋣":"fan2",
"䋤":"yao4",
"䋥":"li2",
"䋦":"fan2",
"䋧":"qu2",
"䋨":"fu3",
"䋩":"er2",
"䋭":"huo4",
"䋮":"jin4",
"䋯":"qi3",
"䋰":"ju2",
"䋱":"lai2",
"䋲":"che3",
"䋳":"bei4",
"䋴":"niu4",
"䋵":"yi4",
"䋶":"xu4",
"䋷":"liu2",
"䋸":"xun2",
"䋹":"fu2",
"䋻":"nin2",
"䋼":"ting3",
"䋽":"beng3",
"䋾":"zha3",
"䌂":"ou4",
"䌃":"shuo4",
"䌄":"geng3",
"䌅":"tang2",
"䌆":"gui4",
"䌇":"hui4",
"䌈":"ta4",
"䌊":"yao2",
"䌌":"qi4",
"䌍":"han4",
"䌎":"lve4",
"䌏":"mi4",
"䌐":"mi4",
"䌒":"lu4",
"䌓":"fan2",
"䌔":"ou4",
"䌕":"mi2",
"䌖":"jie2",
"䌗":"fu3",
"䌘":"mi2",
"䌙":"huang3",
"䌚":"su4",
"䌛":"yao2",
"䌜":"nie4",
"䌝":"jin4",
"䌞":"lian3",
"䌟":"bi4",
"䌠":"qing4",
"䌡":"ti3",
"䌢":"ling2",
"䌣":"zuan3",
"䌤":"zhi3",
"䌥":"yin3",
"䌦":"dao3",
"䌧":"chou2",
"䌨":"cai4",
"䌩":"mi4",
"䌪":"yan2",
"䌫":"lan3",
"䌬":"chong2",
"䌯":"guan4",
"䌰":"she4",
"䌱":"luo4",
"䌴":"luo4",
"䌵":"zhu2",
"䌷":"chou2",
"䌸":"zhuan4",
"䌹":"jiong3",
"䌺":"er3",
"䌻":"yi4",
"䌼":"rui4",
"䌽":"cai3",
"䌾":"ren2",
"䌿":"fu2",
"䍀":"lan2",
"䍁":"sui4",
"䍂":"yu2",
"䍃":"yao2",
"䍄":"dian3",
"䍅":"ling2",
"䍆":"zhu4",
"䍇":"ta4",
"䍈":"ping2",
"䍉":"qian2",
"䍊":"jue2",
"䍋":"chui2",
"䍌":"bu4",
"䍍":"gu3",
"䍎":"cun4",
"䍐":"han3",
"䍑":"han3",
"䍒":"mou3",
"䍓":"hu4",
"䍔":"hong2",
"䍕":"di3",
"䍖":"fu2",
"䍗":"xuan4",
"䍘":"mi2",
"䍙":"mei2",
"䍚":"lang4",
"䍛":"gu4",
"䍜":"zhao4",
"䍝":"ta4",
"䍞":"yu4",
"䍟":"zong4",
"䍠":"li2",
"䍡":"liao4",
"䍢":"wu2",
"䍣":"lei2",
"䍤":"ji3",
"䍥":"lei4",
"䍦":"li2",
"䍨":"bo2",
"䍩":"ang3",
"䍪":"kui4",
"䍫":"tuo2",
"䍮":"zhao4",
"䍯":"gui3",
"䍱":"xu2",
"䍲":"nai2",
"䍳":"chuo4",
"䍴":"duo4",
"䍶":"dong4",
"䍷":"gui4",
"䍸":"bo2",
"䍺":"huan2",
"䍻":"xuan3",
"䍼":"can2",
"䍽":"li4",
"䍾":"tui2",
"䍿":"huang2",
"䎀":"xue4",
"䎁":"hu2",
"䎂":"bao3",
"䎃":"ran3",
"䎄":"tiao2",
"䎅":"fu4",
"䎆":"liao4",
"䎈":"yi4",
"䎉":"shu4",
"䎊":"po4",
"䎋":"he4",
"䎌":"cu4",
"䎎":"na4",
"䎏":"an4",
"䎐":"chao3",
"䎑":"lu4",
"䎒":"zhan3",
"䎓":"ta4",
"䎗":"qiao2",
"䎘":"su4",
"䎚":"guan4",
"䎝":"chu2",
"䎟":"er2",
"䎠":"er2",
"䎡":"nuan3",
"䎢":"qi3",
"䎣":"si4",
"䎤":"chu2",
"䎦":"yan3",
"䎧":"bang4",
"䎨":"an4",
"䎪":"ne4",
"䎫":"chuang4",
"䎬":"ba4",
"䎮":"ti4",
"䎯":"han4",
"䎰":"zuo2",
"䎱":"ba4",
"䎲":"zhe2",
"䎳":"wa4",
"䎴":"sheng4",
"䎵":"bi4",
"䎶":"er4",
"䎷":"zhu4",
"䎸":"wu4",
"䎹":"wen2",
"䎺":"zhi3",
"䎻":"zhou3",
"䎼":"lu4",
"䎽":"wen2",
"䎾":"gun3",
"䎿":"qiu2",
"䏀":"la4",
"䏁":"zai3",
"䏂":"sou3",
"䏃":"mian2",
"䏄":"zhi4",
"䏅":"qi4",
"䏆":"cao2",
"䏇":"piao4",
"䏈":"lian2",
"䏊":"long2",
"䏋":"su4",
"䏌":"qi4",
"䏍":"yuan4",
"䏎":"feng2",
"䏐":"jue2",
"䏑":"di4",
"䏒":"pian4",
"䏓":"guan3",
"䏔":"niu3",
"䏕":"ren3",
"䏖":"zhen4",
"䏗":"gai4",
"䏘":"pi3",
"䏙":"tan3",
"䏚":"chao3",
"䏛":"chun3",
"䏝":"chun2",
"䏞":"mo4",
"䏟":"bie4",
"䏠":"qi4",
"䏡":"shi4",
"䏢":"bi3",
"䏣":"jue2",
"䏤":"si4",
"䏦":"hua2",
"䏧":"na2",
"䏨":"hui3",
"䏪":"er4",
"䏬":"mou2",
"䏮":"xi2",
"䏯":"zhi4",
"䏰":"ren3",
"䏱":"ju2",
"䏲":"die2",
"䏳":"zhe4",
"䏴":"shao4",
"䏵":"meng3",
"䏶":"bi4",
"䏷":"han4",
"䏸":"yu2",
"䏹":"xian4",
"䏻":"neng2",
"䏼":"can2",
"䏽":"bu4",
"䏿":"qi3",
"䐀":"ji4",
"䐁":"niao3",
"䐂":"lu4",
"䐃":"jiong3",
"䐄":"han4",
"䐅":"yi2",
"䐆":"cai3",
"䐇":"chun2",
"䐈":"zhi2",
"䐉":"zi4",
"䐊":"da2",
"䐌":"tian3",
"䐍":"zhou4",
"䐏":"chun3",
"䐑":"zhe2",
"䐓":"rou2",
"䐔":"bin4",
"䐕":"ji2",
"䐖":"yi2",
"䐗":"du3",
"䐘":"jue2",
"䐙":"ge2",
"䐚":"ji2",
"䐝":"suo3",
"䐞":"ruo4",
"䐟":"xiang4",
"䐠":"huang3",
"䐡":"qi2",
"䐢":"zhu4",
"䐣":"cuo4",
"䐤":"chi2",
"䐥":"weng3",
"䐧":"kao4",
"䐨":"gu3",
"䐩":"kai3",
"䐪":"fan4",
"䐬":"cao2",
"䐭":"zhi4",
"䐮":"chan3",
"䐯":"lei2",
"䐲":"zhe2",
"䐳":"yu2",
"䐴":"gui4",
"䐵":"huang2",
"䐶":"jin3",
"䐸":"guo2",
"䐹":"sao4",
"䐺":"tan4",
"䐼":"xi4",
"䐽":"man2",
"䐾":"duo2",
"䐿":"ao2",
"䑀":"pi4",
"䑁":"wu4",
"䑂":"ai3",
"䑃":"meng2",
"䑄":"pi4",
"䑅":"meng2",
"䑆":"yang3",
"䑇":"zhi4",
"䑈":"bo2",
"䑉":"ying2",
"䑊":"wei2",
"䑋":"nao2",
"䑌":"lan2",
"䑍":"yan4",
"䑎":"chan3",
"䑏":"quan2",
"䑐":"zhen3",
"䑑":"pu2",
"䑓":"tai2",
"䑔":"fei4",
"䑕":"shu3",
"䑗":"dang4",
"䑘":"cha2",
"䑙":"ran2",
"䑚":"tian2",
"䑛":"chi3",
"䑜":"ta4",
"䑝":"jia3",
"䑞":"shun4",
"䑟":"huang2",
"䑠":"liao3",
"䑤":"jin4",
"䑥":"e4",
"䑧":"fu2",
"䑨":"duo4",
"䑪":"e4",
"䑬":"yao4",
"䑭":"di4",
"䑯":"di4",
"䑰":"bu4",
"䑱":"man2",
"䑲":"che4",
"䑳":"lun2",
"䑴":"qi2",
"䑵":"mu4",
"䑶":"can2",
"䑻":"you2",
"䑽":"da2",
"䑿":"su4",
"䒀":"fu2",
"䒁":"ji4",
"䒂":"jiang3",
"䒃":"cao4",
"䒄":"bo2",
"䒅":"teng2",
"䒆":"che4",
"䒇":"fu4",
"䒈":"bu3",
"䒉":"wu3",
"䒋":"yang3",
"䒌":"ming4",
"䒍":"pang3",
"䒎":"mang3",
"䒐":"meng2",
"䒑":"cao3",
"䒒":"tiao2",
"䒓":"kai3",
"䒔":"bai4",
"䒕":"xiao3",
"䒖":"xin4",
"䒗":"qi4",
"䒚":"shao3",
"䒛":"heng2",
"䒜":"niu2",
"䒝":"xiao2",
"䒞":"chen2",
"䒠":"fan3",
"䒡":"yin3",
"䒢":"ang2",
"䒣":"ran3",
"䒤":"ri4",
"䒥":"fa4",
"䒦":"fan4",
"䒧":"qu4",
"䒨":"shi3",
"䒩":"he2",
"䒪":"bian4",
"䒫":"dai4",
"䒬":"mo4",
"䒭":"deng3",
"䒲":"cha4",
"䒳":"duo3",
"䒴":"you3",
"䒵":"hao4",
"䒸":"xian2",
"䒹":"lei4",
"䒺":"jin3",
"䒻":"qi3",
"䒽":"mei2",
"䓂":"yan2",
"䓃":"yi4",
"䓄":"yin2",
"䓅":"qi2",
"䓆":"zhe2",
"䓇":"xi4",
"䓈":"yi4",
"䓉":"ye2",
"䓊":"e4",
"䓌":"zhi4",
"䓍":"han3",
"䓎":"chuo4",
"䓐":"chun2",
"䓑":"bing3",
"䓒":"kuai3",
"䓓":"chou2",
"䓕":"tuo3",
"䓖":"qiong2",
"䓘":"jiu4",
"䓚":"cu2",
"䓛":"fu3",
"䓝":"meng2",
"䓞":"li4",
"䓟":"lie4",
"䓠":"ta4",
"䓢":"gu4",
"䓣":"liang3",
"䓥":"la4",
"䓦":"dian3",
"䓧":"ci4",
"䓫":"ji4",
"䓭":"cha4",
"䓮":"mao4",
"䓯":"du2",
"䓱":"chai2",
"䓲":"rui4",
"䓳":"hen3",
"䓴":"ruan2",
"䓶":"lai4",
"䓷":"xing4",
"䓹":"yi4",
"䓺":"mei3",
"䓼":"he4",
"䓽":"ji4",
"䓿":"han3",
"䔁":"li4",
"䔂":"zi3",
"䔃":"zu3",
"䔄":"yao2",
"䔆":"li2",
"䔇":"qi3",
"䔈":"gan3",
"䔉":"li4",
"䔎":"su4",
"䔏":"chou4",
"䔑":"xie2",
"䔒":"bei4",
"䔓":"xu3",
"䔔":"jing4",
"䔕":"pu2",
"䔖":"ling2",
"䔗":"xiang2",
"䔘":"zuo4",
"䔙":"diao4",
"䔚":"chun2",
"䔛":"qing3",
"䔜":"nan2",
"䔞":"lv4",
"䔟":"chi2",
"䔠":"shao3",
"䔡":"yu2",
"䔢":"hua2",
"䔣":"li2",
"䔧":"li2",
"䔪":"dui4",
"䔬":"yi4",
"䔭":"ning4",
"䔯":"hu2",
"䔰":"fu2",
"䔲":"cheng2",
"䔳":"nan3",
"䔴":"ce4",
"䔶":"ti2",
"䔷":"qin2",
"䔸":"biao3",
"䔹":"sui4",
"䔺":"wei2",
"䔼":"se4",
"䔽":"ai4",
"䔾":"e4",
"䔿":"jie4",
"䕀":"kuan3",
"䕁":"fei3",
"䕃":"yin4",
"䕅":"sao3",
"䕆":"dou4",
"䕇":"hui4",
"䕈":"xie4",
"䕉":"ze2",
"䕊":"tan2",
"䕋":"chang3",
"䕌":"zhi4",
"䕍":"yi4",
"䕎":"fu2",
"䕏":"e2",
"䕑":"jun4",
"䕓":"cha2",
"䕔":"xian2",
"䕕":"man4",
"䕗":"bi4",
"䕘":"ling2",
"䕙":"jie2",
"䕚":"kui4",
"䕛":"jia2",
"䕞":"lang4",
"䕠":"fei4",
"䕡":"lu3",
"䕢":"zha3",
"䕣":"he2",
"䕥":"ni3",
"䕦":"ying2",
"䕧":"xiao4",
"䕨":"teng2",
"䕩":"lao3",
"䕪":"ze2",
"䕫":"kui2",
"䕭":"qian2",
"䕮":"ju2",
"䕯":"piao2",
"䕰":"ban4",
"䕱":"dou3",
"䕲":"lin3",
"䕳":"mi2",
"䕴":"zhuo2",
"䕵":"xie2",
"䕶":"hu4",
"䕷":"mi2",
"䕹":"za2",
"䕺":"cong2",
"䕻":"ge2",
"䕼":"nan2",
"䕽":"zhu2",
"䕾":"yan2",
"䕿":"han4",
"䖁":"yi4",
"䖂":"luan2",
"䖃":"yue4",
"䖄":"ran2",
"䖅":"ling2",
"䖆":"niang4",
"䖇":"yu4",
"䖈":"nve4",
"䖊":"yi2",
"䖋":"nve4",
"䖌":"qin2",
"䖍":"qian2",
"䖎":"xia2",
"䖏":"chu3",
"䖐":"jin4",
"䖑":"mi4",
"䖓":"na4",
"䖔":"han4",
"䖕":"zu3",
"䖖":"xia2",
"䖗":"yan2",
"䖘":"tu2",
"䖛":"suo3",
"䖜":"yin2",
"䖝":"chong2",
"䖞":"zhou3",
"䖟":"mang3",
"䖠":"yuan2",
"䖡":"nv4",
"䖢":"miao2",
"䖣":"sao4",
"䖤":"wan3",
"䖥":"li2",
"䖧":"na4",
"䖨":"shi2",
"䖩":"bi4",
"䖪":"ci2",
"䖫":"bang4",
"䖭":"juan4",
"䖮":"xiang3",
"䖯":"gui4",
"䖰":"pai4",
"䖲":"xun2",
"䖳":"zha4",
"䖴":"yao2",
"䖸":"e2",
"䖹":"yang2",
"䖺":"tiao2",
"䖻":"you2",
"䖼":"jue2",
"䖽":"li2",
"䖿":"li2",
"䗁":"ji4",
"䗂":"hu3",
"䗃":"zhan4",
"䗄":"fu3",
"䗅":"chang2",
"䗆":"guan3",
"䗇":"ju2",
"䗈":"meng2",
"䗊":"cheng2",
"䗋":"mou2",
"䗍":"li3",
"䗑":"yi4",
"䗒":"bing4",
"䗔":"hou2",
"䗕":"wan3",
"䗖":"chi4",
"䗘":"ge2",
"䗙":"han2",
"䗚":"bo2",
"䗜":"liu2",
"䗝":"can2",
"䗞":"can2",
"䗟":"yi4",
"䗠":"xuan2",
"䗡":"yan2",
"䗢":"suo3",
"䗣":"gao3",
"䗤":"yong2",
"䗨":"yu2",
"䗪":"zhe4",
"䗫":"ma2",
"䗮":"shuang3",
"䗯":"jin4",
"䗰":"guan4",
"䗱":"pu2",
"䗲":"lin4",
"䗴":"ting2",
"䗶":"la4",
"䗷":"yi4",
"䗹":"ci4",
"䗺":"yan3",
"䗻":"jie2",
"䗽":"wei4",
"䗾":"xian3",
"䗿":"ning2",
"䘀":"fu4",
"䘁":"ge2",
"䘃":"mo4",
"䘄":"fu4",
"䘅":"nai2",
"䘆":"xian3",
"䘇":"wen2",
"䘈":"li4",
"䘉":"can2",
"䘊":"mie4",
"䘌":"ni4",
"䘍":"chai4",
"䘏":"xu4",
"䘐":"nv4",
"䘑":"mai4",
"䘓":"kan4",
"䘕":"hang2",
"䘘":"yu4",
"䘙":"wei4",
"䘚":"zhu2",
"䘝":"yi4",
"䘠":"fu2",
"䘡":"bi3",
"䘢":"zhu3",
"䘣":"zi3",
"䘤":"shu4",
"䘥":"xia2",
"䘦":"ni2",
"䘨":"jiao3",
"䘩":"xuan4",
"䘫":"nou4",
"䘬":"rong2",
"䘭":"die2",
"䘮":"sa4",
"䘱":"yu4",
"䘵":"lu4",
"䘶":"han4",
"䘸":"yi4",
"䘹":"zui4",
"䘺":"zhan4",
"䘻":"su4",
"䘼":"wan3",
"䘽":"ni2",
"䘾":"guan3",
"䘿":"jue2",
"䙀":"beng3",
"䙁":"can2",
"䙃":"duo4",
"䙄":"qi4",
"䙅":"yao4",
"䙆":"gui4",
"䙇":"nuan3",
"䙈":"hou2",
"䙉":"xun2",
"䙊":"xie4",
"䙌":"hui4",
"䙎":"xie2",
"䙏":"bo2",
"䙐":"ke4",
"䙒":"xu4",
"䙓":"bai3",
"䙕":"chu4",
"䙗":"ti4",
"䙘":"chu3",
"䙙":"chi2",
"䙚":"niao3",
"䙛":"guan4",
"䙜":"feng2",
"䙝":"xie4",
"䙟":"duo4",
"䙠":"jue2",
"䙡":"hui4",
"䙢":"zeng4",
"䙣":"sa4",
"䙤":"duo3",
"䙥":"ling2",
"䙦":"meng2",
"䙨":"guo3",
"䙩":"meng2",
"䙪":"long2",
"䙬":"ying4",
"䙮":"guan4",
"䙯":"cu4",
"䙰":"li2",
"䙱":"du2",
"䙳":"e4",
"䙷":"de2",
"䙸":"de2",
"䙹":"jiang3",
"䙺":"lian2",
"䙼":"shao4",
"䙽":"xi4",
"䙿":"wei4",
"䚂":"he4",
"䚃":"you2",
"䚄":"lu4",
"䚅":"lai2",
"䚆":"ou3",
"䚇":"sheng3",
"䚈":"juan4",
"䚉":"qi4",
"䚋":"yun4",
"䚍":"qi4",
"䚏":"leng4",
"䚐":"ji2",
"䚑":"mai2",
"䚒":"chuang2",
"䚓":"nian3",
"䚕":"li4",
"䚖":"ling2",
"䚘":"chen2",
"䚚":"xian3",
"䚛":"hu2",
"䚝":"zu2",
"䚞":"dai3",
"䚟":"dai3",
"䚠":"hun4",
"䚢":"che4",
"䚣":"ti2",
"䚥":"nuo4",
"䚦":"zhi4",
"䚧":"liu2",
"䚨":"fei4",
"䚩":"jiao3",
"䚫":"ao2",
"䚬":"lin2",
"䚮":"reng2",
"䚯":"tao3",
"䚰":"pi3",
"䚱":"xin4",
"䚲":"shan4",
"䚳":"xie4",
"䚴":"wa4",
"䚵":"tao3",
"䚷":"xi4",
"䚸":"xie4",
"䚹":"pi3",
"䚺":"yao2",
"䚻":"yao2",
"䚼":"nv4",
"䚽":"hao4",
"䚾":"nin2",
"䚿":"yin4",
"䛀":"fan3",
"䛁":"nan2",
"䛂":"chi2",
"䛃":"wang4",
"䛄":"yuan3",
"䛅":"xia2",
"䛆":"zhou4",
"䛇":"yuan3",
"䛈":"shi4",
"䛉":"mi4",
"䛋":"ge2",
"䛌":"pao2",
"䛍":"fei4",
"䛎":"hu4",
"䛏":"ni2",
"䛐":"ci2",
"䛑":"mi4",
"䛒":"bian4",
"䛔":"na2",
"䛕":"yu4",
"䛖":"e4",
"䛗":"zhi3",
"䛘":"nin2",
"䛙":"xu4",
"䛚":"lve4",
"䛛":"hui4",
"䛜":"xun4",
"䛝":"nao2",
"䛞":"han3",
"䛟":"jia2",
"䛠":"dou4",
"䛡":"hua4",
"䛤":"cu4",
"䛥":"xi4",
"䛦":"song4",
"䛧":"mi2",
"䛨":"xin4",
"䛩":"wu4",
"䛪":"qiong2",
"䛫":"zheng4",
"䛬":"chou2",
"䛭":"xing4",
"䛮":"jiu4",
"䛯":"ju4",
"䛰":"hun2",
"䛱":"ti2",
"䛲":"man2",
"䛳":"jian3",
"䛴":"qi3",
"䛵":"shou4",
"䛶":"lei3",
"䛷":"wan3",
"䛸":"che4",
"䛹":"can4",
"䛺":"jie4",
"䛻":"you4",
"䛼":"hui3",
"䛽":"zha3",
"䛾":"su4",
"䛿":"ge2",
"䜀":"nao3",
"䜁":"xi4",
"䜄":"chi2",
"䜅":"wei2",
"䜆":"mo4",
"䜇":"gun3",
"䜊":"zao4",
"䜋":"hui4",
"䜌":"luan2",
"䜍":"liao2",
"䜎":"lao2",
"䜑":"qia4",
"䜒":"ao4",
"䜓":"nie4",
"䜔":"sui2",
"䜕":"mai4",
"䜖":"tan4",
"䜗":"xin4",
"䜘":"jing3",
"䜙":"an2",
"䜚":"ta4",
"䜛":"chan2",
"䜜":"wei4",
"䜝":"tuan3",
"䜞":"ji4",
"䜟":"chen2",
"䜠":"che4",
"䜡":"xu4",
"䜢":"xian3",
"䜣":"xin1",
"䜧":"nao3",
"䜩":"yan4",
"䜪":"qiu2",
"䜫":"hong2",
"䜬":"song3",
"䜭":"jun4",
"䜮":"liao2",
"䜯":"ju2",
"䜱":"man3",
"䜲":"lie4",
"䜴":"chu4",
"䜵":"chi3",
"䜶":"xiang2",
"䜸":"mei3",
"䜹":"shu4",
"䜺":"ce4",
"䜻":"chi3",
"䜼":"gu2",
"䜽":"yu2",
"䝀":"liao2",
"䝁":"lao2",
"䝂":"shu4",
"䝃":"zhe2",
"䝈":"e4",
"䝊":"sha4",
"䝋":"zong4",
"䝌":"jue2",
"䝍":"jun4",
"䝏":"lou2",
"䝐":"wei2",
"䝒":"zhu4",
"䝓":"la4",
"䝕":"zhe2",
"䝖":"zhao3",
"䝘":"yi4",
"䝚":"ni2",
"䝝":"yi3",
"䝞":"hao4",
"䝟":"ya4",
"䝠":"huan2",
"䝡":"man4",
"䝢":"man4",
"䝣":"qu2",
"䝤":"lao3",
"䝥":"hao2",
"䝧":"men2",
"䝨":"xian2",
"䝩":"zhen4",
"䝪":"shu2",
"䝫":"zuo2",
"䝬":"zhu4",
"䝭":"gou4",
"䝮":"xuan4",
"䝯":"yi4",
"䝰":"ti2",
"䝲":"jin4",
"䝳":"can2",
"䝵":"bu4",
"䝶":"liang2",
"䝷":"zhi4",
"䝸":"ji4",
"䝹":"wan3",
"䝺":"guan4",
"䝼":"qing2",
"䝽":"ai4",
"䝾":"fu4",
"䝿":"gui4",
"䞀":"gou4",
"䞁":"xian4",
"䞂":"ruan3",
"䞃":"zhi4",
"䞄":"biao4",
"䞅":"yi2",
"䞆":"suo3",
"䞇":"die2",
"䞈":"gui3",
"䞉":"sheng4",
"䞊":"xun4",
"䞋":"chen4",
"䞌":"she2",
"䞍":"qing2",
"䞐":"chun3",
"䞑":"hong2",
"䞒":"dong4",
"䞓":"cheng1",
"䞔":"wei3",
"䞕":"die2",
"䞖":"shu3",
"䞘":"ji2",
"䞙":"za2",
"䞚":"qi2",
"䞜":"fu4",
"䞝":"ao3",
"䞞":"fu2",
"䞟":"po4",
"䞡":"tan3",
"䞢":"zha4",
"䞣":"che3",
"䞤":"qu2",
"䞥":"you4",
"䞦":"he2",
"䞧":"hou4",
"䞨":"gui3",
"䞩":"e4",
"䞪":"jiang4",
"䞫":"yun3",
"䞬":"tou4",
"䞭":"qiu3",
"䞯":"fu4",
"䞰":"zuo2",
"䞱":"hu2",
"䞳":"bo2",
"䞵":"jue3",
"䞶":"di4",
"䞷":"jue2",
"䞸":"fu4",
"䞹":"huang2",
"䞻":"yong3",
"䞼":"chui3",
"䞽":"suo3",
"䞾":"chi2",
"䟂":"man2",
"䟃":"ca4",
"䟄":"qi4",
"䟅":"jian4",
"䟆":"bi4",
"䟈":"zhi2",
"䟉":"zhu2",
"䟊":"qu2",
"䟋":"zhan3",
"䟌":"ji2",
"䟍":"dian2",
"䟏":"li4",
"䟐":"li4",
"䟑":"la3",
"䟒":"quan2",
"䟔":"fu4",
"䟕":"cha4",
"䟖":"tang4",
"䟗":"shi4",
"䟘":"hang4",
"䟙":"qie4",
"䟚":"qi2",
"䟛":"bo2",
"䟜":"na4",
"䟝":"tou4",
"䟞":"chu2",
"䟟":"cu4",
"䟠":"yue4",
"䟡":"di4",
"䟢":"chen2",
"䟣":"chu4",
"䟤":"bi4",
"䟥":"mang2",
"䟦":"ba2",
"䟧":"tian2",
"䟨":"min2",
"䟩":"lie3",
"䟪":"feng3",
"䟬":"qiu4",
"䟭":"tiao2",
"䟮":"fu2",
"䟯":"kuo4",
"䟰":"jian3",
"䟴":"zhen4",
"䟵":"qiu2",
"䟶":"cuo4",
"䟷":"chi4",
"䟸":"kui2",
"䟹":"lie4",
"䟺":"bang3",
"䟻":"du4",
"䟼":"wu3",
"䟾":"jue3",
"䟿":"lu4",
"䠀":"chang3",
"䠂":"chu2",
"䠃":"liang3",
"䠄":"tian3",
"䠅":"kun3",
"䠆":"chang2",
"䠇":"jue2",
"䠈":"tu2",
"䠉":"hua4",
"䠊":"fei4",
"䠋":"bi3",
"䠍":"qia2",
"䠎":"wo4",
"䠏":"ji4",
"䠐":"qu4",
"䠑":"kui3",
"䠒":"hu2",
"䠓":"cu4",
"䠔":"sui4",
"䠗":"qiu4",
"䠘":"pi4",
"䠙":"bei4",
"䠚":"wa4",
"䠛":"jiao3",
"䠜":"rong2",
"䠞":"cu4",
"䠟":"die2",
"䠠":"chi4",
"䠡":"cuo2",
"䠢":"meng4",
"䠣":"xuan3",
"䠤":"duo3",
"䠥":"bie2",
"䠦":"zhe4",
"䠧":"chu2",
"䠨":"chan4",
"䠩":"gui4",
"䠪":"duan4",
"䠫":"zou4",
"䠬":"deng4",
"䠭":"lai2",
"䠮":"teng2",
"䠯":"yue4",
"䠰":"quan2",
"䠱":"shu3",
"䠲":"ling2",
"䠴":"qin3",
"䠵":"fu4",
"䠶":"she4",
"䠷":"tiao3",
"䠹":"ai2",
"䠻":"qiong2",
"䠼":"diao4",
"䠽":"hai2",
"䠾":"shan3",
"䠿":"wai4",
"䡀":"zhan3",
"䡁":"long3",
"䡂":"jiu4",
"䡃":"li4",
"䡅":"min3",
"䡆":"rong2",
"䡇":"yue4",
"䡈":"jue2",
"䡉":"kang3",
"䡊":"fan2",
"䡋":"qi2",
"䡌":"hong2",
"䡍":"fu2",
"䡎":"lu2",
"䡏":"hong2",
"䡐":"tuo2",
"䡑":"min2",
"䡒":"tian2",
"䡓":"juan4",
"䡔":"qi3",
"䡕":"zheng3",
"䡖":"jing4",
"䡗":"gong3",
"䡘":"tian2",
"䡙":"lang2",
"䡚":"mao4",
"䡛":"yin4",
"䡜":"lu4",
"䡝":"yun3",
"䡞":"ju2",
"䡟":"pi4",
"䡡":"xie2",
"䡢":"bian4",
"䡥":"rong2",
"䡦":"sang3",
"䡧":"wu3",
"䡨":"cha4",
"䡩":"gu3",
"䡪":"chan2",
"䡫":"peng2",
"䡬":"man4",
"䡯":"shuang4",
"䡰":"keng3",
"䡱":"zhuan3",
"䡲":"chan2",
"䡴":"chuang2",
"䡵":"sui4",
"䡶":"bei4",
"䡷":"kai4",
"䡹":"zhi4",
"䡺":"wei4",
"䡻":"min2",
"䡼":"ling2",
"䡾":"nei4",
"䡿":"ling2",
"䢀":"qi4",
"䢁":"yue4",
"䢃":"yi4",
"䢄":"xi3",
"䢅":"chen2",
"䢇":"rong3",
"䢈":"chen2",
"䢉":"nong2",
"䢊":"you2",
"䢋":"ji4",
"䢌":"bo2",
"䢍":"fang3",
"䢐":"cu2",
"䢑":"di3",
"䢓":"yu2",
"䢔":"ge2",
"䢕":"xu4",
"䢖":"lv4",
"䢗":"he2",
"䢙":"bai4",
"䢚":"gong4",
"䢛":"jiong3",
"䢝":"ya4",
"䢞":"nu4",
"䢟":"you2",
"䢠":"song4",
"䢡":"xie4",
"䢢":"cang4",
"䢣":"yao2",
"䢤":"shu4",
"䢥":"yan2",
"䢦":"shuai4",
"䢧":"liao4",
"䢩":"yu4",
"䢪":"bo2",
"䢫":"sui2",
"䢭":"yan4",
"䢮":"lei4",
"䢯":"lin2",
"䢰":"tai2",
"䢱":"du2",
"䢲":"yue4",
"䢳":"ji3",
"䢵":"yun2",
"䢹":"ju3",
"䢻":"chen2",
"䢽":"xiang4",
"䢾":"xian3",
"䣀":"gui3",
"䣁":"yu3",
"䣂":"lei3",
"䣄":"tu2",
"䣅":"chen2",
"䣆":"xing2",
"䣇":"qiu2",
"䣈":"hang4",
"䣊":"dang3",
"䣋":"cai3",
"䣌":"di3",
"䣍":"yan3",
"䣑":"chan2",
"䣓":"li2",
"䣔":"suo3",
"䣕":"ma3",
"䣖":"ma3",
"䣘":"tang2",
"䣙":"pei2",
"䣚":"lou2",
"䣜":"cuo2",
"䣝":"tu2",
"䣞":"e4",
"䣟":"can2",
"䣠":"jie2",
"䣡":"ti2",
"䣢":"ji2",
"䣣":"dang3",
"䣤":"jiao4",
"䣥":"bi3",
"䣦":"lei4",
"䣧":"yi4",
"䣨":"chun2",
"䣩":"chun2",
"䣪":"po4",
"䣫":"li2",
"䣬":"zai3",
"䣭":"tai4",
"䣮":"po4",
"䣯":"tian3",
"䣰":"ju4",
"䣱":"xu4",
"䣲":"fan4",
"䣴":"xu4",
"䣵":"er4",
"䣶":"huo2",
"䣸":"ran3",
"䣹":"fa2",
"䣼":"liang2",
"䣽":"ti3",
"䣾":"mi4",
"䤁":"cen2",
"䤂":"mei2",
"䤃":"yin4",
"䤄":"mian3",
"䤅":"tu2",
"䤆":"kui2",
"䤉":"mi4",
"䤊":"rong2",
"䤋":"guo2",
"䤍":"mi2",
"䤎":"ju2",
"䤏":"pi3",
"䤐":"jin3",
"䤑":"wang4",
"䤒":"ji3",
"䤓":"meng2",
"䤔":"jian4",
"䤕":"xue4",
"䤖":"bao4",
"䤗":"gan3",
"䤘":"chan3",
"䤙":"li4",
"䤚":"li3",
"䤛":"qiu2",
"䤜":"dun4",
"䤝":"ying4",
"䤞":"yun3",
"䤟":"chen2",
"䤠":"ji1",
"䤡":"ran3",
"䤣":"lve4",
"䤥":"gui3",
"䤦":"yue4",
"䤧":"hui4",
"䤨":"pi4",
"䤩":"cha2",
"䤪":"duo3",
"䤫":"chan2",
"䤭":"kuan4",
"䤮":"she4",
"䤯":"xing2",
"䤰":"weng3",
"䤱":"shi4",
"䤲":"chi4",
"䤳":"ye4",
"䤴":"han2",
"䤵":"fei4",
"䤶":"ye4",
"䤷":"yan2",
"䤸":"zuan4",
"䤺":"yin3",
"䤻":"duo4",
"䤼":"xian4",
"䤿":"qie4",
"䥀":"chan3",
"䥁":"han2",
"䥂":"meng4",
"䥃":"yue4",
"䥄":"cu4",
"䥅":"qian4",
"䥆":"jin3",
"䥇":"shan4",
"䥈":"mu3",
"䥌":"zheng4",
"䥍":"zhi4",
"䥎":"chun2",
"䥏":"yu3",
"䥐":"mou2",
"䥑":"wan4",
"䥒":"chou2",
"䥔":"su4",
"䥕":"pie3",
"䥖":"tian2",
"䥗":"kuan3",
"䥘":"cu4",
"䥙":"sui4",
"䥛":"jie2",
"䥜":"jian4",
"䥝":"ao2",
"䥞":"jiao3",
"䥟":"ye4",
"䥡":"ye4",
"䥢":"long2",
"䥣":"zao2",
"䥤":"bao2",
"䥥":"lian2",
"䥧":"huan2",
"䥨":"lv4",
"䥩":"wei2",
"䥪":"xian3",
"䥫":"tie3",
"䥬":"bo2",
"䥭":"zheng4",
"䥮":"zhu2",
"䥯":"ba4",
"䥰":"meng4",
"䥱":"xie3",
"䥵":"xiao3",
"䥶":"li4",
"䥷":"zha2",
"䥸":"mi2",
"䥺":"ye2",
"䥾":"xie3",
"䦂":"shan4",
"䦅":"shan4",
"䦆":"jue2",
"䦇":"ji4",
"䦈":"fang3",
"䦊":"niao3",
"䦋":"ao2",
"䦌":"chu4",
"䦍":"wu4",
"䦎":"guan3",
"䦏":"xie4",
"䦐":"ting3",
"䦑":"xie4",
"䦒":"dang4",
"䦔":"tan3",
"䦖":"xia2",
"䦗":"xu4",
"䦘":"bi4",
"䦙":"si4",
"䦚":"huo4",
"䦛":"zheng4",
"䦜":"wu2",
"䦞":"run4",
"䦟":"chuai4",
"䦠":"shi3",
"䦡":"huan2",
"䦢":"kuo4",
"䦣":"fu4",
"䦤":"chuai4",
"䦥":"xian2",
"䦦":"qin2",
"䦧":"qie2",
"䦨":"lan2",
"䦪":"ya4",
"䦬":"que4",
"䦮":"chun3",
"䦯":"zhi4",
"䦱":"kui3",
"䦲":"qian4",
"䦳":"hang4",
"䦴":"yi4",
"䦵":"ni3",
"䦶":"zheng4",
"䦷":"chuai4",
"䦹":"shi2",
"䦻":"ci4",
"䦼":"jue2",
"䦽":"xu4",
"䦾":"yun3",
"䧁":"chu4",
"䧂":"dao4",
"䧃":"dian4",
"䧄":"ge4",
"䧅":"ti4",
"䧆":"hong2",
"䧇":"ni3",
"䧉":"li3",
"䧋":"xian3",
"䧍":"xi4",
"䧎":"xuan4",
"䧒":"lai2",
"䧔":"mu4",
"䧕":"cheng2",
"䧖":"jian4",
"䧗":"bi4",
"䧘":"qi2",
"䧙":"ling2",
"䧚":"hao4",
"䧛":"bang4",
"䧜":"tang2",
"䧝":"di4",
"䧞":"fu4",
"䧟":"xian4",
"䧠":"shuan4",
"䧤":"pu2",
"䧥":"hui4",
"䧦":"wei2",
"䧧":"yi3",
"䧨":"ye4",
"䧪":"che4",
"䧫":"hao2",
"䧮":"xian3",
"䧯":"chan2",
"䧰":"hun4",
"䧲":"han4",
"䧳":"ci2",
"䧵":"qi2",
"䧶":"kui2",
"䧷":"rou2",
"䧺":"xiong2",
"䧼":"hu2",
"䧽":"cui3",
"䧿":"que4",
"䨀":"di2",
"䨁":"che4",
"䨄":"yan4",
"䨅":"liao2",
"䨆":"bi2",
"䨋":"nve4",
"䨌":"bao2",
"䨍":"ying3",
"䨎":"hong2",
"䨏":"ci2",
"䨐":"qia4",
"䨑":"ti2",
"䨒":"yu4",
"䨓":"lei2",
"䨔":"bao2",
"䨖":"ji4",
"䨗":"fu2",
"䨘":"xian4",
"䨙":"cen2",
"䨛":"se4",
"䨞":"yu3",
"䨠":"ai3",
"䨡":"han2",
"䨢":"dan4",
"䨣":"ge2",
"䨤":"di2",
"䨥":"hu4",
"䨦":"pang2",
"䨩":"ling2",
"䨪":"mai2",
"䨫":"mai4",
"䨬":"lian2",
"䨮":"xue3",
"䨯":"zhen4",
"䨰":"po4",
"䨱":"fu4",
"䨲":"nou2",
"䨳":"xi4",
"䨴":"dui4",
"䨵":"dan4",
"䨶":"yun3",
"䨷":"xian4",
"䨸":"yin3",
"䨺":"dui4",
"䨻":"beng4",
"䨼":"hu4",
"䨽":"fei3",
"䨾":"fei3",
"䨿":"qian2",
"䩀":"bei4",
"䩃":"shi4",
"䩄":"tian3",
"䩅":"zhan3",
"䩆":"jian3",
"䩈":"hui4",
"䩉":"fu3",
"䩊":"wan3",
"䩋":"mo3",
"䩌":"qiao2",
"䩍":"liao3",
"䩏":"mie4",
"䩐":"ge2",
"䩑":"hong2",
"䩒":"yu2",
"䩓":"qi2",
"䩔":"duo4",
"䩕":"ang2",
"䩗":"ba4",
"䩘":"di4",
"䩙":"xuan4",
"䩚":"di4",
"䩛":"bi4",
"䩜":"zhou4",
"䩝":"pao2",
"䩞":"nian2",
"䩟":"yi2",
"䩡":"jia2",
"䩢":"da2",
"䩣":"duo3",
"䩤":"xi4",
"䩥":"dan4",
"䩦":"tiao2",
"䩧":"xie4",
"䩨":"chang4",
"䩩":"yuan3",
"䩪":"guan3",
"䩫":"liang3",
"䩬":"beng3",
"䩮":"lu4",
"䩯":"ji2",
"䩰":"xuan4",
"䩱":"shu4",
"䩳":"shu3",
"䩴":"hu2",
"䩵":"yun4",
"䩶":"chan3",
"䩸":"rong2",
"䩹":"e2",
"䩻":"ba4",
"䩼":"feng2",
"䩾":"zhe4",
"䩿":"fen2",
"䪀":"guan3",
"䪁":"bu3",
"䪂":"ge2",
"䪄":"huang2",
"䪅":"du2",
"䪆":"ti3",
"䪇":"bo2",
"䪈":"qian3",
"䪉":"la4",
"䪊":"long2",
"䪋":"wei4",
"䪌":"zhan4",
"䪍":"lan2",
"䪏":"na4",
"䪐":"bi4",
"䪑":"tuo2",
"䪒":"jiao4",
"䪔":"bu3",
"䪕":"ju2",
"䪖":"po4",
"䪗":"xia2",
"䪘":"wei3",
"䪙":"fu2",
"䪚":"he4",
"䪛":"fan2",
"䪜":"chan4",
"䪝":"hu4",
"䪞":"za2",
"䪤":"fan2",
"䪥":"die2",
"䪦":"hong2",
"䪧":"chi2",
"䪨":"bao2",
"䪩":"yin2",
"䪬":"bo2",
"䪭":"ruan3",
"䪮":"chou3",
"䪯":"ying2",
"䪱":"gai3",
"䪳":"yun3",
"䪴":"zhen3",
"䪵":"ya3",
"䪷":"hou4",
"䪸":"min2",
"䪹":"pei2",
"䪺":"ge2",
"䪻":"bian4",
"䪽":"hao4",
"䪾":"mi2",
"䪿":"sheng3",
"䫀":"gen3",
"䫁":"bi4",
"䫂":"duo3",
"䫃":"chun2",
"䫄":"chua4",
"䫅":"san4",
"䫆":"cheng2",
"䫇":"ran2",
"䫈":"zen4",
"䫉":"mao4",
"䫊":"bo2",
"䫋":"tui2",
"䫌":"pi3",
"䫍":"fu3",
"䫐":"lin2",
"䫒":"men2",
"䫓":"wu2",
"䫔":"qi4",
"䫕":"zhi4",
"䫖":"chen3",
"䫗":"xia2",
"䫘":"he2",
"䫙":"sang3",
"䫛":"hou2",
"䫝":"fu3",
"䫞":"rao2",
"䫟":"hun2",
"䫠":"pei2",
"䫡":"qian4",
"䫣":"xi2",
"䫤":"ming2",
"䫥":"kui3",
"䫦":"ge2",
"䫨":"ao4",
"䫩":"san3",
"䫪":"shuang3",
"䫫":"lou2",
"䫬":"zhen3",
"䫭":"hui4",
"䫮":"can2",
"䫰":"lin4",
"䫱":"na2",
"䫲":"han4",
"䫳":"du2",
"䫴":"jin4",
"䫵":"mian2",
"䫶":"fan2",
"䫷":"e4",
"䫸":"nao2",
"䫹":"hong2",
"䫺":"hong2",
"䫻":"xue2",
"䫼":"xue4",
"䫾":"bi4",
"䬀":"you3",
"䬁":"yi2",
"䬂":"xue4",
"䬃":"sa4",
"䬄":"yu4",
"䬅":"li4",
"䬆":"li4",
"䬇":"yuan4",
"䬈":"dui4",
"䬉":"hao4",
"䬊":"qie4",
"䬋":"leng2",
"䬎":"guo2",
"䬏":"bu4",
"䬐":"wei3",
"䬑":"wei4",
"䬓":"an4",
"䬔":"xu4",
"䬕":"shang3",
"䬖":"heng2",
"䬗":"yang2",
"䬙":"yao2",
"䬛":"bi4",
"䬝":"heng2",
"䬞":"tao2",
"䬟":"liu2",
"䬡":"zhu4",
"䬣":"qi4",
"䬤":"chao2",
"䬥":"yi4",
"䬦":"dou4",
"䬧":"yuan2",
"䬨":"cu4",
"䬪":"bo2",
"䬫":"can3",
"䬬":"yang3",
"䬮":"yi2",
"䬯":"nian2",
"䬰":"shao4",
"䬱":"ben4",
"䬳":"ban3",
"䬴":"mo4",
"䬵":"ai4",
"䬶":"en4",
"䬷":"she3",
"䬹":"zhi4",
"䬺":"yang4",
"䬻":"jian4",
"䬼":"yuan4",
"䬽":"dui4",
"䬾":"ti2",
"䬿":"wei3",
"䭀":"xun4",
"䭁":"zhi4",
"䭂":"yi4",
"䭃":"ren3",
"䭄":"shi4",
"䭅":"hu2",
"䭆":"ne4",
"䭇":"yi4",
"䭈":"jian4",
"䭉":"sui3",
"䭊":"ying3",
"䭋":"bao3",
"䭌":"hu2",
"䭍":"hu2",
"䭎":"xie2",
"䭐":"yang4",
"䭑":"lian2",
"䭓":"en4",
"䭕":"jian4",
"䭖":"zhu4",
"䭗":"ying3",
"䭘":"yan4",
"䭙":"jin3",
"䭚":"chuang2",
"䭛":"dan4",
"䭝":"kuai4",
"䭞":"yi4",
"䭟":"ye4",
"䭠":"jian3",
"䭡":"en4",
"䭢":"ning2",
"䭣":"ci2",
"䭤":"qian3",
"䭥":"xue4",
"䭦":"bo2",
"䭧":"mi3",
"䭨":"shui4",
"䭩":"mi4",
"䭪":"liang2",
"䭫":"qi3",
"䭬":"qi3",
"䭭":"shou3",
"䭮":"bi4",
"䭯":"bo2",
"䭰":"beng3",
"䭱":"bie2",
"䭲":"ni3",
"䭳":"wei4",
"䭴":"huan2",
"䭵":"fan2",
"䭶":"qi2",
"䭷":"liu2",
"䭸":"fu4",
"䭹":"ang2",
"䭺":"ang2",
"䭼":"qi2",
"䭽":"qun2",
"䭾":"tuo2",
"䭿":"yi4",
"䮀":"bo2",
"䮁":"pian2",
"䮂":"bo2",
"䮄":"xuan2",
"䮇":"yu4",
"䮈":"chi2",
"䮉":"lu2",
"䮊":"yi2",
"䮋":"li4",
"䮍":"niao3",
"䮎":"xi4",
"䮏":"wu2",
"䮑":"lei4",
"䮓":"zhao4",
"䮔":"zui3",
"䮕":"chuo4",
"䮗":"an4",
"䮘":"er2",
"䮙":"yu4",
"䮚":"leng4",
"䮛":"fu4",
"䮜":"sha4",
"䮝":"huan2",
"䮞":"chu4",
"䮟":"sou3",
"䮡":"bi4",
"䮢":"die2",
"䮤":"di2",
"䮥":"li4",
"䮧":"han2",
"䮨":"zai3",
"䮩":"gu2",
"䮪":"cheng2",
"䮫":"lou2",
"䮬":"mo4",
"䮭":"mi4",
"䮮":"mai4",
"䮯":"ao4",
"䮰":"dan3",
"䮱":"zhu2",
"䮲":"huang2",
"䮳":"fan2",
"䮴":"deng4",
"䮵":"tong2",
"䮷":"du2",
"䮸":"hu2",
"䮹":"wei4",
"䮺":"ji4",
"䮻":"chi4",
"䮼":"lin2",
"䮾":"pang2",
"䮿":"jian3",
"䯀":"nie4",
"䯁":"luo2",
"䯂":"ji2",
"䯅":"nie4",
"䯆":"yi4",
"䯈":"wan2",
"䯉":"ya4",
"䯊":"qia4",
"䯋":"bo2",
"䯍":"ling2",
"䯎":"gan4",
"䯏":"huo2",
"䯐":"hai2",
"䯒":"heng2",
"䯓":"kui2",
"䯔":"cen2",
"䯖":"lang2",
"䯗":"bi4",
"䯘":"huan4",
"䯙":"po4",
"䯚":"ou3",
"䯛":"jian3",
"䯜":"ti4",
"䯝":"sui3",
"䯟":"dui4",
"䯠":"ao3",
"䯡":"jian3",
"䯢":"mo2",
"䯣":"gui4",
"䯤":"kuai4",
"䯥":"an4",
"䯦":"ma4",
"䯧":"qing3",
"䯨":"fen2",
"䯪":"kao3",
"䯫":"hao4",
"䯬":"duo3",
"䯮":"nai2",
"䯰":"jie4",
"䯱":"fu4",
"䯲":"pa2",
"䯴":"chang2",
"䯵":"nie4",
"䯶":"man2",
"䯸":"ci4",
"䯺":"kuo4",
"䯼":"di2",
"䯽":"fu3",
"䯾":"tiao2",
"䯿":"zu2",
"䰀":"wo3",
"䰁":"fei4",
"䰂":"cai4",
"䰃":"peng2",
"䰄":"shi4",
"䰆":"rou2",
"䰇":"qi2",
"䰈":"cha3",
"䰉":"pan2",
"䰊":"bo2",
"䰋":"man2",
"䰌":"zong3",
"䰍":"ci4",
"䰎":"gui4",
"䰏":"ji4",
"䰐":"lan2",
"䰒":"meng2",
"䰓":"mian2",
"䰔":"pan2",
"䰕":"lu2",
"䰖":"cuan2",
"䰘":"liu2",
"䰙":"yi3",
"䰚":"wen2",
"䰛":"li4",
"䰜":"li4",
"䰝":"zeng4",
"䰞":"zhu3",
"䰟":"hun2",
"䰠":"shen2",
"䰡":"chi4",
"䰢":"xing4",
"䰣":"wang3",
"䰥":"huo4",
"䰦":"pi3",
"䰨":"mei4",
"䰩":"che3",
"䰪":"mei4",
"䰫":"chao2",
"䰬":"ju2",
"䰭":"nou4",
"䰯":"ni3",
"䰰":"ru2",
"䰱":"ling2",
"䰲":"ya4",
"䰴":"qi4",
"䰷":"bang4",
"䰹":"ze2",
"䰺":"jie4",
"䰻":"yu2",
"䰼":"xin2",
"䰽":"bei4",
"䰾":"ba4",
"䰿":"tuo2",
"䱁":"qiao2",
"䱂":"you3",
"䱃":"di3",
"䱄":"jie4",
"䱅":"mo4",
"䱆":"sheng2",
"䱇":"shan4",
"䱈":"qi2",
"䱉":"shan4",
"䱊":"mi3",
"䱋":"dan3",
"䱌":"yi2",
"䱍":"geng4",
"䱎":"geng4",
"䱏":"tou3",
"䱑":"xue2",
"䱒":"yi4",
"䱓":"ting2",
"䱔":"tiao2",
"䱕":"mou2",
"䱖":"liu2",
"䱘":"li2",
"䱚":"lu4",
"䱛":"xu4",
"䱜":"cuo4",
"䱝":"ba4",
"䱞":"liu2",
"䱟":"ju4",
"䱠":"zhan4",
"䱡":"ju2",
"䱣":"zu2",
"䱤":"xian4",
"䱥":"zhi2",
"䱨":"zhi4",
"䱫":"la4",
"䱭":"geng4",
"䱮":"e2",
"䱯":"mu2",
"䱰":"zhong4",
"䱱":"di4",
"䱲":"yan2",
"䱴":"geng4",
"䱶":"lang2",
"䱷":"yu2",
"䱹":"na4",
"䱺":"hai2",
"䱻":"hua2",
"䱼":"zhan3",
"䱾":"lou2",
"䱿":"chan4",
"䲀":"die2",
"䲁":"wei4",
"䲂":"xuan2",
"䲃":"zao3",
"䲄":"min2",
"䲊":"tuo3",
"䲋":"cen2",
"䲌":"kuan3",
"䲍":"teng2",
"䲎":"nei3",
"䲏":"lao2",
"䲐":"lu3",
"䲑":"yi2",
"䲒":"xie4",
"䲓":"yan3",
"䲔":"qing2",
"䲕":"pu3",
"䲖":"chou2",
"䲗":"xian2",
"䲘":"guan3",
"䲙":"jie2",
"䲚":"lai4",
"䲛":"meng2",
"䲜":"ye4",
"䲞":"li4",
"䲟":"yin4",
"䲢":"teng2",
"䲣":"yu2",
"䲦":"cha2",
"䲧":"du4",
"䲨":"hong2",
"䲪":"xi4",
"䲬":"qi2",
"䲮":"yuan2",
"䲯":"ji2",
"䲰":"yun4",
"䲱":"fang3",
"䲳":"hang2",
"䲴":"zhen4",
"䲵":"hu4",
"䲸":"jie4",
"䲹":"pei2",
"䲺":"gan4",
"䲻":"xuan2",
"䲽":"dao3",
"䲾":"qiao3",
"䲿":"ci2",
"䳀":"die2",
"䳁":"ba2",
"䳂":"tiao2",
"䳃":"wan3",
"䳄":"ci2",
"䳅":"zhi3",
"䳆":"bai2",
"䳇":"wu3",
"䳈":"bao3",
"䳉":"dan4",
"䳊":"ba2",
"䳋":"tong2",
"䳎":"jiu4",
"䳏":"gui4",
"䳐":"ci4",
"䳑":"you3",
"䳒":"yuan2",
"䳓":"lao3",
"䳔":"jiu4",
"䳕":"fou2",
"䳖":"nei4",
"䳗":"e2",
"䳘":"e2",
"䳙":"xing3",
"䳚":"he2",
"䳛":"yan4",
"䳜":"tu2",
"䳝":"bu4",
"䳞":"beng3",
"䳟":"kou4",
"䳠":"chui2",
"䳢":"qi2",
"䳣":"yuan2",
"䳧":"hou2",
"䳨":"huang2",
"䳪":"juan4",
"䳫":"kui2",
"䳬":"e4",
"䳭":"ji2",
"䳮":"mo4",
"䳯":"chong2",
"䳰":"bao3",
"䳱":"wu4",
"䳲":"zhen4",
"䳳":"xu4",
"䳴":"da2",
"䳵":"chi4",
"䳷":"cong2",
"䳸":"ma2",
"䳹":"kou4",
"䳺":"yan4",
"䳻":"can2",
"䳽":"he4",
"䳿":"lan2",
"䴀":"tong2",
"䴁":"yu4",
"䴂":"hang4",
"䴃":"nao2",
"䴄":"li4",
"䴅":"fen2",
"䴆":"pu2",
"䴇":"ling2",
"䴈":"ao3",
"䴉":"xuan2",
"䴊":"yi2",
"䴋":"xuan2",
"䴌":"meng2",
"䴎":"lei3",
"䴏":"yan4",
"䴐":"bao3",
"䴑":"die2",
"䴒":"ling2",
"䴓":"shi1",
"䴔":"jiao1",
"䴕":"lie4",
"䴖":"jing1",
"䴗":"ju2",
"䴘":"ti1",
"䴙":"pi4",
"䴚":"gang3",
"䴛":"jiao3",
"䴜":"huai2",
"䴝":"bu4",
"䴞":"di2",
"䴟":"huan2",
"䴠":"yao3",
"䴡":"li4",
"䴢":"mi2",
"䴦":"ren2",
"䴩":"piao2",
"䴪":"lu4",
"䴫":"ling2",
"䴬":"yi4",
"䴭":"cai2",
"䴮":"shan4",
"䴰":"shu2",
"䴱":"tuo2",
"䴲":"mo4",
"䴳":"he4",
"䴴":"tie4",
"䴵":"bing3",
"䴶":"peng2",
"䴷":"hun2",
"䴹":"guo3",
"䴺":"bu4",
"䴻":"li2",
"䴼":"chan3",
"䴽":"bai4",
"䴾":"cuo2",
"䴿":"meng2",
"䵀":"suo3",
"䵁":"qiang4",
"䵂":"zhi2",
"䵃":"kuang4",
"䵄":"bi2",
"䵅":"ao2",
"䵆":"meng2",
"䵇":"xian4",
"䵉":"tou2",
"䵋":"wei3",
"䵏":"lao3",
"䵐":"chan3",
"䵑":"ni4",
"䵒":"ni4",
"䵓":"li2",
"䵔":"dong3",
"䵕":"ju4",
"䵖":"jian4",
"䵗":"fu2",
"䵘":"sha4",
"䵙":"zha3",
"䵚":"tao3",
"䵛":"jian4",
"䵜":"nong3",
"䵝":"ya4",
"䵞":"jing4",
"䵟":"gan3",
"䵠":"di2",
"䵡":"jian3",
"䵢":"mei4",
"䵣":"da2",
"䵤":"jian3",
"䵥":"she4",
"䵦":"xie4",
"䵧":"zai4",
"䵨":"mang2",
"䵩":"li2",
"䵪":"gun4",
"䵫":"yu4",
"䵬":"ta4",
"䵭":"zhe4",
"䵮":"yang4",
"䵯":"tuan3",
"䵱":"he4",
"䵲":"diao4",
"䵳":"wei4",
"䵴":"yun4",
"䵵":"zha2",
"䵶":"qu2",
"䵺":"ting3",
"䵻":"gu3",
"䵽":"ca4",
"䵾":"fu2",
"䵿":"tie4",
"䶀":"ta4",
"䶁":"ta4",
"䶂":"zhuo2",
"䶃":"han2",
"䶄":"ping2",
"䶅":"he2",
"䶇":"zhou4",
"䶈":"bo2",
"䶉":"liu2",
"䶊":"nv4",
"䶌":"pao4",
"䶍":"di4",
"䶎":"sha4",
"䶏":"ti3",
"䶐":"kuai4",
"䶑":"ti4",
"䶒":"qi2",
"䶓":"ji4",
"䶔":"chi2",
"䶕":"pa2",
"䶖":"jin4",
"䶗":"ke4",
"䶘":"li4",
"䶙":"ju4",
"䶚":"qu3",
"䶛":"la4",
"䶜":"gu4",
"䶝":"qia4",
"䶞":"qi2",
"䶟":"xian4",
"䶠":"jian3",
"䶡":"shi2",
"䶢":"xian2",
"䶣":"ai2",
"䶤":"hua2",
"䶥":"ju3",
"䶦":"ze2",
"䶧":"yao3",
"䶩":"ji4",
"䶪":"cha2",
"䶫":"kan3",
"䶮":"yan2",
"䶱":"tong2",
"䶲":"nan2",
"䶳":"yue4",
"䶵":"chi2",
"丂":"kao3",
"丄":"shang4",
"丅":"xia4",
"丌":"ji1",
"丏":"mian3",
"丐":"gai4",
"丒":"chou3",
"丕":"pi1",
"丗":"shi4",
"丞":"cheng2",
"丠":"qiu1",
"両":"liang3",
"丣":"you3",
"並":"bing4",
"丨":"gun3",
"丩":"jiu1",
"丬":"qiang2",
"丮":"ji3",
"丯":"jie4",
"丱":"guan4",
"丳":"chan3",
"丵":"zhuo3",
"丶":"zhu3",
"丼":"jing3",
"丿":"pie3",
"乀":"fu2",
"乁":"yi2",
"乂":"yi4",
"乆":"jiu3",
"乇":"zhe2",
"乍":"zha4",
"乑":"zhong4",
"乔":"qiao2",
"乕":"hu3",
"乗":"cheng2",
"乚":"yin3",
"乜":"mie1",
"乞":"qi3",
"乢":"gai4",
"乣":"jiu3",
"乨":"shi3",
"乩":"ji1",
"乪":"nang2",
"乫":"jia1",
"乭":"shi2",
"乴":"xue2",
"乵":"yan3",
"乶":"fu3",
"乷":"sha1",
"乸":"na3",
"乹":"gan1",
"乾":"qian2",
"乿":"chi4",
"亀":"gui1",
"亁":"gan1",
"亃":"lin2",
"亄":"yi4",
"亅":"jue2",
"亇":"ge4",
"亊":"shi4",
"亍":"chu4",
"亐":"yu2",
"亓":"qi2",
"亖":"si4",
"亗":"sui4",
"亘":"gen4",
"亙":"gen4",
"亜":"ya4",
"亝":"qi2",
"亟":"qi4",
"亠":"tou2",
"亢":"kang4",
"亣":"ta4",
"亥":"hai4",
"亨":"heng1",
"京":"jing1",
"亯":"xiang3",
"亰":"jing1",
"亱":"ye4",
"亳":"bo2",
"亴":"you4",
"亵":"xie4",
"亶":"dan3",
"亷":"lian2",
"亸":"duo3",
"亹":"wei3",
"亻":"ren2",
"亼":"ji2",
"亾":"wang2",
"仁":"ren2",
"仂":"le4",
"仃":"ding1",
"仄":"ze4",
"仆":"pu2",
"仈":"ba1",
"仉":"zhang3",
"仌":"bing1",
"仏":"fo2",
"仐":"san3",
"仑":"lun2",
"仕":"shi4",
"仚":"xian1",
"仛":"tuo1",
"仜":"hong2",
"仝":"tong2",
"仞":"ren4",
"仟":"qian1",
"仠":"gan2",
"仡":"yi4",
"仢":"di2",
"仦":"chao4",
"仧":"chang2",
"仨":"sa1",
"仫":"mu4",
"仭":"ren4",
"仮":"jia3",
"仯":"chao4",
"仱":"qian2",
"仲":"zhong4",
"仳":"pi3",
"仴":"wan4",
"仵":"wu3",
"仸":"yao3",
"仹":"feng1",
"仺":"cang1",
"仼":"wang2",
"仾":"di1",
"伀":"zhong1",
"伂":"pei4",
"伃":"yu2",
"伄":"diao4",
"伅":"dun4",
"伆":"wen4",
"伇":"yi4",
"伈":"xin3",
"伉":"kang4",
"伋":"ji2",
"伌":"ai4",
"伎":"ji4",
"伒":"jin4",
"伓":"bei1",
"伔":"dan3",
"伕":"fu1",
"伖":"tang3",
"伛":"yu3",
"伜":"cui4",
"伝":"yun2",
"伡":"che1",
"伢":"ya2",
"伣":"xian4",
"伥":"chang1",
"伦":"lun2",
"伧":"cang1",
"伨":"xun4",
"伩":"xin4",
"伫":"zhu4",
"伭":"xuan2",
"伮":"nu2",
"伱":"ni3",
"伲":"ni3",
"伳":"xie4",
"伵":"xu4",
"伷":"zhou4",
"伹":"qu1",
"伻":"beng1",
"伽":"jia1",
"伾":"pi1",
"伿":"yi4",
"佀":"si4",
"佁":"ai3",
"佂":"zheng1",
"佄":"han2",
"佅":"mai4",
"佇":"zhu4",
"佈":"bu4",
"佉":"qu1",
"佊":"bi3",
"佋":"shao4",
"佌":"ci3",
"佐":"zuo3",
"佒":"yang1",
"佔":"zhan4",
"佖":"bi4",
"佗":"tuo2",
"佘":"she2",
"佚":"yi4",
"佝":"gou1",
"佞":"ning4",
"佟":"tong2",
"佡":"xuan1",
"佢":"qu2",
"佣":"yong1",
"佤":"wa3",
"佥":"qian1",
"佧":"ka3",
"佪":"huai2",
"佫":"he4",
"佬":"lao3",
"佭":"xiang2",
"佮":"ge2",
"佯":"yang2",
"佰":"bai3",
"佱":"fa3",
"佲":"ming2",
"佴":"er4",
"併":"bing4",
"佶":"ji2",
"佷":"hen3",
"佸":"huo2",
"佹":"gui3",
"佺":"quan2",
"佻":"tiao1",
"佼":"jiao3",
"佽":"ci4",
"佾":"yi4",
"侀":"xing2",
"侁":"shen1",
"侂":"tuo1",
"侃":"kan3",
"侄":"zhi2",
"侅":"gai1",
"侇":"yi2",
"侈":"chi3",
"侉":"kua1",
"侊":"guang1",
"侌":"yin1",
"侎":"mi3",
"侏":"zhu1",
"侐":"xu4",
"侑":"you4",
"侒":"an1",
"侓":"lu4",
"侔":"mou2",
"侕":"er2",
"侖":"lun2",
"侗":"tong1",
"侘":"cha4",
"侙":"chi4",
"侚":"xun4",
"侜":"zhou1",
"侞":"ru3",
"侟":"jian4",
"侠":"xia2",
"価":"jia4",
"侢":"zai4",
"侣":"lv3",
"侥":"jiao3",
"侨":"qiao2",
"侩":"kuai4",
"侪":"chai2",
"侫":"ning4",
"侬":"nong2",
"侭":"jin3",
"侯":"hou2",
"侰":"jiong3",
"侱":"cheng3",
"侲":"zhen4",
"侳":"zuo4",
"侴":"chou3",
"侶":"lv3",
"侷":"ju2",
"侸":"shu4",
"侹":"ting3",
"侺":"shen4",
"侻":"tuo1",
"侼":"bo2",
"侽":"nan2",
"侾":"hao1",
"俀":"tui3",
"俁":"yu3",
"係":"xi4",
"俅":"qiu2",
"俆":"xu2",
"俇":"kuang3",
"俈":"ku4",
"俉":"wu2",
"俊":"jun4",
"俋":"yi4",
"俌":"fu3",
"俍":"lang2",
"俎":"zu3",
"俏":"qiao4",
"俐":"li4",
"俑":"yong3",
"俒":"hun4",
"俓":"jing4",
"俔":"xian4",
"俕":"san4",
"俖":"pai3",
"俙":"xi1",
"俚":"li3",
"俛":"mian3",
"俜":"ping1",
"俞":"yu2",
"俟":"si4",
"俠":"xia2",
"俢":"xiu1",
"俣":"yu3",
"俤":"ti4",
"俥":"che1",
"俦":"chou2",
"俨":"yan3",
"俪":"li4",
"俫":"lai2",
"俰":"he4",
"俲":"xiao4",
"俳":"pai2",
"俴":"jian4",
"俵":"biao3",
"俶":"chu4",
"俷":"fei4",
"俸":"feng4",
"俹":"ya4",
"俻":"bei4",
"俼":"yu4",
"俽":"xin1",
"俾":"bi3",
"俿":"jian4",
"倀":"chang1",
"倁":"chi2",
"倂":"bing4",
"倃":"zan2",
"倄":"yao2",
"倅":"cui4",
"倇":"wan3",
"倈":"lai2",
"倊":"zong4",
"倌":"guan1",
"倎":"tian1",
"倏":"shu1",
"倐":"shu1",
"倓":"tan2",
"倔":"jue2",
"倕":"chui2",
"倖":"xing4",
"倗":"peng2",
"倛":"qi1",
"倜":"ti4",
"倝":"gan4",
"倞":"jing4",
"倠":"sui1",
"倢":"jie2",
"倣":"fang3",
"値":"zhi2",
"倥":"kong3",
"倧":"zong1",
"倨":"ju4",
"倩":"qian4",
"倪":"ni2",
"倫":"lun2",
"倬":"zhuo1",
"倭":"wo1",
"倮":"luo3",
"倯":"song1",
"倰":"leng2",
"倱":"hun4",
"倲":"dong1",
"倳":"zi4",
"倴":"ben4",
"倵":"wu3",
"倶":"ju1",
"倷":"nai4",
"倸":"cai3",
"倹":"jian3",
"倻":"ye1",
"倽":"sha4",
"偀":"ying1",
"偁":"cheng1",
"偂":"jian1",
"偃":"yan3",
"偄":"nuan4",
"偅":"zhong4",
"偆":"chun3",
"偈":"ji4",
"偊":"yu3",
"偋":"bing3",
"偌":"ruo4",
"偍":"ti2",
"偐":"yan4",
"偑":"feng1",
"偒":"tang3",
"偓":"wo4",
"偔":"e4",
"偕":"xie2",
"偖":"che3",
"偗":"sheng3",
"偘":"kan3",
"偙":"di4",
"偛":"cha1",
"偝":"bei4",
"偞":"ye4",
"偟":"huang2",
"偠":"yao3",
"偡":"zhan4",
"偢":"chou3",
"偣":"yan1",
"偤":"you3",
"偦":"xu1",
"偧":"zha1",
"偨":"ci1",
"偩":"fu4",
"偪":"bi1",
"偫":"zhi4",
"偬":"zong3",
"偭":"mian3",
"偮":"ji2",
"偯":"yi3",
"偰":"xie4",
"偱":"xun2",
"偲":"si1",
"偳":"duan1",
"偸":"tou1",
"偹":"bei4",
"偺":"za2",
"偻":"lou2",
"偼":"jie2",
"偾":"fen4",
"傀":"kui3",
"傁":"sou3",
"傂":"zhi4",
"傃":"su4",
"傄":"xia1",
"傆":"yuan4",
"傇":"rong3",
"傈":"li4",
"傉":"ru4",
"傊":"yun3",
"傋":"gou4",
"傌":"ma4",
"傎":"dian1",
"傏":"tang2",
"傐":"hao4",
"傑":"jie2",
"傒":"xi1",
"傓":"shan4",
"傔":"qian4",
"傕":"jue2",
"傖":"cang1",
"傗":"chu4",
"傚":"xiao4",
"傛":"yong3",
"傜":"yao2",
"傝":"tan4",
"傞":"suo1",
"傟":"yang3",
"傠":"fa1",
"傡":"bing4",
"傢":"jia1",
"傣":"dai3",
"傤":"zai4",
"傥":"tang3",
"傧":"bin1",
"傩":"nuo2",
"傪":"can1",
"傫":"lei3",
"傭":"yong4",
"傮":"zao1",
"傯":"zong3",
"傰":"peng2",
"傱":"song3",
"傴":"yu3",
"傶":"cou4",
"傸":"qiang3",
"傹":"jing4",
"傺":"chi4",
"傼":"han4",
"傽":"zhang1",
"傿":"yan1",
"僀":"di4",
"僁":"xi1",
"僂":"lou2",
"僃":"bei4",
"僄":"piao4",
"僆":"lian2",
"僇":"lu4",
"僈":"man4",
"僉":"qian1",
"僊":"xian1",
"僋":"tan4",
"僌":"ying2",
"働":"dong4",
"僎":"zhuan4",
"僐":"shan4",
"僑":"qiao2",
"僒":"jiong3",
"僓":"tui3",
"僔":"zun3",
"僕":"pu2",
"僖":"xi1",
"僗":"lao2",
"僘":"chang3",
"僙":"guang1",
"僛":"qi1",
"僜":"deng4",
"僝":"chan2",
"僞":"wei3",
"僟":"ji1",
"僠":"fan1",
"僡":"hui4",
"僢":"chuan3",
"僣":"jian4",
"僤":"dan4",
"僥":"jiao3",
"僦":"jiu4",
"僧":"seng1",
"僨":"fen4",
"僩":"xian4",
"僪":"jue2",
"僫":"e4",
"僬":"jiao1",
"僭":"jian4",
"僮":"zhuang4",
"僯":"lin3",
"僰":"bo2",
"僳":"su4",
"僴":"xian4",
"僶":"min3",
"僷":"ye4",
"僸":"jin4",
"僺":"qiao4",
"僻":"pi4",
"僼":"feng1",
"僽":"zhou4",
"僾":"ai4",
"僿":"sai4",
"儁":"jun4",
"儂":"nong2",
"儃":"chan2",
"儅":"dang1",
"儆":"jing3",
"儇":"xuan1",
"儈":"kuai4",
"儊":"chu4",
"儋":"dan4",
"儌":"jiao3",
"儍":"sha3",
"儎":"zai4",
"儐":"bin1",
"儑":"an4",
"儒":"ru2",
"儓":"tai2",
"儔":"chou2",
"儕":"chai2",
"儖":"lan2",
"儗":"ni3",
"儘":"jin3",
"儙":"qian4",
"儚":"meng2",
"儛":"wu3",
"儜":"ning2",
"儝":"qiong2",
"儞":"ni3",
"儠":"lie4",
"儡":"lei3",
"儢":"lv3",
"儣":"kuang4",
"儤":"bao4",
"儥":"du2",
"儦":"biao1",
"儧":"zan3",
"儨":"zhi2",
"儩":"si4",
"儫":"hao2",
"儬":"chen4",
"儭":"chen4",
"儮":"li4",
"儯":"teng2",
"儰":"wei3",
"儱":"long3",
"儳":"chan4",
"儴":"rang2",
"儵":"shu4",
"儶":"hui4",
"儷":"li4",
"儸":"luo2",
"儹":"zan3",
"儺":"nuo2",
"儻":"tang3",
"儼":"yan3",
"儽":"lei3",
"儾":"nang4",
"兀":"wu4",
"兂":"zan1",
"兆":"zhao4",
"兇":"xiong1",
"兊":"dui4",
"兌":"dui4",
"兎":"tu4",
"兏":"chang2",
"児":"er2",
"兑":"dui4",
"兓":"xin1",
"兕":"si4",
"兖":"yan3",
"兗":"yan3",
"兘":"shi3",
"兛":"qian1",
"兝":"fen1",
"兞":"mao2",
"兟":"shen1",
"兠":"dou1",
"兢":"jing1",
"兣":"li3",
"兤":"huang2",
"兦":"wang2",
"兪":"yu2",
"兮":"xi1",
"兰":"lan2",
"兲":"tian1",
"兹":"zi1",
"兾":"ji4",
"兿":"yi4",
"冀":"ji4",
"冁":"chan3",
"冂":"jiong1",
"冄":"ran3",
"円":"yuan2",
"冇":"mao3",
"冉":"ran3",
"冋":"jiong1",
"冎":"gua3",
"冏":"jiong3",
"冐":"mao4",
"冑":"zhou4",
"冓":"gou4",
"冔":"xu3",
"冕":"mian3",
"冖":"mi4",
"冗":"rong3",
"冘":"yin2",
"冚":"kan3",
"冝":"yi2",
"冞":"mi2",
"冟":"shi4",
"冠":"guan4",
"冡":"meng2",
"冢":"zhong3",
"冣":"ju4",
"冥":"ming2",
"冦":"kou4",
"冨":"fu4",
"冩":"xie3",
"冪":"mi4",
"冫":"bing1",
"冭":"tai2",
"冮":"gang1",
"冯":"feng2",
"冱":"hu4",
"冴":"hu4",
"冸":"pan4",
"冹":"fu2",
"冺":"min3",
"冼":"xian3",
"冽":"lie4",
"冾":"xia2",
"冿":"jian1",
"凁":"shu4",
"凂":"mei3",
"凃":"tu2",
"凅":"gu4",
"凇":"song1",
"凈":"jing4",
"凊":"jing4",
"凋":"diao1",
"凌":"ling2",
"凎":"gan4",
"凐":"yin1",
"凒":"yi2",
"凓":"li4",
"凔":"cang1",
"凕":"ming3",
"凗":"cui2",
"凘":"si1",
"凙":"duo2",
"凚":"jin4",
"凛":"lin3",
"凜":"lin3",
"凞":"xi1",
"凟":"du2",
"凢":"fan2",
"凣":"fan2",
"凥":"ju1",
"処":"chu3",
"凨":"feng1",
"凬":"feng1",
"凮":"feng1",
"凯":"kai3",
"凱":"kai3",
"凲":"gan1",
"凴":"ping2",
"凵":"qu1",
"凷":"kuai4",
"凼":"dang4",
"函":"han2",
"凾":"han2",
"刁":"diao1",
"刂":"dao1",
"刃":"ren4",
"刄":"ren4",
"刅":"chuang1",
"刈":"yi4",
"刉":"ji1",
"刋":"qian4",
"刌":"cun3",
"刍":"chu2",
"刎":"wen3",
"刏":"ji1",
"刐":"dan3",
"刓":"wan2",
"刔":"jue2",
"刕":"li2",
"刖":"yue4",
"刘":"liu2",
"刜":"fu2",
"刞":"qu4",
"刟":"ju1",
"删":"shan1",
"刡":"min3",
"刢":"ling2",
"刣":"zhong1",
"刦":"jie2",
"刧":"jie2",
"刪":"shan1",
"刬":"chan3",
"刭":"jing3",
"刯":"gen1",
"刱":"chuang4",
"刲":"kui1",
"刳":"ku1",
"刴":"duo4",
"刵":"er4",
"券":"quan4",
"刼":"jie2",
"刽":"gui4",
"刾":"ci4",
"刿":"gui4",
"剀":"kai3",
"剁":"duo4",
"剃":"ti4",
"剄":"jing3",
"剅":"lou2",
"剆":"gen1",
"剈":"yuan1",
"剉":"cuo4",
"剋":"ke4",
"剌":"la2",
"剏":"chuang4",
"剐":"gua3",
"剒":"cuo4",
"剓":"li2",
"剕":"fei4",
"剗":"chan3",
"剘":"qi2",
"剙":"chuang4",
"剚":"zi4",
"剜":"wan1",
"剞":"ji1",
"剟":"duo1",
"剠":"qing2",
"剡":"shan4",
"剢":"zhuo2",
"剣":"jian4",
"剤":"ji4",
"剦":"yan1",
"剨":"huo4",
"剫":"duo2",
"剬":"duan1",
"剭":"wu1",
"剮":"gua3",
"剰":"sheng4",
"剱":"jian4",
"剳":"zha1",
"剴":"kai3",
"剶":"juan1",
"剷":"chan3",
"剸":"tuan2",
"剹":"lu4",
"剺":"li2",
"剻":"fou2",
"剼":"shan1",
"剽":"piao1",
"剾":"kou1",
"劀":"gua1",
"劁":"qiao1",
"劂":"jue2",
"劃":"hua2",
"劄":"zha2",
"劅":"zhuo4",
"劆":"lian2",
"劉":"liu2",
"劊":"gui4",
"劋":"jiao3",
"劌":"gui4",
"劎":"jian4",
"劏":"tang1",
"劐":"huo1",
"劒":"jian4",
"劓":"yi4",
"劔":"jian4",
"劕":"zhi2",
"劖":"chan2",
"劗":"cuan2",
"劘":"mo2",
"劙":"li2",
"劚":"zhu2",
"劜":"ya1",
"劢":"mai4",
"劤":"jin4",
"劥":"keng1",
"劦":"xie2",
"劧":"zhi3",
"劫":"jie2",
"劬":"qu2",
"劭":"shao4",
"劮":"yi4",
"劯":"zhu1",
"劰":"miao3",
"労":"lao2",
"劵":"juan4",
"劶":"kou3",
"劷":"yang2",
"劸":"wa1",
"効":"xiao4",
"劺":"mou2",
"劻":"kuang1",
"劼":"jie2",
"劽":"lie4",
"劾":"he2",
"勀":"ke4",
"勂":"hao2",
"勄":"min3",
"勅":"chi4",
"勆":"lang2",
"勈":"yong3",
"勊":"ke4",
"勋":"xun1",
"勌":"juan4",
"勍":"qing2",
"勎":"lu4",
"勏":"pou3",
"勐":"meng3",
"勑":"lai4",
"勓":"kai4",
"勔":"mian3",
"勖":"xu4",
"勗":"xu4",
"勚":"yi4",
"勛":"xun1",
"勜":"weng3",
"募":"mu4",
"勠":"lu4",
"勡":"piao4",
"勣":"ji1",
"勥":"qiang3",
"勦":"chao1",
"勧":"quan4",
"勨":"yang3",
"勩":"yi4",
"勪":"jue2",
"勫":"fan2",
"勬":"juan4",
"勭":"tong2",
"勮":"ju4",
"勯":"dan1",
"勰":"xie2",
"勱":"mai4",
"勲":"xun1",
"勳":"xun1",
"勴":"lv4",
"勶":"che4",
"勷":"rang2",
"勹":"bao1",
"勺":"shao2",
"勼":"jiu1",
"勽":"bao4",
"勿":"wu4",
"匃":"gai4",
"匄":"gai4",
"匈":"xiong1",
"匉":"peng1",
"匊":"ju1",
"匋":"tao2",
"匌":"ge2",
"匍":"pu2",
"匎":"an4",
"匏":"pao2",
"匐":"fu2",
"匑":"gong1",
"匒":"da2",
"匓":"jiu4",
"匔":"qiong1",
"匕":"bi3",
"匘":"nao3",
"匚":"fang1",
"匛":"jiu4",
"匜":"yi2",
"匝":"za1",
"匞":"jiang4",
"匟":"kang4",
"匡":"kuang1",
"匢":"hu1",
"匣":"xia2",
"匤":"qu1",
"匥":"bian4",
"匦":"gui3",
"匧":"qie4",
"匨":"zang1",
"匩":"kuang1",
"匫":"hu1",
"匬":"tou2",
"匭":"gui3",
"匮":"kui4",
"匰":"dan1",
"匱":"kui4",
"匲":"lian2",
"匳":"lian2",
"匴":"suan3",
"匵":"du2",
"匶":"jiu4",
"匷":"qu2",
"匸":"xi3",
"匼":"qia4",
"匽":"yan3",
"匿":"ni4",
"卂":"xin4",
"卄":"nian4",
"卅":"sa4",
"卆":"zu2",
"卉":"hui4",
"卋":"shi4",
"卌":"xi4",
"卍":"wan4",
"卐":"wan4",
"卒":"cu4",
"卓":"zhuo2",
"単":"dan1",
"卙":"ji2",
"卛":"lv4",
"卝":"kuang4",
"卞":"bian4",
"卟":"bu3",
"卢":"lu2",
"卣":"you3",
"卤":"lu3",
"卥":"xi1",
"卦":"gua4",
"卨":"xie4",
"卩":"jie2",
"卪":"jie2",
"卬":"ang2",
"卭":"qiong2",
"卮":"zhi1",
"卯":"mao3",
"卲":"shao4",
"卶":"shi4",
"卹":"xu4",
"卺":"jin3",
"卼":"wu4",
"卽":"ji2",
"卾":"e4",
"卿":"qing1",
"厀":"xi1",
"厃":"zhan1",
"厄":"e4",
"厇":"zhe2",
"厈":"han3",
"厊":"ya3",
"厍":"she4",
"厎":"zhi3",
"厏":"zha3",
"厐":"pang2",
"厒":"he2",
"厓":"ya2",
"厔":"zhi4",
"厖":"pang2",
"厗":"ti2",
"厙":"she4",
"厛":"ting1",
"厜":"zui1",
"厝":"cuo4",
"厞":"fei4",
"厠":"ce4",
"厡":"yuan2",
"厣":"yan3",
"厤":"li4",
"厥":"jue2",
"厧":"dian1",
"厩":"jiu4",
"厪":"jin3",
"厫":"ao2",
"厬":"gui3",
"厮":"si1",
"厯":"li4",
"厰":"chang3",
"厱":"lan2",
"厳":"yan2",
"厴":"yan3",
"厵":"yuan2",
"厶":"si1",
"厷":"gong1",
"厸":"lin2",
"厹":"rou2",
"厺":"qu4",
"厽":"lei3",
"厾":"du1",
"叀":"zhuan1",
"叁":"san1",
"叄":"san1",
"叅":"can1",
"叆":"ai4",
"叇":"dai4",
"叉":"cha1",
"収":"shou1",
"叏":"guai4",
"叐":"ba2",
"叒":"ruo4",
"叓":"shi4",
"叕":"zhuo2",
"叚":"jia3",
"叜":"sou3",
"叝":"gao4",
"叞":"wei4",
"叟":"sou3",
"叡":"rui4",
"叧":"gua3",
"叨":"dao1",
"叩":"kou4",
"叱":"chi4",
"叴":"qiu2",
"叵":"po3",
"叺":"chi3",
"叻":"le4",
"叽":"ji1",
"叿":"hong1",
"吀":"mie1",
"吂":"mang2",
"吅":"xuan1",
"吇":"zi3",
"吋":"cun4",
"吏":"li4",
"吒":"zha4",
"吔":"ye3",
"吕":"lv3",
"吖":"a1",
"吘":"ou3",
"吙":"xue1",
"吚":"yi1",
"吜":"chou3",
"吝":"lin4",
"吠":"fei4",
"吡":"bi3",
"吢":"qin4",
"吣":"qin4",
"吤":"jie4",
"吥":"bu4",
"吪":"e2",
"吮":"shun3",
"吰":"hong2",
"吱":"zi1",
"吲":"yin3",
"吳":"wu2",
"吴":"wu2",
"吷":"xue4",
"吺":"dou1",
"吽":"hong1",
"吾":"wu2",
"吿":"gao4",
"呁":"jun4",
"呂":"lv3",
"呄":"ge2",
"呅":"mei2",
"呇":"qi3",
"呉":"wu2",
"呋":"fu1",
"呌":"jiao4",
"呍":"hong1",
"呎":"chi3",
"呏":"sheng1",
"呑":"tun1",
"呒":"fu3",
"呓":"yi4",
"呔":"dai1",
"呕":"ou3",
"呖":"li4",
"呙":"guo1",
"呛":"qiang4",
"呝":"e4",
"呞":"shi1",
"呟":"quan3",
"呠":"pen1",
"呡":"wen3",
"呤":"ling4",
"呥":"ran3",
"呦":"you1",
"呧":"di3",
"呩":"shi4",
"呪":"zhou4",
"呫":"tie1",
"呬":"xi4",
"呭":"yi4",
"呮":"qi4",
"呯":"ping2",
"呰":"zi3",
"呱":"gu1",
"呲":"zi1",
"呴":"xu1",
"呶":"nao2",
"呷":"xia1",
"呹":"yi4",
"呺":"xiao1",
"呾":"da2",
"呿":"qu1",
"咁":"gan1",
"咃":"tuo1",
"咄":"duo1",
"咅":"pou4",
"咇":"bi4",
"咈":"fu2",
"咉":"yang1",
"咊":"he2",
"咍":"hai1",
"咎":"jiu4",
"咏":"yong3",
"咑":"da1",
"咓":"wa3",
"咔":"ka3",
"咗":"zuo3",
"咘":"bu4",
"咚":"dong1",
"咝":"si1",
"咞":"xian4",
"咟":"huo4",
"咠":"qi4",
"咡":"er4",
"咢":"e4",
"咣":"guang1",
"咤":"zha4",
"咥":"die2",
"咨":"zi1",
"咩":"mie1",
"咪":"mi1",
"咫":"zhi3",
"咭":"ji1",
"咮":"zhou4",
"咯":"ge1",
"咰":"shuai4",
"咲":"xiao4",
"咴":"hui1",
"咵":"kua1",
"咶":"huai4",
"咷":"tao2",
"咹":"e4",
"咺":"xuan1",
"咻":"xiu1",
"咼":"guo1",
"咾":"lao3",
"咿":"yi1",
"哂":"shen3",
"哃":"tong2",
"哅":"xiong1",
"哉":"zai1",
"哊":"yu4",
"哋":"di4",
"哌":"pai4",
"哐":"kuang1",
"哒":"da1",
"哓":"xiao1",
"哔":"bi4",
"哕":"yue3",
"哙":"kuai4",
"哚":"duo3",
"哜":"ji4",
"哝":"nong2",
"哞":"mou1",
"哠":"hao4",
"哢":"long4",
"哣":"pou3",
"哤":"mang2",
"哫":"zu2",
"哬":"he2",
"哯":"xian4",
"哰":"lao2",
"哱":"bo1",
"哳":"zha1",
"哴":"liang4",
"哵":"ba1",
"哶":"mie1",
"哷":"le4",
"哸":"sui1",
"哹":"fou2",
"哻":"han4",
"哾":"shuo1",
"哿":"ke3",
"唀":"you3",
"唁":"yan4",
"唂":"gu3",
"唃":"gu3",
"唅":"han1",
"唆":"suo1",
"唈":"yi4",
"唉":"ai4",
"唊":"jia2",
"唋":"tu3",
"唌":"xian2",
"唍":"huan3",
"唎":"li5",
"唏":"xi1",
"唐":"tang2",
"唑":"zuo4",
"唒":"qiu2",
"唓":"che1",
"唔":"wu2",
"唕":"zao4",
"唖":"ya3",
"唗":"dou1",
"唘":"qi3",
"唙":"di2",
"唚":"qin4",
"唛":"ma4",
"唝":"hong3",
"唞":"dou3",
"唠":"lao2",
"唡":"liang3",
"唢":"suo3",
"唣":"zao4",
"唦":"sha1",
"唧":"ji1",
"唨":"zuo3",
"唩":"wo1",
"唪":"feng3",
"唫":"yin2",
"唭":"qi1",
"唲":"er2",
"唳":"li4",
"唴":"qiang4",
"唵":"an3",
"唶":"jie4",
"唷":"yo1",
"唸":"nian4",
"唹":"yu2",
"唺":"tian3",
"唻":"lai3",
"唼":"sha4",
"唽":"xi1",
"唿":"hu1",
"啀":"ai2",
"啁":"zhou1",
"啂":"nou4",
"啅":"zhuo2",
"啇":"di2",
"啈":"heng4",
"啉":"lin2",
"啋":"xiao1",
"啌":"xiang1",
"啍":"tun1",
"啎":"wu3",
"啐":"cui4",
"啑":"sha4",
"啒":"hu1",
"啓":"qi3",
"啔":"qi3",
"啕":"tao2",
"啖":"dan4",
"啗":"dan4",
"啘":"ye4",
"啙":"zi3",
"啚":"bi3",
"啛":"cui4",
"啜":"chuo4",
"啝":"he2",
"啠":"zhe2",
"啢":"liang3",
"啣":"xian2",
"啧":"ze2",
"啨":"qing1",
"啩":"gua4",
"啫":"zhe3",
"啬":"se4",
"啭":"zhuan4",
"啮":"nie4",
"啯":"guo1",
"啰":"luo1",
"啱":"yan1",
"啲":"di4",
"啳":"quan2",
"啴":"tan1",
"啵":"bo5",
"啶":"ding4",
"啷":"lang1",
"啺":"tang2",
"啻":"chi4",
"啽":"an2",
"啿":"dan4",
"喀":"ka1",
"喁":"yong2",
"喅":"yu4",
"喆":"zhe2",
"喈":"jie1",
"喋":"die2",
"喌":"zhou1",
"喍":"chai2",
"喎":"wai1",
"喏":"re3",
"喐":"yu4",
"喑":"yin1",
"喒":"zan2",
"喓":"yao1",
"喕":"mian3",
"喖":"hu2",
"喗":"yun3",
"喙":"hui4",
"喛":"huan4",
"喞":"ji1",
"喟":"kui4",
"喠":"zhong3",
"喡":"wei3",
"喢":"sha4",
"喣":"xu3",
"喤":"huang2",
"喥":"du4",
"喦":"nie4",
"喧":"xuan1",
"喨":"liang4",
"喩":"yu4",
"喫":"chi1",
"喬":"qiao2",
"喭":"yan4",
"喯":"pen1",
"喰":"can1",
"喱":"li2",
"喳":"cha1",
"喴":"wei1",
"喵":"miao1",
"営":"ying2",
"喹":"kui2",
"喺":"xi4",
"喻":"yu4",
"喼":"jie2",
"喾":"ku4",
"喿":"zao4",
"嗀":"huo4",
"嗁":"ti2",
"嗂":"yao2",
"嗃":"he4",
"嗄":"ga1",
"嗆":"qiang4",
"嗇":"se4",
"嗈":"yong1",
"嗉":"su4",
"嗊":"hong3",
"嗋":"xie2",
"嗌":"yi4",
"嗍":"suo1",
"嗏":"cha1",
"嗑":"ke4",
"嗒":"ta4",
"嗔":"chen1",
"嗕":"ru4",
"嗖":"sou1",
"嗗":"wa1",
"嗘":"ji1",
"嗙":"pang3",
"嗛":"qian1",
"嗜":"shi4",
"嗝":"ge2",
"嗞":"zi1",
"嗟":"jie1",
"嗠":"luo4",
"嗢":"wa4",
"嗣":"si4",
"嗤":"chi1",
"嗥":"hao2",
"嗩":"suo3",
"嗪":"qin2",
"嗫":"nie4",
"嗮":"sai4",
"嗰":"ge4",
"嗱":"na2",
"嗲":"dia3",
"嗳":"ai3",
"嗵":"tong1",
"嗶":"bi4",
"嗷":"ao2",
"嗸":"ao2",
"嗹":"lian2",
"嗺":"cui1",
"嗻":"zhe1",
"嗼":"mo4",
"嗾":"sou3",
"嗿":"tan3",
"嘁":"qi1",
"嘂":"jiao4",
"嘃":"chong1",
"嘄":"jiao1",
"嘅":"kai3",
"嘇":"san1",
"嘉":"jia1",
"嘊":"ai2",
"嘋":"xiao1",
"嘌":"piao1",
"嘎":"ga2",
"嘏":"gu3",
"嘐":"xiao1",
"嘑":"hu1",
"嘒":"hui4",
"嘓":"guo1",
"嘔":"ou3",
"嘕":"xian1",
"嘖":"ze2",
"嘙":"po2",
"嘚":"de1",
"嘜":"ma4",
"嘝":"hu2",
"嘞":"lei5",
"嘟":"du1",
"嘠":"ga1",
"嘡":"tang1",
"嘢":"ye3",
"嘣":"beng1",
"嘤":"ying1",
"嘦":"jiao4",
"嘧":"mi4",
"嘨":"xiao4",
"嘪":"mai3",
"嘫":"ran2",
"嘬":"zuo1",
"嘭":"peng1",
"嘮":"lao2",
"嘰":"ji1",
"嘳":"kui4",
"嘵":"xiao1",
"嘷":"hao2",
"嘸":"fu3",
"嘹":"liao2",
"嘺":"qiao2",
"嘼":"xiu4",
"嘽":"tan1",
"嘾":"tan2",
"噀":"xun4",
"噁":"wu4",
"噂":"zun3",
"噃":"fan1",
"噄":"chi1",
"噅":"hui1",
"噆":"zan3",
"噇":"chuang2",
"噈":"cu4",
"噉":"dan4",
"噊":"yu4",
"噋":"tun1",
"噌":"ceng1",
"噍":"jiao4",
"噎":"ye1",
"噏":"xi1",
"噐":"qi4",
"噑":"hao2",
"噒":"lian2",
"噔":"deng1",
"噕":"hui1",
"噖":"yin2",
"噗":"pu1",
"噘":"jue1",
"噙":"qin2",
"噚":"xun2",
"噛":"nie4",
"噜":"lu1",
"噝":"si1",
"噞":"yan3",
"噟":"ying4",
"噠":"da1",
"噡":"dan1",
"噣":"zhou4",
"噤":"jin4",
"噥":"nong2",
"噦":"yue3",
"噧":"hui4",
"噩":"e4",
"噫":"yi1",
"噬":"shi4",
"噭":"jiao4",
"噮":"yuan1",
"噯":"ai3",
"噰":"yong1",
"噱":"jue2",
"噲":"kuai4",
"噳":"yu3",
"噵":"dao4",
"噶":"ga2",
"噷":"xin1",
"噹":"dang1",
"噻":"sai5",
"噼":"pi1",
"噽":"pi3",
"噾":"yin1",
"噿":"zui3",
"嚁":"di2",
"嚂":"lan4",
"嚃":"ta4",
"嚄":"o3",
"嚅":"ru2",
"嚆":"hao1",
"嚈":"ya4",
"嚉":"duo1",
"嚊":"xi4",
"嚋":"chou2",
"嚌":"ji4",
"嚍":"jin4",
"嚎":"hao2",
"嚏":"ti4",
"嚐":"chang2",
"嚓":"ca1",
"嚔":"ti4",
"嚕":"lu1",
"嚖":"hui4",
"嚗":"bo2",
"嚘":"you1",
"嚙":"nie4",
"嚚":"yin2",
"嚛":"hu4",
"嚜":"mo4",
"嚝":"huang1",
"嚞":"zhe2",
"嚟":"li2",
"嚠":"liu2",
"嚢":"nang2",
"嚣":"xiao1",
"嚤":"mo2",
"嚥":"yan4",
"嚦":"li4",
"嚧":"lu2",
"嚩":"fu2",
"嚪":"dan4",
"嚫":"chen4",
"嚬":"pin2",
"嚭":"pi3",
"嚮":"xiang4",
"嚯":"huo4",
"嚰":"mo2",
"嚱":"xi4",
"嚲":"duo3",
"嚳":"ku4",
"嚵":"chan2",
"嚶":"ying1",
"嚸":"dian3",
"嚹":"la1",
"嚺":"ta4",
"嚻":"xiao1",
"嚽":"chuo4",
"嚾":"huan1",
"嚿":"huo4",
"囀":"zhuan4",
"囁":"nie4",
"囂":"xiao1",
"囃":"ca4",
"囄":"li2",
"囅":"chan3",
"囆":"chai4",
"囇":"li4",
"囈":"yi4",
"囉":"luo1",
"囊":"nang2",
"囋":"zan4",
"囌":"su1",
"囍":"xi3",
"囏":"jian1",
"囐":"za2",
"囒":"lan2",
"囓":"nie4",
"囔":"nang1",
"囗":"wei2",
"囘":"hui2",
"囙":"yin1",
"囚":"qiu2",
"囜":"nin2",
"囝":"nan1",
"囟":"xin4",
"囡":"nan1",
"団":"tuan2",
"囤":"tun2",
"囥":"kang4",
"囦":"yuan1",
"囧":"jiong3",
"囨":"pian1",
"囩":"yun4",
"囫":"hu2",
"囬":"hui2",
"囮":"e2",
"囯":"guo2",
"囲":"wei2",
"図":"tu2",
"囵":"lun2",
"囶":"guo2",
"囷":"qun1",
"囸":"ri4",
"囹":"ling2",
"囻":"guo2",
"囼":"tai1",
"囿":"you4",
"圀":"guo2",
"圁":"yin2",
"圂":"hun4",
"圃":"pu3",
"圄":"yu3",
"圅":"han2",
"圇":"lun2",
"圉":"yu3",
"圊":"qing1",
"圌":"chui2",
"圎":"yuan2",
"圏":"quan1",
"圐":"ku1",
"圑":"fu4",
"圔":"e4",
"圗":"tu2",
"圙":"lve4",
"圚":"hui4",
"圛":"yi4",
"圜":"huan2",
"圝":"luan2",
"圞":"luan2",
"圠":"ya4",
"圡":"tu3",
"圢":"ting1",
"圤":"pu3",
"圥":"lu4",
"圧":"ya1",
"圩":"wei2",
"圪":"ge1",
"圫":"yu4",
"圬":"wu1",
"圭":"gui1",
"圮":"pi3",
"圯":"yi2",
"圱":"qian1",
"圲":"qian1",
"圳":"zhen4",
"圴":"zhuo2",
"圵":"dang4",
"圶":"qia4",
"圹":"kuang4",
"圻":"qi2",
"圼":"nie4",
"圽":"mo4",
"圿":"jia2",
"坁":"zhi3",
"坂":"ban3",
"坃":"xun1",
"坄":"tou2",
"坅":"qin3",
"坆":"mei2",
"坈":"keng1",
"坉":"tun2",
"坋":"fen4",
"坌":"ben4",
"坍":"tan1",
"坒":"bi4",
"坓":"xing2",
"坔":"di4",
"坕":"jing1",
"坖":"ji4",
"坘":"di3",
"坙":"jing1",
"坛":"tan2",
"坜":"li4",
"坞":"wu4",
"坢":"pan3",
"坣":"tang1",
"坤":"kun1",
"坥":"qu1",
"坧":"zhi1",
"坨":"tuo2",
"坩":"gan1",
"坪":"ping2",
"坫":"dian4",
"坬":"gua4",
"坭":"ni2",
"坮":"tai2",
"坰":"jiong1",
"坱":"yang1",
"坲":"fo2",
"坳":"ao4",
"坴":"lu4",
"坵":"qiu1",
"坶":"mu4",
"坷":"ke3",
"坸":"gou4",
"坹":"xue4",
"坺":"ba2",
"坻":"di3",
"坼":"che4",
"坽":"ling2",
"坾":"zhu4",
"坿":"fu4",
"垀":"hu1",
"垁":"zhi4",
"垅":"long3",
"垆":"lu2",
"垇":"ao4",
"垉":"pao2",
"垌":"dong4",
"垍":"ji4",
"垎":"ke4",
"垏":"lu4",
"垐":"ci2",
"垑":"chi3",
"垓":"gai1",
"垔":"yin1",
"垕":"hou4",
"垖":"dui1",
"垗":"zhao4",
"垘":"fu2",
"垙":"guang1",
"垚":"yao2",
"垛":"duo4",
"垜":"duo3",
"垝":"gui3",
"垞":"cha2",
"垟":"yang2",
"垠":"yin2",
"垡":"fa2",
"垢":"gou4",
"垣":"yuan2",
"垤":"die2",
"垥":"xie2",
"垧":"shang3",
"垨":"shou3",
"垩":"e4",
"垬":"hong2",
"垭":"ya1",
"垱":"dang4",
"垲":"kai3",
"垴":"nao3",
"垵":"an3",
"垶":"xing1",
"垷":"xian4",
"垸":"huan4",
"垹":"bang1",
"垺":"pei1",
"垻":"ba4",
"垼":"yi4",
"垽":"yin4",
"垾":"han4",
"垿":"xu4",
"埀":"chui2",
"埁":"cen2",
"埂":"geng3",
"埄":"peng2",
"埅":"fang2",
"埆":"que4",
"埇":"yong3",
"埈":"xun4",
"埉":"jia2",
"埊":"di4",
"埌":"lang4",
"埍":"xuan4",
"埏":"shan1",
"埐":"jin1",
"埑":"zhe2",
"埒":"lie4",
"埓":"lie4",
"埔":"pu3",
"埕":"cheng2",
"埗":"bu4",
"埘":"shi2",
"埙":"xun1",
"埚":"guo1",
"埛":"jiong1",
"埜":"ye3",
"埝":"nian4",
"埞":"di3",
"埡":"ya1",
"埢":"juan3",
"埣":"sui4",
"埤":"pi2",
"埥":"cheng1",
"埦":"wan3",
"埧":"ju4",
"埨":"lun3",
"埩":"zheng1",
"埪":"kong1",
"埫":"chong3",
"埬":"dong1",
"埭":"dai4",
"埮":"tan4",
"埯":"an3",
"埰":"cai4",
"埱":"shu2",
"埲":"beng3",
"埳":"kan3",
"埴":"zhi2",
"埵":"duo3",
"埶":"yi4",
"埸":"yi4",
"埻":"zhun3",
"埼":"qi2",
"埽":"sao4",
"埾":"ju4",
"埿":"ni2",
"堀":"ku1",
"堁":"ke4",
"堃":"kun1",
"堄":"ni4",
"堇":"jin3",
"堈":"gang1",
"堉":"yu4",
"堊":"e4",
"堋":"peng2",
"堌":"gu4",
"堍":"tu4",
"堎":"ling2",
"堐":"ya2",
"堑":"qian4",
"堓":"an4",
"堕":"duo4",
"堖":"nao3",
"堗":"tu1",
"堘":"cheng2",
"堙":"yin1",
"堚":"hun2",
"堛":"bi4",
"堜":"lian4",
"堝":"guo1",
"堞":"die2",
"堟":"zhuan4",
"堠":"hou4",
"堢":"bao3",
"堣":"yu2",
"堥":"mao2",
"堦":"jie1",
"堧":"ruan2",
"堨":"e4",
"堩":"geng4",
"堫":"zong1",
"堬":"yu2",
"堭":"huang2",
"堮":"e4",
"堯":"yao2",
"堲":"ji2",
"堳":"mei2",
"堶":"tuo2",
"堷":"yin4",
"堸":"feng2",
"堹":"zhong4",
"堺":"jie4",
"堻":"zhen1",
"堼":"feng1",
"堽":"gang1",
"堾":"chuan3",
"堿":"jian3",
"塁":"lei3",
"塂":"xiang4",
"塃":"huang1",
"塄":"leng2",
"塅":"duan4",
"塇":"xuan1",
"塈":"ji4",
"塉":"ji2",
"塋":"ying2",
"塍":"cheng2",
"塎":"yong3",
"塏":"kai3",
"塐":"su4",
"塒":"shi2",
"塓":"mi4",
"塕":"weng3",
"塖":"cheng2",
"塗":"tu2",
"塙":"que4",
"塚":"zhong3",
"塛":"li4",
"塜":"peng2",
"塝":"bang4",
"塟":"zang4",
"塠":"dui1",
"塡":"tian2",
"塢":"wu4",
"塣":"cheng3",
"塤":"xun1",
"塥":"ge2",
"塦":"zhen4",
"塧":"ai4",
"塨":"gong1",
"塩":"yan2",
"塪":"kan3",
"塬":"yuan2",
"塭":"wen1",
"塮":"xie4",
"塯":"liu4",
"塱":"lang3",
"塲":"chang3",
"塳":"peng2",
"塴":"beng4",
"塶":"cu4",
"塷":"lu3",
"塸":"ou3",
"塹":"qian4",
"塺":"mei2",
"塻":"mo4",
"塼":"zhuan1",
"塽":"shuang3",
"塾":"shu2",
"塿":"lou3",
"墀":"chi2",
"墁":"man4",
"墂":"biao1",
"墄":"qi1",
"墅":"shu4",
"墆":"di4",
"墇":"zhang1",
"墈":"kan4",
"墉":"yong1",
"墋":"chen3",
"墌":"zhi1",
"墍":"xi4",
"墎":"guo1",
"墏":"qiang3",
"墐":"jin3",
"墑":"di1",
"墒":"shang1",
"墔":"cui1",
"墕":"yan4",
"墖":"ta3",
"増":"zeng1",
"墘":"qi2",
"墚":"liang2",
"墝":"qiao1",
"墟":"xu1",
"墠":"shan4",
"墡":"shan4",
"墢":"ba2",
"墣":"pu1",
"墤":"kuai4",
"墥":"dong3",
"墦":"fan2",
"墧":"que4",
"墪":"dun1",
"墫":"zun1",
"墬":"di2",
"墭":"sheng4",
"墮":"duo4",
"墯":"duo4",
"墰":"tan2",
"墱":"deng4",
"墲":"wu3",
"墴":"huang2",
"墵":"tan2",
"墶":"da1",
"墷":"ye4",
"墺":"ao4",
"墻":"qiang2",
"墼":"ji1",
"墽":"qiao1",
"墿":"yi4",
"壀":"pi2",
"壂":"dian4",
"壃":"jiang1",
"壄":"ye3",
"壅":"yong1",
"壆":"bo2",
"壇":"tan2",
"壈":"lan3",
"壉":"ju4",
"壊":"huai4",
"壋":"dang4",
"壌":"rang3",
"壍":"qian4",
"壎":"xun1",
"壏":"lan4",
"壐":"xi3",
"壑":"he4",
"壒":"ai4",
"壔":"dao3",
"壖":"ruan2",
"壙":"kuang4",
"壚":"lu2",
"壛":"yan2",
"壜":"tan2",
"壝":"wei3",
"壠":"long3",
"壡":"rui4",
"壢":"li4",
"壣":"lin2",
"壦":"xun1",
"壧":"yan2",
"壨":"lei2",
"壬":"ren2",
"壱":"yi1",
"売":"mai4",
"壴":"zhu3",
"壵":"zhuang4",
"壷":"hu2",
"壸":"kun3",
"壹":"yi1",
"壻":"xu4",
"壼":"kun3",
"壾":"mang3",
"壿":"zun1",
"夀":"shou4",
"夁":"yi1",
"夂":"zhi3",
"夃":"gu1",
"夅":"jiang4",
"夆":"feng1",
"変":"bian4",
"夊":"sui1",
"夋":"qun1",
"夌":"ling2",
"夎":"zuo4",
"夐":"xiong4",
"夒":"nao2",
"夓":"xia4",
"夔":"kui2",
"夗":"yuan4",
"夘":"mao3",
"夙":"su4",
"夛":"duo1",
"夝":"qing2",
"夡":"qi4",
"夣":"meng4",
"夤":"yin2",
"夥":"huo3",
"夦":"chen4",
"夨":"ze4",
"夬":"guai4",
"夭":"yao1",
"夯":"hang1",
"夰":"gao3",
"夲":"ben3",
"夳":"tai4",
"夵":"yan3",
"夶":"bi3",
"夷":"yi2",
"夼":"kuang3",
"夽":"yun4",
"夿":"pa1",
"奀":"en1",
"奁":"lian2",
"奂":"huan4",
"奃":"di4",
"奄":"yan1",
"奅":"pao4",
"奆":"quan3",
"奊":"xie2",
"奌":"dian3",
"奎":"kui2",
"奐":"huan4",
"契":"qi4",
"奒":"kai1",
"奓":"zha4",
"奕":"yi4",
"奘":"zhuang3",
"奙":"ben3",
"奚":"xi1",
"奛":"xiang3",
"奜":"fei3",
"奝":"diao1",
"奞":"xun4",
"奟":"keng1",
"奡":"ao4",
"奢":"she1",
"奣":"weng3",
"奤":"pan3",
"奥":"ao4",
"奦":"wu4",
"奧":"ao4",
"奨":"jiang3",
"奩":"lian2",
"奫":"yun1",
"奬":"jiang3",
"奭":"shi4",
"奯":"huo4",
"奰":"bi4",
"奱":"lian2",
"奲":"duo3",
"奵":"ding1",
"奷":"qian1",
"奺":"jiu3",
"奻":"nan2",
"奼":"cha4",
"奾":"xian1",
"奿":"fan4",
"妀":"ji3",
"妁":"shuo4",
"妃":"fei1",
"妅":"hong2",
"妆":"zhuang1",
"妉":"dan1",
"妊":"ren4",
"妋":"fu1",
"妌":"jing4",
"妍":"yan2",
"妎":"xie4",
"妏":"wen4",
"妐":"zhong1",
"妑":"pa1",
"妒":"du4",
"妓":"ji4",
"妔":"keng1",
"妕":"zhong4",
"妖":"yao1",
"妗":"jin4",
"妘":"yun2",
"妚":"pei1",
"妜":"yue4",
"妝":"zhuang1",
"妞":"niu1",
"妟":"yan4",
"妠":"na4",
"妡":"xin1",
"妢":"fen2",
"妣":"bi3",
"妤":"yu2",
"妦":"feng1",
"妧":"yuan2",
"妩":"wu3",
"妪":"yu4",
"妫":"gui1",
"妬":"du4",
"妭":"ba2",
"妮":"ni1",
"妯":"zhou2",
"妰":"zhuo2",
"妱":"zhao1",
"妲":"da2",
"妳":"ni3",
"妴":"yuan3",
"妵":"tou3",
"妶":"xuan2",
"妷":"zhi2",
"妸":"e1",
"妺":"mo4",
"妼":"bi4",
"妽":"shen1",
"妾":"qie4",
"妿":"e1",
"姀":"he2",
"姁":"xu3",
"姂":"fa2",
"姃":"zheng1",
"姄":"min2",
"姅":"ban4",
"姇":"fu1",
"姈":"ling2",
"姉":"jie3",
"姌":"ran3",
"姍":"shan1",
"姎":"yang1",
"姏":"man2",
"姒":"si4",
"姕":"zi1",
"姖":"ju4",
"姗":"shan1",
"姘":"pin1",
"姙":"ren4",
"姚":"yao2",
"姛":"tong3",
"姝":"shu1",
"姞":"ji2",
"姟":"gai1",
"姠":"shang4",
"姡":"kuo4",
"姢":"juan1",
"姣":"jiao1",
"姤":"gou4",
"姥":"lao3",
"姦":"jian1",
"姧":"jian1",
"姩":"nian4",
"姪":"zhi2",
"姫":"zhen3",
"姬":"ji1",
"姭":"xian4",
"姮":"heng2",
"姯":"guang1",
"姰":"jun1",
"姱":"kua1",
"姲":"yan4",
"姳":"ming3",
"姴":"lie4",
"姵":"pei4",
"姶":"yan3",
"姷":"you4",
"姸":"yan2",
"姹":"cha4",
"姺":"xian3",
"姼":"chi3",
"姽":"gui3",
"姾":"quan1",
"娀":"song1",
"娂":"hong2",
"娄":"lou2",
"娅":"ya4",
"娆":"rao2",
"娈":"luan2",
"娉":"ping1",
"娊":"xian4",
"娋":"shao4",
"娌":"li3",
"娍":"cheng2",
"娎":"xiao4",
"娏":"mang2",
"娑":"suo1",
"娒":"wu3",
"娓":"wei3",
"娔":"ke4",
"娕":"lai4",
"娖":"chuo4",
"娗":"ding4",
"娙":"xing2",
"娚":"nan2",
"娜":"na4",
"娝":"pei1",
"娞":"nei3",
"娟":"juan1",
"娠":"shen1",
"娡":"zhi4",
"娢":"han2",
"娣":"di4",
"娤":"zhuang1",
"娥":"e2",
"娦":"pin2",
"娧":"tui4",
"娨":"han4",
"娩":"wan3",
"娪":"wu2",
"娫":"yan2",
"娬":"wu3",
"娭":"xi1",
"娮":"yan2",
"娯":"yu2",
"娰":"si4",
"娲":"wa1",
"娴":"xian2",
"娵":"ju1",
"娷":"shui4",
"娸":"qi2",
"娹":"xian2",
"娺":"zhui1",
"娻":"dong1",
"娼":"chang1",
"娽":"lu4",
"娾":"ai3",
"娿":"e1",
"婀":"e1",
"婁":"lou2",
"婂":"mian2",
"婃":"cong2",
"婄":"pou3",
"婅":"ju2",
"婇":"cai3",
"婈":"ding2",
"婉":"wan3",
"婊":"biao3",
"婋":"xiao1",
"婌":"shu3",
"婍":"qi3",
"婎":"hui1",
"婏":"fu4",
"婐":"wo3",
"婑":"wo3",
"婒":"tan2",
"婓":"fei1",
"婕":"jie2",
"婖":"tian1",
"婗":"ni2",
"婘":"quan2",
"婙":"jing4",
"婛":"jing1",
"婜":"qian1",
"婝":"dian4",
"婞":"xing4",
"婟":"hu4",
"婠":"wa4",
"婡":"lai2",
"婢":"bi4",
"婣":"yin1",
"婤":"zhou1",
"婥":"chuo4",
"婧":"jing4",
"婨":"lun2",
"婩":"yan4",
"婪":"lan2",
"婫":"kun1",
"婬":"yin2",
"婭":"ya4",
"婯":"li4",
"婰":"dian3",
"婱":"xian2",
"婳":"hua4",
"婵":"chan2",
"婷":"ting2",
"婸":"dang4",
"婹":"yao3",
"婺":"wu4",
"婻":"nan4",
"婼":"chuo4",
"婽":"jia3",
"婾":"tou1",
"婿":"xu4",
"媀":"yu2",
"媁":"wei1",
"媂":"ti2",
"媃":"rou2",
"媄":"mei3",
"媅":"dan1",
"媆":"ruan3",
"媇":"qin1",
"媉":"wu1",
"媊":"qian2",
"媋":"chun1",
"媌":"mao2",
"媍":"fu4",
"媎":"jie3",
"媏":"duan1",
"媐":"xi1",
"媑":"zhong4",
"媒":"mei2",
"媓":"huang2",
"媔":"mian2",
"媕":"an1",
"媖":"ying1",
"媗":"xuan1",
"媙":"wei1",
"媚":"mei4",
"媛":"yuan2",
"媜":"zhen1",
"媝":"qiu1",
"媞":"ti2",
"媟":"xie4",
"媠":"tuo3",
"媡":"lian4",
"媢":"mao4",
"媣":"ran3",
"媤":"si1",
"媥":"pian1",
"媦":"wei4",
"媧":"wa1",
"媨":"jiu4",
"媩":"hu2",
"媪":"ao3",
"媬":"bao3",
"媭":"xu1",
"媮":"tou1",
"媯":"gui1",
"媰":"zou1",
"媱":"yao2",
"媲":"pi4",
"媴":"yuan2",
"媵":"ying4",
"媶":"rong2",
"媷":"ru4",
"媸":"chi1",
"媹":"liu2",
"媺":"mei3",
"媻":"pan2",
"媼":"ao3",
"媾":"gou4",
"媿":"kui4",
"嫀":"qin2",
"嫃":"zhen1",
"嫄":"yuan2",
"嫅":"cha1",
"嫆":"yong2",
"嫇":"ming2",
"嫈":"ying1",
"嫉":"ji2",
"嫊":"su4",
"嫋":"niao3",
"嫍":"tao1",
"嫎":"pang2",
"嫏":"lang2",
"嫐":"nao3",
"嫑":"bao2",
"嫒":"ai4",
"嫓":"pi4",
"嫔":"pin2",
"嫕":"yi4",
"嫖":"piao2",
"嫗":"yu4",
"嫘":"lei2",
"嫙":"xuan2",
"嫚":"man4",
"嫛":"yi1",
"嫜":"zhang1",
"嫝":"kang1",
"嫞":"yong2",
"嫟":"ni4",
"嫠":"li2",
"嫡":"di2",
"嫢":"gui1",
"嫣":"yan1",
"嫤":"jin4",
"嫥":"zhuan1",
"嫦":"chang2",
"嫧":"ce4",
"嫨":"han1",
"嫪":"lao4",
"嫫":"mo2",
"嫬":"zhe1",
"嫭":"hu4",
"嫮":"hu4",
"嫯":"ao4",
"嫰":"nen4",
"嫱":"qiang2",
"嫳":"pie4",
"嫴":"gu1",
"嫵":"wu3",
"嫶":"jiao2",
"嫷":"tuo3",
"嫸":"zhan3",
"嫹":"mao2",
"嫺":"xian2",
"嫻":"xian2",
"嫼":"mo4",
"嫽":"liao2",
"嫾":"lian2",
"嫿":"hua4",
"嬀":"gui1",
"嬁":"deng1",
"嬂":"zhi1",
"嬃":"xu1",
"嬅":"hua2",
"嬆":"xi1",
"嬇":"hui4",
"嬈":"rao2",
"嬉":"xi1",
"嬊":"yan4",
"嬋":"chan2",
"嬍":"mei3",
"嬎":"fan4",
"嬏":"fan1",
"嬐":"xian1",
"嬑":"yi4",
"嬒":"wei4",
"嬓":"jiao4",
"嬔":"fu4",
"嬕":"shi4",
"嬖":"bi4",
"嬗":"shan4",
"嬘":"sui4",
"嬙":"qiang2",
"嬚":"lian3",
"嬛":"xuan1",
"嬝":"niao3",
"嬞":"dong3",
"嬟":"yi4",
"嬠":"can2",
"嬡":"ai4",
"嬢":"niang2",
"嬣":"neng2",
"嬤":"ma1",
"嬥":"tiao3",
"嬦":"chou2",
"嬧":"jin4",
"嬨":"ci2",
"嬩":"yu2",
"嬪":"pin2",
"嬬":"xu1",
"嬭":"nai3",
"嬮":"yan1",
"嬯":"tai2",
"嬱":"can2",
"嬲":"niao3",
"嬴":"ying2",
"嬵":"mian2",
"嬷":"ma1",
"嬹":"xing4",
"嬺":"ni4",
"嬻":"du2",
"嬼":"liu3",
"嬽":"yuan1",
"嬾":"lan3",
"嬿":"yan4",
"孀":"shuang1",
"孁":"ling2",
"孂":"jiao3",
"孃":"niang2",
"孄":"lan3",
"孅":"xian1",
"孆":"ying1",
"孇":"shuang1",
"孈":"shuai1",
"孉":"quan2",
"孊":"mi3",
"孋":"li2",
"孌":"luan2",
"孍":"yan2",
"孎":"zhu3",
"孏":"lan3",
"孑":"jie2",
"孒":"jue2",
"孓":"jue2",
"孕":"yun4",
"孖":"zi1",
"孚":"fu2",
"孛":"bei4",
"孜":"zi1",
"孝":"xiao4",
"孞":"xin4",
"孟":"meng4",
"孠":"si4",
"孡":"tai1",
"孢":"bao1",
"孥":"nu2",
"孨":"zhuan3",
"孪":"luan2",
"孬":"nao1",
"孭":"mie1",
"孮":"cong2",
"孯":"qian1",
"孰":"shu2",
"孱":"can4",
"孲":"ya1",
"孳":"zi1",
"孴":"ni3",
"孶":"zi1",
"孷":"li2",
"孹":"bo4",
"孺":"ru2",
"孻":"lai2",
"孼":"nie4",
"孽":"nie4",
"孾":"ying1",
"孿":"luan2",
"宀":"mian2",
"宂":"rong3",
"宄":"gui3",
"宆":"qiong2",
"宊":"tu2",
"宋":"song4",
"宍":"rou4",
"宎":"yao3",
"宐":"yi2",
"宑":"jing3",
"宒":"zhun1",
"宓":"mi4",
"宔":"zhu3",
"宕":"dang4",
"宖":"hong2",
"宛":"wan3",
"実":"shi2",
"宠":"chong3",
"宥":"you4",
"宦":"huan4",
"宧":"yi2",
"宨":"tiao3",
"宩":"shi3",
"宬":"cheng2",
"宭":"qun2",
"宯":"xiao1",
"宱":"zha4",
"宲":"bao3",
"宷":"shen3",
"宸":"chen2",
"宺":"huang3",
"宻":"mi4",
"宼":"kou4",
"寀":"cai4",
"寁":"zan3",
"寃":"yuan1",
"寅":"yin2",
"寈":"qing1",
"寉":"que4",
"寊":"zhen1",
"寋":"jian3",
"寍":"ning2",
"寎":"bing4",
"寏":"huan2",
"寐":"mei4",
"寑":"qin3",
"寔":"shi2",
"寕":"ning2",
"寖":"jin4",
"寗":"ning2",
"寘":"zhi4",
"寙":"yu3",
"寚":"bao3",
"寛":"kuan1",
"寜":"ning2",
"寝":"qin3",
"寠":"ju4",
"寢":"qin3",
"寣":"hu1",
"寤":"wu4",
"寥":"liao2",
"寨":"zhai4",
"寪":"wei3",
"寭":"hui4",
"寮":"liao2",
"寯":"jun4",
"寰":"huan2",
"寱":"yi4",
"寲":"yi2",
"寳":"bao3",
"寴":"qin4",
"寵":"chong3",
"寷":"feng1",
"寺":"si4",
"寽":"lv4",
"対":"dui4",
"尀":"po3",
"専":"zhuan1",
"尃":"fu1",
"尅":"ke4",
"尉":"wei4",
"尌":"shu4",
"尐":"ji1",
"尒":"er3",
"尓":"er3",
"尕":"ga3",
"尗":"shu2",
"尙":"shang4",
"尜":"ga2",
"尞":"liao4",
"尟":"xian3",
"尠":"xian3",
"尢":"wang1",
"尣":"wang1",
"尥":"liao4",
"尦":"liao4",
"尧":"yao2",
"尨":"mang2",
"尩":"wang1",
"尪":"wang1",
"尫":"wang1",
"尬":"ga4",
"尭":"yao2",
"尮":"duo4",
"尯":"kui4",
"尰":"zhong3",
"尲":"gan1",
"尳":"gu3",
"尴":"gan1",
"尵":"tui2",
"尶":"gan1",
"尷":"gan1",
"尹":"yin3",
"尻":"kao1",
"尼":"ni2",
"屃":"xi4",
"屄":"bi1",
"屇":"tian2",
"屌":"diao3",
"屍":"shi1",
"屐":"ji1",
"屒":"chen2",
"屓":"xi4",
"屔":"ni2",
"屖":"xi1",
"屘":"man3",
"屙":"e1",
"屚":"lou4",
"屛":"ping2",
"屝":"fei4",
"屟":"xie4",
"屡":"lv3",
"屢":"lv3",
"屣":"xi3",
"履":"lv3",
"屦":"ju4",
"屧":"xie4",
"屨":"ju4",
"屩":"jue1",
"屪":"liao2",
"屫":"jue2",
"屭":"xi4",
"屮":"che4",
"屯":"tun2",
"屰":"ni4",
"屳":"xian1",
"屴":"li4",
"屵":"xue1",
"屸":"long2",
"屺":"qi3",
"屻":"ren4",
"屼":"wu4",
"屽":"han4",
"屾":"shen1",
"岀":"chu1",
"岄":"yue4",
"岅":"ban3",
"岆":"yao3",
"岇":"ang2",
"岈":"ya2",
"岉":"wu4",
"岊":"jie2",
"岋":"e4",
"岌":"ji2",
"岍":"qian1",
"岎":"fen1",
"岏":"yuan2",
"岐":"qi2",
"岑":"cen2",
"岒":"qian2",
"岓":"qi2",
"岔":"cha4",
"岕":"jie4",
"岘":"xian4",
"岙":"ao4",
"岚":"lan2",
"岜":"ba1",
"岝":"zuo4",
"岞":"zuo4",
"岟":"yang3",
"岠":"ju4",
"岢":"ke3",
"岣":"gou3",
"岤":"xue4",
"岥":"bei1",
"岦":"li4",
"岧":"tiao2",
"岨":"qu1",
"岪":"fu2",
"岫":"xiu4",
"岬":"jia3",
"岮":"tuo2",
"岯":"pei1",
"岰":"you3",
"岱":"dai4",
"岲":"kuang4",
"岳":"yue4",
"岴":"qu1",
"岵":"hu4",
"岶":"po4",
"岷":"min2",
"岹":"tiao2",
"岺":"ling2",
"岻":"chi2",
"岽":"dong1",
"岿":"kui1",
"峀":"xiu4",
"峁":"mao3",
"峂":"tong2",
"峃":"xue2",
"峄":"yi4",
"峆":"he1",
"峇":"ke1",
"峈":"luo4",
"峉":"e1",
"峊":"fu4",
"峋":"xun2",
"峌":"die2",
"峍":"lu4",
"峎":"an1",
"峏":"er3",
"峐":"gai1",
"峑":"quan2",
"峒":"dong4",
"峓":"yi2",
"峔":"mu3",
"峕":"shi2",
"峖":"an1",
"峗":"wei2",
"峘":"hu1",
"峙":"zhi4",
"峚":"mi4",
"峛":"li3",
"峜":"ji1",
"峝":"tong2",
"峞":"wei2",
"峟":"you4",
"峠":"qia3",
"峢":"li3",
"峣":"yao2",
"峤":"jiao4",
"峥":"zheng1",
"峧":"jiao1",
"峩":"e2",
"峪":"yu4",
"峫":"ye2",
"峬":"bu1",
"峮":"qun1",
"峯":"feng1",
"峱":"nao2",
"峲":"li3",
"峳":"you2",
"峴":"xian4",
"峵":"hong2",
"峷":"shen1",
"峸":"cheng2",
"峹":"tu2",
"峺":"geng3",
"峼":"hao4",
"峾":"yin1",
"峿":"wu2",
"崀":"lang4",
"崁":"kan3",
"崂":"lao2",
"崃":"lai2",
"崄":"xian3",
"崅":"que4",
"崆":"kong1",
"崈":"chong2",
"崉":"ta4",
"崋":"hua4",
"崌":"ju1",
"崍":"lai2",
"崏":"min2",
"崐":"kun1",
"崑":"kun1",
"崒":"cui4",
"崓":"gu4",
"崔":"cui1",
"崕":"ya2",
"崘":"lun2",
"崙":"lun2",
"崚":"leng2",
"崛":"jue2",
"崜":"duo1",
"崝":"zheng1",
"崞":"guo1",
"崟":"yin2",
"崠":"dong1",
"崡":"han2",
"崢":"zheng1",
"崣":"wei3",
"崤":"xiao2",
"崥":"pi3",
"崦":"yan1",
"崧":"song1",
"崨":"jie2",
"崪":"zu2",
"崫":"jue2",
"崬":"dong1",
"崮":"gu4",
"崯":"yin2",
"崱":"ze2",
"崲":"huang2",
"崳":"yu2",
"崴":"wai3",
"崵":"yang2",
"崶":"feng1",
"崷":"qiu2",
"崸":"dun4",
"崹":"ti2",
"崺":"yi3",
"崻":"zhi4",
"崼":"shi4",
"崾":"yao3",
"崿":"e4",
"嵀":"zhu4",
"嵁":"kan1",
"嵂":"lv4",
"嵃":"yan3",
"嵄":"mei3",
"嵅":"gan1",
"嵆":"ji1",
"嵇":"ji1",
"嵈":"huan3",
"嵉":"ting2",
"嵊":"sheng4",
"嵋":"mei2",
"嵍":"wu4",
"嵎":"yu2",
"嵏":"zong1",
"嵐":"lan2",
"嵑":"jue2",
"嵒":"yan2",
"嵓":"yan2",
"嵔":"wei3",
"嵕":"zong1",
"嵖":"cha2",
"嵗":"sui4",
"嵘":"rong2",
"嵙":"ke1",
"嵚":"qin1",
"嵛":"yu2",
"嵝":"lou3",
"嵞":"tu2",
"嵟":"dui1",
"嵠":"xi1",
"嵡":"weng1",
"嵢":"cang1",
"嵣":"dang1",
"嵤":"hong2",
"嵥":"jie2",
"嵦":"ai2",
"嵧":"liu2",
"嵨":"wu3",
"嵩":"song1",
"嵪":"qiao1",
"嵫":"zi1",
"嵬":"wei2",
"嵭":"beng1",
"嵮":"dian1",
"嵯":"cuo2",
"嵰":"qian3",
"嵱":"yong3",
"嵲":"nie4",
"嵳":"cuo2",
"嵴":"ji3",
"嵷":"song3",
"嵸":"zong1",
"嵹":"jiang4",
"嵺":"liao2",
"嵼":"chan3",
"嵽":"die2",
"嵾":"cen1",
"嵿":"ding3",
"嶀":"tu1",
"嶁":"lou3",
"嶂":"zhang4",
"嶃":"zhan3",
"嶅":"ao2",
"嶆":"cao2",
"嶈":"qiang1",
"嶉":"zui1",
"嶊":"zui3",
"嶋":"dao3",
"嶌":"dao3",
"嶍":"xi2",
"嶎":"yu4",
"嶏":"bo2",
"嶐":"long2",
"嶑":"xiang3",
"嶒":"ceng2",
"嶓":"bo1",
"嶔":"qin1",
"嶕":"jiao1",
"嶖":"yan3",
"嶗":"lao2",
"嶘":"zhan4",
"嶙":"lin2",
"嶚":"liao2",
"嶛":"liao2",
"嶜":"jin1",
"嶝":"deng4",
"嶞":"duo4",
"嶟":"zun1",
"嶠":"jiao4",
"嶡":"jue2",
"嶢":"yao2",
"嶣":"qiao2",
"嶤":"yao2",
"嶥":"jue2",
"嶦":"zhan1",
"嶧":"yi4",
"嶨":"xue2",
"嶩":"nao2",
"嶪":"ye4",
"嶫":"ye4",
"嶬":"yi2",
"嶭":"e4",
"嶮":"xian3",
"嶯":"ji2",
"嶰":"xie4",
"嶱":"ke3",
"嶲":"sui3",
"嶳":"di4",
"嶴":"ao4",
"嶵":"zui3",
"嶷":"yi2",
"嶸":"rong2",
"嶹":"dao3",
"嶻":"za2",
"嶽":"yue4",
"嶾":"yin3",
"巀":"jie1",
"巁":"li4",
"巂":"sui3",
"巃":"long2",
"巄":"long2",
"巅":"dian1",
"巆":"ying2",
"巇":"xi1",
"巈":"ju2",
"巉":"chan2",
"巊":"ying3",
"巋":"kui1",
"巌":"yan2",
"巎":"nao2",
"巏":"quan2",
"巐":"chao3",
"巑":"cuan2",
"巓":"dian1",
"巔":"dian1",
"巖":"yan2",
"巗":"yan2",
"巘":"yan3",
"巙":"nao2",
"巚":"yan3",
"巛":"chuan1",
"巜":"gui4",
"川":"chuan1",
"巟":"huang1",
"巠":"jing1",
"巣":"chao2",
"巤":"lie1",
"巫":"wu1",
"巯":"qiu2",
"巰":"qiu2",
"巳":"si4",
"巵":"zhi1",
"巶":"zhao1",
"巸":"yi2",
"巹":"jin3",
"巺":"xun4",
"巻":"juan3",
"巽":"xun4",
"巿":"fu2",
"帀":"za1",
"帄":"ding1",
"帇":"nie4",
"帉":"fen1",
"帊":"pa4",
"帋":"zhi3",
"帍":"hu4",
"帎":"dan4",
"帏":"wei2",
"帑":"tang3",
"帒":"dai4",
"帓":"ma4",
"帔":"pei4",
"帖":"tie1",
"帗":"fu2",
"帙":"zhi4",
"帛":"bo2",
"帞":"mo4",
"帟":"yi4",
"帠":"yi4",
"帡":"ping2",
"帢":"qia4",
"帣":"juan4",
"帤":"ru2",
"帧":"zhen1",
"帨":"shui4",
"帩":"qiao4",
"帪":"zhen1",
"帬":"qun2",
"帯":"dai4",
"帰":"gui1",
"帱":"dao4",
"帲":"ping2",
"帴":"sha1",
"帵":"wan1",
"帷":"wei2",
"帹":"qie4",
"帺":"qi2",
"帻":"ze2",
"帼":"guo2",
"帾":"du3",
"帿":"hou2",
"幀":"zhen1",
"幁":"xu1",
"幂":"mi4",
"幃":"wei2",
"幄":"wo4",
"幆":"yi4",
"幇":"bang1",
"幈":"ping2",
"幊":"gong1",
"幋":"pan2",
"幌":"huang3",
"幍":"dao1",
"幎":"mi4",
"幏":"jia1",
"幐":"teng2",
"幑":"hui1",
"幒":"zhong1",
"幓":"shan1",
"幔":"man4",
"幖":"biao1",
"幗":"guo2",
"幘":"ze2",
"幙":"mu4",
"幚":"bang1",
"幛":"zhang4",
"幜":"jiong3",
"幝":"chan3",
"幞":"fu2",
"幠":"hu1",
"幡":"fan1",
"幢":"chuang2",
"幦":"mi4",
"幧":"qiao1",
"幨":"chan1",
"幩":"fen2",
"幪":"meng2",
"幬":"dao4",
"幭":"mie4",
"幮":"chu2",
"幯":"jie2",
"幰":"xian3",
"幱":"lan2",
"幵":"qian1",
"幷":"bing4",
"幹":"gan4",
"幺":"yao1",
"幽":"you1",
"庀":"pi3",
"庁":"ting1",
"庂":"ze4",
"広":"guang3",
"庅":"mo5",
"庇":"bi4",
"庈":"qin2",
"庉":"dun4",
"庋":"gui3",
"庌":"ya3",
"庍":"bai4",
"庎":"jie4",
"庐":"lu2",
"庑":"wu3",
"庖":"pao2",
"庘":"ya1",
"庚":"geng1",
"庛":"ci1",
"庝":"tong2",
"庠":"xiang2",
"庡":"yi3",
"庢":"zhi4",
"庣":"tiao1",
"庤":"zhi4",
"庥":"xiu1",
"庨":"xiao1",
"庩":"tu2",
"庪":"gui3",
"庬":"pang2",
"庮":"you3",
"庯":"bu1",
"庰":"ding1",
"庱":"cheng3",
"庲":"lai2",
"庳":"bi4",
"庴":"ji2",
"庵":"an1",
"庶":"shu4",
"庹":"tuo3",
"庺":"song1",
"庻":"shu4",
"庼":"qing3",
"庽":"yu4",
"庾":"yu3",
"庿":"miao4",
"廀":"sou1",
"廃":"fei4",
"廄":"jiu4",
"廅":"he2",
"廆":"hui4",
"廇":"liu4",
"廊":"lang2",
"廋":"sou1",
"廌":"zhi4",
"廍":"pou3",
"廎":"qing3",
"廏":"jiu4",
"廐":"jiu4",
"廑":"jin3",
"廒":"ao2",
"廔":"lou2",
"廕":"yin4",
"廖":"liao4",
"廗":"dai4",
"廘":"lu4",
"廙":"yi4",
"廛":"chan2",
"廜":"tu1",
"廝":"si1",
"廞":"xin1",
"廡":"wu3",
"廥":"kuai4",
"廦":"bi4",
"廧":"qiang2",
"廨":"xie4",
"廩":"lin3",
"廪":"lin3",
"廫":"liao2",
"廬":"lu2",
"廮":"ying2",
"廯":"xian1",
"廰":"ting1",
"廱":"yong1",
"廲":"li2",
"廴":"yin3",
"廵":"xun2",
"廷":"ting2",
"廸":"di2",
"廹":"po4",
"廻":"hui2",
"廼":"nai3",
"廽":"hui2",
"廾":"gong3",
"弁":"bian4",
"弅":"fen2",
"弆":"ju3",
"弇":"yan3",
"弈":"yi4",
"弉":"zang4",
"弊":"bi4",
"弋":"yi4",
"弌":"yi1",
"弍":"er4",
"弎":"san1",
"弐":"er4",
"弑":"shi4",
"弒":"shi4",
"弔":"diao4",
"弖":"hu4",
"弗":"fu2",
"弘":"hong2",
"弙":"wu1",
"弚":"tui2",
"弛":"chi2",
"弜":"jiang4",
"弝":"ba4",
"弞":"shen3",
"弡":"jue2",
"弢":"tao1",
"弣":"fu3",
"弤":"di3",
"弧":"hu2",
"弨":"chao1",
"弩":"nu3",
"弪":"jing4",
"弫":"zhen3",
"弬":"yi2",
"弭":"mi3",
"弮":"quan1",
"弰":"shao1",
"弲":"xuan1",
"弳":"jing4",
"弴":"dun1",
"弶":"jiang4",
"弸":"beng1",
"弻":"bi4",
"弼":"bi4",
"弽":"she4",
"弾":"dan4",
"弿":"jian3",
"彀":"gou4",
"彂":"fa1",
"彃":"bi4",
"彄":"kou1",
"彆":"bie4",
"彇":"xiao1",
"彉":"kuo4",
"彊":"qiang2",
"彋":"hong2",
"彍":"kuo4",
"彏":"jue2",
"彐":"ji4",
"彑":"ji4",
"彔":"lu4",
"彖":"tuan4",
"彗":"hui4",
"彘":"zhi4",
"彙":"hui4",
"彚":"hui4",
"彛":"yi2",
"彜":"yi2",
"彝":"yi2",
"彞":"yi2",
"彟":"huo4",
"彠":"huo4",
"彡":"shan1",
"彣":"wen2",
"彤":"tong2",
"彥":"yan4",
"彦":"yan4",
"彧":"yu4",
"彨":"chi1",
"彪":"biao1",
"彫":"diao1",
"彬":"bin1",
"彭":"peng2",
"彮":"yong3",
"彯":"piao1",
"彰":"zhang1",
"彲":"chi1",
"彳":"chi4",
"彴":"zhuo2",
"彵":"tuo3",
"彶":"ji2",
"彷":"fang3",
"彸":"zhong1",
"彺":"wang2",
"彽":"chi2",
"彾":"ling3",
"彿":"fu2",
"徂":"cu2",
"徃":"wang3",
"徆":"xi1",
"徇":"xun4",
"徉":"yang2",
"後":"hou4",
"徍":"wa1",
"徎":"cheng3",
"徏":"zhi4",
"従":"cong2",
"徕":"lai2",
"徖":"cong2",
"徙":"xi3",
"徛":"qi4",
"徜":"chang2",
"徝":"zhi4",
"徟":"zhou1",
"徠":"lai2",
"徢":"xie4",
"徣":"jie4",
"徤":"jian4",
"徥":"chi2",
"徦":"jia3",
"徧":"bian4",
"徨":"huang2",
"復":"fu4",
"徫":"wei3",
"徬":"pang2",
"徭":"yao2",
"徯":"xi1",
"徰":"zheng1",
"徱":"piao4",
"徲":"chi2",
"徳":"de2",
"徴":"zheng1",
"徵":"zhi3",
"徶":"bie4",
"徸":"chong1",
"徺":"jiao3",
"徻":"wei4",
"徼":"jiao3",
"徽":"hui1",
"徾":"mei2",
"徿":"long4",
"忀":"xiang1",
"忁":"bao4",
"忂":"qu2",
"忇":"le4",
"忈":"ren2",
"忉":"dao1",
"忊":"ding4",
"忋":"gai3",
"忌":"ji4",
"忎":"ren2",
"忏":"chan4",
"忐":"tan3",
"忑":"te4",
"忒":"te4",
"忓":"gan1",
"忔":"qi4",
"忕":"shi4",
"忖":"cun3",
"忚":"xi1",
"忛":"fan2",
"応":"ying4",
"忝":"tian3",
"忞":"min2",
"忟":"min2",
"忡":"chong1",
"忢":"wu4",
"忣":"ji2",
"忤":"wu3",
"忥":"xi4",
"忦":"ye4",
"忨":"wan4",
"忩":"cong1",
"忪":"zhong1",
"忬":"yu4",
"忭":"bian4",
"忮":"zhi4",
"忯":"qi2",
"忰":"cui4",
"忲":"tai4",
"忳":"tun2",
"忴":"qian2",
"忶":"hun2",
"忷":"xiong1",
"忸":"niu3",
"忹":"wang3",
"忺":"xian1",
"忻":"xin1",
"忼":"kang1",
"忾":"kai4",
"怂":"song3",
"怃":"wu3",
"怄":"ou4",
"怅":"chang4",
"怆":"chuang4",
"怇":"ju4",
"怈":"yi4",
"怉":"bao3",
"怊":"chao1",
"怋":"min2",
"怌":"pei1",
"怍":"zuo4",
"怏":"yang4",
"怐":"kou4",
"怑":"ban4",
"怓":"nao2",
"怗":"tie1",
"怘":"gu4",
"怙":"hu4",
"怚":"ju4",
"怛":"da2",
"怞":"zhou4",
"怟":"di4",
"怠":"dai4",
"怡":"yi2",
"怢":"tu2",
"怣":"you2",
"怤":"fu1",
"怩":"ni2",
"怫":"fei4",
"怬":"xi4",
"怭":"bi4",
"怮":"you1",
"怰":"xuan4",
"怱":"cong1",
"怲":"bing3",
"怳":"huang3",
"怴":"xu4",
"怵":"chu4",
"怶":"pi1",
"怷":"xi1",
"怸":"xi1",
"怹":"tan1",
"怼":"dui4",
"怿":"yi4",
"恀":"chi3",
"恁":"nen4",
"恂":"xun2",
"恃":"shi4",
"恄":"xi4",
"恅":"lao3",
"恇":"kuang1",
"恈":"mu2",
"恉":"zhi3",
"恊":"xie2",
"恌":"tiao1",
"恎":"die2",
"恏":"hao3",
"恑":"gui3",
"恓":"xi1",
"恔":"xiao4",
"恕":"shu4",
"恗":"kua3",
"恘":"qiu1",
"恙":"yang4",
"恚":"hui4",
"恛":"hui2",
"恜":"chi4",
"恝":"jia2",
"恞":"yi2",
"恟":"xiong1",
"恠":"guai4",
"恡":"lin4",
"恣":"zi4",
"恤":"xu4",
"恦":"xiang4",
"恧":"nv4",
"恩":"en1",
"恪":"ke4",
"恫":"dong4",
"恬":"tian2",
"恭":"gong1",
"恮":"quan2",
"恱":"yue4",
"恲":"peng1",
"恴":"de2",
"恵":"hui4",
"恸":"tong4",
"恹":"yan1",
"恺":"kai3",
"恻":"ce4",
"恽":"yun4",
"恾":"mang2",
"恿":"yong3",
"悀":"yong3",
"悁":"yuan1",
"悂":"pi1",
"悃":"kun3",
"悆":"yu4",
"悇":"yu4",
"悈":"jie4",
"悊":"zhe2",
"悋":"lin4",
"悌":"ti4",
"悍":"han4",
"悎":"hao4",
"悏":"qie4",
"悐":"ti4",
"悑":"bu4",
"悒":"yi4",
"悓":"qian4",
"悕":"xi1",
"悖":"bei4",
"悗":"man2",
"悘":"yi1",
"悙":"heng1",
"悚":"song3",
"悛":"quan1",
"悜":"cheng3",
"悝":"li3",
"悞":"wu4",
"悡":"li2",
"悢":"liang4",
"悤":"cong1",
"悥":"yi4",
"悧":"li4",
"悩":"nao3",
"悪":"e4",
"悫":"que4",
"悭":"qian1",
"悮":"wu4",
"悯":"min3",
"悰":"cong2",
"悱":"fei3",
"悳":"duo2",
"悴":"cui4",
"悵":"chang4",
"悷":"li4",
"悸":"ji4",
"悹":"guan4",
"悺":"guan4",
"悻":"xing4",
"悽":"qi1",
"悾":"kong1",
"悿":"tian3",
"惀":"lun2",
"惁":"xi1",
"惂":"kan3",
"惃":"kun1",
"惄":"ni4",
"惆":"chou2",
"惇":"dun1",
"惈":"guo3",
"惉":"chan1",
"惌":"yuan1",
"惍":"jin1",
"惎":"ji4",
"惏":"lin2",
"惐":"yu4",
"惒":"he2",
"惓":"quan2",
"惔":"yan3",
"惖":"ti4",
"惗":"nie1",
"惘":"wang3",
"惙":"chuo4",
"惛":"hun1",
"惝":"tang3",
"惞":"xin1",
"惠":"hui4",
"惢":"rui3",
"惣":"zong3",
"惤":"jian1",
"惥":"yong3",
"惪":"de2",
"惫":"bei4",
"惬":"qie4",
"惮":"dan4",
"惰":"duo4",
"惲":"yun4",
"惴":"zhui4",
"惵":"die4",
"惷":"chun3",
"惸":"qiong2",
"惺":"xing1",
"惻":"ce4",
"惼":"bian3",
"惽":"hun1",
"惾":"zong1",
"惿":"ti2",
"愀":"qiao3",
"愂":"bei4",
"愃":"xuan1",
"愄":"wei1",
"愅":"ge2",
"愆":"qian1",
"愇":"wei3",
"愊":"bi4",
"愋":"xuan1",
"愌":"huan4",
"愍":"min3",
"愎":"bi4",
"愐":"mian3",
"愑":"yong3",
"愒":"kai4",
"愓":"dang4",
"愔":"yin1",
"愖":"chen2",
"愗":"mou4",
"愘":"ke4",
"愙":"ke4",
"愜":"qie4",
"愝":"yan3",
"愞":"nuo4",
"愠":"yun4",
"愡":"zong3",
"愢":"sai1",
"愦":"kui4",
"愨":"que4",
"愩":"gong1",
"愪":"yun2",
"愫":"su4",
"愬":"se4",
"愭":"qi2",
"愮":"yao2",
"愯":"song3",
"愰":"huang3",
"愱":"ji2",
"愲":"gu3",
"愳":"ju4",
"愴":"chuang4",
"愵":"ni4",
"愶":"xie2",
"愷":"kai3",
"愸":"zheng3",
"愹":"yong3",
"愺":"cao3",
"愻":"sun4",
"愼":"shen4",
"愽":"bo2",
"愾":"kai4",
"慀":"xie2",
"慁":"hun4",
"慂":"yong3",
"慃":"yang3",
"慄":"li4",
"慅":"sao1",
"慆":"tao1",
"慇":"yin1",
"慉":"xu4",
"慊":"qian4",
"慍":"yun4",
"慏":"ming3",
"慑":"she4",
"慒":"cong2",
"慓":"piao4",
"慔":"mo4",
"慖":"guo2",
"慗":"chi4",
"慙":"can2",
"慛":"cui2",
"慜":"min3",
"慝":"te4",
"慞":"zhang1",
"慟":"tong4",
"慠":"ao4",
"慡":"shuang3",
"慤":"que4",
"慥":"zao4",
"慦":"jiu4",
"慩":"lian2",
"慪":"ou4",
"慫":"song3",
"慬":"jin3",
"慭":"yin4",
"慯":"shang1",
"慱":"tuan2",
"慲":"man2",
"慳":"qian1",
"慴":"she4",
"慵":"yong1",
"慸":"di4",
"慹":"zhi2",
"慺":"lou2",
"慻":"juan4",
"慼":"qi1",
"慽":"qi1",
"慾":"yu4",
"慿":"ping2",
"憀":"liao2",
"憁":"cong1",
"憃":"chong1",
"憄":"zhi4",
"憅":"tong4",
"憆":"cheng1",
"憇":"qi4",
"憈":"qu1",
"憉":"peng2",
"憊":"bei4",
"憌":"chun2",
"憍":"jiao1",
"憎":"zeng1",
"憏":"chi4",
"憒":"kui4",
"憓":"hui4",
"憔":"qiao2",
"憕":"cheng2",
"憖":"yin4",
"憗":"yin4",
"憘":"xi3",
"憙":"xi3",
"憚":"dan4",
"憛":"tan2",
"憜":"duo3",
"憝":"dui4",
"憞":"dui4",
"憟":"su4",
"憠":"jue2",
"憡":"ce4",
"憢":"xiao1",
"憣":"fan2",
"憥":"lao2",
"憦":"lao4",
"憨":"han1",
"憩":"qi4",
"憪":"xian2",
"憫":"min3",
"憭":"liao3",
"憮":"wu3",
"憯":"can3",
"憰":"jue2",
"憱":"cu4",
"憳":"tan3",
"憴":"sheng2",
"憵":"pi1",
"憷":"chu3",
"憸":"xian1",
"憹":"nao2",
"憺":"dan4",
"憻":"tan3",
"憼":"jing3",
"憽":"song1",
"憿":"jiao1",
"懀":"wai4",
"懁":"huan2",
"懃":"qin2",
"懄":"qin2",
"懅":"qu2",
"懆":"cao3",
"懈":"xie4",
"懊":"ao4",
"懋":"mao4",
"懌":"yi4",
"懍":"lin3",
"懎":"se4",
"懏":"jun4",
"懐":"huai2",
"懑":"men4",
"懓":"ai4",
"懔":"lin3",
"懕":"yan1",
"懖":"gua1",
"懗":"xia4",
"懘":"chi4",
"懙":"yu3",
"懚":"yin4",
"懛":"dai1",
"懜":"meng4",
"懝":"ai4",
"懞":"meng2",
"懟":"dui4",
"懠":"qi2",
"懡":"mo3",
"懢":"lan2",
"懣":"men4",
"懤":"chou2",
"懥":"zhi4",
"懦":"nuo4",
"懧":"nuo4",
"懨":"yan1",
"懩":"yang3",
"懪":"bo2",
"懫":"zhi2",
"懬":"kuang4",
"懭":"kuang4",
"懮":"you3",
"懯":"fu1",
"懰":"liu2",
"懱":"mie4",
"懴":"chan4",
"懵":"meng3",
"懹":"rang4",
"懺":"chan4",
"懻":"ji4",
"懽":"huan1",
"懾":"she4",
"懿":"yi4",
"戁":"nan3",
"戂":"mi2",
"戃":"tang3",
"戄":"jue2",
"戅":"gang4",
"戆":"zhuang4",
"戇":"zhuang4",
"戈":"ge1",
"戉":"yue4",
"戊":"wu4",
"戋":"jian1",
"戌":"xu1",
"戍":"shu4",
"戎":"rong2",
"戓":"ge1",
"戔":"jian1",
"戕":"qiang1",
"戗":"qiang1",
"戙":"dong4",
"戛":"jia2",
"戜":"die2",
"戝":"zei2",
"戞":"jia2",
"戟":"ji3",
"戠":"zhi2",
"戡":"kan1",
"戢":"ji2",
"戣":"kui2",
"戤":"gai4",
"戥":"deng3",
"戦":"zhan4",
"戧":"qiang1",
"戨":"ge1",
"戩":"jian3",
"戫":"yu4",
"戬":"jian3",
"戭":"yan3",
"戮":"lu4",
"戯":"xi4",
"戱":"xi4",
"戳":"chuo1",
"戵":"qu2",
"戸":"hu4",
"戹":"e4",
"戺":"shi4",
"戻":"li4",
"戼":"mao3",
"戽":"hu4",
"戾":"li4",
"扂":"dian4",
"扃":"jiong1",
"扄":"shang3",
"扅":"yi2",
"扆":"yi3",
"扈":"hu4",
"扉":"fei1",
"扊":"yan3",
"扏":"qiu2",
"扐":"le4",
"払":"fan3",
"扗":"zai4",
"扙":"zhang4",
"扚":"diao1",
"扜":"yu1",
"扝":"ku1",
"扞":"han4",
"扟":"shen1",
"扠":"cha1",
"扡":"chi3",
"扢":"xi4",
"扤":"wu4",
"扥":"tuo1",
"扦":"qian1",
"扨":"ren4",
"扪":"men2",
"扱":"xi1",
"扲":"qian2",
"扴":"jia2",
"扵":"yu2",
"扷":"ao4",
"扸":"xi1",
"扺":"zhi3",
"扻":"zi4",
"扼":"e4",
"扽":"den4",
"抁":"yan3",
"抂":"kuang2",
"抃":"bian4",
"抅":"ju1",
"抆":"wen3",
"抇":"hu2",
"抈":"yue4",
"抉":"jue2",
"抋":"qin4",
"抌":"zhen3",
"抍":"zheng3",
"抎":"yun3",
"抏":"wan2",
"抐":"nu4",
"抒":"shu1",
"抔":"pou2",
"抙":"pou2",
"抜":"ba2",
"抝":"ao3",
"択":"ze2",
"抟":"tuan2",
"抠":"kou1",
"抦":"bing3",
"抧":"zhi3",
"抨":"peng1",
"抩":"tan1",
"抪":"pu1",
"抭":"yao3",
"抮":"zhen3",
"抯":"zha1",
"抰":"yang3",
"抲":"he1",
"抳":"ni3",
"抴":"yi4",
"抶":"chi4",
"抷":"pi1",
"抸":"za1",
"抺":"mei4",
"抻":"chen1",
"抾":"qu1",
"拀":"chu4",
"拁":"jia1",
"拂":"fu2",
"拃":"zha3",
"拈":"nian1",
"拊":"fu3",
"拎":"lin1",
"拏":"na2",
"拑":"qian2",
"拓":"ta4",
"拕":"tuo1",
"拗":"ao3",
"拙":"zhuo1",
"拚":"pin1",
"拝":"bai4",
"拞":"di3",
"拠":"ju4",
"拡":"kuo4",
"拪":"qian1",
"拫":"hen2",
"拮":"jie2",
"拯":"zheng3",
"拰":"nin3",
"拲":"gong3",
"拵":"cun2",
"拶":"zan3",
"拷":"kao3",
"拸":"chi3",
"拹":"xie2",
"拺":"ce4",
"拻":"hui1",
"拽":"ye4",
"挀":"bo4",
"挃":"zhi4",
"挄":"kuo4",
"挅":"duo3",
"挆":"duo3",
"挈":"qie4",
"挊":"nong4",
"挋":"zhen4",
"挌":"ge2",
"挍":"jiao4",
"挏":"dong4",
"挐":"na2",
"挒":"lie4",
"挓":"zha1",
"挔":"lv3",
"挕":"die2",
"挗":"jue2",
"挙":"ju3",
"挚":"zhi4",
"挛":"luan2",
"挜":"ya4",
"挝":"zhua1",
"挞":"ta4",
"挠":"nao2",
"挢":"jiao3",
"挦":"xian2",
"挩":"tuo1",
"挪":"nuo2",
"挬":"bo2",
"挭":"geng3",
"挮":"ti3",
"挰":"cheng2",
"挱":"suo1",
"挲":"suo1",
"挳":"keng1",
"挴":"mei3",
"挵":"long4",
"挶":"ju2",
"挷":"peng2",
"挸":"jian3",
"挹":"yi4",
"挻":"shan1",
"挼":"nuo4",
"挿":"cha1",
"捀":"feng1",
"捁":"jiao3",
"捃":"jun4",
"捄":"jiu4",
"捅":"tong3",
"捇":"huo4",
"捈":"tu2",
"捊":"pou2",
"捋":"le4",
"捌":"ba1",
"捑":"ze2",
"捒":"song3",
"捓":"ye2",
"捔":"jue2",
"捖":"huan2",
"捗":"bu4",
"捘":"zun4",
"捙":"yi4",
"捚":"zhai1",
"捛":"lv3",
"捜":"sou1",
"捝":"tuo1",
"捠":"bang1",
"捥":"wan4",
"捦":"qin2",
"捨":"she3",
"捩":"lie4",
"捪":"min2",
"捫":"men2",
"捬":"fu3",
"捭":"bai3",
"捯":"dao3",
"捰":"wo3",
"捱":"ai2",
"捲":"juan3",
"捳":"yue4",
"捴":"zong3",
"捵":"chen3",
"捸":"tu1",
"捹":"ben4",
"捺":"na4",
"捼":"nuo2",
"捽":"zuo2",
"捾":"wo4",
"捿":"xi1",
"掁":"cheng2",
"掂":"dian1",
"掅":"qing4",
"掆":"gang1",
"掇":"duo1",
"掊":"pou3",
"掋":"di3",
"掍":"gun3",
"掎":"ji3",
"掑":"qi2",
"掓":"shu2",
"掔":"qian1",
"掕":"ling4",
"掖":"ye1",
"掗":"ya4",
"掚":"liang3",
"掜":"yi3",
"掝":"huo4",
"掞":"shan4",
"掟":"zheng3",
"採":"cai3",
"掣":"che4",
"掤":"bing1",
"掦":"ti4",
"掫":"zou1",
"掬":"ju1",
"掭":"tian4",
"掮":"qian2",
"掯":"ken4",
"掱":"shou3",
"掲":"jie1",
"掳":"lu3",
"掴":"guo2",
"掸":"dan3",
"掺":"chan1",
"掻":"sao1",
"掼":"guan4",
"掽":"peng4",
"掾":"yuan4",
"掿":"nuo4",
"揁":"zhen1",
"揂":"jiu1",
"揃":"jian1",
"揄":"yu2",
"揅":"yan2",
"揆":"kui2",
"揇":"nan3",
"揈":"hong1",
"揊":"pi4",
"揋":"wei1",
"揌":"sai1",
"揎":"xuan1",
"揑":"nie1",
"揓":"shi4",
"揔":"zong3",
"揕":"zhen4",
"揖":"yi1",
"揗":"shun3",
"揘":"huang2",
"揙":"bian4",
"揜":"yan3",
"揝":"zuan4",
"揞":"an3",
"揟":"xu1",
"揠":"ya4",
"揢":"ke4",
"揤":"ji2",
"揥":"ti4",
"揦":"la2",
"揧":"la4",
"揨":"cheng2",
"揫":"jiu1",
"揬":"tu2",
"揯":"geng1",
"揰":"chong4",
"揱":"shuo4",
"揲":"she2",
"揳":"xie4",
"揵":"qian2",
"揶":"ye2",
"揷":"cha1",
"揸":"zha1",
"揹":"bei1",
"揺":"yao2",
"揽":"lan3",
"揾":"wen4",
"揿":"qin4",
"搃":"zong3",
"搄":"geng1",
"搆":"gou4",
"搇":"qin4",
"搈":"yong3",
"搉":"que4",
"搊":"chou1",
"搋":"chuai1",
"搌":"zhan3",
"搎":"sun1",
"搐":"chu4",
"搑":"rong3",
"搒":"bang4",
"搕":"ke4",
"搘":"zhi1",
"搙":"nu4",
"搚":"xie2",
"搛":"jian1",
"搝":"qiu3",
"搟":"xian3",
"搠":"shuo4",
"搡":"sang3",
"搢":"jin4",
"搣":"mie4",
"搤":"e4",
"搥":"chui2",
"搦":"nuo4",
"搧":"shan1",
"搨":"ta4",
"搩":"jie2",
"搫":"pan2",
"搮":"li4",
"搯":"tao1",
"搰":"hu2",
"搱":"zhi4",
"搲":"wa1",
"搳":"xia2",
"搴":"qian1",
"搵":"wen4",
"搷":"chen1",
"搸":"zhen1",
"搹":"e4",
"搻":"nuo4",
"搼":"quan2",
"搽":"cha2",
"搾":"zha4",
"搿":"ge2",
"摀":"wu3",
"摁":"en4",
"摂":"she4",
"摃":"kang2",
"摅":"shu1",
"摈":"bin4",
"摉":"sou1",
"摋":"sa4",
"摌":"chan3",
"摍":"suo1",
"摎":"liao2",
"摏":"chong1",
"摐":"chuang1",
"摑":"guo2",
"摒":"bing4",
"摓":"feng2",
"摕":"di4",
"摖":"qi4",
"摙":"lian3",
"摚":"tang2",
"摛":"chi1",
"摜":"guan4",
"摝":"lu4",
"摞":"luo4",
"摠":"zong3",
"摡":"gai4",
"摢":"hu4",
"摣":"zha1",
"摤":"chuang3",
"摥":"tang4",
"摦":"hua4",
"摨":"nai2",
"摪":"jiang1",
"摫":"gui1",
"摬":"ying4",
"摭":"zhi2",
"摮":"ao2",
"摯":"zhi4",
"摰":"nie4",
"摱":"man2",
"摲":"shan4",
"摳":"kou1",
"摴":"chu1",
"摵":"suo3",
"摶":"tuan2",
"摷":"jiao3",
"摹":"mo2",
"摺":"zhe2",
"摻":"chan1",
"摼":"keng1",
"摽":"piao1",
"摾":"jiang4",
"摿":"yin1",
"撀":"gou4",
"撁":"qian1",
"撃":"ji2",
"撄":"ying1",
"撆":"pie1",
"撇":"pie3",
"撉":"dun1",
"撊":"xian4",
"撋":"ruan2",
"撌":"kui4",
"撍":"zan3",
"撎":"yi4",
"撏":"xian2",
"撓":"nao2",
"撔":"heng4",
"撖":"qian3",
"撗":"huang2",
"撘":"da1",
"撙":"zun3",
"撚":"nian3",
"撛":"lin3",
"撜":"zheng3",
"撝":"hui1",
"撟":"jiao3",
"撠":"ji3",
"撡":"cao1",
"撢":"dan3",
"撣":"dan3",
"撦":"che3",
"撧":"jue2",
"撨":"xiao1",
"撪":"ben4",
"撬":"qiao4",
"撮":"cuo1",
"撯":"zhuo2",
"撰":"zhuan4",
"撱":"tuo3",
"撳":"qin4",
"撴":"dun1",
"撷":"xie2",
"撸":"lu3",
"撹":"jiao3",
"撺":"cuan1",
"撻":"ta4",
"撽":"qiao4",
"撾":"zhua1",
"擀":"gan3",
"擂":"lei4",
"擃":"kuo3",
"擄":"lu3",
"擅":"shan4",
"擆":"zhuo2",
"擈":"pu1",
"擉":"chuo4",
"擌":"suo3",
"擎":"qing2",
"擏":"jing4",
"擐":"huan4",
"擑":"jie1",
"擒":"qin2",
"擓":"kuai3",
"擕":"xi1",
"擖":"ka1",
"擗":"pi3",
"擘":"bo4",
"擙":"ao4",
"擛":"ye4",
"擞":"sou3",
"擟":"mi2",
"擡":"tai2",
"擢":"zhuo2",
"擣":"dao3",
"擤":"xing3",
"擥":"lan3",
"擧":"ju3",
"擨":"ye2",
"擩":"ru3",
"擪":"ye4",
"擫":"ye4",
"擭":"huo4",
"擮":"ji2",
"擯":"bin4",
"擳":"jie2",
"擵":"mo2",
"擶":"jian4",
"擷":"xie2",
"擸":"lie4",
"擹":"tan1",
"擻":"sou3",
"擼":"lu3",
"擽":"lve4",
"擿":"ti1",
"攁":"yang3",
"攂":"lei4",
"攃":"sa4",
"攄":"shu1",
"攅":"zan3",
"攇":"xian3",
"攈":"jun4",
"攉":"huo4",
"攊":"li4",
"攋":"la4",
"攌":"han4",
"攍":"ying2",
"攎":"lu2",
"攐":"qian1",
"攑":"qian1",
"攓":"qian1",
"攕":"san1",
"攖":"ying1",
"攗":"mei2",
"攘":"rang3",
"攛":"cuan1",
"攞":"luo3",
"攟":"jun4",
"攠":"mi2",
"攡":"li2",
"攣":"luan2",
"攦":"li4",
"攧":"dian1",
"攨":"wa1",
"攩":"dang3",
"攫":"jue2",
"攬":"lan3",
"攭":"li4",
"攮":"nang3",
"攰":"gui4",
"攱":"gui3",
"攲":"qi1",
"攳":"xin2",
"攴":"pu1",
"攵":"sui1",
"攷":"kao3",
"攸":"you1",
"攺":"yi3",
"攼":"gan1",
"攽":"ban1",
"敀":"bo2",
"敁":"dian1",
"敂":"kou4",
"敃":"min3",
"敄":"wu4",
"敆":"he2",
"敇":"ce4",
"敉":"mi3",
"敊":"chu4",
"敋":"ge2",
"敍":"xu4",
"敎":"jiao4",
"敐":"chen2",
"敒":"zhen4",
"敓":"duo2",
"敔":"yu3",
"敕":"chi4",
"敖":"ao2",
"敚":"duo2",
"敛":"lian3",
"敜":"nie4",
"敝":"bi4",
"敟":"dian3",
"敠":"duo2",
"敡":"yi4",
"敤":"ke3",
"敥":"yan4",
"敦":"dun1",
"敧":"qi3",
"敨":"dou3",
"敩":"xiao4",
"敪":"duo2",
"敫":"jiao4",
"敭":"yang2",
"敮":"xia2",
"敯":"min2",
"敱":"ai2",
"敳":"ai2",
"敶":"zhen4",
"敹":"liao2",
"敺":"qu1",
"敻":"xiong4",
"敼":"xi3",
"敽":"jiao3",
"敿":"jiao3",
"斀":"zhuo2",
"斁":"yi4",
"斂":"lian3",
"斄":"tai2",
"斅":"xiao4",
"斆":"xiao4",
"斈":"xue2",
"斉":"qi2",
"斊":"qi2",
"斋":"zhai1",
"斌":"bin1",
"斍":"jue2",
"斎":"zhai1",
"斐":"fei3",
"斑":"ban1",
"斒":"ban1",
"斓":"lan2",
"斔":"yu3",
"斕":"lan2",
"斖":"wei3",
"斘":"sheng1",
"斚":"jia3",
"斛":"hu2",
"斝":"jia3",
"斞":"yu3",
"斟":"zhen1",
"斠":"jiao4",
"斡":"wo4",
"斢":"tou3",
"斣":"chu4",
"斦":"yin2",
"斨":"qiang1",
"斩":"zhan3",
"斪":"qu2",
"斫":"zhuo2",
"斬":"zhan3",
"斮":"zhuo2",
"斱":"zhuo2",
"斲":"zhuo2",
"斳":"qin2",
"斴":"lin2",
"斵":"zhuo2",
"斶":"chu4",
"斸":"zhu3",
"斺":"xie4",
"斻":"hang2",
"於":"yu1",
"斾":"pei4",
"斿":"you2",
"旂":"qi2",
"旃":"zhan1",
"旄":"mao4",
"旆":"pei4",
"旇":"pi1",
"旈":"liu2",
"旉":"fu1",
"旊":"fang3",
"旌":"jing1",
"旍":"jing1",
"旎":"ni3",
"旐":"zhao4",
"旑":"yi3",
"旒":"liu2",
"旓":"shao1",
"旔":"jian4",
"旖":"yi3",
"旘":"zhi4",
"旙":"fan1",
"旚":"piao1",
"旛":"fan1",
"旜":"zhan1",
"旝":"guai4",
"旞":"sui4",
"旟":"yu2",
"旡":"ji4",
"旣":"ji4",
"旤":"huo4",
"旨":"zhi3",
"旪":"xie2",
"旫":"tiao1",
"旭":"xu4",
"旮":"ga1",
"旯":"la2",
"旰":"gan4",
"旲":"tai2",
"旳":"di4",
"旴":"xu1",
"旵":"chan3",
"旸":"yang2",
"旹":"shi2",
"旻":"min2",
"旼":"min2",
"旽":"tun1",
"旾":"chun1",
"旿":"wu3",
"昀":"yun2",
"昁":"bei4",
"昃":"ze4",
"昄":"ban3",
"昅":"jie2",
"昇":"sheng1",
"昈":"hu4",
"昉":"fang3",
"昊":"hao4",
"昋":"gui4",
"昌":"chang1",
"昍":"xuan1",
"昐":"fen1",
"昑":"qin3",
"昒":"hu1",
"昔":"xi1",
"昕":"xin1",
"昖":"yan2",
"昗":"ze4",
"昘":"fang3",
"昙":"tan2",
"昚":"shen4",
"昛":"ju4",
"昜":"yang2",
"昝":"zan3",
"昞":"bing3",
"昡":"xuan4",
"昢":"pei3",
"昣":"zhen3",
"昤":"ling1",
"昦":"hao4",
"昩":"mo4",
"昪":"bian4",
"昫":"xu4",
"昬":"hun1",
"昭":"zhao1",
"昮":"zong4",
"昰":"shi4",
"昱":"yu4",
"昲":"fei4",
"昳":"yi4",
"昴":"mao3",
"昵":"ni4",
"昶":"chang3",
"昷":"wen1",
"昸":"dong1",
"昹":"ai3",
"昺":"bing3",
"昻":"ang2",
"昽":"long2",
"昿":"kuang4",
"晀":"tiao3",
"晁":"chao2",
"晄":"huang3",
"晅":"xuan3",
"晆":"kui2",
"晇":"xu1",
"晈":"jiao3",
"晉":"jin4",
"晊":"zhi3",
"晋":"jin4",
"晍":"tong2",
"晎":"hong3",
"晏":"yan4",
"晐":"gai1",
"晑":"xiang3",
"晔":"ye4",
"晖":"hui1",
"晗":"han2",
"晘":"han4",
"晙":"jun4",
"晛":"xian4",
"晜":"kun1",
"晞":"xi1",
"晟":"sheng4",
"晠":"sheng2",
"晡":"bu1",
"晢":"zhe2",
"晣":"zhe1",
"晤":"wu4",
"晥":"wan3",
"晦":"hui4",
"晧":"hao4",
"晩":"wan3",
"晪":"tian3",
"晫":"zhuo2",
"晬":"zui4",
"晭":"zhou3",
"晱":"shan3",
"晲":"yi3",
"晳":"xi4",
"晵":"qi3",
"晷":"gui3",
"晸":"zhen3",
"晹":"yi4",
"晻":"an3",
"晼":"wan3",
"晽":"lin2",
"晿":"chang1",
"暀":"wang3",
"暁":"xiao3",
"暅":"xuan3",
"暆":"yi2",
"暇":"xia2",
"暉":"hui1",
"暊":"fu3",
"暋":"min3",
"暌":"kui2",
"暍":"ye1",
"暎":"ying4",
"暏":"du3",
"暐":"wei3",
"暒":"qing2",
"暓":"mao4",
"暔":"nan2",
"暕":"jian3",
"暘":"yang2",
"暙":"chun1",
"暚":"yao2",
"暛":"suo3",
"暜":"jin4",
"暝":"ming2",
"暞":"jiao3",
"暟":"kai3",
"暠":"gao3",
"暡":"weng3",
"暣":"qi4",
"暤":"hao4",
"暥":"yan4",
"暦":"li4",
"暧":"ai4",
"暨":"ji4",
"暩":"gui4",
"暪":"men3",
"暬":"xie4",
"暭":"hao4",
"暮":"mu4",
"暯":"mo4",
"暰":"cong1",
"暱":"ni4",
"暲":"zhang1",
"暳":"hui4",
"暵":"han4",
"暶":"xuan2",
"暷":"chuan2",
"暸":"liao3",
"暹":"xian1",
"暺":"dan4",
"暻":"jing3",
"暼":"pie1",
"暽":"lin2",
"暾":"tun1",
"暿":"xi3",
"曀":"yi4",
"曁":"ji4",
"曂":"huang4",
"曃":"tai4",
"曄":"ye4",
"曅":"ye4",
"曆":"li4",
"曇":"tan2",
"曈":"tong2",
"曊":"fei4",
"曋":"qin3",
"曌":"zhao4",
"曍":"hao4",
"曎":"yi4",
"曏":"xiang4",
"曐":"xing1",
"曑":"sen1",
"曒":"jiao3",
"曓":"bao4",
"曔":"jing4",
"曕":"yan4",
"曖":"ai4",
"曗":"ye4",
"曘":"ru2",
"曙":"shu3",
"曚":"meng2",
"曛":"xun1",
"曜":"yao4",
"曝":"pu4",
"曞":"li4",
"曟":"chen2",
"曡":"die2",
"曣":"yan4",
"曤":"huo4",
"曥":"lu2",
"曦":"xi1",
"曧":"rong2",
"曨":"long2",
"曩":"nang3",
"曪":"luo3",
"曫":"luan2",
"曬":"shai4",
"曭":"tang3",
"曮":"yan3",
"曯":"chu2",
"曱":"yue1",
"曳":"ye4",
"曵":"ye4",
"曶":"hu1",
"曷":"he2",
"曹":"cao2",
"曺":"cao2",
"曼":"man4",
"曽":"ceng1",
"朁":"zan3",
"朂":"xu4",
"朄":"yin4",
"朅":"qie4",
"朆":"fen1",
"朇":"pi2",
"朊":"ruan3",
"朌":"ban1",
"朎":"ling2",
"朏":"fei3",
"朐":"qu2",
"朒":"nv4",
"朓":"tiao4",
"朔":"shuo4",
"朕":"zhen4",
"朖":"lang3",
"朘":"juan1",
"朙":"ming2",
"朚":"huang1",
"朜":"tun1",
"朞":"ji1",
"朠":"ying1",
"朡":"zong1",
"朢":"wang4",
"朣":"tong2",
"朤":"lang3",
"朩":"deng3",
"札":"zha2",
"朱":"zhu1",
"朲":"ren2",
"朳":"ba1",
"朶":"duo3",
"朷":"dao1",
"朸":"li4",
"朹":"qiu2",
"朻":"jiu1",
"朼":"bi3",
"朾":"ting2",
"朿":"ci4",
"杄":"qian1",
"杅":"yu2",
"杇":"wu1",
"杈":"cha4",
"杊":"xun2",
"杋":"fan1",
"杌":"wu4",
"杍":"zi3",
"杏":"xing4",
"杒":"ren4",
"杓":"biao1",
"杔":"tuo1",
"杕":"di4",
"杖":"zhang4",
"杗":"mang2",
"杘":"chi4",
"杙":"yi4",
"杚":"gu3",
"杛":"gong1",
"杝":"yi2",
"杞":"qi3",
"杠":"gang4",
"杧":"mang2",
"杩":"ma4",
"杪":"miao3",
"杫":"si4",
"杬":"yuan2",
"杭":"hang2",
"杮":"fei4",
"杲":"gao3",
"杳":"yao3",
"杴":"xian1",
"杵":"chu3",
"杶":"chun1",
"杷":"pa2",
"杸":"shu1",
"杹":"hua4",
"杺":"xin1",
"杻":"niu3",
"杼":"zhu4",
"杽":"chou3",
"枀":"song1",
"枂":"yue4",
"枃":"jin4",
"枅":"ji1",
"枆":"mao2",
"枇":"pi2",
"枈":"bi4",
"枊":"ang4",
"枋":"fang1",
"枌":"fen2",
"枍":"yi4",
"枎":"fu2",
"枏":"nan2",
"枑":"hu4",
"枒":"ya2",
"枓":"dou3",
"枔":"xun2",
"枖":"yao1",
"枘":"rui4",
"枙":"e4",
"枛":"zhao4",
"枞":"cong1",
"枟":"yun4",
"枡":"dou3",
"枥":"li4",
"枧":"jian3",
"枨":"cheng2",
"枫":"feng1",
"枬":"nan2",
"枭":"xiao1",
"枮":"xian1",
"枰":"ping2",
"枱":"yi2",
"枲":"xi3",
"枳":"zhi3",
"枴":"guai3",
"枵":"xiao1",
"枷":"jia1",
"枸":"ju3",
"枹":"fu2",
"枺":"mo4",
"枻":"yi4",
"枼":"ye4",
"枽":"ye4",
"枾":"shi4",
"枿":"nie4",
"柀":"bi3",
"柁":"tuo2",
"柂":"yi2",
"柃":"ling2",
"柅":"ni3",
"柆":"la1",
"柇":"he2",
"柈":"pan2",
"柉":"fan2",
"柊":"zhong1",
"柋":"dai4",
"柌":"ci2",
"柍":"yang1",
"柎":"fu1",
"柑":"gan1",
"柒":"qi1",
"柕":"mao4",
"柖":"zhao1",
"柗":"song1",
"柘":"zhe4",
"柙":"xia2",
"柚":"you4",
"柛":"shen1",
"柝":"tuo4",
"柞":"zuo4",
"柟":"nan2",
"柠":"ning2",
"柡":"yong3",
"柢":"di3",
"柣":"zhi2",
"柤":"zha1",
"柦":"dan4",
"柧":"gu1",
"柩":"jiu4",
"柪":"ao1",
"柫":"fu2",
"柬":"jian3",
"柭":"bo1",
"柮":"duo4",
"柯":"ke1",
"柰":"nai4",
"柲":"bi4",
"柵":"zha4",
"柶":"si4",
"柷":"zhu4",
"柸":"pei1",
"柹":"shi4",
"柺":"guai3",
"査":"cha2",
"柼":"yao3",
"柽":"cheng1",
"柾":"jiu4",
"柿":"shi4",
"栀":"zhi1",
"栁":"liu3",
"栂":"mei2",
"栃":"li4",
"栄":"rong2",
"栅":"zha4",
"栈":"zhan4",
"栉":"zhi4",
"栊":"long2",
"栋":"dong4",
"栌":"lu2",
"栎":"li4",
"栐":"yong3",
"栒":"xun2",
"栓":"shuan1",
"栔":"qi4",
"栕":"zhen1",
"栖":"qi1",
"栗":"li4",
"栘":"yi3",
"栙":"xiang2",
"栚":"zhen4",
"栛":"li4",
"栜":"su4",
"栝":"gua1",
"栞":"kan1",
"栟":"bing1",
"栠":"ren3",
"栢":"bo2",
"栣":"ren3",
"栤":"bing4",
"栥":"zi1",
"栦":"chou2",
"栧":"yi4",
"栨":"jie2",
"栩":"xu3",
"栫":"jian4",
"栬":"zui4",
"栭":"er2",
"栮":"er3",
"栯":"you3",
"栰":"fa2",
"栱":"gong3",
"栲":"kao3",
"栳":"lao3",
"栴":"zhan1",
"栵":"li4",
"栺":"zhi3",
"栻":"shi4",
"栾":"luan2",
"栿":"fu2",
"桀":"jie2",
"桁":"hang2",
"桂":"gui4",
"桄":"guang1",
"桇":"ru2",
"桉":"an1",
"桊":"juan4",
"桋":"yi2",
"桍":"ku1",
"桎":"zhi4",
"桏":"qiong2",
"桐":"tong2",
"桒":"sang1",
"桓":"huan2",
"桕":"jiu4",
"桖":"xue4",
"桗":"duo4",
"桘":"zhui4",
"桙":"yu2",
"桚":"zan3",
"桜":"ying1",
"桟":"zhan4",
"桠":"ya1",
"桡":"rao2",
"桢":"zhen1",
"桤":"qi1",
"桧":"gui4",
"桪":"xun2",
"桫":"suo1",
"桬":"sha1",
"桭":"zhen1",
"桮":"bei1",
"桯":"ting1",
"桰":"gua1",
"桱":"jing4",
"桲":"po5",
"桳":"ben4",
"桴":"fu2",
"桵":"rui3",
"桷":"jue2",
"桸":"xi1",
"桹":"lang2",
"桺":"liu3",
"桻":"feng1",
"桼":"qi1",
"桽":"wen3",
"桾":"jun1",
"桿":"gan3",
"梀":"cu4",
"梂":"qiu2",
"梃":"ting3",
"梄":"you3",
"梇":"long4",
"梈":"peng1",
"梉":"zhuang1",
"梊":"di4",
"梋":"xuan1",
"梌":"tu2",
"梍":"zao4",
"梎":"ao1",
"梏":"gu4",
"梐":"bi4",
"梑":"di2",
"梒":"han2",
"梓":"zi3",
"梔":"zhi1",
"梕":"ren4",
"梖":"bei4",
"梘":"jian3",
"梙":"huan4",
"梚":"wan3",
"梛":"nuo2",
"梜":"jia2",
"梞":"ji4",
"梟":"xiao1",
"梠":"lv3",
"梡":"lv3",
"梣":"cen2",
"梤":"fen2",
"梥":"song1",
"梧":"wu2",
"梩":"li2",
"梪":"dou4",
"梫":"cen1",
"梬":"ying3",
"梭":"suo1",
"梮":"ju2",
"梱":"kun3",
"梲":"zhuo2",
"梴":"chan1",
"梵":"fan4",
"梶":"wei3",
"梷":"jing4",
"梸":"li2",
"梹":"bing1",
"梼":"tao2",
"梽":"zhi4",
"梾":"lai2",
"梿":"lian2",
"棁":"zhuo2",
"棂":"ling2",
"棃":"li2",
"棅":"bing4",
"棆":"zhun1",
"棇":"cong1",
"棈":"qian4",
"棊":"qi2",
"棌":"cai3",
"棎":"chan2",
"棏":"te4",
"棐":"fei3",
"棑":"pai2",
"棓":"pou3",
"棔":"hun1",
"棕":"zong1",
"棖":"cheng2",
"棘":"ji2",
"棙":"li4",
"棛":"yu4",
"棜":"yu4",
"棝":"gu4",
"棞":"hun2",
"棟":"dong4",
"棠":"tang2",
"棡":"gang1",
"棢":"wang3",
"棣":"di4",
"棤":"xi2",
"棥":"fan2",
"棦":"cheng1",
"棧":"zhan4",
"棨":"qi3",
"棩":"yuan1",
"棪":"yan3",
"棫":"yu4",
"棬":"quan1",
"棭":"yi4",
"棯":"ren3",
"棰":"chui2",
"棱":"leng2",
"棲":"qi1",
"棳":"zhuo2",
"棴":"fu2",
"棶":"lai2",
"棷":"zou1",
"棸":"zou1",
"棹":"zhao4",
"棻":"fen1",
"棼":"fen2",
"棽":"chen1",
"棾":"qiong2",
"棿":"nie4",
"椀":"wan3",
"椁":"guo3",
"椂":"lu4",
"椃":"hao2",
"椄":"jie1",
"椆":"chou2",
"椇":"ju3",
"椈":"ju2",
"椉":"cheng2",
"椊":"zuo2",
"椋":"liang2",
"椌":"qiang1",
"椎":"chui2",
"椏":"ya1",
"椐":"ju1",
"椑":"bei1",
"椓":"zhuo2",
"椔":"zi1",
"椕":"bin1",
"椖":"peng2",
"椗":"ding4",
"椘":"chu3",
"検":"jian3",
"椝":"gui1",
"椞":"xi4",
"椟":"du2",
"椠":"qian4",
"椤":"luo2",
"椥":"zhi1",
"椪":"peng4",
"椫":"zhan3",
"椮":"sen1",
"椯":"duo2",
"椰":"ye1",
"椱":"fou4",
"椲":"wei3",
"椳":"wei1",
"椴":"duan4",
"椵":"jia3",
"椶":"zong1",
"椷":"jian1",
"椸":"yi2",
"椹":"zhen1",
"椺":"xi2",
"椻":"yan4",
"椼":"yan3",
"椽":"chuan2",
"椾":"zhan4",
"椿":"chun1",
"楀":"yu3",
"楁":"he2",
"楂":"cha2",
"楃":"wo4",
"楄":"pian2",
"楅":"bi4",
"楆":"yao1",
"楇":"huo4",
"楈":"xu1",
"楉":"ruo4",
"楋":"la4",
"楌":"yan2",
"楍":"ben3",
"楎":"hun2",
"楏":"kui2",
"楐":"jie4",
"楑":"kui2",
"楒":"si1",
"楓":"feng1",
"楔":"xie1",
"楕":"tuo3",
"楖":"zhi4",
"楗":"jian4",
"楘":"mu4",
"楙":"mao4",
"楛":"ku3",
"楜":"hu2",
"楝":"lian4",
"楞":"leng4",
"楟":"ting2",
"楠":"nan2",
"楡":"yu2",
"楢":"you2",
"楣":"mei2",
"楤":"song3",
"楥":"xuan4",
"楦":"xuan4",
"楧":"ying1",
"楨":"zhen1",
"楩":"pian2",
"楪":"die2",
"楫":"ji2",
"楬":"jie2",
"楮":"chu3",
"楯":"shun3",
"楰":"yu2",
"楱":"cou4",
"楲":"wei1",
"楳":"mei2",
"楴":"di4",
"楶":"jie2",
"楷":"kai3",
"楸":"qiu1",
"楹":"ying2",
"楺":"rou2",
"楻":"heng2",
"楽":"le4",
"榀":"pin3",
"榃":"tan2",
"榄":"lan3",
"榅":"yun2",
"榆":"yu2",
"榇":"chen4",
"榈":"lv2",
"榉":"ju3",
"榍":"xie4",
"榎":"jia3",
"榏":"yi4",
"榐":"zhan3",
"榑":"fu4",
"榒":"nai4",
"榓":"mi4",
"榔":"lang2",
"榖":"gu3",
"榗":"jian4",
"榘":"ju3",
"榙":"ta3",
"榚":"yao3",
"榛":"zhen1",
"榝":"sha1",
"榞":"yuan2",
"榟":"zi3",
"榠":"ming2",
"榡":"su4",
"榢":"jia4",
"榣":"yao2",
"榤":"jie2",
"榥":"huang3",
"榦":"gan4",
"榧":"fei3",
"榨":"zha4",
"榩":"qian2",
"榪":"ma4",
"榫":"sun3",
"榬":"yuan2",
"榭":"xie4",
"榯":"shi2",
"榰":"zhi1",
"榱":"cui1",
"榲":"yun2",
"榳":"ting2",
"榵":"rong2",
"榶":"tang2",
"榷":"que4",
"榸":"zhai1",
"榹":"si1",
"榺":"sheng4",
"榻":"ta4",
"榼":"ke4",
"榽":"xi1",
"榾":"gu3",
"榿":"qi1",
"槀":"kao3",
"槁":"gao3",
"槂":"sun1",
"槃":"pan2",
"槄":"tao1",
"槅":"ge2",
"槆":"xun2",
"槇":"dian1",
"槈":"nou4",
"槉":"ji2",
"槊":"shuo4",
"槌":"chui2",
"槎":"cha2",
"槏":"qian3",
"槑":"mei2",
"槒":"xu4",
"槓":"gang4",
"槔":"gao1",
"槕":"zhuo2",
"槖":"tuo4",
"様":"yang4",
"槙":"dian1",
"槚":"jia3",
"槜":"zui4",
"槟":"bing1",
"槠":"zhu1",
"槢":"xi2",
"槣":"qi3",
"槤":"lian2",
"槥":"hui4",
"槦":"yong2",
"槧":"qian4",
"槨":"guo3",
"槩":"gai4",
"槪":"gai4",
"槫":"tuan2",
"槬":"hua4",
"槭":"qi1",
"槮":"sen1",
"槯":"cui1",
"槰":"beng4",
"槱":"you3",
"槲":"hu2",
"槴":"hu4",
"槵":"huan4",
"槶":"kui4",
"槷":"yi4",
"槸":"nie4",
"槹":"gao1",
"槺":"kang5",
"槻":"gui1",
"槼":"gui1",
"槾":"man2",
"槿":"jin3",
"樀":"di4",
"樃":"lang2",
"樄":"chen2",
"樅":"cong1",
"樆":"li2",
"樇":"xiu1",
"樈":"qing2",
"樉":"shuang3",
"樊":"fan2",
"樋":"tong1",
"樌":"guan4",
"樍":"ji1",
"樎":"suo1",
"樏":"lei3",
"樐":"lu3",
"樑":"liang2",
"樒":"mi4",
"樔":"chao2",
"樕":"su4",
"樖":"ke1",
"樗":"chu1",
"樘":"tang2",
"樚":"lu4",
"樛":"jiu1",
"樜":"shu4",
"樝":"zha1",
"樠":"men2",
"樢":"niao3",
"樤":"tiao2",
"樥":"peng2",
"樦":"zhu4",
"樧":"sha1",
"樨":"xi5",
"権":"quan2",
"樫":"jian1",
"樬":"cong1",
"樯":"qiang2",
"樱":"ying1",
"樲":"er4",
"樳":"xin2",
"樴":"zhi2",
"樵":"qiao2",
"樶":"zui1",
"樷":"cong1",
"樸":"pu3",
"樻":"kui4",
"樼":"zhen1",
"樽":"zun1",
"樾":"yue4",
"樿":"zhan3",
"橀":"xi1",
"橁":"xun2",
"橂":"dian4",
"橃":"fa1",
"橄":"gan3",
"橅":"mo2",
"橆":"wu3",
"橇":"qiao1",
"橈":"rao2",
"橉":"lin4",
"橊":"liu2",
"橌":"xian4",
"橍":"run4",
"橎":"fan2",
"橏":"zhan3",
"橐":"tuo2",
"橑":"lao3",
"橒":"yun2",
"橓":"shun4",
"橔":"tui2",
"橕":"cheng1",
"橖":"tang2",
"橗":"meng2",
"橙":"cheng2",
"橚":"su4",
"橛":"jue2",
"橜":"jue2",
"橝":"tan1",
"橞":"hui4",
"橠":"nuo3",
"橣":"ning3",
"橤":"rui3",
"橥":"zhu1",
"橦":"chuang2",
"橧":"zeng1",
"橨":"fen2",
"橩":"qiong2",
"橪":"ran3",
"橬":"cen2",
"橭":"gu1",
"橮":"liu3",
"橯":"lao4",
"橰":"gao1",
"橱":"chu2",
"橶":"ji2",
"橷":"dou1",
"橹":"lu3",
"橼":"yuan2",
"橽":"ta4",
"橾":"qiao1",
"橿":"jiang1",
"檀":"tan2",
"檁":"lin3",
"檂":"nong2",
"檃":"yin3",
"檄":"xi2",
"檅":"sui4",
"檆":"shan1",
"檇":"zui4",
"檈":"xuan2",
"檉":"cheng1",
"檊":"gan4",
"檋":"ju1",
"檌":"zui4",
"檍":"yi4",
"檎":"qin2",
"檏":"pu3",
"檑":"lei2",
"檒":"feng1",
"檓":"hui3",
"檕":"ji4",
"檖":"sui4",
"檗":"bo4",
"檘":"bi4",
"檙":"ding3",
"檚":"chu3",
"檛":"zhua1",
"檜":"gui4",
"檝":"ji2",
"檞":"jie3",
"檟":"jia3",
"檠":"qing2",
"檡":"zhe4",
"檣":"qiang2",
"檤":"dao4",
"檥":"yi3",
"檦":"biao3",
"檧":"song1",
"檨":"she1",
"檩":"lin3",
"檫":"cha2",
"檬":"meng2",
"檭":"yin2",
"檮":"tao2",
"檯":"tai2",
"檰":"mian2",
"檱":"qi2",
"檳":"bing1",
"檴":"huo4",
"檵":"ji4",
"檶":"qian1",
"檷":"mi2",
"檸":"ning2",
"檹":"yi1",
"檺":"gao3",
"檼":"yin4",
"檽":"er2",
"檾":"qing3",
"檿":"yan3",
"櫀":"qi2",
"櫁":"mi4",
"櫂":"zhao4",
"櫃":"gui4",
"櫄":"chun1",
"櫅":"ji1",
"櫆":"kui2",
"櫇":"po2",
"櫈":"deng4",
"櫉":"chu2",
"櫋":"mian2",
"櫌":"you1",
"櫍":"zhi4",
"櫎":"guang4",
"櫏":"qian1",
"櫐":"lei3",
"櫑":"lei3",
"櫒":"sa4",
"櫓":"lu3",
"櫔":"li4",
"櫕":"cuan2",
"櫖":"lv2",
"櫗":"mie4",
"櫘":"hui4",
"櫙":"ou1",
"櫚":"lv2",
"櫛":"zhi4",
"櫜":"gao1",
"櫝":"du2",
"櫞":"yuan2",
"櫟":"li4",
"櫠":"fei4",
"櫡":"zhuo2",
"櫢":"sou3",
"櫣":"lian2",
"櫥":"chu2",
"櫧":"zhu1",
"櫨":"lu2",
"櫩":"yan2",
"櫪":"li4",
"櫫":"zhu1",
"櫬":"chen4",
"櫭":"jie2",
"櫮":"e4",
"櫯":"su1",
"櫰":"huai2",
"櫱":"nie4",
"櫲":"yu4",
"櫳":"long2",
"櫴":"lai4",
"櫶":"xian3",
"櫸":"ju3",
"櫹":"xiao1",
"櫺":"ling2",
"櫻":"ying1",
"櫼":"jian1",
"櫽":"yin3",
"櫾":"you2",
"櫿":"ying2",
"欀":"xiang1",
"欁":"nong2",
"欂":"bo2",
"欃":"chan2",
"欅":"ju3",
"欆":"shuang1",
"欇":"she4",
"欈":"wei2",
"欉":"cong4",
"欋":"qu2",
"欎":"yu4",
"欏":"luo2",
"欐":"li2",
"欑":"zan4",
"欒":"luan2",
"欓":"dang3",
"欔":"jue2",
"欖":"lan3",
"欗":"lan2",
"欘":"zhu3",
"欙":"lei2",
"欚":"li3",
"欛":"ba4",
"欜":"nang2",
"欝":"yu4",
"欞":"ling2",
"欤":"yu2",
"欥":"yu4",
"欦":"qian1",
"欨":"xu1",
"欩":"chao1",
"欪":"chu4",
"欫":"chi1",
"欬":"kai4",
"欭":"yi4",
"欮":"jue2",
"欯":"xi2",
"欰":"xu1",
"欱":"xia4",
"欳":"kuai4",
"欴":"lang2",
"欵":"kuan3",
"欶":"shuo4",
"欷":"xi1",
"欸":"ai3",
"欹":"yi1",
"欻":"xu1",
"欼":"chi3",
"欿":"kan3",
"歀":"kuan3",
"歁":"kan3",
"歂":"chuan2",
"歃":"sha4",
"歅":"yin1",
"歆":"xin1",
"歈":"yu2",
"歊":"xiao1",
"歋":"yi2",
"歍":"wu1",
"歎":"tan4",
"歏":"jin4",
"歑":"hu1",
"歒":"ti4",
"歓":"huan1",
"歔":"xu1",
"歕":"pen4",
"歖":"xi1",
"歗":"xiao4",
"歘":"xu1",
"歙":"xi1",
"歛":"han4",
"歜":"chu4",
"歝":"yi4",
"歞":"kan3",
"歟":"yu2",
"歠":"chuo4",
"歧":"qi2",
"歨":"bu4",
"歩":"bu4",
"歫":"ju4",
"歬":"qian2",
"歭":"chi2",
"歮":"se4",
"歯":"chi3",
"歰":"se4",
"歱":"zhong3",
"歳":"sui4",
"歴":"li4",
"歵":"cuo4",
"歶":"yu2",
"歹":"dai3",
"歺":"dai3",
"歽":"zhe2",
"歾":"mo4",
"歿":"mo4",
"殀":"yao1",
"殁":"mo4",
"殂":"cu2",
"殃":"yang1",
"殄":"tian3",
"殅":"sheng1",
"殆":"dai4",
"殇":"shang1",
"殈":"xu4",
"殉":"xun4",
"殌":"jue2",
"殍":"piao3",
"殎":"qia4",
"殏":"qiu4",
"殐":"su4",
"殑":"qing2",
"殒":"yun3",
"殓":"lian4",
"殔":"yi4",
"殕":"fou3",
"殗":"ye4",
"殙":"hun1",
"殚":"dan1",
"殛":"ji2",
"殜":"ye4",
"殞":"yun3",
"殟":"wen1",
"殠":"chou4",
"殡":"bin4",
"殢":"ti4",
"殣":"jin4",
"殤":"shang1",
"殥":"yin2",
"殦":"diao1",
"殧":"cu4",
"殨":"hui4",
"殩":"cuan4",
"殪":"yi4",
"殫":"dan1",
"殬":"du4",
"殭":"jiang1",
"殮":"lian4",
"殯":"bin4",
"殰":"du2",
"殳":"shu1",
"殴":"ou1",
"殶":"zhu4",
"殷":"yin1",
"殸":"qing4",
"殹":"yi4",
"殻":"ke2",
"殽":"xiao2",
"殾":"jun4",
"毂":"gu1",
"毃":"que4",
"毄":"ji1",
"毆":"ou1",
"毇":"hui3",
"毈":"duan4",
"毉":"yi1",
"毊":"xiao1",
"毋":"wu2",
"毌":"guan4",
"毎":"mei3",
"毐":"ai3",
"毑":"zuo3",
"毓":"yu4",
"毖":"bi4",
"毗":"pi2",
"毘":"pi2",
"毚":"chan2",
"毞":"pu2",
"毠":"jia1",
"毢":"sai1",
"毣":"mu4",
"毤":"tuo4",
"毥":"xun2",
"毦":"er4",
"毧":"rong2",
"毨":"xian3",
"毩":"ju2",
"毪":"mu2",
"毬":"qiu2",
"毭":"dou4",
"毰":"pei2",
"毱":"ju2",
"毲":"duo2",
"毳":"cui4",
"毴":"bi1",
"毵":"san1",
"毷":"mao4",
"毸":"sui1",
"毹":"shu1",
"毺":"yu1",
"毻":"tuo4",
"毼":"he2",
"毽":"jian4",
"毾":"ta4",
"毿":"san1",
"氀":"lv2",
"氁":"mu2",
"氂":"mao2",
"氃":"tong2",
"氄":"rong3",
"氅":"chang3",
"氆":"pu3",
"氇":"lu5",
"氉":"sao4",
"氊":"zhan1",
"氋":"meng2",
"氌":"lu5",
"氍":"qu2",
"氎":"die2",
"氐":"di1",
"氒":"jue2",
"氕":"pie1",
"氖":"nai3",
"気":"qi4",
"氘":"dao1",
"氙":"xian1",
"氚":"chuan1",
"氜":"ri4",
"氝":"nei4",
"氟":"fu2",
"氠":"shen1",
"氡":"dong1",
"氤":"yin1",
"氥":"xi1",
"氦":"hai4",
"氩":"ya4",
"氪":"ke4",
"氬":"ya4",
"氭":"dong1",
"氯":"lv4",
"氰":"qing2",
"氱":"yang3",
"氲":"yun1",
"氳":"yun1",
"氶":"zheng3",
"氷":"bing1",
"氹":"dang4",
"氻":"le4",
"氼":"ni4",
"氽":"tun3",
"氾":"fan4",
"氿":"gui3",
"汀":"ting1",
"汃":"bin1",
"汄":"ze4",
"汅":"mian3",
"汆":"cuan1",
"汈":"diao1",
"汊":"cha4",
"汋":"zhuo2",
"汌":"chuan4",
"汍":"wan2",
"汎":"fan4",
"汏":"dai4",
"汐":"xi1",
"汑":"tuo1",
"汒":"mang2",
"汓":"qiu2",
"汔":"qi4",
"汕":"shan4",
"汖":"pai4",
"汘":"qian1",
"汙":"wu2",
"汚":"wu1",
"汜":"si4",
"汝":"ru3",
"汥":"zhi1",
"汦":"chi2",
"汧":"qian1",
"汨":"mi4",
"汩":"gu3",
"汫":"qing4",
"汬":"jing3",
"汭":"rui4",
"汮":"jun1",
"汯":"hong2",
"汱":"quan3",
"汲":"ji2",
"汳":"bian4",
"汴":"bian4",
"汵":"gan4",
"汶":"wen4",
"汷":"zhong1",
"汸":"fang1",
"汻":"hang3",
"汾":"fen2",
"汿":"xu4",
"沀":"xu4",
"沁":"qin4",
"沂":"yi2",
"沄":"yun2",
"沅":"yuan2",
"沆":"hang4",
"沇":"yan3",
"沈":"shen3",
"沊":"dan4",
"沋":"you2",
"沌":"dun4",
"沍":"hu4",
"沎":"huo4",
"沐":"mu4",
"沑":"rou2",
"沓":"ta4",
"沔":"mian3",
"沕":"wu4",
"沗":"tian1",
"沘":"bi3",
"沚":"zhi3",
"沜":"pan4",
"沝":"zhui3",
"沞":"za1",
"沠":"liu2",
"沢":"ze2",
"沣":"feng1",
"沤":"ou1",
"沦":"lun2",
"沧":"cang1",
"沨":"feng2",
"沩":"wei2",
"沪":"hu4",
"沬":"mei4",
"沭":"shu4",
"沮":"ju3",
"沯":"zan3",
"沰":"tuo1",
"沱":"tuo2",
"沲":"tuo2",
"沴":"li4",
"沵":"mi3",
"沶":"yi2",
"沷":"fa1",
"沺":"tian2",
"沼":"zhao3",
"沽":"gu1",
"泀":"si1",
"泂":"jiong3",
"泃":"ju4",
"泅":"qiu2",
"泆":"yi4",
"泇":"jia1",
"泈":"zhong1",
"泋":"hui4",
"泍":"ben1",
"泎":"zhuo2",
"泏":"chu4",
"泐":"le4",
"泑":"you3",
"泒":"gu1",
"泓":"hong2",
"泔":"gan1",
"泖":"mao3",
"泗":"si4",
"泘":"hu1",
"泙":"ping2",
"泚":"ci3",
"泜":"chi2",
"泝":"su4",
"泞":"ning4",
"泟":"cheng1",
"泠":"ling2",
"泤":"si4",
"泦":"ju2",
"泧":"yue4",
"泩":"sheng1",
"泫":"xuan4",
"泬":"xue4",
"泭":"fu1",
"泮":"pan4",
"泯":"min3",
"泰":"tai4",
"泱":"yang1",
"泲":"ji3",
"泴":"guan4",
"泶":"xue2",
"泷":"long2",
"泸":"lu2",
"泺":"po1",
"泻":"xie4",
"泽":"ze2",
"泾":"jing1",
"泿":"yin2",
"洀":"zhou1",
"洂":"yi4",
"洃":"hui1",
"洄":"hui2",
"洅":"zui3",
"洆":"cheng2",
"洇":"yin1",
"洈":"wei2",
"洉":"hou4",
"洊":"jian4",
"洌":"lie4",
"洍":"si4",
"洎":"ji4",
"洏":"er2",
"洐":"xing2",
"洑":"fu2",
"洓":"suo3",
"洔":"zhi3",
"洕":"yin1",
"洖":"wu2",
"洘":"kao3",
"洙":"zhu1",
"洚":"jiang4",
"洛":"luo4",
"洝":"an4",
"洟":"ti4",
"洠":"mou2",
"洡":"lei3",
"洢":"yi1",
"洣":"mi3",
"洤":"quan2",
"洦":"mo4",
"洧":"wei3",
"洨":"xiao2",
"洩":"xie4",
"洫":"xu4",
"洬":"shuo4",
"洭":"kuang1",
"洮":"tao2",
"洯":"qie4",
"洰":"ju4",
"洱":"er3",
"洳":"ru4",
"洴":"ping2",
"洵":"xun2",
"洷":"zhi4",
"洸":"guang1",
"洹":"huan2",
"洺":"ming2",
"洼":"wa1",
"洽":"qia4",
"洿":"wu1",
"浀":"qu3",
"浂":"yi4",
"浃":"jia1",
"浄":"jing4",
"浈":"zhen1",
"浉":"shi1",
"浍":"kuai4",
"浏":"liu2",
"浐":"chan3",
"浒":"hu3",
"浔":"xun2",
"浕":"jin4",
"浖":"lie4",
"浗":"qiu2",
"浘":"wei3",
"浙":"zhe4",
"浚":"jun4",
"浛":"han4",
"浜":"bang1",
"浝":"mang2",
"浞":"zhuo2",
"浟":"you2",
"浠":"xi1",
"浡":"bo2",
"浢":"dou4",
"浣":"huan4",
"浤":"hong2",
"浥":"yi4",
"浦":"pu3",
"浧":"ying3",
"浨":"lan3",
"浫":"han3",
"浬":"li3",
"浭":"geng1",
"浯":"wu2",
"浰":"lian4",
"浱":"chun2",
"浲":"feng2",
"浳":"yi4",
"浴":"yu4",
"浵":"tong2",
"浶":"lao2",
"浹":"jia1",
"浺":"chong1",
"浻":"weng3",
"浼":"mei3",
"浽":"sui1",
"浾":"cheng1",
"浿":"pei4",
"涀":"xian4",
"涁":"shen4",
"涃":"kun4",
"涄":"pin1",
"涅":"nie4",
"涆":"han4",
"涇":"jing1",
"涊":"nian3",
"涋":"tu1",
"涍":"xiao4",
"涎":"xian2",
"涏":"ting3",
"涐":"e2",
"涑":"su4",
"涒":"tun1",
"涓":"juan1",
"涔":"cen2",
"涖":"li4",
"涗":"shui4",
"涘":"si4",
"涙":"lei4",
"涚":"shui4",
"涜":"du2",
"涝":"lao4",
"涞":"lai2",
"涟":"lian2",
"涠":"wei2",
"涢":"yun2",
"涣":"huan4",
"涧":"jian4",
"涩":"se4",
"涪":"fu2",
"涫":"guan4",
"涬":"xing4",
"涭":"shou4",
"涮":"shuan4",
"涯":"ya2",
"涰":"chuo4",
"涱":"zhang4",
"涳":"kong1",
"涴":"wo4",
"涵":"han2",
"涶":"tuo1",
"涷":"dong1",
"涸":"he2",
"涹":"wo1",
"涺":"ju1",
"涻":"gan4",
"涽":"hun1",
"涾":"ta4",
"涿":"zhuo1",
"淁":"qie4",
"淂":"de2",
"淃":"juan4",
"淄":"zi1",
"淅":"xi1",
"淆":"yao2",
"淇":"qi2",
"淈":"gu3",
"淉":"guo3",
"淊":"yan1",
"淍":"zhou1",
"淎":"peng3",
"淏":"hao4",
"淐":"chang1",
"淑":"shu1",
"淓":"fang1",
"淔":"chi4",
"淕":"lu4",
"淖":"nao4",
"淗":"ju2",
"淙":"cong2",
"淛":"zhi4",
"淜":"peng2",
"淝":"fei2",
"淞":"song1",
"淟":"tian3",
"淠":"pi4",
"淢":"yu4",
"淣":"ni2",
"淤":"yu1",
"淥":"lu4",
"淦":"gan4",
"淧":"mi4",
"淩":"ling2",
"淪":"lun2",
"淫":"yin2",
"淬":"cui4",
"淭":"qu2",
"淮":"huai2",
"淯":"yu4",
"淰":"nian3",
"淲":"piao2",
"淴":"wa4",
"淵":"yuan1",
"淶":"lai2",
"淸":"qing1",
"淼":"miao3",
"淽":"zhi3",
"淾":"yin3",
"淿":"mi4",
"渀":"ben1",
"渁":"yuan1",
"渂":"wen4",
"渃":"re4",
"渄":"fei1",
"渆":"yuan1",
"渇":"ke3",
"済":"ji4",
"渉":"she4",
"渊":"yuan1",
"渋":"se4",
"渌":"lu4",
"渍":"zi4",
"渎":"du2",
"渑":"sheng2",
"渒":"pi4",
"渓":"qi1",
"渕":"yuan1",
"渖":"shen3",
"渘":"rou2",
"渙":"huan4",
"渚":"zhu3",
"渜":"nuan3",
"渝":"yu2",
"渞":"qiu2",
"渟":"ting2",
"渢":"feng2",
"渤":"bo2",
"渥":"wo4",
"渧":"di4",
"渨":"wei1",
"渪":"ru2",
"渫":"xie4",
"渭":"wei4",
"渮":"ge1",
"渰":"yan3",
"渱":"hong2",
"渲":"xuan4",
"渳":"mi3",
"渵":"mao2",
"渶":"ying1",
"渷":"yan3",
"渹":"hong1",
"渻":"xing3",
"渼":"mei3",
"渽":"zai1",
"渿":"nai4",
"湀":"kui2",
"湁":"shi2",
"湂":"e4",
"湄":"mei2",
"湅":"lian4",
"湆":"qi4",
"湇":"qi4",
"湈":"mei2",
"湉":"tian2",
"湋":"wei2",
"湌":"can1",
"湍":"tuan1",
"湎":"mian3",
"湏":"hui4",
"湐":"mo4",
"湑":"xu3",
"湒":"ji2",
"湓":"pen2",
"湔":"jian1",
"湕":"jian3",
"湗":"feng4",
"湘":"xiang1",
"湙":"yi4",
"湚":"yin4",
"湛":"zhan4",
"湜":"shi2",
"湝":"jie1",
"湞":"zhen1",
"湟":"huang2",
"湠":"tan4",
"湡":"yu2",
"湢":"bi4",
"湣":"min3",
"湤":"shi1",
"湥":"tu2",
"湦":"sheng1",
"湧":"yong3",
"湨":"qu4",
"湩":"zhong4",
"湫":"jiao3",
"湬":"jiao3",
"湮":"yan1",
"湰":"long2",
"湱":"huo4",
"湲":"yuan2",
"湳":"nan3",
"湴":"ban4",
"湵":"you3",
"湶":"quan2",
"湷":"chui2",
"湸":"liang4",
"湹":"chan2",
"湺":"yan2",
"湻":"chun2",
"湼":"nie4",
"湽":"zi1",
"満":"man3",
"溁":"ying2",
"溆":"xu4",
"溇":"lv3",
"溈":"wei2",
"溌":"po1",
"溍":"jin4",
"溎":"gui4",
"溏":"tang2",
"溑":"suo3",
"溒":"yuan2",
"溓":"lian2",
"溔":"yao3",
"溕":"meng4",
"準":"zhun3",
"溗":"sheng2",
"溘":"ke4",
"溙":"tai4",
"溚":"da2",
"溛":"wa1",
"溞":"sao1",
"溟":"ming2",
"溠":"zha4",
"溡":"shi2",
"溢":"yi4",
"溣":"lun2",
"溤":"ma3",
"溥":"pu3",
"溦":"wei1",
"溧":"li4",
"溨":"cai2",
"溩":"wu4",
"溬":"qiang1",
"溭":"ze2",
"溮":"shi1",
"溯":"su4",
"溰":"yi1",
"溱":"zhen1",
"溲":"sou1",
"溳":"yun2",
"溴":"xiu4",
"溵":"yin1",
"溷":"hun4",
"溸":"su4",
"溹":"su4",
"溺":"niao4",
"溻":"ta4",
"溼":"shi1",
"溽":"ru4",
"溾":"wei1",
"溿":"pan4",
"滀":"chu4",
"滁":"chu2",
"滂":"pang1",
"滃":"weng3",
"滄":"cang1",
"滆":"he2",
"滇":"dian1",
"滈":"hao4",
"滉":"huang3",
"滊":"xi4",
"滍":"zhi3",
"滎":"xing2",
"滏":"fu3",
"滐":"jie2",
"滒":"ge1",
"滓":"zi3",
"滕":"teng2",
"滖":"sui1",
"滗":"bi3",
"滘":"jiao4",
"滙":"hui4",
"滛":"yin2",
"滜":"gao1",
"滝":"long2",
"滞":"zhi4",
"滟":"yan4",
"滠":"she4",
"滢":"ying2",
"滣":"chun2",
"滤":"lv4",
"滦":"luan2",
"滪":"yu4",
"滫":"xiu1",
"滬":"hu4",
"滭":"bi4",
"滮":"biao1",
"滯":"zhi4",
"滰":"jiang3",
"滱":"kou4",
"滳":"shang1",
"滵":"mi4",
"滶":"ao2",
"滷":"lu3",
"滸":"hu3",
"滹":"hu1",
"滺":"you2",
"滻":"chan3",
"滼":"fan4",
"滽":"yong2",
"漀":"qing4",
"漃":"ji2",
"漄":"ya2",
"漅":"jiao3",
"漇":"xi3",
"漈":"ji4",
"漉":"lu4",
"漊":"lv3",
"漋":"long2",
"漌":"jin3",
"漍":"guo2",
"漎":"cong2",
"漐":"zhi2",
"漑":"gai4",
"漒":"qiang2",
"漓":"li2",
"漕":"cao2",
"漖":"jiao4",
"漗":"cong1",
"漘":"chun2",
"漙":"tuan2",
"漚":"ou1",
"漛":"teng2",
"漜":"ye3",
"漝":"xi2",
"漞":"mi4",
"漟":"tang2",
"漡":"shang1",
"漣":"lian2",
"漤":"lan3",
"漥":"wa1",
"漦":"li2",
"漧":"qian2",
"漨":"feng2",
"漪":"yi1",
"漬":"zi4",
"漭":"mang3",
"漮":"kang1",
"漯":"ta4",
"漰":"peng1",
"漱":"shu4",
"漳":"zhang1",
"漴":"chong2",
"漵":"xu4",
"漶":"huan4",
"漷":"kuo4",
"漹":"yan1",
"漺":"chuang3",
"漻":"liao2",
"漼":"cui3",
"漽":"ti2",
"潀":"cong2",
"潁":"ying3",
"潂":"hong2",
"潃":"xun2",
"潄":"shu4",
"潅":"guan4",
"潆":"ying2",
"潇":"xiao1",
"潊":"xu4",
"潋":"lian4",
"潌":"zhi4",
"潍":"wei2",
"潎":"pi4",
"潏":"jue2",
"潐":"jiao4",
"潒":"dang4",
"潓":"hui4",
"潕":"wu3",
"潖":"pa2",
"潗":"ji2",
"潘":"pan1",
"潙":"gui2",
"潚":"xiao1",
"潝":"xi1",
"潞":"lu4",
"潟":"xi4",
"潠":"xun4",
"潡":"dun4",
"潢":"huang2",
"潣":"min3",
"潥":"su4",
"潦":"lao3",
"潧":"zhen1",
"潨":"zhong1",
"潩":"yi4",
"潪":"di2",
"潫":"wan1",
"潬":"dan4",
"潯":"xun2",
"潲":"shao4",
"潳":"tu2",
"潴":"zhu1",
"潵":"san4",
"潶":"hei1",
"潷":"bi3",
"潸":"shan1",
"潹":"chan2",
"潺":"chan2",
"潻":"shu3",
"潼":"tong2",
"潽":"pu3",
"潾":"lin2",
"潿":"wei2",
"澀":"se4",
"澁":"se4",
"澂":"cheng2",
"澃":"jiong4",
"澄":"deng4",
"澅":"hua4",
"澇":"lao4",
"澈":"che4",
"澉":"gan3",
"澊":"cun1",
"澋":"heng4",
"澌":"si1",
"澍":"shu4",
"澏":"han4",
"澐":"yun2",
"澑":"liu4",
"澒":"hong4",
"澓":"fu2",
"澔":"hao4",
"澕":"he2",
"澖":"xian1",
"澗":"jian4",
"澘":"shan1",
"澙":"xi4",
"澜":"lan2",
"澞":"yu2",
"澟":"lin3",
"澠":"sheng2",
"澢":"dang1",
"澣":"wan3",
"澤":"ze2",
"澥":"xie4",
"澦":"yu4",
"澧":"li3",
"澨":"shi4",
"澩":"xue2",
"澪":"ling2",
"澫":"man4",
"澬":"zi1",
"澭":"yong1",
"澮":"kuai4",
"澯":"can4",
"澰":"lian4",
"澲":"ye4",
"澳":"ao4",
"澴":"huan2",
"澵":"zhen1",
"澶":"chan2",
"澷":"man4",
"澸":"dan3",
"澹":"dan4",
"澺":"yi4",
"澻":"sui4",
"澼":"pi4",
"澽":"ju4",
"澾":"ta4",
"澿":"qin2",
"濂":"lian2",
"濄":"guo1",
"濅":"jin4",
"濆":"fen2",
"濇":"se4",
"濈":"ji2",
"濉":"sui1",
"濊":"hui4",
"濋":"chu3",
"濌":"ta4",
"濍":"song1",
"濎":"ding3",
"濐":"zhu3",
"濑":"lai4",
"濒":"bin1",
"濓":"lian2",
"濔":"mi3",
"濖":"shu4",
"濗":"mi4",
"濘":"ning4",
"濙":"ying2",
"濚":"ying2",
"濛":"meng2",
"濜":"jin4",
"濝":"qi2",
"濞":"pi4",
"濠":"hao2",
"濡":"ru2",
"濢":"zui3",
"濣":"wo4",
"濥":"yin4",
"濦":"yin3",
"濧":"dui4",
"濨":"ci2",
"濩":"huo4",
"濪":"jing4",
"濬":"jun4",
"濭":"ai4",
"濮":"pu2",
"濯":"zhuo2",
"濰":"wei2",
"濲":"gu3",
"濳":"qian2",
"濴":"xing2",
"濶":"kuo4",
"濷":"fei4",
"濻":"wei3",
"濼":"po1",
"濽":"zan4",
"濾":"lv4",
"濿":"li4",
"瀀":"you1",
"瀁":"yang4",
"瀂":"lu3",
"瀃":"si4",
"瀄":"jie2",
"瀅":"ying2",
"瀆":"du2",
"瀇":"wang3",
"瀈":"hui1",
"瀉":"xie4",
"瀊":"pan2",
"瀋":"shen3",
"瀌":"biao1",
"瀍":"chan2",
"瀎":"mo4",
"瀏":"liu2",
"瀐":"jian1",
"瀒":"se4",
"瀓":"cheng2",
"瀔":"gu3",
"瀕":"bin1",
"瀖":"huo4",
"瀗":"xian4",
"瀘":"lu2",
"瀙":"qin1",
"瀚":"han4",
"瀛":"ying2",
"瀜":"yong1",
"瀞":"jing4",
"瀟":"xiao1",
"瀠":"ying2",
"瀡":"sui3",
"瀢":"wei2",
"瀣":"xie4",
"瀤":"huai2",
"瀥":"hao4",
"瀦":"zhu1",
"瀧":"long2",
"瀨":"lai4",
"瀩":"dui4",
"瀪":"fan2",
"瀫":"hu2",
"瀬":"lai4",
"瀯":"ying2",
"瀰":"mi2",
"瀱":"ji4",
"瀲":"lian4",
"瀳":"jian4",
"瀴":"ying3",
"瀵":"fen4",
"瀶":"lin2",
"瀷":"yi4",
"瀸":"jian1",
"瀹":"yue4",
"瀺":"chan2",
"瀻":"dai4",
"瀼":"rang2",
"瀽":"jian3",
"瀾":"lan2",
"瀿":"fan2",
"灀":"shuang4",
"灁":"yuan1",
"灂":"zhuo2",
"灃":"feng1",
"灄":"she4",
"灅":"lei3",
"灆":"lan2",
"灇":"cong2",
"灈":"qu2",
"灉":"yong1",
"灊":"qian2",
"灋":"fa3",
"灍":"que4",
"灎":"yan4",
"灏":"hao4",
"灑":"sa3",
"灒":"zan4",
"灓":"luan2",
"灔":"yan4",
"灕":"li2",
"灖":"mi3",
"灗":"shan4",
"灙":"dang3",
"灚":"jiao3",
"灛":"chan3",
"灝":"hao4",
"灞":"ba4",
"灟":"zhu2",
"灠":"lan3",
"灡":"lan2",
"灢":"nang3",
"灤":"luan2",
"灥":"xun2",
"灦":"xian3",
"灧":"yan4",
"灨":"gan4",
"灩":"yan4",
"灪":"yu4",
"灬":"biao1",
"灮":"guang1",
"灱":"xiao1",
"灲":"xiao1",
"灴":"hong2",
"灷":"zhuan4",
"灸":"jiu3",
"灹":"zha4",
"灺":"xie4",
"灻":"chi4",
"灼":"zhuo2",
"炀":"yang2",
"炁":"qi4",
"炂":"zhong1",
"炃":"fen2",
"炄":"niu3",
"炅":"gui4",
"炆":"wen2",
"炇":"po4",
"炈":"yi4",
"炋":"pi1",
"炌":"kai4",
"炍":"pan4",
"炏":"kai4",
"炐":"pang4",
"炑":"mu4",
"炓":"liao4",
"炔":"que1",
"炖":"dun4",
"炗":"guang1",
"炘":"xin1",
"炙":"zhi4",
"炛":"guang1",
"炜":"wei3",
"炝":"qiang4",
"炟":"da2",
"炠":"xia2",
"炡":"zheng1",
"炢":"zhu2",
"炣":"ke3",
"炤":"zhao4",
"炥":"fu2",
"炦":"ba2",
"炧":"duo4",
"炨":"duo4",
"炩":"ling4",
"炪":"zhuo2",
"炫":"xuan4",
"炬":"ju4",
"炰":"pao2",
"炱":"tai2",
"炲":"tai2",
"炳":"bing3",
"炴":"yang3",
"炵":"tong1",
"炶":"han1",
"炷":"zhu4",
"炻":"shi2",
"炽":"chi4",
"炾":"huang3",
"烀":"hu1",
"烃":"ting1",
"烄":"jiao3",
"烅":"xu4",
"烆":"xing2",
"烇":"quan4",
"烉":"huan4",
"烊":"yang2",
"烋":"xiao1",
"烌":"xiu1",
"烍":"xian3",
"烎":"yin2",
"烐":"zhou1",
"烑":"yao2",
"烒":"shi4",
"烓":"wei1",
"烔":"tong2",
"烕":"xue4",
"烖":"zai1",
"烗":"kai4",
"烙":"lao4",
"烚":"xia2",
"烜":"xuan3",
"烝":"zheng1",
"烞":"po4",
"烠":"hui3",
"烡":"guang1",
"烢":"zhe4",
"烣":"hui1",
"烨":"ye4",
"烩":"hui4",
"烬":"jin4",
"烯":"xi1",
"烰":"fu2",
"烱":"jiong3",
"烲":"che4",
"烳":"pu3",
"烴":"ting1",
"烵":"zhuo2",
"烶":"ting3",
"烷":"wan2",
"烸":"hai3",
"烹":"peng1",
"烺":"lang3",
"烻":"shan1",
"烼":"hu1",
"烽":"feng1",
"烾":"chi4",
"烿":"rong2",
"焀":"hu2",
"焂":"shu2",
"焃":"he4",
"焄":"xun1",
"焅":"ku4",
"焆":"jue2",
"焇":"xiao1",
"焈":"xi1",
"焉":"yan1",
"焋":"zhuang4",
"焌":"qu1",
"焍":"di4",
"焎":"xie4",
"焏":"ji2",
"焐":"wu4",
"焓":"han2",
"焔":"yan4",
"焕":"huan4",
"焖":"men4",
"焗":"ju2",
"焘":"dao4",
"焙":"bei4",
"焚":"fen2",
"焛":"lin4",
"焜":"kun1",
"焝":"hun4",
"焞":"tun1",
"焟":"xi2",
"焠":"cui4",
"焢":"hong1",
"焣":"ju4",
"焤":"fu3",
"焥":"wo4",
"焧":"cong1",
"焨":"feng4",
"焩":"ping1",
"焪":"qiong1",
"焫":"ruo4",
"焬":"xi2",
"焭":"qiong2",
"焮":"xin4",
"焯":"zhuo2",
"焱":"yan4",
"焲":"yi4",
"焳":"jue2",
"焴":"yu4",
"焵":"gang4",
"焷":"pi2",
"焸":"gu3",
"焺":"sheng1",
"焻":"chang4",
"焼":"shao1",
"煁":"chen2",
"煂":"he4",
"煃":"kui3",
"煄":"zhong1",
"煅":"duan4",
"煆":"ya1",
"煇":"hui1",
"煈":"feng4",
"煊":"xuan1",
"煋":"xing1",
"煍":"jiao3",
"煏":"bi4",
"煐":"ying1",
"煑":"zhu3",
"煒":"wei3",
"煓":"tuan1",
"煔":"tian4",
"煕":"xi1",
"煖":"nuan3",
"煗":"nuan3",
"煘":"chan2",
"煚":"jiong3",
"煛":"jiong3",
"煜":"yu4",
"煝":"mei4",
"煟":"wei4",
"煠":"zha2",
"煡":"xin4",
"煢":"qiong2",
"煣":"rou3",
"煥":"huan4",
"煦":"xu4",
"煨":"wei1",
"煪":"qiu2",
"煫":"sui4",
"煬":"yang2",
"煭":"lie4",
"煰":"gao4",
"煱":"gua1",
"煲":"bao1",
"煳":"hu2",
"煴":"yun4",
"煵":"xia1",
"煸":"bian1",
"煹":"gou4",
"煺":"tui4",
"煻":"tang2",
"煼":"chao3",
"煽":"shan1",
"煾":"en1",
"煿":"bo2",
"熀":"huang3",
"熁":"xie2",
"熂":"xi4",
"熃":"wu4",
"熅":"yun4",
"熆":"he2",
"熇":"kao3",
"熈":"xi1",
"熉":"yun2",
"熋":"nai2",
"熌":"shan4",
"熎":"yao4",
"熐":"mi4",
"熑":"lian2",
"熒":"ying2",
"熓":"wu3",
"熗":"qiang4",
"熘":"liu1",
"熙":"xi1",
"熚":"bi4",
"熛":"biao1",
"熜":"zong3",
"熝":"lu4",
"熞":"jian1",
"熠":"yi4",
"熡":"lou2",
"熢":"feng1",
"熣":"sui1",
"熤":"yi4",
"熥":"tong1",
"熦":"jue2",
"熧":"zong1",
"熨":"yun4",
"熩":"hu4",
"熪":"yi2",
"熫":"zhi4",
"熭":"wei4",
"熮":"liao2",
"熯":"han4",
"熰":"ou1",
"熲":"jiong3",
"熳":"man4",
"熵":"shang1",
"熶":"cuan4",
"熷":"zeng1",
"熸":"jian1",
"熹":"xi1",
"熺":"xi1",
"熻":"xi1",
"熼":"yi4",
"熽":"xiao4",
"熾":"chi4",
"熿":"huang2",
"燀":"chan3",
"燁":"ye4",
"燂":"qian2",
"燄":"yan4",
"燅":"xian2",
"燆":"qiao2",
"燇":"zun4",
"燉":"dun1",
"燊":"shen1",
"燋":"jiao1",
"燌":"fen2",
"燍":"si1",
"燎":"liao2",
"燏":"yu4",
"燐":"lin2",
"燑":"tong2",
"燓":"fen1",
"燔":"fan2",
"燖":"xun2",
"燗":"lan4",
"燘":"mei3",
"燚":"yi1",
"燛":"jing3",
"燜":"men4",
"燠":"yu4",
"燡":"yi4",
"燢":"xue2",
"燣":"lan2",
"燤":"tai4",
"燧":"sui4",
"燨":"xi1",
"燩":"que4",
"燪":"cong1",
"燫":"lian2",
"燬":"hui3",
"燮":"xie4",
"燯":"ling2",
"燰":"wei1",
"燱":"yi4",
"燲":"xie2",
"燳":"zhao4",
"燴":"hui4",
"燷":"lan2",
"燸":"ru2",
"燹":"xian3",
"燺":"kao3",
"燻":"xun1",
"燼":"jin4",
"燽":"chou2",
"燾":"dao4",
"燿":"yao4",
"爀":"he4",
"爁":"lan4",
"爂":"biao1",
"爃":"rong2",
"爄":"li4",
"爅":"mo4",
"爇":"ruo4",
"爈":"lv2",
"爉":"la4",
"爊":"ao2",
"爋":"xun4",
"爌":"kuang4",
"爏":"li4",
"爑":"jue2",
"爒":"liao4",
"爓":"yan4",
"爔":"xi1",
"爕":"xie4",
"爖":"long2",
"爗":"ye4",
"爙":"rang3",
"爚":"yue4",
"爜":"cong2",
"爝":"jue2",
"爞":"tong2",
"爟":"guan4",
"爡":"che4",
"爢":"mi2",
"爣":"tang3",
"爤":"lan4",
"爥":"zhu2",
"爧":"ling2",
"爨":"cuan4",
"爩":"yu4",
"爮":"pao2",
"爯":"cheng1",
"爰":"yuan2",
"爲":"wei2",
"爴":"jue2",
"爵":"jue2",
"爻":"yao2",
"爼":"zu3",
"爿":"qiang2",
"牀":"chuang2",
"牁":"ge1",
"牂":"zang1",
"牃":"die2",
"牄":"qiang1",
"牅":"yong2",
"牉":"pan4",
"牊":"shao2",
"牋":"jian1",
"牍":"du2",
"牎":"chuang1",
"牏":"tou2",
"牐":"zha2",
"牑":"bian1",
"牒":"die2",
"牓":"bang3",
"牔":"bo2",
"牕":"chuang1",
"牖":"you3",
"牘":"du2",
"牚":"cheng4",
"牝":"pin4",
"牞":"jiu1",
"牟":"mou2",
"牠":"ta1",
"牣":"ren4",
"牤":"mang2",
"牥":"fang1",
"牨":"gang1",
"牪":"yan4",
"牫":"ge1",
"牬":"bei4",
"牭":"si4",
"牮":"jian4",
"牯":"gu3",
"牰":"you4",
"牱":"ge1",
"牳":"mu3",
"牴":"di3",
"牶":"quan4",
"牷":"quan2",
"牸":"zi4",
"牻":"mang2",
"牼":"keng1",
"牾":"wu3",
"牿":"gu4",
"犂":"li2",
"犃":"pou3",
"犄":"ji1",
"犅":"gang1",
"犆":"te4",
"犇":"ben1",
"犈":"quan2",
"犉":"run2",
"犊":"du2",
"犋":"ju4",
"犌":"jia1",
"犍":"jian1",
"犎":"feng1",
"犏":"pian1",
"犐":"ke1",
"犑":"ju2",
"犒":"kao4",
"犓":"chu2",
"犔":"xi4",
"犕":"bei4",
"犖":"luo4",
"犗":"jie4",
"犘":"ma2",
"犙":"san1",
"犚":"wei4",
"犜":"dun1",
"犝":"tong2",
"犟":"jiang4",
"犠":"xi1",
"犡":"li4",
"犢":"du2",
"犣":"lie4",
"犤":"pi2",
"犥":"piao3",
"犦":"bao4",
"犨":"chou1",
"犩":"wei4",
"犪":"kui2",
"犫":"chou1",
"犮":"ba2",
"犰":"qiu2",
"犱":"ji3",
"犲":"cai2",
"犳":"chuo2",
"犴":"an4",
"犵":"qi4",
"犷":"guang3",
"犸":"ma3",
"犺":"kang4",
"犻":"bo2",
"犼":"hou3",
"犽":"ya2",
"犾":"yin2",
"犿":"huan1",
"狁":"yun3",
"狃":"niu3",
"狄":"di2",
"狅":"qing1",
"狆":"zhong4",
"狇":"mu4",
"狉":"pi1",
"狊":"ju2",
"狋":"ni2",
"狌":"sheng1",
"狍":"pao2",
"狎":"xia2",
"狏":"tuo2",
"狑":"ling2",
"狒":"fei4",
"狓":"pi1",
"狔":"ni3",
"狕":"ao3",
"狖":"you4",
"狘":"yue4",
"狙":"ju1",
"狚":"dan4",
"狛":"po4",
"狜":"gu3",
"狝":"xian3",
"狞":"ning2",
"狟":"huan2",
"狢":"he2",
"狣":"zhao4",
"狤":"ji2",
"狥":"xun4",
"狦":"shan1",
"狧":"ta4",
"狨":"rong2",
"狩":"shou4",
"狪":"tong1",
"狫":"lao3",
"狯":"kuai4",
"狰":"zheng1",
"狲":"sun1",
"狳":"yu2",
"狴":"bi4",
"狵":"mang2",
"狶":"xi3",
"狷":"juan4",
"狺":"yin2",
"狻":"suan1",
"狾":"zhi4",
"狿":"yan2",
"猀":"sha1",
"猁":"li4",
"猂":"han4",
"猃":"xian3",
"猄":"jing1",
"猅":"pai2",
"猆":"fei1",
"猇":"yao2",
"猈":"ba4",
"猉":"qi2",
"猊":"ni2",
"猋":"biao1",
"猌":"yin4",
"猍":"lai2",
"猏":"jian1",
"猐":"qiang1",
"猑":"kun1",
"猒":"yan1",
"猓":"guo3",
"猔":"zong4",
"猕":"mi2",
"猖":"chang1",
"猗":"yi1",
"猘":"zhi4",
"猙":"zheng1",
"猚":"ya2",
"猝":"cu4",
"猞":"she4",
"猟":"lie4",
"猡":"luo2",
"猢":"hu2",
"猣":"zong1",
"猤":"ji4",
"猥":"wei3",
"猦":"feng1",
"猧":"wo1",
"猨":"yuan2",
"猭":"yuan2",
"猯":"tuan1",
"猰":"ya4",
"猱":"nao2",
"猲":"he4",
"猳":"jia1",
"猵":"bian1",
"猷":"you2",
"猸":"mei2",
"猹":"zha1",
"猺":"yao2",
"猻":"sun1",
"猼":"bo2",
"猽":"ming2",
"獀":"sou1",
"獁":"ma3",
"獂":"yuan2",
"獃":"ai2",
"獆":"hao2",
"獈":"yi4",
"獉":"zhen1",
"獊":"chuang4",
"獋":"hao2",
"獌":"man4",
"獍":"jing4",
"獏":"mu2",
"獐":"zhang1",
"獑":"chan2",
"獒":"ao2",
"獓":"ao2",
"獔":"hao2",
"獕":"cui1",
"獖":"fen2",
"獗":"jue2",
"獘":"bi4",
"獙":"bi4",
"獚":"huang2",
"獛":"pu2",
"獜":"lin2",
"獝":"yu4",
"獞":"zhuang4",
"獟":"yao4",
"獠":"liao2",
"獡":"shuo4",
"獢":"xiao1",
"獣":"shou4",
"獥":"xi2",
"獦":"ge2",
"獧":"juan4",
"獩":"hui4",
"獪":"kuai4",
"獫":"xian3",
"獬":"xie4",
"獭":"ta3",
"獮":"xian3",
"獯":"xun1",
"獰":"ning2",
"獱":"pin2",
"獳":"nou4",
"獴":"meng3",
"獶":"nao2",
"獷":"guang3",
"獹":"lu2",
"獺":"ta3",
"獼":"mi2",
"獽":"rang2",
"獾":"huan1",
"獿":"nao2",
"玀":"luo2",
"玁":"xian3",
"玂":"qi2",
"玃":"jue2",
"玄":"xuan2",
"玅":"miao4",
"玆":"zi1",
"玈":"lu2",
"玊":"su4",
"玌":"qiu2",
"玍":"ga3",
"玎":"ding1",
"玏":"le4",
"玐":"ba1",
"玑":"ji1",
"玒":"hong2",
"玓":"di4",
"玔":"chuan4",
"玕":"gan1",
"玖":"jiu3",
"玗":"yu2",
"玘":"ji3",
"玙":"yu2",
"玚":"yang2",
"玛":"ma3",
"玜":"gong1",
"玝":"wu3",
"玞":"fu1",
"玟":"min2",
"玠":"jie4",
"玡":"ya4",
"玢":"fen1",
"玣":"bian4",
"玤":"bang4",
"玥":"yue4",
"玦":"jue2",
"玧":"yun3",
"玨":"jue2",
"玪":"jian1",
"玫":"mei2",
"玬":"dan3",
"玭":"pi2",
"玮":"wei3",
"玱":"qiang1",
"玳":"dai4",
"玴":"yi4",
"玵":"an2",
"玶":"ping2",
"玷":"dian4",
"玸":"fu2",
"玹":"xuan2",
"玺":"xi3",
"玼":"ci3",
"玽":"gou3",
"玾":"jia3",
"玿":"shao2",
"珀":"po4",
"珁":"ci2",
"珂":"ke1",
"珃":"ran3",
"珄":"sheng1",
"珅":"shen1",
"珆":"yi2",
"珇":"zu3",
"珈":"jia1",
"珉":"min2",
"珋":"liu3",
"珌":"bi4",
"珎":"zhen1",
"珏":"jue2",
"珐":"fa4",
"珒":"jin1",
"珓":"jiao4",
"珔":"jian4",
"珕":"li4",
"珖":"guang1",
"珗":"xian1",
"珘":"zhou1",
"珙":"gong3",
"珚":"yan1",
"珛":"xiu4",
"珜":"yang2",
"珝":"xu3",
"珞":"luo4",
"珟":"su4",
"珡":"qin2",
"珢":"ken4",
"珣":"xun2",
"珤":"bao3",
"珥":"er3",
"珦":"xiang4",
"珧":"yao2",
"珨":"xia2",
"珩":"heng2",
"珪":"gui1",
"珫":"chong1",
"珬":"xu4",
"珮":"pei4",
"珰":"dang1",
"珲":"hun2",
"珳":"wen2",
"珴":"e2",
"珵":"cheng2",
"珶":"di4",
"珷":"wu3",
"珸":"wu2",
"珹":"cheng2",
"珺":"jun4",
"珻":"mei2",
"珼":"bei4",
"珽":"ting3",
"珿":"chuo4",
"琀":"han2",
"琁":"xuan2",
"琂":"yan2",
"琄":"quan3",
"琅":"lang2",
"琇":"xiu4",
"琈":"fu2",
"琉":"liu2",
"琊":"ye2",
"琋":"xi1",
"琌":"ling2",
"琍":"li4",
"琎":"jin4",
"琏":"lian3",
"琓":"wan2",
"琔":"dian4",
"琕":"pin2",
"琖":"zhan3",
"琗":"cui4",
"琘":"min2",
"琙":"yu4",
"琚":"ju1",
"琛":"chen1",
"琜":"lai2",
"琝":"wen2",
"琞":"sheng4",
"琟":"wei2",
"琠":"dian3",
"琡":"chu4",
"琣":"pei3",
"琤":"cheng1",
"琥":"hu3",
"琦":"qi2",
"琧":"e4",
"琨":"kun1",
"琩":"chang1",
"琪":"qi2",
"琫":"beng3",
"琬":"wan3",
"琭":"lu4",
"琮":"cong2",
"琯":"guan3",
"琰":"yan3",
"琱":"diao1",
"琲":"bei4",
"琳":"lin2",
"琵":"pi2",
"琶":"pa2",
"琷":"que4",
"琸":"zhuo2",
"琹":"qin2",
"琺":"fa4",
"琼":"qiong2",
"琽":"du3",
"琾":"jie4",
"琿":"hun2",
"瑀":"yu3",
"瑁":"mao4",
"瑂":"mei2",
"瑄":"xuan1",
"瑅":"ti2",
"瑆":"xing1",
"瑇":"dai4",
"瑈":"rou2",
"瑉":"min2",
"瑊":"zhen1",
"瑋":"wei3",
"瑌":"ruan3",
"瑍":"huan4",
"瑎":"jie1",
"瑏":"chuan1",
"瑐":"jian3",
"瑑":"zhuan4",
"瑒":"yang2",
"瑓":"lian4",
"瑔":"quan2",
"瑕":"xia2",
"瑖":"duan4",
"瑗":"yuan4",
"瑘":"ye2",
"瑙":"nao3",
"瑛":"ying1",
"瑜":"yu2",
"瑝":"huang2",
"瑞":"rui4",
"瑟":"se4",
"瑠":"liu2",
"瑢":"rong2",
"瑤":"yao2",
"瑥":"wen1",
"瑦":"wu1",
"瑧":"jin1",
"瑨":"jin4",
"瑪":"ma3",
"瑫":"tao1",
"瑬":"liu2",
"瑭":"tang2",
"瑮":"li4",
"瑯":"lang2",
"瑰":"gui1",
"瑱":"zhen4",
"瑲":"qiang1",
"瑳":"cuo3",
"瑴":"jue2",
"瑵":"zhao3",
"瑶":"yao2",
"瑷":"ai4",
"瑸":"bin1",
"瑹":"tu2",
"瑺":"chang2",
"瑻":"kun1",
"瑼":"zhuan1",
"瑽":"cong1",
"瑾":"jin3",
"瑿":"yi1",
"璀":"cui3",
"璁":"cong1",
"璂":"qi2",
"璄":"ying3",
"璅":"suo3",
"璆":"qiu2",
"璇":"xuan2",
"璈":"ao2",
"璉":"lian3",
"璊":"men2",
"璋":"zhang1",
"璌":"yin2",
"璎":"ying1",
"璏":"zhi4",
"璐":"lu4",
"璑":"wu2",
"璒":"deng1",
"璔":"zeng1",
"璕":"xun2",
"璖":"qu2",
"璗":"dang4",
"璘":"lin2",
"璙":"liao2",
"璚":"jue2",
"璛":"su4",
"璜":"huang2",
"璝":"gui1",
"璞":"pu2",
"璟":"jing3",
"璠":"fan2",
"璡":"jin4",
"璢":"liu2",
"璣":"ji1",
"璥":"jing3",
"璦":"ai4",
"璧":"bi4",
"璨":"can4",
"璩":"qu2",
"璪":"zao3",
"璫":"dang1",
"璬":"jiao3",
"璭":"gun4",
"璮":"tan3",
"璯":"hui4",
"璱":"se4",
"璲":"sui4",
"璳":"tian2",
"璵":"yu2",
"璶":"jin4",
"璷":"lu2",
"璸":"bin1",
"璹":"shou4",
"璺":"wen4",
"璻":"zui3",
"璼":"lan2",
"璽":"xi3",
"璾":"ji4",
"璿":"xuan2",
"瓀":"ruan3",
"瓁":"huo4",
"瓂":"gai4",
"瓃":"lei2",
"瓄":"du2",
"瓅":"li4",
"瓆":"zhi2",
"瓇":"rou2",
"瓈":"li2",
"瓉":"zan4",
"瓊":"qiong2",
"瓋":"zhe2",
"瓌":"gui1",
"瓍":"sui4",
"瓎":"la4",
"瓐":"lu2",
"瓑":"li4",
"瓒":"zan4",
"瓓":"lan4",
"瓔":"ying1",
"瓕":"mi2",
"瓖":"xiang1",
"瓗":"xi1",
"瓘":"guan4",
"瓙":"dao4",
"瓚":"zan4",
"瓛":"huan2",
"瓝":"bo2",
"瓞":"die2",
"瓟":"bao2",
"瓠":"hu4",
"瓡":"zhi2",
"瓤":"rang2",
"瓥":"li4",
"瓨":"jiang1",
"瓪":"fan3",
"瓫":"pen2",
"瓬":"fang3",
"瓭":"dan3",
"瓮":"weng4",
"瓯":"ou1",
"瓳":"hu2",
"瓴":"ling2",
"瓵":"yi2",
"瓹":"juan4",
"瓺":"chang2",
"瓻":"chi1",
"瓽":"dang4",
"瓾":"meng3",
"瓿":"pou3",
"甀":"zhui4",
"甁":"ping2",
"甂":"bian1",
"甃":"zhou4",
"甄":"zhen1",
"甆":"ci2",
"甇":"ying1",
"甈":"qi4",
"甉":"xian2",
"甊":"lou3",
"甋":"di4",
"甌":"ou1",
"甍":"meng2",
"甎":"zhuan1",
"甏":"beng4",
"甐":"lin2",
"甑":"zeng4",
"甒":"wu3",
"甓":"pi4",
"甔":"dan1",
"甕":"weng4",
"甖":"ying1",
"甗":"yan3",
"甙":"dai4",
"甛":"tian2",
"甝":"han1",
"甞":"chang2",
"甠":"qing2",
"甡":"shen1",
"産":"chan3",
"甤":"rui2",
"甥":"sheng1",
"甦":"su1",
"甧":"sen1",
"甪":"lu4",
"甬":"yong3",
"甮":"feng4",
"甯":"ning2",
"甴":"zha2",
"甶":"fu2",
"甹":"ping2",
"町":"ting3",
"甼":"ting3",
"甽":"quan3",
"甾":"zai1",
"甿":"meng2",
"畀":"bi4",
"畁":"qi2",
"畂":"liu4",
"畃":"xun2",
"畄":"liu2",
"畆":"mu3",
"畇":"yun2",
"畈":"fan4",
"畉":"fu2",
"畊":"geng1",
"畋":"tian2",
"畍":"jie4",
"畎":"quan3",
"畐":"fu2",
"畑":"tian2",
"畒":"mu3",
"畕":"jiang1",
"畖":"wa1",
"畗":"da2",
"畘":"nan2",
"畚":"ben3",
"畛":"zhen3",
"畞":"mu3",
"畟":"ce4",
"畡":"gai1",
"畣":"da2",
"畤":"zhi4",
"畦":"qi2",
"畧":"lve4",
"畨":"pan1",
"畬":"yu2",
"畭":"yu2",
"畮":"mu3",
"畯":"jun4",
"畱":"liu2",
"畲":"she1",
"畳":"die2",
"畴":"chou2",
"畵":"hua4",
"畷":"chuo4",
"畸":"ji1",
"畹":"wan3",
"畺":"jiang1",
"畻":"sheng2",
"畼":"chang4",
"畽":"tuan3",
"畾":"lei2",
"畿":"ji1",
"疀":"cha1",
"疁":"liu2",
"疃":"tuan3",
"疄":"lin2",
"疅":"jiang1",
"疇":"chou2",
"疈":"bo4",
"疉":"die2",
"疋":"pi3",
"疌":"nie4",
"疍":"dan4",
"疎":"shu1",
"疐":"zhi4",
"疒":"ni4",
"疓":"nai3",
"疔":"ding1",
"疕":"bi3",
"疖":"jie1",
"疘":"gang1",
"疚":"jiu4",
"疛":"zhou3",
"疜":"xia4",
"疝":"shan4",
"疞":"xu1",
"疟":"yao4",
"疠":"li4",
"疡":"yang2",
"疢":"chen4",
"疣":"you2",
"疤":"ba1",
"疥":"jie4",
"疦":"jue2",
"疧":"qi2",
"疨":"xia1",
"疩":"cui4",
"疪":"bi4",
"疬":"li4",
"疭":"zong4",
"疮":"chuang1",
"疰":"zhu4",
"疱":"pao4",
"疳":"gan1",
"疴":"ke1",
"疵":"ci1",
"疶":"xie4",
"疷":"qi2",
"疸":"dan3",
"疹":"zhen3",
"疺":"fa2",
"疻":"zhi3",
"疽":"ju1",
"疿":"fei4",
"痀":"qu2",
"痁":"dian4",
"痂":"jia1",
"痃":"xian2",
"痄":"zha4",
"痆":"ni4",
"痈":"yong1",
"痉":"jing4",
"痊":"quan2",
"痋":"chong2",
"痌":"tong1",
"痍":"yi2",
"痎":"kai1",
"痏":"wei3",
"痐":"hui2",
"痑":"duo3",
"痓":"chi4",
"痔":"zhi4",
"痖":"ya3",
"痗":"mei4",
"痘":"dou4",
"痙":"jing4",
"痚":"xiao1",
"痜":"tu1",
"痝":"mang2",
"痞":"pi3",
"痟":"xiao1",
"痠":"suan1",
"痡":"pu1",
"痢":"li4",
"痣":"zhi4",
"痤":"cuo2",
"痥":"duo2",
"痦":"wu4",
"痧":"sha1",
"痨":"lao2",
"痩":"shou4",
"痪":"huan4",
"痫":"xian2",
"痬":"yi4",
"痭":"beng1",
"痮":"zhang4",
"痯":"guan3",
"痱":"fei4",
"痲":"ma2",
"痳":"lin2",
"痴":"chi1",
"痵":"ji4",
"痶":"dian3",
"痷":"an1",
"痸":"chi4",
"痻":"min2",
"痼":"gu4",
"痽":"dui1",
"痾":"ke1",
"痿":"wei3",
"瘀":"yu1",
"瘁":"cui4",
"瘂":"ya3",
"瘃":"zhu2",
"瘄":"cu4",
"瘅":"dan1",
"瘆":"shen4",
"瘇":"zhong3",
"瘈":"ji4",
"瘉":"yu4",
"瘊":"hou2",
"瘌":"la4",
"瘍":"yang2",
"瘎":"shen4",
"瘏":"tu2",
"瘐":"yu3",
"瘑":"gua1",
"瘒":"wen2",
"瘓":"huan4",
"瘔":"ku4",
"瘕":"jia3",
"瘖":"yin1",
"瘗":"yi4",
"瘘":"lou4",
"瘙":"sao4",
"瘚":"jue2",
"瘛":"chi4",
"瘜":"xi2",
"瘝":"guan1",
"瘞":"yi4",
"瘟":"wen1",
"瘠":"ji2",
"瘡":"chuang1",
"瘢":"ban1",
"瘣":"lei3",
"瘤":"liu2",
"瘥":"chai4",
"瘧":"yao4",
"瘨":"dian1",
"瘫":"tan1",
"瘬":"zhang4",
"瘭":"biao1",
"瘮":"shen4",
"瘯":"cu4",
"瘰":"luo3",
"瘱":"yi4",
"瘲":"zong4",
"瘳":"chou1",
"瘴":"zhang4",
"瘵":"zhai4",
"瘶":"sou4",
"瘷":"suo3",
"瘸":"que2",
"瘹":"diao4",
"瘺":"lou4",
"瘻":"lou4",
"瘼":"mo4",
"瘽":"jin4",
"瘾":"yin3",
"瘿":"ying3",
"癀":"huang2",
"癁":"fu2",
"癃":"long2",
"癄":"qiao2",
"癅":"liu2",
"癆":"lao2",
"癇":"xian2",
"癈":"fei4",
"癉":"dan1",
"癊":"yin4",
"癋":"he4",
"癍":"ban1",
"癎":"xian2",
"癏":"guan1",
"癐":"guai4",
"癑":"nong2",
"癒":"yu3",
"癓":"wei2",
"癔":"yi4",
"癕":"yong1",
"癖":"pi3",
"癗":"lei3",
"癘":"li4",
"癙":"shu3",
"癚":"dan4",
"癛":"lin3",
"癜":"dian4",
"癝":"lin3",
"癞":"lai4",
"癠":"ji4",
"癡":"chi1",
"癢":"yang3",
"癣":"xuan3",
"癤":"jie1",
"癥":"zheng4",
"癧":"li4",
"癨":"huo4",
"癩":"lai4",
"癪":"ji1",
"癫":"dian1",
"癬":"xuan3",
"癭":"ying3",
"癮":"yin3",
"癯":"qu2",
"癰":"yong1",
"癱":"tan1",
"癲":"dian1",
"癳":"luo3",
"癴":"luan2",
"癵":"luan2",
"癶":"bo1",
"癸":"gui3",
"癹":"po1",
"発":"fa1",
"癿":"qie2",
"皀":"xiang1",
"皁":"zao4",
"皃":"mao4",
"皅":"pa1",
"皈":"gui1",
"皉":"ci3",
"皊":"ling2",
"皋":"gao1",
"皌":"mo4",
"皍":"ji2",
"皎":"jiao3",
"皏":"peng3",
"皐":"gao1",
"皑":"ai2",
"皒":"e2",
"皓":"hao4",
"皔":"han4",
"皕":"bi1",
"皖":"wan3",
"皗":"chou2",
"皘":"qian4",
"皙":"xi1",
"皚":"ai2",
"皛":"jiong3",
"皜":"hao4",
"皝":"huang3",
"皞":"hao4",
"皟":"ze2",
"皠":"cui3",
"皡":"hao4",
"皢":"xiao3",
"皣":"ye4",
"皤":"po2",
"皥":"hao4",
"皦":"jiao3",
"皧":"ai4",
"皨":"xing1",
"皩":"huang4",
"皪":"li4",
"皫":"piao3",
"皬":"he4",
"皭":"jiao4",
"皯":"gan3",
"皰":"pao4",
"皲":"jun1",
"皳":"qiu2",
"皴":"cun1",
"皵":"que4",
"皶":"zha1",
"皷":"gu3",
"皸":"jun1",
"皹":"jun1",
"皻":"zha1",
"皼":"gu3",
"皽":"zhan3",
"皾":"du2",
"皿":"min3",
"盀":"qi3",
"盁":"ying2",
"盂":"yu2",
"盃":"bei1",
"盄":"zhao1",
"盅":"zhong1",
"盇":"he2",
"盈":"ying2",
"盉":"he2",
"盋":"bo1",
"盌":"wan3",
"盍":"he2",
"盎":"ang4",
"盓":"yu1",
"盕":"fan4",
"盙":"fu3",
"盚":"qiu2",
"盝":"lu4",
"盠":"li3",
"盢":"xu4",
"盥":"guan4",
"盦":"an1",
"盧":"lu2",
"盨":"shu3",
"盩":"zhou1",
"盪":"dang4",
"盫":"an1",
"盬":"gu3",
"盭":"li4",
"盰":"gan3",
"盱":"xu1",
"盳":"mang2",
"盵":"qi4",
"盶":"ruan3",
"盷":"tian2",
"盹":"dun3",
"盺":"xin1",
"盻":"xi4",
"盽":"feng1",
"盿":"min2",
"眀":"ming2",
"眂":"shi4",
"眃":"yun2",
"眄":"mian3",
"眅":"pan1",
"眆":"fang3",
"眇":"miao3",
"眈":"dan1",
"眊":"mao4",
"県":"xian4",
"眍":"ou1",
"眎":"shi4",
"眏":"yang1",
"眐":"zheng1",
"眑":"yao3",
"眒":"shen4",
"眓":"huo4",
"眔":"da4",
"眕":"zhen3",
"眖":"kuang4",
"眗":"ju1",
"眘":"shen4",
"眙":"chi4",
"眚":"sheng3",
"眛":"mei4",
"眜":"mo4",
"眝":"zhu4",
"眞":"zhen1",
"眡":"di1",
"眢":"yuan1",
"眣":"die2",
"眤":"yi2",
"眥":"zi4",
"眦":"zi4",
"眧":"chao3",
"眩":"xuan4",
"眪":"bing3",
"眫":"mi3",
"眬":"long2",
"眭":"sui1",
"眮":"dong4",
"眰":"die2",
"眱":"yi2",
"眲":"er4",
"眳":"ming3",
"眴":"xuan4",
"眵":"chi1",
"眷":"juan4",
"眸":"mou2",
"眹":"zhen4",
"眻":"yang2",
"眽":"mo4",
"眿":"mai4",
"睂":"mei2",
"睃":"jun4",
"睄":"shao4",
"睅":"han4",
"睆":"huan3",
"睇":"di4",
"睈":"cheng3",
"睉":"cuo1",
"睊":"juan4",
"睋":"e2",
"睌":"wan3",
"睍":"xian4",
"睎":"xi1",
"睏":"kun4",
"睐":"lai4",
"睑":"jian3",
"睒":"shan3",
"睓":"tian3",
"睔":"hun3",
"睕":"wan3",
"睖":"ling2",
"睗":"shi4",
"睘":"qiong2",
"睙":"lie4",
"睚":"ya2",
"睝":"li2",
"睞":"lai4",
"睟":"sui4",
"睠":"juan4",
"睢":"sui1",
"睤":"bi4",
"睥":"pi4",
"睦":"mu4",
"睧":"hun1",
"睨":"ni4",
"睩":"lu4",
"睪":"yi4",
"睬":"cai3",
"睭":"zhou3",
"睮":"yu2",
"睯":"hun1",
"睰":"ma4",
"睱":"xia4",
"睲":"xing3",
"睳":"xi1",
"睴":"gun4",
"睶":"chun3",
"睷":"jian1",
"睸":"mei4",
"睹":"du3",
"睺":"hou2",
"睻":"xuan1",
"睼":"ti4",
"睽":"kui2",
"睾":"gao1",
"睿":"rui4",
"瞀":"mao4",
"瞁":"xu4",
"瞂":"fa1",
"瞃":"wen1",
"瞆":"kui4",
"瞈":"weng3",
"瞉":"kou4",
"瞊":"dang4",
"瞋":"chen1",
"瞍":"sou3",
"瞏":"qiong2",
"瞐":"mao4",
"瞑":"ming2",
"瞓":"shui4",
"瞔":"ze2",
"瞕":"zhang4",
"瞖":"yi4",
"瞗":"diao1",
"瞘":"ou1",
"瞙":"mo4",
"瞚":"shun4",
"瞛":"cong1",
"瞜":"lou1",
"瞝":"chi1",
"瞟":"piao3",
"瞠":"cheng1",
"瞡":"ji4",
"瞢":"meng2",
"瞤":"run2",
"瞦":"xi1",
"瞨":"pu2",
"瞩":"zhu3",
"瞫":"shen3",
"瞬":"shun4",
"瞮":"che4",
"瞯":"xian2",
"瞰":"kan4",
"瞱":"ye4",
"瞲":"xu4",
"瞳":"tong2",
"瞴":"mou2",
"瞵":"lin2",
"瞶":"kui4",
"瞷":"jian4",
"瞸":"ye4",
"瞹":"ai4",
"瞺":"hui4",
"瞼":"jian3",
"瞽":"gu3",
"瞾":"zhao4",
"瞿":"qu2",
"矀":"wei2",
"矁":"chou3",
"矂":"sao4",
"矃":"ning3",
"矄":"xun1",
"矅":"yao4",
"矆":"huo4",
"矇":"meng2",
"矈":"mian2",
"矉":"bin1",
"矊":"mian2",
"矋":"li4",
"矌":"kuang4",
"矍":"jue2",
"矎":"xuan1",
"矏":"mian2",
"矐":"huo4",
"矑":"lu2",
"矒":"meng2",
"矓":"long2",
"矔":"guan4",
"矕":"man3",
"矖":"xi3",
"矘":"tang3",
"矙":"kan4",
"矚":"zhu3",
"矜":"jin1",
"矝":"lin2",
"矞":"yu4",
"矟":"shuo4",
"矠":"ce4",
"矡":"jue2",
"矢":"shi3",
"矣":"yi3",
"矤":"shen3",
"矦":"hou2",
"矧":"shen3",
"矨":"ying3",
"矪":"zhou1",
"矫":"jiao2",
"矬":"cuo2",
"矯":"jiao2",
"矰":"zeng1",
"矱":"yue1",
"矲":"bai3",
"矴":"ding4",
"矵":"qi4",
"矶":"ji1",
"矷":"zi3",
"矸":"gan1",
"矹":"wu4",
"矺":"tuo1",
"矻":"ku1",
"矼":"jiang1",
"矽":"xi1",
"矾":"fan2",
"砀":"dang4",
"砃":"dan1",
"砄":"jue2",
"砅":"li4",
"砆":"fu1",
"砇":"min2",
"砈":"nuo3",
"砉":"huo4",
"砊":"kang4",
"砋":"zhi3",
"砎":"jie4",
"砏":"fen1",
"砐":"e4",
"砑":"ya4",
"砒":"pi1",
"砓":"zhe2",
"砕":"sui4",
"砗":"che1",
"砘":"dun4",
"砙":"pan1",
"砚":"yan4",
"砜":"feng1",
"砝":"fa2",
"砞":"mo4",
"砟":"zha3",
"砠":"qu1",
"砡":"yu4",
"砢":"ke1",
"砣":"tuo2",
"砤":"tuo2",
"砥":"di3",
"砦":"zhai4",
"砧":"zhen1",
"砨":"ai4",
"砩":"fu2",
"砪":"mu3",
"砫":"zhu3",
"砬":"la2",
"砭":"bian1",
"砮":"nu3",
"砯":"ping1",
"砱":"ling2",
"砲":"pao4",
"砳":"le4",
"砵":"bo1",
"砶":"po4",
"砷":"shen1",
"砹":"ai4",
"砺":"li4",
"砻":"long2",
"砼":"tong2",
"硁":"keng1",
"硂":"quan2",
"硃":"zhu1",
"硄":"kuang1",
"硆":"e4",
"硇":"nao2",
"硈":"jia2",
"硉":"lu4",
"硊":"wei3",
"硋":"ai4",
"硌":"luo4",
"硍":"ken4",
"硎":"xing2",
"硏":"yan2",
"硐":"dong4",
"硑":"peng1",
"硒":"xi1",
"硔":"hong2",
"硕":"shuo4",
"硖":"xia2",
"硗":"qiao1",
"硙":"wei2",
"硚":"qiao2",
"硜":"keng1",
"硞":"que4",
"硟":"chan4",
"硠":"lang3",
"硡":"hong2",
"硢":"yu2",
"硣":"xiao1",
"硤":"xia2",
"硥":"mang3",
"硦":"long4",
"硧":"yong3",
"硨":"che1",
"硩":"che4",
"硪":"e2",
"硭":"mang2",
"硯":"yan4",
"硰":"sha1",
"硱":"kun3",
"硲":"yu4",
"硵":"lu3",
"硶":"chen3",
"硷":"jian3",
"硸":"nve4",
"硹":"song1",
"硺":"zhuo2",
"硻":"keng1",
"硼":"peng2",
"硽":"yan3",
"硾":"zhui4",
"硿":"kong1",
"碀":"ceng2",
"碁":"qi2",
"碂":"zong4",
"碃":"qing4",
"碄":"lin2",
"碅":"jun1",
"碆":"bo1",
"碇":"ding4",
"碈":"min2",
"碉":"diao1",
"碊":"jian1",
"碋":"he4",
"碏":"que4",
"碐":"ling2",
"碒":"yin2",
"碓":"dui4",
"碔":"wu3",
"碕":"qi2",
"碖":"lun4",
"碘":"dian3",
"碙":"gang1",
"碚":"bei4",
"碛":"qi4",
"碜":"chen3",
"碝":"ruan3",
"碞":"yan2",
"碠":"ding4",
"碡":"zhou2",
"碢":"tuo2",
"碣":"jie2",
"碤":"ying1",
"碥":"bian3",
"碦":"ke4",
"碨":"wei1",
"碩":"shuo4",
"碪":"zhen1",
"碫":"duan4",
"碬":"xia2",
"碭":"dang4",
"碮":"ti2",
"碯":"nao3",
"碲":"di4",
"碴":"cha2",
"碶":"qi4",
"碸":"feng1",
"碹":"xuan4",
"碻":"que4",
"碽":"gong1",
"碿":"su4",
"磀":"e2",
"磂":"liu4",
"磃":"si1",
"磄":"tang2",
"磆":"hua2",
"磇":"pi1",
"磈":"wei3",
"磉":"sang3",
"磋":"cuo1",
"磌":"zhen1",
"磍":"xia2",
"磎":"qi1",
"磏":"lian2",
"磐":"pan2",
"磑":"wei2",
"磒":"yun3",
"磓":"dui1",
"磔":"zhe2",
"磖":"la2",
"磘":"qing4",
"磙":"gun3",
"磛":"chan2",
"磜":"qi4",
"磝":"ao2",
"磞":"peng1",
"磟":"lu4",
"磠":"lu3",
"磡":"kan4",
"磢":"qiang3",
"磣":"chen3",
"磤":"yin3",
"磥":"lei3",
"磦":"biao1",
"磧":"qi4",
"磩":"qi1",
"磪":"cui1",
"磫":"zong1",
"磬":"qing4",
"磭":"chuo4",
"磯":"ji1",
"磰":"shan4",
"磱":"lao2",
"磲":"qu2",
"磳":"zeng1",
"磴":"deng4",
"磵":"jian4",
"磶":"xi4",
"磸":"ding4",
"磹":"dian4",
"磻":"pan2",
"磼":"za2",
"磽":"qiao1",
"磾":"di1",
"磿":"li4",
"礁":"jiao1",
"礃":"zhang3",
"礄":"qiao2",
"礅":"dun1",
"礆":"jian3",
"礇":"yu4",
"礈":"zhui4",
"礉":"he2",
"礊":"huo4",
"礋":"zhai2",
"礌":"lei4",
"礍":"ke3",
"礏":"ji2",
"礐":"que4",
"礑":"dang4",
"礒":"yi3",
"礓":"jiang1",
"礔":"pi4",
"礕":"pi1",
"礖":"yu4",
"礗":"pin1",
"礘":"qi4",
"礚":"kai4",
"礛":"jian1",
"礜":"yu4",
"礝":"ruan3",
"礞":"meng2",
"礟":"pao4",
"礠":"ci2",
"礡":"bo2",
"礣":"mie4",
"礤":"ca3",
"礥":"xian2",
"礧":"lei4",
"礨":"lei3",
"礩":"zhi4",
"礪":"li4",
"礬":"fan2",
"礭":"que4",
"礮":"pao4",
"礯":"ying1",
"礰":"li4",
"礱":"long2",
"礲":"long2",
"礳":"mo4",
"礴":"bo2",
"礵":"shuang1",
"礶":"guan4",
"礷":"lan2",
"礸":"zan3",
"礹":"yan2",
"礻":"shi4",
"礽":"reng2",
"礿":"yue4",
"祀":"si4",
"祁":"qi2",
"祂":"ta1",
"祃":"ma4",
"祄":"xie4",
"祅":"yao1",
"祆":"xian1",
"祇":"qi2",
"祈":"qi2",
"祉":"zhi3",
"祊":"beng1",
"祋":"dui4",
"祌":"zhong4",
"祍":"ren4",
"祎":"yi1",
"祏":"shi2",
"祐":"you4",
"祑":"zhi4",
"祒":"tiao2",
"祓":"fu2",
"祔":"fu4",
"祕":"mi4",
"祗":"zhi1",
"祘":"suan4",
"祙":"mei4",
"祚":"zuo4",
"祛":"qu1",
"祜":"hu4",
"祟":"sui4",
"祠":"ci2",
"祡":"chai2",
"祢":"mi2",
"祣":"lv3",
"祤":"yu3",
"祦":"wu2",
"祧":"tiao1",
"祩":"zhu1",
"祪":"gui3",
"祫":"xia2",
"祬":"zhi1",
"祭":"ji4",
"祮":"gao4",
"祯":"zhen1",
"祰":"gao4",
"祱":"shui4",
"祲":"jin1",
"祳":"chen3",
"祴":"gai1",
"祵":"kun3",
"祶":"di4",
"祷":"dao3",
"祹":"tao2",
"祺":"qi2",
"祻":"gu4",
"祼":"guan4",
"祽":"zui4",
"祾":"ling2",
"祿":"lu4",
"禀":"bing3",
"禂":"dao3",
"禃":"zhi2",
"禄":"lu4",
"禅":"chan2",
"禆":"bei1",
"禇":"zhe3",
"禈":"hui1",
"禉":"you3",
"禊":"xi4",
"禋":"yin1",
"禌":"zi1",
"禎":"zhen1",
"禐":"yuan4",
"禑":"wu2",
"禒":"xian3",
"禓":"yang2",
"禔":"ti2",
"禕":"yi1",
"禖":"mei2",
"禗":"si1",
"禘":"di4",
"禚":"zhuo2",
"禛":"zhen1",
"禜":"yong3",
"禝":"ji2",
"禞":"gao4",
"禟":"tang2",
"禠":"si1",
"禡":"ma4",
"禢":"ta4",
"禤":"xuan1",
"禥":"qi2",
"禦":"yu4",
"禧":"xi3",
"禨":"ji1",
"禩":"si4",
"禪":"shan4",
"禫":"tan3",
"禬":"kuai4",
"禭":"sui4",
"禯":"nong2",
"禰":"mi2",
"禱":"dao3",
"禲":"li4",
"禳":"rang2",
"禴":"yue4",
"禵":"ti2",
"禶":"zan3",
"禷":"lei4",
"禸":"rou2",
"禹":"yu3",
"禺":"yu2",
"禼":"xie4",
"禽":"qin2",
"禾":"he2",
"秂":"ren2",
"秄":"zi3",
"秅":"cha2",
"秇":"yi4",
"秈":"xian1",
"秉":"bing3",
"秊":"nian2",
"秌":"qiu1",
"秎":"fen2",
"秏":"hao4",
"秐":"yun2",
"秓":"zhi1",
"秔":"geng1",
"秕":"bi3",
"秖":"zhi1",
"秗":"yu4",
"秙":"ku4",
"秚":"ban4",
"秛":"pi1",
"秜":"ni2",
"秝":"li4",
"秞":"you2",
"秠":"pi1",
"秡":"ba2",
"秢":"ling2",
"秣":"mo4",
"秥":"nian2",
"秦":"qin2",
"秨":"zuo2",
"秪":"zhi1",
"秫":"shu2",
"秬":"ju4",
"秭":"zi3",
"秮":"huo2",
"秱":"tong2",
"秲":"zhi4",
"秳":"huo2",
"秴":"he2",
"秵":"yin1",
"秶":"zi1",
"秷":"zhi2",
"秸":"jie1",
"秹":"ren3",
"秺":"du4",
"秼":"zhu1",
"秽":"hui4",
"秾":"nong2",
"秿":"fu3",
"稁":"kao3",
"稂":"lang2",
"稃":"fu1",
"稄":"ze4",
"稆":"lv3",
"稇":"kun3",
"稉":"geng1",
"稊":"ti2",
"稌":"tu2",
"稏":"ya4",
"稐":"lun3",
"稑":"lu4",
"稒":"gu4",
"稓":"zuo2",
"稔":"ren3",
"稕":"zhun4",
"稖":"bang4",
"稗":"bai4",
"稘":"ji1",
"稙":"zhi1",
"稛":"kun3",
"稜":"leng2",
"稝":"peng2",
"稞":"ke1",
"稟":"bing3",
"稡":"zu2",
"稢":"yu4",
"稣":"su1",
"稤":"lve4",
"稦":"yi1",
"稧":"xi4",
"稨":"bian1",
"稩":"ji4",
"稪":"fu4",
"稫":"bi1",
"稬":"nuo4",
"稭":"jie1",
"稯":"zong1",
"稰":"xu1",
"稲":"dao4",
"稴":"lian2",
"稵":"zi1",
"稶":"yu4",
"稷":"ji4",
"稸":"xu4",
"稹":"zhen3",
"稺":"zhi4",
"稽":"qi3",
"稾":"gao3",
"穀":"gu3",
"穁":"rong2",
"穂":"sui4",
"穄":"ji4",
"穅":"kang1",
"穇":"shan1",
"穈":"men2",
"穉":"zhi4",
"穊":"ji4",
"穋":"lu4",
"穌":"su1",
"穏":"wen3",
"穐":"qiu1",
"穑":"se4",
"穓":"yi4",
"穔":"huang2",
"穕":"qie4",
"穖":"ji3",
"穘":"xiao1",
"穙":"pu2",
"穚":"jiao1",
"穛":"zhuo1",
"穜":"tong2",
"穞":"lv3",
"穟":"sui4",
"穠":"nong2",
"穡":"se4",
"穢":"hui4",
"穣":"rang2",
"穤":"nuo4",
"穥":"yu4",
"穧":"ji4",
"穨":"tui2",
"穪":"cheng1",
"穫":"huo4",
"穬":"gong3",
"穭":"lv3",
"穮":"biao1",
"穰":"rang2",
"穱":"zhuo1",
"穲":"li2",
"穳":"zan4",
"穴":"xue2",
"穵":"wa1",
"穸":"xi1",
"穹":"qiong2",
"穻":"yu1",
"穼":"sen1",
"穽":"jing3",
"穾":"yao4",
"窀":"zhun1",
"窂":"lao2",
"窅":"yao3",
"窆":"bian3",
"窇":"bao2",
"窈":"yao3",
"窉":"bing3",
"窊":"wa1",
"窋":"zhu2",
"窌":"jiao4",
"窍":"qiao4",
"窎":"diao4",
"窏":"wu1",
"窐":"gui1",
"窒":"zhi4",
"窓":"chuang1",
"窔":"yao3",
"窕":"tiao3",
"窘":"jiong3",
"窙":"xiao1",
"窚":"cheng2",
"窛":"kou4",
"窞":"dan4",
"窠":"ke1",
"窡":"zhui4",
"窢":"xu4",
"窣":"su4",
"窥":"kui1",
"窦":"dou4",
"窨":"xun1",
"窪":"wa1",
"窫":"ya4",
"窬":"yu2",
"窭":"ju4",
"窰":"yao2",
"窱":"tiao4",
"窲":"chao2",
"窳":"yu3",
"窴":"tian2",
"窵":"diao4",
"窶":"ju4",
"窷":"liao2",
"窸":"xi1",
"窹":"wu4",
"窺":"kui1",
"窻":"chuang1",
"窼":"zhao1",
"窾":"kuan3",
"竀":"cheng1",
"竁":"cui4",
"竂":"piao2",
"竃":"zao4",
"竅":"qiao4",
"竆":"qiong2",
"竇":"dou4",
"竈":"zao4",
"竉":"long3",
"竌":"chu4",
"竎":"fou4",
"竐":"chu4",
"竑":"hong2",
"竒":"qi2",
"竗":"miao4",
"竘":"ju3",
"竚":"zhu4",
"竛":"ling2",
"竜":"long2",
"竝":"bing4",
"竢":"si4",
"竣":"jun4",
"竤":"hong2",
"竦":"song3",
"竧":"jing4",
"竨":"diao4",
"竩":"yi4",
"竪":"shu4",
"竫":"jing4",
"竬":"qu3",
"竮":"ping2",
"竰":"shao2",
"竱":"zhuan3",
"竲":"ceng2",
"竳":"deng1",
"竴":"cui1",
"竵":"huai1",
"竷":"kan4",
"竸":"jing4",
"竺":"zhu2",
"竻":"le4",
"竼":"peng2",
"竾":"chi2",
"笀":"mang2",
"笁":"zhu2",
"笃":"du3",
"笄":"ji1",
"笅":"xiao2",
"笇":"suan4",
"笈":"ji2",
"笉":"zhen3",
"笊":"zhao4",
"笋":"sun3",
"笌":"ya2",
"笍":"zhui4",
"笎":"yuan2",
"笏":"hu4",
"笐":"gang1",
"笒":"cen2",
"笓":"pi2",
"笕":"jian3",
"笖":"yi3",
"笗":"dong1",
"笘":"shan1",
"笙":"sheng1",
"笚":"xia2",
"笜":"zhu2",
"笝":"na4",
"笞":"chi1",
"笟":"gu1",
"笠":"li4",
"笡":"qie4",
"笢":"min3",
"笣":"bao1",
"笤":"tiao2",
"笥":"si4",
"笧":"ce4",
"笩":"pei4",
"笪":"da2",
"笫":"zi3",
"笭":"ling2",
"笮":"ze2",
"笯":"nu2",
"笰":"fu2",
"笱":"gou3",
"笲":"fan2",
"笳":"jia1",
"笴":"ge3",
"笵":"fan4",
"笶":"shi3",
"笷":"mao3",
"笸":"po3",
"笺":"jian1",
"笻":"qiong2",
"笾":"bian1",
"笿":"luo4",
"筀":"gui4",
"筁":"qu3",
"筂":"chi2",
"筃":"yin1",
"筄":"yao4",
"筅":"xian3",
"筇":"qiong2",
"筈":"gua1",
"筊":"jiao3",
"筌":"quan2",
"筍":"sun3",
"筎":"ru2",
"筏":"fa2",
"筓":"ji1",
"筕":"xing2",
"筗":"zhong4",
"筘":"kou4",
"筙":"lai2",
"筚":"bi4",
"筜":"dang1",
"筝":"zheng1",
"筞":"ce4",
"筟":"fu1",
"筠":"yun2",
"筡":"tu2",
"筢":"pa2",
"筣":"li4",
"筤":"lang2",
"筥":"ju3",
"筦":"guan3",
"筧":"jian3",
"筨":"han2",
"筩":"tong3",
"筪":"xia2",
"筫":"zhi4",
"筬":"cheng2",
"筭":"suan4",
"筮":"shi4",
"筯":"zhu4",
"筰":"zuo2",
"筱":"xiao3",
"筲":"shao1",
"筳":"ting2",
"筴":"jia1",
"筵":"yan2",
"筶":"gao3",
"筸":"gan1",
"筹":"chou2",
"筻":"gang4",
"筼":"yun2",
"筿":"xiao3",
"箁":"pu2",
"箂":"lai2",
"箃":"zou1",
"箄":"bi4",
"箅":"bi4",
"箆":"bi4",
"箇":"ge4",
"箈":"chi2",
"箉":"guai3",
"箊":"yu1",
"箋":"jian1",
"箌":"zhao4",
"箍":"gu1",
"箎":"chi2",
"箏":"zheng1",
"箐":"qing4",
"箑":"sha4",
"箒":"zhou3",
"箓":"lu4",
"箔":"bo2",
"箕":"ji1",
"箖":"lin2",
"箘":"jun4",
"箙":"fu2",
"箚":"zha2",
"箛":"gu1",
"箜":"kong1",
"箝":"qian2",
"箞":"quan1",
"箟":"jun4",
"箠":"chui2",
"箢":"yuan1",
"箣":"ce4",
"箤":"ju2",
"箥":"bo3",
"箦":"ze2",
"箧":"qie4",
"箨":"tuo4",
"箪":"dan1",
"箬":"ruo4",
"箯":"bian1",
"箰":"sun3",
"箲":"xian3",
"箳":"ping2",
"箴":"zhen1",
"箵":"sheng3",
"箶":"hu2",
"箷":"shi1",
"箸":"zhu4",
"箹":"yue1",
"箺":"chun3",
"箻":"lv4",
"箼":"wu1",
"箽":"dong3",
"箾":"shuo4",
"箿":"ji2",
"篁":"huang2",
"篂":"xing1",
"篃":"mei2",
"範":"fan4",
"篅":"chui2",
"篆":"zhuan4",
"篈":"feng1",
"築":"zhu4",
"篊":"hong2",
"篋":"qie4",
"篌":"hou2",
"篍":"qiu1",
"篎":"miao3",
"篏":"qian4",
"篑":"kui4",
"篓":"lou3",
"篔":"yun2",
"篕":"he2",
"篖":"tang2",
"篗":"yue4",
"篘":"chou1",
"篙":"gao1",
"篚":"fei3",
"篛":"ruo4",
"篜":"zheng1",
"篝":"gou1",
"篞":"nie4",
"篟":"qian4",
"篠":"xiao3",
"篡":"cuan4",
"篢":"gong1",
"篣":"pang2",
"篤":"du3",
"篥":"li4",
"篦":"bi4",
"篧":"zhuo2",
"篨":"chu2",
"篪":"chi2",
"篫":"zhu2",
"篬":"qiang1",
"篭":"long2",
"篯":"jian1",
"篰":"bu4",
"篲":"hui4",
"篳":"bi4",
"篴":"di2",
"篵":"cong1",
"篶":"yan1",
"篸":"sen1",
"篹":"zhuan4",
"篺":"pai2",
"篻":"piao4",
"篼":"dou1",
"篽":"yu3",
"篾":"mie4",
"篿":"zhuan1",
"簀":"ze2",
"簁":"xi3",
"簂":"guo2",
"簃":"yi2",
"簄":"hu4",
"簅":"chan3",
"簆":"kou4",
"簈":"ping2",
"簉":"zao4",
"簊":"ji1",
"簋":"gui3",
"簌":"su4",
"簍":"lou3",
"簎":"zha4",
"簏":"lu4",
"簐":"nian3",
"簑":"suo1",
"簒":"cuan4",
"簔":"suo1",
"簕":"le4",
"簖":"duan4",
"簘":"xiao1",
"簙":"bo2",
"簚":"mi4",
"簛":"si1",
"簜":"dang4",
"簝":"liao2",
"簞":"dan1",
"簟":"dian4",
"簠":"fu3",
"簢":"min3",
"簣":"kui4",
"簤":"dai4",
"簥":"jiao1",
"簦":"deng1",
"簧":"huang2",
"簨":"sun3",
"簩":"lao2",
"簪":"zan1",
"簬":"lu4",
"簭":"shi4",
"簮":"zan1",
"簰":"pai2",
"簲":"pai2",
"簳":"gan4",
"簴":"ju4",
"簵":"du4",
"簶":"lu4",
"簷":"yan2",
"簹":"dang1",
"簺":"sai4",
"簻":"ke1",
"簼":"long2",
"簾":"lian2",
"簿":"bu4",
"籀":"zhou4",
"籁":"lai4",
"籄":"kui4",
"籅":"yu2",
"籆":"yue4",
"籇":"hao2",
"籈":"zhen1",
"籉":"tai2",
"籊":"ti4",
"籋":"mi2",
"籌":"chou2",
"籐":"teng2",
"籑":"zhuan4",
"籒":"zhou4",
"籓":"fan1",
"籔":"sou3",
"籕":"zhou4",
"籗":"zhuo2",
"籘":"teng2",
"籙":"lu4",
"籚":"lu2",
"籛":"jian1",
"籜":"tuo4",
"籝":"ying2",
"籞":"yu4",
"籟":"lai4",
"籢":"lian2",
"籣":"lan2",
"籤":"qian1",
"籥":"yue4",
"籦":"zhong1",
"籧":"qu2",
"籨":"lian2",
"籩":"bian1",
"籪":"duan4",
"籫":"zuan3",
"籭":"si1",
"籯":"ying2",
"籰":"yue4",
"籱":"zhuo2",
"籲":"yu4",
"籴":"di2",
"籵":"fan2",
"籶":"shen1",
"籷":"zhe2",
"籸":"shen1",
"籹":"nv3",
"籺":"xie2",
"籼":"xian1",
"籾":"ni2",
"籿":"cun4",
"粁":"qian1",
"粃":"bi3",
"粄":"ban3",
"粅":"wu4",
"粆":"sha1",
"粇":"kang1",
"粈":"rou3",
"粊":"bi4",
"粋":"cui4",
"粍":"li2",
"粎":"chi3",
"粑":"ba1",
"粓":"gan1",
"粔":"ju4",
"粕":"po4",
"粖":"mo4",
"粙":"zhou4",
"粚":"li2",
"粛":"su4",
"粝":"li4",
"粞":"xi1",
"粟":"su4",
"粠":"hong2",
"粡":"tong2",
"粢":"zi1",
"粣":"ce4",
"粤":"yue4",
"粦":"lin4",
"粧":"zhuang1",
"粨":"bai3",
"粯":"xian4",
"粰":"fu2",
"粱":"liang2",
"粲":"can4",
"粳":"jing1",
"粴":"li3",
"粵":"yue4",
"粶":"lu4",
"粷":"ju2",
"粸":"qi2",
"粺":"bai4",
"粻":"zhang1",
"粼":"lin2",
"粽":"zong4",
"粿":"guo3",
"糁":"shen1",
"糂":"san3",
"糃":"tang2",
"糄":"bian1",
"糅":"rou2",
"糆":"mian4",
"糇":"hou2",
"糈":"xu3",
"糉":"zong4",
"糋":"jian4",
"糌":"zan2",
"糍":"ci2",
"糎":"li2",
"糏":"xie4",
"糐":"fu1",
"糑":"ni4",
"糒":"bei4",
"糓":"gu3",
"糔":"xiu3",
"糗":"qiu3",
"糚":"zhuang1",
"糛":"tang2",
"糜":"mei2",
"糝":"shen1",
"糠":"kang1",
"糡":"jiang4",
"糢":"mo2",
"糣":"san3",
"糤":"san3",
"糥":"nuo4",
"糦":"xi1",
"糨":"jiang4",
"糩":"kuai4",
"糪":"bo2",
"糫":"huan2",
"糭":"zong4",
"糮":"xian4",
"糯":"nuo4",
"糰":"tuan2",
"糱":"nie4",
"糲":"li4",
"糳":"zuo4",
"糴":"di2",
"糵":"nie4",
"糷":"lan2",
"糸":"si1",
"糹":"si1",
"糺":"jiu1",
"糼":"gong1",
"糽":"zheng3",
"糿":"you4",
"紁":"cha4",
"紂":"zhou4",
"紃":"xun2",
"紆":"yu1",
"紇":"he2",
"紈":"wan2",
"紉":"ren4",
"紊":"wen3",
"紌":"qiu2",
"紎":"zi1",
"紏":"tou3",
"紑":"fou2",
"紒":"jie4",
"紓":"shu1",
"紕":"pi1",
"紖":"yin3",
"紘":"hong2",
"紜":"yun2",
"紝":"ren4",
"紞":"dan3",
"紟":"jin1",
"紣":"cui4",
"紤":"jiu3",
"紥":"zha2",
"紨":"fu4",
"紩":"zhi4",
"紪":"ci3",
"紬":"chou2",
"紭":"hong2",
"紮":"za1",
"紱":"fu2",
"紲":"xie4",
"紴":"bei4",
"紵":"zhu4",
"紶":"qu3",
"紷":"ling2",
"紸":"zhu4",
"紺":"gan4",
"紻":"yang1",
"紼":"fu2",
"紽":"tuo2",
"紾":"zhen3",
"紿":"dai4",
"絀":"chu4",
"絁":"shi1",
"絃":"xian2",
"絅":"jiong3",
"絆":"ban4",
"絇":"ju4",
"絈":"mo4",
"絉":"shu4",
"絊":"zui4",
"経":"jing1",
"絍":"ren4",
"絎":"heng4",
"絏":"xie4",
"絑":"zhu1",
"絒":"chou2",
"絓":"gua4",
"絔":"bai3",
"絖":"kuang4",
"絗":"hu2",
"絘":"ci4",
"絙":"geng1",
"絚":"geng1",
"絛":"tao1",
"絜":"xie2",
"絝":"ku4",
"絞":"jiao3",
"絟":"quan1",
"絠":"gai3",
"絣":"bing3",
"絤":"xian4",
"絥":"fu2",
"絧":"tong2",
"絩":"tiao4",
"絪":"yin1",
"絫":"lei3",
"絬":"xie4",
"絭":"quan4",
"絮":"xu4",
"絯":"gai1",
"絰":"die2",
"絳":"jiang4",
"絴":"xiang2",
"絵":"hui4",
"絶":"jue2",
"絷":"zhi2",
"絸":"jian3",
"絺":"chi1",
"絻":"mian3",
"絼":"zhen3",
"絽":"lv3",
"絾":"cheng2",
"絿":"qiu2",
"綀":"shu1",
"綂":"tong3",
"綃":"xiao1",
"綄":"wan4",
"綅":"qin1",
"綆":"geng3",
"綇":"xiu3",
"綈":"ti2",
"綉":"xiu4",
"綊":"xie2",
"綋":"hong2",
"綌":"xi4",
"綍":"fu2",
"綎":"ting1",
"綏":"sui2",
"綐":"dui4",
"綑":"kun3",
"綒":"fu1",
"綔":"hu4",
"綕":"zhi1",
"綖":"yan2",
"綗":"jiong3",
"綘":"feng2",
"継":"ji4",
"続":"xu4",
"綝":"lin2",
"綞":"duo3",
"綟":"li4",
"綡":"liang2",
"綣":"quan3",
"綤":"shao4",
"綥":"qi4",
"綦":"qi2",
"綧":"zhun3",
"綨":"qi2",
"綩":"wan3",
"綪":"qian4",
"綫":"xian4",
"綬":"shou4",
"綮":"qi3",
"綯":"tao2",
"綰":"wan3",
"綳":"beng1",
"綵":"cai3",
"綶":"guo3",
"綷":"cui4",
"綹":"liu3",
"綺":"qi3",
"綻":"zhan4",
"綼":"bei1",
"綽":"chuo4",
"綾":"ling2",
"緀":"qi1",
"緁":"jie2",
"緂":"tan1",
"緃":"zong1",
"緄":"gun3",
"緅":"zou1",
"緆":"yi4",
"緇":"zi1",
"緈":"xing4",
"緉":"liang3",
"緋":"fei1",
"緌":"rui2",
"緍":"min2",
"緎":"yu4",
"総":"zong3",
"緐":"fan2",
"緑":"lv4",
"緓":"ying1",
"緔":"zhang4",
"緖":"xu4",
"緗":"xiang1",
"緘":"jian1",
"緙":"ke4",
"緛":"ruan3",
"緜":"mian2",
"緝":"qi1",
"緟":"zhong4",
"緡":"min2",
"緢":"miao2",
"緤":"xie4",
"緥":"bao3",
"緦":"si1",
"緧":"qiu1",
"緪":"geng1",
"緫":"cong1",
"緬":"mian3",
"緭":"wei4",
"緮":"fu4",
"緰":"yu2",
"緱":"gou1",
"緲":"miao3",
"緳":"xie2",
"緵":"zong1",
"緶":"bian4",
"緷":"yun4",
"緸":"yin1",
"緹":"ti2",
"緺":"gua1",
"緻":"zhi4",
"緼":"yun1",
"緽":"cheng1",
"緾":"chan2",
"緿":"dai4",
"縀":"xia2",
"縁":"yuan2",
"縂":"zong3",
"縃":"xu1",
"縄":"sheng2",
"縆":"geng1",
"縈":"ying2",
"縉":"jin4",
"縊":"yi4",
"縋":"zhui4",
"縌":"ni4",
"縍":"bang1",
"縎":"gu3",
"縏":"pan2",
"縐":"zhou4",
"縑":"jian1",
"縒":"cuo3",
"縓":"quan3",
"縔":"shuang3",
"縕":"yun4",
"縖":"xia2",
"縗":"cui1",
"縘":"xi1",
"縙":"rong2",
"縚":"tao1",
"縜":"yun2",
"縝":"zhen3",
"縞":"gao3",
"縟":"ru4",
"縠":"hu2",
"縡":"zai3",
"縢":"teng2",
"縤":"su4",
"縥":"zhen3",
"縦":"zong4",
"縧":"tao1",
"縩":"cai4",
"縪":"bi4",
"縬":"cu4",
"縭":"li2",
"縯":"yin3",
"縰":"xi3",
"縲":"lei2",
"縳":"zhuan4",
"縴":"qian4",
"縵":"man4",
"縶":"zhi2",
"縸":"mo4",
"縹":"piao3",
"縺":"lian2",
"縻":"mi2",
"縼":"xuan4",
"縿":"shan1",
"繀":"sui4",
"繂":"shuai4",
"繄":"yi1",
"繅":"sao1",
"繆":"miao4",
"繇":"yao2",
"繈":"qiang3",
"繉":"hun2",
"繊":"xian1",
"繋":"ji4",
"繍":"xiu4",
"繎":"ran2",
"繏":"xuan4",
"繐":"sui4",
"繑":"qiao1",
"繒":"zeng4",
"繓":"zuo3",
"繕":"shan4",
"繖":"san3",
"繗":"lin2",
"繘":"yu4",
"繙":"fan1",
"繚":"liao2",
"繛":"chuo4",
"繜":"zun1",
"繝":"jian4",
"繟":"chan3",
"繠":"rui3",
"繢":"hui4",
"繣":"hua4",
"繤":"zuan3",
"繥":"xi1",
"繦":"qiang3",
"繨":"da2",
"繫":"xi4",
"繬":"se4",
"繮":"jiang1",
"繯":"huan2",
"繰":"qiao1",
"繱":"cong1",
"繲":"jie4",
"繴":"bo4",
"繵":"chan2",
"繶":"yi4",
"繷":"nao2",
"繸":"sui4",
"繹":"yi4",
"繺":"shai3",
"繻":"xu1",
"繽":"bin1",
"繾":"qian3",
"繿":"lan2",
"纀":"pu2",
"纁":"xun1",
"纂":"zuan3",
"纃":"qi2",
"纄":"peng2",
"纅":"li4",
"纆":"mo4",
"纇":"lei4",
"纈":"xie2",
"纉":"zuan3",
"纊":"kuang4",
"纋":"you1",
"纍":"lei2",
"纎":"xian1",
"纑":"lu2",
"纒":"chan2",
"纓":"ying1",
"纔":"cai2",
"纕":"xiang1",
"纗":"zui1",
"纘":"zuan3",
"纙":"luo4",
"纚":"li2",
"纛":"dao4",
"纜":"lan3",
"纝":"lei2",
"纞":"lian4",
"纟":"si1",
"纡":"yu1",
"纣":"zhou4",
"纥":"he2",
"纨":"wan2",
"纩":"kuang4",
"纫":"ren4",
"纭":"yun2",
"纮":"hong2",
"纰":"pi1",
"纴":"ren4",
"纻":"zhu4",
"纼":"yin3",
"纾":"shu1",
"绀":"gan4",
"绁":"xie4",
"绂":"fu2",
"绉":"zhou4",
"绊":"ban4",
"绋":"fu2",
"绌":"chu4",
"绎":"yi4",
"绐":"dai4",
"绔":"ku4",
"绖":"die2",
"绗":"heng4",
"绛":"jiang4",
"绞":"jiao3",
"绠":"geng3",
"绡":"xiao1",
"绤":"xi4",
"绥":"sui2",
"绦":"tao1",
"绨":"ti2",
"绫":"ling2",
"绬":"ying1",
"绮":"qi3",
"绯":"fei1",
"绰":"chuo4",
"绱":"shang4",
"绲":"gun3",
"绶":"shou4",
"绹":"tao2",
"绺":"liu3",
"绻":"quan3",
"绽":"zhan4",
"绾":"wan3",
"缁":"zi1",
"缂":"ke4",
"缃":"xiang1",
"缄":"jian1",
"缅":"mian3",
"缆":"lan3",
"缇":"ti2",
"缈":"miao3",
"缉":"qi4",
"缊":"yun4",
"缋":"hui4",
"缌":"si1",
"缍":"duo3",
"缏":"bian4",
"缐":"xian4",
"缑":"gou1",
"缒":"zhui4",
"缗":"min2",
"缙":"jin4",
"缛":"ru4",
"缜":"zhen3",
"缞":"cui1",
"缟":"gao3",
"缡":"li2",
"缢":"yi4",
"缣":"jian1",
"缤":"bin1",
"缥":"piao3",
"缦":"man4",
"缧":"lei2",
"缨":"ying1",
"缪":"miao4",
"缫":"sao1",
"缬":"xie2",
"缭":"liao2",
"缮":"shan4",
"缯":"zeng4",
"缱":"qian3",
"缲":"qiao1",
"缳":"huan2",
"缵":"zuan3",
"缶":"fou3",
"缷":"xie4",
"缹":"fou3",
"缻":"fou3",
"缽":"bo1",
"缾":"ping2",
"缿":"hou4",
"罁":"gang1",
"罂":"ying1",
"罃":"ying1",
"罄":"qing4",
"罅":"xia4",
"罆":"guan4",
"罇":"zun1",
"罈":"tan2",
"罊":"qi4",
"罋":"weng4",
"罌":"ying1",
"罍":"lei2",
"罎":"tan2",
"罏":"lu2",
"罒":"wang3",
"罓":"gang1",
"罔":"wang3",
"罕":"han3",
"罗":"luo2",
"罘":"fu2",
"罙":"mi2",
"罛":"gu1",
"罜":"zhu3",
"罝":"ju1",
"罞":"mao2",
"罟":"gu3",
"罠":"min2",
"罡":"gang1",
"罣":"gua4",
"罤":"ti2",
"罥":"juan4",
"罦":"fu2",
"罧":"lin2",
"罨":"yan3",
"罫":"gua4",
"罬":"zhuo2",
"罭":"yu4",
"罯":"an3",
"罱":"nan3",
"罳":"si1",
"罴":"pi2",
"罶":"liu3",
"罸":"fa2",
"罹":"li2",
"罺":"chao1",
"罻":"wei4",
"罼":"bi4",
"罽":"ji4",
"罾":"zeng1",
"罿":"tong2",
"羀":"liu3",
"羁":"ji1",
"羂":"juan4",
"羃":"mi4",
"羄":"zhao4",
"羅":"luo2",
"羆":"pi2",
"羇":"ji1",
"羈":"ji1",
"羉":"luan2",
"羋":"mi3",
"羌":"qiang1",
"羍":"ta4",
"羏":"yang2",
"羐":"you3",
"羑":"you3",
"羒":"fen2",
"羓":"ba1",
"羕":"yang4",
"羖":"gu3",
"羗":"qiang1",
"羘":"zang1",
"羙":"gao1",
"羚":"ling2",
"羛":"yi4",
"羜":"zhu4",
"羝":"di1",
"羞":"xiu1",
"羟":"qiang3",
"羠":"yi2",
"羢":"rong2",
"羣":"qun2",
"羥":"qiang3",
"羦":"huan2",
"羧":"suo1",
"羫":"qiang1",
"羬":"xian2",
"羭":"yu2",
"羮":"geng1",
"羯":"jie2",
"羰":"tang1",
"羱":"yuan2",
"羲":"xi1",
"羳":"fan2",
"羴":"shan1",
"羵":"fen3",
"羶":"shan1",
"羷":"lian3",
"羸":"lei2",
"羹":"geng1",
"羺":"nou2",
"羻":"qiang4",
"羼":"chan4",
"羾":"gong4",
"羿":"yi4",
"翀":"chong1",
"翂":"fen1",
"翃":"hong2",
"翄":"chi4",
"翆":"cui4",
"翇":"fu2",
"翈":"xia2",
"翉":"pen3",
"翊":"yi4",
"翋":"la1",
"翌":"yi4",
"翍":"pi1",
"翎":"ling2",
"翏":"liao4",
"翐":"zhi4",
"翑":"qu2",
"翓":"xie2",
"翕":"xi1",
"翖":"xi4",
"翗":"qi2",
"翙":"hui4",
"翚":"hui1",
"翛":"xiao1",
"翜":"se4",
"翝":"hong2",
"翞":"jiang1",
"翟":"di2",
"翠":"cui4",
"翡":"fei3",
"翢":"tao1",
"翣":"sha4",
"翤":"chi4",
"翥":"zhu4",
"翦":"jian3",
"翧":"xuan1",
"翨":"shi4",
"翩":"pian1",
"翪":"zong1",
"翫":"wan4",
"翬":"hui1",
"翭":"hou2",
"翮":"he2",
"翯":"he4",
"翰":"han4",
"翱":"ao2",
"翲":"piao1",
"翳":"yi4",
"翴":"lian2",
"翵":"qu2",
"翷":"lin2",
"翸":"pen3",
"翺":"ao2",
"翽":"hui4",
"翾":"xuan1",
"翿":"dao4",
"耄":"mao4",
"耆":"qi2",
"耇":"gou3",
"耈":"gou3",
"耉":"gou3",
"耊":"die4",
"耋":"die2",
"耎":"ruan3",
"耏":"er2",
"耑":"duan1",
"耒":"lei3",
"耓":"ting1",
"耔":"zi3",
"耖":"chao4",
"耘":"yun2",
"耙":"pa2",
"耚":"pi1",
"耛":"chi2",
"耜":"si4",
"耝":"chu2",
"耞":"jia1",
"耟":"ju4",
"耠":"he2",
"耡":"chu2",
"耢":"lao4",
"耣":"lun3",
"耤":"ji1",
"耥":"tang3",
"耦":"ou3",
"耧":"lou2",
"耨":"nou4",
"耩":"jiang3",
"耪":"pang3",
"耫":"ze2",
"耬":"lou2",
"耭":"ji1",
"耮":"lao4",
"耯":"huo4",
"耰":"you1",
"耱":"mo4",
"耲":"huai2",
"耴":"zhe2",
"耵":"ding1",
"耶":"ye1",
"耹":"qin2",
"耺":"yun2",
"耼":"dan1",
"耾":"hong2",
"耿":"geng3",
"聀":"zhi2",
"聂":"nie4",
"聃":"dan1",
"聄":"zhen3",
"聅":"che4",
"聆":"ling2",
"聇":"zheng1",
"聈":"you3",
"聉":"wa1",
"聋":"long2",
"聍":"ning2",
"聎":"tiao1",
"聏":"er2",
"聐":"ya4",
"聑":"die2",
"聒":"guo1",
"聕":"hao4",
"聗":"lie4",
"聘":"pin4",
"聙":"jing1",
"聛":"bi4",
"聜":"di3",
"聝":"guo2",
"聟":"xu4",
"聠":"ping2",
"聡":"cong1",
"聤":"ting2",
"聥":"yu3",
"聦":"cong1",
"聧":"kui2",
"聩":"kui4",
"聫":"lian2",
"聬":"weng3",
"聭":"kui4",
"聮":"lian2",
"聱":"ao2",
"聴":"ting1",
"聵":"kui4",
"聶":"nie4",
"聸":"dan1",
"聹":"ning2",
"聻":"ji1",
"聼":"ting1",
"聾":"long2",
"聿":"yu4",
"肀":"yu4",
"肁":"zhao4",
"肂":"si4",
"肄":"yi4",
"肆":"si4",
"肇":"zhao4",
"肈":"zhao4",
"肊":"yi4",
"肋":"lei4",
"肍":"qiu2",
"肎":"ken3",
"肏":"cao4",
"肐":"ge1",
"肑":"di4",
"肒":"huan2",
"肓":"huang1",
"肔":"yi3",
"肕":"ren4",
"肗":"ru3",
"肘":"zhou3",
"肙":"yuan1",
"肛":"gang1",
"肜":"rong2",
"肞":"cha1",
"肟":"wo4",
"肣":"han2",
"肦":"fen2",
"肧":"pei1",
"肨":"pang4",
"肫":"zhun1",
"肬":"you2",
"肭":"na4",
"肮":"ang1",
"肰":"ran2",
"肱":"gong1",
"肳":"wen3",
"肴":"yao2",
"肵":"jin4",
"肶":"pi2",
"肷":"qian1",
"肸":"xi4",
"肹":"xi1",
"肻":"ken3",
"肼":"jing3",
"肽":"tai4",
"肾":"shen4",
"胂":"shen4",
"胄":"zhou4",
"胅":"die2",
"胇":"fei4",
"胈":"ba2",
"胉":"bo2",
"胊":"qu2",
"胋":"tian2",
"胍":"gua1",
"胏":"zi3",
"胐":"ku1",
"胑":"zhi1",
"胒":"ni4",
"胓":"ping2",
"胔":"zi4",
"胕":"fu4",
"胗":"zhen1",
"胘":"xian2",
"胙":"zuo4",
"胚":"pei1",
"胛":"jia3",
"胝":"zhi1",
"胟":"mu3",
"胠":"qu1",
"胢":"ke1",
"胣":"yi3",
"胤":"yin4",
"胥":"xu1",
"胦":"yang1",
"胨":"dong4",
"胩":"ka3",
"胪":"lu2",
"胫":"jing4",
"胬":"nu3",
"胭":"yan1",
"胮":"pang2",
"胯":"kua4",
"胰":"yi2",
"胱":"guang1",
"胲":"hai3",
"胴":"dong4",
"胵":"zhi4",
"胷":"xiong1",
"胹":"er2",
"胺":"an4",
"胻":"heng2",
"胼":"pian2",
"胾":"zi4",
"脀":"cheng2",
"脁":"tiao4",
"脃":"cui4",
"脄":"mei2",
"脇":"xie2",
"脍":"kuai4",
"脎":"sa4",
"脐":"qi2",
"脒":"mi3",
"脓":"nong2",
"脔":"luan2",
"脕":"wan3",
"脗":"wen3",
"脘":"wan3",
"脙":"qiu2",
"脛":"jing4",
"脜":"rou2",
"脝":"heng1",
"脞":"cuo3",
"脟":"lie4",
"脠":"shan1",
"脡":"ting3",
"脢":"mei2",
"脣":"chun2",
"脤":"shen4",
"脥":"qian3",
"脦":"te4",
"脧":"juan1",
"脨":"cu4",
"脩":"xiu1",
"脪":"xin4",
"脬":"pao1",
"脭":"cheng2",
"脮":"nei3",
"脰":"dou4",
"脲":"niao4",
"脳":"nao3",
"脴":"pi3",
"脵":"gu3",
"脶":"gua1",
"脷":"li4",
"脺":"cui4",
"脻":"jie2",
"脼":"liang3",
"脽":"zhou1",
"脿":"biao1",
"腀":"lun2",
"腁":"pian2",
"腂":"guo4",
"腃":"kui4",
"腄":"chui2",
"腅":"dan4",
"腆":"tian3",
"腇":"nei3",
"腉":"jie1",
"腊":"la4",
"腋":"ye4",
"腌":"yan1",
"腍":"ren3",
"腎":"shen4",
"腏":"chuo4",
"腑":"fu3",
"腒":"ju1",
"腓":"fei2",
"腕":"wan4",
"腖":"dong4",
"腗":"pi2",
"腘":"guo2",
"腙":"zong1",
"腚":"ding4",
"腛":"wu1",
"腜":"mei2",
"腝":"ruan3",
"腞":"zhuan4",
"腟":"zhi4",
"腠":"cou4",
"腡":"gua1",
"腢":"ou3",
"腣":"di4",
"腤":"an1",
"腧":"shu4",
"腨":"chuan3",
"腩":"nan3",
"腪":"yun4",
"腬":"rou2",
"腭":"e4",
"腯":"tu2",
"腱":"jian4",
"腲":"wei3",
"腴":"yu2",
"腵":"jia1",
"腶":"duan4",
"腷":"bi4",
"腺":"xian4",
"腻":"ni4",
"腼":"mian3",
"腽":"wa4",
"膁":"qian1",
"膂":"lv3",
"膃":"wa4",
"膄":"sou4",
"膅":"tang2",
"膆":"su4",
"膇":"zhui4",
"膈":"ge2",
"膉":"yi4",
"膋":"liao2",
"膌":"ji2",
"膍":"pi2",
"膎":"xie2",
"膐":"lv3",
"膑":"bin4",
"膓":"chang2",
"膔":"lu4",
"膕":"guo2",
"膖":"pang1",
"膗":"chuai2",
"膘":"biao1",
"膙":"jiang3",
"膞":"zhuan1",
"膟":"lv4",
"膡":"ying4",
"膢":"lv2",
"膣":"zhi4",
"膥":"chun1",
"膦":"lin4",
"膧":"tong2",
"膩":"ni4",
"膪":"zha4",
"膫":"liao2",
"膬":"cui4",
"膭":"gui1",
"膮":"xiao1",
"膯":"teng1",
"膰":"fan2",
"膱":"zhi2",
"膲":"jiao1",
"膳":"shan4",
"膴":"hu1",
"膵":"cui4",
"膶":"run4",
"膷":"xiang1",
"膸":"sui3",
"膹":"fen4",
"膺":"ying1",
"膻":"shan1",
"膼":"zhua1",
"膾":"kuai4",
"膿":"nong2",
"臀":"tun2",
"臁":"lian2",
"臃":"yong1",
"臄":"jue2",
"臅":"chu4",
"臆":"yi4",
"臇":"juan3",
"臈":"la4",
"臊":"sao4",
"臋":"tun2",
"臌":"gu3",
"臍":"qi2",
"臎":"cui4",
"臏":"bin4",
"臐":"xun1",
"臑":"nao4",
"臒":"huo4",
"臓":"zang4",
"臔":"xian4",
"臕":"biao1",
"臖":"xing4",
"臗":"kuan1",
"臘":"la4",
"臙":"yan1",
"臚":"lu2",
"臛":"huo4",
"臜":"za1",
"臝":"luo3",
"臞":"qu2",
"臠":"luan2",
"臡":"ni2",
"臢":"za1",
"臤":"qian1",
"臦":"guang4",
"臧":"zang1",
"臩":"guang4",
"臫":"jiao3",
"臬":"nie4",
"臮":"ji4",
"臯":"gao1",
"臰":"chou4",
"臱":"mian2",
"臲":"nie4",
"臵":"ge2",
"臶":"jian4",
"臷":"die2",
"臸":"zhi4",
"臹":"xiu1",
"臺":"tai2",
"臻":"zhen1",
"臼":"jiu4",
"臽":"xian4",
"臾":"yu2",
"臿":"cha1",
"舁":"yu2",
"舂":"chong1",
"舃":"xi4",
"舄":"xi4",
"舎":"she4",
"舏":"jiu3",
"舐":"shi4",
"舑":"tan1",
"舓":"shi4",
"舕":"dan4",
"舖":"pu4",
"舗":"pu4",
"舘":"guan3",
"舙":"hua4",
"舚":"tan1",
"舛":"chuan3",
"舜":"shun4",
"舝":"xia2",
"舠":"dao1",
"舡":"chuan2",
"舢":"shan1",
"舣":"yi3",
"舥":"pa1",
"舦":"tai4",
"舧":"fan2",
"舨":"ban3",
"舩":"chuan2",
"舫":"fang3",
"舭":"que4",
"舯":"zhong1",
"舲":"ling2",
"舳":"zhu2",
"舴":"ze2",
"舵":"duo4",
"舷":"xian2",
"舸":"ge3",
"舺":"xia2",
"舻":"lu2",
"舼":"hong2",
"舽":"pang2",
"舾":"xi1",
"艀":"fu2",
"艁":"zao4",
"艂":"feng2",
"艃":"li2",
"艄":"shao1",
"艅":"yu2",
"艆":"lang2",
"艉":"wei3",
"艊":"bo2",
"艋":"meng3",
"艌":"nian4",
"艍":"ju1",
"艎":"huang2",
"艏":"shou3",
"艐":"zong1",
"艑":"bian4",
"艒":"mao4",
"艓":"die2",
"艕":"beng4",
"艖":"cha1",
"艗":"yi4",
"艚":"cao2",
"艛":"lou2",
"艜":"dai4",
"艞":"yao4",
"艟":"chong1",
"艡":"dang1",
"艢":"tan2",
"艣":"lu3",
"艤":"yi3",
"艥":"jie4",
"艧":"huo4",
"艨":"meng2",
"艩":"qi2",
"艪":"lu3",
"艫":"lu2",
"艬":"chan2",
"艭":"shuang1",
"艮":"gen3",
"艴":"fu2",
"艵":"ping2",
"艶":"yan4",
"艸":"cao3",
"艹":"cao3",
"艻":"le4",
"艼":"ting1",
"艽":"qiu2",
"艾":"ai4",
"艿":"nai3",
"芀":"tiao2",
"芁":"jiao1",
"芃":"peng2",
"芄":"wan2",
"芅":"yi4",
"芆":"chai1",
"芇":"mian2",
"芈":"mi3",
"芉":"gan1",
"芊":"qian1",
"芋":"yu4",
"芌":"yu4",
"芍":"shao2",
"芎":"qiong1",
"芏":"tu3",
"芐":"xia4",
"芑":"qi3",
"芓":"zi3",
"芔":"hui4",
"芕":"sui1",
"芖":"zhi4",
"芗":"xiang1",
"芘":"pi2",
"芙":"fu2",
"芚":"tun2",
"芛":"wei3",
"芜":"wu2",
"芞":"qi3",
"芟":"shan1",
"芠":"wen2",
"芡":"qian4",
"芢":"ren2",
"芣":"fu2",
"芤":"kou1",
"芥":"jie4",
"芧":"xu4",
"芨":"ji1",
"芩":"qin2",
"芪":"qi2",
"芫":"yuan2",
"芬":"fen1",
"芭":"ba1",
"芮":"rui4",
"芰":"ji4",
"芲":"hua1",
"芳":"fang1",
"芴":"wu4",
"芵":"jue2",
"芶":"gou1",
"芷":"zhi3",
"芸":"yun2",
"芹":"qin2",
"芺":"ao3",
"芻":"chu2",
"芼":"mao4",
"芾":"fu2",
"芿":"reng4",
"苀":"hang2",
"苁":"cong1",
"苂":"yin2",
"苃":"you3",
"苄":"bian4",
"苅":"yi4",
"苈":"li4",
"苉":"pi3",
"苊":"e4",
"苋":"xian4",
"苌":"chang2",
"苎":"zhu4",
"苐":"yi2",
"苑":"yuan4",
"苒":"ran3",
"苓":"ling2",
"苔":"tai1",
"苕":"tiao2",
"苖":"di3",
"苘":"qing3",
"苙":"li4",
"苚":"yong4",
"苛":"ke1",
"苜":"mu4",
"苝":"pei4",
"苞":"bao1",
"苟":"gou3",
"苠":"min2",
"苡":"yi3",
"苢":"yi3",
"苣":"ju4",
"苤":"pie3",
"苧":"zhu4",
"苨":"ni3",
"苩":"bo2",
"苪":"bing3",
"苫":"shan1",
"苬":"qiu2",
"苭":"yao3",
"苮":"xian1",
"苯":"ben3",
"苰":"hong2",
"苲":"zha3",
"苳":"dong1",
"苴":"ju1",
"苵":"die2",
"苶":"nie2",
"苷":"gan1",
"苸":"hu1",
"苺":"mei2",
"苻":"fu2",
"苼":"sheng1",
"苽":"gu1",
"苾":"bi4",
"苿":"wei4",
"茀":"fu2",
"茆":"mao2",
"茇":"ba2",
"茈":"ci2",
"茉":"mo4",
"茊":"zi1",
"茋":"di3",
"茌":"chi2",
"茍":"ji4",
"茏":"long2",
"茑":"niao3",
"茓":"xue2",
"茔":"ying2",
"茕":"qiong2",
"茖":"ge2",
"茗":"ming2",
"茘":"li4",
"茙":"rong2",
"茚":"yin4",
"茛":"gen4",
"茜":"qian4",
"茝":"chai3",
"茞":"chen2",
"茟":"yu4",
"茠":"xiu1",
"茡":"zi4",
"茢":"lie4",
"茣":"wu2",
"茤":"ji4",
"茥":"gui1",
"茦":"ce4",
"茨":"ci2",
"茩":"gou3",
"茪":"guang1",
"茬":"cha2",
"茭":"jiao1",
"茮":"jiao1",
"茯":"fu2",
"茰":"yu2",
"茱":"zhu1",
"茲":"zi1",
"茳":"jiang1",
"茴":"hui2",
"茵":"yin1",
"茷":"fa2",
"茹":"ru2",
"茺":"chong1",
"茻":"mang3",
"茼":"tong2",
"茽":"zhong4",
"茿":"zhu2",
"荀":"xun2",
"荁":"huan2",
"荂":"kua1",
"荃":"quan2",
"荄":"gai1",
"荅":"da1",
"荆":"jing1",
"荇":"xing4",
"荈":"chuan3",
"荊":"jing1",
"荋":"er2",
"荌":"an4",
"荍":"shou1",
"荎":"chi2",
"荏":"ren3",
"荑":"yi2",
"荓":"ping2",
"荕":"jin1",
"荖":"lao3",
"荗":"shu4",
"荘":"zhuang1",
"荙":"da2",
"荚":"jia2",
"荛":"rao2",
"荜":"bi4",
"荝":"ze2",
"荞":"qiao2",
"荟":"hui4",
"荠":"ji4",
"荤":"hun1",
"荥":"xing2",
"荦":"luo4",
"荧":"ying2",
"荨":"xun2",
"荩":"jin4",
"荪":"sun1",
"荫":"yin4",
"荬":"mai3",
"荭":"hong2",
"荮":"zhou4",
"荰":"du4",
"荱":"wei3",
"荲":"chu4",
"荳":"dou4",
"荴":"fu1",
"荵":"ren3",
"荶":"yin2",
"荸":"bi2",
"荹":"bu4",
"荺":"yun2",
"荻":"di2",
"荼":"tu2",
"荽":"sui1",
"荾":"sui1",
"荿":"cheng2",
"莀":"chen2",
"莁":"wu2",
"莂":"bie2",
"莃":"xi1",
"莄":"geng3",
"莅":"li4",
"莆":"pu2",
"莇":"zhu4",
"莈":"mo4",
"莉":"li4",
"莋":"ji2",
"莌":"duo2",
"莍":"qiu2",
"莎":"sha1",
"莏":"suo1",
"莐":"chen2",
"莑":"feng1",
"莒":"ju3",
"莓":"mei2",
"莔":"meng2",
"莕":"xing4",
"莗":"che1",
"莘":"shen1",
"莙":"jun1",
"莚":"yan2",
"莛":"ting2",
"莜":"diao4",
"莝":"cuo4",
"莞":"wan3",
"莟":"han4",
"莠":"you3",
"莡":"cuo4",
"莢":"jia2",
"莣":"wang2",
"莤":"you2",
"莥":"niu3",
"莦":"shao1",
"莧":"xian4",
"莨":"lang4",
"莩":"piao3",
"莪":"e2",
"莬":"wen4",
"莭":"jie2",
"莮":"nan2",
"莯":"mu4",
"莰":"kan3",
"莱":"lai2",
"莲":"lian2",
"莳":"shi4",
"莴":"wo1",
"莶":"lian3",
"莸":"you2",
"莺":"ying1",
"莼":"chun2",
"莽":"mang3",
"莾":"mang3",
"莿":"ci4",
"菀":"wan3",
"菁":"jing1",
"菂":"di1",
"菃":"qu2",
"菄":"dong1",
"菅":"jian1",
"菆":"zou1",
"菈":"la1",
"菉":"lv4",
"菋":"wei4",
"菍":"nie4",
"菎":"kun1",
"菏":"he2",
"菐":"pu2",
"菑":"zi1",
"菒":"gao3",
"菓":"guo3",
"菔":"fu2",
"菕":"lun2",
"菖":"chang1",
"菗":"chou2",
"菘":"song1",
"菙":"chui2",
"菚":"zhan4",
"菛":"men2",
"菝":"ba2",
"菞":"li2",
"菟":"tu4",
"菠":"bo1",
"菡":"han4",
"菢":"bao4",
"菣":"qin4",
"菤":"juan3",
"菥":"xi1",
"菦":"qin2",
"菧":"di3",
"菨":"jie1",
"菪":"dang4",
"菫":"jin3",
"菬":"zhao3",
"菭":"tai2",
"菮":"geng1",
"菰":"gu1",
"菱":"ling2",
"菲":"fei1",
"菳":"jin1",
"菴":"an1",
"菵":"wang3",
"菶":"beng3",
"菷":"zhou3",
"菸":"yu1",
"菹":"zu1",
"菺":"jian1",
"菻":"lin3",
"菼":"tan3",
"菽":"shu1",
"菾":"tian2",
"菿":"dao4",
"萀":"hu3",
"萁":"qi2",
"萂":"he2",
"萃":"cui4",
"萅":"chun1",
"萆":"bi4",
"萇":"chang2",
"萈":"huan2",
"萉":"fei2",
"萊":"lai2",
"萋":"qi1",
"萌":"meng2",
"萍":"ping2",
"萎":"wei3",
"萏":"dan4",
"萐":"sha4",
"萑":"huan2",
"萒":"yan3",
"萓":"yi2",
"萔":"tiao2",
"萕":"qi2",
"萖":"wan3",
"萗":"ce4",
"萘":"nai4",
"萚":"tuo4",
"萛":"jiu1",
"萜":"tie1",
"萠":"meng2",
"萦":"ying2",
"萧":"xiao1",
"萩":"qiu1",
"萪":"ke1",
"萫":"xiang4",
"萭":"yu3",
"萮":"yu4",
"萯":"fu4",
"萰":"lian4",
"萱":"xuan1",
"萲":"yuan2",
"萳":"nan2",
"萴":"ze2",
"萵":"wo1",
"萶":"chun3",
"萷":"xiao1",
"萸":"yu2",
"萹":"pian1",
"萺":"mao4",
"萻":"an1",
"萼":"e4",
"萾":"ying2",
"萿":"huo2",
"葀":"gua1",
"葁":"jiang1",
"葂":"mian3",
"葃":"zuo2",
"葄":"zuo4",
"葅":"ju1",
"葆":"bao3",
"葇":"rou2",
"葈":"xi3",
"葊":"an1",
"葋":"qu2",
"葌":"jian1",
"葍":"fu2",
"葎":"lv4",
"葏":"jing1",
"葐":"pen2",
"葑":"feng1",
"葒":"hong2",
"葓":"hong2",
"葔":"hou2",
"葕":"yan2",
"葖":"tu2",
"葘":"zi1",
"葙":"xiang1",
"葚":"ren4",
"葛":"ge3",
"葜":"jie2",
"葝":"jing4",
"葞":"mi3",
"葟":"huang2",
"葠":"shen1",
"葢":"gai4",
"董":"dong3",
"葤":"zhou4",
"葥":"qian2",
"葧":"bo2",
"葨":"wei1",
"葩":"pa1",
"葪":"ji4",
"葭":"jia1",
"葮":"duan4",
"葯":"yao4",
"葰":"jun4",
"葲":"quan2",
"葳":"wei1",
"葴":"zhen1",
"葶":"ting2",
"葷":"hun1",
"葸":"xi3",
"葹":"shi1",
"葺":"qi4",
"葻":"lan2",
"葼":"zong1",
"葽":"yao1",
"葾":"yuan1",
"葿":"mei2",
"蒀":"yun1",
"蒁":"shu4",
"蒂":"di4",
"蒃":"zhuan4",
"蒄":"guan1",
"蒆":"xue1",
"蒇":"chan3",
"蒈":"kai3",
"蒉":"kui4",
"蒋":"jiang3",
"蒌":"lou2",
"蒍":"wei2",
"蒎":"pai4",
"蒐":"sou1",
"蒑":"yin1",
"蒒":"shi1",
"蒓":"chun2",
"蒔":"shi4",
"蒕":"yun1",
"蒖":"zhen1",
"蒗":"lang4",
"蒘":"nu2",
"蒚":"he2",
"蒛":"que1",
"蒝":"yuan2",
"蒞":"li4",
"蒟":"ju3",
"蒠":"xi2",
"蒡":"bang4",
"蒢":"chu2",
"蒣":"xu2",
"蒤":"tu2",
"蒥":"liu2",
"蒦":"wo4",
"蒧":"zhen1",
"蒨":"qian4",
"蒩":"zu1",
"蒪":"po4",
"蒫":"cuo1",
"蒬":"yuan1",
"蒭":"chu2",
"蒮":"yu4",
"蒯":"kuai3",
"蒰":"pan2",
"蒱":"pu2",
"蒲":"pu2",
"蒳":"na4",
"蒴":"shuo4",
"蒵":"xi1",
"蒶":"fen2",
"蒷":"yun2",
"蒹":"jian1",
"蒺":"ji2",
"蒻":"ruo4",
"蒽":"en1",
"蒾":"mi2",
"蒿":"hao1",
"蓀":"sun1",
"蓁":"zhen1",
"蓂":"ming2",
"蓃":"huo4",
"蓅":"liu2",
"蓆":"xi2",
"蓇":"gu3",
"蓈":"lang2",
"蓉":"rong2",
"蓊":"weng3",
"蓌":"cuo4",
"蓍":"shi1",
"蓎":"tang2",
"蓏":"luo3",
"蓐":"ru4",
"蓑":"suo1",
"蓒":"xian1",
"蓓":"bei4",
"蓔":"yao3",
"蓕":"gui4",
"蓖":"bi4",
"蓗":"zong3",
"蓘":"gun3",
"蓚":"xiu1",
"蓛":"ce4",
"蓟":"ji4",
"蓠":"li2",
"蓡":"can1",
"蓢":"lang2",
"蓣":"yu4",
"蓥":"ying4",
"蓦":"mo4",
"蓧":"diao4",
"蓨":"tiao1",
"蓩":"mao4",
"蓪":"tong1",
"蓫":"zhu2",
"蓭":"an1",
"蓮":"lian2",
"蓯":"cong1",
"蓰":"xi3",
"蓱":"ping2",
"蓲":"qiu1",
"蓳":"jin4",
"蓴":"chun2",
"蓵":"jie2",
"蓶":"wei3",
"蓷":"tui1",
"蓸":"cao2",
"蓹":"yu3",
"蓺":"yi4",
"蓻":"ji2",
"蓼":"lu4",
"蓽":"bi4",
"蓾":"lu3",
"蓿":"xu5",
"蔀":"bu4",
"蔁":"zhang1",
"蔂":"lei2",
"蔃":"jiang4",
"蔄":"man4",
"蔅":"yan2",
"蔆":"ling2",
"蔇":"ji4",
"蔈":"piao3",
"蔉":"gun3",
"蔊":"han3",
"蔋":"di2",
"蔌":"su4",
"蔍":"lu4",
"蔎":"she4",
"蔏":"shang1",
"蔐":"di2",
"蔒":"xun1",
"蔓":"man2",
"蔔":"bo5",
"蔕":"di4",
"蔖":"cuo2",
"蔘":"sen1",
"蔙":"xuan4",
"蔚":"wei4",
"蔛":"hu2",
"蔜":"ao2",
"蔝":"mi3",
"蔞":"lou2",
"蔟":"cu4",
"蔠":"zhong1",
"蔡":"cai4",
"蔢":"po2",
"蔣":"jiang3",
"蔤":"mi4",
"蔦":"niao3",
"蔧":"hui4",
"蔨":"jun4",
"蔩":"yin2",
"蔪":"jian4",
"蔫":"nian1",
"蔭":"yin4",
"蔮":"kui4",
"蔯":"chen2",
"蔰":"hu4",
"蔱":"sha1",
"蔲":"kou4",
"蔳":"qian4",
"蔴":"ma2",
"蔵":"cang2",
"蔷":"qiang2",
"蔸":"dou1",
"蔹":"lian4",
"蔺":"lin4",
"蔻":"kou4",
"蔾":"li2",
"蔿":"wei2",
"蕀":"ji2",
"蕁":"xun2",
"蕂":"sheng4",
"蕃":"bo1",
"蕄":"meng2",
"蕅":"ou3",
"蕆":"chan3",
"蕇":"dian3",
"蕈":"xun4",
"蕊":"rui3",
"蕋":"rui3",
"蕌":"lei3",
"蕍":"yu2",
"蕎":"qiao2",
"蕏":"chu2",
"蕐":"hua2",
"蕑":"jian1",
"蕒":"mai3",
"蕓":"yun2",
"蕔":"bao1",
"蕕":"you2",
"蕖":"qu2",
"蕗":"lu4",
"蕘":"rao2",
"蕙":"hui4",
"蕚":"e4",
"蕛":"teng2",
"蕜":"fei3",
"蕝":"jue2",
"蕞":"zui4",
"蕟":"fa4",
"蕠":"ru2",
"蕡":"fen2",
"蕢":"kui4",
"蕣":"shun4",
"蕤":"rui2",
"蕥":"ya3",
"蕦":"xu1",
"蕧":"fu4",
"蕨":"jue2",
"蕪":"wu2",
"蕫":"tong2",
"蕬":"si1",
"蕭":"xiao1",
"蕮":"xi4",
"蕯":"long2",
"蕰":"wen1",
"蕲":"qi2",
"蕳":"jian1",
"蕵":"sun1",
"蕶":"ling2",
"蕷":"yu4",
"蕸":"xia2",
"蕹":"weng4",
"蕺":"ji2",
"蕻":"hong2",
"蕼":"si4",
"蕽":"nong2",
"蕾":"lei3",
"蕿":"xuan1",
"薀":"wen1",
"薁":"yu4",
"薂":"xi2",
"薃":"hao4",
"薅":"hao1",
"薆":"ai4",
"薇":"wei1",
"薈":"hui4",
"薉":"wei4",
"薊":"ji4",
"薋":"ci1",
"薌":"xiang1",
"薍":"luan4",
"薎":"mie4",
"薏":"yi4",
"薐":"leng2",
"薑":"jiang1",
"薒":"can4",
"薓":"shen1",
"薔":"qiang2",
"薕":"lian2",
"薖":"ke1",
"薗":"yuan2",
"薘":"da2",
"薙":"ti4",
"薚":"tang2",
"薛":"xue1",
"薜":"bi4",
"薝":"zhan2",
"薞":"sun1",
"薟":"lian3",
"薠":"fan2",
"薡":"ding3",
"薢":"xiao4",
"薣":"gu3",
"薤":"xie4",
"薥":"shu3",
"薦":"jian4",
"薧":"kao3",
"薨":"hong1",
"薫":"xun1",
"薬":"yao4",
"薮":"sou3",
"薰":"xun1",
"薱":"dui4",
"薲":"pin2",
"薳":"wei3",
"薴":"neng2",
"薵":"chou2",
"薶":"mai2",
"薷":"ru2",
"薸":"piao2",
"薹":"tai2",
"薺":"ci2",
"薻":"zao3",
"薼":"chen2",
"薽":"zhen1",
"薾":"er3",
"薿":"ni3",
"藀":"ying2",
"藁":"gao3",
"藂":"cong4",
"藃":"xiao1",
"藄":"qi2",
"藅":"fa2",
"藆":"jian3",
"藇":"xu4",
"藈":"kui1",
"藉":"ji2",
"藊":"bian3",
"藋":"diao4",
"藌":"mi4",
"藎":"jin4",
"藐":"miao3",
"藑":"qiong2",
"藒":"qie4",
"藓":"xian3",
"藕":"ou3",
"藖":"xian2",
"藗":"su4",
"藘":"lv2",
"藙":"yi4",
"藚":"xu4",
"藛":"xie3",
"藜":"li2",
"藞":"la3",
"藟":"lei3",
"藠":"xiao4",
"藡":"di2",
"藢":"zhi3",
"藣":"bei1",
"藦":"mo2",
"藧":"huan3",
"藨":"biao1",
"藩":"fan1",
"藪":"sou3",
"藫":"tan2",
"藬":"tui1",
"藭":"qiong2",
"藮":"qiao2",
"藯":"wei4",
"藰":"liu2",
"藱":"hui4",
"藳":"gao3",
"藴":"yun4",
"藶":"li4",
"藷":"shu3",
"藸":"chu2",
"藺":"lin4",
"藻":"zao3",
"藼":"xuan1",
"藽":"chen4",
"藾":"lai4",
"藿":"huo4",
"蘀":"tuo4",
"蘁":"wu4",
"蘂":"rui3",
"蘃":"rui3",
"蘄":"qi2",
"蘅":"heng2",
"蘈":"tui2",
"蘉":"mang2",
"蘌":"yu3",
"蘍":"xun1",
"蘎":"ji4",
"蘏":"jiong1",
"蘐":"xian1",
"蘓":"su1",
"蘔":"jiong1",
"蘖":"nie4",
"蘗":"nie4",
"蘘":"rang2",
"蘙":"yi4",
"蘚":"xian3",
"蘛":"yu2",
"蘜":"ju2",
"蘝":"lian4",
"蘞":"lian4",
"蘟":"yin3",
"蘠":"qiang2",
"蘡":"ying1",
"蘢":"long2",
"蘣":"tong4",
"蘤":"wei3",
"蘥":"yue4",
"蘦":"ling2",
"蘧":"qu2",
"蘨":"yao2",
"蘩":"fan2",
"蘪":"mi2",
"蘫":"lan2",
"蘬":"kui1",
"蘭":"lan2",
"蘮":"ji4",
"蘯":"dang4",
"蘱":"lei4",
"蘲":"lei2",
"蘳":"hua3",
"蘴":"feng1",
"蘵":"zhi2",
"蘶":"wei4",
"蘷":"kui2",
"蘹":"huai4",
"蘺":"li2",
"蘻":"ji4",
"蘼":"mi2",
"蘽":"lei3",
"蘾":"huai4",
"虀":"ji1",
"虁":"kui2",
"虂":"lu4",
"虃":"jian1",
"虆":"lei2",
"虇":"quan3",
"虈":"xiao1",
"虉":"yi4",
"虊":"luan2",
"虋":"men2",
"虌":"bie1",
"虍":"hu3",
"虐":"nve4",
"虒":"si1",
"虓":"xiao1",
"虔":"qian2",
"虖":"hu1",
"虗":"xu1",
"虘":"cuo2",
"虙":"fu2",
"虝":"hu3",
"虞":"yu2",
"虠":"jiao3",
"虡":"ju4",
"虢":"guo2",
"虣":"bao4",
"虤":"yan2",
"虥":"zhan4",
"虦":"zhan4",
"虨":"ban1",
"虩":"xi4",
"虪":"shu2",
"虬":"qiu2",
"虭":"diao1",
"虮":"ji3",
"虯":"qiu2",
"虰":"cheng2",
"虱":"shi1",
"虳":"di4",
"虴":"zhe2",
"虵":"she2",
"虶":"yu1",
"虷":"gan1",
"虸":"zi3",
"虹":"jiang4",
"虺":"hui1",
"虻":"meng2",
"虼":"ge4",
"虿":"chai4",
"蚃":"xiang4",
"蚄":"fang1",
"蚅":"e4",
"蚆":"pa1",
"蚇":"chi3",
"蚈":"qian1",
"蚉":"wen2",
"蚋":"rui4",
"蚌":"bang4",
"蚍":"bi3",
"蚎":"yue4",
"蚏":"yue4",
"蚐":"jun1",
"蚑":"qi2",
"蚒":"tong2",
"蚔":"qi2",
"蚖":"yuan2",
"蚗":"jue2",
"蚘":"hui2",
"蚙":"qin2",
"蚚":"qi2",
"蚛":"zhong4",
"蚝":"hao2",
"蚞":"mu4",
"蚟":"wang2",
"蚠":"fen2",
"蚡":"fen2",
"蚢":"hang2",
"蚤":"zao3",
"蚥":"fu3",
"蚦":"ran2",
"蚧":"jie4",
"蚨":"fu2",
"蚫":"piao2",
"蚬":"xian3",
"蚭":"ni2",
"蚮":"te4",
"蚰":"you2",
"蚱":"zha4",
"蚲":"ping2",
"蚳":"chi2",
"蚴":"you4",
"蚵":"ke4",
"蚶":"han1",
"蚷":"ju4",
"蚸":"li4",
"蚹":"fu4",
"蚺":"ran2",
"蚻":"zha2",
"蚼":"gou3",
"蚽":"pi2",
"蚾":"bo3",
"蚿":"xian2",
"蛁":"diao1",
"蛂":"bie3",
"蛃":"bing3",
"蛄":"gu1",
"蛅":"ran2",
"蛈":"tie4",
"蛉":"ling2",
"蛊":"gu3",
"蛌":"gu3",
"蛍":"ying2",
"蛎":"li4",
"蛏":"cheng1",
"蛐":"qu1",
"蛑":"mou2",
"蛒":"ge2",
"蛓":"ci4",
"蛔":"hui2",
"蛕":"hui2",
"蛖":"mang2",
"蛗":"fu4",
"蛘":"yang2",
"蛚":"lie4",
"蛜":"yi1",
"蛝":"xian2",
"蛞":"kuo4",
"蛟":"jiao1",
"蛠":"li4",
"蛡":"yi4",
"蛢":"ping2",
"蛣":"qi1",
"蛥":"she2",
"蛦":"yi2",
"蛧":"wang3",
"蛨":"mo4",
"蛩":"qiong2",
"蛪":"qie4",
"蛫":"gui3",
"蛬":"gong3",
"蛭":"zhi4",
"蛮":"man2",
"蛰":"zhe2",
"蛱":"jia2",
"蛲":"rao2",
"蛳":"si1",
"蛴":"qi2",
"蛵":"xing1",
"蛶":"lie4",
"蛷":"qiu2",
"蛸":"xiao1",
"蛹":"yong3",
"蛺":"jia2",
"蛻":"tui4",
"蛼":"che1",
"蛽":"bai4",
"蛿":"han4",
"蜀":"shu3",
"蜁":"xuan2",
"蜃":"shen4",
"蜄":"zhen4",
"蜅":"fu3",
"蜆":"xian3",
"蜇":"zhe1",
"蜉":"fu2",
"蜊":"li2",
"蜋":"lang2",
"蜌":"bi4",
"蜍":"chu2",
"蜎":"yuan1",
"蜏":"you3",
"蜐":"jie2",
"蜑":"dan4",
"蜒":"yan2",
"蜔":"dian4",
"蜕":"tui4",
"蜖":"hui2",
"蜙":"song1",
"蜚":"fei3",
"蜛":"ju1",
"蜝":"qi2",
"蜞":"qi2",
"蜟":"yu4",
"蜠":"jun3",
"蜢":"meng3",
"蜣":"qiang1",
"蜤":"si1",
"蜥":"xi1",
"蜦":"lun2",
"蜧":"li4",
"蜨":"die2",
"蜩":"tiao2",
"蜪":"tao1",
"蜫":"kun1",
"蜬":"gan1",
"蜭":"han4",
"蜮":"yu4",
"蜯":"bang4",
"蜰":"fei2",
"蜱":"pi2",
"蜲":"wei3",
"蜳":"dun1",
"蜴":"yi4",
"蜵":"yuan1",
"蜶":"su4",
"蜷":"quan2",
"蜸":"qian3",
"蜹":"rui4",
"蜺":"ni2",
"蜼":"wei4",
"蜽":"liang3",
"蜾":"guo3",
"蜿":"wan1",
"蝀":"dong1",
"蝁":"e4",
"蝂":"ban3",
"蝃":"di4",
"蝄":"wang3",
"蝅":"can2",
"蝆":"yang3",
"蝈":"guo1",
"蝋":"la4",
"蝍":"jie2",
"蝎":"xie1",
"蝏":"ting2",
"蝐":"mai4",
"蝑":"xu1",
"蝒":"mian2",
"蝓":"yu2",
"蝔":"jie1",
"蝖":"xuan1",
"蝘":"yan3",
"蝚":"rou2",
"蝛":"wei1",
"蝜":"fu4",
"蝝":"yuan2",
"蝞":"mei4",
"蝡":"ruan3",
"蝢":"xie2",
"蝣":"you2",
"蝤":"qiu2",
"蝥":"mao2",
"蝧":"ying1",
"蝨":"shi1",
"蝩":"chong2",
"蝪":"tang1",
"蝫":"zhu1",
"蝬":"zong1",
"蝭":"ti2",
"蝮":"fu4",
"蝯":"yuan2",
"蝰":"hui3",
"蝱":"meng2",
"蝲":"la4",
"蝳":"du2",
"蝵":"qiu1",
"蝷":"li4",
"蝹":"yun1",
"蝺":"ju3",
"蝻":"nan3",
"蝼":"lou2",
"蝽":"chun1",
"蝾":"rong2",
"蝿":"ying2",
"螀":"jiang1",
"螂":"lang2",
"螃":"pang2",
"螄":"si1",
"螅":"xi1",
"螆":"ci4",
"螇":"xi1",
"螈":"yuan2",
"螉":"weng1",
"螊":"lian2",
"螋":"sou1",
"螌":"ban1",
"螎":"rong2",
"螏":"ji2",
"螐":"wu1",
"螑":"qiu4",
"螒":"han4",
"螓":"qin2",
"螔":"yi2",
"螕":"bi1",
"螖":"hua2",
"螗":"tang2",
"螘":"yi3",
"螙":"du4",
"螚":"nai4",
"螛":"he2",
"螜":"hu2",
"螝":"hui4",
"螟":"ming2",
"螠":"yi4",
"螡":"wen2",
"螣":"teng2",
"螤":"yu3",
"螥":"cang1",
"螨":"man3",
"螪":"shang1",
"螫":"shi4",
"螬":"cao2",
"螭":"chi1",
"螮":"di4",
"螯":"ao2",
"螰":"lu4",
"螱":"wei4",
"螲":"zhi4",
"螳":"tang2",
"螴":"chen2",
"螵":"piao1",
"螶":"qu2",
"螷":"pi2",
"螸":"yu2",
"螹":"jian4",
"螺":"luo2",
"螻":"lou2",
"螼":"qin3",
"螽":"zhong1",
"螾":"yin3",
"螿":"jiang1",
"蟁":"wen2",
"蟂":"jiao1",
"蟃":"wan4",
"蟄":"zhe2",
"蟅":"zhe4",
"蟇":"ma2",
"蟈":"guo1",
"蟉":"liu2",
"蟊":"mao2",
"蟌":"cong1",
"蟍":"li2",
"蟎":"man3",
"蟏":"xiao1",
"蟑":"zhang1",
"蟒":"mang3",
"蟓":"xiang4",
"蟔":"mo4",
"蟕":"zui1",
"蟖":"si1",
"蟗":"qiu1",
"蟘":"te4",
"蟙":"zhi2",
"蟚":"peng2",
"蟛":"peng2",
"蟜":"jiao3",
"蟝":"qu2",
"蟞":"bie2",
"蟟":"liao2",
"蟠":"pan2",
"蟡":"gui3",
"蟢":"xi3",
"蟣":"ji3",
"蟤":"zhuan1",
"蟥":"huang2",
"蟦":"fei4",
"蟧":"lao2",
"蟨":"jue2",
"蟩":"jue2",
"蟪":"hui4",
"蟫":"yin2",
"蟭":"jiao1",
"蟮":"shan4",
"蟯":"rao2",
"蟰":"xiao1",
"蟱":"mou2",
"蟲":"chong2",
"蟳":"xun2",
"蟴":"si1",
"蟶":"cheng1",
"蟷":"dang1",
"蟸":"li3",
"蟹":"xie4",
"蟺":"shan4",
"蟼":"jing3",
"蟽":"da2",
"蟾":"chan2",
"蟿":"qi4",
"蠀":"ci1",
"蠁":"xiang4",
"蠂":"she4",
"蠃":"luo3",
"蠄":"qin2",
"蠆":"chai4",
"蠇":"li4",
"蠈":"ze2",
"蠉":"xuan1",
"蠊":"lian2",
"蠋":"zhu2",
"蠌":"ze2",
"蠍":"xie1",
"蠎":"mang3",
"蠏":"xie4",
"蠐":"qi2",
"蠑":"rong2",
"蠒":"jian3",
"蠓":"meng3",
"蠔":"hao2",
"蠖":"huo4",
"蠗":"zhuo2",
"蠘":"jie2",
"蠙":"bin1",
"蠚":"he4",
"蠛":"mie4",
"蠜":"fan2",
"蠝":"lei2",
"蠞":"jie2",
"蠠":"mi4",
"蠡":"li2",
"蠢":"chun3",
"蠣":"li4",
"蠤":"qiu1",
"蠥":"nie4",
"蠦":"lu2",
"蠧":"du4",
"蠨":"xiao1",
"蠩":"zhu1",
"蠪":"long2",
"蠫":"li4",
"蠬":"long2",
"蠭":"feng1",
"蠮":"ye1",
"蠯":"beng4",
"蠰":"rang3",
"蠱":"gu3",
"蠲":"juan1",
"蠳":"ying1",
"蠵":"xi1",
"蠷":"qu2",
"蠸":"quan2",
"蠹":"du4",
"蠺":"can2",
"蠻":"man2",
"蠼":"qu2",
"蠽":"jie2",
"蠾":"zhu2",
"蠿":"zha2",
"衁":"huang1",
"衂":"niu4",
"衃":"pei1",
"衄":"nv4",
"衆":"zhong4",
"衇":"mo4",
"衈":"er4",
"衉":"ke4",
"衊":"mie4",
"衋":"xi4",
"衎":"kan4",
"衏":"yuan4",
"衑":"ling2",
"衒":"xuan4",
"術":"shu4",
"衕":"tong4",
"衖":"long4",
"衘":"xian2",
"衚":"hu2",
"衜":"dao4",
"衝":"chong1",
"衞":"wei4",
"衟":"dao4",
"衠":"zhun1",
"衢":"qu2",
"衦":"gan3",
"衧":"yu2",
"衩":"cha3",
"衪":"yi3",
"衭":"fu1",
"衮":"gun3",
"衯":"fen1",
"衱":"jie2",
"衲":"na4",
"衳":"zhong1",
"衴":"dan3",
"衵":"ni4",
"衶":"zhong4",
"衷":"zhong1",
"衸":"xie4",
"衹":"zhi3",
"衺":"xie2",
"衻":"ran2",
"衼":"zhi1",
"衽":"ren4",
"衾":"qin1",
"衿":"jin1",
"袀":"jun1",
"袁":"yuan2",
"袂":"mei4",
"袃":"chai4",
"袅":"niao3",
"袆":"hui1",
"袇":"ran2",
"袈":"jia1",
"袉":"tuo2",
"袊":"ling3",
"袌":"bao4",
"袎":"yao4",
"袏":"zuo4",
"袐":"bi4",
"袑":"shao4",
"袒":"tan3",
"袓":"ju3",
"袔":"he4",
"袕":"shu4",
"袗":"zhen3",
"袘":"yi2",
"袙":"pa4",
"袚":"fu2",
"袛":"di1",
"袝":"fu4",
"袞":"gun3",
"袟":"zhi4",
"袠":"zhi4",
"袡":"ran2",
"袢":"pan4",
"袣":"yi4",
"袤":"mao4",
"袦":"na4",
"袧":"kou1",
"袨":"xian4",
"袩":"chan1",
"袪":"qu1",
"袬":"gun3",
"袮":"xiao2",
"袯":"bo2",
"袲":"yi2",
"袳":"chi3",
"袴":"ku4",
"袵":"ren4",
"袶":"jiang4",
"袷":"jia2",
"袸":"cun2",
"袹":"mo4",
"袺":"jie2",
"袻":"er2",
"袼":"ge1",
"袽":"ru2",
"袾":"zhu1",
"袿":"gui1",
"裀":"yin1",
"裆":"dang1",
"裈":"kun1",
"裉":"ken4",
"裊":"niao3",
"裋":"shu4",
"裌":"jia2",
"裍":"kun3",
"裎":"cheng2",
"裏":"li3",
"裐":"juan1",
"裑":"shen1",
"裒":"pou2",
"裓":"ge2",
"裔":"yi4",
"裖":"zhen3",
"裗":"liu2",
"裘":"qiu2",
"裚":"ji4",
"裛":"yi4",
"裞":"shui4",
"裟":"sha1",
"裠":"qun2",
"裢":"lian2",
"裣":"lian4",
"裥":"jian3",
"裦":"fou2",
"裧":"chan1",
"裨":"pi2",
"裩":"gun1",
"裪":"tao2",
"裫":"yuan4",
"裬":"ling2",
"裭":"chi3",
"裮":"chang1",
"裯":"chou2",
"裰":"duo2",
"裱":"biao3",
"裲":"liang3",
"裴":"pei2",
"裵":"pei2",
"裶":"fei1",
"裷":"yuan1",
"裸":"luo3",
"裺":"yan3",
"裻":"du3",
"裼":"xi2",
"製":"zhi4",
"裾":"ju1",
"裿":"qi3",
"褀":"ji4",
"褁":"zhi2",
"褃":"ken4",
"褅":"ti4",
"褆":"ti2",
"褈":"chong2",
"褉":"xie1",
"褊":"bian3",
"褋":"die2",
"褌":"kun1",
"褍":"duan1",
"褎":"xiu4",
"褏":"xiu4",
"褑":"yuan4",
"褒":"bao1",
"褓":"bao3",
"褔":"fu4",
"褕":"yu2",
"褖":"tuan4",
"褗":"yan3",
"褘":"hui1",
"褙":"bei4",
"褚":"chu3",
"褛":"lv3",
"褞":"yun3",
"褟":"ta1",
"褠":"gou1",
"褡":"da1",
"褢":"huai2",
"褣":"rong2",
"褤":"yuan4",
"褥":"ru4",
"褦":"nai4",
"褧":"jiong3",
"褨":"suo3",
"褩":"ban1",
"褪":"tun4",
"褫":"chi3",
"褬":"sang3",
"褭":"niao3",
"褮":"ying1",
"褯":"jie4",
"褰":"qian1",
"褱":"huai2",
"褳":"lian2",
"褴":"lan2",
"褵":"li2",
"褶":"zhe3",
"褷":"shi1",
"褸":"lv3",
"褹":"yi4",
"褺":"die2",
"褻":"xie4",
"褼":"xian1",
"褽":"wei4",
"褾":"biao3",
"褿":"cao2",
"襀":"ji1",
"襁":"qiang3",
"襂":"sen1",
"襃":"bao1",
"襄":"xiang1",
"襆":"pu2",
"襇":"jian3",
"襈":"zhuan4",
"襉":"jian3",
"襊":"zui4",
"襋":"ji2",
"襌":"dan1",
"襍":"za2",
"襎":"fan2",
"襏":"bo2",
"襐":"xiang4",
"襑":"xin2",
"襒":"bie2",
"襓":"rao2",
"襔":"man3",
"襕":"lan2",
"襗":"duo2",
"襘":"gui4",
"襙":"cao4",
"襚":"sui4",
"襛":"nong2",
"襜":"chan1",
"襝":"lian4",
"襞":"bi4",
"襠":"dang1",
"襡":"shu2",
"襢":"tan3",
"襣":"bi4",
"襤":"lan2",
"襥":"pu2",
"襦":"ru2",
"襧":"zhi3",
"襩":"shu3",
"襫":"shi4",
"襬":"bai3",
"襭":"xie2",
"襮":"bo2",
"襰":"lai4",
"襱":"long2",
"襳":"xian1",
"襴":"lan2",
"襵":"zhe2",
"襶":"dai4",
"襸":"zan4",
"襹":"shi1",
"襺":"jian3",
"襻":"pan4",
"襼":"yi4",
"襾":"ya4",
"覀":"xi1",
"覂":"feng3",
"覃":"tan2",
"覅":"biao4",
"覇":"ba4",
"覈":"he2",
"覉":"ji1",
"覊":"ji1",
"覌":"guan1",
"覍":"bian4",
"覎":"yan4",
"覐":"jue2",
"覑":"pian3",
"覒":"mao2",
"覓":"mi4",
"覔":"mi4",
"覕":"mie4",
"覗":"si1",
"覘":"chan1",
"覙":"luo2",
"覚":"jue2",
"覛":"mi4",
"覜":"tiao4",
"覝":"lian2",
"覞":"yao4",
"覟":"zhi4",
"覠":"jun1",
"覡":"xi2",
"覢":"shan3",
"覣":"wei1",
"覤":"xi4",
"覥":"tian3",
"覦":"yu2",
"覧":"lan3",
"覨":"e4",
"覩":"du3",
"覫":"pang3",
"覬":"ji4",
"覭":"ming2",
"覮":"ying2",
"覯":"gou4",
"覰":"qu4",
"覱":"zhan4",
"覲":"jin4",
"観":"guan1",
"覴":"deng1",
"覵":"jian4",
"覶":"luo2",
"覷":"qu4",
"覸":"jian4",
"覹":"wei2",
"覻":"qu4",
"覼":"luo2",
"覾":"shen3",
"覿":"di2",
"觃":"yan4",
"觅":"mi4",
"觇":"chan1",
"觊":"ji4",
"觋":"xi2",
"觌":"di2",
"觍":"tian3",
"觎":"yu2",
"觏":"gou4",
"觐":"jin4",
"觑":"qu4",
"觓":"jiu1",
"觔":"jin1",
"觕":"cu1",
"觖":"jue2",
"觗":"zhi4",
"觘":"chao4",
"觙":"ji2",
"觚":"gu1",
"觛":"dan4",
"觜":"zui3",
"觝":"di3",
"觞":"shang1",
"觟":"hua4",
"觠":"quan2",
"觡":"ge2",
"觢":"chi4",
"觤":"gui3",
"觥":"gong1",
"觧":"jie3",
"觨":"hun4",
"觩":"qiu2",
"觪":"xing1",
"觫":"su4",
"觬":"ni2",
"觭":"ji1",
"觮":"lu4",
"觯":"zhi4",
"觰":"zha1",
"觱":"bi4",
"觲":"xing1",
"觳":"hu2",
"觴":"shang1",
"觵":"gong1",
"觶":"zhi4",
"觷":"xue2",
"觹":"xi1",
"觺":"yi2",
"觻":"lu4",
"觼":"jue2",
"觽":"xi1",
"觾":"yan4",
"觿":"xi1",
"訃":"fu4",
"訄":"qiu2",
"訅":"qiu2",
"訆":"jiao4",
"訇":"hong1",
"訉":"fan4",
"訋":"diao4",
"訌":"hong2",
"訍":"cha4",
"訏":"xu1",
"訐":"jie2",
"訑":"yi2",
"訒":"ren4",
"訔":"yin2",
"訕":"shan4",
"訖":"qi4",
"託":"tuo1",
"訙":"xun4",
"訚":"yin2",
"訛":"e2",
"訜":"fen1",
"訞":"yao1",
"訠":"shen3",
"訡":"yin2",
"訢":"xin1",
"訣":"jue2",
"訤":"xiao2",
"訥":"ne4",
"訦":"chen2",
"訧":"you2",
"訨":"zhi3",
"訩":"xiong1",
"訫":"xin4",
"訬":"chao1",
"訮":"xian1",
"訯":"sha3",
"訰":"tun2",
"訲":"yi4",
"訳":"yi4",
"訵":"chi1",
"訶":"he1",
"訷":"shen1",
"訸":"he2",
"訹":"xu4",
"註":"zhu4",
"訽":"gou4",
"訾":"zi3",
"訿":"zi3",
"詀":"zhan1",
"詁":"gu3",
"詂":"fu4",
"詃":"quan3",
"詄":"die2",
"詅":"ling2",
"詆":"di3",
"詇":"yang4",
"詈":"li4",
"詉":"nao2",
"詊":"pan4",
"詋":"zhou4",
"詌":"gan4",
"詍":"yi4",
"詎":"ju4",
"詏":"ao4",
"詐":"zha4",
"詑":"tuo2",
"詒":"yi2",
"詓":"qu3",
"詔":"zhao4",
"詖":"bi4",
"詗":"xiong4",
"詘":"qu1",
"詙":"ba2",
"詚":"da2",
"詛":"zu3",
"詜":"tao1",
"詝":"zhu3",
"詟":"zhe2",
"詠":"yong3",
"詡":"xu3",
"詣":"yi4",
"詤":"huang3",
"詥":"he2",
"詧":"cha2",
"詨":"jiao1",
"詪":"hen3",
"詬":"gou4",
"詮":"quan2",
"詯":"hui4",
"詰":"jie2",
"詴":"wei1",
"詵":"shen1",
"詶":"chou2",
"詷":"tong2",
"詸":"mi2",
"詹":"zhan1",
"詺":"ming4",
"詻":"e4",
"詼":"hui1",
"詽":"yan2",
"詾":"xiong1",
"詿":"gua4",
"誀":"er4",
"誁":"beng3",
"誂":"tiao3",
"誃":"chi3",
"誄":"lei3",
"誅":"zhu1",
"誆":"kuang1",
"誇":"kua1",
"誈":"wu2",
"誊":"teng2",
"誋":"ji4",
"誌":"zhi4",
"誎":"su4",
"誏":"lang3",
"誐":"e2",
"誑":"kuang2",
"誔":"ting3",
"誖":"bo2",
"誗":"chan2",
"誙":"keng1",
"誚":"qiao4",
"誛":"qin1",
"誜":"shua4",
"誝":"an1",
"誟":"xiao4",
"誢":"xian4",
"誥":"gao4",
"誧":"pu3",
"誨":"hui4",
"誩":"jing4",
"誫":"zhen4",
"説":"shuo1",
"読":"du2",
"誯":"chang4",
"誱":"jie2",
"誳":"qu1",
"誴":"cong2",
"誵":"xiao2",
"誶":"sui4",
"誷":"wang3",
"誸":"xuan2",
"誹":"fei3",
"誺":"chi1",
"誻":"ta4",
"誽":"na2",
"誾":"yin2",
"諀":"pi3",
"諁":"chuo4",
"諂":"chan3",
"諃":"chen1",
"諄":"zhun1",
"諅":"ji1",
"諆":"qi1",
"諈":"zhui4",
"諉":"wei3",
"諊":"ju2",
"諌":"jian4",
"諍":"zheng4",
"諎":"ze2",
"諏":"zou1",
"諐":"qian1",
"諑":"zhuo2",
"諓":"jian4",
"諔":"zhu4",
"諕":"hao2",
"諗":"shen3",
"諘":"biao3",
"諙":"huai4",
"諚":"pian2",
"諛":"yu2",
"諜":"die2",
"諝":"xu3",
"諞":"pian3",
"諟":"shi4",
"諠":"xuan1",
"諡":"shi4",
"諢":"hun4",
"諣":"hua4",
"諤":"e4",
"諥":"zhong4",
"諦":"di4",
"諧":"xie2",
"諨":"fu2",
"諩":"pu3",
"諪":"ting2",
"諫":"jian4",
"諬":"qi3",
"諭":"yu4",
"諮":"zi1",
"諯":"chuan2",
"諰":"xi3",
"諱":"hui4",
"諲":"yin1",
"諳":"an1",
"諴":"xian2",
"諵":"nan2",
"諶":"chen2",
"諹":"yang2",
"諺":"yan4",
"諻":"heng1",
"諼":"xuan1",
"諽":"ge2",
"諾":"nuo4",
"諿":"qi4",
"謁":"ye4",
"謄":"teng2",
"謅":"zhou1",
"謆":"shan4",
"謇":"jian3",
"謈":"bo2",
"謋":"huo4",
"謌":"ge1",
"謍":"ying2",
"謎":"mi2",
"謏":"xiao3",
"謐":"mi4",
"謑":"xi4",
"謒":"qiang1",
"謓":"chen1",
"謔":"xue4",
"謕":"ti2",
"謖":"su4",
"謗":"bang4",
"謘":"chi2",
"謚":"shi4",
"謜":"yuan4",
"謞":"xue4",
"謟":"tao1",
"謡":"yao2",
"謣":"yu2",
"謤":"biao1",
"謥":"cong4",
"謦":"qing3",
"謧":"li2",
"謨":"mo2",
"謩":"mo4",
"謪":"shang1",
"謫":"zhe2",
"謭":"jian3",
"謮":"ze2",
"謯":"jie1",
"謰":"lian2",
"謱":"lou2",
"謲":"can1",
"謳":"ou1",
"謴":"guan4",
"謵":"xi2",
"謶":"zhuo2",
"謷":"ao2",
"謸":"ao2",
"謺":"zhe2",
"謻":"yi2",
"謼":"hu1",
"謽":"jiang4",
"謾":"man4",
"謿":"chao2",
"譀":"han4",
"譁":"hua2",
"譂":"chan3",
"譃":"xu1",
"譄":"zeng1",
"譅":"se4",
"譆":"xi1",
"譇":"she1",
"譈":"dui4",
"證":"zheng4",
"譊":"nao2",
"譋":"lan2",
"譌":"e2",
"譍":"ying4",
"譎":"jue2",
"譐":"zun3",
"譑":"jiao3",
"譒":"bo4",
"譓":"hui4",
"譔":"zhuan4",
"譕":"mu2",
"譖":"zen4",
"譗":"zha2",
"譙":"qiao2",
"譚":"tan2",
"譛":"zen4",
"譜":"pu3",
"譝":"sheng2",
"譞":"xuan1",
"譟":"zao4",
"譠":"tan1",
"譡":"dang3",
"譢":"sui4",
"譣":"qian1",
"譤":"ji1",
"譥":"jiao4",
"譧":"lian2",
"譨":"nou2",
"譩":"yi1",
"譪":"ai4",
"譫":"zhan1",
"譭":"hui3",
"譮":"hua4",
"譱":"shan4",
"譲":"rang4",
"譳":"nou4",
"譵":"zhui4",
"譶":"ta4",
"譸":"zhou1",
"譹":"hao2",
"譺":"ye4",
"譻":"ying1",
"譼":"jian4",
"譾":"jian3",
"譿":"hui4",
"讁":"zhe2",
"讂":"xuan4",
"讃":"zan4",
"讄":"lei3",
"讅":"shen3",
"讆":"wei4",
"讇":"chan3",
"讈":"li4",
"讉":"yi2",
"讋":"zhe2",
"讌":"yan4",
"讍":"e4",
"讎":"chou2",
"讏":"wei4",
"讐":"chou2",
"讑":"yao4",
"讒":"chan2",
"讔":"yin3",
"讕":"lan2",
"讖":"chen4",
"讗":"huo4",
"讘":"zhe2",
"讙":"huan1",
"讚":"zan4",
"讛":"yi4",
"讜":"dang3",
"讝":"zhan1",
"讞":"yan4",
"讟":"du2",
"讠":"yan2",
"讣":"fu4",
"讦":"jie2",
"讧":"hong2",
"讪":"shan4",
"讫":"qi4",
"讬":"tuo1",
"讱":"ren4",
"讳":"hui4",
"讴":"ou1",
"讵":"ju4",
"讷":"ne4",
"讹":"e2",
"讻":"xiong1",
"诀":"jue2",
"诂":"gu3",
"诃":"he1",
"诅":"zu3",
"诇":"xiong4",
"诈":"zha4",
"诋":"di3",
"诌":"zhou1",
"诎":"qu1",
"诏":"zhao4",
"诐":"bi4",
"诒":"yi2",
"诓":"kuang1",
"诔":"lei3",
"诖":"gua4",
"诘":"jie2",
"诙":"hui1",
"诛":"zhu1",
"诜":"shen1",
"诟":"gou4",
"诠":"quan2",
"诣":"yi4",
"诤":"zheng4",
"诨":"hun4",
"诩":"xu3",
"诪":"zhou1",
"诮":"qiao4",
"诰":"gao4",
"诲":"hui4",
"诳":"kuang2",
"诹":"zou1",
"诺":"nuo4",
"诼":"zhuo2",
"诽":"fei3",
"诿":"wei3",
"谀":"yu2",
"谂":"shen3",
"谄":"chan3",
"谆":"zhun1",
"谇":"sui4",
"谉":"shen3",
"谌":"chen2",
"谍":"die2",
"谏":"jian4",
"谐":"xie2",
"谑":"xue4",
"谒":"ye4",
"谔":"e4",
"谕":"yu4",
"谖":"xuan1",
"谗":"chan2",
"谘":"zi1",
"谙":"an1",
"谚":"yan4",
"谛":"di4",
"谜":"mi2",
"谝":"pian3",
"谞":"xu3",
"谟":"mo2",
"谠":"dang3",
"谡":"su4",
"谤":"bang4",
"谥":"shi4",
"谧":"mi4",
"谩":"man4",
"谪":"zhe2",
"谫":"jian3",
"谭":"tan2",
"谮":"zen4",
"谯":"qiao2",
"谰":"lan2",
"谱":"pu3",
"谲":"jue2",
"谳":"yan4",
"谵":"zhan1",
"谶":"chen4",
"谸":"qian1",
"谹":"hong2",
"谺":"xia1",
"谻":"jue2",
"谼":"hong2",
"谽":"han2",
"谾":"hong1",
"谿":"xi1",
"豀":"xi1",
"豂":"liao2",
"豃":"han3",
"豄":"du2",
"豅":"long2",
"豇":"jiang1",
"豉":"chi3",
"豊":"li3",
"豋":"deng1",
"豍":"bi1",
"豏":"xian4",
"豐":"feng1",
"豑":"zhi4",
"豒":"zhi4",
"豓":"yan4",
"豔":"yan4",
"豕":"shi3",
"豖":"chu4",
"豗":"hui1",
"豘":"tun2",
"豙":"yi4",
"豚":"tun2",
"豛":"yi4",
"豜":"jian1",
"豝":"ba1",
"豞":"hou4",
"豟":"e4",
"豠":"cu2",
"豢":"huan4",
"豣":"jian1",
"豤":"ken3",
"豥":"gai1",
"豦":"ju4",
"豧":"fu1",
"豨":"xi1",
"豩":"bin1",
"豭":"jia1",
"豮":"fen2",
"豯":"xi1",
"豰":"bo2",
"豱":"wen1",
"豲":"huan2",
"豳":"bin1",
"豴":"di2",
"豵":"zong1",
"豶":"fen2",
"豷":"yi4",
"豸":"zhi4",
"豻":"an4",
"豼":"pi2",
"豽":"na4",
"豾":"pi1",
"豿":"gou3",
"貀":"na4",
"貁":"you4",
"貂":"diao1",
"貃":"mo4",
"貄":"si4",
"貅":"xiu1",
"貆":"huan2",
"貇":"kun1",
"貈":"he2",
"貉":"he2",
"貊":"mo4",
"貋":"han4",
"貍":"li2",
"貎":"ni2",
"貏":"bi3",
"貐":"yu3",
"貑":"jia1",
"貒":"tuan1",
"貔":"pi2",
"貕":"xi1",
"貖":"e4",
"貗":"ju4",
"貘":"mo4",
"貙":"chu1",
"貚":"tan2",
"貛":"huan1",
"貜":"jue2",
"貞":"zhen1",
"貟":"yuan2",
"貣":"te4",
"貤":"yi2",
"貥":"hang2",
"貦":"wan4",
"貭":"zhi2",
"貮":"er4",
"貯":"zhu4",
"貰":"shi4",
"貱":"bi4",
"貲":"zi1",
"貳":"er4",
"貵":"pian3",
"貶":"bian3",
"貸":"dai4",
"貹":"sheng4",
"貺":"kuang4",
"貽":"yi2",
"貾":"chi2",
"賁":"ben1",
"賂":"lu4",
"賃":"lin4",
"賄":"hui4",
"賅":"gai1",
"賆":"pian2",
"賈":"gu3",
"賉":"xu4",
"賋":"jiao3",
"賌":"gai4",
"賍":"zang1",
"賎":"jian4",
"賏":"ying4",
"賐":"xun4",
"賑":"zhen4",
"賒":"she1",
"賔":"bin1",
"賕":"qiu2",
"賖":"she1",
"賗":"chuan4",
"賘":"zang1",
"賙":"zhou1",
"賚":"lai4",
"賛":"zan4",
"賜":"ci4",
"賝":"chen1",
"賟":"tian3",
"賡":"geng1",
"賢":"xian2",
"賥":"sui4",
"賦":"fu4",
"賧":"dan3",
"賨":"cong2",
"賩":"cong2",
"賫":"ji1",
"賬":"zhang4",
"賮":"jin4",
"賯":"xiong1",
"賰":"shun3",
"賱":"yun3",
"賲":"bao3",
"賳":"zai1",
"賵":"feng4",
"賶":"cang4",
"賷":"ji1",
"賸":"sheng4",
"賹":"ai4",
"賻":"fu4",
"賾":"ze2",
"賿":"liao2",
"贀":"wei4",
"贁":"bai4",
"贂":"chen3",
"贃":"zhuan4",
"贄":"zhi4",
"贅":"zhui4",
"贆":"biao1",
"贇":"yun1",
"贈":"zeng4",
"贉":"tan3",
"贋":"yan4",
"贍":"shan4",
"贎":"wan4",
"贏":"ying2",
"贐":"jin4",
"贑":"gan3",
"贒":"xian2",
"贓":"zang1",
"贔":"bi4",
"贕":"du2",
"贖":"shu2",
"贗":"yan4",
"贙":"xuan4",
"贚":"long4",
"贛":"gan4",
"贜":"zang1",
"贞":"zhen1",
"贠":"yuan2",
"贤":"xian2",
"账":"zhang4",
"贬":"bian3",
"贮":"zhu4",
"贰":"er4",
"贲":"ben1",
"贳":"shi4",
"贶":"kuang4",
"贷":"dai4",
"贻":"yi2",
"贽":"zhi4",
"贾":"gu3",
"贿":"hui4",
"赀":"zi1",
"赁":"lin4",
"赂":"lu4",
"赃":"zang1",
"赅":"gai1",
"赆":"jin4",
"赇":"qiu2",
"赈":"zhen4",
"赉":"lai4",
"赊":"she1",
"赋":"fu4",
"赍":"ji1",
"赎":"shu2",
"赐":"ci4",
"赑":"bi4",
"赒":"zhou1",
"赓":"geng1",
"赕":"dan3",
"赗":"feng4",
"赘":"zhui4",
"赙":"fu4",
"赜":"ze2",
"赝":"yan4",
"赟":"yun1",
"赠":"zeng4",
"赡":"shan4",
"赢":"ying2",
"赣":"gan4",
"赥":"xi4",
"赦":"she4",
"赧":"nan3",
"赨":"xiong2",
"赩":"xi4",
"赪":"cheng1",
"赫":"he4",
"赬":"cheng1",
"赭":"zhe3",
"赮":"xia2",
"赯":"tang2",
"赱":"zou3",
"赲":"li4",
"赳":"jiu3",
"赵":"zhao4",
"赸":"shan4",
"赹":"qiong2",
"赺":"qin2",
"赻":"xian3",
"赼":"ci1",
"赽":"jue2",
"赾":"qin3",
"赿":"chi2",
"趀":"ci1",
"趂":"chen4",
"趃":"die2",
"趄":"qie4",
"趆":"di1",
"趇":"se4",
"趈":"zhan1",
"趉":"zhu2",
"趌":"jie2",
"趍":"chi2",
"趎":"chu2",
"趏":"gua1",
"趐":"xue4",
"趑":"zi1",
"趒":"tiao2",
"趓":"duo3",
"趔":"lie4",
"趖":"suo1",
"趗":"cu4",
"趘":"xi2",
"趙":"zhao4",
"趚":"su4",
"趛":"yin3",
"趜":"ju2",
"趝":"jian4",
"趞":"que4",
"趠":"chuo4",
"趡":"cui3",
"趢":"lu4",
"趤":"dang4",
"趥":"qiu1",
"趦":"zi1",
"趧":"ti2",
"趩":"chi4",
"趪":"huang2",
"趫":"qiao2",
"趬":"qiao2",
"趭":"yao4",
"趮":"zao4",
"趯":"yue4",
"趱":"zan3",
"趲":"zan3",
"趵":"bo1",
"趶":"ku4",
"趷":"ke1",
"趸":"dun3",
"趹":"jue2",
"趺":"fu1",
"趻":"chen3",
"趼":"jian3",
"趽":"fang4",
"趾":"zhi3",
"趿":"sa4",
"跀":"yue4",
"跁":"pa2",
"跂":"qi2",
"跄":"qiang4",
"跅":"tuo4",
"跆":"tai2",
"跇":"yi4",
"跈":"nian3",
"跉":"ling2",
"跊":"mei4",
"跋":"ba2",
"跍":"ku1",
"跎":"tuo2",
"跏":"jia1",
"跐":"cai3",
"跒":"qia3",
"跓":"zhu4",
"跔":"ju1",
"跕":"dian3",
"跖":"zhi2",
"跗":"fu1",
"跘":"pan2",
"跙":"ju3",
"跚":"shan1",
"跜":"ni2",
"跞":"luo4",
"跠":"yi2",
"跢":"dai4",
"跣":"xian3",
"跤":"jiao1",
"跥":"duo4",
"跦":"zhu1",
"跧":"quan2",
"跩":"zhuai3",
"跫":"qiong2",
"跬":"kui3",
"跭":"xiang2",
"跮":"chi4",
"跰":"beng4",
"跱":"zhi4",
"跲":"jia2",
"跴":"cai3",
"跶":"da2",
"跷":"qiao1",
"跸":"bi4",
"跹":"xian1",
"跻":"ji1",
"跼":"ju2",
"跽":"ji4",
"跾":"shu2",
"跿":"tu2",
"踀":"chu4",
"踁":"jing4",
"踂":"nie4",
"踃":"xiao1",
"踄":"bo2",
"踅":"xue2",
"踆":"qun1",
"踇":"mou3",
"踈":"shu1",
"踉":"lang2",
"踊":"yong3",
"踋":"jiao3",
"踍":"qiao1",
"踑":"qi2",
"踒":"wo1",
"踓":"wei3",
"踔":"chuo1",
"踕":"jie2",
"踖":"ji2",
"踗":"nie1",
"踘":"ju2",
"踙":"ju1",
"踚":"lun2",
"踛":"lu4",
"踜":"leng4",
"踝":"huai2",
"踞":"ju4",
"踟":"chi2",
"踠":"wan3",
"踡":"quan2",
"踣":"bo2",
"踤":"cu4",
"踥":"qie4",
"踦":"qi2",
"踧":"cu4",
"踨":"zong1",
"踫":"peng4",
"踬":"zhi4",
"踭":"zheng1",
"踯":"zhi2",
"踰":"yu2",
"踲":"dun4",
"踳":"chun3",
"踴":"yong3",
"踵":"zhong3",
"踶":"di4",
"踷":"zhe3",
"踸":"chen3",
"踹":"chuai4",
"踺":"jian4",
"踻":"gua1",
"踼":"tang2",
"踽":"ju3",
"踾":"fu2",
"踿":"zu2",
"蹀":"die2",
"蹁":"pian2",
"蹂":"rou2",
"蹃":"nuo4",
"蹅":"cha3",
"蹆":"tui3",
"蹇":"jian3",
"蹉":"cuo1",
"蹊":"xi1",
"蹌":"qiang4",
"蹍":"zhan3",
"蹎":"dian1",
"蹏":"ti2",
"蹐":"ji2",
"蹑":"nie4",
"蹒":"pan2",
"蹓":"liu4",
"蹔":"zhan4",
"蹕":"bi4",
"蹖":"chong1",
"蹗":"lu4",
"蹘":"liao2",
"蹙":"cu4",
"蹚":"tang1",
"蹛":"dai4",
"蹜":"suo1",
"蹝":"xi3",
"蹞":"kui3",
"蹟":"ji1",
"蹠":"zhi2",
"蹡":"qiang1",
"蹢":"di2",
"蹣":"pan2",
"蹥":"lian2",
"蹧":"zao1",
"蹨":"nian3",
"蹩":"bie2",
"蹪":"tui2",
"蹫":"ju2",
"蹮":"xian1",
"蹯":"fan2",
"蹰":"chu2",
"蹱":"zhong1",
"蹳":"bo1",
"蹴":"cu4",
"蹵":"zu2",
"蹶":"jue2",
"蹷":"jue2",
"蹸":"lin4",
"蹹":"ta4",
"蹺":"qiao1",
"蹻":"qiao1",
"蹼":"pu3",
"蹽":"liao1",
"蹾":"dun1",
"蹿":"cuan1",
"躀":"kuang4",
"躂":"da2",
"躃":"bi4",
"躄":"bi4",
"躅":"zhu2",
"躆":"ju4",
"躈":"qiao4",
"躉":"dun3",
"躋":"ji1",
"躌":"wu3",
"躎":"nian3",
"躏":"lin4",
"躐":"lie4",
"躑":"zhi2",
"躒":"luo4",
"躓":"zhi4",
"躔":"chan2",
"躕":"chu2",
"躖":"duan4",
"躗":"wei4",
"躘":"long2",
"躙":"lin4",
"躚":"xian1",
"躛":"wei4",
"躜":"zuan1",
"躝":"lan2",
"躞":"xie4",
"躟":"rang2",
"躠":"xie4",
"躡":"nie4",
"躢":"ta4",
"躣":"qu2",
"躤":"jie4",
"躥":"cuan1",
"躦":"zuan1",
"躧":"xi3",
"躨":"kui2",
"躩":"jue2",
"躪":"lin4",
"躭":"dan1",
"躰":"ti3",
"躱":"duo3",
"躳":"gong1",
"躴":"lang2",
"躶":"luo3",
"躷":"ai3",
"躸":"ji1",
"躹":"ju2",
"躽":"yan3",
"躿":"kang1",
"軁":"lou2",
"軂":"lao4",
"軃":"tuo3",
"軄":"zhi2",
"軆":"ti3",
"軇":"dao4",
"軉":"yu4",
"軎":"wei4",
"軏":"yue4",
"軐":"xin4",
"軑":"di4",
"軒":"xuan1",
"軓":"fan4",
"軔":"ren4",
"軕":"shan1",
"軖":"qiang2",
"軗":"shu1",
"軘":"tun2",
"軙":"chen2",
"軚":"dai4",
"軛":"e4",
"軜":"na4",
"軝":"qi2",
"軞":"mao2",
"軠":"ren4",
"軡":"fan3",
"転":"zhuan3",
"軣":"hong1",
"軤":"hu1",
"軥":"qu2",
"軦":"huang4",
"軧":"di3",
"軨":"ling2",
"軩":"dai4",
"軪":"ao1",
"軫":"zhen3",
"軬":"fan4",
"軭":"kuang1",
"軮":"ang3",
"軯":"peng1",
"軰":"bei4",
"軱":"gu1",
"軲":"ku1",
"軳":"pao2",
"軴":"zhu4",
"軵":"rong3",
"軶":"e4",
"軷":"ba2",
"軹":"zhi3",
"軺":"yao2",
"軻":"ke1",
"軼":"yi4",
"軽":"qing1",
"軾":"shi4",
"軿":"ping2",
"輀":"er2",
"輁":"qiong2",
"輂":"ju2",
"輄":"guang1",
"輅":"lu4",
"輆":"kai3",
"輇":"quan2",
"輈":"zhou1",
"輊":"zhi4",
"輋":"she1",
"輌":"liang4",
"輍":"yu4",
"輎":"shao1",
"輏":"you2",
"輐":"huan3",
"輑":"yun3",
"輒":"zhe2",
"輓":"wan3",
"輖":"zhou1",
"輗":"ni2",
"輘":"ling2",
"輙":"zhe2",
"輚":"zhan4",
"輜":"zi1",
"輞":"wang3",
"輟":"chuo4",
"輠":"guo3",
"輡":"kan3",
"輢":"yi3",
"輣":"peng2",
"輤":"qian4",
"輥":"gun3",
"輦":"nian3",
"輧":"pian2",
"輨":"guan3",
"輫":"pai2",
"輬":"liang2",
"輭":"ruan3",
"輮":"rou2",
"輰":"yang2",
"輱":"xian2",
"輲":"chuan2",
"輳":"cou4",
"輴":"chun1",
"輵":"ge2",
"輶":"you2",
"輷":"hong1",
"輹":"fu4",
"輺":"zi1",
"輼":"wen1",
"輽":"ben4",
"輾":"zhan3",
"轀":"wen1",
"轁":"tao1",
"轂":"gu1",
"轃":"zhen1",
"轄":"xia2",
"轅":"yuan2",
"轆":"lu4",
"轇":"jiu1",
"轈":"chao2",
"轊":"wei4",
"轋":"hun2",
"轍":"zhe2",
"轏":"zhan4",
"轐":"pu2",
"轑":"lao3",
"轒":"fen2",
"轓":"fan1",
"轔":"lin2",
"轕":"ge2",
"轖":"se4",
"轗":"kan3",
"轘":"huan2",
"轙":"yi3",
"轚":"ji2",
"轛":"dui4",
"轜":"er2",
"轝":"yu2",
"轞":"xian4",
"轠":"lei3",
"轡":"pei4",
"轢":"li4",
"轣":"li4",
"轤":"lu5",
"轥":"lin4",
"轩":"xuan1",
"轪":"di4",
"轫":"ren4",
"轭":"e4",
"轱":"ku1",
"轲":"ke1",
"轳":"lu5",
"轵":"zhi3",
"轶":"yi4",
"轷":"hu1",
"轸":"zhen3",
"轹":"li4",
"轺":"yao2",
"轼":"shi4",
"轾":"zhi4",
"辀":"zhou1",
"辁":"quan2",
"辂":"lu4",
"辄":"zhe2",
"辇":"nian3",
"辊":"gun3",
"辋":"wang3",
"辌":"liang2",
"辍":"chuo4",
"辎":"zi1",
"辏":"cou4",
"辒":"wen1",
"辔":"pei4",
"辕":"yuan2",
"辖":"xia2",
"辗":"zhan3",
"辘":"lu4",
"辙":"zhe2",
"辚":"lin2",
"辝":"ci2",
"辠":"zui4",
"辡":"bian4",
"辢":"la4",
"辤":"ci2",
"辥":"xue1",
"辧":"bian4",
"辬":"ban1",
"辰":"chen2",
"辳":"nong2",
"辴":"zhen3",
"辵":"chuo4",
"辶":"chuo4",
"辸":"reng2",
"辺":"bian1",
"辿":"chan1",
"迀":"gan1",
"迂":"yu1",
"迃":"yu1",
"迄":"qi4",
"迆":"yi3",
"迉":"qi2",
"迊":"za1",
"迋":"wang4",
"迍":"zhun1",
"迏":"ti4",
"迒":"hang2",
"迓":"ya4",
"迕":"wu3",
"迖":"da2",
"迗":"e2",
"迠":"che4",
"迡":"ni4",
"迢":"tiao2",
"迣":"zhi4",
"迤":"yi2",
"迥":"jiong3",
"迦":"jia1",
"迧":"chen2",
"迨":"dai4",
"迩":"er3",
"迪":"di2",
"迬":"wang3",
"迭":"die2",
"迮":"ze2",
"迯":"tao2",
"迱":"tuo2",
"迳":"jing4",
"迴":"hui2",
"迵":"tong2",
"迶":"you4",
"迸":"beng4",
"迺":"nai3",
"迻":"yi2",
"迼":"jie2",
"迾":"lie4",
"迿":"xun4",
"逄":"pang2",
"逅":"hou4",
"逆":"ni4",
"逇":"dun4",
"逈":"jiong3",
"逋":"bu1",
"逌":"you2",
"逍":"xiao1",
"逎":"qiu2",
"逑":"qiu2",
"逓":"di4",
"逕":"jing4",
"逖":"ti4",
"逘":"yi3",
"逜":"wu4",
"逞":"cheng3",
"逡":"qun1",
"逤":"suo4",
"逥":"hui2",
"逦":"li3",
"逨":"lai2",
"逩":"ben4",
"逪":"cuo4",
"逫":"jue2",
"逬":"beng4",
"逭":"huan4",
"逯":"lu4",
"逰":"you2",
"週":"zhou1",
"逳":"yu4",
"逴":"chuo4",
"逵":"kui2",
"逶":"wei1",
"逷":"ti4",
"逸":"yi4",
"逹":"da2",
"逺":"yuan3",
"逽":"nuo4",
"逾":"yu2",
"逿":"dang4",
"遀":"sui2",
"遁":"dun4",
"遂":"sui4",
"遃":"yan3",
"遄":"chuan2",
"遅":"chi2",
"遆":"ti2",
"遈":"shi2",
"遉":"zhen1",
"遊":"you2",
"遌":"e4",
"遏":"e4",
"遐":"xia2",
"遑":"huang2",
"遒":"qiu2",
"遘":"gou4",
"遚":"chu4",
"遛":"liu4",
"遝":"ta4",
"遟":"chi2",
"遡":"su4",
"遢":"ta1",
"遦":"guan4",
"遧":"zhang1",
"遨":"ao2",
"遪":"ce4",
"遫":"su4",
"遬":"su4",
"遯":"dun4",
"遰":"di4",
"遱":"lou2",
"遳":"cuo1",
"遴":"lin2",
"遶":"rao4",
"遹":"yu4",
"遻":"wu4",
"遽":"ju4",
"遾":"shi4",
"邂":"xie4",
"邃":"sui4",
"邅":"zhan1",
"邆":"teng2",
"邇":"er3",
"邈":"miao3",
"邉":"bian1",
"邋":"la2",
"邌":"li2",
"邍":"yuan2",
"邎":"yao2",
"邐":"li3",
"邑":"yi4",
"邒":"ting2",
"邓":"deng4",
"邔":"qi3",
"邕":"yong1",
"邖":"shan1",
"邗":"han2",
"邘":"yu2",
"邙":"mang2",
"邚":"ru2",
"邛":"qiong2",
"邝":"kuang4",
"邞":"fu1",
"邟":"kang4",
"邠":"bin1",
"邡":"fang1",
"邢":"xing2",
"邥":"shen3",
"邧":"yuan2",
"邨":"cun1",
"邩":"huo3",
"邪":"xie2",
"邫":"bang1",
"邬":"wu1",
"邭":"ju4",
"邯":"han2",
"邰":"tai2",
"邱":"qiu1",
"邲":"bi4",
"邳":"pei2",
"邴":"bing3",
"邵":"shao4",
"邶":"bei4",
"邷":"wa3",
"邸":"di3",
"邹":"zou1",
"邺":"ye4",
"邼":"kuang1",
"邽":"gui1",
"邾":"zhu1",
"邿":"shi1",
"郀":"ku1",
"郂":"gai1",
"郃":"he2",
"郄":"qie4",
"郅":"zhi4",
"郆":"ji2",
"郇":"xun2",
"郈":"hou4",
"郉":"xing2",
"郋":"xi2",
"郌":"gui1",
"郍":"nuo2",
"郎":"lang2",
"郏":"jia2",
"郐":"kuai4",
"郓":"yun4",
"郔":"yan2",
"郕":"cheng2",
"郖":"dou1",
"郗":"xi1",
"郘":"lv3",
"郙":"fu3",
"郚":"wu2",
"郛":"fu2",
"郜":"gao4",
"郝":"hao3",
"郞":"lang2",
"郟":"jia2",
"郠":"geng3",
"郡":"jun4",
"郢":"ying3",
"郣":"bo2",
"郤":"xi4",
"郥":"bei4",
"郦":"li4",
"郧":"yun2",
"郩":"xiao2",
"郪":"qi1",
"郫":"pi2",
"郬":"qing1",
"郭":"guo1",
"郯":"tan2",
"郰":"zou1",
"郱":"ping2",
"郲":"lai2",
"郳":"ni2",
"郴":"chen1",
"郶":"bu4",
"郷":"xiang1",
"郸":"dan1",
"郹":"ju2",
"郺":"yong1",
"郻":"qiao1",
"郼":"yi1",
"郾":"yan3",
"郿":"mei2",
"鄀":"ruo4",
"鄁":"bei4",
"鄂":"e4",
"鄃":"yu2",
"鄄":"juan4",
"鄅":"yu3",
"鄆":"yun4",
"鄇":"hou4",
"鄈":"kui2",
"鄊":"xiang1",
"鄋":"sou1",
"鄌":"tang2",
"鄍":"ming2",
"鄎":"xi4",
"鄏":"ru4",
"鄐":"chu4",
"鄑":"zi1",
"鄒":"zou1",
"鄓":"ju2",
"鄔":"wu1",
"鄕":"xiang1",
"鄖":"yun2",
"鄗":"hao4",
"鄘":"yong1",
"鄚":"mo4",
"鄛":"chao2",
"鄜":"fu1",
"鄝":"liao3",
"鄞":"yin2",
"鄟":"zhuan1",
"鄠":"hu4",
"鄡":"qiao1",
"鄢":"yan1",
"鄣":"zhang1",
"鄤":"man4",
"鄥":"qiao1",
"鄦":"xu3",
"鄧":"deng4",
"鄨":"bi4",
"鄩":"xin2",
"鄪":"bi4",
"鄫":"ceng2",
"鄬":"wei2",
"鄮":"mao4",
"鄯":"shan4",
"鄱":"po2",
"鄲":"dan1",
"鄳":"meng2",
"鄴":"ye4",
"鄵":"cao1",
"鄶":"kuai4",
"鄷":"feng1",
"鄸":"meng2",
"鄹":"zou1",
"鄺":"kuang4",
"鄻":"lian3",
"鄼":"zan4",
"鄽":"chan2",
"鄾":"you1",
"鄿":"qi2",
"酀":"yan1",
"酁":"chan2",
"酂":"zan4",
"酃":"ling2",
"酄":"huan1",
"酅":"xi1",
"酆":"feng1",
"酇":"zan4",
"酈":"li4",
"酉":"you3",
"酊":"ding3",
"酋":"qiu2",
"酌":"zhuo2",
"酎":"zhou4",
"酏":"yi3",
"酐":"gan1",
"酑":"yu3",
"酓":"yan3",
"酔":"zui4",
"酕":"mao2",
"酖":"dan1",
"酗":"xu4",
"酘":"tou2",
"酙":"zhen1",
"酚":"fen1",
"酝":"yun4",
"酞":"tai4",
"酟":"tian1",
"酠":"qia3",
"酡":"tuo2",
"酢":"cu4",
"酣":"han1",
"酤":"gu1",
"酥":"su1",
"酦":"po1",
"酧":"chou2",
"酨":"zai4",
"酩":"ming3",
"酪":"lao4",
"酫":"chuo4",
"酭":"you4",
"酮":"tong2",
"酯":"zhi3",
"酰":"xian1",
"酲":"cheng2",
"酳":"yin4",
"酴":"tu2",
"酹":"lei4",
"酺":"pu2",
"酻":"zui4",
"酼":"hai3",
"酽":"yan4",
"酾":"shi1",
"醀":"wei2",
"醁":"lu4",
"醂":"lan3",
"醃":"yan1",
"醄":"tao2",
"醅":"pei1",
"醆":"zhan3",
"醇":"chun2",
"醈":"tan2",
"醊":"chuo4",
"醌":"kun1",
"醍":"ti2",
"醎":"mian2",
"醏":"du1",
"醐":"hu2",
"醑":"xu3",
"醓":"tan3",
"醔":"jiu1",
"醕":"chun2",
"醖":"yun4",
"醗":"po4",
"醘":"ke4",
"醙":"sou1",
"醚":"mi2",
"醛":"quan2",
"醜":"chou3",
"醝":"cuo2",
"醞":"yun4",
"醟":"yong4",
"醠":"ang4",
"醡":"zha4",
"醢":"hai3",
"醣":"tang2",
"醤":"jiang4",
"醥":"piao3",
"醦":"shan3",
"醧":"yu4",
"醨":"li2",
"醩":"zao2",
"醪":"lao2",
"醭":"bu2",
"醮":"jiao4",
"醯":"xi1",
"醰":"tan2",
"醱":"po1",
"醲":"nong2",
"醳":"yi4",
"醴":"li3",
"醵":"ju4",
"醶":"jiao4",
"醷":"yi4",
"醸":"niang4",
"醹":"ru2",
"醺":"xun1",
"醻":"chou2",
"醼":"yan4",
"醽":"ling2",
"醾":"mi2",
"醿":"mi2",
"釁":"xin4",
"釂":"jiao4",
"釃":"shi1",
"釄":"mi2",
"釅":"yan4",
"釆":"bian4",
"釈":"shi4",
"釉":"you4",
"釐":"li2",
"釓":"ga2",
"釔":"yi3",
"釕":"liao3",
"釖":"dao1",
"釗":"zhao1",
"釙":"po1",
"釚":"qiu2",
"釛":"he2",
"釜":"fu3",
"釞":"zhi2",
"釟":"ba1",
"釠":"luan4",
"釡":"fu3",
"釢":"nai2",
"釤":"shan1",
"釥":"qiao3",
"釦":"kou4",
"釧":"chuan4",
"釨":"zi3",
"釩":"fan2",
"釪":"yu2",
"釫":"hua2",
"釬":"han4",
"釭":"gang1",
"釮":"qi2",
"釯":"mang2",
"釰":"ri4",
"釱":"di4",
"釲":"si4",
"釳":"xi4",
"釴":"yi4",
"釵":"chai1",
"釶":"shi1",
"釷":"tu3",
"釸":"xi4",
"釹":"nv3",
"釺":"qian1",
"釼":"jian4",
"釽":"pi1",
"釾":"ye2",
"釿":"yin2",
"鈀":"ba3",
"鈁":"fang1",
"鈂":"chen2",
"鈃":"xing2",
"鈄":"dou3",
"鈅":"yue4",
"鈆":"yan2",
"鈇":"fu1",
"鈈":"bu4",
"鈉":"na4",
"鈊":"xin1",
"鈋":"e2",
"鈌":"jue2",
"鈍":"dun4",
"鈎":"gou1",
"鈏":"yin3",
"鈐":"qian2",
"鈑":"ban3",
"鈒":"ji2",
"鈓":"ren2",
"鈕":"niu3",
"鈖":"fen1",
"鈗":"yun3",
"鈘":"ji3",
"鈙":"qin2",
"鈚":"pi2",
"鈛":"guo1",
"鈜":"hong2",
"鈝":"yin2",
"鈞":"jun1",
"鈟":"shi1",
"鈠":"yi4",
"鈡":"zhong1",
"鈢":"nie1",
"鈤":"ri4",
"鈥":"huo3",
"鈦":"tai4",
"鈧":"kang4",
"鈬":"duo2",
"鈭":"zi1",
"鈮":"ni2",
"鈯":"tu2",
"鈰":"shi4",
"鈱":"min2",
"鈲":"gu1",
"鈳":"ke1",
"鈵":"bing4",
"鈶":"yi2",
"鈸":"bo2",
"鈹":"pi2",
"鈺":"yu4",
"鈻":"si4",
"鈼":"zuo2",
"鈽":"bu1",
"鈿":"tian2",
"鉀":"jia3",
"鉁":"zhen1",
"鉂":"shi3",
"鉃":"shi4",
"鉄":"tie3",
"鉅":"ju4",
"鉆":"zhen1",
"鉇":"shi1",
"鉈":"ta1",
"鉉":"xuan4",
"鉊":"zhao1",
"鉋":"bao4",
"鉌":"he2",
"鉍":"bi4",
"鉎":"sheng1",
"鉏":"chu2",
"鉐":"shi2",
"鉑":"bo2",
"鉒":"zhu4",
"鉓":"chi4",
"鉔":"za1",
"鉕":"po3",
"鉖":"tong2",
"鉘":"fu2",
"鉙":"zhai3",
"鉚":"mao3",
"鉜":"fu2",
"鉝":"li4",
"鉞":"yue4",
"鉟":"pi1",
"鉠":"yang1",
"鉡":"ban4",
"鉢":"bo1",
"鉣":"jie2",
"鉥":"shu4",
"鉦":"zheng1",
"鉧":"mu3",
"鉨":"xi3",
"鉩":"nie1",
"鉪":"di4",
"鉫":"jia1",
"鉬":"mu4",
"鉭":"tan3",
"鉮":"shen1",
"鉯":"yi3",
"鉰":"si1",
"鉱":"kuang4",
"鉲":"ka3",
"鉳":"bei3",
"鉵":"tong2",
"鉶":"xing2",
"鉷":"hong2",
"鉸":"jiao3",
"鉹":"chi3",
"鉺":"er3",
"鉻":"ge4",
"鉼":"bing3",
"鉽":"shi4",
"鉾":"mou2",
"鉿":"ha1",
"銁":"jun1",
"銂":"zhou1",
"銃":"chong4",
"銄":"shang4",
"銆":"mo4",
"銇":"lei4",
"銈":"ji1",
"銉":"yu4",
"銊":"xu4",
"銋":"ren2",
"銌":"zun4",
"銍":"zhi4",
"銎":"qiong2",
"銏":"shan4",
"銐":"chi4",
"銑":"xian3",
"銒":"xing2",
"銓":"quan2",
"銔":"pi1",
"銕":"yi2",
"銖":"zhu1",
"銗":"hou2",
"銘":"ming2",
"銙":"kua3",
"銚":"diao4",
"銛":"xian1",
"銝":"xiu1",
"銞":"jun1",
"銟":"cha1",
"銠":"lao3",
"銡":"ji2",
"銢":"pi3",
"銣":"ru2",
"銤":"mi3",
"銥":"yi1",
"銦":"yin1",
"銧":"guang1",
"銨":"an3",
"銩":"diu1",
"銪":"you3",
"銫":"se4",
"銬":"kao4",
"銭":"qian2",
"銮":"luan2",
"銰":"ai1",
"銱":"diao4",
"銲":"han4",
"銴":"shi4",
"銵":"keng1",
"銶":"qiu2",
"銸":"zhe2",
"銹":"xiu4",
"銺":"zang4",
"銻":"ti1",
"銼":"cuo4",
"銽":"gua1",
"銾":"gong3",
"銿":"zhong1",
"鋀":"dou4",
"鋂":"mei2",
"鋃":"lang2",
"鋄":"wan3",
"鋆":"yun2",
"鋇":"bei4",
"鋈":"wu4",
"鋉":"su4",
"鋊":"yu4",
"鋋":"chan2",
"鋌":"ding4",
"鋍":"bo2",
"鋎":"han4",
"鋏":"jia2",
"鋐":"hong2",
"鋑":"cuan1",
"鋓":"chan1",
"鋔":"wan3",
"鋕":"zhi4",
"鋖":"si1",
"鋗":"xuan1",
"鋘":"wu2",
"鋙":"wu2",
"鋚":"tiao2",
"鋛":"gong3",
"鋜":"zhuo2",
"鋝":"lve4",
"鋞":"xing2",
"鋟":"qin3",
"鋠":"shen4",
"鋡":"han2",
"鋢":"lve4",
"鋣":"xie2",
"鋥":"zheng4",
"鋦":"ju2",
"鋧":"xian4",
"鋨":"e2",
"鋩":"mang2",
"鋫":"li2",
"鋬":"pan4",
"鋭":"rui4",
"鋮":"cheng2",
"鋯":"gao4",
"鋰":"li3",
"鋱":"te4",
"鋳":"zhu4",
"鋵":"tu1",
"鋶":"liu3",
"鋷":"zui4",
"鋹":"chang3",
"鋺":"yuan1",
"鋻":"jian4",
"鋽":"diao4",
"鋾":"tao2",
"鋿":"chang2",
"錀":"lun2",
"錁":"ke4",
"錂":"ling2",
"錃":"bei1",
"錅":"li2",
"錆":"qiang1",
"錇":"pei2",
"錈":"juan3",
"錉":"min2",
"錊":"zui4",
"錋":"peng2",
"錌":"an4",
"錍":"pi2",
"錎":"xian4",
"錏":"ya4",
"錐":"zhui1",
"錑":"lei4",
"錒":"a1",
"錓":"kong1",
"錔":"ta4",
"錕":"kun1",
"錖":"du3",
"錗":"wei4",
"錙":"zi1",
"錚":"zheng1",
"錛":"ben1",
"錜":"nie1",
"錝":"cong2",
"錞":"chun2",
"錟":"tan2",
"錡":"qi2",
"錣":"zhuo2",
"錤":"ji1",
"錥":"yu4",
"錧":"guan3",
"錨":"mao2",
"錩":"chang1",
"錪":"tian3",
"錬":"lian4",
"錭":"tao2",
"錮":"gu4",
"錰":"shu4",
"錱":"zhen1",
"録":"lu4",
"錳":"meng3",
"錴":"lu4",
"錵":"hua1",
"錶":"biao3",
"錷":"ga2",
"錸":"lai2",
"錹":"ken3",
"錼":"nai4",
"錽":"wan3",
"錾":"zan4",
"鍀":"de2",
"鍁":"xian1",
"鍃":"huo1",
"鍄":"liang4",
"鍆":"men2",
"鍇":"kai3",
"鍈":"ying1",
"鍉":"di1",
"鍊":"lian4",
"鍌":"xian3",
"鍎":"tu2",
"鍏":"wei2",
"鍐":"cong1",
"鍑":"fu4",
"鍒":"rou2",
"鍓":"ji2",
"鍔":"e4",
"鍕":"rou2",
"鍖":"chen3",
"鍗":"ti2",
"鍘":"zha2",
"鍙":"hong4",
"鍚":"yang2",
"鍜":"xia1",
"鍝":"yu2",
"鍞":"keng1",
"鍟":"xing1",
"鍠":"huang2",
"鍡":"wei3",
"鍢":"fu4",
"鍣":"zhao1",
"鍤":"cha2",
"鍥":"qie4",
"鍦":"she2",
"鍧":"hong1",
"鍨":"kui2",
"鍩":"nuo4",
"鍪":"mou2",
"鍫":"qiao1",
"鍭":"hou2",
"鍮":"tou1",
"鍯":"cong1",
"鍰":"huan2",
"鍱":"ye4",
"鍲":"min2",
"鍳":"jian4",
"鍴":"duan1",
"鍶":"si1",
"鍷":"kui1",
"鍸":"hu2",
"鍹":"xuan1",
"鍺":"zhe3",
"鍻":"jie2",
"鍼":"zhen1",
"鍽":"bian1",
"鍾":"zhong1",
"鍿":"zi1",
"鎀":"xiu1",
"鎁":"ye2",
"鎃":"pai4",
"鎄":"ai1",
"鎅":"jie4",
"鎇":"mei2",
"鎈":"chuo1",
"鎉":"ta4",
"鎊":"bang4",
"鎋":"xia2",
"鎌":"lian2",
"鎍":"suo3",
"鎎":"xi4",
"鎏":"liu2",
"鎐":"zu2",
"鎑":"ye4",
"鎒":"nou4",
"鎓":"weng1",
"鎔":"rong2",
"鎕":"tang2",
"鎗":"qiang1",
"鎘":"ge2",
"鎙":"shuo4",
"鎚":"chui2",
"鎛":"bo2",
"鎜":"pan2",
"鎝":"sa4",
"鎞":"bi4",
"鎟":"sang3",
"鎠":"gang1",
"鎡":"zi1",
"鎢":"wu1",
"鎣":"ying4",
"鎤":"huang3",
"鎥":"tiao2",
"鎦":"liu2",
"鎧":"kai3",
"鎨":"sun3",
"鎩":"sha1",
"鎪":"sou1",
"鎫":"wan4",
"鎬":"gao3",
"鎭":"zhen4",
"鎯":"luo3",
"鎰":"yi4",
"鎱":"yuan2",
"鎲":"tang3",
"鎳":"nie4",
"鎴":"xi2",
"鎵":"jia1",
"鎶":"ge1",
"鎷":"ma3",
"鎸":"juan1",
"鎹":"rong2",
"鎻":"suo3",
"鎿":"na2",
"鏀":"lu3",
"鏁":"suo3",
"鏂":"ou1",
"鏃":"zu2",
"鏄":"tuan2",
"鏅":"xiu1",
"鏆":"guan4",
"鏇":"xuan4",
"鏉":"shou4",
"鏊":"ao2",
"鏋":"man3",
"鏌":"mo4",
"鏍":"luo2",
"鏎":"bi4",
"鏏":"wei4",
"鏐":"liu2",
"鏑":"di1",
"鏒":"qiao1",
"鏓":"cong1",
"鏔":"yi2",
"鏕":"lu4",
"鏖":"ao2",
"鏗":"keng1",
"鏘":"qiang1",
"鏙":"cui1",
"鏚":"qi4",
"鏛":"chang2",
"鏜":"tang1",
"鏝":"man4",
"鏞":"yong1",
"鏠":"feng1",
"鏢":"biao1",
"鏣":"shu4",
"鏤":"lou4",
"鏥":"xiu4",
"鏦":"cong1",
"鏧":"long2",
"鏨":"zan4",
"鏩":"jian4",
"鏪":"cao2",
"鏫":"li2",
"鏬":"xia4",
"鏭":"xi1",
"鏮":"kang1",
"鏰":"beng4",
"鏳":"zheng1",
"鏴":"lu4",
"鏵":"hua2",
"鏶":"ji2",
"鏷":"pu2",
"鏸":"hui4",
"鏹":"qiang3",
"鏺":"po1",
"鏻":"lin2",
"鏼":"suo3",
"鏾":"san3",
"鏿":"cheng1",
"鐀":"kui4",
"鐁":"si1",
"鐂":"liu4",
"鐃":"nao2",
"鐄":"huang2",
"鐅":"pie3",
"鐆":"sui4",
"鐇":"fan2",
"鐈":"qiao2",
"鐉":"quan1",
"鐊":"yang2",
"鐋":"tang4",
"鐌":"xiang4",
"鐍":"jue2",
"鐎":"jiao1",
"鐏":"zun1",
"鐐":"liao4",
"鐑":"jie2",
"鐒":"lao2",
"鐓":"dun1",
"鐔":"tan2",
"鐕":"zan1",
"鐖":"ji1",
"鐗":"jian3",
"鐙":"deng4",
"鐚":"ya4",
"鐛":"ying4",
"鐜":"dui4",
"鐝":"jue2",
"鐞":"nou4",
"鐟":"ti4",
"鐠":"pu3",
"鐡":"tie3",
"鐤":"ding3",
"鐥":"shan4",
"鐦":"kai1",
"鐧":"jian3",
"鐨":"fei4",
"鐩":"sui4",
"鐪":"lu3",
"鐫":"juan1",
"鐬":"hui4",
"鐭":"yu4",
"鐯":"zhuo2",
"鐰":"qiao1",
"鐱":"qian1",
"鐲":"zhuo2",
"鐳":"lei2",
"鐴":"bi4",
"鐶":"huan2",
"鐷":"ye4",
"鐸":"duo2",
"鐹":"guo3",
"鐻":"ju4",
"鐼":"fen2",
"鐽":"da2",
"鐾":"bei4",
"鐿":"yi4",
"鑀":"ai4",
"鑁":"zong1",
"鑂":"xun4",
"鑃":"diao4",
"鑅":"heng2",
"鑆":"zhui4",
"鑇":"ji1",
"鑈":"nie1",
"鑉":"ta4",
"鑊":"huo4",
"鑋":"qing4",
"鑌":"bin1",
"鑍":"ying1",
"鑎":"kui4",
"鑏":"ning2",
"鑐":"xu1",
"鑑":"jian4",
"鑔":"cha3",
"鑕":"zhi4",
"鑖":"mie4",
"鑗":"li2",
"鑘":"lei2",
"鑙":"ji1",
"鑚":"zuan4",
"鑛":"kuang4",
"鑜":"shang4",
"鑝":"peng2",
"鑞":"la4",
"鑟":"du2",
"鑠":"shuo4",
"鑡":"chuo4",
"鑢":"lv4",
"鑣":"biao1",
"鑤":"bao4",
"鑥":"lu3",
"鑨":"long2",
"鑩":"e4",
"鑪":"lu2",
"鑫":"xin1",
"鑬":"jian4",
"鑭":"lan2",
"鑮":"bo2",
"鑯":"jian1",
"鑱":"chan2",
"鑳":"jian4",
"鑴":"xi4",
"鑵":"guan4",
"鑶":"cang2",
"鑷":"nie4",
"鑸":"lei3",
"鑹":"cuan4",
"鑺":"qu2",
"鑻":"pan4",
"鑾":"luan2",
"钀":"nie4",
"钁":"jue2",
"钂":"tang3",
"钃":"shu3",
"钄":"lan2",
"钅":"jin1",
"钆":"ga2",
"钇":"yi3",
"钊":"zhao1",
"钋":"po1",
"钌":"liao3",
"钍":"tu3",
"钎":"qian1",
"钏":"chuan4",
"钐":"shan1",
"钑":"ji2",
"钒":"fan2",
"钔":"men2",
"钕":"nv3",
"钖":"yang2",
"钗":"chai1",
"钘":"xing2",
"钚":"bu4",
"钛":"tai4",
"钜":"ju4",
"钝":"dun4",
"钠":"na4",
"钡":"bei4",
"钣":"ban3",
"钤":"qian2",
"钧":"jun1",
"钨":"wu1",
"钪":"kang4",
"钫":"fang1",
"钬":"huo3",
"钭":"dou3",
"钮":"niu3",
"钯":"ba3",
"钰":"yu4",
"钲":"zheng1",
"钵":"bo1",
"钶":"ke1",
"钷":"po3",
"钸":"bu1",
"钹":"bo2",
"钺":"yue4",
"钼":"mu4",
"钽":"tan3",
"钾":"jia3",
"钿":"tian2",
"铂":"bo2",
"铄":"shuo4",
"铆":"mao3",
"铇":"bao4",
"铈":"shi4",
"铉":"xuan4",
"铊":"ta1",
"铋":"bi4",
"铌":"ni2",
"铍":"pi2",
"铎":"duo2",
"铏":"xing2",
"铐":"kao4",
"铑":"lao3",
"铒":"er3",
"铓":"mang2",
"铔":"ya4",
"铕":"you3",
"铖":"cheng2",
"铗":"jia2",
"铘":"ye2",
"铙":"nao2",
"铚":"zhi4",
"铞":"diao4",
"铟":"yin1",
"铠":"kai3",
"铡":"zha2",
"铢":"zhu1",
"铣":"xian3",
"铤":"ding4",
"铥":"diu1",
"铦":"xian1",
"铧":"hua2",
"铨":"quan2",
"铩":"sha1",
"铪":"ha1",
"铫":"diao4",
"铬":"ge4",
"铭":"ming2",
"铮":"zheng1",
"铯":"se4",
"铰":"jiao3",
"铱":"yi1",
"铳":"chong4",
"铴":"tang4",
"铵":"an3",
"铷":"ru2",
"铹":"lao2",
"铻":"wu2",
"铼":"lai2",
"铽":"te4",
"铿":"keng1",
"锂":"li3",
"锃":"zheng4",
"锆":"gao4",
"锇":"e2",
"锉":"cuo4",
"锊":"lve4",
"锍":"liu3",
"锎":"kai1",
"锏":"jian3",
"锑":"ti1",
"锒":"lang2",
"锓":"qin3",
"锔":"ju1",
"锕":"a1",
"锖":"qiang1",
"锗":"zhe3",
"锘":"nuo4",
"锚":"mao2",
"锛":"ben1",
"锜":"qi2",
"锝":"de2",
"锞":"ke4",
"锟":"kun1",
"锠":"chang1",
"锢":"gu4",
"锥":"zhui1",
"锧":"zhi4",
"锨":"xian1",
"锩":"juan3",
"锪":"huo1",
"锫":"pei2",
"锬":"tan2",
"锰":"meng3",
"锱":"zi1",
"锲":"qie4",
"锳":"ying1",
"锴":"kai3",
"锵":"qiang1",
"锶":"si1",
"锷":"e4",
"锸":"cha2",
"锺":"zhong1",
"锼":"sou1",
"锽":"huang2",
"锾":"huan2",
"锿":"ai1",
"镂":"lou4",
"镃":"zi1",
"镄":"fei4",
"镅":"mei2",
"镆":"mo4",
"镈":"bo2",
"镉":"ge2",
"镊":"nie4",
"镋":"tang3",
"镌":"juan1",
"镍":"nie4",
"镎":"na2",
"镏":"liu2",
"镐":"gao3",
"镑":"bang4",
"镒":"yi4",
"镓":"jia1",
"镔":"bin1",
"镕":"rong2",
"镖":"biao1",
"镗":"tang1",
"镘":"man4",
"镙":"luo2",
"镚":"beng4",
"镛":"yong1",
"镝":"di1",
"镞":"zu2",
"镟":"xuan4",
"镠":"liu2",
"镡":"tan2",
"镢":"jue2",
"镣":"liao4",
"镤":"pu2",
"镥":"lu3",
"镦":"dun1",
"镧":"lan2",
"镨":"pu3",
"镩":"cuan4",
"镪":"qiang3",
"镫":"deng4",
"镬":"huo4",
"镭":"lei2",
"镮":"huan2",
"镯":"zhuo2",
"镱":"yi4",
"镲":"cha3",
"镳":"biao1",
"镴":"la4",
"镵":"chan2",
"镸":"chang2",
"镹":"jiu3",
"镺":"ao3",
"镻":"die2",
"镼":"qu1",
"镽":"liao3",
"镾":"mi2",
"閁":"ma4",
"閂":"shuan1",
"閄":"huo4",
"閅":"men2",
"閆":"yan2",
"閇":"bi4",
"閈":"han4",
"閌":"kang1",
"閍":"beng1",
"閎":"hong2",
"閏":"run4",
"閐":"san4",
"閒":"xian2",
"閔":"min3",
"閕":"xia1",
"閗":"dou4",
"閙":"nao4",
"閛":"peng1",
"閜":"xia3",
"閝":"ling2",
"閞":"bian4",
"閟":"bi4",
"閠":"run4",
"閡":"he2",
"関":"guan1",
"閣":"ge2",
"閤":"he2",
"閦":"chu4",
"閧":"hong4",
"閩":"min3",
"閫":"kun3",
"閬":"lang3",
"閭":"lv2",
"閮":"ting2",
"閯":"sha4",
"閰":"ju2",
"閲":"yue4",
"閳":"chan3",
"閴":"qu4",
"閵":"lin4",
"閶":"chang1",
"閷":"shai4",
"閸":"kun3",
"閹":"yan1",
"閺":"wen2",
"閻":"yan2",
"閼":"yan1",
"閽":"hun1",
"閾":"yu4",
"閿":"wen2",
"闀":"xiang4",
"闁":"bao1",
"闂":"xiang4",
"闃":"qu4",
"闄":"yao3",
"闅":"wen2",
"闆":"ban3",
"闇":"an4",
"闈":"wei2",
"闉":"yin1",
"闋":"que4",
"闌":"lan2",
"闍":"she2",
"闐":"tian2",
"闑":"nie4",
"闒":"ta4",
"闓":"kai3",
"闔":"he2",
"闕":"que1",
"闗":"guan1",
"闘":"dou4",
"闙":"qi3",
"闚":"kui1",
"闛":"tang2",
"闝":"piao2",
"闞":"kan4",
"闟":"xi1",
"闠":"hui4",
"闢":"pi4",
"闣":"dang4",
"闤":"huan2",
"闥":"ta4",
"闦":"wen2",
"闩":"shuan1",
"闫":"yan2",
"闬":"han4",
"闰":"run4",
"闱":"wei2",
"闳":"hong2",
"闵":"min3",
"闶":"kang1",
"闼":"ta4",
"闽":"min3",
"闾":"lv2",
"闿":"kai3",
"阁":"ge2",
"阂":"he2",
"阃":"kun3",
"阄":"jiu1",
"阆":"lang3",
"阇":"she2",
"阈":"yu4",
"阉":"yan1",
"阊":"chang1",
"阋":"xi4",
"阌":"wen2",
"阍":"hun1",
"阎":"yan2",
"阏":"yan1",
"阑":"lan2",
"阒":"qu4",
"阓":"hui4",
"阕":"que4",
"阖":"he2",
"阗":"tian2",
"阘":"ta4",
"阙":"que1",
"阚":"kan4",
"阛":"huan2",
"阜":"fu4",
"阝":"fu4",
"阞":"le4",
"阠":"xin4",
"阡":"qian1",
"阢":"wu4",
"阣":"yi4",
"阤":"tuo2",
"阥":"yin1",
"阦":"yang2",
"阧":"dou3",
"阨":"e4",
"阩":"sheng1",
"阪":"ban3",
"阫":"pei2",
"阬":"keng1",
"阭":"yun3",
"阮":"ruan3",
"阯":"zhi3",
"阰":"pi2",
"阱":"jing3",
"阷":"cheng1",
"阸":"e4",
"阹":"qu1",
"阺":"di3",
"阼":"zuo4",
"阽":"dian4",
"阾":"ling3",
"陀":"tuo2",
"陁":"tuo2",
"陂":"bei1",
"陃":"bing3",
"陇":"long3",
"陉":"xing2",
"陊":"duo4",
"陎":"shu1",
"陏":"duo4",
"陑":"er2",
"陒":"gui3",
"陓":"yu1",
"陔":"gai1",
"陕":"shan3",
"陖":"xun4",
"陗":"qiao4",
"陘":"xing2",
"陙":"chun2",
"陚":"fu4",
"陛":"bi4",
"陜":"xia2",
"陝":"shan3",
"陞":"sheng1",
"陟":"zhi4",
"陠":"pu1",
"陥":"xian4",
"陧":"nie4",
"陨":"yun3",
"陫":"pei2",
"陬":"zou1",
"陭":"yi1",
"陮":"dui3",
"陯":"lun2",
"陱":"ju1",
"陲":"chui2",
"陴":"pi2",
"険":"xian3",
"陻":"yin1",
"陼":"zhu3",
"陾":"reng2",
"陿":"shan3",
"隀":"chong2",
"隁":"yan4",
"隂":"yin1",
"隃":"yu2",
"隄":"di1",
"隅":"yu2",
"隇":"wei1",
"隈":"wei1",
"隉":"nie4",
"隋":"sui2",
"隌":"an3",
"隍":"huang2",
"隑":"gai1",
"隒":"yan3",
"隓":"hui1",
"隕":"yun3",
"隖":"wu4",
"隗":"kui2",
"隚":"tang2",
"隝":"dao3",
"隞":"ao2",
"隟":"xi4",
"隠":"yin3",
"隢":"rao4",
"隣":"lin2",
"隤":"tui2",
"隥":"deng4",
"隦":"pi3",
"隩":"yu4",
"隫":"fen1",
"隬":"ni3",
"隭":"er2",
"隮":"ji1",
"隯":"dao3",
"隰":"xi2",
"隲":"e2",
"隳":"hui1",
"隴":"long3",
"隵":"xi1",
"隷":"li4",
"隹":"zhui1",
"隺":"he4",
"隻":"zhi1",
"隼":"sun3",
"隽":"juan4",
"隿":"yi4",
"雁":"yan4",
"雂":"qin2",
"雃":"ya3",
"雅":"ya3",
"雈":"huan2",
"雉":"zhi4",
"雊":"gou4",
"雋":"juan4",
"雍":"yong1",
"雎":"ju1",
"雏":"chu2",
"雐":"hu1",
"雑":"za2",
"雒":"luo4",
"雓":"yu2",
"雔":"chou2",
"雗":"han4",
"雘":"huo4",
"雚":"guan4",
"雛":"chu2",
"雝":"yong1",
"雟":"sui2",
"雠":"chou2",
"雡":"liu4",
"雤":"xue2",
"雥":"za2",
"雦":"ji2",
"雧":"ji2",
"雩":"yu2",
"雫":"na3",
"雬":"fou3",
"雭":"se4",
"雮":"mu4",
"雯":"wen2",
"雰":"fen1",
"雱":"pang1",
"雲":"yun2",
"雳":"li4",
"雴":"li4",
"雵":"ang3",
"雸":"an2",
"雺":"meng2",
"雼":"dang4",
"雽":"xing2",
"雿":"zhao4",
"霁":"ji4",
"霂":"mu4",
"霃":"chen2",
"霄":"xiao1",
"霅":"zha2",
"霆":"ting2",
"霈":"pei4",
"霊":"ling2",
"霋":"qi1",
"霌":"chou1",
"霍":"huo4",
"霏":"fei1",
"霐":"weng1",
"霑":"zhan1",
"霒":"yin1",
"霓":"ni2",
"霔":"zhu4",
"霕":"tun2",
"霖":"lin2",
"霘":"dong4",
"霙":"ying1",
"霚":"wu4",
"霛":"ling2",
"霝":"ling2",
"霟":"hong2",
"霠":"yin1",
"霡":"mai4",
"霢":"mai4",
"霣":"yun3",
"霤":"liu4",
"霥":"meng4",
"霦":"bin1",
"霨":"wei4",
"霩":"kuo4",
"霪":"yin2",
"霫":"xi2",
"霬":"yi4",
"霭":"ai3",
"霮":"dan4",
"霯":"deng4",
"霰":"xian4",
"霱":"yu4",
"霳":"long2",
"霴":"dai4",
"霵":"ji2",
"霶":"pang2",
"霷":"yang2",
"霹":"pi1",
"霺":"wei2",
"霼":"xi3",
"霽":"ji4",
"霾":"mai2",
"霿":"meng4",
"靀":"meng2",
"靁":"lei2",
"靂":"li4",
"靃":"huo4",
"靄":"ai3",
"靅":"fei4",
"靆":"dai4",
"靇":"long2",
"靉":"ai4",
"靊":"feng1",
"靋":"li4",
"靌":"bao3",
"靎":"he4",
"靏":"he4",
"靐":"bing4",
"靑":"qing1",
"靓":"jing4",
"靔":"tian1",
"靕":"zhen1",
"靖":"jing4",
"靗":"cheng4",
"靘":"qing4",
"靚":"jing4",
"靛":"dian4",
"靝":"tian1",
"靟":"fei1",
"靡":"mi2",
"靣":"mian4",
"靤":"pao4",
"靥":"ye4",
"靦":"mian3",
"靧":"hui4",
"靨":"ye4",
"靪":"ding1",
"靫":"cha1",
"靬":"jian1",
"靭":"ren4",
"靮":"di2",
"靯":"du4",
"靰":"wu4",
"靱":"ren4",
"靲":"qin2",
"靳":"jin4",
"靵":"niu3",
"靶":"ba3",
"靷":"yin3",
"靸":"sa3",
"靹":"na4",
"靺":"mo4",
"靻":"zu3",
"靼":"da2",
"靽":"ban4",
"靾":"yi4",
"靿":"yao4",
"鞀":"tao2",
"鞁":"tuo2",
"鞂":"jia2",
"鞃":"hong2",
"鞄":"pao2",
"鞅":"yang3",
"鞇":"yin1",
"鞈":"jia2",
"鞉":"tao2",
"鞊":"ji2",
"鞌":"an1",
"鞍":"an1",
"鞎":"hen2",
"鞑":"da2",
"鞒":"qiao1",
"鞓":"ting1",
"鞔":"wan3",
"鞕":"ying4",
"鞖":"sui1",
"鞗":"tiao2",
"鞘":"qiao4",
"鞙":"xuan4",
"鞚":"kong4",
"鞛":"beng3",
"鞜":"ta4",
"鞝":"shang4",
"鞞":"bing3",
"鞟":"kuo4",
"鞡":"la5",
"鞢":"xie4",
"鞣":"rou2",
"鞤":"bang1",
"鞥":"yi4",
"鞦":"qiu1",
"鞧":"qiu1",
"鞨":"he2",
"鞩":"xiao4",
"鞪":"mu4",
"鞫":"ju1",
"鞬":"jian1",
"鞮":"di1",
"鞯":"jian1",
"鞱":"tao1",
"鞲":"gou1",
"鞳":"ta4",
"鞴":"bei4",
"鞵":"xie2",
"鞶":"pan2",
"鞷":"ge2",
"鞸":"bi4",
"鞹":"kuo4",
"鞻":"lou2",
"鞼":"gui4",
"鞽":"qiao2",
"鞾":"xue1",
"鞿":"ji1",
"韀":"jian1",
"韂":"chan4",
"韃":"da2",
"韄":"huo4",
"韅":"xian3",
"韆":"qian1",
"韇":"du2",
"韈":"wa4",
"韉":"jian1",
"韊":"lan2",
"韋":"wei2",
"韍":"fu2",
"韎":"mei4",
"韏":"juan4",
"韐":"ge2",
"韑":"wei3",
"韒":"qiao4",
"韓":"han2",
"韔":"chang4",
"韖":"rou2",
"韗":"xun4",
"韘":"she4",
"韙":"wei3",
"韚":"ge2",
"韛":"bei4",
"韜":"tao1",
"韝":"gou1",
"韞":"yun4",
"韠":"bi4",
"韡":"wei3",
"韢":"hui4",
"韣":"du2",
"韤":"wa4",
"韥":"du2",
"韦":"wei2",
"韨":"fu2",
"韩":"han2",
"韪":"wei3",
"韫":"yun4",
"韬":"tao1",
"韭":"jiu3",
"韮":"jiu3",
"韯":"xian1",
"韰":"xie4",
"韱":"qian2",
"韲":"ji1",
"韴":"za2",
"韵":"yun4",
"韶":"shao2",
"韷":"le4",
"韸":"peng2",
"韹":"huang2",
"韺":"ying1",
"韻":"yun4",
"韼":"peng2",
"韽":"yin1",
"韾":"yin1",
"頀":"hu4",
"頄":"kui2",
"頇":"han1",
"頉":"yi2",
"頊":"xu1",
"頋":"gu4",
"頍":"kui3",
"頎":"qi2",
"頏":"hang2",
"頔":"di2",
"頕":"dan1",
"頖":"pan4",
"頙":"ce4",
"頚":"jing3",
"頛":"lei3",
"頜":"he2",
"頝":"qiao1",
"頞":"e4",
"頟":"e2",
"頠":"wei3",
"頡":"xie2",
"頢":"gua1",
"頣":"shen3",
"頤":"yi2",
"頥":"shen3",
"頦":"hai2",
"頧":"dui1",
"頨":"pian1",
"頩":"ping1",
"頪":"lei4",
"頫":"fu3",
"頬":"jia2",
"頮":"hui4",
"頯":"kui2",
"頱":"le4",
"頲":"ting3",
"頳":"cheng1",
"頴":"ying3",
"頵":"jun1",
"頶":"hu2",
"頷":"han4",
"頹":"tui2",
"頺":"tui2",
"頼":"lai4",
"頽":"tui2",
"頾":"zi1",
"頿":"zi1",
"顀":"chui2",
"顁":"ding4",
"顂":"lai4",
"顃":"yan2",
"顄":"han4",
"顅":"jian1",
"顇":"cui4",
"顈":"jiong3",
"顉":"qin1",
"顊":"yi2",
"顋":"sai1",
"顎":"e4",
"顐":"hun2",
"顑":"kan3",
"顒":"yong2",
"顓":"zhuan1",
"顔":"yan2",
"顕":"xian3",
"顖":"xin4",
"顗":"yi3",
"願":"yuan4",
"顙":"sang3",
"顚":"dian1",
"顜":"jiang3",
"顝":"ku1",
"顟":"liao2",
"顠":"piao4",
"顡":"yi4",
"顢":"man1",
"顣":"qi1",
"顤":"rao4",
"顥":"hao4",
"顦":"qiao2",
"顨":"xun4",
"顩":"qian1",
"顪":"hui1",
"顬":"ru2",
"顭":"hong1",
"顮":"bin1",
"顰":"pin2",
"顱":"lu2",
"顲":"lan3",
"顳":"nie4",
"顴":"quan2",
"顸":"han1",
"顼":"xu1",
"颀":"qi2",
"颃":"hang2",
"颅":"lu2",
"颉":"xie2",
"颋":"ting3",
"颌":"he2",
"颍":"ying3",
"颎":"jiong3",
"颏":"hai2",
"颐":"yi2",
"颒":"hui4",
"颓":"tui2",
"颔":"han4",
"颕":"ying3",
"颙":"yong2",
"颚":"e4",
"颛":"zhuan1",
"颞":"nie4",
"颟":"man1",
"颡":"sang3",
"颢":"hao4",
"颣":"lei4",
"颥":"ru2",
"颦":"pin2",
"颧":"quan2",
"颩":"biao1",
"颫":"fu2",
"颬":"xia1",
"颭":"zhan3",
"颮":"biao1",
"颯":"sa4",
"颰":"ba2",
"颱":"tai2",
"颲":"lie4",
"颳":"gua1",
"颴":"xuan4",
"颵":"shao4",
"颶":"ju4",
"颷":"bi1",
"颸":"si1",
"颹":"wei3",
"颺":"yang2",
"颻":"yao2",
"颼":"sou1",
"颽":"kai3",
"颾":"sao1",
"颿":"fan2",
"飀":"liu2",
"飁":"xi2",
"飂":"liao2",
"飃":"piao1",
"飅":"liu2",
"飆":"biao1",
"飇":"biao1",
"飈":"biao1",
"飉":"liao2",
"飋":"se4",
"飌":"feng1",
"飍":"biao1",
"飏":"yang2",
"飐":"zhan3",
"飑":"biao1",
"飒":"sa4",
"飓":"ju4",
"飔":"si1",
"飕":"sou1",
"飖":"yao2",
"飗":"liu2",
"飙":"biao1",
"飚":"biao1",
"飜":"fan1",
"飝":"fei1",
"飠":"shi2",
"飡":"can1",
"飣":"ding4",
"飤":"si4",
"飥":"tuo1",
"飦":"zhan1",
"飧":"sun1",
"飨":"xiang3",
"飩":"tun5",
"飪":"ren4",
"飫":"yu4",
"飬":"juan4",
"飭":"chi4",
"飮":"yin3",
"飰":"fan4",
"飱":"sun1",
"飳":"zhu4",
"飴":"yi2",
"飵":"zhai3",
"飶":"bi4",
"飷":"jie3",
"飸":"tao1",
"飹":"liu3",
"飺":"ci2",
"飻":"tie4",
"飿":"duo4",
"餀":"hai4",
"餁":"ren4",
"餂":"tian3",
"餄":"jia2",
"餆":"yao2",
"餇":"tong2",
"餈":"ci2",
"餉":"xiang3",
"餋":"yang3",
"餌":"er3",
"餍":"yan4",
"餎":"le5",
"餏":"yi1",
"餑":"bo1",
"餒":"nei3",
"餔":"bu1",
"餕":"jun4",
"餖":"dou4",
"餗":"su4",
"餘":"yu2",
"餙":"shi4",
"餚":"yao2",
"餛":"hun2",
"餜":"guo3",
"餝":"shi4",
"餞":"jian4",
"餟":"chuo4",
"餠":"bing3",
"餢":"bu4",
"餣":"ye4",
"餤":"tan2",
"餥":"fei3",
"餦":"zhang1",
"餧":"wei4",
"餩":"e4",
"餪":"nuan3",
"餫":"hun2",
"餬":"hu2",
"餭":"huang2",
"餮":"tie4",
"餯":"hui4",
"餰":"jian1",
"餱":"hou2",
"餲":"he2",
"餳":"xing2",
"餴":"fen1",
"餵":"wei4",
"餶":"gu3",
"餷":"cha1",
"餸":"song4",
"餹":"tang2",
"餺":"bo2",
"餻":"gao1",
"餼":"xi4",
"餽":"kui4",
"餾":"liu2",
"餿":"sou1",
"饀":"tao2",
"饁":"ye4",
"饂":"yun2",
"饃":"mo2",
"饄":"tang2",
"饆":"bi4",
"饇":"yu4",
"饈":"xiu1",
"饉":"jin3",
"饊":"san3",
"饋":"kui4",
"饌":"zhuan4",
"饍":"shan4",
"饎":"chi4",
"饏":"dan4",
"饐":"yi4",
"饑":"ji1",
"饓":"cheng1",
"饔":"yong1",
"饕":"tao1",
"饖":"hui4",
"饗":"xiang3",
"饘":"zhan1",
"饙":"fen1",
"饚":"hai4",
"饛":"meng2",
"饜":"yan4",
"饝":"mo2",
"饟":"xiang3",
"饠":"luo2",
"饡":"zuan4",
"饢":"nang3",
"饣":"shi2",
"饤":"ding4",
"饦":"tuo1",
"饧":"xing2",
"饨":"tun5",
"饩":"xi4",
"饪":"ren4",
"饫":"yu4",
"饬":"chi4",
"饯":"jian4",
"饳":"duo4",
"饴":"yi2",
"饵":"er3",
"饷":"xiang3",
"饸":"jia2",
"饹":"le5",
"饻":"yi1",
"饽":"bo1",
"饾":"dou4",
"馀":"yu2",
"馁":"nei3",
"馂":"jun4",
"馃":"guo3",
"馄":"hun2",
"馇":"cha1",
"馈":"kui4",
"馉":"gu3",
"馊":"sou1",
"馌":"ye4",
"馍":"mo2",
"馎":"bo2",
"馏":"liu2",
"馐":"xiu1",
"馑":"jin3",
"馓":"san3",
"馔":"zhuan4",
"馕":"nang3",
"馗":"kui2",
"馘":"guo2",
"馚":"fen2",
"馛":"ba2",
"馜":"ni3",
"馝":"bi4",
"馞":"bo2",
"馟":"tu2",
"馠":"han1",
"馡":"fei1",
"馢":"jian1",
"馣":"yan3",
"馤":"ai3",
"馥":"fu4",
"馦":"xian1",
"馧":"wen1",
"馨":"xin1",
"馩":"fen2",
"馪":"bin1",
"馫":"xing1",
"馭":"yu4",
"馮":"feng2",
"馯":"han4",
"馰":"di4",
"馲":"tuo1",
"馴":"xun4",
"馵":"zhu4",
"馶":"zhi1",
"馷":"pei4",
"馸":"xin4",
"馹":"ri4",
"馺":"sa4",
"馻":"yin3",
"馼":"wen2",
"馽":"zhi2",
"馾":"dan4",
"馿":"lv2",
"駀":"you2",
"駂":"bao3",
"駃":"kuai4",
"駄":"tuo2",
"駅":"yi4",
"駆":"qu1",
"駈":"qu1",
"駉":"jiong3",
"駊":"bo3",
"駋":"zhao1",
"駌":"yuan1",
"駍":"peng1",
"駎":"zhou4",
"駏":"ju4",
"駑":"nu2",
"駓":"pi1",
"駔":"zang3",
"駖":"ling2",
"駗":"zhen1",
"駘":"tai2",
"駙":"fu4",
"駚":"yang3",
"駜":"bi4",
"駞":"tuo2",
"駟":"si4",
"駠":"liu2",
"駡":"ma4",
"駢":"pian2",
"駣":"tao2",
"駤":"zhi4",
"駥":"rong2",
"駦":"teng2",
"駧":"dong4",
"駨":"xun2",
"駩":"quan2",
"駪":"shen1",
"駫":"jiong1",
"駬":"er3",
"駭":"hai4",
"駮":"bo2",
"駰":"yin1",
"駳":"dan4",
"駴":"xie4",
"駵":"liu2",
"駶":"ju2",
"駷":"song3",
"駸":"qin1",
"駹":"mang2",
"駺":"liang2",
"駻":"han4",
"駼":"tu2",
"駽":"xuan4",
"駾":"tui4",
"駿":"jun4",
"騀":"e2",
"騁":"cheng3",
"騂":"xing1",
"騃":"ai2",
"騄":"lu4",
"騅":"zhui1",
"騆":"zhou1",
"騇":"she3",
"騈":"pian2",
"騉":"kun1",
"騊":"tao2",
"騋":"lai2",
"騌":"zong1",
"騍":"ke4",
"騏":"qi2",
"騐":"yan4",
"騑":"fei1",
"騒":"sao1",
"験":"yan4",
"騔":"jie2",
"騕":"yao3",
"騖":"wu4",
"騗":"pian4",
"騘":"cong1",
"騚":"qian2",
"騛":"fei1",
"騜":"huang2",
"騝":"jian1",
"騞":"huo4",
"騟":"yu4",
"騠":"ti2",
"騡":"quan2",
"騢":"xia2",
"騣":"zong1",
"騤":"kui2",
"騥":"rou2",
"騦":"si1",
"騧":"gua1",
"騨":"tuo2",
"騩":"kui4",
"騪":"sou1",
"騫":"qian1",
"騬":"cheng2",
"騭":"zhi4",
"騮":"liu2",
"騯":"pang2",
"騱":"xi1",
"騲":"cao3",
"騳":"du2",
"騴":"yan4",
"騵":"yuan2",
"騶":"zou1",
"騷":"sao1",
"騸":"shan4",
"騹":"li2",
"騺":"zhi4",
"騻":"shuang3",
"騼":"lu4",
"騽":"xi2",
"騿":"zhang1",
"驀":"mo4",
"驁":"ao4",
"驂":"can1",
"驃":"piao4",
"驄":"cong1",
"驆":"bi4",
"驇":"zhi4",
"驈":"yu4",
"驉":"xu1",
"驊":"hua2",
"驋":"bo1",
"驌":"su4",
"驍":"xiao1",
"驎":"lin2",
"驏":"chan3",
"驐":"dun1",
"驑":"liu2",
"驒":"tuo2",
"驓":"zeng1",
"驔":"tan2",
"驖":"tie3",
"驘":"luo2",
"驙":"zhan1",
"驛":"yi4",
"驜":"ye4",
"驝":"tuo1",
"驞":"bin1",
"驠":"yan4",
"驡":"peng2",
"驣":"teng2",
"驤":"xiang1",
"驥":"ji4",
"驦":"shuang1",
"驧":"ju2",
"驨":"xi1",
"驩":"huan1",
"驪":"li2",
"驫":"biao1",
"驭":"yu4",
"驯":"xun4",
"驲":"ri4",
"驵":"zang3",
"驷":"si4",
"驸":"fu4",
"驺":"zou1",
"驽":"nu2",
"驿":"yi4",
"骀":"tai2",
"骁":"xiao1",
"骃":"yin1",
"骅":"hua2",
"骇":"hai4",
"骈":"pian2",
"骉":"biao1",
"骊":"li2",
"骋":"cheng3",
"骍":"xing1",
"骎":"qin1",
"骏":"jun4",
"骐":"qi2",
"骒":"ke4",
"骓":"zhui1",
"骔":"zong1",
"骕":"su4",
"骖":"can1",
"骘":"zhi4",
"骙":"kui2",
"骚":"sao1",
"骛":"wu4",
"骜":"ao4",
"骝":"liu2",
"骞":"qian1",
"骟":"shan4",
"骠":"piao4",
"骢":"cong1",
"骣":"chan3",
"骥":"ji4",
"骦":"shuang1",
"骧":"xiang1",
"骩":"wei3",
"骪":"wei3",
"骫":"wei3",
"骬":"yu2",
"骭":"gan4",
"骮":"yi4",
"骯":"ang1",
"骰":"tou2",
"骱":"jie4",
"骲":"bao1",
"骳":"bi4",
"骴":"ci1",
"骵":"ti3",
"骶":"di3",
"骷":"ku1",
"骸":"hai2",
"骹":"qiao1",
"骺":"gou4",
"骻":"kua4",
"骽":"tui3",
"骾":"geng3",
"骿":"pian2",
"髀":"bi4",
"髁":"ke1",
"髂":"qia4",
"髃":"yu2",
"髄":"sui3",
"髅":"lou2",
"髆":"bo2",
"髇":"xiao1",
"髈":"pang2",
"髉":"bo1",
"髊":"ci1",
"髋":"kuan1",
"髌":"bin4",
"髍":"mo2",
"髎":"liao2",
"髏":"lou2",
"髐":"xiao1",
"髑":"du2",
"髒":"zang1",
"髓":"sui3",
"髕":"bin4",
"髖":"kuan1",
"髗":"lu2",
"髙":"gao1",
"髚":"qiao4",
"髛":"kao1",
"髜":"qiao1",
"髝":"lao2",
"髞":"sao4",
"髟":"biao1",
"髠":"kun1",
"髡":"kun1",
"髢":"ti4",
"髣":"fang3",
"髤":"xiu1",
"髥":"ran2",
"髧":"dan4",
"髨":"kun1",
"髩":"bin4",
"髪":"fa4",
"髫":"tiao2",
"髬":"pi1",
"髭":"zi1",
"髮":"fa4",
"髯":"ran2",
"髰":"ti4",
"髱":"pao4",
"髲":"pi4",
"髳":"mao2",
"髴":"fu2",
"髵":"er2",
"髶":"rong2",
"髷":"qu1",
"髹":"xiu1",
"髺":"gua4",
"髻":"ji4",
"髼":"peng2",
"髽":"zhua1",
"髾":"shao1",
"髿":"sha1",
"鬀":"ti4",
"鬁":"li4",
"鬂":"bin4",
"鬃":"zong1",
"鬄":"ti4",
"鬅":"peng2",
"鬆":"song1",
"鬇":"zheng1",
"鬈":"quan2",
"鬉":"zong1",
"鬊":"shun4",
"鬋":"jian1",
"鬌":"duo3",
"鬍":"hu2",
"鬎":"la4",
"鬏":"jiu1",
"鬐":"qi2",
"鬑":"lian2",
"鬒":"zhen3",
"鬓":"bin4",
"鬔":"peng2",
"鬕":"mo4",
"鬖":"san1",
"鬗":"man4",
"鬘":"man2",
"鬙":"seng1",
"鬚":"xu1",
"鬛":"lie4",
"鬜":"qian1",
"鬝":"qian1",
"鬞":"nong2",
"鬟":"huan2",
"鬠":"kuai4",
"鬡":"ning2",
"鬢":"bin4",
"鬣":"lie4",
"鬤":"rang2",
"鬥":"dou4",
"鬦":"dou4",
"鬨":"hong4",
"鬩":"xi4",
"鬪":"dou4",
"鬫":"kan4",
"鬬":"dou4",
"鬭":"dou4",
"鬮":"jiu1",
"鬯":"chang4",
"鬰":"yu4",
"鬱":"yu4",
"鬲":"ge2",
"鬳":"juan4",
"鬴":"fu3",
"鬵":"qian2",
"鬶":"gui1",
"鬷":"zong1",
"鬸":"liu4",
"鬹":"gui1",
"鬺":"shang1",
"鬻":"yu4",
"鬽":"mei4",
"鬾":"ji4",
"鬿":"qi2",
"魀":"jie4",
"魁":"kui2",
"魃":"ba2",
"魅":"mei4",
"魆":"xu4",
"魇":"yan3",
"魈":"xiao1",
"魉":"liang3",
"魊":"yu4",
"魋":"tui2",
"魌":"qi1",
"魍":"wang3",
"魎":"liang3",
"魏":"wei4",
"魐":"jian1",
"魑":"chi1",
"魒":"piao1",
"魓":"bi4",
"魕":"ji3",
"魖":"xu1",
"魗":"chou3",
"魘":"yan3",
"魙":"zhan3",
"魛":"dao1",
"魜":"ren2",
"魝":"ji4",
"魟":"gong1",
"魠":"tuo2",
"魡":"diao4",
"魢":"ji3",
"魣":"yu2",
"魤":"e2",
"魥":"e4",
"魦":"sha1",
"魧":"hang2",
"魨":"tun2",
"魩":"mo4",
"魪":"jie4",
"魫":"shen3",
"魬":"fan3",
"魭":"yuan2",
"魮":"bi2",
"魯":"lu3",
"魰":"wen2",
"魱":"hu2",
"魲":"lu2",
"魳":"za2",
"魴":"fang2",
"魵":"fen2",
"魶":"na4",
"魷":"you2",
"魺":"he2",
"魻":"xia2",
"魼":"qu1",
"魽":"han1",
"魾":"pi2",
"魿":"ling2",
"鮀":"tuo2",
"鮁":"ba4",
"鮂":"qiu2",
"鮃":"ping2",
"鮄":"fu2",
"鮅":"bi4",
"鮆":"ji4",
"鮇":"wei4",
"鮈":"ju1",
"鮉":"diao1",
"鮊":"bo2",
"鮋":"you2",
"鮌":"gun3",
"鮍":"pi2",
"鮎":"nian2",
"鮏":"xing1",
"鮐":"tai2",
"鮑":"bao4",
"鮒":"fu4",
"鮓":"zha3",
"鮔":"ju4",
"鮕":"gu1",
"鮙":"ta4",
"鮚":"jie2",
"鮛":"shu4",
"鮜":"hou4",
"鮝":"xiang3",
"鮞":"er2",
"鮟":"an4",
"鮠":"wei2",
"鮡":"tiao1",
"鮢":"zhu1",
"鮣":"yin4",
"鮤":"lie4",
"鮥":"luo4",
"鮦":"tong2",
"鮧":"yi2",
"鮨":"qi2",
"鮩":"bing4",
"鮪":"wei3",
"鮫":"jiao1",
"鮬":"bu4",
"鮭":"gui1",
"鮯":"ge2",
"鮰":"hui2",
"鮳":"kao3",
"鮵":"duo2",
"鮶":"jun1",
"鮷":"ti2",
"鮸":"mian3",
"鮹":"xiao1",
"鮺":"za3",
"鮻":"sha1",
"鮼":"qin1",
"鮽":"yu2",
"鮾":"nei3",
"鮿":"zhe2",
"鯀":"gun3",
"鯁":"geng3",
"鯃":"wu2",
"鯄":"qiu2",
"鯅":"ting2",
"鯆":"fu3",
"鯇":"huan4",
"鯈":"chou2",
"鯊":"sha1",
"鯋":"sha1",
"鯌":"gao4",
"鯍":"meng2",
"鯒":"yong3",
"鯓":"ni2",
"鯔":"zi1",
"鯕":"qi2",
"鯖":"qing1",
"鯗":"xiang3",
"鯘":"nei3",
"鯙":"chun2",
"鯚":"ji4",
"鯛":"diao1",
"鯜":"qie4",
"鯝":"gu4",
"鯞":"zhou3",
"鯟":"dong1",
"鯠":"lai2",
"鯡":"fei1",
"鯢":"ni2",
"鯣":"yi4",
"鯤":"kun1",
"鯥":"lu4",
"鯦":"jiu4",
"鯧":"chang1",
"鯩":"lun2",
"鯪":"ling2",
"鯫":"zou1",
"鯬":"li2",
"鯭":"meng3",
"鯮":"zong1",
"鯯":"zhi4",
"鯰":"nian2",
"鯴":"shi1",
"鯵":"shen1",
"鯶":"hun3",
"鯷":"shi4",
"鯸":"hou2",
"鯹":"xing1",
"鯺":"zhu1",
"鯻":"la4",
"鯼":"zong1",
"鯽":"ji4",
"鯾":"bian1",
"鯿":"bian1",
"鰀":"huan4",
"鰁":"quan2",
"鰂":"ze2",
"鰃":"wei1",
"鰄":"wei1",
"鰅":"yu2",
"鰆":"chun1",
"鰇":"rou2",
"鰈":"die2",
"鰉":"huang2",
"鰊":"lian4",
"鰋":"yan3",
"鰌":"qiu2",
"鰍":"qiu1",
"鰎":"jian4",
"鰏":"bi4",
"鰐":"e4",
"鰑":"yang2",
"鰒":"fu4",
"鰓":"sai1",
"鰔":"jian3",
"鰕":"xia2",
"鰖":"tuo3",
"鰗":"hu2",
"鰙":"ruo4",
"鰛":"wen1",
"鰜":"jian1",
"鰝":"hao4",
"鰞":"wu1",
"鰟":"pang2",
"鰠":"sao1",
"鰡":"liu2",
"鰢":"ma3",
"鰣":"shi2",
"鰤":"shi1",
"鰥":"guan1",
"鰦":"zi1",
"鰧":"teng2",
"鰨":"ta3",
"鰩":"yao2",
"鰪":"ge2",
"鰫":"rong2",
"鰬":"qian2",
"鰭":"qi2",
"鰮":"wen1",
"鰯":"ruo4",
"鰱":"lian2",
"鰲":"ao2",
"鰳":"le4",
"鰴":"hui1",
"鰵":"min3",
"鰶":"ji4",
"鰷":"tiao2",
"鰸":"qu1",
"鰹":"jian1",
"鰺":"sao1",
"鰻":"man2",
"鰼":"xi2",
"鰽":"qiu2",
"鰾":"biao4",
"鰿":"ji1",
"鱀":"ji4",
"鱁":"zhu2",
"鱂":"jiang1",
"鱃":"qiu1",
"鱄":"zhuan1",
"鱅":"yong2",
"鱆":"zhang1",
"鱇":"kang1",
"鱈":"xue3",
"鱉":"bie1",
"鱊":"jue2",
"鱋":"qu1",
"鱌":"xiang4",
"鱍":"bo1",
"鱎":"jiao3",
"鱏":"xun2",
"鱐":"su4",
"鱑":"huang2",
"鱒":"zun1",
"鱓":"shan4",
"鱔":"shan4",
"鱕":"fan1",
"鱖":"gui4",
"鱗":"lin2",
"鱘":"xun2",
"鱙":"miao2",
"鱚":"xi3",
"鱝":"fen4",
"鱞":"guan1",
"鱟":"hou4",
"鱠":"kuai4",
"鱡":"zei2",
"鱢":"sao1",
"鱣":"shan4",
"鱤":"gan3",
"鱥":"gui4",
"鱦":"sheng2",
"鱧":"li3",
"鱨":"chang2",
"鱬":"ru2",
"鱭":"ji4",
"鱮":"xu4",
"鱯":"huo4",
"鱱":"li4",
"鱲":"lie4",
"鱳":"li4",
"鱴":"mie4",
"鱵":"zhen1",
"鱶":"xiang3",
"鱸":"lu2",
"鱹":"guan4",
"鱺":"li2",
"鱻":"xian1",
"鱽":"dao1",
"鱾":"ji3",
"鱿":"you2",
"鲀":"tun2",
"鲁":"lu3",
"鲂":"fang2",
"鲃":"ba1",
"鲄":"he2",
"鲅":"ba4",
"鲆":"ping2",
"鲇":"nian2",
"鲈":"lu2",
"鲉":"you2",
"鲊":"zha3",
"鲋":"fu4",
"鲌":"bo2",
"鲍":"bao4",
"鲎":"hou4",
"鲏":"pi2",
"鲐":"tai2",
"鲑":"gui1",
"鲒":"jie2",
"鲓":"kao3",
"鲔":"wei3",
"鲕":"er2",
"鲖":"tong2",
"鲗":"ze2",
"鲘":"hou4",
"鲙":"kuai4",
"鲚":"ji4",
"鲛":"jiao1",
"鲝":"za3",
"鲞":"xiang3",
"鲟":"xun2",
"鲠":"geng3",
"鲡":"li2",
"鲢":"lian2",
"鲣":"jian1",
"鲥":"shi2",
"鲦":"tiao2",
"鲧":"gun3",
"鲨":"sha1",
"鲩":"huan4",
"鲪":"jun1",
"鲫":"ji4",
"鲬":"yong3",
"鲭":"qing1",
"鲮":"ling2",
"鲯":"qi2",
"鲰":"zou1",
"鲱":"fei1",
"鲲":"kun1",
"鲳":"chang1",
"鲴":"gu4",
"鲵":"ni2",
"鲶":"nian2",
"鲷":"diao1",
"鲹":"shen1",
"鲺":"shi1",
"鲻":"zi1",
"鲼":"fen4",
"鲽":"die2",
"鲾":"bi4",
"鲿":"chang2",
"鳀":"shi4",
"鳁":"wen1",
"鳂":"wei1",
"鳃":"sai1",
"鳅":"qiu1",
"鳆":"fu4",
"鳇":"huang2",
"鳈":"quan2",
"鳉":"jiang1",
"鳊":"bian1",
"鳋":"sao1",
"鳌":"ao2",
"鳍":"qi2",
"鳎":"ta3",
"鳏":"guan1",
"鳐":"yao2",
"鳑":"pang2",
"鳒":"jian1",
"鳓":"le4",
"鳔":"biao4",
"鳕":"xue3",
"鳖":"bie1",
"鳗":"man2",
"鳘":"min3",
"鳙":"yong2",
"鳚":"wei4",
"鳛":"xi2",
"鳜":"gui4",
"鳝":"shan4",
"鳞":"lin2",
"鳟":"zun1",
"鳠":"huo4",
"鳡":"gan3",
"鳢":"li3",
"鳣":"shan4",
"鳤":"guan3",
"鳦":"yi3",
"鳨":"li4",
"鳩":"jiu1",
"鳪":"bu3",
"鳫":"yan4",
"鳬":"fu2",
"鳭":"diao1",
"鳮":"ji1",
"鳯":"feng4",
"鳱":"gan1",
"鳲":"shi1",
"鳵":"bao3",
"鳶":"yuan1",
"鳷":"zhi1",
"鳸":"hu4",
"鳹":"qin2",
"鳺":"fu1",
"鳻":"fen1",
"鳼":"wen2",
"鳽":"jian1",
"鳾":"shi1",
"鳿":"yu4",
"鴀":"fou3",
"鴁":"yao1",
"鴂":"jue4",
"鴃":"jue2",
"鴄":"pi1",
"鴅":"huan1",
"鴆":"zhen4",
"鴇":"bao3",
"鴈":"yan4",
"鴊":"zheng4",
"鴋":"fang1",
"鴌":"feng4",
"鴍":"wen2",
"鴎":"ou1",
"鴏":"te4",
"鴐":"jia1",
"鴑":"nu2",
"鴒":"ling2",
"鴓":"mie4",
"鴔":"fu2",
"鴕":"tuo2",
"鴖":"wen2",
"鴗":"li4",
"鴘":"bian4",
"鴙":"zhi4",
"鴚":"ge1",
"鴛":"yuan1",
"鴜":"zi1",
"鴝":"qu2",
"鴞":"xiao1",
"鴟":"chi1",
"鴠":"dan4",
"鴡":"ju1",
"鴢":"you4",
"鴣":"gu1",
"鴤":"zhong1",
"鴥":"yu4",
"鴦":"yang1",
"鴧":"rong4",
"鴩":"tie3",
"鴪":"yu4",
"鴬":"ying1",
"鴭":"zhui1",
"鴮":"wu1",
"鴯":"er2",
"鴰":"gua1",
"鴱":"ai4",
"鴲":"zhi1",
"鴳":"yan4",
"鴴":"heng2",
"鴵":"jiao1",
"鴶":"ji2",
"鴷":"lie4",
"鴸":"zhu1",
"鴹":"ren2",
"鴺":"yi2",
"鴻":"hong2",
"鴼":"luo4",
"鴽":"ru2",
"鴾":"mou2",
"鵀":"ren4",
"鵁":"jiao1",
"鵂":"xiu1",
"鵃":"zhou1",
"鵄":"zhi1",
"鵅":"luo4",
"鵉":"luan2",
"鵊":"jia2",
"鵋":"ji4",
"鵌":"yu2",
"鵍":"huan1",
"鵎":"tuo3",
"鵏":"bu1",
"鵐":"wu2",
"鵒":"yu4",
"鵓":"bo2",
"鵔":"xun4",
"鵕":"xun4",
"鵖":"bi4",
"鵗":"xi1",
"鵘":"jun4",
"鵙":"ju2",
"鵚":"tu2",
"鵛":"jing1",
"鵜":"ti2",
"鵞":"e2",
"鵟":"kuang2",
"鵠":"gu3",
"鵡":"wu3",
"鵢":"shen1",
"鵣":"lai4",
"鵦":"lu4",
"鵧":"ping2",
"鵨":"shu1",
"鵩":"fu2",
"鵫":"zhao4",
"鵬":"peng2",
"鵭":"qin2",
"鵮":"qian1",
"鵯":"bei1",
"鵰":"diao1",
"鵱":"lu4",
"鵳":"jian1",
"鵴":"ju2",
"鵵":"tu4",
"鵶":"ya1",
"鵷":"yuan1",
"鵸":"qi2",
"鵹":"li2",
"鵺":"ye4",
"鵻":"zhui1",
"鵼":"kong1",
"鵽":"zhui4",
"鵾":"kun1",
"鵿":"sheng1",
"鶀":"qi2",
"鶁":"jing1",
"鶂":"yi4",
"鶃":"yi4",
"鶄":"jing1",
"鶅":"zi1",
"鶆":"lai2",
"鶇":"dong1",
"鶈":"qi1",
"鶊":"geng1",
"鶋":"ju1",
"鶌":"qu1",
"鶏":"ji1",
"鶐":"shu4",
"鶒":"chi4",
"鶓":"miao2",
"鶔":"rou2",
"鶕":"an1",
"鶖":"qiu1",
"鶗":"ti2",
"鶘":"hu2",
"鶙":"ti2",
"鶚":"e4",
"鶛":"jie1",
"鶜":"mao2",
"鶝":"fu2",
"鶞":"chun1",
"鶟":"tu2",
"鶠":"yan3",
"鶡":"he2",
"鶢":"yuan2",
"鶣":"pian1",
"鶤":"yun4",
"鶥":"mei2",
"鶦":"hu2",
"鶧":"ying1",
"鶨":"dun4",
"鶩":"wu4",
"鶪":"ju2",
"鶬":"cang1",
"鶭":"fang3",
"鶮":"gu4",
"鶯":"ying1",
"鶰":"yuan2",
"鶱":"xuan1",
"鶲":"weng1",
"鶳":"shi1",
"鶴":"he4",
"鶵":"chu2",
"鶶":"tang2",
"鶷":"xia4",
"鶸":"ruo4",
"鶹":"liu2",
"鶺":"ji2",
"鶻":"hu2",
"鶼":"jian1",
"鶽":"zhun3",
"鶾":"han4",
"鶿":"ci2",
"鷀":"ci2",
"鷁":"yi4",
"鷂":"yao4",
"鷃":"yan4",
"鷄":"ji1",
"鷅":"li4",
"鷆":"tian2",
"鷇":"kou4",
"鷈":"ti1",
"鷉":"ti1",
"鷊":"ni4",
"鷋":"tu2",
"鷌":"ma3",
"鷍":"jiao1",
"鷎":"gao1",
"鷏":"zhen1",
"鷐":"chen2",
"鷑":"li4",
"鷒":"zhuan1",
"鷓":"zhe4",
"鷔":"ao2",
"鷕":"yao3",
"鷖":"yi1",
"鷘":"chi4",
"鷙":"zhi4",
"鷚":"liao2",
"鷛":"rong2",
"鷜":"lou2",
"鷝":"bi4",
"鷞":"shuang1",
"鷟":"zhuo2",
"鷠":"yu2",
"鷡":"wu2",
"鷢":"jue2",
"鷣":"yin2",
"鷤":"quan2",
"鷥":"si1",
"鷦":"jiao1",
"鷧":"yi4",
"鷨":"hua1",
"鷩":"bi4",
"鷪":"ying1",
"鷫":"su4",
"鷬":"huang2",
"鷭":"fan2",
"鷮":"jiao1",
"鷯":"liao2",
"鷰":"yan4",
"鷱":"kao1",
"鷲":"jiu4",
"鷳":"xian2",
"鷴":"xian2",
"鷵":"tu2",
"鷶":"mai3",
"鷷":"zun1",
"鷸":"yu4",
"鷺":"lu4",
"鷻":"tuan2",
"鷼":"xian2",
"鷽":"xue2",
"鷾":"yi4",
"鷿":"pi4",
"鸀":"shu2",
"鸁":"luo2",
"鸂":"xi1",
"鸃":"yi2",
"鸄":"ji2",
"鸅":"zhe2",
"鸆":"yu2",
"鸇":"zhan1",
"鸈":"ye4",
"鸉":"yang2",
"鸊":"pi4",
"鸋":"ning2",
"鸌":"huo4",
"鸍":"mi2",
"鸎":"ying1",
"鸏":"meng2",
"鸐":"di2",
"鸑":"yue4",
"鸒":"yu2",
"鸓":"lei3",
"鸔":"bao4",
"鸕":"lu2",
"鸖":"he4",
"鸗":"long2",
"鸘":"shuang1",
"鸙":"yue4",
"鸚":"ying1",
"鸛":"guan4",
"鸜":"qu2",
"鸞":"luan2",
"鸠":"jiu1",
"鸢":"yuan1",
"鸤":"shi1",
"鸧":"cang1",
"鸨":"bao3",
"鸩":"zhen4",
"鸪":"gu1",
"鸫":"dong1",
"鸬":"lu2",
"鸮":"xiao1",
"鸯":"yang1",
"鸰":"ling2",
"鸱":"chi1",
"鸲":"qu2",
"鸳":"yuan1",
"鸴":"xue2",
"鸵":"tuo2",
"鸶":"si1",
"鸷":"zhi4",
"鸸":"er2",
"鸹":"gua1",
"鸺":"xiu1",
"鸻":"heng2",
"鸼":"zhou1",
"鸾":"luan2",
"鸿":"hong2",
"鹀":"wu2",
"鹁":"bo2",
"鹄":"gu3",
"鹆":"yu4",
"鹇":"xian2",
"鹈":"ti2",
"鹉":"wu3",
"鹋":"miao2",
"鹍":"kun1",
"鹎":"bei1",
"鹏":"peng2",
"鹐":"qian1",
"鹒":"geng1",
"鹓":"yuan1",
"鹔":"su4",
"鹕":"hu2",
"鹖":"he2",
"鹗":"e4",
"鹘":"hu2",
"鹙":"qiu1",
"鹚":"ci2",
"鹛":"mei2",
"鹜":"wu4",
"鹝":"ni4",
"鹞":"yao4",
"鹟":"weng1",
"鹠":"liu2",
"鹡":"ji2",
"鹢":"yi4",
"鹣":"jian1",
"鹤":"he4",
"鹥":"yi1",
"鹦":"ying1",
"鹧":"zhe4",
"鹨":"liao2",
"鹩":"liao2",
"鹪":"jiao1",
"鹫":"jiu4",
"鹬":"yu4",
"鹭":"lu4",
"鹮":"huan2",
"鹯":"zhan1",
"鹱":"huo4",
"鹲":"meng2",
"鹳":"guan4",
"鹴":"shuang1",
"鹵":"lu3",
"鹶":"jin1",
"鹷":"ling2",
"鹸":"jian3",
"鹹":"xian2",
"鹺":"cuo2",
"鹻":"jian3",
"鹾":"cuo2",
"麀":"you1",
"麁":"cu1",
"麂":"ji3",
"麃":"biao1",
"麄":"cu1",
"麅":"biao1",
"麆":"zhu4",
"麇":"qun2",
"麈":"zhu3",
"麉":"jian1",
"麊":"mi2",
"麋":"mi2",
"麌":"wu2",
"麍":"liu2",
"麎":"chen2",
"麏":"jun1",
"麐":"lin2",
"麑":"ni2",
"麒":"qi2",
"麓":"lu4",
"麔":"jiu4",
"麕":"jun1",
"麖":"jing1",
"麘":"xiang1",
"麙":"yan2",
"麚":"jia1",
"麛":"mi2",
"麜":"li4",
"麝":"she4",
"麞":"zhang1",
"麟":"lin2",
"麠":"jing1",
"麡":"ji1",
"麢":"ling2",
"麣":"yan2",
"麤":"cu1",
"麧":"ge1",
"麨":"chao3",
"麩":"fu1",
"麪":"mian3",
"麫":"mian3",
"麬":"fu1",
"麭":"pao4",
"麮":"qu4",
"麯":"qu2",
"麰":"mou2",
"麱":"fu1",
"麲":"xian4",
"麳":"lai2",
"麴":"qu1",
"麵":"mian4",
"麷":"feng1",
"麸":"fu1",
"麹":"qu2",
"麺":"mian4",
"麽":"mo2",
"麾":"hui1",
"麿":"mo3",
"黀":"zou1",
"黁":"nen1",
"黂":"fen2",
"黅":"jin1",
"黆":"guang1",
"黇":"tian1",
"黈":"tou3",
"黉":"hong2",
"黊":"xi1",
"黋":"kuang3",
"黌":"hong2",
"黍":"shu3",
"黐":"chi1",
"黒":"hei1",
"黓":"yi4",
"黔":"qian2",
"黕":"zhen3",
"黖":"xi4",
"黗":"tuan3",
"黙":"mo4",
"黚":"qian2",
"黛":"dai4",
"黜":"chu4",
"黝":"you3",
"黟":"yi1",
"黠":"xia2",
"黡":"yan3",
"黢":"qu1",
"黣":"mei3",
"黤":"yan3",
"黥":"qing2",
"黦":"yu4",
"黧":"li2",
"黩":"du2",
"黪":"can3",
"黫":"yin1",
"黬":"an4",
"黭":"yan1",
"黮":"dan3",
"黰":"zhen3",
"黱":"dai4",
"黲":"can3",
"黳":"yi1",
"黵":"dan3",
"黶":"yan3",
"黷":"du2",
"黸":"lu2",
"黹":"zhi3",
"黺":"fen3",
"黻":"fu2",
"黼":"fu2",
"黽":"min3",
"黾":"min3",
"黿":"yuan2",
"鼀":"cu4",
"鼁":"qu4",
"鼂":"chao2",
"鼃":"wa1",
"鼄":"zhu1",
"鼅":"zhi1",
"鼆":"mang2",
"鼇":"ao2",
"鼈":"bie1",
"鼉":"tuo2",
"鼊":"bi4",
"鼋":"yuan2",
"鼌":"chao2",
"鼍":"tuo2",
"鼎":"ding3",
"鼏":"mi4",
"鼐":"nai4",
"鼑":"ding3",
"鼒":"zi1",
"鼔":"gu3",
"鼕":"dong1",
"鼖":"fen2",
"鼗":"tao2",
"鼘":"yuan1",
"鼙":"pi2",
"鼚":"chang1",
"鼛":"gao1",
"鼜":"qi4",
"鼝":"yuan1",
"鼞":"tang1",
"鼟":"teng1",
"鼡":"shu3",
"鼢":"fen2",
"鼣":"fei4",
"鼤":"wen2",
"鼥":"ba2",
"鼦":"diao1",
"鼧":"tuo2",
"鼨":"tong2",
"鼩":"qu2",
"鼪":"sheng1",
"鼫":"shi2",
"鼬":"you4",
"鼭":"shi2",
"鼮":"ting2",
"鼯":"wu2",
"鼰":"nian4",
"鼱":"jing1",
"鼲":"hun2",
"鼳":"ju2",
"鼴":"yan3",
"鼵":"tu2",
"鼶":"ti2",
"鼷":"xi1",
"鼸":"xian3",
"鼹":"yan3",
"鼺":"lei2",
"鼼":"yao3",
"鼽":"qiu2",
"鼾":"han1",
"鼿":"wu1",
"齀":"wu4",
"齁":"hou1",
"齂":"xi4",
"齃":"ge2",
"齄":"zha1",
"齅":"xiu4",
"齆":"weng4",
"齇":"zha1",
"齈":"nong2",
"齉":"nang4",
"齋":"zhai1",
"齌":"ji4",
"齍":"zi1",
"齎":"ji1",
"齏":"ji1",
"齑":"ji1",
"齓":"chen4",
"齔":"chen4",
"齕":"he2",
"齖":"ya2",
"齗":"yin2",
"齘":"xie4",
"齙":"bao1",
"齚":"cuo4",
"齛":"shi4",
"齜":"zi1",
"齝":"chi1",
"齞":"nian4",
"齟":"ju3",
"齠":"tiao2",
"齢":"ling2",
"齣":"chu1",
"齤":"quan2",
"齥":"xie4",
"齦":"yin2",
"齧":"nie4",
"齨":"jiu4",
"齩":"yao3",
"齪":"chuo4",
"齫":"kun3",
"齬":"yu3",
"齭":"chu3",
"齮":"yi3",
"齯":"ni2",
"齰":"cuo4",
"齱":"zou1",
"齲":"qu3",
"齳":"nen3",
"齴":"xian3",
"齵":"yu2",
"齶":"e4",
"齷":"wo4",
"齸":"yi4",
"齹":"chuo1",
"齺":"zou1",
"齻":"dian1",
"齼":"chu3",
"齽":"jin4",
"齾":"ya4",
"龀":"chen4",
"龁":"he2",
"龂":"yin2",
"龃":"ju3",
"龅":"bao1",
"龆":"tiao2",
"龇":"zi1",
"龈":"yin2",
"龉":"yu3",
"龊":"chuo4",
"龋":"qu3",
"龌":"wo4",
"龎":"pang2",
"龏":"gong1",
"龑":"yan3",
"龒":"long2",
"龓":"long2",
"龔":"gong1",
"龕":"kan1",
"龖":"ta4",
"龗":"ling2",
"龘":"da2",
"龚":"gong1",
"龛":"kan1",
"龝":"qiu1",
"龞":"bie1",
"龠":"yue4",
"龡":"chui4",
"龢":"he2",
"龣":"jue2",
"龤":"xie2",
"龥":"yu4",
"癩":"la4",
"蘭":"lan2",
"盧":"lu2",
"老":"lao3",
"不":"bu4",
"練":"lian4",
"識":"shi2",
"兀":"wu4",
"嗀":"huo4",
"塚":"zhong3",
"晴":"qing2",
"凞":"xi1",
"猪":"zhu1",
"益":"yi4",
"礼":"li3",
"神":"shen2",
"祥":"xiang2",
"福":"fu2",
"靖":"jing4",
"精":"jing1",
"羽":"yu3",
"諸":"zhu1",
"逸":"yi4",
"都":"du1",
"飯":"fan4",
"飼":"si4",
"館":"guan3",
"鶴":"he4"
},
"compounds":{
"+":[
["+橫","yi1heng2"],
["+個樣","yi1ge5yang4"]
],
"一":[
["一万","yi2wan4"],
["一下","yi2xia4"],
["一世","yi2shi4"],
["一两","yi4liang3"],
["一个","yi2ge5"],
["一串","yi2chuan4"],
["一举","yi4ju3"],
["一义","yi2yi4"],
["一了","yi4liao3"],
["一亇","yi2ge4"],
["一事","yi2shi4"],
["一二","yi2er4"],
["一些","yi4xie1"],
["一亩","yi4mu3"],
["一人","yi4ren2"],
["一亿","yi2yi4"],
["一仍","yi4reng2"],
["一从","yi4cong2"],
["一代","yi2dai4"],
["一件","yi2jian4"],
["一任","yi2ren4"],
["一份","yi2fen4"],
["一伏","yi4fu2"],
["一伙","yi4huo3"],
["一会","yi2hui4"],
["一似","yi2si4"],
["一位","yi2wei4"],
["一体","yi4ti3"],
["一何","yi4he2"],
["一併","yi2bing4"],
["一來","yi4lai2"],
["一例","yi2li4"],
["一個","yi2ge5"],
["一偏","yi4pian1"],
["一億","yi2yi4"],
["一元","yi4yuan2"],
["一党","yi4dang3"],
["一兩","yi4liang3"],
["一共","yi2gong4"],
["一具","yi2ju4"],
["一冊","yi2ce4"],
["一册","yi2ce4"],
["一再","yi2zai4"],
["一冬","yi4dong1"],
["一准","yi4zhun3"],
["一出","yi4chu1"],
["一击","yi4ji1"],
["一切","yi2qie4"],
["一则","yi4ze2"],
["一刬","yi2chan4"],
["一刹","yi2cha4"],
["一刻","yi2ke4"],
["一則","yi4ze2"],
["一剎","yi2cha4"],
["一剗","yi2chan4"],
["一副","yi2fu4"],
["一力","yi2li4"],
["一动","yi2dong4"],
["一動","yi2dong4"],
["一包","yi4bao1"],
["一匙","yi4chi2"],
["一匹","yi4pi3"],
["一十","yi4shi2"],
["一千","yi4qian1"],
["一半","yi2ban4"],
["一双","yi4shuang1"],
["一反","yi4fan3"],
["一发","yi4fa1"],
["一口","yi4kou3"],
["一句","yi2ju4"],
["一只","yi4zhi1"],
["一台","yi4tai2"],
["一号","yi2hao4"],
["一同","yi4tong2"],
["一名","yi4ming2"],
["一向","yi2xiang4"],
["一听","yi4ting1"],
["一吹","yi4chui1"],
["一吾","yi4wu2"],
["一员","yi4yuan2"],
["一周","yi4zhou1"],
["一味","yi2wei4"],
["一命","yi2ming4"],
["一品","yi4pin3"],
["一响","yi4xiang3"],
["一員","yi4yuan2"],
["一哪","yi4nei3"],
["一嘴","yi4zui3"],
["一回","yi4hui2"],
["一团","yi4tuan2"],
["一圈","yi4quan1"],
["一團","yi4tuan2"],
["一场","yi4chang2"],
["一块","yi2kuai4"],
["一垒","yi4lei3"],
["一堂","yi4tang2"],
["一堆","yi4dui1"],
["一場","yi4chang2"],
["一堵","yi4du3"],
["一塊","yi2kuai4"],
["一壁","yi2bi4"],
["一壘","yi4lei3"],
["一声","yi4sheng1"],
["一壶","yi4hu2"],
["一壺","yi4hu2"],
["一处","yi2chu4"],
["一夏","yi2xia4"],
["一夜","yi2ye4"],
["一天","yi4tian1"],
["一夫","yi4fu1"],
["一头","yi4tou2"],
["一套","yi2tao4"],
["一如","yi4ru2"],
["一字","yi2zi4"],
["一宗","yi4zong1"],
["一定","yi2ding4"],
["一审","yi4shen3"],
["一家","yi4jia1"],
["一宿","yi4xiu3"],
["一審","yi4shen3"],
["一对","yi2dui4"],
["一封","yi4feng1"],
["一尊","yi4zun1"],
["一對","yi2dui4"],
["一小","yi4xiao3"],
["一局","yi4ju2"],
["一层","yi4ceng2"],
["一屆","yi2jie4"],
["一届","yi2jie4"],
["一層","yi4ceng2"],
["一岁","yi2sui4"],
["一工","yi4gong1"],
["一己","yi4ji3"],
["一带","yi2dai4"],
["一帶","yi2dai4"],
["一幅","yi4fu2"],
["一幢","yi4chuang2"],
["一干","yi4gan1"],
["一年","yi4nian2"],
["一并","yi2bing4"],
["一床","yi4chuang2"],
["一应","yi4ying1"],
["一度","yi2du4"],
["一座","yi2zuo4"],
["一式","yi2shi4"],
["一张","yi4zhang1"],
["一張","yi4zhang1"],
["一径","yi2jing4"],
["一律","yi2lv4"],
["一徑","yi2jing4"],
["一得","yi4de2"],
["一從","yi4cong2"],
["一心","yi4xin1"],
["一总","yi4zong3"],
["一息","yi4xi1"],
["一惊","yi4jing1"],
["一意","yi2yi4"],
["一愣","yi2leng4"],
["一應","yi4ying1"],
["一所","yi4suo3"],
["一扇","yi2shan4"],
["一手","yi4shou3"],
["一打","yi4da2"],
["一扣","yi2kou4"],
["一批","yi4pi1"],
["一把","yi4ba3"],
["一折","yi4zhe2"],
["一抹","yi4mo3"],
["一拥","yi4yong1"],
["一拨","yi4bo1"],
["一挺","yi4ting3"],
["一排","yi4pai2"],
["一搭","yi4da1"],
["一撥","yi4bo1"],
["一擁","yi4yong1"],
["一擊","yi4ji1"],
["一支","yi4zhi1"],
["一斑","yi4ban1"],
["一新","yi4xin1"],
["一方","yi4fang1"],
["一旁","yi4pang2"],
["一无","yi4wu2"],
["一旦","yi2dan4"],
["一早","yi4zao3"],
["一时","yi4shi2"],
["一星","yi4xing1"],
["一昨","yi4zuo2"],
["一是","yi2shi4"],
["一時","yi4shi2"],
["一晃","yi2huang4"],
["一晌","yi4shang3"],
["一曲","yi4qu3"],
["一會","yi2hui4"],
["一服","yi4fu2"],
["一朝","yi4zhao1"],
["一本","yi4ben3"],
["一朵","yi4duo3"],
["一杆","yi4gan3"],
["一束","yi2shu4"],
["一条","yi4tiao2"],
["一来","yi4lai2"],
["一杯","yi4bei1"],
["一枚","yi4mei2"],
["一枝","yi4zhi1"],
["一架","yi2jia4"],
["一栋","yi2dong4"],
["一株","yi4zhu1"],
["一样","yi2yang4"],
["一根","yi4gen1"],
["一档","yi2dang4"],
["一桿","yi4gan3"],
["一條","yi4tiao2"],
["一棟","yi2dong4"],
["一棵","yi4ke1"],
["一楼","yi4lou2"],
["一榀","yi4pin3"],
["一概","yi2gai4"],
["一榜","yi4bang3"],
["一樓","yi4lou2"],
["一樘","yi4tang2"],
["一樣","yi2yang4"],
["一檔","yi2dang4"],
["一次","yi2ci4"],
["一歇","yi4xie1"],
["一步","yi2bu4"],
["一歲","yi2sui4"],
["一段","yi2duan4"],
["一毛","yi4mao2"],
["一毫","yi4hao2"],
["一气","yi2qi4"],
["一氣","yi2qi4"],
["一汪","yi4wang1"],
["一泡","yi4pao1"],
["一流","yi4liu2"],
["一準","yi4zhun3"],
["一溜","yi2liu4"],
["一点","yi4dian3"],
["一無","yi4wu2"],
["一片","yi2pian4"],
["一班","yi4ban1"],
["一理","yi4li3"],
["一瓶","yi4ping2"],
["一生","yi4sheng1"],
["一甬","yi4yong3"],
["一畝","yi4mu3"],
["一番","yi4fan1"],
["一發","yi4fa1"],
["一百","yi4bai3"],
["一盏","yi4zhan3"],
["一盘","yi4pan2"],
["一盞","yi4zhan3"],
["一盤","yi4pan2"],
["一直","yi4zhi2"],
["一眼","yi4yan3"],
["一瞥","yi4pie1"],
["一瞬","yi2shun4"],
["一碗","yi4wan3"],
["一碧","yi2bi4"],
["一秋","yi4qiu1"],
["一种","yi4zhong3"],
["一秘","yi2mi4"],
["一程","yi4cheng2"],
["一種","yi4zhong3"],
["一空","yi4kong1"],
["一章","yi4zhang1"],
["一端","yi4duan1"],
["一笔","yi4bi3"],
["一筆","yi4bi3"],
["一等","yi4deng3"],
["一筹","yi4chou2"],
["一箇","yi2ge4"],
["一算","yi2suan4"],
["一節","yi4jie2"],
["一篇","yi4pian1"],
["一簇","yi2cu4"],
["一籌","yi4chou2"],
["一米","yi4mi3"],
["一类","yi2lei4"],
["一粒","yi2li4"],
["一粟","yi2su4"],
["一紀","yi2ji4"],
["一級","yi4ji2"],
["一絕","yi4jue2"],
["一絞","yi4jiao3"],
["一統","yi4tong3"],
["一經","yi4jing1"],
["一維","yi4wei2"],
["一線","yi2xian4"],
["一總","yi4zong3"],
["一级","yi4ji2"],
["一纪","yi2ji4"],
["一线","yi2xian4"],
["一经","yi4jing1"],
["一绝","yi4jue2"],
["一绞","yi4jiao3"],
["一统","yi4tong3"],
["一维","yi4wei2"],
["一缸","yi4gang1"],
["一群","yi4qun2"],
["一義","yi2yi4"],
["一聲","yi4sheng1"],
["一聽","yi4ting1"],
["一股","yi4gu3"],
["一胎","yi4tai1"],
["一脸","yi4lian3"],
["一腔","yi4qiang1"],
["一臉","yi4lian3"],
["一自","yi2zi4"],
["一至","yi2zhi4"],
["一致","yi2zhi4"],
["一臺","yi4tai2"],
["一舉","yi4ju3"],
["一般","yi4ban1"],
["一艘","yi4sou1"],
["一色","yi4shai3"],
["一节","yi4jie2"],
["一若","yi2ruo4"],
["一萬","yi2wan4"],
["一處","yi2chu4"],
["一號","yi2hao4"],
["一行","yi4xing2"],
["一袭","yi4xi2"],
["一襲","yi4xi2"],
["一覽","yi4lan3"],
["一览","yi4lan3"],
["一角","yi4jiao3"],
["一言","yi4yan2"],
["一語","yi4yu3"],
["一說","yi4shuo1"],
["一誰","yi4shui2"],
["一讀","yi4du2"],
["一语","yi4yu3"],
["一说","yi4shuo1"],
["一读","yi4du2"],
["一谁","yi4shui2"],
["一貫","yi2guan4"],
["一贯","yi2guan4"],
["一起","yi4qi3"],
["一趟","yi2tang4"],
["一路","yi2lu4"],
["一跳","yi2tiao4"],
["一身","yi4shen1"],
["一輛","yi2liang4"],
["一輪","yi4lun2"],
["一轮","yi4lun2"],
["一辆","yi2liang4"],
["一边","yi4bian1"],
["一这","yi2zhe4"],
["一连","yi4lian2"],
["一這","yi2zhe4"],
["一連","yi4lian2"],
["一遍","yi2bian4"],
["一道","yi2dao4"],
["一遭","yi4zao1"],
["一邊","yi4bian1"],
["一那","yi2na4"],
["一部","yi2bu4"],
["一門","yi4men2"],
["一間","yi4jian1"],
["一门","yi4men2"],
["一间","yi4jian1"],
["一队","yi2dui4"],
["一阵","yi2zhen4"],
["一阶","yi4jie1"],
["一陣","yi2zhen4"],
["一隅","yi4yu2"],
["一隊","yi2dui4"],
["一階","yi4jie1"],
["一隻","yi4zhi1"],
["一集","yi4ji2"],
["一雙","yi4shuang1"],
["一霎","yi2sha4"],
["一霸","yi2ba4"],
["一面","yi2mian4"],
["一音","yi4yin1"],
["一響","yi4xiang3"],
["一頁","yi2ye4"],
["一頂","yi4ding3"],
["一項","yi2xiang4"],
["一順","yi2shun4"],
["一頓","yi2dun4"],
["一頭","yi4tou2"],
["一顆","yi4ke1"],
["一類","yi2lei4"],
["一页","yi2ye4"],
["一顶","yi4ding3"],
["一项","yi2xiang4"],
["一顺","yi2shun4"],
["一顿","yi2dun4"],
["一颗","yi4ke1"],
["一餐","yi4can1"],
["一首","yi4shou3"],
["一驚","yi4jing1"],
["一體","yi4ti3"],
["一點","yi4dian3"],
["一黨","yi4dang3"],
["一齊","yi4qi2"],
["一齐","yi4qi2"],
["一齣","yi4chu1"],
["一丁点","yi4ding1dian3"],
["一丁點","yi4ding1dian3"],
["一上來","yi2shang4lai2"],
["一上来","yi2shang4lai2"],
["一下儿","yi2xia4r5"],
["一不溜","yi2bu4liu1"],
["一与多","yi4yu3duo1"],
["一世界","yi2shi4jie5"],
["一两只","yi4liang3zhi1"],
["一个个","yi2ge4ge4"],
["一个劲","yi2ge4jin4"],
["一乐也","yi2le4ye3"],
["一些儿","yi4xie1r5"],
["一伙儿","yi4huo3r5"],
["一会儿","yi2hui4r5"],
["一侧化","yi2ce4hua4"],
["一個個","yi2ge4ge4"],
["一個勁","yi2ge4jin4"],
["一側化","yi2ce4hua4"],
["一兩只","yi4liang3zhi1"],
["一准儿","yi4zhun3r5"],
["一刀切","yi4dao1qie1"],
["一分子","yi2fen4zi3"],
["一分錢","yi4fen1qian2"],
["一分钱","yi4fen1qian2"],
["一划拉","yi4hua2la5"],
["一动儿","yi2dong4r5"],
["一劲儿","yi2jin4r5"],
["一勁兒","yi2jin4r5"],
["一勺烩","yi4shao2hui4"],
["一勺燴","yi4shao2hui4"],
["一半儿","yi2ban4r5"],
["一厚块","yi2hou4kuai4"],
["一厚塊","yi2hou4kuai4"],
["一号儿","yi2hao4r5"],
["一后晌","yi2hou4shang3"],
["一嘟絡","yi4du1luo4"],
["一嘟络","yi4du1luo4"],
["一圪堵","yi4ge1du3"],
["一地区","yi2di4qu1"],
["一地區","yi2di4qu1"],
["一地址","yi2di4zhi3"],
["一地裡","yi2di4li5"],
["一地里","yi2di4li5"],
["一场空","yi4chang3kong1"],
["一场雪","yi4chang3xue3"],
["一块儿","yi2kuai4r5"],
["一場空","yi4chang3kong1"],
["一場雪","yi4chang3xue3"],
["一处儿","yi2chu4r5"],
["一多半","yi4duo1ban4"],
["一大些","yi2da4xie1"],
["一大半","yi2da4ban4"],
["一大天","yi2da4tian1"],
["一大早","yi2da4zao3"],
["一大晌","yi2da4shang3"],
["一大趟","yi2da4tang4"],
["一天价","yi4tian1jia5"],
["一天價","yi4tian1jia5"],
["一头儿","yi4tou2r5"],
["一妻制","yi4qi1zhi4"],
["一子儿","yi4zi3r5"],
["一子兒","yi4zi3r5"],
["一字儿","yi2zi4r5"],
["一宗儿","yi4zong1r5"],
["一宠性","yi4chong3xing4"],
["一家儿","yi4jia1r5"],
["一宿儿","yi4xiu3r5"],
["一寵性","yi4chong3xing4"],
["一对儿","yi2dui4r5"],
["一小儿","yi4xiao3r5"],
["一屁股","yi2pi4gu5"],
["一巴掌","yi4ba1zhang5"],
["一席話","yi4xi2hua4"],
["一席談","yi4xi2tan2"],
["一席话","yi4xi2hua4"],
["一席谈","yi4xi2tan2"],
["一帮人","yi4bang1ren2"],
["一幫人","yi4bang1ren2"],
["一弄儿","yi2long4r5"],
["一弄兒","yi2long4r5"],
["一弦琴","yi4xian2qin2"],
["一弹指","yi4tan2zhi3"],
["一彈指","yi4tan2zhi3"],
["一当儿","yi2dang4r5"],
["一後晌","yi2hou4shang3"],
["一忽儿","yi4hu1r5"],
["一忽兒","yi4hu1r5"],
["一忽溜","yi4hu1liu5"],
["一忽見","yi4hu1jian4"],
["一忽见","yi4hu1jian4"],
["一总儿","yi4zong3r5"],
["一愣儿","yi2leng4r5"],
["一手儿","yi4shou3r5"],
["一抹平","yi4ma1ping2"],
["一抿子","yi4min3zi5"],
["一拉平","yi4la1ping2"],
["一招儿","yi4zhao1r5"],
["一招兒","yi4zhao1r5"],
["一拢地","yi4long3di4"],
["一拧头","yi4ning3tou2"],
["一拨儿","yi4bo1r5"],
["一揽子","yi4lan3zi5"],
["一摸黑","yi4mo1hei1"],
["一擰頭","yi4ning3tou2"],
["一攏地","yi4long3di4"],
["一攬子","yi4lan3zi5"],
["一整列","yi4zheng3lie4"],
["一整天","yi4zheng3tian1"],
["一整年","yi4zheng3nian2"],
["一日游","yi2ri4you2"],
["一日热","yi2ri4re4"],
["一日熱","yi2ri4re4"],
["一日量","yi2ri4liang4"],
["一早儿","yi4zao3r5"],
["一早晨","yi4zao3chen2"],
["一星儿","yi4xing1r5"],
["一晃儿","yi2huang4r5"],
["一晌儿","yi4shang3r5"],
["一朵落","yi4duo3luo5"],
["一样儿","yi2yang4r5"],
["一樂也","yi2le4ye3"],
["一死儿","yi4si3r5"],
["一死兒","yi4si3r5"],
["一毫儿","yi4hao2r5"],
["一气儿","yi2qi4r5"],
["一水儿","yi4shui3r5"],
["一水兒","yi4shui3r5"],
["一汤匙","yi4tang1chi2"],
["一汪儿","yi4wang1r5"],
["一清早","yi4qing1zao3"],
["一湯匙","yi4tang1chi2"],
["一溜儿","yi2liu4r5"],
["一满勺","yi4man3shao2"],
["一满匙","yi4man3chi2"],
["一满盘","yi4man3pan2"],
["一满箱","yi4man3xiang1"],
["一滩子","yi4tan1zi5"],
["一滩泥","yi4tan1ni2"],
["一滩滩","yi4tan1tan1"],
["一滿勺","yi4man3shao2"],
["一滿匙","yi4man3chi2"],
["一滿盤","yi4man3pan2"],
["一滿箱","yi4man3xiang1"],
["一灘子","yi4tan1zi5"],
["一灘泥","yi4tan1ni2"],
["一灘灘","yi4tan1tan1"],
["一点儿","yi4dian3r5"],
["一熟制","yi4shu2zhi4"],
["一猛子","yi4meng3zi5"],
["一甲子","yi4jia3zi5"],
["一當兒","yi2dang4r5"],
["一疙堆","yi4ge1dui5"],
["一疙瘩","yi4ge1da5"],
["一眨眼","yi4zha3yan3"],
["一码事","yi4ma3shi4"],
["一码子","yi4ma3zi5"],
["一硫化","yi4liu2hua4"],
["一碼事","yi4ma3shi4"],
["一碼子","yi4ma3zi5"],
["一神会","yi4shen2hui4"],
["一神教","yi4shen2jiao4"],
["一神會","yi4shen2hui4"],
["一神論","yi4shen2lun4"],
["一神论","yi4shen2lun4"],
["一穀倉","yi4gu3cang1"],
["一窍儿","yi2qiao4r5"],
["一窝子","yi4wo1zi5"],
["一窝蜂","yi4wo1feng1"],
["一窩子","yi4wo1zi5"],
["一窩蜂","yi4wo1feng1"],
["一竅兒","yi2qiao4r5"],
["一管笛","yi4guan3di2"],
["一系列","yi2xi4lie4"],
["一縷子","yi4lv3zi5"],
["一缕子","yi4lv3zi5"],
["一罵兒","yi2ma4r5"],
["一肘子","yi4zhou3zi5"],
["一肚子","yi2du4zi5"],
["一股節","yi4gu3jie5"],
["一股节","yi4gu3jie5"],
["一背拉","yi2bei4la5"],
["一脑子","yi4nao3zi5"],
["一脚踢","yi4jiao3ti1"],
["一腦子","yi4nao3zi5"],
["一腳踢","yi4jiao3ti1"],
["一與多","yi4yu3duo1"],
["一色儿","yi4shai3r5"],
["一薄层","yi4bao2ceng2"],
["一薄層","yi4bao2ceng2"],
["一行儿","yi4hang2r5"],
["一行兒","yi4hang2r5"],
["一谷仓","yi4gu3cang1"],
["一貼藥","yi4tie1yao4"],
["一贴药","yi4tie1yao4"],
["一路儿","yi2lu4r5"],
["一身儿","yi4shen1r5"],
["一輩子","yi2bei4zi5"],
["一轉眼","yi4zhuan3yan3"],
["一转眼","yi4zhuan3yan3"],
["一辈子","yi2bei4zi5"],
["一边倒","yi4bian1dao3"],
["一边儿","yi4bian1r5"],
["一遭儿","yi4zao1r5"],
["一邊倒","yi4bian1dao3"],
["一部分","yi2bu4fen5"],
["一鋪灘","yi2pu4tan1"],
["一鍋煮","yi4guo1zhu3"],
["一鍋端","yi4guo1duan1"],
["一鍋粥","yi4guo1zhou1"],
["一铺滩","yi2pu4tan1"],
["一锅煮","yi4guo1zhu3"],
["一锅端","yi4guo1duan1"],
["一锅粥","yi4guo1zhou1"],
["一長制","yi4zhang3zhi4"],
["一长制","yi4zhang3zhi4"],
["一閃念","yi4shan3nian4"],
["一闪念","yi4shan3nian4"],
["一阵儿","yi2zhen4r5"],
["一阶儿","yi4jie1r5"],
["一院制","yi2yuan4zhi4"],
["一零儿","yi4ling2r5"],
["一零兒","yi4ling2r5"],
["一面倒","yi2mian4dao3"],
["一面儿","yi2mian4r5"],
["一顺儿","yi2shun4r5"],
["一風吹","yi4feng1chui1"],
["一风吹","yi4feng1chui1"],
["一骂儿","yi2ma4r5"],
["一骨碌","yi4gu1lu5"],
["一骨節","yi4gu3jie2"],
["一骨节","yi4gu3jie2"],
["一骨輪","yi4gu3lun2"],
["一骨轮","yi4gu3lun2"],
["一一如命","yi4yi4ru2ming4"],
["一一对应","yi4yi2dui4ying4"],
["一一對應","yi4yi2dui4ying4"],
["一丁不識","yi4ding1bu4shi2"],
["一丁不识","yi4ding1bu4shi2"],
["一丁星儿","yi4ding1xing1r5"],
["一丁星兒","yi4ding1xing1r5"],
["一丁点儿","yi4ding1dian3r5"],
["一上一下","yi2shang4yi2xia4"],
["一上手儿","yi2shang4shou3r5"],
["一上手兒","yi2shang4shou3r5"],
["一不可再","yi2bu4ke3zai4"],
["一专多能","yi4zhuan1duo1neng2"],
["一丘之貉","yi4qiu1zhi1he2"],
["一丛翠竹","yi4cong2cui4zhu2"],
["一丝一毫","yi4si1yi4hao2"],
["一丝不差","yi4si1bu2cha4"],
["一丝不挂","yi4si1bu2gua4"],
["一丝不苟","yi4si1bu4gou3"],
["一丝不错","yi4si1bu2cuo4"],
["一丝愁云","yi4si1chou2yun2"],
["一丝春意","yi4si1chun1yi4"],
["一丝笑意","yi4si1xiao4yi4"],
["一丟丟兒","yi4diu1diu1r5"],
["一丟就忘","yi4diu1jiu4wang4"],
["一丟點兒","yi4diu1dian3r5"],
["一丢丢儿","yi4diu1diu1r5"],
["一丢就忘","yi4diu1jiu4wang4"],
["一丢点儿","yi4diu1dian3r5"],
["一个个儿","yi2ge4ge4r5"],
["一个劲儿","yi2ge4jin4r5"],
["一个过儿","yi2ge4guo4r5"],
["一中一台","yi4zhong1yi4tai2"],
["一中一臺","yi4zhong1yi4tai2"],
["一中原则","yi4zhong1yuan2ze2"],
["一中原則","yi4zhong1yuan2ze2"],
["一举两得","yi4ju3liang3de2"],
["一举多得","yi4ju3duo1de2"],
["一举得男","yi4ju3de2nan2"],
["一之为甚","yi4zhi1wei2shen4"],
["一之為甚","yi4zhi1wei2shen4"],
["一之謂甚","yi4zhi1wei4shen4"],
["一之谓甚","yi4zhi1wei4shen4"],
["一乾二凈","yi4gan1er4jing4"],
["一了百了","yi4liao3bai3liao3"],
["一争短长","yi4zheng1duan3chang2"],
["一五一十","yi4wu3yi4shi2"],
["一些个人","yi4xie1ge5ren2"],
["一些個人","yi4xie1ge5ren2"],
["一亲芳泽","yi4qin1fang1ze2"],
["一人一票","yi4ren2yi2piao4"],
["一仆二主","yi4pu2er4zhu3"],
["一介书生","yi2jie4shu1sheng1"],
["一介寒儒","yi2jie4han2ru2"],
["一介書生","yi2jie4shu1sheng1"],
["一介武夫","yi2jie4wu3fu1"],
["一代宗匠","yi2dai4zong1jiang4"],
["一以抵十","yi4yi3di3shi2"],
["一以抵百","yi4yi3di3bai3"],
["一以貫之","yi4yi3guan4zhi1"],
["一以贯之","yi4yi3guan4zhi1"],
["一会儿见","yi4hui3r5jian4"],
["一來一往","yi4lai2yi4wang3"],
["一侧优势","yi2ce4you1shi4"],
["一個過兒","yi2ge4guo4r5"],
["一倾积愫","yi4qing1ji1su4"],
["一做就錯","yi2zuo4jiu4cuo4"],
["一做就错","yi2zuo4jiu4cuo4"],
["一側優勢","yi2ce4you1shi4"],
["一傅众咻","yi2fu4zhong4xiu1"],
["一傅眾咻","yi2fu4zhong4xiu1"],
["一傾積愫","yi4qing1ji1su4"],
["一僕二主","yi4pu2er4zhu3"],
["一兵多用","yi4bing1duo1yong4"],
["一兵多能","yi4bing1duo1neng2"],
["一决雌雄","yi4jue2ci2xiong2"],
["一冷一热","yi4leng3yi2re4"],
["一冷一熱","yi4leng3yi2re4"],
["一刀两断","yi4dao1liang3duan4"],
["一刀兩斷","yi4dao1liang3duan4"],
["一分为二","yi4fen1wei2er4"],
["一分收穫","yi4fen1shou1huo4"],
["一分收获","yi4fen1shou1huo4"],
["一分為二","yi4fen1wei2er4"],
["一分耕耘","yi4fen1geng1yun2"],
["一剁两段","yi2duo4liang3duan4"],
["一剁兩段","yi2duo4liang3duan4"],
["一劳永逸","yi4lao2yong3yi4"],
["一勞永逸","yi4lao2yong3yi4"],
["一匡天下","yi4kuang1tian1xia4"],
["一卵双生","yi4luan3shuang1sheng1"],
["一卵双胞","yi4luan3shuang1bao1"],
["一卵孪生","yi4luan3luan2sheng1"],
["一卵孿生","yi4luan3luan2sheng1"],
["一卵雙生","yi4luan3shuang1sheng1"],
["一卵雙胞","yi4luan3shuang1bao1"],
["一厢情愿","yi4xiang1qing2yuan4"],
["一去不回","yi2qu4bu4hui2"],
["一去不返","yi2qu4bu4fan3"],
["一发千钧","yi2fa4qian1jun1"],
["一叙衷曲","yi2xu4zhong1qu3"],
["一叠卡片","yi4die2ka3pian4"],
["一叢翠竹","yi4cong2cui4zhu2"],
["一口气儿","yi4kou3qi4r5"],
["一口答应","yi4kou3da2ying5"],
["一口答應","yi4kou3da2ying5"],
["一叫就到","yi2jiao4jiu4dao4"],
["一叶扁舟","yi2ye4pian1zhou1"],
["一叶知秋","yi2ye4zhi1qiu1"],
["一叶蔽目","yi2ye4bi4mu4"],
["一叶障目","yi2ye4zhang4mu4"],
["一吐为快","yi4tu3wei2kuai4"],
["一吐心声","yi4tu3xin1sheng1"],
["一吐心聲","yi4tu3xin1sheng1"],
["一吐為快","yi4tu3wei2kuai4"],
["一味盲干","yi2wei4mang2gan4"],
["一呼百应","yi4hu1bai3ying4"],
["一呼百應","yi4hu1bai3ying4"],
["一呼百諾","yi4hu1bai3nuo4"],
["一呼百诺","yi4hu1bai3nuo4"],
["一品之官","yi4pin3zhi5guan1"],
["一品夫人","yi4pin3fu1ren2"],
["一哄而上","yi4hong1er2shang4"],
["一哄而出","yi4hong1er2chu1"],
["一哄而散","yi4hong1er2san4"],
["一哄而起","yi4hong1er2qi3"],
["一哨人馬","yi2shao4ren2ma3"],
["一哨人马","yi2shao4ren2ma3"],
["一唱一和","yi2chang4yi2he4"],
["一唱三叹","yi2chang4san1tan4"],
["一唱三嘆","yi2chang4san1tan4"],
["一問一答","yi2wen4yi4da2"],
["一团和气","yi4tuan2he2qi4"],
["一国三公","yi4guo2san1gong1"],
["一国两制","yi4guo2liang3zhi4"],
["一國三公","yi4guo2san1gong1"],
["一國兩制","yi4guo2liang3zhi4"],
["一團和氣","yi4tuan2he2qi4"],
["一场好梦","yi4chang3hao3meng4"],
["一场恶梦","yi4chang3e4meng4"],
["一场春梦","yi4chang3chun1meng4"],
["一场虚惊","yi4chang3xu1jing1"],
["一块堆儿","yi2kuai4dui1r5"],
["一場好夢","yi4chang3hao3meng4"],
["一場惡夢","yi4chang3e4meng4"],
["一場春夢","yi4chang3chun1meng4"],
["一場虛驚","yi4chang3xu1jing1"],
["一塌刮子","yi4ta1gua1zi5"],
["一塌糊塗","yi4ta1hu2tu5"],
["一塌糊涂","yi4ta1hu2tu5"],
["一塵不染","yi4chen2bu4ran3"],
["一墙之隔","yi4qiang2zhi1ge2"],
["一夔已足","yi4kui2yi3zu2"],
["一夕数惊","yi4xi1shu4jing1"],
["一夕數驚","yi4xi1shu4jing1"],
["一多再多","yi4duo1zai4duo1"],
["一多对应","yi4duo1dui4ying4"],
["一多對應","yi4duo1dui4ying4"],
["一大二公","yi2da4er4gong1"],
["一大早儿","yi2da4zao3r5"],
["一夫一妻","yi4fu1yi4qi1"],
["一奶同胞","yi4nai3tong2bao1"],
["一妻多夫","yi4qi1duo1fu1"],
["一子双祧","yi4zi3shuang1tiao1"],
["一子雙祧","yi4zi3shuang1tiao1"],
["一孔之見","yi4kong3zhi1jian4"],
["一孔之见","yi4kong3zhi1jian4"],
["一字一板","yi2zi4yi4ban3"],
["一字一泪","yi2zi4yi2lei4"],
["一字一淚","yi2zi4yi2lei4"],
["一字一珠","yi2zi4yi4zhu1"],
["一字不識","yi2zi4bu4shi2"],
["一字不识","yi2zi4bu4shi2"],
["一字之差","yi2zi4zhi1cha1"],
["一存一亡","yi4cun2yi4wang2"],
["一官半职","yi4guan1ban4zhi2"],
["一官半職","yi4guan1ban4zhi2"],
["一宠性儿","yi4chong3xing4r5"],
["一寒如此","yi4han2ru2ci3"],
["一寸丹心","yi2cun4dan1xin1"],
["一專多能","yi4zhuan1duo1neng2"],
["一小阵儿","yi4xiao3zhen4r5"],
["一尘不染","yi4chen2bu4ran3"],
["一屁股臊","yi2pi4gu5sao1"],
["一屋子人","yi4wu1zi5ren2"],
["一山一水","yi4shan1yi4shui3"],
["一山一石","yi4shan1yi4shi2"],
["一山之隔","yi4shan1zhi1ge2"],
["一差二錯","yi4cha1er4cuo4"],
["一差二错","yi4cha1er4cuo4"],
["一市八街","yi2shi4ba1jie1"],
["一帆風順","yi4fan1feng1shun4"],
["一帆风顺","yi4fan1feng1shun4"],
["一席之地","yi4xi2zhi1di4"],
["一干到底","yi2gan4dao4di3"],
["一平二調","yi4ping2er4diao4"],
["一平二调","yi4ping2er4diao4"],
["一平如鏡","yi4ping2ru2jing4"],
["一平如镜","yi4ping2ru2jing4"],
["一年半載","yi4nian2ban4zai3"],
["一年半载","yi4nian2ban4zai3"],
["一幹到底","yi2gan4dao4di3"],
["一廂情願","yi4xiang1qing2yuan4"],
["一张一弛","yi4zhang1yi4chi2"],
["一弯新月","yi4wan1xin1yue4"],
["一張一弛","yi4zhang1yi4chi2"],
["一彎新月","yi4wan1xin1yue4"],
["一往情深","yi4wang3qing2shen1"],
["一往无前","yi4wang3wu2qian2"],
["一往無前","yi4wang3wu2qian2"],
["一往直前","yi4wang3zhi2qian2"],
["一得一失","yi4de2yi4shi1"],
["一德一心","yi4de2yi4xin1"],
["一心一德","yi4xin1yi4de2"],
["一忍再忍","yi4ren3zai4ren3"],
["一念之差","yi2nian4zhi1cha1"],
["一念之誠","yi2nian4zhi1cheng2"],
["一念之诚","yi2nian4zhi1cheng2"],
["一怒而去","yi2nu4er2qu4"],
["一息奄奄","yi4xi1yan3yan3"],
["一愁莫展","yi4chou2mo4zhan3"],
["一成一旅","yi4cheng2yi4lv3"],
["一成不变","yi4cheng2bu2bian4"],
["一成不變","yi4cheng2bu2bian4"],
["一战而胜","yi2zhan4er2sheng4"],
["一戰而勝","yi2zhan4er2sheng4"],
["一戳就穿","yi4chuo1jiu4chuan1"],
["一戶住宅","yi2hu4zhu4zhai2"],
["一户住宅","yi2hu4zhu4zhai2"],
["一房一厅","yi4fang2yi4ting1"],
["一房一廳","yi4fang2yi4ting1"],
["一打一拉","yi4da3yi4la1"],
["一打三反","yi4da3san1fan3"],
["一扫而光","yi4sao3er2guang1"],
["一扫而空","yi4sao3er2kong1"],
["一技之長","yi2ji4zhi1chang2"],
["一技之长","yi2ji4zhi1chang2"],
["一抓就灵","yi4zhua1jiu4ling2"],
["一抓就靈","yi4zhua1jiu4ling2"],
["一抔黃土","yi4pou2huang2tu3"],
["一抔黄土","yi4pou2huang2tu3"],
["一抠抠儿","yi4kou1kou1r5"],
["一担儿挑","yi2dan4r5tiao1"],
["一拉溜儿","yi4la1liu4r5"],
["一拉溜兒","yi4la1liu4r5"],
["一拍两散","yi4pai1liang3san4"],
["一拍兩散","yi4pai1liang3san4"],
["一拍即合","yi4pai1ji2he2"],
["一拐一拐","yi4guai3yi4guai3"],
["一招一式","yi4zhao1yi2shi4"],
["一招半式","yi4zhao1ban4shi4"],
["一拳一脚","yi4quan2yi4jiao3"],
["一拳一腳","yi4quan2yi4jiao3"],
["一拼到底","yi4pin1dao4di3"],
["一挥而就","yi4hui1er2jiu4"],
["一损俱损","yi4sun3ju4sun3"],
["一掃而光","yi4sao3er2guang1"],
["一掃而空","yi4sao3er2kong1"],
["一掠而过","yi2lve4er2guo4"],
["一掠而過","yi2lve4er2guo4"],
["一推就倒","yi4tui1jiu4dao3"],
["一掰两开","yi4bai1liang3kai1"],
["一掰兩開","yi4bai1liang3kai1"],
["一掷千金","yi2zhi4qian1jin1"],
["一揮而就","yi4hui1er2jiu4"],
["一損俱損","yi4sun3ju4sun3"],
["一搖一擺","yi4yao2yi4bai3"],
["一摇一摆","yi4yao2yi4bai3"],
["一摳摳兒","yi4kou1kou1r5"],
["一撇一捺","yi4pie3yi2na4"],
["一擔兒挑","yi2dan4r5tiao1"],
["一擲千金","yi2zhi4qian1jin1"],
["一改故轍","yi4gai3gu4zhe2"],
["一改故辙","yi4gai3gu4zhe2"],
["一敗塗地","yi2bai4tu2di4"],
["一敗如水","yi2bai4ru2shui3"],
["一敘衷曲","yi2xu4zhong1qu3"],
["一文一武","yi4wen2yi4wu3"],
["一文不值","yi4wen2bu4zhi2"],
["一文不名","yi4wen2bu4ming2"],
["一文不花","yi4wen2bu4hua1"],
["一无所长","yi4wu2suo3chang2"],
["一日三秋","yi2ri4san1qiu1"],
["一日三餐","yi2ri4san1can1"],
["一日之長","yi2ri4zhi1chang2"],
["一日之长","yi2ri4zhi1chang2"],
["一日之雅","yi2ri4zhi1ya3"],
["一日九迁","yi2ri4jiu3qian1"],
["一日九遷","yi2ri4jiu3qian1"],
["一日千里","yi2ri4qian1li3"],
["一日数惊","yi2ri4shu4jing1"],
["一日数起","yi2ri4shu4qi3"],
["一日數起","yi2ri4shu4qi3"],
["一日數驚","yi2ri4shu4jing1"],
["一明两暗","yi4ming2liang3an4"],
["一明兩暗","yi4ming2liang3an4"],
["一星星儿","yi4xing1xing1r5"],
["一显身手","yi4xian3shen1shou3"],
["一暴十寒","yi2pu4shi2han2"],
["一曝十寒","yi2pu4shi2han2"],
["一會兒見","yi4hui3r5jian4"],
["一望无垠","yi2wang4wu2yin2"],
["一望无边","yi2wang4wu2bian1"],
["一望无际","yi2wang4wu2ji4"],
["一望無垠","yi2wang4wu2yin2"],
["一望無邊","yi2wang4wu2bian1"],
["一望無際","yi2wang4wu2ji4"],
["一望而知","yi2wang4er2zhi1"],
["一朝一夕","yi4zhao1yi4xi1"],
["一期工程","yi4qi1gong1cheng2"],
["一期愈合","yi4qi1yu4he2"],
["一木难支","yi2mu4nan2zhi1"],
["一木難支","yi2mu4nan2zhi1"],
["一机多用","yi4ji1duo1yong4"],
["一条藤儿","yi4tiao2teng2r5"],
["一来一往","yi4lai2yi4wang3"],
["一板一眼","yi4ban3yi4yan3"],
["一板三眼","yi4ban3san1yan3"],
["一板正經","yi4ban3zheng4jing1"],
["一板正经","yi4ban3zheng4jing1"],
["一枕黃粱","yi4zhen3huang2liang2"],
["一枕黄粱","yi4zhen3huang2liang2"],
["一枥两骡","yi2li4liang3luo2"],
["一柱擎天","yi2zhu4qing2tian1"],
["一树百获","yi2shu4bai3huo4"],
["一样样价","yi2yang4yang5jia4"],
["一桥飞架","yi4qiao2fei1jia4"],
["一榮俱榮","yi4rong2ju4rong2"],
["一榻横陈","yi2ta4heng2chen2"],
["一榻橫陳","yi2ta4heng2chen2"],
["一模一样","yi4mo2yi2yang4"],
["一模一樣","yi4mo2yi2yang4"],
["一模活脫","yi4mu2huo2tuo1"],
["一模活脱","yi4mu2huo2tuo1"],
["一樣樣價","yi2yang4yang5jia4"],
["一樹百獲","yi2shu4bai3huo4"],
["一橋飛架","yi4qiao2fei1jia4"],
["一機多用","yi4ji1duo1yong4"],
["一櫪兩騾","yi2li4liang3luo2"],
["一此为甚","yi4ci3wei2shen4"],
["一此為甚","yi4ci3wei2shen4"],
["一步一印","yi2bu4yi2yin4"],
["一步一挨","yi2bu4yi4ai2"],
["一步一瘸","yi2bu4yi4que2"],
["一步一看","yi2bu4yi2kan4"],
["一步一踱","yi2bu4yi4duo2"],
["一步一顛","yi2bu4yi4dian1"],
["一步一颠","yi2bu4yi4dian1"],
["一步一鬼","yi2bu4yi4gui3"],
["一死了之","yi4si3liao3zhi1"],
["一死百了","yi4si3bai3liao3"],
["一母所生","yi4mu3suo3sheng1"],
["一气呵成","yi2qi4he1cheng2"],
["一氣呵成","yi2qi4he1cheng2"],
["一氧化氮","yi4yang3hua4dan4"],
["一氧化碳","yi4yang3hua4tan4"],
["一氧化鉛","yi4yang3hua4qian1"],
["一氧化铅","yi4yang3hua4qian1"],
["一水之隔","yi4shui3zhi1ge2"],
["一江如練","yi4jiang1ru2lian4"],
["一江如练","yi4jiang1ru2lian4"],
["一汪水儿","yi4wang1shui3r5"],
["一決雌雄","yi4jue2ci2xiong2"],
["一泓清碧","yi4hong2qing1bi4"],
["一泓秋水","yi4hong2qiu1shui3"],
["一波三折","yi4bo1san1zhe2"],
["一波三摺","yi4bo1san1zhe2"],
["一波不兴","yi4bo1bu4xing1"],
["一波不興","yi4bo1bu4xing1"],
["一泻千里","yi2xie4qian1li3"],
["一派大好","yi2pai4da4hao3"],
["一派胡言","yi2pai4hu2yan2"],
["一派謊言","yi2pai4huang3yan2"],
["一派谎言","yi2pai4huang3yan2"],
["一清二楚","yi4qing1er4chu3"],
["一清二白","yi4qing1er4bai2"],
["一清早儿","yi4qing1zao3r5"],
["一溜烟儿","yi2liu4yan1r5"],
["一滴滴儿","yi4di1di1r5"],
["一滴滴兒","yi4di1di1r5"],
["一潭死水","yi4tan2si3shui3"],
["一瀉千里","yi2xie4qian1li3"],
["一灯如豆","yi4deng1ru2dou4"],
["一灵真性","yi4ling2zhen1xing4"],
["一炮打响","yi2pao4da3xiang3"],
["一炮打響","yi2pao4da3xiang3"],
["一炮而紅","yi2pao4er2hong2"],
["一炮而红","yi2pao4er2hong2"],
["一点一滴","yi4dian3yi4di1"],
["一無所長","yi4wu2suo3chang2"],
["一燈如豆","yi4deng1ru2dou4"],
["一爭短長","yi4zheng1duan3chang2"],
["一牆之隔","yi4qiang2zhi1ge2"],
["一狐之腋","yi4hu2zhi1ye4"],
["一猜就中","yi4cai1jiu4zhong4"],
["一琴一鶴","yi4qin2yi2he4"],
["一琴一鹤","yi4qin2yi2he4"],
["一男半女","yi4nan2ban4nv3"],
["一疊卡片","yi4die2ka3pian4"],
["一病不起","yi2bing4bu4qi3"],
["一病身亡","yi2bing4shen1wang2"],
["一瘸一拐","yi4que2yi4guai3"],
["一百成儿","yi4bai3cheng2r5"],
["一目了然","yi2mu4liao3ran2"],
["一目十行","yi2mu4shi2hang2"],
["一目瞭然","yi2mu4liao4ran2"],
["一相情愿","yi4xiang1qing2yuan4"],
["一相情願","yi4xiang1qing2yuan4"],
["一看二帮","yi2kan4er4bang1"],
["一看二幫","yi2kan4er4bang1"],
["一看就懂","yi2kan4jiu4dong3"],
["一眨眼儿","yi4zha3yan3r5"],
["一瞑不視","yi4ming2bu2shi4"],
["一瞑不视","yi4ming2bu2shi4"],
["一瞻風采","yi4zhan1feng1cai3"],
["一瞻风采","yi4zhan1feng1cai3"],
["一矢之地","yi4shi3zhi1di4"],
["一知半解","yi4zhi1ban4jie3"],
["一石两鸟","yi4shi2liang3niao3"],
["一石二鳥","yi4shi2er4niao3"],
["一石二鸟","yi4shi2er4niao3"],
["一石兩鳥","yi4shi2liang3niao3"],
["一码儿新","yi4ma3r5xin1"],
["一砍两半","yi4kan3liang3ban4"],
["一砍兩半","yi4kan3liang3ban4"],
["一砖一瓦","yi4zhuan1yi4wa3"],
["一碼兒新","yi4ma3r5xin1"],
["一磚一瓦","yi4zhuan1yi4wa3"],
["一票到底","yi2piao4dao4di3"],
["一秉至公","yi4bing3zhi4gong1"],
["一秉虔誠","yi4bing3qian2cheng2"],
["一秉虔诚","yi4bing3qian2cheng2"],
["一穷二白","yi4qiong2er4bai2"],
["一窍不通","yi2qiao4bu4tong1"],
["一窝风吹","yi4wo1feng1chui1"],
["一窥全豹","yi4kui1quan2bao4"],
["一窩風吹","yi4wo1feng1chui1"],
["一窮二白","yi4qiong2er4bai2"],
["一窺全豹","yi4kui1quan2bao4"],
["一竅不通","yi2qiao4bu4tong1"],
["一竿到底","yi4gan1dao4di3"],
["一笑了之","yi2xiao4liao3zhi1"],
["一笑作答","yi2xiao4zuo4da2"],
["一笑倾城","yi2xiao4qing1cheng2"],
["一笑傾城","yi2xiao4qing1cheng2"],
["一笑千金","yi2xiao4qian1jin1"],
["一笑置之","yi2xiao4zhi4zhi1"],
["一笑而去","yi2xiao4er2qu4"],
["一笑頓釋","yi2xiao4dun4shi4"],
["一笑顿释","yi2xiao4dun4shi4"],
["一笔一划","yi4bi3yi2hua4"],
["一筆一劃","yi4bi3yi2hua4"],
["一箭中鵠","yi2jian4zhong4gu3"],
["一箭中鹄","yi2jian4zhong4gu3"],
["一箭之仇","yi2jian4zhi1chou2"],
["一箭之地","yi2jian4zhi1di4"],
["一箭之遙","yi2jian4zhi1yao2"],
["一箭之遥","yi2jian4zhi1yao2"],
["一箭双雕","yi2jian4shuang1diao1"],
["一箭双鵰","yi2jian4shuang1diao1"],
["一箭雙雕","yi2jian4shuang1diao1"],
["一箭雙鵰","yi2jian4shuang1diao1"],
["一篑之功","yi2kui4zhi1gong1"],
["一簣之功","yi2kui4zhi1gong1"],
["一粥一飯","yi4zhou1yi2fan4"],
["一粥一饭","yi4zhou1yi2fan4"],
["一紙休書","yi4zhi3xiu1shu1"],
["一紙具文","yi4zhi3ju4wen2"],
["一紙空文","yi4zhi3kong1wen2"],
["一索得男","yi4suo3de2nan2"],
["一絲一毫","yi4si1yi4hao2"],
["一絲不差","yi4si1bu2cha4"],
["一絲不掛","yi4si1bu2gua4"],
["一絲不苟","yi4si1bu4gou3"],
["一絲不錯","yi4si1bu2cuo4"],
["一絲愁雲","yi4si1chou2yun2"],
["一絲春意","yi4si1chun1yi4"],
["一絲笑意","yi4si1xiao4yi4"],
["一網打盡","yi4wang3da3jin4"],
["一綹假髮","yi4liu3jia3fa4"],
["一綹青絲","yi4liu3qing1si1"],
["一綹頭髮","yi4liu3tou2fa5"],
["一縷幽香","yi4lv3you1xiang1"],
["一縷青煙","yi4lv3qing1yan1"],
["一縷頭髮","yi4lv3tou2fa5"],
["一纸休书","yi4zhi3xiu1shu1"],
["一纸具文","yi4zhi3ju4wen2"],
["一纸空文","yi4zhi3kong1wen2"],
["一绺假发","yi4liu3jia3fa4"],
["一绺头发","yi4liu3tou2fa5"],
["一绺青丝","yi4liu3qing1si1"],
["一缕头发","yi4lv3tou2fa5"],
["一缕幽香","yi4lv3you1xiang1"],
["一缕青烟","yi4lv3qing1yan1"],
["一缰四马","yi4jiang1si4ma3"],
["一网打尽","yi4wang3da3jin4"],
["一聆妙音","yi4ling2miao4yin1"],
["一股劲儿","yi4gu3jin4r5"],
["一股气儿","yi4gu3qi4r5"],
["一胎三兒","yi4tai1san1er2"],
["一胎三子","yi4tai1san1zi3"],
["一胡捋儿","yi4hu2luo1r5"],
["一脈相傳","yi2mai4xiang1chuan2"],
["一脈相承","yi2mai4xiang1cheng2"],
["一脈相通","yi2mai4xiang1tong1"],
["一脈相連","yi2mai4xiang1lian2"],
["一脉相传","yi2mai4xiang1chuan2"],
["一脉相承","yi2mai4xiang1cheng2"],
["一脉相连","yi2mai4xiang1lian2"],
["一脉相通","yi2mai4xiang1tong1"],
["一脖子拐","yi4bo2zi5guai3"],
["一脸死相","yi4lian3si3xiang4"],
["一脸疙瘩","yi4lian3ge1da1"],
["一臂之力","yi2bi4zhi1li4"],
["一臉死相","yi4lian3si3xiang4"],
["一臉疙瘩","yi4lian3ge1da1"],
["一臧一否","yi4zang1yi4pi3"],
["一致联系","yi2zhi4lian2xi5"],
["一致聯繫","yi2zhi4lian2xi5"],
["一舉兩得","yi4ju3liang3de2"],
["一舉多得","yi4ju3duo1de2"],
["一舉得男","yi4ju3de2nan2"],
["一花独放","yi4hua1du2fang4"],
["一花獨放","yi4hua1du2fang4"],
["一草一木","yi4cao3yi2mu4"],
["一荣俱荣","yi4rong2ju4rong2"],
["一落千丈","yi2luo4qian1zhang4"],
["一葉扁舟","yi2ye4pian1zhou1"],
["一葉知秋","yi2ye4zhi1qiu1"],
["一葉蔽目","yi2ye4bi4mu4"],
["一葉障目","yi2ye4zhang4mu4"],
["一薰一莸","yi4xun1yi4you2"],
["一薰一蕕","yi4xun1yi4you2"],
["一衣带水","yi4yi1dai4shui3"],
["一衣帶水","yi4yi1dai4shui3"],
["一表非俗","yi4biao3fei1su2"],
["一袋把烟","yi2dai4ba3yan1"],
["一袋把煙","yi2dai4ba3yan1"],
["一裹脑子","yi4guo3nao3zi5"],
["一裹腦子","yi4guo3nao3zi5"],
["一見傾心","yi2jian4qing1xin1"],
["一見喪膽","yi2jian4sang4dan3"],
["一見垂涎","yi2jian4chui2xian2"],
["一見如故","yi2jian4ru2gu4"],
["一見為快","yi2jian4wei2kuai4"],
["一見稱心","yi2jian4chen4xin1"],
["一見鐘情","yi2jian4zhong1qing2"],
["一見高低","yi2jian4gao1di1"],
["一視同仁","yi2shi4tong2ren2"],
["一親芳澤","yi4qin1fang1ze2"],
["一覺醒來","yi2jiao4xing3lai2"],
["一见丧胆","yi2jian4sang4dan3"],
["一见为快","yi2jian4wei2kuai4"],
["一见倾心","yi2jian4qing1xin1"],
["一见垂涎","yi2jian4chui2xian2"],
["一见如故","yi2jian4ru2gu4"],
["一见称心","yi2jian4chen4xin1"],
["一见钟情","yi2jian4zhong1qing2"],
["一见高低","yi2jian4gao1di1"],
["一视同仁","yi2shi4tong2ren2"],
["一觉醒来","yi2jiao4xing3lai2"],
["一触即发","yi2chu4ji2fa1"],
["一触即溃","yi2chu4ji2kui4"],
["一触即爆","yi2chu4ji2bao4"],
["一觸即潰","yi2chu4ji2kui4"],
["一觸即爆","yi2chu4ji2bao4"],
["一觸即發","yi2chu4ji2fa1"],
["一言丧邦","yi4yan2sang1bang1"],
["一言为定","yi4yan2wei2ding4"],
["一言兴邦","yi4yan2xing1bang1"],
["一言喪邦","yi4yan2sang1bang1"],
["一言為定","yi4yan2wei2ding4"],
["一言興邦","yi4yan2xing1bang1"],
["一言難盡","yi4yan2nan2jin4"],
["一記耳光","yi2ji4er3guang1"],
["一詞多義","yi4ci2duo1yi4"],
["一詞多類","yi4ci2duo1lei4"],
["一試身手","yi2shi4shen1shou3"],
["一語破的","yi4yu3po4di4"],
["一誤再誤","yi2wu4zai4wu4"],
["一誤而誤","yi2wu4er2wu4"],
["一諾千金","yi2nuo4qian1jin1"],
["一记耳光","yi2ji4er3guang1"],
["一词多义","yi4ci2duo1yi4"],
["一词多类","yi4ci2duo1lei4"],
["一试身手","yi2shi4shen1shou3"],
["一语破的","yi4yu3po4di4"],
["一误再误","yi2wu4zai4wu4"],
["一误而误","yi2wu4er2wu4"],
["一诺千金","yi2nuo4qian1jin1"],
["一貧如洗","yi4pin2ru2xi3"],
["一败如水","yi2bai4ru2shui3"],
["一败涂地","yi2bai4tu2di4"],
["一贫如洗","yi4pin2ru2xi3"],
["一走了之","yi4zou3liao3zhi1"],
["一跃而下","yi2yue4er2xia4"],
["一跃而起","yi2yue4er2qi3"],
["一跃而过","yi2yue4er2guo4"],
["一跤摔倒","yi4jiao1shuai1dao3"],
["一跨而过","yi2kua4er2guo4"],
["一跨而過","yi2kua4er2guo4"],
["一蹦一跳","yi2beng4yi2tiao4"],
["一蹦三跳","yi2beng4san1tiao4"],
["一蹴而几","yi2cu4er2ji1"],
["一蹴而及","yi2cu4er2ji2"],
["一蹴而就","yi2cu4er2jiu4"],
["一蹴而幾","yi2cu4er2ji1"],
["一蹶不振","yi4jue2bu2zhen4"],
["一躍而下","yi2yue4er2xia4"],
["一躍而起","yi2yue4er2qi3"],
["一躍而過","yi2yue4er2guo4"],
["一身囊揣","yi4shen1nang2chuai4"],
["一較高下","yi4jiao3gao1xia4"],
["一较高下","yi4jiao3gao1xia4"],
["一辞莫赞","yi4ci2mo4zan4"],
["一辭莫贊","yi4ci2mo4zan4"],
["一过就忘","yi2guo4jiu4wang4"],
["一还一报","yi4huan2yi2bao4"],
["一连串儿","yi4lian2chuan4r5"],
["一连数载","yi4lian2shu4zai3"],
["一连气儿","yi4lian2qi4r5"],
["一通文书","yi4tong1wen2shu1"],
["一通文書","yi4tong1wen2shu1"],
["一通百通","yi4tong1bai3tong1"],
["一連數載","yi4lian2shu4zai3"],
["一過就忘","yi2guo4jiu4wang4"],
["一還一報","yi4huan2yi2bao4"],
["一醉方休","yi2zui4fang1xiu1"],
["一釘釘兒","yi4ding1ding1r5"],
["一針一線","yi4zhen1yi2xian4"],
["一針見血","yi4zhen1jian4xie3"],
["一錐之地","yi4zhui1zhi1di4"],
["一錘定音","yi4chui2ding4yin1"],
["一錢不值","yi4qian2bu4zhi2"],
["一錢如命","yi4qian2ru2ming4"],
["一錯再錯","yi2cuo4zai4cuo4"],
["一针一线","yi4zhen1yi2xian4"],
["一针见血","yi4zhen1jian4xie3"],
["一钉钉儿","yi4ding1ding1r5"],
["一钱不值","yi4qian2bu4zhi2"],
["一钱如命","yi4qian2ru2ming4"],
["一错再错","yi2cuo4zai4cuo4"],
["一锤定音","yi4chui2ding4yin1"],
["一锥之地","yi4zhui1zhi1di4"],
["一長兩短","yi4chang2liang3duan3"],
["一长两短","yi4chang2liang3duan3"],
["一閃一閃","yi4shan3yi4shan3"],
["一閃之念","yi4shan3zhi1nian4"],
["一閃而過","yi4shan3er2guo4"],
["一闪一闪","yi4shan3yi4shan3"],
["一闪之念","yi4shan3zhi1nian4"],
["一闪而过","yi4shan3er2guo4"],
["一问一答","yi2wen4yi4da2"],
["一雄多雌","yi4xiong2duo1ci2"],
["一雅一俗","yi4ya3yi4su2"],
["一雌多雄","yi4ci2duo1xiong2"],
["一雨成災","yi4yu3cheng2zai1"],
["一雨成灾","yi4yu3cheng2zai1"],
["一雨成秋","yi4yu3cheng2qiu1"],
["一靈真性","yi4ling2zhen1xing4"],
["一韁四馬","yi4jiang1si4ma3"],
["一顯身手","yi4xian3shen1shou3"],
["一顰一笑","yi4pin2yi2xiao4"],
["一颦一笑","yi4pin2yi2xiao4"],
["一飛沖天","yi4fei1chong1tian1"],
["一飞冲天","yi4fei1chong1tian1"],
["一飯之恩","yi2fan4zhi1en1"],
["一飯千金","yi2fan4qian1jin1"],
["一飲一啄","yi4yin3yi4zhuo2"],
["一飲而盡","yi4yin3er2jin4"],
["一飽眼福","yi4bao3yan3fu2"],
["一饋十起","yi2kui4shi2qi3"],
["一饭之恩","yi2fan4zhi1en1"],
["一饭千金","yi2fan4qian1jin1"],
["一饮一啄","yi4yin3yi4zhuo2"],
["一饮而尽","yi4yin3er2jin4"],
["一饱眼福","yi4bao3yan3fu2"],
["一馈十起","yi2kui4shi2qi3"],
["一馬平川","yi4ma3ping2chuan1"],
["一馬當先","yi4ma3dang1xian1"],
["一马平川","yi4ma3ping2chuan1"],
["一马当先","yi4ma3dang1xian1"],
["一髮千鈞","yi2fa4qian1jun1"],
["一鬍捋兒","yi4hu2luo1r5"],
["一鱗半爪","yi4lin2ban4zhao3"],
["一鳞半爪","yi4lin2ban4zhao3"],
["一鳴驚人","yi4ming2jing1ren2"],
["一鸣惊人","yi4ming2jing1ren2"],
["一點一滴","yi4dian3yi4di1"],
["一鼓作气","yi4gu3zuo4qi4"],
["一鼓作氣","yi4gu3zuo4qi4"],
["一鼓可得","yi4gu3ke3de2"],
["一鼓而下","yi4gu3er2xia4"],
["一鼓而歼","yi4gu3er2jian1"],
["一鼓而殲","yi4gu3er2jian1"],
["一鼓聚歼","yi4gu3ju4jian1"],
["一鼓聚殲","yi4gu3ju4jian1"],
["一鼻子灰","yi4bi2zi5hui1"],
["一龍一蛇","yi4long2yi4she2"],
["一龍一豬","yi4long2yi4zhu1"],
["一龍九種","yi4long2jiu3zhong3"],
["一龙一猪","yi4long2yi4zhu1"],
["一龙一蛇","yi4long2yi4she2"],
["一龙九种","yi4long2jiu3zhong3"],
["一丝一毫儿","yi4si1yi4hao2r5"],
["一个半个儿","yi2ge4ban4ge4r5"],
["一九四九年","yi4jiu3si4jiu3nian2"],
["一会儿工夫","yi2hui4r5gong1fu1"],
["一個半個兒","yi2ge4ban4ge4r5"],
["一分鐘小說","yi4fen1zhong1xiao3shuo1"],
["一分鐘照相","yi4fen1zhong1zhao4xiang4"],
["一分钟小说","yi4fen1zhong1xiao3shuo1"],
["一分钟照相","yi4fen1zhong1zhao4xiang4"],
["一厘钱精神","yi4li2qian2jing1shen2"],
["一去不复返","yi2qu4bu2fu4fan3"],
["一去不復返","yi2qu4bu2fu4fan3"],
["一去无影踪","yi2qu4wu2ying3zong1"],
["一去無影蹤","yi2qu4wu2ying3zong1"],
["一口京片子","yi4kou3jing1pian4zi5"],
["一問三不知","yi2wen4san1bu4zhi1"],
["一善掩百恶","yi2shan4yan3bai3e4"],
["一善掩百惡","yi2shan4yan3bai3e4"],
["一報還一報","yi2bao4huan2yi2bao4"],
["一好遮百丑","yi4hao3zhe1bai3chou3"],
["一好遮百醜","yi4hao3zhe1bai3chou3"],
["一对一对应","yi2dui4yi2dui4ying4"],
["一对一翻译","yi2dui4yi4fan1yi4"],
["一對一對應","yi2dui4yi2dui4ying4"],
["一對一翻譯","yi2dui4yi4fan1yi4"],
["一扑纳心儿","yi4pu1na5xin1r5"],
["一报还一报","yi2bao4huan2yi2bao4"],
["一挡子事儿","yi2dang4zi5shi4r5"],
["一推六二五","yi4tui1liu4er4wu3"],
["一撲納心兒","yi4pu1na5xin1r5"],
["一擋子事兒","yi2dang4zi5shi4r5"],
["一整套技术","yi4zheng3tao4ji4shu4"],
["一整套技術","yi4zheng3tao4ji4shu4"],
["一时半会儿","yi4shi2ban4hui3r5"],
["一时性黑晕","yi4shi2xing4hei1yun4"],
["一星半点儿","yi4xing1ban4dian3r5"],
["一時半會兒","yi4shi2ban4hui3r5"],
["一時性黑暈","yi4shi2xing4hei1yun4"],
["一會兒工夫","yi2hui4r5gong1fu1"],
["一棍子打死","yi2gun4zi5da3si3"],
["一模活脫兒","yi4mo2huo2tuo1r5"],
["一模活脱儿","yi4mo2huo2tuo1r5"],
["一次性削价","yi2ci4xing4xiao1jia4"],
["一次性削價","yi2ci4xing4xiao1jia4"],
["一氧化二氮","yi4yang3hua4er4dan4"],
["一浪接一浪","yi2lang4jie1yi2lang4"],
["一燕不成夏","yi2yan4bu4cheng2xia4"],
["一物降一物","yi2wu4xiang2yi2wu4"],
["一环扣一环","yi4huan2kou4yi4huan2"],
["一環扣一環","yi4huan2kou4yi4huan2"],
["一生日儿多","yi4sheng1ri4r5duo1"],
["一眨巴眼儿","yi4zha3ba5yan3r5"],
["一眨巴眼兒","yi4zha3ba5yan3r5"],
["一眨眯眼儿","yi4zha3mi1yan3r5"],
["一眨眯眼兒","yi4zha3mi1yan3r5"],
["一股热劲儿","yi4gu3re4jin4r5"],
["一茶匙容量","yi4cha2chi2rong2liang4"],
["一釐錢精神","yi4li2qian2jing1shen2"],
["一銃子性兒","yi2chong4zi5xing4r5"],
["一錘子買賣","yi4chui2zi5mai3mai5"],
["一铳子性儿","yi2chong4zi5xing4r5"],
["一锤子买卖","yi4chui2zi5mai3mai5"],
["一问三不知","yi2wen4san1bu4zhi1"],
["一鼻孔出气","yi4bi2kong3chu1qi4"],
["一鼻孔出氣","yi4bi2kong3chu1qi4"],
["一个儿不个儿","yi2ge4r5bu2ge4r5"],
["一举手一投足","yi4ju3shou3yi4tou2zu2"],
["一亩三分地儿","yi4mu3san1fen1di4r5"],
["一個兒不個兒","yi2ge4r5bu2ge4r5"],
["一分錢一分貨","yi4fen1qian2yi4fen1huo4"],
["一分钱一分货","yi4fen1qian2yi4fen1huo4"],
["一动不如一静","yi2dong4bu4ru2yi2jing4"],
["一動不如一靜","yi2dong4bu4ru2yi2jing4"],
["一发不可收拾","yi4fa1bu4ke3shou1shi2"],
["一客不烦二主","yi2ke4bu4fan2er4zhu3"],
["一客不煩二主","yi2ke4bu4fan2er4zhu3"],
["一山难容二虎","yi4shan1nan2rong2er4hu3"],
["一山難容二虎","yi4shan1nan2rong2er4hu3"],
["一招鮮吃遍天","yi4zhao1xian1chi1bian4tian1"],
["一招鮮走遍天","yi4zhao1xian1zou3bian4tian1"],
["一招鲜吃遍天","yi4zhao1xian1chi1bian4tian1"],
["一招鲜走遍天","yi4zhao1xian1zou3bian4tian1"],
["一掬同情之泪","yi4ju1tong2qing2zhi1lei4"],
["一掬同情之淚","yi4ju1tong2qing2zhi1lei4"],
["一步一个脚印","yi2bu4yi2ge4jiao3yin4"],
["一步一個腳印","yi2bu4yi2ge4jiao3yin4"],
["一死以平民愤","yi4si3yi3ping2min2fen4"],
["一死以平民憤","yi4si3yi3ping2min2fen4"],
["一点水一个泡","yi4dian3shui3yi2ge4pao4"],
["一环折全链断","yi4huan2zhe2quan2lian4duan4"],
["一環折全鏈斷","yi4huan2zhe2quan2lian4duan4"],
["一畝三分地兒","yi4mu3san1fen1di4r5"],
["一發不可收拾","yi4fa1bu4ke3shou1shi2"],
["一竿子插到底","yi4gan1zi5cha1dao4di3"],
["一罪不可两治","yi2zui4bu4ke3liang3zhi4"],
["一罪不可兩治","yi2zui4bu4ke3liang3zhi4"],
["一肚子窝囊气","yi2du4zi5wo1nang2qi4"],
["一肚子窩囊氣","yi2du4zi5wo1nang2qi4"],
["一肚子肮脏计","yi2du4zi5ang1zang1ji4"],
["一肚子骯髒計","yi2du4zi5ang1zang1ji4"],
["一脑门子官司","yi4nao3men2zi5guan1si1"],
["一腦門子官司","yi4nao3men2zi5guan1si1"],
["一臣不事二主","yi4chen2bu2shi4er4zhu3"],
["一舉手一投足","yi4ju3shou3yi4tou2zu2"],
["一蟹不如一蟹","yi2xie4bu4ru2yi2xie4"],
["一鞭子乖板子","yi4bian1zi5guai1ban3zi5"],
["一馬不配兩鞍","yi4ma3bu2pei4liang3an1"],
["一马不配两鞍","yi4ma3bu2pei4liang3an1"],
["一點水一個泡","yi4dian3shui3yi2ge4pao4"],
["一人难称百人意","yi4ren2nan2chen4bai3ren2yi4"],
["一人難稱百人意","yi4ren2nan2chen4bai3ren2yi4"],
["一分价钱一分货","yi4fen1jia4qian2yi4fen1huo4"],
["一分價錢一分貨","yi4fen1jia4qian2yi4fen1huo4"],
["一失足成千古恨","yi4shi1zu2cheng2qian1gu3hen4"],
["一寸光阴一寸金","yi2cun4guang1yin1yi2cun4jin1"],
["一寸光陰一寸金","yi2cun4guang1yin1yi2cun4jin1"],
["一将功成万骨枯","yi2jiang4gong1cheng2wan4gu3ku1"],
["一將功成萬骨枯","yi2jiang4gong1cheng2wan4gu3ku1"],
["一日之計在於晨","yi2ri4zhi1ji4zai4yu2chen2"],
["一日之计在于晨","yi2ri4zhi1ji4zai4yu2chen2"],
["一日夫妻百日恩","yi2ri4fu1qi1bai3ri4en1"],
["一日官司十日打","yi2ri4guan1si5shi2ri4da3"],
["一朝天子一朝臣","yi4chao2tian1zi3yi4chao2chen2"],
["一条道儿跑到黑","yi4tiao2dao4r5pao3dao4hei1"],
["一树梨花压海棠","yi2shu4li2hua1ya1hai3tang2"],
["一樹梨花壓海棠","yi2shu4li2hua1ya1hai3tang2"],
["一步一个脚印儿","yi2bu4yi2ge4jiao3yin4r5"],
["一江春水向东流","yi4jiang1chun1shui3xiang4dong1liu2"],
["一江春水向東流","yi4jiang1chun1shui3xiang4dong1liu2"]
],
"丁":[
["丁丑","ding1chou3"],
["丁卯","ding1mao3"],
["丁点","ding1dian3"],
["丁磊","ding1lei3"],
["丁酉","ding1you3"],
["丁點","ding1dian3"],
["丁一卯二","ding1yi4mao3er4"],
["丁一确二","ding1yi2que4er4"],
["丁一確二","ding1yi2que4er4"],
["丁零当啷","ding1ling5dang1lang1"],
["丁零當啷","ding1ling5dang1lang1"]
],
"七":[
["七只","qi1zhi1"],
["七百","qi1bai3"],
["七十子","qi1shi2zi3"],
["七二一大学","qi1er4yi2da4xue2"],
["七二一大學","qi1er4yi2da4xue2"]
],
"万":[
["万古","wan4gu3"],
["万只","wan4zhi1"],
["万有","wan4you3"],
["万里","wan4li3"],
["万事得","wan4shi4de2"],
["万无一失","wan4wu2yi4shi1"],
["万维天罗地网","wan4wei2tian1luo2di4wang3"]
],
"三":[
["三井","san1jing3"],
["三只","san1zhi1"],
["三宝","san1bao3"],
["三寶","san1bao3"],
["三点","san1dian3"],
["三百","san1bai3"],
["三藏","san1zang4"],
["三角","san1jiao3"],
["三重","san1chong2"],
["三點","san1dian3"],
["三一神","san1yi4shen2"],
["三裡屯","san1li3tun2"],
["三裡河","san1li3he2"],
["三部曲","san1bu4qu3"],
["三个代表","san1ge4dai4biao3"],
["三個代表","san1ge4dai4biao3"],
["三号木杆","san1hao4mu4gan1"],
["三地門鄉","san1di4men2xiang1"],
["三地门乡","san1di4men2xiang1"],
["三號木桿","san1hao4mu4gan1"],
["三分之一弱","san1fen1zhi1yi2ruo4"],
["三合一疫苗","san1he2yi2yi4miao2"]
],
"上":[
["上个","shang4ge4"],
["上九","shang4jiu3"],
["上來","shang4lai5"],
["上個","shang4ge4"],
["上午","shang4wu3"],
["上去","shang4qu5"],
["上口","shang4kou3"],
["上古","shang4gu3"],
["上司","shang4si5"],
["上品","shang4pin3"],
["上地","shang4di4"],
["上场","shang4chang3"],
["上場","shang4chang3"],
["上声","shang3sheng1"],
["上头","shang4tou5"],
["上好","shang4hao3"],
["上将","shang4jiang4"],
["上將","shang4jiang4"],
["上当","shang4dang4"],
["上手","shang4shou3"],
["上指","shang4zhi3"],
["上杆","shang4gan3"],
["上来","shang4lai5"],
["上桿","shang4gan3"],
["上水","shang4shui3"],
["上海","shang4hai3"],
["上涨","shang4zhang3"],
["上演","shang4yan3"],
["上漲","shang4zhang3"],
["上火","shang4huo3"],
["上當","shang4dang4"],
["上瘾","shang4yin3"],
["上癮","shang4yin3"],
["上相","shang4xiang4"],
["上睑","shang4jian3"],
["上瞼","shang4jian3"],
["上礼","shang4li3"],
["上禮","shang4li3"],
["上等","shang4deng3"],
["上網","shang4wang3"],
["上网","shang4wang3"],
["上聲","shang3sheng1"],
["上表","shang4biao3"],
["上訴","shang4su4"],
["上調","shang4tiao2"],
["上诉","shang4su4"],
["上调","shang4tiao2"],
["上边","shang4bian5"],
["上邊","shang4bian5"],
["上野","shang4ye3"],
["上錶","shang4biao3"],
["上面","shang4mian5"],
["上頭","shang4tou5"],
["上馬","shang4ma3"],
["上马","shang4ma3"],
["上齒","shang4chi3"],
["上齿","shang4chi3"],
["上不上","shang4bu5shang4"],
["上不了","shang4bu5liao3"],
["上不來","shang4bu5lai2"],
["上不去","shang4bu5qu4"],
["上不成","shang4bu5cheng2"],
["上不来","shang4bu5lai2"],
["上不起","shang4bu5qi3"],
["上个月","shang4ge5yue4"],
["上個月","shang4ge5yue4"],
["上边儿","shang4bian5r5"]
],
"下":[
["下体","xia4ti3"],
["下來","xia4lai5"],
["下保","xia4bao3"],
["下午","xia4wu3"],
["下去","xia4qu5"],
["下品","xia4pin3"],
["下地","xia4di4"],
["下场","xia4chang3"],
["下場","xia4chang3"],
["下头","xia4tou5"],
["下属","xia4shu3"],
["下屬","xia4shu3"],
["下岗","xia4gang3"],
["下崗","xia4gang3"],
["下手","xia4shou3"],
["下把","xia4ba3"],
["下来","xia4lai5"],
["下水","xia4shui3"],
["下海","xia4hai3"],
["下笔","xia4bi3"],
["下筆","xia4bi3"],
["下等","xia4deng3"],
["下網","xia4wang3"],
["下网","xia4wang3"],
["下走","xia4zou3"],
["下边","xia4bian5"],
["下邊","xia4bian5"],
["下野","xia4ye3"],
["下雨","xia4yu3"],
["下雪","xia4xue3"],
["下面","xia4mian5"],
["下頭","xia4tou5"],
["下馬","xia4ma3"],
["下马","xia4ma3"],
["下體","xia4ti3"],
["下齒","xia4chi3"],
["下齿","xia4chi3"],
["下不了","xia4bu5liao3"],
["下不來","xia4bu5lai2"],
["下不去","xia4bu5qu4"],
["下不来","xia4bu5lai2"],
["下个月","xia4ge4yue4"],
["下個月","xia4ge4yue4"],
["下边儿","xia4bian5r5"],
["下个星期","xia4ge4xing1qi1"],
["下個星期","xia4ge4xing1qi1"],
["下面請看","xia4mian4qing3kan4"],
["下面请看","xia4mian4qing3kan4"]
],
"不":[
["不㐄","bu2kua4"],
["不㐌","bu2si4"],
["不㐖","bu2ye4"],
["不㐡","bu2nuo4"],
["不㐨","bu2xu4"],
["不㐰","bu2xin4"],
["不㐲","bu2dai4"],
["不㐳","bu2wu4"],
["不㐸","bu2qian4"],
["不㐹","bu2yi4"],
["不㐺","bu2zhong4"],
["不㐼","bu2cheng4"],
["不㑅","bu2zuo4"],
["不㑇","bu2zhou4"],
["不㑈","bu2dong4"],
["不㑉","bu2su4"],
["不㑊","bu2yi4"],
["不㑋","bu2jiong4"],
["不㑏","bu2zhu4"],
["不㑘","bu2jie4"],
["不㑛","bu2su4"],
["不㑜","bu2yi4"],
["不㑝","bu2long4"],
["不㑞","bu2ying4"],
["不㑥","bu2yi4"],
["不㑦","bu2li4"],
["不㑧","bu2ji4"],
["不㑰","bu2hui4"],
["不㑳","bu2zhou4"],
["不㑵","bu2han4"],
["不㑶","bu2xi4"],
["不㑷","bu2tai4"],
["不㑹","bu2hui4"],
["不㑺","bu2jun4"],
["不㑻","bu2ma4"],
["不㑼","bu2lve4"],
["不㒂","bu2ku4"],
["不㒃","bu2er4"],
["不㒄","bu2nang4"],
["不㒆","bu2chi4"],
["不㒇","bu2mu4"],
["不㒈","bu2han4"],
["不㒊","bu2se4"],
["不㒑","bu2hui4"],
["不㒓","bu2ta4"],
["不㒛","bu2diao4"],
["不㒝","bu2mie4"],
["不㒞","bu2jun4"],
["不㒠","bu2xie4"],
["不㒤","bu2she4"],
["不㒧","bu2li4"],
["不㒫","bu2ji4"],
["不㒵","bu2mao4"],
["不㒸","bu2sui4"],
["不㒻","bu2mao4"],
["不㒾","bu2shi4"],
["不㓂","bu2kou4"],
["不㓄","bu2zhen4"],
["不㓈","bu2bing4"],
["不㓉","bu2huan4"],
["不㓊","bu2dong4"],
["不㓋","bu2gong4"],
["不㓐","bu2lu4"],
["不㓑","bu2xing4"],
["不㓔","bu2xie4"],
["不㓖","bu2bi4"],
["不㓘","bu2su4"],
["不㓜","bu2you4"],
["不㓞","bu2qi4"],
["不㓠","bu2dian4"],
["不㓢","bu2luo4"],
["不㓣","bu2qia4"],
["不㓰","bu2hua4"],
["不㓲","bu2pian4"],
["不㓴","bu2jun4"],
["不㓵","bu2e4"],
["不㓶","bu2qie4"],
["不㓷","bu2yi4"],
["不㓹","bu2rui4"],
["不㓺","bu2jian4"],
["不㓼","bu2chi4"],
["不㔀","bu2lve4"],
["不㔄","bu2su4"],
["不㔅","bu2xiao4"],
["不㔋","bu2jian4"],
["不㔌","bu2zhou4"],
["不㔎","bu2xie4"],
["不㔏","bu2li4"],
["不㔑","bu2chi4"],
["不㔗","bu2fei4"],
["不㔘","bu2chu4"],
["不㔞","bu2kuai4"],
["不㔧","bu2lv4"],
["不㔨","bu2bei4"],
["不㔩","bu2e4"],
["不㔭","bu2che4"],
["不㔴","bu2yi4"],
["不㔵","bu2xian4"],
["不㔶","bu2gong4"],
["不㔷","bu2lou4"],
["不㔹","bu2le4"],
["不㔺","bu2shi4"],
["不㔽","bu2yao4"],
["不㔿","bu2zou4"],
["不㕁","bu2que4"],
["不㕄","bu2zhi4"],
["不㕆","bu2hu4"],
["不㕈","bu2hou4"],
["不㕉","bu2ke4"],
["不㕋","bu2jing4"],
["不㕌","bu2ai4"],
["不㕎","bu2e4"],
["不㕕","bu2huan4"],
["不㕖","bu2su4"],
["不㕗","bu2you4"],
["不㕙","bu2jun4"],
["不㕛","bu2xu4"],
["不㕟","bu2kui4"],
["不㕢","bu2gai4"],
["不㕦","bu2hua4"],
["不㕨","bu2fan4"],
["不㕩","bu2zhang4"],
["不㕬","bu2song4"],
["不㕭","bu2ao4"],
["不㕯","bu2nei4"],
["不㕰","bu2he4"],
["不㕶","bu2ng4"],
["不㕷","bu2hua4"],
["不㕸","bu2li4"],
["不㕽","bu2si4"],
["不㖀","bu2le4"],
["不㖁","bu2lin4"],
["不㖂","bu2yi4"],
["不㖅","bu2xu4"],
["不㖏","bu2nei4"],
["不㖑","bu2xie4"],
["不㖕","bu2bo4"],
["不㖖","bu2nie4"],
["不㖟","bu2shou4"],
["不㖠","bu2ba4"],
["不㖡","bu2ye4"],
["不㖣","bu2tou4"],
["不㖨","bu2lu4"],
["不㖶","bu2ye4"],
["不㖹","bu2fen4"],
["不㖾","bu2e4"],
["不㗁","bu2e4"],
["不㗈","bu2man4"],
["不㗉","bu2bi4"],
["不㗌","bu2zhi4"],
["不㗑","bu2bai4"],
["不㗒","bu2ai4"],
["不㗕","bu2gou4"],
["不㗖","bu2dan4"],
["不㗙","bu2na4"],
["不㗚","bu2li4"],
["不㗛","bu2xiao4"],
["不㗜","bu2xiu4"],
["不㗢","bu2dong4"],
["不㗣","bu2ti4"],
["不㗤","bu2cu4"],
["不㗥","bu2kuo4"],
["不㗧","bu2zhi4"],
["不㗫","bu2qie4"],
["不㗰","bu2chu4"],
["不㗲","bu2huo4"],
["不㗵","bu2xu4"],
["不㗼","bu2ye4"],
["不㗿","bu2xia4"],
["不㘀","bu2zuo4"],
["不㘁","bu2yi4"],
["不㘉","bu2zhi4"],
["不㘊","bu2yi4"],
["不㘌","bu2ju4"],
["不㘐","bu2pao4"],
["不㘑","bu2li4"],
["不㘞","bu2huo4"],
["不㘠","bu2bi4"],
["不㘧","bu2xu4"],
["不㘨","bu2nei4"],
["不㘩","bu2bi4"],
["不㘪","bu2hao4"],
["不㘬","bu2ao4"],
["不㘭","bu2ao4"],
["不㘴","bu2zuo4"],
["不㘵","bu2bu4"],
["不㘷","bu2ai4"],
["不㘸","bu2zang4"],
["不㘿","bu2nie4"],
["不㙀","bu2liu4"],
["不㙂","bu2dui4"],
["不㙄","bu2bi4"],
["不㙇","bu2chu4"],
["不㙏","bu2fu4"],
["不㙕","bu2kuai4"],
["不㙗","bu2kuai4"],
["不㙞","bu2nie4"],
["不㙠","bu2yi4"],
["不㙣","bu2zhang4"],
["不㙤","bu2xia4"],
["不㙨","bu2ji4"],
["不㙪","bu2ye4"],
["不㙯","bu2yi4"],
["不㙰","bu2xie4"],
["不㙱","bu2hao4"],
["不㙴","bu2chan4"],
["不㙸","bu2bao4"],
["不㙺","bu2gui4"],
["不㙾","bu2xi4"],
["不㚆","bu2fu4"],
["不㚌","bu2hua4"],
["不㚐","bu2tao4"],
["不㚔","bu2nie4"],
["不㚘","bu2ban4"],
["不㚛","bu2xi4"],
["不㚜","bu2xu4"],
["不㚟","bu2chuo4"],
["不㚤","bu2yi4"],
["不㚪","bu2hao4"],
["不㚫","bu2sha4"],
["不㚴","bu2bu4"],
["不㚶","bu2si4"],
["不㚺","bu2yun4"],
["不㛅","bu2er4"],
["不㛍","bu2qie4"],
["不㛏","bu2ou4"],
["不㛑","bu2can4"],
["不㛒","bu2dou4"],
["不㛕","bu2yi4"],
["不㛗","bu2zuo4"],
["不㛘","bu2po4"],
["不㛙","bu2qie4"],
["不㛛","bu2xin4"],
["不㛝","bu2bei4"],
["不㛞","bu2long4"],
["不㛥","bu2ta4"],
["不㛪","bu2yan4"],
["不㛬","bu2lu4"],
["不㛱","bu2rui4"],
["不㛲","bu2fa4"],
["不㛳","bu2cha4"],
["不㛸","bu2shu4"],
["不㛼","bu2sha4"],
["不㛿","bu2zhi4"],
["不㜃","bu2lian4"],
["不㜅","bu2xu4"],
["不㜆","bu2mi4"],
["不㜇","bu2hui4"],
["不㜈","bu2mu4"],
["不㜊","bu2pang4"],
["不㜋","bu2yi4"],
["不㜌","bu2gou4"],
["不㜐","bu2shu4"],
["不㜒","bu2yi4"],
["不㜘","bu2ju4"],
["不㜙","bu2lu4"],
["不㜚","bu2su4"],
["不㜛","bu2nen4"],
["不㜜","bu2ao4"],
["不㜞","bu2qian4"],
["不㜦","bu2han4"],
["不㜧","bu2yue4"],
["不㜩","bu2ao4"],
["不㜫","bu2ma4"],
["不㜮","bu2lan4"],
["不㜰","bu2yue4"],
["不㜱","bu2dong4"],
["不㜴","bu2meng4"],
["不㜸","bu2nie4"],
["不㜺","bu2zan4"],
["不㜻","bu2lian4"],
["不㜿","bu2xu4"],
["不㝀","bu2hao4"],
["不㝂","bu2zhi4"],
["不㝃","bu2fan4"],
["不㝅","bu2gou4"],
["不㝉","bu2zhu4"],
["不㝎","bu2ding4"],
["不㝏","bu2jie4"],
["不㝔","bu2yao4"],
["不㝛","bu2su4"],
["不㝞","bu2ya4"],
["不㝡","bu2zui4"],
["不㝣","bu2ye4"],
["不㝤","bu2gou4"],
["不㝦","bu2jun4"],
["不㝪","bu2dian4"],
["不㝮","bu2cui4"],
["不㝱","bu2meng4"],
["不㝶","bu2ai4"],
["不㝸","bu2bian4"],
["不㞁","bu2yao4"],
["不㞊","bu2xu4"],
["不㞌","bu2yun4"],
["不㞒","bu2xi4"],
["不㞕","bu2xie4"],
["不㞖","bu2ci4"],
["不㞙","bu2niao4"],
["不㞚","bu2qi4"],
["不㞟","bu2dian4"],
["不㞧","bu2hui4"],
["不㞫","bu2ju4"],
["不㞬","bu2qin4"],
["不㞭","bu2dai4"],
["不㞲","bu2yong4"],
["不㞸","bu2sui4"],
["不㞻","bu2hao4"],
["不㞽","bu2xue4"],
["不㞿","bu2chi4"],
["不㟁","bu2an4"],
["不㟋","bu2dui4"],
["不㟖","bu2long4"],
["不㟛","bu2zan4"],
["不㟞","bu2zhan4"],
["不㟟","bu2xiang4"],
["不㟤","bu2lu4"],
["不㟦","bu2yun4"],
["不㟧","bu2e4"],
["不㟳","bu2li4"],
["不㟴","bu2kuai4"],
["不㟻","bu2qian4"],
["不㠇","bu2jiu4"],
["不㠈","bu2run4"],
["不㠋","bu2e4"],
["不㠐","bu2jiao4"],
["不㠑","bu2zui4"],
["不㠔","bu2bai4"],
["不㠖","bu2ji4"],
["不㠗","bu2ao4"],
["不㠚","bu2dui4"],
["不㠛","bu2wo4"],
["不㠜","bu2ni4"],
["不㠢","bu2hua4"],
["不㠣","bu2lai4"],
["不㠥","bu2lv4"],
["不㠨","bu2yu4"],
["不㠪","bu2ju4"],
["不㠱","bu2ji4"],
["不㠴","bu2ren4"],
["不㠸","bu2ku4"],
["不㠹","bu2jie4"],
["不㡀","bu2bi4"],
["不㡂","bu2li4"],
["不㡊","bu2qia4"],
["不㡋","bu2e4"],
["不㡌","bu2mao4"],
["不㡔","bu2wu4"],
["不㡙","bu2bi4"],
["不㡝","bu2feng4"],
["不㡠","bu2zheng4"],
["不㡢","bu2man4"],
["不㡧","bu2zheng4"],
["不㡫","bu2yi4"],
["不㡭","bu2ji4"],
["不㡶","bu2ji4"],
["不㡹","bu2ci4"],
["不㡺","bu2dan4"],
["不㡻","bu2liao4"],
["不㡼","bu2yi4"],
["不㡽","bu2zhao4"],
["不㡾","bu2xian4"],
["不㡿","bu2chi4"],
["不㢀","bu2ci4"],
["不㢄","bu2dou4"],
["不㢅","bu2long4"],
["不㢎","bu2cha4"],
["不㢗","bu2qiao4"],
["不㢛","bu2yan4"],
["不㢞","bu2yi4"],
["不㢣","bu2jing4"],
["不㢥","bu2dong4"],
["不㢧","bu2juan4"],
["不㢨","bu2han4"],
["不㢩","bu2di4"],
["不㢰","bu2bi4"],
["不㢲","bu2xun4"],
["不㢵","bu2she4"],
["不㢶","bu2bi4"],
["不㢸","bu2bi4"],
["不㢼","bu2bie4"],
["不㢾","bu2juan4"],
["不㣀","bu2zhen4"],
["不㣁","bu2bei4"],
["不㣂","bu2yi4"],
["不㣅","bu2zan4"],
["不㣈","bu2si4"],
["不㣌","bu2shan4"],
["不㣎","bu2mu4"],
["不㣏","bu2jing4"],
["不㣐","bu2bian4"],
["不㣒","bu2ceng4"],
["不㣓","bu2can4"],
["不㣛","bu2ta4"],
["不㣟","bu2xi4"],
["不㣤","bu2jian4"],
["不㣥","bu2zhi4"],
["不㣧","bu2yin4"],
["不㣬","bu2qi4"],
["不㣯","bu2xie4"],
["不㣰","bu2xie4"],
["不㣵","bu2ta4"],
["不㣷","bu2ning4"],
["不㣻","bu2yi4"],
["不㣽","bu2shu4"],
["不㣾","bu2cha4"],
["不㤄","bu2pei4"],
["不㤅","bu2ai4"],
["不㤆","bu2fan4"],
["不㤈","bu2qin4"],
["不㤉","bu2qia4"],
["不㤊","bu2xiao4"],
["不㤑","bu2you4"],
["不㤓","bu2ben4"],
["不㤕","bu2chu4"],
["不㤖","bu2zhu4"],
["不㤘","bu2chu4"],
["不㤞","bu2cha4"],
["不㤠","bu2lie4"],
["不㤡","bu2li4"],
["不㤢","bu2xu4"],
["不㤥","bu2hai4"],
["不㤦","bu2li4"],
["不㤩","bu2ke4"],
["不㤪","bu2yuan4"],
["不㤬","bu2hui4"],
["不㤱","bu2fu4"],
["不㤲","bu2qie4"],
["不㤸","bu2xi4"],
["不㤾","bu2san4"],
["不㥂","bu2te4"],
["不㥃","bu2men4"],
["不㥅","bu2shou4"],
["不㥆","bu2dian4"],
["不㥉","bu2che4"],
["不㥍","bu2ji4"],
["不㥐","bu2yuan4"],
["不㥜","bu2wei4"],
["不㥞","bu2cui4"],
["不㥡","bu2xi4"],
["不㥣","bu2hui4"],
["不㥦","bu2qie4"],
["不㥧","bu2shun4"],
["不㥭","bu2tai4"],
["不㥮","bu2zhou4"],
["不㥲","bu2shen4"],
["不㥵","bu2hun4"],
["不㥶","bu2se4"],
["不㥷","bu2ye4"],
["不㥽","bu2ce4"],
["不㥾","bu2ni4"],
["不㥿","bu2ao4"],
["不㦅","bu2di4"],
["不㦇","bu2lu4"],
["不㦉","bu2yi4"],
["不㦌","bu2tui4"],
["不㦍","bu2e4"],
["不㦎","bu2hua4"],
["不㦐","bu2ni4"],
["不㦓","bu2xian4"],
["不㦔","bu2yan4"],
["不㦖","bu2men4"],
["不㦗","bu2jian4"],
["不㦜","bu2huo4"],
["不㦟","bu2hai4"],
["不㦡","bu2le4"],
["不㦣","bu2wei4"],
["不㦤","bu2yi4"],
["不㦦","bu2he4"],
["不㦪","bu2xie4"],
["不㦯","bu2huo4"],
["不㦹","bu2ang4"],
["不㦼","bu2shuang4"],
["不㦽","bu2xu4"],
["不㦿","bu2hu4"],
["不㧁","bu2qu4"],
["不㧅","bu2mu4"],
["不㧉","bu2gai4"],
["不㧌","bu2mao4"],
["不㧔","bu2guai4"],
["不㧕","bu2jiu4"],
["不㧖","bu2e4"],
["不㧘","bu2cui4"],
["不㧙","bu2bi4"],
["不㧜","bu2lie4"],
["不㧡","bu2hai4"],
["不㧣","bu2zhu4"],
["不㧤","bu2chong4"],
["不㧦","bu2xuan4"],
["不㧩","bu2pei4"],
["不㧰","bu2li4"],
["不㧱","bu2chen4"],
["不㧷","bu2duo4"],
["不㧹","bu2te4"],
["不㧺","bu2ta4"],
["不㧼","bu2biao4"],
["不㧽","bu2gu4"],
["不㨄","bu2zhao4"],
["不㨅","bu2nei4"],
["不㨌","bu2gou4"],
["不㨔","bu2han4"],
["不㨖","bu2zhi4"],
["不㨝","bu2xie4"],
["不㨞","bu2su4"],
["不㨠","bu2mi4"],
["不㨤","bu2hui4"],
["不㨥","bu2na4"],
["不㨧","bu2ben4"],
["不㨨","bu2liu4"],
["不㨪","bu2huang4"],
["不㨭","bu2hu4"],
["不㨯","bu2huo4"],
["不㨲","bu2ce4"],
["不㨴","bu2jian4"],
["不㨷","bu2jin4"],
["不㨸","bu2ma4"],
["不㨹","bu2hui4"],
["不㨼","bu2lve4"],
["不㨾","bu2yang4"],
["不㨿","bu2ju4"],
["不㩀","bu2ju4"],
["不㩁","bu2que4"],
["不㩆","bu2jiu4"],
["不㩇","bu2hua4"],
["不㩈","bu2xian4"],
["不㩋","bu2su4"],
["不㩌","bu2fei4"],
["不㩍","bu2ce4"],
["不㩎","bu2ye4"],
["不㩞","bu2ci4"],
["不㩟","bu2zhai4"],
["不㩨","bu2hui4"],
["不㩵","bu2e4"],
["不㩶","bu2nie4"],
["不㪇","bu2xian4"],
["不㪈","bu2gui4"],
["不㪋","bu2han4"],
["不㪐","bu2lu4"],
["不㪑","bu2ye4"],
["不㪔","bu2san4"],
["不㪕","bu2diao4"],
["不㪖","bu2lu4"],
["不㪚","bu2san4"],
["不㪝","bu2lian4"],
["不㪞","bu2mao4"],
["不㪠","bu2qian4"],
["不㪣","bu2qiao4"],
["不㪤","bu2bi4"],
["不㪦","bu2yin4"],
["不㪨","bu2shan4"],
["不㪩","bu2su4"],
["不㪪","bu2sa4"],
["不㪫","bu2rui4"],
["不㪱","bu2huan4"],
["不㪵","bu2ban4"],
["不㪻","bu2juan4"],
["不㫁","bu2duan4"],
["不㫂","bu2zhu4"],
["不㫔","bu2gen4"],
["不㫗","bu2hou4"],
["不㫘","bu2mi4"],
["不㫛","bu2guang4"],
["不㫜","bu2dan4"],
["不㫢","bu2qu4"],
["不㫧","bu2bao4"],
["不㫯","bu2mao4"],
["不㫲","bu2pei4"],
["不㫸","bu2qie4"],
["不㫹","bu2dai4"],
["不㫻","bu2kun4"],
["不㫽","bu2lu4"],
["不㬄","bu2chan4"],
["不㬅","bu2man4"],
["不㬇","bu2huan4"],
["不㬌","bu2jing4"],
["不㬏","bu2li4"],
["不㬓","bu2piao4"],
["不㬗","bu2xian4"],
["不㬘","bu2su4"],
["不㬚","bu2che4"],
["不㬜","bu2jin4"],
["不㬞","bu2he4"],
["不㬠","bu2shai4"],
["不㬣","bu2dui4"],
["不㬥","bu2pu4"],
["不㬦","bu2yue4"],
["不㬩","bu2hui4"],
["不㬫","bu2yan4"],
["不㬬","bu2ju4"],
["不㬭","bu2jiao4"],
["不㬮","bu2kuai4"],
["不㬯","bu2lie4"],
["不㬱","bu2ti4"],
["不㬶","bu2hao4"],
["不㬼","bu2fu4"],
["不㬿","bu2dun4"],
["不㭄","bu2xin4"],
["不㭇","bu2yuan4"],
["不㭋","bu2bang4"],
["不㭑","bu2mei4"],
["不㭒","bu2si4"],
["不㭓","bu2bian4"],
["不㭛","bu2pai4"],
["不㭞","bu2lie4"],
["不㭡","bu2xi4"],
["不㭩","bu2lei4"],
["不㭭","bu2fei4"],
["不㭮","bu2zuo4"],
["不㭰","bu2ji4"],
["不㭼","bu2ta4"],
["不㮆","bu2nie4"],
["不㮇","bu2tian4"],
["不㮈","bu2nai4"],
["不㮏","bu2nai4"],
["不㮑","bu2qi4"],
["不㮓","bu2gen4"],
["不㮘","bu2mao4"],
["不㮙","bu2e4"],
["不㮚","bu2li4"],
["不㮡","bu2guan4"],
["不㮣","bu2gai4"],
["不㮥","bu2fen4"],
["不㮦","bu2se4"],
["不㮳","bu2zhen4"],
["不㮶","bu2shi4"],
["不㮸","bu2song4"],
["不㮿","bu2bi4"],
["不㯁","bu2bang4"],
["不㯂","bu2dai4"],
["不㯇","bu2bi4"],
["不㯈","bu2su4"],
["不㯉","bu2huo4"],
["不㯎","bu2nen4"],
["不㯓","bu2ta4"],
["不㯔","bu2cui4"],
["不㯙","bu2che4"],
["不㯜","bu2cui4"],
["不㯝","bu2lu4"],
["不㯞","bu2juan4"],
["不㯟","bu2lu4"],
["不㯠","bu2qian4"],
["不㯡","bu2pao4"],
["不㯢","bu2zhen4"],
["不㯤","bu2li4"],
["不㯩","bu2ti4"],
["不㯯","bu2gong4"],
["不㯲","bu2jin4"],
["不㯺","bu2jian4"],
["不㯿","bu2lie4"],
["不㰄","bu2jian4"],
["不㰆","bu2bei4"],
["不㰌","bu2que4"],
["不㰎","bu2zui4"],
["不㰔","bu2xie4"],
["不㰗","bu2cu4"],
["不㰛","bu2yue4"],
["不㰟","bu2ji4"],
["不㰠","bu2kang4"],
["不㰡","bu2xie4"],
["不㰣","bu2zi4"],
["不㰥","bu2hui4"],
["不㰦","bu2qu4"],
["不㰮","bu2shen4"],
["不㰯","bu2kou4"],
["不㰰","bu2qie4"],
["不㰱","bu2sha4"],
["不㰲","bu2xu4"],
["不㰳","bu2ya4"],
["不㰷","bu2zi4"],
["不㰹","bu2jin4"],
["不㰼","bu2qie4"],
["不㰾","bu2jiao4"],
["不㱁","bu2shi4"],
["不㱄","bu2mo4"],
["不㱅","bu2yi4"],
["不㱇","bu2se4"],
["不㱈","bu2jin4"],
["不㱉","bu2ye4"],
["不㱋","bu2que4"],
["不㱌","bu2che4"],
["不㱏","bu2zheng4"],
["不㱖","bu2cui4"],
["不㱘","bu2an4"],
["不㱦","bu2e4"],
["不㱧","bu2wo4"],
["不㱨","bu2lian4"],
["不㱪","bu2men4"],
["不㱫","bu2lan4"],
["不㱭","bu2duan4"],
["不㱮","bu2kuai4"],
["不㱱","bu2hui4"],
["不㱲","bu2yi4"],
["不㱳","bu2mo4"],
["不㱴","bu2zi4"],
["不㱵","bu2ben4"],
["不㱶","bu2beng4"],
["不㱸","bu2bi4"],
["不㱹","bu2li4"],
["不㱽","bu2dan4"],
["不㱿","bu2que4"],
["不㲃","bu2jiu4"],
["不㲄","bu2kou4"],
["不㲅","bu2ji4"],
["不㲉","bu2kai4"],
["不㲊","bu2rui4"],
["不㲋","bu2chuo4"],
["不㲌","bu2neng4"],
["不㲒","bu2bao4"],
["不㲕","bu2lei4"],
["不㲡","bu2nai4"],
["不㲢","bu2bian4"],
["不㲦","bu2han4"],
["不㲧","bu2zao4"],
["不㲱","bu2lie4"],
["不㲴","bu2zhong4"],
["不㲶","bu2lv4"],
["不㲷","bu2dan4"],
["不㲻","bu2ni4"],
["不㲼","bu2yi4"],
["不㲽","bu2nian4"],
["不㳀","bu2guo4"],
["不㳁","bu2ze4"],
["不㳃","bu2cui4"],
["不㳇","bu2fu4"],
["不㳈","bu2pei4"],
["不㳍","bu2bu4"],
["不㳎","bu2bian4"],
["不㳐","bu2sa4"],
["不㳑","bu2yi4"],
["不㳒","bu2bian4"],
["不㳔","bu2dui4"],
["不㳗","bu2chai4"],
["不㳙","bu2xuan4"],
["不㳚","bu2yu4"],
["不㳠","bu2ta4"],
["不㳥","bu2ju4"],
["不㳦","bu2xie4"],
["不㳪","bu2pan4"],
["不㳫","bu2ta4"],
["不㳮","bu2niao4"],
["不㳴","bu2mi4"],
["不㳵","bu2ji4"],
["不㳶","bu2gou4"],
["不㳼","bu2bi4"],
["不㳿","bu2xie4"],
["不㴀","bu2fan4"],
["不㴁","bu2yi4"],
["不㴃","bu2lei4"],
["不㴆","bu2jin4"],
["不㴇","bu2she4"],
["不㴈","bu2yin4"],
["不㴋","bu2su4"],
["不㴐","bu2mian4"],
["不㴑","bu2su4"],
["不㴒","bu2yi4"],
["不㴔","bu2se4"],
["不㴖","bu2luo4"],
["不㴘","bu2mao4"],
["不㴚","bu2sui4"],
["不㴛","bu2zhi4"],
["不㴜","bu2bian4"],
["不㴥","bu2qiao4"],
["不㴦","bu2guan4"],
["不㴨","bu2zhen4"],
["不㴪","bu2nie4"],
["不㴫","bu2jun4"],
["不㴬","bu2xie4"],
["不㴮","bu2xie4"],
["不㴵","bu2mi4"],
["不㴶","bu2que4"],
["不㴸","bu2na4"],
["不㴼","bu2su4"],
["不㴽","bu2xie4"],
["不㵀","bu2cuan4"],
["不㵃","bu2che4"],
["不㵄","bu2han4"],
["不㵅","bu2dan4"],
["不㵆","bu2hao4"],
["不㵋","bu2mi4"],
["不㵌","bu2chan4"],
["不㵍","bu2men4"],
["不㵑","bu2he4"],
["不㵒","bu2fei4"],
["不㵕","bu2shen4"],
["不㵖","bu2nv4"],
["不㵗","bu2fu4"],
["不㵘","bu2man4"],
["不㵝","bu2yi4"],
["不㵤","bu2dian4"],
["不㵥","bu2bi4"],
["不㵨","bu2bi4"],
["不㵩","bu2yi4"],
["不㵰","bu2xu4"],
["不㵵","bu2zou4"],
["不㵷","bu2bian4"],
["不㵸","bu2yao4"],
["不㵻","bu2sou4"],
["不㵽","bu2dui4"],
["不㵾","bu2jing4"],
["不㶑","bu2lian4"],
["不㶔","bu2bei4"],
["不㶖","bu2shu4"],
["不㶗","bu2fan4"],
["不㶘","bu2dian4"],
["不㶚","bu2ba4"],
["不㶠","bu2yi4"],
["不㶡","bu2dai4"],
["不㶦","bu2jin4"],
["不㶧","bu2nen4"],
["不㶭","bu2jiu4"],
["不㶯","bu2liu4"],
["不㶲","bu2yong4"],
["不㶳","bu2jin4"],
["不㶵","bu2ren4"],
["不㶹","bu2hong4"],
["不㶺","bu2tian4"],
["不㷂","bu2shu4"],
["不㷄","bu2hui4"],
["不㷆","bu2dou4"],
["不㷇","bu2guai4"],
["不㷈","bu2e4"],
["不㷉","bu2wei4"],
["不㷎","bu2he4"],
["不㷔","bu2yan4"],
["不㷖","bu2zhao4"],
["不㷟","bu2tui4"],
["不㷤","bu2he4"],
["不㷦","bu2xu4"],
["不㷪","bu2cui4"],
["不㷬","bu2mo4"],
["不㷯","bu2beng4"],
["不㷳","bu2yan4"],
["不㷵","bu2mo4"],
["不㷶","bu2bei4"],
["不㷹","bu2shao4"],
["不㷼","bu2yan4"],
["不㸄","bu2ji4"],
["不㸉","bu2xie4"],
["不㸊","bu2la4"],
["不㸌","bu2huo4"],
["不㸍","bu2xi4"],
["不㸎","bu2nie4"],
["不㸑","bu2cuan4"],
["不㸓","bu2mi4"],
["不㸘","bu2wan4"],
["不㸜","bu2kong4"],
["不㸢","bu2bei4"],
["不㸣","bu2ye4"],
["不㸤","bu2pian4"],
["不㸦","bu2hu4"],
["不㸧","bu2ken4"],
["不㸩","bu2an4"],
["不㸬","bu2bei4"],
["不㸷","bu2shi4"],
["不㸹","bu2lie4"],
["不㸻","bu2si4"],
["不㸽","bu2bei4"],
["不㸾","bu2ren4"],
["不㹂","bu2ci4"],
["不㹃","bu2bi4"],
["不㹄","bu2ji4"],
["不㹊","bu2yue4"],
["不㹑","bu2si4"],
["不㹓","bu2yi4"],
["不㹖","bu2huan4"],
["不㹝","bu2shi4"],
["不㹤","bu2qie4"],
["不㹥","bu2zhu4"],
["不㹨","bu2you4"],
["不㹫","bu2xi4"],
["不㹭","bu2yi4"],
["不㹮","bu2mo4"],
["不㹲","bu2xiao4"],
["不㹵","bu2jing4"],
["不㹺","bu2ta4"],
["不㺉","bu2hu4"],
["不㺊","bu2yang4"],
["不㺌","bu2xian4"],
["不㺒","bu2liao4"],
["不㺓","bu2piao4"],
["不㺔","bu2hai4"],
["不㺗","bu2dan4"],
["不㺘","bu2zhan4"],
["不㺛","bu2zhu4"],
["不㺝","bu2jian4"],
["不㺠","bu2you4"],
["不㺡","bu2li4"],
["不㺩","bu2jiu4"],
["不㺷","bu2xu4"],
["不㺹","bu2bian4"],
["不㺺","bu2mao4"],
["不㻅","bu2hui4"],
["不㻉","bu2bu4"],
["不㻋","bu2la4"],
["不㻎","bu2li4"],
["不㻑","bu2ji4"],
["不㻒","bu2jun4"],
["不㻖","bu2dai4"],
["不㻗","bu2bei4"],
["不㻝","bu2la4"],
["不㻞","bu2bian4"],
["不㻧","bu2duo4"],
["不㻪","bu2sui4"],
["不㻫","bu2bi4"],
["不㻭","bu2se4"],
["不㻮","bu2can4"],
["不㻵","bu2zhan4"],
["不㻺","bu2li4"],
["不㻽","bu2sui4"],
["不㼉","bu2yin4"],
["不㼎","bu2bei4"],
["不㼑","bu2lian4"],
["不㼖","bu2li4"],
["不㼙","bu2zhou4"],
["不㼜","bu2ang4"],
["不㼝","bu2fan4"],
["不㼞","bu2peng4"],
["不㼤","bu2qi4"],
["不㼫","bu2huan4"],
["不㼬","bu2xing4"],
["不㼭","bu2dian4"],
["不㼯","bu2dong4"],
["不㼲","bu2lie4"],
["不㼵","bu2di4"],
["不㼾","bu2lu4"],
["不㽀","bu2zheng4"],
["不㽁","bu2li4"],
["不㽂","bu2sa4"],
["不㽇","bu2guai4"],
["不㽈","bu2yi4"],
["不㽊","bu2xie4"],
["不㽌","bu2liu4"],
["不㽙","bu2jun4"],
["不㽚","bu2chi4"],
["不㽛","bu2kou4"],
["不㽝","bu2li4"],
["不㽟","bu2lie4"],
["不㽣","bu2yu4"],
["不㽩","bu2can4"],
["不㽬","bu2fu4"],
["不㽰","bu2shu4"],
["不㽳","bu2han4"],
["不㽴","bu2zhang4"],
["不㽷","bu2shui4"],
["不㽹","bu2fan4"],
["不㽽","bu2gu4"],
["不㽾","bu2wu4"],
["不㾀","bu2qie4"],
["不㾁","bu2shu4"],
["不㾅","bu2si4"],
["不㾇","bu2mu4"],
["不㾈","bu2fu4"],
["不㾋","bu2xiu4"],
["不㾏","bu2jie4"],
["不㾐","bu2li4"],
["不㾒","bu2ji4"],
["不㾜","bu2qie4"],
["不㾝","bu2che4"],
["不㾟","bu2bu4"],
["不㾡","bu2que4"],
["不㾢","bu2lai4"],
["不㾥","bu2xu4"],
["不㾦","bu2bang4"],
["不㾧","bu2ke4"],
["不㾭","bu2zhou4"],
["不㾱","bu2bei4"],
["不㾵","bu2ji4"],
["不㾺","bu2ma4"],
["不㾻","bu2zhu4"],
["不㿃","bu2dai4"],
["不㿄","bu2ai4"],
["不㿋","bu2sao4"],
["不㿍","bu2jie4"],
["不㿎","bu2fen4"],
["不㿑","bu2yao4"],
["不㿙","bu2pi4"],
["不㿚","bu2luo4"],
["不㿞","bu2mao4"],
["不㿢","bu2yao4"],
["不㿦","bu2ning4"],
["不㿨","bu2li4"],
["不㿫","bu2bi4"],
["不㿭","bu2che4"],
["不㿮","bu2yang4"],
["不㿷","bu2zao4"],
["不㿹","bu2ta4"],
["不㿾","bu2zhu4"],
["不䀁","bu2you4"],
["不䀅","bu2she4"],
["不䀆","bu2jin4"],
["不䀈","bu2qi4"],
["不䀍","bu2kan4"],
["不䀏","bu2xian4"],
["不䀑","bu2na4"],
["不䀓","bu2huan4"],
["不䀕","bu2cheng4"],
["不䀙","bu2qi4"],
["不䀛","bu2mei4"],
["不䀡","bu2chan4"],
["不䀢","bu2shun4"],
["不䀣","bu2bi4"],
["不䀤","bu2mao4"],
["不䀥","bu2shuo4"],
["不䀨","bu2huan4"],
["不䀩","bu2luo4"],
["不䀲","bu2mu4"],
["不䀳","bu2ai4"],
["不䀵","bu2shun4"],
["不䀸","bu2di4"],
["不䀻","bu2pin4"],
["不䀼","bu2ren4"],
["不䀿","bu2di4"],
["不䁂","bu2xian4"],
["不䁄","bu2xing4"],
["不䁅","bu2bei4"],
["不䁇","bu2mi4"],
["不䁈","bu2qi4"],
["不䁉","bu2qi4"],
["不䁊","bu2wo4"],
["不䁌","bu2yu4"],
["不䁍","bu2jia4"],
["不䁐","bu2ying4"],
["不䁓","bu2jie4"],
["不䁔","bu2han4"],
["不䁤","bu2che4"],
["不䁥","bu2ni4"],
["不䁦","bu2qu4"],
["不䁨","bu2huo4"],
["不䁯","bu2she4"],
["不䁱","bu2ao4"],
["不䁹","bu2bi4"],
["不䁺","bu2shi4"],
["不䁻","bu2li4"],
["不䁼","bu2mo4"],
["不䁽","bu2lie4"],
["不䁾","bu2mie4"],
["不䁿","bu2mo4"],
["不䂃","bu2jiao4"],
["不䂄","bu2huo4"],
["不䂆","bu2xu4"],
["不䂊","bu2yu4"],
["不䂐","bu2chuo4"],
["不䂔","bu2xing4"],
["不䂕","bu2hui4"],
["不䂜","bu2bang4"],
["不䂞","bu2zhe4"],
["不䂤","bu2fu4"],
["不䂩","bu2yan4"],
["不䂪","bu2diao4"],
["不䂮","bu2lve4"],
["不䂯","bu2guai4"],
["不䂰","bu2la4"],
["不䂱","bu2cui4"],
["不䂻","bu2zheng4"],
["不䂼","bu2nie4"],
["不䂽","bu2diao4"],
["不䂿","bu2ta4"],
["不䃀","bu2cui4"],
["不䃍","bu2zhao4"],
["不䃓","bu2gou4"],
["不䃖","bu2wu4"],
["不䃗","bu2chuo4"],
["不䃙","bu2lu4"],
["不䃚","bu2cu4"],
["不䃝","bu2qiao4"],
["不䃤","bu2su4"],
["不䃯","bu2li4"],
["不䃱","bu2xian4"],
["不䃳","bu2la4"],
["不䃸","bu2xian4"],
["不䃹","bu2lan4"],
["不䃻","bu2ba4"],
["不䄀","bu2huo4"],
["不䄁","bu2yi4"],
["不䄂","bu2liu4"],
["不䄅","bu2juan4"],
["不䄈","bu2dou4"],
["不䄌","bu2zhui4"],
["不䄍","bu2du4"],
["不䄐","bu2quan4"],
["不䄒","bu2nie4"],
["不䄕","bu2she4"],
["不䄟","bu2cui4"],
["不䄠","bu2shan4"],
["不䄤","bu2lai4"],
["不䄪","bu2chuo4"],
["不䄶","bu2bi4"],
["不䄷","bu2dan4"],
["不䄸","bu2po4"],
["不䄺","bu2zhi4"],
["不䄾","bu2rou4"],
["不䄿","bu2yi4"],
["不䅀","bu2lie4"],
["不䅁","bu2an4"],
["不䅄","bu2li4"],
["不䅆","bu2zi4"],
["不䅇","bu2su4"],
["不䅈","bu2yuan4"],
["不䅉","bu2ya4"],
["不䅊","bu2du4"],
["不䅍","bu2dong4"],
["不䅏","bu2hui4"],
["不䅗","bu2sui4"],
["不䅙","bu2hun4"],
["不䅜","bu2duo4"],
["不䅞","bu2na4"],
["不䅢","bu2jiu4"],
["不䅤","bu2qi4"],
["不䅧","bu2yan4"],
["不䅬","bu2ai4"],
["不䅮","bu2cang4"],
["不䅱","bu2hun4"],
["不䅶","bu2nou4"],
["不䆄","bu2shan4"],
["不䆈","bu2zhi4"],
["不䆉","bu2ba4"],
["不䆊","bu2cui4"],
["不䆏","bu2fei4"],
["不䆒","bu2jiu4"],
["不䆓","bu2e4"],
["不䆗","bu2jiao4"],
["不䆜","bu2you4"],
["不䆝","bu2shu4"],
["不䆠","bu2huan4"],
["不䆦","bu2shen4"],
["不䆮","bu2jin4"],
["不䆯","bu2chuo4"],
["不䆷","bu2yu4"],
["不䆻","bu2qiao4"],
["不䆽","bu2ju4"],
["不䆿","bu2yi4"],
["不䇃","bu2si4"],
["不䇈","bu2gui4"],
["不䇋","bu2hai4"],
["不䇌","bu2qiao4"],
["不䇍","bu2chuo4"],
["不䇎","bu2que4"],
["不䇏","bu2dui4"],
["不䇐","bu2li4"],
["不䇑","bu2ba4"],
["不䇒","bu2jie4"],
["不䇔","bu2luo4"],
["不䇘","bu2hu4"],
["不䇟","bu2jian4"],
["不䇠","bu2zhou4"],
["不䇡","bu2zhu4"],
["不䇣","bu2na4"],
["不䇤","bu2dui4"],
["不䇧","bu2zhu4"],
["不䇨","bu2gong4"],
["不䇩","bu2yi4"],
["不䇮","bu2ren4"],
["不䇱","bu2na4"],
["不䇹","bu2jun4"],
["不䇻","bu2hui4"],
["不䇼","bu2chi4"],
["不䇽","bu2zhi4"],
["不䈂","bu2bing4"],
["不䈅","bu2yu4"],
["不䈆","bu2dai4"],
["不䈇","bu2zhao4"],
["不䈉","bu2sha4"],
["不䈋","bu2ta4"],
["不䈎","bu2ye4"],
["不䈐","bu2kui4"],
["不䈙","bu2zhou4"],
["不䈛","bu2kuai4"],
["不䈜","bu2qin4"],
["不䈟","bu2ce4"],
["不䈣","bu2zheng4"],
["不䈪","bu2xi4"],
["不䈫","bu2na4"],
["不䈳","bu2ta4"],
["不䈴","bu2qian4"],
["不䈷","bu2luo4"],
["不䈼","bu2mie4"],
["不䈾","bu2shuo4"],
["不䈿","bu2mai4"],
["不䉀","bu2shu4"],
["不䉅","bu2zhi4"],
["不䉊","bu2fan4"],
["不䉋","bu2mei4"],
["不䉌","bu2sui4"],
["不䉏","bu2xie4"],
["不䉛","bu2yu4"],
["不䉜","bu2zhi4"],
["不䉟","bu2huo4"],
["不䉢","bu2se4"],
["不䉣","bu2xie4"],
["不䉨","bu2yi4"],
["不䉪","bu2lei4"],
["不䉬","bu2fei4"],
["不䉭","bu2lie4"],
["不䉮","bu2lin4"],
["不䉯","bu2xian4"],
["不䉲","bu2bie4"],
["不䉵","bu2zhuan4"],
["不䉷","bu2dan4"],
["不䉸","bu2bian4"],
["不䉼","bu2liao4"],
["不䉾","bu2mi4"],
["不䊂","bu2ce4"],
["不䊃","bu2pei4"],
["不䊆","bu2jiu4"],
["不䊇","bu2bu4"],
["不䊊","bu2mei4"],
["不䊐","bu2en4"],
["不䊓","bu2shi4"],
["不䊘","bu2jiu4"],
["不䊝","bu2xie4"],
["不䊠","bu2xi4"],
["不䊥","bu2xiao4"],
["不䊧","bu2bi4"],
["不䊪","bu2li4"],
["不䊬","bu2cha4"],
["不䊯","bu2kuang4"],
["不䊴","bu2qian4"],
["不䊶","bu2zhen4"],
["不䊽","bu2guai4"],
["不䊾","bu2mu4"],
["不䋀","bu2kua4"],
["不䋃","bu2mao4"],
["不䋎","bu2zhan4"],
["不䋏","bu2zuo4"],
["不䋐","bu2yue4"],
["不䋓","bu2zhou4"],
["不䋔","bu2bi4"],
["不䋕","bu2ren4"],
["不䋖","bu2yu4"],
["不䋘","bu2chuo4"],
["不䋚","bu2yi4"],
["不䋜","bu2qing4"],
["不䋟","bu2ji4"],
["不䋢","bu2bie4"],
["不䋤","bu2yao4"],
["不䋭","bu2huo4"],
["不䋮","bu2jin4"],
["不䋳","bu2bei4"],
["不䋴","bu2niu4"],
["不䋵","bu2yi4"],
["不䋶","bu2xu4"],
["不䌂","bu2ou4"],
["不䌃","bu2shuo4"],
["不䌆","bu2gui4"],
["不䌇","bu2hui4"],
["不䌈","bu2ta4"],
["不䌌","bu2qi4"],
["不䌍","bu2han4"],
["不䌎","bu2lve4"],
["不䌏","bu2mi4"],
["不䌐","bu2mi4"],
["不䌒","bu2lu4"],
["不䌔","bu2ou4"],
["不䌚","bu2su4"],
["不䌜","bu2nie4"],
["不䌝","bu2jin4"],
["不䌟","bu2bi4"],
["不䌠","bu2qing4"],
["不䌨","bu2cai4"],
["不䌩","bu2mi4"],
["不䌯","bu2guan4"],
["不䌰","bu2she4"],
["不䌱","bu2luo4"],
["不䌴","bu2luo4"],
["不䌸","bu2zhuan4"],
["不䌻","bu2yi4"],
["不䌼","bu2rui4"],
["不䍁","bu2sui4"],
["不䍆","bu2zhu4"],
["不䍇","bu2ta4"],
["不䍌","bu2bu4"],
["不䍎","bu2cun4"],
["不䍓","bu2hu4"],
["不䍗","bu2xuan4"],
["不䍚","bu2lang4"],
["不䍛","bu2gu4"],
["不䍜","bu2zhao4"],
["不䍝","bu2ta4"],
["不䍞","bu2yu4"],
["不䍟","bu2zong4"],
["不䍡","bu2liao4"],
["不䍥","bu2lei4"],
["不䍪","bu2kui4"],
["不䍮","bu2zhao4"],
["不䍳","bu2chuo4"],
["不䍴","bu2duo4"],
["不䍶","bu2dong4"],
["不䍷","bu2gui4"],
["不䍽","bu2li4"],
["不䎀","bu2xue4"],
["不䎅","bu2fu4"],
["不䎆","bu2liao4"],
["不䎈","bu2yi4"],
["不䎉","bu2shu4"],
["不䎊","bu2po4"],
["不䎋","bu2he4"],
["不䎌","bu2cu4"],
["不䎎","bu2na4"],
["不䎏","bu2an4"],
["不䎑","bu2lu4"],
["不䎓","bu2ta4"],
["不䎘","bu2su4"],
["不䎚","bu2guan4"],
["不䎣","bu2si4"],
["不䎧","bu2bang4"],
["不䎨","bu2an4"],
["不䎪","bu2ne4"],
["不䎫","bu2chuang4"],
["不䎬","bu2ba4"],
["不䎮","bu2ti4"],
["不䎯","bu2han4"],
["不䎱","bu2ba4"],
["不䎳","bu2wa4"],
["不䎴","bu2sheng4"],
["不䎵","bu2bi4"],
["不䎶","bu2er4"],
["不䎷","bu2zhu4"],
["不䎸","bu2wu4"],
["不䎼","bu2lu4"],
["不䏀","bu2la4"],
["不䏄","bu2zhi4"],
["不䏅","bu2qi4"],
["不䏇","bu2piao4"],
["不䏋","bu2su4"],
["不䏌","bu2qi4"],
["不䏍","bu2yuan4"],
["不䏑","bu2di4"],
["不䏒","bu2pian4"],
["不䏖","bu2zhen4"],
["不䏗","bu2gai4"],
["不䏞","bu2mo4"],
["不䏟","bu2bie4"],
["不䏠","bu2qi4"],
["不䏡","bu2shi4"],
["不䏤","bu2si4"],
["不䏪","bu2er4"],
["不䏯","bu2zhi4"],
["不䏳","bu2zhe4"],
["不䏴","bu2shao4"],
["不䏶","bu2bi4"],
["不䏷","bu2han4"],
["不䏹","bu2xian4"],
["不䏽","bu2bu4"],
["不䐀","bu2ji4"],
["不䐂","bu2lu4"],
["不䐄","bu2han4"],
["不䐉","bu2zi4"],
["不䐍","bu2zhou4"],
["不䐔","bu2bin4"],
["不䐞","bu2ruo4"],
["不䐟","bu2xiang4"],
["不䐢","bu2zhu4"],
["不䐣","bu2cuo4"],
["不䐧","bu2kao4"],
["不䐪","bu2fan4"],
["不䐭","bu2zhi4"],
["不䐴","bu2gui4"],
["不䐹","bu2sao4"],
["不䐺","bu2tan4"],
["不䐼","bu2xi4"],
["不䑀","bu2pi4"],
["不䑁","bu2wu4"],
["不䑄","bu2pi4"],
["不䑇","bu2zhi4"],
["不䑍","bu2yan4"],
["不䑔","bu2fei4"],
["不䑗","bu2dang4"],
["不䑜","bu2ta4"],
["不䑞","bu2shun4"],
["不䑤","bu2jin4"],
["不䑥","bu2e4"],
["不䑨","bu2duo4"],
["不䑪","bu2e4"],
["不䑬","bu2yao4"],
["不䑭","bu2di4"],
["不䑯","bu2di4"],
["不䑰","bu2bu4"],
["不䑲","bu2che4"],
["不䑵","bu2mu4"],
["不䑿","bu2su4"],
["不䒁","bu2ji4"],
["不䒃","bu2cao4"],
["不䒆","bu2che4"],
["不䒇","bu2fu4"],
["不䒌","bu2ming4"],
["不䒔","bu2bai4"],
["不䒖","bu2xin4"],
["不䒗","bu2qi4"],
["不䒤","bu2ri4"],
["不䒥","bu2fa4"],
["不䒦","bu2fan4"],
["不䒧","bu2qu4"],
["不䒪","bu2bian4"],
["不䒫","bu2dai4"],
["不䒬","bu2mo4"],
["不䒲","bu2cha4"],
["不䒵","bu2hao4"],
["不䒹","bu2lei4"],
["不䓃","bu2yi4"],
["不䓇","bu2xi4"],
["不䓈","bu2yi4"],
["不䓊","bu2e4"],
["不䓌","bu2zhi4"],
["不䓎","bu2chuo4"],
["不䓘","bu2jiu4"],
["不䓞","bu2li4"],
["不䓟","bu2lie4"],
["不䓠","bu2ta4"],
["不䓢","bu2gu4"],
["不䓥","bu2la4"],
["不䓧","bu2ci4"],
["不䓫","bu2ji4"],
["不䓭","bu2cha4"],
["不䓮","bu2mao4"],
["不䓲","bu2rui4"],
["不䓶","bu2lai4"],
["不䓷","bu2xing4"],
["不䓹","bu2yi4"],
["不䓼","bu2he4"],
["不䓽","bu2ji4"],
["不䔁","bu2li4"],
["不䔉","bu2li4"],
["不䔎","bu2su4"],
["不䔏","bu2chou4"],
["不䔒","bu2bei4"],
["不䔔","bu2jing4"],
["不䔘","bu2zuo4"],
["不䔙","bu2diao4"],
["不䔞","bu2lv4"],
["不䔪","bu2dui4"],
["不䔬","bu2yi4"],
["不䔭","bu2ning4"],
["不䔴","bu2ce4"],
["不䔹","bu2sui4"],
["不䔼","bu2se4"],
["不䔽","bu2ai4"],
["不䔾","bu2e4"],
["不䔿","bu2jie4"],
["不䕃","bu2yin4"],
["不䕆","bu2dou4"],
["不䕇","bu2hui4"],
["不䕈","bu2xie4"],
["不䕌","bu2zhi4"],
["不䕍","bu2yi4"],
["不䕑","bu2jun4"],
["不䕕","bu2man4"],
["不䕗","bu2bi4"],
["不䕚","bu2kui4"],
["不䕞","bu2lang4"],
["不䕠","bu2fei4"],
["不䕧","bu2xiao4"],
["不䕰","bu2ban4"],
["不䕶","bu2hu4"],
["不䕿","bu2han4"],
["不䖁","bu2yi4"],
["不䖃","bu2yue4"],
["不䖆","bu2niang4"],
["不䖇","bu2yu4"],
["不䖈","bu2nve4"],
["不䖋","bu2nve4"],
["不䖐","bu2jin4"],
["不䖑","bu2mi4"],
["不䖓","bu2na4"],
["不䖔","bu2han4"],
["不䖡","bu2nv4"],
["不䖣","bu2sao4"],
["不䖧","bu2na4"],
["不䖩","bu2bi4"],
["不䖫","bu2bang4"],
["不䖭","bu2juan4"],
["不䖯","bu2gui4"],
["不䖰","bu2pai4"],
["不䖳","bu2zha4"],
["不䗁","bu2ji4"],
["不䗃","bu2zhan4"],
["不䗑","bu2yi4"],
["不䗒","bu2bing4"],
["不䗖","bu2chi4"],
["不䗟","bu2yi4"],
["不䗪","bu2zhe4"],
["不䗯","bu2jin4"],
["不䗰","bu2guan4"],
["不䗲","bu2lin4"],
["不䗶","bu2la4"],
["不䗷","bu2yi4"],
["不䗹","bu2ci4"],
["不䗽","bu2wei4"],
["不䘀","bu2fu4"],
["不䘃","bu2mo4"],
["不䘄","bu2fu4"],
["不䘈","bu2li4"],
["不䘊","bu2mie4"],
["不䘌","bu2ni4"],
["不䘍","bu2chai4"],
["不䘏","bu2xu4"],
["不䘐","bu2nv4"],
["不䘑","bu2mai4"],
["不䘓","bu2kan4"],
["不䘘","bu2yu4"],
["不䘙","bu2wei4"],
["不䘝","bu2yi4"],
["不䘤","bu2shu4"],
["不䘩","bu2xuan4"],
["不䘫","bu2nou4"],
["不䘮","bu2sa4"],
["不䘱","bu2yu4"],
["不䘵","bu2lu4"],
["不䘶","bu2han4"],
["不䘸","bu2yi4"],
["不䘹","bu2zui4"],
["不䘺","bu2zhan4"],
["不䘻","bu2su4"],
["不䙃","bu2duo4"],
["不䙄","bu2qi4"],
["不䙅","bu2yao4"],
["不䙆","bu2gui4"],
["不䙊","bu2xie4"],
["不䙌","bu2hui4"],
["不䙐","bu2ke4"],
["不䙒","bu2xu4"],
["不䙕","bu2chu4"],
["不䙗","bu2ti4"],
["不䙛","bu2guan4"],
["不䙝","bu2xie4"],
["不䙟","bu2duo4"],
["不䙡","bu2hui4"],
["不䙢","bu2zeng4"],
["不䙣","bu2sa4"],
["不䙬","bu2ying4"],
["不䙮","bu2guan4"],
["不䙯","bu2cu4"],
["不䙳","bu2e4"],
["不䙼","bu2shao4"],
["不䙽","bu2xi4"],
["不䙿","bu2wei4"],
["不䚂","bu2he4"],
["不䚄","bu2lu4"],
["不䚈","bu2juan4"],
["不䚉","bu2qi4"],
["不䚋","bu2yun4"],
["不䚍","bu2qi4"],
["不䚏","bu2leng4"],
["不䚕","bu2li4"],
["不䚠","bu2hun4"],
["不䚢","bu2che4"],
["不䚥","bu2nuo4"],
["不䚦","bu2zhi4"],
["不䚨","bu2fei4"],
["不䚱","bu2xin4"],
["不䚲","bu2shan4"],
["不䚳","bu2xie4"],
["不䚴","bu2wa4"],
["不䚷","bu2xi4"],
["不䚸","bu2xie4"],
["不䚼","bu2nv4"],
["不䚽","bu2hao4"],
["不䚿","bu2yin4"],
["不䛃","bu2wang4"],
["不䛆","bu2zhou4"],
["不䛈","bu2shi4"],
["不䛉","bu2mi4"],
["不䛍","bu2fei4"],
["不䛎","bu2hu4"],
["不䛑","bu2mi4"],
["不䛒","bu2bian4"],
["不䛕","bu2yu4"],
["不䛖","bu2e4"],
["不䛙","bu2xu4"],
["不䛚","bu2lve4"],
["不䛛","bu2hui4"],
["不䛜","bu2xun4"],
["不䛠","bu2dou4"],
["不䛡","bu2hua4"],
["不䛤","bu2cu4"],
["不䛥","bu2xi4"],
["不䛦","bu2song4"],
["不䛨","bu2xin4"],
["不䛩","bu2wu4"],
["不䛫","bu2zheng4"],
["不䛭","bu2xing4"],
["不䛮","bu2jiu4"],
["不䛯","bu2ju4"],
["不䛵","bu2shou4"],
["不䛸","bu2che4"],
["不䛹","bu2can4"],
["不䛺","bu2jie4"],
["不䛻","bu2you4"],
["不䛾","bu2su4"],
["不䜁","bu2xi4"],
["不䜆","bu2mo4"],
["不䜊","bu2zao4"],
["不䜋","bu2hui4"],
["不䜑","bu2qia4"],
["不䜒","bu2ao4"],
["不䜓","bu2nie4"],
["不䜕","bu2mai4"],
["不䜖","bu2tan4"],
["不䜗","bu2xin4"],
["不䜚","bu2ta4"],
["不䜜","bu2wei4"],
["不䜞","bu2ji4"],
["不䜠","bu2che4"],
["不䜡","bu2xu4"],
["不䜩","bu2yan4"],
["不䜭","bu2jun4"],
["不䜲","bu2lie4"],
["不䜴","bu2chu4"],
["不䜹","bu2shu4"],
["不䜺","bu2ce4"],
["不䝂","bu2shu4"],
["不䝈","bu2e4"],
["不䝊","bu2sha4"],
["不䝋","bu2zong4"],
["不䝍","bu2jun4"],
["不䝒","bu2zhu4"],
["不䝓","bu2la4"],
["不䝘","bu2yi4"],
["不䝞","bu2hao4"],
["不䝟","bu2ya4"],
["不䝡","bu2man4"],
["不䝢","bu2man4"],
["不䝩","bu2zhen4"],
["不䝬","bu2zhu4"],
["不䝭","bu2gou4"],
["不䝮","bu2xuan4"],
["不䝯","bu2yi4"],
["不䝲","bu2jin4"],
["不䝵","bu2bu4"],
["不䝷","bu2zhi4"],
["不䝸","bu2ji4"],
["不䝺","bu2guan4"],
["不䝽","bu2ai4"],
["不䝾","bu2fu4"],
["不䝿","bu2gui4"],
["不䞀","bu2gou4"],
["不䞁","bu2xian4"],
["不䞃","bu2zhi4"],
["不䞄","bu2biao4"],
["不䞉","bu2sheng4"],
["不䞊","bu2xun4"],
["不䞋","bu2chen4"],
["不䞒","bu2dong4"],
["不䞜","bu2fu4"],
["不䞟","bu2po4"],
["不䞢","bu2zha4"],
["不䞥","bu2you4"],
["不䞧","bu2hou4"],
["不䞩","bu2e4"],
["不䞪","bu2jiang4"],
["不䞬","bu2tou4"],
["不䞯","bu2fu4"],
["不䞶","bu2di4"],
["不䞸","bu2fu4"],
["不䟃","bu2ca4"],
["不䟄","bu2qi4"],
["不䟅","bu2jian4"],
["不䟆","bu2bi4"],
["不䟏","bu2li4"],
["不䟐","bu2li4"],
["不䟔","bu2fu4"],
["不䟕","bu2cha4"],
["不䟖","bu2tang4"],
["不䟗","bu2shi4"],
["不䟘","bu2hang4"],
["不䟙","bu2qie4"],
["不䟜","bu2na4"],
["不䟝","bu2tou4"],
["不䟟","bu2cu4"],
["不䟠","bu2yue4"],
["不䟡","bu2di4"],
["不䟣","bu2chu4"],
["不䟤","bu2bi4"],
["不䟬","bu2qiu4"],
["不䟯","bu2kuo4"],
["不䟴","bu2zhen4"],
["不䟶","bu2cuo4"],
["不䟷","bu2chi4"],
["不䟹","bu2lie4"],
["不䟻","bu2du4"],
["不䟿","bu2lu4"],
["不䠉","bu2hua4"],
["不䠊","bu2fei4"],
["不䠎","bu2wo4"],
["不䠏","bu2ji4"],
["不䠐","bu2qu4"],
["不䠓","bu2cu4"],
["不䠔","bu2sui4"],
["不䠗","bu2qiu4"],
["不䠘","bu2pi4"],
["不䠙","bu2bei4"],
["不䠚","bu2wa4"],
["不䠞","bu2cu4"],
["不䠠","bu2chi4"],
["不䠢","bu2meng4"],
["不䠦","bu2zhe4"],
["不䠨","bu2chan4"],
["不䠩","bu2gui4"],
["不䠪","bu2duan4"],
["不䠫","bu2zou4"],
["不䠬","bu2deng4"],
["不䠯","bu2yue4"],
["不䠵","bu2fu4"],
["不䠶","bu2she4"],
["不䠼","bu2diao4"],
["不䠿","bu2wai4"],
["不䡂","bu2jiu4"],
["不䡃","bu2li4"],
["不䡇","bu2yue4"],
["不䡓","bu2juan4"],
["不䡖","bu2jing4"],
["不䡚","bu2mao4"],
["不䡛","bu2yin4"],
["不䡜","bu2lu4"],
["不䡟","bu2pi4"],
["不䡢","bu2bian4"],
["不䡨","bu2cha4"],
["不䡬","bu2man4"],
["不䡯","bu2shuang4"],
["不䡵","bu2sui4"],
["不䡶","bu2bei4"],
["不䡷","bu2kai4"],
["不䡹","bu2zhi4"],
["不䡺","bu2wei4"],
["不䡾","bu2nei4"],
["不䢀","bu2qi4"],
["不䢁","bu2yue4"],
["不䢃","bu2yi4"],
["不䢋","bu2ji4"],
["不䢕","bu2xu4"],
["不䢖","bu2lv4"],
["不䢙","bu2bai4"],
["不䢚","bu2gong4"],
["不䢝","bu2ya4"],
["不䢞","bu2nu4"],
["不䢠","bu2song4"],
["不䢡","bu2xie4"],
["不䢢","bu2cang4"],
["不䢤","bu2shu4"],
["不䢦","bu2shuai4"],
["不䢧","bu2liao4"],
["不䢩","bu2yu4"],
["不䢭","bu2yan4"],
["不䢮","bu2lei4"],
["不䢲","bu2yue4"],
["不䢽","bu2xiang4"],
["不䣈","bu2hang4"],
["不䣞","bu2e4"],
["不䣤","bu2jiao4"],
["不䣦","bu2lei4"],
["不䣧","bu2yi4"],
["不䣪","bu2po4"],
["不䣭","bu2tai4"],
["不䣮","bu2po4"],
["不䣰","bu2ju4"],
["不䣱","bu2xu4"],
["不䣲","bu2fan4"],
["不䣴","bu2xu4"],
["不䣵","bu2er4"],
["不䣾","bu2mi4"],
["不䤃","bu2yin4"],
["不䤉","bu2mi4"],
["不䤑","bu2wang4"],
["不䤔","bu2jian4"],
["不䤕","bu2xue4"],
["不䤖","bu2bao4"],
["不䤙","bu2li4"],
["不䤜","bu2dun4"],
["不䤝","bu2ying4"],
["不䤣","bu2lve4"],
["不䤦","bu2yue4"],
["不䤧","bu2hui4"],
["不䤨","bu2pi4"],
["不䤭","bu2kuan4"],
["不䤮","bu2she4"],
["不䤱","bu2shi4"],
["不䤲","bu2chi4"],
["不䤳","bu2ye4"],
["不䤵","bu2fei4"],
["不䤶","bu2ye4"],
["不䤸","bu2zuan4"],
["不䤻","bu2duo4"],
["不䤼","bu2xian4"],
["不䤿","bu2qie4"],
["不䥂","bu2meng4"],
["不䥃","bu2yue4"],
["不䥄","bu2cu4"],
["不䥅","bu2qian4"],
["不䥇","bu2shan4"],
["不䥌","bu2zheng4"],
["不䥍","bu2zhi4"],
["不䥑","bu2wan4"],
["不䥔","bu2su4"],
["不䥘","bu2cu4"],
["不䥙","bu2sui4"],
["不䥜","bu2jian4"],
["不䥟","bu2ye4"],
["不䥡","bu2ye4"],
["不䥨","bu2lv4"],
["不䥭","bu2zheng4"],
["不䥯","bu2ba4"],
["不䥰","bu2meng4"],
["不䥶","bu2li4"],
["不䦂","bu2shan4"],
["不䦅","bu2shan4"],
["不䦇","bu2ji4"],
["不䦌","bu2chu4"],
["不䦍","bu2wu4"],
["不䦏","bu2xie4"],
["不䦑","bu2xie4"],
["不䦒","bu2dang4"],
["不䦗","bu2xu4"],
["不䦘","bu2bi4"],
["不䦙","bu2si4"],
["不䦚","bu2huo4"],
["不䦛","bu2zheng4"],
["不䦞","bu2run4"],
["不䦟","bu2chuai4"],
["不䦢","bu2kuo4"],
["不䦣","bu2fu4"],
["不䦤","bu2chuai4"],
["不䦪","bu2ya4"],
["不䦬","bu2que4"],
["不䦯","bu2zhi4"],
["不䦲","bu2qian4"],
["不䦳","bu2hang4"],
["不䦴","bu2yi4"],
["不䦶","bu2zheng4"],
["不䦷","bu2chuai4"],
["不䦻","bu2ci4"],
["不䦽","bu2xu4"],
["不䧁","bu2chu4"],
["不䧂","bu2dao4"],
["不䧃","bu2dian4"],
["不䧄","bu2ge4"],
["不䧅","bu2ti4"],
["不䧍","bu2xi4"],
["不䧎","bu2xuan4"],
["不䧔","bu2mu4"],
["不䧖","bu2jian4"],
["不䧗","bu2bi4"],
["不䧚","bu2hao4"],
["不䧛","bu2bang4"],
["不䧝","bu2di4"],
["不䧞","bu2fu4"],
["不䧟","bu2xian4"],
["不䧠","bu2shuan4"],
["不䧥","bu2hui4"],
["不䧨","bu2ye4"],
["不䧪","bu2che4"],
["不䧰","bu2hun4"],
["不䧲","bu2han4"],
["不䧿","bu2que4"],
["不䨁","bu2che4"],
["不䨄","bu2yan4"],
["不䨋","bu2nve4"],
["不䨐","bu2qia4"],
["不䨒","bu2yu4"],
["不䨖","bu2ji4"],
["不䨘","bu2xian4"],
["不䨛","bu2se4"],
["不䨢","bu2dan4"],
["不䨥","bu2hu4"],
["不䨫","bu2mai4"],
["不䨯","bu2zhen4"],
["不䨰","bu2po4"],
["不䨱","bu2fu4"],
["不䨳","bu2xi4"],
["不䨴","bu2dui4"],
["不䨵","bu2dan4"],
["不䨷","bu2xian4"],
["不䨺","bu2dui4"],
["不䨻","bu2beng4"],
["不䨼","bu2hu4"],
["不䩀","bu2bei4"],
["不䩃","bu2shi4"],
["不䩈","bu2hui4"],
["不䩏","bu2mie4"],
["不䩔","bu2duo4"],
["不䩗","bu2ba4"],
["不䩘","bu2di4"],
["不䩙","bu2xuan4"],
["不䩚","bu2di4"],
["不䩛","bu2bi4"],
["不䩜","bu2zhou4"],
["不䩤","bu2xi4"],
["不䩥","bu2dan4"],
["不䩧","bu2xie4"],
["不䩨","bu2chang4"],
["不䩮","bu2lu4"],
["不䩰","bu2xuan4"],
["不䩱","bu2shu4"],
["不䩵","bu2yun4"],
["不䩻","bu2ba4"],
["不䩾","bu2zhe4"],
["不䪉","bu2la4"],
["不䪋","bu2wei4"],
["不䪌","bu2zhan4"],
["不䪏","bu2na4"],
["不䪐","bu2bi4"],
["不䪒","bu2jiao4"],
["不䪖","bu2po4"],
["不䪚","bu2he4"],
["不䪜","bu2chan4"],
["不䪝","bu2hu4"],
["不䪷","bu2hou4"],
["不䪻","bu2bian4"],
["不䪽","bu2hao4"],
["不䫁","bu2bi4"],
["不䫄","bu2chua4"],
["不䫅","bu2san4"],
["不䫈","bu2zen4"],
["不䫉","bu2mao4"],
["不䫔","bu2qi4"],
["不䫕","bu2zhi4"],
["不䫡","bu2qian4"],
["不䫨","bu2ao4"],
["不䫭","bu2hui4"],
["不䫰","bu2lin4"],
["不䫲","bu2han4"],
["不䫴","bu2jin4"],
["不䫷","bu2e4"],
["不䫼","bu2xue4"],
["不䫾","bu2bi4"],
["不䬂","bu2xue4"],
["不䬃","bu2sa4"],
["不䬄","bu2yu4"],
["不䬅","bu2li4"],
["不䬆","bu2li4"],
["不䬇","bu2yuan4"],
["不䬈","bu2dui4"],
["不䬉","bu2hao4"],
["不䬊","bu2qie4"],
["不䬏","bu2bu4"],
["不䬑","bu2wei4"],
["不䬓","bu2an4"],
["不䬔","bu2xu4"],
["不䬛","bu2bi4"],
["不䬡","bu2zhu4"],
["不䬣","bu2qi4"],
["不䬥","bu2yi4"],
["不䬦","bu2dou4"],
["不䬨","bu2cu4"],
["不䬰","bu2shao4"],
["不䬱","bu2ben4"],
["不䬴","bu2mo4"],
["不䬵","bu2ai4"],
["不䬶","bu2en4"],
["不䬹","bu2zhi4"],
["不䬺","bu2yang4"],
["不䬻","bu2jian4"],
["不䬼","bu2yuan4"],
["不䬽","bu2dui4"],
["不䭀","bu2xun4"],
["不䭁","bu2zhi4"],
["不䭂","bu2yi4"],
["不䭄","bu2shi4"],
["不䭆","bu2ne4"],
["不䭇","bu2yi4"],
["不䭈","bu2jian4"],
["不䭐","bu2yang4"],
["不䭓","bu2en4"],
["不䭕","bu2jian4"],
["不䭖","bu2zhu4"],
["不䭘","bu2yan4"],
["不䭛","bu2dan4"],
["不䭝","bu2kuai4"],
["不䭞","bu2yi4"],
["不䭟","bu2ye4"],
["不䭡","bu2en4"],
["不䭥","bu2xue4"],
["不䭨","bu2shui4"],
["不䭩","bu2mi4"],
["不䭮","bu2bi4"],
["不䭳","bu2wei4"],
["不䭸","bu2fu4"],
["不䭿","bu2yi4"],
["不䮇","bu2yu4"],
["不䮋","bu2li4"],
["不䮎","bu2xi4"],
["不䮑","bu2lei4"],
["不䮓","bu2zhao4"],
["不䮕","bu2chuo4"],
["不䮗","bu2an4"],
["不䮙","bu2yu4"],
["不䮚","bu2leng4"],
["不䮛","bu2fu4"],
["不䮜","bu2sha4"],
["不䮞","bu2chu4"],
["不䮡","bu2bi4"],
["不䮥","bu2li4"],
["不䮬","bu2mo4"],
["不䮭","bu2mi4"],
["不䮮","bu2mai4"],
["不䮯","bu2ao4"],
["不䮴","bu2deng4"],
["不䮹","bu2wei4"],
["不䮺","bu2ji4"],
["不䮻","bu2chi4"],
["不䯀","bu2nie4"],
["不䯅","bu2nie4"],
["不䯆","bu2yi4"],
["不䯉","bu2ya4"],
["不䯊","bu2qia4"],
["不䯎","bu2gan4"],
["不䯗","bu2bi4"],
["不䯘","bu2huan4"],
["不䯙","bu2po4"],
["不䯜","bu2ti4"],
["不䯟","bu2dui4"],
["不䯣","bu2gui4"],
["不䯤","bu2kuai4"],
["不䯥","bu2an4"],
["不䯦","bu2ma4"],
["不䯫","bu2hao4"],
["不䯰","bu2jie4"],
["不䯱","bu2fu4"],
["不䯵","bu2nie4"],
["不䯸","bu2ci4"],
["不䯺","bu2kuo4"],
["不䰁","bu2fei4"],
["不䰂","bu2cai4"],
["不䰄","bu2shi4"],
["不䰍","bu2ci4"],
["不䰎","bu2gui4"],
["不䰏","bu2ji4"],
["不䰛","bu2li4"],
["不䰜","bu2li4"],
["不䰝","bu2zeng4"],
["不䰡","bu2chi4"],
["不䰢","bu2xing4"],
["不䰥","bu2huo4"],
["不䰨","bu2mei4"],
["不䰪","bu2mei4"],
["不䰭","bu2nou4"],
["不䰲","bu2ya4"],
["不䰴","bu2qi4"],
["不䰷","bu2bang4"],
["不䰺","bu2jie4"],
["不䰽","bu2bei4"],
["不䰾","bu2ba4"],
["不䱄","bu2jie4"],
["不䱅","bu2mo4"],
["不䱇","bu2shan4"],
["不䱉","bu2shan4"],
["不䱍","bu2geng4"],
["不䱎","bu2geng4"],
["不䱒","bu2yi4"],
["不䱚","bu2lu4"],
["不䱛","bu2xu4"],
["不䱜","bu2cuo4"],
["不䱝","bu2ba4"],
["不䱟","bu2ju4"],
["不䱠","bu2zhan4"],
["不䱤","bu2xian4"],
["不䱨","bu2zhi4"],
["不䱫","bu2la4"],
["不䱭","bu2geng4"],
["不䱰","bu2zhong4"],
["不䱱","bu2di4"],
["不䱴","bu2geng4"],
["不䱹","bu2na4"],
["不䱿","bu2chan4"],
["不䲁","bu2wei4"],
["不䲒","bu2xie4"],
["不䲚","bu2lai4"],
["不䲜","bu2ye4"],
["不䲞","bu2li4"],
["不䲟","bu2yin4"],
["不䲧","bu2du4"],
["不䲪","bu2xi4"],
["不䲰","bu2yun4"],
["不䲴","bu2zhen4"],
["不䲵","bu2hu4"],
["不䲸","bu2jie4"],
["不䲺","bu2gan4"],
["不䳉","bu2dan4"],
["不䳎","bu2jiu4"],
["不䳏","bu2gui4"],
["不䳐","bu2ci4"],
["不䳔","bu2jiu4"],
["不䳖","bu2nei4"],
["不䳛","bu2yan4"],
["不䳝","bu2bu4"],
["不䳟","bu2kou4"],
["不䳪","bu2juan4"],
["不䳬","bu2e4"],
["不䳮","bu2mo4"],
["不䳱","bu2wu4"],
["不䳲","bu2zhen4"],
["不䳳","bu2xu4"],
["不䳵","bu2chi4"],
["不䳹","bu2kou4"],
["不䳺","bu2yan4"],
["不䳽","bu2he4"],
["不䴁","bu2yu4"],
["不䴂","bu2hang4"],
["不䴄","bu2li4"],
["不䴏","bu2yan4"],
["不䴕","bu2lie4"],
["不䴙","bu2pi4"],
["不䴝","bu2bu4"],
["不䴡","bu2li4"],
["不䴪","bu2lu4"],
["不䴬","bu2yi4"],
["不䴮","bu2shan4"],
["不䴲","bu2mo4"],
["不䴳","bu2he4"],
["不䴴","bu2tie4"],
["不䴺","bu2bu4"],
["不䴽","bu2bai4"],
["不䵁","bu2qiang4"],
["不䵃","bu2kuang4"],
["不䵇","bu2xian4"],
["不䵑","bu2ni4"],
["不䵒","bu2ni4"],
["不䵕","bu2ju4"],
["不䵖","bu2jian4"],
["不䵘","bu2sha4"],
["不䵛","bu2jian4"],
["不䵝","bu2ya4"],
["不䵞","bu2jing4"],
["不䵢","bu2mei4"],
["不䵥","bu2she4"],
["不䵦","bu2xie4"],
["不䵧","bu2zai4"],
["不䵪","bu2gun4"],
["不䵫","bu2yu4"],
["不䵬","bu2ta4"],
["不䵭","bu2zhe4"],
["不䵮","bu2yang4"],
["不䵱","bu2he4"],
["不䵲","bu2diao4"],
["不䵳","bu2wei4"],
["不䵴","bu2yun4"],
["不䵽","bu2ca4"],
["不䵿","bu2tie4"],
["不䶀","bu2ta4"],
["不䶁","bu2ta4"],
["不䶇","bu2zhou4"],
["不䶊","bu2nv4"],
["不䶌","bu2pao4"],
["不䶍","bu2di4"],
["不䶎","bu2sha4"],
["不䶐","bu2kuai4"],
["不䶑","bu2ti4"],
["不䶓","bu2ji4"],
["不䶖","bu2jin4"],
["不䶗","bu2ke4"],
["不䶘","bu2li4"],
["不䶙","bu2ju4"],
["不䶛","bu2la4"],
["不䶜","bu2gu4"],
["不䶝","bu2qia4"],
["不䶟","bu2xian4"],
["不䶩","bu2ji4"],
["不䶳","bu2yue4"],
["不丄","bu2shang4"],
["不丅","bu2xia4"],
["不万","bu2wan4"],
["不丈","bu2zhang4"],
["不上","bu2shang4"],
["不下","bu2xia4"],
["不丐","bu2gai4"],
["不世","bu2shi4"],
["不丗","bu2shi4"],
["不业","bu2ye4"],
["不並","bu2bing4"],
["不丧","bu2sang4"],
["不丯","bu2jie4"],
["不丱","bu2guan4"],
["不串","bu2chuan4"],
["不为","bu2wei4"],
["不丽","bu2li4"],
["不乂","bu2yi4"],
["不义","bu2yi4"],
["不乍","bu2zha4"],
["不乐","bu2le4"],
["不乑","bu2zhong4"],
["不乢","bu2gai4"],
["不乱","bu2luan4"],
["不乿","bu2chi4"],
["不亂","bu2luan4"],
["不亄","bu2yi4"],
["不了","bu4liao3"],
["不亊","bu2shi4"],
["不事","bu2shi4"],
["不二","bu2er4"],
["不亍","bu2chu4"],
["不互","bu2hu4"],
["不亖","bu2si4"],
["不亗","bu2sui4"],
["不亘","bu2gen4"],
["不亙","bu2gen4"],
["不亚","bu2ya4"],
["不亞","bu2ya4"],
["不亟","bu2qi4"],
["不亢","bu2kang4"],
["不亣","bu2ta4"],
["不亦","bu2yi4"],
["不亮","bu2liang4"],
["不亱","bu2ye4"],
["不亴","bu2you4"],
["不亵","bu2xie4"],
["不亿","bu2yi4"],
["不仂","bu2le4"],
["不仄","bu2ze4"],
["不介","bu2jie4"],
["不仗","bu2zhang4"],
["不付","bu2fu4"],
["不仡","bu2yi4"],
["不代","bu2dai4"],
["不令","bu2ling4"],
["不仦","bu2chao4"],
["不仫","bu2mu4"],
["不仭","bu2ren4"],
["不仯","bu2chao4"],
["不仲","bu2zhong4"],
["不仴","bu2wan4"],
["不件","bu2jian4"],
["不价","bu2jia4"],
["不任","bu2ren4"],
["不份","bu2fen4"],
["不伂","bu2pei4"],
["不伄","bu2diao4"],
["不伅","bu2dun4"],
["不伆","bu2wen4"],
["不伇","bu2yi4"],
["不伉","bu2kang4"],
["不伌","bu2ai4"],
["不伎","bu2ji4"],
["不伒","bu2jin4"],
["不众","bu2zhong4"],
["不会","bu2hui4"],
["不伜","bu2cui4"],
["不伣","bu2xian4"],
["不伨","bu2xun4"],
["不伩","bu2xin4"],
["不伫","bu2zhu4"],
["不伳","bu2xie4"],
["不伴","bu2ban4"],
["不伵","bu2xu4"],
["不伷","bu2zhou4"],
["不伺","bu2ci4"],
["不似","bu2si4"],
["不伿","bu2yi4"],
["不佀","bu2si4"],
["不佃","bu2dian4"],
["不佅","bu2mai4"],
["不但","bu2dan4"],
["不佇","bu2zhu4"],
["不佈","bu2bu4"],
["不佋","bu2shao4"],
["不位","bu2wei4"],
["不住","bu2zhu4"],
["不佑","bu2you4"],
["不佔","bu2zhan4"],
["不佖","bu2bi4"],
["不佚","bu2yi4"],
["不作","bu2zuo4"],
["不佞","bu2ning4"],
["不佩","bu2pei4"],
["不佫","bu2he4"],
["不佴","bu2er4"],
["不併","bu2bing4"],
["不佽","bu2ci4"],
["不佾","bu2yi4"],
["不例","bu2li4"],
["不侍","bu2shi4"],
["不侐","bu2xu4"],
["不侑","bu2you4"],
["不侓","bu2lu4"],
["不侘","bu2cha4"],
["不侙","bu2chi4"],
["不侚","bu2xun4"],
["不侟","bu2jian4"],
["不侢","bu2zai4"],
["不侧","bu2ce4"],
["不侩","bu2kuai4"],
["不侫","bu2ning4"],
["不侲","bu2zhen4"],
["不侳","bu2zuo4"],
["不侸","bu2shu4"],
["不侺","bu2shen4"],
["不便","bu2bian4"],
["不係","bu2xi4"],
["不促","bu2cu4"],
["不俈","bu2ku4"],
["不俊","bu2jun4"],
["不俋","bu2yi4"],
["不俏","bu2qiao4"],
["不俐","bu2li4"],
["不俒","bu2hun4"],
["不俓","bu2jing4"],
["不俔","bu2xian4"],
["不俕","bu2san4"],
["不俟","bu2si4"],
["不信","bu2xin4"],
["不俤","bu2ti4"],
["不俪","bu2li4"],
["不俰","bu2he4"],
["不俱","bu2ju4"],
["不俲","bu2xiao4"],
["不俴","bu2jian4"],
["不俶","bu2chu4"],
["不俷","bu2fei4"],
["不俸","bu2feng4"],
["不俹","bu2ya4"],
["不俻","bu2bei4"],
["不俼","bu2yu4"],
["不俿","bu2jian4"],
["不倂","bu2bing4"],
["不倅","bu2cui4"],
["不倊","bu2zong4"],
["不倍","bu2bei4"],
["不倒","bu2dao4"],
["不倖","bu2xing4"],
["不候","bu2hou4"],
["不倜","bu2ti4"],
["不倝","bu2gan4"],
["不倞","bu2jing4"],
["不借","bu2jie4"],
["不倡","bu2chang4"],
["不倦","bu2juan4"],
["不倨","bu2ju4"],
["不倩","bu2qian4"],
["不倱","bu2hun4"],
["不倳","bu2zi4"],
["不倴","bu2ben4"],
["不倷","bu2nai4"],
["不债","bu2zhai4"],
["不倽","bu2sha4"],
["不偄","bu2nuan4"],
["不偅","bu2zhong4"],
["不偈","bu2ji4"],
["不偌","bu2ruo4"],
["不偐","bu2yan4"],
["不偓","bu2wo4"],
["不偔","bu2e4"],
["不偙","bu2di4"],
["不做","bu2zuo4"],
["不偝","bu2bei4"],
["不偞","bu2ye4"],
["不偡","bu2zhan4"],
["不健","bu2jian4"],
["不偩","bu2fu4"],
["不偫","bu2zhi4"],
["不偰","bu2xie4"],
["不側","bu2ce4"],
["不偹","bu2bei4"],
["不偾","bu2fen4"],
["不傂","bu2zhi4"],
["不傃","bu2su4"],
["不傆","bu2yuan4"],
["不傉","bu2ru4"],
["不傋","bu2gou4"],
["不傌","bu2ma4"],
["不傍","bu2bang4"],
["不傐","bu2hao4"],
["不傓","bu2shan4"],
["不傔","bu2qian4"],
["不傗","bu2chu4"],
["不備","bu2bei4"],
["不傚","bu2xiao4"],
["不傝","bu2tan4"],
["不傡","bu2bing4"],
["不傤","bu2zai4"],
["不傭","bu2yong4"],
["不傲","bu2ao4"],
["不債","bu2zhai4"],
["不傶","bu2cou4"],
["不傹","bu2jing4"],
["不傺","bu2chi4"],
["不傼","bu2han4"],
["不僀","bu2di4"],
["不僃","bu2bei4"],
["不僄","bu2piao4"],
["不僇","bu2lu4"],
["不僈","bu2man4"],
["不僋","bu2tan4"],
["不働","bu2dong4"],
["不僎","bu2zhuan4"],
["不像","bu2xiang4"],
["不僐","bu2shan4"],
["不僜","bu2deng4"],
["不僡","bu2hui4"],
["不僣","bu2jian4"],
["不僤","bu2dan4"],
["不僦","bu2jiu4"],
["不僨","bu2fen4"],
["不僩","bu2xian4"],
["不僫","bu2e4"],
["不僭","bu2jian4"],
["不僮","bu2zhuang4"],
["不僱","bu2gu4"],
["不僴","bu2xian4"],
["不僷","bu2ye4"],
["不僸","bu2jin4"],
["不價","bu2jia4"],
["不僺","bu2qiao4"],
["不僻","bu2pi4"],
["不僽","bu2zhou4"],
["不僾","bu2ai4"],
["不僿","bu2sai4"],
["不儁","bu2jun4"],
["不億","bu2yi4"],
["不儈","bu2kuai4"],
["不儊","bu2chu4"],
["不儋","bu2dan4"],
["不儎","bu2zai4"],
["不儑","bu2an4"],
["不儙","bu2qian4"],
["不儠","bu2lie4"],
["不儣","bu2kuang4"],
["不儤","bu2bao4"],
["不儩","bu2si4"],
["不儬","bu2chen4"],
["不儭","bu2chen4"],
["不儮","bu2li4"],
["不儳","bu2chan4"],
["不儵","bu2shu4"],
["不儶","bu2hui4"],
["不儷","bu2li4"],
["不儾","bu2nang4"],
["不兀","bu2wu4"],
["不兆","bu2zhao4"],
["不兊","bu2dui4"],
["不克","bu2ke4"],
["不兌","bu2dui4"],
["不兎","bu2tu4"],
["不兑","bu2dui4"],
["不兔","bu2tu4"],
["不兕","bu2si4"],
["不入","bu2ru4"],
["不內","bu2nei4"],
["不六","bu2liu4"],
["不共","bu2gong4"],
["不兴","bu4xing1"],
["不具","bu2ju4"],
["不兽","bu2shou4"],
["不兾","bu2ji4"],
["不兿","bu2yi4"],
["不冀","bu2ji4"],
["不内","bu2nei4"],
["不冊","bu2ce4"],
["不册","bu2ce4"],
["不再","bu2zai4"],
["不冐","bu2mao4"],
["不冑","bu2zhou4"],
["不冒","bu2mao4"],
["不冓","bu2gou4"],
["不冖","bu2mi4"],
["不冟","bu2shi4"],
["不冠","bu2guan4"],
["不冣","bu2ju4"],
["不冦","bu2kou4"],
["不冨","bu2fu4"],
["不冪","bu2mi4"],
["不冱","bu2hu4"],
["不冴","bu2hu4"],
["不况","bu2kuang4"],
["不冸","bu2pan4"],
["不冻","bu2dong4"],
["不冽","bu2lie4"],
["不净","bu2jing4"],
["不凁","bu2shu4"],
["不凅","bu2gu4"],
["不凈","bu2jing4"],
["不凊","bu2jing4"],
["不凍","bu2dong4"],
["不凎","bu2gan4"],
["不凑","bu2cou4"],
["不凓","bu2li4"],
["不凚","bu2jin4"],
["不凤","bu2feng4"],
["不凳","bu2deng4"],
["不凷","bu2kuai4"],
["不凼","bu2dang4"],
["不刃","bu2ren4"],
["不刄","bu2ren4"],
["不切","bu2qie4"],
["不刈","bu2yi4"],
["不刋","bu2qian4"],
["不划","bu2hua4"],
["不刖","bu2yue4"],
["不列","bu2lie4"],
["不创","bu2chuang4"],
["不刞","bu2qu4"],
["不判","bu2pan4"],
["不利","bu2li4"],
["不到","bu2dao4"],
["不刱","bu2chuang4"],
["不刴","bu2duo4"],
["不刵","bu2er4"],
["不制","bu2zhi4"],
["不券","bu2quan4"],
["不刺","bu2ci4"],
["不刻","bu2ke4"],
["不刽","bu2gui4"],
["不刾","bu2ci4"],
["不刿","bu2gui4"],
["不剁","bu2duo4"],
["不剂","bu2ji4"],
["不剃","bu2ti4"],
["不剉","bu2cuo4"],
["不剋","bu2ke4"],
["不剏","bu2chuang4"],
["不剒","bu2cuo4"],
["不剕","bu2fei4"],
["不剙","bu2chuang4"],
["不剚","bu2zi4"],
["不剡","bu2shan4"],
["不剧","bu2ju4"],
["不剨","bu2huo4"],
["不剩","bu2sheng4"],
["不副","bu2fu4"],
["不剱","bu2jian4"],
["不創","bu2chuang4"],
["不剹","bu2lu4"],
["不劅","bu2zhuo4"],
["不劇","bu2ju4"],
["不劊","bu2gui4"],
["不劌","bu2gui4"],
["不劎","bu2jian4"],
["不劑","bu2ji4"],
["不劒","bu2jian4"],
["不劓","bu2yi4"],
["不劔","bu2jian4"],
["不力","bu2li4"],
["不劝","bu2quan4"],
["不办","bu2ban4"],
["不劢","bu2mai4"],
["不劣","bu2lie4"],
["不劤","bu2jin4"],
["不动","bu2dong4"],
["不助","bu2zhu4"],
["不劭","bu2shao4"],
["不劮","bu2yi4"],
["不励","bu2li4"],
["不劲","bu2jin4"],
["不劵","bu2juan4"],
["不劽","bu2lie4"],
["不势","bu2shi4"],
["不勀","bu2ke4"],
["不勁","bu2jin4"],
["不勅","bu2chi4"],
["不勊","bu2ke4"],
["不勌","bu2juan4"],
["不勎","bu2lu4"],
["不勑","bu2lai4"],
["不勒","bu2le4"],
["不勓","bu2kai4"],
["不動","bu2dong4"],
["不勖","bu2xu4"],
["不勗","bu2xu4"],
["不勚","bu2yi4"],
["不勝","bu2sheng4"],
["不募","bu2mu4"],
["不勠","bu2lu4"],
["不勡","bu2piao4"],
["不勢","bu2shi4"],
["不勩","bu2yi4"],
["不勬","bu2juan4"],
["不勮","bu2ju4"],
["不勱","bu2mai4"],
["不勴","bu2lv4"],
["不勵","bu2li4"],
["不勶","bu2che4"],
["不勸","bu2quan4"],
["不勽","bu2bao4"],
["不勿","bu2wu4"],
["不匃","bu2gai4"],
["不匄","bu2gai4"],
["不匎","bu2an4"],
["不匓","bu2jiu4"],
["不化","bu2hua4"],
["不匛","bu2jiu4"],
["不匞","bu2jiang4"],
["不匟","bu2kang4"],
["不匥","bu2bian4"],
["不匧","bu2qie4"],
["不匮","bu2kui4"],
["不匯","bu2hui4"],
["不匱","bu2kui4"],
["不匶","bu2jiu4"],
["不匼","bu2qia4"],
["不匿","bu2ni4"],
["不卂","bu2xin4"],
["不卄","bu2nian4"],
["不卅","bu2sa4"],
["不卉","bu2hui4"],
["不半","bu2ban4"],
["不卋","bu2shi4"],
["不卍","bu2wan4"],
["不卐","bu2wan4"],
["不卒","bu2cu4"],
["不卖","bu2mai4"],
["不卛","bu2lv4"],
["不卝","bu2kuang4"],
["不卞","bu2bian4"],
["不占","bu2zhan4"],
["不卦","bu2gua4"],
["不卧","bu2wo4"],
["不卨","bu2xie4"],
["不卫","bu2wei4"],
["不印","bu2yin4"],
["不却","bu2que4"],
["不卶","bu2shi4"],
["不卸","bu2xie4"],
["不卹","bu2xu4"],
["不卻","bu2que4"],
["不卼","bu2wu4"],
["不卾","bu2e4"],
["不厄","bu2e4"],
["不历","bu2li4"],
["不厉","bu2li4"],
["不厌","bu2yan4"],
["不厍","bu2she4"],
["不厔","bu2zhi4"],
["不厕","bu2ce4"],
["不厙","bu2she4"],
["不厚","bu2hou4"],
["不厝","bu2cuo4"],
["不厞","bu2fei4"],
["不厠","bu2ce4"],
["不厤","bu2li4"],
["不厦","bu2sha4"],
["不厩","bu2jiu4"],
["不厭","bu2yan4"],
["不厯","bu2li4"],
["不厲","bu2li4"],
["不厺","bu2qu4"],
["不去","bu2qu4"],
["不县","bu2xian4"],
["不叆","bu2ai4"],
["不叇","bu2dai4"],
["不又","bu2you4"],
["不叏","bu2guai4"],
["不叒","bu2ruo4"],
["不叓","bu2shi4"],
["不受","bu2shou4"],
["不变","bu2bian4"],
["不叙","bu2xu4"],
["不叛","bu2pan4"],
["不叝","bu2gao4"],
["不叞","bu2wei4"],
["不叡","bu2rui4"],
["不句","bu2ju4"],
["不另","bu2ling4"],
["不叩","bu2kou4"],
["不叫","bu2jiao4"],
["不召","bu2zhao4"],
["不叱","bu2chi4"],
["不右","bu2you4"],
["不叶","bu2ye4"],
["不号","bu2hao4"],
["不叹","bu2tan4"],
["不叻","bu2le4"],
["不各","bu2ge4"],
["不吊","bu2diao4"],
["不吋","bu2cun4"],
["不后","bu2hou4"],
["不吏","bu2li4"],
["不向","bu2xiang4"],
["不吒","bu2zha4"],
["不吓","bu2xia4"],
["不吝","bu2lin4"],
["不吠","bu2fei4"],
["不吢","bu2qin4"],
["不吣","bu2qin4"],
["不吤","bu2jie4"],
["不吥","bu2bu4"],
["不吷","bu2xue4"],
["不吿","bu2gao4"],
["不呁","bu2jun4"],
["不呃","bu2e4"],
["不告","bu2gao4"],
["不呌","bu2jiao4"],
["不呓","bu2yi4"],
["不呖","bu2li4"],
["不呛","bu2qiang4"],
["不呝","bu2e4"],
["不呤","bu2ling4"],
["不呩","bu2shi4"],
["不呪","bu2zhou4"],
["不呬","bu2xi4"],
["不呭","bu2yi4"],
["不呮","bu2qi4"],
["不味","bu2wei4"],
["不呹","bu2yi4"],
["不命","bu2ming4"],
["不咅","bu2pou4"],
["不咇","bu2bi4"],
["不咎","bu2jiu4"],
["不咒","bu2zhou4"],
["不咘","bu2bu4"],
["不咞","bu2xian4"],
["不咟","bu2huo4"],
["不咠","bu2qi4"],
["不咡","bu2er4"],
["不咢","bu2e4"],
["不咤","bu2zha4"],
["不咮","bu2zhou4"],
["不咰","bu2shuai4"],
["不咲","bu2xiao4"],
["不咶","bu2huai4"],
["不咹","bu2e4"],
["不咽","bu2yan4"],
["不哊","bu2yu4"],
["不哌","bu2pai4"],
["不哔","bu2bi4"],
["不哙","bu2kuai4"],
["不哜","bu2ji4"],
["不哠","bu2hao4"],
["不哨","bu2shao4"],
["不哯","bu2xian4"],
["不哴","bu2liang4"],
["不哷","bu2le4"],
["不哻","bu2han4"],
["不唁","bu2yan4"],
["不唈","bu2yi4"],
["不唉","bu2ai4"],
["不唕","bu2zao4"],
["不唚","bu2qin4"],
["不唛","bu2ma4"],
["不唣","bu2zao4"],
["不唤","bu2huan4"],
["不售","bu2shou4"],
["不唱","bu2chang4"],
["不唳","bu2li4"],
["不唴","bu2qiang4"],
["不唶","bu2jie4"],
["不唸","bu2nian4"],
["不唼","bu2sha4"],
["不唾","bu2tuo4"],
["不啂","bu2nou4"],
["不啈","bu2heng4"],
["不問","bu2wen4"],
["不啐","bu2cui4"],
["不啑","bu2sha4"],
["不啖","bu2dan4"],
["不啗","bu2dan4"],
["不啘","bu2ye4"],
["不啛","bu2cui4"],
["不啜","bu2chuo4"],
["不啩","bu2gua4"],
["不啬","bu2se4"],
["不啭","bu2zhuan4"],
["不啮","bu2nie4"],
["不啲","bu2di4"],
["不啸","bu2xiao4"],
["不啻","bu2chi4"],
["不啿","bu2dan4"],
["不喂","bu2wei4"],
["不善","bu2shan4"],
["不喅","bu2yu4"],
["不喐","bu2yu4"],
["不喙","bu2hui4"],
["不喚","bu2huan4"],
["不喛","bu2huan4"],
["不喟","bu2kui4"],
["不喢","bu2sha4"],
["不喦","bu2nie4"],
["不喨","bu2liang4"],
["不喪","bu2sang4"],
["不喭","bu2yan4"],
["不喺","bu2xi4"],
["不喻","bu2yu4"],
["不喾","bu2ku4"],
["不喿","bu2zao4"],
["不嗀","bu2huo4"],
["不嗃","bu2he4"],
["不嗅","bu2xiu4"],
["不嗆","bu2qiang4"],
["不嗇","bu2se4"],
["不嗉","bu2su4"],
["不嗌","bu2yi4"],
["不嗐","bu2hai4"],
["不嗑","bu2ke4"],
["不嗒","bu2ta4"],
["不嗕","bu2ru4"],
["不嗜","bu2shi4"],
["不嗠","bu2luo4"],
["不嗢","bu2wa4"],
["不嗣","bu2si4"],
["不嗫","bu2nie4"],
["不嗮","bu2sai4"],
["不嗰","bu2ge4"],
["不嗶","bu2bi4"],
["不嗼","bu2mo4"],
["不嘂","bu2jiao4"],
["不嘆","bu2tan4"],
["不嘒","bu2hui4"],
["不嘜","bu2ma4"],
["不嘦","bu2jiao4"],
["不嘨","bu2xiao4"],
["不嘯","bu2xiao4"],
["不嘳","bu2kui4"],
["不嘼","bu2xiu4"],
["不噀","bu2xun4"],
["不噁","bu2wu4"],
["不噈","bu2cu4"],
["不噉","bu2dan4"],
["不噊","bu2yu4"],
["不噍","bu2jiao4"],
["不噐","bu2qi4"],
["不噛","bu2nie4"],
["不噟","bu2ying4"],
["不噣","bu2zhou4"],
["不噤","bu2jin4"],
["不噧","bu2hui4"],
["不器","bu2qi4"],
["不噩","bu2e4"],
["不噪","bu2zao4"],
["不噬","bu2shi4"],
["不噭","bu2jiao4"],
["不噲","bu2kuai4"],
["不噵","bu2dao4"],
["不嚂","bu2lan4"],
["不嚃","bu2ta4"],
["不嚇","bu2xia4"],
["不嚈","bu2ya4"],
["不嚊","bu2xi4"],
["不嚌","bu2ji4"],
["不嚍","bu2jin4"],
["不嚏","bu2ti4"],
["不嚔","bu2ti4"],
["不嚖","bu2hui4"],
["不嚙","bu2nie4"],
["不嚛","bu2hu4"],
["不嚜","bu2mo4"],
["不嚥","bu2yan4"],
["不嚦","bu2li4"],
["不嚪","bu2dan4"],
["不嚫","bu2chen4"],
["不嚮","bu2xiang4"],
["不嚯","bu2huo4"],
["不嚱","bu2xi4"],
["不嚳","bu2ku4"],
["不嚺","bu2ta4"],
["不嚽","bu2chuo4"],
["不嚿","bu2huo4"],
["不囀","bu2zhuan4"],
["不囁","bu2nie4"],
["不囃","bu2ca4"],
["不囆","bu2chai4"],
["不囇","bu2li4"],
["不囈","bu2yi4"],
["不囋","bu2zan4"],
["不囓","bu2nie4"],
["不四","bu2si4"],
["不囟","bu2xin4"],
["不囥","bu2kang4"],
["不囩","bu2yun4"],
["不困","bu2kun4"],
["不囸","bu2ri4"],
["不固","bu2gu4"],
["不囿","bu2you4"],
["不圂","bu2hun4"],
["不圑","bu2fu4"],
["不圔","bu2e4"],
["不圙","bu2lve4"],
["不圚","bu2hui4"],
["不圛","bu2yi4"],
["不圠","bu2ya4"],
["不圣","bu2sheng4"],
["不圥","bu2lu4"],
["不在","bu2zai4"],
["不圫","bu2yu4"],
["不圳","bu2zhen4"],
["不圵","bu2dang4"],
["不圶","bu2qia4"],
["不圹","bu2kuang4"],
["不圼","bu2nie4"],
["不圽","bu2mo4"],
["不坋","bu2fen4"],
["不坌","bu2ben4"],
["不坏","bu2huai4"],
["不坐","bu2zuo4"],
["不坒","bu2bi4"],
["不坔","bu2di4"],
["不坖","bu2ji4"],
["不块","bu2kuai4"],
["不坜","bu2li4"],
["不坝","bu2ba4"],
["不坞","bu2wu4"],
["不坠","bu2zhui4"],
["不坫","bu2dian4"],
["不坬","bu2gua4"],
["不坳","bu2ao4"],
["不坴","bu2lu4"],
["不坶","bu2mu4"],
["不坸","bu2gou4"],
["不坹","bu2xue4"],
["不坼","bu2che4"],
["不坾","bu2zhu4"],
["不坿","bu2fu4"],
["不垁","bu2zhi4"],
["不垇","bu2ao4"],
["不垌","bu2dong4"],
["不垍","bu2ji4"],
["不垎","bu2ke4"],
["不垏","bu2lu4"],
["不垕","bu2hou4"],
["不垗","bu2zhao4"],
["不垛","bu2duo4"],
["不垢","bu2gou4"],
["不垩","bu2e4"],
["不垫","bu2dian4"],
["不垱","bu2dang4"],
["不垷","bu2xian4"],
["不垸","bu2huan4"],
["不垻","bu2ba4"],
["不垼","bu2yi4"],
["不垽","bu2yin4"],
["不垾","bu2han4"],
["不垿","bu2xu4"],
["不埆","bu2que4"],
["不埈","bu2xun4"],
["不埊","bu2di4"],
["不埌","bu2lang4"],
["不埍","bu2xuan4"],
["不埒","bu2lie4"],
["不埓","bu2lie4"],
["不埗","bu2bu4"],
["不埝","bu2nian4"],
["不域","bu2yu4"],
["不埠","bu2bu4"],
["不埣","bu2sui4"],
["不埧","bu2ju4"],
["不埭","bu2dai4"],
["不埮","bu2tan4"],
["不埰","bu2cai4"],
["不埶","bu2yi4"],
["不埸","bu2yi4"],
["不埽","bu2sao4"],
["不埾","bu2ju4"],
["不堁","bu2ke4"],
["不堄","bu2ni4"],
["不堉","bu2yu4"],
["不堊","bu2e4"],
["不堌","bu2gu4"],
["不堍","bu2tu4"],
["不堑","bu2qian4"],
["不堓","bu2an4"],
["不堕","bu2duo4"],
["不堛","bu2bi4"],
["不堜","bu2lian4"],
["不堟","bu2zhuan4"],
["不堠","bu2hou4"],
["不堨","bu2e4"],
["不堩","bu2geng4"],
["不堰","bu2yan4"],
["不報","bu2bao4"],
["不堷","bu2yin4"],
["不堹","bu2zhong4"],
["不堺","bu2jie4"],
["不塂","bu2xiang4"],
["不塅","bu2duan4"],
["不塈","bu2ji4"],
["不塊","bu2kuai4"],
["不塐","bu2su4"],
["不塑","bu2su4"],
["不塓","bu2mi4"],
["不塙","bu2que4"],
["不塛","bu2li4"],
["不塝","bu2bang4"],
["不塟","bu2zang4"],
["不塢","bu2wu4"],
["不塦","bu2zhen4"],
["不塧","bu2ai4"],
["不塮","bu2xie4"],
["不塯","bu2liu4"],
["不塴","bu2beng4"],
["不塶","bu2cu4"],
["不塹","bu2qian4"],
["不塻","bu2mo4"],
["不墁","bu2man4"],
["不境","bu2jing4"],
["不墅","bu2shu4"],
["不墆","bu2di4"],
["不墈","bu2kan4"],
["不墊","bu2dian4"],
["不墍","bu2xi4"],
["不墓","bu2mu4"],
["不墕","bu2yan4"],
["不墜","bu2zhui4"],
["不墠","bu2shan4"],
["不墡","bu2shan4"],
["不墤","bu2kuai4"],
["不墧","bu2que4"],
["不墨","bu2mo4"],
["不墭","bu2sheng4"],
["不墮","bu2duo4"],
["不墯","bu2duo4"],
["不墱","bu2deng4"],
["不墷","bu2ye4"],
["不墺","bu2ao4"],
["不墿","bu2yi4"],
["不壁","bu2bi4"],
["不壂","bu2dian4"],
["不壉","bu2ju4"],
["不壋","bu2dang4"],
["不壍","bu2qian4"],
["不壏","bu2lan4"],
["不壑","bu2he4"],
["不壒","bu2ai4"],
["不壙","bu2kuang4"],
["不壞","bu2huai4"],
["不壡","bu2rui4"],
["不壢","bu2li4"],
["不壩","bu2ba4"],
["不士","bu2shi4"],
["不壮","bu2zhuang4"],
["不壯","bu2zhuang4"],
["不売","bu2mai4"],
["不壵","bu2zhuang4"],
["不壻","bu2xu4"],
["不夀","bu2shou4"],
["不处","bu2chu4"],
["不夅","bu2jiang4"],
["不备","bu2bei4"],
["不変","bu2bian4"],
["不复","bu2fu4"],
["不夎","bu2zuo4"],
["不夏","bu2xia4"],
["不夐","bu2xiong4"],
["不夓","bu2xia4"],
["不外","bu2wai4"],
["不夗","bu2yuan4"],
["不夙","bu2su4"],
["不夜","bu2ye4"],
["不够","bu2gou4"],
["不夠","bu2gou4"],
["不夡","bu2qi4"],
["不夢","bu2meng4"],
["不夣","bu2meng4"],
["不夦","bu2chen4"],
["不大","bu2da4"],
["不夨","bu2ze4"],
["不太","bu2tai4"],
["不夬","bu2guai4"],
["不夳","bu2tai4"],
["不夽","bu2yun4"],
["不奂","bu2huan4"],
["不奃","bu2di4"],
["不奅","bu2pao4"],
["不奈","bu2nai4"],
["不奉","bu2feng4"],
["不奋","bu2fen4"],
["不奏","bu2zou4"],
["不奐","bu2huan4"],
["不契","bu2qi4"],
["不奓","bu2zha4"],
["不奕","bu2yi4"],
["不套","bu2tao4"],
["不奞","bu2xun4"],
["不奠","bu2dian4"],
["不奡","bu2ao4"],
["不奥","bu2ao4"],
["不奦","bu2wu4"],
["不奧","bu2ao4"],
["不奭","bu2shi4"],
["不奮","bu2fen4"],
["不奯","bu2huo4"],
["不奼","bu2cha4"],
["不奿","bu2fan4"],
["不妁","bu2shuo4"],
["不妄","bu2wang4"],
["不妇","bu2fu4"],
["不妊","bu2ren4"],
["不妌","bu2jing4"],
["不妎","bu2xie4"],
["不妏","bu2wen4"],
["不妒","bu2du4"],
["不妓","bu2ji4"],
["不妕","bu2zhong4"],
["不妗","bu2jin4"],
["不妙","bu2miao4"],
["不妜","bu2yue4"],
["不妟","bu2yan4"],
["不妠","bu2na4"],
["不妪","bu2yu4"],
["不妬","bu2du4"],
["不妹","bu2mei4"],
["不妺","bu2mo4"],
["不妼","bu2bi4"],
["不妾","bu2qie4"],
["不姅","bu2ban4"],
["不姒","bu2si4"],
["不姓","bu2xing4"],
["不姖","bu2ju4"],
["不姙","bu2ren4"],
["不姠","bu2shang4"],
["不姡","bu2kuo4"],
["不姤","bu2gou4"],
["不姩","bu2nian4"],
["不姭","bu2xian4"],
["不姲","bu2yan4"],
["不姴","bu2lie4"],
["不姵","bu2pei4"],
["不姷","bu2you4"],
["不姹","bu2cha4"],
["不娅","bu2ya4"],
["不娊","bu2xian4"],
["不娋","bu2shao4"],
["不娎","bu2xiao4"],
["不娔","bu2ke4"],
["不娕","bu2lai4"],
["不娖","bu2chuo4"],
["不娗","bu2ding4"],
["不娜","bu2na4"],
["不娡","bu2zhi4"],
["不娣","bu2di4"],
["不娧","bu2tui4"],
["不娨","bu2han4"],
["不娰","bu2si4"],
["不娷","bu2shui4"],
["不娽","bu2lu4"],
["不婏","bu2fu4"],
["不婙","bu2jing4"],
["不婝","bu2dian4"],
["不婞","bu2xing4"],
["不婟","bu2hu4"],
["不婠","bu2wa4"],
["不婢","bu2bi4"],
["不婥","bu2chuo4"],
["不婦","bu2fu4"],
["不婧","bu2jing4"],
["不婩","bu2yan4"],
["不婭","bu2ya4"],
["不婯","bu2li4"],
["不婳","bu2hua4"],
["不婸","bu2dang4"],
["不婺","bu2wu4"],
["不婻","bu2nan4"],
["不婼","bu2chuo4"],
["不婿","bu2xu4"],
["不媍","bu2fu4"],
["不媑","bu2zhong4"],
["不媚","bu2mei4"],
["不媟","bu2xie4"],
["不媡","bu2lian4"],
["不媢","bu2mao4"],
["不媦","bu2wei4"],
["不媨","bu2jiu4"],
["不媲","bu2pi4"],
["不媵","bu2ying4"],
["不媷","bu2ru4"],
["不媾","bu2gou4"],
["不媿","bu2kui4"],
["不嫁","bu2jia4"],
["不嫊","bu2su4"],
["不嫒","bu2ai4"],
["不嫓","bu2pi4"],
["不嫕","bu2yi4"],
["不嫗","bu2yu4"],
["不嫚","bu2man4"],
["不嫟","bu2ni4"],
["不嫤","bu2jin4"],
["不嫧","bu2ce4"],
["不嫩","bu2nen4"],
["不嫪","bu2lao4"],
["不嫭","bu2hu4"],
["不嫮","bu2hu4"],
["不嫯","bu2ao4"],
["不嫰","bu2nen4"],
["不嫳","bu2pie4"],
["不嫼","bu2mo4"],
["不嫿","bu2hua4"],
["不嬇","bu2hui4"],
["不嬊","bu2yan4"],
["不嬎","bu2fan4"],
["不嬑","bu2yi4"],
["不嬒","bu2wei4"],
["不嬓","bu2jiao4"],
["不嬔","bu2fu4"],
["不嬕","bu2shi4"],
["不嬗","bu2shan4"],
["不嬘","bu2sui4"],
["不嬟","bu2yi4"],
["不嬡","bu2ai4"],
["不嬧","bu2jin4"],
["不嬹","bu2xing4"],
["不嬺","bu2ni4"],
["不嬿","bu2yan4"],
["不孕","bu2yun4"],
["不字","bu2zi4"],
["不孛","bu2bei4"],
["不孝","bu2xiao4"],
["不孞","bu2xin4"],
["不孟","bu2meng4"],
["不孠","bu2si4"],
["不季","bu2ji4"],
["不孱","bu2can4"],
["不孹","bu2bo4"],
["不孼","bu2nie4"],
["不孽","bu2nie4"],
["不宍","bu2rou4"],
["不宓","bu2mi4"],
["不宕","bu2dang4"],
["不宙","bu2zhou4"],
["不定","bu2ding4"],
["不宜","bu4yi2"],
["不客","bu2ke4"],
["不室","bu2shi4"],
["不宥","bu2you4"],
["不宪","bu2xian4"],
["不宱","bu2zha4"],
["不害","bu2hai4"],
["不宴","bu2yan4"],
["不宻","bu2mi4"],
["不宼","bu2kou4"],
["不宿","bu2su4"],
["不寀","bu2cai4"],
["不寂","bu2ji4"],
["不寄","bu2ji4"],
["不密","bu2mi4"],
["不寇","bu2kou4"],
["不寉","bu2que4"],
["不富","bu2fu4"],
["不寎","bu2bing4"],
["不寐","bu2mei4"],
["不寓","bu2yu4"],
["不寖","bu2jin4"],
["不寘","bu2zhi4"],
["不寞","bu2mo4"],
["不寠","bu2ju4"],
["不寤","bu2wu4"],
["不寨","bu2zhai4"],
["不寭","bu2hui4"],
["不寯","bu2jun4"],
["不寱","bu2yi4"],
["不寴","bu2qin4"],
["不寸","bu2cun4"],
["不对","bu2dui4"],
["不寽","bu2lv4"],
["不射","bu2she4"],
["不尅","bu2ke4"],
["不尉","bu2wei4"],
["不尌","bu2shu4"],
["不對","bu2dui4"],
["不尙","bu2shang4"],
["不尚","bu2shang4"],
["不尞","bu2liao4"],
["不尥","bu2liao4"],
["不尦","bu2liao4"],
["不尬","bu2ga4"],
["不尮","bu2duo4"],
["不尯","bu2kui4"],
["不就","bu2jiu4"],
["不尽","bu2jin4"],
["不尿","bu2niao4"],
["不屁","bu2pi4"],
["不屃","bu2xi4"],
["不屆","bu2jie4"],
["不届","bu2jie4"],
["不屑","bu2xie4"],
["不屓","bu2xi4"],
["不屚","bu2lou4"],
["不屝","bu2fei4"],
["不屟","bu2xie4"],
["不屦","bu2ju4"],
["不屧","bu2xie4"],
["不屨","bu2ju4"],
["不屭","bu2xi4"],
["不屮","bu2che4"],
["不屰","bu2ni4"],
["不屴","bu2li4"],
["不屹","bu2yi4"],
["不屻","bu2ren4"],
["不屼","bu2wu4"],
["不屽","bu2han4"],
["不岁","bu2sui4"],
["不岄","bu2yue4"],
["不岉","bu2wu4"],
["不岋","bu2e4"],
["不岔","bu2cha4"],
["不岕","bu2jie4"],
["不岘","bu2xian4"],
["不岙","bu2ao4"],
["不岝","bu2zuo4"],
["不岞","bu2zuo4"],
["不岠","bu2ju4"],
["不岤","bu2xue4"],
["不岦","bu2li4"],
["不岫","bu2xiu4"],
["不岲","bu2kuang4"],
["不岳","bu2yue4"],
["不岵","bu2hu4"],
["不岶","bu2po4"],
["不岸","bu2an4"],
["不峀","bu2xiu4"],
["不峄","bu2yi4"],
["不峈","bu2luo4"],
["不峊","bu2fu4"],
["不峍","bu2lu4"],
["不峒","bu2dong4"],
["不峙","bu2zhi4"],
["不峚","bu2mi4"],
["不峟","bu2you4"],
["不峤","bu2jiao4"],
["不峪","bu2yu4"],
["不峭","bu2qiao4"],
["不峴","bu2xian4"],
["不峻","bu2jun4"],
["不峼","bu2hao4"],
["不崀","bu2lang4"],
["不崅","bu2que4"],
["不崉","bu2ta4"],
["不崋","bu2hua4"],
["不崒","bu2cui4"],
["不崓","bu2gu4"],
["不崸","bu2dun4"],
["不崻","bu2zhi4"],
["不崼","bu2shi4"],
["不崿","bu2e4"],
["不嵀","bu2zhu4"],
["不嵂","bu2lv4"],
["不嵊","bu2sheng4"],
["不嵌","bu2qian4"],
["不嵍","bu2wu4"],
["不嵗","bu2sui4"],
["不嵲","bu2nie4"],
["不嵹","bu2jiang4"],
["不嶂","bu2zhang4"],
["不嶎","bu2yu4"],
["不嶘","bu2zhan4"],
["不嶝","bu2deng4"],
["不嶞","bu2duo4"],
["不嶠","bu2jiao4"],
["不嶧","bu2yi4"],
["不嶪","bu2ye4"],
["不嶫","bu2ye4"],
["不嶭","bu2e4"],
["不嶰","bu2xie4"],
["不嶳","bu2di4"],
["不嶴","bu2ao4"],
["不嶽","bu2yue4"],
["不巁","bu2li4"],
["不巜","bu2gui4"],
["不巨","bu2ju4"],
["不差","bu2cha4"],
["不巷","bu2xiang4"],
["不巺","bu2xun4"],
["不巽","bu2xun4"],
["不币","bu2bi4"],
["不市","bu2shi4"],
["不布","bu2bu4"],
["不帅","bu2shuai4"],
["不帇","bu2nie4"],
["不帊","bu2pa4"],
["不帍","bu2hu4"],
["不帎","bu2dan4"],
["不帐","bu2zhang4"],
["不帒","bu2dai4"],
["不帓","bu2ma4"],
["不帔","bu2pei4"],
["不帕","bu2pa4"],
["不帙","bu2zhi4"],
["不帜","bu2zhi4"],
["不帝","bu2di4"],
["不帞","bu2mo4"],
["不帟","bu2yi4"],
["不帠","bu2yi4"],
["不帢","bu2qia4"],
["不帥","bu2shuai4"],
["不带","bu2dai4"],
["不帨","bu2shui4"],
["不帩","bu2qiao4"],
["不帱","bu2dao4"],
["不帳","bu2zhang4"],
["不帶","bu2dai4"],
["不帹","bu2qie4"],
["不帽","bu2mao4"],
["不幂","bu2mi4"],
["不幄","bu2wo4"],
["不幆","bu2yi4"],
["不幎","bu2mi4"],
["不幔","bu2man4"],
["不幕","bu2mu4"],
["不幛","bu2zhang4"],
["不幟","bu2zhi4"],
["不幣","bu2bi4"],
["不幦","bu2mi4"],
["不幬","bu2dao4"],
["不幭","bu2mie4"],
["不干","bu2gan4"],
["不并","bu2bing4"],
["不幷","bu2bing4"],
["不幸","bu2xing4"],
["不幹","bu2gan4"],
["不幻","bu2huan4"],
["不幼","bu2you4"],
["不庂","bu2ze4"],
["不庆","bu2qing4"],
["不庇","bu2bi4"],
["不庉","bu2dun4"],
["不庍","bu2bai4"],
["不庎","bu2jie4"],
["不序","bu2xu4"],
["不库","bu2ku4"],
["不店","bu2dian4"],
["不庙","bu2miao4"],
["不废","bu2fei4"],
["不庢","bu2zhi4"],
["不庤","bu2zhi4"],
["不度","bu2du4"],
["不座","bu2zuo4"],
["不庫","bu2ku4"],
["不庳","bu2bi4"],
["不庶","bu2shu4"],
["不庻","bu2shu4"],
["不庽","bu2yu4"],
["不庿","bu2miao4"],
["不廁","bu2ce4"],
["不廄","bu2jiu4"],
["不廆","bu2hui4"],
["不廇","bu2liu4"],
["不廈","bu2sha4"],
["不廌","bu2zhi4"],
["不廏","bu2jiu4"],
["不廐","bu2jiu4"],
["不廓","bu2kuo4"],
["不廕","bu2yin4"],
["不廗","bu2dai4"],
["不廘","bu2lu4"],
["不廙","bu2yi4"],
["不廟","bu2miao4"],
["不廢","bu2fei4"],
["不廥","bu2kuai4"],
["不廦","bu2bi4"],
["不廨","bu2xie4"],
["不廹","bu2po4"],
["不建","bu2jian4"],
["不廿","bu2nian4"],
["不弁","bu2bian4"],
["不异","bu2yi4"],
["不弃","bu2qi4"],
["不弄","bu2nong4"],
["不弉","bu2zang4"],
["不弊","bu2bi4"],
["不弋","bu2yi4"],
["不弍","bu2er4"],
["不式","bu2shi4"],
["不弑","bu2shi4"],
["不弒","bu2shi4"],
["不弔","bu2diao4"],
["不弖","bu2hu4"],
["不弜","bu2jiang4"],
["不弝","bu2ba4"],
["不弟","bu2di4"],
["不弪","bu2jing4"],
["不弱","bu2ruo4"],
["不弳","bu2jing4"],
["不弶","bu2jiang4"],
["不弹","bu2dan4"],
["不弻","bu2bi4"],
["不弼","bu2bi4"],
["不弽","bu2she4"],
["不彀","bu2gou4"],
["不彃","bu2bi4"],
["不彆","bu2bie4"],
["不彈","bu2dan4"],
["不彉","bu2kuo4"],
["不彍","bu2kuo4"],
["不彐","bu2ji4"],
["不彑","bu2ji4"],
["不当","bu2dang4"],
["不彔","bu2lu4"],
["不录","bu2lu4"],
["不彖","bu2tuan4"],
["不彗","bu2hui4"],
["不彘","bu2zhi4"],
["不彙","bu2hui4"],
["不彚","bu2hui4"],
["不彟","bu2huo4"],
["不彠","bu2huo4"],
["不彥","bu2yan4"],
["不彦","bu2yan4"],
["不彧","bu2yu4"],
["不彳","bu2chi4"],
["不役","bu2yi4"],
["不彻","bu2che4"],
["不径","bu2jing4"],
["不待","bu2dai4"],
["不徇","bu2xun4"],
["不律","bu2lv4"],
["不後","bu2hou4"],
["不徏","bu2zhi4"],
["不徑","bu2jing4"],
["不得","bu4de2"],
["不徛","bu2qi4"],
["不徝","bu2zhi4"],
["不御","bu2yu4"],
["不徢","bu2xie4"],
["不徣","bu2jie4"],
["不徤","bu2jian4"],
["不徧","bu2bian4"],
["不復","bu2fu4"],
["不徱","bu2piao4"],
["不徶","bu2bie4"],
["不徹","bu2che4"],
["不徿","bu2long4"],
["不忁","bu2bao4"],
["不必","bu2bi4"],
["不忆","bu2yi4"],
["不忇","bu2le4"],
["不忊","bu2ding4"],
["不忌","bu2ji4"],
["不忏","bu2chan4"],
["不忑","bu2te4"],
["不忒","bu2te4"],
["不忔","bu2qi4"],
["不忕","bu2shi4"],
["不志","bu2zhi4"],
["不忘","bu2wang4"],
["不忢","bu2wu4"],
["不忥","bu2xi4"],
["不忦","bu2ye4"],
["不忨","bu2wan4"],
["不快","bu2kuai4"],
["不忬","bu2yu4"],
["不忭","bu2bian4"],
["不忮","bu2zhi4"],
["不忰","bu2cui4"],
["不忲","bu2tai4"],
["不念","bu2nian4"],
["不忿","bu2fen4"],
["不态","bu2tai4"],
["不怅","bu2chang4"],
["不怆","bu2chuang4"],
["不怇","bu2ju4"],
["不怈","bu2yi4"],
["不怍","bu2zuo4"],
["不怏","bu2yang4"],
["不怐","bu2kou4"],
["不怑","bu2ban4"],
["不怒","bu2nu4"],
["不怕","bu2pa4"],
["不怖","bu2bu4"],
["不怘","bu2gu4"],
["不怙","bu2hu4"],
["不怚","bu2ju4"],
["不怞","bu2zhou4"],
["不怟","bu2di4"],
["不怠","bu2dai4"],
["不性","bu2xing4"],
["不怨","bu2yuan4"],
["不怪","bu2guai4"],
["不怬","bu2xi4"],
["不怭","bu2bi4"],
["不怯","bu2qie4"],
["不怰","bu2xuan4"],
["不怴","bu2xu4"],
["不怵","bu2chu4"],
["不怼","bu2dui4"],
["不怿","bu2yi4"],
["不恁","bu2nen4"],
["不恃","bu2shi4"],
["不恄","bu2xi4"],
["不恋","bu2lian4"],
["不恔","bu2xiao4"],
["不恕","bu2shu4"],
["不恙","bu2yang4"],
["不恚","bu2hui4"],
["不恜","bu2chi4"],
["不恠","bu2guai4"],
["不恡","bu2lin4"],
["不恣","bu2zi4"],
["不恤","bu2xu4"],
["不恦","bu2xiang4"],
["不恧","bu2nv4"],
["不恨","bu2hen4"],
["不恪","bu2ke4"],
["不恫","bu2dong4"],
["不息","bu4xi1"],
["不恰","bu2qia4"],
["不恱","bu2yue4"],
["不恵","bu2hui4"],
["不恶","bu2e4"],
["不恸","bu2tong4"],
["不恻","bu2ce4"],
["不恽","bu2yun4"],
["不悅","bu2yue4"],
["不悆","bu2yu4"],
["不悇","bu2yu4"],
["不悈","bu2jie4"],
["不悋","bu2lin4"],
["不悌","bu2ti4"],
["不悍","bu2han4"],
["不悎","bu2hao4"],
["不悏","bu2qie4"],
["不悐","bu2ti4"],
["不悑","bu2bu4"],
["不悒","bu2yi4"],
["不悓","bu2qian4"],
["不悖","bu2bei4"],
["不悞","bu2wu4"],
["不悟","bu2wu4"],
["不悢","bu2liang4"],
["不患","bu2huan4"],
["不悥","bu2yi4"],
["不悦","bu2yue4"],
["不悧","bu2li4"],
["不悫","bu2que4"],
["不悮","bu2wu4"],
["不悴","bu2cui4"],
["不悵","bu2chang4"],
["不悶","bu2men4"],
["不悷","bu2li4"],
["不悸","bu2ji4"],
["不悹","bu2guan4"],
["不悺","bu2guan4"],
["不悼","bu2dao4"],
["不惄","bu2ni4"],
["不惎","bu2ji4"],
["不惐","bu2yu4"],
["不惑","bu2huo4"],
["不惕","bu2ti4"],
["不惖","bu2ti4"],
["不惙","bu2chuo4"],
["不惠","bu2hui4"],
["不惡","bu2e4"],
["不惦","bu2dian4"],
["不惧","bu2ju4"],
["不惫","bu2bei4"],
["不惬","bu2qie4"],
["不惮","bu2dan4"],
["不惯","bu2guan4"],
["不惰","bu2duo4"],
["不惲","bu2yun4"],
["不惴","bu2zhui4"],
["不惵","bu2die4"],
["不惻","bu2ce4"],
["不愂","bu2bei4"],
["不愈","bu2yu4"],
["不愊","bu2bi4"],
["不愌","bu2huan4"],
["不愎","bu2bi4"],
["不意","bu2yi4"],
["不愒","bu2kai4"],
["不愓","bu2dang4"],
["不愕","bu2e4"],
["不愗","bu2mou4"],
["不愘","bu2ke4"],
["不愙","bu2ke4"],
["不愛","bu2ai4"],
["不愜","bu2qie4"],
["不愞","bu2nuo4"],
["不愠","bu2yun4"],
["不愣","bu2leng4"],
["不愤","bu2fen4"],
["不愦","bu2kui4"],
["不愧","bu2kui4"],
["不愨","bu2que4"],
["不愫","bu2su4"],
["不愬","bu2se4"],
["不愳","bu2ju4"],
["不愴","bu2chuang4"],
["不愵","bu2ni4"],
["不愻","bu2sun4"],
["不愼","bu2shen4"],
["不愿","bu2yuan4"],
["不慁","bu2hun4"],
["不慄","bu2li4"],
["不慉","bu2xu4"],
["不慊","bu2qian4"],
["不態","bu2tai4"],
["不慍","bu2yun4"],
["不慎","bu2shen4"],
["不慑","bu2she4"],
["不慓","bu2piao4"],
["不慔","bu2mo4"],
["不慕","bu2mu4"],
["不慗","bu2chi4"],
["不慝","bu2te4"],
["不慟","bu2tong4"],
["不慠","bu2ao4"],
["不慢","bu2man4"],
["不慣","bu2guan4"],
["不慤","bu2que4"],
["不慥","bu2zao4"],
["不慦","bu2jiu4"],
["不慧","bu2hui4"],
["不慭","bu2yin4"],
["不慰","bu2wei4"],
["不慴","bu2she4"],
["不慶","bu2qing4"],
["不慸","bu2di4"],
["不慻","bu2juan4"],
["不慾","bu2yu4"],
["不憄","bu2zhi4"],
["不憅","bu2tong4"],
["不憇","bu2qi4"],
["不憊","bu2bei4"],
["不憏","bu2chi4"],
["不憒","bu2kui4"],
["不憓","bu2hui4"],
["不憖","bu2yin4"],
["不憗","bu2yin4"],
["不憚","bu2dan4"],
["不憝","bu2dui4"],
["不憞","bu2dui4"],
["不憟","bu2su4"],
["不憡","bu2ce4"],
["不憤","bu2fen4"],
["不憦","bu2lao4"],
["不憩","bu2qi4"],
["不憱","bu2cu4"],
["不憲","bu2xian4"],
["不憶","bu2yi4"],
["不憺","bu2dan4"],
["不憾","bu2han4"],
["不懀","bu2wai4"],
["不懈","bu2xie4"],
["不懊","bu2ao4"],
["不懋","bu2mao4"],
["不懌","bu2yi4"],
["不懎","bu2se4"],
["不懏","bu2jun4"],
["不懑","bu2men4"],
["不懓","bu2ai4"],
["不懗","bu2xia4"],
["不懘","bu2chi4"],
["不懚","bu2yin4"],
["不懜","bu2meng4"],
["不懝","bu2ai4"],
["不懟","bu2dui4"],
["不懣","bu2men4"],
["不懥","bu2zhi4"],
["不懦","bu2nuo4"],
["不懧","bu2nuo4"],
["不懬","bu2kuang4"],
["不懭","bu2kuang4"],
["不懱","bu2mie4"],
["不懴","bu2chan4"],
["不懹","bu2rang4"],
["不懺","bu2chan4"],
["不懻","bu2ji4"],
["不懼","bu2ju4"],
["不懾","bu2she4"],
["不懿","bu2yi4"],
["不戀","bu2lian4"],
["不戅","bu2gang4"],
["不戆","bu2zhuang4"],
["不戇","bu2zhuang4"],
["不戉","bu2yue4"],
["不戊","bu2wu4"],
["不戍","bu2shu4"],
["不戏","bu2xi4"],
["不戒","bu2jie4"],
["不或","bu2huo4"],
["不战","bu2zhan4"],
["不戙","bu2dong4"],
["不戤","bu2gai4"],
["不戫","bu2yu4"],
["不戮","bu2lu4"],
["不戰","bu2zhan4"],
["不戲","bu2xi4"],
["不戴","bu2dai4"],
["不戶","bu2hu4"],
["不户","bu2hu4"],
["不戹","bu2e4"],
["不戺","bu2shi4"],
["不戻","bu2li4"],
["不戽","bu2hu4"],
["不戾","bu2li4"],
["不扂","bu2dian4"],
["不扇","bu2shan4"],
["不扈","bu2hu4"],
["不扐","bu2le4"],
["不扗","bu2zai4"],
["不扙","bu2zhang4"],
["不扞","bu2han4"],
["不扢","bu2xi4"],
["不扣","bu2kou4"],
["不扤","bu2wu4"],
["不扨","bu2ren4"],
["不扩","bu2kuo4"],
["不扷","bu2ao4"],
["不扻","bu2zi4"],
["不扼","bu2e4"],
["不扽","bu2den4"],
["不技","bu2ji4"],
["不抃","bu2bian4"],
["不抈","bu2yue4"],
["不抋","bu2qin4"],
["不抐","bu2nu4"],
["不抑","bu2yi4"],
["不抗","bu2kang4"],
["不护","bu2hu4"],
["不报","bu2bao4"],
["不抱","bu2bao4"],
["不抴","bu2yi4"],
["不抶","bu2chi4"],
["不抺","bu2mei4"],
["不拀","bu2chu4"],
["不拌","bu2ban4"],
["不拒","bu2ju4"],
["不拓","bu2ta4"],
["不拜","bu2bai4"],
["不括","bu2kuo4"],
["不拭","bu2shi4"],
["不拺","bu2ce4"],
["不拽","bu2ye4"],
["不挀","bu2bo4"],
["不挂","bu2gua4"],
["不挃","bu2zhi4"],
["不挄","bu2kuo4"],
["不挈","bu2qie4"],
["不按","bu2an4"],
["不挊","bu2nong4"],
["不挋","bu2zhen4"],
["不挍","bu2jiao4"],
["不挎","bu2kua4"],
["不挏","bu2dong4"],
["不挒","bu2lie4"],
["不挚","bu2zhi4"],
["不挜","bu2ya4"],
["不挞","bu2ta4"],
["不挫","bu2cuo4"],
["不振","bu2zhen4"],
["不挵","bu2long4"],
["不挹","bu2yi4"],
["不挼","bu2nuo4"],
["不捃","bu2jun4"],
["不捄","bu2jiu4"],
["不捇","bu2huo4"],
["不捋","bu2le4"],
["不捍","bu2han4"],
["不捗","bu2bu4"],
["不捘","bu2zun4"],
["不捙","bu2yi4"],
["不换","bu2huan4"],
["不捥","bu2wan4"],
["不捩","bu2lie4"],
["不据","bu2ju4"],
["不捳","bu2yue4"],
["不捹","bu2ben4"],
["不捺","bu2na4"],
["不捾","bu2wo4"],
["不掅","bu2qing4"],
["不授","bu2shou4"],
["不掉","bu2diao4"],
["不掕","bu2ling4"],
["不掗","bu2ya4"],
["不掛","bu2gua4"],
["不掝","bu2huo4"],
["不掞","bu2shan4"],
["不掠","bu2lve4"],
["不探","bu2tan4"],
["不掣","bu2che4"],
["不掦","bu2ti4"],
["不控","bu2kong4"],
["不措","bu2cuo4"],
["不掭","bu2tian4"],
["不掯","bu2ken4"],
["不掷","bu2zhi4"],
["不掼","bu2guan4"],
["不掽","bu2peng4"],
["不掾","bu2yuan4"],
["不掿","bu2nuo4"],
["不揊","bu2pi4"],
["不揍","bu2zou4"],
["不揓","bu2shi4"],
["不揕","bu2zhen4"],
["不揙","bu2bian4"],
["不換","bu2huan4"],
["不揝","bu2zuan4"],
["不揠","bu2ya4"],
["不握","bu2wo4"],
["不揢","bu2ke4"],
["不揥","bu2ti4"],
["不揧","bu2la4"],
["不揰","bu2chong4"],
["不揱","bu2shuo4"],
["不揳","bu2xie4"],
["不揾","bu2wen4"],
["不揿","bu2qin4"],
["不搆","bu2gou4"],
["不搇","bu2qin4"],
["不搉","bu2que4"],
["不搐","bu2chu4"],
["不搒","bu2bang4"],
["不搕","bu2ke4"],
["不搙","bu2nu4"],
["不搠","bu2shuo4"],
["不搢","bu2jin4"],
["不搣","bu2mie4"],
["不搤","bu2e4"],
["不搦","bu2nuo4"],
["不搨","bu2ta4"],
["不搮","bu2li4"],
["不搱","bu2zhi4"],
["不搵","bu2wen4"],
["不搹","bu2e4"],
["不搻","bu2nuo4"],
["不搾","bu2zha4"],
["不摁","bu2en4"],
["不摄","bu2she4"],
["不摈","bu2bin4"],
["不摋","bu2sa4"],
["不摒","bu2bing4"],
["不摕","bu2di4"],
["不摖","bu2qi4"],
["不摜","bu2guan4"],
["不摝","bu2lu4"],
["不摞","bu2luo4"],
["不摡","bu2gai4"],
["不摢","bu2hu4"],
["不摥","bu2tang4"],
["不摦","bu2hua4"],
["不摬","bu2ying4"],
["不摯","bu2zhi4"],
["不摰","bu2nie4"],
["不摲","bu2shan4"],
["不摾","bu2jiang4"],
["不撀","bu2gou4"],
["不撂","bu2liao4"],
["不撊","bu2xian4"],
["不撌","bu2kui4"],
["不撎","bu2yi4"],
["不撔","bu2heng4"],
["不撞","bu2zhuang4"],
["不撤","bu2che4"],
["不撪","bu2ben4"],
["不撬","bu2qiao4"],
["不撰","bu2zhuan4"],
["不撳","bu2qin4"],
["不撻","bu2ta4"],
["不撼","bu2han4"],
["不撽","bu2qiao4"],
["不擂","bu2lei4"],
["不擅","bu2shan4"],
["不擉","bu2chuo4"],
["不擏","bu2jing4"],
["不擐","bu2huan4"],
["不擘","bu2bo4"],
["不擙","bu2ao4"],
["不據","bu2ju4"],
["不擛","bu2ye4"],
["不擪","bu2ye4"],
["不擫","bu2ye4"],
["不擭","bu2huo4"],
["不擯","bu2bin4"],
["不擲","bu2zhi4"],
["不擴","bu2kuo4"],
["不擶","bu2jian4"],
["不擸","bu2lie4"],
["不擽","bu2lve4"],
["不攂","bu2lei4"],
["不攃","bu2sa4"],
["不攈","bu2jun4"],
["不攉","bu2huo4"],
["不攊","bu2li4"],
["不攋","bu2la4"],
["不攌","bu2han4"],
["不攝","bu2she4"],
["不攟","bu2jun4"],
["不攥","bu2zuan4"],
["不攦","bu2li4"],
["不攭","bu2li4"],
["不攰","bu2gui4"],
["不放","bu2fang4"],
["不政","bu2zheng4"],
["不敂","bu2kou4"],
["不敄","bu2wu4"],
["不故","bu2gu4"],
["不敇","bu2ce4"],
["不效","bu2xiao4"],
["不敊","bu2chu4"],
["不敍","bu2xu4"],
["不敎","bu2jiao4"],
["不救","bu2jiu4"],
["不敒","bu2zhen4"],
["不敕","bu2chi4"],
["不敗","bu2bai4"],
["不敘","bu2xu4"],
["不教","bu2jiao4"],
["不敜","bu2nie4"],
["不敝","bu2bi4"],
["不敡","bu2yi4"],
["不散","bu2san4"],
["不敥","bu2yan4"],
["不敩","bu2xiao4"],
["不敫","bu2jiao4"],
["不敬","bu2jing4"],
["不数","bu2shu4"],
["不敶","bu2zhen4"],
["不數","bu2shu4"],
["不敻","bu2xiong4"],
["不斁","bu2yi4"],
["不斃","bu2bi4"],
["不斅","bu2xiao4"],
["不斆","bu2xiao4"],
["不斗","bu2dou4"],
["不料","bu2liao4"],
["不斠","bu2jiao4"],
["不斡","bu2wo4"],
["不斣","bu2chu4"],
["不斥","bu2chi4"],
["不断","bu2duan4"],
["不斶","bu2chu4"],
["不斷","bu2duan4"],
["不斺","bu2xie4"],
["不斾","bu2pei4"],
["不旄","bu2mao4"],
["不旆","bu2pei4"],
["不旐","bu2zhao4"],
["不旔","bu2jian4"],
["不旘","bu2zhi4"],
["不旝","bu2guai4"],
["不旞","bu2sui4"],
["不旡","bu2ji4"],
["不既","bu2ji4"],
["不旣","bu2ji4"],
["不旤","bu2huo4"],
["不日","bu2ri4"],
["不旦","bu2dan4"],
["不旧","bu2jiu4"],
["不旭","bu2xu4"],
["不旰","bu2gan4"],
["不旱","bu2han4"],
["不旳","bu2di4"],
["不旷","bu2kuang4"],
["不旺","bu2wang4"],
["不昁","bu2bei4"],
["不昃","bu2ze4"],
["不昈","bu2hu4"],
["不昊","bu2hao4"],
["不昋","bu2gui4"],
["不易","bu2yi4"],
["不昗","bu2ze4"],
["不昚","bu2shen4"],
["不昛","bu2ju4"],
["不映","bu2ying4"],
["不昡","bu2xuan4"],
["不昦","bu2hao4"],
["不昧","bu2mei4"],
["不昩","bu2mo4"],
["不昪","bu2bian4"],
["不昫","bu2xu4"],
["不昮","bu2zong4"],
["不是","bu2shi4"],
["不昰","bu2shi4"],
["不昱","bu2yu4"],
["不昲","bu2fei4"],
["不昳","bu2yi4"],
["不昵","bu2ni4"],
["不昼","bu2zhou4"],
["不昿","bu2kuang4"],
["不晏","bu2yan4"],
["不晒","bu2shai4"],
["不晔","bu2ye4"],
["不晘","bu2han4"],
["不晙","bu2jun4"],
["不晛","bu2xian4"],
["不晝","bu2zhou4"],
["不晟","bu2sheng4"],
["不晤","bu2wu4"],
["不晦","bu2hui4"],
["不晧","bu2hao4"],
["不晳","bu2xi4"],
["不晹","bu2yi4"],
["不智","bu2zhi4"],
["不晾","bu2liang4"],
["不暂","bu2zan4"],
["不暎","bu2ying4"],
["不暓","bu2mao4"],
["不暗","bu2an4"],
["不暜","bu2jin4"],
["不暢","bu2chang4"],
["不暣","bu2qi4"],
["不暤","bu2hao4"],
["不暥","bu2yan4"],
["不暦","bu2li4"],
["不暧","bu2ai4"],
["不暨","bu2ji4"],
["不暩","bu2gui4"],
["不暫","bu2zan4"],
["不暬","bu2xie4"],
["不暭","bu2hao4"],
["不暮","bu2mu4"],
["不暯","bu2mo4"],
["不暱","bu2ni4"],
["不暳","bu2hui4"],
["不暴","bu2bao4"],
["不暵","bu2han4"],
["不暺","bu2dan4"],
["不曀","bu2yi4"],
["不曁","bu2ji4"],
["不曂","bu2huang4"],
["不曃","bu2tai4"],
["不曄","bu2ye4"],
["不曅","bu2ye4"],
["不曊","bu2fei4"],
["不曌","bu2zhao4"],
["不曍","bu2hao4"],
["不曎","bu2yi4"],
["不曏","bu2xiang4"],
["不曓","bu2bao4"],
["不曔","bu2jing4"],
["不曕","bu2yan4"],
["不曖","bu2ai4"],
["不曗","bu2ye4"],
["不曜","bu2yao4"],
["不曝","bu2pu4"],
["不曞","bu2li4"],
["不曠","bu2kuang4"],
["不曣","bu2yan4"],
["不曤","bu2huo4"],
["不曬","bu2shai4"],
["不曳","bu2ye4"],
["不更","bu2geng4"],
["不曵","bu2ye4"],
["不曼","bu2man4"],
["不替","bu2ti4"],
["不最","bu2zui4"],
["不朂","bu2xu4"],
["不會","bu2hui4"],
["不朄","bu2yin4"],
["不朅","bu2qie4"],
["不月","bu2yue4"],
["不朒","bu2nv4"],
["不朓","bu2tiao4"],
["不朔","bu2shuo4"],
["不朕","bu2zhen4"],
["不望","bu2wang4"],
["不木","bu2mu4"],
["不未","bu2wei4"],
["不末","bu2mo4"],
["不朮","bu2shu4"],
["不术","bu2shu4"],
["不朸","bu2li4"],
["不朿","bu2ci4"],
["不杈","bu2cha4"],
["不杌","bu2wu4"],
["不杏","bu2xing4"],
["不杒","bu2ren4"],
["不杕","bu2di4"],
["不杖","bu2zhang4"],
["不杘","bu2chi4"],
["不杙","bu2yi4"],
["不杜","bu2du4"],
["不束","bu2shu4"],
["不杠","bu2gang4"],
["不杩","bu2ma4"],
["不杫","bu2si4"],
["不杮","bu2fei4"],
["不杹","bu2hua4"],
["不杼","bu2zhu4"],
["不枂","bu2yue4"],
["不枃","bu2jin4"],
["不构","bu2gou4"],
["不枈","bu2bi4"],
["不枊","bu2ang4"],
["不枍","bu2yi4"],
["不枑","bu2hu4"],
["不枘","bu2rui4"],
["不枙","bu2e4"],
["不枛","bu2zhao4"],
["不枟","bu2yun4"],
["不枥","bu2li4"],
["不架","bu2jia4"],
["不枺","bu2mo4"],
["不枻","bu2yi4"],
["不枼","bu2ye4"],
["不枽","bu2ye4"],
["不枾","bu2shi4"],
["不枿","bu2nie4"],
["不柋","bu2dai4"],
["不柕","bu2mao4"],
["不柚","bu2you4"],
["不柜","bu2gui4"],
["不柝","bu2tuo4"],
["不柞","bu2zuo4"],
["不柦","bu2dan4"],
["不柩","bu2jiu4"],
["不柮","bu2duo4"],
["不柰","bu2nai4"],
["不柱","bu2zhu4"],
["不柲","bu2bi4"],
["不柵","bu2zha4"],
["不柶","bu2si4"],
["不柷","bu2zhu4"],
["不柹","bu2shi4"],
["不柾","bu2jiu4"],
["不柿","bu2shi4"],
["不栃","bu2li4"],
["不栅","bu2zha4"],
["不栈","bu2zhan4"],
["不栉","bu2zhi4"],
["不栋","bu2dong4"],
["不栎","bu2li4"],
["不树","bu2shu4"],
["不栔","bu2qi4"],
["不栗","bu2li4"],
["不栚","bu2zhen4"],
["不栛","bu2li4"],
["不栜","bu2su4"],
["不校","bu2xiao4"],
["不栤","bu2bing4"],
["不栧","bu2yi4"],
["不栫","bu2jian4"],
["不栬","bu2zui4"],
["不栵","bu2li4"],
["不样","bu2yang4"],
["不桂","bu2gui4"],
["不案","bu2an4"],
["不桊","bu2juan4"],
["不桎","bu2zhi4"],
["不桖","bu2xue4"],
["不桗","bu2duo4"],
["不桘","bu2zhui4"],
["不桟","bu2zhan4"],
["不档","bu2dang4"],
["不桦","bu2hua4"],
["不桱","bu2jing4"],
["不桳","bu2ben4"],
["不梀","bu2cu4"],
["不梇","bu2long4"],
["不梊","bu2di4"],
["不梍","bu2zao4"],
["不梏","bu2gu4"],
["不梐","bu2bi4"],
["不梕","bu2ren4"],
["不梖","bu2bei4"],
["不梙","bu2huan4"],
["不梞","bu2ji4"],
["不梦","bu2meng4"],
["不梪","bu2dou4"],
["不械","bu2xie4"],
["不梵","bu2fan4"],
["不梷","bu2jing4"],
["不梽","bu2zhi4"],
["不棄","bu2qi4"],
["不棅","bu2bing4"],
["不棈","bu2qian4"],
["不棍","bu2gun4"],
["不棏","bu2te4"],
["不棒","bu2bang4"],
["不棙","bu2li4"],
["不棛","bu2yu4"],
["不棜","bu2yu4"],
["不棝","bu2gu4"],
["不棟","bu2dong4"],
["不棧","bu2zhan4"],
["不棫","bu2yu4"],
["不棭","bu2yi4"],
["不棹","bu2zhao4"],
["不棿","bu2nie4"],
["不椂","bu2lu4"],
["不椞","bu2xi4"],
["不椠","bu2qian4"],
["不椪","bu2peng4"],
["不椱","bu2fou4"],
["不椻","bu2yan4"],
["不椾","bu2zhan4"],
["不楃","bu2wo4"],
["不楅","bu2bi4"],
["不楇","bu2huo4"],
["不楉","bu2ruo4"],
["不楋","bu2la4"],
["不楐","bu2jie4"],
["不楖","bu2zhi4"],
["不楗","bu2jian4"],
["不楘","bu2mu4"],
["不楞","bu2leng4"],
["不楥","bu2xuan4"],
["不楦","bu2xuan4"],
["不業","bu2ye4"],
["不楱","bu2cou4"],
["不楴","bu2di4"],
["不概","bu2gai4"],
["不榇","bu2chen4"],
["不榍","bu2xie4"],
["不榏","bu2yi4"],
["不榑","bu2fu4"],
["不榒","bu2nai4"],
["不榓","bu2mi4"],
["不榗","bu2jian4"],
["不榢","bu2jia4"],
["不榦","bu2gan4"],
["不榨","bu2zha4"],
["不榪","bu2ma4"],
["不榭","bu2xie4"],
["不榷","bu2que4"],
["不榺","bu2sheng4"],
["不榻","bu2ta4"],
["不槈","bu2nou4"],
["不槊","bu2shuo4"],
["不構","bu2gou4"],
["不槒","bu2xu4"],
["不槓","bu2gang4"],
["不槖","bu2tuo4"],
["不槜","bu2zui4"],
["不槥","bu2hui4"],
["不槧","bu2qian4"],
["不槩","bu2gai4"],
["不槪","bu2gai4"],
["不槬","bu2hua4"],
["不槰","bu2beng4"],
["不槴","bu2hu4"],
["不槵","bu2huan4"],
["不槶","bu2kui4"],
["不槷","bu2yi4"],
["不槸","bu2nie4"],
["不樀","bu2di4"],
["不樂","bu2le4"],
["不樌","bu2guan4"],
["不樒","bu2mi4"],
["不樕","bu2su4"],
["不樚","bu2lu4"],
["不樜","bu2shu4"],
["不樣","bu2yang4"],
["不樦","bu2zhu4"],
["不樲","bu2er4"],
["不樹","bu2shu4"],
["不樺","bu2hua4"],
["不樻","bu2kui4"],
["不樾","bu2yue4"],
["不橂","bu2dian4"],
["不橉","bu2lin4"],
["不橌","bu2xian4"],
["不橍","bu2run4"],
["不橓","bu2shun4"],
["不橚","bu2su4"],
["不橞","bu2hui4"],
["不橡","bu2xiang4"],
["不橯","bu2lao4"],
["不橽","bu2ta4"],
["不檅","bu2sui4"],
["不檇","bu2zui4"],
["不檊","bu2gan4"],
["不檌","bu2zui4"],
["不檔","bu2dang4"],
["不檕","bu2ji4"],
["不檘","bu2bi4"],
["不檡","bu2zhe4"],
["不檤","bu2dao4"],
["不檵","bu2ji4"],
["不檼","bu2yin4"],
["不櫁","bu2mi4"],
["不櫂","bu2zhao4"],
["不櫃","bu2gui4"],
["不櫈","bu2deng4"],
["不櫍","bu2zhi4"],
["不櫎","bu2guang4"],
["不櫒","bu2sa4"],
["不櫔","bu2li4"],
["不櫗","bu2mie4"],
["不櫘","bu2hui4"],
["不櫛","bu2zhi4"],
["不櫟","bu2li4"],
["不櫠","bu2fei4"],
["不櫪","bu2li4"],
["不櫬","bu2chen4"],
["不櫮","bu2e4"],
["不櫱","bu2nie4"],
["不櫲","bu2yu4"],
["不櫴","bu2lai4"],
["不欇","bu2she4"],
["不欉","bu2cong4"],
["不欎","bu2yu4"],
["不欑","bu2zan4"],
["不欛","bu2ba4"],
["不欝","bu2yu4"],
["不欠","bu2qian4"],
["不次","bu2ci4"],
["不欥","bu2yu4"],
["不欪","bu2chu4"],
["不欬","bu2kai4"],
["不欭","bu2yi4"],
["不欱","bu2xia4"],
["不欲","bu2yu4"],
["不欳","bu2kuai4"],
["不欶","bu2shuo4"],
["不歃","bu2sha4"],
["不歉","bu2qian4"],
["不歎","bu2tan4"],
["不歏","bu2jin4"],
["不歒","bu2ti4"],
["不歕","bu2pen4"],
["不歗","bu2xiao4"],
["不歛","bu2han4"],
["不歝","bu2yi4"],
["不歠","bu2chuo4"],
["不正","bu2zheng4"],
["不步","bu2bu4"],
["不歨","bu2bu4"],
["不歫","bu2ju4"],
["不歮","bu2se4"],
["不歰","bu2se4"],
["不歲","bu2sui4"],
["不歴","bu2li4"],
["不歵","bu2cuo4"],
["不歷","bu2li4"],
["不歾","bu2mo4"],
["不歿","bu2mo4"],
["不殁","bu2mo4"],
["不殆","bu2dai4"],
["不殈","bu2xu4"],
["不殉","bu2xun4"],
["不殎","bu2qia4"],
["不殏","bu2qiu4"],
["不殐","bu2su4"],
["不殓","bu2lian4"],
["不殔","bu2yi4"],
["不殗","bu2ye4"],
["不殜","bu2ye4"],
["不殠","bu2chou4"],
["不殡","bu2bin4"],
["不殢","bu2ti4"],
["不殣","bu2jin4"],
["不殧","bu2cu4"],
["不殨","bu2hui4"],
["不殩","bu2cuan4"],
["不殪","bu2yi4"],
["不殬","bu2du4"],
["不殮","bu2lian4"],
["不殯","bu2bin4"],
["不段","bu2duan4"],
["不殶","bu2zhu4"],
["不殸","bu2qing4"],
["不殹","bu2yi4"],
["不殾","bu2jun4"],
["不殿","bu2dian4"],
["不毃","bu2que4"],
["不毅","bu2yi4"],
["不毈","bu2duan4"],
["不毌","bu2guan4"],
["不毓","bu2yu4"],
["不毕","bu2bi4"],
["不毖","bu2bi4"],
["不毙","bu2bi4"],
["不毣","bu2mu4"],
["不毤","bu2tuo4"],
["不毦","bu2er4"],
["不毭","bu2dou4"],
["不毳","bu2cui4"],
["不毷","bu2mao4"],
["不毻","bu2tuo4"],
["不毽","bu2jian4"],
["不氉","bu2sao4"],
["不氏","bu2shi4"],
["不气","bu2qi4"],
["不氜","bu2ri4"],
["不氝","bu2nei4"],
["不氣","bu2qi4"],
["不氦","bu2hai4"],
["不氩","bu2ya4"],
["不氪","bu2ke4"],
["不氬","bu2ya4"],
["不氮","bu2dan4"],
["不氯","bu2lv4"],
["不氹","bu2dang4"],
["不氻","bu2le4"],
["不氼","bu2ni4"],
["不氾","bu2fan4"],
["不汄","bu2ze4"],
["不汇","bu2hui4"],
["不汊","bu2cha4"],
["不汌","bu2chuan4"],
["不汎","bu2fan4"],
["不汏","bu2dai4"],
["不汔","bu2qi4"],
["不汖","bu2pai4"],
["不汗","bu2han4"],
["不汛","bu2xun4"],
["不汜","bu2si4"],
["不汫","bu2qing4"],
["不汭","bu2rui4"],
["不汰","bu2tai4"],
["不汴","bu2bian4"],
["不汵","bu2gan4"],
["不汶","bu2wen4"],
["不汽","bu2qi4"],
["不汿","bu2xu4"],
["不沀","bu2xu4"],
["不沁","bu2qin4"],
["不沃","bu2wo4"],
["不沆","bu2hang4"],
["不沊","bu2dan4"],
["不沌","bu2dun4"],
["不沍","bu2hu4"],
["不沎","bu2huo4"],
["不沐","bu2mu4"],
["不沓","bu2ta4"],
["不沕","bu2wu4"],
["不沛","bu2pei4"],
["不沜","bu2pan4"],
["不沥","bu2li4"],
["不沫","bu2mo4"],
["不沬","bu2mei4"],
["不沭","bu2shu4"],
["不沴","bu2li4"],
["不沸","bu2fei4"],
["不治","bu2zhi4"],
["不況","bu2kuang4"],
["不泃","bu2ju4"],
["不泄","bu2xie4"],
["不泆","bu2yi4"],
["不泋","bu2hui4"],
["不泌","bu2mi4"],
["不泏","bu2chu4"],
["不泐","bu2le4"],
["不泗","bu2si4"],
["不泛","bu2fan4"],
["不泝","bu2su4"],
["不泞","bu2ning4"],
["不泡","bu2pao4"],
["不泣","bu2qi4"],
["不泤","bu2si4"],
["不泧","bu2yue4"],
["不注","bu2zhu4"],
["不泪","bu2lei4"],
["不泫","bu2xuan4"],
["不泬","bu2xue4"],
["不泮","bu2pan4"],
["不泰","bu2tai4"],
["不泴","bu2guan4"],
["不泵","bu2beng4"],
["不泻","bu2xie4"],
["不洂","bu2yi4"],
["不洉","bu2hou4"],
["不洊","bu2jian4"],
["不洌","bu2lie4"],
["不洍","bu2si4"],
["不洎","bu2ji4"],
["不洚","bu2jiang4"],
["不洝","bu2an4"],
["不洞","bu2dong4"],
["不洟","bu2ti4"],
["不洦","bu2mo4"],
["不洩","bu2xie4"],
["不洫","bu2xu4"],
["不洬","bu2shuo4"],
["不洯","bu2qie4"],
["不洰","bu2ju4"],
["不洳","bu2ru4"],
["不洷","bu2zhi4"],
["不洽","bu2qia4"],
["不派","bu2pai4"],
["不浂","bu2yi4"],
["不测","bu2ce4"],
["不浍","bu2kuai4"],
["不济","bu2ji4"],
["不浕","bu2jin4"],
["不浖","bu2lie4"],
["不浚","bu2jun4"],
["不浛","bu2han4"],
["不浢","bu2dou4"],
["不浣","bu2huan4"],
["不浥","bu2yi4"],
["不浩","bu2hao4"],
["不浪","bu2lang4"],
["不浰","bu2lian4"],
["不浳","bu2yi4"],
["不浴","bu2yu4"],
["不浸","bu2jin4"],
["不浿","bu2pei4"],
["不涀","bu2xian4"],
["不涁","bu2shen4"],
["不涃","bu2kun4"],
["不涅","bu2nie4"],
["不涆","bu2han4"],
["不涉","bu2she4"],
["不涍","bu2xiao4"],
["不涑","bu2su4"],
["不涕","bu2ti4"],
["不涖","bu2li4"],
["不涗","bu2shui4"],
["不涘","bu2si4"],
["不涚","bu2shui4"],
["不涝","bu2lao4"],
["不涣","bu2huan4"],
["不润","bu2run4"],
["不涧","bu2jian4"],
["不涩","bu2se4"],
["不涫","bu2guan4"],
["不涬","bu2xing4"],
["不涭","bu2shou4"],
["不涮","bu2shuan4"],
["不涰","bu2chuo4"],
["不涱","bu2zhang4"],
["不液","bu2ye4"],
["不涴","bu2wo4"],
["不涻","bu2gan4"],
["不涾","bu2ta4"],
["不淀","bu2dian4"],
["不淁","bu2qie4"],
["不淃","bu2juan4"],
["不淏","bu2hao4"],
["不淔","bu2chi4"],
["不淕","bu2lu4"],
["不淖","bu2nao4"],
["不淚","bu2lei4"],
["不淛","bu2zhi4"],
["不淠","bu2pi4"],
["不淡","bu2dan4"],
["不淢","bu2yu4"],
["不淥","bu2lu4"],
["不淦","bu2gan4"],
["不淧","bu2mi4"],
["不淨","bu2jing4"],
["不淬","bu2cui4"],
["不淯","bu2yu4"],
["不淴","bu2wa4"],
["不混","bu2hun4"],
["不淿","bu2mi4"],
["不渂","bu2wen4"],
["不渃","bu2re4"],
["不渌","bu2lu4"],
["不渍","bu2zi4"],
["不渐","bu2jian4"],
["不渒","bu2pi4"],
["不渗","bu2shen4"],
["不渙","bu2huan4"],
["不渡","bu2du4"],
["不渥","bu2wo4"],
["不渧","bu2di4"],
["不渫","bu2xie4"],
["不測","bu2ce4"],
["不渲","bu2xuan4"],
["不渿","bu2nai4"],
["不湂","bu2e4"],
["不湃","bu2pai4"],
["不湅","bu2lian4"],
["不湆","bu2qi4"],
["不湇","bu2qi4"],
["不湊","bu2cou4"],
["不湏","bu2hui4"],
["不湐","bu2mo4"],
["不湗","bu2feng4"],
["不湙","bu2yi4"],
["不湚","bu2yin4"],
["不湛","bu2zhan4"],
["不湠","bu2tan4"],
["不湢","bu2bi4"],
["不湨","bu2qu4"],
["不湩","bu2zhong4"],
["不湱","bu2huo4"],
["不湴","bu2ban4"],
["不湸","bu2liang4"],
["不湼","bu2nie4"],
["不溃","bu2kui4"],
["不溅","bu2jian4"],
["不溆","bu2xu4"],
["不溉","bu2gai4"],
["不溍","bu2jin4"],
["不溎","bu2gui4"],
["不溕","bu2meng4"],
["不溘","bu2ke4"],
["不溙","bu2tai4"],
["不溠","bu2zha4"],
["不溢","bu2yi4"],
["不溧","bu2li4"],
["不溩","bu2wu4"],
["不溯","bu2su4"],
["不溴","bu2xiu4"],
["不溷","bu2hun4"],
["不溸","bu2su4"],
["不溹","bu2su4"],
["不溺","bu2niao4"],
["不溻","bu2ta4"],
["不溽","bu2ru4"],
["不溿","bu2pan4"],
["不滀","bu2chu4"],
["不滅","bu2mie4"],
["不滈","bu2hao4"],
["不滘","bu2jiao4"],
["不滙","bu2hui4"],
["不滞","bu2zhi4"],
["不滟","bu2yan4"],
["不滠","bu2she4"],
["不滤","bu2lv4"],
["不滥","bu2lan4"],
["不滪","bu2yu4"],
["不滭","bu2bi4"],
["不滯","bu2zhi4"],
["不滱","bu2kou4"],
["不滲","bu2shen4"],
["不滵","bu2mi4"],
["不滼","bu2fan4"],
["不漀","bu2qing4"],
["不漂","bu2piao4"],
["不漈","bu2ji4"],
["不漉","bu2lu4"],
["不漏","bu2lou4"],
["不漑","bu2gai4"],
["不漖","bu2jiao4"],
["不漞","bu2mi4"],
["不漠","bu2mo4"],
["不漫","bu2man4"],
["不漬","bu2zi4"],
["不漯","bu2ta4"],
["不漱","bu2shu4"],
["不漵","bu2xu4"],
["不漶","bu2huan4"],
["不漷","bu2kuo4"],
["不漸","bu2jian4"],
["不漾","bu2yang4"],
["不潄","bu2shu4"],
["不潅","bu2guan4"],
["不潊","bu2xu4"],
["不潋","bu2lian4"],
["不潌","bu2zhi4"],
["不潎","bu2pi4"],
["不潐","bu2jiao4"],
["不潒","bu2dang4"],
["不潓","bu2hui4"],
["不潞","bu2lu4"],
["不潟","bu2xi4"],
["不潠","bu2xun4"],
["不潡","bu2dun4"],
["不潤","bu2run4"],
["不潥","bu2su4"],
["不潩","bu2yi4"],
["不潬","bu2dan4"],
["不潰","bu2kui4"],
["不潲","bu2shao4"],
["不潵","bu2san4"],
["不澀","bu2se4"],
["不澁","bu2se4"],
["不澃","bu2jiong4"],
["不澄","bu2deng4"],
["不澅","bu2hua4"],
["不澇","bu2lao4"],
["不澈","bu2che4"],
["不澋","bu2heng4"],
["不澍","bu2shu4"],
["不澏","bu2han4"],
["不澑","bu2liu4"],
["不澒","bu2hong4"],
["不澔","bu2hao4"],
["不澗","bu2jian4"],
["不澙","bu2xi4"],
["不澥","bu2xie4"],
["不澦","bu2yu4"],
["不澨","bu2shi4"],
["不澮","bu2kuai4"],
["不澯","bu2can4"],
["不澰","bu2lian4"],
["不澱","bu2dian4"],
["不澲","bu2ye4"],
["不澳","bu2ao4"],
["不澷","bu2man4"],
["不澹","bu2dan4"],
["不澺","bu2yi4"],
["不澻","bu2sui4"],
["不澼","bu2pi4"],
["不澽","bu2ju4"],
["不澾","bu2ta4"],
["不濅","bu2jin4"],
["不濇","bu2se4"],
["不濊","bu2hui4"],
["不濌","bu2ta4"],
["不濑","bu2lai4"],
["不濖","bu2shu4"],
["不濗","bu2mi4"],
["不濘","bu2ning4"],
["不濜","bu2jin4"],
["不濞","bu2pi4"],
["不濟","bu2ji4"],
["不濣","bu2wo4"],
["不濥","bu2yin4"],
["不濧","bu2dui4"],
["不濩","bu2huo4"],
["不濪","bu2jing4"],
["不濫","bu2lan4"],
["不濬","bu2jun4"],
["不濭","bu2ai4"],
["不濶","bu2kuo4"],
["不濷","bu2fei4"],
["不濺","bu2jian4"],
["不濽","bu2zan4"],
["不濾","bu2lv4"],
["不濿","bu2li4"],
["不瀁","bu2yang4"],
["不瀃","bu2si4"],
["不瀉","bu2xie4"],
["不瀎","bu2mo4"],
["不瀑","bu2pu4"],
["不瀒","bu2se4"],
["不瀖","bu2huo4"],
["不瀗","bu2xian4"],
["不瀚","bu2han4"],
["不瀝","bu2li4"],
["不瀞","bu2jing4"],
["不瀣","bu2xie4"],
["不瀥","bu2hao4"],
["不瀨","bu2lai4"],
["不瀩","bu2dui4"],
["不瀱","bu2ji4"],
["不瀲","bu2lian4"],
["不瀳","bu2jian4"],
["不瀵","bu2fen4"],
["不瀷","bu2yi4"],
["不瀹","bu2yue4"],
["不瀻","bu2dai4"],
["不灀","bu2shuang4"],
["不灄","bu2she4"],
["不灌","bu2guan4"],
["不灍","bu2que4"],
["不灎","bu2yan4"],
["不灏","bu2hao4"],
["不灒","bu2zan4"],
["不灔","bu2yan4"],
["不灗","bu2shan4"],
["不灝","bu2hao4"],
["不灧","bu2yan4"],
["不灨","bu2gan4"],
["不灩","bu2yan4"],
["不灪","bu2yu4"],
["不灭","bu2mie4"],
["不灶","bu2zao4"],
["不灷","bu2zhuan4"],
["不灹","bu2zha4"],
["不灺","bu2xie4"],
["不灻","bu2chi4"],
["不灿","bu2can4"],
["不炁","bu2qi4"],
["不炇","bu2po4"],
["不炈","bu2yi4"],
["不炌","bu2kai4"],
["不炍","bu2pan4"],
["不炏","bu2kai4"],
["不炐","bu2pang4"],
["不炑","bu2mu4"],
["不炓","bu2liao4"],
["不炕","bu2kang4"],
["不炖","bu2dun4"],
["不炙","bu2zhi4"],
["不炝","bu2qiang4"],
["不炤","bu2zhao4"],
["不炧","bu2duo4"],
["不炨","bu2duo4"],
["不炩","bu2ling4"],
["不炫","bu2xuan4"],
["不炬","bu2ju4"],
["不炭","bu2tan4"],
["不炮","bu2pao4"],
["不炷","bu2zhu4"],
["不炸","bu2zha4"],
["不為","bu2wei4"],
["不炼","bu2lian4"],
["不炽","bu2chi4"],
["不烁","bu2shuo4"],
["不烂","bu2lan4"],
["不烅","bu2xu4"],
["不烇","bu2quan4"],
["不烈","bu2lie4"],
["不烉","bu2huan4"],
["不烒","bu2shi4"],
["不烕","bu2xue4"],
["不烗","bu2kai4"],
["不烙","bu2lao4"],
["不烞","bu2po4"],
["不烢","bu2zhe4"],
["不烨","bu2ye4"],
["不烩","bu2hui4"],
["不烫","bu2tang4"],
["不烬","bu2jin4"],
["不热","bu2re4"],
["不烲","bu2che4"],
["不烾","bu2chi4"],
["不焃","bu2he4"],
["不焅","bu2ku4"],
["不焊","bu2han4"],
["不焋","bu2zhuang4"],
["不焍","bu2di4"],
["不焎","bu2xie4"],
["不焐","bu2wu4"],
["不焔","bu2yan4"],
["不焕","bu2huan4"],
["不焖","bu2men4"],
["不焘","bu2dao4"],
["不焙","bu2bei4"],
["不焛","bu2lin4"],
["不焝","bu2hun4"],
["不焠","bu2cui4"],
["不焣","bu2ju4"],
["不焥","bu2wo4"],
["不焨","bu2feng4"],
["不焫","bu2ruo4"],
["不焮","bu2xin4"],
["不焰","bu2yan4"],
["不焱","bu2yan4"],
["不焲","bu2yi4"],
["不焴","bu2yu4"],
["不焵","bu2gang4"],
["不焻","bu2chang4"],
["不煂","bu2he4"],
["不煅","bu2duan4"],
["不煈","bu2feng4"],
["不煉","bu2lian4"],
["不煏","bu2bi4"],
["不煔","bu2tian4"],
["不煜","bu2yu4"],
["不煝","bu2mei4"],
["不煞","bu2sha4"],
["不煟","bu2wei4"],
["不煡","bu2xin4"],
["不煥","bu2huan4"],
["不煦","bu2xu4"],
["不照","bu2zhao4"],
["不煫","bu2sui4"],
["不煭","bu2lie4"],
["不煰","bu2gao4"],
["不煴","bu2yun4"],
["不煹","bu2gou4"],
["不煺","bu2tui4"],
["不熂","bu2xi4"],
["不熃","bu2wu4"],
["不熅","bu2yun4"],
["不熌","bu2shan4"],
["不熎","bu2yao4"],
["不熐","bu2mi4"],
["不熗","bu2qiang4"],
["不熚","bu2bi4"],
["不熝","bu2lu4"],
["不熠","bu2yi4"],
["不熨","bu2yun4"],
["不熩","bu2hu4"],
["不熫","bu2zhi4"],
["不熭","bu2wei4"],
["不熯","bu2han4"],
["不熱","bu2re4"],
["不熳","bu2man4"],
["不熶","bu2cuan4"],
["不熼","bu2yi4"],
["不熽","bu2xiao4"],
["不熾","bu2chi4"],
["不燁","bu2ye4"],
["不燄","bu2yan4"],
["不燇","bu2zun4"],
["不燏","bu2yu4"],
["不燕","bu2yan4"],
["不燗","bu2lan4"],
["不燙","bu2tang4"],
["不燜","bu2men4"],
["不燠","bu2yu4"],
["不燡","bu2yi4"],
["不燤","bu2tai4"],
["不燥","bu2zao4"],
["不燦","bu2can4"],
["不燧","bu2sui4"],
["不燩","bu2que4"],
["不燮","bu2xie4"],
["不燱","bu2yi4"],
["不燳","bu2zhao4"],
["不燴","bu2hui4"],
["不燼","bu2jin4"],
["不燾","bu2dao4"],
["不燿","bu2yao4"],
["不爀","bu2he4"],
["不爁","bu2lan4"],
["不爄","bu2li4"],
["不爅","bu2mo4"],
["不爆","bu2bao4"],
["不爇","bu2ruo4"],
["不爉","bu2la4"],
["不爋","bu2xun4"],
["不爌","bu2kuang4"],
["不爍","bu2shuo4"],
["不爏","bu2li4"],
["不爒","bu2liao4"],
["不爓","bu2yan4"],
["不爕","bu2xie4"],
["不爗","bu2ye4"],
["不爚","bu2yue4"],
["不爛","bu2lan4"],
["不爟","bu2guan4"],
["不爡","bu2che4"],
["不爤","bu2lan4"],
["不爨","bu2cuan4"],
["不爩","bu2yu4"],
["不爱","bu2ai4"],
["不父","bu2fu4"],
["不爸","bu2ba4"],
["不片","bu2pian4"],
["不牉","bu2pan4"],
["不牚","bu2cheng4"],
["不牝","bu2pin4"],
["不牣","bu2ren4"],
["不牧","bu2mu4"],
["不物","bu2wu4"],
["不牪","bu2yan4"],
["不牬","bu2bei4"],
["不牭","bu2si4"],
["不牮","bu2jian4"],
["不牰","bu2you4"],
["不牶","bu2quan4"],
["不牸","bu2zi4"],
["不特","bu2te4"],
["不牿","bu2gu4"],
["不犆","bu2te4"],
["不犋","bu2ju4"],
["不犒","bu2kao4"],
["不犔","bu2xi4"],
["不犕","bu2bei4"],
["不犖","bu2luo4"],
["不犗","bu2jie4"],
["不犚","bu2wei4"],
["不犟","bu2jiang4"],
["不犡","bu2li4"],
["不犣","bu2lie4"],
["不犦","bu2bao4"],
["不犩","bu2wei4"],
["不犯","bu2fan4"],
["不犴","bu2an4"],
["不犵","bu2qi4"],
["不状","bu2zhuang4"],
["不犺","bu2kang4"],
["不狀","bu2zhuang4"],
["不狇","bu2mu4"],
["不狈","bu2bei4"],
["不狒","bu2fei4"],
["不狖","bu2you4"],
["不狘","bu2yue4"],
["不狚","bu2dan4"],
["不狛","bu2po4"],
["不狣","bu2zhao4"],
["不狥","bu2xun4"],
["不狧","bu2ta4"],
["不狩","bu2shou4"],
["不狯","bu2kuai4"],
["不狱","bu2yu4"],
["不狷","bu2juan4"],
["不狽","bu2bei4"],
["不狾","bu2zhi4"],
["不猂","bu2han4"],
["不猈","bu2ba4"],
["不猌","bu2yin4"],
["不猎","bu2lie4"],
["不猔","bu2zong4"],
["不猘","bu2zhi4"],
["不猝","bu2cu4"],
["不猞","bu2she4"],
["不猤","bu2ji4"],
["不献","bu2xian4"],
["不猰","bu2ya4"],
["不猲","bu2he4"],
["不獄","bu2yu4"],
["不獈","bu2yi4"],
["不獊","bu2chuang4"],
["不獌","bu2man4"],
["不獘","bu2bi4"],
["不獙","bu2bi4"],
["不獝","bu2yu4"],
["不獞","bu2zhuang4"],
["不獟","bu2yao4"],
["不獡","bu2shuo4"],
["不獧","bu2juan4"],
["不獩","bu2hui4"],
["不獪","bu2kuai4"],
["不獲","bu2huo4"],
["不獵","bu2lie4"],
["不獸","bu2shou4"],
["不獻","bu2xian4"],
["不玅","bu2miao4"],
["不率","bu2lv4"],
["不玉","bu2yu4"],
["不玊","bu2su4"],
["不玏","bu2le4"],
["不玓","bu2di4"],
["不玔","bu2chuan4"],
["不玠","bu2jie4"],
["不玡","bu2ya4"],
["不玣","bu2bian4"],
["不玥","bu2yue4"],
["不现","bu2xian4"],
["不玳","bu2dai4"],
["不玴","bu2yi4"],
["不玷","bu2dian4"],
["不珀","bu2po4"],
["不珌","bu2bi4"],
["不珐","bu2fa4"],
["不珕","bu2li4"],
["不珛","bu2xiu4"],
["不珞","bu2luo4"],
["不珟","bu2su4"],
["不珢","bu2ken4"],
["不珦","bu2xiang4"],
["不珬","bu2xu4"],
["不珮","bu2pei4"],
["不珶","bu2di4"],
["不珺","bu2jun4"],
["不珼","bu2bei4"],
["不現","bu2xian4"],
["不珿","bu2chuo4"],
["不琍","bu2li4"],
["不琎","bu2jin4"],
["不琔","bu2dian4"],
["不琗","bu2cui4"],
["不琙","bu2yu4"],
["不琞","bu2sheng4"],
["不琡","bu2chu4"],
["不琧","bu2e4"],
["不琲","bu2bei4"],
["不琷","bu2que4"],
["不琺","bu2fa4"],
["不琾","bu2jie4"],
["不瑇","bu2dai4"],
["不瑍","bu2huan4"],
["不瑑","bu2zhuan4"],
["不瑓","bu2lian4"],
["不瑖","bu2duan4"],
["不瑗","bu2yuan4"],
["不瑞","bu2rui4"],
["不瑨","bu2jin4"],
["不瑮","bu2li4"],
["不瑱","bu2zhen4"],
["不瑷","bu2ai4"],
["不璏","bu2zhi4"],
["不璗","bu2dang4"],
["不璛","bu2su4"],
["不璡","bu2jin4"],
["不璦","bu2ai4"],
["不璧","bu2bi4"],
["不璨","bu2can4"],
["不璭","bu2gun4"],
["不璯","bu2hui4"],
["不璱","bu2se4"],
["不璲","bu2sui4"],
["不璶","bu2jin4"],
["不璹","bu2shou4"],
["不璾","bu2ji4"],
["不瓁","bu2huo4"],
["不瓂","bu2gai4"],
["不瓅","bu2li4"],
["不瓉","bu2zan4"],
["不瓍","bu2sui4"],
["不瓎","bu2la4"],
["不瓑","bu2li4"],
["不瓒","bu2zan4"],
["不瓓","bu2lan4"],
["不瓘","bu2guan4"],
["不瓙","bu2dao4"],
["不瓚","bu2zan4"],
["不瓠","bu2hu4"],
["不瓣","bu2ban4"],
["不瓥","bu2li4"],
["不瓮","bu2weng4"],
["不瓹","bu2juan4"],
["不瓽","bu2dang4"],
["不甀","bu2zhui4"],
["不甃","bu2zhou4"],
["不甈","bu2qi4"],
["不甑","bu2zeng4"],
["不甓","bu2pi4"],
["不甕","bu2weng4"],
["不甙","bu2dai4"],
["不用","bu2yong4"],
["不甪","bu2lu4"],
["不甮","bu2feng4"],
["不电","bu2dian4"],
["不甸","bu2dian4"],
["不画","bu2hua4"],
["不畀","bu2bi4"],
["不畂","bu2liu4"],
["不畅","bu2chang4"],
["不畈","bu2fan4"],
["不界","bu2jie4"],
["不畍","bu2jie4"],
["不畏","bu2wei4"],
["不畔","bu2pan4"],
["不畜","bu2chu4"],
["不畟","bu2ce4"],
["不畢","bu2bi4"],
["不略","bu2lve4"],
["不畧","bu2lve4"],
["不畫","bu2hua4"],
["不畯","bu2jun4"],
["不異","bu2yi4"],
["不畵","bu2hua4"],
["不當","bu2dang4"],
["不畷","bu2chuo4"],
["不畼","bu2chang4"],
["不疈","bu2bo4"],
["不疌","bu2nie4"],
["不疍","bu2dan4"],
["不疐","bu2zhi4"],
["不疒","bu2ni4"],
["不疚","bu2jiu4"],
["不疜","bu2xia4"],
["不疝","bu2shan4"],
["不疟","bu2yao4"],
["不疠","bu2li4"],
["不疥","bu2jie4"],
["不疩","bu2cui4"],
["不疪","bu2bi4"],
["不疫","bu2yi4"],
["不疬","bu2li4"],
["不疭","bu2zong4"],
["不疰","bu2zhu4"],
["不疱","bu2pao4"],
["不疶","bu2xie4"],
["不疿","bu2fei4"],
["不痁","bu2dian4"],
["不痄","bu2zha4"],
["不病","bu2bing4"],
["不痆","bu2ni4"],
["不症","bu2zheng4"],
["不痉","bu2jing4"],
["不痓","bu2chi4"],
["不痔","bu2zhi4"],
["不痗","bu2mei4"],
["不痘","bu2dou4"],
["不痙","bu2jing4"],
["不痛","bu2tong4"],
["不痢","bu2li4"],
["不痣","bu2zhi4"],
["不痩","bu2shou4"],
["不痪","bu2huan4"],
["不痬","bu2yi4"],
["不痮","bu2zhang4"],
["不痱","bu2fei4"],
["不痵","bu2ji4"],
["不痸","bu2chi4"],
["不痹","bu2bi4"],
["不痺","bu2bi4"],
["不痼","bu2gu4"],
["不瘁","bu2cui4"],
["不瘄","bu2cu4"],
["不瘆","bu2shen4"],
["不瘈","bu2ji4"],
["不瘉","bu2yu4"],
["不瘌","bu2la4"],
["不瘎","bu2shen4"],
["不瘓","bu2huan4"],
["不瘔","bu2ku4"],
["不瘗","bu2yi4"],
["不瘘","bu2lou4"],
["不瘙","bu2sao4"],
["不瘛","bu2chi4"],
["不瘞","bu2yi4"],
["不瘥","bu2chai4"],
["不瘦","bu2shou4"],
["不瘧","bu2yao4"],
["不瘬","bu2zhang4"],
["不瘮","bu2shen4"],
["不瘱","bu2yi4"],
["不瘲","bu2zong4"],
["不瘴","bu2zhang4"],
["不瘵","bu2zhai4"],
["不瘶","bu2sou4"],
["不瘹","bu2diao4"],
["不瘺","bu2lou4"],
["不瘻","bu2lou4"],
["不瘼","bu2mo4"],
["不瘽","bu2jin4"],
["不癈","bu2fei4"],
["不癊","bu2yin4"],
["不癋","bu2he4"],
["不癐","bu2guai4"],
["不癔","bu2yi4"],
["不癘","bu2li4"],
["不癚","bu2dan4"],
["不癜","bu2dian4"],
["不癞","bu2lai4"],
["不癠","bu2ji4"],
["不癥","bu2zheng4"],
["不癧","bu2li4"],
["不癨","bu2huo4"],
["不癩","bu2lai4"],
["不皁","bu2zao4"],
["不皂","bu2zao4"],
["不皃","bu2mao4"],
["不皌","bu2mo4"],
["不皓","bu2hao4"],
["不皔","bu2han4"],
["不皘","bu2qian4"],
["不皜","bu2hao4"],
["不皞","bu2hao4"],
["不皡","bu2hao4"],
["不皣","bu2ye4"],
["不皥","bu2hao4"],
["不皧","bu2ai4"],
["不皩","bu2huang4"],
["不皪","bu2li4"],
["不皬","bu2he4"],
["不皭","bu2jiao4"],
["不皰","bu2pao4"],
["不皱","bu2zhou4"],
["不皵","bu2que4"],
["不皺","bu2zhou4"],
["不益","bu2yi4"],
["不盎","bu2ang4"],
["不盕","bu2fan4"],
["不盖","bu2gai4"],
["不盗","bu2dao4"],
["不盛","bu2sheng4"],
["不盜","bu2dao4"],
["不盝","bu2lu4"],
["不盡","bu2jin4"],
["不盢","bu2xu4"],
["不盥","bu2guan4"],
["不盪","bu2dang4"],
["不盭","bu2li4"],
["不目","bu2mu4"],
["不盵","bu2qi4"],
["不盻","bu2xi4"],
["不盼","bu2pan4"],
["不盾","bu2dun4"],
["不眂","bu2shi4"],
["不眊","bu2mao4"],
["不看","bu2kan4"],
["不眎","bu2shi4"],
["不眒","bu2shen4"],
["不眓","bu2huo4"],
["不眔","bu2da4"],
["不眖","bu2kuang4"],
["不眘","bu2shen4"],
["不眙","bu2chi4"],
["不眛","bu2mei4"],
["不眜","bu2mo4"],
["不眝","bu2zhu4"],
["不眥","bu2zi4"],
["不眦","bu2zi4"],
["不眩","bu2xuan4"],
["不眮","bu2dong4"],
["不眲","bu2er4"],
["不眴","bu2xuan4"],
["不眶","bu2kuang4"],
["不眷","bu2juan4"],
["不眹","bu2zhen4"],
["不眺","bu2tiao4"],
["不眽","bu2mo4"],
["不眾","bu2zhong4"],
["不眿","bu2mai4"],
["不睃","bu2jun4"],
["不睄","bu2shao4"],
["不睅","bu2han4"],
["不睇","bu2di4"],
["不睊","bu2juan4"],
["不睍","bu2xian4"],
["不睏","bu2kun4"],
["不睐","bu2lai4"],
["不睗","bu2shi4"],
["不睙","bu2lie4"],
["不睞","bu2lai4"],
["不睟","bu2sui4"],
["不睠","bu2juan4"],
["不睡","bu2shui4"],
["不睤","bu2bi4"],
["不睥","bu2pi4"],
["不睦","bu2mu4"],
["不睨","bu2ni4"],
["不睩","bu2lu4"],
["不睪","bu2yi4"],
["不睰","bu2ma4"],
["不睱","bu2xia4"],
["不睴","bu2gun4"],
["不睸","bu2mei4"],
["不睿","bu2rui4"],
["不瞀","bu2mao4"],
["不瞁","bu2xu4"],
["不瞆","bu2kui4"],
["不瞉","bu2kou4"],
["不瞊","bu2dang4"],
["不瞐","bu2mao4"],
["不瞓","bu2shui4"],
["不瞕","bu2zhang4"],
["不瞖","bu2yi4"],
["不瞙","bu2mo4"],
["不瞚","bu2shun4"],
["不瞡","bu2ji4"],
["不瞪","bu2deng4"],
["不瞬","bu2shun4"],
["不瞮","bu2che4"],
["不瞰","bu2kan4"],
["不瞱","bu2ye4"],
["不瞲","bu2xu4"],
["不瞶","bu2kui4"],
["不瞷","bu2jian4"],
["不瞸","bu2ye4"],
["不瞹","bu2ai4"],
["不瞺","bu2hui4"],
["不瞾","bu2zhao4"],
["不矂","bu2sao4"],
["不矅","bu2yao4"],
["不矆","bu2huo4"],
["不矋","bu2li4"],
["不矌","bu2kuang4"],
["不矐","bu2huo4"],
["不矔","bu2guan4"],
["不矗","bu2chu4"],
["不矙","bu2kan4"],
["不矞","bu2yu4"],
["不矟","bu2shuo4"],
["不矠","bu2ce4"],
["不矴","bu2ding4"],
["不矵","bu2qi4"],
["不矹","bu2wu4"],
["不矿","bu2kuang4"],
["不砀","bu2dang4"],
["不砅","bu2li4"],
["不砉","bu2huo4"],
["不砊","bu2kang4"],
["不砌","bu2qi4"],
["不砎","bu2jie4"],
["不砐","bu2e4"],
["不砑","bu2ya4"],
["不砘","bu2dun4"],
["不砚","bu2yan4"],
["不砞","bu2mo4"],
["不砡","bu2yu4"],
["不砦","bu2zhai4"],
["不砨","bu2ai4"],
["不砲","bu2pao4"],
["不砳","bu2le4"],
["不破","bu2po4"],
["不砶","bu2po4"],
["不砹","bu2ai4"],
["不砺","bu2li4"],
["不砾","bu2li4"],
["不硆","bu2e4"],
["不硉","bu2lu4"],
["不硋","bu2ai4"],
["不硌","bu2luo4"],
["不硍","bu2ken4"],
["不硐","bu2dong4"],
["不硕","bu2shuo4"],
["不硞","bu2que4"],
["不硟","bu2chan4"],
["不硦","bu2long4"],
["不硩","bu2che4"],
["不硬","bu2ying4"],
["不确","bu2que4"],
["不硯","bu2yan4"],
["不硲","bu2yu4"],
["不硸","bu2nve4"],
["不硾","bu2zhui4"],
["不碂","bu2zong4"],
["不碋","bu2he4"],
["不碌","bu2lu4"],
["不碍","bu2ai4"],
["不碎","bu2sui4"],
["不碓","bu2dui4"],
["不碖","bu2lun4"],
["不碚","bu2bei4"],
["不碛","bu2qi4"],
["不碠","bu2ding4"],
["不碦","bu2ke4"],
["不碧","bu2bi4"],
["不碩","bu2shuo4"],
["不碫","bu2duan4"],
["不碭","bu2dang4"],
["不碰","bu2peng4"],
["不碲","bu2di4"],
["不碳","bu2tan4"],
["不碶","bu2qi4"],
["不碹","bu2xuan4"],
["不確","bu2que4"],
["不碻","bu2que4"],
["不碿","bu2su4"],
["不磂","bu2liu4"],
["不磅","bu2bang4"],
["不磘","bu2qing4"],
["不磜","bu2qi4"],
["不磟","bu2lu4"],
["不磡","bu2kan4"],
["不磧","bu2qi4"],
["不磬","bu2qing4"],
["不磭","bu2chuo4"],
["不磰","bu2shan4"],
["不磴","bu2deng4"],
["不磵","bu2jian4"],
["不磶","bu2xi4"],
["不磸","bu2ding4"],
["不磹","bu2dian4"],
["不磿","bu2li4"],
["不礇","bu2yu4"],
["不礈","bu2zhui4"],
["不礊","bu2huo4"],
["不礌","bu2lei4"],
["不礐","bu2que4"],
["不礑","bu2dang4"],
["不礔","bu2pi4"],
["不礖","bu2yu4"],
["不礘","bu2qi4"],
["不礙","bu2ai4"],
["不礚","bu2kai4"],
["不礜","bu2yu4"],
["不礟","bu2pao4"],
["不礣","bu2mie4"],
["不礦","bu2kuang4"],
["不礧","bu2lei4"],
["不礩","bu2zhi4"],
["不礪","bu2li4"],
["不礫","bu2li4"],
["不礭","bu2que4"],
["不礮","bu2pao4"],
["不礰","bu2li4"],
["不礳","bu2mo4"],
["不礶","bu2guan4"],
["不示","bu2shi4"],
["不礻","bu2shi4"],
["不社","bu2she4"],
["不礿","bu2yue4"],
["不祀","bu2si4"],
["不祄","bu2xie4"],
["不祋","bu2dui4"],
["不祌","bu2zhong4"],
["不祍","bu2ren4"],
["不祐","bu2you4"],
["不祑","bu2zhi4"],
["不祔","bu2fu4"],
["不祕","bu2mi4"],
["不祘","bu2suan4"],
["不祙","bu2mei4"],
["不祚","bu2zuo4"],
["不祜","bu2hu4"],
["不祝","bu2zhu4"],
["不祟","bu2sui4"],
["不票","bu2piao4"],
["不祭","bu2ji4"],
["不祮","bu2gao4"],
["不祰","bu2gao4"],
["不祱","bu2shui4"],
["不祶","bu2di4"],
["不祸","bu2huo4"],
["不祻","bu2gu4"],
["不祼","bu2guan4"],
["不祽","bu2zui4"],
["不祿","bu2lu4"],
["不禁","bu4jin1"],
["不禄","bu2lu4"],
["不禊","bu2xi4"],
["不禍","bu2huo4"],
["不禐","bu2yuan4"],
["不禘","bu2di4"],
["不禞","bu2gao4"],
["不禦","bu2yu4"],
["不禩","bu2si4"],
["不禪","bu2shan4"],
["不禬","bu2kuai4"],
["不禭","bu2sui4"],
["不禲","bu2li4"],
["不禴","bu2yue4"],
["不禷","bu2lei4"],
["不禼","bu2xie4"],
["不秀","bu2xiu4"],
["不秇","bu2yi4"],
["不秏","bu2hao4"],
["不秗","bu2yu4"],
["不秘","bu2mi4"],
["不秙","bu2ku4"],
["不秚","bu2ban4"],
["不秝","bu2li4"],
["不秣","bu2mo4"],
["不秤","bu2cheng4"],
["不秩","bu2zhi4"],
["不秬","bu2ju4"],
["不秲","bu2zhi4"],
["不秺","bu2du4"],
["不秽","bu2hui4"],
["不稄","bu2ze4"],
["不稅","bu2shui4"],
["不税","bu2shui4"],
["不稏","bu2ya4"],
["不稑","bu2lu4"],
["不稒","bu2gu4"],
["不稕","bu2zhun4"],
["不稖","bu2bang4"],
["不稗","bu2bai4"],
["不稚","bu2zhi4"],
["不稢","bu2yu4"],
["不稤","bu2lve4"],
["不稧","bu2xi4"],
["不稩","bu2ji4"],
["不稪","bu2fu4"],
["不稬","bu2nuo4"],
["不稶","bu2yu4"],
["不稸","bu2xu4"],
["不稺","bu2zhi4"],
["不稻","bu2dao4"],
["不穆","bu2mu4"],
["不穉","bu2zhi4"],
["不穊","bu2ji4"],
["不穋","bu2lu4"],
["不穑","bu2se4"],
["不穓","bu2yi4"],
["不穕","bu2qie4"],
["不穗","bu2sui4"],
["不穟","bu2sui4"],
["不穡","bu2se4"],
["不穢","bu2hui4"],
["不穤","bu2nuo4"],
["不穥","bu2yu4"],
["不穧","bu2ji4"],
["不穫","bu2huo4"],
["不穳","bu2zan4"],
["不穾","bu2yao4"],
["不窃","bu2qie4"],
["不窌","bu2jiao4"],
["不窍","bu2qiao4"],
["不窎","bu2diao4"],
["不窒","bu2zhi4"],
["不窖","bu2jiao4"],
["不窛","bu2kou4"],
["不窜","bu2cuan4"],
["不窞","bu2dan4"],
["不窡","bu2zhui4"],
["不窢","bu2xu4"],
["不窣","bu2su4"],
["不窦","bu2dou4"],
["不窫","bu2ya4"],
["不窭","bu2ju4"],
["不窱","bu2tiao4"],
["不窵","bu2diao4"],
["不窶","bu2ju4"],
["不窹","bu2wu4"],
["不竁","bu2cui4"],
["不竃","bu2zao4"],
["不竄","bu2cuan4"],
["不竅","bu2qiao4"],
["不竇","bu2dou4"],
["不竈","bu2zao4"],
["不竊","bu2qie4"],
["不立","bu2li4"],
["不竌","bu2chu4"],
["不竎","bu2fou4"],
["不竐","bu2chu4"],
["不竖","bu2shu4"],
["不竗","bu2miao4"],
["不站","bu2zhan4"],
["不竚","bu2zhu4"],
["不竝","bu2bing4"],
["不竞","bu2jing4"],
["不竟","bu2jing4"],
["不竢","bu2si4"],
["不竣","bu2jun4"],
["不竧","bu2jing4"],
["不竨","bu2diao4"],
["不竩","bu2yi4"],
["不竪","bu2shu4"],
["不竫","bu2jing4"],
["不競","bu2jing4"],
["不竷","bu2kan4"],
["不竸","bu2jing4"],
["不竻","bu2le4"],
["不笇","bu2suan4"],
["不笊","bu2zhao4"],
["不笍","bu2zhui4"],
["不笏","bu2hu4"],
["不笑","bu2xiao4"],
["不笝","bu2na4"],
["不笠","bu2li4"],
["不笡","bu2qie4"],
["不笥","bu2si4"],
["不笧","bu2ce4"],
["不笨","bu2ben4"],
["不笩","bu2pei4"],
["不笵","bu2fan4"],
["不笿","bu2luo4"],
["不筀","bu2gui4"],
["不筄","bu2yao4"],
["不筑","bu2zhu4"],
["不策","bu2ce4"],
["不筗","bu2zhong4"],
["不筚","bu2bi4"],
["不筞","bu2ce4"],
["不筣","bu2li4"],
["不筫","bu2zhi4"],
["不筭","bu2suan4"],
["不筮","bu2shi4"],
["不筯","bu2zhu4"],
["不筷","bu2kuai4"],
["不筻","bu2gang4"],
["不箄","bu2bi4"],
["不箅","bu2bi4"],
["不箆","bu2bi4"],
["不箇","bu2ge4"],
["不箌","bu2zhao4"],
["不箐","bu2qing4"],
["不箑","bu2sha4"],
["不箓","bu2lu4"],
["不算","bu2suan4"],
["不箘","bu2jun4"],
["不箟","bu2jun4"],
["不箣","bu2ce4"],
["不箧","bu2qie4"],
["不箨","bu2tuo4"],
["不箬","bu2ruo4"],
["不箭","bu2jian4"],
["不箸","bu2zhu4"],
["不箻","bu2lv4"],
["不箾","bu2shuo4"],
["不範","bu2fan4"],
["不篆","bu2zhuan4"],
["不築","bu2zhu4"],
["不篋","bu2qie4"],
["不篏","bu2qian4"],
["不篑","bu2kui4"],
["不篗","bu2yue4"],
["不篛","bu2ruo4"],
["不篞","bu2nie4"],
["不篟","bu2qian4"],
["不篡","bu2cuan4"],
["不篥","bu2li4"],
["不篦","bu2bi4"],
["不篰","bu2bu4"],
["不篲","bu2hui4"],
["不篳","bu2bi4"],
["不篹","bu2zhuan4"],
["不篻","bu2piao4"],
["不篾","bu2mie4"],
["不簄","bu2hu4"],
["不簆","bu2kou4"],
["不簇","bu2cu4"],
["不簉","bu2zao4"],
["不簌","bu2su4"],
["不簎","bu2zha4"],
["不簏","bu2lu4"],
["不簒","bu2cuan4"],
["不簕","bu2le4"],
["不簖","bu2duan4"],
["不簚","bu2mi4"],
["不簟","bu2dian4"],
["不簣","bu2kui4"],
["不簤","bu2dai4"],
["不簭","bu2shi4"],
["不簳","bu2gan4"],
["不簴","bu2ju4"],
["不簵","bu2du4"],
["不簶","bu2lu4"],
["不簺","bu2sai4"],
["不簿","bu2bu4"],
["不籀","bu2zhou4"],
["不籁","bu2lai4"],
["不籄","bu2kui4"],
["不籆","bu2yue4"],
["不籊","bu2ti4"],
["不籑","bu2zhuan4"],
["不籒","bu2zhou4"],
["不籕","bu2zhou4"],
["不籙","bu2lu4"],
["不籜","bu2tuo4"],
["不籞","bu2yu4"],
["不籟","bu2lai4"],
["不籥","bu2yue4"],
["不籪","bu2duan4"],
["不籰","bu2yue4"],
["不籲","bu2yu4"],
["不类","bu2lei4"],
["不籿","bu2cun4"],
["不粅","bu2wu4"],
["不粊","bu2bi4"],
["不粒","bu2li4"],
["不粔","bu2ju4"],
["不粕","bu2po4"],
["不粖","bu2mo4"],
["不粙","bu2zhou4"],
["不粜","bu2tiao4"],
["不粝","bu2li4"],
["不粟","bu2su4"],
["不粣","bu2ce4"],
["不粦","bu2lin4"],
["不粪","bu2fen4"],
["不粯","bu2xian4"],
["不粲","bu2can4"],
["不粶","bu2lu4"],
["不粹","bu2cui4"],
["不粺","bu2bai4"],
["不粽","bu2zong4"],
["不糆","bu2mian4"],
["不糉","bu2zong4"],
["不糋","bu2jian4"],
["不糏","bu2xie4"],
["不糑","bu2ni4"],
["不糒","bu2bei4"],
["不糞","bu2fen4"],
["不糡","bu2jiang4"],
["不糥","bu2nuo4"],
["不糨","bu2jiang4"],
["不糩","bu2kuai4"],
["不糭","bu2zong4"],
["不糮","bu2xian4"],
["不糯","bu2nuo4"],
["不糱","bu2nie4"],
["不糲","bu2li4"],
["不糳","bu2zuo4"],
["不糵","bu2nie4"],
["不糶","bu2tiao4"],
["不系","bu2xi4"],
["不糿","bu2you4"],
["不紀","bu2ji4"],
["不紁","bu2cha4"],
["不紉","bu2ren4"],
["不納","bu2na4"],
["不紒","bu2jie4"],
["不紝","bu2ren4"],
["不素","bu2su4"],
["不紣","bu2cui4"],
["不紨","bu2fu4"],
["不紩","bu2zhi4"],
["不累","bu2lei4"],
["不細","bu2xi4"],
["不紲","bu2xie4"],
["不紴","bu2bei4"],
["不紸","bu2zhu4"],
["不紹","bu2shao4"],
["不紺","bu2gan4"],
["不紿","bu2dai4"],
["不絀","bu2chu4"],
["不絆","bu2ban4"],
["不絇","bu2ju4"],
["不絈","bu2mo4"],
["不絉","bu2shu4"],
["不絊","bu2zui4"],
["不絍","bu2ren4"],
["不絎","bu2heng4"],
["不絏","bu2xie4"],
["不絓","bu2gua4"],
["不絖","bu2kuang4"],
["不絝","bu2ku4"],
["不絡","bu2luo4"],
["不絢","bu2xuan4"],
["不絤","bu2xian4"],
["不給","bu4ji3"],
["不絩","bu2tiao4"],
["不絬","bu2xie4"],
["不絭","bu2quan4"],
["不絮","bu2xu4"],
["不絳","bu2jiang4"],
["不絹","bu2juan4"],
["不綄","bu2wan4"],
["不綉","bu2xiu4"],
["不綌","bu2xi4"],
["不綐","bu2dui4"],
["不綔","bu2hu4"],
["不綟","bu2li4"],
["不綠","bu2lv4"],
["不綤","bu2shao4"],
["不綥","bu2qi4"],
["不綪","bu2qian4"],
["不綫","bu2xian4"],
["不綬","bu2shou4"],
["不綷","bu2cui4"],
["不綻","bu2zhan4"],
["不綽","bu2chuo4"],
["不緆","bu2yi4"],
["不緈","bu2xing4"],
["不緎","bu2yu4"],
["不緒","bu2xu4"],
["不緔","bu2zhang4"],
["不緖","bu2xu4"],
["不緙","bu2ke4"],
["不線","bu2xian4"],
["不緞","bu2duan4"],
["不緟","bu2zhong4"],
["不締","bu2di4"],
["不緤","bu2xie4"],
["不緭","bu2wei4"],
["不緮","bu2fu4"],
["不練","bu2lian4"],
["不緶","bu2bian4"],
["不緷","bu2yun4"],
["不緻","bu2zhi4"],
["不緿","bu2dai4"],
["不縉","bu2jin4"],
["不縊","bu2yi4"],
["不縋","bu2zhui4"],
["不縌","bu2ni4"],
["不縐","bu2zhou4"],
["不縕","bu2yun4"],
["不縛","bu2fu4"],
["不縟","bu2ru4"],
["不縣","bu2xian4"],
["不縤","bu2su4"],
["不縦","bu2zong4"],
["不縩","bu2cai4"],
["不縪","bu2bi4"],
["不縫","bu2feng4"],
["不縬","bu2cu4"],
["不縱","bu2zong4"],
["不縳","bu2zhuan4"],
["不縴","bu2qian4"],
["不縵","bu2man4"],
["不縸","bu2mo4"],
["不縼","bu2xuan4"],
["不繀","bu2sui4"],
["不繂","bu2shuai4"],
["不繆","bu2miao4"],
["不繋","bu2ji4"],
["不繍","bu2xiu4"],
["不繏","bu2xuan4"],
["不繐","bu2sui4"],
["不繒","bu2zeng4"],
["不繕","bu2shan4"],
["不繛","bu2chuo4"],
["不繝","bu2jian4"],
["不繞","bu2rao4"],
["不繡","bu2xiu4"],
["不繢","bu2hui4"],
["不繣","bu2hua4"],
["不繪","bu2hui4"],
["不繫","bu2xi4"],
["不繬","bu2se4"],
["不繲","bu2jie4"],
["不繴","bu2bo4"],
["不繶","bu2yi4"],
["不繸","bu2sui4"],
["不繹","bu2yi4"],
["不繼","bu2ji4"],
["不纅","bu2li4"],
["不纆","bu2mo4"],
["不纇","bu2lei4"],
["不纊","bu2kuang4"],
["不續","bu2xu4"],
["不纙","bu2luo4"],
["不纛","bu2dao4"],
["不纞","bu2lian4"],
["不纩","bu2kuang4"],
["不纪","bu2ji4"],
["不纫","bu2ren4"],
["不纳","bu2na4"],
["不纴","bu2ren4"],
["不纵","bu2zong4"],
["不线","bu2xian4"],
["不绀","bu2gan4"],
["不绁","bu2xie4"],
["不练","bu2lian4"],
["不细","bu2xi4"],
["不绉","bu2zhou4"],
["不绊","bu2ban4"],
["不绌","bu2chu4"],
["不绍","bu2shao4"],
["不绎","bu2yi4"],
["不绐","bu2dai4"],
["不绔","bu2ku4"],
["不绕","bu2rao4"],
["不绗","bu2heng4"],
["不绘","bu2hui4"],
["不给","bu4ji3"],
["不绚","bu2xuan4"],
["不绛","bu2jiang4"],
["不络","bu2luo4"],
["不绢","bu2juan4"],
["不绣","bu2xiu4"],
["不绤","bu2xi4"],
["不继","bu2ji4"],
["不绪","bu2xu4"],
["不续","bu2xu4"],
["不绰","bu2chuo4"],
["不绱","bu2shang4"],
["不绶","bu2shou4"],
["不绽","bu2zhan4"],
["不绿","bu2lv4"],
["不缂","bu2ke4"],
["不缉","bu2qi4"],
["不缊","bu2yun4"],
["不缋","bu2hui4"],
["不缎","bu2duan4"],
["不缏","bu2bian4"],
["不缐","bu2xian4"],
["不缒","bu2zhui4"],
["不缔","bu2di4"],
["不缙","bu2jin4"],
["不缚","bu2fu4"],
["不缛","bu2ru4"],
["不缝","bu2feng4"],
["不缢","bu2yi4"],
["不缦","bu2man4"],
["不缪","bu2miao4"],
["不缮","bu2shan4"],
["不缯","bu2zeng4"],
["不缷","bu2xie4"],
["不缿","bu2hou4"],
["不罄","bu2qing4"],
["不罅","bu2xia4"],
["不罆","bu2guan4"],
["不罊","bu2qi4"],
["不罋","bu2weng4"],
["不罐","bu2guan4"],
["不罥","bu2juan4"],
["不罩","bu2zhao4"],
["不罪","bu2zui4"],
["不罫","bu2gua4"],
["不罭","bu2yu4"],
["不置","bu2zhi4"],
["不罵","bu2ma4"],
["不罻","bu2wei4"],
["不罼","bu2bi4"],
["不罽","bu2ji4"],
["不羂","bu2juan4"],
["不羃","bu2mi4"],
["不羄","bu2zhao4"],
["不羍","bu2ta4"],
["不羕","bu2yang4"],
["不羛","bu2yi4"],
["不羜","bu2zhu4"],
["不羡","bu2xian4"],
["不羨","bu2xian4"],
["不義","bu2yi4"],
["不羻","bu2qiang4"],
["不羼","bu2chan4"],
["不羾","bu2gong4"],
["不羿","bu2yi4"],
["不翄","bu2chi4"],
["不翅","bu2chi4"],
["不翆","bu2cui4"],
["不翊","bu2yi4"],
["不翌","bu2yi4"],
["不翏","bu2liao4"],
["不翐","bu2zhi4"],
["不翖","bu2xi4"],
["不翘","bu2qiao4"],
["不翙","bu2hui4"],
["不翜","bu2se4"],
["不翠","bu2cui4"],
["不翣","bu2sha4"],
["不翤","bu2chi4"],
["不翥","bu2zhu4"],
["不翨","bu2shi4"],
["不翫","bu2wan4"],
["不翯","bu2he4"],
["不翰","bu2han4"],
["不翳","bu2yi4"],
["不翹","bu2qiao4"],
["不翼","bu2yi4"],
["不翽","bu2hui4"],
["不翿","bu2dao4"],
["不耀","bu2yao4"],
["不耄","bu2mao4"],
["不耊","bu2die4"],
["不耐","bu2nai4"],
["不耖","bu2chao4"],
["不耗","bu2hao4"],
["不耜","bu2si4"],
["不耟","bu2ju4"],
["不耢","bu2lao4"],
["不耨","bu2nou4"],
["不耮","bu2lao4"],
["不耯","bu2huo4"],
["不耱","bu2mo4"],
["不聅","bu2che4"],
["不聐","bu2ya4"],
["不聕","bu2hao4"],
["不聖","bu2sheng4"],
["不聗","bu2lie4"],
["不聘","bu2pin4"],
["不聚","bu2ju4"],
["不聛","bu2bi4"],
["不聟","bu2xu4"],
["不聩","bu2kui4"],
["不聭","bu2kui4"],
["不聵","bu2kui4"],
["不聿","bu2yu4"],
["不肀","bu2yu4"],
["不肁","bu2zhao4"],
["不肂","bu2si4"],
["不肃","bu2su4"],
["不肄","bu2yi4"],
["不肅","bu2su4"],
["不肆","bu2si4"],
["不肇","bu2zhao4"],
["不肈","bu2zhao4"],
["不肉","bu2rou4"],
["不肊","bu2yi4"],
["不肋","bu2lei4"],
["不肏","bu2cao4"],
["不肑","bu2di4"],
["不肕","bu2ren4"],
["不肖","bu2xiao4"],
["不肚","bu2du4"],
["不肟","bu2wo4"],
["不肨","bu2pang4"],
["不肭","bu2na4"],
["不育","bu2yu4"],
["不肵","bu2jin4"],
["不肸","bu2xi4"],
["不肺","bu2fei4"],
["不肽","bu2tai4"],
["不肾","bu2shen4"],
["不胀","bu2zhang4"],
["不胂","bu2shen4"],
["不胃","bu2wei4"],
["不胄","bu2zhou4"],
["不胇","bu2fei4"],
["不背","bu2bei4"],
["不胒","bu2ni4"],
["不胔","bu2zi4"],
["不胕","bu2fu4"],
["不胖","bu2pang4"],
["不胙","bu2zuo4"],
["不胜","bu2sheng4"],
["不胤","bu2yin4"],
["不胨","bu2dong4"],
["不胫","bu2jing4"],
["不胯","bu2kua4"],
["不胴","bu2dong4"],
["不胵","bu2zhi4"],
["不胺","bu2an4"],
["不胾","bu2zi4"],
["不脁","bu2tiao4"],
["不脃","bu2cui4"],
["不脆","bu2cui4"],
["不脈","bu2mai4"],
["不脉","bu2mai4"],
["不脍","bu2kuai4"],
["不脎","bu2sa4"],
["不脏","bu2zang4"],
["不脛","bu2jing4"],
["不脟","bu2lie4"],
["不脤","bu2shen4"],
["不脦","bu2te4"],
["不脨","bu2cu4"],
["不脪","bu2xin4"],
["不脰","bu2dou4"],
["不脲","bu2niao4"],
["不脷","bu2li4"],
["不脹","bu2zhang4"],
["不脺","bu2cui4"],
["不腂","bu2guo4"],
["不腃","bu2kui4"],
["不腅","bu2dan4"],
["不腊","bu2la4"],
["不腋","bu2ye4"],
["不腎","bu2shen4"],
["不腏","bu2chuo4"],
["不腕","bu2wan4"],
["不腖","bu2dong4"],
["不腚","bu2ding4"],
["不腞","bu2zhuan4"],
["不腟","bu2zhi4"],
["不腠","bu2cou4"],
["不腣","bu2di4"],
["不腪","bu2yun4"],
["不腭","bu2e4"],
["不腱","bu2jian4"],
["不腶","bu2duan4"],
["不腷","bu2bi4"],
["不腹","bu2fu4"],
["不腺","bu2xian4"],
["不腻","bu2ni4"],
["不腽","bu2wa4"],
["不膃","bu2wa4"],
["不膄","bu2sou4"],
["不膆","bu2su4"],
["不膇","bu2zhui4"],
["不膉","bu2yi4"],
["不膑","bu2bin4"],
["不膔","bu2lu4"],
["不膟","bu2lv4"],
["不膡","bu2ying4"],
["不膣","bu2zhi4"],
["不膦","bu2lin4"],
["不膩","bu2ni4"],
["不膪","bu2zha4"],
["不膬","bu2cui4"],
["不膳","bu2shan4"],
["不膵","bu2cui4"],
["不膶","bu2run4"],
["不膹","bu2fen4"],
["不膾","bu2kuai4"],
["不臂","bu2bi4"],
["不臅","bu2chu4"],
["不臆","bu2yi4"],
["不臈","bu2la4"],
["不臊","bu2sao4"],
["不臎","bu2cui4"],
["不臏","bu2bin4"],
["不臑","bu2nao4"],
["不臒","bu2huo4"],
["不臔","bu2xian4"],
["不臖","bu2xing4"],
["不臘","bu2la4"],
["不臛","bu2huo4"],
["不臟","bu2zang4"],
["不臥","bu2wo4"],
["不臦","bu2guang4"],
["不臩","bu2guang4"],
["不自","bu2zi4"],
["不臬","bu2nie4"],
["不臭","bu2chou4"],
["不臮","bu2ji4"],
["不臰","bu2chou4"],
["不臲","bu2nie4"],
["不至","bu2zhi4"],
["不致","bu2zhi4"],
["不臶","bu2jian4"],
["不臸","bu2zhi4"],
["不臼","bu2jiu4"],
["不臽","bu2xian4"],
["不舃","bu2xi4"],
["不舄","bu2xi4"],
["不舅","bu2jiu4"],
["不興","bu4xing1"],
["不舊","bu2jiu4"],
["不舋","bu2xin4"],
["不舐","bu2shi4"],
["不舓","bu2shi4"],
["不舕","bu2dan4"],
["不舙","bu2hua4"],
["不舦","bu2tai4"],
["不舭","bu2que4"],
["不舰","bu2jian4"],
["不舵","bu2duo4"],
["不艁","bu2zao4"],
["不艌","bu2nian4"],
["不艑","bu2bian4"],
["不艒","bu2mao4"],
["不艕","bu2beng4"],
["不艗","bu2yi4"],
["不艞","bu2yao4"],
["不艥","bu2jie4"],
["不艦","bu2jian4"],
["不艧","bu2huo4"],
["不色","bu2se4"],
["不艳","bu2yan4"],
["不艶","bu2yan4"],
["不艷","bu2yan4"],
["不艺","bu2yi4"],
["不艻","bu2le4"],
["不芅","bu2yi4"],
["不芋","bu2yu4"],
["不芌","bu2yu4"],
["不芐","bu2xia4"],
["不芖","bu2zhi4"],
["不芡","bu2qian4"],
["不芥","bu2jie4"],
["不芰","bu2ji4"],
["不芴","bu2wu4"],
["不芼","bu2mao4"],
["不芿","bu2reng4"],
["不苄","bu2bian4"],
["不苅","bu2yi4"],
["不苊","bu2e4"],
["不苑","bu2yuan4"],
["不苙","bu2li4"],
["不苚","bu2yong4"],
["不苜","bu2mu4"],
["不苝","bu2pei4"],
["不苣","bu2ju4"],
["不若","bu2ruo4"],
["不苾","bu2bi4"],
["不苿","bu2wei4"],
["不茂","bu2mao4"],
["不范","bu2fan4"],
["不茉","bu2mo4"],
["不茍","bu2ji4"],
["不茘","bu2li4"],
["不茚","bu2yin4"],
["不茛","bu2gen4"],
["不茜","bu2qian4"],
["不茟","bu2yu4"],
["不茡","bu2zi4"],
["不茢","bu2lie4"],
["不茤","bu2ji4"],
["不茦","bu2ce4"],
["不茽","bu2zhong4"],
["不荇","bu2xing4"],
["不荌","bu2an4"],
["不荐","bu2jian4"],
["不荔","bu2li4"],
["不荗","bu2shu4"],
["不荜","bu2bi4"],
["不荟","bu2hui4"],
["不荠","bu2ji4"],
["不荡","bu2dang4"],
["不荦","bu2luo4"],
["不荩","bu2jin4"],
["不荫","bu2yin4"],
["不荮","bu2zhou4"],
["不药","bu2yao4"],
["不荰","bu2du4"],
["不荲","bu2chu4"],
["不荳","bu2dou4"],
["不荹","bu2bu4"],
["不莅","bu2li4"],
["不莇","bu2zhu4"],
["不莈","bu2mo4"],
["不莉","bu2li4"],
["不莜","bu2diao4"],
["不莝","bu2cuo4"],
["不莟","bu2han4"],
["不莡","bu2cuo4"],
["不莫","bu2mo4"],
["不莬","bu2wen4"],
["不莯","bu2mu4"],
["不莳","bu2shi4"],
["不获","bu2huo4"],
["不菉","bu2lv4"],
["不菋","bu2wei4"],
["不菍","bu2nie4"],
["不菚","bu2zhan4"],
["不菜","bu2cai4"],
["不菟","bu2tu4"],
["不菡","bu2han4"],
["不菢","bu2bao4"],
["不菪","bu2dang4"],
["不菿","bu2dao4"],
["不萃","bu2cui4"],
["不萆","bu2bi4"],
["不萏","bu2dan4"],
["不萗","bu2ce4"],
["不萘","bu2nai4"],
["不萚","bu2tuo4"],
["不萫","bu2xiang4"],
["不萬","bu2wan4"],
["不萮","bu2yu4"],
["不萯","bu2fu4"],
["不萰","bu2lian4"],
["不萺","bu2mao4"],
["不萼","bu2e4"],
["不落","bu2luo4"],
["不葄","bu2zuo4"],
["不葉","bu2ye4"],
["不葚","bu2ren4"],
["不葝","bu2jing4"],
["不葢","bu2gai4"],
["不葤","bu2zhou4"],
["不葪","bu2ji4"],
["不葬","bu2zang4"],
["不葮","bu2duan4"],
["不葯","bu2yao4"],
["不葰","bu2jun4"],
["不葺","bu2qi4"],
["不蒁","bu2shu4"],
["不蒂","bu2di4"],
["不蒃","bu2zhuan4"],
["不蒉","bu2kui4"],
["不蒎","bu2pai4"],
["不蒔","bu2shi4"],
["不蒗","bu2lang4"],
["不蒜","bu2suan4"],
["不蒞","bu2li4"],
["不蒡","bu2bang4"],
["不蒦","bu2wo4"],
["不蒨","bu2qian4"],
["不蒪","bu2po4"],
["不蒮","bu2yu4"],
["不蒳","bu2na4"],
["不蒴","bu2shuo4"],
["不蒻","bu2ruo4"],
["不蓃","bu2huo4"],
["不蓄","bu2xu4"],
["不蓋","bu2gai4"],
["不蓌","bu2cuo4"],
["不蓐","bu2ru4"],
["不蓕","bu2gui4"],
["不蓖","bu2bi4"],
["不蓛","bu2ce4"],
["不蓟","bu2ji4"],
["不蓣","bu2yu4"],
["不蓥","bu2ying4"],
["不蓦","bu2mo4"],
["不蓧","bu2diao4"],
["不蓩","bu2mao4"],
["不蓳","bu2jin4"],
["不蓺","bu2yi4"],
["不蓼","bu2lu4"],
["不蓽","bu2bi4"],
["不蔀","bu2bu4"],
["不蔃","bu2jiang4"],
["不蔄","bu2man4"],
["不蔇","bu2ji4"],
["不蔌","bu2su4"],
["不蔍","bu2lu4"],
["不蔑","bu2mie4"],
["不蔕","bu2di4"],
["不蔚","bu2wei4"],
["不蔟","bu2cu4"],
["不蔤","bu2mi4"],
["不蔧","bu2hui4"],
["不蔨","bu2jun4"],
["不蔪","bu2jian4"],
["不蔭","bu2yin4"],
["不蔮","bu2kui4"],
["不蔰","bu2hu4"],
["不蔲","bu2kou4"],
["不蔳","bu2qian4"],
["不蔹","bu2lian4"],
["不蔺","bu2lin4"],
["不蔻","bu2kou4"],
["不蔽","bu2bi4"],
["不蕂","bu2sheng4"],
["不蕈","bu2xun4"],
["不蕗","bu2lu4"],
["不蕚","bu2e4"],
["不蕞","bu2zui4"],
["不蕟","bu2fa4"],
["不蕢","bu2kui4"],
["不蕧","bu2fu4"],
["不蕩","bu2dang4"],
["不蕮","bu2xi4"],
["不蕴","bu2yun4"],
["不蕷","bu2yu4"],
["不蕹","bu2weng4"],
["不蕼","bu2si4"],
["不薆","bu2ai4"],
["不薈","bu2hui4"],
["不薉","bu2wei4"],
["不薊","bu2ji4"],
["不薍","bu2luan4"],
["不薎","bu2mie4"],
["不薒","bu2can4"],
["不薙","bu2ti4"],
["不薢","bu2xiao4"],
["不薤","bu2xie4"],
["不薦","bu2jian4"],
["不薱","bu2dui4"],
["不藂","bu2cong4"],
["不藇","bu2xu4"],
["不藌","bu2mi4"],
["不藎","bu2jin4"],
["不藒","bu2qie4"],
["不藗","bu2su4"],
["不藝","bu2yi4"],
["不藠","bu2xiao4"],
["不藥","bu2yao4"],
["不藯","bu2wei4"],
["不藱","bu2hui4"],
["不藴","bu2yun4"],
["不藺","bu2lin4"],
["不藽","bu2chen4"],
["不藿","bu2huo4"],
["不蘀","bu2tuo4"],
["不蘁","bu2wu4"],
["不蘊","bu2yun4"],
["不蘎","bu2ji4"],
["不蘖","bu2nie4"],
["不蘗","bu2nie4"],
["不蘙","bu2yi4"],
["不蘝","bu2lian4"],
["不蘞","bu2lian4"],
["不蘣","bu2tong4"],
["不蘥","bu2yue4"],
["不蘮","bu2ji4"],
["不蘯","bu2dang4"],
["不蘱","bu2lei4"],
["不蘶","bu2wei4"],
["不蘸","bu2zhan4"],
["不蘹","bu2huai4"],
["不蘻","bu2ji4"],
["不蘾","bu2huai4"],
["不虂","bu2lu4"],
["不虉","bu2yi4"],
["不虐","bu2nve4"],
["不處","bu2chu4"],
["不號","bu2hao4"],
["不虡","bu2ju4"],
["不虣","bu2bao4"],
["不虥","bu2zhan4"],
["不虦","bu2zhan4"],
["不虩","bu2xi4"],
["不虳","bu2di4"],
["不虹","bu2jiang4"],
["不虼","bu2ge4"],
["不蚃","bu2xiang4"],
["不蚅","bu2e4"],
["不蚋","bu2rui4"],
["不蚌","bu2bang4"],
["不蚎","bu2yue4"],
["不蚏","bu2yue4"],
["不蚛","bu2zhong4"],
["不蚞","bu2mu4"],
["不蚧","bu2jie4"],
["不蚮","bu2te4"],
["不蚱","bu2zha4"],
["不蚴","bu2you4"],
["不蚵","bu2ke4"],
["不蚷","bu2ju4"],
["不蚸","bu2li4"],
["不蛀","bu2zhu4"],
["不蛈","bu2tie4"],
["不蛋","bu2dan4"],
["不蛎","bu2li4"],
["不蛗","bu2fu4"],
["不蛞","bu2kuo4"],
["不蛠","bu2li4"],
["不蛡","bu2yi4"],
["不蛨","bu2mo4"],
["不蛪","bu2qie4"],
["不蛭","bu2zhi4"],
["不蛶","bu2lie4"],
["不蛻","bu2tui4"],
["不蛽","bu2bai4"],
["不蛿","bu2han4"],
["不蜃","bu2shen4"],
["不蜄","bu2zhen4"],
["不蜌","bu2bi4"],
["不蜑","bu2dan4"],
["不蜔","bu2dian4"],
["不蜕","bu2tui4"],
["不蜜","bu2mi4"],
["不蜟","bu2yu4"],
["不蜡","bu2la4"],
["不蜧","bu2li4"],
["不蜭","bu2han4"],
["不蜮","bu2yu4"],
["不蜯","bu2bang4"],
["不蜴","bu2yi4"],
["不蜶","bu2su4"],
["不蜹","bu2rui4"],
["不蜼","bu2wei4"],
["不蝁","bu2e4"],
["不蝃","bu2di4"],
["不蝋","bu2la4"],
["不蝐","bu2mai4"],
["不蝜","bu2fu4"],
["不蝞","bu2mei4"],
["不蝮","bu2fu4"],
["不蝲","bu2la4"],
["不蝷","bu2li4"],
["不螆","bu2ci4"],
["不螑","bu2qiu4"],
["不螙","bu2du4"],
["不螝","bu2hui4"],
["不螠","bu2yi4"],
["不螫","bu2shi4"],
["不螮","bu2di4"],
["不螰","bu2lu4"],
["不螱","bu2wei4"],
["不螲","bu2zhi4"],
["不螹","bu2jian4"],
["不蟀","bu2shuai4"],
["不蟃","bu2wan4"],
["不蟅","bu2zhe4"],
["不蟓","bu2xiang4"],
["不蟔","bu2mo4"],
["不蟘","bu2te4"],
["不蟦","bu2fei4"],
["不蟮","bu2shan4"],
["不蟹","bu2xie4"],
["不蟺","bu2shan4"],
["不蠁","bu2xiang4"],
["不蠇","bu2li4"],
["不蠏","bu2xie4"],
["不蠖","bu2huo4"],
["不蠚","bu2he4"],
["不蠛","bu2mie4"],
["不蠟","bu2la4"],
["不蠠","bu2mi4"],
["不蠣","bu2li4"],
["不蠥","bu2nie4"],
["不蠧","bu2du4"],
["不蠫","bu2li4"],
["不蠯","bu2beng4"],
["不蠹","bu2du4"],
["不血","bu2xue4"],
["不衂","bu2niu4"],
["不衄","bu2nv4"],
["不衅","bu2xin4"],
["不衇","bu2mo4"],
["不衈","bu2er4"],
["不衉","bu2ke4"],
["不衊","bu2mie4"],
["不衋","bu2xi4"],
["不衎","bu2kan4"],
["不衏","bu2yuan4"],
["不衒","bu2xuan4"],
["不術","bu2shu4"],
["不衕","bu2tong4"],
["不衖","bu2long4"],
["不衛","bu2wei4"],
["不衜","bu2dao4"],
["不衞","bu2wei4"],
["不衟","bu2dao4"],
["不衬","bu2chen4"],
["不衲","bu2na4"],
["不衵","bu2ni4"],
["不衶","bu2zhong4"],
["不衸","bu2xie4"],
["不衽","bu2ren4"],
["不袂","bu2mei4"],
["不袃","bu2chai4"],
["不袋","bu2dai4"],
["不袌","bu2bao4"],
["不袎","bu2yao4"],
["不袏","bu2zuo4"],
["不袐","bu2bi4"],
["不袑","bu2shao4"],
["不袔","bu2he4"],
["不袕","bu2shu4"],
["不袖","bu2xiu4"],
["不袙","bu2pa4"],
["不袜","bu2wa4"],
["不袝","bu2fu4"],
["不袟","bu2zhi4"],
["不袠","bu2zhi4"],
["不袢","bu2pan4"],
["不袣","bu2yi4"],
["不袤","bu2mao4"],
["不袦","bu2na4"],
["不袨","bu2xian4"],
["不被","bu2bei4"],
["不袴","bu2ku4"],
["不袵","bu2ren4"],
["不袶","bu2jiang4"],
["不袹","bu2mo4"],
["不裂","bu2lie4"],
["不裉","bu2ken4"],
["不裋","bu2shu4"],
["不裔","bu2yi4"],
["不裕","bu2yu4"],
["不裚","bu2ji4"],
["不裛","bu2yi4"],
["不裞","bu2shui4"],
["不裣","bu2lian4"],
["不裤","bu2ku4"],
["不裫","bu2yuan4"],
["不製","bu2zhi4"],
["不褀","bu2ji4"],
["不褂","bu2gua4"],
["不褃","bu2ken4"],
["不褅","bu2ti4"],
["不複","bu2fu4"],
["不褎","bu2xiu4"],
["不褏","bu2xiu4"],
["不褐","bu2he4"],
["不褑","bu2yuan4"],
["不褔","bu2fu4"],
["不褖","bu2tuan4"],
["不褙","bu2bei4"],
["不褤","bu2yuan4"],
["不褥","bu2ru4"],
["不褦","bu2nai4"],
["不褪","bu2tun4"],
["不褯","bu2jie4"],
["不褲","bu2ku4"],
["不褹","bu2yi4"],
["不褻","bu2xie4"],
["不褽","bu2wei4"],
["不襈","bu2zhuan4"],
["不襊","bu2zui4"],
["不襐","bu2xiang4"],
["不襘","bu2gui4"],
["不襙","bu2cao4"],
["不襚","bu2sui4"],
["不襝","bu2lian4"],
["不襞","bu2bi4"],
["不襣","bu2bi4"],
["不襪","bu2wa4"],
["不襫","bu2shi4"],
["不襯","bu2chen4"],
["不襰","bu2lai4"],
["不襶","bu2dai4"],
["不襸","bu2zan4"],
["不襼","bu2yi4"],
["不襾","bu2ya4"],
["不要","bu2yao4"],
["不覅","bu2biao4"],
["不覆","bu2fu4"],
["不覇","bu2ba4"],
["不見","bu2jian4"],
["不覍","bu2bian4"],
["不覎","bu2yan4"],
["不覓","bu2mi4"],
["不覔","bu2mi4"],
["不覕","bu2mie4"],
["不視","bu2shi4"],
["不覛","bu2mi4"],
["不覜","bu2tiao4"],
["不覞","bu2yao4"],
["不覟","bu2zhi4"],
["不覤","bu2xi4"],
["不覨","bu2e4"],
["不覬","bu2ji4"],
["不覯","bu2gou4"],
["不覰","bu2qu4"],
["不覱","bu2zhan4"],
["不覵","bu2jian4"],
["不覷","bu2qu4"],
["不覸","bu2jian4"],
["不覻","bu2qu4"],
["不见","bu2jian4"],
["不觃","bu2yan4"],
["不觅","bu2mi4"],
["不视","bu2shi4"],
["不觊","bu2ji4"],
["不觏","bu2gou4"],
["不觑","bu2qu4"],
["不觗","bu2zhi4"],
["不觘","bu2chao4"],
["不觛","bu2dan4"],
["不觟","bu2hua4"],
["不觢","bu2chi4"],
["不触","bu2chu4"],
["不觨","bu2hun4"],
["不觫","bu2su4"],
["不觮","bu2lu4"],
["不觯","bu2zhi4"],
["不觱","bu2bi4"],
["不觶","bu2zhi4"],
["不觸","bu2chu4"],
["不觻","bu2lu4"],
["不觾","bu2yan4"],
["不訂","bu2ding4"],
["不訃","bu2fu4"],
["不訆","bu2jiao4"],
["不計","bu2ji4"],
["不訉","bu2fan4"],
["不訊","bu2xun4"],
["不訋","bu2diao4"],
["不訍","bu2cha4"],
["不訒","bu2ren4"],
["不訓","bu2xun4"],
["不訕","bu2shan4"],
["不訖","bu2qi4"],
["不記","bu2ji4"],
["不訙","bu2xun4"],
["不訝","bu2ya4"],
["不訟","bu2song4"],
["不訥","bu2ne4"],
["不訫","bu2xin4"],
["不設","bu2she4"],
["不訲","bu2yi4"],
["不訳","bu2yi4"],
["不訹","bu2xu4"],
["不証","bu2zheng4"],
["不訽","bu2gou4"],
["不詂","bu2fu4"],
["不詇","bu2yang4"],
["不詈","bu2li4"],
["不詊","bu2pan4"],
["不詋","bu2zhou4"],
["不詌","bu2gan4"],
["不詍","bu2yi4"],
["不詎","bu2ju4"],
["不詏","bu2ao4"],
["不詐","bu2zha4"],
["不詔","bu2zhao4"],
["不詖","bu2bi4"],
["不詗","bu2xiong4"],
["不詣","bu2yi4"],
["不試","bu2shi4"],
["不詫","bu2cha4"],
["不詬","bu2gou4"],
["不詯","bu2hui4"],
["不話","bu2hua4"],
["不詺","bu2ming4"],
["不詻","bu2e4"],
["不詿","bu2gua4"],
["不誀","bu2er4"],
["不誉","bu2yu4"],
["不誋","bu2ji4"],
["不誌","bu2zhi4"],
["不認","bu2ren4"],
["不誎","bu2su4"],
["不誓","bu2shi4"],
["不誕","bu2dan4"],
["不誘","bu2you4"],
["不誚","bu2qiao4"],
["不誜","bu2shua4"],
["不誟","bu2xiao4"],
["不誡","bu2jie4"],
["不誢","bu2xian4"],
["不誤","bu2wu4"],
["不誥","bu2gao4"],
["不誦","bu2song4"],
["不誨","bu2hui4"],
["不誩","bu2jing4"],
["不誫","bu2zhen4"],
["不誯","bu2chang4"],
["不課","bu2ke4"],
["不誶","bu2sui4"],
["不誻","bu2ta4"],
["不誼","bu2yi4"],
["不調","bu2diao4"],
["不諁","bu2chuo4"],
["不諈","bu2zhui4"],
["不諌","bu2jian4"],
["不諍","bu2zheng4"],
["不諒","bu2liang4"],
["不諓","bu2jian4"],
["不諔","bu2zhu4"],
["不論","bu2lun4"],
["不諙","bu2huai4"],
["不諟","bu2shi4"],
["不諡","bu2shi4"],
["不諢","bu2hun4"],
["不諣","bu2hua4"],
["不諤","bu2e4"],
["不諥","bu2zhong4"],
["不諦","bu2di4"],
["不諫","bu2jian4"],
["不諭","bu2yu4"],
["不諱","bu2hui4"],
["不諺","bu2yan4"],
["不諾","bu2nuo4"],
["不諿","bu2qi4"],
["不謁","bu2ye4"],
["不謂","bu2wei4"],
["不謆","bu2shan4"],
["不謋","bu2huo4"],
["不謐","bu2mi4"],
["不謑","bu2xi4"],
["不謔","bu2xue4"],
["不謖","bu2su4"],
["不謗","bu2bang4"],
["不謚","bu2shi4"],
["不謜","bu2yuan4"],
["不謝","bu2xie4"],
["不謞","bu2xue4"],
["不謥","bu2cong4"],
["不謩","bu2mo4"],
["不謬","bu2miu4"],
["不謴","bu2guan4"],
["不謽","bu2jiang4"],
["不謾","bu2man4"],
["不譀","bu2han4"],
["不譅","bu2se4"],
["不譈","bu2dui4"],
["不證","bu2zheng4"],
["不譍","bu2ying4"],
["不譒","bu2bo4"],
["不譓","bu2hui4"],
["不譔","bu2zhuan4"],
["不譖","bu2zen4"],
["不譛","bu2zen4"],
["不譟","bu2zao4"],
["不譢","bu2sui4"],
["不譥","bu2jiao4"],
["不譪","bu2ai4"],
["不譬","bu2pi4"],
["不譮","bu2hua4"],
["不譯","bu2yi4"],
["不議","bu2yi4"],
["不譱","bu2shan4"],
["不譳","bu2nou4"],
["不譵","bu2zhui4"],
["不譶","bu2ta4"],
["不護","bu2hu4"],
["不譺","bu2ye4"],
["不譼","bu2jian4"],
["不譽","bu2yu4"],
["不譿","bu2hui4"],
["不讂","bu2xuan4"],
["不讃","bu2zan4"],
["不讆","bu2wei4"],
["不讈","bu2li4"],
["不變","bu2bian4"],
["不讌","bu2yan4"],
["不讍","bu2e4"],
["不讏","bu2wei4"],
["不讑","bu2yao4"],
["不讓","bu2rang4"],
["不讖","bu2chen4"],
["不讗","bu2huo4"],
["不讚","bu2zan4"],
["不讛","bu2yi4"],
["不讞","bu2yan4"],
["不计","bu2ji4"],
["不订","bu2ding4"],
["不讣","bu2fu4"],
["不认","bu2ren4"],
["不让","bu2rang4"],
["不讪","bu2shan4"],
["不讫","bu2qi4"],
["不训","bu2xun4"],
["不议","bu2yi4"],
["不讯","bu2xun4"],
["不记","bu2ji4"],
["不讱","bu2ren4"],
["不讳","bu2hui4"],
["不讵","bu2ju4"],
["不讶","bu2ya4"],
["不讷","bu2ne4"],
["不论","bu2lun4"],
["不讼","bu2song4"],
["不设","bu2she4"],
["不证","bu2zheng4"],
["不诇","bu2xiong4"],
["不诈","bu2zha4"],
["不诏","bu2zhao4"],
["不诐","bu2bi4"],
["不译","bu2yi4"],
["不试","bu2shi4"],
["不诖","bu2gua4"],
["不话","bu2hua4"],
["不诞","bu2dan4"],
["不诟","bu2gou4"],
["不诣","bu2yi4"],
["不诤","bu2zheng4"],
["不诧","bu2cha4"],
["不诨","bu2hun4"],
["不诫","bu2jie4"],
["不诮","bu2qiao4"],
["不误","bu2wu4"],
["不诰","bu2gao4"],
["不诱","bu2you4"],
["不诲","bu2hui4"],
["不诵","bu2song4"],
["不诺","bu2nuo4"],
["不课","bu2ke4"],
["不调","bu2diao4"],
["不谅","bu2liang4"],
["不谇","bu2sui4"],
["不谊","bu2yi4"],
["不谏","bu2jian4"],
["不谑","bu2xue4"],
["不谒","bu2ye4"],
["不谓","bu2wei4"],
["不谔","bu2e4"],
["不谕","bu2yu4"],
["不谚","bu2yan4"],
["不谛","bu2di4"],
["不谡","bu2su4"],
["不谢","bu2xie4"],
["不谤","bu2bang4"],
["不谥","bu2shi4"],
["不谧","bu2mi4"],
["不谩","bu2man4"],
["不谬","bu2miu4"],
["不谮","bu2zen4"],
["不谳","bu2yan4"],
["不谶","bu2chen4"],
["不豆","bu2dou4"],
["不豎","bu2shu4"],
["不豏","bu2xian4"],
["不豑","bu2zhi4"],
["不豒","bu2zhi4"],
["不豓","bu2yan4"],
["不豔","bu2yan4"],
["不豙","bu2yi4"],
["不豛","bu2yi4"],
["不豞","bu2hou4"],
["不豟","bu2e4"],
["不象","bu2xiang4"],
["不豢","bu2huan4"],
["不豦","bu2ju4"],
["不豷","bu2yi4"],
["不豹","bu2bao4"],
["不豻","bu2an4"],
["不豽","bu2na4"],
["不貀","bu2na4"],
["不貁","bu2you4"],
["不貃","bu2mo4"],
["不貄","bu2si4"],
["不貊","bu2mo4"],
["不貋","bu2han4"],
["不貌","bu2mao4"],
["不貖","bu2e4"],
["不貗","bu2ju4"],
["不貘","bu2mo4"],
["不貝","bu2bei4"],
["不負","bu2fu4"],
["不貢","bu2gong4"],
["不貣","bu2te4"],
["不貦","bu2wan4"],
["不貨","bu2huo4"],
["不販","bu2fan4"],
["不貫","bu2guan4"],
["不貮","bu2er4"],
["不貯","bu2zhu4"],
["不貰","bu2shi4"],
["不貱","bu2bi4"],
["不貳","bu2er4"],
["不貴","bu2gui4"],
["不貸","bu2dai4"],
["不貹","bu2sheng4"],
["不貺","bu2kuang4"],
["不費","bu2fei4"],
["不貿","bu2mao4"],
["不賀","bu2he4"],
["不賂","bu2lu4"],
["不賃","bu2lin4"],
["不賄","bu2hui4"],
["不賉","bu2xu4"],
["不賌","bu2gai4"],
["不賎","bu2jian4"],
["不賏","bu2ying4"],
["不賐","bu2xun4"],
["不賑","bu2zhen4"],
["不賗","bu2chuan4"],
["不賚","bu2lai4"],
["不賜","bu2ci4"],
["不賣","bu2mai4"],
["不賤","bu2jian4"],
["不賥","bu2sui4"],
["不賦","bu2fu4"],
["不質","bu2zhi4"],
["不賬","bu2zhang4"],
["不賮","bu2jin4"],
["不賴","bu2lai4"],
["不賵","bu2feng4"],
["不賶","bu2cang4"],
["不賸","bu2sheng4"],
["不賹","bu2ai4"],
["不賺","bu2zhuan4"],
["不賻","bu2fu4"],
["不購","bu2gou4"],
["不賽","bu2sai4"],
["不贀","bu2wei4"],
["不贁","bu2bai4"],
["不贃","bu2zhuan4"],
["不贄","bu2zhi4"],
["不贅","bu2zhui4"],
["不贈","bu2zeng4"],
["不贊","bu2zan4"],
["不贋","bu2yan4"],
["不贍","bu2shan4"],
["不贎","bu2wan4"],
["不贐","bu2jin4"],
["不贔","bu2bi4"],
["不贗","bu2yan4"],
["不贙","bu2xuan4"],
["不贚","bu2long4"],
["不贝","bu2bei4"],
["不负","bu2fu4"],
["不贡","bu2gong4"],
["不败","bu2bai4"],
["不账","bu2zhang4"],
["不货","bu2huo4"],
["不质","bu2zhi4"],
["不贩","bu2fan4"],
["不购","bu2gou4"],
["不贮","bu2zhu4"],
["不贯","bu2guan4"],
["不贰","bu2er4"],
["不贱","bu2jian4"],
["不贳","bu2shi4"],
["不贵","bu2gui4"],
["不贶","bu2kuang4"],
["不贷","bu2dai4"],
["不贸","bu2mao4"],
["不费","bu2fei4"],
["不贺","bu2he4"],
["不贽","bu2zhi4"],
["不贿","bu2hui4"],
["不赁","bu2lin4"],
["不赂","bu2lu4"],
["不赆","bu2jin4"],
["不赈","bu2zhen4"],
["不赉","bu2lai4"],
["不赋","bu2fu4"],
["不赐","bu2ci4"],
["不赑","bu2bi4"],
["不赖","bu2lai4"],
["不赗","bu2feng4"],
["不赘","bu2zhui4"],
["不赙","bu2fu4"],
["不赚","bu2zhuan4"],
["不赛","bu2sai4"],
["不赝","bu2yan4"],
["不赞","bu2zan4"],
["不赠","bu2zeng4"],
["不赡","bu2shan4"],
["不赤","bu2chi4"],
["不赥","bu2xi4"],
["不赦","bu2she4"],
["不赩","bu2xi4"],
["不赫","bu2he4"],
["不赲","bu2li4"],
["不赴","bu2fu4"],
["不赸","bu2shan4"],
["不趁","bu2chen4"],
["不趂","bu2chen4"],
["不趄","bu2qie4"],
["不趇","bu2se4"],
["不越","bu2yue4"],
["不趐","bu2xue4"],
["不趔","bu2lie4"],
["不趗","bu2cu4"],
["不趚","bu2su4"],
["不趝","bu2jian4"],
["不趞","bu2que4"],
["不趟","bu2tang4"],
["不趠","bu2chuo4"],
["不趢","bu2lu4"],
["不趣","bu2qu4"],
["不趤","bu2dang4"],
["不趩","bu2chi4"],
["不趭","bu2yao4"],
["不趮","bu2zao4"],
["不趯","bu2yue4"],
["不趶","bu2ku4"],
["不趽","bu2fang4"],
["不趿","bu2sa4"],
["不跀","bu2yue4"],
["不跃","bu2yue4"],
["不跄","bu2qiang4"],
["不跅","bu2tuo4"],
["不跇","bu2yi4"],
["不跊","bu2mei4"],
["不跓","bu2zhu4"],
["不距","bu2ju4"],
["不跞","bu2luo4"],
["不跢","bu2dai4"],
["不跥","bu2duo4"],
["不跨","bu2kua4"],
["不跪","bu2gui4"],
["不跮","bu2chi4"],
["不路","bu2lu4"],
["不跰","bu2beng4"],
["不跱","bu2zhi4"],
["不跳","bu2tiao4"],
["不践","bu2jian4"],
["不跸","bu2bi4"],
["不跺","bu2duo4"],
["不跽","bu2ji4"],
["不踀","bu2chu4"],
["不踁","bu2jing4"],
["不踂","bu2nie4"],
["不踏","bu2ta4"],
["不踐","bu2jian4"],
["不踛","bu2lu4"],
["不踜","bu2leng4"],
["不踞","bu2ju4"],
["不踤","bu2cu4"],
["不踥","bu2qie4"],
["不踧","bu2cu4"],
["不踫","bu2peng4"],
["不踬","bu2zhi4"],
["不踲","bu2dun4"],
["不踶","bu2di4"],
["不踹","bu2chuai4"],
["不踺","bu2jian4"],
["不蹃","bu2nuo4"],
["不蹋","bu2ta4"],
["不蹌","bu2qiang4"],
["不蹑","bu2nie4"],
["不蹓","bu2liu4"],
["不蹔","bu2zhan4"],
["不蹕","bu2bi4"],
["不蹗","bu2lu4"],
["不蹙","bu2cu4"],
["不蹛","bu2dai4"],
["不蹦","bu2beng4"],
["不蹭","bu2ceng4"],
["不蹴","bu2cu4"],
["不蹸","bu2lin4"],
["不蹹","bu2ta4"],
["不躀","bu2kuang4"],
["不躁","bu2zao4"],
["不躃","bu2bi4"],
["不躄","bu2bi4"],
["不躆","bu2ju4"],
["不躈","bu2qiao4"],
["不躍","bu2yue4"],
["不躏","bu2lin4"],
["不躐","bu2lie4"],
["不躒","bu2luo4"],
["不躓","bu2zhi4"],
["不躖","bu2duan4"],
["不躗","bu2wei4"],
["不躙","bu2lin4"],
["不躛","bu2wei4"],
["不躞","bu2xie4"],
["不躠","bu2xie4"],
["不躡","bu2nie4"],
["不躢","bu2ta4"],
["不躤","bu2jie4"],
["不躪","bu2lin4"],
["不軂","bu2lao4"],
["不軇","bu2dao4"],
["不軉","bu2yu4"],
["不軋","bu2ya4"],
["不軎","bu2wei4"],
["不軏","bu2yue4"],
["不軐","bu2xin4"],
["不軑","bu2di4"],
["不軓","bu2fan4"],
["不軔","bu2ren4"],
["不軚","bu2dai4"],
["不軛","bu2e4"],
["不軜","bu2na4"],
["不軠","bu2ren4"],
["不軦","bu2huang4"],
["不軩","bu2dai4"],
["不軬","bu2fan4"],
["不軰","bu2bei4"],
["不軴","bu2zhu4"],
["不軶","bu2e4"],
["不軼","bu2yi4"],
["不軾","bu2shi4"],
["不較","bu2jiao4"],
["不輅","bu2lu4"],
["不載","bu2zai4"],
["不輊","bu2zhi4"],
["不輌","bu2liang4"],
["不輍","bu2yu4"],
["不輚","bu2zhan4"],
["不輛","bu2liang4"],
["不輟","bu2chuo4"],
["不輩","bu2bei4"],
["不輳","bu2cou4"],
["不輹","bu2fu4"],
["不輽","bu2ben4"],
["不轆","bu2lu4"],
["不轊","bu2wei4"],
["不轏","bu2zhan4"],
["不轖","bu2se4"],
["不轛","bu2dui4"],
["不轞","bu2xian4"],
["不轡","bu2pei4"],
["不轢","bu2li4"],
["不轣","bu2li4"],
["不轥","bu2lin4"],
["不轧","bu2ya4"],
["不轪","bu2di4"],
["不轫","bu2ren4"],
["不轭","bu2e4"],
["不轶","bu2yi4"],
["不轹","bu2li4"],
["不轼","bu2shi4"],
["不载","bu2zai4"],
["不轾","bu2zhi4"],
["不辂","bu2lu4"],
["不较","bu2jiao4"],
["不辆","bu2liang4"],
["不辈","bu2bei4"],
["不辍","bu2chuo4"],
["不辏","bu2cou4"],
["不辔","bu2pei4"],
["不辘","bu2lu4"],
["不辟","bu2pi4"],
["不辠","bu2zui4"],
["不辡","bu2bian4"],
["不辢","bu2la4"],
["不辣","bu2la4"],
["不辦","bu2ban4"],
["不辧","bu2bian4"],
["不辨","bu2bian4"],
["不辩","bu2bian4"],
["不辫","bu2bian4"],
["不辮","bu2bian4"],
["不辯","bu2bian4"],
["不辵","bu2chuo4"],
["不辶","bu2chuo4"],
["不迄","bu2qi4"],
["不迅","bu2xun4"],
["不过","bu2guo4"],
["不迈","bu2mai4"],
["不迋","bu2wang4"],
["不迏","bu2ti4"],
["不运","bu2yun4"],
["不近","bu2jin4"],
["不迓","bu2ya4"],
["不这","bu2zhe4"],
["不进","bu2jin4"],
["不迠","bu2che4"],
["不迡","bu2ni4"],
["不迣","bu2zhi4"],
["不迨","bu2dai4"],
["不迫","bu2po4"],
["不述","bu2shu4"],
["不迳","bu2jing4"],
["不迶","bu2you4"],
["不迸","bu2beng4"],
["不迾","bu2lie4"],
["不迿","bu2xun4"],
["不退","bu2tui4"],
["不送","bu2song4"],
["不适","bu2shi4"],
["不逅","bu2hou4"],
["不逆","bu2ni4"],
["不逇","bu2dun4"],
["不逊","bu2xun4"],
["不透","bu2tou4"],
["不递","bu2di4"],
["不逕","bu2jing4"],
["不逖","bu2ti4"],
["不逗","bu2dou4"],
["不這","bu2zhe4"],
["不逛","bu2guang4"],
["不逜","bu2wu4"],
["不逝","bu2shi4"],
["不速","bu2su4"],
["不造","bu2zao4"],
["不逤","bu2suo4"],
["不逩","bu2ben4"],
["不逪","bu2cuo4"],
["不逬","bu2beng4"],
["不逭","bu2huan4"],
["不進","bu2jin4"],
["不逳","bu2yu4"],
["不逴","bu2chuo4"],
["不逷","bu2ti4"],
["不逸","bu2yi4"],
["不逽","bu2nuo4"],
["不逿","bu2dang4"],
["不遁","bu2dun4"],
["不遂","bu2sui4"],
["不遇","bu2yu4"],
["不運","bu2yun4"],
["不遌","bu2e4"],
["不遍","bu2bian4"],
["不過","bu2guo4"],
["不遏","bu2e4"],
["不道","bu2dao4"],
["不遘","bu2gou4"],
["不遚","bu2chu4"],
["不遛","bu2liu4"],
["不遜","bu2xun4"],
["不遝","bu2ta4"],
["不遞","bu2di4"],
["不遡","bu2su4"],
["不遦","bu2guan4"],
["不適","bu2shi4"],
["不遪","bu2ce4"],
["不遫","bu2su4"],
["不遬","bu2su4"],
["不遯","bu2dun4"],
["不遰","bu2di4"],
["不遶","bu2rao4"],
["不遹","bu2yu4"],
["不遻","bu2wu4"],
["不遽","bu2ju4"],
["不遾","bu2shi4"],
["不避","bu2bi4"],
["不邁","bu2mai4"],
["不邂","bu2xie4"],
["不邃","bu2sui4"],
["不邑","bu2yi4"],
["不邝","bu2kuang4"],
["不邟","bu2kang4"],
["不那","bu2na4"],
["不邭","bu2ju4"],
["不邲","bu2bi4"],
["不邶","bu2bei4"],
["不郁","bu2yu4"],
["不郄","bu2qie4"],
["不郅","bu2zhi4"],
["不郈","bu2hou4"],
["不郓","bu2yun4"],
["不郜","bu2gao4"],
["不郡","bu2jun4"],
["不郤","bu2xi4"],
["不郥","bu2bei4"],
["不郦","bu2li4"],
["不部","bu2bu4"],
["不郶","bu2bu4"],
["不鄀","bu2ruo4"],
["不鄁","bu2bei4"],
["不鄄","bu2juan4"],
["不鄆","bu2yun4"],
["不鄇","bu2hou4"],
["不鄎","bu2xi4"],
["不鄏","bu2ru4"],
["不鄚","bu2mo4"],
["不鄠","bu2hu4"],
["不鄤","bu2man4"],
["不鄨","bu2bi4"],
["不鄪","bu2bi4"],
["不鄯","bu2shan4"],
["不鄺","bu2kuang4"],
["不鄼","bu2zan4"],
["不酂","bu2zan4"],
["不酇","bu2zan4"],
["不酈","bu2li4"],
["不配","bu2pei4"],
["不酎","bu2zhou4"],
["不酗","bu2xu4"],
["不酝","bu2yun4"],
["不酞","bu2tai4"],
["不酢","bu2cu4"],
["不酨","bu2zai4"],
["不酪","bu2lao4"],
["不酫","bu2chuo4"],
["不酭","bu2you4"],
["不酱","bu2jiang4"],
["不酳","bu2yin4"],
["不酵","bu2jiao4"],
["不酷","bu2ku4"],
["不酹","bu2lei4"],
["不酻","bu2zui4"],
["不酽","bu2yan4"],
["不酿","bu2niang4"],
["不醁","bu2lu4"],
["不醉","bu2zui4"],
["不醊","bu2chuo4"],
["不醋","bu2cu4"],
["不醖","bu2yun4"],
["不醗","bu2po4"],
["不醘","bu2ke4"],
["不醞","bu2yun4"],
["不醟","bu2yong4"],
["不醠","bu2ang4"],
["不醡","bu2zha4"],
["不醤","bu2jiang4"],
["不醧","bu2yu4"],
["不醬","bu2jiang4"],
["不醮","bu2jiao4"],
["不醳","bu2yi4"],
["不醵","bu2ju4"],
["不醶","bu2jiao4"],
["不醷","bu2yi4"],
["不醼","bu2yan4"],
["不釀","bu2niang4"],
["不釁","bu2xin4"],
["不釂","bu2jiao4"],
["不釅","bu2yan4"],
["不釆","bu2bian4"],
["不釉","bu2you4"],
["不释","bu2shi4"],
["不釋","bu2shi4"],
["不重","bu2zhong4"],
["不量","bu2liang4"],
["不釠","bu2luan4"],
["不釣","bu2diao4"],
["不釦","bu2kou4"],
["不釧","bu2chuan4"],
["不釬","bu2han4"],
["不釰","bu2ri4"],
["不釱","bu2di4"],
["不釲","bu2si4"],
["不釴","bu2yi4"],
["不釸","bu2xi4"],
["不釼","bu2jian4"],
["不鈅","bu2yue4"],
["不鈈","bu2bu4"],
["不鈉","bu2na4"],
["不鈍","bu2dun4"],
["不鈠","bu2yi4"],
["不鈣","bu2gai4"],
["不鈤","bu2ri4"],
["不鈦","bu2tai4"],
["不鈧","bu2kang4"],
["不鈰","bu2shi4"],
["不鈵","bu2bing4"],
["不鈺","bu2yu4"],
["不鈻","bu2si4"],
["不鉃","bu2shi4"],
["不鉅","bu2ju4"],
["不鉉","bu2xuan4"],
["不鉋","bu2bao4"],
["不鉍","bu2bi4"],
["不鉒","bu2zhu4"],
["不鉓","bu2chi4"],
["不鉝","bu2li4"],
["不鉞","bu2yue4"],
["不鉡","bu2ban4"],
["不鉥","bu2shu4"],
["不鉪","bu2di4"],
["不鉬","bu2mu4"],
["不鉴","bu2jian4"],
["不鉻","bu2ge4"],
["不鉽","bu2shi4"],
["不銄","bu2shang4"],
["不銆","bu2mo4"],
["不銇","bu2lei4"],
["不銉","bu2yu4"],
["不銊","bu2xu4"],
["不銌","bu2zun4"],
["不銍","bu2zhi4"],
["不銏","bu2shan4"],
["不銐","bu2chi4"],
["不銚","bu2diao4"],
["不銫","bu2se4"],
["不銬","bu2kao4"],
["不銱","bu2diao4"],
["不銲","bu2han4"],
["不銳","bu2rui4"],
["不銴","bu2shi4"],
["不銹","bu2xiu4"],
["不銺","bu2zang4"],
["不銼","bu2cuo4"],
["不鋀","bu2dou4"],
["不鋇","bu2bei4"],
["不鋈","bu2wu4"],
["不鋉","bu2su4"],
["不鋊","bu2yu4"],
["不鋌","bu2ding4"],
["不鋎","bu2han4"],
["不鋕","bu2zhi4"],
["不鋠","bu2shen4"],
["不鋢","bu2lve4"],
["不鋥","bu2zheng4"],
["不鋧","bu2xian4"],
["不鋪","bu2pu4"],
["不鋬","bu2pan4"],
["不鋯","bu2gao4"],
["不鋱","bu2te4"],
["不鋷","bu2zui4"],
["不鋸","bu2ju4"],
["不鋻","bu2jian4"],
["不鋽","bu2diao4"],
["不錁","bu2ke4"],
["不錄","bu2lu4"],
["不錊","bu2zui4"],
["不錌","bu2an4"],
["不錎","bu2xian4"],
["不錏","bu2ya4"],
["不錑","bu2lei4"],
["不錔","bu2ta4"],
["不錗","bu2wei4"],
["不錠","bu2ding4"],
["不錥","bu2yu4"],
["不錮","bu2gu4"],
["不錯","bu2cuo4"],
["不錰","bu2shu4"],
["不録","bu2lu4"],
["不錴","bu2lu4"],
["不錼","bu2nai4"],
["不錾","bu2zan4"],
["不鍄","bu2liang4"],
["不鍊","bu2lian4"],
["不鍍","bu2du4"],
["不鍑","bu2fu4"],
["不鍔","bu2e4"],
["不鍙","bu2hong4"],
["不鍛","bu2duan4"],
["不鍢","bu2fu4"],
["不鍥","bu2qie4"],
["不鍩","bu2nuo4"],
["不鍱","bu2ye4"],
["不鍳","bu2jian4"],
["不鍵","bu2jian4"],
["不鎃","bu2pai4"],
["不鎅","bu2jie4"],
["不鎉","bu2ta4"],
["不鎊","bu2bang4"],
["不鎎","bu2xi4"],
["不鎑","bu2ye4"],
["不鎒","bu2nou4"],
["不鎙","bu2shuo4"],
["不鎝","bu2sa4"],
["不鎞","bu2bi4"],
["不鎣","bu2ying4"],
["不鎫","bu2wan4"],
["不鎭","bu2zhen4"],
["不鎮","bu2zhen4"],
["不鎰","bu2yi4"],
["不鎳","bu2nie4"],
["不鏆","bu2guan4"],
["不鏇","bu2xuan4"],
["不鏈","bu2lian4"],
["不鏉","bu2shou4"],
["不鏌","bu2mo4"],
["不鏎","bu2bi4"],
["不鏏","bu2wei4"],
["不鏕","bu2lu4"],
["不鏚","bu2qi4"],
["不鏝","bu2man4"],
["不鏡","bu2jing4"],
["不鏣","bu2shu4"],
["不鏤","bu2lou4"],
["不鏥","bu2xiu4"],
["不鏨","bu2zan4"],
["不鏩","bu2jian4"],
["不鏬","bu2xia4"],
["不鏰","bu2beng4"],
["不鏴","bu2lu4"],
["不鏸","bu2hui4"],
["不鏽","bu2xiu4"],
["不鐀","bu2kui4"],
["不鐂","bu2liu4"],
["不鐆","bu2sui4"],
["不鐋","bu2tang4"],
["不鐌","bu2xiang4"],
["不鐐","bu2liao4"],
["不鐙","bu2deng4"],
["不鐚","bu2ya4"],
["不鐛","bu2ying4"],
["不鐜","bu2dui4"],
["不鐞","bu2nou4"],
["不鐟","bu2ti4"],
["不鐥","bu2shan4"],
["不鐨","bu2fei4"],
["不鐩","bu2sui4"],
["不鐬","bu2hui4"],
["不鐭","bu2yu4"],
["不鐴","bu2bi4"],
["不鐷","bu2ye4"],
["不鐾","bu2bei4"],
["不鐿","bu2yi4"],
["不鑀","bu2ai4"],
["不鑂","bu2xun4"],
["不鑃","bu2diao4"],
["不鑄","bu2zhu4"],
["不鑆","bu2zhui4"],
["不鑉","bu2ta4"],
["不鑊","bu2huo4"],
["不鑋","bu2qing4"],
["不鑎","bu2kui4"],
["不鑑","bu2jian4"],
["不鑒","bu2jian4"],
["不鑖","bu2mie4"],
["不鑚","bu2zuan4"],
["不鑛","bu2kuang4"],
["不鑜","bu2shang4"],
["不鑞","bu2la4"],
["不鑠","bu2shuo4"],
["不鑡","bu2chuo4"],
["不鑢","bu2lv4"],
["不鑤","bu2bao4"],
["不鑩","bu2e4"],
["不鑬","bu2jian4"],
["不鑰","bu2yao4"],
["不鑳","bu2jian4"],
["不鑴","bu2xi4"],
["不鑷","bu2nie4"],
["不鑹","bu2cuan4"],
["不鑻","bu2pan4"],
["不钀","bu2nie4"],
["不钏","bu2chuan4"],
["不钓","bu2diao4"],
["不钙","bu2gai4"],
["不钚","bu2bu4"],
["不钛","bu2tai4"],
["不钜","bu2ju4"],
["不钝","bu2dun4"],
["不钠","bu2na4"],
["不钡","bu2bei4"],
["不钥","bu2yao4"],
["不钪","bu2kang4"],
["不钰","bu2yu4"],
["不钺","bu2yue4"],
["不钼","bu2mu4"],
["不铄","bu2shuo4"],
["不铇","bu2bao4"],
["不铈","bu2shi4"],
["不铉","bu2xuan4"],
["不铋","bu2bi4"],
["不铐","bu2kao4"],
["不铔","bu2ya4"],
["不铚","bu2zhi4"],
["不铞","bu2diao4"],
["不铤","bu2ding4"],
["不铫","bu2diao4"],
["不铬","bu2ge4"],
["不铯","bu2se4"],
["不铴","bu2tang4"],
["不铸","bu2zhu4"],
["不铺","bu2pu4"],
["不铽","bu2te4"],
["不链","bu2lian4"],
["不锃","bu2zheng4"],
["不锆","bu2gao4"],
["不锈","bu2xiu4"],
["不锉","bu2cuo4"],
["不锐","bu2rui4"],
["不锘","bu2nuo4"],
["不错","bu2cuo4"],
["不锞","bu2ke4"],
["不锢","bu2gu4"],
["不锭","bu2ding4"],
["不键","bu2jian4"],
["不锯","bu2ju4"],
["不锲","bu2qie4"],
["不锷","bu2e4"],
["不锻","bu2duan4"],
["不镀","bu2du4"],
["不镂","bu2lou4"],
["不镄","bu2fei4"],
["不镆","bu2mo4"],
["不镇","bu2zhen4"],
["不镊","bu2nie4"],
["不镍","bu2nie4"],
["不镑","bu2bang4"],
["不镒","bu2yi4"],
["不镘","bu2man4"],
["不镚","bu2beng4"],
["不镜","bu2jing4"],
["不镟","bu2xuan4"],
["不镣","bu2liao4"],
["不镩","bu2cuan4"],
["不镫","bu2deng4"],
["不镬","bu2huo4"],
["不镱","bu2yi4"],
["不镴","bu2la4"],
["不閁","bu2ma4"],
["不閄","bu2huo4"],
["不閇","bu2bi4"],
["不閈","bu2han4"],
["不閉","bu2bi4"],
["不閏","bu2run4"],
["不閐","bu2san4"],
["不閗","bu2dou4"],
["不閙","bu2nao4"],
["不閞","bu2bian4"],
["不閟","bu2bi4"],
["不閠","bu2run4"],
["不閦","bu2chu4"],
["不閧","bu2hong4"],
["不閯","bu2sha4"],
["不閱","bu2yue4"],
["不閴","bu2qu4"],
["不閵","bu2lin4"],
["不閷","bu2shai4"],
["不閾","bu2yu4"],
["不闀","bu2xiang4"],
["不闂","bu2xiang4"],
["不闃","bu2qu4"],
["不闇","bu2an4"],
["不闊","bu2kuo4"],
["不闋","bu2que4"],
["不闑","bu2nie4"],
["不闒","bu2ta4"],
["不闞","bu2kan4"],
["不闠","bu2hui4"],
["不闢","bu2pi4"],
["不闣","bu2dang4"],
["不闥","bu2ta4"],
["不闬","bu2han4"],
["不闭","bu2bi4"],
["不问","bu2wen4"],
["不闰","bu2run4"],
["不闷","bu2men4"],
["不闹","bu2nao4"],
["不闼","bu2ta4"],
["不阅","bu2yue4"],
["不阈","bu2yu4"],
["不阋","bu2xi4"],
["不阒","bu2qu4"],
["不阓","bu2hui4"],
["不阔","bu2kuo4"],
["不阕","bu2que4"],
["不阘","bu2ta4"],
["不阚","bu2kan4"],
["不阜","bu2fu4"],
["不阝","bu2fu4"],
["不阞","bu2le4"],
["不队","bu2dui4"],
["不阠","bu2xin4"],
["不阢","bu2wu4"],
["不阣","bu2yi4"],
["不阨","bu2e4"],
["不阵","bu2zhen4"],
["不阸","bu2e4"],
["不阼","bu2zuo4"],
["不阽","bu2dian4"],
["不附","bu2fu4"],
["不际","bu2ji4"],
["不陆","bu2lu4"],
["不陊","bu2duo4"],
["不陋","bu2lou4"],
["不陌","bu2mo4"],
["不降","bu2jiang4"],
["不陏","bu2duo4"],
["不限","bu2xian4"],
["不陖","bu2xun4"],
["不陗","bu2qiao4"],
["不陚","bu2fu4"],
["不陛","bu2bi4"],
["不陟","bu2zhi4"],
["不院","bu2yuan4"],
["不陣","bu2zhen4"],
["不陥","bu2xian4"],
["不陧","bu2nie4"],
["不陷","bu2xian4"],
["不陸","bu2lu4"],
["不隁","bu2yan4"],
["不隉","bu2nie4"],
["不隊","bu2dui4"],
["不隖","bu2wu4"],
["不隘","bu2ai4"],
["不隙","bu2xi4"],
["不際","bu2ji4"],
["不障","bu2zhang4"],
["不隟","bu2xi4"],
["不隢","bu2rao4"],
["不隥","bu2deng4"],
["不隧","bu2sui4"],
["不隩","bu2yu4"],
["不隶","bu2li4"],
["不隸","bu2li4"],
["不隺","bu2he4"],
["不隽","bu2juan4"],
["不隿","bu2yi4"],
["不雀","bu2que4"],
["不雁","bu2yan4"],
["不雇","bu2gu4"],
["不雉","bu2zhi4"],
["不雊","bu2gou4"],
["不雋","bu2juan4"],
["不雒","bu2luo4"],
["不雘","bu2huo4"],
["不雚","bu2guan4"],
["不雡","bu2liu4"],
["不雭","bu2se4"],
["不雮","bu2mu4"],
["不雳","bu2li4"],
["不雴","bu2li4"],
["不電","bu2dian4"],
["不雼","bu2dang4"],
["不雾","bu2wu4"],
["不雿","bu2zhao4"],
["不霁","bu2ji4"],
["不霂","bu2mu4"],
["不震","bu2zhen4"],
["不霈","bu2pei4"],
["不霍","bu2huo4"],
["不霎","bu2sha4"],
["不霔","bu2zhu4"],
["不霘","bu2dong4"],
["不霚","bu2wu4"],
["不霡","bu2mai4"],
["不霢","bu2mai4"],
["不霤","bu2liu4"],
["不霥","bu2meng4"],
["不霧","bu2wu4"],
["不霨","bu2wei4"],
["不霩","bu2kuo4"],
["不霬","bu2yi4"],
["不霮","bu2dan4"],
["不霯","bu2deng4"],
["不霰","bu2xian4"],
["不霱","bu2yu4"],
["不露","bu2lu4"],
["不霴","bu2dai4"],
["不霸","bu2ba4"],
["不霽","bu2ji4"],
["不霿","bu2meng4"],
["不靂","bu2li4"],
["不靃","bu2huo4"],
["不靅","bu2fei4"],
["不靆","bu2dai4"],
["不靉","bu2ai4"],
["不靋","bu2li4"],
["不靎","bu2he4"],
["不靏","bu2he4"],
["不靐","bu2bing4"],
["不靓","bu2jing4"],
["不靖","bu2jing4"],
["不靗","bu2cheng4"],
["不靘","bu2qing4"],
["不静","bu2jing4"],
["不靚","bu2jing4"],
["不靛","bu2dian4"],
["不靜","bu2jing4"],
["不靠","bu2kao4"],
["不面","bu2mian4"],
["不靣","bu2mian4"],
["不靤","bu2pao4"],
["不靥","bu2ye4"],
["不靧","bu2hui4"],
["不靨","bu2ye4"],
["不靭","bu2ren4"],
["不靯","bu2du4"],
["不靰","bu2wu4"],
["不靱","bu2ren4"],
["不靳","bu2jin4"],
["不靹","bu2na4"],
["不靽","bu2ban4"],
["不靾","bu2yi4"],
["不靿","bu2yao4"],
["不鞕","bu2ying4"],
["不鞘","bu2qiao4"],
["不鞙","bu2xuan4"],
["不鞚","bu2kong4"],
["不鞜","bu2ta4"],
["不鞝","bu2shang4"],
["不鞟","bu2kuo4"],
["不鞢","bu2xie4"],
["不鞥","bu2yi4"],
["不鞩","bu2xiao4"],
["不鞪","bu2mu4"],
["不鞳","bu2ta4"],
["不鞴","bu2bei4"],
["不鞸","bu2bi4"],
["不鞹","bu2kuo4"],
["不鞼","bu2gui4"],
["不韂","bu2chan4"],
["不韄","bu2huo4"],
["不韈","bu2wa4"],
["不韌","bu2ren4"],
["不韏","bu2juan4"],
["不韒","bu2qiao4"],
["不韔","bu2chang4"],
["不韗","bu2xun4"],
["不韘","bu2she4"],
["不韛","bu2bei4"],
["不韞","bu2yun4"],
["不韠","bu2bi4"],
["不韢","bu2hui4"],
["不韤","bu2wa4"],
["不韧","bu2ren4"],
["不韫","bu2yun4"],
["不韰","bu2xie4"],
["不韵","bu2yun4"],
["不韷","bu2le4"],
["不韻","bu2yun4"],
["不頀","bu2hu4"],
["不頁","bu2ye4"],
["不項","bu2xiang4"],
["不順","bu2shun4"],
["不頋","bu2gu4"],
["不頌","bu2song4"],
["不預","bu2yu4"],
["不頓","bu2dun4"],
["不頖","bu2pan4"],
["不頙","bu2ce4"],
["不頞","bu2e4"],
["不頪","bu2lei4"],
["不頮","bu2hui4"],
["不頱","bu2le4"],
["不頷","bu2han4"],
["不顁","bu2ding4"],
["不顂","bu2lai4"],
["不顄","bu2han4"],
["不顇","bu2cui4"],
["不顎","bu2e4"],
["不顖","bu2xin4"],
["不願","bu2yuan4"],
["不類","bu2lei4"],
["不顠","bu2piao4"],
["不顡","bu2yi4"],
["不顤","bu2rao4"],
["不顥","bu2hao4"],
["不顧","bu2gu4"],
["不顨","bu2xun4"],
["不顫","bu2chan4"],
["不顳","bu2nie4"],
["不页","bu2ye4"],
["不项","bu2xiang4"],
["不顺","bu2shun4"],
["不顾","bu2gu4"],
["不顿","bu2dun4"],
["不颂","bu2song4"],
["不预","bu2yu4"],
["不颒","bu2hui4"],
["不颔","bu2han4"],
["不颚","bu2e4"],
["不颞","bu2nie4"],
["不颢","bu2hao4"],
["不颣","bu2lei4"],
["不颤","bu2chan4"],
["不颯","bu2sa4"],
["不颲","bu2lie4"],
["不颴","bu2xuan4"],
["不颵","bu2shao4"],
["不颶","bu2ju4"],
["不飋","bu2se4"],
["不飒","bu2sa4"],
["不飓","bu2ju4"],
["不飣","bu2ding4"],
["不飤","bu2si4"],
["不飪","bu2ren4"],
["不飫","bu2yu4"],
["不飬","bu2juan4"],
["不飭","bu2chi4"],
["不飯","bu2fan4"],
["不飰","bu2fan4"],
["不飳","bu2zhu4"],
["不飶","bu2bi4"],
["不飻","bu2tie4"],
["不飼","bu2si4"],
["不飾","bu2shi4"],
["不飿","bu2duo4"],
["不餀","bu2hai4"],
["不餁","bu2ren4"],
["不餍","bu2yan4"],
["不餓","bu2e4"],
["不餕","bu2jun4"],
["不餖","bu2dou4"],
["不餗","bu2su4"],
["不餙","bu2shi4"],
["不餝","bu2shi4"],
["不餞","bu2jian4"],
["不餟","bu2chuo4"],
["不餡","bu2xian4"],
["不餢","bu2bu4"],
["不餣","bu2ye4"],
["不餧","bu2wei4"],
["不餩","bu2e4"],
["不餮","bu2tie4"],
["不餯","bu2hui4"],
["不餵","bu2wei4"],
["不餸","bu2song4"],
["不餼","bu2xi4"],
["不餽","bu2kui4"],
["不饁","bu2ye4"],
["不饆","bu2bi4"],
["不饇","bu2yu4"],
["不饋","bu2kui4"],
["不饌","bu2zhuan4"],
["不饍","bu2shan4"],
["不饎","bu2chi4"],
["不饏","bu2dan4"],
["不饐","bu2yi4"],
["不饖","bu2hui4"],
["不饚","bu2hai4"],
["不饜","bu2yan4"],
["不饡","bu2zuan4"],
["不饤","bu2ding4"],
["不饩","bu2xi4"],
["不饪","bu2ren4"],
["不饫","bu2yu4"],
["不饬","bu2chi4"],
["不饭","bu2fan4"],
["不饯","bu2jian4"],
["不饰","bu2shi4"],
["不饲","bu2si4"],
["不饳","bu2duo4"],
["不饾","bu2dou4"],
["不饿","bu2e4"],
["不馂","bu2jun4"],
["不馅","bu2xian4"],
["不馈","bu2kui4"],
["不馌","bu2ye4"],
["不馔","bu2zhuan4"],
["不馝","bu2bi4"],
["不馥","bu2fu4"],
["不馭","bu2yu4"],
["不馯","bu2han4"],
["不馰","bu2di4"],
["不馴","bu2xun4"],
["不馷","bu2pei4"],
["不馸","bu2xin4"],
["不馹","bu2ri4"],
["不馺","bu2sa4"],
["不馾","bu2dan4"],
["不駃","bu2kuai4"],
["不駎","bu2zhou4"],
["不駏","bu2ju4"],
["不駐","bu2zhu4"],
["不駕","bu2jia4"],
["不駙","bu2fu4"],
["不駜","bu2bi4"],
["不駟","bu2si4"],
["不駡","bu2ma4"],
["不駤","bu2zhi4"],
["不駧","bu2dong4"],
["不駭","bu2hai4"],
["不駱","bu2luo4"],
["不駳","bu2dan4"],
["不駴","bu2xie4"],
["不駻","bu2han4"],
["不駽","bu2xuan4"],
["不駾","bu2tui4"],
["不駿","bu2jun4"],
["不騍","bu2ke4"],
["不騐","bu2yan4"],
["不騖","bu2wu4"],
["不騗","bu2pian4"],
["不騙","bu2pian4"],
["不騞","bu2huo4"],
["不騟","bu2yu4"],
["不騩","bu2kui4"],
["不騭","bu2zhi4"],
["不騴","bu2yan4"],
["不騸","bu2shan4"],
["不騺","bu2zhi4"],
["不騼","bu2lu4"],
["不驀","bu2mo4"],
["不驁","bu2ao4"],
["不驃","bu2piao4"],
["不驆","bu2bi4"],
["不驇","bu2zhi4"],
["不驈","bu2yu4"],
["不驗","bu2yan4"],
["不驛","bu2yi4"],
["不驜","bu2ye4"],
["不驟","bu2zhou4"],
["不驠","bu2yan4"],
["不驥","bu2ji4"],
["不驭","bu2yu4"],
["不驯","bu2xun4"],
["不驲","bu2ri4"],
["不驷","bu2si4"],
["不驸","bu2fu4"],
["不驻","bu2zhu4"],
["不驾","bu2jia4"],
["不驿","bu2yi4"],
["不骂","bu2ma4"],
["不骆","bu2luo4"],
["不骇","bu2hai4"],
["不验","bu2yan4"],
["不骏","bu2jun4"],
["不骒","bu2ke4"],
["不骗","bu2pian4"],
["不骘","bu2zhi4"],
["不骛","bu2wu4"],
["不骜","bu2ao4"],
["不骟","bu2shan4"],
["不骠","bu2piao4"],
["不骤","bu2zhou4"],
["不骥","bu2ji4"],
["不骭","bu2gan4"],
["不骮","bu2yi4"],
["不骱","bu2jie4"],
["不骳","bu2bi4"],
["不骺","bu2gou4"],
["不骻","bu2kua4"],
["不髀","bu2bi4"],
["不髂","bu2qia4"],
["不髌","bu2bin4"],
["不髕","bu2bin4"],
["不髚","bu2qiao4"],
["不髞","bu2sao4"],
["不髢","bu2ti4"],
["不髧","bu2dan4"],
["不髩","bu2bin4"],
["不髮","bu2fa4"],
["不髰","bu2ti4"],
["不髱","bu2pao4"],
["不髺","bu2gua4"],
["不髻","bu2ji4"],
["不鬀","bu2ti4"],
["不鬁","bu2li4"],
["不鬂","bu2bin4"],
["不鬄","bu2ti4"],
["不鬊","bu2shun4"],
["不鬎","bu2la4"],
["不鬓","bu2bin4"],
["不鬕","bu2mo4"],
["不鬗","bu2man4"],
["不鬛","bu2lie4"],
["不鬠","bu2kuai4"],
["不鬢","bu2bin4"],
["不鬣","bu2lie4"],
["不鬥","bu2dou4"],
["不鬦","bu2dou4"],
["不鬧","bu2nao4"],
["不鬨","bu2hong4"],
["不鬩","bu2xi4"],
["不鬪","bu2dou4"],
["不鬫","bu2kan4"],
["不鬬","bu2dou4"],
["不鬭","bu2dou4"],
["不鬯","bu2chang4"],
["不鬰","bu2yu4"],
["不鬱","bu2yu4"],
["不鬳","bu2juan4"],
["不鬸","bu2liu4"],
["不鬻","bu2yu4"],
["不鬽","bu2mei4"],
["不鬾","bu2ji4"],
["不魀","bu2jie4"],
["不魄","bu2po4"],
["不魅","bu2mei4"],
["不魆","bu2xu4"],
["不魊","bu2yu4"],
["不魓","bu2bi4"],
["不魝","bu2ji4"],
["不魡","bu2diao4"],
["不魥","bu2e4"],
["不魩","bu2mo4"],
["不魪","bu2jie4"],
["不魶","bu2na4"],
["不鮅","bu2bi4"],
["不鮇","bu2wei4"],
["不鮑","bu2bao4"],
["不鮒","bu2fu4"],
["不鮔","bu2ju4"],
["不鮙","bu2ta4"],
["不鮛","bu2shu4"],
["不鮜","bu2hou4"],
["不鮟","bu2an4"],
["不鮣","bu2yin4"],
["不鮤","bu2lie4"],
["不鮥","bu2luo4"],
["不鮩","bu2bing4"],
["不鮬","bu2bu4"],
["不鯇","bu2huan4"],
["不鯌","bu2gao4"],
["不鯚","bu2ji4"],
["不鯜","bu2qie4"],
["不鯝","bu2gu4"],
["不鯣","bu2yi4"],
["不鯥","bu2lu4"],
["不鯦","bu2jiu4"],
["不鯯","bu2zhi4"],
["不鯷","bu2shi4"],
["不鯻","bu2la4"],
["不鯽","bu2ji4"],
["不鰀","bu2huan4"],
["不鰊","bu2lian4"],
["不鰎","bu2jian4"],
["不鰏","bu2bi4"],
["不鰐","bu2e4"],
["不鰒","bu2fu4"],
["不鰙","bu2ruo4"],
["不鰝","bu2hao4"],
["不鰯","bu2ruo4"],
["不鰳","bu2le4"],
["不鰾","bu2biao4"],
["不鱀","bu2ji4"],
["不鱌","bu2xiang4"],
["不鱐","bu2su4"],
["不鱓","bu2shan4"],
["不鱖","bu2gui4"],
["不鱝","bu2fen4"],
["不鱟","bu2hou4"],
["不鱠","bu2kuai4"],
["不鱣","bu2shan4"],
["不鱥","bu2gui4"],
["不鱮","bu2xu4"],
["不鱯","bu2huo4"],
["不鱱","bu2li4"],
["不鱲","bu2lie4"],
["不鱳","bu2li4"],
["不鱴","bu2mie4"],
["不鱷","bu2e4"],
["不鱹","bu2guan4"],
["不鲋","bu2fu4"],
["不鲍","bu2bao4"],
["不鲎","bu2hou4"],
["不鲘","bu2hou4"],
["不鲙","bu2kuai4"],
["不鲩","bu2huan4"],
["不鲫","bu2ji4"],
["不鲴","bu2gu4"],
["不鲼","bu2fen4"],
["不鲾","bu2bi4"],
["不鳀","bu2shi4"],
["不鳄","bu2e4"],
["不鳆","bu2fu4"],
["不鳓","bu2le4"],
["不鳔","bu2biao4"],
["不鳚","bu2wei4"],
["不鳜","bu2gui4"],
["不鳠","bu2huo4"],
["不鳣","bu2shan4"],
["不鳨","bu2li4"],
["不鳫","bu2yan4"],
["不鳯","bu2feng4"],
["不鳳","bu2feng4"],
["不鳸","bu2hu4"],
["不鳿","bu2yu4"],
["不鴂","bu2jue4"],
["不鴆","bu2zhen4"],
["不鴈","bu2yan4"],
["不鴊","bu2zheng4"],
["不鴌","bu2feng4"],
["不鴏","bu2te4"],
["不鴓","bu2mie4"],
["不鴗","bu2li4"],
["不鴘","bu2bian4"],
["不鴙","bu2zhi4"],
["不鴧","bu2rong4"],
["不鴪","bu2yu4"],
["不鴱","bu2ai4"],
["不鴳","bu2yan4"],
["不鴷","bu2lie4"],
["不鴼","bu2luo4"],
["不鵀","bu2ren4"],
["不鵅","bu2luo4"],
["不鵋","bu2ji4"],
["不鵒","bu2yu4"],
["不鵔","bu2xun4"],
["不鵕","bu2xun4"],
["不鵖","bu2bi4"],
["不鵘","bu2jun4"],
["不鵣","bu2lai4"],
["不鵦","bu2lu4"],
["不鵫","bu2zhao4"],
["不鵱","bu2lu4"],
["不鵺","bu2ye4"],
["不鵽","bu2zhui4"],
["不鶂","bu2yi4"],
["不鶃","bu2yi4"],
["不鶐","bu2shu4"],
["不鶒","bu2chi4"],
["不鶚","bu2e4"],
["不鶤","bu2yun4"],
["不鶨","bu2dun4"],
["不鶩","bu2wu4"],
["不鶮","bu2gu4"],
["不鶴","bu2he4"],
["不鶷","bu2xia4"],
["不鶸","bu2ruo4"],
["不鶾","bu2han4"],
["不鷁","bu2yi4"],
["不鷂","bu2yao4"],
["不鷃","bu2yan4"],
["不鷅","bu2li4"],
["不鷇","bu2kou4"],
["不鷊","bu2ni4"],
["不鷑","bu2li4"],
["不鷓","bu2zhe4"],
["不鷘","bu2chi4"],
["不鷙","bu2zhi4"],
["不鷝","bu2bi4"],
["不鷧","bu2yi4"],
["不鷩","bu2bi4"],
["不鷫","bu2su4"],
["不鷰","bu2yan4"],
["不鷲","bu2jiu4"],
["不鷸","bu2yu4"],
["不鷺","bu2lu4"],
["不鷿","bu2pi4"],
["不鸈","bu2ye4"],
["不鸊","bu2pi4"],
["不鸌","bu2huo4"],
["不鸑","bu2yue4"],
["不鸔","bu2bao4"],
["不鸖","bu2he4"],
["不鸙","bu2yue4"],
["不鸛","bu2guan4"],
["不鸩","bu2zhen4"],
["不鸷","bu2zhi4"],
["不鹆","bu2yu4"],
["不鹔","bu2su4"],
["不鹗","bu2e4"],
["不鹜","bu2wu4"],
["不鹝","bu2ni4"],
["不鹞","bu2yao4"],
["不鹢","bu2yi4"],
["不鹤","bu2he4"],
["不鹧","bu2zhe4"],
["不鹫","bu2jiu4"],
["不鹬","bu2yu4"],
["不鹭","bu2lu4"],
["不鹱","bu2huo4"],
["不鹳","bu2guan4"],
["不鹿","bu2lu4"],
["不麆","bu2zhu4"],
["不麓","bu2lu4"],
["不麔","bu2jiu4"],
["不麗","bu2li4"],
["不麜","bu2li4"],
["不麝","bu2she4"],
["不麥","bu2mai4"],
["不麦","bu2mai4"],
["不麭","bu2pao4"],
["不麮","bu2qu4"],
["不麲","bu2xian4"],
["不麵","bu2mian4"],
["不麺","bu2mian4"],
["不黓","bu2yi4"],
["不黖","bu2xi4"],
["不默","bu2mo4"],
["不黛","bu2dai4"],
["不黜","bu2chu4"],
["不黦","bu2yu4"],
["不黬","bu2an4"],
["不黯","bu2an4"],
["不黱","bu2dai4"],
["不鼀","bu2cu4"],
["不鼁","bu2qu4"],
["不鼊","bu2bi4"],
["不鼏","bu2mi4"],
["不鼐","bu2nai4"],
["不鼜","bu2qi4"],
["不鼣","bu2fei4"],
["不鼬","bu2you4"],
["不鼰","bu2nian4"],
["不齀","bu2wu4"],
["不齂","bu2xi4"],
["不齅","bu2xiu4"],
["不齆","bu2weng4"],
["不齉","bu2nang4"],
["不齌","bu2ji4"],
["不齓","bu2chen4"],
["不齔","bu2chen4"],
["不齘","bu2xie4"],
["不齚","bu2cuo4"],
["不齛","bu2shi4"],
["不齞","bu2nian4"],
["不齥","bu2xie4"],
["不齧","bu2nie4"],
["不齨","bu2jiu4"],
["不齪","bu2chuo4"],
["不齰","bu2cuo4"],
["不齶","bu2e4"],
["不齷","bu2wo4"],
["不齸","bu2yi4"],
["不齽","bu2jin4"],
["不齾","bu2ya4"],
["不龀","bu2chen4"],
["不龊","bu2chuo4"],
["不龌","bu2wo4"],
["不龖","bu2ta4"],
["不龡","bu2chui4"],
["不龥","bu2yu4"],
["不癩","bu2la4"],
["不不","bu2bu4"],
["不練","bu2lian4"],
["不兀","bu2wu4"],
["不嗀","bu2huo4"],
["不益","bu2yi4"],
["不靖","bu2jing4"],
["不逸","bu2yi4"],
["不飯","bu2fan4"],
["不飼","bu2si4"],
["不鶴","bu2he4"],
["不万只","bu2wan4zhi1"],
["不上个","bu2shang4ge4"],
["不上來","bu2shang4lai5"],
["不上個","bu2shang4ge4"],
["不上去","bu2shang4qu5"],
["不上司","bu2shang4si5"],
["不上头","bu2shang4tou5"],
["不上将","bu2shang4jiang4"],
["不上將","bu2shang4jiang4"],
["不上当","bu2shang4dang4"],
["不上杆","bu2shang4gan3"],
["不上来","bu2shang4lai5"],
["不上當","bu2shang4dang4"],
["不上訴","bu2shang4su4"],
["不上調","bu2shang4tiao2"],
["不上诉","bu2shang4su4"],
["不上调","bu2shang4tiao2"],
["不上边","bu2shang4bian5"],
["不上邊","bu2shang4bian5"],
["不上面","bu2shang4mian5"],
["不上頭","bu2shang4tou5"],
["不下來","bu2xia4lai5"],
["不下去","bu2xia4qu5"],
["不下於","bu2xia4yu2"],
["不下来","bu2xia4lai5"],
["不下边","bu2xia4bian5"],
["不下邊","bu2xia4bian5"],
["不下面","bu2xia4mian5"],
["不与会","bu2yu4hui4"],
["不业务","bu2ye4wu4"],
["不业绩","bu2ye4ji4"],
["不丧气","bu2sang4qi5"],
["不个个","bu2ge4ge4"],
["不个中","bu2ge4zhong1"],
["不个人","bu2ge4ren2"],
["不个位","bu2ge4wei4"],
["不个体","bu2ge4ti3"],
["不个儿","bu2ge4r5"],
["不个别","bu2ge4bie2"],
["不个子","bu2ge4zi5"],
["不个性","bu2ge4xing4"],
["不个把","bu2ge4ba3"],
["不个案","bu2ge4an4"],
["不个股","bu2ge4gu3"],
["不中举","bu2zhong4ju3"],
["不中伤","bu2zhong4shang1"],
["不中傷","bu2zhong4shang1"],
["不中奖","bu2zhong4jiang3"],
["不中弹","bu2zhong4dan4"],
["不中彈","bu2zhong4dan4"],
["不中彩","bu2zhong4cai3"],
["不中意","bu2zhong4yi4"],
["不中暑","bu2zhong4shu3"],
["不中枪","bu2zhong4qiang1"],
["不中标","bu2zhong4biao1"],
["不中槍","bu2zhong4qiang1"],
["不中標","bu2zhong4biao1"],
["不中毒","bu2zhong4du2"],
["不中獎","bu2zhong4jiang3"],
["不中签","bu2zhong4qian1"],
["不中簽","bu2zhong4qian1"],
["不中肯","bu2zhong4ken3"],
["不中舉","bu2zhong4ju3"],
["不中計","bu2zhong4ji4"],
["不中计","bu2zhong4ji4"],
["不中选","bu2zhong4xuan3"],
["不中選","bu2zhong4xuan3"],
["不中邪","bu2zhong4xie2"],
["不中風","bu2zhong4feng1"],
["不中风","bu2zhong4feng1"],
["不中魔","bu2zhong4mo2"],
["不串供","bu2chuan4gong4"],
["不串行","bu2chuan4hang2"],
["不义务","bu2yi4wu4"],
["不义气","bu2yi4qi5"],
["不乐器","bu2yue4qi4"],
["不乐团","bu2yue4tuan2"],
["不乐坛","bu2yue4tan2"],
["不乐师","bu2yue4shi1"],
["不乐手","bu2yue4shou3"],
["不乐曲","bu2yue4qu3"],
["不乐章","bu2yue4zhang1"],
["不乐谱","bu2yue4pu3"],
["不乐迷","bu2yue4mi2"],
["不乐队","bu2yue4dui4"],
["不乐音","bu2yue4yin1"],
["不乾吗","bu2gan4ma2"],
["不乾嗎","bu2gan4ma2"],
["不乾麼","bu2gan4ma2"],
["不事假","bu2shi4jia4"],
["不事儿","bu2shi4r5"],
["不事务","bu2shi4wu4"],
["不事務","bu2shi4wu4"],
["不事跡","bu2shi4ji4"],
["不事迹","bu2shi4ji4"],
["不二只","bu2er4zhi1"],
["不二重","bu2er4chong2"],
["不亞於","bu2ya4yu2"],
["不亮相","bu2liang4xiang4"],
["不亲家","bu2qing4jia5"],
["不介壳","bu2jie4qiao4"],
["不介子","bu2jie4zi3"],
["不介於","bu2jie4yu2"],
["不介殼","bu2jie4qiao4"],
["不价钱","bu2jia4qian5"],
["不份儿","bu2fen4r5"],
["不份量","bu2fen4liang5"],
["不伎俩","bu2ji4liang3"],
["不伎倆","bu2ji4liang3"],
["不会友","bu2hui4you3"],
["不会计","bu2kuai4ji4"],
["不会长","bu2hui4zhang3"],
["不传略","bu2zhuan4lve4"],
["不传记","bu2zhuan4ji4"],
["不传赞","bu2zhuan4zan4"],
["不估衣","bu2gu4yi5"],
["不伺候","bu2ci4hou5"],
["不伺服","bu2si4fu2"],
["不伺机","bu2si4ji1"],
["不伺機","bu2si4ji1"],
["不伺隙","bu2si4xi4"],
["不似乎","bu2si4hu1"],
["不佈伍","bu2bu4wu3"],
["不位於","bu2wei4yu2"],
["不位置","bu2wei4zhi5"],
["不住地","bu2zhu4di4"],
["不住舍","bu2zhu4she4"],
["不体面","bu4ti3mian4"],
["不作为","bu2zuo4wei2"],
["不作曲","bu2zuo4qu3"],
["不作為","bu2zuo4wei2"],
["不佣金","bu2yong4jin1"],
["不佩服","bu2pei4fu5"],
["不例假","bu2li4jia4"],
["不供品","bu2gong4pin3"],
["不供奉","bu2gong4feng4"],
["不供物","bu2gong4wu4"],
["不供职","bu2gong4zhi2"],
["不供職","bu2gong4zhi2"],
["不供認","bu2gong4ren4"],
["不供认","bu2gong4ren4"],
["不便宜","bu2bian4yi2"],
["不便当","bu2bian4dang5"],
["不便於","bu2bian4yu2"],
["不便當","bu2bian4dang5"],
["不便血","bu2bian4xie3"],
["不便难","bu2bian4nan4"],
["不便難","bu2bian4nan4"],
["不俏皮","bu2qiao4pi5"],
["不信差","bu2xin4chai1"],
["不信息","bu2xin4xi1"],
["不個中","bu2ge4zhong1"],
["不個人","bu2ge4ren2"],
["不個位","bu2ge4wei4"],
["不個個","bu2ge4ge4"],
["不個兒","bu2ge4r5"],
["不個別","bu2ge4bie2"],
["不個子","bu2ge4zi5"],
["不個性","bu2ge4xing4"],
["不個把","bu2ge4ba3"],
["不個案","bu2ge4an4"],
["不個股","bu2ge4gu3"],
["不個體","bu2ge4ti3"],
["不倒数","bu2dao4shu3"],
["不倒數","bu2dao4shu3"],
["不倒是","bu2dao4shi5"],
["不倒相","bu2dao4xiang4"],
["不倒翁","bu4dao3weng1"],
["不债务","bu2zhai4wu4"],
["不假日","bu2jia4ri4"],
["不假期","bu2jia4qi1"],
["不假条","bu2jia4tiao2"],
["不假條","bu2jia4tiao2"],
["不做为","bu2zuo4wei2"],
["不做作","bu2zuo4zuo5"],
["不做為","bu2zuo4wei2"],
["不傳略","bu2zhuan4lve4"],
["不傳記","bu2zhuan4ji4"],
["不傳贊","bu2zhuan4zan4"],
["不債務","bu2zhai4wu4"],
["不像片","bu2xiang4pian1"],
["不僱傭","bu2gu4yong1"],
["不價錢","bu2jia4qian5"],
["不入伍","bu2ru4wu3"],
["不內務","bu2nei4wu4"],
["不內地","bu2nei4di4"],
["不內行","bu2nei4hang2"],
["不內訌","bu2nei4hong4"],
["不六只","bu2liu4zhi1"],
["不共处","bu2gong4chu3"],
["不共處","bu2gong4chu3"],
["不共識","bu2gong4shi2"],
["不共识","bu2gong4shi2"],
["不兴致","bu2xing4zhi4"],
["不兴趣","bu2xing4qu4"],
["不内务","bu2nei4wu4"],
["不内地","bu2nei4di4"],
["不内行","bu2nei4hang2"],
["不内讧","bu2nei4hong4"],
["不凑合","bu2cou4he5"],
["不分內","bu2fen4nei4"],
["不分内","bu2fen4nei4"],
["不分外","bu2fen4wai4"],
["不分子","bu2fen4zi5"],
["不分当","bu2fen4dang1"],
["不分拆","bu2fen4chai1"],
["不分當","bu2fen4dang1"],
["不分量","bu2fen4liang4"],
["不切中","bu2qie4zhong4"],
["不划算","bu4hua2suan4"],
["不列为","bu2lie4wei2"],
["不列传","bu2lie4zhuan4"],
["不列傳","bu2lie4zhuan4"],
["不列為","bu2lie4wei2"],
["不判处","bu2pan4chu3"],
["不判處","bu2pan4chu3"],
["不別嘴","bu2bie4zui3"],
["不別扭","bu2bie4niu5"],
["不刨冰","bu2bao4bing1"],
["不刨刀","bu2bao4dao1"],
["不刨工","bu2bao4gong1"],
["不刨程","bu2bao4cheng2"],
["不刨花","bu2bao4hua1"],
["不刨齒","bu2bao4chi3"],
["不刨齿","bu2bao4chi3"],
["不利害","bu2li4hai5"],
["不利息","bu2li4xi1"],
["不利於","bu2li4yu2"],
["不利落","bu2li4luo5"],
["不利錢","bu2li4qian5"],
["不利钱","bu2li4qian5"],
["不别嘴","bu2bie4zui3"],
["不别扭","bu2bie4niu5"],
["不刹那","bu2cha4na4"],
["不刺儿","bu2ci4r5"],
["不刻薄","bu2ke4bo2"],
["不剎那","bu2cha4na4"],
["不剑客","bu2jian4ke4"],
["不剑尖","bu2jian4jian1"],
["不剑术","bu2jian4shu4"],
["不剑身","bu2jian4shen1"],
["不剩下","bu2sheng4xia5"],
["不劃一","bu2hua4yi1"],
["不劃價","bu2hua4jia4"],
["不劃分","bu2hua4fen1"],
["不劃定","bu2hua4ding4"],
["不劃掉","bu2hua4diao4"],
["不劃撥","bu2hua4bo1"],
["不劃歸","bu2hua4gui1"],
["不劃清","bu2hua4qing1"],
["不劃線","bu2hua4xian4"],
["不劍客","bu2jian4ke4"],
["不劍尖","bu2jian4jian1"],
["不劍術","bu2jian4shu4"],
["不劍身","bu2jian4shen1"],
["不力度","bu2li4du5"],
["不力气","bu2li4qi5"],
["不力氣","bu2li4qi5"],
["不力矩","bu2li4ju3"],
["不力量","bu2li4liang5"],
["不务实","bu2wu4shi2"],
["不务必","bu2wu4bi4"],
["不劣跡","bu2lie4ji4"],
["不劣迹","bu2lie4ji4"],
["不动弹","bu2dong4tan5"],
["不动静","bu2dong4jing5"],
["不助長","bu2zhu4zhang3"],
["不助长","bu2zhu4zhang3"],
["不劲卒","bu2jing4zu2"],
["不劲峭","bu2jing4qiao4"],
["不劲急","bu2jing4ji2"],
["不劲拔","bu2jing4ba2"],
["不劲挺","bu2jing4ting3"],
["不劲敌","bu2jing4di2"],
["不劲旅","bu2jing4lv3"],
["不劲烈","bu2jing4lie4"],
["不劲直","bu2jing4zhi2"],
["不劲草","bu2jing4cao3"],
["不劲风","bu2jing4feng1"],
["不势力","bu2shi4li5"],
["不勁卒","bu2jing4zu2"],
["不勁峭","bu2jing4qiao4"],
["不勁急","bu2jing4ji2"],
["不勁拔","bu2jing4ba2"],
["不勁挺","bu2jing4ting3"],
["不勁敵","bu2jing4di2"],
["不勁旅","bu2jing4lv3"],
["不勁烈","bu2jing4lie4"],
["不勁直","bu2jing4zhi2"],
["不勁草","bu2jing4cao3"],
["不勁風","bu2jing4feng1"],
["不動彈","bu2dong4tan5"],
["不動靜","bu2dong4jing5"],
["不務實","bu2wu4shi2"],
["不務必","bu2wu4bi4"],
["不勝地","bu2sheng4di4"],
["不勢力","bu2shi4li5"],
["不勾当","bu2gou4dang4"],
["不勾當","bu2gou4dang4"],
["不匯劃","bu2hui4hua4"],
["不匿跡","bu2ni4ji4"],
["不匿迹","bu2ni4ji4"],
["不半拉","bu2ban4la3"],
["不卧佛","bu2wo4fo2"],
["不卧倒","bu2wo4dao3"],
["不卷宗","bu2juan4zong1"],
["不卷軸","bu2juan4zhou2"],
["不卷轴","bu2juan4zhou2"],
["不厉害","bu2li4hai5"],
["不厌恶","bu2yan4wu4"],
["不厌薄","bu2yan4bo2"],
["不厭惡","bu2yan4wu4"],
["不厭薄","bu2yan4bo2"],
["不厲害","bu2li4hai5"],
["不县长","bu2xian4zhang3"],
["不发夹","bu2fa4jia1"],
["不发屋","bu2fa4wu1"],
["不发廊","bu2fa4lang2"],
["不发粉","bu2fa4fen3"],
["不发绀","bu2fa4gan4"],
["不发网","bu2fa4wang3"],
["不发胀","bu2fa4zhang4"],
["不发胶","bu2fa4jiao1"],
["不发辫","bu2fa4bian4"],
["不发髻","bu2fa4ji4"],
["不受瘪","bu2shou4bie1"],
["不受癟","bu2shou4bie1"],
["不受禅","bu2shou4shan4"],
["不受降","bu2shou4xiang2"],
["不受难","bu2shou4nan4"],
["不受難","bu2shou4nan4"],
["不变为","bu2bian4wei2"],
["不变更","bu2bian4geng1"],
["不变相","bu2bian4xiang4"],
["不变通","bu2bian4tong5"],
["不句讀","bu2ju4dou4"],
["不句读","bu2ju4dou4"],
["不叫唤","bu2jiao4huan5"],
["不叫喚","bu2jiao4huan5"],
["不可不","bu4ke3bu4"],
["不叱呵","bu2chi4he1"],
["不叱喝","bu2chi4he4"],
["不右边","bu2you4bian5"],
["不右邊","bu2you4bian5"],
["不叹息","bu2tan4xi1"],
["不各个","bu2ge4ge4"],
["不各個","bu2ge4ge4"],
["不各地","bu2ge4di4"],
["不吊卷","bu2diao4juan4"],
["不吊斗","bu2diao4dou3"],
["不后头","bu2hou4tou5"],
["不后缀","bu2hou4zhui4"],
["不后边","bu2hou4bian5"],
["不后面","bu2hou4mian5"],
["不吐根","bu2tu4gen1"],
["不吓倒","bu2xia4dao3"],
["不吓声","bu2he4sheng1"],
["不呫呫","bu2tie4tie4"],
["不呫哔","bu2tie4bi4"],
["不呫嗫","bu2tie4nie4"],
["不呫嗶","bu2tie4bi4"],
["不呫嚅","bu2tie4ru2"],
["不呫囁","bu2tie4nie4"],
["不呫毕","bu2tie4bi4"],
["不呫畢","bu2tie4bi4"],
["不味道","bu2wei4dao5"],
["不哄抢","bu2hong4qiang3"],
["不哄搶","bu2hong4qiang3"],
["不哨卡","bu2shao4qia3"],
["不哮喘","bu2xiao4chuan3"],
["不唤头","bu2huan4tou5"],
["不唱曲","bu2chang4qu3"],
["不唾沫","bu2tuo4mo5"],
["不善於","bu2shan4yu2"],
["不喚頭","bu2huan4tou5"],
["不喝彩","bu2he4cai3"],
["不喝采","bu2he4cai3"],
["不喪氣","bu2sang4qi5"],
["不喪盡","bu2sang4jin4"],
["不嗜好","bu2shi4hao4"],
["不嗣子","bu2si4zi3"],
["不嗫呫","bu2nie4tie4"],
["不嘆息","bu2tan4xi1"],
["不嘌呤","bu2piao4ling4"],
["不嘧啶","bu2mi4ding4"],
["不器乐","bu2qi4yue4"],
["不器樂","bu2qi4yue4"],
["不嚇倒","bu2xia4dao3"],
["不嚇聲","bu2he4sheng1"],
["不嚏喷","bu2ti4pen5"],
["不嚏噴","bu2ti4pen5"],
["不囁呫","bu2nie4tie4"],
["不四只","bu2si4zhi1"],
["不困难","bu2kun4nan5"],
["不困難","bu2kun4nan5"],
["不圣地","bu2sheng4di4"],
["不圣迹","bu2sheng4ji4"],
["不在於","bu2zai4yu2"],
["不地上","bu2di4shang5"],
["不地下","bu2di4xia4"],
["不地主","bu2di4zhu3"],
["不地产","bu2di4chan3"],
["不地亩","bu2di4mu3"],
["不地位","bu2di4wei4"],
["不地利","bu2di4li4"],
["不地动","bu2di4dong4"],
["不地势","bu2di4shi4"],
["不地動","bu2di4dong4"],
["不地勢","bu2di4shi4"],
["不地区","bu2di4qu1"],
["不地區","bu2di4qu1"],
["不地史","bu2di4shi3"],
["不地名","bu2di4ming2"],
["不地图","bu2di4tu2"],
["不地圖","bu2di4tu2"],
["不地址","bu2di4zhi3"],
["不地块","bu2di4kuai4"],
["不地垄","bu2di4long3"],
["不地域","bu2di4yu4"],
["不地基","bu2di4ji1"],
["不地堑","bu2di4qian4"],
["不地堡","bu2di4bao3"],
["不地塊","bu2di4kuai4"],
["不地塹","bu2di4qian4"],
["不地壟","bu2di4long3"],
["不地壳","bu2di4qiao4"],
["不地宫","bu2di4gong1"],
["不地宮","bu2di4gong1"],
["不地层","bu2di4ceng2"],
["不地層","bu2di4ceng2"],
["不地带","bu2di4dai4"],
["不地帶","bu2di4dai4"],
["不地幔","bu2di4man4"],
["不地底","bu2di4di3"],
["不地形","bu2di4xing2"],
["不地支","bu2di4zhi1"],
["不地方","bu2di4fang5"],
["不地板","bu2di4ban3"],
["不地标","bu2di4biao1"],
["不地核","bu2di4he2"],
["不地標","bu2di4biao1"],
["不地步","bu2di4bu4"],
["不地段","bu2di4duan4"],
["不地殼","bu2di4qiao4"],
["不地毯","bu2di4tan3"],
["不地滑","bu2di4hua2"],
["不地漏","bu2di4lou4"],
["不地炉","bu2di4lu2"],
["不地点","bu2di4dian3"],
["不地热","bu2di4re4"],
["不地熱","bu2di4re4"],
["不地爐","bu2di4lu2"],
["不地牢","bu2di4lao2"],
["不地狱","bu2di4yu4"],
["不地獄","bu2di4yu4"],
["不地球","bu2di4qiu2"],
["不地理","bu2di4li3"],
["不地產","bu2di4chan3"],
["不地畝","bu2di4mu3"],
["不地痞","bu2di4pi3"],
["不地皮","bu2di4pi2"],
["不地盘","bu2di4pan2"],
["不地盤","bu2di4pan2"],
["不地租","bu2di4zu1"],
["不地稅","bu2di4shui4"],
["不地税","bu2di4shui4"],
["不地窖","bu2di4jiao4"],
["不地級","bu2di4ji2"],
["不地線","bu2di4xian4"],
["不地緣","bu2di4yuan2"],
["不地级","bu2di4ji2"],
["不地线","bu2di4xian4"],
["不地缘","bu2di4yuan2"],
["不地脈","bu2di4mai4"],
["不地脉","bu2di4mai4"],
["不地衣","bu2di4yi1"],
["不地表","bu2di4biao3"],
["不地貌","bu2di4mao4"],
["不地質","bu2di4zhi4"],
["不地质","bu2di4zhi4"],
["不地軸","bu2di4zhou2"],
["不地轴","bu2di4zhou2"],
["不地道","bu2di4dao5"],
["不地邻","bu2di4lin2"],
["不地鄰","bu2di4lin2"],
["不地鐵","bu2di4tie3"],
["不地铁","bu2di4tie3"],
["不地雷","bu2di4lei2"],
["不地震","bu2di4zhen4"],
["不地面","bu2di4mian4"],
["不地點","bu2di4dian3"],
["不坏处","bu2huai4chu5"],
["不坐下","bu2zuo4xia5"],
["不坐禪","bu2zuo4chan2"],
["不块菌","bu2kuai4jun4"],
["不垫圈","bu2dian4juan4"],
["不垫脚","bu2dian4jiao5"],
["不垫补","bu2dian4bu5"],
["不報應","bu2bao4ying4"],
["不塊菌","bu2kuai4jun4"],
["不境地","bu2jing4di4"],
["不墊圈","bu2dian4juan4"],
["不墊腳","bu2dian4jiao5"],
["不墊補","bu2dian4bu5"],
["不墓地","bu2mu4di4"],
["不墨斗","bu2mo4dou3"],
["不墨跡","bu2mo4ji4"],
["不墨迹","bu2mo4ji4"],
["不壞處","bu2huai4chu5"],
["不壳质","bu2qiao4zhi4"],
["不壽司","bu2shou4si1"],
["不壽命","bu2shou4ming4"],
["不壽堂","bu2shou4tang2"],
["不壽數","bu2shou4shu5"],
["不壽星","bu2shou4xing5"],
["不壽材","bu2shou4cai2"],
["不壽桃","bu2shou4tao2"],
["不壽禮","bu2shou4li3"],
["不壽衣","bu2shou4yi1"],
["不壽辰","bu2shou4chen2"],
["不壽限","bu2shou4xian4"],
["不壽險","bu2shou4xian3"],
["不壽麵","bu2shou4mian4"],
["不复兴","bu2fu4xing1"],
["不复辟","bu2fu4bi4"],
["不外务","bu2wai4wu4"],
["不外務","bu2wai4wu4"],
["不外地","bu2wai4di4"],
["不外头","bu2wai4tou5"],
["不外甥","bu2wai4sheng5"],
["不外行","bu2wai4hang2"],
["不外賈","bu2wai4jia3"],
["不外贾","bu2wai4jia3"],
["不外边","bu2wai4bian5"],
["不外邊","bu2wai4bian5"],
["不外長","bu2wai4zhang3"],
["不外长","bu2wai4zhang3"],
["不外面","bu2wai4mian5"],
["不外頭","bu2wai4tou5"],
["不夜叉","bu2ye4cha5"],
["不夜曲","bu2ye4qu3"],
["不夜里","bu2ye4li5"],
["不夢見","bu2meng4jian5"],
["不大人","bu2da4ren5"],
["不大地","bu2da4di4"],
["不大夫","bu2dai4fu5"],
["不大巴","bu2da4ba1"],
["不大方","bu2da4fang5"],
["不大於","bu2da4yu2"],
["不大爷","bu2da4ye2"],
["不大爺","bu2da4ye2"],
["不大难","bu2da4nan4"],
["不大難","bu2da4nan4"],
["不大黃","bu2dai4huang2"],
["不大黄","bu2dai4huang2"],
["不太太","bu2tai4tai5"],
["不太子","bu2tai4zi3"],
["不失为","bu4shi1wei2"],
["不失為","bu4shi1wei2"],
["不奉承","bu2feng4cheng5"],
["不奉还","bu2feng4huan2"],
["不奉還","bu2feng4huan2"],
["不奏乐","bu2zou4yue4"],
["不奏樂","bu2zou4yue4"],
["不奔头","bu2ben4tou2"],
["不奔頭","bu2ben4tou2"],
["不套套","bu2tao4tao5"],
["不套曲","bu2tao4qu3"],
["不套种","bu2tao4zhong4"],
["不套種","bu2tao4zhong4"],
["不套色","bu2tao4shai3"],
["不奠都","bu2dian4du1"],
["不好奇","bu2hao4qi2"],
["不好学","bu2hao4xue2"],
["不好學","bu2hao4xue2"],
["不好客","bu2hao4ke4"],
["不好战","bu2hao4zhan4"],
["不好戰","bu2hao4zhan4"],
["不好斗","bu2hao4dou4"],
["不好氧","bu2hao4yang3"],
["不好色","bu2hao4se4"],
["不好鬥","bu2hao4dou4"],
["不妄为","bu2wang4wei2"],
["不妄為","bu2wang4wei2"],
["不妹妹","bu2mei4mei5"],
["不嫁妆","bu2jia4zhuang5"],
["不嫁妝","bu2jia4zhuang5"],
["不孕吐","bu2yun4tu4"],
["不字号","bu2zi4hao5"],
["不字帖","bu2zi4tie4"],
["不字號","bu2zi4hao5"],
["不字跡","bu2zi4ji4"],
["不字迹","bu2zi4ji4"],
["不孝道","bu2xiao4dao5"],
["不季子","bu2ji4zi3"],
["不季相","bu2ji4xiang4"],
["不宁可","bu2ning4ke3"],
["不宁愿","bu2ning4yuan4"],
["不宁肯","bu2ning4ken3"],
["不定当","bu2ding4dang4"],
["不定於","bu2ding4yu2"],
["不定當","bu2ding4dang4"],
["不定睛","bu2ding4jing1"],
["不客人","bu2ke4ren5"],
["不客气","bu2ke4qi5"],
["不客氣","bu2ke4qi5"],
["不室友","bu2shi4you3"],
["不宦官","bu2huan4guan1"],
["不宦海","bu2huan4hai3"],
["不宦門","bu2huan4men2"],
["不宦门","bu2huan4men2"],
["不宦騎","bu2huan4qi2"],
["不宦骑","bu2huan4qi2"],
["不害处","bu2hai4chu5"],
["不害處","bu2hai4chu5"],
["不宿分","bu2su4fen4"],
["不宿将","bu2su4jiang4"],
["不宿將","bu2su4jiang4"],
["不宿舍","bu2su4she4"],
["不寄跡","bu2ji4ji4"],
["不寄迹","bu2ji4ji4"],
["不密友","bu2mi4you3"],
["不富余","bu2fu4yu5"],
["不富态","bu2fu4tai5"],
["不富態","bu2fu4tai5"],
["不富於","bu2fu4yu2"],
["不富餘","bu2fu4yu5"],
["不寧可","bu2ning4ke3"],
["不寧肯","bu2ning4ken3"],
["不寧願","bu2ning4yuan4"],
["不对付","bu2dui4fu5"],
["不对地","bu2dui4di4"],
["不对应","bu2dui4ying4"],
["不对称","bu2dui4chen4"],
["不寺庙","bu2si4miao4"],
["不寺廟","bu2si4miao4"],
["不寺院","bu2si4yuan4"],
["不寿司","bu2shou4si1"],
["不寿命","bu2shou4ming4"],
["不寿堂","bu2shou4tang2"],
["不寿数","bu2shou4shu5"],
["不寿星","bu2shou4xing5"],
["不寿材","bu2shou4cai2"],
["不寿桃","bu2shou4tao2"],
["不寿礼","bu2shou4li3"],
["不寿衣","bu2shou4yi1"],
["不寿辰","bu2shou4chen2"],
["不寿限","bu2shou4xian4"],
["不寿险","bu2shou4xian3"],
["不寿面","bu2shou4mian4"],
["不射中","bu2she4zhong4"],
["不将士","bu2jiang4shi4"],
["不将帅","bu2jiang4shuai4"],
["不将牌","bu2jiang4pai2"],
["不将领","bu2jiang4ling3"],
["不將士","bu2jiang4shi4"],
["不將帥","bu2jiang4shuai4"],
["不將牌","bu2jiang4pai2"],
["不將領","bu2jiang4ling3"],
["不對么","bu2dui4yao1"],
["不對付","bu2dui4fu5"],
["不對地","bu2dui4di4"],
["不對應","bu2dui4ying4"],
["不對於","bu2dui4yu2"],
["不對稱","bu2dui4chen4"],
["不少儿","bu2shao4er2"],
["不少兒","bu2shao4er2"],
["不少女","bu2shao4nv3"],
["不少将","bu2shao4jiang4"],
["不少將","bu2shao4jiang4"],
["不少尉","bu2shao4wei4"],
["不少年","bu2shao4nian2"],
["不少校","bu2shao4xiao4"],
["不就地","bu2jiu4di4"],
["不就裡","bu2jiu4li3"],
["不屁股","bu2pi4gu5"],
["不岁差","bu2sui4cha1"],
["不岁数","bu2sui4shu5"],
["不岸上","bu2an4shang5"],
["不巨匠","bu2ju4jiang4"],
["不巨著","bu2ju4zhu4"],
["不市長","bu2shi4zhang3"],
["不市长","bu2shi4zhang3"],
["不布伍","bu2bu4wu3"],
["不帅哥","bu2shuai4ge5"],
["不帐蓬","bu2zhang4peng5"],
["不帥哥","bu2shuai4ge5"],
["不带儿","bu2dai4r5"],
["不带去","bu2dai4qu5"],
["不帳蓬","bu2zhang4peng5"],
["不帶去","bu2dai4qu5"],
["不帹暆","bu2sha4yi2"],
["不干事","bu2gan4shi5"],
["不干吗","bu2gan4ma2"],
["不干将","bu2gan4jiang4"],
["不干麼","bu2gan4ma2"],
["不干麽","bu2gan4ma2"],
["不幸甚","bu2xing4shen4"],
["不幹事","bu2gan4shi5"],
["不幹嗎","bu2gan4ma2"],
["不幹將","bu2gan4jiang4"],
["不幹麼","bu2gan4ma2"],
["不幼兒","bu2you4er2"],
["不序曲","bu2xu4qu3"],
["不应付","bu2ying4fu5"],
["不应力","bu2ying4li4"],
["不应变","bu2ying4bian4"],
["不应和","bu2ying4he4"],
["不应对","bu2ying4dui4"],
["不应征","bu2ying4zheng1"],
["不应急","bu2ying4ji2"],
["不应战","bu2ying4zhan4"],
["不应用","bu2ying4yong4"],
["不应答","bu2ying4da2"],
["不应聘","bu2ying4pin4"],
["不应邀","bu2ying4yao1"],
["不应酬","bu2ying4chou5"],
["不店錢","bu2dian4qian5"],
["不店钱","bu2dian4qian5"],
["不度假","bu2du4jia4"],
["不度数","bu2du4shu5"],
["不度數","bu2du4shu5"],
["不座儿","bu2zuo4r5"],
["不庶子","bu2shu4zi3"],
["不建都","bu2jian4du1"],
["不弄脏","bu2nong4zang1"],
["不弔丧","bu2diao4sang1"],
["不弔喪","bu2diao4sang1"],
["不弟兄","bu2di4xiong5"],
["不弟子","bu2di4zi3"],
["不弟弟","bu2di4di5"],
["不強嘴","bu2jiang4zui3"],
["不弹夹","bu2dan4jia2"],
["不强嘴","bu2jiang4zui3"],
["不彆扭","bu2bie4niu5"],
["不彈夾","bu2dan4jia2"],
["不录供","bu2lu4gong4"],
["不径迹","bu2jing4ji4"],
["不後綴","bu2hou4zhui4"],
["不後邊","bu2hou4bian5"],
["不後面","bu2hou4mian5"],
["不後頭","bu2hou4tou5"],
["不徑跡","bu2jing4ji4"],
["不得了","bu4de2liao3"],
["不復興","bu2fu4xing1"],
["不復辟","bu2fu4bi4"],
["不必得","bu2bi4dei3"],
["不忌妒","bu2ji4du5"],
["不志向","bu2zhi4xiang5"],
["不志气","bu2zhi4qi5"],
["不志氣","bu2zhi4qi5"],
["不快活","bu2kuai4huo5"],
["不念佛","bu2nian4fo2"],
["不念叨","bu2nian4dao5"],
["不念头","bu2nian4tou5"],
["不念頭","bu2nian4tou5"],
["不态度","bu2tai4du5"],
["不怔怔","bu2zheng4zheng4"],
["不怪气","bu2guai4qi5"],
["不怪氣","bu2guai4qi5"],
["不怪物","bu2guai4wu5"],
["不怪相","bu2guai4xiang4"],
["不恨恶","bu2hen4wu4"],
["不恨惡","bu2hen4wu4"],
["不恫吓","bu2dong4he4"],
["不恫嚇","bu2dong4he4"],
["不恰当","bu2qia4dang4"],
["不恰當","bu2qia4dang4"],
["不恶少","bu2e4shao4"],
["不恶恨","bu2wu4hen4"],
["不恶相","bu2e4xiang4"],
["不恶迹","bu2e4ji4"],
["不患难","bu2huan4nan4"],
["不患難","bu2huan4nan4"],
["不惡少","bu2e4shao4"],
["不惡恨","bu2wu4hen4"],
["不惡相","bu2e4xiang4"],
["不惡跡","bu2e4ji4"],
["不意思","bu2yi4si5"],
["不意見","bu2yi4jian5"],
["不意见","bu2yi4jian5"],
["不愛人","bu2ai4ren5"],
["不愛好","bu2ai4hao4"],
["不愿意","bu2yuan4yi5"],
["不態度","bu2tai4du5"],
["不慰藉","bu2wei4jie4"],
["不應付","bu2ying4fu5"],
["不應力","bu2ying4li4"],
["不應和","bu2ying4he4"],
["不應對","bu2ying4dui4"],
["不應徵","bu2ying4zheng1"],
["不應急","bu2ying4ji2"],
["不應戰","bu2ying4zhan4"],
["不應用","bu2ying4yong4"],
["不應答","bu2ying4da2"],
["不應聘","bu2ying4pin4"],
["不應變","bu2ying4bian4"],
["不應邀","bu2ying4yao1"],
["不應酬","bu2ying4chou5"],
["不懦夫","bu2nuo4fu1"],
["不戊子","bu2wu4zi3"],
["不戍卒","bu2shu4zu2"],
["不战友","bu2zhan4you3"],
["不战地","bu2zhan4di4"],
["不戰友","bu2zhan4you3"],
["不戰地","bu2zhan4di4"],
["不戴上","bu2dai4shang5"],
["不扣上","bu2kou4shang5"],
["不扫帚","bu2sao4zhou5"],
["不扫把","bu2sao4ba3"],
["不扮演","bu2ban4yan3"],
["不扮相","bu2ban4xiang4"],
["不扮装","bu2ban4zhuang1"],
["不扮裝","bu2ban4zhuang1"],
["不技俩","bu2ji4liang3"],
["不技倆","bu2ji4liang3"],
["不把子","bu2ba4zi5"],
["不抗訴","bu2kang4su4"],
["不抗诉","bu2kang4su4"],
["不护士","bu2hu4shi5"],
["不报应","bu2bao4ying4"],
["不担子","bu2dan4zi5"],
["不拌和","bu2ban4huo4"],
["不拓展","bu2tuo4zhan3"],
["不拓扑","bu2tuo4pu1"],
["不拓撲","bu2tuo4pu1"],
["不拓荒","bu2tuo4huang1"],
["不拗口","bu2ao4kou3"],
["不拗陷","bu2ao4xian4"],
["不拚命","bu2pan4ming4"],
["不拚弃","bu2pan4qi4"],
["不拚棄","bu2pan4qi4"],
["不拜佛","bu2bai4fo2"],
["不拜倒","bu2bai4dao3"],
["不按下","bu2an4xia5"],
["不挚友","bu2zhi4you3"],
["不挣脱","bu2zheng4tuo1"],
["不挣钱","bu2zheng4qian2"],
["不振兴","bu2zhen4xing1"],
["不振興","bu2zhen4xing1"],
["不掃帚","bu2sao4zhou5"],
["不掃把","bu2sao4ba3"],
["不掖庭","bu2ye4ting2"],
["不掙脫","bu2zheng4tuo1"],
["不掙錢","bu2zheng4qian2"],
["不控訴","bu2kong4su4"],
["不控诉","bu2kong4su4"],
["不推任","bu2tui4ren4"],
["不摯友","bu2zhi4you3"],
["不操屄","bu2cao4bi1"],
["不擔子","bu2dan4zi5"],
["不放下","bu2fang4xia5"],
["不放假","bu2fang4jia4"],
["不政务","bu2zheng4wu4"],
["不政務","bu2zheng4wu4"],
["不政績","bu2zheng4ji4"],
["不政绩","bu2zheng4ji4"],
["不故事","bu2gu4shi5"],
["不故友","bu2gu4you3"],
["不故地","bu2gu4di4"],
["不故跡","bu2gu4ji4"],
["不故迹","bu2gu4ji4"],
["不故都","bu2gu4du1"],
["不效应","bu2xiao4ying4"],
["不效應","bu2xiao4ying4"],
["不救难","bu2jiu4nan4"],
["不救難","bu2jiu4nan4"],
["不敗績","bu2bai4ji4"],
["不敗訴","bu2bai4su4"],
["不教务","bu2jiao4wu4"],
["不教務","bu2jiao4wu4"],
["不教友","bu2jiao4you3"],
["不教子","bu2jiao4zi3"],
["不散盡","bu2san4jin4"],
["不料斗","bu2liao4dou3"],
["不旋子","bu2xuan4zi5"],
["不旋工","bu2xuan4gong1"],
["不旋床","bu2xuan4chuang2"],
["不旋木","bu2xuan4mu4"],
["不旋風","bu2xuan4feng1"],
["不旋风","bu2xuan4feng1"],
["不既得","bu2ji4de2"],
["不旧友","bu2jiu4you3"],
["不旧地","bu2jiu4di4"],
["不旧识","bu2jiu4shi2"],
["不旧迹","bu2jiu4ji4"],
["不旧都","bu2jiu4du1"],
["不时合","bu2shi4he2"],
["不旷夫","bu2kuang4fu1"],
["不昧沒","bu2mei4mo4"],
["不昧没","bu2mei4mo4"],
["不昵比","bu2ni4bi4"],
["不時合","bu2shi4he2"],
["不晉升","bu2jin4sheng1"],
["不晉爵","bu2jin4jue2"],
["不晉級","bu2jin4ji2"],
["不晋升","bu2jin4sheng1"],
["不晋爵","bu2jin4jue2"],
["不晋级","bu2jin4ji2"],
["不晒友","bu2shai4you3"],
["不晕场","bu2yun4chang3"],
["不晕机","bu2yun4ji1"],
["不晕池","bu2yun4chi2"],
["不晕船","bu2yun4chuan2"],
["不晕车","bu2yun4che1"],
["不晕针","bu2yun4zhen1"],
["不晾乾","bu2liang4gan1"],
["不暂息","bu2zan4xi1"],
["不暈場","bu2yun4chang3"],
["不暈機","bu2yun4ji1"],
["不暈池","bu2yun4chi2"],
["不暈船","bu2yun4chuan2"],
["不暈車","bu2yun4che1"],
["不暈針","bu2yun4zhen1"],
["不暗地","bu2an4di4"],
["不暫息","bu2zan4xi1"],
["不暴卒","bu2bao4zu2"],
["不曆年","bu2li4nian2"],
["不曆時","bu2li4shi2"],
["不曆法","bu2li4fa3"],
["不曠夫","bu2kuang4fu1"],
["不曬友","bu2shai4you3"],
["不替换","bu2ti4huan5"],
["不替換","bu2ti4huan5"],
["不替角","bu2ti4jue2"],
["不最为","bu2zui4wei2"],
["不最差","bu2zui4cha1"],
["不最為","bu2zui4wei2"],
["不會友","bu2hui4you3"],
["不會計","bu2kuai4ji4"],
["不會長","bu2hui4zhang3"],
["不月亮","bu2yue4liang5"],
["不月晕","bu2yue4yun4"],
["不月暈","bu2yue4yun4"],
["不月相","bu2yue4xiang4"],
["不服服","bu2fu4fu5"],
["不木头","bu2mu4tou5"],
["不木杆","bu2mu4gan3"],
["不木框","bu2mu4kuang4"],
["不木犀","bu2mu4xi5"],
["不木頭","bu2mu4tou5"],
["不未了","bu2wei4liao3"],
["不未卜","bu2wei4bu3"],
["不末了","bu2mo4liao3"],
["不杜塞","bu2du4se4"],
["不束发","bu2shu4fa4"],
["不杠夫","bu2gang4fu1"],
["不枘凿","bu2rui4zuo4"],
["不枘鑿","bu2rui4zuo4"],
["不架势","bu2jia4shi5"],
["不架勢","bu2jia4shi5"],
["不柵欄","bu2zha4lan5"],
["不栅栏","bu2zha4lan5"],
["不树冠","bu2shu4guan1"],
["不树干","bu2shu4gan4"],
["不校准","bu2jiao4zhun3"],
["不校勘","bu2jiao4kan1"],
["不校友","bu2xiao4you3"],
["不校地","bu2xiao4di4"],
["不校对","bu2jiao4dui4"],
["不校對","bu2jiao4dui4"],
["不校正","bu2jiao4zheng4"],
["不校準","bu2jiao4zhun3"],
["不校稿","bu2jiao4gao3"],
["不校舍","bu2xiao4she4"],
["不校訂","bu2jiao4ding4"],
["不校订","bu2jiao4ding4"],
["不校長","bu2xiao4zhang3"],
["不校长","bu2xiao4zhang3"],
["不校閱","bu2jiao4yue4"],
["不校阅","bu2jiao4yue4"],
["不校驗","bu2jiao4yan4"],
["不校验","bu2jiao4yan4"],
["不桂冠","bu2gui4guan1"],
["不框架","bu2kuang4jia4"],
["不案卷","bu2an4juan4"],
["不案称","bu2an4cheng4"],
["不案稱","bu2an4cheng4"],
["不梦见","bu2meng4jian5"],
["不梵刹","bu2fan4cha4"],
["不梵剎","bu2fan4cha4"],
["不棒槌","bu2bang4chui5"],
["不業務","bu2ye4wu4"],
["不業績","bu2ye4ji4"],
["不槓夫","bu2gang4fu1"],
["不槓杆","bu2gang4gan3"],
["不槛车","bu2jian4che1"],
["不樂器","bu2yue4qi4"],
["不樂團","bu2yue4tuan2"],
["不樂壇","bu2yue4tan2"],
["不樂師","bu2yue4shi1"],
["不樂手","bu2yue4shou3"],
["不樂曲","bu2yue4qu3"],
["不樂章","bu2yue4zhang1"],
["不樂譜","bu2yue4pu3"],
["不樂迷","bu2yue4mi2"],
["不樂隊","bu2yue4dui4"],
["不樂音","bu2yue4yin1"],
["不横死","bu2heng4si3"],
["不横财","bu2heng4cai2"],
["不樹冠","bu2shu4guan1"],
["不橫死","bu2heng4si3"],
["不橫財","bu2heng4cai2"],
["不檻車","bu2jian4che1"],
["不次子","bu2ci4zi3"],
["不次要","bu2ci4yao5"],
["不次長","bu2ci4zhang3"],
["不次长","bu2ci4zhang3"],
["不歎息","bu2tan4xi1"],
["不正切","bu2zheng4qie1"],
["不歲差","bu2sui4cha1"],
["不歲數","bu2sui4shu5"],
["不殉难","bu2xun4nan4"],
["不殉難","bu2xun4nan4"],
["不殼質","bu2qiao4zhi4"],
["不气息","bu2qi4xi1"],
["不氣息","bu2qi4xi1"],
["不沒收","bu2mo4shou1"],
["不沒落","bu2mo4luo4"],
["不沒藥","bu2mo4yao4"],
["不没收","bu2mo4shou1"],
["不没药","bu2mo4yao4"],
["不没落","bu2mo4luo4"],
["不泄露","bu2xie4lou4"],
["不泥古","bu2ni4gu3"],
["不泥子","bu2ni4zi5"],
["不泥守","bu2ni4shou3"],
["不泰斗","bu2tai4dou3"],
["不洩露","bu2xie4lou4"],
["不测量","bu2ce4liang2"],
["不浪头","bu2lang4tou5"],
["不浪子","bu2lang4zi3"],
["不浪頭","bu2lang4tou5"],
["不浸沒","bu2jin4mo4"],
["不浸没","bu2jin4mo4"],
["不涨满","bu2zhang4man3"],
["不涨红","bu2zhang4hong2"],
["不淡薄","bu2dan4bo2"],
["不淨盡","bu2jing4jin4"],
["不混淆","bu2hun4xiao2"],
["不混矇","bu2hun4meng1"],
["不混蒙","bu2hun4meng1"],
["不混跡","bu2hun4ji4"],
["不混迹","bu2hun4ji4"],
["不渡假","bu2du4jia4"],
["不測量","bu2ce4liang2"],
["不湊合","bu2cou4he5"],
["不溺愛","bu2ni4ai4"],
["不溺水","bu2ni4shui3"],
["不溺爱","bu2ni4ai4"],
["不漂亮","bu2piao4liang5"],
["不漏斗","bu2lou4dou3"],
["不漲滿","bu2zhang4man3"],
["不漲紅","bu2zhang4hong2"],
["不烫发","bu2tang4fa4"],
["不热闹","bu2re4nao5"],
["不焙乾","bu2bei4gan1"],
["不照应","bu2zhao4ying5"],
["不照得","bu2zhao4de2"],
["不照應","bu2zhao4ying5"],
["不照相","bu2zhao4xiang4"],
["不照顧","bu2zhao4gu5"],
["不照顾","bu2zhao4gu5"],
["不熱鬧","bu2re4nao5"],
["不爱人","bu2ai4ren5"],
["不爱好","bu2ai4hao4"],
["不父亲","bu2fu4qin5"],
["不父親","bu2fu4qin5"],
["不牧师","bu2mu4shi5"],
["不牧師","bu2mu4shi5"],
["不特地","bu2te4di4"],
["不特徵","bu2te4zheng1"],
["不特調","bu2te4tiao2"],
["不特调","bu2te4tiao2"],
["不特輯","bu2te4ji2"],
["不特辑","bu2te4ji2"],
["不状元","bu2zhuang4yuan5"],
["不狀元","bu2zhuang4yuan5"],
["不献上","bu2xian4shang5"],
["不獲得","bu2huo4de2"],
["不獻上","bu2xian4shang5"],
["不率先","bu2shuai4xian1"],
["不率直","bu2shuai4zhi2"],
["不率領","bu2shuai4ling3"],
["不率领","bu2shuai4ling3"],
["不瑟瑟","bu2se4se4"],
["不瑟縮","bu2se4suo1"],
["不瑟缩","bu2se4suo1"],
["不璧还","bu2bi4huan2"],
["不璧還","bu2bi4huan2"],
["不甚且","bu2shen4qie3"],
["不甚为","bu2shen4wei2"],
["不甚巨","bu2shen4ju4"],
["不甚或","bu2shen4huo4"],
["不甚浓","bu2shen4nong2"],
["不甚濃","bu2shen4nong2"],
["不甚為","bu2shen4wei2"],
["不甚而","bu2shen4er2"],
["不甚至","bu2shen4zhi4"],
["不甚鉅","bu2shen4ju4"],
["不甚钜","bu2shen4ju4"],
["不用处","bu2yong4chu5"],
["不用於","bu2yong4yu2"],
["不用盡","bu2yong4jin4"],
["不用處","bu2yong4chu5"],
["不电子","bu2dian4zi3"],
["不电荷","bu2dian4he4"],
["不画儿","bu2hua4r5"],
["不画卷","bu2hua4juan4"],
["不畜牧","bu2xu4mu4"],
["不畜牲","bu2chu4sheng5"],
["不畜生","bu2chu4sheng5"],
["不略为","bu2lve4wei2"],
["不略為","bu2lve4wei2"],
["不畫卷","bu2hua4juan4"],
["不疟疾","bu2nve4ji5"],
["不病倒","bu2bing4dao3"],
["不病假","bu2bing4jia4"],
["不病友","bu2bing4you3"],
["不病夫","bu2bing4fu1"],
["不病徵","bu2bing4zheng1"],
["不症候","bu2zheng4hou5"],
["不痛快","bu2tong4kuai5"],
["不痛楚","bu2tong4chu3"],
["不痢疾","bu2li4ji5"],
["不瘧疾","bu2nve4ji5"],
["不癥候","bu2zheng4hou5"],
["不益处","bu2yi4chu5"],
["不益處","bu2yi4chu5"],
["不盖儿","bu2gai4r5"],
["不目的","bu2mu4di4"],
["不相位","bu2xiang4wei4"],
["不相国","bu2xiang4guo2"],
["不相图","bu2xiang4tu2"],
["不相國","bu2xiang4guo2"],
["不相圖","bu2xiang4tu2"],
["不相士","bu2xiang4shi4"],
["不相声","bu2xiang4sheng5"],
["不相机","bu2xiang4ji1"],
["不相架","bu2xiang4jia4"],
["不相機","bu2xiang4ji1"],
["不相片","bu2xiang4pian1"],
["不相紙","bu2xiang4zhi3"],
["不相纸","bu2xiang4zhi3"],
["不相聲","bu2xiang4sheng5"],
["不相角","bu2xiang4jiao3"],
["不相貌","bu2xiang4mao4"],
["不相面","bu2xiang4mian4"],
["不看中","bu2kan4zhong4"],
["不看來","bu2kan4lai5"],
["不看头","bu2kan4tou5"],
["不看来","bu2kan4lai5"],
["不看相","bu2kan4xiang4"],
["不看看","bu2kan4kan5"],
["不看見","bu2kan4jian5"],
["不看见","bu2kan4jian5"],
["不看頭","bu2kan4tou5"],
["不眩晕","bu2xuan4yun4"],
["不眩暈","bu2xuan4yun4"],
["不着书","bu2zhu4shu1"],
["不着称","bu2zhu4cheng1"],
["不睡着","bu2shui4zhao2"],
["不睡著","bu2shui4zhao2"],
["不睡覺","bu2shui4jiao4"],
["不睡觉","bu2shui4jiao4"],
["不瞬息","bu2shun4xi1"],
["不知道","bu4zhi1dao4"],
["不矿难","bu2kuang4nan4"],
["不砚台","bu2yan4tai5"],
["不破相","bu2po4xiang4"],
["不硬实","bu2ying4shi5"],
["不硬實","bu2ying4shi5"],
["不硬干","bu2ying4gan4"],
["不硬朗","bu2ying4lang5"],
["不硯臺","bu2yan4tai5"],
["不碇泊","bu2ding4bo2"],
["不碰倒","bu2peng4dao3"],
["不磨叨","bu2mo4dao5"],
["不磨坊","bu2mo4fang2"],
["不磨子","bu2mo4zi5"],
["不磨烦","bu2mo4fan5"],
["不磨煩","bu2mo4fan5"],
["不磨盘","bu2mo4pan2"],
["不磨盤","bu2mo4pan2"],
["不礦難","bu2kuang4nan4"],
["不社長","bu2she4zhang3"],
["不社长","bu2she4zhang3"],
["不禁令","bu2jin4ling4"],
["不禁军","bu2jin4jun1"],
["不禁区","bu2jin4qu1"],
["不禁區","bu2jin4qu1"],
["不禁品","bu2jin4pin3"],
["不禁忌","bu2jin4ji4"],
["不禁戒","bu2jin4jie4"],
["不禁果","bu2jin4guo3"],
["不禁止","bu2jin4zhi3"],
["不禁毒","bu2jin4du2"],
["不禁演","bu2jin4yan3"],
["不禁烟","bu2jin4yan1"],
["不禁煙","bu2jin4yan1"],
["不禁用","bu2jin4yong4"],
["不禁药","bu2jin4yao4"],
["不禁藥","bu2jin4yao4"],
["不禁軍","bu2jin4jun1"],
["不禁运","bu2jin4yun4"],
["不禁運","bu2jin4yun4"],
["不禁酒","bu2jin4jiu3"],
["不禁錮","bu2jin4gu4"],
["不禁锢","bu2jin4gu4"],
["不禁食","bu2jin4shi2"],
["不禅位","bu2shan4wei4"],
["不禅让","bu2shan4rang4"],
["不离儿","bu4li2r5"],
["不秀发","bu2xiu4fa4"],
["不秀才","bu2xiu4cai5"],
["不秀气","bu2xiu4qi5"],
["不秀氣","bu2xiu4qi5"],
["不种地","bu2zhong4di4"],
["不种树","bu2zhong4shu4"],
["不种植","bu2zhong4zhi2"],
["不种花","bu2zhong4hua1"],
["不秤杆","bu2cheng4gan3"],
["不称心","bu2chen4xin1"],
["不称槃","bu2cheng4pan2"],
["不称锤","bu2cheng4chui2"],
["不稅務","bu2shui4wu4"],
["不税务","bu2shui4wu4"],
["不種地","bu2zhong4di4"],
["不種植","bu2zhong4zhi2"],
["不種樹","bu2zhong4shu4"],
["不種花","bu2zhong4hua1"],
["不稱心","bu2chen4xin1"],
["不稱槃","bu2cheng4pan2"],
["不稱錘","bu2cheng4chui2"],
["不空位","bu2kong4wei4"],
["不空余","bu2kong4yu2"],
["不空儿","bu2kong4r5"],
["不空兒","bu2kong4r5"],
["不空地","bu2kong4di4"],
["不空子","bu2kong4zi5"],
["不空当","bu2kong4dang1"],
["不空日","bu2kong4ri4"],
["不空暇","bu2kong4xia2"],
["不空格","bu2kong4ge2"],
["不空當","bu2kong4dang1"],
["不空白","bu2kong4bai2"],
["不空缺","bu2kong4que1"],
["不空閑","bu2kong4xian2"],
["不空闲","bu2kong4xian2"],
["不空隙","bu2kong4xi4"],
["不空額","bu2kong4e2"],
["不空额","bu2kong4e2"],
["不空餘","bu2kong4yu2"],
["不窒息","bu2zhi4xi1"],
["不站長","bu2zhan4zhang3"],
["不站长","bu2zhan4zhang3"],
["不笑話","bu2xiao4hua5"],
["不笑话","bu2xiao4hua5"],
["不策劃","bu2ce4hua4"],
["不算子","bu2suan4zi3"],
["不箭杆","bu2jian4gan3"],
["不簸箕","bu2bo4ji5"],
["不粒子","bu2li4zi3"],
["不糊弄","bu2hu4nong5"],
["不系上","bu2ji4shang5"],
["不系囚","bu2ji4qiu2"],
["不納降","bu2na4xiang2"],
["不細挑","bu2xi4tiao5"],
["不絆倒","bu2ban4dao3"],
["不絮叨","bu2xu4dao5"],
["不絮烦","bu2xu4fan5"],
["不絮煩","bu2xu4fan5"],
["不綠苔","bu2lv4tai2"],
["不綴飾","bu2zhui4shi4"],
["不縣長","bu2xian4zhang3"],
["不縴夫","bu2qian4fu1"],
["不績效","bu2ji4xiao4"],
["不繞地","bu2rao4di4"],
["不繫上","bu2ji4shang5"],
["不繫囚","bu2ji4qiu2"],
["不續假","bu2xu4jia4"],
["不纖夫","bu2qian4fu1"],
["不纤夫","bu2qian4fu1"],
["不纳降","bu2na4xiang2"],
["不细挑","bu2xi4tiao5"],
["不绊倒","bu2ban4dao3"],
["不绕地","bu2rao4di4"],
["不绩效","bu2ji4xiao4"],
["不续假","bu2xu4jia4"],
["不绿苔","bu2lv4tai2"],
["不缀饰","bu2zhui4shi4"],
["不罐头","bu2guan4tou5"],
["不罐頭","bu2guan4tou5"],
["不罢休","bu2ba4xiu1"],
["不罢免","bu2ba4mian3"],
["不罢官","bu2ba4guan1"],
["不罢工","bu2ba4gong1"],
["不罢市","bu2ba4shi4"],
["不罢手","bu2ba4shou3"],
["不罢教","bu2ba4jiao4"],
["不罢论","bu2ba4lun4"],
["不罢课","bu2ba4ke4"],
["不罢黜","bu2ba4chu4"],
["不罪过","bu2zui4guo5"],
["不罪過","bu2zui4guo5"],
["不置於","bu2zhi4yu2"],
["不罷休","bu2ba4xiu1"],
["不罷免","bu2ba4mian3"],
["不罷官","bu2ba4guan1"],
["不罷工","bu2ba4gong1"],
["不罷市","bu2ba4shi4"],
["不罷手","bu2ba4shou3"],
["不罷教","bu2ba4jiao4"],
["不罷課","bu2ba4ke4"],
["不罷論","bu2ba4lun4"],
["不罷黜","bu2ba4chu4"],
["不義務","bu2yi4wu4"],
["不義氣","bu2yi4qi5"],
["不聖地","bu2sheng4di4"],
["不聖跡","bu2sheng4ji4"],
["不肆拾","bu2si4shi2"],
["不背脊","bu2bei4ji3"],
["不胜地","bu2sheng4di4"],
["不脈息","bu2mai4xi1"],
["不脉息","bu2mai4xi1"],
["不腹地","bu2fu4di4"],
["不腻友","bu2ni4you3"],
["不腻味","bu2ni4wei5"],
["不腻烦","bu2ni4fan5"],
["不膩友","bu2ni4you3"],
["不膩味","bu2ni4wei5"],
["不膩煩","bu2ni4fan5"],
["不臥佛","bu2wo4fo2"],
["不臥倒","bu2wo4dao3"],
["不自传","bu2zi4zhuan4"],
["不自傳","bu2zi4zhuan4"],
["不自在","bu2zi4zai5"],
["不自得","bu2zi4de2"],
["不自盡","bu2zi4jin4"],
["不自給","bu2zi4ji3"],
["不自给","bu2zi4ji3"],
["不自轉","bu2zi4zhuan4"],
["不自转","bu2zi4zhuan4"],
["不臭跡","bu2chou4ji4"],
["不臭迹","bu2chou4ji4"],
["不至当","bu2zhi4dang4"],
["不至於","bu2zhi4yu2"],
["不至當","bu2zhi4dang4"],
["不舅母","bu2jiu4mu5"],
["不與會","bu2yu4hui4"],
["不興致","bu2xing4zhi4"],
["不興趣","bu2xing4qu4"],
["不舊友","bu2jiu4you3"],
["不舊地","bu2jiu4di4"],
["不舊識","bu2jiu4shi2"],
["不舊跡","bu2jiu4ji4"],
["不舊都","bu2jiu4du1"],
["不舍下","bu2she4xia4"],
["不舍利","bu2she4li4"],
["不舰只","bu2jian4zhi1"],
["不舰长","bu2jian4zhang3"],
["不艦長","bu2jian4zhang3"],
["不色相","bu2se4xiang4"],
["不色長","bu2se4zhang3"],
["不色长","bu2se4zhang3"],
["不艾塔","bu2ai4ta3"],
["不艾炷","bu2ai4zhu4"],
["不艾絨","bu2ai4rong2"],
["不艾绒","bu2ai4rong2"],
["不芋头","bu2yu4tou5"],
["不芋頭","bu2yu4tou5"],
["不芥末","bu2jie4mo5"],
["不芥蓝","bu2gai4lan2"],
["不芥藍","bu2gai4lan2"],
["不苎麻","bu2zhu4ma2"],
["不苧麻","bu2zhu4ma2"],
["不茉莉","bu2mo4li5"],
["不莨菪","bu2lang4dang4"],
["不获得","bu2huo4de2"],
["不菌子","bu2jun4zi5"],
["不菜地","bu2cai4di4"],
["不落地","bu2luo4di4"],
["不落空","bu2lao4kong1"],
["不著作","bu2zhu4zuo4"],
["不著名","bu2zhu4ming2"],
["不著录","bu2zhu4lu4"],
["不著書","bu2zhu4shu1"],
["不著稱","bu2zhu4cheng1"],
["不著述","bu2zhu4shu4"],
["不著錄","bu2zhu4lu4"],
["不蒜茸","bu2suan4rong2"],
["不蓓蕾","bu2bei4lei3"],
["不蔓延","bu2man4yan2"],
["不蔓草","bu2man4cao3"],
["不蔗农","bu2zhe4nong2"],
["不蔗糖","bu2zhe4tang2"],
["不蔗農","bu2zhe4nong2"],
["不蔚为","bu2wei4wei2"],
["不蔚為","bu2wei4wei2"],
["不蕴藉","bu2yun4jie4"],
["不薄荷","bu2bo4he5"],
["不薏米","bu2yi4mi3"],
["不藉口","bu2jie4kou3"],
["不藉由","bu2jie4you2"],
["不藉着","bu2jie4zhe5"],
["不藉著","bu2jie4zhe5"],
["不藏象","bu2zang4xiang4"],
["不蘊藉","bu2yun4jie4"],
["不虼蚤","bu2ge4zao5"],
["不蚂蚱","bu2ma4zha5"],
["不蝲蛄","bu2la4gu3"],
["不螞蚱","bu2ma4zha5"],
["不血跡","bu2xue4ji4"],
["不血迹","bu2xue4ji4"],
["不被卧","bu2bei4wo5"],
["不被臥","bu2bei4wo5"],
["不裨益","bu2bi4yi4"],
["不襯裡","bu2chen4li3"],
["不要务","bu2yao4wu4"],
["不要務","bu2yao4wu4"],
["不要地","bu2yao4di4"],
["不要塞","bu2yao4sai4"],
["不要得","bu2yao4de2"],
["不要是","bu2yao4shi5"],
["不覆沒","bu2fu4mo4"],
["不覆没","bu2fu4mo4"],
["不視差","bu2shi4cha1"],
["不視為","bu2shi4wei2"],
["不親家","bu2qing4jia5"],
["不覲見","bu2jin4jian4"],
["不视为","bu2shi4wei2"],
["不视差","bu2shi4cha1"],
["不觐见","bu2jin4jian4"],
["不計劃","bu2ji4hua4"],
["不計都","bu2ji4du1"],
["不訊息","bu2xun4xi1"],
["不記住","bu2ji4zhu5"],
["不記傳","bu2ji4zhuan4"],
["不記性","bu2ji4xing5"],
["不記為","bu2ji4wei2"],
["不記號","bu2ji4hao5"],
["不記載","bu2ji4zai3"],
["不訴求","bu2su4qiu2"],
["不訴苦","bu2su4ku3"],
["不訴訟","bu2su4song4"],
["不訴說","bu2su4shuo1"],
["不註冊","bu2zhu4ce4"],
["不註定","bu2zhu4ding4"],
["不註腳","bu2zhu4jiao3"],
["不註解","bu2zhu4jie3"],
["不註釋","bu2zhu4shi4"],
["不註音","bu2zhu4yin1"],
["不詐降","bu2zha4xiang2"],
["不試卷","bu2shi4juan4"],
["不認為","bu2ren4wei2"],
["不誤差","bu2wu4cha1"],
["不說客","bu2shui4ke4"],
["不調和","bu4tiao2he2"],
["不謎兒","bu2mei4r5"],
["不謝帖","bu2xie4tie3"],
["不謝謝","bu2xie4xie5"],
["不譔杜","bu2du4zhuan4"],
["不議長","bu2yi4zhang3"],
["不護士","bu2hu4shi5"],
["不變更","bu2bian4geng1"],
["不變為","bu2bian4wei2"],
["不變相","bu2bian4xiang4"],
["不變通","bu2bian4tong5"],
["不讓開","bu2rang4kai5"],
["不计都","bu2ji4du1"],
["不认为","bu2ren4wei2"],
["不让开","bu2rang4kai5"],
["不议长","bu2yi4zhang3"],
["不讯息","bu2xun4xi1"],
["不记为","bu2ji4wei2"],
["不记传","bu2ji4zhuan4"],
["不记住","bu2ji4zhu5"],
["不记号","bu2ji4hao5"],
["不记性","bu2ji4xing5"],
["不记载","bu2ji4zai3"],
["不诈降","bu2zha4xiang2"],
["不诉求","bu2su4qiu2"],
["不诉苦","bu2su4ku3"],
["不诉讼","bu2su4song4"],
["不诉说","bu2su4shuo1"],
["不试卷","bu2shi4juan4"],
["不误差","bu2wu4cha1"],
["不说客","bu2shui4ke4"],
["不调和","bu4tiao2he2"],
["不谜儿","bu2mei4r5"],
["不谢帖","bu2xie4tie3"],
["不谢谢","bu2xie4xie5"],
["不豁免","bu2huo4mian3"],
["不豁然","bu2huo4ran2"],
["不豆腐","bu2dou4fu5"],
["不象徵","bu2xiang4zheng1"],
["不負荷","bu2fu4he4"],
["不貳拾","bu2er4shi2"],
["不費用","bu2fei4yong5"],
["不質地","bu2zhi4di4"],
["不質子","bu2zhi4zi3"],
["不質難","bu2zhi4nan4"],
["不賬載","bu2zhang4zai3"],
["不賺得","bu2zhuan4de2"],
["不负荷","bu2fu4he4"],
["不败绩","bu2bai4ji4"],
["不败诉","bu2bai4su4"],
["不账载","bu2zhang4zai3"],
["不质地","bu2zhi4di4"],
["不质子","bu2zhi4zi3"],
["不质难","bu2zhi4nan4"],
["不贰拾","bu2er4shi2"],
["不费用","bu2fei4yong5"],
["不赚得","bu2zhuan4de2"],
["不越桔","bu2yue4jie2"],
["不跡象","bu2ji4xiang4"],
["不跪下","bu2gui4xia5"],
["不跪倒","bu2gui4dao3"],
["不路上","bu2lu4shang5"],
["不跳蚤","bu2tiao4zao5"],
["不踉跄","bu2liang4qiang4"],
["不踉蹌","bu2liang4qiang4"],
["不踺子","bu2jian4zi3"],
["不蹦儿","bu2beng4r5"],
["不蹦跶","bu2beng4da5"],
["不蹦躂","bu2beng4da5"],
["不蹦达","bu2beng4da5"],
["不蹦達","bu2beng4da5"],
["不軋場","bu2ya4chang2"],
["不載荷","bu2zai4he4"],
["不輩分","bu2bei4fen5"],
["不轉圈","bu2zhuan4quan1"],
["不轉塔","bu2zhuan4ta3"],
["不轉子","bu2zhuan4zi3"],
["不轉悠","bu2zhuan4you5"],
["不轉椅","bu2zhuan4yi3"],
["不轉爐","bu2zhuan4lu2"],
["不轉矩","bu2zhuan4ju3"],
["不轉磨","bu2zhuan4mo4"],
["不轉筋","bu2zhuan4jin1"],
["不轉紐","bu2zhuan4niu3"],
["不轉臺","bu2zhuan4tai2"],
["不轉距","bu2zhuan4ju4"],
["不轉軸","bu2zhuan4zhou2"],
["不轉輪","bu2zhuan4lun2"],
["不轉速","bu2zhuan4su4"],
["不轉鈴","bu2zhuan4ling2"],
["不轉門","bu2zhuan4men2"],
["不轉鼓","bu2zhuan4gu3"],
["不轎車","bu2jiao4che1"],
["不轧场","bu2ya4chang2"],
["不转台","bu2zhuan4tai2"],
["不转圈","bu2zhuan4quan1"],
["不转塔","bu2zhuan4ta3"],
["不转子","bu2zhuan4zi3"],
["不转悠","bu2zhuan4you5"],
["不转椅","bu2zhuan4yi3"],
["不转炉","bu2zhuan4lu2"],
["不转矩","bu2zhuan4ju3"],
["不转磨","bu2zhuan4mo4"],
["不转筋","bu2zhuan4jin1"],
["不转纽","bu2zhuan4niu3"],
["不转距","bu2zhuan4ju4"],
["不转轮","bu2zhuan4lun2"],
["不转轴","bu2zhuan4zhou2"],
["不转速","bu2zhuan4su4"],
["不转铃","bu2zhuan4ling2"],
["不转门","bu2zhuan4men2"],
["不转鼓","bu2zhuan4gu3"],
["不载荷","bu2zai4he4"],
["不轿车","bu2jiao4che1"],
["不辈分","bu2bei4fen5"],
["不辟邪","bu2bi4xie2"],
["不辨識","bu2bian4shi2"],
["不辨识","bu2bian4shi2"],
["不辩难","bu2bian4nan4"],
["不辯難","bu2bian4nan4"],
["不过分","bu2guo4fen4"],
["不过去","bu2guo4qu5"],
["不过来","bu2guo4lai5"],
["不运气","bu2yun4qi5"],
["不运转","bu2yun4zhuan4"],
["不近視","bu2jin4shi5"],
["不近视","bu2jin4shi5"],
["不这儿","bu2zhe4r5"],
["不这咱","bu2zhe4zan5"],
["不这麽","bu2zhe4me5"],
["不进去","bu2jin4qu5"],
["不进来","bu2jin4lai5"],
["不迫於","bu2po4yu2"],
["不迳迹","bu2jing4ji4"],
["不迹象","bu2ji4xiang4"],
["不退伍","bu2tui4wu3"],
["不退还","bu2tui4huan2"],
["不退還","bu2tui4huan2"],
["不适宜","bu2shi4yi2"],
["不适应","bu2shi4ying4"],
["不适当","bu2shi4dang4"],
["不逆子","bu2ni4zi3"],
["不逆差","bu2ni4cha1"],
["不递解","bu2di4jie4"],
["不逕跡","bu2jing4ji4"],
["不逗弄","bu2dou4nong5"],
["不這咱","bu2zhe4zan5"],
["不這裡","bu2zhe4li3"],
["不造血","bu2zao4xie3"],
["不逮捕","bu2dai4bu3"],
["不進來","bu2jin4lai5"],
["不進去","bu2jin4qu5"],
["不遇难","bu2yu4nan4"],
["不遇難","bu2yu4nan4"],
["不運氣","bu2yun4qi5"],
["不運轉","bu2yun4zhuan4"],
["不遍地","bu2bian4di4"],
["不過來","bu2guo4lai5"],
["不過分","bu2guo4fen4"],
["不過去","bu2guo4qu5"],
["不過於","bu2guo4yu2"],
["不道地","bu2dao4di4"],
["不道理","bu2dao4li5"],
["不遞解","bu2di4jie4"],
["不適宜","bu2shi4yi2"],
["不適應","bu2shi4ying4"],
["不適當","bu2shi4dang4"],
["不避难","bu2bi4nan4"],
["不避難","bu2bi4nan4"],
["不那儿","bu2na4r5"],
["不那只","bu2na4zhi1"],
["不那是","bu2na4shi5"],
["不那边","bu2na4bian5"],
["不那邊","bu2na4bian5"],
["不那里","bu2na4li5"],
["不那麽","bu2na4me5"],
["不郑重","bu2zheng4zhong4"],
["不部下","bu2bu4xia5"],
["不部分","bu2bu4fen5"],
["不部長","bu2bu4zhang3"],
["不部长","bu2bu4zhang3"],
["不鄭重","bu2zheng4zhong4"],
["不配子","bu2pei4zi3"],
["不配得","bu2pei4de2"],
["不配称","bu2pei4chen4"],
["不配稱","bu2pei4chen4"],
["不配角","bu2pei4jue2"],
["不采邑","bu2cai4yi4"],
["不释卷","bu2shi4juan4"],
["不釋卷","bu2shi4juan4"],
["不重创","bu2zhong4chuang1"],
["不重創","bu2zhong4chuang1"],
["不重子","bu2zhong4zi3"],
["不重担","bu2zhong4dan4"],
["不重擔","bu2zhong4dan4"],
["不重荷","bu2zhong4he4"],
["不量子","bu2liang4zi3"],
["不釘死","bu2ding4si3"],
["不鋪家","bu2pu4jia5"],
["不錄供","bu2lu4gong4"],
["不錯處","bu2cuo4chu5"],
["不鎮咳","bu2zhen4ke2"],
["不鎮長","bu2zhen4zhang3"],
["不鑒於","bu2jian4yu2"],
["不鑽井","bu2zuan4jing3"],
["不鑽石","bu2zuan4shi2"],
["不鑽頭","bu2zuan4tou2"],
["不钉死","bu2ding4si3"],
["不钻井","bu2zuan4jing3"],
["不钻头","bu2zuan4tou2"],
["不钻石","bu2zuan4shi2"],
["不铺家","bu2pu4jia5"],
["不错处","bu2cuo4chu5"],
["不镇咳","bu2zhen4ke2"],
["不镇长","bu2zhen4zhang3"],
["不閉上","bu2bi4shang5"],
["不閉塞","bu2bi4se4"],
["不間接","bu2jian4jie1"],
["不間斷","bu2jian4duan4"],
["不間歇","bu2jian4xie1"],
["不間苗","bu2jian4miao2"],
["不間諜","bu2jian4die2"],
["不間隔","bu2jian4ge2"],
["不間隙","bu2jian4xi4"],
["不闊氣","bu2kuo4qi5"],
["不闭上","bu2bi4shang5"],
["不闭塞","bu2bi4se4"],
["不间接","bu2jian4jie1"],
["不间断","bu2jian4duan4"],
["不间歇","bu2jian4xie1"],
["不间苗","bu2jian4miao2"],
["不间谍","bu2jian4die2"],
["不间隔","bu2jian4ge2"],
["不间隙","bu2jian4xi4"],
["不阔气","bu2kuo4qi5"],
["不队友","bu2dui4you3"],
["不队长","bu2dui4zhang3"],
["不阵地","bu2zhen4di4"],
["不附和","bu2fu4he4"],
["不附着","bu2fu4zhuo2"],
["不附著","bu2fu4zhuo2"],
["不陆地","bu2lu4di4"],
["不降息","bu2jiang4xi1"],
["不限於","bu2xian4yu2"],
["不院長","bu2yuan4zhang3"],
["不院长","bu2yuan4zhang3"],
["不陣地","bu2zhen4di4"],
["不陷於","bu2xian4yu2"],
["不陸地","bu2lu4di4"],
["不隊友","bu2dui4you3"],
["不隊長","bu2dui4zhang3"],
["不难民","bu2nan4min2"],
["不雇傭","bu2gu4yong1"],
["不難民","bu2nan4min2"],
["不電子","bu2dian4zi3"],
["不電荷","bu2dian4he4"],
["不露丑","bu2lou4chou3"],
["不露头","bu2lou4tou2"],
["不露富","bu2lou4fu4"],
["不露底","bu2lou4di3"],
["不露怯","bu2lou4qie4"],
["不露水","bu2lu4shui5"],
["不露白","bu2lou4bai2"],
["不露相","bu2lou4xiang4"],
["不露脸","bu2lou4lian3"],
["不露臉","bu2lou4lian3"],
["不露苗","bu2lou4miao2"],
["不露醜","bu2lou4chou3"],
["不露面","bu2lou4mian4"],
["不露頭","bu2lou4tou2"],
["不露風","bu2lou4feng1"],
["不露风","bu2lou4feng1"],
["不露餡","bu2lou4xian4"],
["不露馅","bu2lou4xian4"],
["不露齒","bu2lou4chi3"],
["不露齿","bu2lou4chi3"],
["不靓妹","bu2liang4mei4"],
["不靚妹","bu2liang4mei4"],
["不面儿","bu2mian4r5"],
["不面友","bu2mian4you3"],
["不面积","bu2mian4ji5"],
["不面積","bu2mian4ji5"],
["不面糊","bu2mian4hu2"],
["不面食","bu2mian4shi5"],
["不順應","bu2shun4ying4"],
["不順溜","bu2shun4liu5"],
["不順當","bu2shun4dang5"],
["不預卜","bu2yu4bu3"],
["不願意","bu2yuan4yi5"],
["不顫慄","bu2zhan4li4"],
["不顺应","bu2shun4ying4"],
["不顺当","bu2shun4dang5"],
["不顺溜","bu2shun4liu5"],
["不预卜","bu2yu4bu3"],
["不颤栗","bu2zhan4li4"],
["不飯食","bu2fan4shi5"],
["不飾釘","bu2shi4ding4"],
["不饭食","bu2fan4shi5"],
["不饰钉","bu2shi4ding4"],
["不馅儿","bu2xian4r5"],
["不馱子","bu2duo4zi5"],
["不馴駝","bu2xun4tuo2"],
["不駐地","bu2zhu4di4"],
["不駐紮","bu2zhu4zha1"],
["不騙供","bu2pian4gong4"],
["不驮子","bu2duo4zi5"],
["不驯驼","bu2xun4tuo2"],
["不驻地","bu2zhu4di4"],
["不驻紮","bu2zhu4zha1"],
["不骗供","bu2pian4gong4"],
["不體面","bu4ti3mian4"],
["不鬓发","bu2bin4fa4"],
["不鱔魚","bu2shan4yu2"],
["不鳝鱼","bu2shan4yu2"],
["不麵糊","bu2mian4hu4"],
["不麵食","bu2mian4shi5"],
["不Ｕ盘","bu2yu4pan2"],
["不Ｕ盤","bu2yu4pan2"],
["不一会儿","bu4yi4hui3r5"],
["不一會兒","bu4yi4hui3r5"],
["不一而足","bu4yi4er2zu2"],
["不上个月","bu2shang4ge5yue4"],
["不上個月","bu2shang4ge5yue4"],
["不上边儿","bu2shang4bian5r5"],
["不下个月","bu2xia4ge4yue4"],
["不下個月","bu2xia4ge4yue4"],
["不下边儿","bu2xia4bian5r5"],
["不丧气话","bu2sang4qi4hua4"],
["不丧气鬼","bu2sang4qi4gui3"],
["不个头儿","bu2ge4tou2r5"],
["不中圈套","bu2zhong4quan1tao4"],
["不为人知","bu4wei2ren2zhi1"],
["不为已甚","bu4wei2yi3shen4"],
["不乐学者","bu2yue4xue2zhe3"],
["不乱蓬蓬","bu2luan4peng1peng1"],
["不乾不凈","bu4gan1bu2jing4"],
["不亂蓬蓬","bu2luan4peng1peng1"],
["不了了之","bu4liao3liao3zhi1"],
["不二噁英","bu2er4e4ying1"],
["不二把手","bu2er4ba3shou3"],
["不互操性","bu2hu4cao4xing5"],
["不亦乐乎","bu2yi4le4hu1"],
["不亦樂乎","bu2yi4le4hu1"],
["不佔便宜","bu2zhan4pian2yi5"],
["不個頭兒","bu2ge4tou2r5"],
["不倒过儿","bu2dao4guo5r5"],
["不倒過兒","bu2dao4guo5r5"],
["不借单儿","bu2jie4dan1r5"],
["不借字儿","bu2jie4zi4r5"],
["不值一提","bu4zhi2yi4ti2"],
["不值一文","bu4zhi2yi4wen2"],
["不值一笑","bu4zhi2yi2xiao4"],
["不值一談","bu4zhi2yi4tan2"],
["不值一谈","bu4zhi2yi4tan2"],
["不值一錢","bu4zhi2yi4qian2"],
["不值一钱","bu4zhi2yi4qian2"],
["不值一顧","bu4zhi2yi2gu4"],
["不值一顾","bu4zhi2yi2gu4"],
["不值一駁","bu4zhi2yi4bo2"],
["不值一驳","bu4zhi2yi4bo2"],
["不做不到","bu2zuo4bu5dao4"],
["不做买卖","bu2zuo4mai3mai5"],
["不做人家","bu2zuo4ren2jia1"],
["不做伴儿","bu2zuo4ban4r5"],
["不做買賣","bu2zuo4mai3mai5"],
["不傍家儿","bu2bang4jia1r5"],
["不像片簿","bu2xiang4pian4bu4"],
["不免一死","bu4mian3yi4si3"],
["不內切球","bu2nei4qie1qiu2"],
["不兴冲冲","bu2xing4chong1chong1"],
["不内切球","bu2nei4qie1qiu2"],
["不冒失鬼","bu2mao4shi5gui3"],
["不凤仙花","bu2feng4xian1hua1"],
["不利得稅","bu2li4de2shui4"],
["不利得税","bu2li4de2shui4"],
["不利息率","bu2li4xi5lv4"],
["不到时候","bu2dao4shi2hou4"],
["不到時候","bu2dao4shi2hou4"],
["不制服呢","bu2zhi4fu2ni2"],
["不制鞋匠","bu2zhi4xie2jiang4"],
["不刺芹菇","bu2ci4qin2gu1"],
["不剃发令","bu2ti4fa4ling4"],
["不劃時代","bu2hua4shi2dai4"],
["不办不到","bu2ban4bu5dao4"],
["不务正业","bu2wu4zheng4ye4"],
["不动不动","bu2dong4bu5dong4"],
["不势利眼","bu2shi4li5yan3"],
["不動不動","bu2dong4bu5dong4"],
["不務正業","bu2wu4zheng4ye4"],
["不勢利眼","bu2shi4li5yan3"],
["不匯出行","bu2hui4chu1hang2"],
["不占便宜","bu2zhan4pian2yi5"],
["不卸肩儿","bu2xie4jian1r5"],
["不历史上","bu2li4shi3shang5"],
["不受不了","bu2shou4bu5liao3"],
["不变奏曲","bu2bian4zou4qu3"],
["不变样儿","bu2bian4yang4r5"],
["不变法儿","bu2bian4fa3r5"],
["不变速杆","bu2bian4su4gan3"],
["不可估量","bu4ke3gu1liang4"],
["不可勝數","bu4ke3sheng4shu3"],
["不可多得","bu4ke3duo1de2"],
["不可得兼","bu4ke3de2jian1"],
["不可胜数","bu4ke3sheng4shu3"],
["不右边儿","bu2you4bian5r5"],
["不名一文","bu4ming2yi4wen2"],
["不名一錢","bu4ming2yi4qian2"],
["不名一钱","bu4ming2yi4qian2"],
["不吐苦水","bu2tu4ku3shui3"],
["不向北地","bu2xiang4bei3di4"],
["不命中率","bu2ming4zhong4lv4"],
["不喝倒彩","bu2he4dao4cai3"],
["不喪氣話","bu2sang4qi4hua4"],
["不喪氣鬼","bu2sang4qi4gui3"],
["不四部曲","bu2si4bu4qu3"],
["不在下面","bu2zai4xia4mian4"],
["不地平線","bu2di4ping2xian4"],
["不地平线","bu2di4ping2xian4"],
["不地心說","bu2di4xin1shuo1"],
["不地心说","bu2di4xin1shuo1"],
["不地方官","bu2di4fang1guan1"],
["不地方性","bu2di4fang1xing4"],
["不地磁场","bu2di4ci2chang3"],
["不地磁場","bu2di4ci2chang3"],
["不坏包儿","bu2huai4bao1r5"],
["不垫底儿","bu2dian4di3r5"],
["不垫脚石","bu2dian4jiao3shi2"],
["不報務員","bu2bao4wu4yuan2"],
["不墊腳石","bu2dian4jiao3shi2"],
["不墨水儿","bu2mo4shui3r5"],
["不夜宵儿","bu2ye4xiao1r5"],
["不大不了","bu2da4bu5liao3"],
["不大体上","bu2da4ti3shang5"],
["不大分子","bu2da4fen1zi3"],
["不大学生","bu2da4xue2sheng1"],
["不大學生","bu2da4xue2sheng1"],
["不大拇指","bu2da4mu5zhi3"],
["不大氧吧","bu2da4yang3ba1"],
["不大离儿","bu2da4li2r5"],
["不大部份","bu2da4bu4fen5"],
["不大都会","bu2da4du1hui4"],
["不大都會","bu2da4du1hui4"],
["不大體上","bu2da4ti3shang5"],
["不大麥地","bu2da4mai4di4"],
["不大麦地","bu2da4mai4di4"],
["不大黃蜂","bu2da4huang2feng1"],
["不大黄蜂","bu2da4huang2feng1"],
["不奏鳴曲","bu2zou4ming2qu3"],
["不奏鸣曲","bu2zou4ming2qu3"],
["不奔头儿","bu2ben4tou5r5"],
["不奔頭兒","bu2ben4tou5r5"],
["不套口供","bu2tao4kou3gong4"],
["不套马杆","bu2tao4ma3gan3"],
["不奥米伽","bu2ao4mi3ga1"],
["不奧米伽","bu2ao4mi3ga1"],
["不定场白","bu2ding4chang2bai2"],
["不定場白","bu2ding4chang2bai2"],
["不室內樂","bu2shi4nei4yue4"],
["不室内乐","bu2shi4nei4yue4"],
["不对不上","bu2dui4bu5shang4"],
["不对不住","bu2dui4bu5zhu4"],
["不对不起","bu2dui4bu5qi3"],
["不对劲儿","bu2dui4jin4r5"],
["不对味儿","bu2dui4wei4r5"],
["不对工儿","bu2dui4gong1r5"],
["不对心儿","bu2dui4xin1r5"],
["不对着干","bu2dui4zhe5gan4"],
["不对碴儿","bu2dui4cha2r5"],
["不对茬儿","bu2dui4cha2r5"],
["不對不上","bu2dui4bu5shang4"],
["不對不住","bu2dui4bu5zhu4"],
["不對不起","bu2dui4bu5qi3"],
["不屁眼儿","bu2pi4yan3r5"],
["不屑一顧","bu2xie4yi2gu4"],
["不屑一顾","bu2xie4yi2gu4"],
["不差不多","bu2cha4bu5duo1"],
["不差不离","bu2cha4bu5li2"],
["不差不離","bu2cha4bu5li2"],
["不帧太长","bu2zheng4tai4chang2"],
["不幀太長","bu2zheng4tai4chang2"],
["不干不净","bu4gan1bu2jing4"],
["不幸運兒","bu2xing4yun4er2"],
["不应激性","bu2ying4ji1xing4"],
["不弄不清","bu2nong4bu5qing1"],
["不弄明白","bu2nong4ming2bai2"],
["不当得利","bu4dang1de2li4"],
["不得不为","bu4de2bu4wei2"],
["不得不為","bu4de2bu4wei2"],
["不得劲儿","bu4de2jin4r5"],
["不必得着","bu2bi4de2zhao2"],
["不必得著","bu2bi4de2zhao2"],
["不快板儿","bu2kuai4ban3r5"],
["不快点儿","bu2kuai4dian5r5"],
["不快點兒","bu2kuai4dian5r5"],
["不怔神儿","bu2zheng4shen2r5"],
["不怔神兒","bu2zheng4shen2r5"],
["不急之务","bu4ji2zhi1wu4"],
["不急之務","bu4ji2zhi1wu4"],
["不怪不得","bu2guai4bu5de5"],
["不怪念头","bu2guai4nian4tou2"],
["不怪念頭","bu2guai4nian4tou2"],
["不怪物似","bu2guai4wu4si4"],
["不恨不得","bu2hen4bu5de5"],
["不恨不能","bu2hen4bu5neng2"],
["不恶势力","bu2e4shi4li4"],
["不恶名儿","bu2e4ming2r5"],
["不惜一战","bu4xi1yi2zhan4"],
["不惜一戰","bu4xi1yi2zhan4"],
["不惡勢力","bu2e4shi4li4"],
["不慕道友","bu2mu4dao4you3"],
["不慢腾腾","bu2man4teng1teng1"],
["不慢騰騰","bu2man4teng1teng1"],
["不憩息处","bu2qi4xi1chu4"],
["不憩息處","bu2qi4xi1chu4"],
["不應激性","bu2ying4ji1xing4"],
["不护发素","bu2hu4fa4su4"],
["不报务员","bu2bao4wu4yuan2"],
["不抱佛脚","bu2bao4fo2jiao3"],
["不抱佛腳","bu2bao4fo2jiao3"],
["不担担面","bu2dan4dan4mian4"],
["不拘一格","bu4ju1yi4ge2"],
["不拜把子","bu2bai4ba3zi5"],
["不括弧裡","bu2kuo4hu2li3"],
["不挎兜儿","bu2kua4dou1er5"],
["不挎兜兒","bu2kua4dou1er5"],
["不换挡杆","bu2huan4dang3gan3"],
["不换档杆","bu2huan4dang4gan3"],
["不掉价儿","bu2diao4jia4r5"],
["不控制杆","bu2kong4zhi4gan3"],
["不揣冒昧","bu4chuai3mao4mei4"],
["不摁钉儿","bu2en4ding1r5"],
["不擔擔麵","bu2dan4dan4mian4"],
["不放不下","bu2fang4bu5xia4"],
["不故事片","bu2gu4shi5pian1"],
["不敗家子","bu2bai4jia1zi3"],
["不敢自专","bu4gan3zi4zhuan1"],
["不敢自專","bu4gan3zi4zhuan1"],
["不斗趣儿","bu2dou4qu4r5"],
["不料豆儿","bu2liao4dou4r5"],
["不是不是","bu2shi4bu5shi4"],
["不是味儿","bu2shi4wei4r5"],
["不晕高儿","bu2yun4gao1r5"],
["不暈高兒","bu2yun4gao1r5"],
["不暗地里","bu2an4di4li5"],
["不暗记儿","bu2an4ji4r5"],
["不暗间儿","bu2an4jian1r5"],
["不替班儿","bu2ti4ban1r5"],
["不替角儿","bu2ti4jue2r5"],
["不木棉花","bu2mu4mian2hua1"],
["不未婚夫","bu2wei4hun1fu1"],
["不未成冠","bu2wei4cheng2guan1"],
["不棒棒糖","bu2bang4bang5tang2"],
["不樂學者","bu2yue4xue2zhe3"],
["不欢而散","bu4huan1er2san4"],
["不歡而散","bu4huan1er2san4"],
["不歷史上","bu2li4shi3shang5"],
["不气头上","bu2qi4tou2shang5"],
["不氣頭上","bu2qi4tou2shang5"],
["不求甚解","bu4qiu2shen4jie3"],
["不汇出行","bu2hui4chu1hang2"],
["不汉堡包","bu2han4bao3bao1"],
["不汉白玉","bu2han4bai2yu4"],
["不法分子","bu4fa3fen4zi3"],
["不混名儿","bu2hun4ming2r5"],
["不混混儿","bu2hun4hun4r5"],
["不混血兒","bu2hun4xue4er2"],
["不漢堡包","bu2han4bao3bao1"],
["不漢白玉","bu2han4bai2yu4"],
["不灌米汤","bu2guan4mi3tang5"],
["不灌米湯","bu2guan4mi3tang5"],
["不為人知","bu4wei2ren2zhi1"],
["不為已甚","bu4wei2yi3shen4"],
["不热乎乎","bu2re4hu1hu1"],
["不熱乎乎","bu2re4hu1hu1"],
["不父母亲","bu2fu4mu3qin1"],
["不父母親","bu2fu4mu3qin1"],
["不特別是","bu2te4bie2shi5"],
["不特别是","bu2te4bie2shi5"],
["不犯不着","bu2fan4bu5zhao2"],
["不犯不著","bu2fan4bu5zhao2"],
["不犯得上","bu2fan4de5shang4"],
["不犯得着","bu2fan4de5zhao2"],
["不犯得著","bu2fan4de5zhao2"],
["不玉米粉","bu2yu4mi5fen3"],
["不甚至於","bu2shen4zhi4yu2"],
["不甚高頻","bu2shen4gao1pin2"],
["不甚高频","bu2shen4gao1pin2"],
["不用不了","bu2yong4bu5liao3"],
["不用不着","bu2yong4bu5zhao2"],
["不用不著","bu2yong4bu5zhao2"],
["不用出來","bu2yong4chu5lai5"],
["不用出来","bu2yong4chu5lai5"],
["不用得着","bu2yong4de5zhao2"],
["不用得著","bu2yong4de5zhao2"],
["不电线杆","bu2dian4xian4gan1"],
["不电荷量","bu2dian4he2liang4"],
["不畜产品","bu2xu4chan3pin3"],
["不畜產品","bu2xu4chan3pin3"],
["不當得利","bu4dang1de2li4"],
["不疟原虫","bu2nve4yuan2chong2"],
["不病包儿","bu2bing4bao1r5"],
["不症候群","bu2zheng4hou4qun2"],
["不瘧原蟲","bu2nve4yuan2chong2"],
["不癥候群","bu2zheng4hou4qun2"],
["不目的地","bu2mu4di4di4"],
["不相位差","bu2xiang4wei4cha1"],
["不相命者","bu2xiang4ming4zhe3"],
["不相平面","bu2xiang4ping2mian4"],
["不相空間","bu2xiang4kong1jian1"],
["不相空间","bu2xiang4kong1jian1"],
["不省人事","bu4xing3ren2shi4"],
["不看上去","bu2kan4shang5qu5"],
["不看不中","bu2kan4bu5zhong4"],
["不看不出","bu2kan4bu5chu1"],
["不看不惯","bu2kan4bu5guan4"],
["不看不慣","bu2kan4bu5guan4"],
["不看不懂","bu2kan4bu5dong3"],
["不看不清","bu2kan4bu5qing1"],
["不看不見","bu2kan4bu5jian4"],
["不看不见","bu2kan4bu5jian4"],
["不看不起","bu2kan4bu5qi3"],
["不看得中","bu2kan4de5zhong4"],
["不看起來","bu2kan4qi5lai5"],
["不看起来","bu2kan4qi5lai5"],
["不着边际","bu4zhuo2bian1ji4"],
["不睡懒觉","bu2shui4lan3jiao4"],
["不睡懶覺","bu2shui4lan3jiao4"],
["不瞭望台","bu2liao4wang4tai2"],
["不瞭望臺","bu2liao4wang4tai2"],
["不知去向","bu4zhi1qu4xiang5"],
["不矿务局","bu2kuang4wu4ju2"],
["不碰碰車","bu2peng4peng5che1"],
["不碰碰车","bu2peng4peng5che1"],
["不磨不开","bu2mo4bu5kai1"],
["不磨不開","bu2mo4bu5kai1"],
["不磨得开","bu2mo4de5kai1"],
["不磨得開","bu2mo4de5kai1"],
["不磨豆腐","bu2mo4dou4fu5"],
["不礦務局","bu2kuang4wu4ju2"],
["不禁制令","bu2jin4zhi4ling4"],
["不秘书长","bu2mi4shu1zhang3"],
["不秘書長","bu2mi4shu1zhang3"],
["不窍门儿","bu2qiao4men2r5"],
["不笑脸儿","bu2xiao4lian3r5"],
["不策源地","bu2ce4yuan2di4"],
["不算不得","bu2suan4bu5de5"],
["不紀傳體","bu2ji4zhuan4ti3"],
["不綠油油","bu2lv4you1you1"],
["不纪传体","bu2ji4zhuan4ti3"],
["不纳闷儿","bu2na4men4r5"],
["不绿油油","bu2lv4you1you1"],
["不置一詞","bu2zhi4yi4ci2"],
["不置一词","bu2zhi4yi4ci2"],
["不聚居地","bu2ju4ju1di4"],
["不背地風","bu2bei4di4feng1"],
["不背地风","bu2bei4di4feng1"],
["不背影儿","bu2bei4ying3r5"],
["不背影兒","bu2bei4ying3r5"],
["不背着手","bu2bei4zhe5shou3"],
["不背著手","bu2bei4zhe5shou3"],
["不胖乎乎","bu2pang4hu1hu1"],
["不自留地","bu2zi4liu2di4"],
["不臭子儿","bu2chou4zi3r5"],
["不臭子兒","bu2chou4zi3r5"],
["不興沖沖","bu2xing4chong1chong1"],
["不舍利子","bu2she4li4zi3"],
["不艾兹病","bu2ai4zi1bing4"],
["不艾茲病","bu2ai4zi1bing4"],
["不芥子气","bu2jie4zi3qi4"],
["不芥子氣","bu2jie4zi3qi4"],
["不药水儿","bu2yao4shui3r5"],
["不荳角儿","bu2dou4jiao3r5"],
["不菟丝子","bu2tu4si1zi3"],
["不菟絲子","bu2tu4si1zi3"],
["不著邊際","bu4zhuo2bian1ji4"],
["不蔓越桔","bu2man4yue4ju2"],
["不蔓越橘","bu2man4yue4ju2"],
["不藏紅花","bu2zang4hong2hua1"],
["不藏經洞","bu2zang4jing1dong4"],
["不藏红花","bu2zang4hong2hua1"],
["不藏经洞","bu2zang4jing1dong4"],
["不虎不拉","bu2hu4bu5la3"],
["不血友病","bu2xue4you3bing4"],
["不行兇者","bu2xing4xiong1zhe3"],
["不袖筒儿","bu2xiu4tong3r5"],
["不被誉为","bu2bei4yu4wei2"],
["不被譽為","bu2bei4yu4wei2"],
["不製鞋匠","bu2zhi4xie2jiang4"],
["不要不得","bu2yao4bu5de5"],
["不要不是","bu2yao4bu5shi4"],
["不要不然","bu2yao4bu5ran2"],
["不要不要","bu2yao4bu5yao4"],
["不要样儿","bu2yao4yang4r5"],
["不見不得","bu2jian4bu5de5"],
["不見經傳","bu2jian4jing1zhuan4"],
["不见不得","bu2jian4bu5de5"],
["不见经传","bu2jian4jing1zhuan4"],
["不触技曲","bu2chu4ji4qu3"],
["不觸技曲","bu2chu4ji4qu3"],
["不記不住","bu2ji4bu5zhu4"],
["不試一試","bu2shi4yi2shi4"],
["不試試看","bu2shi4shi5kan4"],
["不謀而得","bu4mou2er2de2"],
["不識一丁","bu4shi2yi4ding1"],
["不識大體","bu4shi2da4ti3"],
["不識好歹","bu4shi2hao3dai3"],
["不識抬舉","bu4shi2tai2ju5"],
["不識時務","bu4shi2shi2wu4"],
["不識時變","bu4shi2shi2bian4"],
["不識泰山","bu4shi2tai4shan1"],
["不識高低","bu4shi2gao1di1"],
["不變奏曲","bu2bian4zou4qu3"],
["不认人儿","bu2ren4ren2r5"],
["不记不住","bu2ji4bu5zhu4"],
["不识一丁","bu4shi2yi4ding1"],
["不识大体","bu4shi2da4ti3"],
["不识好歹","bu4shi2hao3dai3"],
["不识抬举","bu4shi2tai2ju5"],
["不识时务","bu4shi2shi2wu4"],
["不识时变","bu4shi2shi2bian4"],
["不识泰山","bu4shi2tai4shan1"],
["不识高低","bu4shi2gao1di1"],
["不试一试","bu2shi4yi2shi4"],
["不试试看","bu2shi4shi5kan4"],
["不话茬儿","bu2hua4cha2r5"],
["不谋而得","bu4mou2er2de2"],
["不負重擔","bu2fu4zhong4dan1"],
["不費米子","bu2fei4mi3zi3"],
["不賦格曲","bu2fu4ge2qu3"],
["不贊一詞","bu2zan4yi4ci2"],
["不贝壳儿","bu2bei4ke2r5"],
["不负重担","bu2fu4zhong4dan1"],
["不败家子","bu2bai4jia1zi3"],
["不费劲儿","bu2fei4jin4r5"],
["不费米子","bu2fei4mi3zi3"],
["不赋格曲","bu2fu4ge2qu3"],
["不赞一词","bu2zan4yi4ci2"],
["不赤睛魚","bu2chi4jing1yu2"],
["不赤睛鱼","bu2chi4jing1yu2"],
["不足为奇","bu4zu2wei2qi2"],
["不足为训","bu4zu2wei2xun4"],
["不足為奇","bu4zu2wei2qi2"],
["不足為訓","bu4zu2wei2xun4"],
["不跪下來","bu2gui4xia4lai5"],
["不跪下来","bu2gui4xia4lai5"],
["不蹦高儿","bu2beng4gao1r5"],
["不轉一趟","bu2zhuan4yi2tang4"],
["不轉字鎖","bu2zhuan4zi4suo3"],
["不转一趟","bu2zhuan4yi2tang4"],
["不转字锁","bu2zhuan4zi4suo3"],
["不转轴儿","bu2zhuan4zhou2r5"],
["不转铃儿","bu2zhuan4ling2r5"],
["不辦不到","bu2ban4bu5dao4"],
["不辩护士","bu2bian4hu4shi4"],
["不辯護士","bu2bian4hu4shi4"],
["不过不去","bu2guo4bu5qu4"],
["不这个月","bu2zhei4ge4yue4"],
["不这边儿","bu2zhe4bian1r5"],
["不这阵儿","bu2zhe4zhen4r5"],
["不进行曲","bu2jin4xing2qu3"],
["不逗笑儿","bu2dou4xiao4r5"],
["不逗趣儿","bu2dou4qu4r5"],
["不這個月","bu2zhei4ge4yue4"],
["不速調管","bu2su4tiao2guan3"],
["不速调管","bu2su4tiao2guan3"],
["不進行曲","bu2jin4xing2qu3"],
["不過不去","bu2guo4bu5qu4"],
["不配得上","bu2pei4de5shang4"],
["不釘書針","bu2ding4shu1zhen1"],
["不錮漏鍋","bu2gu4lou5guo1"],
["不钉书针","bu2ding4shu1zhen1"],
["不锢漏锅","bu2gu4lou5guo1"],
["不闹笑话","bu2nao4xiao4hua4"],
["不雀形目","bu2que4xing1mu4"],
["不電荷量","bu2dian4he2liang4"],
["不露一手","bu2lou4yi4shou3"],
["不露馅儿","bu2lou4xian4r5"],
["不露馬腳","bu2lou4ma3jiao3"],
["不露马脚","bu2lou4ma3jiao3"],
["不静一静","bu2jing4yi2jing4"],
["不静悄悄","bu2jing4qiao1qiao1"],
["不靜一靜","bu2jing4yi2jing4"],
["不靜悄悄","bu2jing4qiao1qiao1"],
["不靠不住","bu2kao4bu5zhu4"],
["不面条儿","bu2mian4tiao2r5"],
["不顧不得","bu2gu4bu5de5"],
["不顺嘴儿","bu2shun4zui3r5"],
["不顺手儿","bu2shun4shou3r5"],
["不顾不得","bu2gu4bu5de5"],
["不鬧笑話","bu2nao4xiao4hua4"],
["不鳳仙花","bu2feng4xian1hua1"],
["不万无一失","bu2wan4wu2yi4shi1"],
["不下个星期","bu2xia4ge4xing1qi1"],
["不下個星期","bu2xia4ge4xing1qi1"],
["不下面請看","bu2xia4mian4qing3kan4"],
["不下面请看","bu2xia4mian4qing3kan4"],
["不串亲访友","bu2chuan4qin1fang3you3"],
["不串親訪友","bu2chuan4qin1fang3you3"],
["不事危累卵","bu2shi4wei1lei3luan3"],
["不互为因果","bu2hu4wei2yin1guo3"],
["不互為因果","bu2hu4wei2yin1guo3"],
["不付之一叹","bu2fu4zhi1yi2tan4"],
["不付之一嘆","bu2fu4zhi1yi2tan4"],
["不付之一歎","bu2fu4zhi1yi2tan4"],
["不付之一炬","bu2fu4zhi1yi2ju4"],
["不付之一笑","bu2fu4zhi1yi2xiao4"],
["不令人发指","bu2ling4ren2fa4zhi3"],
["不众口一词","bu2zhong4kou3yi4ci2"],
["不众矢之的","bu2zhong4shi3zhi1di4"],
["不佣人领班","bu2yong4ren5ling3ban1"],
["不倒打一耙","bu2dao4da3yi4pa2"],
["不倒果为因","bu2dao4guo3wei2yin1"],
["不倒果為因","bu2dao4guo3wei2yin1"],
["不倒背手儿","bu2dao4bei4shou3r5"],
["不借花献佛","bu2jie4hua1xian4fo2"],
["不借花獻佛","bu2jie4hua1xian4fo2"],
["不傭人領班","bu2yong4ren5ling3ban1"],
["不入土为安","bu2ru4tu3wei2an1"],
["不入土為安","bu2ru4tu3wei2an1"],
["不內懮外患","bu2nei4you1wai4huan4"],
["不兴高采烈","bu2xing4gao1cai3lie4"],
["不内懮外患","bu2nei4you1wai4huan4"],
["不冒冒失失","bu2mao4mao5shi1shi1"],
["不划一不二","bu2hua4yi2bu2er4"],
["不剃发留辫","bu2ti4fa4liu2bian4"],
["不剑拔弩张","bu2jian4ba2nu3zhang1"],
["不劃一不二","bu2hua4yi2bu2er4"],
["不劃圓防守","bu2hua4yuan2fang2shou3"],
["不劍拔弩張","bu2jian4ba2nu3zhang1"],
["不助紂為虐","bu2zhu4zhou4wei2nve4"],
["不助纣为虐","bu2zhu4zhou4wei2nve4"],
["不化敌为友","bu2hua4di2wei2you3"],
["不化整为零","bu2hua4zheng3wei2ling2"],
["不化整為零","bu2hua4zheng3wei2ling2"],
["不化敵為友","bu2hua4di2wei2you3"],
["不化险为夷","bu2hua4xian3wei2yi2"],
["不化險為夷","bu2hua4xian3wei2yi2"],
["不半半拉拉","bu2ban4ban5la1la1"],
["不半夜三更","bu2ban4ye4san1geng1"],
["不半开门儿","bu2ban4kai1men2r5"],
["不厚养薄葬","bu2hou4yang3bo2zang4"],
["不厚養薄葬","bu2hou4yang3bo2zang4"],
["不发指眦裂","bu2fa4zhi3zi4lie4"],
["不受命於天","bu2shou4ming4yu2tian1"],
["不变征之声","bu2bian4zhi3zhi1sheng1"],
["不右派分子","bu2you4pai4fen4zi3"],
["不叹为观止","bu2tan4wei2guan1zhi3"],
["不各執一詞","bu2ge4zhi2yi4ci2"],
["不各奔前程","bu2ge4ben4qian2cheng2"],
["不各得其所","bu2ge4de2qi2suo3"],
["不各执一词","bu2ge4zhi2yi4ci2"],
["不各有所好","bu2ge4you3suo3hao4"],
["不各盡所能","bu2ge4jin4suo3neng2"],
["不各行各业","bu2ge4hang2ge4ye4"],
["不各行各業","bu2ge4hang2ge4ye4"],
["不吊儿郎当","bu2diao4r5lang2dang1"],
["不唾手可得","bu2tuo4shou3ke3de2"],
["不唾面自乾","bu2tuo4mian4zi4gan1"],
["不喪失殆盡","bu2sang4shi1dai4jin4"],
["不嘆為觀止","bu2tan4wei2guan1zhi3"],
["不四个小时","bu2si4ge4xiao3shi2"],
["不四個小時","bu2si4ge4xiao3shi2"],
["不四季豆腐","bu2si4ji4dou4fu3"],
["不四面楚歌","bu2si4mian4chu3ge1"],
["不圣经贤传","bu2sheng4jing1xian2zhuan4"],
["不地久天長","bu2di4jiu3tian1chang2"],
["不地久天长","bu2di4jiu3tian1chang2"],
["不地塞米松","bu2di4sai1mi3song1"],
["不地心吸力","bu2di4xin1xi1li4"],
["不地心引力","bu2di4xin1yin3li4"],
["不地方主义","bu2di4fang1zhu3yi4"],
["不地方主義","bu2di4fang1zhu3yi4"],
["不地方政府","bu2di4fang1zheng4fu3"],
["不地方法院","bu2di4fang1fa3yuan4"],
["不地方自治","bu2di4fang1zi4zhi4"],
["不地方选举","bu2di4fang1xuan2ju3"],
["不地方選舉","bu2di4fang1xuan2ju3"],
["不块儿八毛","bu2kuai4r5ba1mao2"],
["不壽數已盡","bu2shou4shu5yi3jin4"],
["不壽終正寢","bu2shou4zhong1zheng4qin3"],
["不外甥女婿","bu2wai4sheng1nv3xu4"],
["不外甥媳妇","bu2wai4sheng1xi2fu5"],
["不外甥媳婦","bu2wai4sheng1xi2fu5"],
["不夙兴夜寐","bu2su4xing1ye4mei4"],
["不夙興夜寐","bu2su4xing1ye4mei4"],
["不大一会儿","bu2da4yi4hui3r5"],
["不大一會兒","bu2da4yi4hui3r5"],
["不大中学生","bu2da4zhong1xue2sheng5"],
["不大中學生","bu2da4zhong1xue2sheng5"],
["不大可不必","bu2da4ke3bu2bi4"],
["不大吹大擂","bu2da4chui1da4lei2"],
["不大有可为","bu2da4you3ke3wei2"],
["不大有可為","bu2da4you3ke3wei2"],
["不太阳黑子","bu2tai4yang2hei1zi3"],
["不太陽黑子","bu2tai4yang2hei1zi3"],
["不奉承討好","bu2feng4cheng2tao3hao3"],
["不奉承讨好","bu2feng4cheng2tao3hao3"],
["不好吃懒做","bu2hao4chi1lan3zuo4"],
["不好吃懶做","bu2hao4chi1lan3zuo4"],
["不妄自菲薄","bu2wang4zi4fei3bo2"],
["不嫁禍於人","bu2jia4huo4yu2ren2"],
["不字裡行間","bu2zi4li3hang2jian1"],
["不宁死不屈","bu2ning4si3bu4qu1"],
["不宁缺毋滥","bu2ning4que1wu2lan4"],
["不定过去式","bu2ding4guo4qu4shi4"],
["不定過去式","bu2ding4guo4qu4shi4"],
["不密密麻麻","bu2mi4mi5ma2ma2"],
["不寓意深長","bu2yu4yi4shen1zhang3"],
["不寓意深长","bu2yu4yi4shen1zhang3"],
["不寧死不屈","bu2ning4si3bu4qu1"],
["不寧缺毋濫","bu2ning4que1wu2lan4"],
["不寿终正寝","bu2shou4zhong1zheng4qin3"],
["不尽力而为","bu2jin4li4er2wei2"],
["不尽欢而散","bu2jin4huan1er2san4"],
["不差不离儿","bu2cha4bu5li2r5"],
["不应县木塔","bu2ying4xian4mu4ta3"],
["不应运而生","bu2ying4yun4er2sheng1"],
["不彈盡援絕","bu2dan4jin4yuan2jue2"],
["不彈盡糧絕","bu2dan4jin4liang2jue2"],
["不得烟儿抽","bu4de2yan1r5chou1"],
["不必不可少","bu2bi4bu5ke3shao3"],
["不怒发冲冠","bu2nu4fa4chong1guan1"],
["不怒髮衝冠","bu2nu4fa4chong1guan1"],
["不怪声怪气","bu2guai4sheng1guai4qi4"],
["不怪模怪样","bu2guai4mu2guai4yang4"],
["不怪模怪樣","bu2guai4mu2guai4yang4"],
["不怪聲怪氣","bu2guai4sheng1guai4qi4"],
["不怪裡怪氣","bu2guai4li5guai4qi4"],
["不怪里怪气","bu2guai4li5guai4qi4"],
["不恨海难填","bu2hen4hai3nan2tian2"],
["不恨海難填","bu2hen4hai3nan2tian2"],
["不恰到好处","bu2qia4dao4hao3chu4"],
["不恰到好處","bu2qia4dao4hao3chu4"],
["不恶恶实实","bu2e4e5shi1shi1"],
["不恶意中伤","bu2e4yi4zhong1shang1"],
["不惡惡實實","bu2e4e5shi1shi1"],
["不惡意中傷","bu2e4yi4zhong1shang1"],
["不意猶未盡","bu2yi4you2wei4jin4"],
["不愛人如己","bu2ai4ren2ru2ji3"],
["不愛樂樂團","bu2ai4yue4yue4tuan2"],
["不愛民如子","bu2ai4min2ru2zi3"],
["不愧悔无地","bu2kui4hui3wu2di4"],
["不愧悔無地","bu2kui4hui3wu2di4"],
["不慢慢吞吞","bu2man4man5tun1tun1"],
["不應縣木塔","bu2ying4xian4mu4ta3"],
["不應運而生","bu2ying4yun4er2sheng1"],
["不扼襟控咽","bu2e4jin1kong4yan1"],
["不据为己有","bu2ju4wei2ji3you3"],
["不據為己有","bu2ju4wei2ji3you3"],
["不放在眼裡","bu2fang4zai5yan3li3"],
["不放在眼里","bu2fang4zai5yan3li3"],
["不故地重游","bu2gu4di4chong2you2"],
["不故地重遊","bu2gu4di4chong2you2"],
["不敗子回頭","bu2bai4zi3hui2tou2"],
["不敝帚千金","bu2bi4zhou3qian1jin1"],
["不敝帚自珍","bu2bi4zhou3zi4zhen1"],
["不数理逻辑","bu2shu4li3luo2ji2"],
["不數理邏輯","bu2shu4li3luo2ji2"],
["不日月重光","bu2ri4yue4chong2guang1"],
["不日积月累","bu2ri4ji1yue4lei3"],
["不日積月累","bu2ri4ji1yue4lei3"],
["不旧地重遊","bu2jiu4di4chong2you2"],
["不暮鼓晨鐘","bu2mu4gu3chen2zhong1"],
["不暮鼓晨钟","bu2mu4gu3chen2zhong1"],
["不暴虎冯河","bu2bao4hu3ping2he2"],
["不暴虎馮河","bu2bao4hu3ping2he2"],
["不最低限度","bu2zui4di1xian4du5"],
["不望子成龍","bu2wang4zi3cheng2long2"],
["不望子成龙","bu2wang4zi3cheng2long2"],
["不望而兴叹","bu2wang4er2xing1tan4"],
["不望而興嘆","bu2wang4er2xing1tan4"],
["不未雨綢繆","bu2wei4yu3chou2mou2"],
["不未雨绸缪","bu2wei4yu3chou2mou2"],
["不杜秋娘歌","bu2du4qiu1niang2ge1"],
["不樂於助人","bu2le4yu2zhu4ren2"],
["不正儿八经","bu2zheng4r5ba1jing1"],
["不正当防卫","bu2zheng4dang4fang2wei4"],
["不正當防衛","bu2zheng4dang4fang2wei4"],
["不正經八百","bu2zheng4jing5ba1bai3"],
["不正经八百","bu2zheng4jing5ba1bai3"],
["不步步为营","bu2bu4bu4wei2ying2"],
["不步步為營","bu2bu4bu4wei2ying2"],
["不气不忿儿","bu2qi4bu5fen4r5"],
["不气冲牛斗","bu2qi4chong1niu2dou3"],
["不气贯长虹","bu2qi4guan4chang2hong2"],
["不氣不忿兒","bu2qi4bu5fen4r5"],
["不氣沖牛斗","bu2qi4chong1niu2dou3"],
["不氣貫長虹","bu2qi4guan4chang2hong2"],
["不沃尔夫奖","bu2wo4er3fu1jiang3"],
["不沃爾夫獎","bu2wo4er3fu1jiang3"],
["不沒齒不忘","bu2mo4chi3bu2wang4"],
["不沒齒難忘","bu2mo4chi3nan2wang4"],
["不没齿不忘","bu2mo4chi3bu2wang4"],
["不没齿难忘","bu2mo4chi3nan2wang4"],
["不洛阳纸贵","bu2luo4yang2zhi3gui4"],
["不洛陽紙貴","bu2luo4yang2zhi3gui4"],
["不测地曲率","bu2ce4di4qu1lv4"],
["不浩浩荡荡","bu2hao4hao5dang4dang4"],
["不浩浩蕩蕩","bu2hao4hao5dang4dang4"],
["不淡泊寡味","bu2dan4bo2gua3wei4"],
["不測地曲率","bu2ce4di4qu1lv4"],
["不燕雀乌鹊","bu2yan4que4wu1que4"],
["不燕雀处堂","bu2yan4que4chu3tang2"],
["不燕雀烏鵲","bu2yan4que4wu1que4"],
["不燕雀處堂","bu2yan4que4chu3tang2"],
["不爆冷门儿","bu2bao4leng3men2r5"],
["不爱乐乐团","bu2ai4yue4yue4tuan2"],
["不爱人如己","bu2ai4ren2ru2ji3"],
["不爱民如子","bu2ai4min2ru2zi3"],
["不率兽食人","bu2shuai4shou4shi2ren2"],
["不率尔操觚","bu2shuai4er3cao1gu1"],
["不率爾操觚","bu2shuai4er3cao1gu1"],
["不率獸食人","bu2shuai4shou4shi2ren2"],
["不率由旧章","bu2shuai4you2jiu4zhang1"],
["不率由舊章","bu2shuai4you2jiu4zhang1"],
["不甚嚣尘上","bu2shen4xiao1chen2shang4"],
["不甚囂塵上","bu2shen4xiao1chen2shang4"],
["不甚感詫異","bu2shen4gan3cha4yi4"],
["不甚感诧异","bu2shen4gan3cha4yi4"],
["不画荻教子","bu2hua4di2jiao1zi3"],
["不略識之無","bu2lve4shi2zhi1wu2"],
["不略识之无","bu2lve4shi2zhi1wu2"],
["不畫荻教子","bu2hua4di2jiao1zi3"],
["不痛痛快快","bu2tong4tong5kuai4kuai4"],
["不盡力而為","bu2jin4li4er2wei2"],
["不盡善盡美","bu2jin4shan4jin4mei3"],
["不盡歡而散","bu2jin4huan1er2san4"],
["不目不識丁","bu2mu4bu4shi2ding1"],
["不目不识丁","bu2mu4bu4shi2ding1"],
["不目不轉睛","bu2mu4bu4zhuan3jing1"],
["不目不转睛","bu2mu4bu4zhuan3jing1"],
["不目挑心招","bu2mu4tiao3xin1zhao1"],
["不相体裁衣","bu2xiang4ti3cai2yi1"],
["不相夫教子","bu2xiang4fu1jiao4zi3"],
["不相體裁衣","bu2xiang4ti3cai2yi1"],
["不看不順眼","bu2kan4bu5shun4yan3"],
["不看不顺眼","bu2kan4bu5shun4yan3"],
["不眾口一詞","bu2zhong4kou3yi4ci2"],
["不眾矢之的","bu2zhong4shi3zhi1di4"],
["不破涕为笑","bu2po4ti4wei2xiao4"],
["不破涕為笑","bu2po4ti4wei2xiao4"],
["不祸不单行","bu2huo4bu4dan1xing2"],
["不禁慾主义","bu2jin4yu4zhu3yi4"],
["不禁慾主義","bu2jin4yu4zhu3yi4"],
["不禍不單行","bu2huo4bu4dan1xing2"],
["不空成就佛","bu4kong1cheng2jiu4fo2"],
["不笑裡藏刀","bu2xiao4li3cang2dao1"],
["不类地行星","bu2lei4di4xing2xing1"],
["不絮絮叨叨","bu2xu4xu5dao1dao1"],
["不綠女紅男","bu2lv4nv3hong2nan2"],
["不綠林好漢","bu2lu4lin2hao3han4"],
["不绿女红男","bu2lv4nv3hong2nan2"],
["不绿林好汉","bu2lu4lin2hao3han4"],
["不聖經賢傳","bu2sheng4jing1xian2zhuan4"],
["不背水一战","bu2bei4shui3yi2zhan4"],
["不背水一戰","bu2bei4shui3yi2zhan4"],
["不能贊一辭","bu4neng2zan4yi4ci2"],
["不能赞一辞","bu4neng2zan4yi4ci2"],
["不自作聪明","bu2zi4zuo4cong1ming2"],
["不自作聰明","bu2zi4zuo4cong1ming2"],
["不自吹自擂","bu2zi4chui1zi4lei2"],
["不自由自在","bu2zi4you2zi4zai4"],
["不自繇自在","bu2zi4you2zi4zai5"],
["不自視甚高","bu2zi4shi4shen4gao1"],
["不自视甚高","bu2zi4shi4shen4gao1"],
["不臭名昭著","bu2chou4ming2zhao1zhu4"],
["不興高采烈","bu2xing4gao1cai3lie4"],
["不舊地重遊","bu2jiu4di4chong2you2"],
["不舜日堯年","bu2shun4ri4yao2nian2"],
["不舜日尧年","bu2shun4ri4yao2nian2"],
["不艾扑西龙","bu2ai4pu1xi1long2"],
["不艾撲西龍","bu2ai4pu1xi1long2"],
["不艾滋病毒","bu2ai4zi1bing4du2"],
["不莫可指数","bu2mo4ke3zhi3shu3"],
["不莫可指數","bu2mo4ke3zhi3shu3"],
["不萨克斯风","bu2sa4ke4si1feng1"],
["不萬無一失","bu2wan4wu2yi4shi1"],
["不著书立说","bu2zhu4shu1li4shuo1"],
["不著称于世","bu2zhu4cheng1yu2shi4"],
["不著稱於世","bu2zhu4cheng1yu2shi4"],
["不蔓生植物","bu2man4sheng1zhi2wu4"],
["不薩克斯風","bu2sa4ke4si1feng1"],
["不藏茴香果","bu2zang4hui2xiang1guo3"],
["不血流漂杵","bu2xue4liu2piao1chu3"],
["不血濃於水","bu2xue4nong2yu2shui3"],
["不血跡斑斑","bu2xue4ji1ban1ban1"],
["不血迹斑斑","bu2xue4ji1ban1ban1"],
["不衣錦榮歸","bu2yi4jin3rong2gui1"],
["不衣錦還鄉","bu2yi4jin3huan2xiang1"],
["不衣锦荣归","bu2yi4jin3rong2gui1"],
["不衣锦还乡","bu2yi4jin3huan2xiang1"],
["不見微知著","bu2jian4wei1zhi1zhu4"],
["不視同兒戲","bu2shi4tong2er2xi4"],
["不視微知著","bu2shi4wei1zhi1zhuo2"],
["不见微知著","bu2jian4wei1zhi1zhu4"],
["不视微知着","bu2shi4wei1zhi1zhuo2"],
["不訊框傳送","bu2xun4kuang4chuan2song4"],
["不設身處地","bu2she4shen1chu3di4"],
["不誓死不降","bu2shi4si3bu4xiang2"],
["不认死扣儿","bu2ren4si3kou4r5"],
["不认死理儿","bu2ren4si3li3r5"],
["不讯框传送","bu2xun4kuang4chuan2song4"],
["不设身处地","bu2she4shen1chu3di4"],
["不負債累累","bu2fu4zhai4lei3lei3"],
["不負擔不起","bu2fu4dan1bu4qi3"],
["不費盡心思","bu2fei4jin4xin1si5"],
["不负债累累","bu2fu4zhai4lei3lei3"],
["不负担不起","bu2fu4dan1bu4qi3"],
["不败子回头","bu2bai4zi3hui2tou2"],
["不蹦蹦跳跳","bu2beng4beng5tiao4tiao4"],
["不轉渾天儀","bu2zhuan4hun2tian1yi2"],
["不转浑天仪","bu2zhuan4hun2tian1yi2"],
["不过一会儿","bu2guo4yi4hui3r5"],
["不过去分词","bu2guo4qu4fen1ci2"],
["不这早晚儿","bu2zhe4zao3wan3r5"],
["不退耕还林","bu2tui4geng1huan2lin2"],
["不退耕還林","bu2tui4geng1huan2lin2"],
["不退避三舍","bu2tui4bi4san1she4"],
["不逆行倒施","bu2ni4xing2dao3shi1"],
["不過一會兒","bu2guo4yi4hui3r5"],
["不過去分詞","bu2guo4qu4fen1ci2"],
["不重於泰山","bu2zhong4yu2tai4shan1"],
["不量入为出","bu2liang4ru4wei2chu1"],
["不量入為出","bu2liang4ru4wei2chu1"],
["不鑽頭卡盤","bu2zuan4tou2qia3pan2"],
["不钻头卡盘","bu2zuan4tou2qia3pan2"],
["不閉目塞聽","bu2bi4mu4se4ting1"],
["不闭目塞听","bu2bi4mu4se4ting1"],
["不霧裡看花","bu2wu4li3kan4hua1"],
["不露齒而笑","bu2lu4chi3er2xiao4"],
["不露齿而笑","bu2lu4chi3er2xiao4"],
["不靖难之役","bu2jing4nan4zhi1yi4"],
["不靖難之役","bu2jing4nan4zhi1yi4"],
["不面伏于地","bu2mian4fu2yu2di4"],
["不預備知識","bu2yu4bei4zhi1shi2"],
["不類地行星","bu2lei4di4xing2xing1"],
["不预备知识","bu2yu4bei4zhi1shi2"],
["不二一添作五","bu2er4yi4tian1zuo4wu3"],
["不二十四節氣","bu2er4shi2si4jie2qi4"],
["不二十四节气","bu2er4shi2si4jie2qi4"],
["不到那个时候","bu2dao4na4ge4shi2hou4"],
["不到那個時候","bu2dao4na4ge4shi2hou4"],
["不化学剂量计","bu2hua4xue2ji4liang4ji4"],
["不化學劑量計","bu2hua4xue2ji4liang4ji4"],
["不地对空导弹","bu2di4dui4kong1dao3dan4"],
["不地對空導彈","bu2di4dui4kong1dao3dan4"],
["不壽保險公司","bu2shou4bao3xian3gong1si1"],
["不大洋型地殻","bu2da4yang2xing1di4qiao4"],
["不客客气气气","bu2ke4ke5qi4qi4qi4"],
["不客客氣氣氣","bu2ke4ke5qi4qi4qi4"],
["不寿保险公司","bu2shou4bao3xian3gong1si1"],
["不愿意不愿意","bu2yuan4yi5bu2yuan4yi4"],
["不战略核力量","bu2zhan4lve4he2li4liang4"],
["不戰略核力量","bu2zhan4lve4he2li4liang4"],
["不探头探脑儿","bu2tan4tou2tan4nao3r5"],
["不数码照相机","bu2shu4ma3zhao4xiang1ji1"],
["不數碼照相機","bu2shu4ma3zhao4xiang1ji1"],
["不稅捐稽徵處","bu2shui4juan1ji1zheng1chu4"],
["不税捐稽征处","bu2shui4juan1ji1zheng1chu4"],
["不豆腐渣工程","bu2dou4fu3zha1gong1cheng2"],
["不費一兵一卒","bu2fei4yi4bing1yi4zu2"],
["不费一兵一卒","bu2fei4yi4bing1yi4zu2"],
["不願意不願意","bu2yuan4yi5bu2yuan4yi4"],
["不可一日无此君","bu4ke3yi2ri4wu2ci3jun1"],
["不可一日無此君","bu4ke3yi2ri4wu2ci3jun1"],
["不定治了治不了","bu2ding4zhi4liao3zhi4bu5liao3"],
["不消一会儿工夫","bu4xiao1yi2hui4r5gong1fu5"],
["不消一會兒工夫","bu4xiao1yi2hui4r5gong1fu5"]
],
"与":[
["与会","yu4hui4"],
["与时俱进","yu3shi2ju1jin4"]
],
"丑":[
["丑相","chou3xiang4"],
["丑诋","chou3di3"]
],
"专":[
["专好","zhuan1hao4"],
["专有","zhuan1you3"],
["专款","zhuan1kuan3"],
["专管","zhuan1guan3"],
["专著","zhuan1zhu4"],
["专访","zhuan1fang3"],
["专辑","zhuan1ji2"],
["专一性","zhuan1yi2xing4"],
["专心一志","zhuan1xin1yi2zhi4"]
],
"且":[
["且看","qie3kan1"],
["且得不了","qie3de2bu5liao3"]
],
"世":[
["世行","shi4hang2"],
["世界文化遗产地","shi4jie4wen2hua4yi2chan3di4"],
["世界文化遺產地","shi4jie4wen2hua4yi2chan3di4"]
],
"丘":[
["丘北","qiu1bei3"],
["丘疹","qiu1zhen3"],
["丘脑","qiu1nao3"],
["丘腦","qiu1nao3"]
],
"丙":[
["丙午","bing3wu3"],
["丙子","bing3zi3"],
["丙等","bing3deng3"]
],
"业":[
["业主","ye4zhu3"],
["业务","ye4wu4"],
["业已","ye4yi3"],
["业海","ye4hai3"],
["业绩","ye4ji4"]
],
"东":[
["东北","dong1bei3"],
["东家","dong1jia5"],
["东海","dong1hai3"],
["东莞","dong1wan3"],
["东西","dong1xi5"],
["东边","dong1bian5"],
["东阿","dong1e1"],
["东面","dong1mian5"],
["东西周","dong1xi1zhou1"],
["东西德","dong1xi1de2"],
["东西方","dong1xi1fang1"],
["东边儿","dong1bian1r5"],
["东倒西歪","dong1dao3xi1wai1"],
["东巴文化","dong1ba1wen2hua4"],
["东西半球","dong1xi1ban4qiu2"],
["东西南北","dong1xi1nan2bei3"]
],
"丝":[
["丝柏","si1bo2"],
["丝缕","si1lv3"],
["丝雨","si1yu3"]
],
"丞":[
["丞相","cheng2xiang4"]
],
"丟":[
["丟珥","diu1er3"],
["丟臉","diu1lian3"],
["丟醜","diu1chou3"],
["丟不了","diu1bu5liao3"],
["丟不開手","diu1bu5kai1shou3"]
],
"丢":[
["丢丑","diu1chou3"],
["丢珥","diu1er3"],
["丢脸","diu1lian3"],
["丢不了","diu1bu5liao3"],
["丢不开手","diu1bu5kai1shou3"]
],
"两":[
["两只","liang3zhi1"],
["两广","liang3guang3"],
["两手","liang3shou3"],
["两百","liang3bai3"],
["两眼","liang3yan3"],
["两者","liang3zhe3"],
["两腿","liang3tui3"],
["两定一奖","liang3ding4yi4jiang3"],
["两得其便","liang3de2qi2bian4"],
["两手一摊","liang3shou3yi4tan1"],
["两报一刊","liang3bao4yi4kan1"],
["两饱一倒","liang3bao3yi4dao3"],
["两个或两个以上","liang3ge4huo4liang3ge4yi3shang4"]
],
"严":[
["严守","yan2shou3"],
["严岛","yan2dao3"],
["严紧","yan2jin3"],
["严谨","yan2jin3"]
],
"並":[
["並且","bing4qie3"],
["並把","bing4ba3"],
["並舉","bing4ju3"]
],
"丧":[
["丧事","sang1shi4"],
["丧仪","sang1yi2"],
["丧假","sang1jia4"],
["丧偶","sang4ou3"],
["丧夫","sang4fu1"],
["丧服","sang1fu2"],
["丧棒","sang1bang4"],
["丧气","sang4qi5"],
["丧礼","sang1li3"],
["丧胆","sang4dan3"],
["丧荒","sang1huang1"],
["丧葬","sang1zang4"],
["丧钟","sang1zhong1"],
["丧气话","sang4qi4hua4"],
["丧气鬼","sang4qi4gui3"],
["丧门星","sang1men2xing1"],
["丧门神","sang1men2shen2"]
],
"个":[
["个个","ge4ge4"],
["个中","ge4zhong1"],
["个人","ge4ren2"],
["个位","ge4wei4"],
["个体","ge4ti3"],
["个例","ge4li4"],
["个儿","ge4r5"],
["个别","ge4bie2"],
["个头","ge4tou2"],
["个子","ge4zi5"],
["个展","ge4zhan3"],
["个性","ge4xing4"],
["个把","ge4ba3"],
["个旧","ge4jiu4"],
["个案","ge4an4"],
["个股","ge4gu3"],
["个头儿","ge4tou2r5"]
],
"丫":[
["丫头","ya1tou5"],
["丫頭","ya1tou5"],
["丫鬟","ya1huan5"],
["丫巴儿","ya1ba1r5"],
["丫巴兒","ya1ba1r5"]
],
"中":[
["中举","zhong4ju3"],
["中产","zhong1chan3"],
["中伤","zhong4shang1"],
["中保","zhong1bao3"],
["中傷","zhong4shang1"],
["中兴","zhong1xing1"],
["中午","zhong1wu3"],
["中古","zhong1gu3"],
["中吃","zhong4chi1"],
["中土","zhong1tu3"],
["中场","zhong1chang3"],
["中場","zhong1chang3"],
["中奖","zhong4jiang3"],
["中子","zhong1zi3"],
["中将","zhong1jiang4"],
["中將","zhong1jiang4"],
["中岛","zhong1dao3"],
["中島","zhong1dao3"],
["中巴","zhong1ba1"],
["中弹","zhong4dan4"],
["中彈","zhong4dan4"],
["中彩","zhong4cai3"],
["中悔","zhong1hui3"],
["中意","zhong4yi4"],
["中指","zhong1zhi3"],
["中暑","zhong4shu3"],
["中枪","zhong4qiang1"],
["中标","zhong4biao1"],
["中槍","zhong4qiang1"],
["中標","zhong4biao1"],
["中止","zhong1zhi3"],
["中毒","zhong4du2"],
["中油","zhong4you2"],
["中法","zhong1fa3"],
["中港","zhong1gang3"],
["中点","zhong1dian3"],
["中獎","zhong4jiang3"],
["中產","zhong1chan3"],
["中等","zhong1deng3"],
["中签","zhong4qian1"],
["中簽","zhong4qian1"],
["中美","zhong1mei3"],
["中耳","zhong1er3"],
["中肯","zhong4ken3"],
["中脊","zhong1ji3"],
["中興","zhong1xing1"],
["中舉","zhong4ju3"],
["中行","zhong1hang2"],
["中計","zhong4ji4"],
["中计","zhong4ji4"],
["中轉","zhong1zhuan3"],
["中转","zhong1zhuan3"],
["中选","zhong4xuan3"],
["中選","zhong4xuan3"],
["中邪","zhong4xie2"],
["中阮","zhong1ruan3"],
["中風","zhong4feng1"],
["中风","zhong4feng1"],
["中飽","zhong1bao3"],
["中饱","zhong1bao3"],
["中魔","zhong4mo2"],
["中點","zhong1dian3"],
["中不溜","zhong1bu5liu1"],
["中圈套","zhong4quan1tao4"],
["中埔乡","zhong1bu4xiang1"],
["中埔鄉","zhong1bu4xiang1"],
["中学生","zhong1xue2sheng1"],
["中學生","zhong1xue2sheng1"],
["中微子","zhong1wei1zi3"],
["中心矩","zhong1xin1ju3"],
["中洋脊","zhong1yang2ji2"],
["中不溜儿","zhong1bu5liu1r5"],
["中俄关系","zhong1e2guan1xi4"],
["中俄關係","zhong1e2guan1xi4"],
["中坚分子","zhong1jian1fen4zi3"],
["中堅分子","zhong1jian1fen4zi3"],
["中山狼传","zhong1shan1lang2zhuan4"],
["中山狼傳","zhong1shan1lang2zhuan4"]
],
"丰":[
["丰产","feng1chan3"],
["丰水","feng1shui3"],
["丰满","feng1man3"],
["丰美","feng1mei3"],
["丰都","feng1du1"],
["丰采","feng1cai3"]
],
"串":[
["串供","chuan4gong4"],
["串行","chuan4hang2"],
["串亲访友","chuan4qin1fang3you3"],
["串親訪友","chuan4qin1fang3you3"],
["串行点阵打印机","chuan4xing2dian3zhen4da3yin4ji1"],
["串行點陣打印機","chuan4xing2dian3zhen4da3yin4ji1"]
],
"临":[
["临产","lin2chan3"],
["临写","lin2xie3"],
["临场","lin2chang3"],
["临帖","lin2tie4"],
["临武","lin2wu3"],
["临死","lin2si3"],
["临海","lin2hai3"],
["临澧","lin2li3"],
["临难","lin2nan4"],
["临月儿","lin2yue4r5"],
["临门一脚","lin2men2yi4jiao3"]
],
"丹":[
["丹参","dan1shen1"],
["丹參","dan1shen1"],
["丹巴","dan1ba1"]
],
"为":[
["为业","wei2ye4"],
["为主","wei2zhu3"],
["为人","wei2ren2"],
["为伍","wei2wu3"],
["为例","wei2li4"],
["为准","wei2zhun3"],
["为凭","wei2ping2"],
["为善","wei2shan4"],
["为头","wei2tou2"],
["为害","wei2hai4"],
["为己","wei4ji3"],
["为幸","wei2xing4"],
["为恶","wei2e4"],
["为患","wei2huan4"],
["为我","wei4wo3"],
["为时","wei2shi2"],
["为期","wei2qi1"],
["为止","wei2zhi3"],
["为此","wei4ci3"],
["为生","wei2sheng1"],
["为荣","wei2rong2"],
["为证","wei2zheng4"],
["为道","wei2dao4"],
["为重","wei2zhong4"],
["为难","wei2nan2"],
["为首","wei2shou3"],
["为之一振","wei4zhi1yi2zhen4"],
["为之一新","wei2zhi1yi4xin1"],
["为仁不富","wei2ren2bu2fu4"],
["为富不仁","wei2fu4bu4ren2"],
["为德不卒","wei2de2bu4zu2"],
["为德不终","wei2de2bu4zhong1"],
["为所欲为","wei2suo3yu4wei2"],
["为非作歹","wei2fei1zuo4dai3"]
],
"主":[
["主体","zhu3ti3"],
["主使","zhu3shi3"],
["主宰","zhu3zai3"],
["主导","zhu3dao3"],
["主導","zhu3dao3"],
["主干","zhu3gan4"],
["主意","zhu3yi5"],
["主我","zhu3wo3"],
["主旨","zhu3zhi3"],
["主有","zhu3you3"],
["主板","zhu3ban3"],
["主母","zhu3mu3"],
["主演","zhu3yan3"],
["主管","zhu3guan3"],
["主角","zhu3jue2"],
["主語","zhu3yu3"],
["主语","zhu3yu3"],
["主體","zhu3ti3"],
["主不了","zhu3bu5liao3"],
["主人家","zhu3ren2jia1"]
],
"丽":[
["丽水","li2shui3"],
["丽佳娜","li2jia1na4"],
["丽水地区","li4shui3di4qu1"]
],
"举":[
["举手","ju3shou3"],
["举止","ju3zhi3"],
["举起","ju3qi3"],
["举一废百","ju3yi2fei4bai3"],
["举一赅百","ju3yi4gai1bai3"]
],
"乃":[
["乃尔","nai3er3"],
["乃爾","nai3er3"]
],
"久":[
["久已","jiu3yi3"],
["久等","jiu3deng3"],
["久远","jiu3yuan3"],
["久遠","jiu3yuan3"]
],
"么":[
["么二","yao1er4"],
["么小","yao1xiao3"],
["么点","yao1dian3"],
["么點","yao1dian3"],
["么並矢","yao1bing4shi3"]
],
"义":[
["义务","yi4wu4"],
["义勇","yi4yong3"],
["义母","yi4mu3"],
["义气","yi4qi5"],
["义演","yi4yan3"],
["义理","yi4li3"],
["义警","yi4jing3"],
["义马","yi4ma3"]
],
"之":[
["之久","zhi1jiu3"],
["之地","zhi1di4"],
["之子","zhi1zi3"],
["之乎者也","zhi1hu1zhe3ye3"]
],
"乌":[
["乌什","wu1shi2"],
["乌卡","wu1ka3"],
["乌尔","wu4er3"],
["乌榄","wu1lan3"],
["乌法","wu1fa3"],
["乌海","wu1hai3"],
["乌玛","wu1ma3"],
["乌语","wu1yu3"],
["乌鳢","wu1li3"],
["乌兰夫","wu1lan2fu1"],
["乌尔姆","wu1er3mu3"],
["乌斯地","wu1si1di4"],
["乌良哈","wu1liang2ha3"],
["乌黎雅","wu1li1ya3"],
["乌兰巴托","wu1lan2ba1tuo1"],
["乌兰察布市","wu1lan4cha2bu4shi4"]
],
"乍":[
["乍得","zha4de2"],
["乍浦","zha4pu3"],
["乍眼一看","zha4yan3yi2kan4"]
],
"乐":[
["乐亭","yue4ting2"],
["乐器","yue4qi4"],
["乐团","yue4tuan2"],
["乐坛","yue4tan2"],
["乐声","yue4sheng1"],
["乐师","yue4shi1"],
["乐府","yue4fu3"],
["乐得","le4de2"],
["乐手","yue4shou3"],
["乐曲","yue4qu3"],
["乐清","yue4qing1"],
["乐章","yue4zhang1"],
["乐经","yue4jing1"],
["乐谱","yue4pu3"],
["乐迷","yue4mi2"],
["乐都","le4du1"],
["乐队","yue4dui4"],
["乐音","yue4yin1"],
["乐学者","yue4xue2zhe3"],
["乐善好施","le4shan4hao4shi1"],
["乐得心痒难受","le4de5xin1yang3nan2shou4"]
],
"乖":[
["乖巧","guai1qiao3"]
],
"乘":[
["乘法","cheng2fa3"],
["乘警","cheng2jing3"],
["乘务员","cheng2wu4yuan2"],
["乘務員","cheng2wu4yuan2"]
],
"乙":[
["乙丑","yi3chou3"],
["乙卯","yi3mao3"],
["乙种","yi3zhong3"],
["乙種","yi3zhong3"],
["乙脑","yi3nao3"],
["乙腦","yi3nao3"],
["乙酉","yi3you3"]
],
"九":[
["九只","jiu3zhi1"],
["九巴","jiu3ba1"],
["九百","jiu3bai3"],
["九一八","jiu3yi4ba1"],
["九一四","jiu3yi2si4"]
],
"乞":[
["乞兒","qi3er2"],
["乞討","qi3tao3"],
["乞讨","qi3tao3"],
["乞免一死","qi3mian3yi4si3"],
["乞浆得酒","qi3jiang1de2jiu3"],
["乞漿得酒","qi3jiang1de2jiu3"]
],
"也":[
["也好","ye3hao3"],
["也得","ye3dei3"],
["也有","ye3you3"],
["也許","ye3xu3"],
["也许","ye3xu3"]
],
"习":[
["习得","xi2de2"],
["习水","xi2shui3"]
],
"乡":[
["乡下","xiang1xia5"],
["乡土","xiang1tu3"],
["乡戚","xiang1qi1"],
["乡曲","xiang1qu3"],
["乡里","xiang1li3"]
],
"书":[
["书体","shu1ti3"],
["书写","shu1xie3"],
["书卷","shu1juan4"],
["书反","shu1fan3"],
["书展","shu1zhan3"],
["书本","shu1ben3"],
["书板","shu1ban3"],
["书法","shu1fa3"],
["书玛","shu1ma3"],
["书珥","shu1er3"],
["书稿","shu1gao3"],
["书记","shu1ji5"],
["书迹","shu1ji4"],
["书雅","shu1ya3"],
["书馆","shu1guan3"],
["书不尽","shu1bu5jin4"],
["书巴业","shu1ba1ye4"],
["书馆儿","shu1guan3r5"]
],
"买":[
["买主","mai3zhu3"],
["买好","mai3hao3"],
["买下来","mai3xia4lai2"],
["买不上","mai3bu5shang4"],
["买不下","mai3bu5xia4"],
["买不到","mai3bu5dao4"],
["买不成","mai3bu5cheng2"],
["买不来","mai3bu5lai2"],
["买不着","mai3bu5zhao2"],
["买不起","mai3bu5qi3"],
["买得出","mai3de5chu1"],
["买一送一","mai3yi2song4yi1"]
],
"乱":[
["乱党","luan4dang3"],
["乱写","luan4xie3"],
["乱滚","luan4gun3"],
["乱码","luan4ma3"],
["乱跑","luan4pao3"],
["乱闯","luan4chuang3"],
["乱蓬蓬","luan4peng1peng1"],
["乱打一通","luan4da3yi4tong1"],
["乱说一通","luan4shuo1yi4tong1"]
],
"乳":[
["乳晕","ru3yun4"],
["乳暈","ru3yun4"],
["乳母","ru3mu3"],
["乳齒","ru3chi3"],
["乳齿","ru3chi3"],
["乳白色","ru3bai2se5"],
["乳臭未乾","ru3xiu4wei4gan1"],
["乳臭未干","ru3xiu4wei4gan1"]
],
"乾":[
["乾冰","gan1bing1"],
["乾凈","gan1jing4"],
["乾吗","gan4ma2"],
["乾嗎","gan4ma2"],
["乾嚎","gan1hao2"],
["乾姜","gan1jiang1"],
["乾娘","gan1niang2"],
["乾媽","gan1ma1"],
["乾巴","gan1ba5"],
["乾旱","gan1han4"],
["乾杯","gan1bei1"],
["乾果","gan1guo3"],
["乾枯","gan1ku1"],
["乾柴","gan1chai2"],
["乾洗","gan1xi3"],
["乾涸","gan1he2"],
["乾淨","gan1jing4"],
["乾渴","gan1ke3"],
["乾燥","gan1zao4"],
["乾爹","gan1die1"],
["乾瘦","gan1shou4"],
["乾癬","gan1xuan3"],
["乾糧","gan1liang5"],
["乾脆","gan1cui4"],
["乾草","gan1cao3"],
["乾菜","gan1cai4"],
["乾號","gan1hao2"],
["乾衣","gan1yi1"],
["乾裂","gan1lie4"],
["乾貝","gan1bei4"],
["乾透","gan1tou4"],
["乾酪","gan1lao4"],
["乾飯","gan1fan4"],
["乾麼","gan4ma2"],
["乾梅子","gan1mei2zi5"],
["乾巴得慌","gan1ba1de5huang1"]
],
"亂":[
["亂寫","luan4xie3"],
["亂滾","luan4gun3"],
["亂碼","luan4ma3"],
["亂跑","luan4pao3"],
["亂闖","luan4chuang3"],
["亂黨","luan4dang3"],
["亂蓬蓬","luan4peng1peng1"],
["亂打一通","luan4da3yi4tong1"],
["亂說一通","luan4shuo1yi4tong1"]
],
"了":[
["了了","liao3liao3"],
["了事","liao3shi4"],
["了住","liao3zhu4"],
["了儿","liao3r5"],
["了兒","liao3r5"],
["了却","liao3que4"],
["了卻","liao3que4"],
["了帐","liao3zhang4"],
["了帳","liao3zhang4"],
["了当","liao3dang4"],
["了得","liao3de5"],
["了手","liao3shou3"],
["了清","liao3qing1"],
["了當","liao3dang4"],
["了結","liao3jie2"],
["了结","liao3jie2"],
["了解","liao3jie3"],
["了不了","liao3bu5liao3"],
["了不得","liao3bu5de5"],
["了不起","liao3bu5qi3"],
["了得了","liao3de5liao3"],
["了如指掌","liao3ru2zhi3zhang3"],
["了此一生","liao3ci3yi4sheng1"]
],
"予":[
["予以","yu3yi3"]
],
"争":[
["争取","zheng1qu3"],
["争吵","zheng1chao3"],
["争宠","zheng1chong3"],
["争得","zheng1de2"],
["争竞","zheng1jing5"],
["争不到","zheng1bu5dao4"],
["争不来","zheng1bu5lai2"]
],
"事":[
["事体","shi4ti3"],
["事假","shi4jia4"],
["事儿","shi4r5"],
["事务","shi4wu4"],
["事務","shi4wu4"],
["事宜","shi4yi2"],
["事理","shi4li3"],
["事跡","shi4ji4"],
["事迹","shi4ji4"],
["事體","shi4ti3"],
["事危累卵","shi4wei1lei3luan3"],
["事非得已","shi4fei1de2yi3"]
],
"二":[
["二只","er4zhi1"],
["二奶","er4nai3"],
["二手","er4shou3"],
["二百","er4bai3"],
["二等","er4deng3"],
["二老","er4lao3"],
["二者","er4zhe3"],
["二重","er4chong2"],
["二噁英","er4e4ying1"],
["二把手","er4ba3shou3"],
["二節棍","er2jie2gun4"],
["二节棍","er2jie2gun4"],
["二十一条","er4shi2yi1tiao2"],
["二十一條","er4shi2yi1tiao2"],
["二十八宿","er4shi2ba1xiu4"],
["二馬一虎","er4ma3yi4hu3"],
["二马一虎","er4ma3yi4hu3"],
["二一添作五","er4yi4tian1zuo4wu3"],
["二十一世紀","er4shi2yi1shi4ji4"],
["二十一世纪","er4shi2yi1shi4ji4"],
["二十四節氣","er4shi2si4jie2qi4"],
["二十四节气","er4shi2si4jie2qi4"],
["二合一复数","er4he2yi2fu4shu4"],
["二合一複數","er4he2yi2fu4shu4"]
],
"于":[
["于此","yu2ci3"],
["于都","yu2du1"]
],
"亏":[
["亏产","kui1chan3"],
["亏折","kui1she2"],
["亏损","kui1sun3"],
["亏本","kui1ben3"],
["亏空","kui1kong5"]
],
"云":[
["云彩","yun2cai5"],
["云影","yun2ying3"],
["云朵","yun2duo3"],
["云母","yun2mu3"],
["云涌","yun2yong3"],
["云顶","yun2ding3"]
],
"互":[
["互补","hu4bu3"],
["互補","hu4bu3"],
["互訪","hu4fang3"],
["互访","hu4fang3"],
["互操性","hu4cao4xing5"],
["互为因果","hu4wei2yin1guo3"],
["互為因果","hu4wei2yin1guo3"]
],
"五":[
["五只","wu3zhi1"],
["五百","wu3bai3"],
["五穀","wu3gu3"],
["五笔","wu3bi3"],
["五筆","wu3bi3"],
["五角","wu3jiao3"],
["五谷","wu3gu3"],
["五鬼","wu3gui3"],
["五子棋","wu3zi3qi2"],
["五虎将","wu3hu3jiang4"],
["五虎將","wu3hu3jiang4"],
["五体投地","wu3ti3tou2di4"],
["五行八作","wu3hang2ba1zuo4"],
["五體投地","wu3ti3tou2di4"],
["五一六通知","wu3yi2liu4tong1zhi1"],
["五一劳动节","wu3yi4lao2dong4jie2"],
["五一勞動節","wu3yi4lao2dong4jie2"]
],
"井":[
["井口","jing3kou3"],
["井水","jing3shui3"]
],
"亚":[
["亚卡","ya4ka3"],
["亚塔","ya4ta3"],
["亚巴","ya4ba1"],
["亚底","ya4di3"],
["亚所","ya4suo3"],
["亚抹","ya4mo3"],
["亚比","ya4bi3"],
["亚玛","ya4ma3"],
["亚珥","ya4er3"],
["亚瓦","ya4wa3"],
["亚甲","ya4jia3"],
["亚种","ya4zhong3"],
["亚米","ya4mi3"],
["亚铁","ya4tie3"],
["亚雅","ya4ya3"],
["亚哈拉","ya4ha1la1"],
["亚喀巴","ya4ka1ba1"],
["亚得列","ya4de2lie4"],
["亚拉得","ya4la1de2"],
["亚罢拿","ya4ba4na2"],
["亚舍拉","ya4she4la1"],
["亚都悯","ya4du1min3"],
["亚得米勒","ya4de2mi3le4"],
["亚斯那巴","ya4si1na4ba1"],
["亚略巴古","ya4lve4ba1gu3"],
["亚隆巴古","ya4long2ba1gu3"],
["亚得里亚海","ya4de2li3ya4hai3"],
["亚历山大里亚","ya4li4shan1da4li3ya4"],
["亚的斯亚贝巴","ya4di4si1ya4bei4ba1"]
],
"些":[
["些許","xie1xu3"],
["些许","xie1xu3"]
],
"亞":[
["亞卡","ya4ka3"],
["亞塔","ya4ta3"],
["亞巴","ya4ba1"],
["亞底","ya4di3"],
["亞所","ya4suo3"],
["亞抹","ya4mo3"],
["亞比","ya4bi3"],
["亞珥","ya4er3"],
["亞瑪","ya4ma3"],
["亞瓦","ya4wa3"],
["亞甲","ya4jia3"],
["亞種","ya4zhong3"],
["亞米","ya4mi3"],
["亞鐵","ya4tie3"],
["亞雅","ya4ya3"],
["亞哈拉","ya4ha1la1"],
["亞喀巴","ya4ka1ba1"],
["亞得列","ya4de2lie4"],
["亞拉得","ya4la1de2"],
["亞罷拿","ya4ba4na2"],
["亞舍拉","ya4she4la1"],
["亞都憫","ya4du1min3"],
["亞得米勒","ya4de2mi3le4"],
["亞斯那巴","ya4si1na4ba1"],
["亞略巴古","ya4lve4ba1gu3"],
["亞隆巴古","ya4long2ba1gu3"],
["亞得里亞海","ya4de2li3ya4hai3"],
["亞歷山大裡亞","ya4li4shan1da4li3ya4"],
["亞的斯亞貝巴","ya4di4si1ya4bei4ba1"]
],
"亡":[
["亡母","wang2mu3"],
["亡沒","wang2mo4"],
["亡没","wang2mo4"],
["亡者","wang2zhe3"],
["亡羊得牛","wang2yang2de2niu2"]
],
"交":[
["交九","jiao1jiu3"],
["交卷","jiao1juan4"],
["交友","jiao1you3"],
["交口","jiao1kou3"],
["交响","jiao1xiang3"],
["交尾","jiao1wei3"],
["交往","jiao1wang3"],
["交情","jiao1qing5"],
["交手","jiao1shou3"],
["交火","jiao1huo3"],
["交点","jiao1dian3"],
["交給","jiao1gei3"],
["交给","jiao1gei3"],
["交角","jiao1jiao3"],
["交警","jiao1jing3"],
["交还","jiao1huan2"],
["交還","jiao1huan2"],
["交響","jiao1xiang3"],
["交點","jiao1dian3"],
["交不上","jiao1bu5shang4"],
["交不下","jiao1bu5xia4"],
["交不了","jiao1bu5liao3"],
["交不出","jiao1bu5chu1"],
["交响乐","jiao1xiang3yue4"],
["交响曲","jiao1xiang3qu3"],
["交得上","jiao1de5shang4"],
["交響曲","jiao1xiang3qu3"],
["交響樂","jiao1xiang3yue4"]
],
"产":[
["产仔","chan3zi3"],
["产假","chan3jia4"],
["产卵","chan3luan3"],
["产品","chan3pin3"],
["产地","chan3di4"],
["产不出","chan3bu5chu1"]
],
"享":[
["享有","xiang3you3"]
],
"京":[
["京广","jing1guang3"],
["京廣","jing1guang3"],
["京都","jing1du1"]
],
"亮":[
["亮堂","liang4tang5"],
["亮彩","liang4cai3"],
["亮相","liang4xiang4"]
],
"亲":[
["亲友","qin1you3"],
["亲口","qin1kou3"],
["亲吻","qin1wen3"],
["亲嘴","qin1zui3"],
["亲子","qin1zi3"],
["亲家","qing4jia5"],
["亲属","qin1shu3"],
["亲手","qin1shou3"],
["亲眼","qin1yan3"],
["亲笔","qin1bi3"],
["亲耳","qin1er3"],
["亲朋好友","qin1peng2hao3you3"],
["亲眼看见","qin1yan3kan4jian4"]
],
"人":[
["人为","ren2wei2"],
["人主","ren2zhu3"],
["人体","ren2ti3"],
["人保","ren2bao3"],
["人参","ren2shen1"],
["人參","ren2shen1"],
["人口","ren2kou3"],
["人地","ren2di4"],
["人子","ren2zi3"],
["人家","ren2jia5"],
["人差","ren2cha1"],
["人手","ren2shou3"],
["人武","ren2wu3"],
["人死","ren2si3"],
["人海","ren2hai3"],
["人满","ren2man3"],
["人滿","ren2man3"],
["人為","ren2wei2"],
["人相","ren2xiang4"],
["人种","ren2zhong3"],
["人種","ren2zhong3"],
["人跡","ren2ji4"],
["人迹","ren2ji4"],
["人选","ren2xuan3"],
["人選","ren2xuan3"],
["人馬","ren2ma3"],
["人马","ren2ma3"],
["人體","ren2ti3"],
["人尖儿","ren2jian1r5"],
["人傑地靈","ren2jie2di4ling2"],
["人情味儿","ren2qing2wei4r5"],
["人杰地灵","ren2jie2di4ling2"],
["人浮於事","ren2fu2yu2shi4"],
["人盡其才","ren2jin4qi2cai2"],
["人盡其材","ren2jin4qi2cai2"],
["人給家足","ren2ji3jia1zu2"],
["人给家足","ren2ji3jia1zu2"],
["人不可貌相","ren2bu4ke3mao4xiang4"]
],
"什":[
["什一","shi2yi1"],
["什亭","shi2ting2"],
["什叶","shi2ye4"],
["什菜","shi2cai4"],
["什葉","shi2ye4"],
["什邡","shi2fang1"],
["什麽","shen2me5"],
["什刹海","shi2cha4hai3"],
["什剎海","shi2cha4hai3"],
["什一奉献","shi2yi2feng4xian4"],
["什一奉獻","shi2yi2feng4xian4"]
],
"仅":[
["仅仅","jin3jin3"],
["仅有","jin3you3"]
],
"今":[
["今儿","jin1r5"],
["今晚","jin1wan3"],
["今晨","jin1chen2"],
["今朝","jin1zhao1"]
],
"介":[
["介壳","jie4qiao4"],
["介子","jie4zi3"],
["介於","jie4yu2"],
["介殼","jie4qiao4"]
],
"仍":[
["仍有","reng2you3"]
],
"从":[
["从古","cong2gu3"],
["从女","cong2nv3"],
["从小","cong2xiao3"],
["从属","cong2shu3"],
["从此","cong2ci3"],
["从母","cong2mu3"],
["从一而终","cong2yi4er2zhong1"],
["从那时侯","cong2na4shi2hou4"]
],
"仓":[
["仓储","cang1chu3"],
["仓颉","cang1jie2"],
["仓鼠","cang1shu3"]
],
"他":[
["他巴","ta1ba1"],
["他往","ta1wang3"],
["他得","ta1dei3"],
["他泊","ta1bo2"],
["他玛","ta1ma3"],
["他瑪","ta1ma3"],
["他罕","ta1han3"],
["他得上","ta1de2shang4"],
["他得中","ta1de2zhong4"],
["他得主","ta1de2zhu3"],
["他得了","ta1de2le5"],
["他得享","ta1de2xiang3"],
["他得人","ta1de2ren2"],
["他得令","ta1de2ling4"],
["他得以","ta1de2yi3"],
["他得体","ta1de2ti3"],
["他得來","ta1de2lai2"],
["他得便","ta1de2bian4"],
["他得出","ta1de2chu1"],
["他得分","ta1de2fen1"],
["他得到","ta1de2dao4"],
["他得力","ta1de2li4"],
["他得劲","ta1de2jin4"],
["他得势","ta1de2shi4"],
["他得勁","ta1de2jin4"],
["他得勝","ta1de2sheng4"],
["他得勢","ta1de2shi4"],
["他得名","ta1de2ming2"],
["他得君","ta1de2jun1"],
["他得听","ta1de2ting1"],
["他得味","ta1de2wei4"],
["他得喜","ta1de2xi3"],
["他得失","ta1de2shi1"],
["他得奖","ta1de2jiang3"],
["他得子","ta1de2zi3"],
["他得宜","ta1de2yi2"],
["他得实","ta1de2shi2"],
["他得宠","ta1de2chong3"],
["他得實","ta1de2shi2"],
["他得寵","ta1de2chong3"],
["他得巴","ta1de2ba5"],
["他得年","ta1de2nian2"],
["他得幸","ta1de2xing4"],
["他得当","ta1de2dang4"],
["他得彩","ta1de2cai3"],
["他得很","ta1de5hen3"],
["他得得","ta1de2de2"],
["他得志","ta1de2zhi4"],
["他得悉","ta1de2xi1"],
["他得意","ta1de2yi4"],
["他得所","ta1de2suo3"],
["他得手","ta1de2shou3"],
["他得撒","ta1de2sa1"],
["他得救","ta1de2jiu4"],
["他得数","ta1de2shu4"],
["他得數","ta1de2shu4"],
["他得文","ta1de2wen2"],
["他得时","ta1de2shi2"],
["他得時","ta1de2shi2"],
["他得来","ta1de2lai2"],
["他得标","ta1de2biao1"],
["他得榮","ta1de2rong2"],
["他得標","ta1de2biao1"],
["他得民","ta1de2min2"],
["他得法","ta1de2fa3"],
["他得獎","ta1de2jiang3"],
["他得率","ta1de2lv4"],
["他得瑕","ta1de2xia2"],
["他得用","ta1de2yong4"],
["他得當","ta1de2dang4"],
["他得病","ta1de2bing4"],
["他得益","ta1de2yi4"],
["他得着","ta1de2zhao2"],
["他得知","ta1de2zhi1"],
["他得神","ta1de2shen2"],
["他得票","ta1de2piao4"],
["他得空","ta1de2kong4"],
["他得窍","ta1de2qiao4"],
["他得竅","ta1de2qiao4"],
["他得策","ta1de2ce4"],
["他得粮","ta1de2liang2"],
["他得糧","ta1de2liang2"],
["他得繼","ta1de2ji4"],
["他得继","ta1de2ji4"],
["他得罪","ta1de2zui5"],
["他得职","ta1de2zhi2"],
["他得職","ta1de2zhi2"],
["他得聽","ta1de2ting1"],
["他得胜","ta1de2sheng4"],
["他得脸","ta1de2lian3"],
["他得臉","ta1de2lian3"],
["他得自","ta1de2zi4"],
["他得色","ta1de2se4"],
["他得荣","ta1de2rong2"],
["他得著","ta1de2zhao2"],
["他得計","ta1de2ji4"],
["他得證","ta1de2zheng4"],
["他得计","ta1de2ji4"],
["他得证","ta1de2zheng4"],
["他得逞","ta1de2cheng3"],
["他得道","ta1de2dao4"],
["他得閑","ta1de2xian2"],
["他得間","ta1de2jian4"],
["他得闲","ta1de2xian2"],
["他得间","ta1de2jian4"],
["他得非","ta1de2fei1"],
["他得體","ta1de2ti3"],
["他得不到","ta1de2bu5dao4"],
["他得不着","ta1de2bu5zhao2"],
["他得不著","ta1de2bu5zhao2"],
["他得人儿","ta1de2ren2r5"],
["他得便儿","ta1de2bian4r5"],
["他得便宜","ta1de2pian2yi5"],
["他得劲儿","ta1de2jin4r5"],
["他得天下","ta1de2tian1xia4"],
["他得数儿","ta1de2shu4r5"],
["他得样儿","ta1de2yang4r5"],
["他得樣兒","ta1de2yang4r5"],
["他得益处","ta1de2yi4chu5"],
["他得益處","ta1de2yi4chu5"],
["他得空儿","ta1de2kong4r5"],
["他得罪人","ta1de2zui4ren2"],
["他廷合示地","ta1ting2he2shi4di4"]
],
"仗":[
["仗火","zhang4huo3"]
],
"付":[
["付梓","fu4zi3"],
["付款","fu4kuan3"],
["付給","fu4gei3"],
["付给","fu4gei3"],
["付之一叹","fu4zhi1yi2tan4"],
["付之一嘆","fu4zhi1yi2tan4"],
["付之一歎","fu4zhi1yi2tan4"],
["付之一炬","fu4zhi1yi2ju4"],
["付之一笑","fu4zhi1yi2xiao4"],
["付諸一炬","fu4zhu1yi2ju4"],
["付诸一炬","fu4zhu1yi2ju4"]
],
"仙":[
["仙人","xian1ren2"],
["仙台","xian1tai2"],
["仙境","xian1jing4"],
["仙女","xian1nv3"],
["仙姑","xian1gu1"],
["仙居","xian1ju1"],
["仙山","xian1shan1"],
["仙岛","xian1dao3"],
["仙島","xian1dao3"],
["仙桃","xian1tao2"],
["仙游","xian1you2"],
["仙童","xian1tong2"],
["仙草","xian1cao3"],
["仙逝","xian1shi4"],
["仙遊","xian1you2"],
["仙后座","xian1hou4zuo4"],
["仙客來","xian1ke4lai2"],
["仙客来","xian1ke4lai2"],
["仙王座","xian1wang2zuo4"]
],
"仟":[
["仟悔","qian1hui3"]
],
"代":[
["代写","dai4xie3"],
["代寫","dai4xie3"],
["代理","dai4li3"],
["代码","dai4ma3"],
["代碼","dai4ma3"],
["代祷","dai4dao3"],
["代禱","dai4dao3"],
["代笔","dai4bi3"],
["代筆","dai4bi3"],
["代考","dai4kao3"],
["代表","dai4biao3"]
],
"令":[
["令狐","ling2hu2"],
["令人发指","ling4ren2fa4zhi3"]
],
"以":[
["以为","yi3wei2"],
["以倘","yi3tang3"],
["以免","yi3mian3"],
["以北","yi3bei3"],
["以坦","yi3tan3"],
["以往","yi3wang3"],
["以扫","yi3sao3"],
["以掃","yi3sao3"],
["以斐","yi3fei3"],
["以此","yi3ci3"],
["以法","yi3fa3"],
["以為","yi3wei2"],
["以瓦","yi3wa3"],
["以米","yi3mi3"],
["以里","yi3li3"],
["以鐵","yi3tie3"],
["以铁","yi3tie3"],
["以利楚","yi3li4chu3"],
["以巴弗","yi3ba1fu2"],
["以巴路","yi3ba1lu4"],
["以得雷","yi3de2lei2"],
["以拉都","yi3la1du1"],
["以一奉百","yi3yi2feng4bai3"],
["以一当十","yi3yi4dang1shi2"],
["以一当百","yi3yi4dang1bai3"],
["以一持万","yi3yi4chi2wan4"],
["以一持萬","yi3yi4chi2wan4"],
["以一當十","yi3yi4dang1shi2"],
["以一當百","yi3yi4dang1bai3"],
["以一警百","yi3yi4jing3bai3"],
["以决一战","yi3jue2yi2zhan4"],
["以博一笑","yi3bo2yi2xiao4"],
["以博一粲","yi3bo2yi2can4"],
["以慎为键","yi3shen4wei2jian4"],
["以慎為鍵","yi3shen4wei2jian4"],
["以求一逞","yi3qiu2yi4cheng3"],
["以決一戰","yi3jue2yi2zhan4"],
["以牙还牙","yi3ya2huan2ya2"],
["以牙還牙","yi3ya2huan2ya2"],
["以眼还眼","yi3yan3huan2yan3"],
["以眼還眼","yi3yan3huan2yan3"],
["以邻为壑","yi3lin2wei2he4"],
["以鄰為壑","yi3lin2wei2he4"]
],
"仪":[
["仪典","yi2dian3"],
["仪礼","yi2li3"],
["仪表","yi2biao3"],
["仪陇","yi2long3"]
],
"们":[
["们得","men5dei3"],
["们得上","men5de2shang4"],
["们得中","men5de2zhong4"],
["们得主","men5de2zhu3"],
["们得了","men5de2le5"],
["们得享","men5de2xiang3"],
["们得人","men5de2ren2"],
["们得令","men5de2ling4"],
["们得以","men5de2yi3"],
["们得体","men5de2ti3"],
["们得來","men5de2lai2"],
["们得便","men5de2bian4"],
["们得出","men5de2chu1"],
["们得分","men5de2fen1"],
["们得到","men5de2dao4"],
["们得力","men5de2li4"],
["们得劲","men5de2jin4"],
["们得势","men5de2shi4"],
["们得勁","men5de2jin4"],
["们得勝","men5de2sheng4"],
["们得勢","men5de2shi4"],
["们得名","men5de2ming2"],
["们得君","men5de2jun1"],
["们得听","men5de2ting1"],
["们得味","men5de2wei4"],
["们得喜","men5de2xi3"],
["们得失","men5de2shi1"],
["们得奖","men5de2jiang3"],
["们得子","men5de2zi3"],
["们得宜","men5de2yi2"],
["们得实","men5de2shi2"],
["们得宠","men5de2chong3"],
["们得實","men5de2shi2"],
["们得寵","men5de2chong3"],
["们得巴","men5de2ba5"],
["们得年","men5de2nian2"],
["们得幸","men5de2xing4"],
["们得当","men5de2dang4"],
["们得彩","men5de2cai3"],
["们得很","men5de5hen3"],
["们得得","men5de2de2"],
["们得志","men5de2zhi4"],
["们得悉","men5de2xi1"],
["们得意","men5de2yi4"],
["们得所","men5de2suo3"],
["们得手","men5de2shou3"],
["们得撒","men5de2sa1"],
["们得救","men5de2jiu4"],
["们得数","men5de2shu4"],
["们得數","men5de2shu4"],
["们得文","men5de2wen2"],
["们得时","men5de2shi2"],
["们得時","men5de2shi2"],
["们得来","men5de2lai2"],
["们得标","men5de2biao1"],
["们得榮","men5de2rong2"],
["们得標","men5de2biao1"],
["们得民","men5de2min2"],
["们得法","men5de2fa3"],
["们得獎","men5de2jiang3"],
["们得率","men5de2lv4"],
["们得瑕","men5de2xia2"],
["们得用","men5de2yong4"],
["们得當","men5de2dang4"],
["们得病","men5de2bing4"],
["们得益","men5de2yi4"],
["们得着","men5de2zhao2"],
["们得知","men5de2zhi1"],
["们得神","men5de2shen2"],
["们得票","men5de2piao4"],
["们得空","men5de2kong4"],
["们得窍","men5de2qiao4"],
["们得竅","men5de2qiao4"],
["们得策","men5de2ce4"],
["们得粮","men5de2liang2"],
["们得糧","men5de2liang2"],
["们得繼","men5de2ji4"],
["们得继","men5de2ji4"],
["们得罪","men5de2zui5"],
["们得职","men5de2zhi2"],
["们得職","men5de2zhi2"],
["们得聽","men5de2ting1"],
["们得胜","men5de2sheng4"],
["们得脸","men5de2lian3"],
["们得臉","men5de2lian3"],
["们得自","men5de2zi4"],
["们得色","men5de2se4"],
["们得荣","men5de2rong2"],
["们得著","men5de2zhao2"],
["们得計","men5de2ji4"],
["们得證","men5de2zheng4"],
["们得计","men5de2ji4"],
["们得证","men5de2zheng4"],
["们得逞","men5de2cheng3"],
["们得道","men5de2dao4"],
["们得閑","men5de2xian2"],
["们得間","men5de2jian4"],
["们得闲","men5de2xian2"],
["们得间","men5de2jian4"],
["们得非","men5de2fei1"],
["们得體","men5de2ti3"],
["们得不到","men5de2bu5dao4"],
["们得不着","men5de2bu5zhao2"],
["们得不著","men5de2bu5zhao2"],
["们得人儿","men5de2ren2r5"],
["们得便儿","men5de2bian4r5"],
["们得便宜","men5de2pian2yi5"],
["们得劲儿","men5de2jin4r5"],
["们得天下","men5de2tian1xia4"],
["们得数儿","men5de2shu4r5"],
["们得样儿","men5de2yang4r5"],
["们得樣兒","men5de2yang4r5"],
["们得益处","men5de2yi4chu5"],
["们得益處","men5de2yi4chu5"],
["们得空儿","men5de2kong4r5"],
["们得罪人","men5de2zui4ren2"]
],
"仰":[
["仰泳","yang3yong3"],
["仰脸","yang3lian3"],
["仰臉","yang3lian3"],
["仰屋兴叹","yang3wu1xing1tan4"],
["仰屋興嘆","yang3wu1xing1tan4"]
],
"仲":[
["仲巴","zhong4ba1"]
],
"价":[
["价款","jia4kuan3"],
["价钱","jia4qian5"]
],
"任":[
["任为","ren4wei2"],
["任免","ren4mian3"],
["任所","ren4suo3"],
["任為","ren4wei2"],
["任选","ren4xuan3"],
["任選","ren4xuan3"],
["任一个","ren4yi2ge4"],
["任一個","ren4yi2ge4"]
],
"份":[
["份儿","fen4r5"],
["份量","fen4liang5"]
],
"仿":[
["仿古","fang3gu3"],
["仿紙","fang3zhi3"],
["仿纸","fang3zhi3"]
],
"企":[
["企劃","qi3hua4"]
],
"伊":[
["伊塔","yi1ta3"],
["伊朗","yi1lang3"],
["伊珥","yi1er3"],
["伊索","yi1suo3"],
["伊妹儿","yi1mei4er5"],
["伊妹兒","yi1mei4er5"],
["伊施巴","yi1shi1ba1"],
["伊於胡底","yi1yu2hu2di3"],
["伊裡格瑞","yi1li3ge2rui4"]
],
"伍":[
["伍奢","wu3she1"],
["伍的","wu3de5"],
["伍子胥","wu3zi3xu1"],
["伍廷芳","wu3ting2fang1"],
["伍德豪斯","wu3de2hao2si1"]
],
"伎":[
["伎俩","ji4liang3"],
["伎倆","ji4liang3"]
],
"伏":[
["伏地","fu2di4"],
["伏笔","fu2bi3"],
["伏筆","fu2bi3"],
["伏虎","fu2hu3"],
["伏罗希洛夫","fu2luo2xi1luo4fu1"],
["伏羅希洛夫","fu2luo2xi1luo4fu1"]
],
"休":[
["休假","xiu1jia4"],
["休养","xiu1yang3"],
["休想","xiu1xiang3"],
["休整","xiu1zheng3"],
["休止","xiu1zhi3"],
["休養","xiu1yang3"]
],
"优":[
["优格","you1ge1"],
["优点","you1dian3"],
["优等","you1deng3"],
["优美","you1mei3"],
["优雅","you1ya3"]
],
"伙":[
["伙計","huo3ji5"],
["伙计","huo3ji5"],
["伙食","huo3shi5"]
],
"会":[
["会友","hui4you3"],
["会否","hui4fou3"],
["会场","hui4chang3"],
["会审","hui4shen3"],
["会死","hui4si3"],
["会计","kuai4ji4"],
["会长","hui4zhang3"],
["会首","hui4shou3"],
["会心一笑","hui4xin1yi2xiao4"]
],
"伟":[
["伟举","wei3ju3"],
["伟绩","wei3ji4"]
],
"传":[
["传写","chuan2xie3"],
["传寄","chuan3ji4"],
["传导","chuan2dao3"],
["传感","chuan2gan3"],
["传本","chuan2ben3"],
["传染","chuan2ran3"],
["传略","zhuan4lve4"],
["传种","chuan2zhong3"],
["传粉","chuan2fen3"],
["传给","chuan2gei5"],
["传统","chuan2tong3"],
["传记","zhuan4ji4"],
["传讲","chuan2jiang3"],
["传语","chuan2yu3"],
["传赞","zhuan4zan4"]
],
"伢":[
["伢崽","ya2zai3"]
],
"伤":[
["伤口","shang1kou3"],
["伤感","shang1gan3"],
["伤者","shang1zhe3"],
["伤耗","shang1hao5"]
],
"伦":[
["伦巴","lun2ba1"],
["伦理","lun2li3"]
],
"伪":[
["伪顶","wei3ding3"]
],
"伯":[
["伯伯","bo2bo5"],
["伯母","bo2mu3"],
["伯祖","bo2zu3"],
["伯利兹","bai3li4zi1"],
["伯利茲","bai3li4zi1"],
["伯拉斯都","bo2la1si1du1"]
],
"估":[
["估产","gu1chan3"],
["估摸","gu1mo5"],
["估產","gu1chan3"],
["估衣","gu4yi5"],
["估量","gu1liang5"],
["估堆儿","gu1dui1r5"]
],
"伴":[
["伴侣","ban4lv3"],
["伴侶","ban4lv3"]
],
"伶":[
["伶人","ling2ren2"],
["伶仃","ling2ding1"],
["伶俐","ling2li4"],
["伶俜","ling2ping1"],
["伶悧","ling2li4"],
["伶牙俐齒","ling2ya2li4chi3"],
["伶牙俐齿","ling2ya2li4chi3"]
],
"伸":[
["伸展","shen1zhan3"],
["伸手","shen1shou3"]
],
"伺":[
["伺候","ci4hou5"],
["伺服","si4fu2"],
["伺机","si4ji1"],
["伺機","si4ji1"],
["伺隙","si4xi4"]
],
"似":[
["似乎","si4hu1"],
["似雪","si4xue3"],
["似鳥","si4niao3"],
["似鸟","si4niao3"]
],
"伽":[
["伽馬","ga1ma3"],
["伽马","ga1ma3"],
["伽罗华","jia1luo2hua4"],
["伽罗瓦","jia1luo2wa4"],
["伽羅瓦","jia1luo2wa4"],
["伽羅華","jia1luo2hua4"],
["伽罗瓦理论","jia1luo2wa3li3lun4"],
["伽羅瓦理論","jia1luo2wa3li3lun4"]
],
"但":[
["但使","dan4shi3"],
["但只","dan4zhi3"]
],
"佈":[
["佈伍","bu4wu3"],
["佈景","bu4jing3"]
],
"位":[
["位分","wei4fen4"],
["位差","wei4cha1"],
["位於","wei4yu2"],
["位置","wei4zhi5"]
],
"低":[
["低产","di1chan3"],
["低地","di1di4"],
["低息","di1xi1"],
["低於","di1yu2"],
["低產","di1chan3"],
["低矮","di1ai3"],
["低等","di1deng3"],
["低緩","di1huan3"],
["低缓","di1huan3"],
["低語","di1yu3"],
["低语","di1yu3"],
["低谷","di1gu3"],
["低能兒","di1neng2er2"]
],
"住":[
["住下","zhu4xia5"],
["住友","zhu4you3"],
["住口","zhu4kou3"],
["住嘴","zhu4zui3"],
["住地","zhu4di4"],
["住址","zhu4zhi3"],
["住所","zhu4suo3"],
["住手","zhu4shou3"],
["住满","zhu4man3"],
["住滿","zhu4man3"],
["住舍","zhu4she4"],
["住下來","zhu4xia4lai5"],
["住下去","zhu4xia4qu5"],
["住下来","zhu4xia4lai5"],
["住不下","zhu4bu5xia4"],
["住不了","zhu4bu5liao3"],
["住不住","zhu4bu5zhu4"],
["住不开","zhu4bu5kai1"],
["住不起","zhu4bu5qi3"],
["住不開","zhu4bu5kai1"]
],
"佐":[
["佐酒","zuo3jiu3"],
["佐格比国际","zuo3ge2bi4guo2ji4"],
["佐格比國際","zuo3ge2bi4guo2ji4"]
],
"体":[
["体己","ti1ji5"],
["体检","ti3jian3"],
["体癣","ti3xuan3"],
["体统","ti3tong3"],
["体表","ti3biao3"],
["体面","ti3mian5"]
],
"佔":[
["佔有","zhan4you3"],
["佔領","zhan4ling3"],
["佔领","zhan4ling3"],
["佔便宜","zhan4pian2yi5"]
],
"何":[
["何以","he2yi3"],
["何地","he2di4"],
["何坦","he2tan3"],
["何巴","he2ba1"],
["何得","he2de2"],
["何止","he2zhi3"],
["何珥","he2er3"],
["何琏","he2lian3"],
["何璉","he2lian3"],
["何等","he2deng3"],
["何苦","he2ku3"],
["何以見得","he2yi3jian4de2"],
["何以见得","he2yi3jian4de2"],
["何由見得","he2you2jian4de2"],
["何由见得","he2you2jian4de2"],
["何魯曉夫","he2lu3xiao3fu1"],
["何鲁晓夫","he2lu3xiao3fu1"],
["何乐而不为","he2le4er2bu4wei2"],
["何樂而不為","he2le4er2bu4wei2"]
],
"余":[
["余党","yu2dang3"],
["余切","yu2qie1"],
["余地","yu2di4"],
["余码","yu2ma3"],
["余者","yu2zhe3"],
["余角","yu2jiao3"],
["余下来","yu2xia4lai2"]
],
"佛":[
["佛像","fo2xiang4"],
["佛冈","fo2gang1"],
["佛号","fo2hao4"],
["佛坪","fo2ping2"],
["佛塔","fo2ta3"],
["佛家","fo2jia1"],
["佛寺","fo2si4"],
["佛山","fo2shan1"],
["佛岡","fo2gang1"],
["佛性","fo2xing4"],
["佛教","fo2jiao4"],
["佛法","fo2fa3"],
["佛經","fo2jing1"],
["佛经","fo2jing1"],
["佛號","fo2hao4"],
["佛語","fo2yu3"],
["佛语","fo2yu3"],
["佛陀","fo2tuo2"],
["佛龕","fo2kan1"],
["佛龛","fo2kan1"],
["佛得角","fo2de2jiao3"],
["佛手瓜","fo2shou3gua1"],
["佛朗哥","fo2lang3ge1"],
["佛舍利","fo2she4li4"],
["佛香閣","fo2xiang1ge2"],
["佛香阁","fo2xiang1ge2"],
["佛兰芒语","fo2lan2mang2yu3"],
["佛洛伊德","fo2luo4yi1de2"],
["佛罗伦萨","fo2luo2lun2sa4"],
["佛羅倫薩","fo2luo2lun2sa4"],
["佛蘭芒語","fo2lan2mang2yu3"]
],
"作":[
["作为","zuo4wei2"],
["作主","zuo4zhu3"],
["作保","zuo4bao3"],
["作假","zuo4jia3"],
["作准","zuo4zhun3"],
["作古","zuo4gu3"],
["作品","zuo4pin3"],
["作响","zuo4xiang3"],
["作坊","zuo1fang5"],
["作妥","zuo4tuo3"],
["作手","zuo4shou3"],
["作料","zuo2liao5"],
["作曲","zuo4qu3"],
["作死","zuo1si3"],
["作法","zuo4fa3"],
["作準","zuo4zhun3"],
["作為","zuo4wei2"],
["作罢","zuo4ba4"],
["作罷","zuo4ba4"],
["作者","zuo4zhe3"],
["作響","zuo4xiang3"],
["作馬","zuo4ma3"],
["作马","zuo4ma3"],
["作不來","zuo4bu5lai2"],
["作不来","zuo4bu5lai2"],
["作不了主","zuo4bu5liao3zhu3"]
],
"你":[
["你好","ni3hao3"],
["你得","ni3dei3"],
["你等","ni3deng3"],
["你老","ni3lao3"],
["你得上","ni3de2shang4"],
["你得中","ni3de2zhong4"],
["你得主","ni3de2zhu3"],
["你得了","ni3de2le5"],
["你得享","ni3de2xiang3"],
["你得人","ni3de2ren2"],
["你得令","ni3de2ling4"],
["你得以","ni3de2yi3"],
["你得体","ni3de2ti3"],
["你得來","ni3de2lai2"],
["你得便","ni3de2bian4"],
["你得出","ni3de2chu1"],
["你得分","ni3de2fen1"],
["你得到","ni3de2dao4"],
["你得力","ni3de2li4"],
["你得劲","ni3de2jin4"],
["你得势","ni3de2shi4"],
["你得勁","ni3de2jin4"],
["你得勝","ni3de2sheng4"],
["你得勢","ni3de2shi4"],
["你得名","ni3de2ming2"],
["你得君","ni3de2jun1"],
["你得听","ni3de2ting1"],
["你得味","ni3de2wei4"],
["你得喜","ni3de2xi3"],
["你得失","ni3de2shi1"],
["你得奖","ni3de2jiang3"],
["你得子","ni3de2zi3"],
["你得宜","ni3de2yi2"],
["你得实","ni3de2shi2"],
["你得宠","ni3de2chong3"],
["你得實","ni3de2shi2"],
["你得寵","ni3de2chong3"],
["你得巴","ni3de2ba5"],
["你得年","ni3de2nian2"],
["你得幸","ni3de2xing4"],
["你得当","ni3de2dang4"],
["你得彩","ni3de2cai3"],
["你得很","ni3de5hen3"],
["你得得","ni3de2de2"],
["你得志","ni3de2zhi4"],
["你得悉","ni3de2xi1"],
["你得意","ni3de2yi4"],
["你得所","ni3de2suo3"],
["你得手","ni3de2shou3"],
["你得撒","ni3de2sa1"],
["你得救","ni3de2jiu4"],
["你得数","ni3de2shu4"],
["你得數","ni3de2shu4"],
["你得文","ni3de2wen2"],
["你得时","ni3de2shi2"],
["你得時","ni3de2shi2"],
["你得来","ni3de2lai2"],
["你得标","ni3de2biao1"],
["你得榮","ni3de2rong2"],
["你得標","ni3de2biao1"],
["你得民","ni3de2min2"],
["你得法","ni3de2fa3"],
["你得獎","ni3de2jiang3"],
["你得率","ni3de2lv4"],
["你得瑕","ni3de2xia2"],
["你得用","ni3de2yong4"],
["你得當","ni3de2dang4"],
["你得病","ni3de2bing4"],
["你得益","ni3de2yi4"],
["你得着","ni3de2zhao2"],
["你得知","ni3de2zhi1"],
["你得神","ni3de2shen2"],
["你得票","ni3de2piao4"],
["你得空","ni3de2kong4"],
["你得窍","ni3de2qiao4"],
["你得竅","ni3de2qiao4"],
["你得策","ni3de2ce4"],
["你得粮","ni3de2liang2"],
["你得糧","ni3de2liang2"],
["你得繼","ni3de2ji4"],
["你得继","ni3de2ji4"],
["你得罪","ni3de2zui5"],
["你得职","ni3de2zhi2"],
["你得職","ni3de2zhi2"],
["你得聽","ni3de2ting1"],
["你得胜","ni3de2sheng4"],
["你得脸","ni3de2lian3"],
["你得臉","ni3de2lian3"],
["你得自","ni3de2zi4"],
["你得色","ni3de2se4"],
["你得荣","ni3de2rong2"],
["你得著","ni3de2zhao2"],
["你得計","ni3de2ji4"],
["你得證","ni3de2zheng4"],
["你得计","ni3de2ji4"],
["你得证","ni3de2zheng4"],
["你得逞","ni3de2cheng3"],
["你得道","ni3de2dao4"],
["你得閑","ni3de2xian2"],
["你得間","ni3de2jian4"],
["你得闲","ni3de2xian2"],
["你得间","ni3de2jian4"],
["你得非","ni3de2fei1"],
["你得體","ni3de2ti3"],
["你得不到","ni3de2bu5dao4"],
["你得不着","ni3de2bu5zhao2"],
["你得不著","ni3de2bu5zhao2"],
["你得人儿","ni3de2ren2r5"],
["你得便儿","ni3de2bian4r5"],
["你得便宜","ni3de2pian2yi5"],
["你得劲儿","ni3de2jin4r5"],
["你得天下","ni3de2tian1xia4"],
["你得数儿","ni3de2shu4r5"],
["你得样儿","ni3de2yang4r5"],
["你得樣兒","ni3de2yang4r5"],
["你得益处","ni3de2yi4chu5"],
["你得益處","ni3de2yi4chu5"],
["你得空儿","ni3de2kong4r5"],
["你得罪人","ni3de2zui4ren2"]
],
"佣":[
["佣金","yong4jin1"],
["佣人领班","yong4ren5ling3ban1"]
],
"佩":[
["佩服","pei4fu5"],
["佩魯賈","pei4lu3jia3"],
["佩鲁贾","pei4lu3jia3"]
],
"佳":[
["佳港","jia1gang3"],
["佳美","jia1mei3"]
],
"使":[
["使唤","shi3huan5"],
["使喚","shi3huan5"],
["使女","shi3nv3"],
["使盡","shi3jin4"],
["使者","shi3zhe3"],
["使酒","shi3jiu3"],
["使館","shi3guan3"],
["使馆","shi3guan3"],
["使不上","shi3bu5shang4"],
["使不了","shi3bu5liao3"],
["使不得","shi3bu5de5"],
["使不惯","shi3bu5guan4"],
["使不慣","shi3bu5guan4"],
["使得上","shi3de5shang4"],
["使溺死","shi3ni4si3"],
["使徒行传","shi3tu2xing2zhuan4"],
["使徒行傳","shi3tu2xing2zhuan4"]
],
"侄":[
["侄儿","zhi2r5"],
["侄女","zhi2nv3"],
["侄女婿","zhi2nv3xu5"],
["侄媳妇","zhi2xi2fu5"],
["侄媳婦","zhi2xi2fu5"]
],
"來":[
["來使","lai2shi3"],
["來往","lai2wang3"],
["來火","lai2huo3"],
["來者","lai2zhe3"],
["來訪","lai2fang3"],
["來不及","lai2bu5ji2"],
["來不得","lai2bu5de5"],
["來回來去","lai2hui2lai2qu4"],
["來路不明","lai2lu5bu4ming2"]
],
"例":[
["例假","li4jia4"],
["例語","li4yu3"],
["例语","li4yu3"]
],
"侍":[
["侍女","shi4nv3"],
["侍者","shi4zhe3"],
["侍卫长","shi4wei4zhang3"],
["侍衛長","shi4wei4zhang3"]
],
"侗":[
["侗族","dong4zu2"]
],
"供":[
["供养","gong1yang3"],
["供品","gong4pin3"],
["供奉","gong4feng4"],
["供应","gong1ying4"],
["供應","gong1ying4"],
["供水","gong1shui3"],
["供物","gong4wu4"],
["供給","gong1ji3"],
["供给","gong1ji3"],
["供职","gong4zhi2"],
["供職","gong4zhi2"],
["供認","gong4ren4"],
["供认","gong4ren4"],
["供養","gong1yang3"],
["供应商","gong1ying1shang1"],
["供應商","gong1ying1shang1"],
["供不应求","gong1bu2ying4qiu2"],
["供不應求","gong1bu2ying4qiu2"]
],
"依":[
["依属","yi1shu3"],
["依屬","yi1shu3"],
["依法","yi1fa3"],
["依不得","yi1bu5de5"],
["依地酸二鈷","yi1di4suan1er4gu3"],
["依地酸二钴","yi1di4suan1er4gu3"]
],
"侦":[
["侦缉","zhen1ji1"]
],
"侧":[
["侧耳","ce4er3"],
["侧躺","ce4tang3"]
],
"侮":[
["侮辱","wu3ru3"]
],
"侯":[
["侯馬","hou2ma3"],
["侯马","hou2ma3"]
],
"侵":[
["侵扰","qin1rao3"],
["侵擾","qin1rao3"],
["侵晨","qin1chen2"]
],
"便":[
["便便","pian2pian2"],
["便宜","bian4yi2"],
["便当","bian4dang5"],
["便於","bian4yu2"],
["便桶","bian4tong3"],
["便當","bian4dang5"],
["便血","bian4xie3"],
["便覽","bian4lan3"],
["便览","bian4lan3"],
["便难","bian4nan4"],
["便難","bian4nan4"],
["便宜貨","pian2yi5huo4"],
["便宜货","pian2yi5huo4"]
],
"係":[
["係小","xi4xiao3"]
],
"促":[
["促使","cu4shi3"],
["促請","cu4qing3"],
["促请","cu4qing3"]
],
"俄":[
["俄斐","e2fei3"],
["俄語","e2yu3"],
["俄语","e2yu3"],
["俄備得","e2bei4de2"],
["俄备得","e2bei4de2"],
["俄巴路","e2ba1lu4"],
["俄得尼","e2de2ni2"],
["俄珥巴","e2er3ba1"],
["俄巴底亚","e2ba1di3ya4"],
["俄巴底亞","e2ba1di3ya4"]
],
"俊":[
["俊美","jun4mei3"],
["俊雅","jun4ya3"]
],
"俏":[
["俏皮","qiao4pi5"]
],
"俗":[
["俗气","su2qi5"],
["俗氣","su2qi5"],
["俗語","su2yu3"],
["俗语","su2yu3"]
],
"俘":[
["俘虏","fu2lu3"],
["俘虜","fu2lu3"]
],
"俚":[
["俚語","li3yu3"],
["俚语","li3yu3"]
],
"保":[
["保人","bao3ren5"],
["保养","bao3yang3"],
["保姆","bao3mu3"],
["保守","bao3shou3"],
["保尔","bao3er3"],
["保底","bao3di3"],
["保有","bao3you3"],
["保本","bao3ben3"],
["保爾","bao3er3"],
["保管","bao3guan3"],
["保角","bao3jiao3"],
["保語","bao3yu3"],
["保语","bao3yu3"],
["保長","bao3zhang3"],
["保长","bao3zhang3"],
["保险","bao3xian3"],
["保險","bao3xian3"],
["保養","bao3yang3"],
["保不住","bao3bu5zhu4"],
["保不定","bao3bu5ding4"],
["保不齊","bao3bu5qi2"],
["保不齐","bao3bu5qi2"]
],
"信":[
["信仰","xin4yang3"],
["信使","xin4shi3"],
["信守","xin4shou3"],
["信宜","xin4yi2"],
["信差","xin4chai1"],
["信息","xin4xi1"],
["信笔","xin4bi3"],
["信筆","xin4bi3"],
["信管","xin4guan3"],
["信紙","xin4zhi3"],
["信纸","xin4zhi3"],
["信不來","xin4bu5lai2"],
["信不及","xin4bu5ji2"],
["信不得","xin4bu5de5"],
["信不来","xin4bu5lai2"],
["信得來","xin4de5lai2"],
["信得来","xin4de5lai2"]
],
"俭":[
["俭朴","jian3pu3"]
],
"修":[
["修养","xiu1yang3"],
["修剪","xiu1jian3"],
["修女","xiu1nv3"],
["修好","xiu1hao3"],
["修改","xiu1gai3"],
["修整","xiu1zheng3"],
["修武","xiu1wu3"],
["修水","xiu1shui3"],
["修理","xiu1li3"],
["修脚","xiu1jiao3"],
["修腳","xiu1jiao3"],
["修补","xiu1bu3"],
["修補","xiu1bu3"],
["修養","xiu1yang3"],
["修指甲","xiu1zhi3jia3"],
["修补匠","xiu1bu3jiang4"],
["修補匠","xiu1bu3jiang4"],
["修鞋匠","xiu1xie2jiang4"],
["修短得中","xiu1duan3de2zhong1"]
],
"俯":[
["俯首","fu3shou3"]
],
"俾":[
["俾使","bi3shi3"]
],
"倉":[
["倉儲","cang1chu3"],
["倉頡","cang1jie2"],
["倉鼠","cang1shu3"]
],
"個":[
["個中","ge4zhong1"],
["個人","ge4ren2"],
["個位","ge4wei4"],
["個例","ge4li4"],
["個個","ge4ge4"],
["個兒","ge4r5"],
["個別","ge4bie2"],
["個子","ge4zi5"],
["個展","ge4zhan3"],
["個性","ge4xing4"],
["個把","ge4ba3"],
["個案","ge4an4"],
["個股","ge4gu3"],
["個舊","ge4jiu4"],
["個頭","ge4tou2"],
["個體","ge4ti3"]
],
"倍":[
["倍塔","bei4ta3"]
],
"們":[
["們得","men5dei3"],
["們得上","men5de2shang4"],
["們得中","men5de2zhong4"],
["們得主","men5de2zhu3"],
["們得了","men5de2le5"],
["們得享","men5de2xiang3"],
["們得人","men5de2ren2"],
["們得令","men5de2ling4"],
["們得以","men5de2yi3"],
["們得体","men5de2ti3"],
["們得來","men5de2lai2"],
["們得便","men5de2bian4"],
["們得出","men5de2chu1"],
["們得分","men5de2fen1"],
["們得到","men5de2dao4"],
["們得力","men5de2li4"],
["們得劲","men5de2jin4"],
["們得势","men5de2shi4"],
["們得勁","men5de2jin4"],
["們得勝","men5de2sheng4"],
["們得勢","men5de2shi4"],
["們得名","men5de2ming2"],
["們得君","men5de2jun1"],
["們得听","men5de2ting1"],
["們得味","men5de2wei4"],
["們得喜","men5de2xi3"],
["們得失","men5de2shi1"],
["們得奖","men5de2jiang3"],
["們得子","men5de2zi3"],
["們得宜","men5de2yi2"],
["們得实","men5de2shi2"],
["們得宠","men5de2chong3"],
["們得實","men5de2shi2"],
["們得寵","men5de2chong3"],
["們得巴","men5de2ba5"],
["們得年","men5de2nian2"],
["們得幸","men5de2xing4"],
["們得当","men5de2dang4"],
["們得彩","men5de2cai3"],
["們得很","men5de5hen3"],
["們得得","men5de2de2"],
["們得志","men5de2zhi4"],
["們得悉","men5de2xi1"],
["們得意","men5de2yi4"],
["們得所","men5de2suo3"],
["們得手","men5de2shou3"],
["們得撒","men5de2sa1"],
["們得救","men5de2jiu4"],
["們得数","men5de2shu4"],
["們得數","men5de2shu4"],
["們得文","men5de2wen2"],
["們得时","men5de2shi2"],
["們得時","men5de2shi2"],
["們得来","men5de2lai2"],
["們得标","men5de2biao1"],
["們得榮","men5de2rong2"],
["們得標","men5de2biao1"],
["們得民","men5de2min2"],
["們得法","men5de2fa3"],
["們得獎","men5de2jiang3"],
["們得率","men5de2lv4"],
["們得瑕","men5de2xia2"],
["們得用","men5de2yong4"],
["們得當","men5de2dang4"],
["們得病","men5de2bing4"],
["們得益","men5de2yi4"],
["們得着","men5de2zhao2"],
["們得知","men5de2zhi1"],
["們得神","men5de2shen2"],
["們得票","men5de2piao4"],
["們得空","men5de2kong4"],
["們得窍","men5de2qiao4"],
["們得竅","men5de2qiao4"],
["們得策","men5de2ce4"],
["們得粮","men5de2liang2"],
["們得糧","men5de2liang2"],
["們得繼","men5de2ji4"],
["們得继","men5de2ji4"],
["們得罪","men5de2zui5"],
["們得职","men5de2zhi2"],
["們得職","men5de2zhi2"],
["們得聽","men5de2ting1"],
["們得胜","men5de2sheng4"],
["們得脸","men5de2lian3"],
["們得臉","men5de2lian3"],
["們得自","men5de2zi4"],
["們得色","men5de2se4"],
["們得荣","men5de2rong2"],
["們得著","men5de2zhao2"],
["們得計","men5de2ji4"],
["們得證","men5de2zheng4"],
["們得计","men5de2ji4"],
["們得证","men5de2zheng4"],
["們得逞","men5de2cheng3"],
["們得道","men5de2dao4"],
["們得閑","men5de2xian2"],
["們得間","men5de2jian4"],
["們得闲","men5de2xian2"],
["們得间","men5de2jian4"],
["們得非","men5de2fei1"],
["們得體","men5de2ti3"],
["們得不到","men5de2bu5dao4"],
["們得不着","men5de2bu5zhao2"],
["們得不著","men5de2bu5zhao2"],
["們得人儿","men5de2ren2r5"],
["們得便儿","men5de2bian4r5"],
["們得便宜","men5de2pian2yi5"],
["們得劲儿","men5de2jin4r5"],
["們得天下","men5de2tian1xia4"],
["們得数儿","men5de2shu4r5"],
["們得样儿","men5de2yang4r5"],
["們得樣兒","men5de2yang4r5"],
["們得益处","men5de2yi4chu5"],
["們得益處","men5de2yi4chu5"],
["們得空儿","men5de2kong4r5"],
["們得罪人","men5de2zui4ren2"]
],
"倒":[
["倒下","dao3xia4"],
["倒仓","dao3cang1"],
["倒伏","dao3fu2"],
["倒休","dao3xiu1"],
["倒位","dao3wei4"],
["倒倉","dao3cang1"],
["倒卖","dao3mai4"],
["倒卧","dao3wo4"],
["倒台","dao3tai2"],
["倒噍","dao3jiao4"],
["倒嚼","dao3jiao4"],
["倒地","dao3di4"],
["倒坍","dao3tan1"],
["倒塌","dao3ta1"],
["倒头","dao3tou2"],
["倒好","dao4hao3"],
["倒弄","dao3nong5"],
["倒彩","dao4cai3"],
["倒影","dao4ying3"],
["倒戈","dao3ge1"],
["倒手","dao3shou3"],
["倒把","dao3ba3"],
["倒换","dao3huan4"],
["倒換","dao3huan4"],
["倒敗","dao3bai4"],
["倒数","dao4shu3"],
["倒數","dao4shu3"],
["倒斃","dao3bi4"],
["倒是","dao4shi5"],
["倒替","dao3ti4"],
["倒有","dao4you3"],
["倒槽","dao3cao2"],
["倒毙","dao3bi4"],
["倒满","dao4man3"],
["倒滿","dao4man3"],
["倒灶","dao3zao4"],
["倒爷","dao3ye2"],
["倒爺","dao3ye2"],
["倒班","dao3ban1"],
["倒相","dao4xiang4"],
["倒腾","dao3teng5"],
["倒臥","dao3wo4"],
["倒臺","dao3tai2"],
["倒茬","dao3cha2"],
["倒蛋","dao3dan4"],
["倒賣","dao3mai4"],
["倒賬","dao3zhang4"],
["倒败","dao3bai4"],
["倒账","dao3zhang4"],
["倒車","dao3che1"],
["倒轉","dao4zhuan3"],
["倒车","dao3che1"],
["倒转","dao4zhuan3"],
["倒运","dao3yun4"],
["倒運","dao3yun4"],
["倒鎖","dao4suo3"],
["倒锁","dao4suo3"],
["倒閉","dao3bi4"],
["倒闭","dao3bi4"],
["倒霉","dao3mei2"],
["倒頭","dao3tou2"],
["倒騰","dao3teng5"],
["倒不了","dao3bu5liao3"],
["倒不如","dao4bu5ru2"],
["倒不开","dao3bu5kai1"],
["倒不開","dao3bu5kai1"],
["倒出來","dao3chu1lai2"],
["倒出来","dao3chu1lai2"],
["倒胃口","dao3wei4kou5"],
["倒計時","dao3ji4shi2"],
["倒计时","dao3ji4shi2"],
["倒車擋","dao4che1dang3"],
["倒车挡","dao4che1dang3"],
["倒过儿","dao4guo5r5"],
["倒過兒","dao4guo5r5"],
["倒不过来","dao3bu5guo4lai5"],
["倒不過來","dao3bu5guo4lai5"],
["倒买倒卖","dao3mai3dao3mai4"],
["倒打一耙","dao4da3yi4pa2"],
["倒果为因","dao4guo3wei2yin1"],
["倒果為因","dao4guo3wei2yin1"],
["倒海翻江","dao3hai3fan1jiang1"],
["倒背手儿","dao4bei4shou3r5"],
["倒買倒賣","dao3mai3dao3mai4"]
],
"倔":[
["倔強","jue2jiang4"],
["倔强","jue2jiang4"]
],
"候":[
["候审","hou4shen3"],
["候審","hou4shen3"],
["候补","hou4bu3"],
["候補","hou4bu3"],
["候診","hou4zhen3"],
["候诊","hou4zhen3"],
["候选","hou4xuan3"],
["候選","hou4xuan3"],
["候鳥","hou4niao3"],
["候鸟","hou4niao3"]
],
"借":[
["借以","jie4yi3"],
["借取","jie4qu3"],
["借口","jie4kou3"],
["借款","jie4kuan3"],
["借此","jie4ci3"],
["借火","jie4huo3"],
["借給","jie4gei3"],
["借给","jie4gei3"],
["借单儿","jie4dan1r5"],
["借字儿","jie4zi4r5"],
["借花献佛","jie4hua1xian4fo2"],
["借花獻佛","jie4hua1xian4fo2"]
],
"倡":[
["倡导","chang4dao3"],
["倡導","chang4dao3"]
],
"倩":[
["倩影","qian4ying3"]
],
"倫":[
["倫巴","lun2ba1"],
["倫理","lun2li3"]
],
"债":[
["债主","zhai4zhu3"],
["债务","zhai4wu4"],
["债款","zhai4kuan3"]
],
"倾":[
["倾倒","qing1dao3"],
["倾吐","qing1tu3"],
["倾耳","qing1er3"],
["倾角","qing1jiao3"],
["倾诉","qing1su4"],
["倾箱倒箧","qing1xiang1dao3qie4"]
],
"假":[
["假使","jia3shi3"],
["假发","jia3fa4"],
["假想","jia3xiang3"],
["假手","jia3shou3"],
["假扮","jia3ban4"],
["假拱","jia3gong3"],
["假日","jia4ri4"],
["假期","jia4qi1"],
["假条","jia4tiao2"],
["假條","jia4tiao2"],
["假死","jia3si3"],
["假腿","jia3tui3"],
["假性近視","jia3xing4jin4shi4"],
["假性近视","jia3xing4jin4shi4"]
],
"偉":[
["偉績","wei3ji4"],
["偉舉","wei3ju3"]
],
"偏":[
["偏好","pian1hao4"],
["偏差","pian1cha1"],
["偏袒","pian1tan3"],
["偏轉","pian1zhuan3"],
["偏转","pian1zhuan3"],
["偏远","pian1yuan3"],
["偏遠","pian1yuan3"]
],
"做":[
["做为","zuo4wei2"],
["做主","zuo4zhu3"],
["做作","zuo4zuo5"],
["做好","zuo4hao3"],
["做小","zuo4xiao3"],
["做得","zuo4de2"],
["做手","zuo4shou3"],
["做水","zuo4shui3"],
["做法","zuo4fa3"],
["做為","zuo4wei2"],
["做盡","zuo4jin4"],
["做眼","zuo4yan3"],
["做脸","zuo4lian3"],
["做臉","zuo4lian3"],
["做起","zuo4qi3"],
["做鬼","zuo4gui3"],
["做不下","zuo4bu5xia4"],
["做不了","zuo4bu5liao3"],
["做不到","zuo4bu5dao4"],
["做不好","zuo4bu5hao3"],
["做不完","zuo4bu5wan2"],
["做不得","zuo4bu5de5"],
["做不成","zuo4bu5cheng2"],
["做买卖","zuo4mai3mai5"],
["做人家","zuo4ren2jia1"],
["做伴儿","zuo4ban4r5"],
["做得到","zuo4de5dao4"],
["做得完","zuo4de5wan2"],
["做買賣","zuo4mai3mai5"],
["做得过分","zuo4de5guo4fen5"],
["做得過分","zuo4de5guo4fen5"]
],
"停":[
["停产","ting2chan3"],
["停手","ting2shou3"],
["停止","ting2zhi3"],
["停泊","ting2bo2"],
["停火","ting2huo3"],
["停產","ting2chan3"],
["停下來","ting2xia4lai2"],
["停下来","ting2xia4lai2"],
["停車位置","ting2che1wei4zhi4"],
["停车位置","ting2che1wei4zhi4"],
["停頓下來","ting2dun4xia4lai2"],
["停顿下来","ting2dun4xia4lai2"]
],
"健":[
["健美","jian4mei3"],
["健診","jian4zhen3"],
["健诊","jian4zhen3"]
],
"側":[
["側耳","ce4er3"],
["側躺","ce4tang3"]
],
"偵":[
["偵緝","zhen1ji1"]
],
"偶":[
["偶尔","ou3er3"],
["偶爾","ou3er3"],
["偶一不慎","ou3yi2bu2shen4"],
["偶一为之","ou3yi4wei2zhi1"],
["偶一為之","ou3yi4wei2zhi1"]
],
"偷":[
["偷懒","tou1lan3"],
["偷懶","tou1lan3"],
["偷偷摸摸","tou1tou1mo1mo1"],
["偷雞不著蝕把米","tou1ji1bu4zhao2shi2ba3mi3"],
["偷鸡不着蚀把米","tou1ji1bu4zhao2shi2ba3mi3"]
],
"偽":[
["偽頂","wei3ding3"]
],
"偿":[
["偿还","chang2huan2"]
],
"傅":[
["傅說","fu4shuo1"],
["傅说","fu4shuo1"],
["傅作义","fu4zuo4yi4"],
["傅作義","fu4zuo4yi4"],
["傅佳敏","fu4jia1min3"],
["傅科摆","fu4ke1bai3"],
["傅科擺","fu4ke1bai3"],
["傅立叶","fu4li4ye4"],
["傅立葉","fu4li4ye4"],
["傅里叶","fu4li3ye4"],
["傅里葉","fu4li3ye4"]
],
"傍":[
["傍午","bang4wu3"],
["傍晚","bang4wan3"],
["傍家儿","bang4jia1r5"]
],
"傑":[
["傑夫","jie2fu1"],
["傑米","jie2mi3"],
["傑佛茲","jie2fo2zi1"]
],
"備":[
["備取","bei4qu3"],
["備品","bei4pin3"],
["備抵","bei4di3"],
["備有","bei4you3"],
["備考","bei4kao3"],
["備於萬一","bei4yu2wan4yi1"]
],
"傢":[
["傢伙","jia1huo5"]
],
"傧":[
["傧相","bin1xiang4"]
],
"储":[
["储水","chu3shui3"]
],
"催":[
["催乳","cui1ru3"],
["催产","cui1chan3"],
["催吐","cui1tu4"],
["催奶","cui1nai3"],
["催產","cui1chan3"],
["催討","cui1tao3"],
["催讨","cui1tao3"],
["催谷","cui1gu3"],
["催赶","cui1gan3"],
["催趕","cui1gan3"],
["催眠曲","cui1mian2qu3"]
],
"傭":[
["傭兵","yong1bing1"],
["傭工","yong1gong1"],
["傭人領班","yong4ren5ling3ban1"]
],
"傲":[
["傲骨","ao4gu3"]
],
"傳":[
["傳寄","chuan3ji4"],
["傳寫","chuan2xie3"],
["傳導","chuan2dao3"],
["傳感","chuan2gan3"],
["傳本","chuan2ben3"],
["傳染","chuan2ran3"],
["傳略","zhuan4lve4"],
["傳種","chuan2zhong3"],
["傳粉","chuan2fen3"],
["傳給","chuan2gei5"],
["傳統","chuan2tong3"],
["傳記","zhuan4ji4"],
["傳語","chuan2yu3"],
["傳講","chuan2jiang3"],
["傳贊","zhuan4zan4"]
],
"債":[
["債主","zhai4zhu3"],
["債務","zhai4wu4"],
["債款","zhai4kuan3"]
],
"傷":[
["傷口","shang1kou3"],
["傷感","shang1gan3"],
["傷者","shang1zhe3"],
["傷耗","shang1hao5"]
],
"傻":[
["傻气","sha3qi5"],
["傻氣","sha3qi5"],
["傻眼","sha3yan3"],
["傻乎乎","sha3hu1hu1"],
["傻不楞登","sha3bu5leng1deng1"]
],
"傾":[
["傾倒","qing1dao3"],
["傾吐","qing1tu3"],
["傾耳","qing1er3"],
["傾角","qing1jiao3"],
["傾訴","qing1su4"],
["傾向於","qing1xiang4yu2"],
["傾箱倒篋","qing1xiang1dao3qie4"]
],
"僅":[
["僅僅","jin3jin3"],
["僅有","jin3you3"],
["僅次於","jin3ci4yu2"]
],
"像":[
["像儿","xiang4r5"],
["像片","xiang4pian1"],
["像片簿","xiang4pian4bu4"]
],
"僧":[
["僧侣","seng1lv3"],
["僧侶","seng1lv3"]
],
"僭":[
["僭主","jian4zhu3"]
],
"僱":[
["僱主","gu4zhu3"],
["僱傭","gu4yong1"]
],
"價":[
["價款","jia4kuan3"],
["價錢","jia4qian5"]
],
"儀":[
["儀典","yi2dian3"],
["儀禮","yi2li3"],
["儀表","yi2biao3"],
["儀隴","yi2long3"]
],
"儉":[
["儉樸","jian3pu3"]
],
"儐":[
["儐相","bin1xiang4"]
],
"儒":[
["儒者","ru2zhe5"]
],
"儘":[
["儘管","jin3guan3"]
],
"償":[
["償還","chang2huan2"]
],
"優":[
["優於","you1yu2"],
["優格","you1ge1"],
["優等","you1deng3"],
["優美","you1mei3"],
["優雅","you1ya3"],
["優點","you1dian3"]
],
"儲":[
["儲水","chu3shui3"]
],
"儿":[
["儿女","er2nv3"],
["儿媳妇","er2xi2fu5"],
["儿女英雄传","er2nv3ying1xiong2zhuan4"]
],
"允":[
["允准","yun3zhun3"],
["允宜","yun3yi2"],
["允当","yun3dang4"],
["允準","yun3zhun3"],
["允當","yun3dang4"],
["允許","yun3xu3"],
["允许","yun3xu3"]
],
"元":[
["元史","yuan2shi3"],
["元曲","yuan2qu3"],
["元朗","yuan2lang3"],
["元老","yuan2lao3"],
["元首","yuan2shou3"]
],
"兄":[
["兄長","xiong1zhang3"],
["兄长","xiong1zhang3"]
],
"充":[
["充分","chong1fen4"],
["充塞","chong1se4"],
["充好","chong1hao3"],
["充氧","chong1yang3"],
["充满","chong1man3"],
["充滿","chong1man3"],
["充不了","chong1bu5liao3"]
],
"兆":[
["兆头","zhao4tou5"],
["兆瓦","zhao4wa3"],
["兆頭","zhao4tou5"]
],
"兇":[
["兇手","xiong1shou3"],
["兇死","xiong1si3"],
["兇狠","xiong1hen3"],
["兇猛","xiong1meng3"],
["兇相","xiong1xiang4"],
["兇险","xiong1xian3"],
["兇險","xiong1xian3"]
],
"先":[
["先妣","xian1bi3"],
["先导","xian1dao3"],
["先導","xian1dao3"],
["先生","xian1sheng5"],
["先祖","xian1zu3"],
["先走","xian1zou3"],
["先王之乐","xian1wang2zhi1yue4"],
["先王之樂","xian1wang2zhi1yue4"],
["先睹为快","xian1du3wei2kuai4"],
["先睹為快","xian1du3wei2kuai4"],
["先下手为强","xian1xia4shou3wei2qiang2"],
["先下手為強","xian1xia4shou3wei2qiang2"],
["先到灶头先得食","xian1dao4zao4tou5xian1de2shi2"],
["先到灶頭先得食","xian1dao4zao4tou5xian1de2shi2"]
],
"光":[
["光子","guang1zi3"],
["光彩","guang1cai3"],
["光景","guang1jing3"],
["光润","guang1run5"],
["光溜","guang1liu5"],
["光滑","guang1hua5"],
["光潤","guang1run5"],
["光笔","guang1bi3"],
["光筆","guang1bi3"],
["光纜","guang1lan3"],
["光缆","guang1lan3"],
["光脚","guang1jiao3"],
["光腳","guang1jiao3"],
["光譜","guang1pu3"],
["光谱","guang1pu3"],
["光棍儿","guang1gun4r5"],
["光不出溜儿","guang1bu5chu5liu1r5"],
["光不出溜兒","guang1bu5chu5liu1r5"]
],
"克":[
["克己","ke4ji3"],
["克朗","ke4lang3"],
["克架","kei1jia4"],
["克罗巴","ke4luo2ba1"],
["克羅巴","ke4luo2ba1"],
["克蕾儿","ke4lei3r5"],
["克什克腾","ke4shi2ke4teng2"],
["克什克騰","ke4shi2ke4teng2"],
["克什米尔","ke4shi2mi3er3"],
["克什米爾","ke4shi2mi3er3"],
["克利夫兰","ke4li4fu1lan2"],
["克利夫蘭","ke4li4fu1lan2"],
["克拉科夫","ke4la1ke1fu1"],
["克罗地亚","ke4luo2di4ya4"],
["克羅地亞","ke4luo2di4ya4"],
["克裡米亞","ke4li3mi3ya4"],
["克利斯朵夫","ke4li4si1duo3fu1"],
["克裡姆林宮","ke4li3mu3lin2gong1"],
["克裡木半島","ke4li3mu4ban4dao3"],
["克裡絲蒂娃","ke4li3si1di4wa2"]
],
"兒":[
["兒化","er2hua4"],
["兒女","er2nv3"],
["兒媳","er2xi2"],
["兒子","er2zi5"],
["兒孫","er2sun1"],
["兒歌","er2ge1"],
["兒科","er2ke1"],
["兒童","er2tong2"],
["兒媳婦","er2xi2fu5"],
["兒女英雄傳","er2nv3ying1xiong2zhuan4"]
],
"党":[
["党务","dang3wu4"],
["党参","dang3shen1"],
["党史","dang3shi3"],
["党委","dang3wei3"],
["党组","dang3zu3"],
["党羽","dang3yu3"]
],
"兜":[
["兜儿","dou1r5"],
["兜兜","dou1dou5"],
["兜肚","dou1du5"],
["兜头一拳","dou1tou2yi4quan2"],
["兜頭一拳","dou1tou2yi4quan2"]
],
"入":[
["入伍","ru4wu3"],
["入伙","ru4huo3"],
["入口","ru4kou3"],
["入土","ru4tu3"],
["入地","ru4di4"],
["入手","ru4shou3"],
["入水","ru4shui3"],
["入股","ru4gu3"],
["入选","ru4xuan3"],
["入選","ru4xuan3"],
["入土为安","ru4tu3wei2an1"],
["入土為安","ru4tu3wei2an1"]
],
"內":[
["內務","nei4wu4"],
["內地","nei4di4"],
["內場","nei4chang3"],
["內有","nei4you3"],
["內監","nei4jian4"],
["內碼","nei4ma3"],
["內耳","nei4er3"],
["內蒙","nei4meng3"],
["內行","nei4hang2"],
["內裡","nei4li3"],
["內訌","nei4hong4"],
["內切球","nei4qie1qiu2"],
["內埔鄉","nei4bu4xiang1"],
["內比都","nei4bi3du1"],
["內賈德","nei4jia3de2"],
["內懮外患","nei4you1wai4huan4"]
],
"全":[
["全个","quan2ge4"],
["全体","quan2ti3"],
["全個","quan2ge4"],
["全党","quan2dang3"],
["全地","quan2di4"],
["全场","quan2chang3"],
["全場","quan2chang3"],
["全影","quan2ying3"],
["全景","quan2jing3"],
["全本","quan2ben3"],
["全省","quan2sheng3"],
["全等","quan2deng3"],
["全美","quan2mei3"],
["全體","quan2ti3"],
["全黨","quan2dang3"]
],
"兩":[
["兩廣","liang3guang3"],
["兩手","liang3shou3"],
["兩百","liang3bai3"],
["兩眼","liang3yan3"],
["兩者","liang3zhe3"],
["兩腿","liang3tui3"],
["兩報一刊","liang3bao4yi4kan1"],
["兩定一獎","liang3ding4yi4jiang3"],
["兩得其便","liang3de2qi2bian4"],
["兩手一攤","liang3shou3yi4tan1"],
["兩飽一倒","liang3bao3yi4dao3"],
["兩個或兩個以上","liang3ge4huo4liang3ge4yi3shang4"]
],
"八":[
["八仙","ba1xian1"],
["八只","ba1zhi1"],
["八宝","ba1bao3"],
["八寶","ba1bao3"],
["八百","ba1bai3"],
["八股","ba1gu3"],
["八角","ba1jiao3"],
["八一五","ba1yi4wu3"],
["八一厂","ba1yi4chang3"],
["八一廠","ba1yi4chang3"],
["八行书","ba1hang2shu1"],
["八行書","ba1hang2shu1"],
["八紘一宇","ba1hong2yi4yu3"],
["八纮一宇","ba1hong2yi4yu3"],
["八一建军节","ba1yi2jian4jun1jie2"],
["八一建軍節","ba1yi2jian4jun1jie2"],
["八字沒一撇","ba1zi4mei2yi4pie3"],
["八字没一撇","ba1zi4mei2yi4pie3"],
["八一南昌起义","ba1yi4nan2chang1qi3yi4"],
["八一南昌起義","ba1yi4nan2chang1qi3yi4"],
["八竿子打不着","ba1gan1zi3da3bu5zhao2"],
["八竿子打不著","ba1gan1zi3da3bu5zhao2"],
["八一电影制片厂","ba1yi2dian4ying3zhi4pian4chang3"],
["八一電影制片廠","ba1yi2dian4ying3zhi4pian4chang3"]
],
"公":[
["公两","gong1liang3"],
["公主","gong1zhu3"],
["公亩","gong1mu3"],
["公仔","gong1zi3"],
["公使","gong1shi3"],
["公兩","gong1liang3"],
["公公","gong1gong5"],
["公务","gong1wu4"],
["公務","gong1wu4"],
["公地","gong1di4"],
["公子","gong1zi3"],
["公审","gong1shen3"],
["公家","gong1jia5"],
["公審","gong1shen3"],
["公尺","gong1chi3"],
["公差","gong1cha1"],
["公引","gong1yin3"],
["公斗","gong1dou3"],
["公有","gong1you3"],
["公款","gong1kuan3"],
["公法","gong1fa3"],
["公海","gong1hai3"],
["公演","gong1yan3"],
["公犬","gong1quan3"],
["公理","gong1li3"],
["公畝","gong1mu3"],
["公石","gong1dan4"],
["公秉","gong1bing3"],
["公網","gong1wang3"],
["公网","gong1wang3"],
["公署","gong1shu3"],
["公訴","gong1su4"],
["公诉","gong1su4"],
["公轉","gong1zhuan4"],
["公转","gong1zhuan4"],
["公道","gong1dao5"],
["公里","gong1li3"],
["公頃","gong1qing3"],
["公顷","gong1qing3"],
["公館","gong1guan3"],
["公馆","gong1guan3"],
["公倍数","gong1bei4shu5"],
["公倍數","gong1bei4shu5"],
["公羊传","gong1yang2zhuan4"],
["公羊傳","gong1yang2zhuan4"],
["公諸同好","gong1zhu1tong2hao4"],
["公諸於世","gong1zhu1yu2shi4"],
["公诸同好","gong1zhu1tong2hao4"]
],
"六":[
["六只","liu4zhi1"],
["六百","liu4bai3"],
["六腑","liu4fu3"],
["六合区","lu4he2qu1"],
["六合區","lu4he2qu1"],
["六枝特区","lu4zhi1te4qu1"],
["六枝特區","lu4zhi1te4qu1"],
["六一儿童节","liu4yi4er2tong2jie2"],
["六一兒童節","liu4yi4er2tong2jie2"],
["六一国际儿童节","liu4yi4guo2ji4er2tong2jie2"],
["六一國際兒童節","liu4yi4guo2ji4er2tong2jie2"]
],
"兰":[
["兰塞","lan2sai4"],
["兰考","lan2kao3"],
["兰谱","lan2pu3"]
],
"共":[
["共产","gong4chan3"],
["共享","gong4xiang3"],
["共处","gong4chu3"],
["共有","gong4you3"],
["共產","gong4chan3"],
["共管","gong4guan3"],
["共處","gong4chu3"],
["共識","gong4shi2"],
["共识","gong4shi2"]
],
"关":[
["关上","guan1shang5"],
["关乎","guan1hu1"],
["关卡","guan1qia3"],
["关厂","guan1chang3"],
["关塞","guan1sai4"],
["关岛","guan1dao3"],
["关系","guan1xi5"],
["关羽","guan1yu3"],
["关不严","guan1bu5yan2"],
["关不住","guan1bu5zhu4"],
["关不着","guan1bu5zhao2"]
],
"兴":[
["兴义","xing1yi4"],
["兴亡","xing1wang2"],
["兴仁","xing1ren2"],
["兴兵","xing1bing1"],
["兴办","xing1ban4"],
["兴化","xing1hua4"],
["兴县","xing1xian4"],
["兴和","xing1he2"],
["兴国","xing1guo2"],
["兴城","xing1cheng2"],
["兴奋","xing1fen4"],
["兴宁","xing1ning2"],
["兴安","xing1an1"],
["兴山","xing1shan1"],
["兴平","xing1ping2"],
["兴建","xing1jian4"],
["兴文","xing1wen2"],
["兴旺","xing1wang4"],
["兴海","xing1hai3"],
["兴盛","xing1sheng4"],
["兴荣","xing1rong2"],
["兴衰","xing1shuai1"],
["兴起","xing1qi3"],
["兴隆","xing1long2"],
["兴不开","xing1bu5kai1"],
["兴中会","xing1zhong1hui4"],
["兴业银行","xing1ye4yin2hang2"],
["兴得起来","xing1de5qi3lai5"],
["兴都库仕","xing1du1ku4shi4"],
["兴高彩烈","xing1gao1cai3lie4"],
["兴凯刺鳑鲏","xing1kai3ci4pang2pi2"],
["兴都库什山","xing1du1ku4shi2shan1"]
],
"兵":[
["兵法","bing1fa3"],
["兵痞","bing1pi3"],
["兵种","bing1zhong3"],
["兵種","bing1zhong3"],
["兵蚁","bing1yi3"],
["兵蟻","bing1yi3"],
["兵餉","bing1xiang3"],
["兵饷","bing1xiang3"],
["兵馬","bing1ma3"],
["兵马","bing1ma3"],
["兵敗如山倒","bing1bai4ru2shan1dao3"],
["兵败如山倒","bing1bai4ru2shan1dao3"]
],
"其":[
["其所","qi2suo3"]
],
"具":[
["具体","ju4ti3"],
["具保","ju4bao3"],
["具尔","ju4er3"],
["具有","ju4you3"],
["具爾","ju4er3"],
["具體","ju4ti3"]
],
"典":[
["典礼","dian3li3"],
["典禮","dian3li3"],
["典雅","dian3ya3"],
["典狱长","dian3yu4zhang3"],
["典獄長","dian3yu4zhang3"]
],
"养":[
["养分","yang3fen4"],
["养地","yang3di4"],
["养女","yang3nv3"],
["养子","yang3zi3"],
["养母","yang3mu3"],
["养活","yang3huo5"],
["养老","yang3lao3"],
["养尊处优","yang3zun1chu3you1"]
],
"兼":[
["兼得","jian1de2"]
],
"内":[
["内务","nei4wu4"],
["内地","nei4di4"],
["内场","nei4chang3"],
["内有","nei4you3"],
["内监","nei4jian4"],
["内码","nei4ma3"],
["内耳","nei4er3"],
["内蒙","nei4meng3"],
["内行","nei4hang2"],
["内讧","nei4hong4"],
["内里","nei4li3"],
["内切球","nei4qie1qiu2"],
["内埔乡","nei4bu4xiang1"],
["内比都","nei4bi3du1"],
["内贾德","nei4jia3de2"],
["内懮外患","nei4you1wai4huan4"]
],
"冈":[
["冈本","gang1ben3"]
],
"冉":[
["冉冉","ran3ran3"]
],
"再":[
["再不","zai4bu5"],
["再也","zai4ye3"],
["再好","zai4hao3"],
["再娶","zai4qu3"],
["再审","zai4shen3"],
["再審","zai4shen3"],
["再者","zai4zhe3"],
["再起","zai4qi3"]
],
"冒":[
["冒失","mao4shi5"],
["冒起","mao4qi3"],
["冒险","mao4xian3"],
["冒險","mao4xian3"],
["冒雨","mao4yu3"],
["冒領","mao4ling3"],
["冒领","mao4ling3"],
["冒冒失失","mao4mao5shi1shi1"],
["冒险一试","mao4xian3yi2shi4"],
["冒險一試","mao4xian3yi2shi4"]
],
"写":[
["写法","xie3fa3"],
["写给","xie3gei3"],
["写下来","xie3xia4lai2"],
["写不上","xie3bu5shang4"],
["写不下","xie3bu5xia4"],
["写不出","xie3bu5chu1"],
["写不通","xie3bu5tong1"],
["写出来","xie3chu1lai2"]
],
"军":[
["军务","jun1wu4"],
["军委","jun1wei3"],
["军旅","jun1lv3"],
["军法","jun1fa3"],
["军港","jun1gang3"],
["军演","jun1yan3"],
["军火","jun1huo3"],
["军长","jun1zhang3"]
],
"农":[
["农产","nong2chan3"],
["农地","nong2di4"],
["农场","nong2chang3"],
["农夫","nong2fu1"],
["农舍","nong2she4"]
],
"冠":[
["冠冕","guan1mian3"],
["冠县","guan1xian4"],
["冠子","guan1zi5"],
["冠縣","guan1xian4"],
["冠脈","guan1mai4"],
["冠脉","guan1mai4"],
["冠心病","guan1xin1bing4"],
["冠状动脉","guan1zhuang4dong4mai4"],
["冠狀動脈","guan1zhuang4dong4mai4"]
],
"冤":[
["冤家","yuan1jia5"],
["冤死","yuan1si3"],
["冤苦","yuan1ku3"],
["冤家对头","yuan1jia1dui4tou5"],
["冤家對頭","yuan1jia1dui4tou5"],
["冤家路窄","yuan1jia1lu4zhai3"]
],
"冥":[
["冥想","ming2xiang3"]
],
"冰":[
["冰冷","bing1leng3"],
["冰品","bing1pin3"],
["冰场","bing1chang3"],
["冰場","bing1chang3"],
["冰塔","bing1ta3"],
["冰岛","bing1dao3"],
["冰島","bing1dao3"],
["冰水","bing1shui3"],
["冰点","bing1dian3"],
["冰點","bing1dian3"],
["冰棍儿","bing1gun4r5"],
["冰淇淋","bing1qi5lin2"],
["冰激凌","bing1ji5ling2"],
["冰天雪地","bing1tian1xue3di4"]
],
"冲":[
["冲垮","chong1kua3"],
["冲打","chong1da3"],
["冲洗","chong1xi3"],
["冲着","chong4zhe5"],
["冲走","chong1zou3"]
],
"决":[
["决口","jue2kou3"],
["决一死战","jue2yi4si3zhan4"],
["决一胜负","jue2yi2sheng4fu4"],
["决一雌雄","jue2yi4ci2xiong2"]
],
"况":[
["况且","kuang4qie3"]
],
"冷":[
["冷冷","leng3leng3"],
["冷水","leng3shui3"],
["冷清","leng3qing5"],
["冷眼","leng3yan3"],
["冷語","leng3yu3"],
["冷语","leng3yu3"],
["冷軋","leng3zha2"],
["冷轧","leng3zha2"],
["冷顫","leng3zhan4"],
["冷颤","leng3zhan4"],
["冷飲","leng3yin3"],
["冷饮","leng3yin3"],
["冷不丁","leng3bu5ding1"],
["冷不防","leng3bu5fang2"],
["冷得邪活","leng3de5xie2huo5"],
["冷热度数","leng3re4du4shu4"],
["冷熱度數","leng3re4du4shu4"]
],
"冻":[
["冻土","dong4tu3"],
["冻死","dong4si3"],
["冻雨","dong4yu3"],
["冻不着","dong4bu5zhao2"]
],
"净":[
["净土","jing4tu3"]
],
"凄":[
["凄婉","qi1wan3"],
["凄惋","qi1wan3"],
["凄惨","qi1can3"],
["凄慘","qi1can3"],
["凄梗","qi1geng3"],
["凄楚","qi1chu3"],
["凄苦","qi1ku3"]
],
"准":[
["准将","zhun3jiang4"],
["准得","zhun3dei3"],
["准许","zhun3xu3"],
["准不准","zhun3bu5zhun3"]
],
"凈":[
["凈土","jing4tu3"],
["凈盡","jing4jin4"]
],
"凉":[
["凉快","liang2kuai5"],
["凉水","liang2shui3"],
["凉爽","liang2shuang3"],
["凉在一边","liang4zai4yi4bian1"]
],
"凌":[
["凌晨","ling2chen2"],
["凌海","ling2hai3"],
["凌辱","ling2ru3"]
],
"凍":[
["凍土","dong4tu3"],
["凍死","dong4si3"],
["凍雨","dong4yu3"],
["凍不著","dong4bu5zhao2"]
],
"减":[
["减产","jian3chan3"],
["减免","jian3mian3"],
["减小","jian3xiao3"],
["减少","jian3shao3"],
["减法","jian3fa3"],
["减缓","jian3huan3"]
],
"凑":[
["凑合","cou4he5"],
["凑巧","cou4qiao3"],
["凑手","cou4shou3"],
["凑不上","cou4bu5shang4"]
],
"凛":[
["凛凛","lin3lin3"]
],
"凜":[
["凜凜","lin3lin3"]
],
"几":[
["几丁","ji1ding1"],
["几乎","ji1hu1"],
["几只","ji3zhi1"],
["几希","ji1xi1"],
["几微","ji1wei1"],
["几案","ji1an4"],
["几点","ji1dian3"],
["几率","ji1lv4"],
["几百","ji3bai3"],
["几至","ji1zhi4"],
["几许","ji3xu3"],
["几谏","ji1jian4"],
["几个月","ji3ge4yue4"],
["几点了","ji3dian3le5"],
["几个小时","ji3ge4xiao3shi2"]
],
"凡":[
["凡响","fan2xiang3"],
["凡夫","fan2fu1"],
["凡百","fan2bai3"],
["凡響","fan2xiang3"],
["凡夫俗子","fan2fu1su2zi3"]
],
"凤":[
["凤爪","feng4zhao3"],
["凤仙花","feng4xian1hua1"]
],
"凭":[
["凭倚","ping2yi3"],
["凭准","ping2zhun3"],
["凭险","ping2xian3"]
],
"凯":[
["凯尔","kai3er3"],
["凯里","kai3li3"]
],
"凱":[
["凱爾","kai3er3"],
["凱裡","kai3li3"]
],
"凶":[
["凶党","xiong1dang3"],
["凶手","xiong1shou3"],
["凶死","xiong1si3"],
["凶狠","xiong1hen3"],
["凶猛","xiong1meng3"],
["凶相","xiong1xiang4"],
["凶黨","xiong1dang3"]
],
"凸":[
["凸版","tu1ban3"],
["凸耳","tu1er3"],
["凸起","tu1qi3"]
],
"凹":[
["凹板","ao1ban3"],
["凹版","ao1ban3"]
],
"出":[
["出丑","chu1chou3"],
["出丧","chu1sang1"],
["出乎","chu1hu1"],
["出产","chu1chan3"],
["出使","chu1shi3"],
["出來","chu1lai5"],
["出厂","chu1chang3"],
["出去","chu1qu5"],
["出口","chu1kou3"],
["出品","chu1pin3"],
["出喪","chu1sang1"],
["出土","chu1tu3"],
["出场","chu1chang3"],
["出場","chu1chang3"],
["出差","chu1chai1"],
["出廠","chu1chang3"],
["出息","chu1xi1"],
["出手","chu1shou3"],
["出於","chu1yu2"],
["出来","chu1lai5"],
["出榜","chu1bang3"],
["出水","chu1shui3"],
["出沒","chu1mo4"],
["出没","chu1mo4"],
["出海","chu1hai3"],
["出港","chu1gang3"],
["出溜","chu1liu5"],
["出火","chu1huo3"],
["出版","chu1ban3"],
["出產","chu1chan3"],
["出落","chu1luo5"],
["出訪","chu1fang3"],
["出診","chu1zhen3"],
["出访","chu1fang3"],
["出诊","chu1zhen3"],
["出走","chu1zou3"],
["出軌","chu1gui3"],
["出轨","chu1gui3"],
["出醜","chu1chou3"],
["出险","chu1xian3"],
["出險","chu1xian3"],
["出馬","chu1ma3"],
["出马","chu1ma3"],
["出不了","chu1bu5liao3"],
["出不來","chu1bu5lai2"],
["出不去","chu1bu5qu4"],
["出不来","chu1bu5lai2"],
["出不起","chu1bu5qi3"],
["出主意","chu1zhu3yi4"],
["出圈儿","chu1quan1r5"],
["出尖儿","chu1jian1r5"],
["出洋相","chu1yang2xiang4"],
["出生地","chu1sheng1di4"],
["出人头地","chu1ren2tou2di4"],
["出人頭地","chu1ren2tou2di4"],
["出生日期","chu1sheng1ri4qi1"],
["出一磅子力气","chu1yi2bang4zi5li4qi5"],
["出一磅子力氣","chu1yi2bang4zi5li4qi5"]
],
"击":[
["击中","ji1zhong4"],
["击倒","ji1dao3"],
["击打","ji1da3"],
["击掌","ji1zhang3"],
["击毁","ji1hui3"],
["击鼓","ji1gu3"]
],
"凿":[
["凿井","zao2jing3"]
],
"刀":[
["刀俎","dao1zu3"],
["刀口","dao1kou3"],
["刀把","dao1ba4"]
],
"刁":[
["刁难","diao1nan4"],
["刁難","diao1nan4"]
],
"分":[
["分为","fen1wei2"],
["分享","fen1xiang3"],
["分內","fen4nei4"],
["分内","fen4nei4"],
["分叉","fen1cha4"],
["分外","fen4wai4"],
["分娩","fen1mian3"],
["分子","fen4zi5"],
["分宜","fen1yi2"],
["分寸","fen1cun5"],
["分属","fen1shu3"],
["分屬","fen1shu3"],
["分当","fen4dang1"],
["分得","fen1de2"],
["分手","fen1shou3"],
["分拆","fen4chai1"],
["分晓","fen1xiao3"],
["分曉","fen1xiao3"],
["分析","fen1xi5"],
["分母","fen1mu3"],
["分点","fen1dian3"],
["分為","fen1wei2"],
["分當","fen4dang1"],
["分相","fen1xiang4"],
["分米","fen1mi3"],
["分組","fen1zu3"],
["分給","fen1gei3"],
["分组","fen1zu3"],
["分给","fen1gei3"],
["分行","fen1hang2"],
["分解","fen1jie3"],
["分量","fen4liang4"],
["分點","fen1dian3"],
["分不了","fen1bu5liao3"],
["分不出","fen1bu5chu1"],
["分不开","fen1bu5kai1"],
["分不開","fen1bu5kai1"],
["分出來","fen1chu1lai2"],
["分出来","fen1chu1lai2"],
["分子式","fen1zi3shi4"],
["分子筛","fen1zi3shai1"],
["分子篩","fen1zi3shai1"],
["分子量","fen1zi3liang4"],
["分得了","fen1de5liao3"],
["分不清楚","fen1bu5qing1chu5"],
["分外恩典","fen1wai4en1dian3"],
["分子医学","fen1zi3yi1xue2"],
["分子杂交","fen1zi3za2jiao1"],
["分子醫學","fen1zi3yi1xue2"],
["分子雜交","fen1zi3za2jiao1"],
["分毫之差","fen1hao2zhi1cha1"],
["分子生物学","fen1zi3sheng1wu4xue2"],
["分子生物學","fen1zi3sheng1wu4xue2"]
],
"切":[
["切中","qie4zhong4"],
["切割","qie1ge1"],
["切去","qie1qu4"],
["切口","qie4kou3"],
["切向","qie1xiang4"],
["切嘱","qie4zhu3"],
["切囑","qie4zhu3"],
["切尼","qie1ni2"],
["切开","qie1kai1"],
["切成","qie1cheng2"],
["切换","qie1huan4"],
["切換","qie1huan4"],
["切断","qie1duan4"],
["切斷","qie1duan4"],
["切点","qie1dian3"],
["切片","qie1pian4"],
["切牙","qie1ya2"],
["切碎","qie1sui4"],
["切磋","qie1cuo1"],
["切線","qie1xian4"],
["切线","qie1xian4"],
["切腹","qie1fu4"],
["切角","qie1jiao3"],
["切診","qie4zhen3"],
["切诊","qie4zhen3"],
["切開","qie1kai1"],
["切除","qie1chu2"],
["切面","qie1mian4"],
["切點","qie1dian3"],
["切齒","qie4chi3"],
["切齿","qie4chi3"],
["切不可","qie4bu5ke3"],
["切不齊","qie1bu5qi2"],
["切不齐","qie1bu5qi2"],
["切叶蚁","qie1ye4yi3"],
["切平面","qie1ping2mian4"],
["切空間","qie1kong1jian1"],
["切空间","qie1kong1jian1"],
["切肉刀","qie1rou4dao1"],
["切葉蟻","qie1ye4yi3"],
["切分信息","qie1fen1xin4xi1"],
["切尔诺贝利","qie1er3nuo4bei4li4"],
["切爾諾貝利","qie1er3nuo4bei4li4"]
],
"刈":[
["刈羽","yi4yu3"]
],
"刊":[
["刊載","kan1zai3"],
["刊载","kan1zai3"]
],
"刑":[
["刑场","xing2chang3"],
["刑場","xing2chang3"],
["刑法","xing2fa3"],
["刑满","xing2man3"],
["刑滿","xing2man3"],
["刑網","xing2wang3"],
["刑网","xing2wang3"],
["刑警","xing2jing3"],
["刑辱","xing2ru3"],
["刑訴法","xing2su4fa3"],
["刑诉法","xing2su4fa3"]
],
"划":[
["划子","hua2zi5"],
["划拉","hua2la5"],
["划拳","hua2quan2"],
["划桨","hua2jiang3"],
["划槳","hua2jiang3"],
["划水","hua2shui3"],
["划痕","hua2hen2"],
["划破","hua2po4"],
["划算","hua2suan4"],
["划船","hua2chuan2"],
["划艇","hua2ting3"],
["划过","hua2guo4"],
["划過","hua2guo4"],
["划不來","hua2bu5lai2"],
["划不来","hua2bu5lai2"],
["划得來","hua2de5lai2"],
["划得来","hua2de5lai2"],
["划一不二","hua4yi2bu2er4"]
],
"列":[
["列为","lie4wei2"],
["列举","lie4ju3"],
["列传","lie4zhuan4"],
["列傳","lie4zhuan4"],
["列子","lie4zi3"],
["列岛","lie4dao3"],
["列島","lie4dao3"],
["列為","lie4wei2"],
["列舉","lie4ju3"],
["列表","lie4biao3"],
["列別傑夫","lie4bie4jie2fu1"],
["列别杰夫","lie4bie4jie2fu1"]
],
"刘":[
["刘海","liu2hai3"],
["刘表","liu2biao3"],
["刘少奇","liu2shao4qi2"],
["刘涓子","liu2juan1zi3"]
],
"刚":[
["刚体","gang1ti3"],
["刚好","gang1hao3"],
["刚巧","gang1qiao3"],
["刚果","gang1guo3"]
],
"创":[
["创举","chuang4ju3"],
["创伤","chuang1shang1"],
["创口","chuang1kou3"],
["创始","chuang4shi3"],
["创痛","chuang1tong4"],
["创可贴","chuang1ke3tie1"],
["创造出","chuang1zao4chu1"],
["创巨痛深","chuang1ju4tong4shen1"]
],
"初":[
["初始","chu1shi3"],
["初小","chu1xiao3"],
["初稿","chu1gao3"],
["初等","chu1deng3"],
["初选","chu1xuan3"],
["初選","chu1xuan3"],
["初露头角","chu1lu4tou2jiao3"],
["初露頭角","chu1lu4tou2jiao3"]
],
"删":[
["删减","shan1jian3"]
],
"判":[
["判处","pan4chu3"],
["判處","pan4chu3"]
],
"別":[
["別了","bie4le5"],
["別人","bie2ren5"],
["別嘴","bie4zui3"],
["別扭","bie4niu5"],
["別理","bie2li3"],
["別管","bie2guan3"],
["別致","bie2zhi5"],
["別/彆","bie4bu5guo5"],
["別西卜","bie2xi1bu3"],
["別具一格","bie2ju4yi4ge2"],
["別樹一幟","bie2shu4yi2zhi4"],
["別赫捷列夫","bie2he4jie2lie4fu1"]
],
"刨":[
["刨冰","bao4bing1"],
["刨刀","bao4dao1"],
["刨地","pao2di4"],
["刨工","bao4gong1"],
["刨程","bao4cheng2"],
["刨花","bao4hua1"],
["刨齒","bao4chi3"],
["刨齿","bao4chi3"],
["刨根儿","pao2gen1r5"]
],
"利":[
["利以","li4yi3"],
["利害","li4hai5"],
["利己","li4ji3"],
["利巴","li4ba1"],
["利得","li4de2"],
["利息","li4xi1"],
["利於","li4yu2"],
["利法","li4fa3"],
["利爪","li4zhao3"],
["利甲","li4jia3"],
["利落","li4luo5"],
["利錢","li4qian5"],
["利钱","li4qian5"],
["利馬","li4ma3"],
["利马","li4ma3"],
["利息率","li4xi5lv4"],
["利斯巴","li4si1ba1"],
["利都施","li4du1shi1"],
["利雅得","li4ya3de2"]
],
"刪":[
["刪減","shan1jian3"]
],
"别":[
["别了","bie4le5"],
["别人","bie2ren5"],
["别嘴","bie4zui3"],
["别扭","bie4niu5"],
["别理","bie2li3"],
["别管","bie2guan3"],
["别致","bie2zhi5"],
["别不过","bie4bu5guo5"],
["别西卜","bie2xi1bu3"],
["别具一格","bie2ju4yi4ge2"],
["别树一帜","bie2shu4yi2zhi4"],
["别赫捷列夫","bie2he4jie2lie4fu1"]
],
"刮":[
["刮脸","gua1lian3"],
["刮臉","gua1lian3"],
["刮起","gua1qi3"],
["刮鏟","gua1chan3"],
["刮铲","gua1chan3"],
["刮地風","gua1di4feng1"],
["刮地风","gua1di4feng1"]
],
"到":[
["到场","dao4chang3"],
["到場","dao4chang3"],
["到差","dao4chai1"],
["到底","dao4di3"],
["到此","dao4ci3"],
["到老","dao4lao3"],
["到过","dao4guo5"],
["到過","dao4guo5"],
["到不了","dao4bu5liao3"],
["到不到","dao4bu5dao4"],
["到时候","dao4shi2hou4"],
["到時候","dao4shi2hou4"],
["到处一游","dao4chu4yi4you2"],
["到處一游","dao4chu4yi4you2"],
["到那个时候","dao4na4ge4shi2hou4"],
["到那個時候","dao4na4ge4shi2hou4"]
],
"制":[
["制假","zhi4jia3"],
["制品","zhi4pin3"],
["制导","zhi4dao3"],
["制止","zhi4zhi3"],
["制服呢","zhi4fu2ni2"],
["制鞋匠","zhi4xie2jiang4"]
],
"刹":[
["刹把","sha1ba3"],
["刹那","cha4na4"]
],
"刺":[
["刺儿","ci4r5"],
["刺柏","ci4bai3"],
["刺死","ci4si3"],
["刺耳","ci4er3"],
["刺骨","ci4gu3"],
["刺芹菇","ci4qin2gu1"],
["刺儿不喇叽","ci4r5bu5la1ji1"],
["刺兒不喇嘰","ci4r5bu5la1ji1"]
],
"刻":[
["刻上","ke4shang5"],
["刻写","ke4xie3"],
["刻寫","ke4xie3"],
["刻本","ke4ben3"],
["刻板","ke4ban3"],
["刻版","ke4ban3"],
["刻苦","ke4ku3"],
["刻薄","ke4bo2"]
],
"剃":[
["剃发","ti4fa4"]
],
"削":[
["削减","xue1jian3"],
["削掉","xiao1diao4"],
["削減","xue1jian3"],
["削球","xiao1qiu2"],
["削职为民","xue1zhi2wei2min2"],
["削職為民","xue1zhi2wei2min2"]
],
"剋":[
["剋架","kei1jia4"]
],
"前":[
["前冠","qian2guan1"],
["前咽","qian2yan1"],
["前夫","qian2fu1"],
["前头","qian2tou5"],
["前已","qian2yi3"],
["前往","qian2wang3"],
["前手","qian2shou3"],
["前摆","qian2bai3"],
["前擺","qian2bai3"],
["前景","qian2jing3"],
["前燕","qian2yan1"],
["前綴","qian2zhui4"],
["前缀","qian2zhui4"],
["前者","qian2zhe3"],
["前腿","qian2tui3"],
["前边","qian2bian5"],
["前邊","qian2bian5"],
["前面","qian2mian5"],
["前頭","qian2tou5"],
["前不大","qian2bu5da4"],
["前奏曲","qian2zou4qu3"],
["前边儿","qian2bian5r5"],
["前仆后繼","qian2pu1hou4ji4"],
["前仆后继","qian2pu1hou4ji4"],
["前半晌儿","qian2ban4shang3r5"],
["前不大会儿","qian2bu5da4hui3r5"],
["前不大會兒","qian2bu5da4hui3r5"]
],
"剎":[
["剎把","sha1ba3"],
["剎那","cha4na4"]
],
"剑":[
["剑柄","jian4bing3"]
],
"剛":[
["剛好","gang1hao3"],
["剛巧","gang1qiao3"],
["剛果","gang1guo3"],
["剛體","gang1ti3"]
],
"剧":[
["剧场","ju4chang3"],
["剧本","ju4ben3"]
],
"剩":[
["剩下","sheng4xia5"],
["剩下來","sheng4xia4lai2"],
["剩下来","sheng4xia4lai2"],
["剩不下","sheng4bu5xia4"]
],
"剪":[
["剪切","jian3qie1"],
["剪发","jian3fa4"],
["剪彩","jian3cai3"],
["剪短","jian3duan3"],
["剪紙","jian3zhi3"],
["剪纸","jian3zhi3"],
["剪下來","jian3xia4lai2"],
["剪下来","jian3xia4lai2"],
["剪刀差","jian3dao1cha1"]
],
"副":[
["副手","fu4shou3"],
["副本","fu4ben3"]
],
"割":[
["割取","ge1qu3"],
["割礼","ge1li3"],
["割禮","ge1li3"],
["割草","ge1cao3"]
],
"創":[
["創傷","chuang1shang1"],
["創口","chuang1kou3"],
["創始","chuang4shi3"],
["創痛","chuang1tong4"],
["創舉","chuang4ju3"],
["創可貼","chuang1ke3tie1"],
["創造出","chuang1zao4chu1"],
["創巨痛深","chuang1ju4tong4shen1"]
],
"剿":[
["剿匪","jiao3fei3"]
],
"劃":[
["劃一","hua4yi1"],
["劃價","hua4jia4"],
["劃出","hua4chu1"],
["劃分","hua4fen1"],
["劃定","hua4ding4"],
["劃掉","hua4diao4"],
["劃撥","hua4bo1"],
["劃歸","hua4gui1"],
["劃清","hua4qing1"],
["劃線","hua4xian4"],
["劃時代","hua4shi2dai4"],
["劃一不二","hua4yi2bu2er4"],
["劃圓防守","hua4yuan2fang2shou3"]
],
"劇":[
["劇場","ju4chang3"],
["劇本","ju4ben3"]
],
"劉":[
["劉海","liu2hai3"],
["劉禪","liu2chan2"],
["劉表","liu2biao3"],
["劉少奇","liu2shao4qi2"],
["劉涓子","liu2juan1zi3"]
],
"劍":[
["劍柄","jian4bing3"]
],
"力":[
["力主","li4zhu3"],
["力偶","li4ou3"],
["力场","li4chang3"],
["力場","li4chang3"],
["力宝","li4bao3"],
["力寶","li4bao3"],
["力度","li4du5"],
["力把","li4ba5"],
["力拓","li4tuo4"],
["力气","li4qi5"],
["力氣","li4qi5"],
["力盡","li4jin4"],
["力矩","li4ju3"],
["力量","li4liang5"],
["力阻","li4zu3"],
["力有未逮","li4you3wei4dai4"],
["力求一逞","li4qiu2yi4cheng3"]
],
"劝":[
["劝勉","quan4mian3"],
["劝导","quan4dao3"],
["劝解","quan4jie3"],
["劝阻","quan4zu3"]
],
"办":[
["办妥","ban4tuo3"],
["办法","ban4fa3"],
["办理","ban4li3"],
["办不下","ban4bu5xia4"],
["办不了","ban4bu5liao3"],
["办不出","ban4bu5chu1"],
["办不到","ban4bu5dao4"],
["办不动","ban4bu5dong4"],
["办不完","ban4bu5wan2"],
["办不成","ban4bu5cheng2"],
["办不来","ban4bu5lai2"],
["办不清","ban4bu5qing1"],
["办得了","ban4de5liao3"],
["办得到","ban4de5dao4"]
],
"功":[
["功底","gong1di3"],
["功績","gong1ji4"],
["功绩","gong1ji4"],
["功亏一篑","gong1kui1yi2kui4"],
["功虧一簣","gong1kui1yi2kui4"]
],
"加":[
["加以","jia1yi3"],
["加冕","jia1mian3"],
["加法","jia1fa3"],
["加甲","jia1jia3"],
["加码","jia1ma3"],
["加碼","jia1ma3"],
["加紧","jia1jin3"],
["加給","jia1ji3"],
["加緊","jia1jin3"],
["加给","jia1ji3"],
["加的夫","jia1de5fu1"],
["加達裡","jia1da2li3"],
["加德满都","jia1de2man3du1"],
["加德滿都","jia1de2man3du1"],
["加榮耀於","jia1rong2yao4yu2"],
["加納利碼頭","jia1na4li4ma3tou2"],
["加纳利码头","jia1na4li4ma3tou2"]
],
"务":[
["务全","wu4quan2"],
["务农","wu4nong2"],
["务实","wu4shi2"],
["务必","wu4bi4"],
["务求","wu4qiu2"],
["务要","wu4yao4"]
],
"劣":[
["劣等","lie4deng3"],
["劣跡","lie4ji4"],
["劣迹","lie4ji4"]
],
"动":[
["动嘴","dong4zui3"],
["动弹","dong4tan5"],
["动手","dong4shou3"],
["动武","dong4wu3"],
["动点","dong4dian3"],
["动静","dong4jing5"],
["动不了","dong4bu5liao3"],
["动不动","dong4bu5dong4"],
["动不得","dong4bu5de5"],
["动不动儿","dong4bu5dong4r5"],
["动弹不得","dong4tan5bu5de5"],
["动辄得咎","dong4zhe2de2jiu4"]
],
"助":[
["助手","zhu4shou3"],
["助理","zhu4li3"],
["助長","zhu4zhang3"],
["助长","zhu4zhang3"],
["助以一臂","zhu4yi3yi2bi4"],
["助紂為虐","zhu4zhou4wei2nve4"],
["助纣为虐","zhu4zhou4wei2nve4"],
["助一臂之力","zhu4yi2bi4zhi5li4"]
],
"劫":[
["劫洗","jie2xi3"],
["劫难","jie2nan4"],
["劫難","jie2nan4"]
],
"劲":[
["劲卒","jing4zu2"],
["劲吹","jing4chui1"],
["劲峭","jing4qiao4"],
["劲急","jing4ji2"],
["劲拔","jing4ba2"],
["劲挺","jing4ting3"],
["劲敌","jing4di2"],
["劲旅","jing4lv3"],
["劲烈","jing4lie4"],
["劲直","jing4zhi2"],
["劲草","jing4cao3"],
["劲风","jing4feng1"]
],
"劳":[
["劳苦","lao2ku3"],
["劳雇关系","lao2gu4guan1xi4"]
],
"势":[
["势力","shi4li5"],
["势阱","shi4jing3"],
["势利眼","shi4li5yan3"],
["势在必得","shi4zai4bi4de2"]
],
"勁":[
["勁卒","jing4zu2"],
["勁吹","jing4chui1"],
["勁峭","jing4qiao4"],
["勁急","jing4ji2"],
["勁拔","jing4ba2"],
["勁挺","jing4ting3"],
["勁敵","jing4di2"],
["勁旅","jing4lv3"],
["勁烈","jing4lie4"],
["勁直","jing4zhi2"],
["勁草","jing4cao3"],
["勁風","jing4feng1"]
],
"勃":[
["勃兴","bo2xing1"],
["勃海","bo2hai3"],
["勃興","bo2xing1"],
["勃起","bo2qi3"],
["勃列日涅夫","bo2lie4ri4nie4fu1"]
],
"勇":[
["勇敢","yong3gan3"],
["勇於","yong3yu2"],
["勇武","yong3wu3"],
["勇猛","yong3meng3"]
],
"勉":[
["勉強","mian3qiang3"],
["勉强","mian3qiang3"],
["勉強一笑","mian3qiang3yi2xiao4"],
["勉强一笑","mian3qiang3yi2xiao4"]
],
"勒":[
["勒杀","lei1sha1"],
["勒殺","lei1sha1"],
["勒索","le4suo3"],
["勒紧","lei1jin3"],
["勒緊","lei1jin3"],
["勒馬","le4ma3"],
["勒马","le4ma3"],
["勒脖子","lei1bo2zi5"]
],
"動":[
["動嘴","dong4zui3"],
["動彈","dong4tan5"],
["動手","dong4shou3"],
["動武","dong4wu3"],
["動靜","dong4jing5"],
["動點","dong4dian3"],
["動不了","dong4bu5liao3"],
["動不動","dong4bu5dong4"],
["動不得","dong4bu5de5"],
["動彈不得","dong4tan5bu5de5"],
["動輒得咎","dong4zhe2de2jiu4"]
],
"務":[
["務全","wu4quan2"],
["務實","wu4shi2"],
["務必","wu4bi4"],
["務求","wu4qiu2"],
["務要","wu4yao4"],
["務農","wu4nong2"]
],
"勝":[
["勝地","sheng4di4"],
["勝於","sheng4yu2"],
["勝訴","sheng4su4"],
["勝選","sheng4xuan3"]
],
"勞":[
["勞苦","lao2ku3"],
["勞雇關係","lao2gu4guan1xi4"]
],
"募":[
["募得","mu4de2"],
["募款","mu4kuan3"]
],
"勢":[
["勢力","shi4li5"],
["勢阱","shi4jing3"],
["勢利眼","shi4li5yan3"],
["勢在必得","shi4zai4bi4de2"]
],
"勤":[
["勤俭","qin2jian3"],
["勤儉","qin2jian3"],
["勤务","qin2wu4"],
["勤勉","qin2mian3"],
["勤務","qin2wu4"],
["勤快","qin2kuai5"],
["勤恳","qin2ken3"],
["勤懇","qin2ken3"],
["勤於","qin2yu2"],
["勤朴","qin2pu3"],
["勤樸","qin2pu3"],
["勤苦","qin2ku3"],
["勤謹","qin2jin5"],
["勤谨","qin2jin5"]
],
"勳":[
["勳績","xun1ji4"],
["勳绩","xun1ji4"]
],
"勸":[
["勸勉","quan4mian3"],
["勸導","quan4dao3"],
["勸解","quan4jie3"],
["勸阻","quan4zu3"]
],
"勻":[
["勻實","yun2shi5"],
["勻整","yun2zheng3"],
["勻溜","yun2liu5"],
["勻稱","yun2chen5"],
["勻不出","yun2bu5chu1"],
["勻得出","yun2de5chu1"]
],
"勾":[
["勾劃","gou1hua4"],
["勾引","gou1yin3"],
["勾当","gou4dang4"],
["勾手","gou1shou3"],
["勾當","gou4dang4"]
],
"匀":[
["匀实","yun2shi5"],
["匀整","yun2zheng3"],
["匀溜","yun2liu5"],
["匀称","yun2chen5"],
["匀不出","yun2bu5chu1"],
["匀得出","yun2de5chu1"]
],
"包":[
["包举","bao1ju3"],
["包乾","bao1gan1"],
["包产","bao1chan3"],
["包伙","bao1huo3"],
["包剿","bao1jiao3"],
["包场","bao1chang3"],
["包場","bao1chang3"],
["包尔","bao1er3"],
["包扎","bao1za1"],
["包拯","bao1zheng3"],
["包揽","bao1lan3"],
["包攬","bao1lan3"],
["包涵","bao1han5"],
["包爾","bao1er3"],
["包產","bao1chan3"],
["包穀","bao1gu3"],
["包管","bao1guan3"],
["包米","bao1mi3"],
["包舉","bao1ju3"],
["包裹","bao1guo3"],
["包谷","bao1gu3"],
["包起","bao1qi3"],
["包不了","bao1bu5liao3"],
["包园儿","bao1yuan2r5"],
["包圆儿","bao1yuan2r5"],
["包干儿","bao1gan1r5"],
["包皮环切","bao1pi2huan2qie1"],
["包皮環切","bao1pi2huan2qie1"],
["包袱底儿","bao1fu5di3r5"]
],
"匈":[
["匈語","xiong1yu3"],
["匈语","xiong1yu3"]
],
"匕":[
["匕首","bi3shou3"]
],
"化":[
["化为","hua4wei2"],
["化子","hua1zi5"],
["化為","hua4wei2"],
["化解","hua4jie3"],
["化悲为喜","hua4bei1wei2xi3"],
["化悲為喜","hua4bei1wei2xi3"],
["化敌为友","hua4di2wei2you3"],
["化整为零","hua4zheng3wei2ling2"],
["化整為零","hua4zheng3wei2ling2"],
["化敵為友","hua4di2wei2you3"],
["化险为夷","hua4xian3wei2yi2"],
["化險為夷","hua4xian3wei2yi2"],
["化学剂量计","hua4xue2ji4liang4ji4"],
["化學劑量計","hua4xue2ji4liang4ji4"]
],
"北":[
["北史","bei3shi3"],
["北岛","bei3dao3"],
["北島","bei3dao3"],
["北斗","bei3dou3"],
["北海","bei3hai3"],
["北燕","bei3yan1"],
["北緯","bei3wei3"],
["北纬","bei3wei3"],
["北美","bei3mei3"],
["北埔乡","bei3bu4xiang1"],
["北埔鄉","bei3bu4xiang1"],
["北边儿","bei3bian1r5"]
],
"匪":[
["匪首","fei3shou3"]
],
"匯":[
["匯劃","hui4hua4"],
["匯款","hui4kuan3"],
["匯水","hui4shui3"],
["匯點","hui4dian3"],
["匯出行","hui4chu1hang2"]
],
"匹":[
["匹馬","pi3ma3"],
["匹马","pi3ma3"]
],
"医":[
["医务","yi1wu4"],
["医卜","yi1bu3"]
],
"匿":[
["匿跡","ni4ji4"],
["匿迹","ni4ji4"]
],
"區":[
["區劃","qu1hua4"]
],
"十":[
["十九","shi2jiu3"],
["十五","shi2wu3"],
["十几","shi2ji3"],
["十只","shi2zhi1"],
["十幾","shi2ji3"],
["十一号","shi2yi1hao4"],
["十一年","shi2yi1nian2"],
["十一號","shi2yi1hao4"],
["十一路","shi2yi1lu4"],
["十字形","shi2zi5xing2"],
["十一級風","shi2yi1ji2feng1"],
["十一级风","shi2yi1ji2feng1"],
["十几个月","shi2ji3ge4yue4"],
["十四行詩","shi2si4hang2shi1"],
["十四行诗","shi2si4hang2shi1"],
["十幾個月","shi2ji3ge4yue4"],
["十賒不如一現","shi2she1bu4ru2yi2xian4"],
["十赊不如一现","shi2she1bu4ru2yi2xian4"]
],
"千":[
["千卡","qian1ka3"],
["千古","qian1gu3"],
["千夫","qian1fu1"],
["千瓦","qian1wa3"],
["千米","qian1mi3"],
["千里","qian1li3"],
["千佛洞","qian1fo2dong4"],
["千差万别","qian1cha1wan4bie2"],
["千差萬別","qian1cha1wan4bie2"],
["千慮一失","qian1lv4yi4shi1"],
["千經萬卷","qian1jing1wan4juan4"],
["千经万卷","qian1jing1wan4juan4"],
["千虑一失","qian1lv4yi4shi1"],
["千載一時","qian1zai3yi4shi2"],
["千載一遇","qian1zai3yi2yu4"],
["千載難逢","qian1zai3nan2feng2"],
["千载一时","qian1zai3yi4shi2"],
["千载一遇","qian1zai3yi2yu4"],
["千载难逢","qian1zai3nan2feng2"],
["千金一掷","qian1jin1yi2zhi4"],
["千金一擲","qian1jin1yi2zhi4"],
["千金一笑","qian1jin1yi2xiao4"],
["千金一諾","qian1jin1yi2nuo4"],
["千金一诺","qian1jin1yi2nuo4"],
["千鈞一髮","qian1jun1yi2fa4"],
["千钧一发","qian1jun1yi2fa4"],
["千金难买一笑","qian1jin1nan2mai3yi2xiao4"],
["千金難買一笑","qian1jin1nan2mai3yi2xiao4"],
["千里达和多巴哥","qian1li3da2he2duo1ba1ge1"],
["千里達和多巴哥","qian1li3da2he2duo1ba1ge1"]
],
"升":[
["升息","sheng1xi1"],
["升汞","sheng1gong3"],
["升起","sheng1qi3"],
["升上來","sheng1shang4lai2"],
["升上来","sheng1shang4lai2"],
["升不了","sheng1bu5liao3"]
],
"午":[
["午覺","wu3jiao4"],
["午觉","wu3jiao4"],
["午馬","wu3ma3"],
["午马","wu3ma3"]
],
"半":[
["半上","ban4shang3"],
["半响","ban4xiang3"],
["半场","ban4chang3"],
["半場","ban4chang3"],
["半岛","ban4dao3"],
["半島","ban4dao3"],
["半拉","ban4la3"],
["半死","ban4si3"],
["半点","ban4dian3"],
["半響","ban4xiang3"],
["半點","ban4dian3"],
["半半拉拉","ban4ban5la1la1"],
["半夜三更","ban4ye4san1geng1"],
["半开门儿","ban4kai1men2r5"]
],
"华":[
["华佗","hua4tuo2"],
["华北","hua2bei3"],
["华山","hua4shan1"],
["华府","hua2fu3"],
["华彩","hua2cai3"],
["华美","hua2mei3"],
["华蓥","hua2ying2"],
["华表","hua2biao3"],
["华语","hua2yu3"],
["华里","hua2li3"],
["华兴会","hua2xing1hui4"],
["华尔兹","hua2er3zi5"],
["华罗庚","hua4luo2geng1"],
["华纳兄弟","hua4na4xiong1di4"],
["华纳音乐集团","hua4na4yin1yue4ji2tuan2"],
["华严经大方广佛","hua2yan2jing1da4fang1guang3fo2"]
],
"协":[
["协理","xie2li3"],
["协管","xie2guan3"],
["协调","xie2tiao2"],
["协奏曲","xie2zou4qu3"]
],
"卑":[
["卑鄙","bei1bi3"]
],
"卓":[
["卓著","zhuo2zhu4"],
["卓乎不群","zhuo2hu1bu4qun2"]
],
"協":[
["協理","xie2li3"],
["協管","xie2guan3"],
["協調","xie2tiao2"],
["協奏曲","xie2zou4qu3"]
],
"单":[
["单丛","dong1cong2"],
["单于","chan2yu2"],
["单体","dan1ti3"],
["单县","shan4xian4"],
["单手","dan1shou3"],
["单打","dan1da3"],
["单曲","dan1qu3"],
["单相","dan1xiang4"],
["单眼","dan1yan3"],
["单薄","dan1bo2"],
["单行","dan1hang2"],
["单轨","dan1gui3"],
["单一码","dan1yi4ma3"],
["单一税","dan1yi2shui4"],
["单峰驼","dan1feng1tuo2"],
["单相思","dan1xiang1si1"],
["单行本","dan1xing2ben3"],
["单行线","dan1xing2xian4"],
["单行道","dan1xing2dao4"],
["单一种植","dan1yi2zhong4zhi2"],
["单一翻译","dan1yi4fan1yi4"],
["单一转换","dan1yi4zhuan3huan4"],
["单一隐喻","dan1yi4yin3yu4"],
["单亲家庭","dan1qin1jia1ting2"],
["单一主题句","dan1yi4zhu3ti2ju4"],
["单一合体字","dan1yi4he2ti3zi4"]
],
"卖":[
["卖主","mai4zhu3"],
["卖傻","mai4sha3"],
["卖点","mai4dian3"],
["卖给","mai4gei3"],
["卖不上","mai4bu5shang4"],
["卖不了","mai4bu5liao3"],
["卖不光","mai4bu5guang1"],
["卖不动","mai4bu5dong4"],
["卖不清","mai4bu5qing1"],
["卖不过","mai4bu5guo4"],
["卖得出","mai4de5chu1"],
["卖不出去","mai4bu5chu1qu5"]
],
"南":[
["南乐","nan2yue4"],
["南北","nan2bei3"],
["南史","nan2shi3"],
["南地","nan2di4"],
["南岛","nan2dao3"],
["南岭","nan2ling3"],
["南島","nan2dao3"],
["南嶺","nan2ling3"],
["南樂","nan2yue4"],
["南海","nan2hai3"],
["南燕","nan2yan1"],
["南緯","nan2wei3"],
["南纬","nan2wei3"],
["南美","nan2mei3"],
["南边","nan2bian5"],
["南邊","nan2bian5"],
["南边儿","nan2bian5r5"],
["南奥塞梯","nan2ao4sai1ti1"],
["南奧塞梯","nan2ao4sai1ti1"],
["南柯一夢","nan2ke1yi2meng4"],
["南柯一梦","nan2ke1yi2meng4"]
],
"博":[
["博兴","bo2xing1"],
["博取","bo2qu3"],
["博古","bo2gu3"],
["博彩","bo2cai3"],
["博得","bo2de2"],
["博興","bo2xing1"],
["博覽","bo2lan3"],
["博览","bo2lan3"],
["博識","bo2shi2"],
["博识","bo2shi2"],
["博野","bo2ye3"],
["博雅","bo2ya3"],
["博聞多識","bo2wen2duo1shi2"],
["博聞強識","bo2wen2qiang2shi2"],
["博闻多识","bo2wen2duo1shi2"],
["博闻强识","bo2wen2qiang2shi2"]
],
"卜":[
["卜占","bu3zhan1"],
["卜卦","bu3gua4"],
["卜問","bu3wen4"],
["卜宅","bu3zhai2"],
["卜居","bu3ju1"],
["卜征","bu3zheng1"],
["卜甲","bu3jia3"],
["卜筮","bu3shi4"],
["卜課","bu3ke4"],
["卜课","bu3ke4"],
["卜辞","bu3ci2"],
["卜辭","bu3ci2"],
["卜问","bu3wen4"],
["卜骨","bu3gu3"],
["卜昼卜夜","bu3zhou4bu3ye4"],
["卜晝卜夜","bu3zhou4bu3ye4"]
],
"占":[
["占卜","zhan1bu3"],
["占星","zhan1xing1"],
["占有","zhan4you3"],
["占領","zhan4ling3"],
["占领","zhan4ling3"],
["占便宜","zhan4pian2yi5"]
],
"卡":[
["卡尔","ka3er3"],
["卡爾","ka3er3"],
["卡米","ka3mi3"],
["卡仙尼","ka3xian1ni2"],
["卡地夫","ka3di4fu1"],
["卡夫卡","ka3fu1ka3"],
["卡山得","ka3shan1de2"],
["卡尔扎伊","ka3er3za1yi1"],
["卡拉OK","ka3la1ou1kei1"],
["卡拉奇那","ka3la1ji1na5"],
["卡拉季奇","ka3la1ji4ji1"],
["卡文迪什","ka3wen2di2shi2"],
["卡爾扎伊","ka3er3za1yi1"],
["卡西莫夫","ka3xi1mo4fu1"],
["卡門柏乳酪","ka3men2bo2ru3lao4"],
["卡门柏乳酪","ka3men2bo2ru3lao4"],
["卡拉什尼科夫","ka3la1shi2ni2ke1fu1"],
["卡拉馬佐夫兄弟","ka3la1ma3zuo3fu1xiong1di4"],
["卡拉马佐夫兄弟","ka3la1ma3zuo3fu1xiong1di4"]
],
"卢":[
["卢卡","lu2ka3"],
["卢比","lu2bi3"]
],
"卤":[
["卤属","lu3shu3"],
["卤水","lu3shui3"],
["卤法","lu3fa3"],
["卤莽","lu3mang3"]
],
"卧":[
["卧佛","wo4fo2"],
["卧倒","wo4dao3"],
["卧底","wo4di3"],
["卧虎","wo4hu3"],
["卧轨","wo4gui3"],
["卧果儿","wo4guo3r5"]
],
"卫":[
["卫冕","wei4mian3"]
],
"卯":[
["卯榫","mao3sun3"]
],
"印":[
["印巴","yin4ba1"],
["印染","yin4ran3"],
["印版","yin4ban3"],
["印古什","yin4gu3shi2"],
["印地語","yin4di4yu3"],
["印地语","yin4di4yu3"],
["印地安納","yin4di4an1na4"],
["印地安纳","yin4di4an1na4"]
],
"危":[
["危笃","wei1du3"],
["危篤","wei1du3"],
["危险","wei1xian3"],
["危險","wei1xian3"],
["危难","wei1nan4"],
["危難","wei1nan4"],
["危地馬拉","wei1di4ma3la1"],
["危地马拉","wei1di4ma3la1"],
["危如累卵","wei1ru2lei3luan3"]
],
"即":[
["即为","ji2wei2"],
["即使","ji2shi3"],
["即可","ji2ke3"],
["即早","ji2zao3"],
["即為","ji2wei2"],
["即时即地","ji2shi2ji2di4"],
["即時即地","ji2shi2ji2di4"]
],
"却":[
["却好","que4hao3"],
["却老","que4lao3"],
["却走","que4zou3"]
],
"卵":[
["卵子","luan3zi3"]
],
"卷":[
["卷发","quan2fa4"],
["卷宗","juan4zong1"],
["卷尺","juan3chi3"],
["卷走","juan3zou3"],
["卷起","juan3qi3"],
["卷軸","juan4zhou2"],
["卷轴","juan4zhou2"],
["卷餅","juan3bing3"],
["卷饼","juan3bing3"],
["卷起來","juan3qi3lai5"],
["卷起来","juan3qi3lai5"],
["卷铺盖","juan3pu1gai5"],
["卷帙浩繁","juan4zhi4hao4fan2"]
],
"卻":[
["卻好","que4hao3"],
["卻老","que4lao3"],
["卻走","que4zou3"]
],
"厂":[
["厂主","chang3zhu3"],
["厂史","chang3shi3"],
["厂址","chang3zhi3"],
["厂长","chang3zhang3"]
],
"厅":[
["厅长","ting1zhang3"]
],
"历":[
["历久","li4jiu3"],
["历史","li4shi3"],
["历法","li4fa3"],
["历险","li4xian3"],
["历史上","li4shi3shang5"]
],
"厉":[
["厉害","li4hai5"],
["厉鬼","li4gui3"]
],
"压":[
["压倒","ya1dao3"],
["压扁","ya1bian3"],
["压挤","ya1ji3"],
["压死","ya1si3"],
["压紧","ya1jin3"],
["压不住","ya1bu5zhu4"],
["压不过","ya1bu5guo4"]
],
"厌":[
["厌恶","yan4wu4"],
["厌氧","yan4yang3"],
["厌薄","yan4bo2"]
],
"厕":[
["厕所","ce4suo3"]
],
"厘":[
["厘米","li2mi3"]
],
"厚":[
["厚礼","hou4li3"],
["厚禮","hou4li3"],
["厚养薄葬","hou4yang3bo2zang4"],
["厚此薄彼","hou4ci3bo2bi3"],
["厚養薄葬","hou4yang3bo2zang4"]
],
"原":[
["原为","yuan2wei2"],
["原主","yuan2zhu3"],
["原产","yuan2chan3"],
["原地","yuan2di4"],
["原址","yuan2zhi3"],
["原始","yuan2shi3"],
["原委","yuan2wei3"],
["原子","yuan2zi3"],
["原有","yuan2you3"],
["原本","yuan2ben3"],
["原点","yuan2dian3"],
["原為","yuan2wei2"],
["原理","yuan2li3"],
["原產","yuan2chan3"],
["原著","yuan2zhu4"],
["原野","yuan2ye3"],
["原點","yuan2dian3"],
["原产地","yuan2chan3di4"],
["原点矩","yuan2dian3ju3"],
["原產地","yuan2chan3di4"],
["原點矩","yuan2dian3ju3"]
],
"厦":[
["厦门","xia4men2"]
],
"厭":[
["厭惡","yan4wu4"],
["厭氧","yan4yang3"],
["厭薄","yan4bo2"]
],
"厮":[
["厮守","si1shou3"],
["厮打","si1da3"]
],
"厲":[
["厲害","li4hai5"],
["厲鬼","li4gui3"]
],
"去":[
["去取","qu4qu3"],
["去不了","qu4bu5liao3"],
["去不得","qu4bu5de5"],
["去不成","qu4bu5cheng2"],
["去得了","qu4de5liao3"]
],
"县":[
["县长","xian4zhang3"]
],
"叁":[
["叁拾","san1shi2"]
],
"参":[
["参与","can1yu4"],
["参宿","shen1xiu4"],
["参差","cen1ci1"],
["参考","can1kao3"],
["参薯","shen1shu3"],
["参谋长","can1mou2zhang3"]
],
"參":[
["參宿","shen1xiu4"],
["參差","cen1ci1"],
["參考","can1kao3"],
["參與","can1yu4"],
["參薯","shen1shu3"],
["參謀長","can1mou2zhang3"]
],
"叄":[
["叄拾","san1shi2"]
],
"及":[
["及早","ji2zao3"]
],
"友":[
["友人","you3ren2"],
["友伴","you3ban4"],
["友军","you3jun1"],
["友善","you3shan4"],
["友好","you3hao3"],
["友情","you3qing2"],
["友愛","you3ai4"],
["友爱","you3ai4"],
["友誼","you3yi4"],
["友谊","you3yi4"],
["友軍","you3jun1"],
["友邦","you3bang1"],
["友妮基","you3ni1ji1"],
["友布罗","you3bu4luo2"],
["友布羅","you3bu4luo2"],
["友阿蝶","you3a1die2"],
["友拉革罗","you3la1ge2luo2"],
["友拉革羅","you3la1ge2luo2"]
],
"双":[
["双乳","shuang1ru3"],
["双喜","shuang1xi3"],
["双塔","shuang1ta3"],
["双子","shuang1zi3"],
["双手","shuang1shou3"],
["双打","shuang1da3"],
["双柏","shuang1bai3"],
["双眼","shuang1yan3"],
["双管","shuang1guan3"],
["双脚","shuang1jiao3"],
["双腿","shuang1tui3"],
["双语","shuang1yu3"],
["双轨","shuang1gui3"],
["双重","shuang1chong2"],
["双膝跪下","shuang1xi1gui4xia4"]
],
"反":[
["反党","fan3dang3"],
["反剪","fan3jian3"],
["反响","fan3xiang3"],
["反嘴","fan3zui3"],
["反导","fan3dao3"],
["反導","fan3dao3"],
["反应","fan3ying4"],
["反恐","fan3kong3"],
["反悔","fan3hui3"],
["反感","fan3gan3"],
["反應","fan3ying4"],
["反手","fan3shou3"],
["反掌","fan3zhang3"],
["反比","fan3bi3"],
["反水","fan3shui3"],
["反演","fan3yan3"],
["反省","fan3xing3"],
["反訴","fan3su4"],
["反語","fan3yu3"],
["反諷","fan3feng3"],
["反讽","fan3feng3"],
["反诉","fan3su4"],
["反语","fan3yu3"],
["反轉","fan3zhuan3"],
["反转","fan3zhuan3"],
["反鎖","fan3suo3"],
["反锁","fan3suo3"],
["反間","fan3jian4"],
["反间","fan3jian4"],
["反響","fan3xiang3"],
["反黨","fan3dang3"],
["反应式","fan3ying1shi4"],
["反應式","fan3ying1shi4"],
["反散射","fan3san4she4"],
["反过来","fan3guo5lai2"],
["反過來","fan3guo5lai2"],
["反手可得","fan3shou3ke3de2"],
["反敗為勝","fan3bai4wei2sheng4"],
["反败为胜","fan3bai4wei2sheng4"],
["反过来说","fan3guo4lai2shuo1"],
["反過來說","fan3guo4lai2shuo1"],
["反射区治疗","fan3she4ou1zhi4liao2"],
["反射區治療","fan3she4ou1zhi4liao2"]
],
"发":[
["发丧","fa1sang1"],
["发冷","fa1leng3"],
["发夹","fa4jia1"],
["发屋","fa4wu1"],
["发展","fa1zhan3"],
["发廊","fa4lang2"],
["发往","fa1wang3"],
["发怔","fa1zheng4"],
["发憷","fa1chu4"],
["发抖","fa1dou3"],
["发泡","fa1pao2"],
["发火","fa1huo3"],
["发痒","fa1yang3"],
["发窘","fa1jiong3"],
["发粉","fa4fen3"],
["发绀","fa4gan4"],
["发给","fa1gei3"],
["发网","fa4wang3"],
["发胀","fa4zhang4"],
["发胶","fa4jiao1"],
["发表","fa1biao3"],
["发起","fa1qi3"],
["发软","fa1ruan3"],
["发辫","fa4bian4"],
["发迹","fa1ji4"],
["发难","fa1nan4"],
["发颤","fa1zhan4"],
["发髻","fa4ji4"],
["发不了","fa1bu5liao3"],
["发出来","fa1chu1lai2"],
["发源地","fa1yuan2di4"],
["发烧友","fa1shao1you3"],
["发现号","fa1xian4hao2"],
["发祥地","fa1xiang2di4"],
["发指眦裂","fa4zhi3zi4lie4"],
["发明创造","fa1ming2chuang1zao4"]
],
"叔":[
["叔伯","shu1bai5"],
["叔叔","shu1shu5"],
["叔母","shu1mu3"],
["叔祖","shu1zu3"]
],
"取":[
["取下","qu3xia5"],
["取巧","qu3qiao3"],
["取得","qu3de2"],
["取捨","qu3she3"],
["取暖","qu3nuan3"],
["取舍","qu3she3"],
["取不上","qu3bu5shang4"],
["取出來","qu3chu1lai2"],
["取出来","qu3chu1lai2"],
["取決於","qu3jue2yu2"]
],
"受":[
["受享","shou4xiang3"],
["受体","shou4ti3"],
["受取","shou4qu3"],
["受宠","shou4chong3"],
["受审","shou4shen3"],
["受審","shou4shen3"],
["受寵","shou4chong3"],
["受损","shou4sun3"],
["受損","shou4sun3"],
["受暑","shou4shu3"],
["受洗","shou4xi3"],
["受理","shou4li3"],
["受瘪","shou4bie1"],
["受癟","shou4bie1"],
["受盡","shou4jin4"],
["受礼","shou4li3"],
["受禅","shou4shan4"],
["受禮","shou4li3"],
["受窘","shou4jiong3"],
["受膏","shou4gao4"],
["受苦","shou4ku3"],
["受賞","shou4shang3"],
["受赏","shou4shang3"],
["受辱","shou4ru3"],
["受阻","shou4zu3"],
["受降","shou4xiang2"],
["受难","shou4nan4"],
["受難","shou4nan4"],
["受領","shou4ling3"],
["受领","shou4ling3"],
["受體","shou4ti3"],
["受不了","shou4bu5liao3"],
["受不住","shou4bu5zhu4"],
["受不得","shou4bu5de5"],
["受不着","shou4bu5zhao2"],
["受不著","shou4bu5zhao2"],
["受不起","shou4bu5qi3"],
["受委屈","shou4wei3qu1"],
["受得了","shou4de5liao3"],
["受折磨","shou4zhe2mo2"],
["受命於天","shou4ming4yu2tian1"]
],
"变":[
["变丑","bian4chou3"],
["变为","bian4wei2"],
["变产","bian4chan3"],
["变体","bian4ti3"],
["变暖","bian4nuan3"],
["变更","bian4geng1"],
["变法","bian4fa3"],
["变相","bian4xiang4"],
["变种","bian4zhong3"],
["变脸","bian4lian3"],
["变苦","bian4ku3"],
["变软","bian4ruan3"],
["变通","bian4tong5"],
["变奏曲","bian4zou4qu3"],
["变样儿","bian4yang4r5"],
["变法儿","bian4fa3r5"],
["变速杆","bian4su4gan3"],
["变征之声","bian4zhi3zhi1sheng1"]
],
"叙":[
["叙永","xu4yong3"]
],
"叛":[
["叛党","pan4dang3"],
["叛匪","pan4fei3"],
["叛黨","pan4dang3"]
],
"叠":[
["叠起","die2qi3"]
],
"口":[
["口北","kou3bei3"],
["口感","kou3gan3"],
["口水","kou3shui3"],
["口渴","kou3ke3"],
["口給","kou3ji3"],
["口给","kou3ji3"],
["口角","kou3jiao3"],
["口語","kou3yu3"],
["口语","kou3yu3"],
["口音","kou3yin5"],
["口齒","kou3chi3"],
["口齿","kou3chi3"],
["口頭禪","kou3tou2chan2"],
["口乾舌燥","kou3gan1she2zao4"],
["口口声声","kou3kou5sheng1sheng1"],
["口口聲聲","kou3kou5sheng1sheng1"],
["口齒清楚","kou3chi3qing1chu3"],
["口齿清楚","kou3chi3qing1chu3"]
],
"古":[
["古典","gu3dian3"],
["古冶","gu3ye3"],
["古史","gu3shi3"],
["古塔","gu3ta3"],
["古巴","gu3ba1"],
["古珥","gu3er3"],
["古老","gu3lao3"],
["古董","gu3dong3"],
["古跡","gu3ji4"],
["古迹","gu3ji4"],
["古都","gu3du1"],
["古典乐","gu3dian3yue4"],
["古典樂","gu3dian3yue4"],
["古地磁","gu3di4ci2"],
["古今一轍","gu3jin1yi4zhe2"],
["古今一辙","gu3jin1yi4zhe2"]
],
"句":[
["句法","ju4fa3"],
["句讀","ju4dou4"],
["句读","ju4dou4"],
["句首","ju4shou3"]
],
"另":[
["另有","ling4you3"]
],
"叨":[
["叨唠","dao1lao5"],
["叨嘮","dao1lao5"]
],
"叩":[
["叩首","kou4shou3"]
],
"只":[
["只可","zhi3ke3"],
["只好","zhi3hao3"],
["只得","zhi3de2"],
["只手","zhi1shou3"],
["只有","zhi3you3"],
["只眼","zhi1yan3"],
["只管","zhi3guan3"],
["只許","zhi3xu3"],
["只许","zhi3xu3"],
["只身","zhi1shen1"],
["只不过","zhi3bu5guo4"],
["只不過","zhi3bu5guo4"],
["只言片语","zhi1yan2pian4yu3"],
["只雞斗酒","zhi1ji1dou3jiu3"],
["只鸡斗酒","zhi1ji1dou3jiu3"]
],
"叫":[
["叫唤","jiao4huan5"],
["叫喊","jiao4han3"],
["叫喚","jiao4huan5"],
["叫嚷","jiao4rang3"],
["叫好","jiao4hao3"],
["叫横","jiao4heng4"],
["叫橫","jiao4heng4"],
["叫水","jiao4shui3"],
["叫法","jiao4fa3"],
["叫醒","jiao4xing3"],
["叫不上","jiao4bu5shang4"],
["叫不醒","jiao4bu5xing3"]
],
"叮":[
["叮咬","ding1yao3"],
["叮嘱","ding1zhu3"],
["叮囑","ding1zhu3"]
],
"可":[
["可不","ke3bu5"],
["可以","ke3yi3"],
["可免","ke3mian3"],
["可口","ke3kou3"],
["可可","ke3ke3"],
["可喜","ke3xi3"],
["可塞","ke3sai4"],
["可好","ke3hao3"],
["可导","ke3dao3"],
["可導","ke3dao3"],
["可巧","ke3qiao3"],
["可恥","ke3chi3"],
["可恶","ke3wu4"],
["可惡","ke3wu4"],
["可数","ke3shu3"],
["可數","ke3shu3"],
["可比","ke3bi3"],
["可汗","ke4han2"],
["可耻","ke3chi3"],
["可調","ke3tiao2"],
["可调","ke3tiao2"],
["可鄙","ke3bi3"],
["可不得了","ke3bu4de2liao3"],
["可一而不可再","ke3yi4er2bu4ke3zai4"]
],
"台":[
["台北","tai2bei3"],
["台地","tai2di4"],
["台州","tai1zhou1"],
["台海","tai2hai3"],
["台語","tai2yu3"],
["台语","tai2yu3"],
["台兒莊區","tai2er2zhuang1qu1"]
],
"叱":[
["叱呵","chi4he1"],
["叱喝","chi4he4"]
],
"史":[
["史传","shi3zhuan4"],
["史傳","shi3zhuan4"],
["史蒂夫","shi3di4fu1"],
["史传小说","shi3zhuan4xiao3shuo2"],
["史傳小說","shi3zhuan4xiao3shuo2"]
],
"右":[
["右手","you4shou3"],
["右脚","you4jiao3"],
["右腳","you4jiao3"],
["右腿","you4tui3"],
["右边","you4bian5"],
["右邊","you4bian5"],
["右边儿","you4bian5r5"],
["右派分子","you4pai4fen4zi3"]
],
"叶":[
["叶挺","ye4ting3"],
["叶枕","ye4zhen3"],
["叶柄","ye4bing3"]
],
"号":[
["号丧","hao2sang5"],
["号叫","hao2jiao4"],
["号啕","hao2tao2"],
["号码","hao4ma3"],
["号筒","hao4tong3"],
["号角","hao4jiao3"]
],
"司":[
["司法","si1fa3"],
["司長","si1zhang3"],
["司长","si1zhang3"],
["司馬","si1ma3"],
["司马","si1ma3"]
],
"叹":[
["叹息","tan4xi1"],
["叹赏","tan4shang3"],
["叹为观止","tan4wei2guan1zhi3"]
],
"吃":[
["吃上","chi1shang5"],
["吃主","chi1zhu3"],
["吃儿","chi1r5"],
["吃头","chi1tou5"],
["吃奶","chi1nai3"],
["吃本","chi1ben3"],
["吃紧","chi1jin3"],
["吃緊","chi1jin3"],
["吃苦","chi1ku3"],
["吃草","chi1cao3"],
["吃請","chi1qing3"],
["吃请","chi1qing3"],
["吃頭","chi1tou5"],
["吃飽","chi1bao3"],
["吃饱","chi1bao3"],
["吃不上","chi1bu5shang4"],
["吃不下","chi1bu5xia4"],
["吃不了","chi1bu5liao3"],
["吃不住","chi1bu5zhu4"],
["吃不來","chi1bu5lai2"],
["吃不到","chi1bu5dao4"],
["吃不完","chi1bu5wan2"],
["吃不开","chi1bu5kai1"],
["吃不得","chi1bu5de2"],
["吃不惯","chi1bu5guan4"],
["吃不慣","chi1bu5guan4"],
["吃不服","chi1bu5fu2"],
["吃不来","chi1bu5lai2"],
["吃不消","chi1bu5xiao1"],
["吃不清","chi1bu5qing1"],
["吃不着","chi1bu5zhao2"],
["吃不著","chi1bu5zhao2"],
["吃不起","chi1bu5qi3"],
["吃不透","chi1bu5tou4"],
["吃不開","chi1bu5kai1"],
["吃不飽","chi1bu5bao3"],
["吃不饱","chi1bu5bao3"],
["吃得上","chi1de5shang4"],
["吃得來","chi1de5lai2"],
["吃得来","chi1de5lai2"],
["吃苦头","chi1ku3tou5"],
["吃苦頭","chi1ku3tou5"],
["吃不下去","chi1bu5xia4qu5"],
["吃盡苦頭","chi1jin4ku3tou5"],
["吃不住劲儿","chi1bu5zhu4jin4r5"],
["吃一堑长一智","chi1yi2qian4zhang3yi2zhi4"],
["吃一塹長一智","chi1yi2qian4zhang3yi2zhi4"]
],
"各":[
["各个","ge4ge4"],
["各個","ge4ge4"],
["各地","ge4di4"],
["各省","ge4sheng3"],
["各种","ge4zhong3"],
["各種","ge4zhong3"],
["各執一見","ge4zhi2yi2jian4"],
["各執一詞","ge4zhi2yi4ci2"],
["各奔前程","ge4ben4qian2cheng2"],
["各得其所","ge4de2qi2suo3"],
["各执一见","ge4zhi2yi2jian4"],
["各执一词","ge4zhi2yi4ci2"],
["各有所好","ge4you3suo3hao4"],
["各盡所能","ge4jin4suo3neng2"],
["各行各业","ge4hang2ge4ye4"],
["各行各業","ge4hang2ge4ye4"]
],
"吆":[
["吆呼","yao1hu5"],
["吆喊","yao1han3"],
["吆喝","yao1he5"]
],
"合":[
["合上","he2shang5"],
["合为","he2wei2"],
["合乎","he2hu1"],
["合伙","he2huo3"],
["合卺","he2jin3"],
["合同","he2tong5"],
["合好","he2hao3"],
["合宜","he2yi2"],
["合巹","he2jin3"],
["合影","he2ying3"],
["合拢","he2long3"],
["合掌","he2zhang3"],
["合攏","he2long3"],
["合於","he2yu2"],
["合水","he2shui3"],
["合法","he2fa3"],
["合浦","he2pu3"],
["合演","he2yan3"],
["合為","he2wei2"],
["合理","he2li3"],
["合眼","he2yan3"],
["合着","he2zhu4"],
["合縫","he2feng2"],
["合缝","he2feng2"],
["合股","he2gu3"],
["合脚","he2jiao3"],
["合腳","he2jiao3"],
["合著","he2zhu4"],
["合不上","he2bu5shang4"],
["合不了","he2bu5liao3"],
["合不來","he2bu5lai2"],
["合不拢","he2bu5long3"],
["合不攏","he2bu5long3"],
["合不来","he2bu5lai2"],
["合不着","he2bu5zhao2"],
["合不著","he2bu5zhao2"],
["合家欢","he2jia1huan1"],
["合家歡","he2jia1huan1"],
["合得來","he2de5lai2"],
["合得来","he2de5lai2"],
["合得着","he2de5zhao2"],
["合得著","he2de5zhao2"],
["合辙儿","he2zhe2r5"],
["合乎逻辑","he2hu1luo2ji2"],
["合乎邏輯","he2hu1luo2ji2"],
["合二为一","he2er4wei2yi1"],
["合二為一","he2er4wei2yi1"],
["合众为一","he2zhong4wei2yi1"],
["合眾為一","he2zhong4wei2yi1"],
["合而为一","he2er2wei2yi1"],
["合而為一","he2er2wei2yi1"]
],
"吉":[
["吉他","ji2ta5"],
["吉普","ji2pu3"],
["吉水","ji2shui3"],
["吉珥","ji2er3"],
["吉甲","ji2jia3"],
["吉野","ji2ye3"],
["吉首","ji2shou3"],
["吉卜賽","ji2bu3sai4"],
["吉卜赛","ji2bu3sai4"],
["吉娃娃","ji2wa2wa2"]
],
"吊":[
["吊卷","diao4juan4"],
["吊古","diao4gu3"],
["吊塔","diao4ta3"],
["吊审","diao4shen3"],
["吊審","diao4shen3"],
["吊打","diao4da3"],
["吊斗","diao4dou3"],
["吊死","diao4si3"],
["吊索","diao4suo3"],
["吊起","diao4qi3"],
["吊頸","diao4jing3"],
["吊颈","diao4jing3"],
["吊儿郎当","diao4r5lang2dang1"]
],
"同":[
["同为","tong2wei2"],
["同伙","tong2huo3"],
["同党","tong2dang3"],
["同喜","tong2xi3"],
["同感","tong2gan3"],
["同母","tong2mu3"],
["同為","tong2wei2"],
["同理","tong2li3"],
["同等","tong2deng3"],
["同黨","tong2dang3"],
["同一性","tong2yi2xing4"],
["同样是","tong2yang4shi5"],
["同樣是","tong2yang4shi5"],
["同出一軌","tong2chu1yi4gui3"],
["同出一轍","tong2chu1yi4zhe2"],
["同出一轨","tong2chu1yi4gui3"],
["同出一辙","tong2chu1yi4zhe2"],
["同声一哭","tong2sheng1yi4ku1"],
["同工同酬","tong2gong1tong2chou2"],
["同歸於盡","tong2gui1yu2jin4"],
["同聲一哭","tong2sheng1yi4ku1"],
["同行一莫","tong2hang2yi2mo4"]
],
"名":[
["名为","ming2wei2"],
["名产","ming2chan3"],
["名分","ming2fen4"],
["名堂","ming2tang5"],
["名字","ming2zi5"],
["名将","ming2jiang4"],
["名將","ming2jiang4"],
["名帖","ming2tie3"],
["名手","ming2shou3"],
["名曲","ming2qu3"],
["名气","ming2qi5"],
["名氣","ming2qi5"],
["名為","ming2wei2"],
["名產","ming2chan3"],
["名著","ming2zhu4"],
["名角","ming2jue2"],
["名酒","ming2jiu3"],
["名义上","ming2yi4shang5"],
["名義上","ming2yi4shang5"],
["名角儿","ming2jue2r5"],
["名誉扫地","ming2yu4sao3di4"],
["名譽掃地","ming2yu4sao3di4"]
],
"后":[
["后冠","hou4guan1"],
["后头","hou4tou5"],
["后影","hou4ying3"],
["后悔","hou4hui3"],
["后果","hou4guo3"],
["后母","hou4mu3"],
["后缀","hou4zhui4"],
["后者","hou4zhe3"],
["后边","hou4bian5"],
["后面","hou4mian5"],
["后頭","hou4tou5"]
],
"吐":[
["吐根","tu4gen1"],
["吐訴","tu3su4"],
["吐诉","tu3su4"],
["吐不出","tu3bu5chu1"],
["吐出來","tu3chu1lai2"],
["吐出来","tu3chu1lai2"],
["吐苦水","tu4ku3shui3"],
["吐谷浑","tu3yu4hun2"],
["吐谷渾","tu3yu4hun2"],
["吐露心事","tu3lu4xin1shi4"]
],
"向":[
["向使","xiang4shi3"],
["向北","xiang4bei3"],
["向导","xiang4dao3"],
["向導","xiang4dao3"],
["向左","xiang4zuo3"],
["向往","xiang4wang3"],
["向晚","xiang4wan3"],
["向海","xiang4hai3"],
["向火","xiang4huo3"],
["向北地","xiang4bei3di4"],
["向巴平措","xiang4ba1ping2cuo4"]
],
"吓":[
["吓倒","xia4dao3"],
["吓傻","xia4sha3"],
["吓声","he4sheng1"],
["吓跑","xia4pao3"]
],
"吕":[
["吕览","lv3lan3"]
],
"吗":[
["吗哪","ma3na3"],
["吗啡","ma3fei1"]
],
"君":[
["君主","jun1zhu3"],
["君子","jun1zi3"]
],
"吞":[
["吞吐","tun1tu3"],
["吞沒","tun1mo4"],
["吞没","tun1mo4"],
["吞吞吐吐","tun1tun5tu3tu3"]
],
"吟":[
["吟咏","yin2yong3"],
["吟哦","yin2e2"],
["吟詠","yin2yong3"]
],
"吧":[
["吧台","ba1tai2"]
],
"吩":[
["吩咐","fen1fu4"]
],
"含":[
["含有","han2you3"],
["含水","han2shui3"],
["含商咀徵","han2shang1ju3zheng1"],
["含宮咀徵","han2gong1ju3zheng1"],
["含情脈脈","han2qing2mo4mo4"],
["含情脉脉","han2qing2mo4mo4"],
["含糊不清","han2hu2bu4qing1"]
],
"听":[
["听写","ting1xie3"],
["听取","ting1qu3"],
["听听","ting1ting5"],
["听头","ting1tou5"],
["听审","ting1shen3"],
["听懂","ting1dong3"],
["听筒","ting1tong3"],
["听者","ting1zhe3"],
["听讲","ting1jiang3"],
["听骨","ting1gu3"],
["听不到","ting1bu5dao4"],
["听不得","ting1bu5de5"],
["听不懂","ting1bu5dong3"],
["听不清","ting1bu5qing1"],
["听不见","ting1bu5jian4"],
["听不进","ting1bu5jin4"],
["听得出","ting1de5chu1"],
["听得懂","ting1de2dong3"],
["听清楚","ting1qing1chu3"],
["听说过","ting1shuo1guo5"],
["听不下去","ting1bu5xia4qu4"],
["听不明白","ting1bu5ming2bai5"],
["听不清楚","ting1bu5qing1chu3"],
["听不进去","ting1bu5jin4qu5"],
["听墙根儿","ting1qiang2gen1r5"]
],
"吱":[
["吱声","zhi1sheng1"],
["吱聲","zhi1sheng1"],
["吱吱声","zi1zi1sheng1"],
["吱吱聲","zi1zi1sheng1"]
],
"吲":[
["吲哚","yin3duo3"]
],
"吳":[
["吳堡","wu2bu3"],
["吳語","wu2yu3"],
["吳頭楚尾","wu2tou2chu3wei3"]
],
"吴":[
["吴堡","wu2bu3"],
["吴语","wu2yu3"],
["吴头楚尾","wu2tou2chu3wei3"]
],
"吵":[
["吵嘴","chao3zui3"]
],
"吶":[
["吶喊","na4han3"]
],
"吸":[
["吸取","xi1qu3"],
["吸口","xi1kou3"],
["吸吮","xi1shun3"],
["吸引","xi1yin3"],
["吸氧","xi1yang3"],
["吸水","xi1shui3"],
["吸盡","xi1jin4"],
["吸着","xi1zhuo2"],
["吸管","xi1guan3"],
["吸著","xi1zhuo2"],
["吸血","xi1xie3"],
["吸血鬼","xi1xue4gui3"]
],
"吹":[
["吹乾","chui1gan1"],
["吹响","chui1xiang3"],
["吹打","chui1da3"],
["吹捧","chui1peng3"],
["吹火","chui1huo3"],
["吹走","chui1zou3"],
["吹響","chui1xiang3"],
["吹管乐","chui1guan3yue4"],
["吹管樂","chui1guan3yue4"],
["吹吹拍拍","chui1chui5pai1pai1"],
["吹得譜兒","chui1de2pu3r5"],
["吹得谱儿","chui1de2pu3r5"]
],
"吾":[
["吾珥","wu2er3"]
],
"呂":[
["呂覽","lv3lan3"]
],
"呆":[
["呆板","dai1ban3"]
],
"呈":[
["呈給","cheng2gei3"],
["呈给","cheng2gei3"],
["呈請","cheng2qing3"],
["呈请","cheng2qing3"]
],
"告":[
["告示","gao4shi5"],
["告解","gao4jie3"]
],
"呐":[
["呐喊","na4han3"]
],
"呕":[
["呕吐","ou3tu4"]
],
"呜":[
["呜咽","wu1ye4"]
],
"呢":[
["呢喃","ni2nan2"]
],
"周":[
["周五","zhou1wu3"],
["周到","zhou1dao5"],
["周口","zhou1kou3"],
["周礼","zhou1li3"],
["周禮","zhou1li3"],
["周轉","zhou1zhuan3"],
["周转","zhou1zhuan3"],
["周一岳","zhou1yi2yue4"],
["周一嶽","zhou1yi2yue4"]
],
"呫":[
["呫吨","zhan1dun1"],
["呫呫","tie4tie4"],
["呫哔","tie4bi4"],
["呫嗫","tie4nie4"],
["呫嗶","tie4bi4"],
["呫噸","zhan1dun1"],
["呫嚅","tie4ru2"],
["呫囁","tie4nie4"],
["呫毕","tie4bi4"],
["呫畢","tie4bi4"]
],
"味":[
["味道","wei4dao5"]
],
"呵":[
["呵呵","he1he1"],
["呵喝","he1he4"],
["呵护","he1hu4"],
["呵斥","he1chi4"],
["呵欠","he1qian4"],
["呵禁","he1jin4"],
["呵護","he1hu4"],
["呵責","he1ze2"],
["呵责","he1ze2"],
["呵一口气","he1yi4kou3qi4"],
["呵一口氣","he1yi4kou3qi4"]
],
"呼":[
["呼号","hu1hao2"],
["呼吁","hu1yu4"],
["呼喊","hu1han3"],
["呼喝","hu1he4"],
["呼应","hu1ying4"],
["呼應","hu1ying4"],
["呼玛","hu1ma3"],
["呼瑪","hu1ma3"],
["呼號","hu1hao2"],
["呼來喝去","hu1lai2he4qu4"],
["呼来喝去","hu1lai2he4qu4"]
],
"命":[
["命中","ming4zhong4"]
],
"咆":[
["咆哮","pao2xiao4"]
],
"咋":[
["咋不","zha1bu5"]
],
"和":[
["和了","huo4le5"],
["和好","he2hao3"],
["和尚","he2shang5"],
["和暖","he2nuan3"],
["和气","he2qi5"],
["和氣","he2qi5"],
["和法","he2fa3"],
["和緩","he2huan3"],
["和缓","he2huan3"],
["和美","he2mei3"],
["和蔼","he2ai3"],
["和藹","he2ai3"],
["和解","he2jie3"],
["和詩","he4shi1"],
["和诗","he4shi1"],
["和道","he2dao5"],
["和面","huo2mian4"],
["和麵","huo2mian4"],
["和散那","he2san3na4"],
["和和气气","he2he2qi4qi4"],
["和和氣氣","he2he2qi4qi4"],
["和气生财","he2qi4sheng1cai2"],
["和气致祥","he2qi4zhi4xiang2"],
["和氣生財","he2qi4sheng1cai2"],
["和氣致祥","he2qi4zhi4xiang2"]
],
"咒":[
["咒詛","zhou4zu3"],
["咒語","zhou4yu3"],
["咒诅","zhou4zu3"],
["咒语","zhou4yu3"]
],
"咕":[
["咕咕","gu1gu1"],
["咕唧","gu1ji1"],
["咕噜","gu1lu1"],
["咕嚕","gu1lu1"],
["咕咾肉","gu1lao3rou4"],
["咕啾在一块","gu1jiu5zai4yi2kuai4"],
["咕啾在一塊","gu1jiu5zai4yi2kuai4"],
["咕啾在一块儿","gu1jiu5zai4yi2kuai4r5"]
],
"咖":[
["咖喱","ga1li2"],
["咖啡馆儿","ka1fei1guan3r5"]
],
"咧":[
["咧嘴","lie3zui3"],
["咧开嘴笑","lie3kai1zui3xiao4"],
["咧開嘴笑","lie3kai1zui3xiao4"]
],
"咬":[
["咬嚼","yao3jiao2"],
["咬死","yao3si3"],
["咬不动","yao3bu5dong4"],
["咬不動","yao3bu5dong4"],
["咬不着","yao3bu5zhao2"],
["咬不著","yao3bu5zhao2"],
["咬文嚼字","yao3wen2jiao2zi4"],
["咬人狗儿不露齿","yao3ren2gou3r5bu2lu4chi3"],
["咬人狗兒不露齒","yao3ren2gou3r5bu2lu4chi3"]
],
"咳":[
["咳嗽","ke2sou5"]
],
"咸":[
["咸水","xian2shui3"],
["咸海","xian2hai3"],
["咸草","xian2cao3"],
["咸不唧儿","xian2bu5ji5r5"],
["咸丝丝儿","xian2si1si1r5"],
["咸津津儿","xian2jin1jin1r5"]
],
"咽":[
["咽喉","yan1hou2"],
["咽炎","yan1yan2"],
["咽不下","yan4bu5xia4"],
["咽鼓管","yan1gu3guan3"]
],
"哀":[
["哀乐","ai1yue4"],
["哀号","ai1hao2"],
["哀启","ai1qi3"],
["哀啟","ai1qi3"],
["哀子","ai1zi3"],
["哀悯","ai1min3"],
["哀憫","ai1min3"],
["哀戚","ai1qi1"],
["哀樂","ai1yue4"],
["哀號","ai1hao2"],
["哀的美敦","ai1di2mei3dun1"],
["哀的美敦书","ai1di4mei3dun1shu1"],
["哀的美敦書","ai1di4mei3dun1shu1"]
],
"品":[
["品种","pin3zhong3"],
["品種","pin3zhong3"],
["品等","pin3deng3"],
["品酒","pin3jiu3"]
],
"哄":[
["哄抢","hong4qiang3"],
["哄搶","hong4qiang3"],
["哄騙","hong3pian4"],
["哄骗","hong3pian4"],
["哄不过","hong3bu5guo4"],
["哄不過","hong3bu5guo4"]
],
"哇":[
["哇哇","wa1wa1"]
],
"哈":[
["哈佛","ha1fo2"],
["哈塔","ha1ta3"],
["哈巴","ha3ba1"],
["哈抹","ha1mo3"],
["哈拉","ha1la5"],
["哈撒","ha4sa5"],
["哈欠","ha1qian5"],
["哈琐","ha1suo3"],
["哈瑣","ha1suo3"],
["哈甲","ha1jia3"],
["哈达","ha3da2"],
["哈迪","ha3di2"],
["哈達","ha3da2"],
["哈馬","ha1ma3"],
["哈马","ha1ma3"],
["哈巴谷","ha1ba1gu3"],
["哈得拉","ha1de2la1"],
["哈得莱","ha1de2lai2"],
["哈得萊","ha1de2lai2"],
["哈甲巴","ha1jia3ba1"],
["哈舒巴","ha1shu1ba1"],
["哈苏巴","ha1su1ba1"],
["哈蘇巴","ha1su1ba1"],
["哈斯巴音","ha1si1ba1yin1"],
["哈裡斯堡","ha1li3si1bao3"],
["哈裡森史密特","ha1li3sen1shi3mi4te4"]
],
"响":[
["响声","xiang3sheng5"],
["响应","xiang3ying4"],
["响水","xiang3shui3"],
["响起","xiang3qi3"]
],
"哎":[
["哎呀","ai1ya1"]
],
"哑":[
["哑鼓","ya3gu3"],
["哑终端","ya1zhong1duan1"]
],
"哗":[
["哗变","hua2bian4"],
["哗啦","hua1la1"],
["哗然","hua2ran2"],
["哗笑","hua2xiao4"],
["哗啦啦","hua1la1la1"],
["哗众取宠","hua2zhong4qu3chong3"]
],
"哥":[
["哥儿","ge1r5"],
["哥哥","ge1ge5"],
["哥们儿","ge1men5r5"],
["哥罗芳","ge1luo2fang3"],
["哥羅芳","ge1luo2fang3"]
],
"哨":[
["哨卡","shao4qia3"],
["哨所","shao4suo3"]
],
"哪":[
["哪儿","na3r5"],
["哪只","na3zhi1"],
["哪吒","ne2zha1"],
["哪有","na3you3"],
["哪裏","na3li3"],
["哪里","na3li5"],
["哪古屋","na4gu3wu1"]
],
"哭":[
["哭丧","ku1sang1"],
["哭喪","ku1sang1"],
["哭脸","ku1lian3"],
["哭臉","ku1lian3"],
["哭訴","ku1su4"],
["哭诉","ku1su4"],
["哭不得","ku1bu5de5"],
["哭不成声","ku1bu5cheng2sheng1"],
["哭不成聲","ku1bu5cheng2sheng1"],
["哭丧着脸","ku1sang5zhe5lian3"],
["哭哭啼啼","ku1ku5ti2ti2"],
["哭喪著臉","ku1sang5zhe5lian3"],
["哭笑不得","ku1xiao4bu4de2"]
],
"哮":[
["哮喘","xiao4chuan3"]
],
"哲":[
["哲理","zhe2li3"]
],
"哺":[
["哺乳","bu3ru3"],
["哺养","bu3yang3"],
["哺養","bu3yang3"]
],
"哼":[
["哼唧","heng1ji5"]
],
"唆":[
["唆使","suo1shi3"]
],
"唇":[
["唇齒","chun2chi3"],
["唇齿","chun2chi3"]
],
"唐":[
["唐卡","tang2ka3"],
["唐海","tang2hai3"],
["唐氏兒","tang2shi4er2"]
],
"唠":[
["唠叨","lao2dao5"]
],
"唢":[
["唢呐","suo3na4"]
],
"唤":[
["唤头","huan4tou5"],
["唤起","huan4qi3"],
["唤醒","huan4xing3"]
],
"唧":[
["唧咕","ji1gu1"],
["唧筒","ji1tong3"],
["唧唧喳喳","ji1ji5zha1zha1"],
["唧唧嘎嘎","ji1ji1ga2ga2"]
],
"唱":[
["唱和","chang4he4"],
["唱曲","chang4qu3"],
["唱法","chang4fa3"],
["唱起","chang4qi3"],
["唱起來","chang4qi3lai5"],
["唱起来","chang4qi3lai5"]
],
"唾":[
["唾沫","tuo4mo5"],
["唾手可得","tuo4shou3ke3de2"],
["唾面自乾","tuo4mian4zi4gan1"]
],
"商":[
["商务","shang1wu4"],
["商務","shang1wu4"],
["商品","shang1pin3"],
["商场","shang1chang3"],
["商場","shang1chang3"],
["商旅","shang1lv3"],
["商水","shang1shui3"],
["商港","shang1gang3"],
["商討","shang1tao3"],
["商讨","shang1tao3"],
["商都","shang1du1"],
["商量","shang1liang5"],
["商鞅","shang1yang1"]
],
"啊":[
["啊呀","a1ya1"],
["啊修罗","a1xiu1luo2"],
["啊修羅","a1xiu1luo2"],
["啊耳忒弥斯","a1er3te4mi2si1"],
["啊耳忒彌斯","a1er3te4mi2si1"]
],
"問":[
["問問","wen4wen5"],
["問好","wen4hao3"],
["問難","wen4nan4"],
["問鼎","wen4ding3"]
],
"啜":[
["啜飲","chuo4yin3"],
["啜饮","chuo4yin3"]
],
"啞":[
["啞鼓","ya3gu3"],
["啞終端","ya1zhong1duan1"]
],
"啤":[
["啤酒","pi2jiu3"]
],
"啮":[
["啮齿","nie4chi3"]
],
"喀":[
["喀什","ka1shi2"],
["喀喇沁","ka1la1qin4"],
["喀啦喀啦","ka1la1ka1la1"],
["喀拉拉邦","ke4la1la1bang1"],
["喀拉汗国","ka1la1han4guo2"],
["喀拉汗國","ka1la1han4guo2"],
["喀喇崑崙山","ka1la1kun1lun2shan1"],
["喀喇昆仑山","ka1la1kun1lun2shan1"],
["喀喇昆侖山","ka1la1kun1lun2shan1"],
["喀拉喀托火山","ke4la1ke4tuo1huo3shan1"]
],
"喂":[
["喂养","wei4yang3"],
["喂奶","wei4nai3"],
["喂養","wei4yang3"]
],
"善":[
["善举","shan4ju3"],
["善於","shan4yu2"],
["善本","shan4ben3"],
["善果","shan4guo3"],
["善款","shan4kuan3"],
["善舉","shan4ju3"],
["善地阿索","shan4di4a1suo3"]
],
"喇":[
["喇合","la1he2"]
],
"喉":[
["喉咽","hou2yan1"],
["喉塞音","hou2se4yin1"]
],
"喑":[
["喑哑","yin1ya3"],
["喑啞","yin1ya3"]
],
"喘":[
["喘息","chuan3xi1"],
["喘不上","chuan3bu5shang4"],
["喘不过","chuan3bu5guo4"],
["喘不過","chuan3bu5guo4"]
],
"喚":[
["喚起","huan4qi3"],
["喚醒","huan4xing3"],
["喚頭","huan4tou5"]
],
"喜":[
["喜好","xi3hao4"],
["喜帖","xi3tie3"],
["喜酒","xi3jiu3"],
["喜雨","xi3yu3"],
["喜怒哀乐","xi3nu4ai1le4"],
["喜怒哀樂","xi3nu4ai1le4"]
],
"喝":[
["喝令","he4ling4"],
["喝彩","he4cai3"],
["喝水","he1shui3"],
["喝酒","he1jiu3"],
["喝采","he4cai3"],
["喝不上","he1bu5shang4"],
["喝不到","he1bu5dao4"],
["喝不着","he1bu5zhao2"],
["喝不著","he1bu5zhao2"],
["喝倒彩","he4dao4cai3"]
],
"喧":[
["喧哗","xuan1hua2"],
["喧嘩","xuan1hua2"],
["喧嚷","xuan1rang3"],
["喧扰","xuan1rao3"],
["喧擾","xuan1rao3"]
],
"喪":[
["喪事","sang1shi4"],
["喪假","sang1jia4"],
["喪偶","sang4ou3"],
["喪儀","sang1yi2"],
["喪夫","sang4fu1"],
["喪服","sang1fu2"],
["喪棒","sang1bang4"],
["喪氣","sang4qi5"],
["喪盡","sang4jin4"],
["喪禮","sang1li3"],
["喪膽","sang4dan3"],
["喪荒","sang1huang1"],
["喪葬","sang1zang4"],
["喪鐘","sang1zhong1"],
["喪氣話","sang4qi4hua4"],
["喪氣鬼","sang4qi4gui3"],
["喪門星","sang1men2xing1"],
["喪門神","sang1men2shen2"],
["喪失殆盡","sang4shi1dai4jin4"]
],
"單":[
["單于","chan2yu2"],
["單叢","dong1cong2"],
["單手","dan1shou3"],
["單打","dan1da3"],
["單曲","dan1qu3"],
["單相","dan1xiang4"],
["單眼","dan1yan3"],
["單縣","shan4xian4"],
["單薄","dan1bo2"],
["單行","dan1hang2"],
["單軌","dan1gui3"],
["單體","dan1ti3"],
["單一碼","dan1yi4ma3"],
["單一稅","dan1yi2shui4"],
["單峰駝","dan1feng1tuo2"],
["單相思","dan1xiang1si1"],
["單行本","dan1xing2ben3"],
["單行線","dan1xing2xian4"],
["單行道","dan1xing2dao4"],
["單一種植","dan1yi2zhong4zhi2"],
["單一翻譯","dan1yi4fan1yi4"],
["單一轉換","dan1yi4zhuan3huan4"],
["單一隱喻","dan1yi4yin3yu4"],
["單親家庭","dan1qin1jia1ting2"],
["單一主題句","dan1yi4zhu3ti2ju4"],
["單一合體字","dan1yi4he2ti3zi4"]
],
"喷":[
["喷嘴","pen1zui3"],
["喷洒","pen1sa3"]
],
"嗎":[
["嗎哪","ma3na3"],
["嗎啡","ma3fei1"]
],
"嗒":[
["嗒嗒","da1da1"]
],
"嗚":[
["嗚咽","wu1ye4"]
],
"嗜":[
["嗜好","shi4hao4"],
["嗜酒","shi4jiu3"]
],
"嗣":[
["嗣响","si4xiang3"],
["嗣子","si4zi3"],
["嗣響","si4xiang3"]
],
"嗩":[
["嗩吶","suo3na4"]
],
"嗫":[
["嗫呫","nie4tie4"]
],
"嘆":[
["嘆息","tan4xi1"],
["嘆賞","tan4shang3"],
["嘆為觀止","tan4wei2guan1zhi3"]
],
"嘉":[
["嘉兴","jia1xing1"],
["嘉奖","jia1jiang3"],
["嘉獎","jia1jiang3"],
["嘉興","jia1xing1"],
["嘉許","jia1xu3"],
["嘉许","jia1xu3"],
["嘉柏隆里","jia1bo2long2li3"]
],
"嘌":[
["嘌呤","piao4ling4"]
],
"嘎":[
["嘎吱","ga1zhi1"],
["嘎嘎","ga1ga1"]
],
"嘔":[
["嘔吐","ou3tu4"]
],
"嘗":[
["嘗嘗","chang2chang5"],
["嘗一嘗","chang2yi4chang2"],
["嘗鼎一臠","chang2ding3yi4luan2"]
],
"嘟":[
["嘟哝","du1nong5"],
["嘟噜","du1lu5"],
["嘟噥","du1nong5"],
["嘟嚕","du1lu5"],
["嘟囔","du1nang5"]
],
"嘩":[
["嘩啦","hua1la1"],
["嘩然","hua2ran2"],
["嘩笑","hua2xiao4"],
["嘩變","hua2bian4"],
["嘩啦啦","hua1la1la1"],
["嘩眾取寵","hua2zhong4qu3chong3"]
],
"嘮":[
["嘮叨","lao2dao5"]
],
"嘲":[
["嘲哳","zhao1zha1"],
["嘲諷","chao2feng3"],
["嘲讽","chao2feng3"]
],
"嘴":[
["嘴脸","zui3lian3"],
["嘴臉","zui3lian3"],
["嘴裡","zui3li3"],
["嘴角","zui3jiao3"],
["嘴里","zui3li3"],
["嘴不严","zui3bu5yan2"],
["嘴不嚴","zui3bu5yan2"],
["嘴不稳","zui3bu5wen3"],
["嘴不穩","zui3bu5wen3"]
],
"嘶":[
["嘶吼","si1hou3"],
["嘶哑","si1ya3"],
["嘶啞","si1ya3"],
["嘶喊","si1han3"]
],
"噁":[
["噁嗪","e3qin2"],
["噁心","e3xin1"]
],
"器":[
["器乐","qi4yue4"],
["器樂","qi4yue4"],
["器皿","qi4min3"]
],
"噴":[
["噴嘴","pen1zui3"],
["噴灑","pen1sa3"]
],
"噶":[
["噶厦","ga2xia4"],
["噶喇","ga2la3"],
["噶尔","ga2er3"],
["噶廈","ga2xia4"],
["噶爾","ga2er3"]
],
"嚇":[
["嚇倒","xia4dao3"],
["嚇傻","xia4sha3"],
["嚇聲","he4sheng1"],
["嚇跑","xia4pao3"]
],
"嚏":[
["嚏喷","ti4pen5"],
["嚏噴","ti4pen5"]
],
"嚙":[
["嚙齒","nie4chi3"]
],
"嚮":[
["嚮导","xiang4dao3"],
["嚮導","xiang4dao3"],
["嚮往","xiang4wang3"]
],
"嚴":[
["嚴守","yan2shou3"],
["嚴島","yan2dao3"],
["嚴緊","yan2jin3"],
["嚴謹","yan2jin3"]
],
"囁":[
["囁呫","nie4tie4"]
],
"囊":[
["囊揣","nang1chuai4"],
["囊肿","nang2zhong3"],
["囊腫","nang2zhong3"],
["囊膪","nang1chuai4"]
],
"四":[
["四体","si4ti3"],
["四只","si4zhi1"],
["四地","si4di5"],
["四百","si4bai3"],
["四角","si4jiao3"],
["四起","si4qi3"],
["四體","si4ti3"],
["四部曲","si4bu4qu3"],
["四个小时","si4ge4xiao3shi2"],
["四個小時","si4ge4xiao3shi2"],
["四号电池","si1hao4dian4chi2"],
["四子王旗","si4zi3wang2qi2"],
["四季豆腐","si4ji4dou4fu3"],
["四號電池","si1hao4dian4chi2"],
["四面楚歌","si4mian4chu3ge1"]
],
"回":[
["回來","hui2lai5"],
["回去","hui2qu5"],
["回响","hui2xiang3"],
["回嘴","hui2zui3"],
["回应","hui2ying4"],
["回想","hui2xiang3"],
["回應","hui2ying4"],
["回暖","hui2nuan3"],
["回来","hui2lai5"],
["回火","hui2huo3"],
["回礼","hui2li3"],
["回禀","hui2bing3"],
["回禮","hui2li3"],
["回稟","hui2bing3"],
["回訪","hui2fang3"],
["回請","hui2qing3"],
["回访","hui2fang3"],
["回请","hui2qing3"],
["回轉","hui2zhuan3"],
["回转","hui2zhuan3"],
["回采","hui2cai3"],
["回響","hui2xiang3"],
["回首","hui2shou3"],
["回不來","hui2bu5lai2"],
["回不去","hui2bu5qu4"],
["回不来","hui2bu5lai2"],
["回去了","hui2qu4le5"],
["回头一想","hui2tou2yi4xiang3"],
["回头一看","hui2tou2yi2kan4"],
["回頭一想","hui2tou2yi4xiang3"],
["回頭一看","hui2tou2yi2kan4"]
],
"因":[
["因子","yin1zi3"],
["因应","yin1ying4"],
["因恐","yin1kong3"],
["因應","yin1ying4"],
["因果","yin1guo3"],
["因此","yin1ci3"],
["因地制宜","yin1di4zhi4yi2"],
["因时制宜","yin1shi2zhi4yi2"],
["因時制宜","yin1shi2zhi4yi2"],
["因祸得福","yin1huo4de2fu2"],
["因禍得福","yin1huo4de2fu2"],
["因荷得藕","yin1he2de2ou3"]
],
"团":[
["团伙","tuan2huo3"],
["团体","tuan2ti3"],
["团长","tuan2zhang3"],
["团团转","tuan2tuan2zhuan4"],
["团结就是力量","tuan2jie2jiu4shi4li4liang4"]
],
"园":[
["园圃","yuan2pu3"],
["园地","yuan2di4"]
],
"困":[
["困扰","kun4rao3"],
["困擾","kun4rao3"],
["困窘","kun4jiong3"],
["困苦","kun4ku3"],
["困难","kun4nan5"],
["困難","kun4nan5"]
],
"围":[
["围剿","wei2jiao3"],
["围场","wei2chang3"],
["围拢","wei2long3"],
["围捕","wei2bu3"],
["围起","wei2qi3"]
],
"囹":[
["囹圄","ling2yu3"],
["囹圉","ling2yu3"]
],
"固":[
["固体","gu4ti3"],
["固始","gu4shi3"],
["固守","gu4shou3"],
["固有","gu4you3"],
["固體","gu4ti3"]
],
"国":[
["国乐","guo2yue4"],
["国产","guo2chan3"],
["国企","guo2qi3"],
["国史","guo2shi3"],
["国土","guo2tu3"],
["国宝","guo2bao3"],
["国有","guo2you3"],
["国法","guo2fa3"],
["国玺","guo2xi3"],
["国美","guo2mei3"],
["国耻","guo2chi3"],
["国语","guo2yu3"],
["国都","guo2du1"],
["国务卿","guo2wu4qing1"],
["国务院","guo2wu4yuan4"],
["国子监","guo2zi3jian4"],
["国务委员","guo2wu4wei3yuan2"],
["国务次卿","guo2wu4ci4qing1"]
],
"图":[
["图尔","tu2er3"],
["图版","tu2ban3"],
["图纸","tu2zhi3"],
["图表","tu2biao3"],
["图谱","tu2pu3"],
["图辑","tu2ji2"],
["图波列夫","tu2bo1lie4fu1"]
],
"圆":[
["圆场","yuan2chang3"],
["圆拱","yuan2gong3"],
["圆满","yuan2man3"],
["圆顶","yuan2ding3"],
["圆领","yuan2ling3"],
["圆饼","yuan2bing3"]
],
"圈":[
["圈地","quan1di4"]
],
"國":[
["國企","guo2qi3"],
["國史","guo2shi3"],
["國土","guo2tu3"],
["國寶","guo2bao3"],
["國恥","guo2chi3"],
["國有","guo2you3"],
["國樂","guo2yue4"],
["國法","guo2fa3"],
["國璽","guo2xi3"],
["國產","guo2chan3"],
["國美","guo2mei3"],
["國語","guo2yu3"],
["國都","guo2du1"],
["國務卿","guo2wu4qing1"],
["國務院","guo2wu4yuan4"],
["國子監","guo2zi3jian4"],
["國務委員","guo2wu4wei3yuan2"],
["國務次卿","guo2wu4ci4qing1"]
],
"圍":[
["圍剿","wei2jiao3"],
["圍場","wei2chang3"],
["圍捕","wei2bu3"],
["圍攏","wei2long3"],
["圍起","wei2qi3"]
],
"園":[
["園圃","yuan2pu3"],
["園地","yuan2di4"]
],
"圓":[
["圓場","yuan2chang3"],
["圓拱","yuan2gong3"],
["圓滿","yuan2man3"],
["圓頂","yuan2ding3"],
["圓領","yuan2ling3"],
["圓餅","yuan2bing3"]
],
"圖":[
["圖爾","tu2er3"],
["圖版","tu2ban3"],
["圖紙","tu2zhi3"],
["圖表","tu2biao3"],
["圖譜","tu2pu3"],
["圖輯","tu2ji2"],
["圖波列夫","tu2bo1lie4fu1"]
],
"團":[
["團伙","tuan2huo3"],
["團長","tuan2zhang3"],
["團體","tuan2ti3"],
["團團轉","tuan2tuan2zhuan4"],
["團結就是力量","tuan2jie2jiu4shi4li4liang4"]
],
"土":[
["土产","tu3chan3"],
["土匪","tu3fei3"],
["土地","tu3di4"],
["土壤","tu3rang3"],
["土岗","tu3gang3"],
["土崗","tu3gang3"],
["土狗","tu3gou3"],
["土產","tu3chan3"],
["土著","tu3zhu4"],
["土生土長","tu3sheng1tu3zhang3"],
["土生土长","tu3sheng1tu3zhang3"]
],
"圣":[
["圣体","sheng4ti3"],
["圣地","sheng4di4"],
["圣子","sheng4zi3"],
["圣所","sheng4suo3"],
["圣手","sheng4shou3"],
["圣旨","sheng4zhi3"],
["圣母","sheng4mu3"],
["圣水","sheng4shui3"],
["圣洗","sheng4xi3"],
["圣火","sheng4huo3"],
["圣礼","sheng4li3"],
["圣者","sheng4zhe3"],
["圣迹","sheng4ji4"],
["圣经外传","sheng4jing1wai4zhuan4"],
["圣经贤传","sheng4jing1xian2zhuan4"],
["圣赫勒拿","sheng4he4lei1na2"],
["圣潘克勒斯站","sheng4pan1ke4lei1si1zhan4"]
],
"在":[
["在场","zai4chang3"],
["在場","zai4chang3"],
["在岗","zai4gang3"],
["在崗","zai4gang3"],
["在於","zai4yu2"],
["在此","zai4ci3"],
["在行","zai4hang2"],
["在野","zai4ye3"],
["在一达","zai4yi4da2"],
["在一達","zai4yi4da2"],
["在下面","zai4xia4mian4"],
["在你看來","zai4ni3kan4lai2"],
["在你看来","zai4ni3kan4lai2"]
],
"地":[
["地上","di4shang5"],
["地下","di4xia4"],
["地主","di4zhu3"],
["地产","di4chan3"],
["地亩","di4mu3"],
["地位","di4wei4"],
["地出","di4chu1"],
["地利","di4li4"],
["地动","di4dong4"],
["地势","di4shi4"],
["地動","di4dong4"],
["地勢","di4shi4"],
["地区","di4qu1"],
["地區","di4qu1"],
["地史","di4shi3"],
["地名","di4ming2"],
["地图","di4tu2"],
["地圖","di4tu2"],
["地土","di4tu3"],
["地址","di4zhi3"],
["地块","di4kuai4"],
["地坛","di4tan2"],
["地垄","di4long3"],
["地域","di4yu4"],
["地基","di4ji1"],
["地堑","di4qian4"],
["地堡","di4bao3"],
["地塊","di4kuai4"],
["地塹","di4qian4"],
["地壇","di4tan2"],
["地壟","di4long3"],
["地壳","di4qiao4"],
["地处","di4chu3"],
["地契","di4qi4"],
["地宫","di4gong1"],
["地宮","di4gong1"],
["地层","di4ceng2"],
["地層","di4ceng2"],
["地带","di4dai4"],
["地帶","di4dai4"],
["地幔","di4man4"],
["地底","di4di3"],
["地形","di4xing2"],
["地支","di4zhi1"],
["地方","di4fang5"],
["地板","di4ban3"],
["地极","di4ji2"],
["地标","di4biao1"],
["地核","di4he2"],
["地極","di4ji2"],
["地標","di4biao1"],
["地步","di4bu4"],
["地段","di4duan4"],
["地殼","di4qiao4"],
["地毯","di4tan3"],
["地气","di4qi4"],
["地氣","di4qi4"],
["地沉","di4chen2"],
["地洞","di4dong4"],
["地滑","di4hua2"],
["地漏","di4lou4"],
["地炉","di4lu2"],
["地点","di4dian3"],
["地热","di4re4"],
["地照","di4zhao4"],
["地熱","di4re4"],
["地爐","di4lu2"],
["地牢","di4lao2"],
["地狱","di4yu4"],
["地獄","di4yu4"],
["地球","di4qiu2"],
["地理","di4li3"],
["地產","di4chan3"],
["地界","di4jie4"],
["地畝","di4mu3"],
["地痞","di4pi3"],
["地的","di4de5"],
["地皮","di4pi2"],
["地盘","di4pan2"],
["地盤","di4pan2"],
["地租","di4zu1"],
["地积","di4ji1"],
["地稅","di4shui4"],
["地税","di4shui4"],
["地積","di4ji1"],
["地穴","di4xue2"],
["地窖","di4jiao4"],
["地級","di4ji2"],
["地線","di4xian4"],
["地緣","di4yuan2"],
["地级","di4ji2"],
["地线","di4xian4"],
["地缘","di4yuan2"],
["地脈","di4mai4"],
["地脉","di4mai4"],
["地藏","di4zang4"],
["地處","di4chu3"],
["地衣","di4yi1"],
["地表","di4biao3"],
["地裂","di4lie4"],
["地貌","di4mao4"],
["地質","di4zhi4"],
["地质","di4zhi4"],
["地軸","di4zhou2"],
["地轴","di4zhou2"],
["地运","di4yun4"],
["地運","di4yun4"],
["地道","di4dao5"],
["地邻","di4lin2"],
["地鄰","di4lin2"],
["地鐵","di4tie3"],
["地铁","di4tie3"],
["地雷","di4lei2"],
["地震","di4zhen4"],
["地面","di4mian4"],
["地黃","di4huang2"],
["地黄","di4huang2"],
["地點","di4dian3"],
["地中海","di4zhong1hai3"],
["地平線","di4ping2xian4"],
["地平线","di4ping2xian4"],
["地心說","di4xin1shuo1"],
["地心说","di4xin1shuo1"],
["地拉那","di4la1na4"],
["地方官","di4fang1guan1"],
["地方性","di4fang1xing4"],
["地磁场","di4ci2chang3"],
["地磁場","di4ci2chang3"],
["地西泮","di4xi1pan4"],
["地躺拳","di4tang3quan2"],
["地久天長","di4jiu3tian1chang2"],
["地久天长","di4jiu3tian1chang2"],
["地勤人员","di4qin2ren2yuan2"],
["地勤人員","di4qin2ren2yuan2"],
["地塞米松","di4sai1mi3song1"],
["地心吸力","di4xin1xi1li4"],
["地心引力","di4xin1yin3li4"],
["地方主义","di4fang1zhu3yi4"],
["地方主義","di4fang1zhu3yi4"],
["地方政府","di4fang1zheng4fu3"],
["地方法院","di4fang1fa3yuan4"],
["地方自治","di4fang1zi4zhi4"],
["地方选举","di4fang1xuan2ju3"],
["地方選舉","di4fang1xuan2ju3"],
["地对空导弹","di4dui4kong1dao3dan4"],
["地對空導彈","di4dui4kong1dao3dan4"],
["地方民族主义","di4fang1min2zu2zhu3yi4"],
["地方民族主義","di4fang1min2zu2zhu3yi4"]
],
"场":[
["场地","chang3di4"],
["场所","chang3suo3"],
["场景","chang3jing3"],
["场院","chang2yuan4"],
["场外应急","chang3wai4ying1ji2"]
],
"均":[
["均可","jun1ke3"],
["均差","jun1cha1"],
["均等","jun1deng3"],
["均一性","jun1yi2xing4"]
],
"坎":[
["坎儿","kan3r5"],
["坎坎","kan3kan3"],
["坎坷","kan3ke3"],
["坎肩儿","kan3jian1r5"]
],
"坏":[
["坏处","huai4chu5"],
["坏死","huai4si3"],
["坏种","huai4zhong3"],
["坏主意","huai4zhu3yi4"],
["坏包儿","huai4bao1r5"]
],
"坐":[
["坐下","zuo4xia5"],
["坐地","zuo4di4"],
["坐好","zuo4hao3"],
["坐椅","zuo4yi3"],
["坐满","zuo4man3"],
["坐滿","zuo4man3"],
["坐禪","zuo4chan2"],
["坐下來","zuo4xia4lai2"],
["坐下来","zuo4xia4lai2"],
["坐不上","zuo4bu5shang4"],
["坐不下","zuo4bu5xia4"],
["坐不住","zuo4bu5zhu4"],
["坐不开","zuo4bu5kai1"],
["坐不牢","zuo4bu5lao2"],
["坐不稳","zuo4bu5wen3"],
["坐不穩","zuo4bu5wen3"],
["坐不起","zuo4bu5qi3"],
["坐不開","zuo4bu5kai1"]
],
"坑":[
["坑口","keng1kou3"],
["坑坑洼洼","keng1keng5wa1wa1"],
["坑坑窪窪","keng1keng5wa1wa1"]
],
"块":[
["块体","kuai4ti3"],
["块垒","kuai4lei3"],
["块菌","kuai4jun4"],
["块儿八毛","kuai4r5ba1mao2"]
],
"坚":[
["坚守","jian1shou3"],
["坚忍","jian1ren3"],
["坚挺","jian1ting3"],
["坚果","jian1guo3"]
],
"坟":[
["坟地","fen2di4"],
["坟场","fen2chang3"]
],
"坠":[
["坠毁","zhui4hui3"]
],
"坦":[
["坦率","tan3shuai4"]
],
"垂":[
["垂体","chui2ti3"],
["垂死","chui2si3"],
["垂體","chui2ti3"],
["垂头丧气","chui2tou2sang4qi4"],
["垂手可得","chui2shou3ke3de2"],
["垂手而得","chui2shou3er2de2"],
["垂頭喪氣","chui2tou2sang4qi4"]
],
"型":[
["型板","xing2ban3"]
],
"垣":[
["垣曲","yuan2qu3"]
],
"垫":[
["垫圈","dian4juan4"],
["垫款","dian4kuan3"],
["垫脚","dian4jiao5"],
["垫补","dian4bu5"],
["垫不起","dian4bu5qi3"],
["垫底儿","dian4di3r5"],
["垫脚石","dian4jiao3shi2"]
],
"埃":[
["埃塔","ai1ta3"],
["埃尔","ai1er3"],
["埃爾","ai1er3"],
["埃及地","ai1ji2di4"],
["埃裡溫","ai1li3wen1"],
["埃夫伯里","ai1fu1bo2li3"],
["埃克巴坦那","ai1ke4ba1tan3na4"],
["埃塞俄比亚","ai1sai4e2bi3ya4"],
["埃塞俄比亞","ai1sai4e2bi3ya4"]
],
"埋":[
["埋伏","mai2fu5"],
["埋怨","man2yuan4"],
["埋沒","mai2mo4"],
["埋没","mai2mo4"]
],
"城":[
["城口","cheng2kou3"],
["城堡","cheng2bao3"],
["城府","cheng2fu3"],
["城裡","cheng2li3"],
["城里","cheng2li3"]
],
"執":[
["執掌","zhi2zhang3"],
["執法","zhi2fa3"],
["執著","zhi2zhuo2"],
["執行長","zhi2xing2zhang3"]
],
"培":[
["培养","pei2yang3"],
["培土","pei2tu3"],
["培養","pei2yang3"]
],
"基":[
["基准","ji1zhun3"],
["基地","ji1di4"],
["基址","ji1zhi3"],
["基尔","ji1er3"],
["基底","ji1di3"],
["基抹","ji1mo3"],
["基於","ji1yu2"],
["基本","ji1ben3"],
["基板","ji1ban3"],
["基法","ji1fa3"],
["基準","ji1zhun3"],
["基点","ji1dian3"],
["基爾","ji1er3"],
["基玛","ji1ma3"],
["基瑪","ji1ma3"],
["基础","ji1chu3"],
["基礎","ji1chu3"],
["基網","ji1wang3"],
["基网","ji1wang3"],
["基脚","ji1jiao3"],
["基腳","ji1jiao3"],
["基輔","ji1fu3"],
["基辅","ji1fu3"],
["基點","ji1dian3"],
["基巴珥","ji1ba1er3"],
["基本上","ji1ben3shang5"],
["基裡巴斯共和國","ji1li3ba1si1gong4he2guo2"]
],
"堂":[
["堂姐","tang2jie3"]
],
"堅":[
["堅守","jian1shou3"],
["堅忍","jian1ren3"],
["堅挺","jian1ting3"],
["堅果","jian1guo3"]
],
"堆":[
["堆垒","dui1lei3"],
["堆壘","dui1lei3"],
["堆满","dui1man3"],
["堆滿","dui1man3"],
["堆起","dui1qi3"],
["堆起來","dui1qi3lai5"],
["堆起来","dui1qi3lai5"],
["堆案盈几","dui1an4ying2ji1"]
],
"堡":[
["堡垒","bao3lei3"],
["堡壘","bao3lei3"]
],
"報":[
["報以","bao4yi3"],
["報喜","bao4xi3"],
["報導","bao4dao3"],
["報應","bao4ying4"],
["報曉","bao4xiao3"],
["報紙","bao4zhi3"],
["報考","bao4kao3"],
["報表","bao4biao3"],
["報警","bao4jing3"],
["報館","bao4guan3"],
["報不下","bao4bu5xia4"],
["報務員","bao4wu4yuan2"],
["報以一笑","bao4yi3yi2xiao4"]
],
"場":[
["場地","chang3di4"],
["場所","chang3suo3"],
["場景","chang3jing3"],
["場院","chang2yuan4"],
["場外應急","chang3wai4ying1ji2"]
],
"堵":[
["堵塞","du3se4"],
["堵不住","du3bu5zhu4"],
["堵得慌","du3de5huang5"]
],
"塊":[
["塊壘","kuai4lei3"],
["塊菌","kuai4jun4"],
["塊體","kuai4ti3"]
],
"塌":[
["塌实","ta1shi5"],
["塌實","ta1shi5"],
["塌成一摊","ta1cheng2yi4tan1"],
["塌成一攤","ta1cheng2yi4tan1"]
],
"塔":[
["塔扎","ta3za1"],
["塔玛","ta3ma3"],
["塔瑪","ta3ma3"],
["塔頂","ta3ding3"],
["塔顶","ta3ding3"],
["塔什干","ta3shi2gan1"],
["塔塔儿","ta3ta3r5"],
["塔裡木河","ta3li3mu4he2"],
["塔克拉玛干","ta3ke4la1ma3gan4"],
["塔克拉瑪干","ta3ke4la1ma3gan4"],
["塔那那利佛","ta3na4na4li4fo2"],
["塔克拉玛干沙漠","ta3ke4la1ma3gan1sha1mo4"],
["塔克拉瑪干沙漠","ta3ke4la1ma3gan1sha1mo4"]
],
"塗":[
["塗寫","tu2xie3"],
["塗抹","tu2mo3"],
["塗油於","tu2you2yu2"]
],
"塞":[
["塞外","sai4wai4"],
["塞满","sai1man3"],
["塞滿","sai1man3"],
["塞特","sai4te4"],
["塞給","sai1gei3"],
["塞给","sai1gei3"],
["塞語","sai1yu3"],
["塞语","sai1yu3"],
["塞尔南","sai4er3nan2"],
["塞拉凡","sai4la1fan2"],
["塞爾南","sai4er3nan2"],
["塞琉古","sai4liu2gu3"],
["塞舌尔","sai4she2er3"],
["塞舌爾","sai4she2er3"],
["塞內加爾","sai4nei4jia1er3"],
["塞内加尔","sai4nei4jia1er3"],
["塞哥維亞","se4ge1wei2ya4"],
["塞哥维亚","se4ge1wei2ya4"],
["塞尔维亚","se4er3wei2ya4"],
["塞尔维特","se4er3wei2te4"],
["塞拉利昂","sai4la1li4ang2"],
["塞浦路斯","sai4pu3lu4si1"],
["塞爾維亞","se4er3wei2ya4"],
["塞爾維特","se4er3wei2te4"],
["塞琉西亚","se4liu2xi1ya4"],
["塞琉西亞","se4liu2xi1ya4"],
["塞翁失馬","sai4weng1shi1ma3"],
["塞翁失马","sai4weng1shi1ma3"],
["塞韋裡諾","sai4wei2li3nuo4"],
["塞韦里诺","sai4wei2li3nuo4"],
["塞尔维亚语","sai1er3wei2ya4yu3"],
["塞爾維亞語","sai1er3wei2ya4yu3"]
],
"填":[
["填写","tian2xie3"],
["填堵","tian2du3"],
["填寫","tian2xie3"],
["填海","tian2hai3"],
["填满","tian2man3"],
["填滿","tian2man3"],
["填空","tian2kong4"],
["填补","tian2bu3"],
["填表","tian2biao3"],
["填補","tian2bu3"],
["填飽","tian2bao3"],
["填饱","tian2bao3"]
],
"塬":[
["塬地","yuan2di4"]
],
"塵":[
["塵土","chen2tu3"]
],
"境":[
["境地","jing4di4"]
],
"墊":[
["墊圈","dian4juan4"],
["墊款","dian4kuan3"],
["墊腳","dian4jiao5"],
["墊補","dian4bu5"],
["墊不起","dian4bu5qi3"],
["墊腳石","dian4jiao3shi2"]
],
"墒":[
["墒土","shang1tu3"]
],
"墓":[
["墓主","mu4zhu3"],
["墓地","mu4di4"],
["墓塔","mu4ta3"]
],
"墙":[
["墙脚","qiang2jiao3"],
["墙角","qiang2jiao3"]
],
"墜":[
["墜毀","zhui4hui3"]
],
"增":[
["增产","zeng1chan3"],
["增减","zeng1jian3"],
["增广","zeng1guang3"],
["增廣","zeng1guang3"],
["增減","zeng1jian3"],
["增產","zeng1chan3"],
["增补","zeng1bu3"],
["增補","zeng1bu3"],
["增長","zeng1zhang3"],
["增长","zeng1zhang3"]
],
"墨":[
["墨子","mo4zi3"],
["墨守","mo4shou3"],
["墨斗","mo4dou3"],
["墨水","mo4shui3"],
["墨笔","mo4bi3"],
["墨筆","mo4bi3"],
["墨者","mo4zhe3"],
["墨跡","mo4ji4"],
["墨迹","mo4ji4"],
["墨水儿","mo4shui3r5"]
],
"墳":[
["墳地","fen2di4"],
["墳場","fen2chang3"]
],
"壁":[
["壁垒","bi4lei3"],
["壁壘","bi4lei3"],
["壁毯","bi4tan3"],
["壁紙","bi4zhi3"],
["壁纸","bi4zhi3"],
["壁虎","bi4hu3"]
],
"壓":[
["壓倒","ya1dao3"],
["壓扁","ya1bian3"],
["壓擠","ya1ji3"],
["壓死","ya1si3"],
["壓緊","ya1jin3"],
["壓不住","ya1bu5zhu4"],
["壓不過","ya1bu5guo4"]
],
"壞":[
["壞死","huai4si3"],
["壞種","huai4zhong3"],
["壞處","huai4chu5"],
["壞主意","huai4zhu3yi4"]
],
"壤":[
["壤土","rang3tu3"]
],
"壬":[
["壬午","ren2wu3"],
["壬子","ren2zi3"]
],
"壮":[
["壮举","zhuang4ju3"],
["壮美","zhuang4mei3"]
],
"壯":[
["壯美","zhuang4mei3"],
["壯舉","zhuang4ju3"]
],
"声":[
["声乐","sheng1yue4"],
["声卡","sheng1ka3"],
["声响","sheng1xiang3"],
["声母","sheng1mu3"]
],
"壳":[
["壳质","qiao4zhi4"]
],
"壽":[
["壽數","shou4shu5"],
["壽星","shou4xing5"],
["壽禮","shou4li3"],
["壽險","shou4xian3"],
["壽數已盡","shou4shu5yi3jin4"]
],
"处":[
["处世","chu3shi4"],
["处事","chu3shi4"],
["处于","chu3yu2"],
["处决","chu3jue2"],
["处分","chu3fen4"],
["处在","chu3zai4"],
["处境","chu3jing4"],
["处女","chu3nv3"],
["处所","chu4suo3"],
["处方","chu3fang1"],
["处暑","chu3shu3"],
["处死","chu3si3"],
["处治","chu3zhi4"],
["处理","chu3li3"],
["处男","chu3nan2"],
["处罚","chu3fa2"],
["处置","chu3zhi4"],
["处身","chu3shen1"],
["处不下","chu4bu5xia4"],
["处不来","chu3bu5lai2"],
["处得来","chu3de5lai2"],
["处之泰然","chu3zhi1tai4ran2"]
],
"备":[
["备取","bei4qu3"],
["备品","bei4pin3"],
["备抵","bei4di3"],
["备有","bei4you3"],
["备考","bei4kao3"]
],
"复":[
["复兴","fu4xing1"],
["复写","fu4xie3"],
["复古","fu4gu3"],
["复审","fu4shen3"],
["复本","fu4ben3"],
["复比","fu4bi3"],
["复眼","fu4yan3"],
["复诊","fu4zhen3"],
["复转","fu4zhuan3"],
["复辟","fu4bi4"]
],
"夏":[
["夏琐","xia4suo3"],
["夏瑣","xia4suo3"],
["夏甲","xia4jia3"],
["夏衍","xia4yan3"]
],
"外":[
["外企","wai4qi3"],
["外典","wai4dian3"],
["外务","wai4wu4"],
["外務","wai4wu4"],
["外地","wai4di4"],
["外场","wai4chang3"],
["外場","wai4chang3"],
["外头","wai4tou5"],
["外甥","wai4sheng5"],
["外相","wai4xiang4"],
["外耳","wai4er3"],
["外行","wai4hang2"],
["外表","wai4biao3"],
["外語","wai4yu3"],
["外语","wai4yu3"],
["外賈","wai4jia3"],
["外贾","wai4jia3"],
["外边","wai4bian5"],
["外邊","wai4bian5"],
["外長","wai4zhang3"],
["外长","wai4zhang3"],
["外面","wai4mian5"],
["外頭","wai4tou5"],
["外埔乡","wai4bu4xiang1"],
["外埔鄉","wai4bu4xiang1"],
["外蒙古","wai4meng2gu3"],
["外甥女婿","wai4sheng1nv3xu4"],
["外甥媳妇","wai4sheng1xi2fu5"],
["外甥媳婦","wai4sheng1xi2fu5"]
],
"多":[
["多久","duo1jiu3"],
["多产","duo1chan3"],
["多佛","duo1fo2"],
["多儿","duo1r5"],
["多党","duo1dang3"],
["多卡","duo1ka3"],
["多咱","duo1zan5"],
["多嘴","duo1zui3"],
["多坦","duo1tan3"],
["多寡","duo1gua3"],
["多少","duo1shao3"],
["多尔","duo1er3"],
["多採","duo1cai3"],
["多於","duo1yu2"],
["多爾","duo1er3"],
["多珥","duo1er3"],
["多瑙","duo1nao3"],
["多產","duo1chan3"],
["多礼","duo1li3"],
["多禮","duo1li3"],
["多种","duo1zhong3"],
["多種","duo1zhong3"],
["多語","duo1yu3"],
["多语","duo1yu3"],
["多远","duo1yuan3"],
["多遠","duo1yuan3"],
["多采","duo1cai3"],
["多难","duo1nan4"],
["多難","duo1nan4"],
["多馬","duo1ma3"],
["多马","duo1ma3"],
["多黨","duo1dang3"],
["多巴胺","duo1ba1an4"],
["多重性","duo1chong2xing4"],
["多不勝數","duo1bu2sheng4shu3"],
["多不胜数","duo1bu2sheng4shu3"],
["多劳多得","duo1lao2duo1de2"],
["多勞多得","duo1lao2duo1de2"],
["多子多孙","duo1zi3duo1sun1"],
["多子多孫","duo1zi3duo1sun1"],
["多那太罗","duo1na3tai4luo2"],
["多那太羅","duo1na3tai4luo2"],
["多重国籍","duo1chong2guo2ji2"],
["多重國籍","duo1chong2guo2ji2"]
],
"夜":[
["夜叉","ye4cha5"],
["夜晚","ye4wan3"],
["夜景","ye4jing3"],
["夜曲","ye4qu3"],
["夜里","ye4li5"],
["夜鳥","ye4niao3"],
["夜鸟","ye4niao3"],
["夜宵儿","ye4xiao1r5"]
],
"夢":[
["夢想","meng4xiang3"],
["夢景","meng4jing3"],
["夢見","meng4jian5"],
["夢魘","meng4yan3"]
],
"大":[
["大为","da4wei2"],
["大举","da4ju3"],
["大人","da4ren5"],
["大伙","da4huo3"],
["大伟","da4wei3"],
["大体","da4ti3"],
["大佬","da4lao3"],
["大使","da4shi3"],
["大偉","da4wei3"],
["大兴","da4xing1"],
["大写","da4xie3"],
["大冶","da4ye3"],
["大勇","da4yong3"],
["大口","da4kou3"],
["大喊","da4han3"],
["大喜","da4xi3"],
["大嗓","da4sang3"],
["大嚷","da4rang3"],
["大地","da4di4"],
["大坂","da4ban3"],
["大坦","da4tan3"],
["大埔","da4bu4"],
["大夥","da4huo3"],
["大夫","dai4fu5"],
["大夼","da4kuang3"],
["大奖","da4jiang3"],
["大好","da4hao3"],
["大姐","da4jie3"],
["大娘","da4niang2"],
["大嫂","da4sao3"],
["大宇","da4yu3"],
["大宝","da4bao3"],
["大寫","da4xie3"],
["大寶","da4bao3"],
["大将","da4jiang4"],
["大將","da4jiang4"],
["大小","da4xiao3"],
["大巴","da4ba1"],
["大指","da4zhi3"],
["大摆","da4bai3"],
["大擺","da4bai3"],
["大方","da4fang5"],
["大於","da4yu2"],
["大暑","da4shu3"],
["大有","da4you3"],
["大桶","da4tong3"],
["大比","da4bi3"],
["大水","da4shui3"],
["大海","da4hai3"],
["大火","da4huo3"],
["大為","da4wei2"],
["大爷","da4ye2"],
["大爺","da4ye2"],
["大獎","da4jiang3"],
["大理","da4li3"],
["大禹","da4yu3"],
["大笔","da4bi3"],
["大筆","da4bi3"],
["大米","da4mi3"],
["大胆","da4dan3"],
["大脑","da4nao3"],
["大脚","da4jiao3"],
["大腦","da4nao3"],
["大腳","da4jiao3"],
["大腿","da4tui3"],
["大膽","da4dan3"],
["大興","da4xing1"],
["大舉","da4ju3"],
["大衮","da4gun3"],
["大袞","da4gun3"],
["大解","da4jie3"],
["大选","da4xuan3"],
["大選","da4xuan3"],
["大里","da4li5"],
["大釜","da4fu3"],
["大阪","da4ban3"],
["大阮","da4ruan3"],
["大难","da4nan4"],
["大雅","da4ya3"],
["大難","da4nan4"],
["大雨","da4yu3"],
["大雪","da4xue3"],
["大餅","da4bing3"],
["大饼","da4bing3"],
["大馬","da4ma3"],
["大马","da4ma3"],
["大體","da4ti3"],
["大鴇","da4bao3"],
["大鸨","da4bao3"],
["大黃","dai4huang2"],
["大黄","dai4huang2"],
["大鼓","da4gu3"],
["大鼠","da4shu3"],
["大不了","da4bu5liao3"],
["大人物","da4ren2wu4"],
["大伙儿","da4huo3r5"],
["大体上","da4ti3shang5"],
["大分县","da4fen4xian4"],
["大分子","da4fen1zi3"],
["大分縣","da4fen4xian4"],
["大女儿","da4nv3r5"],
["大女兒","da4nv3r5"],
["大学生","da4xue2sheng1"],
["大學生","da4xue2sheng1"],
["大拇指","da4mu5zhi3"],
["大方县","da4fang1xian4"],
["大方縣","da4fang1xian4"],
["大氧吧","da4yang3ba1"],
["大融炉","rong2lu2da4"],
["大融爐","rong2lu2da4"],
["大部份","da4bu4fen5"],
["大都会","da4du1hui4"],
["大都會","da4du1hui4"],
["大體上","da4ti3shang5"],
["大麥地","da4mai4di4"],
["大麦地","da4mai4di4"],
["大黃蜂","da4huang2feng1"],
["大黃魚","da4huang2yu2"],
["大黄蜂","da4huang2feng1"],
["大黄鱼","da4huang2yu2"],
["大不列蹀","da4bu5lie5die5"],
["大中学生","da4zhong1xue2sheng5"],
["大中學生","da4zhong1xue2sheng5"],
["大发牢骚","da4fa1lao2sao5"],
["大可一試","da4ke3yi2shi4"],
["大可一试","da4ke3yi2shi4"],
["大可不必","da4ke3bu2bi4"],
["大吹大擂","da4chui1da4lei2"],
["大喝一声","da4he4yi4sheng1"],
["大喝一聲","da4he4yi4sheng1"],
["大干一场","da4gan4yi4chang3"],
["大干一票","da4gan4yi2piao4"],
["大幹一場","da4gan4yi4chang3"],
["大幹一票","da4gan4yi2piao4"],
["大戶人家","da4hu4ren2jia1"],
["大户人家","da4hu4ren2jia1"],
["大有可为","da4you3ke3wei2"],
["大有可為","da4you3ke3wei2"],
["大發牢騷","da4fa1lao2sao5"],
["大闹一场","da4nao4yi4chang3"],
["大鬧一場","da4nao4yi4chang3"],
["大洋型地殻","da4yang2xing1di4qiao4"]
],
"天":[
["天主","tian1zhu3"],
["天井","tian1jing3"],
["天仙","tian1xian1"],
["天体","tian1ti3"],
["天使","tian1shi3"],
["天儿","tian1r5"],
["天分","tian1fen4"],
["天台","tian1tai1"],
["天哪","tian1na5"],
["天地","tian1di4"],
["天好","tian1hao3"],
["天子","tian1zi3"],
["天府","tian1fu3"],
["天水","tian1shui3"],
["天演","tian1yan3"],
["天等","tian1deng3"],
["天篷","tian1peng2"],
["天险","tian1xian3"],
["天險","tian1xian3"],
["天頂","tian1ding3"],
["天顶","tian1ding3"],
["天體","tian1ti3"],
["天妇罗","tian1fu4luo1"],
["天婦羅","tian1fu4luo1"],
["天不作美","tian1bu5zuo4mei3"],
["天主教徒","tian1zhu3jiao1tu2"],
["天寒地冻","tian1han2di4dong4"],
["天寒地凍","tian1han2di4dong4"],
["天旋地轉","tian1xuan2di4zhuan4"],
["天旋地转","tian1xuan2di4zhuan4"],
["天昏地暗","tian1hun1di4an4"],
["天竺牡丹","tian1zhu2mu3dan1"],
["天經地義","tian1jing1di4yi4"],
["天经地义","tian1jing1di4yi4"],
["天翻地覆","tian1fan1di4fu4"],
["天長地久","tian1chang2di4jiu3"],
["天长地久","tian1chang2di4jiu3"],
["天不轉地轉","tian1bu5zhuan4di4zhuan4"],
["天不转地转","tian1bu5zhuan4di4zhuan4"],
["天字第一号","tian1zi4di4yi1hao4"],
["天字第一號","tian1zi4di4yi1hao4"],
["天一句地一句","tian1yi2ju4di4yi2ju4"],
["天下文章一大抄","tian1xia4wen2zhang1yi2da4chao1"]
],
"太":[
["太保","tai4bao3"],
["太古","tai4gu3"],
["太太","tai4tai5"],
["太子","tai4zi3"],
["太守","tai4shou3"],
["太少","tai4shao3"],
["太祖","tai4zu3"],
["太老","tai4lao3"],
["太谷","tai4gu3"],
["太行山","tai4hang2shan1"],
["太古洋行","tai4gu3yang2hang2"],
["太阳黑子","tai4yang2hei1zi3"],
["太陽黑子","tai4yang2hei1zi3"]
],
"夫":[
["夫人","fu1ren5"],
["夫妇","fu1fu4"],
["夫妻","fu1qi1"],
["夫婦","fu1fu4"],
["夫子","fu1zi3"],
["夫家","fu1jia1"],
["夫权","fu1quan2"],
["夫權","fu1quan2"]
],
"央":[
["央告","yang1gao5"],
["央行","yang1hang2"]
],
"夯":[
["夯土","hang1tu3"]
],
"失":[
["失主","shi1zhu3"],
["失口","shi1kou3"],
["失地","shi1di4"],
["失宜","shi1yi2"],
["失宠","shi1chong3"],
["失寵","shi1chong3"],
["失当","shi1dang4"],
["失悔","shi1hui3"],
["失手","shi1shou3"],
["失枕","shi1zhen3"],
["失欢","shi1huan1"],
["失歡","shi1huan1"],
["失火","shi1huo3"],
["失當","shi1dang4"],
["失着","shi1zhao1"],
["失礼","shi1li3"],
["失禮","shi1li3"],
["失脚","shi1jiao3"],
["失腳","shi1jiao3"],
["失著","shi1zhao1"],
["失語","shi1yu3"],
["失調","shi1tiao2"],
["失语","shi1yu3"],
["失调","shi1tiao2"],
["失而复得","shi1er2fu4de2"],
["失而復得","shi1er2fu4de2"]
],
"头":[
["头儿","tou2r5"],
["头冠","tou2guan1"],
["头发","tou2fa5"],
["头奖","tou2jiang3"],
["头打","tou2da3"],
["头挡","tou2dang3"],
["头枕","tou2zhen3"],
["头版","tou2ban3"],
["头等","tou2deng3"],
["头脑","tou2nao3"],
["头脸","tou2lian3"],
["头角","tou2jiao3"],
["头里","tou2li5"],
["头面","tou2mian5"],
["头顶","tou2ding3"],
["头领","tou2ling3"],
["头骨","tou2gu3"],
["头一摸","tou2yi4mo1"],
["头脸儿","tou2lian3r5"],
["头脑发胀","tou2nao3fa1zhang4"],
["头面人物","tou2mian4ren2wu4"]
],
"夸":[
["夸口","kua1kou3"],
["夸奖","kua1jiang3"]
],
"夹":[
["夹克","jia2ke4"],
["夹板","jia1ban3"],
["夹紧","jia1jin3"],
["夹衣","jia2yi1"],
["夹角","jia1jiao3"],
["夹塞儿","jia1sai1r5"],
["夹当儿","jia1dang1er5"]
],
"夺":[
["夺取","duo2qu3"],
["夺得","duo2de2"],
["夺走","duo2zou3"],
["夺不过","duo2bu5guo4"]
],
"夾":[
["夾克","jia2ke4"],
["夾板","jia1ban3"],
["夾緊","jia1jin3"],
["夾衣","jia2yi1"],
["夾角","jia1jiao3"],
["夾當兒","jia1dang1er5"]
],
"奇":[
["奇丑","qi2chou3"],
["奇偶","ji1ou3"],
["奇数","ji1shu4"],
["奇數","ji1shu4"],
["奇景","qi2jing3"],
["奇羡","ji1xian4"],
["奇羨","ji1xian4"],
["奇跡","qi2ji4"],
["奇蹟","qi2ji4"],
["奇迹","qi2ji4"],
["奇醜","qi2chou3"],
["奇函数","ji1han2shu4"],
["奇函數","ji1han2shu4"]
],
"奉":[
["奉养","feng4yang3"],
["奉差","feng4chai1"],
["奉承","feng4cheng5"],
["奉旨","feng4zhi3"],
["奉还","feng4huan2"],
["奉還","feng4huan2"],
["奉養","feng4yang3"],
["奉承討好","feng4cheng2tao3hao3"],
["奉承讨好","feng4cheng2tao3hao3"]
],
"奋":[
["奋勇","fen4yong3"],
["奋起","fen4qi3"],
["奋臂一呼","fen4bi4yi4hu1"]
],
"奏":[
["奏乐","zou4yue4"],
["奏樂","zou4yue4"],
["奏鳴曲","zou4ming2qu3"],
["奏鸣曲","zou4ming2qu3"]
],
"奔":[
["奔丧","ben1sang1"],
["奔喪","ben1sang1"],
["奔头","ben4tou2"],
["奔涌","ben1yong3"],
["奔走","ben1zou3"],
["奔跑","ben1pao3"],
["奔頭","ben4tou2"],
["奔馬","ben1ma3"],
["奔马","ben1ma3"],
["奔头儿","ben4tou5r5"],
["奔頭兒","ben4tou5r5"]
],
"奕":[
["奕詝","yi4zhu3"]
],
"奖":[
["奖品","jiang3pin3"],
["奖赏","jiang3shang3"],
["奖酬","jiang3chou2"]
],
"套":[
["套取","tao4qu3"],
["套套","tao4tao5"],
["套曲","tao4qu3"],
["套种","tao4zhong4"],
["套種","tao4zhong4"],
["套筒","tao4tong3"],
["套管","tao4guan3"],
["套索","tao4suo3"],
["套色","tao4shai3"],
["套語","tao4yu3"],
["套语","tao4yu3"],
["套馬","tao4ma3"],
["套马","tao4ma3"],
["套口供","tao4kou3gong4"],
["套衫儿","tao4shan1r5"],
["套马杆","tao4ma3gan3"]
],
"奠":[
["奠都","dian4du1"],
["奠酒","dian4jiu3"]
],
"奢":[
["奢侈","she1chi3"]
],
"奥":[
["奥什","ao4shi2"],
["奥马","ao4ma3"],
["奥塞梯","ao4se4ti1"],
["奥巴马","ao4ba1ma3"],
["奥林巴","ao4lin2ba1"],
["奥米伽","ao4mi3ga1"],
["奥黛丽","ao4da4li4"],
["奥切诺斯","ao4qie1nuo4si1"],
["奥古斯都","ao4gu3si1du1"]
],
"奧":[
["奧什","ao4shi2"],
["奧馬","ao4ma3"],
["奧塞梯","ao4se4ti1"],
["奧巴馬","ao4ba1ma3"],
["奧林巴","ao4lin2ba1"],
["奧米伽","ao4mi3ga1"],
["奧黛麗","ao4da4li4"],
["奧切諾斯","ao4qie1nuo4si1"],
["奧古斯都","ao4gu3si1du1"]
],
"奪":[
["奪取","duo2qu3"],
["奪得","duo2de2"],
["奪走","duo2zou3"],
["奪不過","duo2bu5guo4"]
],
"奮":[
["奮勇","fen4yong3"],
["奮起","fen4qi3"],
["奮臂一呼","fen4bi4yi4hu1"]
],
"女":[
["女傭","nv3yong1"],
["女兒","nv3er2"],
["女友","nv3you3"],
["女婿","nv3xu5"],
["女子","nv3zi3"],
["女紅","nv3gong1"],
["女红","nv3gong1"],
["女警","nv3jing3"],
["女孩儿","nv3hai2r5"],
["女舍监","nv3she4jian1"],
["女舍監","nv3she4jian1"]
],
"奶":[
["奶嘴","nai3zui3"],
["奶奶","nai3nai5"],
["奶水","nai3shui3"],
["奶粉","nai3fen3"],
["奶嘴儿","nai3zui3r5"]
],
"奸":[
["奸党","jian1dang3"],
["奸夫","jian1fu1"],
["奸宄","jian1gui3"],
["奸細","jian1xi5"],
["奸细","jian1xi5"],
["奸险","jian1xian3"],
["奸險","jian1xian3"],
["奸黨","jian1dang3"]
],
"她":[
["她得","ta1dei3"],
["她玛","ta1ma3"],
["她瑪","ta1ma3"],
["她得上","ta1de2shang4"],
["她得中","ta1de2zhong4"],
["她得主","ta1de2zhu3"],
["她得了","ta1de2le5"],
["她得享","ta1de2xiang3"],
["她得人","ta1de2ren2"],
["她得令","ta1de2ling4"],
["她得以","ta1de2yi3"],
["她得体","ta1de2ti3"],
["她得來","ta1de2lai2"],
["她得便","ta1de2bian4"],
["她得出","ta1de2chu1"],
["她得分","ta1de2fen1"],
["她得到","ta1de2dao4"],
["她得力","ta1de2li4"],
["她得劲","ta1de2jin4"],
["她得势","ta1de2shi4"],
["她得勁","ta1de2jin4"],
["她得勝","ta1de2sheng4"],
["她得勢","ta1de2shi4"],
["她得名","ta1de2ming2"],
["她得君","ta1de2jun1"],
["她得听","ta1de2ting1"],
["她得味","ta1de2wei4"],
["她得喜","ta1de2xi3"],
["她得失","ta1de2shi1"],
["她得奖","ta1de2jiang3"],
["她得子","ta1de2zi3"],
["她得宜","ta1de2yi2"],
["她得实","ta1de2shi2"],
["她得宠","ta1de2chong3"],
["她得實","ta1de2shi2"],
["她得寵","ta1de2chong3"],
["她得巴","ta1de2ba5"],
["她得年","ta1de2nian2"],
["她得幸","ta1de2xing4"],
["她得当","ta1de2dang4"],
["她得彩","ta1de2cai3"],
["她得很","ta1de5hen3"],
["她得得","ta1de2de2"],
["她得志","ta1de2zhi4"],
["她得悉","ta1de2xi1"],
["她得意","ta1de2yi4"],
["她得所","ta1de2suo3"],
["她得手","ta1de2shou3"],
["她得撒","ta1de2sa1"],
["她得救","ta1de2jiu4"],
["她得数","ta1de2shu4"],
["她得數","ta1de2shu4"],
["她得文","ta1de2wen2"],
["她得时","ta1de2shi2"],
["她得時","ta1de2shi2"],
["她得来","ta1de2lai2"],
["她得标","ta1de2biao1"],
["她得榮","ta1de2rong2"],
["她得標","ta1de2biao1"],
["她得民","ta1de2min2"],
["她得法","ta1de2fa3"],
["她得獎","ta1de2jiang3"],
["她得率","ta1de2lv4"],
["她得瑕","ta1de2xia2"],
["她得用","ta1de2yong4"],
["她得當","ta1de2dang4"],
["她得病","ta1de2bing4"],
["她得益","ta1de2yi4"],
["她得着","ta1de2zhao2"],
["她得知","ta1de2zhi1"],
["她得神","ta1de2shen2"],
["她得票","ta1de2piao4"],
["她得空","ta1de2kong4"],
["她得窍","ta1de2qiao4"],
["她得竅","ta1de2qiao4"],
["她得策","ta1de2ce4"],
["她得粮","ta1de2liang2"],
["她得糧","ta1de2liang2"],
["她得繼","ta1de2ji4"],
["她得继","ta1de2ji4"],
["她得罪","ta1de2zui5"],
["她得职","ta1de2zhi2"],
["她得職","ta1de2zhi2"],
["她得聽","ta1de2ting1"],
["她得胜","ta1de2sheng4"],
["她得脸","ta1de2lian3"],
["她得臉","ta1de2lian3"],
["她得自","ta1de2zi4"],
["她得色","ta1de2se4"],
["她得荣","ta1de2rong2"],
["她得著","ta1de2zhao2"],
["她得計","ta1de2ji4"],
["她得證","ta1de2zheng4"],
["她得计","ta1de2ji4"],
["她得证","ta1de2zheng4"],
["她得逞","ta1de2cheng3"],
["她得道","ta1de2dao4"],
["她得閑","ta1de2xian2"],
["她得間","ta1de2jian4"],
["她得闲","ta1de2xian2"],
["她得间","ta1de2jian4"],
["她得非","ta1de2fei1"],
["她得體","ta1de2ti3"],
["她得不到","ta1de2bu5dao4"],
["她得不着","ta1de2bu5zhao2"],
["她得不著","ta1de2bu5zhao2"],
["她得人儿","ta1de2ren2r5"],
["她得便儿","ta1de2bian4r5"],
["她得便宜","ta1de2pian2yi5"],
["她得劲儿","ta1de2jin4r5"],
["她得天下","ta1de2tian1xia4"],
["她得数儿","ta1de2shu4r5"],
["她得样儿","ta1de2yang4r5"],
["她得樣兒","ta1de2yang4r5"],
["她得益处","ta1de2yi4chu5"],
["她得益處","ta1de2yi4chu5"],
["她得空儿","ta1de2kong4r5"],
["她得罪人","ta1de2zui4ren2"]
],
"好":[
["好久","hao3jiu3"],
["好使","hao3shi3"],
["好儿","hao3r5"],
["好几","hao3ji3"],
["好勝","hao4sheng4"],
["好啊","hao3a1"],
["好处","hao3chu5"],
["好奇","hao4qi2"],
["好好","hao3hao1"],
["好学","hao4xue2"],
["好學","hao4xue2"],
["好客","hao4ke4"],
["好幾","hao3ji3"],
["好惹","hao3re3"],
["好感","hao3gan3"],
["好战","hao4zhan4"],
["好戰","hao4zhan4"],
["好斗","hao4dou4"],
["好歹","hao3dai3"],
["好死","hao3si3"],
["好比","hao3bi3"],
["好氧","hao4yang3"],
["好种","hao3zhong3"],
["好種","hao3zhong3"],
["好胜","hao4sheng4"],
["好色","hao4se4"],
["好處","hao3chu5"],
["好轉","hao3zhuan3"],
["好转","hao3zhuan3"],
["好辩","hao4bian4"],
["好辯","hao4bian4"],
["好鬥","hao4dou4"],
["好一个","hao3yi2ge4"],
["好一個","hao3yi2ge4"],
["好不了","hao3bu5liao3"],
["好不好","hao3bu5hao3"],
["好主意","hao3zhu3yi4"],
["好好儿","hao3hao1r5"],
["好得了","hao3de5liao3"],
["好玩儿","hao3wan2er5"],
["好玩兒","hao3wan2er5"],
["好久不見","hao3jiu3bu5jian4"],
["好久不见","hao3jiu3bu5jian4"],
["好吃懒做","hao4chi1lan3zuo4"],
["好吃懶做","hao4chi1lan3zuo4"],
["好好先生","hao3hao3xian1sheng1"],
["好管閑事","hao4guan3xian2shi4"],
["好管闲事","hao4guan3xian2shi4"],
["好好整一整","hao3hao3zheng3yi5zheng3"],
["好得没底儿","hao3de5mei2di3r5"]
],
"如":[
["如有","ru2you3"],
["如果","ru2guo3"],
["如此","ru2ci3"],
["如火","ru2huo3"],
["如草","ru2cao3"],
["如一日","ru2yi2ri4"],
["如出一轍","ru2chu1yi4zhe2"],
["如出一辙","ru2chu1yi4zhe2"],
["如得甘露","ru2de2gan1lu4"],
["如虎得翼","ru2hu3de2yi4"],
["如蝇逐臭","ru2ying2zhu2chou4"],
["如蠅逐臭","ru2ying2zhu2chou4"],
["如魚得水","ru2yu2de2shui3"],
["如鱼得水","ru2yu2de2shui3"]
],
"妄":[
["妄为","wang4wei2"],
["妄取","wang4qu3"],
["妄想","wang4xiang3"],
["妄為","wang4wei2"],
["妄語","wang4yu3"],
["妄语","wang4yu3"],
["妄自菲薄","wang4zi4fei3bo2"]
],
"妇":[
["妇女","fu4nv3"],
["妇道","fu4dao5"]
],
"妈":[
["妈咪","ma1mi5"],
["妈妈","ma1ma5"],
["妈祖","ma1zu3"]
],
"妓":[
["妓女","ji4nv3"]
],
"妖":[
["妖冶","yao1ye3"],
["妖精","yao1jing5"]
],
"妙":[
["妙品","miao4pin3"],
["妙手","miao4shou3"]
],
"妥":[
["妥当","tuo3dang5"],
["妥當","tuo3dang5"]
],
"妯":[
["妯娌","zhou2li5"]
],
"妹":[
["妹妹","mei4mei5"]
],
"妻":[
["妻兒","qi1er2"],
["妻小","qi1xiao3"],
["妻子管得严","qi1zi5guan3de2yan2"],
["妻子管得嚴","qi1zi5guan3de2yan2"]
],
"姊":[
["姊姊","zi3zi3"]
],
"始":[
["始兴","shi3xing1"],
["始点","shi3dian3"],
["始祖","shi3zu3"],
["始興","shi3xing1"],
["始點","shi3dian3"]
],
"姐":[
["姐姐","jie3jie5"]
],
"姑":[
["姑且","gu1qie3"],
["姑姑","gu1gu5"],
["姑息","gu1xi1"],
["姑母","gu1mu3"],
["姑父","gu1fu5"]
],
"委":[
["委婉","wei3wan3"],
["委屈","wei3qu5"],
["委靡","wei3mi3"],
["委员长","wei3yuan2zhang3"],
["委員長","wei3yuan2zhang3"]
],
"姥":[
["姥姥","lao3lao5"]
],
"姨":[
["姨姐","yi2jie3"],
["姨母","yi2mu3"],
["姨父","yi2fu5"]
],
"姪":[
["姪女","zhi2nv3"],
["姪女婿","zhi2nv3xu5"]
],
"威":[
["威吓","wei1he4"],
["威嚇","wei1he4"],
["威显","wei1xian3"],
["威武","wei1wu3"],
["威海","wei1hai3"],
["威猛","wei1meng3"],
["威远","wei1yuan3"],
["威遠","wei1yuan3"],
["威顯","wei1xian3"],
["威信扫地","wei1xin4sao3di4"],
["威信掃地","wei1xin4sao3di4"],
["威凤一羽","wei1feng4yi4yu3"],
["威鳳一羽","wei1feng4yi4yu3"]
],
"娃":[
["娃娃","wa2wa5"]
],
"娄":[
["娄底","lou2di3"]
],
"娇":[
["娇嫩","jiao1nen5"],
["娇小","jiao1xiao3"],
["娇贵","jiao1gui5"]
],
"娘":[
["娘娘","niang2niang5"],
["娘家","niang2jia5"],
["娘胎","niang2tai1"]
],
"娜":[
["娜亚","nuo2ya4"],
["娜亞","nuo2ya4"]
],
"娩":[
["娩痛","mian3tong4"]
],
"娼":[
["娼女","chang1nv3"]
],
"婀":[
["婀娜","e1nuo2"]
],
"婁":[
["婁底","lou2di3"]
],
"婆":[
["婆婆","po2po5"],
["婆家","po2jia5"],
["婆囉洲","po2luo2zhou1"]
],
"婉":[
["婉轉","wan3zhuan3"],
["婉转","wan3zhuan3"]
],
"婚":[
["婚礼","hun1li3"],
["婚禮","hun1li3"]
],
"婢":[
["婢女","bi4nv3"]
],
"婦":[
["婦女","fu4nv3"],
["婦道","fu4dao5"]
],
"婶":[
["婶婶","shen3shen5"],
["婶母","shen3mu3"]
],
"媒":[
["媒人","mei2ren5"],
["媒体","mei2ti3"],
["媒體","mei2ti3"]
],
"媚":[
["媚眼","mei4yan3"]
],
"媲":[
["媲美","pi4mei3"]
],
"媽":[
["媽咪","ma1mi5"],
["媽媽","ma1ma5"],
["媽祖","ma1zu3"]
],
"嫁":[
["嫁妆","jia4zhuang5"],
["嫁妝","jia4zhuang5"],
["嫁娶","jia4qu3"],
["嫁給","jia4gei3"],
["嫁给","jia4gei3"],
["嫁禍於人","jia4huo4yu2ren2"]
],
"嫂":[
["嫂嫂","sao3sao5"]
],
"嫌":[
["嫌恶","xian2wu4"],
["嫌惡","xian2wu4"]
],
"嫩":[
["嫩草","nen4cao3"]
],
"嫪":[
["嫪毐","lao4ai3"]
],
"嬌":[
["嬌兒","jiao1er2"],
["嬌嫩","jiao1nen5"],
["嬌小","jiao1xiao3"],
["嬌貴","jiao1gui5"]
],
"嬰":[
["嬰兒","ying1er2"]
],
"嬸":[
["嬸嬸","shen3shen5"],
["嬸母","shen3mu3"]
],
"子":[
["子丑","zi3chou3"],
["子代","zi3dai4"],
["子叶","zi3ye4"],
["子夜","zi3ye4"],
["子女","zi3nv3"],
["子孙","zi3sun1"],
["子孫","zi3sun1"],
["子宫","zi3gong1"],
["子宮","zi3gong1"],
["子层","zi3ceng2"],
["子層","zi3ceng2"],
["子弟","zi3di4"],
["子弹","zi3dan4"],
["子彈","zi3dan4"],
["子房","zi3fang2"],
["子民","zi3min2"],
["子洲","zi3zhou1"],
["子爵","zi3jue2"],
["子畜","zi3chu4"],
["子粒","zi3li4"],
["子系","zi3xi4"],
["子網","zi3wang3"],
["子网","zi3wang3"],
["子群","zi3qun2"],
["子葉","zi3ye4"],
["子規","zi3gui1"],
["子规","zi3gui1"],
["子路","zi3lu4"],
["子長","zi3chang2"],
["子长","zi3chang2"],
["子集","zi3ji2"],
["子音","zi3yin1"],
["子鼠","zi3shu3"],
["子公司","zi3gong1si1"],
["子午線","zi3wu3xian4"],
["子午线","zi3wu3xian4"],
["子囊菌","zi3nang2jun1"],
["子模型","zi3mo2xing2"],
["子母弹","zi3mu3dan4"],
["子母彈","zi3mu3dan4"],
["子程序","zi3cheng2xu4"],
["子空間","zi3kong1jian1"],
["子空间","zi3kong1jian1"],
["子細胞","zi3xi4bao1"],
["子细胞","zi3xi4bao1"],
["子子孙孙","zi3zi3sun1sun1"],
["子子孫孫","zi3zi3sun1sun1"],
["子母炮弹","zi3mu3pao4dan4"],
["子母炮彈","zi3mu3pao4dan4"],
["子母炸弹","zi3mu3zha4dan4"],
["子母炸彈","zi3mu3zha4dan4"]
],
"孔":[
["孔子","kong3zi3"],
["孔眼","kong3yan3"],
["孔丛子","kong3cong2zi3"],
["孔叢子","kong3cong2zi3"],
["孔子家語","kong3zi5jia1yu3"],
["孔子家语","kong3zi5jia1yu3"]
],
"孕":[
["孕产","yun4chan3"],
["孕吐","yun4tu4"],
["孕產","yun4chan3"]
],
"字":[
["字体","zi4ti3"],
["字典","zi4dian3"],
["字号","zi4hao5"],
["字尾","zi4wei3"],
["字帖","zi4tie4"],
["字母","zi4mu3"],
["字眼","zi4yan3"],
["字码","zi4ma3"],
["字碼","zi4ma3"],
["字號","zi4hao5"],
["字跡","zi4ji4"],
["字迹","zi4ji4"],
["字首","zi4shou3"],
["字體","zi4ti3"],
["字裡行間","zi4li3hang2jian1"]
],
"存":[
["存储","cun2chu3"],
["存儲","cun2chu3"],
["存取","cun2qu3"],
["存有","cun2you3"],
["存款","cun2kuan3"]
],
"孙":[
["孙女","sun1nv3"],
["孙子","sun1zi3"],
["孙武","sun1wu3"],
["孙女儿","sun1nv3r5"],
["孙武子","sun1wu3zi3"],
["孙逸仙","sun1yi4xian1"],
["孙子定理","sun1zi5ding4li3"]
],
"孝":[
["孝感","xiao4gan3"],
["孝道","xiao4dao5"]
],
"孟":[
["孟买","meng4mai3"],
["孟子","meng4zi3"],
["孟買","meng4mai3"]
],
"孢":[
["孢子","bao1zi3"]
],
"季":[
["季子","ji4zi3"],
["季相","ji4xiang4"]
],
"孤":[
["孤兒","gu1er2"],
["孤岛","gu1dao3"],
["孤島","gu1dao3"],
["孤胆","gu1dan3"],
["孤膽","gu1dan3"],
["孤苦","gu1ku3"],
["孤立子","gu1li4zi3"],
["孤零零","gu1ling1ling1"],
["孤儿寡妇","gu1er2gua3fu4"],
["孤兒寡婦","gu1er2gua3fu4"],
["孤注一掷","gu1zhu4yi2zhi4"],
["孤注一擲","gu1zhu4yi2zhi4"]
],
"学":[
["学好","xue2hao3"],
["学府","xue2fu3"],
["学海","xue2hai3"],
["学生","xue2sheng5"],
["学者","xue2zhe3"],
["学识","xue2shi2"],
["学问","xue2wen5"],
["学不了","xue2bu5liao3"],
["学不会","xue2bu5hui4"],
["学不来","xue2bu5lai2"],
["学百艺而无一精","xue2bai3yi4er2wu2yi4jing1"]
],
"孫":[
["孫女","sun1nv3"],
["孫子","sun1zi3"],
["孫武","sun1wu3"],
["孫武子","sun1wu3zi3"],
["孫逸仙","sun1yi4xian1"],
["孫子定理","sun1zi5ding4li3"]
],
"孬":[
["孬种","nao1zhong3"],
["孬種","nao1zhong3"]
],
"孱":[
["孱弱","chan2ruo4"]
],
"學":[
["學問","xue2wen5"],
["學好","xue2hao3"],
["學府","xue2fu3"],
["學海","xue2hai3"],
["學生","xue2sheng5"],
["學者","xue2zhe3"],
["學識","xue2shi2"],
["學不了","xue2bu5liao3"],
["學不來","xue2bu5lai2"],
["學不會","xue2bu5hui4"],
["學百藝而無一精","xue2bai3yi4er2wu2yi4jing1"]
],
"孽":[
["孽种","nie4zhong3"],
["孽種","nie4zhong3"]
],
"宁":[
["宁可","ning4ke3"],
["宁愿","ning4yuan4"],
["宁武","ning2wu3"],
["宁法","ning2fa3"],
["宁洱","ning4er3"],
["宁海","ning2hai3"],
["宁肯","ning4ken3"],
["宁远","ning2yuan3"],
["宁都","ning2du1"],
["宁陕","ning2shan3"],
["宁死不屈","ning4si3bu4qu1"],
["宁缺毋滥","ning4que1wu2lan4"]
],
"宅":[
["宅舍","zhai2she4"]
],
"守":[
["守丧","shou3sang1"],
["守住","shou3zhu5"],
["守分","shou3fen4"],
["守喪","shou3sang1"],
["守土","shou3tu3"],
["守寡","shou3gua3"],
["守更","shou3geng1"],
["守法","shou3fa3"],
["守不住","shou3bu5zhu4"],
["守空房","shou3kong4fang2"]
],
"安":[
["安享","an1xiang3"],
["安保","an1bao3"],
["安分","an1fen4"],
["安可","an1ke3"],
["安好","an1hao3"],
["安得","an1de2"],
["安息","an1xi1"],
["安抚","an1fu3"],
["安撫","an1fu3"],
["安於","an1yu2"],
["安检","an1jian3"],
["安檢","an1jian3"],
["安瓿","an1bu4"],
["安稳","an1wen3"],
["安穩","an1wen3"],
["安远","an1yuan3"],
["安遠","an1yuan3"],
["安不下","an1bu5xia4"],
["安地斯","an1di4si1"],
["安步当车","an1bu4dang4che1"],
["安步當車","an1bu4dang4che1"],
["安民告示","an1min2gao4shi4"],
["安提瓜和巴布达","an1ti2gua1he2ba1bu4da2"],
["安提瓜和巴布達","an1ti2gua1he2ba1bu4da2"]
],
"宋":[
["宋体","song4ti3"],
["宋史","song4shi3"],
["宋體","song4ti3"],
["宋楚瑜","song4chu3yu2"]
],
"完":[
["完好","wan2hao3"],
["完整","wan2zheng3"],
["完满","wan2man3"],
["完滿","wan2man3"],
["完美","wan2mei3"],
["完不了","wan2bu5liao3"],
["完不成","wan2bu5cheng2"],
["完成任务","wan2cheng2ren4wu4"],
["完成任務","wan2cheng2ren4wu4"]
],
"宏":[
["宏伟","hong2wei3"],
["宏偉","hong2wei3"]
],
"宗":[
["宗旨","zong1zhi3"]
],
"官":[
["官倒","guan1dao3"],
["官司","guan1si5"],
["官场","guan1chang3"],
["官場","guan1chang3"],
["官子","guan1zi3"],
["官差","guan1chai1"],
["官府","guan1fu3"],
["官署","guan1shu3"],
["官邸","guan1di3"],
["官長","guan1zhang3"],
["官长","guan1zhang3"],
["官老爷","guan1lao3ye2"],
["官老爺","guan1lao3ye2"],
["官宦人家","guan1huan4ren2jia1"]
],
"定":[
["定为","ding4wei2"],
["定兴","ding4xing1"],
["定当","ding4dang4"],
["定影","ding4ying3"],
["定於","ding4yu2"],
["定本","ding4ben3"],
["定海","ding4hai3"],
["定点","ding4dian3"],
["定為","ding4wei2"],
["定理","ding4li3"],
["定當","ding4dang4"],
["定睛","ding4jing1"],
["定礼","ding4li3"],
["定禮","ding4li3"],
["定興","ding4xing1"],
["定語","ding4yu3"],
["定语","ding4yu3"],
["定远","ding4yuan3"],
["定遠","ding4yuan3"],
["定點","ding4dian3"],
["定鼎","ding4ding3"],
["定下來","ding4xia4lai2"],
["定下来","ding4xia4lai2"],
["定场白","ding4chang2bai2"],
["定場白","ding4chang2bai2"]
],
"宜":[
["宜丰","yi2feng1"],
["宜人","yi2ren2"],
["宜兰","yi2lan2"],
["宜兴","yi2xing1"],
["宜君","yi2jun1"],
["宜城","yi2cheng2"],
["宜家","yi2jia1"],
["宜宾","yi2bin1"],
["宜山","yi2shan1"],
["宜川","yi2chuan1"],
["宜昌","yi2chang1"],
["宜春","yi2chun1"],
["宜章","yi2zhang1"],
["宜興","yi2xing1"],
["宜良","yi2liang2"],
["宜蘭","yi2lan2"],
["宜豐","yi2feng1"],
["宜賓","yi2bin1"],
["宜阳","yi2yang2"],
["宜陽","yi2yang2"],
["宜黃","yi2huang2"],
["宜黄","yi2huang2"]
],
"宝":[
["宝兴","bao3xing1"],
["宝坻","bao3di3"],
["宝塔","bao3ta3"],
["宝宝","bao3bao3"],
["宝藏","bao3zang4"],
["宝马","bao3ma3"],
["宝生佛","bao3sheng1fo2"],
["宝石匠","bao3shi2jiang4"],
["宝贝儿","bao3bei4r5"]
],
"实":[
["实体","shi2ti3"],
["实务","shi2wu4"],
["实地","shi2di4"],
["实女","shi2nv3"],
["实干","shi2gan4"],
["实有","shi2you3"],
["实肘","shi2zhou3"],
["实分析","shi2fen1xi1"],
["实际上","shi2ji4shang5"]
],
"审":[
["审处","shen3chu3"],
["审干","shen3gan4"],
["审度","shen3duo2"],
["审改","shen3gai3"],
["审校","shen3jiao4"],
["审理","shen3li3"],
["审美","shen3mei3"],
["审判长","shen3pan4zhang3"],
["审计长","shen3ji4zhang3"],
["审时度势","shen3shi2duo2shi4"]
],
"客":[
["客人","ke4ren5"],
["客体","ke4ti3"],
["客气","ke4qi5"],
["客氣","ke4qi5"],
["客蚤","ke4zao3"],
["客體","ke4ti3"],
["客客气气气","ke4ke5qi4qi4qi4"],
["客客氣氣氣","ke4ke5qi4qi4qi4"]
],
"宣":[
["宣紙","xuan1zhi3"],
["宣統","xuan1tong3"],
["宣纸","xuan1zhi3"],
["宣统","xuan1tong3"],
["宣講","xuan1jiang3"],
["宣讲","xuan1jiang3"]
],
"室":[
["室友","shi4you3"],
["室女","shi4nv3"],
["室町","shi4ting3"],
["室內樂","shi4nei4yue4"],
["室内乐","shi4nei4yue4"]
],
"宦":[
["宦海","huan4hai3"]
],
"宪":[
["宪法","xian4fa3"]
],
"宫":[
["宫女","gong1nv3"],
["宫阙","gong1que4"],
["宫颈","gong1jing3"],
["宫商角徵羽","gong1shang1jue2zhi3yu3"]
],
"宮":[
["宮女","gong1nv3"],
["宮闕","gong1que4"],
["宮頸","gong1jing3"],
["宮商角徵羽","gong1shang1jue2zhi3yu3"]
],
"宰":[
["宰相","zai3xiang4"]
],
"害":[
["害口","hai4kou3"],
["害喜","hai4xi3"],
["害处","hai4chu5"],
["害死","hai4si3"],
["害眼","hai4yan3"],
["害處","hai4chu5"],
["害馬","hai4ma3"],
["害马","hai4ma3"],
["害不了","hai4bu5liao3"]
],
"宴":[
["宴請","yan4qing3"],
["宴请","yan4qing3"],
["宴飨","yan4xiang3"],
["宴飲","yan4yin3"],
["宴饗","yan4xiang3"],
["宴饮","yan4yin3"]
],
"家":[
["家主","jia1zhu3"],
["家产","jia1chan3"],
["家伙","jia1huo5"],
["家俱","jia1ju1"],
["家具","jia1ju5"],
["家养","jia1yang3"],
["家务","jia1wu4"],
["家務","jia1wu4"],
["家宝","jia1bao3"],
["家寶","jia1bao3"],
["家属","jia1shu3"],
["家屬","jia1shu3"],
["家当","jia1dang4"],
["家景","jia1jing3"],
["家產","jia1chan3"],
["家當","jia1dang4"],
["家蝇","jia1ying2"],
["家蠅","jia1ying2"],
["家裡","jia1li3"],
["家譜","jia1pu3"],
["家谱","jia1pu3"],
["家里","jia1li3"],
["家長","jia1zhang3"],
["家长","jia1zhang3"],
["家養","jia1yang3"],
["家給人足","jia1ji3ren2zu2"],
["家给人足","jia1ji3ren2zu2"]
],
"容":[
["容忍","rong2ren3"],
["容許","rong2xu3"],
["容许","rong2xu3"],
["容不下","rong2bu5xia4"],
["容不开","rong2bu5kai1"],
["容不得","rong2bu5de2"],
["容不開","rong2bu5kai1"]
],
"宽":[
["宽假","kuan1jia3"],
["宽免","kuan1mian3"],
["宽口","kuan1kou3"],
["宽展","kuan1zhan3"],
["宽广","kuan1guang3"],
["宽斧","kuan1fu3"],
["宽爽","kuan1shuang3"],
["宽窄","kuan1zhai3"],
["宽绰","kuan1chuo5"],
["宽缓","kuan1huan3"],
["宽解","kuan1jie3"],
["宽心丸儿","kuan1xin1wan2r5"]
],
"宾":[
["宾主","bin1zhu3"],
["宾得","bin1de2"],
["宾语","bin1yu3"],
["宾馆","bin1guan3"]
],
"宿":[
["宿主","su4zhu3"],
["宿分","su4fen4"],
["宿务","su4wu4"],
["宿務","su4wu4"],
["宿将","su4jiang4"],
["宿將","su4jiang4"],
["宿舍","su4she4"],
["宿草","su4cao3"],
["宿酒","su4jiu3"],
["宿弊一清","su4bi4yi4qing1"]
],
"寄":[
["寄主","ji4zhu3"],
["寄予","ji4yu3"],
["寄母","ji4mu3"],
["寄給","ji4gei3"],
["寄给","ji4gei3"],
["寄跡","ji4ji4"],
["寄迹","ji4ji4"],
["寄存处","ji4cun2chu3"],
["寄存處","ji4cun2chu3"],
["寄予很大期望","ji4yu2hen3da4qi1wang4"]
],
"寅":[
["寅虎","yin2hu3"]
],
"密":[
["密友","mi4you3"],
["密抹","mi4mo3"],
["密码","mi4ma3"],
["密碼","mi4ma3"],
["密密麻麻","mi4mi5ma2ma2"]
],
"富":[
["富余","fu4yu5"],
["富态","fu4tai5"],
["富態","fu4tai5"],
["富於","fu4yu2"],
["富有","fu4you3"],
["富給","fu4ji3"],
["富给","fu4ji3"],
["富錦","fu4jin3"],
["富锦","fu4jin3"],
["富餘","fu4yu5"]
],
"寒":[
["寒假","han2jia4"],
["寒冷","han2leng3"],
["寒暑","han2shu3"],
["寒毛","han2mao5"]
],
"寓":[
["寓所","yu4suo3"],
["寓意深長","yu4yi4shen1zhang3"],
["寓意深长","yu4yi4shen1zhang3"]
],
"察":[
["察雅","cha2ya3"],
["察合台","cha2ge3tai2"],
["察合臺","cha2ge3tai2"],
["察微知著","cha2wei1zhi1zhu4"]
],
"寡":[
["寡妇","gua3fu5"],
["寡婦","gua3fu5"]
],
"實":[
["實務","shi2wu4"],
["實地","shi2di4"],
["實女","shi2nv3"],
["實有","shi2you3"],
["實肘","shi2zhou3"],
["實體","shi2ti3"],
["實分析","shi2fen1xi1"],
["實際上","shi2ji4shang5"]
],
"寧":[
["寧可","ning4ke3"],
["寧武","ning2wu3"],
["寧法","ning2fa3"],
["寧洱","ning4er3"],
["寧海","ning2hai3"],
["寧肯","ning4ken3"],
["寧遠","ning2yuan3"],
["寧都","ning2du1"],
["寧陝","ning2shan3"],
["寧願","ning4yuan4"],
["寧死不屈","ning4si3bu4qu1"],
["寧缺毋濫","ning4que1wu2lan4"]
],
"審":[
["審度","shen3duo2"],
["審改","shen3gai3"],
["審校","shen3jiao4"],
["審理","shen3li3"],
["審美","shen3mei3"],
["審處","shen3chu3"],
["審判長","shen3pan4zhang3"],
["審計長","shen3ji4zhang3"],
["審時度勢","shen3shi2duo2shi4"]
],
"寫":[
["寫法","xie3fa3"],
["寫給","xie3gei3"],
["寫下來","xie3xia4lai2"],
["寫不上","xie3bu5shang4"],
["寫不下","xie3bu5xia4"],
["寫不出","xie3bu5chu1"],
["寫不通","xie3bu5tong1"],
["寫出來","xie3chu1lai2"]
],
"寬":[
["寬假","kuan1jia3"],
["寬免","kuan1mian3"],
["寬口","kuan1kou3"],
["寬展","kuan1zhan3"],
["寬廣","kuan1guang3"],
["寬斧","kuan1fu3"],
["寬爽","kuan1shuang3"],
["寬窄","kuan1zhai3"],
["寬綽","kuan1chuo5"],
["寬緩","kuan1huan3"],
["寬解","kuan1jie3"]
],
"寰":[
["寰宇","huan2yu3"]
],
"寵":[
["寵兒","chong3er2"]
],
"寶":[
["寶坻","bao3di3"],
["寶塔","bao3ta3"],
["寶寶","bao3bao3"],
["寶興","bao3xing1"],
["寶藏","bao3zang4"],
["寶馬","bao3ma3"],
["寶生佛","bao3sheng1fo2"],
["寶石匠","bao3shi2jiang4"]
],
"寸":[
["寸口","cun4kou3"]
],
"对":[
["对付","dui4fu5"],
["对偶","dui4ou3"],
["对儿","dui4r5"],
["对准","dui4zhun3"],
["对口","dui4kou3"],
["对地","dui4di4"],
["对垒","dui4lei3"],
["对好","dui4hao3"],
["对审","dui4shen3"],
["对应","dui4ying4"],
["对手","dui4shou3"],
["对本","dui4ben3"],
["对比","dui4bi3"],
["对火","dui4huo3"],
["对相","dui4xiang4"],
["对眼","dui4yan3"],
["对称","dui4chen4"],
["对等","dui4deng3"],
["对美","dui4mei3"],
["对角","dui4jiao3"],
["对不上","dui4bu5shang4"],
["对不住","dui4bu5zhu4"],
["对不起","dui4bu5qi3"],
["对劲儿","dui4jin4r5"],
["对味儿","dui4wei4r5"],
["对工儿","dui4gong1r5"],
["对心儿","dui4xin1r5"],
["对着干","dui4zhe5gan4"],
["对茬儿","dui4cha2r5"]
],
"寻":[
["寻址","xun2zhi3"],
["寻宝","xun2bao3"],
["寻找","xun2zhao3"],
["寻的","xun2di4"],
["寻索","xun2suo3"],
["寻访","xun2fang3"],
["寻不着","xun2bu5zhao2"],
["寻思一计","xin2si5yi2ji4"],
["寻欢作乐","xun2huan1zuo4le4"]
],
"导":[
["导体","dao3ti3"],
["导引","dao3yin3"],
["导演","dao3yan3"],
["导管","dao3guan3"]
],
"寿":[
["寿数","shou4shu5"],
["寿星","shou4xing5"],
["寿礼","shou4li3"],
["寿险","shou4xian3"]
],
"封":[
["封口","feng1kou3"],
["封土","feng1tu3"],
["封地","feng1di4"],
["封底","feng1di3"],
["封港","feng1gang3"],
["封火","feng1huo3"],
["封鎖","feng1suo3"],
["封锁","feng1suo3"],
["封頂","feng1ding3"],
["封顶","feng1ding3"],
["封上一官半职","feng1shang5yi4guan1ban4zhi2"],
["封上一官半職","feng1shang5yi4guan1ban4zhi2"]
],
"射":[
["射中","she4zhong4"],
["射影","she4ying3"],
["射手","she4shou3"],
["射鵰英雄传","she4diao1ying1xiong2zhuan4"],
["射鵰英雄傳","she4diao1ying1xiong2zhuan4"]
],
"将":[
["将士","jiang4shi4"],
["将就","jiang1jiu5"],
["将帅","jiang4shuai4"],
["将棋","jiang4qi2"],
["将死","jiang1si3"],
["将牌","jiang4pai2"],
["将领","jiang4ling3"]
],
"將":[
["將士","jiang4shi4"],
["將就","jiang1jiu5"],
["將帥","jiang4shuai4"],
["將棋","jiang4qi2"],
["將死","jiang1si3"],
["將牌","jiang4pai2"],
["將領","jiang4ling3"]
],
"專":[
["專好","zhuan1hao4"],
["專有","zhuan1you3"],
["專款","zhuan1kuan3"],
["專管","zhuan1guan3"],
["專著","zhuan1zhu4"],
["專訪","zhuan1fang3"],
["專輯","zhuan1ji2"],
["專一性","zhuan1yi2xing4"],
["專心一志","zhuan1xin1yi2zhi4"]
],
"尊":[
["尊为","zun1wei2"],
["尊為","zun1wei2"],
["尊者","zun1zhe3"],
["尊長","zun1zhang3"],
["尊长","zun1zhang3"]
],
"尋":[
["尋址","xun2zhi3"],
["尋寶","xun2bao3"],
["尋找","xun2zhao3"],
["尋的","xun2di4"],
["尋索","xun2suo3"],
["尋訪","xun2fang3"],
["尋不著","xun2bu5zhao2"],
["尋思一計","xin2si5yi2ji4"],
["尋歡作樂","xun2huan1zuo4le4"]
],
"對":[
["對么","dui4yao1"],
["對付","dui4fu5"],
["對偶","dui4ou3"],
["對口","dui4kou3"],
["對地","dui4di4"],
["對壘","dui4lei3"],
["對好","dui4hao3"],
["對審","dui4shen3"],
["對應","dui4ying4"],
["對手","dui4shou3"],
["對於","dui4yu2"],
["對本","dui4ben3"],
["對比","dui4bi3"],
["對準","dui4zhun3"],
["對火","dui4huo3"],
["對相","dui4xiang4"],
["對眼","dui4yan3"],
["對稱","dui4chen4"],
["對等","dui4deng3"],
["對美","dui4mei3"],
["對角","dui4jiao3"],
["對不上","dui4bu5shang4"],
["對不住","dui4bu5zhu4"],
["對不起","dui4bu5qi3"]
],
"導":[
["導引","dao3yin3"],
["導演","dao3yan3"],
["導管","dao3guan3"],
["導體","dao3ti3"]
],
"小":[
["小丑","xiao3chou3"],
["小传","xiao3zhuan4"],
["小傳","xiao3zhuan4"],
["小写","xiao3xie3"],
["小卒","xiao3zu2"],
["小品","xiao3pin3"],
["小女","xiao3nv3"],
["小姐","xiao3jie5"],
["小寫","xiao3xie3"],
["小小","xiao3xiao3"],
["小岛","xiao3dao3"],
["小島","xiao3dao3"],
["小指","xiao3zhi3"],
["小於","xiao3yu2"],
["小暑","xiao3shu3"],
["小本","xiao3ben3"],
["小满","xiao3man3"],
["小滿","xiao3man3"],
["小狗","xiao3gou3"],
["小米","xiao3mi3"],
["小組","xiao3zu3"],
["小组","xiao3zu3"],
["小脑","xiao3nao3"],
["小腦","xiao3nao3"],
["小腿","xiao3tui3"],
["小艇","xiao3ting3"],
["小角","xiao3jiao3"],
["小醜","xiao3chou3"],
["小雅","xiao3ya3"],
["小雪","xiao3xue3"],
["小馬","xiao3ma3"],
["小马","xiao3ma3"],
["小鬼","xiao3gui3"],
["小鳥","xiao3niao3"],
["小鸟","xiao3niao3"],
["小鼠","xiao3shu3"],
["小不了","xiao3bu5liao3"],
["小不点","xiao3bu5dian3"],
["小不點","xiao3bu5dian3"],
["小女兒","xiao3nv3er2"],
["小妹妹","xiao3mei4mei4"],
["小学生","xiao3xue2sheng1"],
["小孩儿","xiao3hai2r5"],
["小學生","xiao3xue2sheng1"],
["小指头","xiao3zhi3tou5"],
["小指頭","xiao3zhi3tou5"],
["小摊儿","xiao3tan1r5"],
["小数点","xiao3shu4dian3"],
["小數點","xiao3shu4dian3"],
["小气候","xiao3qi4hou5"],
["小氣候","xiao3qi4hou5"],
["小脏鬼","xiao3zang1gui3"],
["小雞雞","xiao3ji1ji5"],
["小鸡鸡","xiao3ji1ji5"],
["小一会儿","xiao3yi4hui3r5"],
["小一會兒","xiao3yi4hui3r5"],
["小不点儿","xiao3bu5dian3r5"],
["小事一桩","xiao3shi4yi4zhuang1"],
["小事一樁","xiao3shi4yi4zhuang1"],
["小兒麻痺","xiao3er2ma2bi4"],
["小时候儿","xiao3shi2hou5r5"],
["小白脸儿","xiao3bai2lian3r5"],
["小紅蘿蔔","xiao3hong2luo2bo5"],
["小红萝蔔","xiao3hong2luo2bo5"],
["小菜一碟","xiao3cai4yi4die2"],
["小西葫芦","xiao3xi1hu2lu2"],
["小西葫蘆","xiao3xi1hu2lu2"],
["小兒麻痹癥","xiao3er2ma2bi4zheng4"]
],
"少":[
["少儿","shao4er2"],
["少兒","shao4er2"],
["少壮","shao4zhuang4"],
["少壯","shao4zhuang4"],
["少女","shao4nv3"],
["少妇","shao4fu4"],
["少婦","shao4fu4"],
["少将","shao4jiang4"],
["少將","shao4jiang4"],
["少尉","shao4wei4"],
["少年","shao4nian2"],
["少有","shao3you3"],
["少林","shao4lin2"],
["少校","shao4xiao4"],
["少男","shao4nan2"],
["少給","shao3gei3"],
["少给","shao3gei3"],
["少不了","shao3bu5liao3"],
["少不得","shao3bu5de2"],
["少先队","shao4xian1dui4"],
["少先隊","shao4xian1dui4"],
["少得了","shao3de5liao3"],
["少劳少得","shao3lao2shao3de2"],
["少勞少得","shao3lao2shao3de2"]
],
"尔":[
["尔雅","er3ya3"]
],
"尖":[
["尖塔","jian1ta3"],
["尖頂","jian1ding3"],
["尖顶","jian1ding3"]
],
"尘":[
["尘土","chen2tu3"]
],
"尚":[
["尚且","shang4qie3"]
],
"尝":[
["尝尝","chang2chang5"],
["尝一尝","chang2yi4chang2"],
["尝鼎一脔","chang2ding3yi4luan2"]
],
"尤":[
["尤坎","you2kan3"],
["尤克裡裡琴","you2ke4li3li3qin2"]
],
"就":[
["就使","jiu4shi3"],
["就和","jiu4he5"],
["就地","jiu4di4"],
["就寝","jiu4qin3"],
["就寢","jiu4qin3"],
["就得","jiu4dei3"],
["就手","jiu4shou3"],
["就此","jiu4ci3"],
["就裡","jiu4li3"],
["就診","jiu4zhen3"],
["就诊","jiu4zhen3"],
["就里","jiu4li3"]
],
"尸":[
["尸体","shi1ti3"],
["尸检","shi1jian3"],
["尸首","shi1shou5"]
],
"尺":[
["尺寸","chi3cun5"],
["尺码","chi3ma3"],
["尺碼","chi3ma3"],
["尺骨","chi3gu3"]
],
"尻":[
["尻骨","kao1gu3"]
],
"尼":[
["尼姆","ni2mu3"],
["尼採","ni2cai3"],
["尼斐","ni2fei3"],
["尼玛","ni2ma3"],
["尼珥","ni2er3"],
["尼瑪","ni2ma3"],
["尼甲","ni2jia3"],
["尼百","ni2bai3"],
["尼采","ni2cai3"],
["尼雅","ni2ya3"],
["尼泊尔","ni2bo2er3"],
["尼泊爾","ni2bo2er3"],
["尼布楚条约","ni2bu4chu3tiao2yue1"],
["尼布楚條約","ni2bu4chu3tiao2yue1"]
],
"尽":[
["尽快","jin3kuai4"],
["尽早","jin4zao3"],
["尽管","jin3guan3"],
["尽量","jin3liang4"],
["尽可能","jin3ke3neng2"],
["尽力而为","jin4li4er2wei2"],
["尽欢而散","jin4huan1er2san4"]
],
"尾":[
["尾水","wei3shui3"],
["尾綴","wei3zhui4"],
["尾缀","wei3zhui4"],
["尾羽","wei3yu3"],
["尾骨","wei3gu3"]
],
"尿":[
["尿样","sui1yang4"],
["尿樣","sui1yang4"]
],
"局":[
["局地","ju2di4"],
["局長","ju2zhang3"],
["局长","ju2zhang3"]
],
"屁":[
["屁股","pi4gu5"],
["屁眼儿","pi4yan3r5"]
],
"层":[
["层理","ceng2li3"]
],
"居":[
["居所","ju1suo3"],
["居於","ju1yu2"],
["居里","ju1li3"],
["居首","ju1shou3"],
["居住於","ju1zhu4yu2"]
],
"屆":[
["屆滿","jie4man3"]
],
"屈":[
["屈辱","qu1ru3"]
],
"届":[
["届满","jie4man3"]
],
"屋":[
["屋脊","wu1ji3"],
["屋頂","wu1ding3"],
["屋顶","wu1ding3"],
["屋裡的","wu1li3de5"]
],
"屍":[
["屍檢","shi1jian3"],
["屍首","shi1shou5"],
["屍體","shi1ti3"]
],
"屏":[
["屏息","bing3xi1"],
["屏气","bing3qi4"],
["屏氣","bing3qi4"],
["屏除","bing3chu2"]
],
"展":[
["展覽","zhan3lan3"],
["展览","zhan3lan3"]
],
"属":[
["属地","shu3di4"]
],
"屠":[
["屠场","tu2chang3"],
["屠場","tu2chang3"],
["屠夫","tu2fu1"],
["屠宰","tu2zai3"],
["屠格涅夫","tu2ge2nie4fu1"]
],
"屡":[
["屡屡","lv3lv3"]
],
"屢":[
["屢屢","lv3lv3"]
],
"層":[
["層理","ceng2li3"]
],
"屬":[
["屬地","shu3di4"],
["屬於","shu3yu2"]
],
"屯":[
["屯垦","tun2ken3"],
["屯墾","tun2ken3"]
],
"山":[
["山体","shan1ti3"],
["山地","shan1di4"],
["山岭","shan1ling3"],
["山嶺","shan1ling3"],
["山本","shan1ben3"],
["山楂","shan1zha1"],
["山水","shan1shui3"],
["山火","shan1huo3"],
["山脊","shan1ji3"],
["山脚","shan1jiao3"],
["山腳","shan1jiao3"],
["山药","shan1yao5"],
["山藥","shan1yao5"],
["山裡","shan1li3"],
["山谷","shan1gu3"],
["山都","shan1du1"],
["山里","shan1li3"],
["山野","shan1ye3"],
["山頂","shan1ding3"],
["山顶","shan1ding3"],
["山體","shan1ti3"],
["山鶉","shan1chun2"],
["山鹑","shan1chun2"],
["山口洋","shan1kou3yang1"],
["山旮旯","shan1ga1la5"],
["山窮水盡","shan1qiong2shui3jin4"]
],
"岁":[
["岁差","sui4cha1"],
["岁数","sui4shu5"],
["岁首","sui4shou3"]
],
"岑":[
["岑巩","cen2gong3"],
["岑鞏","cen2gong3"]
],
"岔":[
["岔口","cha4kou3"]
],
"岗":[
["岗巴","gang3ba1"]
],
"岛":[
["岛屿","dao3yu3"]
],
"岡":[
["岡本","gang1ben3"]
],
"岳":[
["岳母","yue4mu3"]
],
"岸":[
["岸上","an4shang5"]
],
"峇":[
["峇里","ke1li3"]
],
"峡":[
["峡谷","xia2gu3"]
],
"島":[
["島嶼","dao3yu3"]
],
"峻":[
["峻岭","jun4ling3"],
["峻嶺","jun4ling3"]
],
"峽":[
["峽谷","xia2gu3"]
],
"崇":[
["崇左","chong2zuo3"],
["崇礼","chong2li3"],
["崇禮","chong2li3"]
],
"崖":[
["崖珥","ya2er3"],
["崖谷","ya2gu3"],
["崖魯","ya2lu3"],
["崖鲁","ya2lu3"]
],
"崗":[
["崗巴","gang3ba1"]
],
"崛":[
["崛起","jue2qi3"]
],
"崩":[
["崩毀","beng1hui3"],
["崩毁","beng1hui3"]
],
"川":[
["川党","chuan1dang3"],
["川藏","chuan1zang4"],
["川黨","chuan1dang3"],
["川党参","chuan1dang3shen1"],
["川黨參","chuan1dang3shen1"]
],
"州":[
["州長","zhou1zhang3"],
["州长","zhou1zhang3"]
],
"巡":[
["巡抚","xun2fu3"],
["巡撫","xun2fu3"],
["巡警","xun2jing3"]
],
"工":[
["工党","gong1dang3"],
["工匠","gong1jiang4"],
["工厂","gong1chang3"],
["工地","gong1di4"],
["工委","gong1wei3"],
["工廠","gong1chang3"],
["工整","gong1zheng3"],
["工行","gong1hang2"],
["工錢","gong1qian5"],
["工钱","gong1qian5"],
["工黨","gong1dang3"]
],
"左":[
["左传","zuo3zhuan4"],
["左傳","zuo3zhuan4"],
["左手","zuo3shou3"],
["左掌","zuo3zhang3"],
["左脚","zuo3jiao3"],
["左腳","zuo3jiao3"],
["左边","zuo3bian5"],
["左邊","zuo3bian5"],
["左不是","zuo3bu5shi5"],
["左不过","zuo3bu5guo4"],
["左不過","zuo3bu5guo4"],
["左边儿","zuo3bian5r5"]
],
"巧":[
["巧匠","qiao3jiang4"],
["巧干","qiao3gan4"],
["巧手","qiao3shou3"]
],
"巨":[
["巨匠","ju4jiang4"],
["巨响","ju4xiang3"],
["巨款","ju4kuan3"],
["巨著","ju4zhu4"],
["巨蟒","ju4mang3"],
["巨野","ju4ye3"],
["巨響","ju4xiang3"]
],
"巫":[
["巫蛊","wu1gu3"],
["巫蠱","wu1gu3"]
],
"差":[
["差事","chai1shi5"],
["差人","chai1ren2"],
["差他","chai1ta1"],
["差价","cha1jia4"],
["差價","cha1jia4"],
["差分","cha1fen1"],
["差別","cha1bie2"],
["差别","cha1bie2"],
["差商","cha1shang1"],
["差失","cha1shi1"],
["差异","cha1yi4"],
["差役","chai1yi4"],
["差我","chai1wo3"],
["差数","cha1shu4"],
["差數","cha1shu4"],
["差派","chai1pai4"],
["差点","cha4dian3"],
["差異","cha1yi4"],
["差訛","cha1e2"],
["差誤","cha1wu4"],
["差讹","cha1e2"],
["差误","cha1wu4"],
["差距","cha1ju4"],
["差遣","chai1qian3"],
["差錯","cha1cuo4"],
["差错","cha1cuo4"],
["差額","cha1e2"],
["差额","cha1e2"],
["差點","cha4dian3"],
["差一点","cha1yi4dian3"],
["差一點","cha1yi4dian3"],
["差不了","cha4bu5liao3"],
["差不多","cha4bu5duo1"],
["差不点","cha4bu5dian3"],
["差不离","cha4bu5li2"],
["差不远","cha4bu5yuan3"],
["差不遠","cha4bu5yuan3"],
["差不離","cha4bu5li2"],
["差不點","cha4bu5dian3"],
["差点儿","cha4dian3r5"],
["差速器","cha1su4qi4"],
["差一点儿","cha1yi4dian3r5"],
["差不点儿","cha4bu5dian3r5"],
["差不离儿","cha4bu5li2r5"],
["差不究竟","cha4bu5jiu1jing4"],
["差強人意","cha1qiang2ren2yi4"],
["差强人意","cha1qiang2ren2yi4"]
],
"己":[
["己丑","ji3chou3"],
["己卯","ji3mao3"],
["己酉","ji3you3"]
],
"已":[
["已久","yi3jiu3"],
["已往","yi3wang3"],
["已死","yi3si3"],
["已經","yi3jing5"],
["已经","yi3jing5"],
["已得代价","yi3de2dai4jia4"],
["已得代價","yi3de2dai4jia4"]
],
"巴":[
["巴东","ba1dong1"],
["巴中","ba1zhong1"],
["巴乌","ba1wu1"],
["巴兰","ba1lan2"],
["巴列","ba1lie4"],
["巴別","ba1bie2"],
["巴利","ba1li4"],
["巴别","ba1bie2"],
["巴力","ba1li4"],
["巴勒","ba1le4"],
["巴卜","ba1bu3"],
["巴厘","ba1li2"],
["巴县","ba1xian4"],
["巴塘","ba1tang2"],
["巴士","ba1shi4"],
["巴尔","ba1er3"],
["巴尼","ba1ni2"],
["巴山","ba1shan1"],
["巴州","ba1zhou1"],
["巴巴","ba1ba1"],
["巴库","ba1ku4"],
["巴庫","ba1ku4"],
["巴录","ba1lu4"],
["巴彥","ba1yan4"],
["巴彦","ba1yan4"],
["巴得","ba1de5"],
["巴拉","ba1la1"],
["巴拿","ba1na2"],
["巴掌","ba1zhang5"],
["巴斗","ba1dou3"],
["巴斯","ba1si1"],
["巴旦","ba1dan4"],
["巴望","ba1wang4"],
["巴末","ba1mo4"],
["巴東","ba1dong1"],
["巴林","ba1lin2"],
["巴楚","ba1chu3"],
["巴氏","ba1shi4"],
["巴沙","ba1sha1"],
["巴烈","ba1lie4"],
["巴烏","ba1wu1"],
["巴爾","ba1er3"],
["巴特","ba1te4"],
["巴珊","ba1shan1"],
["巴生","ba1sheng1"],
["巴登","ba1deng1"],
["巴結","ba1jie5"],
["巴縣","ba1xian4"],
["巴结","ba1jie5"],
["巴莫","ba1mo4"],
["巴萨","ba1sa4"],
["巴薩","ba1sa4"],
["巴蘭","ba1lan2"],
["巴蜀","ba1shu3"],
["巴裡","ba1li3"],
["巴西","ba1xi1"],
["巴豆","ba1dou4"],
["巴赫","ba1he4"],
["巴里","ba1li3"],
["巴釐","ba1li2"],
["巴金","ba1jin1"],
["巴錄","ba1lu4"],
["巴阿","ba1a1"],
["巴青","ba1qing1"],
["巴頓","ba1dun4"],
["巴顿","ba1dun4"],
["巴黎","ba1li2"],
["巴不到","ba1bu5dao4"],
["巴不得","ba1bu5de5"],
["巴儿狗","ba1r5gou3"],
["巴克莱","ba1ke4lai2"],
["巴克萊","ba1ke4lai2"],
["巴兒狗","ba1r5gou3"],
["巴哈馬","ba1ha1ma3"],
["巴哈马","ba1ha1ma3"],
["巴哥斯","ba1ge1si1"],
["巴塞尔","ba1sai1er3"],
["巴塞爾","ba1sai1er3"],
["巴实抹","ba1shi2mo3"],
["巴宰族","ba1zai3zu2"],
["巴實抹","ba1shi2mo3"],
["巴尔干","ba1er3gan4"],
["巴布尔","ba1bu4er3"],
["巴布爾","ba1bu4er3"],
["巴布迦","ba1bu4jia1"],
["巴希尔","ba1xi1er3"],
["巴希爾","ba1xi1er3"],
["巴戶琳","ba1hu4lin2"],
["巴户琳","ba1hu4lin2"],
["巴拉巴","ba1la1ba1"],
["巴拿巴","ba1na2ba1"],
["巴提迈","ba1ti2mai4"],
["巴提邁","ba1ti2mai4"],
["巴撒巴","ba1sa1ba1"],
["巴松管","ba1song1guan3"],
["巴格兰","ba1ge2lan2"],
["巴格蘭","ba1ge2lan2"],
["巴格达","ba1ge2da2"],
["巴格達","ba1ge2da2"],
["巴比伦","ba1bi3lun2"],
["巴比倫","ba1bi3lun2"],
["巴比妥","ba1bi3tuo3"],
["巴洗律","ba1xi3lv4"],
["巴瓦伊","ba1wa3yi1"],
["巴米拿","ba1mi3na2"],
["巴罗佐","ba1luo2zuo3"],
["巴罗克","ba1luo2ke4"],
["巴羅佐","ba1luo2zuo3"],
["巴羅克","ba1luo2ke4"],
["巴耶稣","ba1ye1su1"],
["巴耶穌","ba1ye1su1"],
["巴菲特","ba1fei1te4"],
["巴頌管","ba1song4guan3"],
["巴颂管","ba1song4guan3"],
["巴馬科","ba1ma3ke1"],
["巴马科","ba1ma3ke1"],
["巴魯米","ba1lu3mi3"],
["巴鲁米","ba1lu3mi3"],
["巴三覽四","ba1san1lan3si4"],
["巴三览四","ba1san1lan3si4"],
["巴不能够","ba1bu4neng2gou4"],
["巴不能夠","ba1bu4neng2gou4"],
["巴伐利亚","ba1fa2li4ya4"],
["巴伐利亞","ba1fa2li4ya4"],
["巴伦支海","ba1lun2zhi1hai3"],
["巴伦西亚","ba1lun2xi1ya4"],
["巴倫支海","ba1lun2zhi1hai3"],
["巴倫西亞","ba1lun2xi1ya4"],
["巴克夏猪","ba1ke4xia4zhu1"],
["巴克夏豬","ba1ke4xia4zhu1"],
["巴克科思","ba1ke4ke1si1"],
["巴前算后","ba1qian2suan4hou4"],
["巴前算後","ba1qian2suan4hou4"],
["巴力西卜","ba1li4xi1bu3"],
["巴哈摩押","ba1ha1mo2ya1"],
["巴哈魯米","ba1ha1lu3mi3"],
["巴哈鲁米","ba1ha1lu3mi3"],
["巴基斯坦","ba1ji1si1tan3"],
["巴塞罗那","ba1sai4luo2na4"],
["巴塞羅那","ba1sai4luo2na4"],
["巴多罗买","ba1duo1luo2mai3"],
["巴多羅買","ba1duo1luo2mai3"],
["巴头探脑","ba1tou2tan4nao3"],
["巴尔的摩","ba1er3di4mo2"],
["巴巴結結","ba1ba5jie5jie5"],
["巴巴结结","ba1ba5jie5jie5"],
["巴布拉族","ba1bu4la1zu2"],
["巴施戶珥","ba1shi1hu4er3"],
["巴施户珥","ba1shi1hu4er3"],
["巴爾的摩","ba1er3di4mo2"],
["巴答一声","ba1da1yi4sheng1"],
["巴答一聲","ba1da1yi4sheng1"],
["巴耶利巴","ba1ye1li4ba1"],
["巴頭探腦","ba1tou2tan4nao3"],
["巴高望上","ba1gao1wang4shang4"],
["巴不能够儿","ba1bu5neng2gou4r5"],
["巴不能夠兒","ba1bu5neng2gou4r5"],
["巴拉基列夫","ba1la1ji1lie4fu1"],
["巴枯宁主义","ba1ku1ning2zhu3yi4"],
["巴枯寧主義","ba1ku1ning2zhu3yi4"],
["巴氏杀菌法","ba1shi4sha1jun4fa3"],
["巴氏殺菌法","ba1shi4sha1jun4fa3"],
["巴音郭愣州","ba1yin1guo1leng4zhou1"],
["巴尔舍夫斯基","ba1er3she3fu1si1ji1"],
["巴爾舍夫斯基","ba1er3she3fu1si1ji1"],
["巴音布克草原","ba1yin1bu4ke4cao3yuan2"],
["巴布亚新几内亚","ba1bu4ya4xin1ji3nei4ya4"],
["巴布亞新幾內亞","ba1bu4ya4xin1ji3nei4ya4"],
["巴貝西亞原蟲病","ba1bei4xi1ya4yuan2chong2bing4"],
["巴贝西亚原虫病","ba1bei4xi1ya4yuan2chong2bing4"],
["巴馬瑤族自治縣","ba1ma3yao2zu2zi4zhi4xian4"],
["巴马瑶族自治县","ba1ma3yao2zu2zi4zhi4xian4"]
],
"巹":[
["巹飲","jin3yin3"],
["巹饮","jin3yin3"]
],
"市":[
["市场","shi4chang3"],
["市場","shi4chang3"],
["市委","shi4wei3"],
["市引","shi4yin3"],
["市長","shi4zhang3"],
["市长","shi4zhang3"]
],
"布":[
["布什","bu4shi2"],
["布伍","bu4wu3"],
["布匹","bu4pi3"],
["布景","bu4jing3"],
["布朗","bu4lang3"],
["布满","bu4man3"],
["布滿","bu4man3"],
["布穀","bu4gu3"],
["布谷","bu4gu3"],
["布琼布拉","bu4qiong2bu4la5"],
["布瓊布拉","bu4qiong2bu4la5"],
["布裡奇頓","bu4li3qi2dun4"],
["布裡斯班","bu4li3si1ban1"],
["布魯塞爾","bu4lu3sai4er3"],
["布鲁塞尔","bu4lu3sai4er3"],
["布尔什维克","bu4er3shi2wei2ke4"],
["布拉柴維爾","bu4la5chai2wei2er3"],
["布拉柴维尔","bu4la5chai2wei2er3"],
["布爾什維克","bu4er3shi2wei2ke4"],
["布宜諾斯艾利斯","bu4yi2nuo4si1ai4li4si1"],
["布宜诺斯艾利斯","bu4yi2nuo4si1ai4li4si1"]
],
"帅":[
["帅哥","shuai4ge5"]
],
"帆":[
["帆板","fan1ban3"]
],
"师":[
["师友","shi1you3"],
["师母","shi1mu3"],
["师父","shi1fu5"],
["师表","shi1biao3"],
["师长","shi1zhang3"]
],
"希":[
["希尔","xi1er3"],
["希息","xi1xi1"],
["希爾","xi1er3"],
["希罕","xi1han5"],
["希里","xi1li3"],
["希思罗","xi1si1luo1"],
["希思羅","xi1si1luo1"],
["希拉裡","xi1la1li3"]
],
"帐":[
["帐棚","zhang4peng5"],
["帐蓬","zhang4peng5"]
],
"帕":[
["帕鐵","pa4tie3"],
["帕铁","pa4tie3"],
["帕罗巴","pa4luo2ba1"],
["帕羅巴","pa4luo2ba1"],
["帕尼巴特","pa4ni2pa1te4"],
["帕拉塞尔士","pa4la1se4er3shi4"],
["帕拉塞爾士","pa4la1se4er3shi4"]
],
"帝":[
["帝都","di4du1"]
],
"帥":[
["帥哥","shuai4ge5"]
],
"带":[
["带儿","dai4r5"],
["带去","dai4qu5"],
["带手","dai4shou3"],
["带有","dai4you3"],
["带给","dai4gei3"],
["带走","dai4zou3"],
["带过","dai4guo5"],
["带领","dai4ling3"],
["带不到","dai4bu5dao5"],
["带不走","dai4bu5zou3"],
["带出去","dai4chu1qu4"]
],
"師":[
["師友","shi1you3"],
["師母","shi1mu3"],
["師父","shi1fu5"],
["師表","shi1biao3"],
["師長","shi1zhang3"]
],
"席":[
["席卷","xi2juan3"]
],
"帮":[
["帮手","bang1shou5"],
["帮不上","bang1bu5shang4"]
],
"帳":[
["帳棚","zhang4peng5"],
["帳蓬","zhang4peng5"]
],
"帶":[
["帶去","dai4qu5"],
["帶手","dai4shou3"],
["帶有","dai4you3"],
["帶給","dai4gei3"],
["帶走","dai4zou3"],
["帶過","dai4guo5"],
["帶領","dai4ling3"],
["帶不到","dai4bu5dao5"],
["帶不走","dai4bu5zou3"],
["帶出去","dai4chu1qu4"]
],
"常":[
["常务","chang2wu4"],
["常務","chang2wu4"],
["常好","chang2hao4"],
["常委","chang2wei3"],
["常有","chang2you3"],
["常熟","chang2shou2"],
["常理","chang2li3"],
["常識","chang2shi2"],
["常识","chang2shi2"],
["常軌","chang2gui3"],
["常轨","chang2gui3"]
],
"帹":[
["帹暆","sha4yi2"]
],
"幕":[
["幕府","mu4fu3"]
],
"幫":[
["幫手","bang1shou5"],
["幫不上","bang1bu5shang4"]
],
"干":[
["干事","gan4shi5"],
["干劲","gan4jin4"],
["干号","gan1hao2"],
["干吗","gan4ma2"],
["干娘","gan1niang2"],
["干将","gan4jiang4"],
["干才","gan4cai2"],
["干扰","gan1rao3"],
["干掉","gan4diao4"],
["干擾","gan1rao3"],
["干材","gan4cai2"],
["干果","gan1guo3"],
["干校","gan4xiao4"],
["干洗","gan1xi3"],
["干活","gan4huo2"],
["干流","gan4liu2"],
["干渠","gan4qu2"],
["干渴","gan1ke3"],
["干癣","gan1xuan3"],
["干粮","gan1liang5"],
["干线","gan4xian4"],
["干群","gan4qun2"],
["干草","gan1cao3"],
["干道","gan4dao4"],
["干部","gan4bu4"],
["干麼","gan4ma2"],
["干麽","gan4ma2"],
["干不下","gan4bu5xia4"],
["干不了","gan4bu5liao3"],
["干不出","gan4bu5chu1"],
["干不动","gan4bu5dong4"],
["干不干","gan4bu5gan4"],
["干不来","gan4bu5lai2"],
["干不过","gan4bu5guo4"],
["干什么","gan4shen2me5"],
["干得了","gan4de5liao3"],
["干得出","gan4de5chu1"],
["干得来","gan4de5lai2"],
["干活儿","gan4huo2r5"],
["干细胞","gan4xi4bao1"],
["干得过儿","gan4de5guo4r5"]
],
"平":[
["平反","ping2fan3"],
["平地","ping2di4"],
["平坦","ping2tan3"],
["平壤","ping2rang3"],
["平复","ping2fu5"],
["平復","ping2fu5"],
["平息","ping2xi1"],
["平整","ping2zheng3"],
["平板","ping2ban3"],
["平果","ping2guo3"],
["平武","ping2wu3"],
["平毀","ping2hui3"],
["平毁","ping2hui3"],
["平稳","ping2wen3"],
["平穩","ping2wen3"],
["平等","ping2deng3"],
["平米","ping2mi3"],
["平緩","ping2huan3"],
["平缓","ping2huan3"],
["平菇","ping2gu1"],
["平谷","ping2gu3"],
["平远","ping2yuan3"],
["平遠","ping2yuan3"],
["平頂","ping2ding3"],
["平顶","ping2ding3"],
["平魯","ping2lu3"],
["平鲁","ping2lu3"],
["平安裡","ping2an1li3"],
["平一宇內","ping2yi4yu3nei4"],
["平一宇内","ping2yi4yu3nei4"]
],
"年":[
["年下","nian2xia5"],
["年友","nian2you3"],
["年少","nian2shao4"],
["年尾","nian2wei3"],
["年底","nian2di3"],
["年息","nian2xi1"],
["年月","nian2yue5"],
["年老","nian2lao3"],
["年表","nian2biao3"],
["年載","nian2zai3"],
["年载","nian2zai3"],
["年長","nian2zhang3"],
["年长","nian2zhang3"],
["年長日久","nian2chang2ri4jiu3"],
["年长日久","nian2chang2ri4jiu3"]
],
"并":[
["并且","bing4qie3"],
["并举","bing4ju3"],
["并把","bing4ba3"]
],
"幸":[
["幸免","xing4mian3"],
["幸喜","xing4xi3"],
["幸好","xing4hao3"],
["幸得","xing4de2"],
["幸甚","xing4shen4"],
["幸運兒","xing4yun4er2"],
["幸免一死","xing4mian3yi4si3"],
["幸免于难","xing4mian3yu2nan4"],
["幸免於難","xing4mian3yu2nan4"]
],
"幹":[
["幹事","gan4shi5"],
["幹嗎","gan4ma2"],
["幹將","gan4jiang4"],
["幹麼","gan4ma2"],
["幹不下","gan4bu5xia4"],
["幹不了","gan4bu5liao3"],
["幹不來","gan4bu5lai2"],
["幹不出","gan4bu5chu1"],
["幹不動","gan4bu5dong4"],
["幹不幹","gan4bu5gan4"],
["幹不過","gan4bu5guo4"],
["幹得了","gan4de5liao3"],
["幹得來","gan4de5lai2"],
["幹得出","gan4de5chu1"]
],
"幻":[
["幻影","huan4ying3"],
["幻想","huan4xiang3"]
],
"幼":[
["幼体","you4ti3"],
["幼兒","you4er2"],
["幼女","you4nv3"],
["幼子","you4zi3"],
["幼馬","you4ma3"],
["幼马","you4ma3"],
["幼體","you4ti3"]
],
"幽":[
["幽谷","you1gu3"],
["幽雅","you1ya3"]
],
"幾":[
["幾丁","ji1ding1"],
["幾乎","ji1hu1"],
["幾只","ji3zhi1"],
["幾希","ji1xi1"],
["幾微","ji1wei1"],
["幾率","ji1lv4"],
["幾百","ji3bai3"],
["幾至","ji1zhi4"],
["幾許","ji3xu3"],
["幾諫","ji1jian4"],
["幾點","ji1dian3"],
["幾個月","ji3ge4yue4"],
["幾點了","ji3dian3le5"],
["幾個小時","ji3ge4xiao3shi2"]
],
"广":[
["广九","guang3jiu3"],
["广场","guang3chang3"],
["广岛","guang3dao3"],
["广水","guang3shui3"],
["广告片","guang3gao4pian1"]
],
"庄":[
["庄子","zhuang1zi3"],
["庄老","zhuang1lao3"],
["庄稼地","zhuang1jia5di4"]
],
"庆":[
["庆典","qing4dian3"]
],
"序":[
["序曲","xu4qu3"]
],
"库":[
["库尔","ku4er3"],
["库巴","ku4ba1"]
],
"应":[
["应付","ying4fu5"],
["应允","ying1yun3"],
["应分","ying1fen4"],
["应力","ying4li4"],
["应变","ying4bian4"],
["应和","ying4he4"],
["应对","ying4dui4"],
["应征","ying4zheng1"],
["应得","ying1de2"],
["应急","ying4ji2"],
["应战","ying4zhan4"],
["应有","ying1you3"],
["应用","ying4yong4"],
["应答","ying4da2"],
["应约","ying4yue1"],
["应聘","ying4pin4"],
["应许","ying1xu3"],
["应邀","ying4yao1"],
["应酬","ying4chou5"],
["应门","ying4men2"],
["应验","ying4yan4"],
["应激性","ying4ji1xing4"],
["应付帐款","ying1fu4zhang4kuan3"],
["应县木塔","ying4xian4mu4ta3"],
["应试教育","ying4shi4jiao4yu4"],
["应运而生","ying4yun4er2sheng1"]
],
"底":[
["底下","di3xia5"],
["底本","di3ben3"],
["底版","di3ban3"],
["底甲","di3jia3"],
["底細","di3xi5"],
["底细","di3xi5"],
["底裡","di3li3"],
["底里","di3li3"],
["底馬","di3ma3"],
["底马","di3ma3"]
],
"店":[
["店主","dian4zhu3"],
["店伙","dian4huo3"],
["店錢","dian4qian5"],
["店钱","dian4qian5"]
],
"庙":[
["庙塔","miao4ta3"],
["庙宇","miao4yu3"]
],
"庚":[
["庚午","geng1wu3"],
["庚子","geng1zi3"]
],
"府":[
["府尹","fu3yin3"],
["府谷","fu3gu3"],
["府邸","fu3di3"]
],
"废":[
["废品","fei4pin3"],
["废止","fei4zhi3"],
["废水","fei4shui3"],
["废纸","fei4zhi3"],
["废铁","fei4tie3"]
],
"度":[
["度假","du4jia4"],
["度数","du4shu5"],
["度數","du4shu5"],
["度玛","du4ma3"],
["度瑪","du4ma3"]
],
"座":[
["座儿","zuo4r5"],
["座椅","zuo4yi3"]
],
"庫":[
["庫巴","ku4ba1"],
["庫爾","ku4er3"],
["庫布裡克","ku4bu4li3ke4"],
["庫裡提巴","ku4li3ti2ba1"]
],
"庭":[
["庭审","ting2shen3"],
["庭審","ting2shen3"],
["庭長","ting2zhang3"],
["庭长","ting2zhang3"]
],
"庶":[
["庶子","shu4zi3"]
],
"康":[
["康保","kang1bao3"],
["康馬","kang1ma3"],
["康马","kang1ma3"]
],
"廁":[
["廁所","ce4suo3"]
],
"廈":[
["廈門","xia4men2"]
],
"廉":[
["廉恥","lian2chi3"],
["廉署","lian2shu3"],
["廉耻","lian2chi3"],
["廉得其情","lian2de2qi2qing2"]
],
"廊":[
["廊坊","lang2fang1"]
],
"廝":[
["廝守","si1shou3"],
["廝打","si1da3"]
],
"廟":[
["廟塔","miao4ta3"],
["廟宇","miao4yu3"]
],
"廠":[
["廠主","chang3zhu3"],
["廠史","chang3shi3"],
["廠址","chang3zhi3"],
["廠長","chang3zhang3"]
],
"廢":[
["廢品","fei4pin3"],
["廢止","fei4zhi3"],
["廢水","fei4shui3"],
["廢紙","fei4zhi3"],
["廢鐵","fei4tie3"]
],
"廣":[
["廣九","guang3jiu3"],
["廣場","guang3chang3"],
["廣島","guang3dao3"],
["廣水","guang3shui3"],
["廣告片","guang3gao4pian1"]
],
"廳":[
["廳長","ting1zhang3"]
],
"延":[
["延展","yan2zhan3"],
["延揽","yan2lan3"],
["延攬","yan2lan3"],
["延緩","yan2huan3"],
["延缓","yan2huan3"],
["延請","yan2qing3"],
["延请","yan2qing3"],
["延髓","yan2sui3"]
],
"建":[
["建党","jian4dang3"],
["建好","jian4hao3"],
["建始","jian4shi3"],
["建水","jian4shui3"],
["建都","jian4du1"],
["建黨","jian4dang3"]
],
"开":[
["开伙","kai1huo3"],
["开卷","kai1juan4"],
["开口","kai1kou3"],
["开启","kai1qi3"],
["开地","kai1di4"],
["开场","kai1chang3"],
["开垦","kai1ken3"],
["开始","kai1shi3"],
["开导","kai1dao3"],
["开展","kai1zhan3"],
["开往","kai1wang3"],
["开打","kai1da3"],
["开拓","kai1tuo4"],
["开敞","kai1chang3"],
["开朗","kai1lang3"],
["开本","kai1ben3"],
["开水","kai1shui3"],
["开满","kai1man3"],
["开演","kai1yan3"],
["开火","kai1huo3"],
["开眼","kai1yan3"],
["开笔","kai1bi3"],
["开脸","kai1lian3"],
["开讲","kai1jiang3"],
["开远","kai1yuan3"],
["开通","kai1tong5"],
["开采","kai1cai3"],
["开销","kai1xiao5"],
["开锁","kai1suo3"],
["开鲁","kai1lu3"],
["开不了","kai1bu5liao3"],
["开不动","kai1bu5dong4"],
["开不开","kai1bu5kai1"],
["开不成","kai1bu5cheng2"],
["开倒车","kai1dao4che1"],
["开小差","kai1xiao3chai1"],
["开得了","kai1de5liao3"],
["开都河","kai1du1he2"],
["开天避地","kai1tian1bi4di4"],
["开天闢地","kai1tian1pi4di4"]
],
"异":[
["异体","yi4ti3"],
["异地","yi4di4"],
["异彩","yi4cai3"],
["异母","yi4mu3"],
["异种","yi4zhong3"],
["异乎寻常","yi4hu1xun2chang2"]
],
"弄":[
["弄小","nong4xiao3"],
["弄短","nong4duan3"],
["弄脏","nong4zang1"],
["弄醒","nong4xing3"],
["弄不下","nong4bu5xia4"],
["弄不了","nong4bu5liao3"],
["弄不住","nong4bu5zhu4"],
["弄不准","nong4bu5zhun3"],
["弄不到","nong4bu5dao4"],
["弄不动","nong4bu5dong4"],
["弄不動","nong4bu5dong4"],
["弄不好","nong4bu5hao3"],
["弄不巧","nong4bu5qiao3"],
["弄不清","nong4bu5qing1"],
["弄不準","nong4bu5zhun3"],
["弄不碎","nong4bu5sui4"],
["弄不轉","nong4bu5zhuan4"],
["弄不转","nong4bu5zhuan4"],
["弄不过","nong4bu5guo4"],
["弄不過","nong4bu5guo4"],
["弄得上","nong4de5shang4"],
["弄明白","nong4ming2bai2"],
["弄不清楚","nong4bu5qing1chu3"],
["弄得大伙一楞","nong4de5da4huo3yi2leng4"]
],
"弓":[
["弓弩","gong1nu3"],
["弓弦儿","gong1xian2r5"]
],
"弔":[
["弔丧","diao4sang1"],
["弔古","diao4gu3"],
["弔喪","diao4sang1"],
["弔詭","diao4gui3"],
["弔诡","diao4gui3"]
],
"引":[
["引产","yin3chan3"],
["引导","yin3dao3"],
["引導","yin3dao3"],
["引得","yin3de2"],
["引徵","yin3zheng1"],
["引水","yin3shui3"],
["引火","yin3huo3"],
["引產","yin3chan3"],
["引語","yin3yu3"],
["引语","yin3yu3"],
["引起","yin3qi3"],
["引領","yin3ling3"],
["引頸","yin3jing3"],
["引领","yin3ling3"],
["引颈","yin3jing3"],
["引吭高歌","yin3hang2gao1ge1"]
],
"弛":[
["弛緩","chi2huan3"],
["弛缓","chi2huan3"]
],
"弟":[
["弟兄","di4xiong5"],
["弟子","di4zi3"],
["弟弟","di4di5"]
],
"张":[
["张北","zhang1bei3"],
["张华","zhang1hua4"],
["张口","zhang1kou3"],
["张嘴","zhang1zui3"],
["张宝","zhang1bao3"],
["张手","zhang1shou3"],
["张掖","zhang1ye4"],
["张网","zhang1wang3"],
["张罗","zhang1luo5"],
["张角","zhang1jue2"],
["张僧繇","zhang1seng1you2"],
["张华光","zhang1hua2guang1"],
["张华明","zhang1hua2ming2"],
["张国焘","zhang1guo2tao1"],
["张学友","zhang1xue2you3"]
],
"弥":[
["弥撒","mi2sa5"],
["弥缝","mi2feng2"],
["弥补","mi2bu3"],
["弥勒佛","mi2le4fo2"]
],
"弦":[
["弦乐","xian2yue4"],
["弦樂","xian2yue4"]
],
"弱":[
["弱小","ruo4xiao3"],
["弱点","ruo4dian3"],
["弱碱","ruo4jian3"],
["弱鹼","ruo4jian3"],
["弱點","ruo4dian3"]
],
"張":[
["張北","zhang1bei3"],
["張口","zhang1kou3"],
["張嘴","zhang1zui3"],
["張寶","zhang1bao3"],
["張手","zhang1shou3"],
["張掖","zhang1ye4"],
["張網","zhang1wang3"],
["張羅","zhang1luo5"],
["張華","zhang1hua4"],
["張角","zhang1jue2"],
["張僧繇","zhang1seng1you2"],
["張國燾","zhang1guo2tao1"],
["張學友","zhang1xue2you3"],
["張華光","zhang1hua2guang1"],
["張華明","zhang1hua2ming2"]
],
"強":[
["強使","qiang3shi3"],
["強勁","qiang2jing4"],
["強取","qiang2qu3"],
["強嘴","jiang4zui3"],
["強子","qiang2zi3"],
["強忍","qiang2ren3"],
["強打","qiang2da3"],
["強拉","qiang3la1"],
["強橫","qiang2heng4"],
["強者","qiang2zhe3"],
["強迫","qiang3po4"],
["強鹼","qiang2jian3"],
["強迫癥","qiang2po4zheng4"],
["強詞奪理","qiang3ci2duo2li3"],
["強將手下無弱兵","qiang2jiang4shou3xia4wu2ruo4bing1"],
["強龍不壓地頭蛇","qiang2long2bu4ya1di4tou2she2"]
],
"弹":[
["弹出","tan2chu1"],
["弹力","tan2li4"],
["弹劾","tan2he2"],
["弹压","tan2ya1"],
["弹唱","tan2chang4"],
["弹夹","dan4jia2"],
["弹奏","tan2zou4"],
["弹孔","dan4kong3"],
["弹射","tan2she4"],
["弹性","tan2xing4"],
["弹拨","tan2bo1"],
["弹指","tan2zhi3"],
["弹斥","tan2chi4"],
["弹牙","tan2ya2"],
["弹琴","tan2qin2"],
["弹簧","tan2huang2"],
["弹纠","tan2jiu1"],
["弹花","tan2hua1"],
["弹词","tan2ci2"],
["弹跳","tan2tiao4"],
["弹拨乐","tan2bo1yue4"],
["弹涂鱼","tan2tu2yu2"],
["弹冠相庆","tan2guan1xiang1qing4"],
["弹指一挥","tan2zhi3yi4hui1"],
["弹指可得","tan2zhi3ke3de2"]
],
"强":[
["强使","qiang3shi3"],
["强劲","qiang2jing4"],
["强取","qiang2qu3"],
["强嘴","jiang4zui3"],
["强子","qiang2zi3"],
["强忍","qiang2ren3"],
["强打","qiang2da3"],
["强拉","qiang3la1"],
["强横","qiang2heng4"],
["强碱","qiang2jian3"],
["强者","qiang2zhe3"],
["强迫","qiang3po4"],
["强迫症","qiang2po4zheng4"],
["强词夺理","qiang3ci2duo2li3"],
["强将手下无弱兵","qiang2jiang4shou3xia4wu2ruo4bing1"],
["强龙不压地头蛇","qiang2long2bu4ya1di4tou2she2"]
],
"彆":[
["彆嘴","bie4zui3"],
["彆扭","bie4niu5"]
],
"彈":[
["彈出","tan2chu1"],
["彈力","tan2li4"],
["彈劾","tan2he2"],
["彈唱","tan2chang4"],
["彈壓","tan2ya1"],
["彈夾","dan4jia2"],
["彈奏","tan2zou4"],
["彈孔","dan4kong3"],
["彈射","tan2she4"],
["彈性","tan2xing4"],
["彈指","tan2zhi3"],
["彈撥","tan2bo1"],
["彈斥","tan2chi4"],
["彈牙","tan2ya2"],
["彈琴","tan2qin2"],
["彈簧","tan2huang2"],
["彈糾","tan2jiu1"],
["彈花","tan2hua1"],
["彈詞","tan2ci2"],
["彈跳","tan2tiao4"],
["彈塗魚","tan2tu2yu2"],
["彈撥樂","tan2bo1yue4"],
["彈冠相慶","tan2guan1xiang1qing4"],
["彈指一揮","tan2zhi3yi4hui1"],
["彈指可得","tan2zhi3ke3de2"],
["彈盡援絕","dan4jin4yuan2jue2"],
["彈盡糧絕","dan4jin4liang2jue2"]
],
"彌":[
["彌撒","mi2sa5"],
["彌縫","mi2feng2"],
["彌補","mi2bu3"],
["彌勒佛","mi2le4fo2"]
],
"归":[
["归主","gui1zhu3"],
["归属","gui1shu3"],
["归拢","gui1long3"],
["归给","gui1gei3"],
["归还","gui1huan2"],
["归降","gui1xiang2"]
],
"当":[
["当上","dang1shang5"],
["当为","dang1wei2"],
["当作","dang4zuo4"],
["当做","dang4zuo4"],
["当儿","dang1r5"],
["当地","dang1di4"],
["当场","dang1chang3"],
["当天","dang4tian1"],
["当成","dang4cheng2"],
["当晚","dang4wan3"],
["当月","dang4yue4"],
["当涂","dang1tu2"],
["当真","dang4zhen1"],
["当选","dang1xuan3"],
["当铺","dang4pu4"],
["当不了","dang1bu5liao3"],
["当回事","dang4hui2shi4"],
["当得了","dang1de5liao3"],
["当务之急","dang1wu4zhi1ji2"],
["当回事儿","dang4hui2shi4r5"],
["当头一棒","dang1tou2yi2bang4"]
],
"录":[
["录供","lu4gong4"],
["录取","lu4qu3"]
],
"彙":[
["彙攏","hui4long3"],
["彙整","hui4zheng3"],
["彙總","hui4zong3"]
],
"形":[
["形体","xing2ti3"],
["形跡","xing2ji4"],
["形迹","xing2ji4"],
["形體","xing2ti3"],
["形於色","xing2yu2se4"],
["形容不出","xing2rong2bu5chu1"]
],
"彩":[
["彩虹","cai3hong2"]
],
"彪":[
["彪炳","biao1bing3"]
],
"彫":[
["彫版","diao1ban3"],
["彫琢","diao1zhuo2"]
],
"彰":[
["彰显","zhang1xian3"],
["彰武","zhang1wu3"],
["彰顯","zhang1xian3"],
["彰善瘅恶","zhang1shan4dan4e4"],
["彰善癉惡","zhang1shan4dan4e4"],
["彰明較著","zhang1ming2jiao4zhu4"],
["彰明较著","zhang1ming2jiao4zhu4"]
],
"影":[
["影兒","ying3er2"],
["影响","ying3xiang3"],
["影響","ying3xiang3"]
],
"彷":[
["彷徨","pang2huang2"]
],
"彻":[
["彻底","che4di3"],
["彻骨","che4gu3"]
],
"彼":[
["彼得","bi3de2"],
["彼息","bi3xi1"],
["彼此","bi3ci3"],
["彼珥","bi3er3"]
],
"往":[
["往古","wang3gu3"],
["往往","wang3wang3"],
["往跡","wang3ji4"],
["往返","wang3fan3"],
["往还","wang3huan2"],
["往迹","wang3ji4"],
["往還","wang3huan2"],
["往泥裡踩","wang3ni4li3cai3"],
["往泥里踩","wang3ni4li3cai3"]
],
"征":[
["征勦","zheng1jiao3"],
["征地","zheng1di4"],
["征夫","zheng1fu1"],
["征得","zheng1de2"],
["征敛","zheng1lian3"],
["征稿","zheng1gao3"],
["征討","zheng1tao3"],
["征讨","zheng1tao3"],
["征馬","zheng1ma3"],
["征马","zheng1ma3"]
],
"径":[
["径迹","jing4ji4"]
],
"待":[
["待在","dai1zai4"],
["待得","dai4de2"],
["待考","dai4kao3"],
["待解","dai4jie3"],
["待不住","dai1bu5zhu4"]
],
"很":[
["很好","hen3hao3"],
["很少","hen3shao3"],
["很想","hen3xiang3"]
],
"律":[
["律吕","lv4lv3"],
["律呂","lv4lv3"],
["律法","lv4fa3"]
],
"後":[
["後影","hou4ying3"],
["後悔","hou4hui3"],
["後果","hou4guo3"],
["後母","hou4mu3"],
["後綴","hou4zhui4"],
["後者","hou4zhe3"],
["後邊","hou4bian5"],
["後面","hou4mian5"],
["後頭","hou4tou5"]
],
"徐":[
["徐水","xu2shui3"],
["徐緩","xu2huan3"],
["徐缓","xu2huan3"]
],
"徑":[
["徑跡","jing4ji4"]
],
"徒":[
["徒弟","tu2di5"],
["徒手","tu2shou3"]
],
"得":[
["得上","de2shang4"],
["得中","de2zhong4"],
["得主","de2zhu3"],
["得了","de2le5"],
["得亏","dei3kui1"],
["得享","de2xiang3"],
["得人","de2ren2"],
["得令","de2ling4"],
["得以","de2yi3"],
["得体","de2ti3"],
["得來","de2lai2"],
["得便","de2bian4"],
["得出","de2chu1"],
["得分","de2fen1"],
["得到","de2dao4"],
["得力","de2li4"],
["得劲","de2jin4"],
["得势","de2shi4"],
["得勁","de2jin4"],
["得勝","de2sheng4"],
["得勢","de2shi4"],
["得名","de2ming2"],
["得君","de2jun1"],
["得听","de2ting1"],
["得味","de2wei4"],
["得喜","de2xi3"],
["得失","de2shi1"],
["得奖","de2jiang3"],
["得子","de2zi3"],
["得宜","de2yi2"],
["得实","de2shi2"],
["得宠","de2chong3"],
["得實","de2shi2"],
["得寵","de2chong3"],
["得巴","de2ba5"],
["得年","de2nian2"],
["得幸","de2xing4"],
["得当","de2dang4"],
["得彩","de2cai3"],
["得很","de5hen3"],
["得得","de2de2"],
["得志","de2zhi4"],
["得悉","de2xi1"],
["得意","de2yi4"],
["得所","de2suo3"],
["得手","de2shou3"],
["得撒","de2sa1"],
["得救","de2jiu4"],
["得数","de2shu4"],
["得數","de2shu4"],
["得文","de2wen2"],
["得时","de2shi2"],
["得時","de2shi2"],
["得来","de2lai2"],
["得标","de2biao1"],
["得榮","de2rong2"],
["得標","de2biao1"],
["得民","de2min2"],
["得法","de2fa3"],
["得獎","de2jiang3"],
["得率","de2lv4"],
["得瑕","de2xia2"],
["得用","de2yong4"],
["得當","de2dang4"],
["得病","de2bing4"],
["得益","de2yi4"],
["得看","dei3kan4"],
["得着","de2zhao2"],
["得知","de2zhi1"],
["得神","de2shen2"],
["得票","de2piao4"],
["得空","de2kong4"],
["得窍","de2qiao4"],
["得竅","de2qiao4"],
["得策","de2ce4"],
["得粮","de2liang2"],
["得糧","de2liang2"],
["得繼","de2ji4"],
["得继","de2ji4"],
["得罪","de2zui5"],
["得职","de2zhi2"],
["得職","de2zhi2"],
["得聽","de2ting1"],
["得胜","de2sheng4"],
["得脸","de2lian3"],
["得臉","de2lian3"],
["得自","de2zi4"],
["得色","de2se4"],
["得荣","de2rong2"],
["得著","de2zhao2"],
["得虧","dei3kui1"],
["得計","de2ji4"],
["得證","de2zheng4"],
["得计","de2ji4"],
["得证","de2zheng4"],
["得逞","de2cheng3"],
["得道","de2dao4"],
["得閑","de2xian2"],
["得間","de2jian4"],
["得闲","de2xian2"],
["得间","de2jian4"],
["得非","de2fei1"],
["得體","de2ti3"],
["得不到","de2bu5dao4"],
["得不着","de2bu5zhao2"],
["得不著","de2bu5zhao2"],
["得人儿","de2ren2r5"],
["得便儿","de2bian4r5"],
["得便宜","de2pian2yi5"],
["得劲儿","de2jin4r5"],
["得天下","de2tian1xia4"],
["得尔塔","dei3er3ta3"],
["得数儿","de2shu4r5"],
["得样儿","de2yang4r5"],
["得樣兒","de2yang4r5"],
["得爾塔","dei3er3ta3"],
["得益处","de2yi4chu5"],
["得益處","de2yi4chu5"],
["得空儿","de2kong4r5"],
["得罪人","de2zui4ren2"],
["得一望二","de2yi2wang4er4"],
["得一枝栖","de2yi4zhi1qi1"],
["得一枝棲","de2yi4zhi1qi1"],
["得不偿失","de2bu4chang2shi1"],
["得不償失","de2bu4chang2shi1"],
["得亲芳泽","de2qin1fang1ze2"],
["得人意儿","de2ren2yi4r5"],
["得偿夙愿","de2chang2su4yuan4"],
["得償夙願","de2chang2su4yuan4"],
["得克萨斯","de2ke4sa4si1"],
["得克薩斯","de2ke4sa4si1"],
["得其所哉","de2qi2suo3zai1"],
["得其皮毛","de2qi2pi2mao2"],
["得匣还珠","de2xia2huan2zhu1"],
["得匣還珠","de2xia2huan2zhu1"],
["得占勿药","de2zhan1wu4yao4"],
["得占勿藥","de2zhan1wu4yao4"],
["得天独厚","de2tian1du2hou4"],
["得天獨厚","de2tian1du2hou4"],
["得寸进尺","de2cun4jin4chi3"],
["得寸進尺","de2cun4jin4chi3"],
["得少失多","de2shao3shi1duo1"],
["得庆更生","de2qing4geng1sheng1"],
["得心应手","de2xin1ying4shou3"],
["得心應手","de2xin1ying4shou3"],
["得忍且忍","de2ren3qie3ren3"],
["得慰平生","de2wei4ping2sheng1"],
["得慶更生","de2qing4geng1sheng1"],
["得新厌旧","de2xin1yan4jiu4"],
["得新厭舊","de2xin1yan4jiu4"],
["得未曾有","de2wei4ceng2you3"],
["得此失彼","de2ci3shi1bi3"],
["得步进步","de2bu4jin4bu4"],
["得步進步","de2bu4jin4bu4"],
["得窥一斑","de2kui1yi4ban1"],
["得窥全豹","de2kui1quan2bao4"],
["得窥门径","de2kui1men2jing4"],
["得窺一斑","de2kui1yi4ban1"],
["得窺全豹","de2kui1quan2bao4"],
["得窺門徑","de2kui1men2jing4"],
["得罢且罢","de2ba4qie3ba4"],
["得罷且罷","de2ba4qie3ba4"],
["得而复失","de2er2fu4shi1"],
["得而復失","de2er2fu4shi1"],
["得而誅之","de2er2zhu1zhi1"],
["得而诛之","de2er2zhu1zhi1"],
["得親芳澤","de2qin1fang1ze2"],
["得負責任","dei3fu4ze2ren4"],
["得负责任","dei3fu4ze2ren4"],
["得过且过","de2guo4qie3guo4"],
["得遂所愿","de2sui2suo3yuan4"],
["得遂所願","de2sui2suo3yuan4"],
["得過且過","de2guo4qie3guo4"],
["得陇望蜀","de2long3wang4shu3"],
["得隴望蜀","de2long3wang4shu3"],
["得風便轉","de2feng1bian4zhuan3"],
["得风便转","de2feng1bian4zhuan3"],
["得魚忘筌","de2yu2wang4quan2"],
["得鱼忘筌","de2yu2wang4quan2"],
["得理不饒人","de2li3bu4rao2ren2"],
["得理不饶人","de2li3bu4rao2ren2"],
["得饒人處且饒人","de2rao2ren2chu4qie3rao2ren2"],
["得饶人处且饶人","de2rao2ren2chu4qie3rao2ren2"]
],
"從":[
["從古","cong2gu3"],
["從女","cong2nv3"],
["從小","cong2xiao3"],
["從屬","cong2shu3"],
["從此","cong2ci3"],
["從母","cong2mu3"],
["從一而終","cong2yi4er2zhong1"],
["從那時侯","cong2na4shi2hou4"]
],
"御":[
["御史","yu4shi3"],
["御夫座","yu4fu1zuo4"]
],
"復":[
["復古","fu4gu3"],
["復審","fu4shen3"],
["復興","fu4xing1"],
["復診","fu4zhen3"],
["復轉","fu4zhuan3"],
["復辟","fu4bi4"]
],
"循":[
["循法","xun2fa3"],
["循都姬","xun2du1ji1"],
["循規蹈矩","xun2gui1dao3ju3"],
["循规蹈矩","xun2gui1dao3ju3"]
],
"微":[
["微小","wei1xiao3"],
["微扰","wei1rao3"],
["微擾","wei1rao3"],
["微火","wei1huo3"],
["微管","wei1guan3"],
["微米","wei1mi3"],
["微薄","wei1bo2"],
["微軟","wei1ruan3"],
["微软","wei1ruan3"],
["微微一笑","wei1wei1yi2xiao4"]
],
"徵":[
["徵兆","zheng1zhao4"],
["徵兵","zheng1bing1"],
["徵募","zheng1mu4"],
["徵召","zheng1zhao4"],
["徵士","zheng1shi4"],
["徵實","zheng1shi2"],
["徵得","zheng1de2"],
["徵收","zheng1shou1"],
["徵斂","zheng1lian3"],
["徵求","zheng1qiu2"],
["徵用","zheng1yong4"],
["徵發","zheng1fa1"],
["徵稅","zheng1shui4"],
["徵稿","zheng1gao3"],
["徵聘","zheng1pin4"],
["徵詢","zheng1xun2"],
["徵象","zheng1xiang4"],
["徵集","zheng1ji2"],
["徵名責實","zheng1ming2ze2shi2"]
],
"德":[
["德保","de2bao3"],
["德兴","de2xing1"],
["德興","de2xing1"],
["德裡","de2li3"],
["德語","de2yu3"],
["德语","de2yu3"],
["德都","de2du1"],
["德里","de2li3"],
["德勒巴克","de2le4ba1ke4"],
["德薄能鮮","de2bo2neng2xian3"],
["德薄能鲜","de2bo2neng2xian3"],
["德国统一社会党","de2guo2tong3yi2she4hui4dang3"],
["德國統一社會黨","de2guo2tong3yi2she4hui4dang3"]
],
"徹":[
["徹底","che4di3"],
["徹骨","che4gu3"]
],
"心":[
["心上","xin1shang5"],
["心事","xin1shi5"],
["心土","xin1tu3"],
["心地","xin1di4"],
["心坎","xin1kan3"],
["心底","xin1di3"],
["心得","xin1de2"],
["心思","xin1si5"],
["心想","xin1xiang3"],
["心梗","xin1geng3"],
["心死","xin1si3"],
["心版","xin1ban3"],
["心理","xin1li3"],
["心眼","xin1yan3"],
["心窄","xin1zhai3"],
["心許","xin1xu3"],
["心许","xin1xu3"],
["心軟","xin1ruan3"],
["心软","xin1ruan3"],
["心里","xin1li5"],
["心領","xin1ling3"],
["心领","xin1ling3"],
["心上人","xin1shang4ren2"],
["心眼儿","xin1yan3r5"],
["心窝儿","xin1wo1r5"],
["心脏病","xin1zang4bing4"],
["心裡話","xin1li3hua4"],
["心里话","xin1li3hua4"],
["心安理得","xin1an1li3de2"],
["心宽体胖","xin1kuan1ti3pan2"],
["心寬體胖","xin1kuan1ti3pan2"],
["心急火燎","xin1ji2huo3liao3"],
["心生一計","xin1sheng1yi2ji4"],
["心生一计","xin1sheng1yi2ji4"],
["心裡一愣","xin1li3yi2leng4"],
["心裡悲痛","xin1li3bei1tong4"],
["心裡明白","xin1li3ming2bai5"],
["心裡盤算","xin1li3pan2suan4"],
["心裡難過","xin1li3nan2guo4"],
["心里一愣","xin1li3yi2leng4"],
["心里悲痛","xin1li3bei1tong4"],
["心里明白","xin1li3ming2bai5"],
["心里盘算","xin1li3pan2suan4"],
["心里难过","xin1li3nan2guo4"],
["心病还得心药治","xin1bing4hai2dei3xin1yao4zhi4"],
["心病還得心藥治","xin1bing4hai2dei3xin1yao4zhi4"]
],
"必":[
["必应","bi4ying4"],
["必得","bi4dei3"],
["必應","bi4ying4"],
["必死","bi4si3"],
["必得着","bi4de2zhao2"],
["必得著","bi4de2zhao2"],
["必不可免","bi4bu5ke3mian3"],
["必不可少","bi4bu5ke3shao3"],
["必不得已","bi4bu5de2yi3"],
["必和必拓","bi4huo2bi4tuo4"]
],
"忌":[
["忌口","ji4kou3"],
["忌妒","ji4du5"]
],
"忍":[
["忍恥","ren3chi3"],
["忍者","ren3zhe3"],
["忍耻","ren3chi3"],
["忍辱","ren3ru3"],
["忍不住","ren3bu5zhu4"]
],
"忏":[
["忏悔","chan4hui3"]
],
"志":[
["志向","zhi4xiang5"],
["志气","zhi4qi5"],
["志氣","zhi4qi5"],
["志在必得","zhi4zai4bi4de2"]
],
"忘":[
["忘我","wang4wo3"],
["忘不了","wang4bu5liao3"]
],
"忙":[
["忙於","mang2yu2"],
["忙活","mang2huo5"],
["忙不迭","mang2bu5die2"],
["忙不过来","mang2bu5guo4lai5"],
["忙不過來","mang2bu5guo4lai5"],
["忙得蝎虎","mang2de5xie1hu5"]
],
"忠":[
["忠勇","zhong1yong3"],
["忠於","zhong1yu2"]
],
"快":[
["快感","kuai4gan3"],
["快板","kuai4ban3"],
["快活","kuai4huo5"],
["快点","kuai4dian3"],
["快艇","kuai4ting3"],
["快跑","kuai4pao3"],
["快馬","kuai4ma3"],
["快马","kuai4ma3"],
["快點","kuai4dian3"],
["快板儿","kuai4ban3r5"],
["快点儿","kuai4dian5r5"],
["快點兒","kuai4dian5r5"]
],
"念":[
["念佛","nian4fo2"],
["念叨","nian4dao5"],
["念头","nian4tou5"],
["念頭","nian4tou5"],
["念不上","nian4bu5shang4"],
["念不下","nian4bu5xia4"]
],
"忽":[
["忽悠","hu1you5"],
["忽閃","hu1shan3"],
["忽闪","hu1shan3"]
],
"怀":[
["怀古","huai2gu3"],
["怀有","huai2you3"],
["怀表","huai2biao3"],
["怀远","huai2yuan3"],
["怀里","huai2li3"]
],
"态":[
["态度","tai4du5"]
],
"怂":[
["怂恿","song3yong3"]
],
"怎":[
["怎敢","zen3gan3"],
["怎見得","zen3jian4de2"],
["怎见得","zen3jian4de2"],
["怎麽了","zen3me5le5"],
["怎么得了","zen3me5de2liao3"],
["怎麼得了","zen3me5de2liao3"]
],
"怒":[
["怒号","nu4hao2"],
["怒吼","nu4hou3"],
["怒喝","nu4he4"],
["怒火","nu4huo3"],
["怒號","nu4hao2"],
["怒发冲冠","nu4fa4chong1guan1"],
["怒髮衝冠","nu4fa4chong1guan1"]
],
"怔":[
["怔怔","zheng4zheng4"],
["怔神儿","zheng4shen2r5"],
["怔神兒","zheng4shen2r5"]
],
"怕":[
["怕是","pa4shi5"],
["怕死","pa4si3"]
],
"怜":[
["怜悯","lian2min3"]
],
"思":[
["思忖","si1cun3"],
["思想","si1xiang3"],
["思索","si1suo3"],
["思考","si1kao3"],
["思量","si1liang5"]
],
"怡":[
["怡保","yi2bao3"]
],
"急":[
["急务","ji2wu4"],
["急務","ji2wu4"],
["急於","ji2yu2"],
["急眼","ji2yan3"],
["急診","ji2zhen3"],
["急诊","ji2zhen3"],
["急轉","ji2zhuan3"],
["急转","ji2zhuan3"]
],
"性":[
["性感","xing4gan3"]
],
"怪":[
["怪气","guai4qi5"],
["怪氣","guai4qi5"],
["怪物","guai4wu5"],
["怪癖","guai4pi3"],
["怪相","guai4xiang4"],
["怪不得","guai4bu5de5"],
["怪念头","guai4nian4tou2"],
["怪念頭","guai4nian4tou2"],
["怪物似","guai4wu4si4"],
["怪声怪气","guai4sheng1guai4qi4"],
["怪模怪样","guai4mu2guai4yang4"],
["怪模怪樣","guai4mu2guai4yang4"],
["怪聲怪氣","guai4sheng1guai4qi4"],
["怪裡怪氣","guai4li5guai4qi4"],
["怪里怪气","guai4li5guai4qi4"]
],
"总":[
["总体","zong3ti3"],
["总务","zong3wu4"],
["总得","zong3dei3"],
["总有","zong3you3"],
["总理","zong3li3"],
["总管","zong3guan3"],
["总统","zong3tong3"],
["总署","zong3shu3"],
["总览","zong3lan3"],
["总长","zong3zhang3"],
["总杆赛","zong3gan3sai4"],
["总面积","zong3mian4ji1"]
],
"恆":[
["恆久","heng2jiu3"]
],
"恐":[
["恐吓","kong3he4"],
["恐嚇","kong3he4"],
["恐鳥","kong3niao3"],
["恐鸟","kong3niao3"],
["恐怖分子","kong3bu4fen4zi3"]
],
"恒":[
["恒久","heng2jiu3"]
],
"恥":[
["恥辱","chi3ru3"],
["恥骨","chi3gu3"]
],
"恨":[
["恨恶","hen4wu4"],
["恨惡","hen4wu4"],
["恨不得","hen4bu5de5"],
["恨不能","hen4bu5neng2"],
["恨海难填","hen4hai3nan2tian2"],
["恨海難填","hen4hai3nan2tian2"]
],
"恩":[
["恩主","en1zhu3"],
["恩典","en1dian3"],
["恩准","en1zhun3"],
["恩宠","en1chong3"],
["恩寵","en1chong3"],
["恩準","en1zhun3"],
["恩給","en1ji3"],
["恩给","en1ji3"],
["恩賈梅納","en1jia3mei2na4"],
["恩贾梅纳","en1jia3mei2na4"]
],
"恪":[
["恪守","ke4shou3"]
],
"恫":[
["恫吓","dong4he4"],
["恫嚇","dong4he4"]
],
"恭":[
["恭喜","gong1xi3"],
["恭維","gong1wei5"],
["恭维","gong1wei5"]
],
"息":[
["息借","xi1jie4"],
["息县","xi1xian4"],
["息怒","xi1nu4"],
["息拉","xi1la1"],
["息末","xi1mo4"],
["息票","xi1piao4"],
["息縣","xi1xian4"],
["息峰县","xi1feng1xian4"],
["息峰縣","xi1feng1xian4"],
["息息相关","xi1xi1xiang1guan1"],
["息息相關","xi1xi1xiang1guan1"]
],
"恰":[
["恰好","qia4hao3"],
["恰巧","qia4qiao3"],
["恰当","qia4dang4"],
["恰當","qia4dang4"],
["恰到好处","qia4dao4hao3chu4"],
["恰到好處","qia4dao4hao3chu4"],
["恰如其分","qia4ru2qi2fen4"]
],
"恳":[
["恳请","ken3qing3"]
],
"恶":[
["恶口","e4kou3"],
["恶少","e4shao4"],
["恶心","e3xin1"],
["恶恨","wu4hen4"],
["恶感","e4gan3"],
["恶损","e4sun3"],
["恶搞","e4gao3"],
["恶果","e4guo3"],
["恶水","e4shui3"],
["恶犬","e4quan3"],
["恶狠","e4hen3"],
["恶癖","e4pi3"],
["恶相","e4xiang4"],
["恶补","e4bu3"],
["恶语","e4yu3"],
["恶迹","e4ji4"],
["恶鬼","e4gui3"],
["恶势力","e4shi4li4"],
["恶名儿","e4ming2r5"],
["恶恶实实","e4e5shi1shi1"],
["恶意中伤","e4yi4zhong1shang1"]
],
"恺":[
["恺撒","kai3sa3"]
],
"恼":[
["恼火","nao3huo3"]
],
"悄":[
["悄悄","qiao3qiao3"],
["悄然","qiao3ran2"],
["悄悄地","qiao1qiao1de5"]
],
"悅":[
["悅耳","yue4er3"]
],
"悍":[
["悍勇","han4yong3"]
],
"悔":[
["悔改","hui3gai3"]
],
"悟":[
["悟得","wu4de2"],
["悟性","wu4xing5"]
],
"悠":[
["悠久","you1jiu3"]
],
"患":[
["患者","huan4zhe3"],
["患难","huan4nan4"],
["患難","huan4nan4"],
["患得患失","huan4de2huan4shi1"]
],
"悦":[
["悦耳","yue4er3"]
],
"您":[
["您好","nin2hao3"],
["您是不是要查","nin2shi4bu2shi4yao1cha2"]
],
"悬":[
["悬赏","xuan2shang3"]
],
"悲":[
["悲号","bei1hao2"],
["悲悯","bei1min3"],
["悲惨","bei1can3"],
["悲慘","bei1can3"],
["悲憫","bei1min3"],
["悲戚","bei1qi1"],
["悲苦","bei1ku3"],
["悲號","bei1hao2"],
["悲欢离合","bei1huan1li2he2"],
["悲歡離合","bei1huan1li2he2"]
],
"悶":[
["悶熱","men1re4"],
["悶不住","men4bu5zhu4"],
["悶得很","men1de5hen3"],
["悶得慌","men1de5huang1"]
],
"情":[
["情侣","qing2lv3"],
["情侶","qing2lv3"],
["情分","qing2fen4"],
["情场","qing2chang3"],
["情場","qing2chang3"],
["情夫","qing2fu1"],
["情形","qing2xing5"],
["情感","qing2gan3"],
["情景","qing2jing3"],
["情理","qing2li3"],
["情种","qing2zhong4"],
["情種","qing2zhong4"],
["情急了","qing2ji2liao3"]
],
"惊":[
["惊喜","jing1xi3"],
["惊恐","jing1kong3"],
["惊悚","jing1song3"],
["惊扰","jing1rao3"],
["惊赏","jing1shang3"],
["惊起","jing1qi3"],
["惊醒","jing1xing3"],
["惊险","jing1xian3"],
["惊马","jing1ma3"],
["惊鸟","jing1niao3"],
["惊天动地","jing1tian1dong4di4"],
["惊奇不已","jing1ji1bu4yi3"]
],
"惟":[
["惟有","wei2you3"]
],
"惠":[
["惠普","hui4pu3"],
["惠水","hui4shui3"],
["惠更斯","hui4geng1si1"]
],
"惡":[
["惡口","e4kou3"],
["惡少","e4shao4"],
["惡心","e3xin1"],
["惡恨","wu4hen4"],
["惡感","e4gan3"],
["惡損","e4sun3"],
["惡搞","e4gao3"],
["惡果","e4guo3"],
["惡水","e4shui3"],
["惡犬","e4quan3"],
["惡狠","e4hen3"],
["惡癖","e4pi3"],
["惡相","e4xiang4"],
["惡補","e4bu3"],
["惡語","e4yu3"],
["惡跡","e4ji4"],
["惡鬼","e4gui3"],
["惡勢力","e4shi4li4"],
["惡惡實實","e4e5shi1shi1"],
["惡意中傷","e4yi4zhong1shang1"]
],
"惨":[
["惨惨","can3can3"],
["惨景","can3jing3"]
],
"惱":[
["惱火","nao3huo3"]
],
"想":[
["想想","xiang3xiang5"],
["想死","xiang3si3"],
["想法","xiang3fa3"],
["想盡","xiang3jin4"],
["想起","xiang3qi3"],
["想过","xiang3guo5"],
["想過","xiang3guo5"],
["想一想","xiang3yi5xiang5"],
["想不出","xiang3bu5chu1"],
["想不到","xiang3bu5dao4"],
["想不开","xiang3bu5kai1"],
["想不起","xiang3bu5qi3"],
["想不透","xiang3bu5tou4"],
["想不通","xiang3bu5tong1"],
["想不開","xiang3bu5kai1"],
["想得到","xiang3de5dao4"],
["想得美","xiang3de2mei3"],
["想想看","xiang3xiang3kan4"],
["想起來","xiang3qi3lai5"],
["想起来","xiang3qi3lai5"],
["想不清楚","xiang3bu5qing1chu3"],
["想像得到","xiang3xiang4de5dao4"],
["想得出神","xiang3de5chu1shen2"]
],
"惶":[
["惶恐","huang2kong3"]
],
"惹":[
["惹恼","re3nao3"],
["惹惱","re3nao3"],
["惹火","re3huo3"],
["惹起","re3qi3"],
["惹不得","re3bu5de5"],
["惹不起","re3bu5qi3"]
],
"愁":[
["愁苦","chou2ku3"]
],
"意":[
["意思","yi4si5"],
["意指","yi4zhi3"],
["意旨","yi4zhi3"],
["意見","yi4jian5"],
["意见","yi4jian5"],
["意猶未盡","yi4you2wei4jin4"],
["意見一致","yi4jian4yi2zhi4"],
["意见一致","yi4jian4yi2zhi4"]
],
"愚":[
["愚氓","yu2meng2"],
["愚蠢","yu2chun3"],
["愚魯","yu2lu3"],
["愚鲁","yu2lu3"]
],
"愛":[
["愛人","ai4ren5"],
["愛女","ai4nv3"],
["愛好","ai4hao4"],
["愛子","ai4zi3"],
["愛撫","ai4fu3"],
["愛瑪","ai4ma3"],
["愛人如己","ai4ren2ru2ji3"],
["愛樂樂團","ai4yue4yue4tuan2"],
["愛民如子","ai4min2ru2zi3"]
],
"感":[
["感应","gan3ying4"],
["感想","gan3xiang3"],
["感慨","gan3kai3"],
["感應","gan3ying4"],
["感染","gan3ran3"]
],
"愤":[
["愤慨","fen4kai3"]
],
"愧":[
["愧赧","kui4nan3"],
["愧悔无地","kui4hui3wu2di4"],
["愧悔無地","kui4hui3wu2di4"]
],
"愷":[
["愷撒","kai3sa3"]
],
"愿":[
["愿意","yuan4yi5"],
["愿海","yuan4hai3"],
["愿意不愿意","yuan4yi5bu2yuan4yi4"]
],
"慈":[
["慈姑","ci2gu5"],
["慈禧","ci2xi3"]
],
"態":[
["態度","tai4du5"]
],
"慘":[
["慘慘","can3can3"],
["慘景","can3jing3"]
],
"慢":[
["慢走","man4zou3"],
["慢跑","man4pao3"],
["慢下來","man4xia4lai2"],
["慢下来","man4xia4lai2"],
["慢腾腾","man4teng1teng1"],
["慢騰騰","man4teng1teng1"],
["慢慢吞吞","man4man5tun1tun1"]
],
"慫":[
["慫恿","song3yong3"]
],
"慰":[
["慰藉","wei4jie4"]
],
"慶":[
["慶典","qing4dian3"]
],
"慷":[
["慷慨","kang1kai3"],
["慷慨好施","kang1kai3hao4shi1"]
],
"慾":[
["慾火","yu4huo3"]
],
"憋":[
["憋悶","bie1men5"],
["憋闷","bie1men5"],
["憋不住","bie1bu5zhu4"],
["憋得慌","bie1de5huang5"]
],
"憎":[
["憎恶","zeng1wu4"],
["憎惡","zeng1wu4"]
],
"憐":[
["憐憫","lian2min3"]
],
"憑":[
["憑倚","ping2yi3"],
["憑準","ping2zhun3"],
["憑險","ping2xian3"]
],
"憤":[
["憤慨","fen4kai3"]
],
"憧":[
["憧憬","chong1jing3"]
],
"憨":[
["憨厚","han1hou5"],
["憨不楞登","han1bu5leng2deng1"]
],
"憲":[
["憲法","xian4fa3"]
],
"懂":[
["懂行","dong3hang2"]
],
"懇":[
["懇請","ken3qing3"]
],
"應":[
["應付","ying4fu5"],
["應允","ying1yun3"],
["應分","ying1fen4"],
["應力","ying4li4"],
["應和","ying4he4"],
["應對","ying4dui4"],
["應得","ying1de2"],
["應徵","ying4zheng1"],
["應急","ying4ji2"],
["應戰","ying4zhan4"],
["應有","ying1you3"],
["應用","ying4yong4"],
["應答","ying4da2"],
["應約","ying4yue1"],
["應聘","ying4pin4"],
["應許","ying1xu3"],
["應變","ying4bian4"],
["應邀","ying4yao1"],
["應酬","ying4chou5"],
["應門","ying4men2"],
["應驗","ying4yan4"],
["應激性","ying4ji1xing4"],
["應付帳款","ying1fu4zhang4kuan3"],
["應有盡有","ying1you3jin4you3"],
["應縣木塔","ying4xian4mu4ta3"],
["應試教育","ying4shi4jiao4yu4"],
["應運而生","ying4yun4er2sheng1"]
],
"懊":[
["懊恼","ao4nao3"],
["懊悔","ao4hui3"],
["懊惱","ao4nao3"]
],
"懒":[
["懒怠","lan3dai5"],
["懒散","lan3san3"],
["懒鬼","lan3gui3"],
["懒洋洋","lan3yang1yang1"],
["懒驴上磨屎尿多","lan3lv2shang4mo4shi3niao4duo1"]
],
"懦":[
["懦夫","nuo4fu1"]
],
"懮":[
["懮慮","you1lv4"],
["懮虑","you1lv4"]
],
"懶":[
["懶怠","lan3dai5"],
["懶散","lan3san3"],
["懶鬼","lan3gui3"],
["懶洋洋","lan3yang1yang1"],
["懶驢上磨屎尿多","lan3lv2shang4mo4shi3niao4duo1"]
],
"懷":[
["懷古","huai2gu3"],
["懷有","huai2you3"],
["懷表","huai2biao3"],
["懷裡","huai2li3"],
["懷遠","huai2yuan3"]
],
"懸":[
["懸賞","xuan2shang3"]
],
"懺":[
["懺悔","chan4hui3"]
],
"懿":[
["懿旨","yi4zhi3"]
],
"戈":[
["戈尔","ge1er3"],
["戈爾","ge1er3"],
["戈尔巴乔夫","ge1er3ba1qiao2fu1"],
["戈爾巴喬夫","ge1er3ba1qiao2fu1"]
],
"戊":[
["戊午","wu4wu3"],
["戊子","wu4zi3"]
],
"戌":[
["戌狗","xu1gou3"]
],
"戍":[
["戍卒","shu4zu2"],
["戍守","shu4shou3"],
["戍角","shu4jiao3"]
],
"戎":[
["戎甲","rong2jia3"],
["戎行","rong2hang2"],
["戎馬","rong2ma3"],
["戎马","rong2ma3"]
],
"戏":[
["戏仿","xi4fang3"],
["戏曲","xi4qu3"],
["戏法","xi4fa3"],
["戏耍","xi4shua3"]
],
"成":[
["成为","cheng2wei2"],
["成仙","cheng2xian1"],
["成体","cheng2ti3"],
["成分","cheng2fen4"],
["成品","cheng2pin3"],
["成本","cheng2ben3"],
["成果","cheng2guo3"],
["成武","cheng2wu3"],
["成為","cheng2wei2"],
["成礼","cheng2li3"],
["成禮","cheng2li3"],
["成組","cheng2zu3"],
["成績","cheng2ji4"],
["成组","cheng2zu3"],
["成绩","cheng2ji4"],
["成語","cheng2yu3"],
["成语","cheng2yu3"],
["成都","cheng2du1"],
["成長","cheng2zhang3"],
["成长","cheng2zhang3"],
["成骨","cheng2gu3"],
["成體","cheng2ti3"],
["成不上","cheng2bu5shang4"],
["成不了","cheng2bu5liao3"],
["成方儿","cheng2fang1r5"],
["成吉思汗","cheng2ji2si1han2"]
],
"我":[
["我得","wo3dei3"],
["我等","wo3deng3"],
["我得上","wo3de2shang4"],
["我得中","wo3de2zhong4"],
["我得主","wo3de2zhu3"],
["我得了","wo3de2le5"],
["我得享","wo3de2xiang3"],
["我得人","wo3de2ren2"],
["我得令","wo3de2ling4"],
["我得以","wo3de2yi3"],
["我得体","wo3de2ti3"],
["我得來","wo3de2lai2"],
["我得便","wo3de2bian4"],
["我得出","wo3de2chu1"],
["我得分","wo3de2fen1"],
["我得到","wo3de2dao4"],
["我得力","wo3de2li4"],
["我得劲","wo3de2jin4"],
["我得势","wo3de2shi4"],
["我得勁","wo3de2jin4"],
["我得勝","wo3de2sheng4"],
["我得勢","wo3de2shi4"],
["我得名","wo3de2ming2"],
["我得君","wo3de2jun1"],
["我得听","wo3de2ting1"],
["我得味","wo3de2wei4"],
["我得喜","wo3de2xi3"],
["我得失","wo3de2shi1"],
["我得奖","wo3de2jiang3"],
["我得子","wo3de2zi3"],
["我得宜","wo3de2yi2"],
["我得实","wo3de2shi2"],
["我得宠","wo3de2chong3"],
["我得實","wo3de2shi2"],
["我得寵","wo3de2chong3"],
["我得巴","wo3de2ba5"],
["我得年","wo3de2nian2"],
["我得幸","wo3de2xing4"],
["我得当","wo3de2dang4"],
["我得彩","wo3de2cai3"],
["我得很","wo3de5hen3"],
["我得得","wo3de2de2"],
["我得志","wo3de2zhi4"],
["我得悉","wo3de2xi1"],
["我得意","wo3de2yi4"],
["我得所","wo3de2suo3"],
["我得手","wo3de2shou3"],
["我得撒","wo3de2sa1"],
["我得救","wo3de2jiu4"],
["我得数","wo3de2shu4"],
["我得數","wo3de2shu4"],
["我得文","wo3de2wen2"],
["我得时","wo3de2shi2"],
["我得時","wo3de2shi2"],
["我得来","wo3de2lai2"],
["我得标","wo3de2biao1"],
["我得榮","wo3de2rong2"],
["我得標","wo3de2biao1"],
["我得民","wo3de2min2"],
["我得法","wo3de2fa3"],
["我得獎","wo3de2jiang3"],
["我得率","wo3de2lv4"],
["我得瑕","wo3de2xia2"],
["我得用","wo3de2yong4"],
["我得當","wo3de2dang4"],
["我得病","wo3de2bing4"],
["我得益","wo3de2yi4"],
["我得着","wo3de2zhao2"],
["我得知","wo3de2zhi1"],
["我得神","wo3de2shen2"],
["我得票","wo3de2piao4"],
["我得空","wo3de2kong4"],
["我得窍","wo3de2qiao4"],
["我得竅","wo3de2qiao4"],
["我得策","wo3de2ce4"],
["我得粮","wo3de2liang2"],
["我得糧","wo3de2liang2"],
["我得繼","wo3de2ji4"],
["我得继","wo3de2ji4"],
["我得罪","wo3de2zui5"],
["我得职","wo3de2zhi2"],
["我得職","wo3de2zhi2"],
["我得聽","wo3de2ting1"],
["我得胜","wo3de2sheng4"],
["我得脸","wo3de2lian3"],
["我得臉","wo3de2lian3"],
["我得自","wo3de2zi4"],
["我得色","wo3de2se4"],
["我得荣","wo3de2rong2"],
["我得著","wo3de2zhao2"],
["我得計","wo3de2ji4"],
["我得證","wo3de2zheng4"],
["我得计","wo3de2ji4"],
["我得证","wo3de2zheng4"],
["我得逞","wo3de2cheng3"],
["我得道","wo3de2dao4"],
["我得閑","wo3de2xian2"],
["我得間","wo3de2jian4"],
["我得闲","wo3de2xian2"],
["我得间","wo3de2jian4"],
["我得非","wo3de2fei1"],
["我得體","wo3de2ti3"],
["我得不到","wo3de2bu5dao4"],
["我得不着","wo3de2bu5zhao2"],
["我得不著","wo3de2bu5zhao2"],
["我得人儿","wo3de2ren2r5"],
["我得便儿","wo3de2bian4r5"],
["我得便宜","wo3de2pian2yi5"],
["我得劲儿","wo3de2jin4r5"],
["我得天下","wo3de2tian1xia4"],
["我得数儿","wo3de2shu4r5"],
["我得样儿","wo3de2yang4r5"],
["我得樣兒","wo3de2yang4r5"],
["我得益处","wo3de2yi4chu5"],
["我得益處","wo3de2yi4chu5"],
["我得空儿","wo3de2kong4r5"],
["我得罪人","wo3de2zui4ren2"]
],
"戒":[
["戒指","jie4zhi5"],
["戒酒","jie4jiu3"],
["戒不掉","jie4bu5diao4"]
],
"或":[
["或者","huo4zhe3"],
["或許","huo4xu3"],
["或许","huo4xu3"]
],
"战":[
["战友","zhan4you3"],
["战地","zhan4di4"],
["战场","zhan4chang3"],
["战法","zhan4fa3"],
["战火","zhan4huo3"],
["战马","zhan4ma3"],
["战略核力量","zhan4lve4he2li4liang4"]
],
"戚":[
["戚友","qi1you3"],
["戚属","qi1shu3"],
["戚屬","qi1shu3"],
["戚戚","qi1qi1"],
["戚族","qi1zu2"],
["戚誼","qi1yi4"],
["戚谊","qi1yi4"],
["戚繼光","qi1ji4guang1"],
["戚继光","qi1ji4guang1"]
],
"截":[
["截塔","jie2ta3"],
["截尾","jie2wei3"],
["截止","jie2zhi3"],
["截短","jie2duan3"]
],
"戰":[
["戰友","zhan4you3"],
["戰地","zhan4di4"],
["戰場","zhan4chang3"],
["戰法","zhan4fa3"],
["戰火","zhan4huo3"],
["戰馬","zhan4ma3"],
["戰略核力量","zhan4lve4he2li4liang4"]
],
"戲":[
["戲仿","xi4fang3"],
["戲曲","xi4qu3"],
["戲法","xi4fa3"],
["戲耍","xi4shua3"]
],
"戳":[
["戳儿","chuo1r5"],
["戳咕","chuo1gu1"],
["戳不住","chuo1bu5zhu4"],
["戳脊梁骨","chuo1ji2liang5gu3"]
],
"戴":[
["戴上","dai4shang5"],
["戴尔","dai4er3"],
["戴爾","dai4er3"],
["戴不上","dai4bu5shang4"]
],
"戶":[
["戶主","hu4zhu3"],
["戶口","hu4kou3"],
["戶牖","hu4you3"],
["戶珥","hu4er3"]
],
"户":[
["户主","hu4zhu3"],
["户口","hu4kou3"],
["户牖","hu4you3"],
["户珥","hu4er3"]
],
"戽":[
["戽水","hu4shui3"]
],
"房":[
["房主","fang2zhu3"],
["房产","fang2chan3"],
["房卡","fang2ka3"],
["房產","fang2chan3"],
["房角","fang2jiao3"],
["房錢","fang2qian5"],
["房钱","fang2qian5"],
["房長","fang2zhang3"],
["房长","fang2zhang3"],
["房頂","fang2ding3"],
["房顶","fang2ding3"]
],
"所":[
["所为","suo3wei2"],
["所以","suo3yi3"],
["所属","suo3shu3"],
["所屬","suo3shu3"],
["所得","suo3de2"],
["所想","suo3xiang3"],
["所指","suo3zhi3"],
["所有","suo3you3"],
["所為","suo3wei2"],
["所給","suo3ji3"],
["所给","suo3ji3"],
["所長","suo3zhang3"],
["所长","suo3zhang3"],
["所在地","suo3zai4di4"],
["所罗巴伯","suo3luo2ba1bo2"],
["所羅巴伯","suo3luo2ba1bo2"]
],
"扁":[
["扁担","bian3dan5"],
["扁擔","bian3dan5"],
["扁骨","bian3gu3"],
["扁形动物","pian1xing2dong4wu4"],
["扁形動物","pian1xing2dong4wu4"],
["扁袒一方","pian1tan3yi4fang1"]
],
"手":[
["手上","shou3shang5"],
["手举","shou3ju3"],
["手写","shou3xie3"],
["手卷","shou3juan4"],
["手寫","shou3xie3"],
["手弹","shou3tan2"],
["手彈","shou3tan2"],
["手打","shou3da3"],
["手指","shou3zhi3"],
["手掌","shou3zhang3"],
["手本","shou3ben3"],
["手柄","shou3bing3"],
["手法","shou3fa3"],
["手稿","shou3gao3"],
["手紧","shou3jin3"],
["手緊","shou3jin3"],
["手肘","shou3zhou3"],
["手脚","shou3jiao3"],
["手腳","shou3jiao3"],
["手舉","shou3ju3"],
["手表","shou3biao3"],
["手裡","shou3li3"],
["手語","shou3yu3"],
["手语","shou3yu3"],
["手跡","shou3ji4"],
["手軟","shou3ruan3"],
["手软","shou3ruan3"],
["手迹","shou3ji4"],
["手里","shou3li3"],
["手不稳","shou3bu5wen3"],
["手不穩","shou3bu5wen3"],
["手心裡","shou3xin1li3"],
["手心里","shou3xin1li3"],
["手写辩识","shou3xie3bian4shi2"],
["手寫辯識","shou3xie3bian4shi2"]
],
"才":[
["才好","cai2hao3"],
["才子","cai2zi3"],
["才干","cai2gan4"],
["才有","cai2you3"],
["才識","cai2shi2"],
["才识","cai2shi2"],
["才知道","cai2zhi1dao4"]
],
"扎":[
["扎囊","za1nang2"],
["扎好","za1hao3"],
["扎实","zha1shi5"],
["扎實","zha1shi5"],
["扎得慌","zha1de5huang5"],
["扎尔达里","za1er3da2li3"],
["扎挣不住","zha2zheng5bu5zhu4"],
["扎掙不住","zha2zheng5bu5zhu4"],
["扎格罗斯","za1ge2luo2si1"],
["扎格羅斯","za1ge2luo2si1"],
["扎爾達里","za1er3da2li3"],
["扎魯特旗","za1lu3te4qi2"],
["扎鲁特旗","za1lu3te4qi2"]
],
"扑":[
["扑倒","pu1dao3"],
["扑腾","pu1teng5"],
["扑脸儿","pu1lian3r5"],
["扑哧一笑","pu1chi1yi2xiao4"]
],
"扒":[
["扒手","pa2shou3"],
["扒拉","ba1la5"],
["扒搂","ba1lou1"],
["扒摟","ba1lou1"],
["扒灰","pa2hui1"],
["扒犁","pa2li2"],
["扒窃","pa2qie4"],
["扒竊","pa2qie4"],
["扒糕","pa2gao1"],
["扒头儿","ba1tou5r5"],
["扒頭兒","ba1tou5r5"]
],
"打":[
["打中","da3zhong4"],
["打倒","da3dao3"],
["打发","da3fa5"],
["打听","da3ting5"],
["打啵","da3bo1"],
["打嘴","da3zui3"],
["打场","da3chang2"],
["打垮","da3kua3"],
["打場","da3chang2"],
["打奶","da3nai3"],
["打好","da3hao3"],
["打底","da3di3"],
["打手","da3shou5"],
["打扫","da3sao3"],
["打扰","da3rao3"],
["打拱","da3gong3"],
["打掃","da3sao3"],
["打搅","da3jiao3"],
["打擾","da3rao3"],
["打攪","da3jiao3"],
["打更","da3geng1"],
["打死","da3si3"],
["打比","da3bi3"],
["打水","da3shui3"],
["打法","da3fa3"],
["打滚","da3gun3"],
["打滾","da3gun3"],
["打点","da3dian5"],
["打烊","da3yang4"],
["打狗","da3gou3"],
["打發","da3fa5"],
["打的","da3di1"],
["打盹","da3dun3"],
["打着","da3zhao2"],
["打禪","da3chan2"],
["打穀","da3gu3"],
["打算","da3suan5"],
["打聽","da3ting5"],
["打著","da3zhao2"],
["打谷","da3gu3"],
["打賭","da3du3"],
["打赌","da3du3"],
["打跑","da3pao3"],
["打轉","da3zhuan4"],
["打转","da3zhuan4"],
["打酒","da3jiu3"],
["打量","da3liang5"],
["打鳥","da3niao3"],
["打鸟","da3niao3"],
["打點","da3dian5"],
["打鼓","da3gu3"],
["打下來","da3xia4lai2"],
["打下去","da3xia4qu4"],
["打下来","da3xia4lai2"],
["打不了","da3bu5liao3"],
["打不住","da3bu5zhu4"],
["打不倒","da3bu5dao3"],
["打不出","da3bu5chu1"],
["打不定","da3bu5ding4"],
["打不开","da3bu5kai1"],
["打不死","da3bu5si3"],
["打不破","da3bu5po4"],
["打不碎","da3bu5sui4"],
["打不过","da3bu5guo4"],
["打不過","da3bu5guo4"],
["打不開","da3bu5kai1"],
["打嗝儿","da3ge2r5"],
["打工仔","da3gong1zai3"],
["打手势","da3shou3shi4"],
["打手勢","da3shou3shi4"],
["打比方","da3bi3fang5"],
["打盹儿","da3dun3r5"],
["打短儿","da3duan3r5"],
["打穀場","da3gu3chang2"],
["打谷场","da3gu3chang2"],
["打趸儿","da3dun3r5"],
["打顿儿","da3dun4r5"],
["打家劫舍","da3jia1jie2she4"]
],
"扔":[
["扔下","reng1xia5"]
],
"托":[
["托巴","tuo1ba1"],
["托管","tuo1guan3"],
["托裡","tuo1li3"],
["托里","tuo1li3"],
["托兒所","tuo1er2suo3"]
],
"扣":[
["扣上","kou4shang5"]
],
"执":[
["执掌","zhi2zhang3"],
["执法","zhi2fa3"],
["执着","zhi2zhuo2"],
["执行长","zhi2xing2zhang3"]
],
"扩":[
["扩展","kuo4zhan3"]
],
"扫":[
["扫帚","sao4zhou5"],
["扫把","sao4ba3"],
["扫不清","sao3bu5qing1"]
],
"扬":[
["扬谷","yang2gu3"],
["扬起","yang2qi3"],
["扬子江","yang2zi3jiang1"]
],
"扭":[
["扭捏","niu3nie5"],
["扭摆","niu3bai3"],
["扭擺","niu3bai3"],
["扭矩","niu3ju3"],
["扭轉","niu3zhuan3"],
["扭转","niu3zhuan3"],
["扭不过","niu3bu5guo4"],
["扭不過","niu3bu5guo4"],
["扭扭捏捏","niu3niu5nie1nie1"]
],
"扮":[
["扮演","ban4yan3"],
["扮相","ban4xiang4"],
["扮装","ban4zhuang1"],
["扮裝","ban4zhuang1"]
],
"扰":[
["扰攘","rao3rang3"]
],
"扳":[
["扳手","ban1shou3"],
["扳不倒儿","ban1bu5dao3r5"],
["扳不倒兒","ban1bu5dao3r5"]
],
"扶":[
["扶养","fu2yang3"],
["扶手","fu2shou3"],
["扶起","fu2qi3"],
["扶養","fu2yang3"]
],
"批":[
["批假","pi1jia4"],
["批准","pi1zhun3"],
["批改","pi1gai3"],
["批語","pi1yu3"],
["批语","pi1yu3"],
["批轉","pi1zhuan3"],
["批转","pi1zhuan3"],
["批首","pi1shou3"]
],
"扼":[
["扼守","e4shou3"],
["扼死","e4si3"],
["扼頸","e4jing3"],
["扼颈","e4jing3"],
["扼襟控咽","e4jin1kong4yan1"]
],
"找":[
["找头","zhao3tou5"],
["找死","zhao3si3"],
["找水","zhao3shui3"],
["找着","zhao3zhao2"],
["找著","zhao3zhao2"],
["找頭","zhao3tou5"],
["找不上","zhao3bu5shang4"],
["找不出","zhao3bu5chu1"],
["找不到","zhao3bu5dao4"],
["找不开","zhao3bu5kai1"],
["找不着","zhao3bu5zhao2"],
["找不著","zhao3bu5zhao2"],
["找不開","zhao3bu5kai1"],
["找得出","zhao3de5chu1"],
["找得着","zhao3de5zhao2"],
["找得著","zhao3de5zhao2"],
["找碴儿","zhao3cha2r5"],
["找門路","zhao3men2lu4"],
["找门路","zhao3men2lu4"],
["找台阶儿","zhao3tai2jie1r5"]
],
"承":[
["承应","cheng2ying4"],
["承應","cheng2ying4"],
["承欢","cheng2huan1"],
["承歡","cheng2huan1"],
["承轉","cheng2zhuan3"],
["承转","cheng2zhuan3"],
["承重孙","cheng2zhong4sun1"],
["承重孫","cheng2zhong4sun1"]
],
"技":[
["技俩","ji4liang3"],
["技倆","ji4liang3"],
["技巧","ji4qiao3"]
],
"抄":[
["抄写","chao1xie3"],
["抄寫","chao1xie3"],
["抄本","chao1ben3"],
["抄網","chao1wang3"],
["抄网","chao1wang3"],
["抄近儿","chao1jin4r5"]
],
"把":[
["把儿","ba4r5"],
["把兒","ba4r5"],
["把合","ba3he5"],
["把子","ba4zi5"],
["把守","ba3shou3"],
["把式","ba3shi5"],
["把手","ba3shou5"],
["把柄","ba3bing3"],
["把稳","ba3wen3"],
["把穩","ba3wen3"],
["把酒","ba3jiu3"],
["把手上","ba3shou3shang5"],
["把手下","ba3shou3xia4"],
["把手中","ba3shou3zhong1"],
["把手举","ba3shou3ju3"],
["把手冊","ba3shou3ce4"],
["把手册","ba3shou3ce4"],
["把手写","ba3shou3xie3"],
["把手动","ba3shou3dong4"],
["把手势","ba3shou3shi4"],
["把手動","ba3shou3dong4"],
["把手勢","ba3shou3shi4"],
["把手勤","ba3shou3qin2"],
["把手卷","ba3shou3juan4"],
["把手头","ba3shou3tou2"],
["把手套","ba3shou3tao4"],
["把手寫","ba3shou3xie3"],
["把手工","ba3shou3gong1"],
["把手巾","ba3shou3jin1"],
["把手帕","ba3shou3pa4"],
["把手式","ba3shou3shi4"],
["把手弹","ba3shou3tan2"],
["把手彈","ba3shou3tan2"],
["把手心","ba3shou3xin1"],
["把手打","ba3shou3da3"],
["把手拿","ba3shou3na2"],
["把手持","ba3shou3chi2"],
["把手指","ba3shou3zhi3"],
["把手掌","ba3shou3zhang3"],
["把手提","ba3shou3ti2"],
["把手本","ba3shou3ben3"],
["把手术","ba3shou3shu4"],
["把手机","ba3shou3ji1"],
["把手杖","ba3shou3zhang4"],
["把手枪","ba3shou3qiang1"],
["把手柄","ba3shou3bing3"],
["把手槍","ba3shou3qiang1"],
["把手機","ba3shou3ji1"],
["把手段","ba3shou3duan4"],
["把手气","ba3shou3qi4"],
["把手氣","ba3shou3qi4"],
["把手法","ba3shou3fa3"],
["把手淫","ba3shou3yin2"],
["把手球","ba3shou3qiu2"],
["把手用","ba3shou3yong4"],
["把手电","ba3shou3dian4"],
["把手稿","ba3shou3gao3"],
["把手紧","ba3shou3jin3"],
["把手絹","ba3shou3juan4"],
["把手緊","ba3shou3jin3"],
["把手續","ba3shou3xu4"],
["把手绢","ba3shou3juan4"],
["把手续","ba3shou3xu4"],
["把手肘","ba3shou3zhou3"],
["把手脚","ba3shou3jiao3"],
["把手腕","ba3shou3wan4"],
["把手腳","ba3shou3jiao3"],
["把手臂","ba3shou3bi4"],
["把手舉","ba3shou3ju3"],
["把手艺","ba3shou3yi4"],
["把手藝","ba3shou3yi4"],
["把手術","ba3shou3shu4"],
["把手表","ba3shou3biao3"],
["把手裡","ba3shou3li3"],
["把手語","ba3shou3yu3"],
["把手语","ba3shou3yu3"],
["把手足","ba3shou3zu2"],
["把手跡","ba3shou3ji4"],
["把手軟","ba3shou3ruan3"],
["把手软","ba3shou3ruan3"],
["把手迹","ba3shou3ji4"],
["把手里","ba3shou3li3"],
["把手重","ba3shou3zhong4"],
["把手銬","ba3shou3kao4"],
["把手錘","ba3shou3chui2"],
["把手鐲","ba3shou3zhuo2"],
["把手铐","ba3shou3kao4"],
["把手锤","ba3shou3chui2"],
["把手镯","ba3shou3zhuo2"],
["把手電","ba3shou3dian4"],
["把手頭","ba3shou3tou2"],
["把手不稳","ba3shou3bu5wen3"],
["把手不穩","ba3shou3bu5wen3"],
["把手心裡","ba3shou3xin1li3"],
["把手拉車","ba3shou3la1che1"],
["把手拉车","ba3shou3la1che1"],
["把手推車","ba3shou3tui1che1"],
["把手推车","ba3shou3tui1che1"],
["把手榴弹","ba3shou3liu2dan4"],
["把手榴彈","ba3shou3liu2dan4"],
["把手風琴","ba3shou3feng1qin2"],
["把手风琴","ba3shou3feng1qin2"],
["把手写辩识","ba3shou3xie3bian4shi2"],
["把手寫辯識","ba3shou3xie3bian4shi2"],
["把手忙脚乱","ba3shou3mang2jiao3luan4"],
["把手忙腳亂","ba3shou3mang2jiao3luan4"],
["把手扳葫芦","ba3shou3ban1hu2lu5"],
["把手扳葫蘆","ba3shou3ban1hu2lu5"],
["把手拉葫芦","ba3shou3la1hu2lu5"],
["把手拉葫蘆","ba3shou3la1hu2lu5"],
["把手搖風琴","ba3shou3yao2feng1qin2"],
["把手摇风琴","ba3shou3yao2feng1qin2"],
["把手无寸铁","ba3shou3wu2cun4tie3"],
["把手板葫芦","ba3shou3ban3hu2lu5"],
["把手無寸鐵","ba3shou3wu2cun4tie3"],
["把手版葫蘆","ba3shou3ban3hu2lu5"],
["把手舞足蹈","ba3shou3wu3zu2dao3"],
["把手无缚鸡之力","ba3shou3wu2fu4ji1zhi1li4"],
["把手無縛雞之力","ba3shou3wu2fu4ji1zhi1li4"]
],
"抑":[
["抑止","yi4zhi3"]
],
"抒":[
["抒写","shu1xie3"],
["抒寫","shu1xie3"]
],
"抓":[
["抓举","zhua1ju3"],
["抓捕","zhua1bu3"],
["抓紧","zhua1jin3"],
["抓緊","zhua1jin3"],
["抓舉","zhua1ju3"],
["抓走","zhua1zou3"],
["抓不住","zhua1bu5zhu4"],
["抓不到","zhua1bu5dao4"],
["抓不起","zhua1bu5qi3"],
["抓地力","zhua1di4li4"],
["抓子儿","zhua1zi3r5"],
["抓子兒","zhua1zi3r5"]
],
"投":[
["投中","tou2zhong4"],
["投产","tou2chan3"],
["投奔","tou2ben4"],
["投影","tou2ying3"],
["投手","tou2shou3"],
["投產","tou2chan3"],
["投稿","tou2gao3"],
["投訴","tou2su4"],
["投诉","tou2su4"],
["投降","tou2xiang2"],
["投保人","tou2bao3ren2"],
["投进去","tou2jin4qu4"],
["投進去","tou2jin4qu4"],
["投机买卖","tou2ji1mai3mai5"],
["投機買賣","tou2ji1mai3mai5"]
],
"抖":[
["抖擞","dou3sou3"],
["抖擻","dou3sou3"],
["抖落","dou3luo5"]
],
"抗":[
["抗体","kang4ti3"],
["抗水","kang4shui3"],
["抗礼","kang4li3"],
["抗禮","kang4li3"],
["抗訴","kang4su4"],
["抗诉","kang4su4"],
["抗體","kang4ti3"]
],
"折":[
["折了","she2le5"],
["折尺","zhe2chi3"],
["折本","she2ben3"],
["折椅","zhe2yi3"],
["折煞","zhe2sha1"],
["折磨","zhe2mo5"],
["折秤","she2cheng4"],
["折笔","zhe2bi3"],
["折筆","zhe2bi3"],
["折箩","zhe1luo2"],
["折籮","zhe1luo2"],
["折縫","zhe2feng2"],
["折缝","zhe2feng2"],
["折耗","she2hao4"],
["折腾","zhe1teng5"],
["折轉","zhe2zhuan3"],
["折转","zhe2zhuan3"],
["折返","zhe2fan3"],
["折錢","she2qian2"],
["折钱","she2qian2"],
["折騰","zhe1teng5"],
["折刀儿","zhe2dao1r5"],
["折跟头","zhe1gen1tou5"],
["折跟頭","zhe1gen1tou5"],
["折过儿","zhe1guo4r5"],
["折過兒","zhe1guo4r5"]
],
"抚":[
["抚养","fu3yang3"],
["抚远","fu3yuan3"]
],
"抛":[
["抛撒","pao1sa3"],
["抛洒","pao1sa3"],
["抛脸","pao1lian3"],
["抛头露面","pao1tou2lu4mian4"]
],
"抢":[
["抢手","qiang3shou3"],
["抢走","qiang3zou3"],
["抢险","qiang3xian3"],
["抢风","qiang1feng1"]
],
"护":[
["护士","hu4shi5"],
["护理","hu4li3"],
["护短","hu4duan3"],
["护发素","hu4fa4su4"]
],
"报":[
["报以","bao4yi3"],
["报喜","bao4xi3"],
["报导","bao4dao3"],
["报应","bao4ying4"],
["报晓","bao4xiao3"],
["报纸","bao4zhi3"],
["报考","bao4kao3"],
["报表","bao4biao3"],
["报警","bao4jing3"],
["报馆","bao4guan3"],
["报不下","bao4bu5xia4"],
["报务员","bao4wu4yuan2"],
["报以一笑","bao4yi3yi2xiao4"]
],
"披":[
["披发","pi1fa4"],
["披散","pi1san5"],
["披甲","pi1jia3"],
["披索","pi1suo3"],
["披头散发","pi1tou2san4fa4"]
],
"抬":[
["抬举","tai2ju5"],
["抬舉","tai2ju5"],
["抬走","tai2zou3"],
["抬起","tai2qi3"],
["抬不动","tai2bu5dong4"],
["抬不動","tai2bu5dong4"],
["抬不起","tai2bu5qi3"],
["抬起來","tai2qi3lai5"],
["抬起来","tai2qi3lai5"],
["抬头一看","tai2tou2yi2kan4"],
["抬頭一看","tai2tou2yi2kan4"]
],
"抱":[
["抱养","bao4yang3"],
["抱有","bao4you3"],
["抱枕","bao4zhen3"],
["抱養","bao4yang3"],
["抱佛脚","bao4fo2jiao3"],
["抱佛腳","bao4fo2jiao3"]
],
"抵":[
["抵挡","di3dang3"],
["抵擋","di3dang3"],
["抵不上","di3bu5shang4"],
["抵不了","di3bu5liao3"],
["抵不住","di3bu5zhu4"],
["抵得上","di3de5shang4"]
],
"抹":[
["抹头","mo4tou2"],
["抹煞","mo3sha1"],
["抹頭","mo4tou2"],
["抹不下","ma1bu5xia4"]
],
"押":[
["押卜","ya1bu3"],
["押玛","ya1ma3"],
["押瑪","ya1ma3"]
],
"抽":[
["抽中","chou1zhong4"],
["抽取","chou1qu3"],
["抽奖","chou1jiang3"],
["抽打","chou1da3"],
["抽搭","chou1da5"],
["抽斗","chou1dou3"],
["抽獎","chou1jiang3"],
["抽空","chou1kong4"],
["抽菸","chou1yan1"],
["抽血","chou1xie3"]
],
"拂":[
["拂扫","fu2sao3"],
["拂掃","fu2sao3"]
],
"担":[
["担保","dan1bao3"],
["担子","dan4zi5"],
["担待","dan1dai5"],
["担懮","dan1you1"],
["担荷","dan1he4"],
["担不起","dan1bu5qi3"],
["担担面","dan4dan4mian4"]
],
"拆":[
["拆息","chai1xi1"],
["拆毀","chai1hui3"],
["拆毁","chai1hui3"],
["拆洗","chai1xi3"]
],
"拇":[
["拇战","mu3zhan4"],
["拇戰","mu3zhan4"],
["拇指","mu3zhi3"],
["拇趾","mu3zhi3"]
],
"拉":[
["拉下","la1xia5"],
["拉倒","la1dao3"],
["拉夫","la1fu1"],
["拉屎","la1shi3"],
["拉巴","la1ba1"],
["拉开","la1kai5"],
["拉手","la1shou3"],
["拉拢","la1long5"],
["拉攏","la1long5"],
["拉比","la1bi3"],
["拉法","la1fa3"],
["拉玛","la1ma3"],
["拉瑪","la1ma3"],
["拉甲","la1jia3"],
["拉紧","la1jin3"],
["拉緊","la1jin3"],
["拉美","la1mei3"],
["拉起","la1qi3"],
["拉里","la1li3"],
["拉開","la1kai5"],
["拉馬","la1ma3"],
["拉马","la1ma3"],
["拉魯","la1lu3"],
["拉鲁","la1lu3"],
["拉上來","la1shang4lai2"],
["拉上来","la1shang4lai2"],
["拉下來","la1xia4lai2"],
["拉下来","la1xia4lai2"],
["拉不上","la1bu5shang4"],
["拉不动","la1bu5dong4"],
["拉不動","la1bu5dong4"],
["拉不开","la1bu5kai1"],
["拉不着","la1bu5zhao2"],
["拉不著","la1bu5zhao2"],
["拉不開","la1bu5kai1"],
["拉出去","la1chu5qu5"],
["拉勾儿","la1gou4r5"],
["拉勾兒","la1gou4r5"],
["拉那烈","la1na1lie4"],
["拉不出來","la1bu5chu1lai5"],
["拉不出来","la1bu5chu1lai5"],
["拉卜楞寺","la1bu3leng4si4"],
["拉夫罗夫","la1fu1luo2fu1"],
["拉夫羅夫","la1fu1luo2fu1"],
["拉夫桑賈尼","la1fu1sang1jia3ni2"],
["拉夫桑贾尼","la1fu1sang1jia3ni2"],
["拉賈斯坦邦","la1jia3si1tan3bang1"],
["拉贾斯坦邦","la1jia3si1tan3bang1"],
["拉赫曼尼諾夫","la1he4man4ni2nuo4fu1"],
["拉赫曼尼诺夫","la1he4man4ni2nuo4fu1"]
],
"拊":[
["拊掌","fu3zhang3"]
],
"拋":[
["拋撒","pao1sa3"],
["拋灑","pao1sa3"],
["拋臉","pao1lian3"],
["拋頭露面","pao1tou2lu4mian4"]
],
"拌":[
["拌和","ban4huo4"],
["拌嘴","ban4zui3"],
["拌种","ban4zhong3"],
["拌種","ban4zhong3"],
["拌不过","ban4bu5guo4"],
["拌不過","ban4bu5guo4"]
],
"拍":[
["拍手","pai1shou3"],
["拍打","pai1da5"],
["拍掌","pai1zhang3"],
["拍板","pai1ban3"],
["拍馬","pai1ma3"],
["拍马","pai1ma3"]
],
"拐":[
["拐点","guai3dian3"],
["拐角","guai3jiao3"],
["拐點","guai3dian3"],
["拐弯儿","guai3wan1r5"],
["拐弯抹角","guai3wan1mo4jiao3"],
["拐彎抹角","guai3wan1mo4jiao3"]
],
"拒":[
["拒捕","ju4bu3"]
],
"拓":[
["拓展","tuo4zhan3"],
["拓扑","tuo4pu1"],
["拓拔","tuo4ba2"],
["拓撲","tuo4pu1"],
["拓荒","tuo4huang1"],
["拓跋","tuo4ba2"]
],
"拔":[
["拔取","ba2qu3"],
["拔地","ba2di4"],
["拔染","ba2ran3"],
["拔海","ba2hai3"],
["拔腿","ba2tui3"],
["拔起","ba2qi3"],
["拔頂","ba2ding3"],
["拔顶","ba2ding3"],
["拔不出","ba2bu5chu1"],
["拔尖儿","ba2jian1r5"],
["拔起來","ba2qi3lai5"],
["拔起来","ba2qi3lai5"],
["拔十得五","ba2shi2de2wu3"],
["拔得头筹","ba2de2tou2chou2"],
["拔得頭籌","ba2de2tou2chou2"],
["拔火罐儿","ba2huo3guan4r5"]
],
"拖":[
["拖把","tuo1ba3"],
["拖斗","tuo1dou3"],
["拖累","tuo1lei3"],
["拖網","tuo1wang3"],
["拖网","tuo1wang3"],
["拖走","tuo1zou3"],
["拖兒帶女","tuo1er2dai4nv3"]
],
"拗":[
["拗口","ao4kou3"],
["拗陷","ao4xian4"],
["拗不过","niu4bu5guo4"],
["拗不過","niu4bu5guo4"]
],
"拘":[
["拘守","ju1shou3"],
["拘捕","ju1bu3"],
["拘检","ju1jian3"],
["拘檢","ju1jian3"],
["拘泥","ju1ni4"],
["拘礼","ju1li3"],
["拘禮","ju1li3"],
["拘謹","ju1jin3"],
["拘谨","ju1jin3"],
["拘挛儿","ju1luan2r5"]
],
"拙":[
["拙朴","zhuo1pu3"],
["拙樸","zhuo1pu3"],
["拙稿","zhuo1gao3"],
["拙笔","zhuo1bi3"],
["拙筆","zhuo1bi3"],
["拙著","zhuo1zhu4"]
],
"拚":[
["拚命","pan4ming4"],
["拚弃","pan4qi4"],
["拚棄","pan4qi4"]
],
"招":[
["招呼","zhao1hu5"],
["招展","zhao1zhan3"],
["招引","zhao1yin3"],
["招惹","zhao1re5"],
["招手","zhao1shou3"],
["招抚","zhao1fu3"],
["招揽","zhao1lan3"],
["招撫","zhao1fu3"],
["招攬","zhao1lan3"],
["招牌","zhao1pai5"],
["招股","zhao1gu3"],
["招請","zhao1qing3"],
["招请","zhao1qing3"],
["招远","zhao1yuan3"],
["招遠","zhao1yuan3"],
["招揽生意","zhao1lan3sheng1yi4"],
["招攬生意","zhao1lan3sheng1yi4"],
["招不住劲儿","zhao1bu5zhu4jin4r5"],
["招不住勁兒","zhao1bu5zhu4jin4r5"]
],
"拜":[
["拜佛","bai4fo2"],
["拜倒","bai4dao3"],
["拜訪","bai4fang3"],
["拜访","bai4fang3"],
["拜把子","bai4ba3zi5"]
],
"拟":[
["拟古","ni3gu3"],
["拟稿","ni3gao3"],
["拟古之作","ni3gu3zhi4zuo4"]
],
"拣":[
["拣起","jian3qi3"],
["拣选","jian3xuan3"],
["拣佛烧香","jian3fo2shao1xiang1"]
],
"拥":[
["拥塞","yong1se4"],
["拥挤","yong1ji3"],
["拥有","yong1you3"]
],
"拦":[
["拦住","lan2zhu5"],
["拦网","lan2wang3"],
["拦阻","lan2zu3"],
["拦不住","lan2bu5zhu4"]
],
"拨":[
["拨冗","bo1rong3"],
["拨刺","bo1ci1"],
["拨弄","bo1nong5"],
["拨款","bo1kuan3"],
["拨给","bo1gei3"],
["拨子弹","bo1zi3tan2"],
["拨浪鼓","bo1lang5gu3"]
],
"拭":[
["拭抹","shi4mo3"]
],
"拮":[
["拮据","jie2ju1"],
["拮據","jie2ju1"]
],
"拱":[
["拱手","gong3shou3"],
["拱頂","gong3ding3"],
["拱顶","gong3ding3"]
],
"拳":[
["拳头","quan2tou5"],
["拳手","quan2shou3"],
["拳打","quan2da3"],
["拳脚","quan2jiao3"],
["拳腳","quan2jiao3"],
["拳頭","quan2tou5"],
["拳头产品","quan2tou2chan3pin3"],
["拳頭產品","quan2tou2chan3pin3"]
],
"拷":[
["拷打","kao3da3"]
],
"拼":[
["拼写","pin1xie3"],
["拼寫","pin1xie3"],
["拼抢","pin1qiang3"],
["拼拢","pin1long3"],
["拼搶","pin1qiang3"],
["拼攏","pin1long3"],
["拼攒","pin1cuan2"],
["拼攢","pin1cuan2"],
["拼板","pin1ban3"],
["拼死","pin1si3"],
["拼法","pin1fa3"],
["拼火","pin1huo3"],
["拼版","pin1ban3"],
["拼綴","pin1zhui4"],
["拼缀","pin1zhui4"]
],
"拾":[
["拾取","shi2qu3"],
["拾得","shi2de2"],
["拾掇","shi2duo5"],
["拾柴","shi2chai2"],
["拾物","shi2wu4"],
["拾級","shi2ji2"],
["拾级","shi2ji2"],
["拾芥","shi2jie4"],
["拾荒","shi2huang1"],
["拾起","shi2qi3"],
["拾遗","shi2yi2"],
["拾遺","shi2yi2"],
["拾零","shi2ling2"],
["拾不得","shi2bu5de2"],
["拾起來","shi2qi3lai5"],
["拾起来","shi2qi3lai5"],
["拾人涕唾","shi2ren2ti4tuo4"],
["拾人牙慧","shi2ren2ya2hui4"],
["拾金不昧","shi2jin1bu2mei4"]
],
"拿":[
["拿好","na2hao3"],
["拿手","na2shou3"],
["拿比","na2bi3"],
["拿玛","na2ma3"],
["拿瑪","na2ma3"],
["拿給","na2gei3"],
["拿给","na2gei3"],
["拿走","na2zou3"],
["拿起","na2qi3"],
["拿鐵","na2tie3"],
["拿铁","na2tie3"],
["拿不上","na2bu5shang4"],
["拿不了","na2bu5liao3"],
["拿不住","na2bu5zhu4"],
["拿不准","na2bu5zhun3"],
["拿不出","na2bu5chu1"],
["拿不动","na2bu5dong4"],
["拿不動","na2bu5dong4"],
["拿不定","na2bu5ding4"],
["拿不準","na2bu5zhun3"],
["拿不着","na2bu5zhao2"],
["拿不稳","na2bu5wen3"],
["拿不穩","na2bu5wen3"],
["拿不著","na2bu5zhao2"],
["拿不起","na2bu5qi3"],
["拿出來","na2chu5lai5"],
["拿出来","na2chu5lai5"],
["拿得了","na2de5liao3"],
["拿得出","na2de5chu1"],
["拿起來","na2qi3lai5"],
["拿起来","na2qi3lai5"],
["拿不好調","na2bu5hao3diao4"],
["拿不好调","na2bu5hao3diao4"],
["拿不起來","na2bu5qi3lai5"],
["拿不起来","na2bu5qi3lai5"],
["拿定主意","na2ding4zhu3yi4"],
["拿不好调儿","na2bu5hao3diao4r5"],
["拿得出手去","na2de5chu1shou3qu5"]
],
"持":[
["持久","chi2jiu3"],
["持守","chi2shou3"],
["持有","chi2you3"]
],
"挂":[
["挂好","gua4hao3"],
["挂挡","gua4dang3"],
["挂起","gua4qi3"],
["挂锁","gua4suo3"],
["挂不上","gua4bu5shang4"],
["挂不下","gua4bu5xia4"],
["挂不住","gua4bu5zhu4"],
["挂起来","gua4qi3lai5"],
["挂一漏万","gua4yi2lou4wan4"],
["挂在嘴上","gua4zai5zui3shang5"],
["挂不住劲儿","gua4bu5zhu4jin4r5"]
],
"指":[
["指使","zhi3shi3"],
["指头","zhi3tou5"],
["指导","zhi3dao3"],
["指導","zhi3dao3"],
["指引","zhi3yin3"],
["指徵","zhi3zheng1"],
["指望","zhi3wang5"],
["指法","zhi3fa3"],
["指点","zhi3dian3"],
["指甲","zhi3jia5"],
["指給","zhi3gei3"],
["指给","zhi3gei3"],
["指頭","zhi3tou5"],
["指點","zhi3dian3"],
["指令名字","zhi3ling4ming2zi4"],
["指手划脚","zhi3shou3hua2jiao3"],
["指手划腳","zhi3shou3hua2jiao3"],
["指鹿为马","zhi3lu4wei2ma3"],
["指鹿為馬","zhi3lu4wei2ma3"]
],
"按":[
["按下","an4xia5"],
["按手","an4shou3"],
["按理","an4li3"],
["按語","an4yu3"],
["按语","an4yu3"],
["按鈕","an4niu3"],
["按钮","an4niu3"],
["按不住","an4bu5zhu4"],
["按捺不住","an4na4bu5zhu4"],
["按下葫芦浮起瓢","an4xia4hu2lu5fu2qi3piao2"],
["按下葫蘆浮起瓢","an4xia4hu2lu5fu2qi3piao2"]
],
"挑":[
["挑剔","tiao1ti5"],
["挑动","tiao3dong4"],
["挑動","tiao3dong4"],
["挑唆","tiao3suo1"],
["挑嘴","tiao3zui3"],
["挑头","tiao3tou2"],
["挑弄","tiao3nong4"],
["挑战","tiao3zhan4"],
["挑戰","tiao3zhan4"],
["挑担","tiao1dan4"],
["挑拣","tiao1jian3"],
["挑拨","tiao3bo1"],
["挑揀","tiao1jian3"],
["挑撥","tiao3bo1"],
["挑擔","tiao1dan4"],
["挑明","tiao3ming2"],
["挑染","tiao1ran3"],
["挑檐","tiao3yan2"],
["挑灯","tiao3deng1"],
["挑燈","tiao3deng1"],
["挑簷","tiao3yan2"],
["挑舋","tiao3xin4"],
["挑花","tiao3hua1"],
["挑衅","tiao3xin4"],
["挑起","tiao3qi3"],
["挑选","tiao1xuan3"],
["挑逗","tiao3dou4"],
["挑選","tiao1xuan3"],
["挑釁","tiao3xin4"],
["挑頭","tiao3tou2"],
["挑不上","tiao1bu5shang4"],
["挑不动","tiao1bu5dong4"],
["挑不動","tiao1bu5dong4"],
["挑不起","tiao1bu5qi3"],
["挑头儿","tiao3tou2r5"],
["挑毛病","tiao1mao2bing4"],
["挑三窝四","tiao3san1wo1si4"],
["挑三窩四","tiao3san1wo1si4"]
],
"挖":[
["挖井","wa1jing3"],
["挖土","wa1tu3"],
["挖地","wa1di4"],
["挖苦","wa1ku5"],
["挖不通","wa1bu5tong1"]
],
"挚":[
["挚友","zhi4you3"]
],
"挣":[
["挣扎","zheng1zha2"],
["挣断","zheng4duan4"],
["挣脱","zheng4tuo1"],
["挣钱","zheng4qian2"],
["挣不上","zheng4bu5shang4"],
["挣不了","zheng4bu5liao3"],
["挣不着","zheng4bu5zhao2"]
],
"挤":[
["挤死","ji3si3"],
["挤满","ji3man3"],
["挤不上","ji3bu5shang4"],
["挤不下","ji3bu5xia4"],
["挤不动","ji3bu5dong4"],
["挤不开","ji3bu5kai1"],
["挤不进","ji3bu5jin4"]
],
"挥":[
["挥手","hui1shou3"],
["挥杆","hui1gan3"],
["挥洒","hui1sa3"],
["挥舞","hui1wu3"],
["挥麈","hui1zhu3"]
],
"挨":[
["挨个","ai1ge4"],
["挨個","ai1ge4"],
["挨剋","ai2ke4"],
["挨打","ai2da3"],
["挨批","ai2pi1"],
["挨挤","ai2ji3"],
["挨揍","ai2zou4"],
["挨擠","ai2ji3"],
["挨整","ai2zheng3"],
["挨斗","ai2dou4"],
["挨罵","ai2ma4"],
["挨餓","ai2e4"],
["挨饿","ai2e4"],
["挨骂","ai2ma4"],
["挨鬥","ai2dou4"],
["挨不上","ai1bu5shang4"],
["挨不得","ai1bu5de5"],
["挨个儿","ai1ge4r5"],
["挨呲儿","ai1ci1r5"],
["挨呲兒","ai1ci1r5"],
["挨头子","ai2tou2zi5"],
["挨板子","ai2ban3zi5"],
["挨肩儿","ai1jian1r5"],
["挨边儿","ai1bian1r5"],
["挨頭子","ai2tou2zi5"]
],
"挪":[
["挪动","nuo2dong5"],
["挪動","nuo2dong5"],
["挪巴","nuo2ba1"],
["挪法","nuo2fa3"],
["挪不动","nuo2bu5dong4"],
["挪不動","nuo2bu5dong4"],
["挪不开","nuo2bu5kai1"],
["挪不開","nuo2bu5kai1"],
["挪窝儿","nuo2wo1r5"]
],
"振":[
["振兴","zhen4xing1"],
["振興","zhen4xing1"],
["振作精神","zhen4zuo4jing1shen5"],
["振臂一呼","zhen4bi4yi4hu1"]
],
"挺":[
["挺举","ting3ju3"],
["挺好","ting3hao3"],
["挺杆","ting3gan3"],
["挺桿","ting3gan3"],
["挺舉","ting3ju3"],
["挺起","ting3qi3"],
["挺不住","ting3bu5zhu4"],
["挺不起","ting3bu5qi3"]
],
"捆":[
["捆好","kun3hao3"],
["捆綁","kun3bang3"],
["捆绑","kun3bang3"],
["捆起","kun3qi3"],
["捆鎖","kun3suo3"],
["捆锁","kun3suo3"],
["捆起來","kun3qi3lai5"],
["捆起来","kun3qi3lai5"]
],
"捉":[
["捉取","zhuo1qu3"]
],
"捏":[
["捏估","nie1gu5"],
["捏弄","nie1nong5"],
["捏脊治疗","nie1ji3zhi4liao2"],
["捏脊治療","nie1ji3zhi4liao2"]
],
"捐":[
["捐款","juan1kuan3"],
["捐給","juan1gei3"],
["捐给","juan1gei3"],
["捐选","juan1xuan3"],
["捐選","juan1xuan3"]
],
"捕":[
["捕手","bu3shou3"]
],
"损":[
["损毁","sun3hui3"]
],
"换":[
["换取","huan4qu3"],
["换岗","huan4gang3"],
["换挡","huan4dang3"],
["换羽","huan4yu3"],
["换不出","huan4bu5chu1"],
["换不得","huan4bu5de5"],
["换挡杆","huan4dang3gan3"],
["换档杆","huan4dang4gan3"]
],
"捣":[
["捣弄","dao3nong5"],
["捣毁","dao3hui3"],
["捣腾","dao3teng5"],
["捣鬼","dao3gui3"],
["捣鼓","dao3gu5"],
["捣持得很漂亮","dao3chi5de5hen3piao4liang5"]
],
"捧":[
["捧场","peng3chang3"],
["捧場","peng3chang3"],
["捧人一场","peng3ren2yi4chang3"],
["捧人一場","peng3ren2yi4chang3"]
],
"捨":[
["捨己","she3ji3"],
["捨不了","she3bu5liao3"],
["捨不得","she3bu5de5"],
["捨得了","she3de5liao3"],
["捨己為人","she3ji3wei4ren2"]
],
"据":[
["据守","ju4shou3"],
["据有","ju4you3"],
["据此","ju4ci3"],
["据点","ju4dian3"],
["据理","ju4li3"],
["据险","ju4xian3"],
["据为己有","ju4wei2ji3you3"]
],
"捶":[
["捶打","chui2da3"]
],
"捷":[
["捷語","jie2yu3"],
["捷语","jie2yu3"],
["捷足先得","jie2zu2xian1de2"]
],
"掀":[
["掀涌","xian1yong3"],
["掀腾","xian1teng5"],
["掀起","xian1qi3"],
["掀騰","xian1teng5"],
["掀不开锅","xian1bu5kai1guo1"],
["掀不開鍋","xian1bu5kai1guo1"],
["掀天揭地","xian1tian1jie1di4"]
],
"掃":[
["掃帚","sao4zhou5"],
["掃把","sao4ba3"],
["掃不清","sao3bu5qing1"]
],
"授":[
["授与","shou4yu3"],
["授乳","shou4ru3"],
["授予","shou4yu3"],
["授奖","shou4jiang3"],
["授獎","shou4jiang3"],
["授粉","shou4fen3"],
["授給","shou4gei3"],
["授给","shou4gei3"],
["授與","shou4yu3"]
],
"掉":[
["掉轉","diao4zhuan3"],
["掉转","diao4zhuan3"],
["掉下來","diao4xia4lai2"],
["掉下去","diao4xia4qu4"],
["掉下来","diao4xia4lai2"],
["掉价儿","diao4jia4r5"]
],
"掌":[
["掌管","zhang3guan3"],
["掌骨","zhang3gu3"],
["掌不了","zhang3bu5liao3"]
],
"掐":[
["掐死","qia1si3"]
],
"排":[
["排偶","pai2ou3"],
["排卵","pai2luan3"],
["排在","pai2zai5"],
["排场","pai2chang5"],
["排場","pai2chang5"],
["排挡","pai2dang3"],
["排挤","pai2ji3"],
["排擋","pai2dang3"],
["排擠","pai2ji3"],
["排档","pai2dang3"],
["排检","pai2jian3"],
["排檔","pai2dang3"],
["排檢","pai2jian3"],
["排比","pai2bi3"],
["排水","pai2shui3"],
["排泻","pai3xie4"],
["排瀉","pai3xie4"],
["排版","pai2ban3"],
["排行","pai2hang2"],
["排解","pai2jie3"],
["排遣","pai2qian3"],
["排長","pai2zhang3"],
["排长","pai2zhang3"],
["排骨","pai2gu3"],
["排山倒海","pai2shan1dao3hai3"],
["排难解纷","pai2nan4jie3fen1"],
["排難解紛","pai2nan4jie3fen1"]
],
"掖":[
["掖庭","ye4ting2"]
],
"掙":[
["掙扎","zheng1zha2"],
["掙斷","zheng4duan4"],
["掙脫","zheng4tuo1"],
["掙錢","zheng4qian2"],
["掙不上","zheng4bu5shang4"],
["掙不了","zheng4bu5liao3"],
["掙不著","zheng4bu5zhao2"]
],
"掛":[
["掛好","gua4hao3"],
["掛擋","gua4dang3"],
["掛起","gua4qi3"],
["掛鎖","gua4suo3"],
["掛不上","gua4bu5shang4"],
["掛不下","gua4bu5xia4"],
["掛不住","gua4bu5zhu4"],
["掛起來","gua4qi3lai5"],
["掛一漏萬","gua4yi2lou4wan4"],
["掛在嘴上","gua4zai5zui3shang5"]
],
"掠":[
["掠取","lve4qu3"]
],
"採":[
["採取","cai3qu3"],
["採場","cai3chang3"],
["採暖","cai3nuan3"],
["採果","cai3guo3"],
["採種","cai3zhong3"],
["採訪","cai3fang3"],
["採買","cai3mai3"]
],
"探":[
["探索","tan4suo3"],
["探討","tan4tao3"],
["探訪","tan4fang3"],
["探讨","tan4tao3"],
["探访","tan4fang3"],
["探险","tan4xian3"],
["探險","tan4xian3"],
["探不見","tan4bu5jian4"],
["探不见","tan4bu5jian4"],
["探驪得珠","tan4li2de2zhu1"],
["探骊得珠","tan4li2de2zhu1"],
["探头探脑儿","tan4tou2tan4nao3r5"]
],
"接":[
["接取","jie1qu3"],
["接口","jie1kou3"],
["接吻","jie1wen3"],
["接地","jie1di4"],
["接壤","jie1rang3"],
["接应","jie1ying4"],
["接應","jie1ying4"],
["接点","jie1dian3"],
["接种","jie1zhong4"],
["接種","jie1zhong4"],
["接管","jie1guan3"],
["接走","jie1zou3"],
["接踵","jie1zhong3"],
["接軌","jie1gui3"],
["接轨","jie1gui3"],
["接點","jie1dian3"],
["接上去","jie1shang4qu4"],
["接下來","jie1xia4lai2"],
["接下来","jie1xia4lai2"],
["接不上","jie1bu5shang4"],
["接納為","jie1na4wei2"],
["接纳为","jie1na4wei2"]
],
"控":[
["控訴","kong4su4"],
["控诉","kong4su4"],
["控制杆","kong4zhi4gan3"]
],
"推":[
["推举","tui1ju3"],
["推任","tui4ren4"],
["推倒","tui1dao3"],
["推委","tui1wei3"],
["推导","tui1dao3"],
["推導","tui1dao3"],
["推广","tui1guang3"],
["推廣","tui1guang3"],
["推挤","tui1ji3"],
["推擠","tui1ji3"],
["推演","tui1yan3"],
["推理","tui1li3"],
["推磨","tui1mo4"],
["推舉","tui1ju3"],
["推衍","tui1yan3"],
["推許","tui1xu3"],
["推諉","tui1wei3"],
["推许","tui1xu3"],
["推诿","tui1wei3"],
["推选","tui1xuan3"],
["推選","tui1xuan3"],
["推不出","tui1bu5chu1"],
["推不动","tui1bu5dong4"],
["推不動","tui1bu5dong4"],
["推不开","tui1bu5kai1"],
["推不開","tui1bu5kai1"],
["推一知万","tui1yi4zhi1wan4"],
["推一知萬","tui1yi4zhi1wan4"],
["推不知情","tui1bu5zhi1qing2"]
],
"掩":[
["掩体","yan3ti3"],
["掩口","yan3kou3"],
["掩着","yan3zhao5"],
["掩耳","yan3er3"],
["掩著","yan3zhao5"],
["掩體","yan3ti3"],
["掩不住","yan3bu5zhu4"]
],
"措":[
["措美","cuo4mei3"]
],
"掬":[
["掬飲","ju1yin3"],
["掬饮","ju1yin3"]
],
"掳":[
["掳去","lu3qu5"]
],
"掺":[
["掺假","chan1jia3"],
["掺和","chan1huo5"]
],
"揀":[
["揀起","jian3qi3"],
["揀選","jian3xuan3"],
["揀佛燒香","jian3fo2shao1xiang1"]
],
"揉":[
["揉搓","rou2cuo5"],
["揉磨","rou2mo5"]
],
"描":[
["描写","miao2xie3"],
["描寫","miao2xie3"]
],
"提":[
["提取","ti2qu3"],
["提审","ti2shen3"],
["提審","ti2shen3"],
["提尔","ti2er3"],
["提巴","ti2ba1"],
["提干","ti2gan4"],
["提手","ti2shou3"],
["提掖","ti2ye4"],
["提早","ti2zao3"],
["提款","ti2kuan3"],
["提法","ti2fa3"],
["提溜","di1liu1"],
["提爾","ti2er3"],
["提玛","ti2ma3"],
["提瑪","ti2ma3"],
["提請","ti2qing3"],
["提请","ti2qing3"],
["提起","ti2qi3"],
["提醒","ti2xing3"],
["提防","di1fang2"],
["提領","ti2ling3"],
["提领","ti2ling3"],
["提馬","ti2ma3"],
["提马","ti2ma3"],
["提不到","ti2bu5dao4"],
["提不动","ti2bu5dong4"],
["提不動","ti2bu5dong4"],
["提不得","ti2bu5de2"],
["提不起","ti2bu5qi3"],
["提篮儿","ti2lan2r5"],
["提葫芦","ti2hu2lu2"],
["提葫蘆","ti2hu2lu2"],
["提不起來","ti2bu5qi3lai5"],
["提不起来","ti2bu5qi3lai5"],
["提不起精神","ti2bu5qi3jing1shen5"]
],
"插":[
["插上","cha1shang5"],
["插嘴","cha1zui3"],
["插孔","cha1kong3"],
["插手","cha1shou3"],
["插曲","cha1qu3"],
["插一脚","cha1yi4jiao3"],
["插一腳","cha1yi4jiao3"],
["插一杠子","cha1yi2gang4zi5"],
["插不上嘴","cha1bu5shang4zui3"]
],
"揘":[
["揘毕","yong2bi4"],
["揘畢","yong2bi4"]
],
"揚":[
["揚穀","yang2gu3"],
["揚起","yang2qi3"],
["揚子江","yang2zi3jiang1"]
],
"換":[
["換取","huan4qu3"],
["換崗","huan4gang3"],
["換擋","huan4dang3"],
["換羽","huan4yu3"],
["換不出","huan4bu5chu1"],
["換不得","huan4bu5de5"]
],
"握":[
["握手","wo4shou3"]
],
"揣":[
["揣度","chuai3duo2"],
["揣想","chuai1xiang3"],
["揣摩","chuai3mo2"],
["揣测","chuai3ce4"],
["揣測","chuai3ce4"],
["揣在怀里","chuai1zai4huai2li5"],
["揣在懷裡","chuai1zai4huai2li5"]
],
"揭":[
["揭晓","jie1xiao3"],
["揭曉","jie1xiao3"],
["揭不开锅","jie1bu5kai1guo1"],
["揭不開鍋","jie1bu5kai1guo1"]
],
"揮":[
["揮手","hui1shou3"],
["揮桿","hui1gan3"],
["揮灑","hui1sa3"],
["揮舞","hui1wu3"],
["揮麈","hui1zhu3"]
],
"援":[
["援引","yuan2yin3"],
["援手","yuan2shou3"],
["援藏","yuan2zang4"]
],
"搀":[
["搀假","chan1jia3"],
["搀和","chan1huo5"],
["搀不到","chan1bu5dao4"]
],
"搁":[
["搁板","ge1ban3"],
["搁浅","ge1qian3"],
["搁下来","ge1xia4lai2"],
["搁不下","ge1bu5xia4"],
["搁不住","ge1bu5zhu4"],
["搁得住","ge2de5zhu4"]
],
"搅":[
["搅和","jiao3huo5"],
["搅扰","jiao3rao3"],
["搅混","jiao3hun5"]
],
"損":[
["損毀","sun3hui3"]
],
"搔":[
["搔痒","sao1yang3"],
["搔癢","sao1yang3"]
],
"搖":[
["搖手","yao2shou3"],
["搖撼","yao2han5"],
["搖擺","yao2bai3"],
["搖滾","yao2gun3"],
["搖滾樂","yao2gun3yue4"],
["搖搖晃晃","yao2yao2huang4huang4"],
["搖身一變","yao2shen1yi2bian4"]
],
"搗":[
["搗弄","dao3nong5"],
["搗毀","dao3hui3"],
["搗騰","dao3teng5"],
["搗鬼","dao3gui3"],
["搗鼓","dao3gu5"],
["搗持得很漂亮","dao3chi5de5hen3piao4liang5"]
],
"搜":[
["搜捕","sou1bu3"],
["搜狗","sou1gou3"],
["搜索","sou1suo3"],
["搜藏","sou1zang4"]
],
"搞":[
["搞鬼","gao3gui3"],
["搞不好","gao3bu5hao3"]
],
"搬":[
["搬走","ban1zou3"],
["搬不倒","ban1bu5dao3"]
],
"搭":[
["搭伙","da1huo3"],
["搭咕","da1gu1"],
["搭嘴","da1zui3"],
["搭理","da1li5"],
["搭膊","da1bo2"],
["搭补","da1bu3"],
["搭補","da1bu3"],
["搭起","da1qi3"],
["搭不上","da1bu5shang4"],
["搭茬儿","da2cha2r5"],
["搭茬兒","da2cha2r5"]
],
"搶":[
["搶手","qiang3shou3"],
["搶走","qiang3zou3"],
["搶險","qiang3xian3"],
["搶風","qiang1feng1"]
],
"摄":[
["摄取","she4qu3"],
["摄影","she4ying3"]
],
"摆":[
["摆好","bai3hao3"],
["摆手","bai3shou3"],
["摆满","bai3man3"],
["摆不下","bai3bu5xia4"],
["摆不了","bai3bu5liao3"],
["摆地摊","bai3di4tan1"],
["摆设儿","bai3she4er5"],
["摆事实讲道理","bai3shi4shi2jiang3dao4li3"]
],
"摇":[
["摇手","yao2shou3"],
["摇摆","yao2bai3"],
["摇撼","yao2han5"],
["摇滚","yao2gun3"],
["摇滚乐","yao2gun3yue4"],
["摇摇晃晃","yao2yao2huang4huang4"],
["摇身一变","yao2shen1yi2bian4"]
],
"摊":[
["摊点","tan1dian3"],
["摊薄","tan1bo2"]
],
"摔":[
["摔倒","shuai1dao3"],
["摔打","shuai1da5"],
["摔死","shuai1si3"],
["摔角","shuai1jiao3"],
["摔不了","shuai1bu5liao3"],
["摔不掉","shuai1bu5diao4"]
],
"摘":[
["摘取","zhai1qu3"],
["摘引","zhai1yin3"],
["摘下來","zhai1xia4lai2"],
["摘下来","zhai1xia4lai2"],
["摘不去","zhai1bu5qu4"]
],
"摧":[
["摧毀","cui1hui3"],
["摧毁","cui1hui3"]
],
"摩":[
["摩卡","mo2ka3"],
["摩尔","mo2er3"],
["摩撒","ma1sa5"],
["摩爾","mo2er3"]
],
"摯":[
["摯友","zhi4you3"]
],
"摸":[
["摸摸","mo1mo5"],
["摸索","mo1suo5"],
["摸不清","mo1bu5qing1"],
["摸不着","mo1bu5zhao2"],
["摸不著","mo1bu5zhao2"],
["摸不透","mo1bu5tou4"],
["摸不着边儿","mo1bu5zhao2bian1r5"],
["摸不着门儿","mo1bu5zhao2men2r5"]
],
"摹":[
["摹仿","mo2fang3"],
["摹扎特","mo2za1te4"]
],
"摺":[
["摺尺","zhe2chi3"],
["摺椅","zhe2yi3"],
["摺紙","zhe2zhi3"],
["摺纸","zhe2zhi3"],
["摺轉","zhe2zhuan3"],
["摺转","zhe2zhuan3"]
],
"摻":[
["摻假","chan1jia3"],
["摻和","chan1huo5"]
],
"撇":[
["撇下","pie1xia5"],
["撇去","pie1qu4"],
["撇弃","pie1qi4"],
["撇棄","pie1qi4"]
],
"撒":[
["撒军","sa3jun1"],
["撒冷","sa1leng3"],
["撒布","sa3bu4"],
["撒手","sa1shou3"],
["撒播","sa3bo1"],
["撒泼","sa1po1"],
["撒潑","sa1po1"],
["撒然","sa3ran2"],
["撒玛","sa1ma3"],
["撒瑪","sa1ma3"],
["撒种","sa3zhong3"],
["撒種","sa3zhong3"],
["撒網","sa1wang3"],
["撒网","sa1wang3"],
["撒罕","sa1han3"],
["撒脚","sa1jiao3"],
["撒腳","sa1jiao3"],
["撒腿","sa1tui3"],
["撒謊","sa1huang3"],
["撒谎","sa1huang3"],
["撒軍","sa3jun1"],
["撒野","sa1ye3"],
["撒切尔","sa1qie1er3"],
["撒切爾","sa1qie1er3"],
["撒哈拉","sa1ha1la1"],
["撒布得","sa1bu4de2"],
["撒非喇","sa1fei1la1"],
["撒巴第业","sa1ba1di4ye4"],
["撒巴第業","sa1ba1di4ye4"],
["撒都該人","sa1du1gai1ren2"],
["撒都该人","sa1du1gai1ren2"],
["撒马尔干","sa1ma3er3gan4"],
["撒法納巴內亞","sa1fa3na4ba1nei4ya4"],
["撒法纳巴内亚","sa1fa3na4ba1nei4ya4"]
],
"撕":[
["撕毀","si1hui3"],
["撕毁","si1hui3"]
],
"撞":[
["撞倒","zhuang4dao3"],
["撞死","zhuang4si3"],
["撞毀","zhuang4hui3"],
["撞毁","zhuang4hui3"],
["撞鎖","zhuang4suo3"],
["撞锁","zhuang4suo3"]
],
"撤":[
["撤走","che4zou3"],
["撤旦教","che4dan4jiao1"]
],
"撥":[
["撥冗","bo1rong3"],
["撥刺","bo1ci1"],
["撥弄","bo1nong5"],
["撥款","bo1kuan3"],
["撥給","bo1gei3"],
["撥子彈","bo1zi3tan2"],
["撥浪鼓","bo1lang5gu3"]
],
"撩":[
["撩人","liao2ren2"],
["撩动","liao2dong4"],
["撩動","liao2dong4"],
["撩惹","liao2re3"],
["撩拨","liao2bo1"],
["撩撥","liao2bo1"],
["撩逗","liao2dou4"],
["撩是生非","liao2shi4sheng1fei1"]
],
"撫":[
["撫遠","fu3yuan3"],
["撫養","fu3yang3"]
],
"播":[
["播弄","bo1nong5"],
["播种","bo1zhong3"],
["播種","bo1zhong3"]
],
"撰":[
["撰写","zhuan4xie3"],
["撰寫","zhuan4xie3"]
],
"撲":[
["撲倒","pu1dao3"],
["撲騰","pu1teng5"],
["撲哧一笑","pu1chi1yi2xiao4"]
],
"撵":[
["撵走","nian3zou3"],
["撵不开","nian3bu5kai1"],
["撵不掉","nian3bu5diao4"]
],
"撺":[
["撺掇","cuan1duo5"]
],
"擁":[
["擁塞","yong1se4"],
["擁擠","yong1ji3"],
["擁有","yong1you3"]
],
"擄":[
["擄去","lu3qu5"]
],
"擅":[
["擅场","shan4chang3"],
["擅場","shan4chang3"],
["擅美","shan4mei3"]
],
"擊":[
["擊中","ji1zhong4"],
["擊倒","ji1dao3"],
["擊打","ji1da3"],
["擊掌","ji1zhang3"],
["擊毀","ji1hui3"],
["擊鼓","ji1gu3"]
],
"操":[
["操典","cao1dian3"],
["操场","cao1chang3"],
["操場","cao1chang3"],
["操守","cao1shou3"],
["操屄","cao4bi1"],
["操持","cao1chi5"],
["操法","cao1fa3"],
["操演","cao1yan3"]
],
"擔":[
["擔保","dan1bao3"],
["擔子","dan4zi5"],
["擔待","dan1dai5"],
["擔懮","dan1you1"],
["擔荷","dan1he4"],
["擔不起","dan1bu5qi3"],
["擔擔麵","dan4dan4mian4"]
],
"據":[
["據守","ju4shou3"],
["據有","ju4you3"],
["據此","ju4ci3"],
["據理","ju4li3"],
["據險","ju4xian3"],
["據點","ju4dian3"],
["據為己有","ju4wei2ji3you3"]
],
"擠":[
["擠死","ji3si3"],
["擠滿","ji3man3"],
["擠不上","ji3bu5shang4"],
["擠不下","ji3bu5xia4"],
["擠不動","ji3bu5dong4"],
["擠不進","ji3bu5jin4"],
["擠不開","ji3bu5kai1"]
],
"擦":[
["擦乾","ca1gan1"],
["擦写","ca1xie3"],
["擦寫","ca1xie3"],
["擦洗","ca1xi3"],
["擦澡","ca1zao3"],
["擦黑儿","ca1hei1r5"]
],
"擬":[
["擬古","ni3gu3"],
["擬稿","ni3gao3"],
["擬古之作","ni3gu3zhi4zuo4"],
["擬於不倫","ni3yu2bu4lun2"]
],
"擱":[
["擱板","ge1ban3"],
["擱淺","ge1qian3"],
["擱下來","ge1xia4lai2"],
["擱不下","ge1bu5xia4"],
["擱不住","ge1bu5zhu4"],
["擱得住","ge2de5zhu4"]
],
"擴":[
["擴展","kuo4zhan3"]
],
"擺":[
["擺好","bai3hao3"],
["擺手","bai3shou3"],
["擺滿","bai3man3"],
["擺不下","bai3bu5xia4"],
["擺不了","bai3bu5liao3"],
["擺地攤","bai3di4tan1"],
["擺設兒","bai3she4er5"],
["擺事實講道理","bai3shi4shi2jiang3dao4li3"]
],
"擾":[
["擾攘","rao3rang3"]
],
"攀":[
["攀扯","pan1che3"],
["攀比","pan1bi3"],
["攀不上","pan1bu5shang4"]
],
"攆":[
["攆走","nian3zou3"],
["攆不掉","nian3bu5diao4"],
["攆不開","nian3bu5kai1"]
],
"攔":[
["攔住","lan2zhu5"],
["攔網","lan2wang3"],
["攔阻","lan2zu3"],
["攔不住","lan2bu5zhu4"]
],
"攙":[
["攙假","chan1jia3"],
["攙和","chan1huo5"],
["攙不到","chan1bu5dao4"]
],
"攛":[
["攛掇","cuan1duo5"]
],
"攝":[
["攝取","she4qu3"],
["攝影","she4ying3"]
],
"攤":[
["攤薄","tan1bo2"],
["攤點","tan1dian3"]
],
"攪":[
["攪和","jiao3huo5"],
["攪擾","jiao3rao3"],
["攪混","jiao3hun5"]
],
"攫":[
["攫取","jue2qu3"]
],
"支":[
["支差","zhi1chai1"],
["支点","zhi1dian3"],
["支點","zhi1dian3"],
["支不起","zhi1bu5qi3"],
["支付得起","zhi1fu4de2qi3"],
["支吾其詞","zhi1wu5qi2ci2"],
["支吾其词","zhi1wu5qi2ci2"],
["支持不住","zhi1chi2bu5zhu4"]
],
"收":[
["收下","shou1xia5"],
["收买","shou1mai3"],
["收养","shou1yang3"],
["收取","shou1qu3"],
["收场","shou1chang3"],
["收場","shou1chang3"],
["收尾","shou1wei3"],
["收成","shou1cheng5"],
["收揽","shou1lan3"],
["收攬","shou1lan3"],
["收紧","shou1jin3"],
["收緊","shou1jin3"],
["收繳","shou1jiao3"],
["收缴","shou1jiao3"],
["收買","shou1mai3"],
["收起","shou1qi3"],
["收養","shou1yang3"],
["收不回","shou1bu5hui2"],
["收不住脚","shou1bu5zhu4jiao3"],
["收不住腳","shou1bu5zhu4jiao3"],
["收拾行李","shou1shi5xing2li3"]
],
"改":[
["改为","gai3wei2"],
["改写","gai3xie3"],
["改口","gai3kou3"],
["改寫","gai3xie3"],
["改為","gai3wei2"],
["改稿","gai3gao3"],
["改組","gai3zu3"],
["改组","gai3zu3"],
["改行","gai3hang2"],
["改选","gai3xuan3"],
["改選","gai3xuan3"],
["改不了","gai3bu5liao3"],
["改不过","gai3bu5guo4"],
["改不過","gai3bu5guo4"],
["改变主意","gai3bian4zhu3yi4"],
["改變主意","gai3bian4zhu3yi4"]
],
"攻":[
["攻取","gong1qu3"],
["攻打","gong1da3"]
],
"放":[
["放上","fang4shang5"],
["放下","fang4xia5"],
["放假","fang4jia4"],
["放养","fang4yang3"],
["放好","fang4hao3"],
["放手","fang4shou3"],
["放火","fang4huo3"],
["放緩","fang4huan3"],
["放缓","fang4huan3"],
["放胆","fang4dan3"],
["放膽","fang4dan3"],
["放走","fang4zou3"],
["放过","fang4guo5"],
["放過","fang4guo5"],
["放養","fang4yang3"],
["放一码","fang4yi4ma3"],
["放一碼","fang4yi4ma3"],
["放不下","fang4bu5xia4"],
["放出來","fang4chu1lai2"],
["放出来","fang4chu1lai2"],
["放下架子","fang4xia4jia4zi5"],
["放手一搏","fang4shou3yi4bo2"]
],
"政":[
["政体","zheng4ti3"],
["政党","zheng4dang3"],
["政务","zheng4wu4"],
["政務","zheng4wu4"],
["政委","zheng4wei3"],
["政审","zheng4shen3"],
["政審","zheng4shen3"],
["政府","zheng4fu3"],
["政柄","zheng4bing3"],
["政法","zheng4fa3"],
["政理","zheng4li3"],
["政績","zheng4ji4"],
["政绩","zheng4ji4"],
["政體","zheng4ti3"],
["政黨","zheng4dang3"]
],
"故":[
["故事","gu4shi5"],
["故典","gu4dian3"],
["故友","gu4you3"],
["故土","gu4tu3"],
["故地","gu4di4"],
["故址","gu4zhi3"],
["故我","gu4wo3"],
["故此","gu4ci3"],
["故跡","gu4ji4"],
["故迹","gu4ji4"],
["故都","gu4du1"],
["故里","gu4li3"],
["故事片","gu4shi5pian1"],
["故地重游","gu4di4chong2you2"],
["故地重遊","gu4di4chong2you2"]
],
"效":[
["效应","xiao4ying4"],
["效應","xiao4ying4"],
["效果","xiao4guo3"],
["效法","xiao4fa3"]
],
"敌":[
["敌地","di2di4"],
["敌将","di2jiang4"],
["敌手","di2shou3"],
["敌不了","di2bu5liao3"],
["敌不住","di2bu5zhu4"],
["敌不过","di2bu5guo4"]
],
"敏":[
["敏感","min3gan3"]
],
"救":[
["救主","jiu4zhu3"],
["救难","jiu4nan4"],
["救難","jiu4nan4"],
["救不了","jiu4bu5liao3"],
["救出來","jiu4chu1lai2"],
["救出来","jiu4chu1lai2"],
["救得了","jiu4de5liao3"]
],
"敗":[
["敗北","bai4bei3"],
["敗火","bai4huo3"],
["敗筆","bai4bi3"],
["敗績","bai4ji4"],
["敗訴","bai4su4"],
["敗家子","bai4jia1zi3"],
["敗不成軍","bai4bu5cheng2jun1"],
["敗子回頭","bai4zi3hui2tou2"]
],
"敘":[
["敘永","xu4yong3"]
],
"教":[
["教主","jiao4zhu3"],
["教书","jiao1shu1"],
["教养","jiao4yang3"],
["教务","jiao4wu4"],
["教務","jiao4wu4"],
["教友","jiao4you3"],
["教女","jiao4nv3"],
["教子","jiao4zi3"],
["教导","jiao4dao3"],
["教導","jiao4dao3"],
["教書","jiao1shu1"],
["教母","jiao4mu3"],
["教訓","jiao4xun5"],
["教训","jiao4xun5"],
["教養","jiao4yang3"],
["教不倦","jiao1bu5juan4"],
["教授得法","jiao1shou4de2fa3"]
],
"敛":[
["敛迹","lian3ji4"]
],
"敝":[
["敝屣","bi4xi3"],
["敝帚千金","bi4zhou3qian1jin1"],
["敝帚自珍","bi4zhou3zi4zhen1"]
],
"敞":[
["敞开","chang3kai1"],
["敞開","chang3kai1"],
["敞篷車","chang3peng2che1"],
["敞篷车","chang3peng2che1"],
["敞蓬車","chang3peng2che1"],
["敞蓬车","chang3peng2che1"]
],
"敢":[
["敢为","gan3wei2"],
["敢於","gan3yu2"],
["敢為","gan3wei2"],
["敢自","gan3zi5"]
],
"散":[
["散人","san3ren2"],
["散件","san3jian4"],
["散伙","san4huo3"],
["散体","san3ti3"],
["散光","san3guang1"],
["散兵","san3bing1"],
["散剂","san3ji4"],
["散劑","san3ji4"],
["散匪","san3fei3"],
["散场","san4chang3"],
["散場","san4chang3"],
["散射","san3she4"],
["散居","san3ju1"],
["散戶","san3hu4"],
["散户","san3hu4"],
["散打","san4da3"],
["散文","san3wen2"],
["散曲","san3qu3"],
["散板","san3ban3"],
["散架","san3jia4"],
["散水","san4shui3"],
["散沙","san3sha1"],
["散漫","san3man4"],
["散盡","san4jin4"],
["散碎","san3sui4"],
["散职","san3zhi2"],
["散職","san3zhi2"],
["散装","san3zhuang1"],
["散裝","san3zhuang1"],
["散見","san3jian4"],
["散见","san3jian4"],
["散記","san3ji4"],
["散話","san3hua4"],
["散誕","san3dan4"],
["散记","san3ji4"],
["散话","san3hua4"],
["散诞","san3dan4"],
["散體","san3ti3"],
["散不了","san3bu5liao3"],
["散座儿","san3zuo4er5"],
["散座兒","san3zuo4er5"]
],
"敬":[
["敬仰","jing4yang3"],
["敬启","jing4qi3"],
["敬啟","jing4qi3"],
["敬礼","jing4li3"],
["敬禮","jing4li3"],
["敬酒","jing4jiu3"]
],
"数":[
["数出","shu3chu1"],
["数法","shu4fa3"],
["数点","shu3dian3"],
["数理","shu4li3"],
["数百","shu4bai3"],
["数码","shu4ma3"],
["数种","shu4zhong3"],
["数算","shu3suan4"],
["数组","shu4zu3"],
["数过","shu3guo4"],
["数一数","shu3yi4shu3"],
["数不上","shu3bu5shang4"],
["数不了","shu3bu5liao3"],
["数不尽","shu3bu5jin4"],
["数不清","shu3bu5qing1"],
["数不着","shu3bu5zhao2"],
["数不起","shu3bu5qi3"],
["数不过","shu3bu5guo4"],
["数得上","shu3de5shang4"],
["数得着","shu3de5zhao2"],
["数不胜数","shu3bu2sheng4shu3"],
["数理逻辑","shu4li3luo2ji2"],
["数码照相机","shu4ma3zhao4xiang1ji1"]
],
"敲":[
["敲打","qiao1da5"],
["敲敲打打","qiao1qiao1da3da3"]
],
"整":[
["整个","zheng3ge4"],
["整体","zheng3ti3"],
["整個","zheng3ge4"],
["整改","zheng3gai3"],
["整整","zheng3zheng3"],
["整理","zheng3li3"],
["整體","zheng3ti3"]
],
"敵":[
["敵地","di2di4"],
["敵將","di2jiang4"],
["敵手","di2shou3"],
["敵不了","di2bu5liao3"],
["敵不住","di2bu5zhu4"],
["敵不過","di2bu5guo4"]
],
"敷":[
["敷演","fu1yan3"],
["敷粉","fu1fen3"],
["敷衍","fu1yan3"],
["敷裹","fu1guo3"],
["敷衍了事","fu1yan5liao3shi4"],
["敷衍塞責","fu1yan5se4ze2"],
["敷衍塞责","fu1yan5se4ze2"]
],
"數":[
["數出","shu3chu1"],
["數法","shu4fa3"],
["數理","shu4li3"],
["數百","shu4bai3"],
["數碼","shu4ma3"],
["數種","shu4zhong3"],
["數算","shu3suan4"],
["數組","shu4zu3"],
["數過","shu3guo4"],
["數點","shu3dian3"],
["數一數","shu3yi4shu3"],
["數不上","shu3bu5shang4"],
["數不了","shu3bu5liao3"],
["數不清","shu3bu5qing1"],
["數不盡","shu3bu5jin4"],
["數不著","shu3bu5zhao2"],
["數不起","shu3bu5qi3"],
["數不過","shu3bu5guo4"],
["數得上","shu3de5shang4"],
["數得著","shu3de5zhao2"],
["數不勝數","shu3bu2sheng4shu3"],
["數理邏輯","shu4li3luo2ji2"],
["數碼照相機","shu4ma3zhao4xiang1ji1"]
],
"斂":[
["斂跡","lian3ji4"]
],
"文":[
["文史","wen2shi3"],
["文本","wen2ben3"],
["文武","wen2wu3"],
["文水","wen2shui3"],
["文法","wen2fa3"],
["文种","wen2zhong3"],
["文種","wen2zhong3"],
["文稿","wen2gao3"],
["文笔","wen2bi3"],
["文筆","wen2bi3"],
["文雅","wen2ya3"],
["文徵明","wen2zheng1ming2"]
],
"斑":[
["斑点","ban1dian3"],
["斑馬","ban1ma3"],
["斑马","ban1ma3"],
["斑鱧","ban1li3"],
["斑鳢","ban1li3"],
["斑點","ban1dian3"]
],
"斗":[
["斗六","dou3liu4"],
["斗嘴","dou4zui3"],
["斗眼","dou4yan3"],
["斗篷","dou3peng5"],
["斗門","dou3men2"],
["斗门","dou3men2"],
["斗不过","dou4bu5guo4"],
["斗南鎮","dou3nan2zhen4"],
["斗南镇","dou3nan2zhen4"],
["斗趣儿","dou4qu4r5"],
["斗南一人","dou3nan2yi4ren2"],
["斗筲之人","dou3shao1zhi1ren2"],
["斗酒只鸡","dou3jiu3zhi1ji1"],
["斗酒隻雞","dou3jiu3zhi1ji1"]
],
"料":[
["料想","liao4xiang3"],
["料斗","liao4dou3"],
["料理","liao4li3"],
["料酒","liao4jiu3"],
["料不到","liao4bu5dao4"],
["料豆儿","liao4dou4r5"]
],
"斜":[
["斜体","xie2ti3"],
["斜塔","xie2ta3"],
["斜躺","xie2tang3"],
["斜體","xie2ti3"],
["斜眼一瞟","xie2yan3yi4piao3"],
["斜紋軟呢","xie2wen2ruan3ni2"],
["斜纹软呢","xie2wen2ruan3ni2"]
],
"斟":[
["斟酒","zhen1jiu3"]
],
"斤":[
["斤斗","jin1dou3"]
],
"斩":[
["斩首","zhan3shou3"]
],
"斬":[
["斬首","zhan3shou3"]
],
"断":[
["断奶","duan4nai3"],
["断想","duan4xiang3"],
["断掌","duan4zhang3"],
["断腿","duan4tui3"],
["断不了","duan4bu5liao3"]
],
"新":[
["新主","xin1zhu3"],
["新党","xin1dang3"],
["新兴","xin1xing1"],
["新娘","xin1niang2"],
["新手","xin1shou3"],
["新曲","xin1qu3"],
["新欢","xin1huan1"],
["新款","xin1kuan3"],
["新歡","xin1huan1"],
["新版","xin1ban3"],
["新穀","xin1gu3"],
["新穎","xin1ying3"],
["新興","xin1xing1"],
["新谷","xin1gu3"],
["新选","xin1xuan3"],
["新選","xin1xuan3"],
["新都","xin1du1"],
["新野","xin1ye3"],
["新雅","xin1ya3"],
["新颖","xin1ying3"],
["新馬","xin1ma3"],
["新马","xin1ma3"],
["新黨","xin1dang3"],
["新埔鎮","xin1bu4zhen4"],
["新埔镇","xin1bu4zhen4"],
["新生兒","xin1sheng1er2"],
["新华日报","xing1hua2ri4bao4"],
["新天新地","xin1tian1xin1di4"],
["新斯科舍","xin1si1ke1she4"],
["新華日報","xing1hua2ri4bao4"],
["新喀裡多尼亞","xin1ka1li3duo1ni2ya4"],
["新晃侗族自治县","xin1huang3dong4zu2zi4zhi4xian4"],
["新晃侗族自治縣","xin1huang3dong4zu2zi4zhi4xian4"]
],
"斷":[
["斷奶","duan4nai3"],
["斷想","duan4xiang3"],
["斷掌","duan4zhang3"],
["斷腿","duan4tui3"],
["斷不了","duan4bu5liao3"]
],
"方":[
["方丈","fang1zhang5"],
["方差","fang1cha1"],
["方法","fang1fa3"],
["方頂","fang1ding3"],
["方顶","fang1ding3"],
["方兴未艾","fang1xing1wei4ai4"],
["方興未艾","fang1xing1wei4ai4"]
],
"於":[
["於後","yu2hou4"],
["於是","yu2shi4"],
["於此","yu2ci3"],
["於田","yu2tian2"],
["於都","yu2du1"],
["於事無補","yu2shi4wu2bu3"]
],
"施":[
["施与","shi1yu3"],
["施以","shi1yi3"],
["施展","shi1zhan3"],
["施捨","shi1she3"],
["施法","shi1fa3"],
["施洗","shi1xi3"],
["施秉","shi1bing3"],
["施與","shi1yu3"],
["施舍","shi1she3"]
],
"旅":[
["旅舍","lv3she4"],
["旅館","lv3guan3"],
["旅馆","lv3guan3"]
],
"旋":[
["旋子","xuan4zi5"],
["旋工","xuan4gong1"],
["旋床","xuan4chuang2"],
["旋木","xuan4mu4"],
["旋筒","xuan2tong3"],
["旋舞","xuan2wu3"],
["旋踵","xuan2zhong3"],
["旋轉","xuan2zhuan3"],
["旋转","xuan2zhuan3"],
["旋里","xuan2li3"],
["旋鈕","xuan2niu3"],
["旋钮","xuan2niu3"],
["旋風","xuan4feng1"],
["旋风","xuan4feng1"],
["旋得旋失","xuan2de2xuan2shi1"]
],
"族":[
["族譜","zu2pu3"],
["族谱","zu2pu3"],
["族長","zu2zhang3"],
["族长","zu2zhang3"]
],
"旗":[
["旗手","qi2shou3"],
["旗語","qi2yu3"],
["旗语","qi2yu3"]
],
"无":[
["无为","wu2wei2"],
["无几","wu2ji3"],
["无可","wu2ke3"],
["无品","wu2pin3"],
["无底","wu2di3"],
["无我","wu2wo3"],
["无损","wu2sun3"],
["无有","wu2you3"],
["无比","wu2bi3"],
["无氧","wu2yang3"],
["无水","wu2shui3"],
["无法","wu2fa3"],
["无爪","wu2zhua3"],
["无理","wu2li3"],
["无着","wu2zhuo2"],
["无礼","wu2li3"],
["无稽","wu2ji1"],
["无耻","wu2chi3"],
["无补","wu2bu3"],
["无轨","wu2gui3"],
["无间","wu2jian4"],
["无怪乎","wu2guai4hu1"],
["无患子","wu2huan4zi3"],
["无意识","wu2yi4shi2"],
["无一不备","wu2yi2bu2bei4"],
["无一不精","wu2yi2bu4jing1"],
["无一不能","wu2yi2bu4neng2"],
["无一不通","wu2yi2bu4tong1"],
["无地自容","wu2di4zi4rong2"],
["无所不为","wu2suo3bu4wei2"],
["无的放矢","wu2di4fang4shi3"],
["无知无识","wu2zhi1wu2shi2"]
],
"既":[
["既得","ji4de2"],
["既有","ji4you3"],
["既得利益者","ji4de5li4yi4zhe3"]
],
"日":[
["日产","ri4chan3"],
["日冕","ri4mian3"],
["日土","ri4tu3"],
["日影","ri4ying3"],
["日惹","ri4re3"],
["日晷","ri4gui3"],
["日本","ri4ben3"],
["日產","ri4chan3"],
["日給","ri4ji3"],
["日给","ri4ji3"],
["日美","ri4mei3"],
["日語","ri4yu3"],
["日语","ri4yu3"],
["日里","ri4li5"],
["日复一日","ri4fu4yi2ri4"],
["日復一日","ri4fu4yi2ri4"],
["日月重光","ri4yue4chong2guang1"],
["日甚一日","ri4shen4yi2ri4"],
["日积月累","ri4ji1yue4lei3"],
["日積月累","ri4ji1yue4lei3"],
["日行一善","ri4xing2yi2shan4"]
],
"旦":[
["旦角","dan4jiao3"]
],
"旧":[
["旧体","jiu4ti3"],
["旧友","jiu4you3"],
["旧地","jiu4di4"],
["旧址","jiu4zhi3"],
["旧好","jiu4hao3"],
["旧损","jiu4sun3"],
["旧版","jiu4ban3"],
["旧识","jiu4shi2"],
["旧迹","jiu4ji4"],
["旧都","jiu4du1"],
["旧雨","jiu4yu3"],
["旧地重遊","jiu4di4chong2you2"]
],
"早":[
["早上","zao3shang5"],
["早产","zao3chan3"],
["早场","zao3chang3"],
["早場","zao3chang3"],
["早已","zao3yi3"],
["早晚","zao3wan3"],
["早死","zao3si3"],
["早点","zao3dian3"],
["早產","zao3chan3"],
["早起","zao3qi3"],
["早點","zao3dian3"],
["早早儿","zao3zao3r5"],
["早班儿","zao3ban1r5"],
["早起三朝当一天","zao3qi3san1zhao1dang1yi4tian1"],
["早起三朝當一天","zao3qi3san1zhao1dang1yi4tian1"]
],
"旬":[
["旬始","xun2shi3"],
["旬首","xun2shou3"]
],
"旱":[
["旱地","han4di4"],
["旱得邪火","han4de5xie2huo5"]
],
"时":[
["时候","shi2hou5"],
["时兴","shi2xing1"],
["时分","shi2fen4"],
["时务","shi2wu4"],
["时宜","shi2yi2"],
["时差","shi2cha1"],
["时有","shi2you3"],
["时辰","shi2chen5"],
["时不常儿","shi2bu5chang2r5"],
["时好时坏","shi2hao4shi2huai4"],
["时机一到","shi2ji1yi2dao4"]
],
"旷":[
["旷古","kuang4gu3"],
["旷夫","kuang4fu1"],
["旷渺","kuang4miao3"],
["旷野","kuang4ye3"]
],
"旺":[
["旺角","wang4jiao3"]
],
"昂":[
["昂首","ang2shou3"]
],
"昆":[
["昆卡","kun1ka3"],
["昆曲","kun1qu3"]
],
"昇":[
["昇起","sheng1qi3"]
],
"昌":[
["昌都","chang1du1"]
],
"明":[
["明了","ming2liao3"],
["明儿","ming2r5"],
["明史","ming2shi3"],
["明显","ming2xian3"],
["明朗","ming2lang3"],
["明水","ming2shui3"],
["明火","ming2huo3"],
["明理","ming2li3"],
["明白","ming2bai5"],
["明里","ming2li5"],
["明顯","ming2xian3"],
["明晓得","ming2xiao3de5"],
["明曉得","ming2xiao3de5"],
["明明白白","ming2ming2bai2bai2"],
["明窗淨几","ming2chuang1jing4ji1"],
["明窗淨幾","ming2chuang1jing4ji1"]
],
"昏":[
["昏倒","hun1dao3"]
],
"易":[
["易懂","yi4dong3"],
["易卜生","yi4bu3sheng1"],
["易卜拉辛","yi4bu3la1xin1"],
["易得易失","yi4de2yi4shi1"],
["易得者易失","yi4de2zhe3yi4shi1"]
],
"星":[
["星体","xing1ti3"],
["星宿","xing1xiu4"],
["星岛","xing1dao3"],
["星島","xing1dao3"],
["星斗","xing1dou3"],
["星星","xing1xing5"],
["星等","xing1deng3"],
["星表","xing1biao3"],
["星體","xing1ti3"],
["星巴克","xing1ba1ke4"],
["星巴剋","xing1ba1ke4"],
["星相学","xing1xiang4xue2"],
["星相學","xing1xiang4xue2"],
["星相师","xing1xiang4shi1"],
["星相師","xing1xiang4shi1"],
["星星之火","xing1xing1zhi5huo3"]
],
"春":[
["春假","chun1jia4"],
["春卷","chun1juan3"],
["春捲","chun1juan3"],
["春景","chun1jing3"],
["春柳","chun1liu3"],
["春菇","chun1gu1"],
["春雨","chun1yu3"],
["春餅","chun1bing3"],
["春饼","chun1bing3"],
["春秋三传","chun1qiu1san1zhuan4"],
["春秋三傳","chun1qiu1san1zhuan4"],
["春秋左氏传","chun1qiu1zuo3shi4zhuan4"],
["春秋左氏傳","chun1qiu1zuo3shi4zhuan4"]
],
"昧":[
["昧死","mei4si3"],
["昧沒","mei4mo4"],
["昧没","mei4mo4"]
],
"昨":[
["昨晚","zuo2wan3"]
],
"是":[
["是不","shi4bu5"],
["是为","shi4wei2"],
["是以","shi4yi3"],
["是否","shi4fou3"],
["是指","shi4zhi3"],
["是晚","shi4wan3"],
["是為","shi4wei2"],
["是非得失","shi4fei1de2shi1"]
],
"昵":[
["昵比","ni4bi4"]
],
"显":[
["显卡","xian3ka3"],
["显影","xian3ying3"],
["显显","xian3xian3"],
["显眼","xian3yan3"],
["显老","xian3lao3"],
["显考","xian3kao3"],
["显著","xian3zhu4"],
["显豁","xian3huo4"],
["显不出","xian3bu5chu1"],
["显示屏","xian3shi4bing3"]
],
"時":[
["時候","shi2hou5"],
["時分","shi2fen4"],
["時務","shi2wu4"],
["時宜","shi2yi2"],
["時差","shi2cha1"],
["時有","shi2you3"],
["時興","shi2xing1"],
["時辰","shi2chen5"],
["時不常兒","shi2bu5chang2r5"],
["時好時壞","shi2hao4shi2huai4"],
["時機一到","shi2ji1yi2dao4"]
],
"晌":[
["晌午","shang3wu5"]
],
"晏":[
["晏子","yan4zi3"]
],
"晒":[
["晒友","shai4you3"],
["晒不着","shai4bu5zhao2"],
["晒不透","shai4bu5tou4"],
["晒得漆黑","shai4de2qi1hei1"]
],
"晓":[
["晓得","xiao3de2"]
],
"晕":[
["晕倒","yun1dao3"],
["晕场","yun4chang3"],
["晕机","yun4ji1"],
["晕池","yun4chi2"],
["晕船","yun4chuan2"],
["晕车","yun4che1"],
["晕针","yun4zhen1"],
["晕高儿","yun4gao1r5"],
["晕头转向","yun1tou2zhuan4xiang4"]
],
"晚":[
["晚上","wan3shang5"],
["晚点","wan3dian3"],
["晚祷","wan3dao3"],
["晚禱","wan3dao3"],
["晚點","wan3dian3"],
["晚上好","wan3shang4hao3"]
],
"晨":[
["晨光","chen2guang1"],
["晨報","chen2bao4"],
["晨报","chen2bao4"],
["晨星","chen2xing1"],
["晨曦","chen2xi1"],
["晨歌","chen2ge1"],
["晨祷","chen2dao3"],
["晨禱","chen2dao3"],
["晨練","chen2lian4"],
["晨练","chen2lian4"],
["晨鐘暮鼓","chen2zhong1mu4gu3"],
["晨钟暮鼓","chen2zhong1mu4gu3"]
],
"普":[
["普洱","pu3er3"],
["普瓦","pu3wa3"],
["普选","pu3xuan3"],
["普選","pu3xuan3"],
["普鐵","pu3tie3"],
["普铁","pu3tie3"],
["普加乔夫","pu3jia1qiao2fu1"],
["普加喬夫","pu3jia1qiao2fu1"],
["普罗夫迪夫","pu3luo2fu1di2fu1"],
["普羅夫迪夫","pu3luo2fu1di2fu1"],
["普裡什蒂納","pu3li3shi2di4na4"],
["普里什蒂纳","pu3li3shi2di4na4"]
],
"景":[
["景仰","jing3yang3"],
["景点","jing3dian3"],
["景谷","jing3gu3"],
["景點","jing3dian3"]
],
"晴":[
["晴好","qing2hao3"],
["晴朗","qing2lang3"]
],
"晶":[
["晶体","jing1ti3"],
["晶體","jing1ti3"]
],
"智":[
["智者","zhi4zhe3"],
["智齒","zhi4chi3"],
["智齿","zhi4chi3"]
],
"晾":[
["晾乾","liang4gan1"],
["晾一晾","liang4yi5liang4"]
],
"暂":[
["暂且","zan4qie3"],
["暂息","zan4xi1"],
["暂短","zan4duan3"],
["暂缓","zan4huan3"]
],
"暄":[
["暄腾","xuan1teng5"],
["暄騰","xuan1teng5"]
],
"暈":[
["暈倒","yun1dao3"],
["暈場","yun4chang3"],
["暈機","yun4ji1"],
["暈池","yun4chi2"],
["暈船","yun4chuan2"],
["暈車","yun4che1"],
["暈針","yun4zhen1"],
["暈高兒","yun4gao1r5"],
["暈頭轉向","yun1tou2zhuan4xiang4"]
],
"暑":[
["暑假","shu3jia4"]
],
"暖":[
["暖和","nuan3huo5"]
],
"暗":[
["暗井","an4jing3"],
["暗喜","an4xi3"],
["暗地","an4di4"],
["暗堡","an4bao3"],
["暗影","an4ying3"],
["暗指","an4zhi3"],
["暗裡","an4li3"],
["暗語","an4yu3"],
["暗语","an4yu3"],
["暗轉","an4zhuan3"],
["暗转","an4zhuan3"],
["暗里","an4li3"],
["暗鎖","an4suo3"],
["暗锁","an4suo3"],
["暗地里","an4di4li5"],
["暗记儿","an4ji4r5"],
["暗间儿","an4jian1r5"],
["暗中摸索","an4zhong1mo1suo3"]
],
"暢":[
["暢想","chang4xiang3"],
["暢飲","chang4yin3"]
],
"暫":[
["暫且","zan4qie3"],
["暫息","zan4xi1"],
["暫短","zan4duan3"],
["暫緩","zan4huan3"]
],
"暮":[
["暮景","mu4jing3"],
["暮霭","mu4ai3"],
["暮靄","mu4ai3"],
["暮鼓晨鐘","mu4gu3chen2zhong1"],
["暮鼓晨钟","mu4gu3chen2zhong1"]
],
"暴":[
["暴卒","bao4zu2"],
["暴敛","bao4lian3"],
["暴斂","bao4lian3"],
["暴涨","bao4zhang3"],
["暴漲","bao4zhang3"],
["暴雨","bao4yu3"],
["暴飲","bao4yin3"],
["暴饮","bao4yin3"],
["暴虎冯河","bao4hu3ping2he2"],
["暴虎馮河","bao4hu3ping2he2"]
],
"曆":[
["曆法","li4fa3"]
],
"曉":[
["曉得","xiao3de2"]
],
"曠":[
["曠古","kuang4gu3"],
["曠夫","kuang4fu1"],
["曠渺","kuang4miao3"],
["曠野","kuang4ye3"]
],
"曬":[
["曬乾","shai4gan1"],
["曬友","shai4you3"],
["曬不著","shai4bu5zhao2"],
["曬不透","shai4bu5tou4"],
["曬得漆黑","shai4de2qi1hei1"]
],
"曲":[
["曲周","qu3zhou1"],
["曲子","qu3zi5"],
["曲尺","qu1chi3"],
["曲松","qu3song1"],
["曲柄","qu1bing3"],
["曲水","qu3shui3"],
["曲江","qu3jiang1"],
["曲沃","qu3wo4"],
["曲笔","qu1bi3"],
["曲筆","qu1bi3"],
["曲背","qu1bei1"],
["曲艺","qu3yi4"],
["曲藝","qu3yi4"],
["曲解","qu1jie3"],
["曲調","qu3diao4"],
["曲调","qu3diao4"],
["曲阜","qu3fu4"],
["曲阳","qu3yang2"],
["曲陽","qu3yang2"],
["曲靖","qu3jing4"],
["曲鬆","qu3song1"],
["曲柄鑽","qu1bing3zuan4"],
["曲柄钻","qu1bing3zuan4"],
["曲麻莱","qu3ma2lai2"],
["曲麻萊","qu3ma2lai2"],
["曲終奏雅","qu3zhong1zou4ya3"],
["曲终奏雅","qu3zhong1zou4ya3"],
["曲里拐弯","qu1li5guai3wan1"]
],
"更":[
["更为","geng4wei2"],
["更代","geng1dai4"],
["更动","geng1dong4"],
["更動","geng1dong4"],
["更卒","geng1zu2"],
["更名","geng1ming2"],
["更夫","geng1fu1"],
["更好","geng4hao3"],
["更始","geng1shi3"],
["更张","geng1zhang1"],
["更張","geng1zhang1"],
["更换","geng1huan4"],
["更換","geng1huan4"],
["更改","geng1gai3"],
["更新","geng1xin1"],
["更替","geng1ti4"],
["更楼","geng1lou2"],
["更樓","geng1lou2"],
["更次","geng1ci4"],
["更正","geng1zheng4"],
["更深","geng1shen1"],
["更漏","geng1lou4"],
["更為","geng4wei2"],
["更生","geng1sheng1"],
["更番","geng1fan1"],
["更衣","geng1yi1"],
["更远","geng4yuan3"],
["更迭","geng1die2"],
["更递","geng1di4"],
["更遞","geng1di4"],
["更遠","geng4yuan3"],
["更鼓","geng1gu3"],
["更年期","geng1nian2qi1"],
["更仆难数","geng1pu2nan2shu3"],
["更僕難數","geng1pu2nan2shu3"],
["更高性能","geng1gao1xing4neng2"]
],
"書":[
["書卷","shu1juan4"],
["書反","shu1fan3"],
["書寫","shu1xie3"],
["書展","shu1zhan3"],
["書本","shu1ben3"],
["書板","shu1ban3"],
["書法","shu1fa3"],
["書珥","shu1er3"],
["書瑪","shu1ma3"],
["書稿","shu1gao3"],
["書記","shu1ji5"],
["書跡","shu1ji4"],
["書雅","shu1ya3"],
["書館","shu1guan3"],
["書體","shu1ti3"],
["書不盡","shu1bu5jin4"],
["書巴業","shu1ba1ye4"]
],
"曼":[
["曼谷","man4gu3"],
["曼切斯特","man4qie1si1te4"]
],
"曾":[
["曾孙","zeng1sun1"],
["曾孫","zeng1sun1"],
["曾巩","zeng1gong3"],
["曾朴","zeng1pu3"],
["曾樸","zeng1pu3"],
["曾祖","zeng1zu3"],
["曾鞏","zeng1gong3"],
["曾国藩","zeng1guo2fan1"],
["曾國藩","zeng1guo2fan1"],
["曾孝谷","zeng1xiao4gu3"],
["曾庆红","zeng1qing4hong2"],
["曾慶紅","zeng1qing4hong2"],
["曾紀澤","zeng1ji4ze2"],
["曾纪泽","zeng1ji4ze2"],
["曾外祖母","zeng1wai4zu3mu3"]
],
"替":[
["替换","ti4huan5"],
["替換","ti4huan5"],
["替补","ti4bu3"],
["替補","ti4bu3"],
["替角","ti4jue2"],
["替班儿","ti4ban1r5"],
["替角儿","ti4jue2r5"]
],
"最":[
["最为","zui4wei2"],
["最好","zui4hao3"],
["最小","zui4xiao3"],
["最少","zui4shao3"],
["最差","zui4cha1"],
["最早","zui4zao3"],
["最為","zui4wei2"],
["最短","zui4duan3"],
["最远","zui4yuan3"],
["最遠","zui4yuan3"],
["最前面","zui4qian2mian4"],
["最低限度","zui4di1xian4du5"],
["最后一滴","zui4hou4yi4di1"],
["最後一滴","zui4hou4yi4di1"]
],
"會":[
["會友","hui4you3"],
["會否","hui4fou3"],
["會場","hui4chang3"],
["會審","hui4shen3"],
["會死","hui4si3"],
["會演","hui4yan3"],
["會計","kuai4ji4"],
["會長","hui4zhang3"],
["會首","hui4shou3"],
["會裡縣","hui4li3xian4"],
["會心一笑","hui4xin1yi2xiao4"]
],
"月":[
["月亮","yue4liang5"],
["月晕","yue4yun4"],
["月暈","yue4yun4"],
["月氏","yue4zhi1"],
["月沒","yue4mo4"],
["月没","yue4mo4"],
["月相","yue4xiang4"],
["月給","yue4ji3"],
["月给","yue4ji3"],
["月餅","yue4bing3"],
["月饼","yue4bing3"],
["月鱧","yue4li3"],
["月鳢","yue4li3"]
],
"有":[
["有为","you3wei2"],
["有主","you3zhu3"],
["有分","you3fen4"],
["有喜","you3xi3"],
["有守","you3shou3"],
["有得","you3de2"],
["有感","you3gan3"],
["有所","you3suo3"],
["有损","you3sun3"],
["有損","you3sun3"],
["有染","you3ran3"],
["有水","you3shui3"],
["有点","you3dian3"],
["有為","you3wei2"],
["有理","you3li3"],
["有种","you3zhong3"],
["有種","you3zhong3"],
["有空","you3kong4"],
["有脸","you3lian3"],
["有臉","you3lian3"],
["有請","you3qing3"],
["有请","you3qing3"],
["有軌","you3gui3"],
["有轨","you3gui3"],
["有酒","you3jiu3"],
["有雨","you3yu3"],
["有點","you3dian3"],
["有助於","you3zhu4yu2"],
["有势力","you3shi4li4"],
["有勢力","you3shi4li4"],
["有好处","you3hao3chu4"],
["有好處","you3hao3chu4"],
["有学问","you3xue2wen4"],
["有學問","you3xue2wen4"],
["有年头","you3nian2tou5"],
["有年頭","you3nian2tou5"],
["有志气","you3zhi4qi4"],
["有志氣","you3zhi4qi4"],
["有点儿","you3dian3r5"],
["有眉目","you3mei2mu4"],
["有見識","you3jian4shi2"],
["有见识","you3jian4shi2"],
["有賴於","you3lai4yu2"],
["有道理","you3dao4li3"],
["有夫之妇","you3fu1zhi1fu4"],
["有夫之婦","you3fu1zhi1fu4"],
["有朝一日","you3zhao1yi2ri4"],
["有机分子","you3ji1fen1zi3"],
["有機分子","you3ji1fen1zi3"],
["有苦說不出","you3ku3shuo1bu5chu1"],
["有苦说不出","you3ku3shuo1bu5chu1"],
["有一哈无一哈","you3yi4ha1wu2yi4ha1"],
["有一哈無一哈","you3yi4ha1wu2yi4ha1"],
["有一利必有一弊","you3yi2li4bi4you3yi2bi4"],
["有其父必有其子","you3qi2fu4bi4you3qi2zi3"]
],
"朋":[
["朋党","peng2dang3"],
["朋黨","peng2dang3"]
],
"服":[
["服丧","fu2sang1"],
["服务","fu2wu4"],
["服務","fu2wu4"],
["服喪","fu2sang1"],
["服服","fu4fu5"],
["服法","fu2fa3"],
["服老","fu2lao3"]
],
"朔":[
["朔巴","shuo4ba1"],
["朔比","shuo4bi3"],
["朔法","shuo4fa3"],
["朔百","shuo4bai3"],
["朔罢","shuo4ba4"],
["朔罷","shuo4ba4"]
],
"望":[
["望都","wang4du1"],
["望不到","wang4bu5dao4"],
["望不見","wang4bu5jian4"],
["望不见","wang4bu5jian4"],
["望出去","wang4chu1qu4"],
["望夫石","wang4fu1shi2"],
["望子成龍","wang4zi3cheng2long2"],
["望子成龙","wang4zi3cheng2long2"],
["望而兴叹","wang4er2xing1tan4"],
["望而興嘆","wang4er2xing1tan4"]
],
"朝":[
["朝夕","zhao1xi1"],
["朝日","zhao1ri4"],
["朝朝","zhao1zhao1"],
["朝歌","zhao1ge1"],
["朝气","zhao1qi4"],
["朝氣","zhao1qi4"],
["朝野","chao2ye3"],
["朝露","zhao1lu4"],
["朝鮮","chao2xian3"],
["朝鲜","chao2xian3"],
["朝三暮四","zhao1san1mu4si4"],
["朝秦暮楚","zhao1qin2mu4chu3"],
["朝阳地区","zhao1yang2di4qu1"],
["朝陽地區","zhao1yang2di4qu1"]
],
"期":[
["期攷","qi1kao3"],
["期满","qi1man3"],
["期滿","qi1man3"],
["期考","qi1kao3"],
["期許","qi1xu3"],
["期许","qi1xu3"]
],
"木":[
["木偶","mu4ou3"],
["木塔","mu4ta3"],
["木头","mu4tou5"],
["木杆","mu4gan3"],
["木板","mu4ban3"],
["木框","mu4kuang4"],
["木桶","mu4tong3"],
["木桿","mu4gan3"],
["木版","mu4ban3"],
["木犀","mu4xi5"],
["木瓦","mu4wa3"],
["木耳","mu4er3"],
["木薯","mu4shu3"],
["木頭","mu4tou5"],
["木馬","mu4ma3"],
["木马","mu4ma3"],
["木子美","mu4zi3mei3"],
["木棉花","mu4mian2hua1"],
["木骨都束","mu4gu3du1shu4"],
["木裡藏族自治縣","mu4li3zang4zu2zi4zhi4xian4"]
],
"未":[
["未了","wei4liao3"],
["未免","wei4mian3"],
["未几","wei4ji3"],
["未卜","wei4bu3"],
["未可","wei4ke3"],
["未始","wei4shi3"],
["未娶","wei4qu3"],
["未幾","wei4ji3"],
["未有","wei4you3"],
["未熟","wei4shou2"],
["未婚夫","wei4hun1fu1"],
["未成冠","wei4cheng2guan1"],
["未見得","wei4jian4de2"],
["未见得","wei4jian4de2"],
["未雨綢繆","wei4yu3chou2mou2"],
["未雨绸缪","wei4yu3chou2mou2"]
],
"末":[
["末了","mo4liao3"],
["末巴奈","mo4ba1nai4"]
],
"本":[
["本体","ben3ti3"],
["本分","ben3fen4"],
["本土","ben3tu3"],
["本地","ben3di4"],
["本垒","ben3lei3"],
["本壘","ben3lei3"],
["本岛","ben3dao3"],
["本島","ben3dao3"],
["本底","ben3di3"],
["本影","ben3ying3"],
["本有","ben3you3"],
["本省","ben3sheng3"],
["本草","ben3cao3"],
["本行","ben3hang2"],
["本都","ben3du1"],
["本錢","ben3qian5"],
["本钱","ben3qian5"],
["本領","ben3ling3"],
["本领","ben3ling3"],
["本體","ben3ti3"],
["本徵值","ben3zheng1zhi2"],
["本同一源","ben3tong2yi4yuan2"],
["本徵向量","ben3zheng1xiang4liang4"]
],
"札":[
["札幌","zha2huang3"]
],
"术":[
["术语","shu4yu3"]
],
"朱":[
["朱子","zhu1zi3"],
["朱粉","zhu1fen3"],
["朱云折槛","zhu1yun2zhe1kan3"],
["朱雲折檻","zhu1yun2zhe1kan3"]
],
"朴":[
["朴子","po4zi3"]
],
"朵":[
["朵云","duo3yun2"],
["朵雲","duo3yun2"]
],
"机":[
["机体","ji1ti3"],
["机场","ji1chang3"],
["机宜","ji1yi2"],
["机尾","ji1wei3"],
["机巧","ji1qiao3"],
["机敏","ji1min3"],
["机灵","ji1ling5"],
["机理","ji1li3"],
["机组","ji1zu3"],
["机警","ji1jing3"],
["机长","ji1zhang3"],
["机务段","ji1wu4duan4"]
],
"杀":[
["杀手","sha1shou3"],
["杀死","sha1si3"],
["杀一儆百","sha1yi4jing3bai3"],
["杀人不过头点地","sha1ren2bu2guo4tou2dian3di4"]
],
"杂":[
["杂务","za2wu4"],
["杂感","za2gan3"],
["杂耍","za2shua3"],
["杂草","za2cao3"],
["杂件儿","za2jian4r5"],
["杂拌儿","za2ban4r5"],
["杂牌儿","za2pai2r5"]
],
"权":[
["权为","quan2wei2"],
["权宜","quan2yi2"],
["权柄","quan2bing3"]
],
"杆":[
["杆秤","gan3cheng4"],
["杆菌","gan3jun1"]
],
"李":[
["李广","li3guang3"],
["李廣","li3guang3"],
["李悝","li3kui1"],
["李昉","li3fang3"],
["李鐵","li3tie3"],
["李铁","li3tie3"],
["李娃传","li3wa2zhuan4"],
["李娃傳","li3wa2zhuan4"],
["李昌鎬","li3chang1hao4"],
["李昌镐","li3chang1hao4"],
["李林甫","li3lin2fu3"]
],
"村":[
["村里","cun1li5"],
["村長","cun1zhang3"],
["村长","cun1zhang3"]
],
"杓":[
["杓子","shao2zi5"],
["杓球场","shao2qiu2chang3"],
["杓球場","shao2qiu2chang3"]
],
"杜":[
["杜口","du4kou3"],
["杜塞","du4se4"],
["杜宇","du4yu3"],
["杜巴","du4ba1"],
["杜甫","du4fu3"],
["杜秋娘歌","du4qiu1niang2ge1"],
["杜莎夫人","du4suo1fu1ren5"],
["杜塞尔多夫","du4sai1er3duo1fu1"],
["杜塞爾多夫","du4sai1er3duo1fu1"],
["杜布罗夫尼克","du4bu4luo2fu1ni2ke4"],
["杜布羅夫尼克","du4bu4luo2fu1ni2ke4"]
],
"束":[
["束发","shu4fa4"],
["束手","shu4shou3"],
["束紧","shu4jin3"],
["束緊","shu4jin3"]
],
"杠":[
["杠夫","gang4fu1"]
],
"条":[
["条款","tiao2kuan3"],
["条理","tiao2li3"],
["条码","tiao2ma3"]
],
"来":[
["来使","lai2shi3"],
["来往","lai2wang3"],
["来火","lai2huo3"],
["来者","lai2zhe3"],
["来访","lai2fang3"],
["来不及","lai2bu5ji2"],
["来不得","lai2bu5de5"],
["来火儿","lai2huo3r5"],
["来回来去","lai2hui2lai2qu4"],
["来路不明","lai2lu5bu4ming2"]
],
"杨":[
["杨柳","yang2liu3"],
["杨家将","yang2jia1jiang4"],
["杨澄中","yang2cheng2zhong1"]
],
"杯":[
["杯葛","bei1ge2"]
],
"杰":[
["杰夫","jie2fu1"],
["杰米","jie2mi3"],
["杰佛兹","jie2fo2zi1"]
],
"東":[
["東北","dong1bei3"],
["東家","dong1jia5"],
["東海","dong1hai3"],
["東莞","dong1wan3"],
["東西","dong1xi5"],
["東邊","dong1bian5"],
["東阿","dong1e1"],
["東面","dong1mian5"],
["東西周","dong1xi1zhou1"],
["東西德","dong1xi1de2"],
["東西方","dong1xi1fang1"],
["東邊兒","dong1bian1r5"],
["東倒西歪","dong1dao3xi1wai1"],
["東巴文化","dong1ba1wen2hua4"],
["東西半球","dong1xi1ban4qiu2"],
["東西南北","dong1xi1nan2bei3"]
],
"松":[
["松土","song1tu3"],
["松岛","song1dao3"],
["松島","song1dao3"],
["松快","song1kuai5"],
["松散","song1san5"],
["松果","song1guo3"],
["松柏","song1bai3"],
["松泛","song1fan5"],
["松绑","song1bang3"],
["松缓","song1huan3"],
["松茸","song1rong2"],
["松菌","song1jun4"],
["松软","song1ruan3"],
["松饼","song1bing3"],
["松鼠","song1shu3"],
["松巴哇","song1ba1wa1"],
["松赞干布","song1zan4gan4bu4"]
],
"板":[
["板斧","ban3fu3"],
["板眼","ban3yan3"],
["板紙","ban3zhi3"],
["板纸","ban3zhi3"],
["板鼓","ban3gu3"],
["板擦儿","ban3ca1r5"],
["板上釘釘","ban3shang4ding4ding1"],
["板上钉钉","ban3shang4ding4ding1"],
["板块构造","ban3kuai4gou4zao5"],
["板塊構造","ban3kuai4gou4zao5"]
],
"极":[
["极为","ji2wei2"],
["极北","ji2bei3"],
["极好","ji2hao3"],
["极小","ji2xiao3"],
["极少","ji2shao3"],
["极点","ji2dian3"],
["极角","ji2jiao3"],
["极地狐","ji2di4hu2"]
],
"构":[
["构想","gou4xiang3"]
],
"枇":[
["枇杷","pi2pa5"]
],
"枉":[
["枉径","wang3jing4"],
["枉徑","wang3jing4"],
["枉法","wang3fa3"],
["枉然","wang3ran2"],
["枉自","wang3zi4"],
["枉顧","wang3gu4"],
["枉顾","wang3gu4"],
["枉費心機","wang3fei4xin1ji1"],
["枉费心机","wang3fei4xin1ji1"]
],
"枕":[
["枕头","zhen3tou5"],
["枕藉","zhen3jie4"],
["枕頭","zhen3tou5"],
["枕骨","zhen3gu3"],
["枕席儿","zhen3xi2r5"]
],
"林":[
["林卡","lin2ka3"],
["林口","lin2kou3"],
["林地","lin2di4"],
["林场","lin2chang3"],
["林堡","lin2bao3"],
["林場","lin2chang3"],
["林火","lin2huo3"],
["林肯","lin2ken3"],
["林家翘","lin2jia1qiao2"],
["林家翹","lin2jia1qiao2"],
["林荫大道","lin2yin1da4dao4"],
["林蔭大道","lin2yin1da4dao4"],
["林德布拉德","lin2de2bu4la5de2"]
],
"枘":[
["枘凿","rui4zuo4"],
["枘鑿","rui4zuo4"]
],
"果":[
["果品","guo3pin3"],
["果岭","guo3ling3"],
["果嶺","guo3ling3"],
["果敢","guo3gan3"],
["果脯","guo3fu3"],
["果蝇","guo3ying2"],
["果蠅","guo3ying2"],
["果酒","guo3jiu3"],
["果仁儿","guo3ren2r5"],
["果料儿","guo3liao4r5"],
["果不其然","guo3bu5qi2ran2"],
["果实累累","guo3shi2lei3lei3"],
["果實累累","guo3shi2lei3lei3"]
],
"枝":[
["枝干","zhi1gan4"]
],
"枢":[
["枢纽","shu1niu3"]
],
"枪":[
["枪匪","qiang1fei3"],
["枪口","qiang1kou3"],
["枪手","qiang1shou3"],
["枪法","qiang1fa3"],
["枪管","qiang1guan3"]
],
"枭":[
["枭首","xiao1shou3"]
],
"枯":[
["枯乾","ku1gan1"],
["枯朽","ku1xiu3"],
["枯槁","ku1gao3"],
["枯死","ku1si3"],
["枯水","ku1shui3"],
["枯草","ku1cao3"],
["枯萎","ku1wei3"]
],
"架":[
["架势","jia4shi5"],
["架勢","jia4shi5"],
["架起","jia4qi3"],
["架不住","jia4bu5zhu4"]
],
"枷":[
["枷鎖","jia1suo3"],
["枷锁","jia1suo3"]
],
"枸":[
["枸杞","gou3qi3"],
["枸檵","gou3qi3"]
],
"柏":[
["柏林","bo2lin2"],
["柏拉图","bo2la1tu2"],
["柏拉圖","bo2la1tu2"],
["柏柏尔","bo4bo4er3"],
["柏柏爾","bo4bo4er3"],
["柏辽兹","bo2liao2zi1"],
["柏遼茲","bo2liao2zi1"],
["柏蒂切利","bo2di4qie4li4"],
["柏克里克千佛洞","bo2ke4li3ke4qian1fo2dong4"]
],
"某":[
["某个","mou3ge4"],
["某個","mou3ge4"],
["某地","mou3di4"],
["某某","mou3mou3"],
["某种","mou3zhong3"],
["某種","mou3zhong3"]
],
"染":[
["染上","ran3shang5"],
["染厂","ran3chang3"],
["染发","ran3fa4"],
["染廠","ran3chang3"],
["染指","ran3zhi3"],
["染指於鼎","ran3zhi3yu2ding3"]
],
"柔":[
["柔佛","rou2fo2"],
["柔軟","rou2ruan3"],
["柔软","rou2ruan3"],
["柔佛州","rou2fu2zhou1"],
["柔情脈脈","rou2qing2mo4mo4"],
["柔情脉脉","rou2qing2mo4mo4"]
],
"柜":[
["柜上","gui4shang5"]
],
"柞":[
["柞水","zuo4shui3"]
],
"查":[
["查处","cha2chu3"],
["查找","cha2zhao3"],
["查点","cha2dian3"],
["查考","cha2kao3"],
["查處","cha2chu3"],
["查點","cha2dian3"],
["查韋斯","cha2wei2si5"],
["查韦斯","cha2wei2si5"],
["查不出來","cha2bu5chu1lai5"],
["查不出来","cha2bu5chu1lai5"]
],
"柱":[
["柱体","zhu4ti3"],
["柱頂","zhu4ding3"],
["柱顶","zhu4ding3"],
["柱體","zhu4ti3"]
],
"柳":[
["柳体","liu3ti3"],
["柳杞","liu3qi3"],
["柳永","liu3yong3"],
["柳體","liu3ti3"],
["柳毅传","liu3yi4zhuan4"],
["柳毅傳","liu3yi4zhuan4"],
["柳眉一扬","liu3mei2yi4yang2"],
["柳眉一揚","liu3mei2yi4yang2"],
["柳暗花明又一村","liu3an4hua1ming2you4yi4cun1"]
],
"柴":[
["柴火","chai2huo5"],
["柴科夫斯基","chai2ke1fu1si1ji1"]
],
"柵":[
["柵欄","zha4lan5"]
],
"柽":[
["柽柳","cheng1liu3"]
],
"柿":[
["柿餅","shi4bing3"],
["柿饼","shi4bing3"]
],
"栅":[
["栅栏","zha4lan5"]
],
"标":[
["标准","biao1zhun3"],
["标尺","biao1chi3"],
["标底","biao1di3"],
["标本","biao1ben3"],
["标榜","biao1bang3"],
["标点","biao1dian3"],
["标致","biao1zhi5"],
["标识","biao1zhi4"],
["标语","biao1yu3"],
["标准差","biao1zhun3cha1"],
["标准杆","biao1zhun3gan3"]
],
"栈":[
["栈板","zhan4ban3"]
],
"栉":[
["栉比","zhi4bi3"]
],
"树":[
["树上","shu4shang5"],
["树下","shu4xia5"],
["树冠","shu4guan1"],
["树干","shu4gan4"],
["树獭","shu4ta3"],
["树种","shu4zhong3"],
["树荫","shu4yin1"],
["树起","shu4qi3"],
["树顶","shu4ding3"],
["树倒猢狲散","shu4dao3hu2sun1san4"]
],
"栓":[
["栓塞","shuan1se4"]
],
"栖":[
["栖息","qi1xi1"],
["栖霞","xi1xia2"],
["栖息地","qi1xi1di4"]
],
"栗":[
["栗鼠","li4shu3"]
],
"校":[
["校准","jiao4zhun3"],
["校勘","jiao4kan1"],
["校友","xiao4you3"],
["校地","xiao4di4"],
["校对","jiao4dui4"],
["校對","jiao4dui4"],
["校正","jiao4zheng4"],
["校準","jiao4zhun3"],
["校稿","jiao4gao3"],
["校舍","xiao4she4"],
["校訂","jiao4ding4"],
["校订","jiao4ding4"],
["校長","xiao4zhang3"],
["校长","xiao4zhang3"],
["校閱","jiao4yue4"],
["校阅","jiao4yue4"],
["校驗","jiao4yan4"],
["校验","jiao4yan4"]
],
"栩":[
["栩栩","xu3xu3"]
],
"株":[
["株守","zhu1shou3"]
],
"样":[
["样品","yang4pin3"],
["样本","yang4ben3"],
["样板","yang4ban3"]
],
"核":[
["核准","he2zhun3"],
["核子","he2zi3"],
["核桃","he2tao5"],
["核武","he2wu3"],
["核準","he2zhun3"],
["核散射","he2san4she4"],
["核門檻","he2men2jian4"],
["核门槛","he2men2jian4"]
],
"根":[
["根本","gen1ben3"],
["根柢","gen1di3"],
["根据地","gen1ju4di4"],
["根據地","gen1ju4di4"]
],
"格":[
["格式","ge2shi5"],
["格網","ge2wang3"],
["格网","ge2wang3"],
["格式化","ge2shi4hua4"],
["格林多","ge4lin2duo1"],
["格尔夫波特","ge2er3fu1bo1te4"],
["格爾夫波特","ge2er3fu1bo1te4"]
],
"栽":[
["栽种","zai1zhong4"],
["栽種","zai1zhong4"]
],
"桁":[
["桁架","heng2jia4"],
["桁梁","heng2liang2"],
["桁樑","heng2liang2"]
],
"桂":[
["桂冠","gui4guan1"]
],
"框":[
["框子","kuang4zi5"],
["框架","kuang4jia4"]
],
"案":[
["案卷","an4juan4"],
["案板","an4ban3"],
["案称","an4cheng4"],
["案稱","an4cheng4"]
],
"桐":[
["桐柏","tong2bai3"],
["桐梓","tong2zi3"]
],
"桑":[
["桑巴","sang1ba1"],
["桑海","sang1hai3"],
["桑給巴爾","sang1ji3ba1er3"],
["桑给巴尔","sang1ji3ba1er3"]
],
"桔":[
["桔梗","jie2geng3"],
["桔黃色","jie2huang2se4"],
["桔黄色","jie2huang2se4"]
],
"桡":[
["桡骨","rao2gu3"]
],
"桥":[
["桥本","qiao2ben3"]
],
"桿":[
["桿弟","gan1di4"]
],
"梅":[
["梅雨","mei2yu3"]
],
"梗":[
["梗塞","geng3se4"],
["梗死","geng3si3"],
["梗阻","geng3zu3"]
],
"條":[
["條款","tiao2kuan3"],
["條理","tiao2li3"],
["條碼","tiao2ma3"]
],
"梟":[
["梟首","xiao1shou3"]
],
"梦":[
["梦想","meng4xiang3"],
["梦景","meng4jing3"],
["梦见","meng4jian5"],
["梦魇","meng4yan3"]
],
"梨":[
["梨属","li2shu3"],
["梨屬","li2shu3"],
["梨果","li2guo3"]
],
"梯":[
["梯己","ti1ji5"],
["梯板","ti1ban3"]
],
"梵":[
["梵刹","fan4cha4"],
["梵剎","fan4cha4"],
["梵語","fan4yu3"],
["梵语","fan4yu3"]
],
"检":[
["检举","jian3ju3"],
["检校","jian3jiao4"],
["检点","jian3dian3"],
["检索","jian3suo3"],
["检讨","jian3tao3"]
],
"棃":[
["棃果","li2guo3"]
],
"棉":[
["棉花","mian2hua5"],
["棉袄","mian2ao3"],
["棉襖","mian2ao3"]
],
"棋":[
["棋子","qi2zi3"],
["棋手","qi2shou3"],
["棋譜","qi2pu3"],
["棋谱","qi2pu3"],
["棋高一着","qi2gao1yi4zhao1"],
["棋高一著","qi2gao1yi4zhao1"],
["棋錯一著滿盤輸","qi2cuo4yi4zhao1man3pan2shu1"],
["棋错一着满盘输","qi2cuo4yi4zhao1man3pan2shu1"]
],
"棒":[
["棒打","bang4da3"],
["棒槌","bang4chui5"],
["棒棒糖","bang4bang5tang2"]
],
"棕":[
["棕毯","zong1tan3"],
["棕繃","zong1beng1"],
["棕绷","zong1beng1"]
],
"棘":[
["棘手","ji2shou3"]
],
"棚":[
["棚圈","peng2juan4"]
],
"棱":[
["棱角","leng2jiao3"]
],
"棲":[
["棲息","qi1xi1"],
["棲霞","xi1xia2"],
["棲息地","qi1xi1di4"]
],
"棺":[
["棺材","guan1cai5"]
],
"椋":[
["椋鳥","liang2niao3"],
["椋鸟","liang2niao3"]
],
"椎":[
["椎骨","zhui1gu3"],
["椎間盤","zhui1jian1pan2"],
["椎间盘","zhui1jian1pan2"]
],
"椰":[
["椰奶","ye1nai3"],
["椰枣","ye1zao3"],
["椰棗","ye1zao3"]
],
"楊":[
["楊柳","yang2liu3"],
["楊家將","yang2jia1jiang4"],
["楊澄中","yang2cheng2zhong1"]
],
"楚":[
["楚国","chu3guo2"],
["楚國","chu3guo2"],
["楚辞","chu3ci2"],
["楚辭","chu3ci2"],
["楚雄","chu3xiong2"],
["楚庄王","chu3zhuang1wang2"],
["楚莊王","chu3zhuang1wang2"],
["楚弓楚得","chu3gong1chu3de2"],
["楚汉战争","chu3han4zhan4zheng1"],
["楚漢戰爭","chu3han4zhan4zheng1"]
],
"楞":[
["楞迦","leng2jia1"],
["楞子眼","leng2zi5yan3"]
],
"業":[
["業主","ye4zhu3"],
["業務","ye4wu4"],
["業已","ye4yi3"],
["業海","ye4hai3"],
["業績","ye4ji4"]
],
"極":[
["極北","ji2bei3"],
["極好","ji2hao3"],
["極小","ji2xiao3"],
["極少","ji2shao3"],
["極為","ji2wei2"],
["極角","ji2jiao3"],
["極點","ji2dian3"],
["極地狐","ji2di4hu2"]
],
"楼":[
["楼板","lou2ban3"],
["楼橹","lou2lu3"],
["楼顶","lou2ding3"]
],
"榄":[
["榄角","lan3jiao3"]
],
"榔":[
["榔头","lang2tou5"],
["榔頭","lang2tou5"]
],
"榛":[
["榛果","zhen1guo3"]
],
"榜":[
["榜首","bang3shou3"]
],
"榨":[
["榨取","zha4qu3"]
],
"榫":[
["榫头","sun3tou5"],
["榫眼","sun3yan3"],
["榫頭","sun3tou5"]
],
"榮":[
["榮美","rong2mei3"],
["榮譽教授","rong2yu2jiao4shou4"]
],
"構":[
["構想","gou4xiang3"]
],
"槍":[
["槍匪","qiang1fei3"],
["槍口","qiang1kou3"],
["槍手","qiang1shou3"],
["槍法","qiang1fa3"],
["槍管","qiang1guan3"]
],
"槓":[
["槓夫","gang4fu1"],
["槓杆","gang4gan3"],
["槓桿","gang4gan3"]
],
"槛":[
["槛车","jian4che1"],
["槛花笼鹤","jian4hua1long2he4"]
],
"槟":[
["槟城","bin1cheng2"],
["槟子","bin1zi5"],
["槟榔","bing1lang5"]
],
"樂":[
["樂亭","yue4ting2"],
["樂器","yue4qi4"],
["樂團","yue4tuan2"],
["樂壇","yue4tan2"],
["樂師","yue4shi1"],
["樂府","yue4fu3"],
["樂得","le4de2"],
["樂手","yue4shou3"],
["樂於","le4yu2"],
["樂曲","yue4qu3"],
["樂清","yue4qing1"],
["樂章","yue4zhang1"],
["樂經","yue4jing1"],
["樂聲","yue4sheng1"],
["樂譜","yue4pu3"],
["樂迷","yue4mi2"],
["樂都","le4du1"],
["樂隊","yue4dui4"],
["樂音","yue4yin1"],
["樂學者","yue4xue2zhe3"],
["樂善好施","le4shan4hao4shi1"],
["樂得心癢難受","le4de5xin1yang3nan2shou4"]
],
"樓":[
["樓板","lou2ban3"],
["樓櫓","lou2lu3"],
["樓頂","lou2ding3"]
],
"標":[
["標尺","biao1chi3"],
["標底","biao1di3"],
["標本","biao1ben3"],
["標榜","biao1bang3"],
["標準","biao1zhun3"],
["標致","biao1zhi5"],
["標語","biao1yu3"],
["標識","biao1zhi4"],
["標點","biao1dian3"],
["標準差","biao1zhun3cha1"]
],
"樞":[
["樞紐","shu1niu3"]
],
"樟":[
["樟脑","zhang1nao3"],
["樟腦","zhang1nao3"]
],
"模":[
["模仿","mo2fang3"],
["模倣","mo2fang3"],
["模具","mu2ju4"],
["模子","mu2zi5"],
["模拟","mo2ni3"],
["模擬","mo2ni3"],
["模板","mu2ban3"],
["模样","mu2yang4"],
["模樣","mu2yang4"],
["模特儿","mo2te4r5"]
],
"樣":[
["樣品","yang4pin3"],
["樣本","yang4ben3"],
["樣板","yang4ban3"]
],
"横":[
["横切","heng2qie1"],
["横扫","heng2sao3"],
["横是","heng2shi5"],
["横死","heng4si3"],
["横流","heng4liu2"],
["横祸","heng4huo4"],
["横竖","heng2shu5"],
["横笔","heng2bi3"],
["横财","heng4cai2"],
["横骨","heng2gu3"],
["横桁帆","heng2heng2fan1"],
["横结肠","heng2jie1chang2"]
],
"樱":[
["樱岛","ying1dao3"]
],
"樵":[
["樵夫","qiao2fu1"]
],
"樹":[
["樹上","shu4shang5"],
["樹下","shu4xia5"],
["樹冠","shu4guan1"],
["樹獺","shu4ta3"],
["樹種","shu4zhong3"],
["樹蔭","shu4yin1"],
["樹起","shu4qi3"],
["樹頂","shu4ding3"],
["樹倒猢猻散","shu4dao3hu2sun1san4"]
],
"橄":[
["橄榄","gan3lan3"],
["橄欖","gan3lan3"]
],
"橈":[
["橈骨","rao2gu3"]
],
"橋":[
["橋本","qiao2ben3"]
],
"機":[
["機場","ji1chang3"],
["機宜","ji1yi2"],
["機尾","ji1wei3"],
["機巧","ji1qiao3"],
["機敏","ji1min3"],
["機理","ji1li3"],
["機組","ji1zu3"],
["機警","ji1jing3"],
["機長","ji1zhang3"],
["機靈","ji1ling5"],
["機體","ji1ti3"],
["機務段","ji1wu4duan4"]
],
"橫":[
["橫切","heng2qie1"],
["橫掃","heng2sao3"],
["橫是","heng2shi5"],
["橫死","heng4si3"],
["橫流","heng4liu2"],
["橫禍","heng4huo4"],
["橫筆","heng2bi3"],
["橫豎","heng2shu5"],
["橫財","heng4cai2"],
["橫骨","heng2gu3"],
["橫桁帆","heng2heng2fan1"],
["橫結腸","heng2jie1chang2"],
["橫徵暴斂","heng2zheng1bao4lian3"]
],
"檉":[
["檉柳","cheng1liu3"]
],
"檢":[
["檢校","jian3jiao4"],
["檢索","jian3suo3"],
["檢舉","jian3ju3"],
["檢討","jian3tao3"],
["檢點","jian3dian3"]
],
"檳":[
["檳城","bin1cheng2"],
["檳子","bin1zi5"],
["檳榔","bing1lang5"]
],
"檻":[
["檻車","jian4che1"],
["檻花籠鶴","jian4hua1long2he4"]
],
"櫃":[
["櫃上","gui4shang5"]
],
"櫛":[
["櫛比","zhi4bi3"]
],
"櫻":[
["櫻島","ying1dao3"]
],
"權":[
["權宜","quan2yi2"],
["權柄","quan2bing3"],
["權為","quan2wei2"]
],
"欖":[
["欖角","lan3jiao3"]
],
"欠":[
["欠妥","qian4tuo3"],
["欠款","qian4kuan3"]
],
"次":[
["次品","ci4pin3"],
["次女","ci4nv3"],
["次子","ci4zi3"],
["次等","ci4deng3"],
["次要","ci4yao5"],
["次長","ci4zhang3"],
["次长","ci4zhang3"]
],
"欢":[
["欢乐","huan1le4"],
["欢势","huan1shi5"],
["欢呼","huan1hu1"],
["欢喜","huan1xi3"],
["欢声","huan1sheng1"],
["欢实","huan1shi5"],
["欢宴","huan1yan4"],
["欢庆","huan1qing4"],
["欢度","huan1du4"],
["欢心","huan1xin1"],
["欢愉","huan1yu2"],
["欢欣","huan1xin1"],
["欢畅","huan1chang4"],
["欢笑","huan1xiao4"],
["欢聚","huan1ju4"],
["欢腾","huan1teng2"],
["欢跃","huan1yue4"],
["欢迎","huan1ying2"],
["欢送","huan1song4"],
["欢天喜地","huan1tian1xi3di4"],
["欢欢喜喜","huan1huan1xi3xi3"],
["欢蹦乱跳","huan1beng4luan4tiao4"]
],
"欣":[
["欣喜","xin1xi3"],
["欣賞","xin1shang3"],
["欣赏","xin1shang3"],
["欣嫩子","xin1nen4zi3"]
],
"欧":[
["欧姆","ou1mu3"],
["欧宝","ou1bao3"],
["欧泊","ou1bo2"],
["欧美","ou1mei3"],
["欧米伽","ou1mi3ga1"],
["欧几里得","ou1ji3li3de2"],
["欧里庇得斯","ou1li3bi4de2si1"]
],
"欲":[
["欲火","yu4huo3"]
],
"欺":[
["欺侮","qi1wu3"],
["欺哄","qi1hong3"],
["欺負","qi1fu5"],
["欺负","qi1fu5"],
["欺人太甚","qi1ren2tai4shen4"]
],
"款":[
["款儿","kuan3r5"]
],
"歇":[
["歇手","xie1shou3"],
["歇脚","xie1jiao3"],
["歇腳","xie1jiao3"],
["歇一会","xie1yi4hui3"],
["歇一會","xie1yi4hui3"],
["歇一会儿","xie1yi4hui3r5"]
],
"歌":[
["歌儿","ge1r5"],
["歌咏","ge1yong3"],
["歌女","ge1nv3"],
["歌手","ge1shou3"],
["歌曲","ge1qu3"],
["歌舞","ge1wu3"],
["歌詠","ge1yong3"],
["歌仔戏","ge1zai3xi4"],
["歌仔戲","ge1zai3xi4"]
],
"歎":[
["歎息","tan4xi1"]
],
"歐":[
["歐姆","ou1mu3"],
["歐寶","ou1bao3"],
["歐泊","ou1bo2"],
["歐美","ou1mei3"],
["歐米伽","ou1mi3ga1"],
["歐幾裡德","ou1ji3li3de2"],
["歐幾里得","ou1ji3li3de2"],
["歐里庇得斯","ou1li3bi4de2si1"]
],
"歡":[
["歡勢","huan1shi5"],
["歡呼","huan1hu1"],
["歡喜","huan1xi3"],
["歡宴","huan1yan4"],
["歡實","huan1shi5"],
["歡度","huan1du4"],
["歡心","huan1xin1"],
["歡愉","huan1yu2"],
["歡慶","huan1qing4"],
["歡暢","huan1chang4"],
["歡樂","huan1le4"],
["歡欣","huan1xin1"],
["歡笑","huan1xiao4"],
["歡聚","huan1ju4"],
["歡聲","huan1sheng1"],
["歡躍","huan1yue4"],
["歡迎","huan1ying2"],
["歡送","huan1song4"],
["歡騰","huan1teng2"],
["歡天喜地","huan1tian1xi3di4"],
["歡歡喜喜","huan1huan1xi3xi3"],
["歡蹦亂跳","huan1beng4luan4tiao4"]
],
"止":[
["止咳","zhi3ke2"],
["止息","zhi3xi1"],
["止不了","zhi3bu5liao3"],
["止不住","zhi3bu5zhu4"],
["止疼片","zhi3teng2pian1"]
],
"正":[
["正体","zheng4ti3"],
["正切","zheng4qie1"],
["正午","zheng4wu3"],
["正反","zheng4fan3"],
["正史","zheng4shi3"],
["正好","zheng4hao3"],
["正巧","zheng4qiao3"],
["正月","zheng1yue4"],
["正楷","zheng4kai3"],
["正比","zheng4bi3"],
["正点","zheng4dian3"],
["正統","zheng4tong3"],
["正统","zheng4tong3"],
["正骨","zheng4gu3"],
["正體","zheng4ti3"],
["正點","zheng4dian3"],
["正仓院","zheng1cang1yuan4"],
["正倉院","zheng1cang1yuan4"],
["正当性","zheng4dang4xing4"],
["正當性","zheng4dang4xing4"],
["正儿八经","zheng4r5ba1jing1"],
["正当防卫","zheng4dang4fang2wei4"],
["正當防衛","zheng4dang4fang2wei4"],
["正經八百","zheng4jing5ba1bai3"],
["正经八百","zheng4jing5ba1bai3"]
],
"此":[
["此地","ci3di4"]
],
"步":[
["步履","bu4lv3"],
["步法","bu4fa3"],
["步步为营","bu4bu4wei2ying2"],
["步步為營","bu4bu4wei2ying2"]
],
"武":[
["武举","wu3ju3"],
["武将","wu3jiang4"],
["武將","wu3jiang4"],
["武打","wu3da3"],
["武水","wu3shui3"],
["武舉","wu3ju3"],
["武警","wu3jing3"],
["武都","wu3du1"],
["武仙座","wu3xian1zuo4"],
["武打片","wu3da3pian1"],
["武装力量","wu3zhuang1li4liang4"],
["武裝力量","wu3zhuang1li4liang4"]
],
"歪":[
["歪嘴","wai1zui3"],
["歪理","wai1li3"],
["歪一歪","wai1yi5wai1"]
],
"歲":[
["歲差","sui4cha1"],
["歲數","sui4shu5"],
["歲首","sui4shou3"]
],
"歷":[
["歷久","li4jiu3"],
["歷史","li4shi3"],
["歷盡","li4jin4"],
["歷險","li4xian3"],
["歷史上","li4shi3shang5"]
],
"歸":[
["歸主","gui1zhu3"],
["歸屬","gui1shu3"],
["歸攏","gui1long3"],
["歸於","gui1yu2"],
["歸給","gui1gei3"],
["歸還","gui1huan2"],
["歸降","gui1xiang2"],
["歸咎於","gui1jiu4yu2"]
],
"死":[
["死产","si3chan3"],
["死地","si3di4"],
["死守","si3shou3"],
["死板","si3ban3"],
["死死","si3si3"],
["死海","si3hai3"],
["死狗","si3gou3"],
["死產","si3chan3"],
["死者","si3zhe3"],
["死角","si3jiao3"],
["死难","si3nan4"],
["死難","si3nan4"],
["死鬼","si3gui3"],
["死不了","si3bu5liao3"],
["死胡同","si3hu2tong4"],
["死难者","si3nan2zhe3"],
["死難者","si3nan2zhe3"],
["死不要脸","si3bu5yao4lian3"],
["死不要臉","si3bu5yao4lian3"],
["死得其所","si3de2qi2suo3"],
["死得壮烈","si3de2zhuang4lie4"],
["死得壯烈","si3de2zhuang4lie4"],
["死於非命","si3yu2fei1ming4"],
["死裡逃生","si3li3tao2sheng1"]
],
"殉":[
["殉死","xun4si3"],
["殉难","xun4nan4"],
["殉難","xun4nan4"]
],
"殊":[
["殊死","shu1si3"],
["殊不知","shu1bu5zhi1"]
],
"残":[
["残卷","can2juan4"],
["残忍","can2ren3"],
["残秆","can2gan3"],
["残疾儿","can2ji5er2"]
],
"殘":[
["殘卷","can2juan4"],
["殘忍","can2ren3"],
["殘稈","can2gan3"],
["殘疾兒","can2ji5er2"]
],
"殴":[
["殴打","ou1da3"]
],
"殺":[
["殺手","sha1shou3"],
["殺死","sha1si3"],
["殺一儆百","sha1yi4jing3bai3"],
["殺人不過頭點地","sha1ren2bu2guo4tou2dian3di4"]
],
"殼":[
["殼質","qiao4zhi4"]
],
"殿":[
["殿宇","dian4yu3"]
],
"毀":[
["毀損","hui3sun3"],
["毀於一旦","hui3yu2yi2dan4"]
],
"毁":[
["毁损","hui3sun3"]
],
"毆":[
["毆打","ou1da3"]
],
"母":[
["母乳","mu3ru3"],
["母亲","mu3qin5"],
["母体","mu3ti3"],
["母女","mu3nv3"],
["母板","mu3ban3"],
["母犬","mu3quan3"],
["母狗","mu3gou3"],
["母親","mu3qin5"],
["母語","mu3yu3"],
["母语","mu3yu3"],
["母馬","mu3ma3"],
["母马","mu3ma3"],
["母體","mu3ti3"],
["母鳥","mu3niao3"],
["母鸟","mu3niao3"],
["母亲节","mu3qin1jie2"],
["母夜叉","mu3ye4cha1"],
["母親節","mu3qin1jie2"],
["母子垂直感染","mu3zi3chui2zhi2gan3ran3"]
],
"每":[
["每每","mei3mei3"]
],
"毒":[
["毒品","du2pin3"],
["毒手","du2shou3"],
["毒打","du2da3"],
["毒爪","du2zhua3"],
["毒瘾","du2yin3"],
["毒癮","du2yin3"],
["毒草","du2cao3"],
["毒不过","du2bu5guo4"],
["毒不過","du2bu5guo4"]
],
"比":[
["比为","bi3wei2"],
["比坦","bi3tan3"],
["比尔","bi3er3"],
["比才","bi4cai2"],
["比拟","bi3ni3"],
["比擬","bi3ni3"],
["比方","bi3fang5"],
["比武","bi3wu3"],
["比為","bi3wei2"],
["比爾","bi3er3"],
["比珥","bi3er3"],
["比索","bi3suo3"],
["比起","bi3qi3"],
["比量","bi3liang5"],
["比一比","bi3yi5bi3"],
["比不上","bi3bu5shang4"],
["比不得","bi3bu5de2"],
["比得上","bi3de5shang4"],
["比斯巴","bi3si1ba1"],
["比桿賽","bi3gan1sai4"],
["比較少","bi3jiao3shao3"],
["比较少","bi3jiao3shao3"],
["比什凯克","bi3shi2kai3ke4"],
["比什凱克","bi3shi2kai3ke4"],
["比佛利山","bi3fo2li4shan1"],
["比較喜歡","bi3jiao4xi3huan1"],
["比较喜欢","bi3jiao4xi3huan1"],
["比埃兹巴伯","bi3ai1zi1ba1bo2"],
["比埃茲巴伯","bi3ai1zi1ba1bo2"]
],
"毕":[
["毕甲","bi4jia3"],
["毕宿五","bi4xiu4wu3"],
["毕尔巴鄂","bi4er3ba1e4"],
["毕尼奥夫","bi4ni2ao4fu1"],
["毕其功于一役","bi4qi2gong1yu2yi2yi4"]
],
"毛":[
["毛发","mao2fa4"],
["毛口","mao2kou3"],
["毛孔","mao2kong3"],
["毛毛","mao2mao5"],
["毛毯","mao2tan3"],
["毛片","mao2pian1"],
["毛病","mao2bing5"],
["毛笔","mao2bi3"],
["毛筆","mao2bi3"],
["毛哔叽","mao2bi4ji5"],
["毛嗶嘰","mao2bi4ji5"]
],
"毫":[
["毫发","hao2fa4"],
["毫巴","hao2ba1"],
["毫秒","hao2miao3"],
["毫米","hao2mi3"],
["毫不在意","hao2bu5zai4yi4"]
],
"民":[
["民主","min2zhu3"],
["民乐","min2yue4"],
["民改","min2gai3"],
["民有","min2you3"],
["民樂","min2yue4"],
["民法","min2fa3"],
["民調","min2tiao2"],
["民警","min2jing3"],
["民调","min2tiao2"],
["民选","min2xuan3"],
["民選","min2xuan3"],
["民窮財盡","min2qiong2cai2jin4"],
["民以食为天","min2yi3shi2wei2tian1"],
["民以食為天","min2yi3shi2wei2tian1"]
],
"气":[
["气体","qi4ti3"],
["气口","qi4kou3"],
["气喘","qi4chuan3"],
["气孔","qi4kong3"],
["气息","qi4xi1"],
["气死","qi4si3"],
["气管","qi4guan3"],
["气阱","qi4jing3"],
["气馁","qi4nei3"],
["气不忿","qi4bu5fen4"],
["气头上","qi4tou2shang5"],
["气不忿儿","qi4bu5fen4r5"],
["气冲牛斗","qi4chong1niu2dou3"],
["气贯长虹","qi4guan4chang2hong2"],
["气得脸发黄","qi4de5lian3fa1huang2"]
],
"氢":[
["氢氧","qing1yang3"]
],
"氣":[
["氣口","qi4kou3"],
["氣喘","qi4chuan3"],
["氣孔","qi4kong3"],
["氣息","qi4xi1"],
["氣死","qi4si3"],
["氣盡","qi4jin4"],
["氣管","qi4guan3"],
["氣阱","qi4jing3"],
["氣餒","qi4nei3"],
["氣體","qi4ti3"],
["氣不忿","qi4bu5fen4"],
["氣頭上","qi4tou2shang5"],
["氣沖牛斗","qi4chong1niu2dou3"],
["氣貫長虹","qi4guan4chang2hong2"],
["氣得臉發黃","qi4de5lian3fa1huang2"]
],
"氫":[
["氫氧","qing1yang3"]
],
"氯":[
["氯仿","lv4fang3"],
["氯苯","lv4ben3"]
],
"水":[
["水井","shui3jing3"],
["水产","shui3chan3"],
["水仙","shui3xian1"],
["水体","shui3ti3"],
["水准","shui3zhun3"],
["水分","shui3fen4"],
["水土","shui3tu3"],
["水底","shui3di3"],
["水手","shui3shou3"],
["水果","shui3guo3"],
["水桶","shui3tong3"],
["水母","shui3mu3"],
["水洗","shui3xi3"],
["水準","shui3zhun3"],
["水点","shui3dian3"],
["水獭","shui3ta3"],
["水獺","shui3ta3"],
["水產","shui3chan3"],
["水碾","shui3nian3"],
["水管","shui3guan3"],
["水肿","shui3zhong3"],
["水腫","shui3zhong3"],
["水草","shui3cao3"],
["水表","shui3biao3"],
["水解","shui3jie3"],
["水里","shui3li5"],
["水餃","shui3jiao3"],
["水饺","shui3jiao3"],
["水體","shui3ti3"],
["水鳥","shui3niao3"],
["水鸟","shui3niao3"],
["水點","shui3dian3"],
["水浒传","shui3hu3zhuan4"],
["水滸傳","shui3hu3zhuan4"],
["水饺儿","shui3jiao3r5"],
["水上运动","shui3shang4yun4dong5"],
["水上運動","shui3shang4yun4dong5"],
["水天一色","shui3tian1yi2se4"],
["水浒全传","shui3hu3quan2zhuan4"],
["水浒后传","shui3hu3hou4zhuan4"],
["水滸全傳","shui3hu3quan2zhuan4"],
["水滸後傳","shui3hu3hou4zhuan4"]
],
"永":[
["永久","yong3jiu3"],
["永享","yong3xiang3"],
["永兴","yong3xing1"],
["永興","yong3xing1"],
["永远","yong3yuan3"],
["永遠","yong3yuan3"],
["永贞内禅","yong3zhen1nei4shan4"]
],
"求":[
["求取","qiu2qu3"],
["求得","qiu2de2"],
["求索","qiu2suo3"],
["求解","qiu2jie3"],
["求雨","qiu2yu3"],
["求仁得仁","qiu2ren2de2ren2"],
["求浆得酒","qiu2jiang1de2jiu3"],
["求漿得酒","qiu2jiang1de2jiu3"]
],
"汇":[
["汇总","hui4zong3"],
["汇拢","hui4long3"],
["汇整","hui4zheng3"],
["汇款","hui4kuan3"],
["汇水","hui4shui3"],
["汇演","hui4yan3"],
["汇点","hui4dian3"],
["汇出行","hui4chu1hang2"]
],
"汉":[
["汉口","han4kou3"],
["汉堡","han4bao3"],
["汉水","han4shui3"],
["汉语","han4yu3"]
],
"汎":[
["汎指","fan4zhi3"]
],
"汐":[
["汐止","xi1zhi3"]
],
"汕":[
["汕尾","shan4wei3"]
],
"汗":[
["汗国","han2guo2"],
["汗國","han2guo2"]
],
"江":[
["江北","jiang1bei3"],
["江口","jiang1kou3"],
["江永","jiang1yong3"],
["江浦","jiang1pu3"],
["江都","jiang1du1"]
],
"池":[
["池水","chi2shui3"],
["池沼","chi2zhao3"]
],
"污":[
["污损","wu1sun3"],
["污損","wu1sun3"],
["污染","wu1ran3"],
["污水","wu1shui3"],
["污点","wu1dian3"],
["污跡","wu1ji4"],
["污辱","wu1ru3"],
["污迹","wu1ji4"],
["污點","wu1dian3"]
],
"汤":[
["汤匙","tang1chi2"],
["汤姆","tang1mu3"],
["汤碗","tang1wan3"]
],
"汲":[
["汲取","ji2qu3"],
["汲引","ji2yin3"],
["汲水","ji2shui3"]
],
"汹":[
["汹涌","xiong1yong3"],
["汹湧","xiong1yong3"]
],
"決":[
["決口","jue2kou3"],
["決一勝負","jue2yi2sheng4fu4"],
["決一死戰","jue2yi4si3zhan4"],
["決一雌雄","jue2yi4ci2xiong2"]
],
"汽":[
["汽暖","qi4nuan3"],
["汽水","qi4shui3"],
["汽碾","qi4nian3"],
["汽艇","qi4ting3"],
["汽酒","qi4jiu3"]
],
"沁":[
["沁水","qin4shui3"]
],
"沂":[
["沂水","yi2shui3"]
],
"沃":[
["沃土","wo4tu3"],
["沃壤","wo4rang3"],
["沃水","wo4shui3"],
["沃衍","wo4yan3"],
["沃野","wo4ye3"],
["沃夫西","wo4fu1xi1"],
["沃尔夫","wo4er3fu1"],
["沃爾夫","wo4er3fu1"]
],
"沅":[
["沅水","yuan2shui3"]
],
"沈":[
["沈积","chen2ji1"],
["沈積","chen2ji1"],
["沈重","chen2zhong4"],
["沈默","chen2mo4"],
["沈魚落雁","chen2yu2luo4yan4"],
["沈鱼落雁","chen2yu2luo4yan4"]
],
"沉":[
["沉沒","chen2mo4"],
["沉没","chen2mo4"],
["沉溺","chen2ni4"],
["沉着","chen2zhuo2"],
["沉稳","chen2wen3"],
["沉穩","chen2wen3"],
["沉著","chen2zhuo2"],
["沉甸甸","chen2dian1dian1"],
["沉不住气","chen2bu5zhu4qi4"],
["沉不住氣","chen2bu5zhu4qi4"]
],
"沒":[
["沒收","mo4shou1"],
["沒有","mei2you3"],
["沒法","mei2fa3"],
["沒落","mo4luo4"],
["沒藥","mo4yao4"],
["沒頂","mo4ding3"],
["沒分寸","mei2fen1cun4"],
["沒辦法","mei2ban4fa5"],
["沒完沒了","mei2wan2mei2liao3"],
["沒藥救了","mei2yao4jiu4le5"],
["沒齒不忘","mo4chi3bu2wang4"],
["沒齒難忘","mo4chi3nan2wang4"]
],
"沖":[
["沖洗","chong1xi3"],
["沖走","chong1zou3"]
],
"沙":[
["沙哑","sha1ya3"],
["沙啞","sha1ya3"],
["沙土","sha1tu3"],
["沙地","sha1di4"],
["沙场","sha1chang3"],
["沙場","sha1chang3"],
["沙巴","sha1ba1"],
["沙斐","sha1fei3"],
["沙朗","sha1lang3"],
["沙本","sha1ben3"],
["沙法","sha1fa3"],
["沙玛","sha1ma3"],
["沙瑪","sha1ma3"],
["沙甲","sha1jia3"],
["沙畹","sha1wan3"],
["沙眼","sha1yan3"],
["沙雅","sha1ya3"],
["沙馬","sha1ma3"],
["沙马","sha1ma3"],
["沙坑杆","sha1keng1gan3"],
["沙得拉","sha1de2la1"],
["沙利科什維利","sha1li4ke1shi2wei2li4"],
["沙利科什维利","sha1li4ke1shi2wei2li4"]
],
"沟":[
["沟谷","gou1gu3"]
],
"没":[
["没收","mo4shou1"],
["没有","mei2you3"],
["没法","mei2fa3"],
["没药","mo4yao4"],
["没落","mo4luo4"],
["没顶","mo4ding3"],
["没准儿","mei2zhun3r5"],
["没分寸","mei2fen1cun4"],
["没办法","mei2ban4fa5"],
["没完没了","mei2wan2mei2liao3"],
["没药救了","mei2yao4jiu4le5"],
["没齿不忘","mo4chi3bu2wang4"],
["没齿难忘","mo4chi3nan2wang4"]
],
"沣":[
["沣水","feng1shui3"]
],
"沦":[
["沦为","lun2wei2"],
["沦没","lun2mo4"]
],
"沧":[
["沧海","cang1hai3"]
],
"河":[
["河北","he2bei3"],
["河叉","he2cha4"],
["河口","he2kou3"],
["河水","he2shui3"],
["河狸","he2li2"],
["河粉","he2fen3"],
["河谷","he2gu3"],
["河馬","he2ma3"],
["河马","he2ma3"]
],
"沸":[
["沸水","fei4shui3"],
["沸点","fei4dian3"],
["沸點","fei4dian3"]
],
"油":[
["油井","you2jing3"],
["油炸","you2zha2"],
["油餅","you2bing3"],
["油饼","you2bing3"],
["油不渍","you2bu5zi4"],
["油不漬","you2bu5zi4"]
],
"治":[
["治好","zhi4hao3"],
["治本","zhi4ben3"],
["治死","zhi4si3"],
["治理","zhi4li3"],
["治癒","zhi4yu3"],
["治不了","zhi4bu5liao3"],
["治不住","zhi4bu5zhu4"],
["治不好","zhi4bu5hao3"],
["治不服","zhi4bu5fu2"],
["治得了","zhi4de5liao3"]
],
"沾":[
["沾手","zhan1shou3"],
["沾染","zhan1ran3"]
],
"沿":[
["沿儿","yan2r5"],
["沿海","yan2hai3"],
["沿条儿","yan2tiao2r5"],
["沿边儿","yan2bian1r5"]
],
"況":[
["況且","kuang4qie3"]
],
"泄":[
["泄底","xie4di3"],
["泄露","xie4lou4"]
],
"泉":[
["泉水","quan2shui3"],
["泉涌","quan2yong3"],
["泉眼","quan2yan3"]
],
"泊":[
["泊位","bo2wei4"],
["泊車","bo2che1"],
["泊车","bo2che1"]
],
"法":[
["法典","fa3dian3"],
["法场","fa3chang3"],
["法場","fa3chang3"],
["法宝","fa3bao3"],
["法寶","fa3bao3"],
["法海","fa3hai3"],
["法理","fa3li3"],
["法網","fa3wang3"],
["法网","fa3wang3"],
["法老","fa3lao3"],
["法語","fa3yu3"],
["法语","fa3yu3"],
["法律上","fa3lv4shang5"],
["法論功","fa3lun2gong1"],
["法论功","fa3lun2gong1"],
["法隆寺","fa3long1si4"],
["法尔卡什","fa3er3ka3shi2"],
["法爾卡什","fa3er3ka3shi2"]
],
"泗":[
["泗水","si4shui3"]
],
"泛":[
["泛指","fan4zhi3"],
["泛起","fan4qi3"]
],
"泡":[
["泡影","pao4ying3"],
["泡桐","pao1tong2"]
],
"波":[
["波导","bo1dao3"],
["波導","bo1dao3"],
["波罕","bo1han3"],
["波罗","bo1luo5"],
["波羅","bo1luo5"],
["波語","bo1yu3"],
["波譜","bo1pu3"],
["波语","bo1yu3"],
["波谱","bo1pu3"],
["波谷","bo1gu3"],
["波拿巴","bo1na2ba1"],
["波隆那","bo1long1na4"],
["波罗的海","bo1luo2di4hai3"],
["波羅的海","bo1luo2di4hai3"]
],
"泥":[
["泥古","ni4gu3"],
["泥土","ni2tu3"],
["泥子","ni4zi5"],
["泥守","ni4shou3"],
["泥巴","ni2ba1"],
["泥沼","ni2zhao3"],
["泥涂","ni2tu2"],
["泥水匠","ni2shui3jiang4"]
],
"注":[
["注脚","zhu4jiao3"],
["注解","zhu4jie3"]
],
"泪":[
["泪水","lei4shui3"]
],
"泰":[
["泰兴","tai4xing1"],
["泰华","tai4hua4"],
["泰坦","tai4tan3"],
["泰尔","tai4er3"],
["泰斗","tai4dou3"],
["泰法","tai4fa3"],
["泰爾","tai4er3"],
["泰興","tai4xing1"],
["泰華","tai4hua4"],
["泰語","tai4yu3"],
["泰语","tai4yu3"]
],
"泵":[
["泵柄","beng4bing3"]
],
"泷":[
["泷水","long2shui3"]
],
"泸":[
["泸水","lu2shui3"]
],
"泼":[
["泼妇","po1fu4"],
["泼掉","po1diao4"],
["泼辣","po1la5"],
["泼冷水","po1leng3shui3"],
["泼水节","po1shui3jie2"],
["泼烟花","po1yan1hua1"]
],
"泽":[
["泽塔","ze2ta3"],
["泽普","ze2pu3"]
],
"洋":[
["洋务","yang2wu4"],
["洋務","yang2wu4"],
["洋壳","yang2qiao4"],
["洋底","yang2di3"],
["洋殼","yang2qiao4"],
["洋碱","yang2jian3"],
["洋粉","yang2fen3"],
["洋脊","yang2ji3"],
["洋鬼","yang2gui3"],
["洋鹼","yang2jian3"]
],
"洒":[
["洒水","sa3shui3"],
["洒满","sa3man3"],
["洒脱","sa3tuo5"]
],
"洗":[
["洗巴","xi3ba1"],
["洗手","xi3shou3"],
["洗法","xi3fa3"],
["洗澡","xi3zao3"],
["洗珥","xi3er3"],
["洗碗","xi3wan3"],
["洗礼","xi3li3"],
["洗禮","xi3li3"],
["洗脑","xi3nao3"],
["洗脚","xi3jiao3"],
["洗脸","xi3lian3"],
["洗腦","xi3nao3"],
["洗腳","xi3jiao3"],
["洗臉","xi3lian3"],
["洗雪","xi3xue3"],
["洗不掉","xi3bu5diao4"],
["洗不清","xi3bu5qing1"],
["洗发剂","xi3fa4ji4"],
["洗发水","xi3fa4shui3"],
["洗发皂","xi3fa4zao4"],
["洗发露","xi3fa4lu4"],
["洗发水儿","xi3fa4shui3r5"]
],
"洛":[
["洛浦","luo4pu3"],
["洛美","luo4mei3"]
],
"洞":[
["洞口","dong4kou3"]
],
"洣":[
["洣水","mi3shui3"]
],
"洧":[
["洧水","wei3shui3"]
],
"洩":[
["洩底","xie4di3"],
["洩露","xie4lou4"]
],
"洪":[
["洪佛","hong2fo2"],
["洪堡","hong2bao3"],
["洪武","hong2wu3"],
["洪水","hong2shui3"],
["洪雅","hong2ya3"],
["洪都拉斯","hong2du1la1si1"]
],
"洮":[
["洮北","tao2bei3"]
],
"洱":[
["洱海","er3hai3"]
],
"洲":[
["洲府","zhou1fu3"]
],
"洶":[
["洶涌","xiong1yong3"],
["洶湧","xiong1yong3"]
],
"活":[
["活佛","huo2fo2"],
["活儿","huo2r5"],
["活水","huo2shui3"],
["活下來","huo2xia4lai2"],
["活下去","huo2xia4qu4"],
["活下来","huo2xia4lai2"],
["活不了","huo2bu5liao3"],
["活不成","huo2bu5cheng2"],
["活不下去","huo2bu5xia4qu4"]
],
"洼":[
["洼地","wa1di4"]
],
"派":[
["派差","pai4chai1"],
["派往","pai4wang3"],
["派給","pai4gei3"],
["派给","pai4gei3"],
["派遣","pai4qian3"],
["派拉蒙影","pai4la1meng3ying3"]
],
"流":[
["流产","liu2chan3"],
["流体","liu2ti3"],
["流干","liu2gan4"],
["流徙","liu2xi3"],
["流感","liu2gan3"],
["流水","liu2shui3"],
["流淌","liu2tang3"],
["流玛","liu2ma3"],
["流珥","liu2er3"],
["流瑪","liu2ma3"],
["流產","liu2chan3"],
["流盡","liu2jin4"],
["流脑","liu2nao3"],
["流腦","liu2nao3"],
["流覽","liu2lan3"],
["流览","liu2lan3"],
["流體","liu2ti3"],
["流浪兒","liu2lang4er2"],
["流量計","liu2liang4ji4"],
["流量计","liu2liang4ji4"],
["流鼻涕","liu2bi2ti4"],
["流里流气","liu2li5liu2qi4"]
],
"浅":[
["浅显","qian3xian3"],
["浅水","qian3shui3"],
["浅海","qian3hai3"],
["浅短","qian3duan3"],
["浅薄","qian3bo2"],
["浅鲜","qian3xian3"]
],
"浆":[
["浆果","jiang1guo3"]
],
"浇":[
["浇水","jiao1shui3"]
],
"浊":[
["浊酒","zhuo2jiu3"]
],
"测":[
["测量","ce4liang2"],
["测地曲率","ce4di4qu1lv4"]
],
"济":[
["济南","ji3nan2"],
["济济一堂","ji3ji3yi4tang2"]
],
"浏":[
["浏览","liu2lan3"]
],
"浠":[
["浠水","xi1shui3"]
],
"浦":[
["浦北","pu3bei3"],
["浦口","pu3kou3"]
],
"浩":[
["浩淼","hao4miao3"],
["浩渺","hao4miao3"],
["浩浩荡荡","hao4hao5dang4dang4"],
["浩浩蕩蕩","hao4hao5dang4dang4"]
],
"浪":[
["浪头","lang4tou5"],
["浪子","lang4zi3"],
["浪涌","lang4yong3"],
["浪頭","lang4tou5"],
["浪卡子","lang4qia3zi5"],
["浪得虚名","lang4de2xu1ming2"],
["浪得虛名","lang4de2xu1ming2"]
],
"浮":[
["浮想","fu2xiang3"],
["浮点","fu2dian3"],
["浮肿","fu2zhong3"],
["浮腫","fu2zhong3"],
["浮薄","fu2bo2"],
["浮起","fu2qi3"],
["浮點","fu2dian3"],
["浮一大白","fu2yi2da4bai2"]
],
"浴":[
["浴场","yu4chang3"],
["浴場","yu4chang3"]
],
"海":[
["海产","hai3chan3"],
["海兴","hai3xing1"],
["海北","hai3bei3"],
["海参","hai3shen1"],
["海參","hai3shen1"],
["海口","hai3kou3"],
["海地","hai3di4"],
["海岛","hai3dao3"],
["海岭","hai3ling3"],
["海島","hai3dao3"],
["海嶺","hai3ling3"],
["海底","hai3di3"],
["海水","hai3shui3"],
["海法","hai3fa3"],
["海港","hai3gang3"],
["海狗","hai3gou3"],
["海狸","hai3li2"],
["海獭","hai3ta3"],
["海獺","hai3ta3"],
["海產","hai3chan3"],
["海胆","hai3dan3"],
["海膽","hai3dan3"],
["海興","hai3xing1"],
["海草","hai3cao3"],
["海藻","hai3zao3"],
["海角","hai3jiao3"],
["海里","hai3li3"],
["海难","hai3nan4"],
["海難","hai3nan4"],
["海馬","hai3ma3"],
["海马","hai3ma3"],
["海鯉","hai3li3"],
["海鲤","hai3li3"],
["海天一色","hai3tian1yi2se4"]
],
"浸":[
["浸染","jin4ran3"],
["浸沒","jin4mo4"],
["浸没","jin4mo4"],
["浸洗","jin4xi3"],
["浸礼","jin4li3"],
["浸禮","jin4li3"],
["浸种","jin4zhong3"],
["浸種","jin4zhong3"],
["浸不透","jin4bu5tou4"]
],
"涂":[
["涂上","tu2shang4"],
["涂写","tu2xie3"],
["涂家","tu2jia1"],
["涂山","tu2shan1"],
["涂径","tu2jing4"],
["涂抹","tu2mo3"],
["涂掉","tu2diao4"],
["涂敷","tu2fu1"],
["涂料","tu2liao4"],
["涂油","tu2you2"],
["涂装","tu2zhuang1"],
["涂鸦","tu2ya1"],
["涂鸭","tu2ya1"],
["涂尔干","tu2er3gan1"],
["涂爾干","tu2er3gan1"]
],
"涅":[
["涅瓦","nie4wa3"]
],
"消":[
["消停","xiao1ting5"],
["消损","xiao1sun3"],
["消損","xiao1sun3"],
["消暑","xiao1shu3"],
["消泯","xiao1min3"],
["消肿","xiao1zhong3"],
["消腫","xiao1zhong3"],
["消解","xiao1jie3"],
["消遣","xiao1qian3"],
["消長","xiao1zhang3"],
["消长","xiao1zhang3"],
["消隐","xiao1yin3"],
["消隱","xiao1yin3"],
["消闲儿","xiao1xian2r5"],
["消食儿","xiao1shi2r5"]
],
"涉":[
["涉想","she4xiang3"],
["涉水","she4shui3"],
["涉笔","she4bi3"],
["涉筆","she4bi3"],
["涉覽","she4lan3"],
["涉览","she4lan3"],
["涉险","she4xian3"],
["涉險","she4xian3"]
],
"涌":[
["涌上","yong3shang5"],
["涌起","yong3qi3"],
["涌上來","yong3shang4lai5"],
["涌上来","yong3shang4lai5"]
],
"涞":[
["涞水","lai2shui3"]
],
"涟":[
["涟水","lian2shui3"]
],
"润":[
["润笔","run4bi3"],
["润饼","run4bing3"]
],
"涨":[
["涨水","zhang3shui3"],
["涨溢","zhang4yi4"],
["涨满","zhang4man3"],
["涨红","zhang4hong2"]
],
"液":[
["液体","ye4ti3"],
["液體","ye4ti3"]
],
"涵":[
["涵养","han2yang3"],
["涵管","han2guan3"],
["涵養","han2yang3"]
],
"涼":[
["涼快","liang2kuai5"],
["涼水","liang2shui3"],
["涼爽","liang2shuang3"],
["涼在一邊","liang4zai4yi4bian1"]
],
"淀":[
["淀粉","dian4fen3"]
],
"淋":[
["淋巴","lin2ba1"],
["淋灕盡致","lin2li2jin4zhi4"]
],
"淑":[
["淑女","shu1nv3"]
],
"淒":[
["淒惨","qi1can3"],
["淒慘","qi1can3"]
],
"淘":[
["淘洗","tao2xi3"],
["淘选","tao2xuan3"],
["淘選","tao2xuan3"]
],
"淚":[
["淚水","lei4shui3"]
],
"淡":[
["淡水","dan4shui3"],
["淡薄","dan4bo2"],
["淡酒","dan4jiu3"],
["淡不唧儿","dan4bu5ji5r5"],
["淡不唧兒","dan4bu5ji5r5"],
["淡泊寡味","dan4bo2gua3wei4"],
["淡淡一笑","dan4dan4yi2xiao4"]
],
"淤":[
["淤塞","yu1se4"]
],
"淨":[
["淨土","jing4tu3"],
["淨盡","jing4jin4"]
],
"淪":[
["淪沒","lun2mo4"],
["淪為","lun2wei2"]
],
"淫":[
["淫水","yin2shui3"],
["淫猥","yin2wei3"],
["淫辱","yin2ru3"],
["淫鬼","yin2gui3"]
],
"淬":[
["淬火","cui4huo3"]
],
"淮":[
["淮北","huai2bei3"]
],
"淯":[
["淯水","yu4shui3"]
],
"深":[
["深井","shen1jing3"],
["深广","shen1guang3"],
["深廣","shen1guang3"],
["深得","shen1de2"],
["深感","shen1gan3"],
["深水","shen1shui3"],
["深浅","shen1qian3"],
["深海","shen1hai3"],
["深淺","shen1qian3"],
["深港","shen1gang3"],
["深省","shen1xing3"],
["深表","shen1biao3"],
["深谷","shen1gu3"],
["深远","shen1yuan3"],
["深遠","shen1yuan3"],
["深醒","shen1xing3"],
["深恶痛绝","shen1wu4tong4jue2"],
["深惡痛絕","shen1wu4tong4jue2"]
],
"淳":[
["淳朴","chun2pu3"],
["淳樸","chun2pu3"]
],
"淵":[
["淵藪","yuan1sou3"]
],
"淶":[
["淶水","lai2shui3"]
],
"混":[
["混汞","hun4gong3"],
["混淆","hun4xiao2"],
["混矇","hun4meng1"],
["混紡","hun4fang3"],
["混纺","hun4fang3"],
["混蒙","hun4meng1"],
["混蛋","hun2dan4"],
["混行","hun2xing2"],
["混跡","hun4ji4"],
["混迹","hun4ji4"],
["混一混","hun4yi2hun4"],
["混不上","hun4bu5shang4"],
["混名儿","hun4ming2r5"],
["混混儿","hun4hun4r5"],
["混血兒","hun4xue4er2"],
["混不下去","hun4bu5xia4qu5"],
["混不过去","hun4bu5guo4qu5"],
["混不過去","hun4bu5guo4qu5"],
["混为一体","hun2wei2yi4ti3"],
["混为一谈","hun4wei2yi4tan2"],
["混水摸魚","hun2shui3mo1yu2"],
["混水摸鱼","hun2shui3mo1yu2"],
["混為一談","hun4wei2yi4tan2"],
["混為一體","hun2wei2yi4ti3"]
],
"淹":[
["淹死","yan1si3"],
["淹沒","yan1mo4"],
["淹没","yan1mo4"]
],
"淺":[
["淺水","qian3shui3"],
["淺海","qian3hai3"],
["淺短","qian3duan3"],
["淺薄","qian3bo2"],
["淺顯","qian3xian3"],
["淺鮮","qian3xian3"]
],
"添":[
["添补","tian1bu5"],
["添補","tian1bu5"],
["添不起","tian1bu5qi3"]
],
"清":[
["清党","qing1dang3"],
["清剿","qing1jiao3"],
["清扫","qing1sao3"],
["清掃","qing1sao3"],
["清早","qing1zao3"],
["清晨","qing1chen2"],
["清朗","qing1lang3"],
["清水","qing1shui3"],
["清洗","qing1xi3"],
["清澄","qing1cheng2"],
["清点","qing1dian3"],
["清爽","qing1shuang3"],
["清理","qing1li3"],
["清还","qing1huan2"],
["清远","qing1yuan3"],
["清遠","qing1yuan3"],
["清還","qing1huan2"],
["清酒","qing1jiu3"],
["清醒","qing1xing3"],
["清點","qing1dian3"],
["清黨","qing1dang3"],
["清一色","qing1yi2se4"],
["清道夫","qing1dao4fu1"],
["清清楚楚","qing1qing5chu3chu3"]
],
"渊":[
["渊薮","yuan1sou3"]
],
"渑":[
["渑池","mian3chi2"]
],
"渔":[
["渔场","yu2chang3"],
["渔夫","yu2fu1"],
["渔港","yu2gang3"],
["渔网","yu2wang3"],
["渔鼓","yu2gu3"],
["渔人得利","yu2ren2de2li4"]
],
"渗":[
["渗水","shen4shui3"],
["渗人得慌","shen4ren2de2huang1"]
],
"減":[
["減免","jian3mian3"],
["減小","jian3xiao3"],
["減少","jian3shao3"],
["減法","jian3fa3"],
["減產","jian3chan3"],
["減緩","jian3huan3"]
],
"渝":[
["渝水","yu2shui3"]
],
"渡":[
["渡假","du4jia4"],
["渡口","du4kou3"],
["渡海","du4hai3"]
],
"渣":[
["渣滓","zha1zi3"]
],
"渤":[
["渤海","bo2hai3"]
],
"温":[
["温岭","wen1ling3"],
["温差","wen1cha1"],
["温暖","wen1nuan3"],
["温网","wen1wang3"],
["温蔼","wen1ai3"],
["温雅","wen1ya3"],
["温饱","wen1bao3"],
["温得和克","wen1de2he2ke4"],
["温情脉脉","wen1qing2mo4mo4"]
],
"測":[
["測量","ce4liang2"],
["測地曲率","ce4di4qu1lv4"]
],
"渭":[
["渭水","wei4shui3"]
],
"港":[
["港口","gang3kou3"],
["港府","gang3fu3"],
["港股","gang3gu3"],
["港务局","gang3wu4ju2"],
["港務局","gang3wu4ju2"]
],
"渲":[
["渲染","xuan4ran3"]
],
"渴":[
["渴死","ke3si3"]
],
"游":[
["游手","you2shou3"],
["游水","you2shui3"],
["游泳","you2yong3"],
["游艇","you2ting3"],
["游走","you2zou3"],
["游隼","you2sun3"],
["游手好閑","you2shou3hao4xian2"],
["游手好闲","you2shou3hao4xian2"],
["游行队伍","you2xing2dui4wu3"],
["游行隊伍","you2xing2dui4wu3"]
],
"渺":[
["渺子","miao3zi3"],
["渺小","miao3xiao3"]
],
"湊":[
["湊合","cou4he5"],
["湊巧","cou4qiao3"],
["湊手","cou4shou3"],
["湊不上","cou4bu5shang4"]
],
"湖":[
["湖北","hu2bei3"],
["湖口","hu2kou3"],
["湖广","hu2guang3"],
["湖廣","hu2guang3"],
["湖沼","hu2zhao3"],
["湖海","hu2hai3"]
],
"湟":[
["湟水","huang2shui3"]
],
"湮":[
["湮沒","yan1mo4"],
["湮没","yan1mo4"],
["湮滅","yin1mie4"],
["湮灭","yin1mie4"]
],
"湯":[
["湯匙","tang1chi2"],
["湯姆","tang1mu3"],
["湯碗","tang1wan3"]
],
"湾":[
["湾仔","wan1zai3"],
["湾里","wan1li3"]
],
"湿":[
["湿土","shi1tu3"],
["湿地","shi1di4"],
["湿疹","shi1zhen3"]
],
"溆":[
["溆浦","xu4pu3"]
],
"源":[
["源於","yuan2yu2"],
["源点","yuan2dian3"],
["源點","yuan2dian3"]
],
"準":[
["準將","zhun3jiang4"],
["準得","zhun3dei3"],
["準許","zhun3xu3"],
["準不準","zhun3bu5zhun3"]
],
"溜":[
["溜走","liu1zou3"],
["溜达","liu1da5"],
["溜達","liu1da5"],
["溜边儿","liu1bian1r5"]
],
"溝":[
["溝谷","gou1gu3"]
],
"溢":[
["溢水","yi4shui3"],
["溢满","yi4man3"],
["溢滿","yi4man3"]
],
"溧":[
["溧水","li4shui3"]
],
"溪":[
["溪水","xi1shui3"],
["溪谷","xi1gu3"]
],
"溫":[
["溫嶺","wen1ling3"],
["溫差","wen1cha1"],
["溫暖","wen1nuan3"],
["溫網","wen1wang3"],
["溫藹","wen1ai3"],
["溫雅","wen1ya3"],
["溫飽","wen1bao3"],
["溫得和克","wen1de2he2ke4"],
["溫情脈脈","wen1qing2mo4mo4"]
],
"溶":[
["溶体","rong2ti3"],
["溶解","rong2jie3"],
["溶體","rong2ti3"]
],
"溺":[
["溺愛","ni4ai4"],
["溺水","ni4shui3"],
["溺爱","ni4ai4"]
],
"滄":[
["滄海","cang1hai3"]
],
"滅":[
["滅沒","mie4mo4"],
["滅火","mie4huo3"],
["滅跡","mie4ji4"]
],
"滇":[
["滇藏","dian1zang4"]
],
"滋":[
["滋养","zi1yang3"],
["滋扰","zi1rao3"],
["滋擾","zi1rao3"],
["滋蔓","zi1man4"],
["滋补","zi1bu3"],
["滋補","zi1bu3"],
["滋長","zi1zhang3"],
["滋长","zi1zhang3"],
["滋養","zi1yang3"]
],
"滎":[
["滎經","ying2jing1"]
],
"滑":[
["滑倒","hua2dao3"],
["滑板","hua2ban3"],
["滑水","hua2shui3"],
["滑溜","hua2liu5"],
["滑稽","hua2ji5"],
["滑雪","hua2xue3"],
["滑鼠","hua2shu3"],
["滑溜溜","hua2liu1liu1"],
["滑不叽溜","hua2bu5ji1liu1"],
["滑不嘰溜","hua2bu5ji1liu1"],
["滑了一跤","hua2le5yi4jiao1"]
],
"滚":[
["滚上","gun3shang5"],
["滚水","gun3shui3"],
["滚滚","gun3gun3"],
["滚筒","gun3tong3"],
["滚不了","gun3bu5liao3"],
["滚出去","gun3chu1qu4"]
],
"满":[
["满口","man3kou3"],
["满嘴","man3zui3"],
["满地","man3di4"],
["满垒","man3lei3"],
["满手","man3shou3"],
["满拧","man3ning3"],
["满满","man3man3"],
["满点","man3dian3"],
["满眼","man3yan3"],
["满脸","man3lian3"],
["满语","man3yu3"],
["满酒","man3jiu3"],
["满口应承","man3kou3ying4cheng2"]
],
"滤":[
["滤纸","lv4zhi3"],
["滤网","lv4wang3"],
["滤饼","lv4bing3"]
],
"滨":[
["滨海","bin1hai3"]
],
"滲":[
["滲水","shen4shui3"],
["滲人得慌","shen4ren2de2huang1"]
],
"滴":[
["滴水","di1shui3"],
["滴答","di1da5"],
["滴管","di1guan3"]
],
"滷":[
["滷法","lu3fa3"]
],
"滾":[
["滾上","gun3shang5"],
["滾水","gun3shui3"],
["滾滾","gun3gun3"],
["滾筒","gun3tong3"],
["滾不了","gun3bu5liao3"],
["滾出去","gun3chu1qu4"]
],
"滿":[
["滿口","man3kou3"],
["滿嘴","man3zui3"],
["滿地","man3di4"],
["滿壘","man3lei3"],
["滿手","man3shou3"],
["滿擰","man3ning3"],
["滿滿","man3man3"],
["滿眼","man3yan3"],
["滿臉","man3lian3"],
["滿語","man3yu3"],
["滿酒","man3jiu3"],
["滿點","man3dian3"],
["滿洲裡","man3zhou1li3"],
["滿口應承","man3kou3ying4cheng2"],
["滿城盡帶黃金甲","man3cheng2jin4dai4huang2jin1jia3"]
],
"漁":[
["漁場","yu2chang3"],
["漁夫","yu2fu1"],
["漁港","yu2gang3"],
["漁網","yu2wang3"],
["漁鼓","yu2gu3"],
["漁人得利","yu2ren2de2li4"]
],
"漂":[
["漂亮","piao4liang5"],
["漂去","piao1qu4"],
["漂泊","piao1bo2"],
["漂洗","piao3xi3"],
["漂流","piao1liu2"],
["漂浮","piao1fu2"],
["漂游","piao1you2"],
["漂白","piao3bai2"],
["漂移","piao1yi2"],
["漂荡","piao1dang4"],
["漂蕩","piao1dang4"],
["漂遊","piao1you2"]
],
"漏":[
["漏斗","lou4dou3"],
["漏水","lou4shui3"],
["漏雨","lou4yu3"]
],
"演":[
["演武","yan3wu3"],
["演講","yan3jiang3"],
["演讲","yan3jiang3"]
],
"漢":[
["漢口","han4kou3"],
["漢堡","han4bao3"],
["漢水","han4shui3"],
["漢語","han4yu3"]
],
"漣":[
["漣水","lian2shui3"]
],
"漯":[
["漯河","luo4he2"]
],
"漲":[
["漲水","zhang3shui3"],
["漲溢","zhang4yi4"],
["漲滿","zhang4man3"],
["漲紅","zhang4hong2"]
],
"漳":[
["漳浦","zhang1pu3"]
],
"漵":[
["漵浦","xu4pu3"]
],
"漿":[
["漿果","jiang1guo3"]
],
"潇":[
["潇洒","xiao1sa3"]
],
"潍":[
["潍坊","wei2fang1"]
],
"潑":[
["潑婦","po1fu4"],
["潑掉","po1diao4"],
["潑辣","po1la5"],
["潑冷水","po1leng3shui3"],
["潑水節","po1shui3jie2"],
["潑煙花","po1yan1hua1"]
],
"潛":[
["潛影","qian2ying3"],
["潛水","qian2shui3"],
["潛沒","qian2mo4"],
["潛泳","qian2yong3"],
["潛艇","qian2ting3"],
["潛鳥","qian2niao3"],
["潛意識","qian2yi4shi2"],
["潛水夫病","qian2shui3fu1bing4"],
["潛水夫癥","qian2shui3fu1zheng4"]
],
"潜":[
["潜影","qian2ying3"],
["潜水","qian2shui3"],
["潜没","qian2mo4"],
["潜泳","qian2yong3"],
["潜艇","qian2ting3"],
["潜鸟","qian2niao3"],
["潜意识","qian2yi4shi2"],
["潜水夫病","qian2shui3fu1bing4"],
["潜水夫症","qian2shui3fu1zheng4"]
],
"潤":[
["潤筆","run4bi3"],
["潤餅","run4bing3"]
],
"潦":[
["潦倒","liao2dao3"],
["潦草","liao2cao3"]
],
"潭":[
["潭水","tan2shui3"]
],
"潮":[
["潮水","chao2shui3"],
["潮涌","chao2yong3"],
["潮解","chao2jie3"]
],
"澄":[
["澄城","cheng2cheng2"],
["澄江","cheng2jiang1"],
["澄海","cheng2hai3"],
["澄清","cheng2qing1"],
["澄迈","cheng2mai4"],
["澄邁","cheng2mai4"]
],
"澆":[
["澆水","jiao1shui3"]
],
"澎":[
["澎湃","peng2pai4"],
["澎湖群岛","peng2hu2qun2dao3"],
["澎湖群島","peng2hu2qun2dao3"]
],
"澠":[
["澠池","mian3chi2"]
],
"澤":[
["澤塔","ze2ta3"],
["澤普","ze2pu3"]
],
"澧":[
["澧水","li3shui3"]
],
"澱":[
["澱粉","dian4fen3"]
],
"澳":[
["澳紐","ao4niu3"],
["澳纽","ao4niu3"]
],
"激":[
["激打","ji1da3"],
["激起","ji1qi3"],
["激不起","ji1bu5qi3"]
],
"濁":[
["濁酒","zhuo2jiu3"]
],
"濒":[
["濒死","bin1si3"],
["濒海","bin1hai3"]
],
"濕":[
["濕土","shi1tu3"],
["濕地","shi1di4"],
["濕疹","shi1zhen3"]
],
"濟":[
["濟南","ji3nan2"],
["濟濟一堂","ji3ji3yi4tang2"]
],
"濰":[
["濰坊","wei2fang1"]
],
"濱":[
["濱海","bin1hai3"]
],
"濾":[
["濾紙","lv4zhi3"],
["濾網","lv4wang3"],
["濾餅","lv4bing3"]
],
"瀍":[
["瀍水","chan2shui3"]
],
"瀏":[
["瀏覽","liu2lan3"]
],
"瀕":[
["瀕於","bin1yu2"],
["瀕死","bin1si3"],
["瀕海","bin1hai3"]
],
"瀘":[
["瀘水","lu2shui3"]
],
"瀟":[
["瀟灑","xiao1sa3"]
],
"瀧":[
["瀧水","long2shui3"]
],
"灃":[
["灃水","feng1shui3"]
],
"灑":[
["灑水","sa3shui3"],
["灑滿","sa3man3"],
["灑脫","sa3tuo5"]
],
"灣":[
["灣仔","wan1zai3"],
["灣裡","wan1li3"]
],
"火":[
["火儿","huo3r5"],
["火剪","huo3jian3"],
["火把","huo3ba3"],
["火种","huo3zhong3"],
["火種","huo3zhong3"],
["火腿","huo3tui3"],
["火警","huo3jing3"],
["火烧火燎","huo3shao1huo3liao3"],
["火燒火燎","huo3shao1huo3liao3"]
],
"灭":[
["灭没","mie4mo4"],
["灭火","mie4huo3"],
["灭迹","mie4ji4"]
],
"灯":[
["灯塔","deng1ta3"],
["灯火","deng1huo3"],
["灯盏","deng1zhan3"],
["灯笼","deng1long5"],
["灯管","deng1guan3"]
],
"灰":[
["灰領","hui1ling3"],
["灰领","hui1ling3"],
["灰不啦唧","hui1bu5la1ji1"],
["灰不溜丟","hui1bu5liu1diu1"],
["灰不溜丢","hui1bu5liu1diu1"],
["灰不溜秋","hui1bu5liu1qiu1"],
["灰心丧气","hui1xin1sang4qi4"],
["灰心喪氣","hui1xin1sang4qi4"],
["灰一灰房子","hui1yi4hui1fang2zi5"]
],
"灵":[
["灵塔","ling2ta3"],
["灵宝","ling2bao3"],
["灵巧","ling2qiao3"],
["灵感","ling2gan3"],
["灵敏","ling2min3"],
["灵武","ling2wu3"],
["灵语","ling2yu3"],
["灵性上","ling2xing4shang5"],
["灵长目","ling2zhang3mu4"],
["灵长类","ling2zhang3lei4"]
],
"灶":[
["灶王","zao4wang5"]
],
"災":[
["災難","zai1nan4"],
["災難性","zai1nan4xing5"]
],
"灾":[
["灾难","zai1nan4"],
["灾难性","zai1nan4xing5"]
],
"炉":[
["炉火","lu2huo3"],
["炉长","lu2zhang3"]
],
"炭":[
["炭火","tan4huo3"]
],
"炮":[
["炮塔","pao4ta3"],
["炮手","pao4shou3"],
["炮火","pao4huo3"],
["炮艇","pao4ting3"]
],
"炯":[
["炯炯","jiong3jiong3"]
],
"炸":[
["炸死","zha4si3"],
["炸毀","zha4hui3"],
["炸毁","zha4hui3"],
["炸燬","zha4hui3"],
["炸糕","zha2gao1"],
["炸雞","zha2ji1"],
["炸魚","zha2yu2"],
["炸鱼","zha2yu2"],
["炸鸡","zha2ji1"],
["炸丸子","zha2wan2zi5"],
["炸子雞","zha2zi3ji1"],
["炸子鸡","zha2zi3ji1"],
["炸油餅","zha2you2bing3"],
["炸油饼","zha2you2bing3"],
["炸薯条","zha2shu3tiao2"],
["炸薯條","zha2shu3tiao2"],
["炸酱面","zha2jiang4mian4"],
["炸醬麵","zha2jiang4mian4"],
["炸土豆条","zha2tu3dou4tiao2"],
["炸土豆條","zha2tu3dou4tiao2"],
["炸土豆片","zha2tu3dou4pian1"]
],
"点":[
["点儿","dian3r5"],
["点卯","dian3mao3"],
["点将","dian3jiang4"],
["点心","dian3xin5"],
["点拨","dian3bo5"],
["点染","dian3ran3"],
["点检","dian3jian3"],
["点水","dian3shui3"],
["点火","dian3huo3"],
["点点","dian3dian3"],
["点着","dian3zhao2"],
["点睛","dian3jing1"],
["点补","dian3bu5"],
["点起","dian3qi3"],
["点不着","dian3bu5zhao2"],
["点点头","dian3dian5tou2"],
["点起来","dian3qi3lai5"],
["点头一笑","dian3tou2yi2xiao4"]
],
"為":[
["為主","wei2zhu3"],
["為人","wei2ren2"],
["為伍","wei2wu3"],
["為例","wei2li4"],
["為善","wei2shan4"],
["為害","wei2hai4"],
["為己","wei4ji3"],
["為幸","wei2xing4"],
["為患","wei2huan4"],
["為惡","wei2e4"],
["為憑","wei2ping2"],
["為我","wei4wo3"],
["為時","wei2shi2"],
["為期","wei2qi1"],
["為業","wei2ye4"],
["為榮","wei2rong2"],
["為止","wei2zhi3"],
["為此","wei4ci3"],
["為準","wei2zhun3"],
["為生","wei2sheng1"],
["為證","wei2zheng4"],
["為道","wei2dao4"],
["為重","wei2zhong4"],
["為難","wei2nan2"],
["為頭","wei2tou2"],
["為首","wei2shou3"],
["為之一振","wei4zhi1yi2zhen4"],
["為之一新","wei2zhi1yi4xin1"],
["為仁不富","wei2ren2bu2fu4"],
["為富不仁","wei2fu4bu4ren2"],
["為德不卒","wei2de2bu4zu2"],
["為德不終","wei2de2bu4zhong1"],
["為所欲為","wei2suo3yu4wei2"],
["為非作歹","wei2fei1zuo4dai3"]
],
"炼":[
["炼乳","lian4ru3"],
["炼铁","lian4tie3"]
],
"烂":[
["烂崽","lan4zai3"],
["烂掉","lan4diao5"]
],
"烈":[
["烈属","lie4shu3"],
["烈屬","lie4shu3"],
["烈火","lie4huo3"],
["烈酒","lie4jiu3"]
],
"烏":[
["烏什","wu1shi2"],
["烏卡","wu1ka3"],
["烏欖","wu1lan3"],
["烏法","wu1fa3"],
["烏海","wu1hai3"],
["烏爾","wu4er3"],
["烏瑪","wu1ma3"],
["烏語","wu1yu3"],
["烏鱧","wu1li3"],
["烏斯地","wu1si1di4"],
["烏爾姆","wu1er3mu3"],
["烏良哈","wu1liang2ha3"],
["烏蘭夫","wu1lan2fu1"],
["烏黎雅","wu1li1ya3"],
["烏蘭巴托","wu1lan2ba1tuo1"],
["烏蘭察布市","wu1lan4cha2bu4shi4"]
],
"烘":[
["烘乾","hong1gan1"],
["烘染","hong1ran3"],
["烘烤","hong1kao3"],
["烘笼儿","hong1long2r5"]
],
"烙":[
["烙餅","lao4bing3"],
["烙饼","lao4bing3"]
],
"烟":[
["烟厂","yan1chang3"],
["烟海","yan1hai3"],
["烟火","yan1huo3"],
["烟瘾","yan1yin3"],
["烟碱","yan1jian3"],
["烟筒","yan1tong5"],
["烟草","yan1cao3"],
["烟鬼","yan1gui3"],
["烟卷儿","yan1juan3r5"],
["烟燻火燎","yan1xun1huo3liao3"],
["烟花行院","yan1hua1hang2yuan4"]
],
"烤":[
["烤火","kao3huo3"],
["烤熟","kao3shou2"],
["烤餅","kao3bing3"],
["烤饼","kao3bing3"]
],
"烦":[
["烦恼","fan2nao3"],
["烦扰","fan2rao3"],
["烦琐","fan2suo3"]
],
"烧":[
["烧卖","shao1mai5"],
["烧死","shao1si3"],
["烧毁","shao1hui3"],
["烧火","shao1huo3"],
["烧烤","shao1kao3"],
["烧煮","shao1zhu3"],
["烧燬","shao1hui3"],
["烧着","shao1zhao2"],
["烧碱","shao1jian3"],
["烧纸","shao1zhi3"],
["烧酒","shao1jiu3"],
["烧饼","shao1bing5"],
["烧不熟","shao1bu5shou2"],
["烧不着","shao1bu5zhao2"],
["烧得慌","shao1de5huang5"]
],
"烫":[
["烫发","tang4fa4"],
["烫一烫","tang4yi2tang4"],
["烫不着","tang4bu5zhao2"]
],
"热":[
["热和","re4huo5"],
["热导","re4dao3"],
["热岛","re4dao3"],
["热捧","re4peng3"],
["热水","re4shui3"],
["热点","re4dian3"],
["热狗","re4gou3"],
["热补","re4bu3"],
["热闹","re4nao5"],
["热饮","re4yin3"],
["热乎乎","re4hu1hu1"]
],
"烹":[
["烹調","peng1tiao2"],
["烹调","peng1tiao2"]
],
"烽":[
["烽火","feng1huo3"]
],
"焉":[
["焉得","yan1de2"]
],
"焙":[
["焙乾","bei4gan1"],
["焙烤","bei4kao3"],
["焙粉","bei4fen3"]
],
"焚":[
["焚毀","fen2hui3"],
["焚毁","fen2hui3"]
],
"無":[
["無可","wu2ke3"],
["無品","wu2pin3"],
["無幾","wu2ji3"],
["無底","wu2di3"],
["無恥","wu2chi3"],
["無我","wu2wo3"],
["無損","wu2sun3"],
["無有","wu2you3"],
["無比","wu2bi3"],
["無氧","wu2yang3"],
["無水","wu2shui3"],
["無法","wu2fa3"],
["無為","wu2wei2"],
["無爪","wu2zhua3"],
["無理","wu2li3"],
["無禮","wu2li3"],
["無稽","wu2ji1"],
["無著","wu2zhuo2"],
["無補","wu2bu3"],
["無軌","wu2gui3"],
["無間","wu2jian4"],
["無怪乎","wu2guai4hu1"],
["無患子","wu2huan4zi3"],
["無意識","wu2yi4shi2"],
["無一不備","wu2yi2bu2bei4"],
["無一不精","wu2yi2bu4jing1"],
["無一不能","wu2yi2bu4neng2"],
["無一不通","wu2yi2bu4tong1"],
["無兒無女","wu2er2wu2nv3"],
["無動於衷","wu2dong4yu2zhong1"],
["無地自容","wu2di4zi4rong2"],
["無徵不信","wu2zheng1bu2xin4"],
["無愧於心","wu2kui4yu2xin1"],
["無所不為","wu2suo3bu4wei2"],
["無濟於事","wu2ji4yu2shi4"],
["無的放矢","wu2di4fang4shi3"],
["無盡無休","wu2jin4wu2xiu1"],
["無知無識","wu2zhi1wu2shi2"],
["無窮無盡","wu2qiong2wu2jin4"],
["無求備於一人","wu2qiu2bei4yu2yi4ren2"]
],
"焦":[
["焦土","jiao1tu3"],
["焦点","jiao1dian3"],
["焦耳","jiao1er3"],
["焦點","jiao1dian3"]
],
"焰":[
["焰火","yan4huo3"]
],
"然":[
["然也","ran2ye3"]
],
"煉":[
["煉乳","lian4ru3"],
["煉鐵","lian4tie3"]
],
"煎":[
["煎炸","jian1zha2"],
["煎餃","jian1jiao3"],
["煎饺","jian1jiao3"]
],
"煙":[
["煙廠","yan1chang3"],
["煙海","yan1hai3"],
["煙火","yan1huo3"],
["煙癮","yan1yin3"],
["煙筒","yan1tong5"],
["煙草","yan1cao3"],
["煙鬼","yan1gui3"],
["煙鹼","yan1jian3"],
["煙燻火燎","yan1xun1huo3liao3"],
["煙花行院","yan1hua1hang2yuan4"]
],
"煞":[
["煞住","sha1zhu4"],
["煞尾","sha1wei3"],
["煞气","sha1qi4"],
["煞氣","sha1qi4"],
["煞笔","sha1bi3"],
["煞筆","sha1bi3"],
["煞賬","sha1zhang4"],
["煞账","sha1zhang4"],
["煞車","sha1che1"],
["煞车","sha1che1"],
["煞性子","sha1xing4zi5"],
["煞風景","sha1feng1jing3"],
["煞风景","sha1feng1jing3"]
],
"煦":[
["煦暖","xu4nuan3"]
],
"照":[
["照准","zhao4zhun3"],
["照应","zhao4ying5"],
["照得","zhao4de2"],
["照應","zhao4ying5"],
["照理","zhao4li3"],
["照相","zhao4xiang4"],
["照眼","zhao4yan3"],
["照管","zhao4guan3"],
["照顧","zhao4gu5"],
["照顾","zhao4gu5"]
],
"煩":[
["煩惱","fan2nao3"],
["煩擾","fan2rao3"],
["煩瑣","fan2suo3"]
],
"煮":[
["煮熟","zhu3shou2"]
],
"熄":[
["熄火","xi1huo3"]
],
"熊":[
["熊掌","xiong2zhang3"],
["熊本","xiong2ben3"]
],
"熏":[
["熏染","xun1ran3"],
["熏烤","xun1kao3"]
],
"熔":[
["熔点","rong2dian3"],
["熔解","rong2jie3"],
["熔點","rong2dian3"]
],
"熙":[
["熙壤","xi1rang3"]
],
"熟":[
["熟地","shu2di4"],
["熟手","shu2shou3"],
["熟稔","shu2ren3"],
["熟語","shou2yu3"],
["熟语","shou2yu3"],
["熟鐵","shu2tie3"],
["熟铁","shu2tie3"],
["熟道儿","shu2dao4r5"]
],
"熨":[
["熨斗","yun4dou3"]
],
"熬":[
["熬稃","ao1fu1"],
["熬不住","ao2bu5zhu4"],
["熬不过","ao2bu5guo4"],
["熬不過","ao2bu5guo4"]
],
"熱":[
["熱和","re4huo5"],
["熱導","re4dao3"],
["熱島","re4dao3"],
["熱捧","re4peng3"],
["熱水","re4shui3"],
["熱狗","re4gou3"],
["熱補","re4bu3"],
["熱飲","re4yin3"],
["熱鬧","re4nao5"],
["熱點","re4dian3"],
["熱乎乎","re4hu1hu1"]
],
"燃":[
["燃点","ran2dian3"],
["燃起","ran2qi3"],
["燃點","ran2dian3"],
["燃灯佛","ran2deng1fo2"],
["燃燈佛","ran2deng1fo2"]
],
"燄":[
["燄火","yan4huo3"]
],
"燈":[
["燈塔","deng1ta3"],
["燈火","deng1huo3"],
["燈盞","deng1zhan3"],
["燈管","deng1guan3"],
["燈籠","deng1long5"]
],
"燒":[
["燒乾","shao1gan1"],
["燒死","shao1si3"],
["燒毀","shao1hui3"],
["燒火","shao1huo3"],
["燒烤","shao1kao3"],
["燒煮","shao1zhu3"],
["燒燬","shao1hui3"],
["燒盡","shao1jin4"],
["燒紙","shao1zhi3"],
["燒著","shao1zhao2"],
["燒賣","shao1mai5"],
["燒酒","shao1jiu3"],
["燒餅","shao1bing5"],
["燒鹼","shao1jian3"],
["燒不熟","shao1bu5shou2"],
["燒不著","shao1bu5zhao2"],
["燒得慌","shao1de5huang5"]
],
"燕":[
["燕京","yan1jing1"],
["燕山","yan1shan1"],
["燕赵","yan1zhao4"],
["燕趙","yan1zhao4"],
["燕太子丹","yan1tai4zi3dan1"],
["燕雀乌鹊","yan4que4wu1que4"],
["燕雀处堂","yan4que4chu3tang2"],
["燕雀烏鵲","yan4que4wu1que4"],
["燕雀處堂","yan4que4chu3tang2"]
],
"營":[
["營口","ying2kou3"],
["營地","ying2di4"],
["營壘","ying2lei3"],
["營養","ying2yang3"]
],
"爆":[
["爆冷","bao4leng3"],
["爆满","bao4man3"],
["爆滿","bao4man3"],
["爆管","bao4guan3"],
["爆冷门儿","bao4leng3men2r5"]
],
"爐":[
["爐火","lu2huo3"],
["爐長","lu2zhang3"]
],
"爛":[
["爛崽","lan4zai3"],
["爛掉","lan4diao5"]
],
"爪":[
["爪儿","zhua3r5"],
["爪兒","zhua3r5"],
["爪哇","zhao3wa1"],
["爪子","zhua3zi5"],
["爪尖儿","zhua3jian1r5"],
["爪尖兒","zhua3jian1r5"]
],
"爭":[
["爭取","zheng1qu3"],
["爭吵","zheng1chao3"],
["爭寵","zheng1chong3"],
["爭得","zheng1de2"],
["爭競","zheng1jing5"],
["爭不來","zheng1bu5lai2"],
["爭不到","zheng1bu5dao4"]
],
"爱":[
["爱人","ai4ren5"],
["爱女","ai4nv3"],
["爱好","ai4hao4"],
["爱子","ai4zi3"],
["爱抚","ai4fu3"],
["爱玛","ai4ma3"],
["爱乐乐团","ai4yue4yue4tuan2"],
["爱人如己","ai4ren2ru2ji3"],
["爱民如子","ai4min2ru2zi3"]
],
"父":[
["父亲","fu4qin5"],
["父子","fu4zi3"],
["父母","fu4mu3"],
["父老","fu4lao3"],
["父親","fu4qin5"],
["父亲节","fu4qin1jie2"],
["父親節","fu4qin1jie2"]
],
"爷":[
["爷爷","ye2ye5"]
],
"爸":[
["爸爸","ba4ba5"]
],
"爺":[
["爺爺","ye2ye5"]
],
"爽":[
["爽口","shuang3kou3"],
["爽当","shuang3dang4"],
["爽快","shuang3kuai5"],
["爽朗","shuang3lang3"],
["爽當","shuang3dang4"],
["爽爽快快","shuang3shuang3kuai4kuai4"]
],
"爾":[
["爾雅","er3ya3"]
],
"牆":[
["牆腳","qiang2jiao3"],
["牆角","qiang2jiao3"]
],
"片":[
["片儿","pian1r5"],
["片兒","pian1r5"],
["片名","pian1ming2"],
["片子","pian1zi5"],
["片語","pian4yu3"],
["片语","pian4yu3"]
],
"版":[
["版主","ban3zhu3"],
["版本","ban3ben3"]
],
"牌":[
["牌匾","pai2bian3"],
["牌坊","pai2fang1"],
["牌楼","pai2lou5"],
["牌樓","pai2lou5"]
],
"牒":[
["牒譜","die2pu3"],
["牒谱","die2pu3"]
],
"牙":[
["牙齒","ya2chi3"],
["牙齿","ya2chi3"]
],
"牛":[
["牛仔","niu2zai3"],
["牛奶","niu2nai3"],
["牛尾","niu2wei3"],
["牛柳","niu2liu3"],
["牛腩","niu2nan3"],
["牛飲","niu2yin3"],
["牛饮","niu2yin3"],
["牛馬","niu2ma3"],
["牛马","niu2ma3"],
["牛肉乾","niu2rou4gan1"],
["牛脊肉","niu2ji3rou4"]
],
"牝":[
["牝馬","pin4ma3"],
["牝马","pin4ma3"]
],
"牟":[
["牟取","mou2qu3"],
["牟平区","mu4ping2qu1"],
["牟平區","mu4ping2qu1"]
],
"牡":[
["牡丹","mu3dan5"],
["牡馬","mu3ma3"],
["牡马","mu3ma3"],
["牡丹坊","mu3dan1fang1"]
],
"牢":[
["牢靠","lao2kao5"]
],
"牧":[
["牧养","mu4yang3"],
["牧场","mu4chang3"],
["牧場","mu4chang3"],
["牧师","mu4shi5"],
["牧師","mu4shi5"],
["牧者","mu4zhe3"],
["牧草","mu4cao3"],
["牧養","mu4yang3"],
["牧夫座","mu4fu1zuo4"]
],
"物":[
["物主","wu4zhu3"],
["物产","wu4chan3"],
["物体","wu4ti3"],
["物品","wu4pin3"],
["物理","wu4li3"],
["物產","wu4chan3"],
["物种","wu4zhong3"],
["物種","wu4zhong3"],
["物體","wu4ti3"]
],
"牲":[
["牲口","sheng1kou5"]
],
"牵":[
["牵引","qian1yin3"],
["牵强","qian1qiang3"],
["牵手","qian1shou3"],
["牵扯","qian1che3"],
["牵累","qian1lei3"]
],
"特":[
["特产","te4chan3"],
["特使","te4shi3"],
["特免","te4mian3"],
["特写","te4xie3"],
["特地","te4di4"],
["特寫","te4xie3"],
["特徵","te4zheng1"],
["特指","te4zhi3"],
["特有","te4you3"],
["特此","te4ci3"],
["特点","te4dian3"],
["特瓦","te4wa3"],
["特產","te4chan3"],
["特种","te4zhong3"],
["特種","te4zhong3"],
["特等","te4deng3"],
["特許","te4xu3"],
["特調","te4tiao2"],
["特警","te4jing3"],
["特许","te4xu3"],
["特调","te4tiao2"],
["特起","te4qi3"],
["特輯","te4ji2"],
["特辑","te4ji2"],
["特點","te4dian3"],
["特別是","te4bie2shi5"],
["特别是","te4bie2shi5"],
["特拉維夫","te4la1wei2fu1"],
["特拉维夫","te4la1wei2fu1"],
["特古西加尔巴","te4gu3xi1jia1er3ba1"],
["特古西加爾巴","te4gu3xi1jia1er3ba1"]
],
"牽":[
["牽引","qian1yin3"],
["牽強","qian1qiang3"],
["牽手","qian1shou3"],
["牽扯","qian1che3"],
["牽累","qian1lei3"],
["牽一髮而動全身","qian1yi2fa4er2dong4quan2shen1"]
],
"犀":[
["犀鳥","xi1niao3"],
["犀鸟","xi1niao3"]
],
"犁":[
["犁地","li2di4"],
["犁头","li2tou5"],
["犁頭","li2tou5"],
["犁骨","li2gu3"]
],
"犄":[
["犄角","ji1jiao3"]
],
"犍":[
["犍为","qian2wei4"],
["犍為","qian2wei4"]
],
"犬":[
["犬齒","quan3chi3"],
["犬齿","quan3chi3"]
],
"犯":[
["犯法","fan4fa3"],
["犯不上","fan4bu5shang4"],
["犯不着","fan4bu5zhao2"],
["犯不著","fan4bu5zhao2"],
["犯得上","fan4de5shang4"],
["犯得着","fan4de5zhao2"],
["犯得著","fan4de5zhao2"]
],
"状":[
["状元","zhuang4yuan5"],
["状语","zhuang4yu3"]
],
"犹":[
["犹底","you2di3"],
["犹甲","you2jia3"],
["犹地亚","you2di4ya4"],
["犹士都","you2shi4du1"]
],
"狀":[
["狀元","zhuang4yuan5"],
["狀語","zhuang4yu3"]
],
"狂":[
["狂喜","kuang2xi3"],
["狂欢","kuang2huan1"],
["狂歡","kuang2huan1"],
["狂野","kuang2ye3"],
["狂飲","kuang2yin3"],
["狂饮","kuang2yin3"],
["狂想曲","kuang2xiang3qu3"],
["狂飲大嚼","kuang2yin3da4jiao4"],
["狂饮大嚼","kuang2yin3da4jiao4"]
],
"狗":[
["狗屎","gou3shi3"]
],
"狠":[
["狠狠","hen3hen3"]
],
"独":[
["独体","du2ti3"],
["独处","du2chu3"],
["独夫","du2fu1"],
["独子","du2zi3"],
["独岛","du2dao3"],
["独得","du2de2"],
["独揽","du2lan3"],
["独有","du2you3"],
["独眼","du2yan3"],
["独胆","du2dan3"],
["独舞","du2wu3"],
["独语","du2yu3"],
["独一词","du2yi4ci2"],
["独院儿","du2yuan4r5"],
["独一全智","du2yi4quan2zhi4"],
["独创一格","du2chuang4yi4ge2"],
["独树一帜","du2shu4yi2zhi4"],
["独在异乡为异客","du2zai4yi4xiang1wei2yi4ke4"]
],
"狭":[
["狭小","xia2xiao3"],
["狭窄","xia2zhai3"],
["狭谷","xia2gu3"]
],
"狮":[
["狮吼","shi1hou3"]
],
"狸":[
["狸子","li2zi5"],
["狸猫","li2mao1"],
["狸貓","li2mao1"]
],
"狹":[
["狹小","xia2xiao3"],
["狹窄","xia2zhai3"],
["狹谷","xia2gu3"]
],
"狼":[
["狼井","lang2jing3"],
["狼崽","lang2zai3"],
["狼狗","lang2gou3"],
["狼号鬼哭","lang2hao2gui3ku1"],
["狼子野心","lang2zi3ye3xin1"],
["狼狈为奸","lang2bei4wei2jian1"],
["狼狽為奸","lang2bei4wei2jian1"],
["狼號鬼哭","lang2hao2gui3ku1"]
],
"猎":[
["猎取","lie4qu3"],
["猎手","lie4shou3"],
["猎犬","lie4quan3"],
["猎狗","lie4gou3"]
],
"猜":[
["猜中","cai1zhong4"],
["猜度","cai1duo2"],
["猜想","cai1xiang3"],
["猜不着","cai1bu5zhao2"],
["猜不著","cai1bu5zhao2"],
["猜不透","cai1bu5tou4"],
["猜謎兒","cai1mi2er5"],
["猜谜儿","cai1mi2er5"]
],
"猞":[
["猞猁","she1li4"]
],
"猩":[
["猩猩","xing1xing5"]
],
"猪":[
["猪狗","zhu1gou3"]
],
"猫":[
["猫儿","mao1r5"]
],
"献":[
["献上","xian4shang5"],
["献礼","xian4li3"],
["献给","xian4gei3"]
],
"猶":[
["猶底","you2di3"],
["猶甲","you2jia3"],
["猶地亞","you2di4ya4"],
["猶士都","you2shi4du1"]
],
"獅":[
["獅吼","shi1hou3"]
],
"獎":[
["獎品","jiang3pin3"],
["獎賞","jiang3shang3"],
["獎酬","jiang3chou2"]
],
"獒":[
["獒犬","ao2quan3"]
],
"獨":[
["獨夫","du2fu1"],
["獨子","du2zi3"],
["獨島","du2dao3"],
["獨得","du2de2"],
["獨攬","du2lan3"],
["獨有","du2you3"],
["獨眼","du2yan3"],
["獨膽","du2dan3"],
["獨舞","du2wu3"],
["獨處","du2chu3"],
["獨語","du2yu3"],
["獨體","du2ti3"],
["獨一詞","du2yi4ci2"],
["獨一全智","du2yi4quan2zhi4"],
["獨創一格","du2chuang4yi4ge2"],
["獨樹一幟","du2shu4yi2zhi4"],
["獨在異鄉為異客","du2zai4yi4xiang1wei2yi4ke4"]
],
"獲":[
["獲取","huo4qu3"],
["獲得","huo4de2"],
["獲準","huo4zhun3"],
["獲獎","huo4jiang3"],
["獲選","huo4xuan3"]
],
"獵":[
["獵取","lie4qu3"],
["獵手","lie4shou3"],
["獵犬","lie4quan3"],
["獵狗","lie4gou3"]
],
"獻":[
["獻上","xian4shang5"],
["獻禮","xian4li3"],
["獻給","xian4gei3"]
],
"玄":[
["玄奘","xuan2zang4"],
["玄武","xuan2wu3"],
["玄理","xuan2li3"],
["玄远","xuan2yuan3"],
["玄遠","xuan2yuan3"]
],
"率":[
["率先","shuai4xian1"],
["率直","shuai4zhi2"],
["率領","shuai4ling3"],
["率领","shuai4ling3"],
["率兽食人","shuai4shou4shi2ren2"],
["率尔操觚","shuai4er3cao1gu1"],
["率爾操觚","shuai4er3cao1gu1"],
["率獸食人","shuai4shou4shi2ren2"],
["率由卓章","shuai4you2zhuo2zhang1"],
["率由旧章","shuai4you2jiu4zhang1"],
["率由舊章","shuai4you2jiu4zhang1"]
],
"玉":[
["玉米","yu4mi3"],
["玉髓","yu4sui3"],
["玉夫座","yu4fu1zuo4"],
["玉米粉","yu4mi5fen3"],
["玉素甫","yu4su4fu3"]
],
"王":[
["王储","wang2chu3"],
["王儲","wang2chu3"],
["王八","wang2ba5"],
["王冠","wang2guan1"],
["王子","wang2zi3"],
["王导","wang2dao3"],
["王導","wang2dao3"],
["王府","wang2fu3"],
["王母","wang2mu3"],
["王水","wang2shui3"],
["王法","wang2fa3"],
["王猛","wang2meng3"],
["王码","wang2ma3"],
["王碼","wang2ma3"],
["王者","wang2zhe3"],
["王莽","wang2mang3"],
["王著","wang2zhu4"],
["王选","wang2xuan3"],
["王選","wang2xuan3"],
["王义夫","wang2yi4fu1"],
["王仙芝","wang2xian1zhi1"],
["王夫之","wang2fu1zhi1"],
["王实甫","wang2shi2fu3"],
["王實甫","wang2shi2fu3"],
["王義夫","wang2yi4fu1"]
],
"玛":[
["玛坦","ma3tan3"],
["玛塔","ma3ta3"],
["玛曲","ma3qu3"],
["玛比","ma3bi3"],
["玛瑙","ma3nao3"],
["玛艾","ma3yi4"],
["玛哈拉","ma3ha1la1"],
["玛奇朵","ma3qi2duo3"],
["玛得缅","ma3de2mian3"],
["玛得米那","ma3de2mi3na4"]
],
"玩":[
["玩偶","wan2ou3"],
["玩儿","wan2r5"],
["玩火","wan2huo3"],
["玩索","wan2suo3"],
["玩者","wan2zhe3"],
["玩耍","wan2shua3"],
["玩賞","wan2shang3"],
["玩赏","wan2shang3"],
["玩不轉","wan2bu5zhuan4"],
["玩不转","wan2bu5zhuan4"],
["玩意儿","wan2yi4r5"],
["玩儿不转","wan2r5bu2zhuan4"],
["玩儿得转","wan2r5de5zhuan4"],
["玩兒不轉","wan2r5bu2zhuan4"],
["玩兒得轉","wan2r5de5zhuan4"]
],
"玫":[
["玫瑰","mei2gui5"],
["玫瑰不管叫啥名","mei2gui1bu4guan3jiao4sha2ming2"]
],
"环":[
["环保","huan2bao3"],
["环岛","huan2dao3"],
["环法","huan2fa3"]
],
"现":[
["现场","xian4chang3"],
["现有","xian4you3"],
["现款","xian4kuan3"]
],
"玷":[
["玷辱","dian4ru3"]
],
"玻":[
["玻璃","bo1li5"]
],
"珊":[
["珊玛","shan1ma3"],
["珊瑪","shan1ma3"]
],
"珍":[
["珍品","zhen1pin3"],
["珍奶","zhen1nai3"],
["珍宝","zhen1bao3"],
["珍寶","zhen1bao3"]
],
"珠":[
["珠宝","zhu1bao3"],
["珠寶","zhu1bao3"],
["珠海","zhu1hai3"]
],
"班":[
["班底","ban1di3"],
["班玛","ban1ma3"],
["班瑪","ban1ma3"],
["班禪","ban1chan2"],
["班組","ban1zu3"],
["班组","ban1zu3"],
["班長","ban1zhang3"],
["班长","ban1zhang3"],
["班务会","ban1wu4hui4"],
["班務會","ban1wu4hui4"],
["班辈儿","ban1bei4r5"]
],
"現":[
["現場","xian4chang3"],
["現有","xian4you3"],
["現款","xian4kuan3"]
],
"球":[
["球场","qiu2chang3"],
["球場","qiu2chang3"],
["球差","qiu2cha1"],
["球感","qiu2gan3"],
["球網","qiu2wang3"],
["球网","qiu2wang3"]
],
"琅":[
["琅玡","lang2ye2"]
],
"理":[
["理发","li3fa4"],
["理想","li3xiang3"],
["理睬","li3cai3"],
["理解","li3jie3"],
["理事長","li3shi4zhang3"],
["理事长","li3shi4zhang3"],
["理論上","li3lun4shang5"],
["理论上","li3lun4shang5"]
],
"琉":[
["琉璃","liu2li5"],
["琉璃塔","liu2li2ta3"]
],
"琐":[
["琐巴","suo3ba1"],
["琐法","suo3fa3"],
["琐珥","suo3er3"],
["琐比巴","suo3bi3ba1"],
["琐罗亚斯特","suo3luo1ya4si1te4"]
],
"琢":[
["琢磨","zhuo2mo2"]
],
"琴":[
["琴手","qin2shou3"],
["琴瑟不調","qin2se4bu4tiao2"],
["琴瑟不调","qin2se4bu4tiao2"]
],
"琵":[
["琵珥","pi2er3"],
["琵琶","pi2pa5"]
],
"琼":[
["琼海","qiong2hai3"]
],
"瑙":[
["瑙魯","nao3lu3"],
["瑙鲁","nao3lu3"]
],
"瑞":[
["瑞典","rui4dian3"],
["瑞雪","rui4xue3"]
],
"瑣":[
["瑣巴","suo3ba1"],
["瑣法","suo3fa3"],
["瑣珥","suo3er3"],
["瑣比巴","suo3bi3ba1"],
["瑣羅亞斯特","suo3luo1ya4si1te4"]
],
"瑪":[
["瑪坦","ma3tan3"],
["瑪塔","ma3ta3"],
["瑪曲","ma3qu3"],
["瑪比","ma3bi3"],
["瑪瑙","ma3nao3"],
["瑪艾","ma3yi4"],
["瑪哈拉","ma3ha1la1"],
["瑪奇朵","ma3qi2duo3"],
["瑪得緬","ma3de2mian3"],
["瑪得米那","ma3de2mi3na4"]
],
"瑰":[
["瑰伟","gui1wei3"],
["瑰偉","gui1wei3"],
["瑰宝","gui1bao3"],
["瑰寶","gui1bao3"],
["瑰玮","gui1wei3"],
["瑰瑋","gui1wei3"]
],
"瑾":[
["瑾琐","jin3suo3"],
["瑾瑣","jin3suo3"]
],
"璧":[
["璧还","bi4huan2"],
["璧還","bi4huan2"]
],
"環":[
["環保","huan2bao3"],
["環島","huan2dao3"],
["環法","huan2fa3"]
],
"瓊":[
["瓊海","qiong2hai3"]
],
"瓜":[
["瓜子","gua1zi3"],
["瓜葛","gua1ge2"],
["瓜达拉哈拉","gua1da2la1ha1la1"],
["瓜達拉哈拉","gua1da2la1ha1la1"]
],
"瓦":[
["瓦解","wa3jie3"],
["瓦德西","wa3ee2xi1"],
["瓦裡斯","wa3li3si1"],
["瓦西裡","wa3xi1li3"]
],
"瓶":[
["瓶頸","ping2jing3"],
["瓶颈","ping2jing3"]
],
"甘":[
["甘地","gan1di4"],
["甘於","gan1yu2"],
["甘汞","gan1gong3"],
["甘美","gan1mei3"],
["甘苦","gan1ku3"],
["甘草","gan1cao3"],
["甘薯","gan1shu3"],
["甘谷","gan1gu3"]
],
"甚":[
["甚且","shen4qie3"],
["甚为","shen4wei2"],
["甚于","shen4yu2"],
["甚多","shen4duo1"],
["甚巨","shen4ju4"],
["甚或","shen4huo4"],
["甚於","shen4yu2"],
["甚浓","shen4nong2"],
["甚濃","shen4nong2"],
["甚為","shen4wei2"],
["甚而","shen4er2"],
["甚至","shen4zhi4"],
["甚鉅","shen4ju4"],
["甚钜","shen4ju4"],
["甚麽","shen2me5"],
["甚至於","shen4zhi4yu2"],
["甚高頻","shen4gao1pin2"],
["甚高频","shen4gao1pin2"],
["甚嚣尘上","shen4xiao1chen2shang4"],
["甚囂塵上","shen4xiao1chen2shang4"],
["甚感詫異","shen4gan3cha4yi4"],
["甚感诧异","shen4gan3cha4yi4"]
],
"甜":[
["甜品","tian2pin3"],
["甜水","tian2shui3"],
["甜点","tian2dian3"],
["甜筒","tian2tong3"],
["甜美","tian2mei3"],
["甜酒","tian2jiu3"],
["甜點","tian2dian3"],
["甜不唧","tian2bu5ji1"],
["甜不唧儿","tian2bu5ji1r5"]
],
"生":[
["生为","sheng1wei2"],
["生产","sheng1chan3"],
["生养","sheng1yang3"],
["生土","sheng1tu3"],
["生子","sheng1zi3"],
["生息","sheng1xi1"],
["生意","sheng1yi5"],
["生於","sheng1yu2"],
["生日","sheng1ri5"],
["生死","sheng1si3"],
["生母","sheng1mu3"],
["生水","sheng1shui3"],
["生火","sheng1huo3"],
["生為","sheng1wei2"],
["生理","sheng1li3"],
["生產","sheng1chan3"],
["生米","sheng1mi3"],
["生苔","sheng1tai2"],
["生还","sheng1huan2"],
["生還","sheng1huan2"],
["生鐵","sheng1tie3"],
["生铁","sheng1tie3"],
["生長","sheng1zhang3"],
["生长","sheng1zhang3"],
["生養","sheng1yang3"],
["生下來","sheng1xia4lai2"],
["生下来","sheng1xia4lai2"],
["生卒年","sheng1zu2nian2"],
["生詞語","sheng1ci2yu2"],
["生词语","sheng1ci2yu2"],
["生兒育女","sheng1er2yu4nv3"],
["生日快乐","sheng1ri4kuai4le4"],
["生日快樂","sheng1ri4kuai4le4"],
["生活費用","sheng1huo2fei4yong4"],
["生活费用","sheng1huo2fei4yong4"]
],
"產":[
["產仔","chan3zi3"],
["產假","chan3jia4"],
["產兒","chan3er2"],
["產卵","chan3luan3"],
["產品","chan3pin3"],
["產地","chan3di4"],
["產不出","chan3bu5chu1"]
],
"甥":[
["甥女","sheng1nv3"]
],
"甦":[
["甦醒","su1xing3"]
],
"用":[
["用主","yong4zhu3"],
["用以","yong4yi3"],
["用品","yong4pin3"],
["用地","yong4di4"],
["用处","yong4chu5"],
["用头","yong4tou5"],
["用於","yong4yu2"],
["用武","yong4wu3"],
["用水","yong4shui3"],
["用法","yong4fa3"],
["用盡","yong4jin4"],
["用處","yong4chu5"],
["用語","yong4yu3"],
["用语","yong4yu3"],
["用頭","yong4tou5"],
["用不了","yong4bu5liao3"],
["用不完","yong4bu5wan2"],
["用不得","yong4bu5de2"],
["用不惯","yong4bu5guan4"],
["用不慣","yong4bu5guan4"],
["用不着","yong4bu5zhao2"],
["用不著","yong4bu5zhao2"],
["用不起","yong4bu5qi3"],
["用出來","yong4chu5lai5"],
["用出来","yong4chu5lai5"],
["用得了","yong4de5liao3"],
["用得着","yong4de5zhao2"],
["用得著","yong4de5zhao2"]
],
"甩":[
["甩尾","shuai3wei3"],
["甩不开","shuai3bu5kai1"],
["甩不掉","shuai3bu5diao4"],
["甩不脫","shuai3bu5tuo1"],
["甩不脱","shuai3bu5tuo1"],
["甩不開","shuai3bu5kai1"],
["甩出去","shuai3chu1qu4"]
],
"田":[
["田主","tian2zhu3"],
["田产","tian2chan3"],
["田地","tian2di4"],
["田產","tian2chan3"],
["田里","tian2li3"],
["田野","tian2ye3"],
["田鼠","tian2shu3"]
],
"由":[
["由你","you2ni3"],
["由於","you2yu2"],
["由此","you2ci3"],
["由不了","you2bu5liao3"],
["由不得","you2bu5de5"]
],
"甲":[
["甲乙","jia3yi3"],
["甲午","jia3wu3"],
["甲壳","jia3qiao4"],
["甲子","jia3zi3"],
["甲板","jia3ban3"],
["甲殼","jia3qiao4"],
["甲等","jia3deng3"],
["甲苯","jia3ben3"],
["甲鎧","jia3kai3"],
["甲铠","jia3kai3"],
["甲長","jia3zhang3"],
["甲长","jia3zhang3"],
["甲骨","jia3gu3"],
["甲仙乡","jia3xian1xiang1"],
["甲仙鄉","jia3xian1xiang1"],
["甲壳类","jia3ke2lei4"],
["甲殼類","jia3ke2lei4"],
["甲壳虫类","jia3ke2chong2lei4"],
["甲殼蟲類","jia3ke2chong2lei4"]
],
"申":[
["申曲","shen1qu3"],
["申理","shen1li3"],
["申討","shen1tao3"],
["申訴","shen1su4"],
["申請","shen1qing3"],
["申讨","shen1tao3"],
["申诉","shen1su4"],
["申请","shen1qing3"],
["申雪","shen1xue3"],
["申領","shen1ling3"],
["申领","shen1ling3"]
],
"电":[
["电厂","dian4chang3"],
["电场","dian4chang3"],
["电子","dian4zi3"],
["电导","dian4dao3"],
["电影","dian4ying3"],
["电感","dian4gan3"],
["电打","dian4da3"],
["电泳","dian4yong3"],
["电缆","dian4lan3"],
["电脑","dian4nao3"],
["电荷","dian4he4"],
["电表","dian4biao3"],
["电解","dian4jie3"],
["电钮","dian4niu3"],
["电阻","dian4zu3"],
["电线杆","dian4xian4gan1"],
["电荷量","dian4he2liang4"]
],
"男":[
["男女","nan2nv3"],
["男子","nan2zi3"],
["男孩儿","nan2hai2r5"],
["男女老少","nan2nv3lao3shao4"],
["男扮女装","nan2ban4nv3zhuang1"],
["男扮女裝","nan2ban4nv3zhuang1"]
],
"画":[
["画儿","hua4r5"],
["画卷","hua4juan4"],
["画展","hua4zhan3"],
["画荻教子","hua4di2jiao1zi3"]
],
"畅":[
["畅想","chang4xiang3"],
["畅饮","chang4yin3"]
],
"界":[
["界尺","jie4chi3"],
["界首","jie4shou3"]
],
"留":[
["留守","liu2shou3"],
["留影","liu2ying3"],
["留种","liu2zhong3"],
["留種","liu2zhong3"],
["留空","liu2kong4"],
["留給","liu2gei3"],
["留给","liu2gei3"],
["留都","liu2du1"],
["留难","liu2nan4"],
["留難","liu2nan4"],
["留飲","liu2yin3"],
["留饮","liu2yin3"],
["留鳥","liu2niao3"],
["留鸟","liu2niao3"],
["留不住","liu2bu5zhu4"],
["留学生","liu2xue2sheng1"],
["留學生","liu2xue2sheng1"],
["留成儿","liu2cheng2r5"],
["留连论诗","liu2lian2lun4shi2"],
["留連論詩","liu2lian2lun4shi2"]
],
"畜":[
["畜牧","xu4mu4"],
["畜牲","chu4sheng5"],
["畜生","chu4sheng5"],
["畜产品","xu4chan3pin3"],
["畜產品","xu4chan3pin3"]
],
"畢":[
["畢甲","bi4jia3"],
["畢宿五","bi4xiu4wu3"],
["畢尼奧夫","bi4ni2ao4fu1"],
["畢爾巴鄂","bi4er3ba1e4"],
["畢其功於一役","bi4qi2gong1yu2yi2yi4"]
],
"略":[
["略为","lve4wei2"],
["略举","lve4ju3"],
["略為","lve4wei2"],
["略码","lve4ma3"],
["略碼","lve4ma3"],
["略舉","lve4ju3"],
["略語","lve4yu3"],
["略语","lve4yu3"],
["略一过目","lve4yi2guo4mu4"],
["略一過目","lve4yi2guo4mu4"],
["略識之無","lve4shi2zhi1wu2"],
["略识之无","lve4shi2zhi1wu2"]
],
"番":[
["番禺","pan1yu2"],
["番茄","fan1qie2"],
["番薯","fan1shu3"]
],
"畫":[
["畫卷","hua4juan4"],
["畫展","hua4zhan3"],
["畫荻教子","hua4di2jiao1zi3"]
],
"畬":[
["畬族","she1zu2"]
],
"異":[
["異地","yi4di4"],
["異彩","yi4cai3"],
["異母","yi4mu3"],
["異種","yi4zhong3"],
["異體","yi4ti3"],
["異乎尋常","yi4hu1xun2chang2"]
],
"當":[
["當上","dang1shang5"],
["當作","dang4zuo4"],
["當做","dang4zuo4"],
["當地","dang1di4"],
["當場","dang1chang3"],
["當天","dang4tian1"],
["當成","dang4cheng2"],
["當晚","dang4wan3"],
["當月","dang4yue4"],
["當涂","dang1tu2"],
["當為","dang1wei2"],
["當真","dang4zhen1"],
["當選","dang1xuan3"],
["當鋪","dang4pu4"],
["當不了","dang1bu5liao3"],
["當回事","dang4hui2shi4"],
["當得了","dang1de5liao3"],
["當務之急","dang1wu4zhi1ji2"],
["當頭一棒","dang1tou2yi2bang4"]
],
"畹":[
["畹町","wan3ting3"]
],
"疆":[
["疆土","jiang1tu3"],
["疆场","jiang1chang3"],
["疆場","jiang1chang3"]
],
"疊":[
["疊起","die2qi3"]
],
"疏":[
["疏剪","shu1jian3"],
["疏导","shu1dao3"],
["疏導","shu1dao3"],
["疏忽","shu1hu5"],
["疏率","shu1shuai4"],
["疏理","shu1li3"],
["疏解","shu1jie3"],
["疏远","shu1yuan3"],
["疏遠","shu1yuan3"],
["疏忽大意","shu1hu1da4yi4"],
["疏忽职守","shu1hu1zhi2shou3"],
["疏忽職守","shu1hu1zhi2shou3"],
["疏於防範","shu1yu2fang2fan4"]
],
"疑":[
["疑点","yi2dian3"],
["疑點","yi2dian3"]
],
"疗":[
["疗养","liao2yang3"],
["疗法","liao2fa3"]
],
"疟":[
["疟疾","nve4ji5"],
["疟蚊","nve4wen2"],
["疟原虫","nve4yuan2chong2"]
],
"疱":[
["疱疹","pao4zhen3"]
],
"疲":[
["疲軟","pi2ruan3"],
["疲软","pi2ruan3"]
],
"疼":[
["疼死","teng2si3"]
],
"疾":[
["疾苦","ji2ku3"],
["疾走","ji2zou3"],
["疾風知勁草","ji2feng1zhi1jin4cao3"],
["疾风知劲草","ji2feng1zhi1jin4cao3"]
],
"病":[
["病倒","bing4dao3"],
["病假","bing4jia4"],
["病友","bing4you3"],
["病夫","bing4fu1"],
["病徵","bing4zheng1"],
["病死","bing4si3"],
["病沒","bing4mo4"],
["病没","bing4mo4"],
["病理","bing4li3"],
["病癒","bing4yu3"],
["病包儿","bing4bao1r5"]
],
"症":[
["症候","zheng4hou5"],
["症结","zheng1jie2"],
["症候群","zheng4hou4qun2"]
],
"痊":[
["痊癒","quan2yu3"]
],
"痒":[
["痒痒","yang3yang5"]
],
"痕":[
["痕跡","hen2ji4"],
["痕迹","hen2ji4"]
],
"痛":[
["痛快","tong4kuai5"],
["痛恶","tong4wu4"],
["痛悔","tong4hui3"],
["痛惡","tong4wu4"],
["痛感","tong4gan3"],
["痛打","tong4da3"],
["痛楚","tong4chu3"],
["痛苦","tong4ku3"],
["痛飲","tong4yin3"],
["痛饮","tong4yin3"],
["痛哭一场","tong4ku1yi4chang3"],
["痛哭一場","tong4ku1yi4chang3"],
["痛得蝎虎","tong4de5xie1hu5"],
["痛快一时","tong4kuai4yi4shi2"],
["痛快一時","tong4kuai4yi4shi2"],
["痛痛快快","tong4tong5kuai4kuai4"]
],
"痢":[
["痢疾","li4ji5"]
],
"痲":[
["痲疹","ma2zhen3"]
],
"痴":[
["痴呆","chi1ai2"],
["痴呆症","chi1dai1zheng4"],
["痴呆癥","chi1dai1zheng4"]
],
"瘧":[
["瘧疾","nve4ji5"],
["瘧蚊","nve4wen2"],
["瘧原蟲","nve4yuan2chong2"]
],
"瘪":[
["瘪三","bie1san1"]
],
"瘫":[
["瘫软","tan1ruan3"]
],
"瘸":[
["瘸腿","que2tui3"]
],
"療":[
["療法","liao2fa3"],
["療養","liao2yang3"]
],
"癖":[
["癖好","pi3hao4"]
],
"癟":[
["癟三","bie1san1"]
],
"癢":[
["癢癢","yang3yang5"]
],
"癥":[
["癥候","zheng4hou5"],
["癥結","zheng1jie2"],
["癥候群","zheng4hou4qun2"]
],
"癱":[
["癱軟","tan1ruan3"]
],
"癸":[
["癸丑","gui3chou3"],
["癸卯","gui3mao3"],
["癸酉","gui3you3"]
],
"登":[
["登场","deng1chang3"],
["登場","deng1chang3"],
["登載","deng1zai3"],
["登载","deng1zai3"],
["登高一呼","deng1gao1yi4hu1"]
],
"發":[
["發冷","fa1leng3"],
["發喪","fa1sang1"],
["發展","fa1zhan3"],
["發往","fa1wang3"],
["發怔","fa1zheng4"],
["發憷","fa1chu4"],
["發抖","fa1dou3"],
["發泡","fa1pao2"],
["發火","fa1huo3"],
["發癢","fa1yang3"],
["發窘","fa1jiong3"],
["發給","fa1gei3"],
["發表","fa1biao3"],
["發起","fa1qi3"],
["發跡","fa1ji4"],
["發軟","fa1ruan3"],
["發難","fa1nan4"],
["發顫","fa1zhan4"],
["發不了","fa1bu5liao3"],
["發出來","fa1chu1lai2"],
["發源地","fa1yuan2di4"],
["發燒友","fa1shao1you3"],
["發現號","fa1xian4hao2"],
["發祥地","fa1xiang2di4"],
["發明創造","fa1ming2chuang1zao4"]
],
"白":[
["白体","bai2ti3"],
["白佛","bai2fo2"],
["白净","bai2jing5"],
["白凈","bai2jing5"],
["白匪","bai2fei3"],
["白卷","bai2juan4"],
["白发","bai2fa4"],
["白地","bai2di4"],
["白拣","bai2jian3"],
["白揀","bai2jian3"],
["白朗","bai2lang3"],
["白朮","bai2zhu2"],
["白术","bai2zhu2"],
["白朴","bai2pu3"],
["白板","bai2ban3"],
["白果","bai2guo3"],
["白樸","bai2pu3"],
["白死","bai2si3"],
["白水","bai2shui3"],
["白眼","bai2yan3"],
["白种","bai2zhong3"],
["白種","bai2zhong3"],
["白米","bai2mi3"],
["白粉","bai2fen3"],
["白給","bai2gei3"],
["白给","bai2gei3"],
["白脸","bai2lian3"],
["白臉","bai2lian3"],
["白薯","bai2shu3"],
["白虎","bai2hu3"],
["白蚁","bai2yi3"],
["白蟻","bai2yi3"],
["白術","bai2zhu2"],
["白起","bai2qi3"],
["白酒","bai2jiu3"],
["白鐵","bai2tie3"],
["白铁","bai2tie3"],
["白雪","bai2xue3"],
["白領","bai2ling3"],
["白领","bai2ling3"],
["白骨","bai2gu3"],
["白體","bai2ti3"],
["白鬼","bai2gui3"],
["白不了","bai2bu5liao3"],
["白乾兒","bai2gan1r5"],
["白兰地","bai2lan2di4"],
["白干儿","bai2gan1r5"],
["白班儿","bai2ban1r5"],
["白白地","bai2bai2de5"],
["白蘭地","bai2lan2di4"],
["白蛇传","bai2she2zhuan4"],
["白蛇傳","bai2she2zhuan4"],
["白不呲咧","bai2bu5ci1lie1"],
["白旄黃鉞","bai2mao2huang2yue4"],
["白旄黄钺","bai2mao2huang2yue4"],
["白眼珠儿","bai2yan3zhu1r5"],
["白馬王子","bai2ma3wang2zi5"],
["白马王子","bai2ma3wang2zi5"]
],
"百":[
["百米","bai3mi3"],
["百色","bo2se4"],
["百几个","bai3ji3ge4"],
["百夫長","bai3fu1zhang3"],
["百夫长","bai3fu1zhang3"],
["百幾個","bai3ji3ge4"],
["百日咳","bai3ri4ke2"],
["百儿八十","bai3r5ba1shi2"],
["百发百中","bai3fa1bai3zhong4"],
["百密一疏","bai3mi4yi4shu1"],
["百废俱兴","bai3fei4ju4xing1"],
["百度百科","bai3du4bai3ke4"],
["百廢俱興","bai3fei4ju4xing1"],
["百无一失","bai3wu2yi4shi1"],
["百无一精","bai3wu2yi4jing1"],
["百无一能","bai3wu2yi4neng2"],
["百无一长","bai3wu2yi4chang2"],
["百無一失","bai3wu2yi4shi1"],
["百無一精","bai3wu2yi4jing1"],
["百無一能","bai3wu2yi4neng2"],
["百無一長","bai3wu2yi4chang2"],
["百發百中","bai3fa1bai3zhong4"],
["百裡挑一","bai3li3tiao1yi1"],
["百聞不如一見","bai3wen2bu4ru2yi2jian4"],
["百闻不如一见","bai3wen2bu4ru2yi2jian4"]
],
"皂":[
["皂碱","zao4jian3"],
["皂鹼","zao4jian3"]
],
"的":[
["的地","de5di4"],
["的士","di2shi4"],
["的当","di2dang4"],
["的當","di2dang4"],
["的确","di2que4"],
["的確","di2que4"],
["的地壳","de5di4qiao4"],
["的地方","de5di4fang5"],
["的地殼","de5di4qiao4"],
["的黎波裡","de5li2bo1li3"]
],
"皆":[
["皆可","jie1ke3"]
],
"皇":[
["皇上","huang2shang5"],
["皇储","huang2chu3"],
["皇儲","huang2chu3"],
["皇冠","huang2guan1"],
["皇历","huang2li5"],
["皇古","huang2gu3"],
["皇子","huang2zi3"],
["皇曆","huang2li5"],
["皇甫","huang2fu3"],
["皇馬","huang2ma3"],
["皇马","huang2ma3"],
["皇亲国戚","huang2qin1guo2qi1"],
["皇親國戚","huang2qin1guo2qi1"]
],
"皓":[
["皓首","hao4shou3"],
["皓齒","hao4chi3"],
["皓齿","hao4chi3"]
],
"皮":[
["皮儿","pi2er5"],
["皮兒","pi2er5"],
["皮疹","pi2zhen3"],
["皮艇","pi2ting3"],
["皮草","pi2cao3"],
["皮鞋匠","pi2xie2jiang4"],
["皮諾切特","pi2nuo4qie1te4"],
["皮诺切特","pi2nuo4qie1te4"]
],
"皰":[
["皰疹","pao4zhen3"]
],
"盆":[
["盆地","pen2di4"],
["盆景","pen2jing3"]
],
"益":[
["益处","yi4chu5"],
["益處","yi4chu5"]
],
"盐":[
["盐井","yan2jing3"],
["盐卤","yan2lu3"],
["盐海","yan2hai3"],
["盐碱","yan2jian3"],
["盐谷","yan2gu3"],
["盐碱地","yan2jian3di4"],
["盐酸克仑特罗","yan2suan1ke4lun2te4luo1"]
],
"监":[
["监管","jian1guan3"],
["监考","jian1kao3"],
["监狱长","jian1yu4zhang3"]
],
"盔":[
["盔甲","kui1jia3"]
],
"盖":[
["盖上","gai4shang5"],
["盖儿","gai4r5"],
["盖好","gai4hao3"],
["盖尔","gai4er3"],
["盖革计数器","ge3ge2ji4shu4qi4"]
],
"盗":[
["盗匪","dao4fei3"],
["盗取","dao4qu3"],
["盗版","dao4ban3"]
],
"盘":[
["盘古","pan2gu3"],
["盘碗","pan2wan3"],
["盘算","pan2suan5"],
["盘腿","pan2tui3"],
["盘锦","pan2jin3"]
],
"盛":[
["盛举","sheng4ju3"],
["盛产","sheng4chan3"],
["盛典","sheng4dian3"],
["盛景","sheng4jing3"],
["盛產","sheng4chan3"],
["盛舉","sheng4ju3"]
],
"盜":[
["盜匪","dao4fei3"],
["盜取","dao4qu3"],
["盜版","dao4ban3"]
],
"盟":[
["盟友","meng2you3"]
],
"盡":[
["盡信","jin4xin4"],
["盡力","jin4li4"],
["盡心","jin4xin1"],
["盡忠","jin4zhong1"],
["盡快","jin4kuai4"],
["盡情","jin4qing2"],
["盡早","jin4zao3"],
["盡是","jin4shi4"],
["盡管","jin3guan3"],
["盡興","jin4xing4"],
["盡責","jin4ze2"],
["盡述","jin4shu4"],
["盡速","jin4su4"],
["盡頭","jin4tou2"],
["盡本分","jin4ben3fen4"],
["盡義務","jin4yi4wu4"],
["盡人皆知","jin4ren2jie1zhi1"],
["盡力而為","jin4li4er2wei2"],
["盡善盡美","jin4shan4jin4mei3"],
["盡己所能","jin4ji3suo3neng2"],
["盡歡而散","jin4huan1er2san4"],
["盡職盡責","jin4zhi2jin4ze2"],
["盡釋前嫌","jin4shi4qian2xian2"]
],
"監":[
["監管","jian1guan3"],
["監考","jian1kao3"],
["監獄長","jian1yu4zhang3"]
],
"盤":[
["盤古","pan2gu3"],
["盤碗","pan2wan3"],
["盤算","pan2suan5"],
["盤腿","pan2tui3"],
["盤錦","pan2jin3"]
],
"盥":[
["盥洗","guan4xi3"]
],
"盧":[
["盧卡","lu2ka3"],
["盧比","lu2bi3"]
],
"目":[
["目的","mu4di4"],
["目睹","mu4du3"],
["目語","mu4yu3"],
["目语","mu4yu3"],
["目的地","mu4di4di4"],
["目不識丁","mu4bu4shi2ding1"],
["目不识丁","mu4bu4shi2ding1"],
["目不轉睛","mu4bu4zhuan3jing1"],
["目不转睛","mu4bu4zhuan3jing1"],
["目挑心招","mu4tiao3xin1zhao1"],
["目前还不清楚","mu4qian2hai2bu4qing1chu3"],
["目前還不清楚","mu4qian2hai2bu4qing1chu3"]
],
"盲":[
["盲打","mang2da3"],
["盲点","mang2dian3"],
["盲點","mang2dian3"]
],
"直":[
["直发","zhi2fa4"],
["直尺","zhi2chi3"],
["直属","zhi2shu3"],
["直屬","zhi2shu3"],
["直指","zhi2zhi3"],
["直爽","zhi2shuang3"],
["直率","zhi2shuai4"],
["直角","zhi2jiao3"],
["直餾","zhi2liu4"],
["直馏","zhi2liu4"],
["直不棱","zhi2bu5leng5"],
["直不棱瞪","zhi2bu5leng5deng5"],
["直眉瞪眼","zhi2mei5deng4yan3"]
],
"相":[
["相仿","xiang1fang3"],
["相位","xiang4wei4"],
["相反","xiang1fan3"],
["相国","xiang4guo2"],
["相图","xiang4tu2"],
["相國","xiang4guo2"],
["相圖","xiang4tu2"],
["相士","xiang4shi4"],
["相声","xiang4sheng5"],
["相处","xiang1chu3"],
["相宜","xiang1yi2"],
["相应","xiang1ying4"],
["相得","xiang1de2"],
["相恶","xiang1wu4"],
["相惡","xiang1wu4"],
["相應","xiang1ying4"],
["相扑","xiang4pu1"],
["相撲","xiang4pu1"],
["相机","xiang4ji1"],
["相架","xiang4jia4"],
["相機","xiang4ji1"],
["相比","xiang1bi3"],
["相片","xiang4pian1"],
["相称","xiang1chen4"],
["相稱","xiang1chen4"],
["相等","xiang1deng3"],
["相紙","xiang4zhi3"],
["相纸","xiang4zhi3"],
["相聲","xiang4sheng5"],
["相處","xiang1chu3"],
["相角","xiang4jiao3"],
["相識","xiang1shi2"],
["相识","xiang1shi2"],
["相貌","xiang4mao4"],
["相間","xiang1jian4"],
["相间","xiang1jian4"],
["相面","xiang4mian4"],
["相位差","xiang4wei4cha1"],
["相命者","xiang4ming4zhe3"],
["相平面","xiang4ping2mian4"],
["相當於","xiang1dang1yu2"],
["相空間","xiang4kong1jian1"],
["相空间","xiang4kong1jian1"],
["相体裁衣","xiang4ti3cai2yi1"],
["相依为命","xiang1yi1wei2ming4"],
["相依為命","xiang1yi1wei2ming4"],
["相关系数","xiang1guan1xi4shu4"],
["相同名字","xiang1tong2ming2zi4"],
["相夫教子","xiang4fu1jiao4zi3"],
["相關係數","xiang1guan1xi4shu4"],
["相顧一笑","xiang1gu4yi2xiao4"],
["相顾一笑","xiang1gu4yi2xiao4"],
["相體裁衣","xiang4ti3cai2yi1"]
],
"盹":[
["盹儿","dun3r5"]
],
"省":[
["省亲","xing3qin1"],
["省俭","sheng3jian3"],
["省儉","sheng3jian3"],
["省察","xing3cha2"],
["省悟","xing3wu4"],
["省視","xing3shi4"],
["省親","xing3qin1"],
["省视","xing3shi4"],
["省長","sheng3zhang3"],
["省长","sheng3zhang3"],
["省不下","sheng3bu5xia4"],
["省劲儿","sheng3jin4r5"],
["省字号","sheng3zi4hao4"],
["省字號","sheng3zi4hao4"],
["省得出","sheng3de5chu1"]
],
"眇":[
["眇眇","miao3miao3"]
],
"眉":[
["眉毛","mei2mao5"],
["眉目","mei2mu5"],
["眉目传情","mei2mu4chuan2qing2"],
["眉目傳情","mei2mu4chuan2qing2"]
],
"看":[
["看上","kan4shang5"],
["看中","kan4zhong4"],
["看來","kan4lai5"],
["看准","kan4zhun3"],
["看头","kan4tou5"],
["看好","kan4hao3"],
["看守","kan1shou3"],
["看懂","kan4dong3"],
["看来","kan4lai5"],
["看法","kan4fa3"],
["看涨","kan4zhang3"],
["看準","kan4zhun3"],
["看漲","kan4zhang3"],
["看相","kan4xiang4"],
["看看","kan4kan5"],
["看管","kan1guan3"],
["看羊","kan1yang2"],
["看見","kan4jian5"],
["看见","kan4jian5"],
["看門","kan1men2"],
["看门","kan1men2"],
["看頭","kan4tou5"],
["看一看","kan4yi2kan4"],
["看上去","kan4shang5qu5"],
["看下去","kan4xia4qu4"],
["看不上","kan4bu5shang4"],
["看不下","kan4bu5xia4"],
["看不中","kan4bu5zhong4"],
["看不來","kan4bu5lai2"],
["看不准","kan4bu5zhun3"],
["看不出","kan4bu5chu1"],
["看不到","kan4bu5dao4"],
["看不完","kan4bu5wan2"],
["看不得","kan4bu5de5"],
["看不忿","kan4bu5fen4"],
["看不惯","kan4bu5guan4"],
["看不慣","kan4bu5guan4"],
["看不懂","kan4bu5dong3"],
["看不来","kan4bu5lai2"],
["看不清","kan4bu5qing1"],
["看不準","kan4bu5zhun3"],
["看不見","kan4bu5jian4"],
["看不见","kan4bu5jian4"],
["看不起","kan4bu5qi3"],
["看不过","kan4bu5guo4"],
["看不透","kan4bu5tou4"],
["看不過","kan4bu5guo4"],
["看得上","kan4de5shang4"],
["看得中","kan4de5zhong4"],
["看得住","kan1de5zhu4"],
["看得來","kan4de5lai2"],
["看得出","kan4de5chu1"],
["看得到","kan4de5dao4"],
["看得来","kan4de5lai2"],
["看情形","kan4qing2xing2"],
["看清楚","kan4qing1chu3"],
["看起來","kan4qi5lai5"],
["看起来","kan4qi5lai5"],
["看不习惯","kan1bu4xi2guan4"],
["看不出來","kan4bu5chu1lai5"],
["看不出来","kan4bu5chu1lai5"],
["看不忿儿","kan4bu5fen4r5"],
["看不清楚","kan4bu5qing1chu3"],
["看不習慣","kan1bu4xi2guan4"],
["看不順眼","kan4bu5shun4yan3"],
["看不顺眼","kan4bu5shun4yan3"],
["看得出來","kan4de5chu1lai5"],
["看得出来","kan4de5chu1lai5"],
["看得过眼儿","kan4de5guo4yan3r5"]
],
"真":[
["真个","zhen1ge4"],
["真主","zhen1zhu3"],
["真伪","zhen1wei3"],
["真個","zhen1ge4"],
["真偽","zhen1wei3"],
["真武","zhen1wu3"],
["真版","zhen1ban3"],
["真率","zhen1shuai4"],
["真理","zhen1li3"],
["真相","zhen1xiang4"],
["真跡","zhen1ji4"],
["真迹","zhen1ji4"],
["真髓","zhen1sui3"],
["真是的","zhen1shi5de5"]
],
"眨":[
["眨眼","zha3yan3"],
["眨眼睛","zha3yan3jing1"]
],
"眩":[
["眩晕","xuan4yun4"],
["眩暈","xuan4yun4"]
],
"眷":[
["眷属","juan4shu3"],
["眷屬","juan4shu3"]
],
"眼":[
["眼屎","yan3shi3"],
["眼底","yan3di3"],
["眼影","yan3ying3"],
["眼晕","yan3yun4"],
["眼暈","yan3yun4"],
["眼柄","yan3bing3"],
["眼点","yan3dian3"],
["眼睑","yan3jian3"],
["眼瞼","yan3jian3"],
["眼裡","yan3li3"],
["眼里","yan3li3"],
["眼點","yan3dian3"],
["眼底下","yan3di3xia5"],
["眼珠儿","yan3zhu1r5"],
["眼珠一轉","yan3zhu1yi2zhuan4"],
["眼珠一转","yan3zhu1yi2zhuan4"],
["眼不見為淨","yan3bu2jian4wei2jing4"],
["眼不见为淨","yan3bu2jian4wei2jing4"]
],
"着":[
["着书","zhu4shu1"],
["着儿","zhao1r5"],
["着凉","zhao2liang2"],
["着力","zhuo2li4"],
["着吃","zhao2chi1"],
["着墨","zhuo2mo4"],
["着处","zhuo2chu4"],
["着实","zhuo2shi2"],
["着家","zhao2jia1"],
["着床","zhuo2chuang2"],
["着忙","zhao2mang2"],
["着急","zhao2ji2"],
["着想","zhuo2xiang3"],
["着意","zhuo2yi4"],
["着慌","zhao2huang1"],
["着手","zhuo2shou3"],
["着棋","zhuo2qi2"],
["着法","zhao1fa3"],
["着火","zhao2huo3"],
["着用","zhao2yong4"],
["着眼","zhuo2yan3"],
["着称","zhu4cheng1"],
["着笔","zhuo2bi3"],
["着紧","zhao2jin3"],
["着色","zhuo2se4"],
["着落","zhuo2luo4"],
["着衣","zhuo2yi1"],
["着装","zhuo2zhuang1"],
["着边","zhao2bian1"],
["着迷","zhao2mi2"],
["着重","zhuo2zhong4"],
["着陆","zhuo2lu4"],
["着风","zhao2feng1"],
["着魔","zhao2mo2"],
["着劲儿","zhuo2jin4r5"],
["着边儿","zhao2bian1r5"],
["着三不着两","zhao2san1bu4zhao2liang3"]
],
"睁":[
["睁眼","zheng1yan3"],
["睁不开","zheng1bu5kai1"],
["睁开眼睛","zheng1kai1yan3jing1"]
],
"睚":[
["睚珥","ya2er3"],
["睚魯","ya2lu3"],
["睚鲁","ya2lu3"]
],
"睜":[
["睜眼","zheng1yan3"],
["睜不開","zheng1bu5kai1"],
["睜開眼睛","zheng1kai1yan3jing1"]
],
"睡":[
["睡椅","shui4yi3"],
["睡眼","shui4yan3"],
["睡着","shui4zhao2"],
["睡著","shui4zhao2"],
["睡覺","shui4jiao4"],
["睡觉","shui4jiao4"],
["睡醒","shui4xing3"],
["睡鼠","shui4shu3"],
["睡不下","shui4bu5xia4"],
["睡不好","shui4bu5hao3"],
["睡不着","shui4bu5zhao2"],
["睡不著","shui4bu5zhao2"],
["睡得着","shui4de5zhao2"],
["睡得著","shui4de5zhao2"],
["睡懒觉","shui4lan3jiao4"],
["睡懶覺","shui4lan3jiao4"],
["睡不着觉","shui4bu5zhao2jiao4"],
["睡不著覺","shui4bu5zhao2jiao4"]
],
"督":[
["督导","du1dao3"],
["督導","du1dao3"],
["督抚","du1fu3"],
["督撫","du1fu3"]
],
"瞄":[
["瞄准","miao2zhun3"],
["瞄準","miao2zhun3"]
],
"瞎":[
["瞎扯","xia1che3"],
["瞎眼","xia1yan3"],
["瞎搞一通","xia1gao3yi2tong4"]
],
"瞑":[
["瞑想","ming2xiang3"]
],
"瞬":[
["瞬息","shun4xi1"]
],
"瞭":[
["瞭解","liao3jie3"],
["瞭望台","liao4wang4tai2"],
["瞭望臺","liao4wang4tai2"]
],
"瞳":[
["瞳孔","tong2kong3"]
],
"瞻":[
["瞻仰","zhan1yang3"]
],
"矛":[
["矛柄","mao2bing3"]
],
"知":[
["知了","zhi1liao3"],
["知会","zhi1hui5"],
["知己","zhi1ji3"],
["知府","zhi1fu3"],
["知晓","zhi1xiao3"],
["知曉","zhi1xiao3"],
["知會","zhi1hui5"],
["知道","zhi1dao5"],
["知更鳥","zhi1geng1niao3"],
["知更鸟","zhi1geng1niao3"],
["知道了","zhi1dao4le5"],
["知一不知十","zhi1yi2bu4zhi1shi2"],
["知識就是力量","zhi1shi5jiu4shi4li4liang4"],
["知识就是力量","zhi1shi5jiu4shi4li4liang4"]
],
"矩":[
["矩尺","ju3chi3"],
["矩形","ju3xing2"],
["矩阵","ju3zhen4"],
["矩陣","ju3zhen4"]
],
"矫":[
["矫健","jiao3jian4"],
["矫形","jiao3xing2"],
["矫情","jiao3qing2"],
["矫捷","jiao3jie2"],
["矫正","jiao3zheng4"],
["矫治","jiao3zhi4"],
["矫矫","jiao3jiao3"],
["矫诏","jiao3zhao4"],
["矫味剂","jiao3wei4ji4"],
["矫揉造作","jiao3rou2zao4zuo4"],
["矫枉过正","jiao3wang3guo4zheng4"],
["矫枉过直","jiao3wang3guo4zhi2"]
],
"短":[
["短处","duan3chu5"],
["短少","duan3shao3"],
["短指","duan3zhi3"],
["短浅","duan3qian3"],
["短淺","duan3qian3"],
["短短","duan3duan3"],
["短简","duan3jian3"],
["短簡","duan3jian3"],
["短腿","duan3tui3"],
["短處","duan3chu5"],
["短跑","duan3pao3"],
["短不了","duan3bu5liao3"],
["短得了","duan3de5liao3"],
["短打扮","duan3da3ban4"]
],
"矮":[
["矮小","ai3xiao3"],
["矮人一截","ai3ren2yi4jie2"],
["矮杆品种","ai3gan3pin3zhong3"],
["矮子里拔将军","ai3zi5li5ba2jiang1jun1"]
],
"矯":[
["矯健","jiao3jian4"],
["矯形","jiao3xing2"],
["矯情","jiao3qing2"],
["矯捷","jiao3jie2"],
["矯正","jiao3zheng4"],
["矯治","jiao3zhi4"],
["矯矯","jiao3jiao3"],
["矯詔","jiao3zhao4"],
["矯味劑","jiao3wei4ji4"],
["矯揉造作","jiao3rou2zao4zuo4"],
["矯枉過正","jiao3wang3guo4zheng4"],
["矯枉過直","jiao3wang3guo4zhi2"]
],
"石":[
["石头","shi2tou5"],
["石女","shi2nv3"],
["石子","shi2zi3"],
["石岗","shi2gang3"],
["石崗","shi2gang3"],
["石弩","shi2nu3"],
["石板","shi2ban3"],
["石榴","shi2liu5"],
["石版","shi2ban3"],
["石磨","shi2mo4"],
["石笋","shi2sun3"],
["石筍","shi2sun3"],
["石蕊","shi2rui3"],
["石虎","shi2hu3"],
["石頭","shi2tou5"],
["石首","shi2shou3"],
["石子儿","shi2zi3r5"],
["石榴子","shi2liu5zi3"],
["石河子","shi2he2zi3"]
],
"矶":[
["矶法","ji1fa3"]
],
"矽":[
["矽藻","xi1zao3"]
],
"矿":[
["矿井","kuang4jing3"],
["矿产","kuang4chan3"],
["矿场","kuang4chang3"],
["矿水","kuang4shui3"],
["矿难","kuang4nan4"],
["矿务局","kuang4wu4ju2"]
],
"码":[
["码头","ma3tou5"]
],
"砍":[
["砍倒","kan3dao3"],
["砍下來","kan3xia4lai2"],
["砍下来","kan3xia4lai2"]
],
"研":[
["研拟","yan2ni3"],
["研擬","yan2ni3"],
["研考","yan2kao3"],
["研討","yan2tao3"],
["研讨","yan2tao3"]
],
"砖":[
["砖瓦","zhuan1wa3"]
],
"砚":[
["砚台","yan4tai5"]
],
"砝":[
["砝码","fa3ma3"],
["砝碼","fa3ma3"]
],
"砧":[
["砧骨","zhen1gu3"]
],
"砲":[
["砲响","pao4xiang3"],
["砲手","pao4shou3"],
["砲艇","pao4ting3"],
["砲響","pao4xiang3"]
],
"破":[
["破产","po4chan3"],
["破口","po4kou3"],
["破土","po4tu3"],
["破损","po4sun3"],
["破損","po4sun3"],
["破晓","po4xiao3"],
["破曉","po4xiao3"],
["破產","po4chan3"],
["破相","po4xiang4"],
["破胆","po4dan3"],
["破膽","po4dan3"],
["破解","po4jie3"],
["破涕为笑","po4ti4wei2xiao4"],
["破涕為笑","po4ti4wei2xiao4"],
["破顏一笑","po4yan2yi2xiao4"],
["破颜一笑","po4yan2yi2xiao4"],
["破题儿第一遭","po4ti2r5di4yi1zao1"]
],
"砸":[
["砸毀","za2hui3"],
["砸毁","za2hui3"]
],
"硅":[
["硅藻","gui1zao3"],
["硅谷","gui1gu3"]
],
"硬":[
["硬体","ying4ti3"],
["硬实","ying4shi5"],
["硬實","ying4shi5"],
["硬干","ying4gan4"],
["硬朗","ying4lang5"],
["硬水","ying4shui3"],
["硬紙","ying4zhi3"],
["硬纸","ying4zhi3"],
["硬起","ying4qi5"],
["硬領","ying4ling3"],
["硬领","ying4ling3"],
["硬骨","ying4gu3"],
["硬體","ying4ti3"]
],
"确":[
["确保","que4bao3"],
["确诊","que4zhen3"]
],
"硯":[
["硯臺","yan4tai5"]
],
"碇":[
["碇泊","ding4bo2"]
],
"碉":[
["碉堡","diao1bao3"]
],
"碌":[
["碌曲","lu4qu3"]
],
"碍":[
["碍口","ai4kou3"],
["碍眼","ai4yan3"],
["碍不着","ai4bu5zhao2"],
["碍得着","ai4de5zhao2"]
],
"碑":[
["碑帖","bei1tie4"]
],
"碧":[
["碧土","bi4tu3"],
["碧玺","bi4xi3"],
["碧璽","bi4xi3"],
["碧瓦","bi4wa3"]
],
"碰":[
["碰倒","peng4dao3"],
["碰巧","peng4qiao3"],
["碰损","peng4sun3"],
["碰損","peng4sun3"],
["碰碰車","peng4peng5che1"],
["碰碰车","peng4peng5che1"],
["碰磁儿","peng4ci2r5"]
],
"碱":[
["碱土","jian3tu3"],
["碱水","jian3shui3"]
],
"確":[
["確保","que4bao3"],
["確診","que4zhen3"]
],
"碼":[
["碼頭","ma3tou5"]
],
"碾":[
["碾坊","nian3fang2"]
],
"磁":[
["磁体","ci2ti3"],
["磁卡","ci2ka3"],
["磁场","ci2chang3"],
["磁場","ci2chang3"],
["磁矩","ci2ju3"],
["磁鐵","ci2tie3"],
["磁铁","ci2tie3"],
["磁體","ci2ti3"],
["磁单极子","ci2dan1ji2zi3"],
["磁單極子","ci2dan1ji2zi3"]
],
"磅":[
["磅礴","pang2bo2"]
],
"磚":[
["磚瓦","zhuan1wa3"]
],
"磨":[
["磨叨","mo4dao5"],
["磨嘴","mo2zui3"],
["磨坊","mo4fang2"],
["磨子","mo4zi5"],
["磨损","mo2sun3"],
["磨損","mo2sun3"],
["磨烦","mo4fan5"],
["磨煩","mo4fan5"],
["磨盘","mo4pan2"],
["磨盤","mo4pan2"],
["磨蹭","mo2ceng5"],
["磨难","mo2nan4"],
["磨難","mo2nan4"],
["磨面","mo4mian4"],
["磨麵","mo4mian4"],
["磨齒","mo2chi3"],
["磨齿","mo2chi3"],
["磨不开","mo4bu5kai1"],
["磨不開","mo4bu5kai1"],
["磨得开","mo4de5kai1"],
["磨得開","mo4de5kai1"],
["磨豆腐","mo4dou4fu5"]
],
"磯":[
["磯法","ji1fa3"]
],
"磴":[
["磴口","deng4kou3"]
],
"磷":[
["磷火","lin2huo3"]
],
"礁":[
["礁岛","jiao1dao3"],
["礁島","jiao1dao3"]
],
"礙":[
["礙口","ai4kou3"],
["礙眼","ai4yan3"],
["礙不著","ai4bu5zhao2"],
["礙得著","ai4de5zhao2"]
],
"礦":[
["礦井","kuang4jing3"],
["礦場","kuang4chang3"],
["礦水","kuang4shui3"],
["礦產","kuang4chan3"],
["礦難","kuang4nan4"],
["礦務局","kuang4wu4ju2"]
],
"示":[
["示冷","shi4leng3"],
["示坦","shi4tan3"],
["示巴","shi4ba1"],
["示每","shi4mei3"],
["示法","shi4fa3"],
["示玛","shi4ma3"],
["示瑪","shi4ma3"],
["示緬","shi4mian3"],
["示缅","shi4mian3"],
["示警","shi4jing3"],
["示馬","shi4ma3"],
["示马","shi4ma3"]
],
"礼":[
["礼品","li3pin3"],
["礼法","li3fa3"],
["礼服呢","li3fu2ni2"]
],
"社":[
["社保","she4bao3"],
["社火","she4huo3"],
["社長","she4zhang3"],
["社长","she4zhang3"]
],
"祇":[
["祇讀","zhi1du2"],
["祇读","zhi1du2"]
],
"祈":[
["祈祷","qi2dao3"],
["祈禱","qi2dao3"]
],
"祕":[
["祕本","mi4ben3"]
],
"祖":[
["祖母","zu3mu3"],
["祖珥","zu3er3"],
["祖魯","zu3lu3"],
["祖鲁","zu3lu3"],
["祖鳥","zu3niao3"],
["祖鸟","zu3niao3"]
],
"祝":[
["祝好","zhu4hao3"],
["祝酒","zhu4jiu3"]
],
"神":[
["神仙","shen2xian1"],
["神体","shen2ti3"],
["神佛","shen2fo2"],
["神勇","shen2yong3"],
["神女","shen2nv3"],
["神曲","shen2qu3"],
["神父","shen2fu5"],
["神祖","shen2zu3"],
["神笔","shen2bi3"],
["神筆","shen2bi3"],
["神譜","shen2pu3"],
["神谱","shen2pu3"],
["神跡","shen2ji4"],
["神迹","shen2ji4"],
["神都","shen2du1"],
["神采","shen2cai3"],
["神髓","shen2sui3"],
["神體","shen2ti3"],
["神不守舍","shen2bu4shou3she4"],
["神乎其技","shen2hu1qi2ji4"],
["神出鬼沒","shen2chu1gui3mo4"],
["神出鬼没","shen2chu1gui3mo4"],
["神差鬼使","shen2chai1gui3shi3"],
["神气十足","shen2qi5shi2zu2"],
["神氣十足","shen2qi5shi2zu2"],
["神話故事","shen2hua4gu4shi4"],
["神话故事","shen2hua4gu4shi4"]
],
"票":[
["票友","piao4you3"],
["票选","piao4xuan3"],
["票選","piao4xuan3"],
["票友儿","piao4you3r5"]
],
"祭":[
["祭品","ji4pin3"],
["祭礼","ji4li3"],
["祭祖","ji4zu3"],
["祭禮","ji4li3"]
],
"祸":[
["祸首","huo4shou3"],
["祸不单行","huo4bu4dan1xing2"]
],
"禁":[
["禁品","jin4pin3"],
["禁果","jin4guo3"],
["禁止","jin4zhi3"],
["禁演","jin4yan3"],
["禁語","jin1yu3"],
["禁语","jin1yu3"],
["禁酒","jin4jiu3"],
["禁不住","jin1bu5zhu4"],
["禁不起","jin1bu5qi3"],
["禁得住","jin1de5zhu4"],
["禁得起","jin1de5qi3"]
],
"禅":[
["禅位","shan4wei4"],
["禅让","shan4rang4"]
],
"禍":[
["禍首","huo4shou3"],
["禍不單行","huo4bu4dan1xing2"]
],
"福":[
["福分","fu2fen5"],
["福地","fu2di4"],
["福尔","fu2er3"],
["福气","fu2qi5"],
["福氣","fu2qi5"],
["福海","fu2hai3"],
["福爾","fu2er3"],
["福礼","fu2li3"],
["福祉","fu2zhi3"],
["福禮","fu2li3"],
["福鼎","fu2ding3"],
["福兴乡","fu2xing1xiang1"],
["福興鄉","fu2xing1xiang1"],
["福徒拿都","fu2tu2na2du1"],
["福斯塔夫","fu2si1ta3fu1"],
["福田康夫","fu2tian2kang1fu1"]
],
"禪":[
["禪堂","chan2tang2"],
["禪宗","chan2zong1"],
["禪師","chan2shi1"],
["禪房","chan2fang2"],
["禪杖","chan2zhang4"],
["禪林","chan2lin2"],
["禪機","chan2ji1"],
["禪院","chan2yuan4"]
],
"禮":[
["禮品","li3pin3"],
["禮法","li3fa3"],
["禮服呢","li3fu2ni2"]
],
"离":[
["离地","li2di4"],
["离子","li2zi3"],
["离岛","li2dao3"],
["离港","li2gang3"],
["离谱","li2pu3"],
["离间","li2jian4"],
["离不了","li2bu5liao3"],
["离不开","li2bu5kai1"],
["离得了","li2de5liao3"],
["离不开人儿","li2bu5kai1ren2r5"],
["离不开手儿","li2bu5kai1shou3r5"],
["离不开身儿","li2bu5kai1shen1r5"]
],
"禽":[
["禽鳥","qin2niao3"],
["禽鸟","qin2niao3"]
],
"禾":[
["禾场","he2chang2"],
["禾場","he2chang2"],
["禾秆","he2gan3"],
["禾稈","he2gan3"],
["禾穀","he2gu3"],
["禾草","he2cao3"],
["禾谷","he2gu3"]
],
"禿":[
["禿頂","tu1ding3"]
],
"秀":[
["秀发","xiu4fa4"],
["秀才","xiu4cai5"],
["秀气","xiu4qi5"],
["秀氣","xiu4qi5"],
["秀美","xiu4mei3"]
],
"私":[
["私地","si1di4"],
["私有","si1you3"],
["私法","si1fa3"],
["私語","si1yu3"],
["私语","si1yu3"]
],
"秃":[
["秃发","tu1fa4"],
["秃顶","tu1ding3"]
],
"秈":[
["秈米","xian1mi3"]
],
"秉":[
["秉笔","bing3bi3"],
["秉筆","bing3bi3"]
],
"秋":[
["秋景","qiu1jing3"],
["秋狝","qiu1xian3"],
["秋獮","qiu1xian3"],
["秋瑾","qiu1jin3"],
["秋雨","qiu1yu3"]
],
"种":[
["种上","zhong4shang5"],
["种下","zhong4xia4"],
["种地","zhong4di4"],
["种差","zhong3cha1"],
["种树","zhong4shu4"],
["种植","zhong4zhi2"],
["种祸","zhong4huo4"],
["种种","zhong3zhong3"],
["种花","zhong4hua1"],
["种薯","zhong3shu3"],
["种马","zhong3ma3"],
["种子选手","zhong3zi3xuan3shou3"],
["种瓜得瓜","zhong4gua1de2gua1"],
["种豆得豆","zhong4dou4de2dou4"],
["种豆得麦","zhong4dou4de2mai4"],
["种麦得麦","zhong4mai4de2mai4"]
],
"科":[
["科举","ke1ju3"],
["科尔","ke1er3"],
["科斗","ke1dou3"],
["科普","ke1pu3"],
["科爾","ke1er3"],
["科舉","ke1ju3"],
["科蚪","ke1dou3"],
["科長","ke1zhang3"],
["科长","ke1zhang3"],
["科学种田","ke1xue2zhong4tian2"],
["科學種田","ke1xue2zhong4tian2"],
["科納克裡","ke1na4ke4li3"],
["科什图尼察","ke1shi2tu2ni2cha2"],
["科什圖尼察","ke1shi2tu2ni2cha2"]
],
"秘":[
["秘本","mi4ben3"],
["秘魯","bi4lu3"],
["秘鲁","bi4lu3"],
["秘书长","mi4shu1zhang3"],
["秘書長","mi4shu1zhang3"]
],
"租":[
["租給","zu1gei3"],
["租给","zu1gei3"],
["租不起","zu1bu5qi3"],
["租借地","zu1jie4di4"]
],
"秤":[
["秤杆","cheng4gan3"],
["秤桿","cheng4gan3"]
],
"秦":[
["秦岭","qin2ling3"],
["秦嶺","qin2ling3"],
["秦火","qin2huo3"],
["秦吉了","qin2ji2liao3"]
],
"秧":[
["秧歌","yang1ge5"]
],
"积":[
["积攒","ji1zan3"],
["积祖","ji1zu3"],
["积累","ji1lei3"],
["积雪","ji1xue3"]
],
"称":[
["称为","cheng1wei2"],
["称呼","cheng1hu5"],
["称多","chen4duo1"],
["称好","cheng1hao3"],
["称心","chen4xin1"],
["称槃","cheng4pan2"],
["称许","cheng1xu3"],
["称量","cheng1liang2"],
["称锤","cheng4chui2"],
["称之为","cheng1zhi1wei2"],
["称得上","cheng1de5shang4"],
["称砣虽小压千斤","cheng4tuo2sui1xiao3ya1qian1jin1"]
],
"移":[
["移走","yi2zou3"]
],
"秽":[
["秽迹","hui4ji4"]
],
"稀":[
["稀土","xi1tu3"],
["稀少","xi1shao3"],
["稀有","xi1you3"],
["稀罕","xi1han5"],
["稀稀拉拉","xi1xi5la1la1"]
],
"稅":[
["稅務","shui4wu4"],
["稅款","shui4kuan3"],
["稅捐稽徵處","shui4juan1ji1zheng1chu4"]
],
"程":[
["程度","cheng2du5"]
],
"稍":[
["稍息","shao4xi1"],
["稍早","shao1zao3"],
["稍等","shao1deng3"],
["稍稍一怔","shao1shao1yi2zheng4"]
],
"税":[
["税务","shui4wu4"],
["税款","shui4kuan3"],
["税捐稽征处","shui4juan1ji1zheng1chu4"]
],
"稜":[
["稜角","leng2jiao3"]
],
"種":[
["種上","zhong4shang5"],
["種下","zhong4xia4"],
["種地","zhong4di4"],
["種差","zhong3cha1"],
["種植","zhong4zhi2"],
["種樹","zhong4shu4"],
["種禍","zhong4huo4"],
["種種","zhong3zhong3"],
["種花","zhong4hua1"],
["種薯","zhong3shu3"],
["種馬","zhong3ma3"],
["種子選手","zhong3zi3xuan3shou3"],
["種瓜得瓜","zhong4gua1de2gua1"],
["種豆得豆","zhong4dou4de2dou4"],
["種豆得麥","zhong4dou4de2mai4"],
["種麥得麥","zhong4mai4de2mai4"]
],
"稱":[
["稱呼","cheng1hu5"],
["稱多","chen4duo1"],
["稱好","cheng1hao3"],
["稱心","chen4xin1"],
["稱槃","cheng4pan2"],
["稱為","cheng1wei2"],
["稱許","cheng1xu3"],
["稱量","cheng1liang2"],
["稱錘","cheng4chui2"],
["稱之為","cheng1zhi1wei2"],
["稱得上","cheng1de5shang4"],
["稱砣雖小壓千斤","cheng4tuo2sui1xiao3ya1qian1jin1"]
],
"稳":[
["稳妥","wen3tuo3"],
["稳实","wen3shi5"],
["稳当","wen3dang5"],
["稳稳","wen3wen3"],
["稳不住架","wen3bu5zhu4jia4"]
],
"稻":[
["稻穀","dao4gu3"],
["稻米","dao4mi3"],
["稻草","dao4cao3"],
["稻谷","dao4gu3"]
],
"稽":[
["稽古","ji1gu3"],
["稽查员","ji1cha2yuan2"],
["稽查員","ji1cha2yuan2"]
],
"稿":[
["稿紙","gao3zhi3"],
["稿纸","gao3zhi3"]
],
"穀":[
["穀場","gu3chang2"],
["穀草","gu3cao3"],
["穀雨","gu3yu3"]
],
"積":[
["積攢","ji1zan3"],
["積祖","ji1zu3"],
["積累","ji1lei3"],
["積雪","ji1xue3"],
["積於忽微","ji1yu2hu1wei1"]
],
"穎":[
["穎果","ying3guo3"]
],
"穢":[
["穢跡","hui4ji4"]
],
"穩":[
["穩妥","wen3tuo3"],
["穩實","wen3shi5"],
["穩當","wen3dang5"],
["穩穩","wen3wen3"],
["穩不住架","wen3bu5zhu4jia4"]
],
"穷":[
["穷苦","qiong2ku3"]
],
"穹":[
["穹窿","qiong2long2"],
["穹頂","qiong2ding3"],
["穹顶","qiong2ding3"]
],
"空":[
["空位","kong4wei4"],
["空余","kong4yu2"],
["空儿","kong4r5"],
["空兒","kong4r5"],
["空喊","kong1han3"],
["空地","kong4di4"],
["空姐","kong1jie3"],
["空子","kong4zi5"],
["空当","kong4dang1"],
["空想","kong1xiang3"],
["空手","kong1shou3"],
["空挡","kong1dang4"],
["空擋","kong1dang4"],
["空日","kong4ri4"],
["空暇","kong4xia2"],
["空有","kong1you3"],
["空格","kong4ge2"],
["空當","kong4dang1"],
["空白","kong4bai2"],
["空缺","kong4que1"],
["空調","kong1tiao2"],
["空调","kong1tiao2"],
["空跑","kong1pao3"],
["空閑","kong4xian2"],
["空闲","kong4xian2"],
["空隙","kong4xi4"],
["空难","kong1nan4"],
["空難","kong1nan4"],
["空額","kong4e2"],
["空额","kong4e2"],
["空餘","kong4yu2"],
["空心儿","kong1xin1r5"]
],
"穿":[
["穿上","chuan1shang5"],
["穿着","chuan1zhuo2"],
["穿耳","chuan1er3"],
["穿著","chuan1zhuo2"],
["穿不上","chuan1bu5shang4"],
["穿不住","chuan1bu5zhu4"],
["穿不得","chuan1bu5de5"],
["穿不起","chuan1bu5qi3"]
],
"突":[
["突显","tu1xian3"],
["突起","tu1qi3"],
["突顯","tu1xian3"]
],
"窃":[
["窃取","qie4qu3"]
],
"窑":[
["窑场","yao2chang3"]
],
"窒":[
["窒息","zhi4xi1"]
],
"窗":[
["窗口","chuang1kou3"],
["窗戶","chuang1hu5"],
["窗户","chuang1hu5"],
["窗框","chuang1kuang4"],
["窗明几淨","chuang1ming2ji1jing4"],
["窗明幾淨","chuang1ming2ji1jing4"]
],
"窜":[
["窜扰","cuan4rao3"],
["窜改","cuan4gai3"]
],
"窝":[
["窝囊","wo1nang5"],
["窝脖儿","wo1bo2r5"]
],
"窥":[
["窥伺","kui1si4"]
],
"窩":[
["窩囊","wo1nang5"]
],
"窪":[
["窪地","wa1di4"]
],
"窮":[
["窮盡","qiong2jin4"],
["窮苦","qiong2ku3"]
],
"窯":[
["窯場","yao2chang3"]
],
"窸":[
["窸窣","xi1su1"]
],
"窺":[
["窺伺","kui1si4"]
],
"竄":[
["竄擾","cuan4rao3"],
["竄改","cuan4gai3"]
],
"竊":[
["竊取","qie4qu3"]
],
"立":[
["立下","li4xia5"],
["立体","li4ti3"],
["立场","li4chang3"],
["立場","li4chang3"],
["立法","li4fa3"],
["立脚","li4jiao3"],
["立腳","li4jiao3"],
["立馬","li4ma3"],
["立马","li4ma3"],
["立體","li4ti3"]
],
"竖":[
["竖起","shu4qi3"]
],
"站":[
["站岗","zhan4gang3"],
["站崗","zhan4gang3"],
["站稳","zhan4wen3"],
["站穩","zhan4wen3"],
["站起","zhan4qi3"],
["站長","zhan4zhang3"],
["站长","zhan4zhang3"],
["站不住","zhan4bu5zhu4"],
["站不稳","zhan4bu5wen3"],
["站不穩","zhan4bu5wen3"],
["站起來","zhan4qi3lai5"],
["站起来","zhan4qi3lai5"],
["站不起來","zhan4bu5qi3lai5"],
["站不起来","zhan4bu5qi3lai5"]
],
"竞":[
["竞走","jing4zou3"],
["竞选","jing4xuan3"]
],
"竟":[
["竟敢","jing4gan3"]
],
"童":[
["童女","tong2nv3"],
["童子军","tong2zi3jun1"],
["童子軍","tong2zi3jun1"],
["童話故事","tong2hua4gu4shi4"],
["童话故事","tong2hua4gu4shi4"]
],
"竭":[
["竭盡","jie2jin4"]
],
"端":[
["端午","duan1wu3"],
["端口","duan1kou3"]
],
"競":[
["競走","jing4zou3"],
["競選","jing4xuan3"]
],
"竹":[
["竹北","zhu2bei3"],
["竹岛","zhu2dao3"],
["竹島","zhu2dao3"],
["竹笋","zhu2sun3"],
["竹筍","zhu2sun3"],
["竹筒","zhu2tong3"],
["竹简","zhu2jian3"],
["竹管","zhu2guan3"],
["竹簡","zhu2jian3"],
["竹篱笆","zhu2li2ba1"],
["竹籬笆","zhu2li2ba1"]
],
"笃":[
["笃守","du3shou3"]
],
"笆":[
["笆斗","ba1dou3"]
],
"笑":[
["笑柄","xiao4bing3"],
["笑脸","xiao4lian3"],
["笑臉","xiao4lian3"],
["笑話","xiao4hua5"],
["笑語","xiao4yu3"],
["笑话","xiao4hua5"],
["笑语","xiao4yu3"],
["笑一笑","xiao4yi2xiao4"],
["笑不上","xiao4bu5shang4"],
["笑不出","xiao4bu5chu1"],
["笑不唧","xiao4bu5ji1"],
["笑不得","xiao4bu5de5"],
["笑脸儿","xiao4lian3r5"],
["笑得痛快","xiao4de5tong4kuai4"],
["笑裡藏刀","xiao4li3cang2dao1"],
["笑裡藏奸","xiao4li3cang2jian1"]
],
"笔":[
["笔友","bi3you3"],
["笔挺","bi3ting3"],
["笔杆","bi3gan3"],
["笔法","bi3fa3"],
["笔筒","bi3tong3"],
["笔者","bi3zhe3"],
["笔迹","bi3ji4"]
],
"笛":[
["笛手","di2shou3"],
["笛卡儿","di2ka3er5"],
["笛卡兒","di2ka3er5"],
["笛卡尔","di1ka3er3"],
["笛卡爾","di1ka3er3"],
["笛卡儿座标制","di2ka3er2zuo4biao1zhi4"],
["笛卡兒座標制","di2ka3er2zuo4biao1zhi4"]
],
"符":[
["符板","fu2ban3"]
],
"第":[
["第九","di4jiu3"],
["第五","di4wu3"],
["第一两","di4yi1liang3"],
["第一个","di4yi1ge5"],
["第一串","di4yi1chuan4"],
["第一义","di4yi1yi4"],
["第一亇","di4yi1ge4"],
["第一亩","di4yi1mu3"],
["第一代","di4yi1dai4"],
["第一件","di4yi1jian4"],
["第一份","di4yi1fen4"],
["第一伏","di4yi1fu2"],
["第一位","di4yi1wei4"],
["第一例","di4yi1li4"],
["第一個","di4yi1ge5"],
["第一兩","di4yi1liang3"],
["第一具","di4yi1ju4"],
["第一冊","di4yi1ce4"],
["第一册","di4yi1ce4"],
["第一出","di4yi1chu1"],
["第一刻","di4yi1ke4"],
["第一副","di4yi1fu4"],
["第一包","di4yi1bao1"],
["第一匹","di4yi1pi3"],
["第一双","di4yi1shuang1"],
["第一发","di4yi1fa1"],
["第一口","di4yi1kou3"],
["第一句","di4yi1ju4"],
["第一只","di4yi1zhi1"],
["第一台","di4yi1tai2"],
["第一名","di4yi1ming2"],
["第一听","di4yi1ting1"],
["第一响","di4yi1xiang3"],
["第一哪","di4yi1nei3"],
["第一回","di4yi1hui2"],
["第一圈","di4yi1quan1"],
["第一场","di4yi1chang2"],
["第一块","di4yi1kuai4"],
["第一場","di4yi1chang2"],
["第一堵","di4yi1du3"],
["第一塊","di4yi1kuai4"],
["第一声","di4yi1sheng1"],
["第一壶","di4yi1hu2"],
["第一壺","di4yi1hu2"],
["第一处","di4yi1chu4"],
["第一天","di4yi1tian1"],
["第一头","di4yi1tou2"],
["第一套","di4yi1tao4"],
["第一审","di4yi1shen3"],
["第一家","di4yi1jia1"],
["第一審","di4yi1shen3"],
["第一封","di4yi1feng1"],
["第一尊","di4yi1zun1"],
["第一局","di4yi1ju2"],
["第一层","di4yi1ceng2"],
["第一屆","di4yi1jie4"],
["第一届","di4yi1jie4"],
["第一層","di4yi1ceng2"],
["第一岁","di4yi1sui4"],
["第一幅","di4yi1fu2"],
["第一幢","di4yi1chuang2"],
["第一年","di4yi1nian2"],
["第一床","di4yi1chuang2"],
["第一座","di4yi1zuo4"],
["第一张","di4yi1zhang1"],
["第一張","di4yi1zhang1"],
["第一所","di4yi1suo3"],
["第一扇","di4yi1shan4"],
["第一手","di4yi1shou3"],
["第一批","di4yi1pi1"],
["第一把","di4yi1ba3"],
["第一折","di4yi1zhe2"],
["第一抹","di4yi1mo3"],
["第一挺","di4yi1ting3"],
["第一排","di4yi1pai2"],
["第一支","di4yi1zhi1"],
["第一方","di4yi1fang1"],
["第一本","di4yi1ben3"],
["第一朵","di4yi1duo3"],
["第一杆","di4yi1gan3"],
["第一束","di4yi1shu4"],
["第一条","di4yi1tiao2"],
["第一杯","di4yi1bei1"],
["第一枚","di4yi1mei2"],
["第一枝","di4yi1zhi1"],
["第一架","di4yi1jia4"],
["第一栋","di4yi1dong4"],
["第一株","di4yi1zhu1"],
["第一根","di4yi1gen1"],
["第一档","di4yi1dang4"],
["第一桿","di4yi1gan3"],
["第一條","di4yi1tiao2"],
["第一棟","di4yi1dong4"],
["第一棵","di4yi1ke1"],
["第一榀","di4yi1pin3"],
["第一樘","di4yi1tang2"],
["第一檔","di4yi1dang4"],
["第一次","di4yi1ci4"],
["第一步","di4yi1bu4"],
["第一歲","di4yi1sui4"],
["第一段","di4yi1duan4"],
["第一毛","di4yi1mao2"],
["第一泡","di4yi1pao1"],
["第一流","di4yi1liu2"],
["第一点","di4yi1dian3"],
["第一片","di4yi1pian4"],
["第一班","di4yi1ban1"],
["第一瓶","di4yi1ping2"],
["第一甬","di4yi1yong3"],
["第一畝","di4yi1mu3"],
["第一番","di4yi1fan1"],
["第一發","di4yi1fa1"],
["第一盏","di4yi1zhan3"],
["第一盘","di4yi1pan2"],
["第一盞","di4yi1zhan3"],
["第一盤","di4yi1pan2"],
["第一种","di4yi1zhong3"],
["第一種","di4yi1zhong3"],
["第一章","di4yi1zhang1"],
["第一笔","di4yi1bi3"],
["第一筆","di4yi1bi3"],
["第一箇","di4yi1ge4"],
["第一節","di4yi1jie2"],
["第一篇","di4yi1pian1"],
["第一簇","di4yi1cu4"],
["第一米","di4yi1mi3"],
["第一粒","di4yi1li4"],
["第一級","di4yi1ji2"],
["第一絞","di4yi1jiao3"],
["第一線","di4yi1xian4"],
["第一级","di4yi1ji2"],
["第一线","di4yi1xian4"],
["第一绞","di4yi1jiao3"],
["第一缸","di4yi1gang1"],
["第一義","di4yi1yi4"],
["第一聲","di4yi1sheng1"],
["第一聽","di4yi1ting1"],
["第一股","di4yi1gu3"],
["第一臺","di4yi1tai2"],
["第一艘","di4yi1sou1"],
["第一节","di4yi1jie2"],
["第一處","di4yi1chu4"],
["第一袭","di4yi1xi2"],
["第一襲","di4yi1xi2"],
["第一起","di4yi1qi3"],
["第一趟","di4yi1tang4"],
["第一身","di4yi1shen1"],
["第一輛","di4yi1liang4"],
["第一輪","di4yi1lun2"],
["第一轮","di4yi1lun2"],
["第一辆","di4yi1liang4"],
["第一这","di4yi1zhe4"],
["第一這","di4yi1zhe4"],
["第一道","di4yi1dao4"],
["第一遭","di4yi1zao1"],
["第一那","di4yi1na4"],
["第一部","di4yi1bu4"],
["第一門","di4yi1men2"],
["第一間","di4yi1jian1"],
["第一门","di4yi1men2"],
["第一间","di4yi1jian1"],
["第一队","di4yi1dui4"],
["第一阵","di4yi1zhen4"],
["第一陣","di4yi1zhen4"],
["第一隊","di4yi1dui4"],
["第一隻","di4yi1zhi1"],
["第一集","di4yi1ji2"],
["第一雙","di4yi1shuang1"],
["第一面","di4yi1mian4"],
["第一響","di4yi1xiang3"],
["第一頁","di4yi1ye4"],
["第一頂","di4yi1ding3"],
["第一頓","di4yi1dun4"],
["第一頭","di4yi1tou2"],
["第一顆","di4yi1ke1"],
["第一页","di4yi1ye4"],
["第一顶","di4yi1ding3"],
["第一顿","di4yi1dun4"],
["第一颗","di4yi1ke1"],
["第一首","di4yi1shou3"],
["第一點","di4yi1dian3"],
["第一齣","di4yi1chu1"],
["第一世界","di4yi1shi4jie4"],
["第一人称","di4yi1ren2cheng1"],
["第一人稱","di4yi1ren2cheng1"],
["第一夫人","di4yi1fu1ren2"],
["第一性徵","di4yi1xing4zheng1"],
["第一語言","di4yi1yu3yan2"],
["第一语言","di4yi1yu3yan2"],
["第比利斯","di4bi4li4si1"],
["第一个层次","di4yi1ge4ceng2ci4"],
["第一個層次","di4yi1ge4ceng2ci4"],
["第一类物资","di4yi1lei4wu4zi1"],
["第一類物資","di4yi1lei4wu4zi1"],
["第五个现代化","di4wu3ge4xian4dai4hua4"],
["第五個現代化","di4wu3ge4xian4dai4hua4"]
],
"笼":[
["笼头","long2tou5"],
["笼槛","long2jian4"],
["笼络","long3luo4"],
["笼统","long3tong3"],
["笼罩","long3zhao4"],
["笼鸟","long2niao3"],
["笼鸟槛猿","long2niao3jian4yuan2"]
],
"筆":[
["筆友","bi3you3"],
["筆挺","bi3ting3"],
["筆桿","bi3gan3"],
["筆法","bi3fa3"],
["筆筒","bi3tong3"],
["筆者","bi3zhe3"],
["筆跡","bi3ji4"]
],
"等":[
["等差","deng3cha1"],
["等於","deng3yu2"],
["等死","deng3si3"],
["等等","deng3deng3"],
["等不了","deng3bu5liao3"],
["等不及","deng3bu5ji2"],
["等不得","deng3bu5de2"]
],
"筋":[
["筋斗","jin1dou3"],
["筋骨","jin1gu3"]
],
"筑":[
["筑土","zhu4tu3"],
["筑起","zhu4qi3"]
],
"答":[
["答允","da1yun3"],
["答卷","da2juan4"],
["答应","da1ying5"],
["答應","da1ying5"],
["答白","da1bai2"],
["答礼","da2li3"],
["答禮","da2li3"],
["答腔","da1qiang1"],
["答訪","da2fang3"],
["答访","da2fang3"],
["答不上","da2bu5shang4"],
["答不出","da2bu5chu1"],
["答巴俄","da2ba1e2"],
["答得上","da2de5shang4"],
["答不上來","da2bu5shang4lai5"],
["答不上来","da2bu5shang4lai5"],
["答不下來","da2bu5xia4lai5"],
["答不下来","da2bu5xia4lai5"]
],
"策":[
["策劃","ce4hua4"],
["策反","ce4fan3"],
["策馬","ce4ma3"],
["策马","ce4ma3"],
["策源地","ce4yuan2di4"]
],
"筛":[
["筛检","shai1jian3"],
["筛法","shai1fa3"],
["筛选","shai1xuan3"],
["筛骨","shai1gu3"]
],
"筠":[
["筠连","jun1lian2"],
["筠連","jun1lian2"]
],
"筹":[
["筹款","chou2kuan3"],
["筹码","chou2ma3"]
],
"签":[
["签署","qian1shu3"]
],
"简":[
["简体","jian3ti3"],
["简写","jian3xie3"],
["简史","jian3shi3"],
["简帖","jian3tie3"],
["简朴","jian3pu3"],
["简短","jian3duan3"],
["简谱","jian3pu3"],
["简帖儿","jian3tie3r5"]
],
"箕":[
["箕子","ji1zi3"]
],
"算":[
["算子","suan4zi3"],
["算得","suan4de2"],
["算法","suan4fa3"],
["算一算","suan4yi5suan4"],
["算不上","suan4bu5shang4"],
["算不了","suan4bu5liao3"],
["算不來","suan4bu5lai2"],
["算不得","suan4bu5de5"],
["算不来","suan4bu5lai2"],
["算不清","suan4bu5qing1"],
["算得上","suan4de5shang4"],
["算得了","suan4de5liao3"],
["算得什么","suan4de5shen2me5"],
["算得什麼","suan4de5shen2me5"]
],
"管":[
["管他","guan3ta5"],
["管理","guan3li3"],
["管領","guan3ling3"],
["管领","guan3ling3"],
["管不了","guan3bu5liao3"],
["管不住","guan3bu5zhu4"],
["管不着","guan3bu5zhao2"],
["管不著","guan3bu5zhao2"]
],
"箭":[
["箭杆","jian4gan3"],
["箭桿","jian4gan3"]
],
"節":[
["節儉","jie2jian3"],
["節氣","jie2qi5"],
["節水","jie2shui3"],
["節省","jie2sheng3"],
["節選","jie2xuan3"],
["節點","jie2dian3"]
],
"範":[
["範縝","fan4zhen3"]
],
"篆":[
["篆体","zhuan4ti3"],
["篆體","zhuan4ti3"]
],
"篇":[
["篇幅","pian1fu5"]
],
"築":[
["築土","zhu4tu3"],
["築起","zhu4qi3"]
],
"篝":[
["篝火","gou1huo3"]
],
"篡":[
["篡改","cuan4gai3"]
],
"篤":[
["篤守","du3shou3"]
],
"篩":[
["篩檢","shai1jian3"],
["篩法","shai1fa3"],
["篩選","shai1xuan3"],
["篩骨","shai1gu3"]
],
"篮":[
["篮板","lan2ban3"]
],
"篷":[
["篷車","peng2che1"],
["篷车","peng2che1"],
["篷盖佈","peng2gai4bu4"],
["篷蓋佈","peng2gai4bu4"]
],
"簡":[
["簡史","jian3shi3"],
["簡寫","jian3xie3"],
["簡帖","jian3tie3"],
["簡樸","jian3pu3"],
["簡短","jian3duan3"],
["簡譜","jian3pu3"],
["簡體","jian3ti3"]
],
"簧":[
["簧管","huang2guan3"]
],
"簸":[
["簸穀","bo3gu3"],
["簸箕","bo4ji5"],
["簸谷","bo3gu3"]
],
"簽":[
["簽署","qian1shu3"]
],
"籃":[
["籃板","lan2ban3"]
],
"籌":[
["籌劃","chou2hua4"],
["籌款","chou2kuan3"],
["籌碼","chou2ma3"]
],
"籠":[
["籠檻","long2jian4"],
["籠絡","long3luo4"],
["籠統","long3tong3"],
["籠罩","long3zhao4"],
["籠頭","long2tou5"],
["籠鳥","long2niao3"],
["籠鳥檻猿","long2niao3jian4yuan2"]
],
"米":[
["米夫","mi3fu1"],
["米煞","mi3sha1"],
["米玛","mi3ma3"],
["米瑪","mi3ma3"],
["米甲","mi3jia3"],
["米粉","mi3fen3"],
["米芾","mi3fei4"],
["米底巴","mi3di3ba1"],
["米所巴","mi3suo3ba1"],
["米斯巴","mi3si1ba1"],
["米德爾伯裡","mi3de2er3bo2li3"]
],
"类":[
["类比","lei4bi3"],
["类地行星","lei4di4xing2xing1"]
],
"籼":[
["籼米","xian1mi3"]
],
"粉":[
["粉土","fen3tu3"],
["粉笔","fen3bi3"],
["粉筆","fen3bi3"],
["粉不喇唧","fen3bu5la1ji1"]
],
"粒":[
["粒子","li4zi3"]
],
"粗":[
["粗体","cu1ti3"],
["粗口","cu1kou3"],
["粗哑","cu1ya3"],
["粗啞","cu1ya3"],
["粗浅","cu1qian3"],
["粗淺","cu1qian3"],
["粗語","cu1yu3"],
["粗语","cu1yu3"],
["粗野","cu1ye3"],
["粗體","cu1ti3"],
["粗魯","cu1lu3"],
["粗鲁","cu1lu3"],
["粗略一看","cu1lve4yi2kan4"]
],
"粘":[
["粘土","nian2tu3"],
["粘度","nian2du4"],
["粘性","nian2xing4"],
["粘液","nian2ye4"],
["粘痰","nian2tan2"],
["粘粘","nian2nian2"],
["粘胶","nian2jiao1"],
["粘膜","nian2mo2"],
["粘膠","nian2jiao1"],
["粘菌","nian2jun1"],
["粘不住","zhan1bu5zhu4"]
],
"粤":[
["粤语","yue4yu3"]
],
"粪":[
["粪土","fen4tu3"]
],
"粮":[
["粮草","liang2cao3"],
["粮食","liang2shi5"],
["粮饷","liang2xiang3"],
["粮食供应","liang2shi5gong4ying4"]
],
"粵":[
["粵語","yue4yu3"]
],
"精":[
["精准","jing1zhun3"],
["精品","jing1pin3"],
["精子","jing1zi3"],
["精巧","jing1qiao3"],
["精干","jing1gan4"],
["精当","jing1dang4"],
["精彩","jing1cai3"],
["精於","jing1yu2"],
["精準","jing1zhun3"],
["精當","jing1dang4"],
["精简","jing1jian3"],
["精簡","jing1jian3"],
["精米","jing1mi3"],
["精美","jing1mei3"],
["精选","jing1xuan3"],
["精選","jing1xuan3"],
["精髓","jing1sui3"],
["精校本","jing1jiao4ben3"],
["精明强干","jing1ming2qiang2gan4"],
["精灵宝钻","jing1ling2bao3zuan4"],
["精靈寶鑽","jing1ling2bao3zuan4"]
],
"糊":[
["糊剂","hu2ji4"],
["糊劑","hu2ji4"],
["糊口","hu2kou3"],
["糊嘴","hu2zui3"],
["糊塗","hu2tu5"],
["糊弄","hu4nong5"],
["糊涂","hu2tu5"],
["糊精","hu2jing1"],
["糊糊","hu2hu5"],
["糊糊塗塗","hu2hu5tu1tu1"],
["糊糊涂涂","hu2hu5tu1tu1"],
["糊裡糊塗","hu2li5hu2tu5"],
["糊里糊涂","hu2li5hu2tu5"]
],
"糕":[
["糕点","gao1dian3"],
["糕點","gao1dian3"]
],
"糖":[
["糖果","tang2guo3"],
["糖水","tang2shui3"],
["糖酯","tang2zhi3"],
["糖醋裡脊","tang2cu4li3ji5"],
["糖醋里脊","tang2cu4li3ji5"]
],
"糜":[
["糜烂","mi2lan4"],
["糜爛","mi2lan4"]
],
"糞":[
["糞土","fen4tu3"]
],
"糟":[
["糟踏","zao1ta5"],
["糟蹋","zao1ta5"]
],
"糢":[
["糢糊","mo2hu2"]
],
"糧":[
["糧草","liang2cao3"],
["糧食","liang2shi5"],
["糧餉","liang2xiang3"],
["糧食供應","liang2shi5gong4ying4"]
],
"糯":[
["糯米","nuo4mi3"]
],
"系":[
["系上","ji4shang5"],
["系囚","ji4qiu2"],
["系小","xi4xiao3"],
["系統","xi4tong3"],
["系统","xi4tong3"],
["系于一发","xi4yu2yi2fa4"]
],
"糾":[
["糾葛","jiu1ge2"]
],
"約":[
["約坦","yue1tan3"],
["約塔","yao1ta3"],
["約巴","yue1ba1"],
["約摸","yue1mo5"],
["約法","yue1fa3"],
["約珥","yue1er3"],
["約緬","yue1mian3"],
["約莫","yue1mo5"],
["約請","yue1qing3"],
["約不到","yue1bu5dao4"],
["約瑟夫","yue1se4fu1"],
["約維克","yao1wei2ke4"],
["約翰一書","yue1han4yi4shu1"],
["約設巴設","yue1she4ba1she4"]
],
"紅":[
["紅堡","hong2bao3"],
["紅場","hong2chang3"],
["紅暈","hong2yun4"],
["紅棗","hong2zao3"],
["紅海","hong2hai3"],
["紅筆","hong2bi3"],
["紅腫","hong2zhong3"],
["紅臉","hong2lian3"],
["紅薯","hong2shu3"],
["紅蘿蔔","hong2luo2bo2"],
["紅高粱","hong2gao1liang2"],
["紅不棱登","hong2bu5leng1deng1"],
["紅了一個時期","hong2le5yi2ge4shi2qi1"]
],
"紋":[
["紋理","wen2li3"],
["紋縷","wen2lv5"],
["紋路","wen2lu5"]
],
"納":[
["納指","na4zhi3"],
["納米","na4mi3"],
["納閩","na4min3"],
["納降","na4xiang2"],
["納扎爾巴耶夫","na4zha1er3ba1ye1fu1"]
],
"紓":[
["紓解","shu1jie3"]
],
"純":[
["純品","chun2pin3"],
["純屬","chun2shu3"],
["純樸","chun2pu3"],
["純種","chun2zhong3"],
["純鹼","chun2jian3"]
],
"紙":[
["紙品","zhi3pin3"],
["紙板","zhi3ban3"],
["紙草","zhi3cao3"],
["紙馬","zhi3ma3"],
["紙莎草","zhi3suo1cao3"],
["紙包不住火","zhi3bao1bu5zhu4huo3"]
],
"級":[
["級差","ji2cha1"]
],
"紜":[
["紜苔","yun2tai2"]
],
"素":[
["素有","su4you3"]
],
"索":[
["索取","suo3qu3"],
["索尔","suo3er3"],
["索引","suo3yin3"],
["索爾","suo3er3"],
["索福克裡斯","suo3fu2ke4li3si1"]
],
"紧":[
["紧紧","jin3jin3"],
["紧绷","jin3beng1"],
["紧绷绷","jin3beng1beng1"]
],
"紫":[
["紫草","zi3cao3"],
["紫菜苔","zi3cai4tai2"]
],
"紮":[
["紮營","zha1ying2"],
["紮营","zha1ying2"]
],
"累":[
["累倒","lei4dao3"],
["累坠","lei2zhui5"],
["累墜","lei2zhui5"],
["累月","lei3yue4"],
["累犯","lei3fan4"],
["累积","lei3ji1"],
["累積","lei3ji1"],
["累計","lei3ji4"],
["累计","lei3ji4"],
["累赘","lei2zhui5"],
["累不了","lei4bu5liao3"],
["累不垮","lei4bu5kua3"],
["累不起","lei4bu5qi3"],
["累加器","lei3jia1qi4"],
["累得慌","lei4de5huang5"]
],
"細":[
["細小","xi4xiao3"],
["細想","xi4xiang3"],
["細挑","xi4tiao5"],
["細粉","xi4fen3"],
["細語","xi4yu3"],
["細雨","xi4yu3"],
["細嚼慢咽","xi4jiao2man4yan4"]
],
"紹":[
["紹興","shao4xing1"]
],
"終":[
["終傅","zhong1fu4"],
["終於","zhong1yu2"],
["終止","zhong1zhi3"],
["終點","zhong1dian3"],
["終有一日","zhong1you3yi2ri4"]
],
"組":[
["組分","zu3fen4"],
["組委","zu3wei3"],
["組曲","zu3qu3"],
["組長","zu3zhang3"]
],
"絆":[
["絆住","ban4zhu5"],
["絆倒","ban4dao3"],
["絆腳","ban4jiao3"]
],
"結":[
["結伙","jie2huo3"],
["結好","jie2hao3"],
["結子","jie1zi3"],
["結實","jie1shi2"],
["結尾","jie2wei3"],
["結巴","jie1ba5"],
["結彩","jie2cai3"],
["結果","jie2guo3"],
["結歡","jie2huan1"],
["結滿","jie2man3"],
["結草","jie2cao3"],
["結語","jie2yu3"],
["結識","jie2shi2"],
["結點","jie2dian3"],
["結黨","jie2dang3"],
["結不了","jie2bu5liao3"],
["結結巴巴","jie1jie1ba1ba1"]
],
"絕":[
["絕品","jue2pin3"],
["絕地","jue2di4"],
["絕產","jue2chan3"],
["絕種","jue2zhong3"],
["絕跡","jue2ji4"],
["絕大部份","jue2da4bu4fen4"]
],
"絞":[
["絞扭","jiao3niu3"],
["絞死","jiao3si3"],
["絞索","jiao3suo3"],
["絞盡腦汁","jiao3jin4nao3zhi1"]
],
"給":[
["給予","ji3yu3"],
["給以","gei3yi3"],
["給不了","gei3bu5liao3"],
["給他一大哄","gei3ta1yi2da4hong4"]
],
"絮":[
["絮叨","xu4dao5"],
["絮嘴","xu4zui3"],
["絮烦","xu4fan5"],
["絮煩","xu4fan5"],
["絮語","xu4yu3"],
["絮语","xu4yu3"],
["絮絮叨叨","xu4xu5dao1dao1"]
],
"統":[
["統屬","tong3shu3"],
["統感","tong3gan3"],
["統攬","tong3lan3"],
["統率","tong3shuai4"],
["統管","tong3guan3"],
["統統","tong3tong3"],
["統考","tong3kao3"],
["統領","tong3ling3"],
["統一化","tong3yi2hua4"],
["統一性","tong3yi2xing4"],
["統一碼","tong3yi4ma3"],
["統一大業","tong3yi2da4ye4"],
["統一戰線","tong3yi2zhan4xian4"],
["統一招生","tong3yi4zhao1sheng1"],
["統一核算","tong3yi4he2suan4"],
["統一祖國","tong3yi4zu3guo2"],
["統一規劃","tong3yi4gui1hua4"],
["統一價格法","tong3yi2jia4ge2fa3"]
],
"絲":[
["絲柏","si1bo2"],
["絲縷","si1lv3"],
["絲雨","si1yu3"]
],
"綁":[
["綁匪","bang3fei3"],
["綁紮","bang3zha2"],
["綁緊","bang3jin3"],
["綁腿","bang3tui3"],
["綁走","bang3zou3"]
],
"經":[
["經久","jing1jiu3"],
["經典","jing1dian3"],
["經卷","jing1juan4"],
["經手","jing1shou3"],
["經打","jing1da3"],
["經水","jing1shui3"],
["經理","jing1li3"],
["經管","jing1guan3"],
["經緯","jing1wei3"],
["經解","jing1jie3"],
["經錦","jing1jin3"],
["經不起","jing1bu5qi3"]
],
"綠":[
["綠卡","lv4ka3"],
["綠營","lu4ying2"],
["綠苔","lv4tai2"],
["綠草","lv4cao3"],
["綠黨","lv4dang3"],
["綠油油","lv4you1you1"],
["綠女紅男","lv4nv3hong2nan2"],
["綠林好漢","lu4lin2hao3han4"]
],
"綱":[
["綱領","gang1ling3"]
],
"網":[
["網卡","wang3ka3"],
["網友","wang3you3"],
["網址","wang3zhi3"],
["網孔","wang3kong3"],
["網捕","wang3bu3"],
["網景","wang3jing3"],
["網杓","wang3shao2"],
["網眼","wang3yan3"],
["網管","wang3guan3"],
["網點","wang3dian3"]
],
"綴":[
["綴飾","zhui4shi4"]
],
"綺":[
["綺靡","qi3mi3"]
],
"綿":[
["綿薄","mian2bo2"],
["綿遠","mian2yuan3"],
["綿裡藏針","mian2li3cang2zhen1"]
],
"緊":[
["緊緊","jin3jin3"],
["緊繃","jin3beng1"],
["緊繃繃","jin3beng1beng1"]
],
"線":[
["線桿","xian4gan3"],
["線索","xian4suo3"],
["線纜","xian4lan3"]
],
"緝":[
["緝拿","ji1na2"],
["緝捕","ji1bu3"],
["緝查","ji1cha2"],
["緝獲","ji1huo4"],
["緝私","ji1si1"],
["緝訪","ji1fang3"]
],
"緣":[
["緣分","yuan2fen4"],
["緣起","yuan2qi3"]
],
"編":[
["編審","bian1shen3"],
["編寫","bian1xie3"],
["編導","bian1dao3"],
["編曲","bian1qu3"],
["編碼","bian1ma3"],
["編組","bian1zu3"],
["編綴","bian1zhui4"],
["編纂","bian1zuan3"],
["編者","bian1zhe3"],
["編舞","bian1wu3"],
["編著","bian1zhu4"],
["編輯","bian1ji2"],
["編遣","bian1qian3"],
["編選","bian1xuan3"],
["編派一套瞎話","bian1pai5yi2tao4xia1hua4"]
],
"緩":[
["緩緩","huan3huan3"],
["緩解","huan3jie3"],
["緩不過","huan3bu5guo4"]
],
"緯":[
["緯錦","wei3jin3"]
],
"縣":[
["縣長","xian4zhang3"]
],
"縫":[
["縫上","feng2shang4"],
["縫口","feng2kou3"],
["縫合","feng2he2"],
["縫窮","feng2qiong2"],
["縫紉","feng2ren4"],
["縫絍","feng2ren4"],
["縫綴","feng2zhui4"],
["縫補","feng2bu3"],
["縫製","feng2zhi4"],
["縫針","feng2zhen1"],
["縫衣針","feng2yi1zhen1"],
["縫針跡","feng2zhen1ji4"],
["縫縫連連","feng2feng5lian2lian2"],
["縫衣工人","feng2yi1gong1ren2"]
],
"縮":[
["縮寫","suo1xie3"],
["縮小","suo1xiao3"],
["縮影","suo1ying3"],
["縮水","suo1shui3"],
["縮減","suo1jian3"],
["縮短","suo1duan3"]
],
"縱":[
["縱使","zong4shi3"],
["縱有","zong4you3"],
["縱火","zong4huo3"],
["縱覽","zong4lan3"],
["縱酒","zong4jiu3"]
],
"縴":[
["縴夫","qian4fu1"]
],
"總":[
["總務","zong3wu4"],
["總得","zong3dei3"],
["總有","zong3you3"],
["總理","zong3li3"],
["總管","zong3guan3"],
["總統","zong3tong3"],
["總署","zong3shu3"],
["總覽","zong3lan3"],
["總長","zong3zhang3"],
["總體","zong3ti3"],
["總面積","zong3mian4ji1"]
],
"績":[
["績效","ji4xiao4"],
["績溪","ji4xi1"]
],
"繁":[
["繁体","fan2ti3"],
["繁本","fan2ben3"],
["繁琐","fan2suo3"],
["繁瑣","fan2suo3"],
["繁衍","fan2yan3"],
["繁體","fan2ti3"],
["繁徵博引","fan2zheng1bo2yin3"]
],
"繃":[
["繃子","beng1zi5"],
["繃帶","beng1dai4"],
["繃床","beng1chuang2"],
["繃簧","beng1huang2"],
["繃不住","beng1bu5zhu4"],
["繃不住勁","beng3bu5zhu4jin4"],
["繃不住臉","beng3bu5zhu4lian3"]
],
"織":[
["織品","zhi1pin3"],
["織女","zhi1nv3"],
["織補","zhi1bu3"],
["織錦","zhi1jin3"]
],
"繞":[
["繞地","rao4di4"],
["繞組","rao4zu3"],
["繞不過","rao4bu5guo4"]
],
"繩":[
["繩尺","sheng2chi3"],
["繩索","sheng2suo3"]
],
"繫":[
["繫上","ji4shang5"],
["繫囚","ji4qiu2"],
["繫於一髮","xi4yu2yi2fa4"]
],
"繳":[
["繳還","jiao3huan2"]
],
"繼":[
["繼女","ji4nv3"],
["繼母","ji4mu3"]
],
"續":[
["續假","xu4jia4"],
["續娶","xu4qu3"]
],
"纍":[
["纍贅","lei2zhui5"]
],
"纏":[
["纏得","chan2de2"],
["纏手","chan2shou3"],
["纏擾","chan2rao3"],
["纏累","chan2lei3"],
["纏裹","chan2guo3"],
["纏不清","chan2bu5qing1"]
],
"纖":[
["纖夫","qian4fu1"],
["纖小","xian1xiao3"],
["纖巧","xian1qiao3"],
["纖芯","xian1xin4"]
],
"纠":[
["纠葛","jiu1ge2"]
],
"红":[
["红场","hong2chang3"],
["红堡","hong2bao3"],
["红晕","hong2yun4"],
["红枣","hong2zao3"],
["红海","hong2hai3"],
["红笔","hong2bi3"],
["红肿","hong2zhong3"],
["红脸","hong2lian3"],
["红薯","hong2shu3"],
["红萝蔔","hong2luo2bo2"],
["红高粱","hong2gao1liang2"],
["红不棱登","hong2bu5leng1deng1"],
["红了一个时期","hong2le5yi2ge4shi2qi1"]
],
"纤":[
["纤夫","qian4fu1"],
["纤小","xian1xiao3"],
["纤巧","xian1qiao3"],
["纤芯","xian1xin4"]
],
"约":[
["约坦","yue1tan3"],
["约塔","yao1ta3"],
["约巴","yue1ba1"],
["约摸","yue1mo5"],
["约法","yue1fa3"],
["约珥","yue1er3"],
["约缅","yue1mian3"],
["约莫","yue1mo5"],
["约请","yue1qing3"],
["约不到","yue1bu5dao4"],
["约瑟夫","yue1se4fu1"],
["约维克","yao1wei2ke4"],
["约翰一书","yue1han4yi4shu1"],
["约设巴设","yue1she4ba1she4"]
],
"级":[
["级差","ji2cha1"]
],
"纬":[
["纬锦","wei3jin3"]
],
"纯":[
["纯品","chun2pin3"],
["纯属","chun2shu3"],
["纯朴","chun2pu3"],
["纯碱","chun2jian3"],
["纯种","chun2zhong3"]
],
"纲":[
["纲领","gang1ling3"]
],
"纳":[
["纳指","na4zhi3"],
["纳米","na4mi3"],
["纳闽","na4min3"],
["纳降","na4xiang2"],
["纳闷儿","na4men4r5"],
["纳扎尔巴耶夫","na4zha1er3ba1ye1fu1"]
],
"纵":[
["纵使","zong4shi3"],
["纵有","zong4you3"],
["纵火","zong4huo3"],
["纵览","zong4lan3"],
["纵酒","zong4jiu3"]
],
"纸":[
["纸品","zhi3pin3"],
["纸板","zhi3ban3"],
["纸草","zhi3cao3"],
["纸马","zhi3ma3"],
["纸煤儿","zhi3mei2r5"],
["纸莎草","zhi3suo1cao3"],
["纸马儿","zhi3ma3r5"],
["纸包不住火","zhi3bao1bu5zhu4huo3"]
],
"纹":[
["纹理","wen2li3"],
["纹缕","wen2lv5"],
["纹路","wen2lu5"],
["纹丝儿","wen2si1r5"],
["纹缕儿","wen2lv5r5"]
],
"纾":[
["纾解","shu1jie3"]
],
"线":[
["线杆","xian4gan3"],
["线索","xian4suo3"],
["线缆","xian4lan3"]
],
"组":[
["组分","zu3fen4"],
["组委","zu3wei3"],
["组曲","zu3qu3"],
["组长","zu3zhang3"]
],
"细":[
["细小","xi4xiao3"],
["细想","xi4xiang3"],
["细挑","xi4tiao5"],
["细粉","xi4fen3"],
["细语","xi4yu3"],
["细雨","xi4yu3"],
["细嚼慢咽","xi4jiao2man4yan4"]
],
"织":[
["织品","zhi1pin3"],
["织女","zhi1nv3"],
["织补","zhi1bu3"],
["织锦","zhi1jin3"]
],
"终":[
["终傅","zhong1fu4"],
["终止","zhong1zhi3"],
["终点","zhong1dian3"],
["终有一日","zhong1you3yi2ri4"]
],
"绊":[
["绊住","ban4zhu5"],
["绊倒","ban4dao3"],
["绊脚","ban4jiao3"]
],
"绍":[
["绍兴","shao4xing1"]
],
"经":[
["经上","jing1shang5"],
["经久","jing1jiu3"],
["经典","jing1dian3"],
["经卷","jing1juan4"],
["经手","jing1shou3"],
["经打","jing1da3"],
["经水","jing1shui3"],
["经理","jing1li3"],
["经管","jing1guan3"],
["经纬","jing1wei3"],
["经解","jing1jie3"],
["经锦","jing1jin3"],
["经不起","jing1bu5qi3"]
],
"绑":[
["绑匪","bang3fei3"],
["绑紧","bang3jin3"],
["绑紮","bang3zha2"],
["绑腿","bang3tui3"],
["绑走","bang3zou3"]
],
"结":[
["结伙","jie2huo3"],
["结党","jie2dang3"],
["结发","jie2fa4"],
["结好","jie2hao3"],
["结子","jie1zi3"],
["结实","jie1shi2"],
["结尾","jie2wei3"],
["结巴","jie1ba5"],
["结彩","jie2cai3"],
["结果","jie2guo3"],
["结欢","jie2huan1"],
["结满","jie2man3"],
["结点","jie2dian3"],
["结草","jie2cao3"],
["结识","jie2shi2"],
["结语","jie2yu3"],
["结不了","jie2bu5liao3"],
["结结巴巴","jie1jie1ba1ba1"]
],
"绕":[
["绕地","rao4di4"],
["绕组","rao4zu3"],
["绕不过","rao4bu5guo4"]
],
"给":[
["给予","ji3yu3"],
["给以","gei3yi3"],
["给不了","gei3bu5liao3"],
["给他一大哄","gei3ta1yi2da4hong4"]
],
"绝":[
["绝产","jue2chan3"],
["绝品","jue2pin3"],
["绝地","jue2di4"],
["绝种","jue2zhong3"],
["绝迹","jue2ji4"],
["绝大部份","jue2da4bu4fen4"]
],
"绞":[
["绞扭","jiao3niu3"],
["绞死","jiao3si3"],
["绞索","jiao3suo3"]
],
"统":[
["统属","tong3shu3"],
["统感","tong3gan3"],
["统揽","tong3lan3"],
["统率","tong3shuai4"],
["统管","tong3guan3"],
["统统","tong3tong3"],
["统考","tong3kao3"],
["统领","tong3ling3"],
["统一化","tong3yi2hua4"],
["统一性","tong3yi2xing4"],
["统一码","tong3yi4ma3"],
["统一大业","tong3yi2da4ye4"],
["统一战线","tong3yi2zhan4xian4"],
["统一招生","tong3yi4zhao1sheng1"],
["统一核算","tong3yi4he2suan4"],
["统一祖国","tong3yi4zu3guo2"],
["统一规划","tong3yi4gui1hua4"],
["统一价格法","tong3yi2jia4ge2fa3"]
],
"继":[
["继女","ji4nv3"],
["继母","ji4mu3"]
],
"绩":[
["绩效","ji4xiao4"],
["绩溪","ji4xi1"]
],
"续":[
["续假","xu4jia4"],
["续娶","xu4qu3"]
],
"绮":[
["绮靡","qi3mi3"]
],
"绳":[
["绳尺","sheng2chi3"],
["绳索","sheng2suo3"]
],
"绵":[
["绵薄","mian2bo2"],
["绵远","mian2yuan3"]
],
"绷":[
["绷子","beng1zi5"],
["绷带","beng1dai4"],
["绷床","beng1chuang2"],
["绷簧","beng1huang2"],
["绷不住","beng1bu5zhu4"],
["绷不住劲","beng3bu5zhu4jin4"],
["绷不住脸","beng3bu5zhu4lian3"],
["绷不住劲儿","beng3bu5zhu4jin4r5"]
],
"绿":[
["绿党","lv4dang3"],
["绿卡","lv4ka3"],
["绿苔","lv4tai2"],
["绿草","lv4cao3"],
["绿营","lu4ying2"],
["绿油油","lv4you1you1"],
["绿女红男","lv4nv3hong2nan2"],
["绿林好汉","lu4lin2hao3han4"]
],
"缀":[
["缀饰","zhui4shi4"]
],
"缉":[
["缉拿","ji1na2"],
["缉捕","ji1bu3"],
["缉查","ji1cha2"],
["缉私","ji1si1"],
["缉获","ji1huo4"],
["缉访","ji1fang3"]
],
"缓":[
["缓缓","huan3huan3"],
["缓解","huan3jie3"],
["缓不过","huan3bu5guo4"]
],
"编":[
["编写","bian1xie3"],
["编审","bian1shen3"],
["编导","bian1dao3"],
["编曲","bian1qu3"],
["编码","bian1ma3"],
["编纂","bian1zuan3"],
["编组","bian1zu3"],
["编缀","bian1zhui4"],
["编者","bian1zhe3"],
["编舞","bian1wu3"],
["编著","bian1zhu4"],
["编辑","bian1ji2"],
["编选","bian1xuan3"],
["编遣","bian1qian3"],
["编派一套瞎话","bian1pai5yi2tao4xia1hua4"]
],
"缘":[
["缘分","yuan2fen4"],
["缘起","yuan2qi3"]
],
"缜":[
["缜发","zhen3fa4"]
],
"缝":[
["缝上","feng2shang4"],
["缝制","feng2zhi4"],
["缝口","feng2kou3"],
["缝合","feng2he2"],
["缝穷","feng2qiong2"],
["缝絍","feng2ren4"],
["缝纫","feng2ren4"],
["缝缀","feng2zhui4"],
["缝补","feng2bu3"],
["缝针","feng2zhen1"],
["缝衣针","feng2yi1zhen1"],
["缝针迹","feng2zhen1ji4"],
["缝缝连连","feng2feng5lian2lian2"],
["缝衣工人","feng2yi1gong1ren2"]
],
"缠":[
["缠得","chan2de2"],
["缠手","chan2shou3"],
["缠扰","chan2rao3"],
["缠累","chan2lei3"],
["缠裹","chan2guo3"],
["缠不清","chan2bu5qing1"]
],
"缩":[
["缩写","suo1xie3"],
["缩减","suo1jian3"],
["缩小","suo1xiao3"],
["缩影","suo1ying3"],
["缩水","suo1shui3"],
["缩短","suo1duan3"]
],
"缰":[
["缰绳","jiang1sheng5"]
],
"缴":[
["缴还","jiao3huan2"]
],
"缺":[
["缺口","que1kou3"],
["缺嘴","que1zui3"],
["缺少","que1shao3"],
["缺损","que1sun3"],
["缺損","que1sun3"],
["缺氧","que1yang3"],
["缺水","que1shui3"],
["缺点","que1dian3"],
["缺點","que1dian3"],
["缺一不可","que1yi2bu4ke3"]
],
"罐":[
["罐头","guan4tou5"],
["罐頭","guan4tou5"]
],
"网":[
["网卡","wang3ka3"],
["网友","wang3you3"],
["网址","wang3zhi3"],
["网孔","wang3kong3"],
["网捕","wang3bu3"],
["网景","wang3jing3"],
["网杓","wang3shao2"],
["网点","wang3dian3"],
["网眼","wang3yan3"],
["网管","wang3guan3"]
],
"罕":[
["罕有","han3you3"]
],
"罗":[
["罗以","luo2yi3"],
["罗刹","luo2cha4"],
["罗口","luo2kou3"],
["罗嗦","luo1suo5"],
["罗坦","luo2tan3"],
["罗得","luo2de2"],
["罗索","luo2suo3"],
["罗网","luo2wang3"],
["罗罗","luo2luo5"],
["罗语","luo2yu3"],
["罗马","luo2ma3"],
["罗一秀","luo2yi2xiu4"],
["罗伯逊","luo1bo2xun4"],
["罗圈儿","luo2quan1r5"],
["罗姆酒","luo1mu3jiu3"],
["罗布泊","luo2bu4bo2"],
["罗底巴","luo2di3ba1"],
["罗盛教","luo2cheng2jiao4"],
["罗锅儿","luo2guo1r5"],
["罗切斯特","luo2qie1si1te4"],
["罗摩衍那","luo2mo2yan3na3"],
["罗斯托夫","luo2si1tuo1fu1"],
["罗斯涅夫","luo2si1nie4fu1"],
["罗摩诺索夫","luo2mo2nuo4suo3fu1"],
["罗巴切夫斯基","luo2ba1qie4fu1si1ji1"]
],
"罚":[
["罚款","fa2kuan3"],
["罚酒","fa2jiu3"]
],
"罢":[
["罢了","ba4le5"],
["罢休","ba4xiu1"],
["罢免","ba4mian3"],
["罢官","ba4guan1"],
["罢工","ba4gong1"],
["罢市","ba4shi4"],
["罢手","ba4shou3"],
["罢教","ba4jiao4"],
["罢论","ba4lun4"],
["罢课","ba4ke4"],
["罢黜","ba4chu4"]
],
"罪":[
["罪过","zui4guo5"],
["罪過","zui4guo5"],
["罪行累累","zui4xing2lei3lei3"]
],
"置":[
["置地","zhi4di4"],
["置於","zhi4yu2"],
["置之一笑","zhi4zhi1yi2xiao4"]
],
"罰":[
["罰款","fa2kuan3"],
["罰酒","fa2jiu3"]
],
"罷":[
["罷了","ba4le5"],
["罷休","ba4xiu1"],
["罷免","ba4mian3"],
["罷官","ba4guan1"],
["罷工","ba4gong1"],
["罷市","ba4shi4"],
["罷手","ba4shou3"],
["罷教","ba4jiao4"],
["罷課","ba4ke4"],
["罷論","ba4lun4"],
["罷黜","ba4chu4"]
],
"罹":[
["罹难","li2nan4"],
["罹難","li2nan4"]
],
"羅":[
["羅以","luo2yi3"],
["羅剎","luo2cha4"],
["羅口","luo2kou3"],
["羅嗦","luo1suo5"],
["羅坦","luo2tan3"],
["羅得","luo2de2"],
["羅索","luo2suo3"],
["羅網","luo2wang3"],
["羅羅","luo2luo5"],
["羅語","luo2yu3"],
["羅馬","luo2ma3"],
["羅一秀","luo2yi2xiu4"],
["羅伯遜","luo1bo2xun4"],
["羅姆酒","luo1mu3jiu3"],
["羅布泊","luo2bu4bo2"],
["羅底巴","luo2di3ba1"],
["羅盛教","luo2cheng2jiao4"],
["羅切斯特","luo2qie1si1te4"],
["羅摩衍那","luo2mo2yan3na3"],
["羅斯托夫","luo2si1tuo1fu1"],
["羅斯涅夫","luo2si1nie4fu1"],
["羅摩諾索夫","luo2mo2nuo4suo3fu1"],
["羅巴切夫斯基","luo2ba1qie4fu1si1ji1"]
],
"羊":[
["羊只","yang2zhi1"],
["羊圈","yang2juan4"],
["羊奶","yang2nai3"],
["羊水","yang2shui3"],
["羊腿","yang2tui3"],
["羊舍","yang2she4"],
["羊角","yang2jiao3"],
["羊駝","yang2tuo2"],
["羊驼","yang2tuo2"]
],
"美":[
["美发","mei3fa4"],
["美女","mei3nv3"],
["美好","mei3hao3"],
["美景","mei3jing3"],
["美满","mei3man3"],
["美滿","mei3man3"],
["美語","mei3yu3"],
["美语","mei3yu3"],
["美酒","mei3jiu3"],
["美人儿","mei3ren2r5"],
["美容覺","mei3rong2jiao4"],
["美容觉","mei3rong2jiao4"],
["美差事","mei3chai1shi4"],
["美智子","mei3zhi4zi3"],
["美得受不得","mei3de5shou4bu4de5"]
],
"羞":[
["羞恥","xiu1chi3"],
["羞耻","xiu1chi3"],
["羞辱","xiu1ru3"],
["羞得脸红","xiu1de5lian3hong2"],
["羞得臉紅","xiu1de5lian3hong2"]
],
"群":[
["群体","qun2ti3"],
["群岛","qun2dao3"],
["群島","qun2dao3"],
["群體","qun2ti3"],
["群众组织","qun2zhong4zu3zhi5"],
["群猴猴族","qun2hou2hou5zu2"],
["群眾組織","qun2zhong4zu3zhi5"]
],
"義":[
["義勇","yi4yong3"],
["義務","yi4wu4"],
["義母","yi4mu3"],
["義氣","yi4qi5"],
["義演","yi4yan3"],
["義理","yi4li3"],
["義警","yi4jing3"],
["義馬","yi4ma3"]
],
"羯":[
["羯鼓","jie2gu3"]
],
"羼":[
["羼水","chan4shui3"]
],
"羽":[
["羽冠","yu3guan1"]
],
"翅":[
["翅展","chi4zhan3"],
["翅膀","chi4bang3"]
],
"習":[
["習得","xi2de2"],
["習水","xi2shui3"]
],
"翘":[
["翘首","qiao2shou3"]
],
"翳":[
["翳眼","yi4yan3"]
],
"翹":[
["翹首","qiao2shou3"]
],
"翻":[
["翻供","fan1gong4"],
["翻倒","fan1dao3"],
["翻嘴","fan1zui3"],
["翻悔","fan1hui3"],
["翻拣","fan1jian3"],
["翻揀","fan1jian3"],
["翻涌","fan1yong3"],
["翻滚","fan1gun3"],
["翻滾","fan1gun3"],
["翻版","fan1ban3"],
["翻脸","fan1lian3"],
["翻腾","fan1teng5"],
["翻臉","fan1lian3"],
["翻起","fan1qi3"],
["翻轉","fan1zhuan3"],
["翻转","fan1zhuan3"],
["翻騰","fan1teng5"],
["翻一翻","fan1yi4fan1"],
["翻出來","fan1chu5lai5"],
["翻出来","fan1chu5lai5"],
["翻筋斗","fan1jin1dou5"],
["翻跟斗","fan1gen1dou3"],
["翻过来","fan1guo5lai5"],
["翻過來","fan1guo5lai5"],
["翻天覆地","fan1tian1fu4di4"],
["翻江倒海","fan1jiang1dao3hai3"]
],
"耀":[
["耀眼","yao4yan3"]
],
"老":[
["老叟","lao3sou3"],
["老姥","lao3lao3"],
["老娘","lao3niang2"],
["老婆","lao3po5"],
["老子","lao3zi3"],
["老实","lao3shi5"],
["老實","lao3shi5"],
["老将","lao3jiang4"],
["老將","lao3jiang4"],
["老手","lao3shou3"],
["老挝","lao3wo1"],
["老捨","lao3she3"],
["老撾","lao3wo1"],
["老早","lao3zao3"],
["老是","lao3shi5"],
["老板","lao3ban3"],
["老繭","lao3jian3"],
["老老","lao3lao5"],
["老脸","lao3lian3"],
["老臉","lao3lian3"],
["老舍","lao3she3"],
["老茧","lao3jian3"],
["老虎","lao3hu3"],
["老趼","lao3jian3"],
["老远","lao3yuan3"],
["老遠","lao3yuan3"],
["老酒","lao3jiu3"],
["老闆","lao3ban3"],
["老鴰","lao3gua5"],
["老鸹","lao3gua5"],
["老鼠","lao3shu3"],
["老一輩","lao3yi2bei4"],
["老一辈","lao3yi2bei4"],
["老不修","lao3bu5xiu1"],
["老不死","lao3bu5si3"],
["老人家","lao3ren5jia5"],
["老伴儿","lao3ban4r5"],
["老來少","lao3lai2shao4"],
["老大爷","lao3da4ye5"],
["老大爺","lao3da4ye5"],
["老天爷","lao3tian1ye2"],
["老天爺","lao3tian1ye2"],
["老太爷","lao3tai4ye2"],
["老太爺","lao3tai4ye2"],
["老客儿","lao3ke4r5"],
["老来少","lao3lai2shao4"],
["老不要脸","lao3bu5yao4lian3"],
["老不要臉","lao3bu5yao4lian3"],
["老两口儿","lao3liang3kou3r5"],
["老大不小","lao3da4bu5xiao3"],
["老实巴交","lao3shi5ba1jiao1"],
["老實巴交","lao3shi5ba1jiao1"],
["老少无欺","lao3shao4wu2qi1"],
["老少無欺","lao3shao4wu2qi1"],
["老於世故","lao3yu2shi4gu4"],
["老虎伍兹","lao3hu3wu3zi1"],
["老虎伍茲","lao3hu3wu3zi1"],
["老馬識途","lao3ma3shi2tu2"],
["老马识途","lao3ma3shi2tu2"],
["老年痴獃症","lao3nian2chi1dai1zheng4"],
["老年痴獃癥","lao3nian2chi1dai1zheng4"],
["老子天下第一","lao3zi5tian1xia4di4yi1"],
["老年性痴獃症","lao3nian2xing4chi1dai1zheng4"],
["老年性痴獃癥","lao3nian2xing4chi1dai1zheng4"],
["老虎屁股摸不得","lao3hu3pi4gu5mo1bu5de5"]
],
"考":[
["考上","kao3shang5"],
["考中","kao3zhong4"],
["考卷","kao3juan4"],
["考取","kao3qu3"],
["考古","kao3gu3"],
["考场","kao3chang3"],
["考場","kao3chang3"],
["考究","kao3jiu5"],
["考績","kao3ji4"],
["考绩","kao3ji4"],
["考量","kao3liang2"],
["考不上","kao3bu5shang4"],
["考不中","kao3bu5zhong4"],
["考不取","kao3bu5qu3"],
["考波什堡","kao3bo1shi2bao3"]
],
"而":[
["而且","er2qie3"],
["而已","er2yi3"]
],
"耐":[
["耐久","nai4jiu3"],
["耐水","nai4shui3"],
["耐洗","nai4xi3"],
["耐火","nai4huo3"],
["耐碱","nai4jian3"],
["耐鹼","nai4jian3"],
["耐不住","nai4bu5zhu4"]
],
"耕":[
["耕地","geng1di4"],
["耕种","geng1zhong4"],
["耕種","geng1zhong4"]
],
"耗":[
["耗损","hao4sun3"],
["耗損","hao4sun3"],
["耗盡","hao4jin4"]
],
"耙":[
["耙土","ba4tu3"]
],
"耳":[
["耳屎","er3shi3"],
["耳底","er3di3"],
["耳片","er3pian1"],
["耳語","er3yu3"],
["耳语","er3yu3"],
["耳巴奴","er3ba1nu2"]
],
"耶":[
["耶魯","ye1lu3"],
["耶鲁","ye1lu3"],
["耶戶巴","ye1hu4ba1"],
["耶戶得","ye1hu4de2"],
["耶户巴","ye1hu4ba1"],
["耶户得","ye1hu4de2"]
],
"耻":[
["耻辱","chi3ru3"],
["耻骨","chi3gu3"]
],
"耽":[
["耽搁","dan1ge5"],
["耽擱","dan1ge5"],
["耽於","dan1yu2"],
["耽溺","dan1ni4"],
["耽誤","dan1wu5"],
["耽误","dan1wu5"]
],
"耿":[
["耿耿","geng3geng3"],
["耿餅","geng3bing3"],
["耿饼","geng3bing3"],
["耿耿於懷","geng3geng3yu2huai2"]
],
"聂":[
["聂耳","nie4er3"]
],
"职":[
["职分","zhi2fen4"],
["职务","zhi2wu4"],
["职场","zhi2chang3"],
["职守","zhi2shou3"]
],
"聒":[
["聒耳","guo1er3"]
],
"联":[
["联想","lian2xiang3"],
["联手","lian2shou3"],
["联欢","lian2huan1"],
["联网","lian2wang3"],
["联署","lian2shu3"],
["联考","lian2kao3"],
["联不到","lian2bu5dao4"],
["联成一组","lian2cheng2yi4zu3"]
],
"聖":[
["聖地","sheng4di4"],
["聖子","sheng4zi3"],
["聖所","sheng4suo3"],
["聖手","sheng4shou3"],
["聖旨","sheng4zhi3"],
["聖母","sheng4mu3"],
["聖水","sheng4shui3"],
["聖洗","sheng4xi3"],
["聖火","sheng4huo3"],
["聖禮","sheng4li3"],
["聖者","sheng4zhe3"],
["聖跡","sheng4ji4"],
["聖體","sheng4ti3"],
["聖經外傳","sheng4jing1wai4zhuan4"],
["聖經賢傳","sheng4jing1xian2zhuan4"],
["聖赫勒拿","sheng4he4lei1na2"],
["聖潘克勒斯站","sheng4pan1ke4lei1si1zhan4"]
],
"聘":[
["聘礼","pin4li3"],
["聘禮","pin4li3"],
["聘請","pin4qing3"],
["聘请","pin4qing3"]
],
"聚":[
["聚伙","ju4huo3"],
["聚拢","ju4long3"],
["聚攏","ju4long3"],
["聚敛","ju4lian3"],
["聚斂","ju4lian3"],
["聚点","ju4dian3"],
["聚賭","ju4du3"],
["聚赌","ju4du3"],
["聚酯","ju4zhi3"],
["聚飲","ju4yin3"],
["聚饮","ju4yin3"],
["聚點","ju4dian3"],
["聚居地","ju4ju1di4"]
],
"聞":[
["聞喜","wen2xi3"],
["聞得","wen2de2"],
["聞一多","wen2yi4duo1"],
["聞不出","wen2bu5chu1"],
["聞不得","wen2bu5de2"],
["聞不見","wen2bu5jian4"],
["聞得見","wen2de5jian4"],
["聞一知十","wen2yi4zhi1shi2"]
],
"聪":[
["聪敏","cong1min3"],
["聪明","cong1ming5"],
["聪颖","cong1ying3"]
],
"聯":[
["聯想","lian2xiang3"],
["聯手","lian2shou3"],
["聯歡","lian2huan1"],
["聯網","lian2wang3"],
["聯署","lian2shu3"],
["聯考","lian2kao3"],
["聯不到","lian2bu5dao4"],
["聯成一組","lian2cheng2yi4zu3"]
],
"聰":[
["聰敏","cong1min3"],
["聰明","cong1ming5"],
["聰穎","cong1ying3"]
],
"聲":[
["聲卡","sheng1ka3"],
["聲樂","sheng1yue4"],
["聲母","sheng1mu3"],
["聲響","sheng1xiang3"]
],
"聶":[
["聶耳","nie4er3"]
],
"職":[
["職分","zhi2fen4"],
["職務","zhi2wu4"],
["職場","zhi2chang3"],
["職守","zhi2shou3"]
],
"聽":[
["聽取","ting1qu3"],
["聽審","ting1shen3"],
["聽寫","ting1xie3"],
["聽懂","ting1dong3"],
["聽筒","ting1tong3"],
["聽者","ting1zhe3"],
["聽聽","ting1ting5"],
["聽講","ting1jiang3"],
["聽頭","ting1tou5"],
["聽骨","ting1gu3"],
["聽不到","ting1bu5dao4"],
["聽不得","ting1bu5de5"],
["聽不懂","ting1bu5dong3"],
["聽不清","ting1bu5qing1"],
["聽不見","ting1bu5jian4"],
["聽不進","ting1bu5jin4"],
["聽得出","ting1de5chu1"],
["聽得懂","ting1de2dong3"],
["聽清楚","ting1qing1chu3"],
["聽說過","ting1shuo1guo5"],
["聽不下去","ting1bu5xia4qu4"],
["聽不明白","ting1bu5ming2bai5"],
["聽不清楚","ting1bu5qing1chu3"],
["聽不進去","ting1bu5jin4qu5"]
],
"肃":[
["肃反","su4fan3"]
],
"肅":[
["肅反","su4fan3"]
],
"肆":[
["肆拾","si4shi2"]
],
"肇":[
["肇始","zhao4shi3"]
],
"肉":[
["肉体","rou4ti3"],
["肉眼","rou4yan3"],
["肉餅","rou4bing3"],
["肉饼","rou4bing3"],
["肉體","rou4ti3"]
],
"肋":[
["肋骨","lei4gu3"]
],
"肌":[
["肌体","ji1ti3"],
["肌體","ji1ti3"]
],
"肘":[
["肘尺","zhou3chi3"]
],
"肚":[
["肚腹","du3fu4"]
],
"肝":[
["肝胆","gan1dan3"],
["肝膽","gan1dan3"]
],
"肠":[
["肠管","chang2guan3"]
],
"股":[
["股息","gu3xi1"],
["股本","gu3ben3"],
["股癣","gu3xuan3"],
["股癬","gu3xuan3"],
["股骨","gu3gu3"]
],
"肢":[
["肢体","zhi1ti3"],
["肢解","zhi1jie3"],
["肢體","zhi1ti3"]
],
"肤":[
["肤浅","fu1qian3"]
],
"肥":[
["肥实","fei2shi5"],
["肥實","fei2shi5"],
["肥美","fei2mei3"],
["肥瘦得中","fei2shou4de2zhong1"]
],
"肩":[
["肩上","jian1shang5"],
["肩胛","jian1jia3"],
["肩膀","jian1bang3"]
],
"肮":[
["肮脏","ang1zang5"]
],
"肱":[
["肱骨","gong1gu3"]
],
"育":[
["育水","yu4shui3"]
],
"肺":[
["肺腑","fei4fu3"]
],
"胀":[
["胀起","zhang4qi3"]
],
"胃":[
["胃口","wei4kou3"]
],
"胆":[
["胆小","dan3xiao3"],
["胆敢","dan3gan3"],
["胆管","dan3guan3"]
],
"背":[
["背上","bei4shang5"],
["背包","bei1bao1"],
["背带","bei1dai4"],
["背帶","bei1dai4"],
["背影","bei4ying3"],
["背景","bei4jing3"],
["背篓","bei1lou3"],
["背簍","bei1lou3"],
["背脊","bei4ji3"],
["背負","bei1fu4"],
["背负","bei1fu4"],
["背起","bei1qi3"],
["背骨","bei4gu3"],
["背地風","bei4di4feng1"],
["背地风","bei4di4feng1"],
["背影儿","bei4ying3r5"],
["背着手","bei4zhe5shou3"],
["背著手","bei4zhe5shou3"],
["背黑鍋","bei1hei1guo1"],
["背黑锅","bei1hei1guo1"],
["背城一战","bei4cheng2yi2zhan4"],
["背城一戰","bei4cheng2yi2zhan4"],
["背水一战","bei4shui3yi2zhan4"],
["背水一戰","bei4shui3yi2zhan4"]
],
"胎":[
["胎兒","tai1er2"]
],
"胜":[
["胜地","sheng4di4"],
["胜诉","sheng4su4"],
["胜选","sheng4xuan3"]
],
"胞":[
["胞藻","bao1zao3"]
],
"胡":[
["胡乐","hu2yue4"],
["胡塗","hu2tu5"],
["胡夫","hu2fu1"],
["胡巴","hu2ba1"],
["胡扯","hu2che3"],
["胡樂","hu2yue4"],
["胡琴","hu2qin5"],
["胡琴儿","hu2qin2er5"],
["胡琴兒","hu2qin2er5"],
["胡芦巴","hu2lu2ba1"],
["胡蘆巴","hu2lu2ba1"],
["胡作非为","hu2zuo4fei1wei2"],
["胡作非為","hu2zuo4fei1wei2"],
["胡搞一通","hu2gao3yi4tong1"]
],
"胰":[
["胰岛","yi2dao3"],
["胰島","yi2dao3"]
],
"胳":[
["胳肢","ge2zhi5"],
["胳臂","ge1bei5"]
],
"胶":[
["胶体","jiao1ti3"],
["胶卷","jiao1juan3"],
["胶子","jiao1zi3"],
["胶水","jiao1shui3"],
["胶粘","jiao1nian2"]
],
"胸":[
["胸口","xiong1kou3"],
["胸椎","xiong1zhui1"],
["胸甲","xiong1jia3"],
["胸骨","xiong1gu3"]
],
"能":[
["能为","neng2wei2"],
["能否","neng2fou3"],
["能干","neng2gan4"],
["能所","neng2suo3"],
["能手","neng2shou3"],
["能指","neng2zhi3"],
["能為","neng2wei2"],
["能耐","neng2nai5"],
["能不够","neng2bu5gou4"],
["能不夠","neng2bu5gou4"]
],
"脈":[
["脈口","mai4kou3"],
["脈息","mai4xi1"],
["脈管","mai4guan3"],
["脈診","mai4zhen3"]
],
"脉":[
["脉口","mai4kou3"],
["脉息","mai4xi1"],
["脉管","mai4guan3"],
["脉诊","mai4zhen3"]
],
"脊":[
["脊柱","ji3zhu4"],
["脊梁","ji3liang5"],
["脊椎","ji3zhui1"],
["脊樑","ji3liang2"],
["脊索","ji3suo3"],
["脊線","ji3xian4"],
["脊线","ji3xian4"],
["脊肋","ji3lei4"],
["脊背","ji3bei4"],
["脊骨","ji3gu3"],
["脊髓","ji3sui3"],
["脊樑骨","ji3liang5gu3"]
],
"脏":[
["脏乱","zang1luan4"],
["脏土","zang1tu3"],
["脏字","zang1zi4"],
["脏弹","zang1dan4"],
["脏水","zang1shui3"],
["脏污","zang1wu1"],
["脏煤","zang1mei2"],
["脏病","zang1bing4"],
["脏脏","zang1zang1"],
["脏腑","zang4fu3"],
["脏话","zang1hua4"],
["脏不过","zang1bu5guo4"]
],
"脐":[
["脐屎","qi2shi3"],
["脐梗","qi2geng3"]
],
"脑":[
["脑岛","nao3dao3"],
["脑干","nao3gan4"],
["脑海","nao3hai3"],
["脑袋","nao3dai5"],
["脑脊液","nao3ji3ye4"]
],
"脖":[
["脖領","bo2ling3"],
["脖领","bo2ling3"],
["脖頸兒","bo2geng3r5"],
["脖颈儿","bo2geng3r5"]
],
"脚":[
["脚底","jiao3di3"],
["脚掌","jiao3zhang3"],
["脚本","jiao3ben3"],
["脚行","jiao3hang2"],
["脚趾","jiao3zhi3"],
["脚踩","jiao3cai3"],
["脚蹼","jiao3pu3"],
["脚踏实地","jiao3ta4shi2di4"]
],
"脫":[
["脫口","tuo1kou3"],
["脫手","tuo1shou3"],
["脫敏","tuo1min3"],
["脫氧","tuo1yang3"],
["脫水","tuo1shui3"],
["脫灑","tuo1sa3"],
["脫產","tuo1chan3"],
["脫稿","tuo1gao3"],
["脫羽","tuo1yu3"],
["脫軌","tuo1gui3"],
["脫險","tuo1xian3"],
["脫靶","tuo1ba3"],
["脫黨","tuo1dang3"],
["脫不了","tuo1bu5liao3"],
["脫不開","tuo1bu5kai1"],
["脫不得身","tuo1bu5de5shen1"],
["脫骨成佛","tuo1gu3cheng2fo2"]
],
"脱":[
["脱产","tuo1chan3"],
["脱党","tuo1dang3"],
["脱发","tuo1fa4"],
["脱口","tuo1kou3"],
["脱手","tuo1shou3"],
["脱敏","tuo1min3"],
["脱氧","tuo1yang3"],
["脱水","tuo1shui3"],
["脱洒","tuo1sa3"],
["脱稿","tuo1gao3"],
["脱羽","tuo1yu3"],
["脱轨","tuo1gui3"],
["脱险","tuo1xian3"],
["脱靶","tuo1ba3"],
["脱不了","tuo1bu5liao3"],
["脱不开","tuo1bu5kai1"],
["脱不得身","tuo1bu5de5shen1"],
["脱骨成佛","tuo1gu3cheng2fo2"]
],
"脸":[
["脸孔","lian3kong3"],
["脸谱","lian3pu3"],
["脸蛋儿","lian3dan4r5"],
["脸色一沉","lian3se4yi4chen2"]
],
"脹":[
["脹起","zhang4qi3"]
],
"脾":[
["脾气","pi2qi5"],
["脾氣","pi2qi5"]
],
"腌":[
["腌臜","a1za5"],
["腌臢","a1za5"]
],
"腐":[
["腐乳","fu3ru3"],
["腐朽","fu3xiu3"]
],
"腦":[
["腦島","nao3dao3"],
["腦海","nao3hai3"],
["腦袋","nao3dai5"],
["腦脊液","nao3ji3ye4"]
],
"腮":[
["腮骨","sai1gu3"]
],
"腰":[
["腰果","yao1guo3"],
["腰椎","yao1zhui1"]
],
"腳":[
["腳底","jiao3di3"],
["腳掌","jiao3zhang3"],
["腳本","jiao3ben3"],
["腳行","jiao3hang2"],
["腳趾","jiao3zhi3"],
["腳踩","jiao3cai3"],
["腳蹼","jiao3pu3"],
["腳踏實地","jiao3ta4shi2di4"]
],
"腸":[
["腸管","chang2guan3"]
],
"腹":[
["腹地","fu4di4"],
["腹誹","fu4fei3"],
["腹诽","fu4fei3"]
],
"腻":[
["腻友","ni4you3"],
["腻味","ni4wei5"],
["腻烦","ni4fan5"]
],
"腼":[
["腼腆","mian3tian5"]
],
"膀":[
["膀胱","pang2guang1"]
],
"膏":[
["膏立","gao4li4"]
],
"膚":[
["膚淺","fu1qian3"]
],
"膠":[
["膠卷","jiao1juan3"],
["膠子","jiao1zi3"],
["膠水","jiao1shui3"],
["膠粘","jiao1nian2"],
["膠體","jiao1ti3"]
],
"膩":[
["膩友","ni4you3"],
["膩味","ni4wei5"],
["膩煩","ni4fan5"]
],
"膽":[
["膽小","dan3xiao3"],
["膽敢","dan3gan3"],
["膽管","dan3guan3"]
],
"臂":[
["臂膀","bi4bang3"]
],
"臃":[
["臃肿","yong1zhong3"],
["臃腫","yong1zhong3"]
],
"臉":[
["臉孔","lian3kong3"],
["臉譜","lian3pu3"],
["臉色一沉","lian3se4yi4chen2"]
],
"臍":[
["臍屎","qi2shi3"],
["臍梗","qi2geng3"]
],
"臟":[
["臟腑","zang4fu3"]
],
"臣":[
["臣子","chen2zi3"],
["臣一主二","chen2yi4zhu3er4"]
],
"臥":[
["臥佛","wo4fo2"],
["臥倒","wo4dao3"],
["臥底","wo4di3"],
["臥虎","wo4hu3"],
["臥軌","wo4gui3"]
],
"臨":[
["臨場","lin2chang3"],
["臨寫","lin2xie3"],
["臨帖","lin2tie4"],
["臨武","lin2wu3"],
["臨死","lin2si3"],
["臨海","lin2hai3"],
["臨澧","lin2li3"],
["臨產","lin2chan3"],
["臨難","lin2nan4"],
["臨門一腳","lin2men2yi4jiao3"]
],
"自":[
["自主","zi4zhu3"],
["自传","zi4zhuan4"],
["自傳","zi4zhuan4"],
["自刎","zi4wen3"],
["自取","zi4qu3"],
["自古","zi4gu3"],
["自在","zi4zai5"],
["自始","zi4shi3"],
["自导","zi4dao3"],
["自導","zi4dao3"],
["自己","zi4ji3"],
["自得","zi4de2"],
["自我","zi4wo3"],
["自找","zi4zhao3"],
["自有","zi4you3"],
["自此","zi4ci3"],
["自毀","zi4hui3"],
["自毁","zi4hui3"],
["自满","zi4man3"],
["自滿","zi4man3"],
["自理","zi4li3"],
["自盡","zi4jin4"],
["自省","zi4xing3"],
["自給","zi4ji3"],
["自给","zi4ji3"],
["自詡","zi4xu3"],
["自诩","zi4xu3"],
["自走","zi4zou3"],
["自轉","zi4zhuan4"],
["自转","zi4zhuan4"],
["自首","zi4shou3"],
["自命为","zi4ming4wei2"],
["自命為","zi4ming4wei2"],
["自留地","zi4liu2di4"],
["自一推万","zi4yi4tui1wan4"],
["自一推萬","zi4yi4tui1wan4"],
["自作聪明","zi4zuo4cong1ming2"],
["自作聰明","zi4zuo4cong1ming2"],
["自吹自擂","zi4chui1zi4lei2"],
["自由自在","zi4you2zi4zai4"],
["自繇自在","zi4you2zi4zai5"],
["自視甚高","zi4shi4shen4gao1"],
["自视甚高","zi4shi4shen4gao1"]
],
"臬":[
["臬氧","nie4yang3"]
],
"臭":[
["臭氧","chou4yang3"],
["臭美","chou4mei3"],
["臭跡","chou4ji4"],
["臭迹","chou4ji4"],
["臭子儿","chou4zi3r5"],
["臭子兒","chou4zi3r5"],
["臭名昭著","chou4ming2zhao1zhu4"]
],
"至":[
["至好","zhi4hao3"],
["至宝","zhi4bao3"],
["至寶","zhi4bao3"],
["至少","zhi4shao3"],
["至当","zhi4dang4"],
["至於","zhi4yu2"],
["至此","zhi4ci3"],
["至死","zhi4si3"],
["至當","zhi4dang4"],
["至不济","zhi4bu5ji4"],
["至不濟","zhi4bu5ji4"]
],
"致":[
["致使","zhi4shi3"],
["致死","zhi4si3"],
["致力於","zhi4li4yu2"]
],
"臺":[
["臺北","tai2bei3"],
["臺地","tai2di4"],
["臺海","tai2hai3"],
["臺灣關系法","tai2wan1guan1xi5fa3"]
],
"臼":[
["臼齒","jiu4chi3"],
["臼齿","jiu4chi3"]
],
"舀":[
["舀水","yao3shui3"]
],
"舅":[
["舅嫂","jiu4sao3"],
["舅母","jiu4mu5"],
["舅舅","jiu4jiu5"]
],
"與":[
["與會","yu4hui4"],
["與時俱進","yu3shi2ju1jin4"]
],
"興":[
["興亡","xing1wang2"],
["興仁","xing1ren2"],
["興兵","xing1bing1"],
["興化","xing1hua4"],
["興和","xing1he2"],
["興國","xing1guo2"],
["興城","xing1cheng2"],
["興奮","xing1fen4"],
["興安","xing1an1"],
["興寧","xing1ning2"],
["興山","xing1shan1"],
["興平","xing1ping2"],
["興建","xing1jian4"],
["興文","xing1wen2"],
["興旺","xing1wang4"],
["興榮","xing1rong2"],
["興海","xing1hai3"],
["興盛","xing1sheng4"],
["興縣","xing1xian4"],
["興義","xing1yi4"],
["興衰","xing1shuai1"],
["興起","xing1qi3"],
["興辦","xing1ban4"],
["興隆","xing1long2"],
["興不開","xing1bu5kai1"],
["興中會","xing1zhong1hui4"],
["興得起來","xing1de5qi3lai5"],
["興業銀行","xing1ye4yin2hang2"],
["興都庫仕","xing1du1ku4shi4"],
["興高彩烈","xing1gao1cai3lie4"],
["興凱刺鰟鮍","xing1kai3ci4pang2pi2"],
["興都庫什山","xing1du1ku4shi2shan1"]
],
"舉":[
["舉手","ju3shou3"],
["舉止","ju3zhi3"],
["舉起","ju3qi3"],
["舉一廢百","ju3yi2fei4bai3"],
["舉一賅百","ju3yi4gai1bai3"]
],
"舊":[
["舊友","jiu4you3"],
["舊地","jiu4di4"],
["舊址","jiu4zhi3"],
["舊好","jiu4hao3"],
["舊損","jiu4sun3"],
["舊版","jiu4ban3"],
["舊識","jiu4shi2"],
["舊跡","jiu4ji4"],
["舊都","jiu4du1"],
["舊雨","jiu4yu3"],
["舊體","jiu4ti3"],
["舊地重遊","jiu4di4chong2you2"]
],
"舌":[
["舌头","she2tou5"],
["舌頭","she2tou5"]
],
"舍":[
["舍下","she4xia4"],
["舍利","she4li4"],
["舍己","she3ji3"],
["舍玛","she4ma3"],
["舍瑪","she4ma3"],
["舍不了","she3bu5liao3"],
["舍不得","she3bu5de5"],
["舍伊拉","she4yi1la1"],
["舍伯那","she4bo2na4"],
["舍利子","she4li4zi3"],
["舍得了","she3de5liao3"],
["舍穆理","she4mu4li3"],
["舍己为人","she3ji3wei4ren2"],
["舍己爲人","she3ji3wei4ren2"],
["舍巴尼雅","she4ba1ni2ya3"],
["舍迦尼雅","she4jia1ni2ya3"]
],
"舒":[
["舒坦","shu1tan5"],
["舒展","shu1zhan3"],
["舒服","shu1fu5"]
],
"舔":[
["舔吮","tian3shun3"],
["舔一舔","tian3yi4tian3"]
],
"舞":[
["舞曲","wu3qu3"],
["舞者","wu3zhe3"],
["舞蹈","wu3dao3"]
],
"舟":[
["舟曲","zhou1qu3"]
],
"航":[
["航母","hang2mu3"],
["航海","hang2hai3"],
["航跡","hang2ji4"],
["航迹","hang2ji4"]
],
"舰":[
["舰只","jian4zhi1"],
["舰艇","jian4ting3"],
["舰长","jian4zhang3"]
],
"舵":[
["舵手","duo4shou3"],
["舵把","duo4ba3"]
],
"船":[
["船主","chuan2zhu3"],
["船只","chuan2zhi1"],
["船夫","chuan2fu1"],
["船尾","chuan2wei3"],
["船底","chuan2di3"],
["船板","chuan2ban3"],
["船篷","chuan2peng2"],
["船長","chuan2zhang3"],
["船长","chuan2zhang3"]
],
"艦":[
["艦艇","jian4ting3"],
["艦長","jian4zhang3"]
],
"良":[
["良久","liang2jiu3"],
["良友","liang2you3"],
["良好","liang2hao3"],
["良渚","liang2zhu3"],
["良港","liang2gang3"],
["良种","liang2zhong3"],
["良種","liang2zhong3"],
["良馬","liang2ma3"],
["良马","liang2ma3"]
],
"艰":[
["艰苦","jian1ku3"],
["艰险","jian1xian3"]
],
"艱":[
["艱苦","jian1ku3"],
["艱險","jian1xian3"]
],
"色":[
["色子","shai3zi5"],
["色彩","se4cai3"],
["色相","se4xiang4"],
["色胆","se4dan3"],
["色膽","se4dan3"],
["色長","se4zhang3"],
["色长","se4zhang3"],
["色鬼","se4gui3"]
],
"艾":[
["艾塔","ai4ta3"],
["艾押","yi4ya1"],
["艾舒","yi4shu1"],
["艾雅","yi4ya3"],
["艾哈迈德","ai4ha3mai4de2"],
["艾哈邁德","ai4ha3mai4de2"],
["艾尔米塔什","ai4er3mi3ta3shi2"],
["艾爾米塔什","ai4er3mi3ta3shi2"]
],
"节":[
["节俭","jie2jian3"],
["节气","jie2qi5"],
["节水","jie2shui3"],
["节点","jie2dian3"],
["节省","jie2sheng3"],
["节选","jie2xuan3"]
],
"芋":[
["芋头","yu4tou5"],
["芋艿","yu4nai3"],
["芋頭","yu4tou5"]
],
"芍":[
["芍药","shao2yao5"],
["芍藥","shao2yao5"],
["芍陂","que4pi2"]
],
"芒":[
["芒果","mang2guo3"],
["芒种","mang2zhong4"],
["芒種","mang2zhong4"]
],
"芝":[
["芝宇","zhi1yu3"],
["芝麻","zhi1ma5"]
],
"芥":[
["芥兰","gai4lan2"],
["芥末","jie4mo5"],
["芥蓝","gai4lan2"],
["芥藍","gai4lan2"],
["芥蘭","gai4lan2"],
["芥子气","jie4zi3qi4"],
["芥子氣","jie4zi3qi4"],
["芥兰牛肉","jie4lan2niu2rou4"],
["芥蘭牛肉","jie4lan2niu2rou4"]
],
"芦":[
["芦笋","lu2sun3"],
["芦管","lu2guan3"],
["芦苇","lu2wei3"]
],
"芫":[
["芫荽","yan2sui5"]
],
"芭":[
["芭蕾","ba1lei3"]
],
"花":[
["花儿","hua1r5"],
["花冠","hua1guan1"],
["花匠","hua1jiang4"],
["花呢","hua1ni2"],
["花哨","hua1shao5"],
["花头","hua1tou5"],
["花展","hua1zhan3"],
["花巧","hua1qiao3"],
["花彩","hua1cai3"],
["花朵","hua1duo3"],
["花果","hua1guo3"],
["花梗","hua1geng3"],
["花洒","hua1sa3"],
["花灑","hua1sa3"],
["花甲","hua1jia3"],
["花粉","hua1fen3"],
["花草","hua1cao3"],
["花蕊","hua1rui3"],
["花蕾","hua1lei3"],
["花都","hua1du1"],
["花頭","hua1tou5"],
["花鳥","hua1niao3"],
["花鸟","hua1niao3"],
["花鼓","hua1gu3"],
["花不完","hua1bu5wan2"],
["花不起","hua1bu5qi3"],
["花岗岩","hua1gang1yan2"],
["花岗石","hua1gang1shi2"],
["花崗岩","hua1gang1yan2"],
["花崗石","hua1gang1shi2"],
["花旗参","hua1qi2shen1"],
["花旗參","hua1qi2shen1"],
["花朝節","hua1zhao1jie2"],
["花朝节","hua1zhao1jie2"],
["花生浆","hua1sheng1jiang4"],
["花生漿","hua1sheng1jiang4"],
["花衣服","hua1yi1fu2"],
["花不棱登","hua1bu5leng1deng1"],
["花朝月夕","hua1zhao1yue4xi1"],
["花花搭搭","hua1hua5da1da1"],
["花花肠子","hua1hua5chang2zi5"],
["花花腸子","hua1hua5chang2zi5"]
],
"芸":[
["芸苔","yun2tai2"],
["芸苔子","yun2tai2zi3"]
],
"苌":[
["苌楚","chang2chu3"]
],
"苍":[
["苍劲","cang1jing4"],
["苍老","cang1lao3"],
["苍莽","cang1mang3"],
["苍生涂炭","cang1sheng1tu2tan4"]
],
"苏":[
["苏尔","su1er3"],
["苏打","su1da2"],
["苏武","su1wu3"],
["苏法","su1fa3"],
["苏瓦","su1wa3"],
["苏甲","su1jia3"],
["苏醒","su1xing3"],
["苏铁","su1tie3"],
["苏打水","su1da3shui3"],
["苏联之友社","su1lian2zhi1you3she4"]
],
"苔":[
["苔草","tai2cao3"],
["苔藓","tai2xian3"],
["苔蘚","tai2xian3"]
],
"苗":[
["苗圃","miao2pu3"],
["苗条","miao2tiao5"],
["苗條","miao2tiao5"]
],
"苟":[
["苟且","gou3qie3"],
["苟得","gou3de2"]
],
"苤":[
["苤蓝","pie3lan5"],
["苤藍","pie3lan5"]
],
"苦":[
["苦主","ku3zhu3"],
["苦参","ku3shen1"],
["苦參","ku3shen1"],
["苦口","ku3kou3"],
["苦处","ku3chu5"],
["苦头","ku3tou5"],
["苦差","ku3chai1"],
["苦干","ku3gan4"],
["苦恼","ku3nao3"],
["苦惱","ku3nao3"],
["苦果","ku3guo3"],
["苦楚","ku3chu3"],
["苦水","ku3shui3"],
["苦海","ku3hai3"],
["苦胆","ku3dan3"],
["苦膽","ku3dan3"],
["苦苦","ku3ku3"],
["苦處","ku3chu5"],
["苦酒","ku3jiu3"],
["苦难","ku3nan4"],
["苦難","ku3nan4"],
["苦頭","ku3tou5"],
["苦不唧儿","ku3bu5ji1r5"],
["苦不唧兒","ku3bu5ji1r5"],
["苦盡甘來","ku3jin4gan1lai2"]
],
"英":[
["英亩","ying1mu3"],
["英勇","ying1yong3"],
["英尺","ying1chi3"],
["英法","ying1fa3"],
["英畝","ying1mu3"],
["英語","ying1yu3"],
["英语","ying1yu3"],
["英里","ying1li3"],
["英仙座","ying1xian1zuo4"],
["英仙臂","ying1xian1bi4"]
],
"苹":[
["苹果","ping2guo3"]
],
"茁":[
["茁長","zhuo2zhang3"],
["茁长","zhuo2zhang3"]
],
"茂":[
["茂港","mao4gang3"]
],
"范":[
["范缜","fan4zhen3"]
],
"茄":[
["茄子","qie2zi5"],
["茄科","qie2ke1"],
["茄紅素","qie2hong2su4"],
["茄红素","qie2hong2su4"],
["茄萣乡","qie2ding4xiang1"],
["茄萣鄉","qie2ding4xiang1"]
],
"茅":[
["茅舍","mao2she4"],
["茅塞頓開","mao2se4dun4kai1"],
["茅塞顿开","mao2se4dun4kai1"]
],
"茉":[
["茉莉","mo4li5"]
],
"茜":[
["茜紫","qian4zi3"],
["茜草","qian4cao3"]
],
"茨":[
["茨菰","ci2gu5"]
],
"茬":[
["茬口","cha2kou3"],
["茬地","cha2di5"]
],
"茶":[
["茶几","cha2ji1"],
["茶匙","cha2chi2"],
["茶点","cha2dian3"],
["茶碗","cha2wan3"],
["茶碱","cha2jian3"],
["茶隼","cha2sun3"],
["茶館","cha2guan3"],
["茶馆","cha2guan3"],
["茶鹼","cha2jian3"],
["茶點","cha2dian3"],
["茶馆儿","cha2guan3r5"]
],
"荀":[
["荀子","xun2zi3"]
],
"草":[
["草地","cao3di4"],
["草场","cao3chang3"],
["草場","cao3chang3"],
["草拟","cao3ni3"],
["草擬","cao3ni3"],
["草本","cao3ben3"],
["草率","cao3shuai4"],
["草稿","cao3gao3"],
["草草","cao3cao3"],
["草菇","cao3gu1"],
["草食动物","cao3shi2dong4wu5"],
["草食動物","cao3shi2dong4wu5"]
],
"荒":[
["荒土","huang1tu3"],
["荒地","huang1di4"],
["荒岛","huang1dao3"],
["荒島","huang1dao3"],
["荒野","huang1ye3"]
],
"荔":[
["荔浦","li4pu3"]
],
"荚":[
["荚果","jia2guo3"],
["荚膜组织胞浆菌","jia2mo4zu3zhi1bao1jiang1jun1"]
],
"荣":[
["荣美","rong2mei3"],
["荣誉教授","rong2yu2jiao4shou4"]
],
"荥":[
["荥经","ying2jing1"]
],
"荨":[
["荨麻","qian2ma2"],
["荨麻疹","xun2ma2zhen3"]
],
"药":[
["药典","yao4dian3"],
["药品","yao4pin3"],
["药检","yao4jian3"],
["药水","yao4shui3"],
["药师佛","yao4shi1fo2"],
["药水儿","yao4shui3r5"]
],
"荳":[
["荳角","dou4jiao3"],
["荳角儿","dou4jiao3r5"]
],
"荷":[
["荷馬","he2ma3"],
["荷马","he2ma3"]
],
"荸":[
["荸荠","bi2qi5"],
["荸薺","bi2qi5"]
],
"莊":[
["莊子","zhuang1zi3"],
["莊老","zhuang1lao3"],
["莊稼地","zhuang1jia5di4"]
],
"莞":[
["莞尔","wan3er3"],
["莞爾","wan3er3"],
["莞尔一笑","wan3er3yi2xiao4"],
["莞爾一笑","wan3er3yi2xiao4"]
],
"莢":[
["莢果","jia2guo3"],
["莢膜組織胞漿菌","jia2mo4zu3zhi1bao1jiang1jun1"]
],
"莫":[
["莫講","mo4jiang3"],
["莫讲","mo4jiang3"],
["莫可指数","mo4ke3zhi3shu3"],
["莫可指數","mo4ke3zhi3shu3"],
["莫名一文","mo4ming2yi4wen2"],
["莫卧儿王朝","mo4wo4r5wang2chao2"]
],
"莲":[
["莲子","lian2zi3"]
],
"莴":[
["莴笋","wo1sun3"]
],
"获":[
["获准","huo4zhun3"],
["获取","huo4qu3"],
["获奖","huo4jiang3"],
["获得","huo4de2"],
["获选","huo4xuan3"]
],
"莺":[
["莺鸟","ying1niao3"]
],
"莽":[
["莽草","mang3cao3"]
],
"菌":[
["菌子","jun4zi5"]
],
"菜":[
["菜圃","cai4pu3"],
["菜地","cai4di4"],
["菜籽","cai4zi3"],
["菜譜","cai4pu3"],
["菜谱","cai4pu3"],
["菜鳥","cai4niao3"],
["菜鸟","cai4niao3"]
],
"菥":[
["菥蓂","xi1mi4"]
],
"華":[
["華佗","hua4tuo2"],
["華北","hua2bei3"],
["華山","hua4shan1"],
["華府","hua2fu3"],
["華彩","hua2cai3"],
["華美","hua2mei3"],
["華表","hua2biao3"],
["華語","hua2yu3"],
["華里","hua2li3"],
["華鎣","hua2ying2"],
["華爾茲","hua2er3zi5"],
["華羅庚","hua4luo2geng1"],
["華興會","hua2xing1hui4"],
["華納兄弟","hua4na4xiong1di4"],
["華納音樂集團","hua4na4yin1yue4ji2tuan2"],
["華嚴經大方廣佛","hua2yan2jing1da4fang1guang3fo2"]
],
"菱":[
["菱角","ling2jiao5"]
],
"菲":[
["菲比","fei1bi3"]
],
"菸":[
["菸碱","yan1jian3"],
["菸蒂","yan1di4"],
["菸鹼","yan1jian3"],
["菸碱酸","yu1jian3suan1"],
["菸鹼酸","yu1jian3suan1"]
],
"菹":[
["菹醢","zu1hai3"]
],
"萃":[
["萃取","cui4qu3"],
["萃於一堂","cui4yu2yi4tang2"],
["萃於一身","cui4yu2yi4shen1"]
],
"萇":[
["萇楚","chang2chu3"]
],
"萎":[
["萎靡","wei3mi3"]
],
"萝":[
["萝北","luo2bei3"]
],
"萤":[
["萤火","ying2huo3"]
],
"营":[
["营养","ying2yang3"],
["营口","ying2kou3"],
["营地","ying2di4"],
["营垒","ying2lei3"]
],
"萧":[
["萧索","xiao1suo3"],
["萧一山","xiao1yi4shan1"],
["萧子显","xiao1zi3xian3"]
],
"萨":[
["萨凯","sa4kai3"],
["萨嘎","sa4ga1"],
["萨尔","sa4er3"],
["萨巴","sa4ba1"],
["萨里","sa4li3"],
["萨哈洛夫","sa4ha1luo4fu1"],
["萨哈罗夫","sa4ha3luo2fu1"],
["萨哈诺夫","sa4ha3nuo4fu1"],
["萨卡什维利","sa4ka3shi2wei2li4"],
["萨达姆侯赛因","sa4da2mu3hou4sai4yin1"]
],
"萬":[
["萬古","wan4gu3"],
["萬有","wan4you3"],
["萬里","wan4li3"],
["萬事得","wan4shi4de2"],
["萬無一失","wan4wu2yi4shi1"],
["萬維天羅地網","wan4wei2tian1luo2di4wang3"]
],
"萵":[
["萵筍","wo1sun3"]
],
"落":[
["落伍","luo4wu3"],
["落地","luo4di4"],
["落榜","luo4bang3"],
["落水","luo4shui3"],
["落笔","luo4bi3"],
["落筆","luo4bi3"],
["落網","luo4wang3"],
["落网","luo4wang3"],
["落选","luo4xuan3"],
["落選","luo4xuan3"],
["落难","luo4nan4"],
["落難","luo4nan4"],
["落馬","luo4ma3"],
["落马","luo4ma3"],
["落下來","luo4xia5lai5"],
["落下来","luo4xia5lai5"],
["落不下","lao4bu5xia4"],
["落不着","lao4bu5zhao2"],
["落不著","lao4bu5zhao2"]
],
"葉":[
["葉挺","ye4ting3"],
["葉枕","ye4zhen3"],
["葉柄","ye4bing3"]
],
"著":[
["著书","zhu4shu1"],
["著作","zhu4zuo4"],
["著兒","zhao1r5"],
["著力","zhuo2li4"],
["著吃","zhao2chi1"],
["著名","zhu4ming2"],
["著墨","zhuo2mo4"],
["著家","zhao2jia1"],
["著實","zhuo2shi2"],
["著床","zhuo2chuang2"],
["著录","zhu4lu4"],
["著忙","zhao2mang2"],
["著急","zhao2ji2"],
["著想","zhuo2xiang3"],
["著意","zhuo2yi4"],
["著慌","zhao2huang1"],
["著手","zhuo2shou3"],
["著書","zhu4shu1"],
["著棋","zhuo2qi2"],
["著法","zhao1fa3"],
["著涼","zhao2liang2"],
["著火","zhao2huo3"],
["著用","zhao2yong4"],
["著眼","zhuo2yan3"],
["著稱","zhu4cheng1"],
["著筆","zhuo2bi3"],
["著緊","zhao2jin3"],
["著色","zhuo2se4"],
["著落","zhuo2luo4"],
["著處","zhuo2chu4"],
["著衣","zhuo2yi1"],
["著裝","zhuo2zhuang1"],
["著述","zhu4shu4"],
["著迷","zhao2mi2"],
["著邊","zhao2bian1"],
["著重","zhuo2zhong4"],
["著錄","zhu4lu4"],
["著陸","zhuo2lu4"],
["著風","zhao2feng1"],
["著魔","zhao2mo2"],
["著勁兒","zhuo2jin4r5"],
["著称于世","zhu4cheng1yu2shi4"],
["著稱於世","zhu4cheng1yu2shi4"],
["著三不著兩","zhao2san1bu4zhao2liang3"]
],
"葛":[
["葛巾","ge2jin1"],
["葛布","ge2bu4"],
["葛根","ge2gen1"],
["葛粉","ge2fen3"],
["葛藤","ge2teng2"],
["葛洲坝","ge2zhou1ba4"],
["葛洲壩","ge2zhou1ba4"],
["葛縷子","ge3lve3zi5"],
["葛缕子","ge3lve3zi5"]
],
"葡":[
["葡萄","pu2tao5"],
["葡萄乾","pu2tao5gan1"],
["葡萄园","pu2tao2yuan2"],
["葡萄園","pu2tao2yuan2"],
["葡萄柚","pu2tao2you4"],
["葡萄汁","pu2tao2zhi1"],
["葡萄牙","pu2tao2ya2"],
["葡萄藤","pu2tao2teng2"],
["葡萄干儿","pu2tao5gan1r5"]
],
"葫":[
["葫芦","hu2lu5"],
["葫蘆","hu2lu5"],
["葫芦巴","hu2lu2ba1"],
["葫蘆巴","hu2lu2ba1"]
],
"葬":[
["葬礼","zang4li3"],
["葬禮","zang4li3"]
],
"葱":[
["葱岭","cong1ling3"]
],
"葵":[
["葵涌","kui2yong3"],
["葵花子","kui2hua1zi3"]
],
"蒙":[
["蒙医","meng3yi1"],
["蒙古","meng3gu3"],
["蒙文","meng3wen2"],
["蒙茸","meng2rong2"],
["蒙覆","meng3fu4"],
["蒙醫","meng3yi1"],
["蒙难","meng2nan4"],
["蒙難","meng2nan4"],
["蒙館","meng2guan3"],
["蒙馆","meng2guan3"],
["蒙騙","meng1pian4"],
["蒙骗","meng1pian4"],
["蒙代尔","meng1dai4er3"],
["蒙代爾","meng1dai4er3"],
["蒙蒙黑","meng1meng1hei1"],
["蒙帕納斯","meng3pa4na4si1"],
["蒙帕纳斯","meng3pa4na4si1"],
["蒙得維的亞","meng2de2wei2di4ya4"],
["蒙得维的亚","meng2de2wei2di4ya4"]
],
"蒜":[
["蒜茸","suan4rong2"]
],
"蒴":[
["蒴果","shuo4guo3"]
],
"蒸":[
["蒸餃","zheng1jiao3"],
["蒸饺","zheng1jiao3"]
],
"蒺":[
["蒺藜","ji2li5"]
],
"蒼":[
["蒼勁","cang1jing4"],
["蒼老","cang1lao3"],
["蒼莽","cang1mang3"]
],
"蓄":[
["蓄养","xu4yang3"],
["蓄水","xu4shui3"],
["蓄養","xu4yang3"]
],
"蓋":[
["蓋上","gai4shang5"],
["蓋好","gai4hao3"],
["蓋爾","gai4er3"],
["蓋革計數器","ge3ge2ji4shu4qi4"]
],
"蓓":[
["蓓蕾","bei4lei3"]
],
"蓝":[
["蓝藻","lan2zao3"],
["蓝领","lan2ling3"]
],
"蓬":[
["蓬茸","peng2rong2"]
],
"蓮":[
["蓮子","lian2zi3"]
],
"蓼":[
["蓼蓝","liao3lan2"],
["蓼藍","liao3lan2"]
],
"蔓":[
["蔓延","man4yan2"],
["蔓生","man4sheng1"],
["蔓草","man4cao3"],
["蔓菁","man2jing5"],
["蔓越桔","man4yue4ju2"],
["蔓越橘","man4yue4ju2"]
],
"蔗":[
["蔗农","zhe4nong2"],
["蔗糖","zhe4tang2"],
["蔗農","zhe4nong2"],
["蔗露","zhe4lu4"]
],
"蔚":[
["蔚为","wei4wei2"],
["蔚為","wei4wei2"]
],
"蔥":[
["蔥嶺","cong1ling3"]
],
"蔼":[
["蔼蔼","ai3ai3"]
],
"蔽":[
["蔽体","bi4ti3"],
["蔽體","bi4ti3"]
],
"蕁":[
["蕁麻","qian2ma2"],
["蕁麻疹","xun2ma2zhen3"]
],
"蕃":[
["蕃薯","fan1shu3"],
["蕃衍","fan2yan3"]
],
"蕉":[
["蕉岭","jiao1ling3"],
["蕉嶺","jiao1ling3"]
],
"蕠":[
["蕠漆","ru2lv2"]
],
"蕭":[
["蕭索","xiao1suo3"],
["蕭一山","xiao1yi4shan1"],
["蕭子顯","xiao1zi3xian3"]
],
"蕴":[
["蕴藉","yun4jie4"]
],
"薄":[
["薄产","bo2chan3"],
["薄利","bo2li4"],
["薄厚","bo2hou4"],
["薄命","bo2ming4"],
["薄地","bo2di4"],
["薄幸","bo2xing4"],
["薄弱","bo2ruo4"],
["薄待","bo2dai4"],
["薄情","bo2qing2"],
["薄技","bo2ji4"],
["薄明","bo2ming2"],
["薄晓","bo2xiao3"],
["薄暗","bo2an4"],
["薄暮","bo2mu4"],
["薄曉","bo2xiao3"],
["薄板","bao2ban3"],
["薄海","bo2hai3"],
["薄產","bo2chan3"],
["薄田","bo2tian2"],
["薄礼","bo2li3"],
["薄禮","bo2li3"],
["薄紗","bo2sha1"],
["薄紙","bao2zhi3"],
["薄纱","bo2sha1"],
["薄纸","bao2zhi3"],
["薄膜","bo2mo2"],
["薄荷","bo4he5"],
["薄酒","bao2jiu3"],
["薄酬","bo2chou2"],
["薄雾","bo2wu4"],
["薄霧","bo2wu4"],
["薄面","bo2mian4"],
["薄餅","bao2bing3"],
["薄饼","bao2bing3"],
["薄麵","bo2mian4"],
["薄一波","bo2yi4bo1"],
["薄油层","bo2you2ceng2"],
["薄油層","bo2you2ceng2"],
["薄烤餅","bo2kao3bing3"],
["薄烤饼","bo2kao3bing3"],
["薄熙來","bo2xi1lai2"],
["薄熙来","bo2xi1lai2"],
["薄瑞光","bo2rui4guang1"],
["薄养厚葬","bo2yang3hou4zang4"],
["薄胎瓷器","bo2tai1ci2qi4"],
["薄養厚葬","bo2yang3hou4zang4"]
],
"薏":[
["薏米","yi4mi3"]
],
"薑":[
["薑餅","jiang1bing3"],
["薑饼","jiang1bing3"],
["薑子牙","jiang1zi3ya2"]
],
"薩":[
["薩凱","sa4kai3"],
["薩嘎","sa4ga1"],
["薩巴","sa4ba1"],
["薩爾","sa4er3"],
["薩裡","sa4li3"],
["薩哈洛夫","sa4ha1luo4fu1"],
["薩哈羅夫","sa4ha3luo2fu1"],
["薩哈諾夫","sa4ha3nuo4fu1"],
["薩卡什維利","sa4ka3shi2wei2li4"],
["薩達姆侯賽因","sa4da2mu3hou4sai4yin1"]
],
"薪":[
["薪水","xin1shui5"],
["薪酬","xin1chou2"]
],
"薹":[
["薹草","tai2cao3"]
],
"藉":[
["藉口","jie4kou3"],
["藉由","jie4you2"],
["藉着","jie4zhe5"],
["藉著","jie4zhe5"]
],
"藍":[
["藍藻","lan2zao3"],
["藍領","lan2ling3"]
],
"藏":[
["藏人","zang4ren2"],
["藏文","zang4wen2"],
["藏族","zang4zu2"],
["藏独","zang4du2"],
["藏獒","zang4ao2"],
["藏獨","zang4du2"],
["藏羚","zang4ling2"],
["藏語","zang4yu3"],
["藏语","zang4yu3"],
["藏象","zang4xiang4"],
["藏躲","cang2duo3"],
["藏不住","cang2bu5zhu4"],
["藏紅花","zang4hong2hua1"],
["藏經洞","zang4jing1dong4"],
["藏红花","zang4hong2hua1"],
["藏经洞","zang4jing1dong4"],
["藏羚羊","cang2ling2yang2"],
["藏茴香果","zang4hui2xiang1guo3"]
],
"藤":[
["藤蔓","teng2man4"],
["藤野","teng2ye3"]
],
"藥":[
["藥典","yao4dian3"],
["藥品","yao4pin3"],
["藥檢","yao4jian3"],
["藥水","yao4shui3"],
["藥師佛","yao4shi1fo2"]
],
"藹":[
["藹藹","ai3ai3"]
],
"蘆":[
["蘆筍","lu2sun3"],
["蘆管","lu2guan3"],
["蘆葦","lu2wei3"]
],
"蘇":[
["蘇打","su1da2"],
["蘇武","su1wu3"],
["蘇法","su1fa3"],
["蘇爾","su1er3"],
["蘇瓦","su1wa3"],
["蘇甲","su1jia3"],
["蘇醒","su1xing3"],
["蘇鐵","su1tie3"],
["蘇打水","su1da3shui3"],
["蘇聯之友社","su1lian2zhi1you3she4"]
],
"蘊":[
["蘊藉","yun4jie4"]
],
"蘋":[
["蘋果","ping2guo3"]
],
"蘭":[
["蘭塞","lan2sai4"],
["蘭考","lan2kao3"],
["蘭譜","lan2pu3"]
],
"蘿":[
["蘿北","luo2bei3"]
],
"虎":[
["虎口","hu3kou3"],
["虎骨","hu3gu3"],
["虎不拉","hu4bu5la3"],
["虎爪派","hu3zhua3pai4"],
["虎父无犬子","hu3fu4wu2quan3zi3"],
["虎父無犬子","hu3fu4wu2quan3zi3"]
],
"處":[
["處世","chu3shi4"],
["處事","chu3shi4"],
["處分","chu3fen4"],
["處在","chu3zai4"],
["處境","chu3jing4"],
["處女","chu3nv3"],
["處所","chu4suo3"],
["處方","chu3fang1"],
["處於","chu3yu2"],
["處暑","chu3shu3"],
["處死","chu3si3"],
["處決","chu3jue2"],
["處治","chu3zhi4"],
["處理","chu3li3"],
["處男","chu3nan2"],
["處置","chu3zhi4"],
["處罰","chu3fa2"],
["處身","chu3shen1"],
["處不下","chu4bu5xia4"],
["處不來","chu3bu5lai2"],
["處得來","chu3de5lai2"],
["處之泰然","chu3zhi1tai4ran2"]
],
"虚":[
["虚伪","xu1wei3"],
["虚假","xu1jia3"],
["虚拟","xu1ni3"],
["虚警","xu1jing3"],
["虚谎","xu1huang3"],
["虚与委蛇","xu1yu3wei1yi2"],
["虚惊一场","xu1jing1yi4chang3"],
["虚无缥缈","xu1wu2piao1miao3"],
["虚晃一下","xu1huang3yi2xia4"],
["虚晃一枪","xu1huang3yi4qiang1"],
["虚空藏菩萨","xu1kong1zang4pu2sa4"]
],
"虛":[
["虛假","xu1jia3"],
["虛偽","xu1wei3"],
["虛擬","xu1ni3"],
["虛謊","xu1huang3"],
["虛警","xu1jing3"],
["虛晃一下","xu1huang3yi2xia4"],
["虛晃一槍","xu1huang3yi4qiang1"],
["虛無縹緲","xu1wu2piao1miao3"],
["虛與委蛇","xu1yu3wei1yi2"],
["虛驚一場","xu1jing1yi4chang3"],
["虛空藏菩薩","xu1kong1zang4pu2sa4"]
],
"虞":[
["虞喜","yu2xi3"],
["虞应龙","yu2ying4long2"],
["虞應龍","yu2ying4long2"]
],
"號":[
["號叫","hao2jiao4"],
["號啕","hao2tao2"],
["號喪","hao2sang5"],
["號碼","hao4ma3"],
["號筒","hao4tong3"],
["號角","hao4jiao3"]
],
"虧":[
["虧折","kui1she2"],
["虧損","kui1sun3"],
["虧本","kui1ben3"],
["虧產","kui1chan3"],
["虧空","kui1kong5"]
],
"虫":[
["虫草","chong2cao3"]
],
"虰":[
["虰蛵","ding1xing2"]
],
"虹":[
["虹吸","hong2xi1"],
["虹桥","hong2qiao2"],
["虹橋","hong2qiao2"],
["虹膜","hong2mo2"],
["虹口区","hong2kou3qu1"],
["虹口區","hong2kou3qu1"]
],
"虺":[
["虺蛇","hui3she2"]
],
"虼":[
["虼蚤","ge4zao5"]
],
"虾":[
["虾子","xia1zi3"],
["虾饺","xia1jiao3"],
["虾兵蟹将","xia1bing1xie4jiang4"]
],
"蚂":[
["蚂蚁","ma3yi3"],
["蚂蚱","ma4zha5"]
],
"蚍":[
["蚍蜉","pi2fu2"]
],
"蚕":[
["蚕卵","can2luan3"]
],
"蚯":[
["蚯蚓","qiu1yin3"]
],
"蚰":[
["蚰蜒","you2yan5"]
],
"蚱":[
["蚱蜢","zha4meng3"]
],
"蛇":[
["蛇岛","she2dao3"],
["蛇島","she2dao3"],
["蛇夫座","she2fu1zuo4"]
],
"蛙":[
["蛙泳","wa1yong3"]
],
"蛤":[
["蛤蚧","ge2jie4"],
["蛤蜊","ge2li2"]
],
"蛮":[
["蛮干","man2gan4"],
["蛮横","man2heng4"],
["蛮邸","man2di3"]
],
"蜀":[
["蜀相","shu3xiang4"],
["蜀錦","shu3jin3"],
["蜀锦","shu3jin3"]
],
"蜂":[
["蜂起","feng1qi3"],
["蜂鳥","feng1niao3"],
["蜂鸟","feng1niao3"]
],
"蜃":[
["蜃景","shen4jing3"]
],
"蜈":[
["蜈蚣","wu2gong1"]
],
"蜚":[
["蜚声","fei1sheng1"],
["蜚聲","fei1sheng1"],
["蜚語","fei1yu3"],
["蜚语","fei1yu3"]
],
"蜜":[
["蜜枣","mi4zao3"],
["蜜棗","mi4zao3"]
],
"蜡":[
["蜡笔","la4bi3"]
],
"蝇":[
["蝇子","ying2zi5"]
],
"蝈":[
["蝈蝈","guo1guo5"],
["蝈蝈儿","guo1guo5r5"],
["蝈蝈笼","guo1guo1long2"]
],
"蝌":[
["蝌蚪","ke1dou3"]
],
"蝗":[
["蝗蝻","huang2nan3"]
],
"蝦":[
["蝦乾","xia1gan1"],
["蝦子","xia1zi3"],
["蝦餃","xia1jiao3"],
["蝦兵蟹將","xia1bing1xie4jiang4"]
],
"蝲":[
["蝲蛄","la4gu3"]
],
"蝶":[
["蝶泳","die2yong3"],
["蝶骨","die2gu3"]
],
"蝼":[
["蝼蚁","lou2yi3"]
],
"融":[
["融解","rong2jie3"],
["融雪","rong2xue3"],
["融为一体","rong2wei2yi4ti3"],
["融合为一","rong2he2wei4yi1"],
["融合為一","rong2he2wei4yi1"],
["融為一體","rong2wei2yi4ti3"]
],
"螞":[
["螞蚱","ma4zha5"],
["螞蟻","ma3yi3"]
],
"螢":[
["螢火","ying2huo3"]
],
"螺":[
["螺杆","luo2gan3"],
["螺桨","luo2jiang3"],
["螺桿","luo2gan3"],
["螺槳","luo2jiang3"],
["螺母","luo2mu3"]
],
"螻":[
["螻蟻","lou2yi3"]
],
"蟈":[
["蟈蟈","guo1guo5"],
["蟈蟈籠","guo1guo1long2"]
],
"蟲":[
["蟲草","chong2cao3"]
],
"蟹":[
["蟹獴","xie4meng3"],
["蟹粉","xie4fen3"]
],
"蠅":[
["蠅子","ying2zi5"]
],
"蠟":[
["蠟筆","la4bi3"]
],
"蠶":[
["蠶卵","can2luan3"]
],
"蠻":[
["蠻橫","man2heng4"],
["蠻邸","man2di3"]
],
"血":[
["血口","xue4kou3"],
["血史","xue4shi3"],
["血拼","xue2pin1"],
["血本","xue4ben3"],
["血染","xue4ran3"],
["血水","xue4shui3"],
["血洗","xue4xi3"],
["血管","xue4guan3"],
["血統","xue4tong3"],
["血统","xue4tong3"],
["血肠","xie3chang2"],
["血肿","xue4zhong3"],
["血腫","xue4zhong3"],
["血腸","xie3chang2"],
["血跡","xue4ji4"],
["血迹","xue4ji4"],
["血雨","xue4yu3"],
["血压计","xie3ya1ji4"],
["血友病","xue4you3bing4"],
["血壓計","xie3ya1ji4"],
["血债累累","xue4zhai4lei3lei3"],
["血債累累","xue4zhai4lei3lei3"],
["血流漂杵","xue4liu2piao1chu3"],
["血濃於水","xue4nong2yu2shui3"],
["血跡斑斑","xue4ji1ban1ban1"],
["血迹斑斑","xue4ji1ban1ban1"]
],
"行":[
["行业","hang2ye4"],
["行为","xing2wei2"],
["行乞","xing2qi3"],
["行伍","hang2wu3"],
["行使","xing2shi3"],
["行列","hang2lie4"],
["行家","hang2jia1"],
["行市","hang2shi5"],
["行当","hang2dang5"],
["行情","hang2qing2"],
["行李","xing2li5"],
["行業","hang2ye4"],
["行止","xing2zhi3"],
["行為","xing2wei2"],
["行當","hang2dang5"],
["行省","xing2sheng3"],
["行礼","xing2li3"],
["行禮","xing2li3"],
["行署","xing2shu3"],
["行草","xing2cao3"],
["行走","xing2zou3"],
["行都","xing2du1"],
["行長","hang2zhang3"],
["行长","hang2zhang3"],
["行間","hang2jian1"],
["行间","hang2jian1"],
["行駛","xing2shi3"],
["行驶","xing2shi3"],
["行不去","xing2bu5qu4"],
["行不开","xing2bu5kai1"],
["行不得","xing2bu5de5"],
["行不行","xing2bu5xing2"],
["行不通","xing2bu5tong1"],
["行不開","xing2bu5kai1"],
["行兇者","xing4xiong1zhe3"],
["行李箱","xing2li3xiang1"],
["行行出状元","hang2hang2chu1zhuang4yuan5"],
["行行出狀元","hang2hang2chu1zhuang4yuan5"]
],
"術":[
["術語","shu4yu3"]
],
"街":[
["街上","jie1shang5"]
],
"衙":[
["衙門","ya2men5"],
["衙门","ya2men5"]
],
"衛":[
["衛冕","wei4mian3"]
],
"衝":[
["衝垮","chong1kua3"],
["衝打","chong1da3"],
["衝著","chong4zhe5"]
],
"衡":[
["衡水","heng2shui3"],
["衡量","heng2liang5"],
["衡量得失","heng2liang2de2shi1"]
],
"衣":[
["衣子","yi1zi3"],
["衣摆","yi1bai3"],
["衣擺","yi1bai3"],
["衣服","yi1fu5"],
["衣着","yi1zhuo2"],
["衣著","yi1zhuo2"],
["衣被","yi4bei4"],
["衣領","yi1ling3"],
["衣领","yi1ling3"],
["衣单食薄","yi1dan1shi2bo2"],
["衣單食薄","yi1dan1shi2bo2"],
["衣服縫邊","yi1fu5feng2bian1"],
["衣服缝边","yi1fu5feng2bian1"],
["衣錦榮歸","yi4jin3rong2gui1"],
["衣錦還鄉","yi4jin3huan2xiang1"],
["衣锦荣归","yi4jin3rong2gui1"],
["衣锦还乡","yi4jin3huan2xiang1"]
],
"补":[
["补丁","bu3ding5"],
["补体","bu3ti3"],
["补养","bu3yang3"],
["补品","bu3pin3"],
["补法","bu3fa3"],
["补码","bu3ma3"],
["补种","bu3zhong4"],
["补给","bu3ji3"],
["补缀","bu3zhui4"],
["补考","bu3kao3"],
["补角","bu3jiao3"],
["补语","bu3yu3"],
["补选","bu3xuan3"]
],
"表":[
["表土","biao3tu3"],
["表姐","biao3jie3"],
["表尺","biao3chi3"],
["表徵","biao3zheng1"],
["表演","biao3yan3"],
["表率","biao3shuai4"],
["表裡","biao3li3"],
["表語","biao3yu3"],
["表语","biao3yu3"],
["表里","biao3li3"]
],
"衬":[
["衬里","chen4li3"]
],
"衰":[
["衰减","shuai1jian3"],
["衰減","shuai1jian3"],
["衰老","shuai1lao3"]
],
"袋":[
["袋鼠","dai4shu3"]
],
"袖":[
["袖口","xiu4kou3"],
["袖筒","xiu4tong3"],
["袖筒儿","xiu4tong3r5"]
],
"被":[
["被卧","bei4wo5"],
["被抢","bei4qiang3"],
["被捕","bei4bu3"],
["被搶","bei4qiang3"],
["被臥","bei4wo5"],
["被誉为","bei4yu4wei2"],
["被譽為","bei4yu4wei2"],
["被子植物","bei4zi3zhi2wu4"]
],
"袼":[
["袼褙","ge1bei5"]
],
"裁":[
["裁减","cai2jian3"],
["裁剪","cai2jian3"],
["裁減","cai2jian3"],
["裁縫","cai2feng2"],
["裁缝","cai2feng2"]
],
"裂":[
["裂口","lie4kou3"],
["裂谷","lie4gu3"]
],
"装":[
["装假","zhuang1jia3"],
["装好","zhuang1hao3"],
["装扮","zhuang1ban4"],
["装有","zhuang1you3"],
["装满","zhuang1man3"],
["装甲","zhuang1jia3"],
["装不下","zhuang1bu5xia4"]
],
"補":[
["補丁","bu3ding5"],
["補品","bu3pin3"],
["補法","bu3fa3"],
["補碼","bu3ma3"],
["補種","bu3zhong4"],
["補給","bu3ji3"],
["補綴","bu3zhui4"],
["補考","bu3kao3"],
["補角","bu3jiao3"],
["補語","bu3yu3"],
["補選","bu3xuan3"],
["補養","bu3yang3"],
["補體","bu3ti3"]
],
"裝":[
["裝假","zhuang1jia3"],
["裝好","zhuang1hao3"],
["裝扮","zhuang1ban4"],
["裝有","zhuang1you3"],
["裝滿","zhuang1man3"],
["裝甲","zhuang1jia3"],
["裝不下","zhuang1bu5xia4"]
],
"裡":[
["裡人","li3ren2"],
["裡加","li3jia1"],
["裡外","li3wai4"],
["裡實","li3shi2"],
["裡帶","li3dai4"],
["裡昂","li3ang2"],
["裡根","li3gen1"],
["裡海","li3hai3"],
["裡衣","li3yi1"],
["裡邊","li3bian5"],
["裡面","li3mian4"],
["裡頭","li3tou5"],
["裡士滿","li3shi4man3"],
["裡奧斯","li3ao4si1"],
["裡斯本","li3si1ben3"],
["裡港鄉","li3gang3xiang1"],
["裡邊兒","li3bian1r5"],
["裡出外進","li3chu1wai4jin4"],
["裡瓦爾多","li3wa3er3duo1"],
["裡裡外外","li3li3wai4wai4"]
],
"裤":[
["裤腿","ku4tui3"]
],
"裨":[
["裨益","bi4yi4"]
],
"裱":[
["裱糊","biao3hu2"]
],
"裸":[
["裸体","luo3ti3"],
["裸體","luo3ti3"],
["裸子植物","luo3zi3zhi2wu4"]
],
"裹":[
["裹脚","guo3jiao3"],
["裹腳","guo3jiao3"]
],
"製":[
["製假","zhi4jia3"],
["製品","zhi4pin3"],
["製導","zhi4dao3"],
["製鞋匠","zhi4xie2jiang4"]
],
"複":[
["複寫","fu4xie3"],
["複本","fu4ben3"],
["複比","fu4bi3"],
["複眼","fu4yan3"]
],
"褲":[
["褲腿","ku4tui3"]
],
"襁":[
["襁褓","qiang3bao3"]
],
"襯":[
["襯裡","chen4li3"]
],
"西":[
["西乃","xi1nai3"],
["西北","xi1bei3"],
["西坦","xi1tan3"],
["西塔","xi1ta3"],
["西巴","xi1ba1"],
["西法","xi1fa3"],
["西满","xi1man3"],
["西滿","xi1man3"],
["西点","xi1dian3"],
["西珥","xi1er3"],
["西米","xi1mi3"],
["西緬","xi1mian3"],
["西缅","xi1mian3"],
["西美","xi1mei3"],
["西藏","xi1zang4"],
["西边","xi1bian5"],
["西邊","xi1bian5"],
["西雅","xi1ya3"],
["西點","xi1dian3"],
["西公都","xi1gong1du1"],
["西裡爾","xi1li3er3"],
["西边儿","xi1bian5r5"],
["西門子","xi1men2zi3"],
["西门子","xi1men2zi3"],
["西格蒙德","xi1ge2meng1de2"],
["西西裡島","xi1xi1li3dao3"]
],
"要":[
["要击","yao1ji1"],
["要务","yao4wu4"],
["要務","yao4wu4"],
["要口","yao4kou3"],
["要吐","yao4tu4"],
["要地","yao4di4"],
["要塞","yao4sai4"],
["要好","yao4hao3"],
["要少","yao4shao3"],
["要得","yao4de2"],
["要指","yao4zhi3"],
["要挟","yao1xie2"],
["要挾","yao1xie2"],
["要擊","yao1ji1"],
["要旨","yao4zhi3"],
["要是","yao4shi5"],
["要晕","yao1yun1"],
["要暈","yao1yun1"],
["要有","yao4you3"],
["要束","yao1shu4"],
["要死","yao4si3"],
["要求","yao1qiu2"],
["要点","yao4dian3"],
["要紧","yao4jin3"],
["要緊","yao4jin3"],
["要脸","yao4lian3"],
["要臉","yao4lian3"],
["要角","yao4jiao3"],
["要謊","yao4huang3"],
["要谎","yao4huang3"],
["要領","yao4ling3"],
["要领","yao4ling3"],
["要點","yao4dian3"],
["要不得","yao4bu5de5"],
["要不是","yao4bu5shi4"],
["要不然","yao4bu5ran2"],
["要不要","yao4bu5yao4"],
["要样儿","yao4yang4r5"]
],
"覆":[
["覆沒","fu4mo4"],
["覆没","fu4mo4"]
],
"覈":[
["覈准","he2zhun3"]
],
"見":[
["見地","jian4di4"],
["見好","jian4hao3"],
["見解","jian4jie3"],
["見訪","jian4fang3"],
["見鬼","jian4gui3"],
["見不到","jian4bu5dao4"],
["見不得","jian4bu5de5"],
["見不著","jian4bu5zhao2"],
["見得了","jian4de5liao3"],
["見得著","jian4de5zhao2"],
["見微知著","jian4wei1zhi1zhu4"]
],
"規":[
["規劃","gui1hua4"],
["規管","gui1guan3"],
["規一化","gui1yi2hua4"],
["規矩準繩","gui1ju3zhun3sheng2"],
["規規矩矩","gui1gui5ju1ju1"]
],
"覓":[
["覓取","mi4qu3"],
["覓得","mi4de2"]
],
"視":[
["視差","shi4cha1"],
["視為","shi4wei2"],
["視角","shi4jiao3"],
["視野","shi4ye3"],
["視同兒戲","shi4tong2er2xi4"],
["視微知著","shi4wei1zhi1zhuo2"]
],
"親":[
["親友","qin1you3"],
["親口","qin1kou3"],
["親吻","qin1wen3"],
["親嘴","qin1zui3"],
["親子","qin1zi3"],
["親家","qing4jia5"],
["親屬","qin1shu3"],
["親手","qin1shou3"],
["親眼","qin1yan3"],
["親筆","qin1bi3"],
["親耳","qin1er3"],
["親朋好友","qin1peng2hao3you3"],
["親眼看見","qin1yan3kan4jian4"]
],
"覺":[
["覺得","jue2de5"],
["覺醒","jue2xing3"],
["覺不出","jue2bu5chu1"],
["覺不到","jue2bu5dao4"]
],
"觀":[
["觀塘","guan4tang2"],
["觀感","guan1gan3"],
["觀止","guan1zhi3"],
["觀火","guan1huo3"],
["觀禮","guan1li3"],
["觀覽","guan1lan3"],
["觀賞","guan1shang3"],
["觀點","guan1dian3"]
],
"见":[
["见地","jian4di4"],
["见好","jian4hao3"],
["见解","jian4jie3"],
["见访","jian4fang3"],
["见鬼","jian4gui3"],
["见不到","jian4bu5dao4"],
["见不得","jian4bu5de5"],
["见不着","jian4bu5zhao2"],
["见得了","jian4de5liao3"],
["见得着","jian4de5zhao2"],
["见微知著","jian4wei1zhi1zhu4"]
],
"观":[
["观塘","guan4tang2"],
["观感","guan1gan3"],
["观止","guan1zhi3"],
["观火","guan1huo3"],
["观点","guan1dian3"],
["观礼","guan1li3"],
["观览","guan1lan3"],
["观赏","guan1shang3"]
],
"规":[
["规管","gui1guan3"],
["规一化","gui1yi2hua4"],
["规矩准绳","gui1ju3zhun3sheng2"],
["规规矩矩","gui1gui5ju1ju1"]
],
"觅":[
["觅取","mi4qu3"],
["觅得","mi4de2"]
],
"视":[
["视为","shi4wei2"],
["视差","shi4cha1"],
["视角","shi4jiao3"],
["视野","shi4ye3"],
["视微知着","shi4wei1zhi1zhuo2"]
],
"觉":[
["觉得","jue2de5"],
["觉醒","jue2xing3"],
["觉不出","jue2bu5chu1"],
["觉不到","jue2bu5dao4"]
],
"角":[
["角力","jue2li4"],
["角口","jiao3kou3"],
["角尺","jiao3chi3"],
["角抵","jue2di3"],
["角斗","jue2dou4"],
["角朊","jiao3ruan3"],
["角椅","jiao3yi3"],
["角逐","jue2zhu2"],
["角鐵","jiao3tie3"],
["角铁","jiao3tie3"],
["角鬥","jue2dou4"],
["角色扮演遊戏","jue2se4ban4yan3you2xi4"],
["角色扮演遊戲","jue2se4ban4yan3you2xi4"]
],
"解":[
["解体","jie3ti3"],
["解免","jie3mian3"],
["解手","jie3shou3"],
["解法","jie3fa3"],
["解渴","jie3ke3"],
["解甲","jie3jia3"],
["解码","jie3ma3"],
["解碼","jie3ma3"],
["解送","jie4song4"],
["解體","jie3ti3"],
["解不了","jie3bu5liao3"],
["解不开","jie3bu5kai1"],
["解不開","jie3bu5kai1"],
["解决不了","jie3jue2bu5liao3"],
["解決不了","jie3jue2bu5liao3"],
["解球不下","jie3qiu2bu5xia4"]
],
"触":[
["触手","chu4shou3"],
["触角","chu4jiao3"],
["触诊","chu4zhen3"],
["触技曲","chu4ji4qu3"]
],
"觸":[
["觸手","chu4shou3"],
["觸角","chu4jiao3"],
["觸診","chu4zhen3"],
["觸技曲","chu4ji4qu3"]
],
"言":[
["言語","yan2yu3"],
["言講","yan2jiang3"],
["言讲","yan2jiang3"],
["言语","yan2yu3"],
["言不得当","yan2bu4de2dang4"],
["言不得當","yan2bu4de2dang4"],
["言归正传","yan2gui1zheng4zhuan4"],
["言歸正傳","yan2gui1zheng4zhuan4"]
],
"計":[
["計劃","ji4hua4"],
["計有","ji4you3"],
["計都","ji4du1"]
],
"訊":[
["訊息","xun4xi1"],
["訊框傳送","xun4kuang4chuan2song4"],
["訊息處理系統","xun4xi1chu4li3xi4tong3"]
],
"討":[
["討乞","tao3qi3"],
["討保","tao3bao3"],
["討好","tao3hao3"],
["討巧","tao3qiao3"],
["討底","tao3di3"],
["討擾","tao3rao3"],
["討米","tao3mi3"],
["討還","tao3huan2"],
["討不了","tao3bu5liao3"],
["討便宜","tao3pian2yi5"]
],
"訓":[
["訓詁","xun4gu3"]
],
"記":[
["記住","ji4zhu5"],
["記傳","ji4zhuan4"],
["記取","ji4qu3"],
["記性","ji4xing5"],
["記為","ji4wei2"],
["記者","ji4zhe3"],
["記號","ji4hao5"],
["記起","ji4qi3"],
["記載","ji4zai3"],
["記下來","ji4xia4lai2"],
["記不住","ji4bu5zhu4"],
["記不全","ji4bu5quan2"],
["記不得","ji4bu5de2"],
["記不清","ji4bu5qing1"],
["記不牢","ji4bu5lao2"],
["記錄下來","ji4lu4xia4lai2"]
],
"訪":[
["訪古","fang3gu3"],
["訪港","fang3gang3"],
["訪親問友","fang3qin1wen4you3"]
],
"設":[
["設使","she4shi3"],
["設崗","she4gang3"],
["設廠","she4chang3"],
["設想","she4xiang3"],
["設斐","she4fei3"],
["設有","she4you3"],
["設法","she4fa3"],
["設身處地","she4shen1chu3di4"]
],
"許":[
["許久","xu3jiu3"],
["許仙","xu3xian1"],
["許可","xu3ke3"],
["許厪父","xu3qin2fu4"],
["許地山","xu3di4shan1"],
["許廑父","xu3qin2fu4"]
],
"訴":[
["訴冤","su4yuan1"],
["訴求","su4qiu2"],
["訴狀","su4zhuang4"],
["訴苦","su4ku3"],
["訴訟","su4song4"],
["訴說","su4shuo1"]
],
"診":[
["診所","zhen3suo3"]
],
"註":[
["註腳","zhu4jiao3"],
["註解","zhu4jie3"]
],
"詆":[
["詆毀","di3hui3"]
],
"詐":[
["詐取","zha4qu3"],
["詐語","zha4yu3"],
["詐降","zha4xiang2"]
],
"詔":[
["詔旨","zhao4zhi3"]
],
"評":[
["評審","ping2shen3"],
["評比","ping2bi3"],
["評為","ping2wei2"],
["評理","ping2li3"],
["評語","ping2yu3"],
["評選","ping2xuan3"],
["評點","ping2dian3"]
],
"詞":[
["詞典","ci2dian3"],
["詞尾","ci2wei3"],
["詞組","ci2zu3"],
["詞綴","ci2zhui4"],
["詞藻","ci2zao3"],
["詞語","ci2yu3"],
["詞體","ci2ti3"]
],
"試":[
["試卷","shi4juan4"],
["試場","shi4chang3"],
["試管","shi4guan3"],
["試試","shi4shi5"],
["試一試","shi4yi2shi4"],
["試不好","shi4bu5hao3"]
],
"詩":[
["詩禮","shi1li3"],
["詩稿","shi1gao3"],
["詩書畫合而為一","shi1shu1hua4he2er5wei2yi1"]
],
"話":[
["話卡","hua4ka3"],
["話把","hua4ba4"],
["話本","hua4ben3"],
["話筒","hua4tong3"],
["話語","hua4yu3"],
["話題一轉","hua4ti2yi4zhuan3"]
],
"該":[
["該上","gai1shang5"],
["該死","gai1si3"],
["該隱","gai1yin3"],
["該不著","gai1bu5zhao2"]
],
"詳":[
["詳盡","xiang2jin4"]
],
"誇":[
["誇口","kua1kou3"],
["誇獎","kua1jiang3"]
],
"誊":[
["誊写","teng2xie3"]
],
"認":[
["認可","ren4ke3"],
["認準","ren4zhun3"],
["認為","ren4wei2"],
["認腳","ren4jiao3"],
["認領","ren4ling3"],
["認不出","ren4bu5chu1"],
["認不得","ren4bu5de2"],
["認不清","ren4bu5qing1"],
["認識到","ren4shi5dao5"]
],
"誑":[
["誑語","kuang2yu3"]
],
"誒":[
["誒笑","ei1xiao4"],
["誒詒","ei1yi2"]
],
"誓":[
["誓死","shi4si3"],
["誓死不降","shi4si3bu4xiang2"]
],
"誘":[
["誘使","you4shi3"],
["誘導","you4dao3"],
["誘拐","you4guai3"],
["誘餌","you4er3"]
],
"語":[
["語感","yu3gan3"],
["語法","yu3fa3"],
["語種","yu3zhong3"]
],
"誠":[
["誠懇","cheng2ken3"],
["誠樸","cheng2pu3"],
["誠篤","cheng2du3"]
],
"誤":[
["誤導","wu4dao3"],
["誤差","wu4cha1"],
["誤解","wu4jie3"],
["誤不了","wu4bu5liao3"]
],
"說":[
["說中","shuo1zhong4"],
["說和","shuo1he5"],
["說好","shuo1hao3"],
["說客","shui4ke4"],
["說文","shuo1wen1"],
["說法","shuo1fa3"],
["說給","shuo1gei3"],
["說說","shuo1shuo5"],
["說謊","shuo1huang3"],
["說起","shuo1qi3"],
["說不上","shuo1bu5shang4"],
["說不下","shuo1bu5xia4"],
["說不了","shuo1bu5liao3"],
["說不來","shuo1bu5lai2"],
["說不到","shuo1bu5dao4"],
["說不好","shuo1bu5hao3"],
["說不妥","shuo1bu5tuo3"],
["說不完","shuo1bu5wan2"],
["說不定","shuo1bu5ding4"],
["說不得","shuo1bu5de5"],
["說不惱","shuo1bu5nao3"],
["說不明","shuo1bu5ming2"],
["說不服","shuo1bu5fu2"],
["說不清","shuo1bu5qing1"],
["說不盡","shuo1bu5jin4"],
["說不著","shuo1bu5zhao2"],
["說不通","shuo1bu5tong1"],
["說不過","shuo1bu5guo4"],
["說不開","shuo1bu5kai1"],
["說不齊","shuo1bu5qi2"],
["說得上","shuo1de5shang4"],
["說得來","shuo1de5lai2"],
["說得出","shuo1de5chu1"],
["說得著","shuo1de5zhao2"],
["說清楚","shuo1qing1chu3"],
["說一不二","shuo1yi2bu2er4"],
["說不出來","shuo1bu5chu1lai5"],
["說不出口","shuo1bu5chu1kou3"],
["說不出話","shuo1bu5chu1hua4"],
["說不利灑","shuo1bu5li4sa5"],
["說不清楚","shuo1bu5qing1chu3"],
["說不過去","shuo1bu5guo4qu5"],
["說得下去","shuo1de5xia4qu4"],
["說得恰當","shuo1de5qia4dang1"],
["說文解字","shuo1wen2jie3zi4"],
["說不對勁兒","shuo1bu5dui4jin4r5"],
["說不清道不明","shuo1bu5qing1dao4bu5ming2"]
],
"誰":[
["誰敢","shui2gan3"],
["誰肯","shui2ken3"],
["誰知道","shei2zhi1dao4"],
["誰人樂隊","shei2ren2yue4dui4"]
],
"課":[
["課本","ke4ben3"],
["課表","ke4biao3"]
],
"調":[
["調低","tiao2di1"],
["調侃","tiao2kan3"],
["調停","tiao2ting2"],
["調價","tiao2jia4"],
["調制","tiao2zhi4"],
["調劑","tiao2ji4"],
["調勻","tiao2yun2"],
["調協","tiao2xie2"],
["調味","tiao2wei4"],
["調和","tiao2he2"],
["調唆","tiao2suo1"],
["調弄","tiao2nong4"],
["調情","tiao2qing2"],
["調戲","tiao2xi4"],
["調控","tiao2kong4"],
["調攝","tiao2she4"],
["調教","tiao2jiao4"],
["調整","tiao2zheng3"],
["調料","tiao2liao4"],
["調準","tiao2zhun3"],
["調焦","tiao2jiao1"],
["調理","tiao2li5"],
["調皮","tiao2pi2"],
["調笑","tiao2xiao4"],
["調節","tiao2jie2"],
["調羹","tiao2geng1"],
["調色","tiao2se4"],
["調解","tiao2jie3"],
["調試","tiao2shi4"],
["調諧","tiao2xie2"],
["調謔","tiao2xue4"],
["調變","tiao2bian4"],
["調資","tiao2zi1"],
["調轉","diao4zhuan3"],
["調速","tiao2su4"],
["調適","tiao2shi4"],
["調音","tiao2yin1"],
["調頻","tiao2pin2"],
["調養","tiao2yang3"],
["調馴","tiao2xun4"],
["調藥刀","tiao2yao4dao1"],
["調和分析","tiao2he2fen1xi1"],
["調嘴學舌","tiao2zui3xue2she2"],
["調制解調器","diao4zhi4jie3diao4qi4"]
],
"請":[
["請假","qing3jia4"],
["請帖","qing3tie3"],
["請柬","qing3jian3"]
],
"諍":[
["諍友","zheng4you3"]
],
"諒":[
["諒解","liang4jie3"]
],
"論":[
["論法","lun4fa3"],
["論語","lun2yu3"],
["論點","lun4dian3"]
],
"諧":[
["諧婉","xie2wan3"],
["諧美","xie2mei3"],
["諧振子","xie2zhen4zi3"]
],
"諭":[
["諭旨","yu4zhi3"]
],
"諸":[
["諸子","zhu1zi3"],
["諸將","zhu1jiang4"],
["諸葛","zhu1ge3"]
],
"諺":[
["諺語","yan4yu3"]
],
"諾":[
["諾爾","nuo4er3"]
],
"謀":[
["謀劃","mou2hua4"],
["謀反","mou2fan3"],
["謀取","mou2qu3"],
["謀得","mou2de2"],
["謀臣猛將","mou2chen2meng3jiang4"]
],
"謁":[
["謁訪","ye4fang3"]
],
"謂":[
["謂語","wei4yu3"]
],
"謄":[
["謄寫","teng2xie3"]
],
"謎":[
["謎兒","mei4r5"],
["謎底","mi2di3"],
["謎語","mi2yu3"]
],
"謔":[
["謔語","xue4yu3"]
],
"謙":[
["謙語","qian1yu3"]
],
"講":[
["講史","jiang3shi3"],
["講演","jiang3yan3"],
["講理","jiang3li3"],
["講究","jiang3jiu5"],
["講者","jiang3zhe3"],
["講解","jiang3jie3"],
["講不得","jiang3bu5de5"],
["講不通","jiang3bu5tong1"],
["講出來","jiang3chu1lai2"],
["講不出口","jiang3bu5chu1kou3"]
],
"謝":[
["謝帖","xie4tie3"],
["謝爾","xie4er3"],
["謝禮","xie4li3"],
["謝謝","xie4xie5"],
["謝頂","xie4ding3"],
["謝裡夫","xie4li3fu1"],
["謝天謝地","xie4tian1xie4di4"]
],
"謬":[
["謬獎","miu4jiang3"],
["謬種","miu4zhong3"]
],
"謹":[
["謹守","jin3shou3"]
],
"證":[
["證卷","zheng4juan4"]
],
"譏":[
["譏諷","ji1feng3"]
],
"譔":[
["譔杜","du4zhuan4"]
],
"識":[
["識別","shi2bie2"],
["識力","shi2li4"],
["識字","shi2zi4"],
["識度","shi2du4"],
["識得","shi2de2"],
["識才","shi2cai2"],
["識相","shi2xiang4"],
["識破","shi2po4"],
["識羞","shi2xiu1"],
["識荊","shi2jing1"],
["識見","shi2jian4"],
["識貨","shi2huo4"],
["識趣","shi2qu4"],
["識多才廣","shi2duo1cai2guang3"],
["識微見幾","shi2wei1jian4ji3"],
["識文斷字","shi2wen2duan4zi4"],
["識時通變","shi2shi2tong1bian4"],
["識時達務","shi2shi2da2wu4"],
["識途老馬","shi2tu2lao3ma3"],
["識時務者為俊傑","shi2shi2wu4zhe3wei2jun4jie2"]
],
"譜":[
["譜寫","pu3xie3"],
["譜曲","pu3qu3"]
],
"警":[
["警犬","jing3quan3"],
["警种","jing3zhong3"],
["警種","jing3zhong3"],
["警醒","jing3xing3"]
],
"譯":[
["譯本","yi4ben3"],
["譯者","yi4zhe3"]
],
"議":[
["議長","yi4zhang3"]
],
"護":[
["護士","hu4shi5"],
["護理","hu4li3"],
["護短","hu4duan3"]
],
"讀":[
["讀寫","du2xie3"],
["讀懂","du2dong3"],
["讀本","du2ben3"],
["讀者","du2zhe3"]
],
"變":[
["變暖","bian4nuan3"],
["變更","bian4geng1"],
["變法","bian4fa3"],
["變為","bian4wei2"],
["變產","bian4chan3"],
["變相","bian4xiang4"],
["變種","bian4zhong3"],
["變臉","bian4lian3"],
["變苦","bian4ku3"],
["變軟","bian4ruan3"],
["變通","bian4tong5"],
["變醜","bian4chou3"],
["變體","bian4ti3"],
["變奏曲","bian4zou4qu3"]
],
"讒":[
["讒諂","chan2chan3"]
],
"讓":[
["讓給","rang4gei3"],
["讓開","rang4kai5"],
["讓一讓","rang4yi5rang4"]
],
"讚":[
["讚美","zan4mei3"],
["讚賞","zan4shang3"],
["讚赏","zan4shang3"]
],
"计":[
["计有","ji4you3"],
["计都","ji4du1"]
],
"认":[
["认为","ren4wei2"],
["认准","ren4zhun3"],
["认可","ren4ke3"],
["认脚","ren4jiao3"],
["认领","ren4ling3"],
["认不出","ren4bu5chu1"],
["认不得","ren4bu5de2"],
["认不清","ren4bu5qing1"],
["认人儿","ren4ren2r5"],
["认识到","ren4shi5dao5"],
["认死扣儿","ren4si3kou4r5"],
["认死理儿","ren4si3li3r5"]
],
"讥":[
["讥讽","ji1feng3"]
],
"讨":[
["讨乞","tao3qi3"],
["讨保","tao3bao3"],
["讨好","tao3hao3"],
["讨巧","tao3qiao3"],
["讨底","tao3di3"],
["讨扰","tao3rao3"],
["讨米","tao3mi3"],
["讨还","tao3huan2"],
["讨不了","tao3bu5liao3"],
["讨便宜","tao3pian2yi5"],
["讨底儿","tao3di3r5"]
],
"让":[
["让开","rang4kai5"],
["让给","rang4gei3"],
["让一让","rang4yi5rang4"]
],
"训":[
["训诂","xun4gu3"]
],
"议":[
["议长","yi4zhang3"]
],
"讯":[
["讯息","xun4xi1"],
["讯框传送","xun4kuang4chuan2song4"],
["讯息处理系统","xun4xi1chu4li3xi4tong3"]
],
"记":[
["记为","ji4wei2"],
["记传","ji4zhuan4"],
["记住","ji4zhu5"],
["记取","ji4qu3"],
["记号","ji4hao5"],
["记性","ji4xing5"],
["记者","ji4zhe3"],
["记起","ji4qi3"],
["记载","ji4zai3"],
["记下来","ji4xia4lai2"],
["记不住","ji4bu5zhu4"],
["记不全","ji4bu5quan2"],
["记不得","ji4bu5de2"],
["记不清","ji4bu5qing1"],
["记不牢","ji4bu5lao2"],
["记录下来","ji4lu4xia4lai2"]
],
"讲":[
["讲史","jiang3shi3"],
["讲演","jiang3yan3"],
["讲理","jiang3li3"],
["讲究","jiang3jiu5"],
["讲者","jiang3zhe3"],
["讲解","jiang3jie3"],
["讲不得","jiang3bu5de5"],
["讲不通","jiang3bu5tong1"],
["讲出来","jiang3chu1lai2"],
["讲不出口","jiang3bu5chu1kou3"]
],
"许":[
["许久","xu3jiu3"],
["许仙","xu3xian1"],
["许可","xu3ke3"],
["许厪父","xu3qin2fu4"],
["许地山","xu3di4shan1"],
["许廑父","xu3qin2fu4"]
],
"论":[
["论法","lun4fa3"],
["论点","lun4dian3"],
["论语","lun2yu3"]
],
"设":[
["设使","she4shi3"],
["设厂","she4chang3"],
["设岗","she4gang3"],
["设想","she4xiang3"],
["设斐","she4fei3"],
["设有","she4you3"],
["设法","she4fa3"],
["设身处地","she4shen1chu3di4"]
],
"访":[
["访古","fang3gu3"],
["访港","fang3gang3"],
["访亲问友","fang3qin1wen4you3"]
],
"证":[
["证卷","zheng4juan4"]
],
"评":[
["评为","ping2wei2"],
["评审","ping2shen3"],
["评比","ping2bi3"],
["评点","ping2dian3"],
["评理","ping2li3"],
["评语","ping2yu3"],
["评选","ping2xuan3"]
],
"识":[
["识别","shi2bie2"],
["识力","shi2li4"],
["识字","shi2zi4"],
["识度","shi2du4"],
["识得","shi2de2"],
["识才","shi2cai2"],
["识相","shi2xiang4"],
["识破","shi2po4"],
["识羞","shi2xiu1"],
["识荆","shi2jing1"],
["识见","shi2jian4"],
["识货","shi2huo4"],
["识趣","shi2qu4"],
["识多才广","shi2duo1cai2guang3"],
["识微见几","shi2wei1jian4ji3"],
["识文断字","shi2wen2duan4zi4"],
["识时达务","shi2shi2da2wu4"],
["识时通变","shi2shi2tong1bian4"],
["识途老马","shi2tu2lao3ma3"],
["识时务者为俊杰","shi2shi2wu4zhe3wei2jun4jie2"]
],
"诈":[
["诈取","zha4qu3"],
["诈语","zha4yu3"],
["诈降","zha4xiang2"]
],
"诉":[
["诉冤","su4yuan1"],
["诉求","su4qiu2"],
["诉状","su4zhuang4"],
["诉苦","su4ku3"],
["诉讼","su4song4"],
["诉说","su4shuo1"]
],
"诊":[
["诊所","zhen3suo3"]
],
"诋":[
["诋毁","di3hui3"]
],
"词":[
["词体","ci2ti3"],
["词典","ci2dian3"],
["词尾","ci2wei3"],
["词组","ci2zu3"],
["词缀","ci2zhui4"],
["词藻","ci2zao3"],
["词语","ci2yu3"],
["词干启动","ci2gan4qi3dong4"]
],
"诏":[
["诏旨","zhao4zhi3"]
],
"译":[
["译本","yi4ben3"],
["译者","yi4zhe3"]
],
"试":[
["试卷","shi4juan4"],
["试场","shi4chang3"],
["试管","shi4guan3"],
["试试","shi4shi5"],
["试一试","shi4yi2shi4"],
["试不好","shi4bu5hao3"]
],
"诗":[
["诗礼","shi1li3"],
["诗稿","shi1gao3"],
["诗书画合而为一","shi1shu1hua4he2er5wei2yi1"]
],
"诚":[
["诚恳","cheng2ken3"],
["诚朴","cheng2pu3"],
["诚笃","cheng2du3"]
],
"话":[
["话卡","hua4ka3"],
["话把","hua4ba4"],
["话本","hua4ben3"],
["话筒","hua4tong3"],
["话语","hua4yu3"],
["话茬儿","hua4cha2r5"],
["话题一转","hua4ti2yi4zhuan3"]
],
"诤":[
["诤友","zheng4you3"]
],
"该":[
["该上","gai1shang5"],
["该死","gai1si3"],
["该隐","gai1yin3"],
["该不着","gai1bu5zhao2"]
],
"语":[
["语感","yu3gan3"],
["语法","yu3fa3"],
["语种","yu3zhong3"]
],
"误":[
["误导","wu4dao3"],
["误差","wu4cha1"],
["误解","wu4jie3"],
["误不了","wu4bu5liao3"]
],
"诱":[
["诱使","you4shi3"],
["诱导","you4dao3"],
["诱拐","you4guai3"],
["诱饵","you4er3"]
],
"诳":[
["诳语","kuang2yu3"]
],
"说":[
["说中","shuo1zhong4"],
["说和","shuo1he5"],
["说好","shuo1hao3"],
["说客","shui4ke4"],
["说文","shuo1wen1"],
["说法","shuo1fa3"],
["说给","shuo1gei3"],
["说说","shuo1shuo5"],
["说谎","shuo1huang3"],
["说起","shuo1qi3"],
["说不上","shuo1bu5shang4"],
["说不下","shuo1bu5xia4"],
["说不了","shuo1bu5liao3"],
["说不到","shuo1bu5dao4"],
["说不好","shuo1bu5hao3"],
["说不妥","shuo1bu5tuo3"],
["说不完","shuo1bu5wan2"],
["说不定","shuo1bu5ding4"],
["说不尽","shuo1bu5jin4"],
["说不开","shuo1bu5kai1"],
["说不得","shuo1bu5de5"],
["说不恼","shuo1bu5nao3"],
["说不明","shuo1bu5ming2"],
["说不服","shuo1bu5fu2"],
["说不来","shuo1bu5lai2"],
["说不清","shuo1bu5qing1"],
["说不着","shuo1bu5zhao2"],
["说不过","shuo1bu5guo4"],
["说不通","shuo1bu5tong1"],
["说不齐","shuo1bu5qi2"],
["说得上","shuo1de5shang4"],
["说得出","shuo1de5chu1"],
["说得来","shuo1de5lai2"],
["说得着","shuo1de5zhao2"],
["说清楚","shuo1qing1chu3"],
["说一不二","shuo1yi2bu2er4"],
["说不出口","shuo1bu5chu1kou3"],
["说不出来","shuo1bu5chu1lai5"],
["说不出话","shuo1bu5chu1hua4"],
["说不利洒","shuo1bu5li4sa5"],
["说不清楚","shuo1bu5qing1chu3"],
["说不过去","shuo1bu5guo4qu5"],
["说得下去","shuo1de5xia4qu4"],
["说得恰当","shuo1de5qia4dang1"],
["说文解字","shuo1wen2jie3zi4"],
["说不对劲儿","shuo1bu5dui4jin4r5"],
["说不清道不明","shuo1bu5qing1dao4bu5ming2"]
],
"诶":[
["诶笑","ei1xiao4"],
["诶诒","ei1yi2"]
],
"请":[
["请假","qing3jia4"],
["请帖","qing3tie3"],
["请柬","qing3jian3"]
],
"诸":[
["诸子","zhu1zi3"],
["诸将","zhu1jiang4"],
["诸葛","zhu1ge3"]
],
"诺":[
["诺尔","nuo4er3"]
],
"读":[
["读写","du2xie3"],
["读懂","du2dong3"],
["读本","du2ben3"],
["读者","du2zhe3"]
],
"课":[
["课本","ke4ben3"],
["课表","ke4biao3"]
],
"谁":[
["谁敢","shui2gan3"],
["谁肯","shui2ken3"],
["谁知道","shei2zhi1dao4"],
["谁人乐队","shei2ren2yue4dui4"]
],
"调":[
["调价","tiao2jia4"],
["调低","tiao2di1"],
["调侃","tiao2kan3"],
["调停","tiao2ting2"],
["调养","tiao2yang3"],
["调准","tiao2zhun3"],
["调制","tiao2zhi4"],
["调剂","tiao2ji4"],
["调匀","tiao2yun2"],
["调协","tiao2xie2"],
["调变","tiao2bian4"],
["调味","tiao2wei4"],
["调和","tiao2he2"],
["调唆","tiao2suo1"],
["调弄","tiao2nong4"],
["调情","tiao2qing2"],
["调戏","tiao2xi4"],
["调控","tiao2kong4"],
["调摄","tiao2she4"],
["调教","tiao2jiao4"],
["调整","tiao2zheng3"],
["调料","tiao2liao4"],
["调焦","tiao2jiao1"],
["调理","tiao2li5"],
["调皮","tiao2pi2"],
["调笑","tiao2xiao4"],
["调羹","tiao2geng1"],
["调色","tiao2se4"],
["调节","tiao2jie2"],
["调解","tiao2jie3"],
["调试","tiao2shi4"],
["调谐","tiao2xie2"],
["调谑","tiao2xue4"],
["调资","tiao2zi1"],
["调转","diao4zhuan3"],
["调适","tiao2shi4"],
["调速","tiao2su4"],
["调音","tiao2yin1"],
["调频","tiao2pin2"],
["调驯","tiao2xun4"],
["调药刀","tiao2yao4dao1"],
["调和分析","tiao2he2fen1xi1"],
["调嘴学舌","tiao2zui3xue2she2"],
["调制解调器","diao4zhi4jie3diao4qi4"]
],
"谅":[
["谅解","liang4jie3"]
],
"谋":[
["谋反","mou2fan3"],
["谋取","mou2qu3"],
["谋得","mou2de2"],
["谋臣猛将","mou2chen2meng3jiang4"]
],
"谐":[
["谐婉","xie2wan3"],
["谐美","xie2mei3"],
["谐振子","xie2zhen4zi3"]
],
"谑":[
["谑语","xue4yu3"]
],
"谒":[
["谒访","ye4fang3"]
],
"谓":[
["谓语","wei4yu3"]
],
"谕":[
["谕旨","yu4zhi3"]
],
"谗":[
["谗谄","chan2chan3"]
],
"谚":[
["谚语","yan4yu3"]
],
"谜":[
["谜儿","mei4r5"],
["谜底","mi2di3"],
["谜语","mi2yu3"]
],
"谢":[
["谢尔","xie4er3"],
["谢帖","xie4tie3"],
["谢礼","xie4li3"],
["谢谢","xie4xie5"],
["谢顶","xie4ding3"],
["谢里夫","xie4li3fu1"],
["谢天谢地","xie4tian1xie4di4"]
],
"谦":[
["谦语","qian1yu3"]
],
"谨":[
["谨守","jin3shou3"]
],
"谬":[
["谬奖","miu4jiang3"],
["谬种","miu4zhong3"]
],
"谱":[
["谱写","pu3xie3"],
["谱曲","pu3qu3"]
],
"谷":[
["谷地","gu3di4"],
["谷场","gu3chang2"],
["谷草","gu3cao3"],
["谷雨","gu3yu3"],
["谷梁传","gu4liang2zhuan4"],
["谷梁傳","gu4liang2zhuan4"]
],
"谿":[
["谿谷","xi1gu3"]
],
"豁":[
["豁免","huo4mian3"],
["豁拳","hua2quan2"],
["豁然","huo4ran2"]
],
"豆":[
["豆奶","dou4nai3"],
["豆腐","dou4fu5"],
["豆薯","dou4shu3"],
["豆角","dou4jiao3"],
["豆豉","dou4chi3"],
["豆腐渣工程","dou4fu3zha1gong1cheng2"]
],
"豎":[
["豎起","shu4qi3"]
],
"豐":[
["豐水","feng1shui3"],
["豐滿","feng1man3"],
["豐產","feng1chan3"],
["豐美","feng1mei3"],
["豐都","feng1du1"]
],
"豚":[
["豚鼠","tun2shu3"]
],
"象":[
["象徵","xiang4zheng1"]
],
"豪":[
["豪爽","hao2shuang3"],
["豪雨","hao2yu3"],
["豪飲","hao2yin3"],
["豪饮","hao2yin3"]
],
"豬":[
["豬狗","zhu1gou3"]
],
"貉":[
["貉子","hao2zi5"],
["貉絨","hao2rong2"],
["貉绒","hao2rong2"]
],
"貌":[
["貌美","mao4mei3"]
],
"貝":[
["貝塔","bei4ta3"],
["貝母","bei4mu3"],
["貝爾","bei4er3"],
["貝婭特麗克絲","bei4ya4te4li2ke4si1"]
],
"負":[
["負有","fu4you3"],
["負荷","fu4he4"],
["負起","fu4qi3"],
["負鼠","fu4shu3"],
["負重擔","fu4zhong4dan1"],
["負債累累","fu4zhai4lei3lei3"],
["負擔不起","fu4dan1bu4qi3"]
],
"財":[
["財主","cai2zhu3"],
["財務","cai2wu4"],
["財寶","cai2bao3"],
["財會","cai2kuai4"],
["財產","cai2chan3"],
["財長","cai2zhang3"]
],
"貢":[
["貢品","gong4pin3"]
],
"貧":[
["貧嘴","pin2zui3"],
["貧氣","pin2qi5"],
["貧相","pin2xiang4"],
["貧苦","pin2ku3"],
["貧嘴薄舌","pin2zui3bo2she2"],
["貧富差距","pin2fu4cha4ju4"]
],
"貨":[
["貨款","huo4kuan3"]
],
"貪":[
["貪腐","tan1fu3"],
["貪多務得","tan1duo1wu4de2"],
["貪得無厭","tan1de2wu2yan4"],
["貪多嚼不爛","tan1duo1jiao2bu5lan4"]
],
"責":[
["責打","ze2da3"],
["責難","ze2nan4"]
],
"貳":[
["貳拾","er4shi2"]
],
"貴":[
["貴嶼","gui4yu3"],
["貴港","gui4gang3"]
],
"貶":[
["貶損","bian3sun3"]
],
"買":[
["買主","mai3zhu3"],
["買好","mai3hao3"],
["買下來","mai3xia4lai2"],
["買不上","mai3bu5shang4"],
["買不下","mai3bu5xia4"],
["買不來","mai3bu5lai2"],
["買不到","mai3bu5dao4"],
["買不成","mai3bu5cheng2"],
["買不著","mai3bu5zhao2"],
["買不起","mai3bu5qi3"],
["買得出","mai3de5chu1"],
["買一送一","mai3yi2song4yi1"]
],
"貸":[
["貸款","dai4kuan3"],
["貸給","dai4gei3"]
],
"費":[
["費用","fei4yong5"],
["費解","fei4jie3"],
["費不了","fei4bu5liao3"],
["費力氣","fei4li4qi4"],
["費米子","fei4mi3zi3"],
["費爾巴哈","fei4er3ba1ha1"],
["費爾干納","fei4er3gan4na4"],
["費盡心思","fei4jin4xin1si5"],
["費爾干納槃地","fei4er3gan4na4pan2di4"]
],
"貼":[
["貼息","tie1xi1"],
["貼水","tie1shui3"],
["貼不起","tie1bu5qi3"]
],
"賀":[
["賀卡","he4ka3"],
["賀得","he4de2"],
["賀子珍","he2zi3zhen1"]
],
"賁":[
["賁臨","bi4lin2"]
],
"資":[
["資本","zi1ben3"],
["資產","zi1chan3"],
["資給","zi1ji3"],
["資興","zi1xing1"]
],
"賊":[
["賊眼","zei2yan3"],
["賊眼一溜","zei2yan3yi4liu1"]
],
"賓":[
["賓主","bin1zhu3"],
["賓得","bin1de2"],
["賓語","bin1yu3"],
["賓館","bin1guan3"]
],
"賜":[
["賜予","ci4yu3"],
["賜給","ci4gei3"],
["賜與","ci4yu3"]
],
"賞":[
["賞給","shang3gei3"],
["賞臉","shang3lian3"],
["賞識","shang3shi2"]
],
"賠":[
["賠本","pei2ben3"],
["賠款","pei2kuan3"],
["賠禮","pei2li3"],
["賠不了","pei2bu5liao3"]
],
"賣":[
["賣主","mai4zhu3"],
["賣傻","mai4sha3"],
["賣給","mai4gei3"],
["賣點","mai4dian3"],
["賣不上","mai4bu5shang4"],
["賣不了","mai4bu5liao3"],
["賣不光","mai4bu5guang1"],
["賣不動","mai4bu5dong4"],
["賣不清","mai4bu5qing1"],
["賣不過","mai4bu5guo4"],
["賣得出","mai4de5chu1"],
["賣不出去","mai4bu5chu1qu5"]
],
"賦":[
["賦予","fu4yu3"],
["賦格曲","fu4ge2qu3"]
],
"質":[
["質地","zhi4di4"],
["質子","zhi4zi3"],
["質感","zhi4gan3"],
["質樸","zhi4pu3"],
["質檢","zhi4jian3"],
["質譜","zhi4pu3"],
["質難","zhi4nan4"],
["質點","zhi4dian3"]
],
"賬":[
["賬本","zhang4ben3"],
["賬款","zhang4kuan3"],
["賬載","zhang4zai3"]
],
"賭":[
["賭場","du3chang3"]
],
"賺":[
["賺取","zhuan4qu3"],
["賺得","zhuan4de2"],
["賺不出","zhuan4bu5chu1"],
["賺得出","zhuan4de5chu1"]
],
"購":[
["購得","gou4de2"],
["購買","gou4mai3"]
],
"賽":[
["賽場","sai4chang3"],
["賽艇","sai4ting3"],
["賽跑","sai4pao3"],
["賽馬","sai4ma3"],
["賽點","sai4dian3"]
],
"贈":[
["贈予","zeng4yu3"],
["贈給","zeng4gei3"]
],
"贊":[
["贊美","zan4mei3"],
["贊許","zan4xu3"],
["贊賞","zan4shang3"]
],
"贍":[
["贍養","shan4yang3"]
],
"贏":[
["贏得","ying2de2"]
],
"贓":[
["贓款","zang1kuan3"]
],
"贗":[
["贗品","yan4pin3"]
],
"贝":[
["贝塔","bei4ta3"],
["贝尔","bei4er3"],
["贝母","bei4mu3"],
["贝壳儿","bei4ke2r5"],
["贝娅特丽克丝","bei4ya4te4li2ke4si1"]
],
"负":[
["负有","fu4you3"],
["负荷","fu4he4"],
["负起","fu4qi3"],
["负鼠","fu4shu3"],
["负重担","fu4zhong4dan1"],
["负债累累","fu4zhai4lei3lei3"],
["负担不起","fu4dan1bu4qi3"]
],
"贡":[
["贡品","gong4pin3"]
],
"财":[
["财主","cai2zhu3"],
["财产","cai2chan3"],
["财会","cai2kuai4"],
["财务","cai2wu4"],
["财宝","cai2bao3"],
["财长","cai2zhang3"]
],
"责":[
["责打","ze2da3"],
["责难","ze2nan4"]
],
"败":[
["败北","bai4bei3"],
["败火","bai4huo3"],
["败笔","bai4bi3"],
["败绩","bai4ji4"],
["败诉","bai4su4"],
["败家子","bai4jia1zi3"],
["败不成军","bai4bu5cheng2jun1"],
["败子回头","bai4zi3hui2tou2"]
],
"账":[
["账本","zhang4ben3"],
["账款","zhang4kuan3"],
["账载","zhang4zai3"]
],
"货":[
["货款","huo4kuan3"]
],
"质":[
["质地","zhi4di4"],
["质子","zhi4zi3"],
["质感","zhi4gan3"],
["质朴","zhi4pu3"],
["质检","zhi4jian3"],
["质点","zhi4dian3"],
["质谱","zhi4pu3"],
["质难","zhi4nan4"]
],
"贪":[
["贪腐","tan1fu3"],
["贪多务得","tan1duo1wu4de2"],
["贪得无厌","tan1de2wu2yan4"],
["贪多嚼不烂","tan1duo1jiao2bu5lan4"]
],
"贫":[
["贫嘴","pin2zui3"],
["贫气","pin2qi5"],
["贫相","pin2xiang4"],
["贫苦","pin2ku3"],
["贫嘴薄舌","pin2zui3bo2she2"],
["贫富差距","pin2fu4cha4ju4"]
],
"贬":[
["贬损","bian3sun3"]
],
"购":[
["购买","gou4mai3"],
["购得","gou4de2"]
],
"贰":[
["贰拾","er4shi2"]
],
"贲":[
["贲临","bi4lin2"]
],
"贴":[
["贴息","tie1xi1"],
["贴水","tie1shui3"],
["贴不起","tie1bu5qi3"]
],
"贵":[
["贵屿","gui4yu3"],
["贵港","gui4gang3"]
],
"贷":[
["贷款","dai4kuan3"],
["贷给","dai4gei3"]
],
"费":[
["费用","fei4yong5"],
["费解","fei4jie3"],
["费不了","fei4bu5liao3"],
["费力气","fei4li4qi4"],
["费劲儿","fei4jin4r5"],
["费米子","fei4mi3zi3"],
["费尔巴哈","fei4er3ba1ha1"],
["费尔干纳","fei4er3gan4na4"],
["费尔干纳槃地","fei4er3gan4na4pan2di4"]
],
"贺":[
["贺卡","he4ka3"],
["贺得","he4de2"],
["贺子珍","he2zi3zhen1"]
],
"贼":[
["贼眼","zei2yan3"],
["贼眼一溜","zei2yan3yi4liu1"]
],
"赃":[
["赃款","zang1kuan3"]
],
"资":[
["资产","zi1chan3"],
["资兴","zi1xing1"],
["资本","zi1ben3"],
["资给","zi1ji3"]
],
"赋":[
["赋予","fu4yu3"],
["赋格曲","fu4ge2qu3"]
],
"赌":[
["赌场","du3chang3"]
],
"赏":[
["赏给","shang3gei3"],
["赏脸","shang3lian3"],
["赏识","shang3shi2"]
],
"赐":[
["赐与","ci4yu3"],
["赐予","ci4yu3"],
["赐给","ci4gei3"]
],
"赔":[
["赔本","pei2ben3"],
["赔款","pei2kuan3"],
["赔礼","pei2li3"],
["赔不了","pei2bu5liao3"]
],
"赚":[
["赚取","zhuan4qu3"],
["赚得","zhuan4de2"],
["赚不出","zhuan4bu5chu1"],
["赚得出","zhuan4de5chu1"]
],
"赛":[
["赛场","sai4chang3"],
["赛点","sai4dian3"],
["赛艇","sai4ting3"],
["赛跑","sai4pao3"],
["赛马","sai4ma3"]
],
"赝":[
["赝品","yan4pin3"]
],
"赞":[
["赞美","zan4mei3"],
["赞许","zan4xu3"],
["赞赏","zan4shang3"]
],
"赠":[
["赠予","zeng4yu3"],
["赠给","zeng4gei3"]
],
"赡":[
["赡养","shan4yang3"]
],
"赢":[
["赢得","ying2de2"]
],
"赤":[
["赤手","chi4shou3"],
["赤水","chi4shui3"],
["赤脚","chi4jiao3"],
["赤腳","chi4jiao3"],
["赤裸","chi4luo3"],
["赤睛魚","chi4jing1yu2"],
["赤睛鱼","chi4jing1yu2"]
],
"赦":[
["赦免","she4mian3"]
],
"赫":[
["赫尔","he4er3"],
["赫巴","he4ba1"],
["赫本","he4ben3"],
["赫爾","he4er3"],
["赫玛","he4ma3"],
["赫瑪","he4ma3"],
["赫魯雪夫","he4lu3xue3fu1"],
["赫鲁雪夫","he4lu3xue3fu1"]
],
"走":[
["走卒","zou3zu2"],
["走嘴","zou3zui3"],
["走好","zou3hao3"],
["走子","zou3zi3"],
["走水","zou3shui3"],
["走狗","zou3gou3"],
["走相","zou3xiang4"],
["走眼","zou3yan3"],
["走索","zou3suo3"],
["走色","zou3shai3"],
["走訪","zou3fang3"],
["走访","zou3fang3"],
["走走","zou3zou3"],
["走险","zou3xian3"],
["走險","zou3xian3"],
["走不了","zou3bu5liao3"],
["走不到","zou3bu5dao4"],
["走不动","zou3bu5dong4"],
["走不動","zou3bu5dong4"],
["走不开","zou3bu5kai1"],
["走不得","zou3bu5de2"],
["走不脫","zou3bu5tuo1"],
["走不脱","zou3bu5tuo1"],
["走不远","zou3bu5yuan3"],
["走不通","zou3bu5tong1"],
["走不遠","zou3bu5yuan3"],
["走不開","zou3bu5kai1"],
["走味儿","zou3wei4r5"],
["走娘家","zou3niang2jia1"],
["走形儿","zou3xing2r5"],
["走样儿","zou3yang4r5"],
["走神儿","zou3shen2r5"],
["走不过去","zou3bu5guo4qu5"],
["走不過去","zou3bu5guo4qu5"],
["走亲访友","zou3qin1fang3you3"],
["走親訪友","zou3qin1fang3you3"]
],
"赶":[
["赶紧","gan3jin3"],
["赶脚","gan3jiao3"],
["赶走","gan3zou3"],
["赶上来","gan3shang4lai2"],
["赶不上","gan3bu5shang4"],
["赶不及","gan3bu5ji2"],
["赶不来","gan3bu5lai2"],
["赶出去","gan3chu1qu4"],
["赶出来","gan3chu1lai2"],
["赶得上","gan3de5shang4"]
],
"起":[
["起來","qi3lai5"],
["起哄","qi3hong4"],
["起土","qi3tu3"],
["起始","qi3shi3"],
["起手","qi3shou3"],
["起晚","qi3wan3"],
["起来","qi3lai5"],
["起火","qi3huo3"],
["起点","qi3dian3"],
["起码","qi3ma3"],
["起碼","qi3ma3"],
["起舞","qi3wu3"],
["起草","qi3cao3"],
["起訴","qi3su4"],
["起講","qi3jiang3"],
["起讲","qi3jiang3"],
["起诉","qi3su4"],
["起跑","qi3pao3"],
["起點","qi3dian3"],
["起不來","qi3bu5lai2"],
["起不来","qi3bu5lai2"],
["起名儿","qi3ming2r5"],
["起扑杆","qi3pu1gan3"]
],
"趁":[
["趁早","chen4zao3"]
],
"超":[
["超产","chao1chan3"],
["超导","chao1dao3"],
["超導","chao1dao3"],
["超我","chao1wo3"],
["超產","chao1chan3"],
["超等","chao1deng3"],
["超不过","chao1bu5guo4"],
["超不過","chao1bu5guo4"]
],
"越":[
["越分","yue4fen4"],
["越桔","yue4jie2"],
["越軌","yue4gui3"],
["越轨","yue4gui3"],
["越野","yue4ye3"]
],
"趋":[
["趋冷","qu1leng3"]
],
"趑":[
["趑趄","zi1ju1"]
],
"趕":[
["趕緊","gan3jin3"],
["趕腳","gan3jiao3"],
["趕走","gan3zou3"],
["趕上來","gan3shang4lai2"],
["趕不上","gan3bu5shang4"],
["趕不來","gan3bu5lai2"],
["趕不及","gan3bu5ji2"],
["趕出來","gan3chu1lai2"],
["趕出去","gan3chu1qu4"],
["趕得上","gan3de5shang4"]
],
"趨":[
["趨冷","qu1leng3"],
["趨於","qu1yu2"]
],
"足":[
["足以","zu2yi3"],
["足有","zu2you3"],
["足跡","zu2ji4"],
["足迹","zu2ji4"]
],
"跃":[
["跃马","yue4ma3"]
],
"跌":[
["跌倒","die1dao3"],
["跌水","die1shui3"],
["跌一跤","die1yi4jiao1"],
["跌跌撞撞","die1die5zhuang4zhuang4"],
["跌跌跄跄","die1die1qiang1qiang1"],
["跌跌蹌蹌","die1die1qiang1qiang1"],
["跌得倒爬得起","die1de5dao3pa2de5qi3"]
],
"跑":[
["跑垒","pao3lei3"],
["跑壘","pao3lei3"],
["跑差","pao3chai1"],
["跑表","pao3biao3"],
["跑馬","pao3ma3"],
["跑马","pao3ma3"],
["跑不了","pao3bu5liao3"],
["跑不出","pao3bu5chu1"],
["跑不动","pao3bu5dong4"],
["跑不動","pao3bu5dong4"],
["跑不掉","pao3bu5diao4"],
["跑味儿","pao3wei4r5"],
["跑神儿","pao3shen2r5"],
["跑腿儿","pao3tui3r5"],
["跑堂儿的","pao3tang2r5de5"],
["跑跑顛顛","pao3pao5dian1dian1"],
["跑跑颠颠","pao3pao5dian1dian1"]
],
"跛":[
["跛脚","bo3jiao3"],
["跛腳","bo3jiao3"]
],
"跟":[
["跟儿","gen1r5"],
["跟头","gen1tou5"],
["跟差","gen1chai1"],
["跟脚","gen1jiao3"],
["跟腳","gen1jiao3"],
["跟頭","gen1tou5"],
["跟不上","gen1bu5shang4"],
["跟得上","gen1de5shang4"]
],
"跡":[
["跡象","ji4xiang4"]
],
"跪":[
["跪下","gui4xia5"],
["跪倒","gui4dao3"],
["跪毯","gui4tan3"],
["跪祷","gui4dao3"],
["跪禱","gui4dao3"],
["跪下來","gui4xia4lai5"],
["跪下来","gui4xia4lai5"]
],
"路":[
["路上","lu4shang5"],
["路口","lu4kou3"],
["路得","lu4de2"],
["路司得","lu4si1de2"]
],
"跳":[
["跳伞","tiao4san3"],
["跳傘","tiao4san3"],
["跳板","tiao4ban3"],
["跳水","tiao4shui3"],
["跳脚","tiao4jiao3"],
["跳腳","tiao4jiao3"],
["跳舞","tiao4wu3"],
["跳蚤","tiao4zao5"],
["跳蝻","tiao4nan3"],
["跳起","tiao4qi3"],
["跳远","tiao4yuan3"],
["跳遠","tiao4yuan3"],
["跳馬","tiao4ma3"],
["跳马","tiao4ma3"],
["跳鼠","tiao4shu3"],
["跳下去","tiao4xia4qu4"]
],
"踉":[
["踉跄","liang4qiang4"],
["踉蹌","liang4qiang4"]
],
"踏":[
["踏实","ta1shi5"],
["踏實","ta1shi5"],
["踏板","ta4ban3"],
["踏踏实实","ta1ta1shi2shi2"],
["踏踏實實","ta1ta1shi2shi2"]
],
"踝":[
["踝骨","huai2gu3"]
],
"踩":[
["踩死","cai3si3"],
["踩水","cai3shui3"]
],
"踪":[
["踪影","zong1ying3"],
["踪迹","zong1ji4"]
],
"踮":[
["踮脚","dian3jiao3"],
["踮腳","dian3jiao3"]
],
"踺":[
["踺子","jian4zi3"]
],
"蹤":[
["蹤影","zong1ying3"],
["蹤跡","zong1ji4"]
],
"蹦":[
["蹦儿","beng4r5"],
["蹦跶","beng4da5"],
["蹦躂","beng4da5"],
["蹦达","beng4da5"],
["蹦達","beng4da5"],
["蹦高儿","beng4gao1r5"],
["蹦蹦跳跳","beng4beng5tiao4tiao4"]
],
"躍":[
["躍馬","yue4ma3"]
],
"身":[
["身上","shen1shang5"],
["身为","shen1wei2"],
["身份","shen1fen5"],
["身体","shen1ti3"],
["身分","shen1fen5"],
["身处","shen1chu3"],
["身影","shen1ying3"],
["身手","shen1shou3"],
["身板","shen1ban3"],
["身法","shen1fa3"],
["身為","shen1wei2"],
["身處","shen1chu3"],
["身量","shen1liang5"],
["身體","shen1ti3"],
["身板儿","shen1ban3r5"]
],
"躯":[
["躯体","qu1ti3"],
["躯壳","qu1qiao4"],
["躯干","qu1gan4"]
],
"躲":[
["躲开","duo3kai5"],
["躲懒","duo3lan3"],
["躲懶","duo3lan3"],
["躲閃","duo3shan3"],
["躲開","duo3kai5"],
["躲闪","duo3shan3"],
["躲难","duo3nan4"],
["躲難","duo3nan4"],
["躲不了","duo3bu5liao3"],
["躲不开","duo3bu5kai1"],
["躲不起","duo3bu5qi3"],
["躲不開","duo3bu5kai1"]
],
"躺":[
["躺下","tang3xia5"],
["躺椅","tang3yi3"],
["躺下來","tang3xia4lai2"],
["躺下来","tang3xia4lai2"],
["躺不下","tang3bu5xia4"],
["躺不稳","tang3bu5wen3"],
["躺不穩","tang3bu5wen3"]
],
"軀":[
["軀殼","qu1qiao4"],
["軀體","qu1ti3"]
],
"車":[
["車夫","che1fu1"],
["車展","che1zhan3"],
["車把","che1ba3"],
["車長","che1zhang3"],
["車頂","che1ding3"],
["車馬","che1ma3"],
["車把式","che1ba3shi5"],
["車行通道","che1hang2tong1dao4"],
["車爾尼雪夫斯基","che1er3ni2xue3fu1si1ji1"]
],
"軋":[
["軋場","ya4chang2"],
["軋染","ya4ran3"],
["軋機","zha2ji1"],
["軋製","zha2zhi4"],
["軋鋼","zha2gang1"]
],
"軌":[
["軌枕","gui3zhen3"],
["軌跡","gui3ji4"]
],
"軍":[
["軍務","jun1wu4"],
["軍委","jun1wei3"],
["軍旅","jun1lv3"],
["軍法","jun1fa3"],
["軍港","jun1gang3"],
["軍演","jun1yan3"],
["軍火","jun1huo3"],
["軍長","jun1zhang3"]
],
"軒":[
["軒檻","xuan1jian4"]
],
"軟":[
["軟飲","ruan3yin3"],
["軟骨","ruan3gu3"],
["軟體","ruan3ti3"]
],
"軸":[
["軸索","zhou2suo3"],
["軸突運輸","zhou2tu2yun4shu1"]
],
"輂":[
["輂輦","ju2nian3"],
["輂辇","ju2nian3"]
],
"較":[
["較好","jiao4hao3"],
["較少","jiao4shao3"]
],
"載":[
["載入","zai3ru4"],
["載湉","zai3tian2"],
["載滿","zai4man3"],
["載籍","zai3ji2"],
["載荷","zai4he4"],
["載體","zai4ti3"],
["載伯德","zai3bo2de2"]
],
"輔":[
["輔以","fu3yi3"],
["輔導","fu3dao3"]
],
"輕":[
["輕咬","qing1yao3"],
["輕巧","qing1qiao3"],
["輕打","qing1da3"],
["輕染","qing1ran3"],
["輕水","qing1shui3"],
["輕率","qing1shuai4"],
["輕省","qing1sheng5"],
["輕薄","qing1bo2"],
["輕軌","qing1gui3"],
["輕不了","qing1bu5liao3"]
],
"輟":[
["輟止","chuo4zhi3"],
["輟演","chuo4yan3"],
["輟筆","chuo4bi3"]
],
"輩":[
["輩分","bei4fen5"]
],
"輪":[
["輪椅","lun2yi3"],
["輪腳","lun2jiao3"],
["輪輞","lun2wang3"],
["輪轂","lun2gu3"],
["輪齒","lun2chi3"]
],
"輾":[
["輾轉","zhan3zhuan3"]
],
"轄":[
["轄地","xia2di4"]
],
"轉":[
["轉口","zhuan3kou3"],
["轉圈","zhuan4quan1"],
["轉塔","zhuan4ta3"],
["轉子","zhuan4zi3"],
["轉寫","zhuan3xie3"],
["轉導","zhuan3dao3"],
["轉引","zhuan3yin3"],
["轉往","zhuan3wang3"],
["轉徙","zhuan3xi3"],
["轉悠","zhuan4you5"],
["轉手","zhuan3shou3"],
["轉抵","zhuan3di3"],
["轉椅","zhuan4yi3"],
["轉為","zhuan3wei2"],
["轉爐","zhuan4lu2"],
["轉產","zhuan3chan3"],
["轉盤","zhuan4pan2"],
["轉眼","zhuan3yan3"],
["轉矩","zhuan4ju3"],
["轉磨","zhuan4mo4"],
["轉筋","zhuan4jin1"],
["轉紐","zhuan4niu3"],
["轉給","zhuan3gei3"],
["轉臉","zhuan3lian3"],
["轉臺","zhuan4tai2"],
["轉行","zhuan3hang2"],
["轉角","zhuan3jiao3"],
["轉距","zhuan4ju4"],
["轉軸","zhuan4zhou2"],
["轉載","zhuan3zai3"],
["轉輪","zhuan4lun2"],
["轉速","zhuan4su4"],
["轉鈴","zhuan4ling2"],
["轉門","zhuan4men2"],
["轉體","zhuan3ti3"],
["轉鼓","zhuan4gu3"],
["轉一趟","zhuan4yi2tang4"],
["轉一轉","zhuan4yi5zhuan4"],
["轉不過","zhuan3bu5guo4"],
["轉字鎖","zhuan4zi4suo3"],
["轉學生","zhuan3xue2sheng1"],
["轉車臺","zhuan4che1tai2"],
["轉輪王","zhuan3lun2wang2"],
["轉危為安","zhuan3wei1wei2an1"],
["轉彎抹角","zhuan3wan1mo4jiao3"],
["轉悲為喜","zhuan3bei1wei2xi3"],
["轉敗為勝","zhuan3bai4wei2sheng4"],
["轉渾天儀","zhuan4hun2tian1yi2"],
["轉磨不開","zhuan4mo5bu5kai1"],
["轉而一想","zhuan3er2yi4xiang3"],
["轉變抹角","zhuan3bian4mo4jiao3"]
],
"轎":[
["轎夫","jiao4fu1"]
],
"轟":[
["轟隆","hong1long1"]
],
"车":[
["车夫","che1fu1"],
["车展","che1zhan3"],
["车把","che1ba3"],
["车长","che1zhang3"],
["车顶","che1ding3"],
["车马","che1ma3"],
["车把式","che1ba3shi5"],
["车行通道","che1hang2tong1dao4"],
["车尔尼雪夫斯基","che1er3ni2xue3fu1si1ji1"]
],
"轧":[
["轧制","zha2zhi4"],
["轧场","ya4chang2"],
["轧机","zha2ji1"],
["轧染","ya4ran3"],
["轧钢","zha2gang1"]
],
"轨":[
["轨枕","gui3zhen3"],
["轨迹","gui3ji4"]
],
"轩":[
["轩槛","xuan1jian4"]
],
"转":[
["转为","zhuan3wei2"],
["转产","zhuan3chan3"],
["转体","zhuan3ti3"],
["转写","zhuan3xie3"],
["转口","zhuan3kou3"],
["转台","zhuan4tai2"],
["转圈","zhuan4quan1"],
["转塔","zhuan4ta3"],
["转子","zhuan4zi3"],
["转导","zhuan3dao3"],
["转干","zhuan3gan4"],
["转引","zhuan3yin3"],
["转往","zhuan3wang3"],
["转徙","zhuan3xi3"],
["转悠","zhuan4you5"],
["转手","zhuan3shou3"],
["转抵","zhuan3di3"],
["转椅","zhuan4yi3"],
["转炉","zhuan4lu2"],
["转盘","zhuan4pan2"],
["转眼","zhuan3yan3"],
["转矩","zhuan4ju3"],
["转磨","zhuan4mo4"],
["转筋","zhuan4jin1"],
["转纽","zhuan4niu3"],
["转给","zhuan3gei3"],
["转脸","zhuan3lian3"],
["转行","zhuan3hang2"],
["转角","zhuan3jiao3"],
["转距","zhuan4ju4"],
["转轮","zhuan4lun2"],
["转轴","zhuan4zhou2"],
["转载","zhuan3zai3"],
["转速","zhuan4su4"],
["转铃","zhuan4ling2"],
["转门","zhuan4men2"],
["转鼓","zhuan4gu3"],
["转一趟","zhuan4yi2tang4"],
["转一转","zhuan4yi5zhuan4"],
["转不过","zhuan3bu5guo4"],
["转字锁","zhuan4zi4suo3"],
["转学生","zhuan3xue2sheng1"],
["转车台","zhuan4che1tai2"],
["转轮王","zhuan3lun2wang2"],
["转轴儿","zhuan4zhou2r5"],
["转铃儿","zhuan4ling2r5"],
["转危为安","zhuan3wei1wei2an1"],
["转变抹角","zhuan3bian4mo4jiao3"],
["转弯抹角","zhuan3wan1mo4jiao3"],
["转悲为喜","zhuan3bei1wei2xi3"],
["转浑天仪","zhuan4hun2tian1yi2"],
["转磨不开","zhuan4mo5bu5kai1"],
["转而一想","zhuan3er2yi4xiang3"],
["转败为胜","zhuan3bai4wei2sheng4"]
],
"轮":[
["轮椅","lun2yi3"],
["轮毂","lun2gu3"],
["轮脚","lun2jiao3"],
["轮辋","lun2wang3"],
["轮齿","lun2chi3"]
],
"软":[
["软体","ruan3ti3"],
["软饮","ruan3yin3"],
["软骨","ruan3gu3"],
["软泥儿","ruan3ni2r5"]
],
"轰":[
["轰隆","hong1long1"]
],
"轴":[
["轴索","zhou2suo3"],
["轴突运输","zhou2tu2yun4shu1"]
],
"轻":[
["轻咬","qing1yao3"],
["轻巧","qing1qiao3"],
["轻打","qing1da3"],
["轻染","qing1ran3"],
["轻水","qing1shui3"],
["轻率","qing1shuai4"],
["轻省","qing1sheng5"],
["轻薄","qing1bo2"],
["轻轨","qing1gui3"],
["轻不了","qing1bu5liao3"]
],
"载":[
["载体","zai4ti3"],
["载入","zai3ru4"],
["载湉","zai3tian2"],
["载满","zai4man3"],
["载籍","zai3ji2"],
["载荷","zai4he4"],
["载伯德","zai3bo2de2"]
],
"轿":[
["轿夫","jiao4fu1"]
],
"较":[
["较好","jiao4hao3"],
["较少","jiao4shao3"]
],
"辅":[
["辅以","fu3yi3"],
["辅导","fu3dao3"]
],
"辈":[
["辈分","bei4fen5"]
],
"辍":[
["辍止","chuo4zhi3"],
["辍演","chuo4yan3"],
["辍笔","chuo4bi3"]
],
"辖":[
["辖地","xia2di4"]
],
"辗":[
["辗转","zhan3zhuan3"]
],
"辛":[
["辛丑","xin1chou3"],
["辛卯","xin1mao3"],
["辛玛","xin1ma3"],
["辛瑪","xin1ma3"],
["辛苦","xin1ku3"],
["辛酉","xin1you3"]
],
"辞":[
["辞典","ci2dian3"],
["辞海","ci2hai3"],
["辞藻","ci2zao3"]
],
"辟":[
["辟拉","bi4la1"],
["辟邪","bi4xie2"]
],
"辣":[
["辣彼","la4bi3"],
["辣哈布","la1ha1bu4"],
["辣不唧儿","la4bu5ji1r5"],
["辣不唧兒","la4bu5ji1r5"]
],
"辦":[
["辦妥","ban4tuo3"],
["辦法","ban4fa3"],
["辦理","ban4li3"],
["辦不下","ban4bu5xia4"],
["辦不了","ban4bu5liao3"],
["辦不來","ban4bu5lai2"],
["辦不出","ban4bu5chu1"],
["辦不到","ban4bu5dao4"],
["辦不動","ban4bu5dong4"],
["辦不完","ban4bu5wan2"],
["辦不成","ban4bu5cheng2"],
["辦不清","ban4bu5qing1"],
["辦得了","ban4de5liao3"],
["辦得到","ban4de5dao4"]
],
"辨":[
["辨識","bian4shi2"],
["辨识","bian4shi2"]
],
"辩":[
["辩解","bian4jie3"],
["辩难","bian4nan4"],
["辩护士","bian4hu4shi4"]
],
"辭":[
["辭典","ci2dian3"],
["辭海","ci2hai3"],
["辭藻","ci2zao3"]
],
"辯":[
["辯解","bian4jie3"],
["辯難","bian4nan4"],
["辯護士","bian4hu4shi4"]
],
"辱":[
["辱沒","ru3mo4"],
["辱没","ru3mo4"]
],
"農":[
["農地","nong2di4"],
["農場","nong2chang3"],
["農夫","nong2fu1"],
["農產","nong2chan3"],
["農舍","nong2she4"]
],
"边":[
["边卡","bian1qia3"],
["边地","bian1di4"],
["边塞","bian1sai4"],
["边框","bian1kuang4"],
["边远","bian1yuan3"],
["边鄙","bian1bi3"]
],
"辽":[
["辽史","liao2shi3"],
["辽海","liao2hai3"],
["辽远","liao2yuan3"]
],
"达":[
["达卡","da2ka3"],
["达喀尔","da2ka4er3"]
],
"迁":[
["迁往","qian1wang3"],
["迁徙","qian1xi3"],
["迁都","qian1du1"]
],
"迂":[
["迂緩","yu1huan3"],
["迂缓","yu1huan3"],
["迂腐","yu1fu3"],
["迂远","yu1yuan3"],
["迂遠","yu1yuan3"]
],
"迅":[
["迅猛","xun4meng3"]
],
"过":[
["过儿","guo4r5"],
["过分","guo4fen4"],
["过去","guo4qu5"],
["过奖","guo4jiang3"],
["过少","guo4shao3"],
["过当","guo4dang4"],
["过往","guo4wang3"],
["过得","guo4de2"],
["过敏","guo4min3"],
["过早","guo4zao3"],
["过来","guo4lai5"],
["过氧","guo4yang3"],
["过满","guo4man3"],
["过瘾","guo4yin3"],
["过逾","guo4yu5"],
["过不下","guo4bu5xia4"],
["过不了","guo4bu5liao3"],
["过不去","guo4bu5qu4"],
["过不得","guo4bu5de5"],
["过不来","guo4bu5lai2"],
["过不着","guo4bu5zhao2"],
["过得去","guo4de5qu4"],
["过得来","guo4de5lai2"],
["过得着","guo4de5zhao2"],
["过得硬","guo4de5ying4"],
["过一会儿","guo4yi4hui3r5"],
["过去分词","guo4qu4fen1ci2"]
],
"迎":[
["迎娶","ying2qu3"],
["迎火","ying2huo3"]
],
"运":[
["运往","yun4wang3"],
["运气","yun4qi5"],
["运笔","yun4bi3"],
["运脚","yun4jiao3"],
["运转","yun4zhuan4"]
],
"近":[
["近古","jin4gu3"],
["近視","jin4shi5"],
["近视","jin4shi5"],
["近乎同步","jin1hu5tong2bu4"],
["近水楼台先得月","jin4shui3lou2tai2xian1de2yue4"],
["近水樓臺先得月","jin4shui3lou2tai2xian1de2yue4"]
],
"还":[
["还乡","huan2xiang1"],
["还书","huan2shu1"],
["还价","huan2jia4"],
["还俗","huan2su2"],
["还债","huan2zhai4"],
["还击","huan2ji1"],
["还原","huan2yuan2"],
["还口","huan2kou3"],
["还嘴","huan2zui3"],
["还好","hai2hao3"],
["还席","huan2xi2"],
["还手","huan2shou3"],
["还报","huan2bao4"],
["还早","hai2zao3"],
["还是","hai2shi5"],
["还有","hai2you3"],
["还本","huan2ben3"],
["还清","huan2qing1"],
["还礼","huan2li3"],
["还给","huan2gei3"],
["还账","huan2zhang4"],
["还魂","huan2hun2"],
["还得起","huan2de5qi3"],
["还以颜色","huan2yi3yan2se4"]
],
"这":[
["这儿","zhe4r5"],
["这咱","zhe4zan5"],
["这晚","zhe4wan3"],
["这末","zhe4me5"],
["这点","zhe4dian3"],
["这种","zhe4zhong3"],
["这等","zhe4deng3"],
["这裏","zhe4li3"],
["这里","zhe4li3"],
["这麽","zhe4me5"],
["这个月","zhei4ge4yue4"],
["这会儿","zhe4hui4r5"],
["这年头","zhe4nian2tou5"],
["这边儿","zhe4bian1r5"],
["这阵儿","zhe4zhen4r5"],
["这早晚儿","zhe4zao3wan3r5"]
],
"进":[
["进去","jin4qu5"],
["进取","jin4qu3"],
["进口","jin4kou3"],
["进场","jin4chang3"],
["进展","jin4zhan3"],
["进来","jin4lai5"],
["进水","jin4shui3"],
["进深","jin4shen5"],
["进酒","jin4jiu3"],
["进不去","jin4bu5qu4"],
["进不来","jin4bu5lai2"],
["进行曲","jin4xing2qu3"]
],
"远":[
["远古","yuan3gu3"],
["远地","yuan3di4"],
["远景","yuan3jing3"],
["远祖","yuan3zu3"],
["远识","yuan3shi2"],
["远远","yuan3yuan3"],
["远水解不了近渴","yuan3shui3jie3bu5liao3jin4ke3"]
],
"违":[
["违反","wei2fan3"],
["违忤","wei2wu3"],
["违拗","wei2ao4"],
["违法","wei2fa3"]
],
"连":[
["连写","lian2xie3"],
["连巹","lian2jin3"],
["连手","lian2shou3"],
["连理","lian2li3"],
["连累","lian2lei3"],
["连缀","lian2zhui4"],
["连翘","lian2qiao2"],
["连载","lian2zai3"],
["连锁","lian2suo3"],
["连不上","lian2bu5shang4"]
],
"迟":[
["迟早","chi2zao3"],
["迟缓","chi2huan3"]
],
"迤":[
["迤逦","yi3li3"],
["迤邐","yi3li3"]
],
"迦":[
["迦坦","jia1tan3"],
["迦巴","jia1ba1"],
["迦底","jia1di3"],
["迦得","jia1de2"],
["迦本","jia1ben3"],
["迦米","jia1mi3"],
["迦勒得","jia1le4de2"]
],
"迫":[
["迫使","po4shi3"],
["迫於","po4yu2"],
["迫击炮","pai3ji1pao4"],
["迫擊炮","pai3ji1pao4"]
],
"述":[
["述語","shu4yu3"],
["述语","shu4yu3"]
],
"迳":[
["迳迹","jing4ji4"]
],
"迴":[
["迴轉","hui2zhuan3"],
["迴转","hui2zhuan3"]
],
"迷":[
["迷住","mi2zhu5"],
["迷你","mi2ni3"],
["迷惑","mi2huo5"],
["迷惘","mi2wang3"],
["迷瞪","mi2deng5"],
["迷迷糊糊","mi2mi2hu1hu1"]
],
"迹":[
["迹象","ji4xiang4"]
],
"追":[
["追剿","zhui1jiao3"],
["追悔","zhui1hui3"],
["追想","zhui1xiang3"],
["追打","zhui1da3"],
["追捕","zhui1bu3"],
["追捧","zhui1peng3"],
["追比","zhui1bi3"],
["追索","zhui1suo3"],
["追緝","zhui1ji1"],
["追繳","zhui1jiao3"],
["追缉","zhui1ji1"],
["追缴","zhui1jiao3"],
["追补","zhui1bu3"],
["追補","zhui1bu3"],
["追討","zhui1tao3"],
["追訴","zhui1su4"],
["追讨","zhui1tao3"],
["追诉","zhui1su4"],
["追赶","zhui1gan3"],
["追趕","zhui1gan3"],
["追还","zhui1huan2"],
["追還","zhui1huan2"],
["追不上","zhui1bu5shang4"],
["追不到","zhui1bu5dao4"],
["追根究底儿","zhui1gen1jiu1di3r5"]
],
"退":[
["退伍","tui4wu3"],
["退守","tui4shou3"],
["退走","tui4zou3"],
["退还","tui4huan2"],
["退還","tui4huan2"],
["退耕还林","tui4geng1huan2lin2"],
["退耕還林","tui4geng1huan2lin2"],
["退避三舍","tui4bi4san1she4"]
],
"送":[
["送礼","song4li3"],
["送禮","song4li3"],
["送給","song4gei3"],
["送给","song4gei3"],
["送股","song4gu3"],
["送走","song4zou3"],
["送返","song4fan3"],
["送不起","song4bu5qi3"]
],
"适":[
["适宜","shi4yi2"],
["适应","shi4ying4"],
["适当","shi4dang4"],
["适度微调","shi4du4wei1tiao2"],
["适得其反","shi4de2qi2fan3"]
],
"逃":[
["逃往","tao2wang3"],
["逃走","tao2zou3"],
["逃跑","tao2pao3"],
["逃难","tao2nan4"],
["逃難","tao2nan4"],
["逃不了","tao2bu5liao3"],
["逃不出","tao2bu5chu1"]
],
"逆":[
["逆产","ni4chan3"],
["逆反","ni4fan3"],
["逆子","ni4zi3"],
["逆差","ni4cha1"],
["逆旅","ni4lv3"],
["逆水","ni4shui3"],
["逆產","ni4chan3"],
["逆耳","ni4er3"],
["逆轉","ni4zhuan3"],
["逆转","ni4zhuan3"],
["逆反应","ni4fan3ying4"],
["逆反應","ni4fan3ying4"],
["逆行倒施","ni4xing2dao3shi1"]
],
"选":[
["选中","xuan3zhong4"],
["选举","xuan3ju3"],
["选取","xuan3qu3"],
["选手","xuan3shou3"],
["选不出","xuan3bu5chu1"]
],
"透":[
["透水","tou4shui3"],
["透頂","tou4ding3"],
["透顶","tou4ding3"],
["透露出","tou4lou4chu1"],
["透不过气","tou4bu5guo4qi4"],
["透不過氣","tou4bu5guo4qi4"]
],
"逐":[
["逐个","zhu2ge4"],
["逐個","zhu2ge4"],
["逐行","zhu2hang2"],
["逐一解决","zhu2yi4jie3jue2"],
["逐一解決","zhu2yi4jie3jue2"],
["逐兔先得","zhu2tu4xian1de2"]
],
"递":[
["递给","di4gei3"],
["递解","di4jie4"],
["递不到","di4bu5dao4"]
],
"逕":[
["逕跡","jing4ji4"]
],
"逗":[
["逗嘴","dou4zui3"],
["逗弄","dou4nong5"],
["逗引","dou4yin3"],
["逗点","dou4dian3"],
["逗點","dou4dian3"],
["逗笑儿","dou4xiao4r5"],
["逗趣儿","dou4qu4r5"]
],
"這":[
["這咱","zhe4zan5"],
["這晚","zhe4wan3"],
["這末","zhe4me5"],
["這種","zhe4zhong3"],
["這等","zhe4deng3"],
["這裏","zhe4li3"],
["這裡","zhe4li3"],
["這點","zhe4dian3"],
["這個月","zhei4ge4yue4"],
["這年頭","zhe4nian2tou5"]
],
"通":[
["通什","tong1shi2"],
["通假","tong1jia3"],
["通史","tong1shi3"],
["通往","tong1wang3"],
["通晓","tong1xiao3"],
["通曉","tong1xiao3"],
["通海","tong1hai3"],
["通緝","tong1ji1"],
["通缉","tong1ji1"],
["通許","tong1xu3"],
["通識","tong1shi2"],
["通许","tong1xu3"],
["通识","tong1shi2"],
["通不过","tong1bu5guo4"],
["通不過","tong1bu5guo4"],
["通用串行总线","tong1yong4chuan4xing2zong3xian4"],
["通用串行總線","tong1yong4chuan4xing2zong3xian4"]
],
"速":[
["速写","su4xie3"],
["速寫","su4xie3"],
["速調管","su4tiao2guan3"],
["速调管","su4tiao2guan3"]
],
"造":[
["造假","zao4jia3"],
["造反","zao4fan3"],
["造紙","zao4zhi3"],
["造纸","zao4zhi3"],
["造血","zao4xie3"]
],
"連":[
["連寫","lian2xie3"],
["連巹","lian2jin3"],
["連手","lian2shou3"],
["連理","lian2li3"],
["連累","lian2lei3"],
["連綴","lian2zhui4"],
["連翹","lian2qiao2"],
["連載","lian2zai3"],
["連鎖","lian2suo3"],
["連不上","lian2bu5shang4"]
],
"逮":[
["逮捕","dai4bu3"]
],
"週":[
["週五","zhou1wu3"],
["週轉","zhou1zhuan3"],
["週转","zhou1zhuan3"]
],
"進":[
["進來","jin4lai5"],
["進去","jin4qu5"],
["進取","jin4qu3"],
["進口","jin4kou3"],
["進場","jin4chang3"],
["進展","jin4zhan3"],
["進水","jin4shui3"],
["進深","jin4shen5"],
["進酒","jin4jiu3"],
["進不來","jin4bu5lai2"],
["進不去","jin4bu5qu4"],
["進行曲","jin4xing2qu3"]
],
"逼":[
["逼供","bi1gong4"],
["逼死","bi1si3"]
],
"遇":[
["遇火","yu4huo3"],
["遇险","yu4xian3"],
["遇險","yu4xian3"],
["遇难","yu4nan4"],
["遇難","yu4nan4"],
["遇不上","yu4bu5shang4"]
],
"遊":[
["遊手","you2shou3"],
["遊艇","you2ting3"],
["遊覽","you2lan3"],
["遊览","you2lan3"],
["遊說","you2shui4"],
["遊说","you2shui4"],
["遊走","you2zou3"],
["遊隼","you2sun3"],
["遊手好閑","you2shou3hao4xian2"],
["遊手好闲","you2shou3hao4xian2"]
],
"運":[
["運往","yun4wang3"],
["運氣","yun4qi5"],
["運筆","yun4bi3"],
["運腳","yun4jiao3"],
["運轉","yun4zhuan4"]
],
"遍":[
["遍体","bian4ti3"],
["遍地","bian4di4"],
["遍體","bian4ti3"]
],
"過":[
["過來","guo4lai5"],
["過分","guo4fen4"],
["過去","guo4qu5"],
["過少","guo4shao3"],
["過往","guo4wang3"],
["過得","guo4de2"],
["過敏","guo4min3"],
["過於","guo4yu2"],
["過早","guo4zao3"],
["過氧","guo4yang3"],
["過滿","guo4man3"],
["過獎","guo4jiang3"],
["過當","guo4dang4"],
["過癮","guo4yin3"],
["過逾","guo4yu5"],
["過不下","guo4bu5xia4"],
["過不了","guo4bu5liao3"],
["過不來","guo4bu5lai2"],
["過不去","guo4bu5qu4"],
["過不得","guo4bu5de5"],
["過不著","guo4bu5zhao2"],
["過得來","guo4de5lai2"],
["過得去","guo4de5qu4"],
["過得硬","guo4de5ying4"],
["過得著","guo4de5zhao2"],
["過一會兒","guo4yi4hui3r5"],
["過去分詞","guo4qu4fen1ci2"]
],
"遏":[
["遏止","e4zhi3"]
],
"遐":[
["遐迩","xia2er3"],
["遐邇","xia2er3"]
],
"道":[
["道人","dao4ren5"],
["道地","dao4di4"],
["道场","dao4chang3"],
["道場","dao4chang3"],
["道士","dao4shi5"],
["道指","dao4zhi3"],
["道理","dao4li5"],
["道藏","dao4zang4"],
["道觀","dao4guan4"],
["道观","dao4guan4"],
["道長","dao4zhang3"],
["道长","dao4zhang3"]
],
"達":[
["達卡","da2ka3"],
["達喀爾","da2ka4er3"]
],
"違":[
["違反","wei2fan3"],
["違忤","wei2wu3"],
["違拗","wei2ao4"],
["違法","wei2fa3"]
],
"遗":[
["遗产","yi2chan3"],
["遗体","yi2ti3"],
["遗嘱","yi2zhu3"],
["遗址","yi2zhi3"],
["遗稿","yi2gao3"],
["遗迹","yi2ji4"],
["遗骨","yi2gu3"],
["遗腹子","yi2fu4zi3"],
["遗妻弃子","yi2qi1qi4zi3"]
],
"遙":[
["遙感","yao2gan3"],
["遙遠","yao2yuan3"]
],
"遞":[
["遞給","di4gei3"],
["遞解","di4jie4"],
["遞不到","di4bu5dao4"]
],
"遠":[
["遠古","yuan3gu3"],
["遠地","yuan3di4"],
["遠景","yuan3jing3"],
["遠祖","yuan3zu3"],
["遠識","yuan3shi2"],
["遠遠","yuan3yuan3"],
["遠水解不了近渴","yuan3shui3jie3bu5liao3jin4ke3"]
],
"遣":[
["遣返","qian3fan3"]
],
"遥":[
["遥感","yao2gan3"],
["遥远","yao2yuan3"]
],
"適":[
["適宜","shi4yi2"],
["適應","shi4ying4"],
["適當","shi4dang4"],
["適度微調","shi4du4wei1tiao2"],
["適得其反","shi4de2qi2fan3"]
],
"遭":[
["遭打","zao1da3"],
["遭难","zao1nan4"],
["遭難","zao1nan4"]
],
"遮":[
["遮挡","zhe1dang3"],
["遮掩","zhe1yan3"],
["遮擋","zhe1dang3"],
["遮脸","zhe1lian3"],
["遮臉","zhe1lian3"],
["遮不了","zhe1bu5liao3"],
["遮不住","zhe1bu5zhu4"]
],
"遲":[
["遲早","chi2zao3"],
["遲緩","chi2huan3"]
],
"遴":[
["遴选","lin2xuan3"],
["遴選","lin2xuan3"]
],
"遵":[
["遵守","zun1shou3"]
],
"遷":[
["遷往","qian1wang3"],
["遷徙","qian1xi3"],
["遷都","qian1du1"]
],
"選":[
["選中","xuan3zhong4"],
["選取","xuan3qu3"],
["選手","xuan3shou3"],
["選舉","xuan3ju3"],
["選不出","xuan3bu5chu1"]
],
"遺":[
["遺囑","yi2zhu3"],
["遺址","yi2zhi3"],
["遺產","yi2chan3"],
["遺稿","yi2gao3"],
["遺跡","yi2ji4"],
["遺骨","yi2gu3"],
["遺體","yi2ti3"],
["遺腹子","yi2fu4zi3"],
["遺妻棄子","yi2qi1qi4zi3"]
],
"遼":[
["遼史","liao2shi3"],
["遼海","liao2hai3"],
["遼遠","liao2yuan3"]
],
"避":[
["避免","bi4mian3"],
["避暑","bi4shu3"],
["避险","bi4xian3"],
["避險","bi4xian3"],
["避难","bi4nan4"],
["避難","bi4nan4"],
["避不作答","bi4bu5zuo4da2"],
["避不見面","bi4bu5jian4mian4"],
["避不见面","bi4bu5jian4mian4"],
["避不露面","bi4bu5lu4mian4"]
],
"邀":[
["邀請","yao1qing3"],
["邀请","yao1qing3"]
],
"還":[
["還俗","huan2su2"],
["還債","huan2zhai4"],
["還價","huan2jia4"],
["還原","huan2yuan2"],
["還口","huan2kou3"],
["還嘴","huan2zui3"],
["還報","huan2bao4"],
["還好","hai2hao3"],
["還席","huan2xi2"],
["還手","huan2shou3"],
["還擊","huan2ji1"],
["還早","hai2zao3"],
["還是","hai2shi5"],
["還書","huan2shu1"],
["還有","hai2you3"],
["還本","huan2ben3"],
["還清","huan2qing1"],
["還禮","huan2li3"],
["還給","huan2gei3"],
["還賬","huan2zhang4"],
["還鄉","huan2xiang1"],
["還魂","huan2hun2"],
["還得起","huan2de5qi3"],
["還以顏色","huan2yi3yan2se4"]
],
"邊":[
["邊卡","bian1qia3"],
["邊地","bian1di4"],
["邊塞","bian1sai4"],
["邊框","bian1kuang4"],
["邊遠","bian1yuan3"],
["邊鄙","bian1bi3"]
],
"邋":[
["邋遢","la1ta5"]
],
"邓":[
["邓拓","deng4tuo4"]
],
"那":[
["那儿","na4r5"],
["那只","na4zhi1"],
["那是","na4shi5"],
["那曲","na3qu1"],
["那有","na3you3"],
["那种","na4zhong3"],
["那種","na4zhong3"],
["那裏","na4li3"],
["那边","na4bian5"],
["那邊","na4bian5"],
["那里","na4li5"],
["那麽","na4me5"],
["那曲市","na4qu3shi4"],
["那維克","na3wei2ke4"],
["那维克","na3wei2ke4"],
["那曲地区","na4qu3di4qu1"],
["那曲地區","na4qu3di4qu1"],
["那拉提草原","na4la1di1cao3yuan2"]
],
"邮":[
["邮差","you2chai1"],
["邮筒","you2tong3"]
],
"邵":[
["邵武","shao4wu3"]
],
"邻":[
["邻水","lin2shui3"],
["邻舍","lin2she4"],
["邻里","lin2li3"]
],
"郊":[
["郊野","jiao1ye3"]
],
"郑":[
["郑码","zheng4ma3"]
],
"部":[
["部下","bu4xia5"],
["部分","bu4fen5"],
["部委","bu4wei3"],
["部属","bu4shu3"],
["部屬","bu4shu3"],
["部署","bu4shu3"],
["部長","bu4zhang3"],
["部长","bu4zhang3"],
["部首","bu4shou3"]
],
"郵":[
["郵差","you2chai1"],
["郵筒","you2tong3"]
],
"都":[
["都兰","du1lan2"],
["都勻","du1yun2"],
["都匀","du1yun2"],
["都城","du1cheng2"],
["都市","du1shi4"],
["都昌","du1chang1"],
["都灵","du1ling2"],
["都統","du1tong3"],
["都统","du1tong3"],
["都蘭","du1lan2"],
["都靈","du1ling2"],
["都伯林","du1bo2lin2"],
["都柏林","du1bo2lin2"],
["都江堰","du1jiang1yan4"],
["都会传奇","du1hui4chuan2qi2"],
["都會傳奇","du1hui4chuan2qi2"],
["都安瑤族自治縣","du1an1yao2zu2zi4zhi4xian4"],
["都安瑶族自治县","du1an1yao2zu2zi4zhi4xian4"]
],
"鄉":[
["鄉下","xiang1xia5"],
["鄉土","xiang1tu3"],
["鄉戚","xiang1qi1"],
["鄉曲","xiang1qu3"],
["鄉里","xiang1li3"]
],
"鄙":[
["鄙俚","bi3li3"],
["鄙薄","bi3bo2"]
],
"鄧":[
["鄧拓","deng4tuo4"]
],
"鄭":[
["鄭碼","zheng4ma3"]
],
"鄰":[
["鄰水","lin2shui3"],
["鄰舍","lin2she4"],
["鄰里","lin2li3"]
],
"酋":[
["酋長","qiu2zhang3"],
["酋长","qiu2zhang3"]
],
"配":[
["配乐","pei4yue4"],
["配体","pei4ti3"],
["配偶","pei4ou3"],
["配子","pei4zi3"],
["配属","pei4shu3"],
["配屬","pei4shu3"],
["配得","pei4de2"],
["配樂","pei4yue4"],
["配称","pei4chen4"],
["配稱","pei4chen4"],
["配給","pei4ji3"],
["配给","pei4ji3"],
["配角","pei4jue2"],
["配體","pei4ti3"],
["配不上","pei4bu5shang4"],
["配得上","pei4de5shang4"],
["配得來","pei4de5lai2"],
["配得来","pei4de5lai2"]
],
"酒":[
["酒厂","jiu3chang3"],
["酒吧","jiu3ba1"],
["酒巴","jiu3ba1"],
["酒廠","jiu3chang3"],
["酒醒","jiu3xing3"],
["酒館","jiu3guan3"],
["酒馆","jiu3guan3"],
["酒鬼","jiu3gui3"],
["酒馆儿","jiu3guan3r5"]
],
"酗":[
["酗酒","xu4jiu3"]
],
"酥":[
["酥軟","su1ruan3"],
["酥软","su1ruan3"]
],
"酬":[
["酬偿","chou2chang2"],
["酬償","chou2chang2"],
["酬劳","chou2lao2"],
["酬勞","chou2lao2"],
["酬和","chou2he4"],
["酬報","chou2bao4"],
["酬应","chou2ying4"],
["酬應","chou2ying4"],
["酬报","chou2bao4"],
["酬答","chou2da2"],
["酬謝","chou2xie4"],
["酬谢","chou2xie4"],
["酬賞","chou2shang3"],
["酬赏","chou2shang3"],
["酬載","chou2zai4"],
["酬载","chou2zai4"],
["酬酢","chou2zuo4"],
["酬金","chou2jin1"]
],
"酵":[
["酵母","jiao4mu3"]
],
"酸":[
["酸乳","suan1ru3"],
["酸奶","suan1nai3"],
["酸曲","suan1qu3"],
["酸枣","suan1zao3"],
["酸棗","suan1zao3"],
["酸苦","suan1ku3"],
["酸軟","suan1ruan3"],
["酸软","suan1ruan3"],
["酸雨","suan1yu3"],
["酸葡萄","suan1pu2tao2"],
["酸不唧儿","suan1bu5ji5r5"],
["酸不唧兒","suan1bu5ji5r5"],
["酸不溜丟","suan1bu5liu1diu1"],
["酸不溜丢","suan1bu5liu1diu1"],
["酸不唧溜儿","suan1bu5ji1liu1r5"],
["酸不唧溜兒","suan1bu5ji1liu1r5"]
],
"酿":[
["酿酒","niang4jiu3"]
],
"醇":[
["醇美","chun2mei3"]
],
"醉":[
["醉倒","zui4dao3"],
["醉酒","zui4jiu3"]
],
"醜":[
["醜相","chou3xiang4"],
["醜詆","chou3di3"]
],
"醫":[
["醫務","yi1wu4"],
["醫卜","yi1bu3"]
],
"釀":[
["釀酒","niang4jiu3"]
],
"采":[
["采买","cai3mai3"],
["采取","cai3qu3"],
["采场","cai3chang3"],
["采暖","cai3nuan3"],
["采果","cai3guo3"],
["采种","cai3zhong3"],
["采访","cai3fang3"],
["采邑","cai4yi4"]
],
"释":[
["释典","shi4dian3"],
["释卷","shi4juan4"],
["释手","shi4shou3"],
["释迦佛","shi4jia1fo2"],
["释放出来","shi4fang4chu1lai5"],
["释迦牟尼佛","shi4jia1mou2ni2fo2"]
],
"釋":[
["釋典","shi4dian3"],
["釋卷","shi4juan4"],
["釋手","shi4shou3"],
["釋迦佛","shi4jia1fo2"],
["釋放出來","shi4fang4chu1lai5"],
["釋迦牟尼佛","shi4jia1mou2ni2fo2"]
],
"里":[
["里头","li3tou5"],
["里尔","li3er3"],
["里海","li3hai3"],
["里爾","li3er3"],
["里边","li3bian5"],
["里長","li3zhang3"],
["里长","li3zhang3"],
["里賈納","li3jia3na4"],
["里贾纳","li3jia3na4"],
["里边儿","li3bian1r5"],
["里瓦几亚条约","li3wa3ji1ya4tiao2yue1"],
["里瓦幾亞條約","li3wa3ji1ya4tiao2yue1"]
],
"重":[
["重五","chong2wu3"],
["重估","chong2gu1"],
["重來","chong2lai2"],
["重修","chong2xiu1"],
["重典","zhong4dian3"],
["重创","zhong4chuang1"],
["重創","zhong4chuang1"],
["重午","chong2wu3"],
["重印","chong2yin4"],
["重又","chong2you4"],
["重叠","chong2die2"],
["重回","chong2hui2"],
["重围","chong2wei2"],
["重圍","chong2wei2"],
["重塑","chong2su4"],
["重复","chong2fu4"],
["重奏","chong2zou4"],
["重子","zhong4zi3"],
["重孙","chong2sun1"],
["重孫","chong2sun1"],
["重审","chong2shen3"],
["重審","chong2shen3"],
["重屋","chong2wu1"],
["重庆","chong2qing4"],
["重建","chong2jian4"],
["重开","chong2kai1"],
["重弹","chong2tan2"],
["重彈","chong2tan2"],
["重影","chong2ying3"],
["重慶","chong2qing4"],
["重打","zhong4da3"],
["重担","zhong4dan4"],
["重提","chong2ti2"],
["重擔","zhong4dan4"],
["重文","chong2wen2"],
["重新","chong2xin1"],
["重映","chong2ying4"],
["重来","chong2lai2"],
["重楼","chong2lou2"],
["重樓","chong2lou2"],
["重水","zhong4shui3"],
["重沓","chong2ta4"],
["重洋","chong2yang2"],
["重温","chong2wen1"],
["重溫","chong2wen1"],
["重演","chong2yan3"],
["重点","zhong4dian3"],
["重獲","chong2huo4"],
["重现","chong2xian4"],
["重現","chong2xian4"],
["重生","chong2sheng1"],
["重申","chong2shen1"],
["重疊","chong2die2"],
["重算","chong2suan4"],
["重組","chong2zu3"],
["重组","chong2zu3"],
["重聚","chong2ju4"],
["重荷","zhong4he4"],
["重获","chong2huo4"],
["重複","chong2fu4"],
["重覆","chong2fu4"],
["重評","chong2ping2"],
["重譯","chong2yi4"],
["重评","chong2ping2"],
["重译","chong2yi4"],
["重蹈","chong2dao4"],
["重返","chong2fan3"],
["重迭","chong2die2"],
["重述","chong2shu4"],
["重造","chong2zao4"],
["重逢","chong2feng2"],
["重重","chong2chong2"],
["重開","chong2kai1"],
["重阳","chong2yang2"],
["重陽","chong2yang2"],
["重霄","chong2xiao1"],
["重點","zhong4dian3"],
["重孙女","chong2sun1nv5"],
["重孫女","chong2sun1nv5"],
["重定向","chong2ding4xiang4"],
["重正化","chong2zheng4hua4"],
["重眼皮","chong2yan3pi2"],
["重結晶","chong2jie2jing1"],
["重结晶","chong2jie2jing1"],
["重量計","zhong4liang4ji4"],
["重量计","zhong4liang4ji4"],
["重历旧遊","chong2li4jiu4you2"],
["重峦叠嶂","chong2luan2die2zhang4"],
["重巒疊嶂","chong2luan2die2zhang4"],
["重操旧业","chong2cao1jiu4ye4"],
["重操舊業","chong2cao1jiu4ye4"],
["重整旗鼓","chong2zheng3qi2gu3"],
["重文輕武","zhong4wen2qing1wu3"],
["重文轻武","zhong4wen2qing1wu3"],
["重於泰山","zhong4yu2tai4shan1"],
["重歷舊遊","chong2li4jiu4you2"],
["重眼皮儿","chong2yan3pi2r5"],
["重睹天日","chong2du3tian1ri4"],
["重碳酸鈣","chong2tan4suan1gai4"],
["重碳酸钙","chong2tan4suan1gai4"],
["重見天日","chong2jian4tian1ri4"],
["重见天日","chong2jian4tian1ri4"],
["重足而立","chong2zu2er2li4"],
["重蹈覆轍","chong2dao3fu4zhe2"],
["重蹈覆辙","chong2dao3fu4zhe2"]
],
"野":[
["野史","ye3shi3"],
["野地","ye3di4"],
["野火","ye3huo3"],
["野狗","ye3gou3"],
["野草","ye3cao3"],
["野馬","ye3ma3"],
["野马","ye3ma3"],
["野葡萄","ye3pu2tao2"]
],
"量":[
["量具","liang2ju4"],
["量出","liang2chu1"],
["量器","liang2qi4"],
["量子","liang4zi3"],
["量度","liang2du4"],
["量杯","liang2bei1"],
["量瓶","liang2ping2"],
["量程","liang2cheng2"],
["量筒","liang2tong3"],
["量規","liang2gui1"],
["量规","liang2gui1"],
["量計","liang2ji4"],
["量计","liang2ji4"],
["量一量","liang2yi5liang2"],
["量体温","liang2ti3wen1"],
["量体重","liang2ti3zhong4"],
["量尺寸","liang2chi3cun4"],
["量角器","liang2jiao3qi4"],
["量體溫","liang2ti3wen1"],
["量體重","liang2ti3zhong4"],
["量入为出","liang4ru4wei2chu1"],
["量入為出","liang4ru4wei2chu1"],
["量力而为","liang4li4er2wei2"],
["量力而為","liang4li4er2wei2"]
],
"釐":[
["釐米","li2mi3"]
],
"金":[
["金匠","jin1jiang4"],
["金发","jin1fa4"],
["金史","jin1shi3"],
["金塔","jin1ta3"],
["金属","jin1shu3"],
["金屬","jin1shu3"],
["金桔","jin1jie2"],
["金罕","jin1han3"],
["金菇","jin1gu1"],
["金酒","jin1jiu3"],
["金領","jin1ling3"],
["金领","jin1ling3"],
["金不换","jin1bu5huan4"],
["金不換","jin1bu5huan4"],
["金合欢","jin1he2huan1"],
["金合歡","jin1he2huan1"],
["金裡奇","jin1li3qi2"],
["金針菇","jin1zhen1gu1"],
["金针菇","jin1zhen1gu1"],
["金龜子","jin1gui1zi3"],
["金龟子","jin1gui1zi3"],
["金属薄片","jin1shu3bo2pian4"],
["金屬薄片","jin1shu3bo2pian4"],
["金蝉脱壳","jin1chan2tuo1qiao4"],
["金蟬脫殼","jin1chan2tuo1qiao4"]
],
"釘":[
["釘住","ding4zhu4"],
["釘入","ding4ru4"],
["釘死","ding4si3"],
["釘書針","ding4shu1zhen1"]
],
"針":[
["針法","zhen1fa3"],
["針灸","zhen1jiu3"],
["針鼴","zhen1yan3"]
],
"鈍":[
["鈍角","dun4jiao3"]
],
"鈴":[
["鈴鼓","ling2gu3"]
],
"鉛":[
["鉛筆","qian1bi3"],
["鉛刀一割","qian1dao1yi4ge1"]
],
"鉴":[
["鉴赏","jian4shang3"]
],
"銀":[
["銀兩","yin2liang3"],
["銀匠","yin2jiang4"],
["銀海","yin2hai3"],
["銀獎","yin2jiang3"],
["銀耳","yin2er3"],
["銀苔","yin2tai2"],
["銀行","yin2hang2"],
["銀點","yin2dian3"],
["銀晃晃","yin2huang4huang5"]
],
"銅":[
["銅板","tong2ban3"],
["銅鼓","tong2gu3"]
],
"銳":[
["銳敏","rui4min3"],
["銳減","rui4jian3"],
["銳角","rui4jiao3"]
],
"銷":[
["銷毀","xiao1hui3"]
],
"鋁":[
["鋁土","lv3tu3"]
],
"鋤":[
["鋤地","chu2di4"],
["鋤草","chu2cao3"],
["鋤頭","chu2tou5"]
],
"鋦":[
["鋦子","ju1zi5"]
],
"鋪":[
["鋪保","pu4bao3"],
["鋪墊","pu1dian4"],
["鋪家","pu4jia5"],
["鋪展","pu1zhan3"],
["鋪平","pu1ping2"],
["鋪床","pu1chuang2"],
["鋪底","pu4di3"],
["鋪張","pu1zhang1"],
["鋪成","pu1cheng2"],
["鋪排","pu1pai2"],
["鋪擺","pu1bai3"],
["鋪攤","pu1tan5"],
["鋪敘","pu1xu4"],
["鋪板","pu4ban3"],
["鋪炕","pu1kang4"],
["鋪砌","pu1qi4"],
["鋪蓋","pu1gai4"],
["鋪衍","pu4yan3"],
["鋪襯","pu1chen5"],
["鋪設","pu1she4"],
["鋪路","pu1lu4"],
["鋪軌","pu1gui3"],
["鋪開","pu1kai1"],
["鋪陳","pu1chen2"],
["鋪面","pu1mian4"],
["鋪首","pu1shou3"],
["鋪石地","pu1shi2di4"],
["鋪面房","pu4mian4fang2"],
["鋪天蓋地","pu1tian1gai4di4"],
["鋪蓋卷兒","pu1gai5juan3r5"]
],
"鋸":[
["鋸齒","ju4chi3"]
],
"鋼":[
["鋼廠","gang1chang3"],
["鋼板","gang1ban3"],
["鋼筆","gang1bi3"],
["鋼管","gang1guan3"],
["鋼纜","gang1lan3"],
["鋼軌","gang1gui3"],
["鋼鐵","gang1tie3"],
["鋼曲尺","gang3qu1chi3"]
],
"錄":[
["錄供","lu4gong4"],
["錄取","lu4qu3"]
],
"錘":[
["錘骨","chui2gu3"]
],
"錫":[
["錫鑞","xi1la5"],
["錫林郭勒盟","xi1ling2guo1le4meng2"]
],
"錯":[
["錯處","cuo4chu5"],
["錯不了","cuo4bu5liao3"]
],
"鍋":[
["鍋底","guo1di3"],
["鍋餅","guo1bing3"]
],
"鍛":[
["鍛鐵","duan4tie3"]
],
"鎖":[
["鎖孔","suo3kong3"],
["鎖骨","suo3gu3"],
["鎖不上","suo3bu5shang4"],
["鎖不住","suo3bu5zhu4"]
],
"鎦":[
["鎦子","liu4zi5"]
],
"鎧":[
["鎧甲","kai3jia3"]
],
"鎬":[
["鎬京","hao4jing1"],
["鎬頭","gao3tou5"]
],
"鎮":[
["鎮咳","zhen4ke2"],
["鎮守","zhen4shou3"],
["鎮巴","zhen4ba1"],
["鎮海","zhen4hai3"],
["鎮遠","zhen4yuan3"],
["鎮長","zhen4zhang3"]
],
"鏈":[
["鏈表","lian4biao3"]
],
"鏽":[
["鏽鐵","xiu4tie3"]
],
"鐐":[
["鐐鎖","liao4suo3"]
],
"鐘":[
["鐘擺","zhong1bai3"],
["鐘樂","zhong1yue4"],
["鐘表","zhong1biao3"],
["鐘點","zhong1dian3"],
["鐘鳴漏盡","zhong1ming2lou4jin4"]
],
"鐙":[
["鐙骨","deng4gu3"]
],
"鐵":[
["鐵匠","tie3jiang4"],
["鐵塔","tie3ta3"],
["鐵嶺","tie3ling3"],
["鐵板","tie3ban3"],
["鐵桿","tie3gan3"],
["鐵水","tie3shui3"],
["鐵法","tie3fa3"],
["鐵甲","tie3jia3"],
["鐵筆","tie3bi3"],
["鐵軌","tie3gui3"],
["鐵餅","tie3bing3"]
],
"鑄":[
["鑄鐵","zhu4tie3"]
],
"鑒":[
["鑒於","jian4yu2"],
["鑒賞","jian4shang3"]
],
"鑲":[
["鑲板","xiang1ban3"],
["鑲框","xiang1kuang4"],
["鑲滿","xiang1man3"]
],
"鑼":[
["鑼鼓","luo2gu3"]
],
"鑽":[
["鑽井","zuan4jing3"],
["鑽卡","zuan1qia3"],
["鑽孔","zuan1kong3"],
["鑽版","zuan1ban3"],
["鑽眼","zuan1yan3"],
["鑽石","zuan4shi2"],
["鑽粉","zuan1fen3"],
["鑽頭","zuan4tou2"],
["鑽火得冰","zuan1huo3de2bing1"],
["鑽頭卡盤","zuan4tou2qia3pan2"],
["鑽頭夾盤","zuan1tou2jia2pan2"]
],
"鑿":[
["鑿井","zao2jing3"]
],
"针":[
["针法","zhen1fa3"],
["针灸","zhen1jiu3"],
["针鼹","zhen1yan3"]
],
"钉":[
["钉住","ding4zhu4"],
["钉入","ding4ru4"],
["钉死","ding4si3"],
["钉书针","ding4shu1zhen1"]
],
"钝":[
["钝角","dun4jiao3"]
],
"钟":[
["钟乐","zhong1yue4"],
["钟摆","zhong1bai3"],
["钟点","zhong1dian3"],
["钟表","zhong1biao3"],
["钟子期","zhong1zi3qi1"]
],
"钢":[
["钢厂","gang1chang3"],
["钢板","gang1ban3"],
["钢笔","gang1bi3"],
["钢管","gang1guan3"],
["钢缆","gang1lan3"],
["钢轨","gang1gui3"],
["钢铁","gang1tie3"],
["钢曲尺","gang3qu1chi3"]
],
"钻":[
["钻井","zuan4jing3"],
["钻卡","zuan1qia3"],
["钻头","zuan4tou2"],
["钻孔","zuan1kong3"],
["钻版","zuan1ban3"],
["钻眼","zuan1yan3"],
["钻石","zuan4shi2"],
["钻粉","zuan1fen3"],
["钻劲儿","zuan1jin4r5"],
["钻头卡盘","zuan4tou2qia3pan2"],
["钻头夹盘","zuan1tou2jia2pan2"],
["钻火得冰","zuan1huo3de2bing1"]
],
"铁":[
["铁匠","tie3jiang4"],
["铁塔","tie3ta3"],
["铁岭","tie3ling3"],
["铁杆","tie3gan3"],
["铁板","tie3ban3"],
["铁水","tie3shui3"],
["铁法","tie3fa3"],
["铁甲","tie3jia3"],
["铁笔","tie3bi3"],
["铁轨","tie3gui3"],
["铁饼","tie3bing3"]
],
"铃":[
["铃鼓","ling2gu3"]
],
"铅":[
["铅笔","qian1bi3"],
["铅刀一割","qian1dao1yi4ge1"]
],
"铜":[
["铜板","tong2ban3"],
["铜鼓","tong2gu3"]
],
"铝":[
["铝土","lv3tu3"]
],
"铠":[
["铠甲","kai3jia3"]
],
"银":[
["银两","yin2liang3"],
["银匠","yin2jiang4"],
["银奖","yin2jiang3"],
["银海","yin2hai3"],
["银点","yin2dian3"],
["银耳","yin2er3"],
["银苔","yin2tai2"],
["银行","yin2hang2"],
["银晃晃","yin2huang4huang5"]
],
"铸":[
["铸铁","zhu4tie3"]
],
"铺":[
["铺保","pu4bao3"],
["铺叙","pu1xu4"],
["铺垫","pu1dian4"],
["铺家","pu4jia5"],
["铺展","pu1zhan3"],
["铺平","pu1ping2"],
["铺床","pu1chuang2"],
["铺底","pu4di3"],
["铺开","pu1kai1"],
["铺张","pu1zhang1"],
["铺成","pu1cheng2"],
["铺排","pu1pai2"],
["铺摆","pu1bai3"],
["铺摊","pu1tan5"],
["铺板","pu4ban3"],
["铺炕","pu1kang4"],
["铺盖","pu1gai4"],
["铺砌","pu1qi4"],
["铺衍","pu4yan3"],
["铺衬","pu1chen5"],
["铺设","pu1she4"],
["铺路","pu1lu4"],
["铺轨","pu1gui3"],
["铺陈","pu1chen2"],
["铺面","pu1mian4"],
["铺首","pu1shou3"],
["铺石地","pu1shi2di4"],
["铺面房","pu4mian4fang2"],
["铺天盖地","pu1tian1gai4di4"],
["铺盖卷儿","pu1gai5juan3r5"]
],
"链":[
["链表","lian4biao3"]
],
"销":[
["销毁","xiao1hui3"]
],
"锁":[
["锁孔","suo3kong3"],
["锁骨","suo3gu3"],
["锁不上","suo3bu5shang4"],
["锁不住","suo3bu5zhu4"]
],
"锄":[
["锄地","chu2di4"],
["锄头","chu2tou5"],
["锄草","chu2cao3"]
],
"锅":[
["锅底","guo1di3"],
["锅饼","guo1bing3"]
],
"锈":[
["锈铁","xiu4tie3"]
],
"锐":[
["锐减","rui4jian3"],
["锐敏","rui4min3"],
["锐角","rui4jiao3"]
],
"错":[
["错处","cuo4chu5"],
["错不了","cuo4bu5liao3"]
],
"锡":[
["锡镴","xi1la5"],
["锡林郭勒盟","xi1ling2guo1le4meng2"]
],
"锣":[
["锣鼓","luo2gu3"]
],
"锤":[
["锤骨","chui2gu3"]
],
"锯":[
["锯齿","ju4chi3"]
],
"锻":[
["锻铁","duan4tie3"]
],
"镇":[
["镇咳","zhen4ke2"],
["镇守","zhen4shou3"],
["镇巴","zhen4ba1"],
["镇海","zhen4hai3"],
["镇远","zhen4yuan3"],
["镇长","zhen4zhang3"]
],
"镏":[
["镏子","liu4zi5"]
],
"镐":[
["镐京","hao4jing1"],
["镐头","gao3tou5"]
],
"镣":[
["镣锁","liao4suo3"]
],
"镫":[
["镫骨","deng4gu3"]
],
"镶":[
["镶板","xiang1ban3"],
["镶框","xiang1kuang4"],
["镶满","xiang1man3"]
],
"長":[
["長上","zhang3shang4"],
["長久","chang2jiu3"],
["長假","chang2jia4"],
["長像","zhang3xiang4"],
["長兄","zhang3xiong1"],
["長出","zhang3chu1"],
["長大","zhang3da4"],
["長女","zhang3nv3"],
["長姊","zhang3zi3"],
["長子","zhang3zi3"],
["長孫","zhang3sun1"],
["長官","zhang3guan1"],
["長尾","chang2wei3"],
["長島","chang2dao3"],
["長嶺","chang2ling3"],
["長幼","zhang3you4"],
["長得","zhang3de5"],
["長成","zhang3cheng2"],
["長椅","chang2yi3"],
["長武","chang2wu3"],
["長海","chang2hai3"],
["長滿","zhang3man3"],
["長相","zhang3xiang4"],
["長短","chang2duan3"],
["長老","zhang3lao3"],
["長者","zhang3zhe3"],
["長肉","zhang3rou4"],
["長興","chang2xing1"],
["長葛","chang2ge3"],
["長處","chang2chu5"],
["長輩","zhang3bei4"],
["長進","zhang3jin4"],
["長遠","chang2yuan3"],
["長野","chang2ye3"],
["長釘","chang2ding4"],
["長長","zhang3chang2"],
["長不了","chang2bu5liao3"],
["長出來","zhang3chu1lai5"],
["長起來","zhang3qi3lai5"],
["長此下去","chang2ci3xia4qu